# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####


import bpy
from .. import Shared
from ..Shared import uiCore, ui_textures, modifiers, ui
from ..Shared import polls as P

from .. import preferences, Icons, QuickSetup

from ..Liquid import ui as ui_liquid
from .. Gas import ui as ui_gas

import os


DOMAIN_SETTINGS = "VIEW3D_PT_MantaPro"

"""
 █████  █████ █████       ████   ███           █████
░░███  ░░███ ░░███       ░░███  ░░░           ░░███
 ░███   ░███  ░███        ░███  ████   █████  ███████    █████
 ░███   ░███  ░███        ░███ ░░███  ███░░  ░░░███░    ███░░
 ░███   ░███  ░███        ░███  ░███ ░░█████   ░███    ░░█████
 ░███   ░███  ░███        ░███  ░███  ░░░░███  ░███ ███ ░░░░███
 ░░████████   █████       █████ █████ ██████   ░░█████  ██████
  ░░░░░░░░   ░░░░░       ░░░░░ ░░░░░ ░░░░░░     ░░░░░  ░░░░░░
"""


class OBJECT_UL_domains(bpy.types.UIList):
    MP_order_id = 0

    def draw_item(self, context, layout, data, item, icon, active_data, active_propname):
        if not item.obj:
            return
        ob = data
        if not item.obj.users_scene:
            layout.alert = True

        if self.layout_type in {'DEFAULT'}:
            if Shared.modifiers.check_type_gas(item.obj, "DOMAIN"):
                Icon = Icons.get_icon_id("domain_gas")  # "MOD_FLUID"
            else:
                Icon = Icons.get_icon_id("domain_liquid")  # "MATFLUID"

            layout.scale_x = 1
            layout.prop(item.obj, "name", text="",
                        emboss=False, icon_value=Icon)


"""
  █████████             █████        █████               ████
 ███░░░░░███           ░░███        ░░███               ░░███
░███    ░░░  █████ ████ ░███████     ░███████    ██████  ░███  ████████   ██████  ████████   █████
░░█████████ ░░███ ░███  ░███░░███    ░███░░███  ███░░███ ░███ ░░███░░███ ███░░███░░███░░███ ███░░
 ░░░░░░░░███ ░███ ░███  ░███ ░███    ░███ ░███ ░███████  ░███  ░███ ░███░███████  ░███ ░░░ ░░█████
 ███    ░███ ░███ ░███  ░███ ░███    ░███ ░███ ░███░░░   ░███  ░███ ░███░███░░░   ░███      ░░░░███
░░█████████  ░░████████ ████████     ████ █████░░██████  █████ ░███████ ░░██████  █████     ██████
 ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░     ░░░░ ░░░░░  ░░░░░░  ░░░░░  ░███░░░   ░░░░░░  ░░░░░     ░░░░░░
                                                               ░███
                                                               █████
                                                              ░░░░░
"""


class DomainSub:
    bl_parent_id = "VIEW3D_PT_MantaProDomain"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"


"""
 ███████████                        ███████
░░███░░░░░███                     ███░░░░░███
 ░███    ░███  ██████  ████████  ███     ░░███ █████ █████  ██████  ████████
 ░██████████  ███░░███░░███░░███░███      ░███░░███ ░░███  ███░░███░░███░░███
 ░███░░░░░░  ░███ ░███ ░███ ░███░███      ░███ ░███  ░███ ░███████  ░███ ░░░
 ░███        ░███ ░███ ░███ ░███░░███     ███  ░░███ ███  ░███░░░   ░███
 █████       ░░██████  ░███████  ░░░███████░    ░░█████   ░░██████  █████
░░░░░         ░░░░░░   ░███░░░     ░░░░░░░       ░░░░░     ░░░░░░  ░░░░░
                       ░███
                       █████
                      ░░░░░
"""


class VIEW3D_PT_AutoOpsSettings(uiCore.Core, bpy.types.Panel):
    bl_label = "Settings"  # MantaPro Domain
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 4

    bl_options = {"INSTANCED"}

    def draw(self, context):
        settings = context.scene.MantaPro.auto_ops_settings
        self.set_layout("col", align=True)
        self.icon_prop(settings, "auto_find")
        self.icon_prop(settings, "auto_remove")
        self.icon_prop(settings, "auto_v_selection")


"""
 ██████████                                       ███                                                        ████
░░███░░░░███                                     ░░░                                                        ░░███
 ░███   ░░███  ██████  █████████████    ██████   ████  ████████      ████████   ██████   ████████    ██████  ░███
 ░███    ░███ ███░░███░░███░░███░░███  ░░░░░███ ░░███ ░░███░░███    ░░███░░███ ░░░░░███ ░░███░░███  ███░░███ ░███
 ░███    ░███░███ ░███ ░███ ░███ ░███   ███████  ░███  ░███ ░███     ░███ ░███  ███████  ░███ ░███ ░███████  ░███
 ░███    ███ ░███ ░███ ░███ ░███ ░███  ███░░███  ░███  ░███ ░███     ░███ ░███ ███░░███  ░███ ░███ ░███░░░   ░███
 ██████████  ░░██████  █████░███ █████░░████████ █████ ████ █████    ░███████ ░░████████ ████ █████░░██████  █████
░░░░░░░░░░    ░░░░░░  ░░░░░ ░░░ ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░     ░███░░░   ░░░░░░░░ ░░░░ ░░░░░  ░░░░░░  ░░░░░
                                                                     ░███
                                                                     █████
                                                                    ░░░░░
"""


class VIEW3D_PT_MantaPro(uiCore.Core, bpy.types.Panel):
    bl_label = ""  # MantaPro Domain
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 5

    def draw_header(self, context):
        self.layout.label(text="MantaPro Domain",
                          icon_value=Icons.get_icon_id("domain_mixed"))

    def draw(self, context):
        settings = context.scene.MantaPro
        layout = self.layout

        self.set_layout("col", align=True)
        self.operator("mantapro.find_all", icon="ZOOM_ALL")
        if settings.auto_ops:
            if not Shared.ops.auto_ops_running:
                self.ui_layout.alert = True
        self.separator()
        self.icon_prop(settings, "auto_ops")
        self.ui_layout.popover("VIEW3D_PT_AutoOpsSettings")

        self.ui_layout.alert = False
        self.separator(2)

        # self.operator("mantapro.setup", text="Quick setup OLD", icon="PLUS")
        # self.separator(2)

        self.operator("mantapro.quick_setup_menu",
                      text="Quick setup", icon="PLUS")

        self.operator("mantapro.add_domain", icon="ADD")

        self.separator()

        self.set_layout("row", align=True)

        col = layout.column()
        col.template_list("OBJECT_UL_domains", "", settings,
                          "domains", settings, "domains_index")

        self.set_layout("row", align=True)

        icon = "BLENDER"

        if settings.active_domain:
            if Shared.modifiers.check_category(settings.active_domain) == "GAS":
                icon = "MOD_FLUID"
            else:
                icon = "MATFLUID"
        try:
            self.label(
                text=settings.domains[settings.domains_index].obj.name, icon=icon)
        except:
            self.label(text="")

        self.operator("mantapro.make_domain", icon="ADD", text="")
        self.operator("mantapro.remove", text="", icon="REMOVE", settings=[
            ["kind", "DOMAIN"]])
        self.operator("mantapro.find_domain", icon="ZOOM_ALL", text="",)


class VIEW3D_PT_MantaProDomain(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_MantaPro"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    bl_label = " "
    MP_order_id = 6

    @ classmethod
    def poll(cls, context):
        return context.scene.MantaPro.active_domain

    def draw_header(self, context):
        self.set_layout("row")
        self.label(text="Settings")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "domain")
        else:
            ui_liquid.draw(self, context, "domain")


"""
 ██████████                                       ███                                   █████
░░███░░░░███                                     ░░░                                   ░░███
 ░███   ░░███  ██████  █████████████    ██████   ████  ████████       █████  █████ ████ ░███████   █████
 ░███    ░███ ███░░███░░███░░███░░███  ░░░░░███ ░░███ ░░███░░███     ███░░  ░░███ ░███  ░███░░███ ███░░
 ░███    ░███░███ ░███ ░███ ░███ ░███   ███████  ░███  ░███ ░███    ░░█████  ░███ ░███  ░███ ░███░░█████
 ░███    ███ ░███ ░███ ░███ ░███ ░███  ███░░███  ░███  ░███ ░███     ░░░░███ ░███ ░███  ░███ ░███ ░░░░███
 ██████████  ░░██████  █████░███ █████░░████████ █████ ████ █████    ██████  ░░████████ ████████  ██████
░░░░░░░░░░    ░░░░░░  ░░░░░ ░░░ ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░    ░░░░░░    ░░░░░░░░ ░░░░░░░░  ░░░░░░
"""


class VIEW3D_PT_DomainMaterialSub(uiCore.Core, DomainSub, bpy.types.Panel):
    bl_label = "Material"
    MP_order_id = 36

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and not P.UI_BLENDER()

    def draw_header(self, context):
        self.set_layout("row")
        self.label(icon="SHADING_RENDERED")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "material")
        else:
            ui_liquid.draw(self, context, "material")


class VIEW3D_PT_DomainGuidesSub(uiCore.Core, DomainSub, bpy.types.Panel):
    bl_label = "Guides"
    MP_order_id = 37

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        pref = preferences.get_preferences()
        return P.DOMAIN(context) and not P.UI_BLENDER()

    def draw_header(self, context):
        Shared.modifiers_settings = Shared.modifiers.get_modifier_domain(
            context)
        self.set_layout("row")
        self.label(icon="CON_TRACKTO")
        self.prop(Shared.modifiers_settings, "use_guide", text="")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "guides")
        else:
            ui_liquid.draw(self, context, "guides")


class VIEW3D_PT_DomainCollectionsSub(uiCore.Core, DomainSub, bpy.types.Panel):
    bl_label = "Collections"
    MP_order_id = 38

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        pref = preferences.get_preferences()
        return P.DOMAIN(context) and not P.UI_BLENDER()

    def draw_header(self, context):
        self.set_layout("row")
        self.label(icon="OUTLINER_OB_GROUP_INSTANCE")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "collections")
        else:
            ui_liquid.draw(self, context, "collections")


class VIEW3D_PT_DomainBorderSub(uiCore.Core, DomainSub, bpy.types.Panel):
    bl_label = "Border Collisions"
    MP_order_id = 39

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        pref = preferences.get_preferences()
        return P.DOMAIN(context) and not P.UI_BLENDER()

    def draw_header(self, context):
        self.set_layout("row")
        self.label(icon="FACE_MAPS")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "border")
        else:
            ui_liquid.draw(self, context, "border")


class VIEW3D_PT_DomainFieldSub(uiCore.Core, DomainSub, bpy.types.Panel):
    bl_label = "Field Weights"
    MP_order_id = 40

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        pref = preferences.get_preferences()
        return P.DOMAIN(context) and not P.UI_BLENDER()

    def draw_header(self, context):
        self.set_layout("row")
        self.label(icon="OUTLINER_OB_FORCE_FIELD")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "field")
        else:
            ui_liquid.draw(self, context, "field")


class VIEW3D_PT_DomainAdvancedSub(uiCore.Core, DomainSub, bpy.types.Panel):
    bl_label = "Advanced"
    MP_order_id = 41

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and P.UI_DEFAULT()
        # return Shared.modifiers.get_modifier_domain(context)

    def draw_header(self, context):
        self.set_layout("row")
        self.label(icon="LONGDISPLAY")

    def draw(self, context):
        pass


class VIEW3D_PT_AdvancedGravitySub(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_DomainAdvancedSub"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "Gravity"
    bl_context = "objectmode"

    MP_order_id = 76

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and P.UI_DEFAULT()

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "advanced_gravity")
        else:
            ui_liquid.draw(self, context, "advanced_gravity")


class VIEW3D_PT_AdvancedCacheSub(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_DomainAdvancedSub"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "Cache"
    bl_context = "objectmode"
    MP_order_id = 77

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and P.UI_DEFAULT()

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "advanced_cache")
        else:
            ui_liquid.draw(self, context, "advanced_cache")


class VIEW3D_PT_Viewport(uiCore.Core, DomainSub, bpy.types.Panel):
    bl_label = "Viewport Display"
    MP_order_id = 55

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and P.UI_DEFAULT()

    def draw_header(self, context):
        self.set_layout("row")
        self.label(icon="RESTRICT_VIEW_OFF")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "view")
        else:
            ui_liquid.draw(self, context, "view")


class VIEW3D_PT_ViewportSlice(uiCore.Core, bpy.types.Panel):
    bl_label = "Slice"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 57

    bl_parent_id = "VIEW3D_PT_Viewport"

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and P.UI_DEFAULT()

    def draw_header(self, context):
        domain = context.scene.MantaPro.active_domain
        modifier_settings = modifiers.get_modifier_domain(domain=domain)
        self.set_layout("row", align=True)
        self.prop(modifier_settings, "use_slice", text="")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw_view_slice(self, context)
        else:
            ui_liquid.draw(self, context, "view_slice")


class VIEW3D_PT_ViewportGrid(uiCore.Core, bpy.types.Panel):
    bl_label = "Grid Display"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 59

    bl_parent_id = "VIEW3D_PT_Viewport"

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and P.UI_DEFAULT()

    def draw_header(self, context):
        domain = context.scene.MantaPro.active_domain
        modifier_settings = modifiers.get_modifier_domain(domain=domain)
        self.set_layout("row", align=True)
        self.prop(modifier_settings, "use_color_ramp", text="")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "view_grid")
        else:
            ui_liquid.draw(self, context, "view_grid")


class VIEW3D_PT_ViewportVector(uiCore.Core, bpy.types.Panel):
    bl_label = "Vector Display"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 61

    bl_parent_id = "VIEW3D_PT_Viewport"

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and P.UI_BLENDER()

    def draw_header(self, context):
        domain = context.scene.MantaPro.active_domain
        modifier_settings = modifiers.get_modifier_domain(domain=domain)
        self.set_layout("row", align=True)
        self.prop(modifier_settings, "show_velocity", text="")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "view_vector")
        else:
            ui_liquid.draw(self, context, "view_vector")


"""
 ███████████  ████                          █████
░░███░░░░░███░░███                         ░░███
 ░███    ░███ ░███   ██████  ████████    ███████   ██████  ████████
 ░██████████  ░███  ███░░███░░███░░███  ███░░███  ███░░███░░███░░███
 ░███░░░░░███ ░███ ░███████  ░███ ░███ ░███ ░███ ░███████  ░███ ░░░
 ░███    ░███ ░███ ░███░░░   ░███ ░███ ░███ ░███ ░███░░░   ░███
 ███████████  █████░░██████  ████ █████░░████████░░██████  █████
░░░░░░░░░░░  ░░░░░  ░░░░░░  ░░░░ ░░░░░  ░░░░░░░░  ░░░░░░  ░░░░░
"""


class VIEW3D_PT_DomainBorderBlenderSub(uiCore.Core, DomainSub, bpy.types.Panel):
    bl_label = "Border Collisions"

    MP_order_id = 44

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and P.UI_BLENDER()

    def draw_header(self, context):
        self.set_layout("row")
        # self.label(icon="FACE_MAPS")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "border")
        else:
            ui_liquid.draw(self, context, "border")


class VIEW3D_PT_BlenderGuides(uiCore.Core, bpy.types.Panel):
    bl_label = "Guides"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 49

    bl_parent_id = "VIEW3D_PT_MantaPro"

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and P.UI_BLENDER()

    def draw_header(self, context):
        domain = context.scene.MantaPro.active_domain
        modifier_settings = modifiers.get_modifier_domain(domain=domain)
        self.set_layout("row", align=True)
        self.prop(modifier_settings, "use_guide", text="")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "guides")
        else:
            ui_liquid.draw(self, context, "guides")


class VIEW3D_PT_BlenderCollections(uiCore.Core, bpy.types.Panel):
    bl_label = "Collections"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 50

    bl_parent_id = "VIEW3D_PT_MantaPro"

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and P.UI_BLENDER()

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "collections")
        else:
            ui_liquid.draw(self, context, "collections")


class VIEW3D_PT_BlenderCache(uiCore.Core, bpy.types.Panel):
    bl_label = "Cache"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 51

    bl_parent_id = "VIEW3D_PT_MantaPro"

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and P.UI_BLENDER()

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "cache")
        else:
            ui_liquid.draw(self, context, "cache")


class VIEW3D_PT_BlenderCacheAdvanced(uiCore.Core, bpy.types.Panel):
    bl_label = "Advanced"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 52

    bl_parent_id = "VIEW3D_PT_BlenderCache"

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and P.UI_BLENDER()

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "cache_advanced")
        else:
            ui_liquid.draw(self, context, "cache_advanced")


class VIEW3D_PT_BlenderFieldWeights(uiCore.Core, bpy.types.Panel):
    bl_label = "Field Weights"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 53

    bl_parent_id = "VIEW3D_PT_MantaPro"

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and P.UI_BLENDER()

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "field")
        else:
            ui_liquid.draw(self, context, "field")


class VIEW3D_PT_BlenderViewport(uiCore.Core, bpy.types.Panel):
    bl_label = "Viewport Display"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 56

    bl_parent_id = "VIEW3D_PT_MantaPro"

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and P.UI_BLENDER()

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "view")
        else:
            ui_liquid.draw(self, context, "view")


class VIEW3D_PT_BlenderViewportSlice(uiCore.Core, bpy.types.Panel):
    bl_label = "Slice"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 58

    bl_parent_id = "VIEW3D_PT_BlenderViewport"

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and P.UI_BLENDER()

    def draw_header(self, context):
        domain = context.scene.MantaPro.active_domain
        modifier_settings = modifiers.get_modifier_domain(domain=domain)
        self.set_layout("row", align=True)
        self.prop(modifier_settings, "use_slice", text="")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw_view_slice(self, context)
        else:
            ui_liquid.draw(self, context, "view_slice")


class VIEW3D_PT_BlenderViewportGrid(uiCore.Core, bpy.types.Panel):
    bl_label = "Grid Display"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 60

    bl_parent_id = "VIEW3D_PT_BlenderViewport"

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and P.UI_BLENDER()

    def draw_header(self, context):
        domain = context.scene.MantaPro.active_domain
        modifier_settings = modifiers.get_modifier_domain(domain=domain)
        self.set_layout("row", align=True)
        self.prop(modifier_settings, "use_color_ramp", text="")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "view_grid")
        else:
            ui_liquid.draw(self, context, "view_grid")


class VIEW3D_PT_BlenderViewportVector(uiCore.Core, bpy.types.Panel):
    bl_label = "Vector Display"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 62

    bl_parent_id = "VIEW3D_PT_BlenderViewport"

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and P.UI_BLENDER()

    def draw_header(self, context):
        domain = context.scene.MantaPro.active_domain
        modifier_settings = modifiers.get_modifier_domain(domain=domain)
        self.set_layout("row", align=True)
        self.prop(modifier_settings, "show_velocity", text="")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "view_vector")
        else:
            ui_liquid.draw(self, context, "view_vector")


class VIEW3D_PT_DomainBlenderToolsSub(uiCore.Core, DomainSub, bpy.types.Panel):
    bl_label = "MantaPro Tools"
    bl_options = {"DEFAULT_CLOSED"}
    MP_order_id = 64

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and P.UI_BLENDER()

    def draw_header(self, context):
        self.set_layout("row")
        self.label(icon="TOOL_SETTINGS")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "tools")
        else:
            ui_liquid.draw(self, context, "tools")


class VIEW3D_PT_DomainMaterailBlenderToolsSub(uiCore.Core, DomainSub, bpy.types.Panel):
    bl_label = "Material"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    bl_parent_id = "VIEW3D_PT_DomainBlenderToolsSub"
    MP_order_id = 65

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and P.UI_BLENDER()

    def draw_header(self, context):
        self.set_layout("row")
        self.label(icon="MATERIAL_DATA")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "material")
        else:
            ui_liquid.draw(self, context, "material")


class VIEW3D_PT_CacheBlenderToolsSub(uiCore.Core, DomainSub, bpy.types.Panel):
    bl_label = "MantaPro Tools"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    bl_parent_id = "VIEW3D_PT_BlenderCache"
    bl_options = {"DEFAULT_CLOSED"}
    MP_order_id = 54

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN(context) and P.UI_BLENDER()

    def draw_header(self, context):
        self.set_layout("row")
        self.label(icon="TOOL_SETTINGS")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "cache_tools")
        else:
            ui_liquid.draw(self, context, "cache_tools")
