# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####


import bpy
from .. import Shared
from ..Shared import uiCore, ui_textures

from .. import preferences, Icons, QuickSetup

from ..Liquid import ui as ui_liquid
from .. Gas import ui as ui_gas

import os


"""
 █████  █████ █████       ████   ███           █████
░░███  ░░███ ░░███       ░░███  ░░░           ░░███
 ░███   ░███  ░███        ░███  ████   █████  ███████    █████
 ░███   ░███  ░███        ░███ ░░███  ███░░  ░░░███░    ███░░
 ░███   ░███  ░███        ░███  ░███ ░░█████   ░███    ░░█████
 ░███   ░███  ░███        ░███  ░███  ░░░░███  ░███ ███ ░░░░███
 ░░████████   █████       █████ █████ ██████   ░░█████  ██████
  ░░░░░░░░   ░░░░░       ░░░░░ ░░░░░ ░░░░░░     ░░░░░  ░░░░░░
"""


class OBJECT_UL_effector(bpy.types.UIList):
    MP_order_id = 2

    def draw_item(self, context, layout, data, item, icon, active_data, active_propname):
        if not item.obj:
            return
        ob = data
        domain = Shared.modifiers.get_modifier_domain(context)
        if not item.obj.users_scene:
            layout.alert = True
        if self.layout_type in {'DEFAULT'}:
            if Shared.modifiers.find_modifier(item.obj).effector_settings.effector_type == "GUIDE":
                Icon = "CON_TRACKTO"
            else:
                Icon = "MOD_PHYSICS"

            if domain:
                if domain.effector_group:
                    if domain.effector_group in item.obj.users_collection:
                        layout.enabled = True
                    else:
                        layout.enabled = False

            layout.prop(item.obj, "name", text="", emboss=False, icon=Icon)

            if not layout.enabled:
                layout.label(text="Not in " + domain.effector_group.name)


"""
  █████████             █████        █████               ████
 ███░░░░░███           ░░███        ░░███               ░░███
░███    ░░░  █████ ████ ░███████     ░███████    ██████  ░███  ████████   ██████  ████████   █████
░░█████████ ░░███ ░███  ░███░░███    ░███░░███  ███░░███ ░███ ░░███░░███ ███░░███░░███░░███ ███░░
 ░░░░░░░░███ ░███ ░███  ░███ ░███    ░███ ░███ ░███████  ░███  ░███ ░███░███████  ░███ ░░░ ░░█████
 ███    ░███ ░███ ░███  ░███ ░███    ░███ ░███ ░███░░░   ░███  ░███ ░███░███░░░   ░███      ░░░░███
░░█████████  ░░████████ ████████     ████ █████░░██████  █████ ░███████ ░░██████  █████     ██████
 ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░     ░░░░ ░░░░░  ░░░░░░  ░░░░░  ░███░░░   ░░░░░░  ░░░░░     ░░░░░░
                                                               ░███
                                                               █████
                                                              ░░░░░
"""


class EffectorSub:
    bl_parent_id = "VIEW3D_PT_MantaProEffector"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"


"""
 ██████████    ██████     ██████                     █████                                                                  ████
░░███░░░░░█   ███░░███   ███░░███                   ░░███                                                                  ░░███
 ░███  █ ░   ░███ ░░░   ░███ ░░░   ██████   ██████  ███████    ██████  ████████     ████████   ██████   ████████    ██████  ░███
 ░██████    ███████    ███████    ███░░███ ███░░███░░░███░    ███░░███░░███░░███   ░░███░░███ ░░░░░███ ░░███░░███  ███░░███ ░███
 ░███░░█   ░░░███░    ░░░███░    ░███████ ░███ ░░░   ░███    ░███ ░███ ░███ ░░░     ░███ ░███  ███████  ░███ ░███ ░███████  ░███
 ░███ ░   █  ░███       ░███     ░███░░░  ░███  ███  ░███ ███░███ ░███ ░███         ░███ ░███ ███░░███  ░███ ░███ ░███░░░   ░███
 ██████████  █████      █████    ░░██████ ░░██████   ░░█████ ░░██████  █████        ░███████ ░░████████ ████ █████░░██████  █████
░░░░░░░░░░  ░░░░░      ░░░░░      ░░░░░░   ░░░░░░     ░░░░░   ░░░░░░  ░░░░░         ░███░░░   ░░░░░░░░ ░░░░ ░░░░░  ░░░░░░  ░░░░░
                                                                                    ░███
                                                                                    █████
                                                                                   ░░░░░
"""


class VIEW3D_PT_MantaProEffectorMain(uiCore.Core, bpy.types.Panel):
    bl_label = ""  # MantaPro Effector
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 13

    def draw_header(self, context):
        row = self.layout.row(align=True)
        row.label(text="MantaPro Effector",
                  icon_value=Icons.get_icon_id("effector_mixed"))

    def draw(self, context):
        settings = context.scene.MantaPro
        layout = self.layout

        self.set_layout("row", align=True)

        col = layout.column()
        col.template_list("OBJECT_UL_effector", "", settings,
                          "effectors", settings, "effectors_index")

        self.set_layout("row", align=True)
        icon = "BLENDER"
        if settings.active_effector:
            modifier = Shared.modifiers.find_modifier(settings.active_effector)
            if modifier:
                if modifier.effector_settings.effector_type == "GUIDE":
                    icon = "CON_TRACKTO"
                else:
                    icon = "MOD_PHYSICS"

        try:
            self.label(
                text=settings.effectors[settings.effectors_index].obj.name, icon=icon)
        except:
            self.label(text="")

        self.operator("mantapro.make_effector", icon="ADD", text="")
        self.operator("mantapro.remove", text="", icon="REMOVE", settings=[
            ["kind", "EFFECTOR"]])
        self.operator("mantapro.find_effector", icon="ZOOM_ALL", text="",)


class VIEW3D_PT_MantaProEffector(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_MantaProEffectorMain"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    bl_label = "settings"
    MP_order_id = 15

    @ classmethod
    def poll(cls, context):
        return context.scene.MantaPro.active_effector

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "effector")
        else:
            ui_liquid.draw(self, context, "effector")


"""
 ██████████    ██████     ██████                     █████                                             █████
░░███░░░░░█   ███░░███   ███░░███                   ░░███                                             ░░███
 ░███  █ ░   ░███ ░░░   ░███ ░░░   ██████   ██████  ███████    ██████  ████████      █████  █████ ████ ░███████
 ░██████    ███████    ███████    ███░░███ ███░░███░░░███░    ███░░███░░███░░███    ███░░  ░░███ ░███  ░███░░███
 ░███░░█   ░░░███░    ░░░███░    ░███████ ░███ ░░░   ░███    ░███ ░███ ░███ ░░░    ░░█████  ░███ ░███  ░███ ░███
 ░███ ░   █  ░███       ░███     ░███░░░  ░███  ███  ░███ ███░███ ░███ ░███         ░░░░███ ░███ ░███  ░███ ░███
 ██████████  █████      █████    ░░██████ ░░██████   ░░█████ ░░██████  █████        ██████  ░░████████ ████████
░░░░░░░░░░  ░░░░░      ░░░░░      ░░░░░░   ░░░░░░     ░░░░░   ░░░░░░  ░░░░░        ░░░░░░    ░░░░░░░░ ░░░░░░░░
"""


class VIEW3D_PT_EffectorDisplaySubGas(uiCore.Core, EffectorSub, bpy.types.Panel):
    bl_label = "Display"
    MP_order_id = 16

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        if context.scene.MantaPro.active_effector:
            if Shared.modifiers.check_type_liquid(context.scene.MantaPro.active_effector, "EFFECTOR"):
                return True
        return False

    def draw_header(self, context):
        self.set_layout("row")
        self.label(icon="RESTRICT_VIEW_OFF")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "effector_display")
        else:
            ui_liquid.draw(self, context, "effector_display")
