# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####

import bpy
from .. import Shared
from ..Shared import uiCore, ui_textures

from .. import preferences, Icons, QuickSetup

from ..Liquid import ui as ui_liquid
from .. Gas import ui as ui_gas

import os

"""
 ██████████                 █████                                              █████
░░███░░░░░█                ░░███                                              ░░███
 ░███  █ ░  █████████████   ░███████   ██████  ████████      █████  █████ ████ ░███████   █████
 ░██████   ░░███░░███░░███  ░███░░███ ███░░███░░███░░███    ███░░  ░░███ ░███  ░███░░███ ███░░
 ░███░░█    ░███ ░███ ░███  ░███ ░███░███████  ░███ ░░░    ░░█████  ░███ ░███  ░███ ░███░░█████
 ░███ ░   █ ░███ ░███ ░███  ░███ ░███░███░░░   ░███         ░░░░███ ░███ ░███  ░███ ░███ ░░░░███
 ██████████ █████░███ █████ ████████ ░░██████  █████        ██████  ░░████████ ████████  ██████
░░░░░░░░░░ ░░░░░ ░░░ ░░░░░ ░░░░░░░░   ░░░░░░  ░░░░░        ░░░░░░    ░░░░░░░░ ░░░░░░░░  ░░░░░░



"""


class VIEW3D_PT_EmberSettingsSub(uiCore.Core, bpy.types.Panel):
    bl_label = "General Settings"
    bl_parent_id = "VIEW3D_PT_FlowEmberSub"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 80

    @ classmethod
    def poll(cls, context):
        flow = context.scene.MantaPro.active_flow
        system = Shared.particles.find_ember_system(flow)
        return system

    def draw_header(self, context):
        self.label(icon="SETTINGS")

    def draw(self, context):
        Shared.ui.ember(self, context)


class VIEW3D_PT_EmberParticleSub(uiCore.Core, bpy.types.Panel):
    bl_label = "Particle Settings"
    bl_parent_id = "VIEW3D_PT_FlowEmberSub"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 82

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        flow = context.scene.MantaPro.active_flow
        system = Shared.particles.find_ember_system(flow)
        return system

    def draw_header(self, context):
        self.label(icon="PARTICLES")

    def draw(self, context):
        Shared.ui.ember_particle(self, context)


class VIEW3D_PT_EmberCustomParticleSub(uiCore.Core, bpy.types.Panel):
    bl_label = "Custom Particles"
    bl_parent_id = "VIEW3D_PT_EmberParticleSub"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 83

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        flow = context.scene.MantaPro.active_flow
        system = Shared.particles.find_ember_system(flow)
        return system

    def draw_header(self, context):
        self.label(icon="MOD_PARTICLE_INSTANCE")

    def draw(self, context):
        Shared.ui.ember_custom_particles(self, context)


class VIEW3D_PT_EmberMaterialSub(uiCore.Core, bpy.types.Panel):
    bl_label = "Material Settings"
    bl_parent_id = "VIEW3D_PT_FlowEmberSub"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 87

    @ classmethod
    def poll(cls, context):
        flow = context.scene.MantaPro.active_flow
        system = Shared.particles.find_ember_system(flow)
        return system

    def draw_header(self, context):
        self.label(icon="MATERIAL")

    def draw(self, context):
        Shared.ui.ember_material(self, context)


class VIEW3D_PT_EmberForceSub(uiCore.Core, bpy.types.Panel):
    bl_label = "Force Settings"
    bl_parent_id = "VIEW3D_PT_FlowEmberSub"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 84

    bl_options = {"DEFAULT_CLOSED"}

    def draw_header(self, context):
        self.label(icon="FORCE_FORCE")

    @ classmethod
    def poll(cls, context):
        flow = context.scene.MantaPro.active_flow
        system = Shared.particles.find_ember_system(flow)
        return system

    def draw(self, context):
        Shared.ui.ember_force(self, context)


class VIEW3D_PT_EmberForceFalloffSub(uiCore.Core, bpy.types.Panel):
    bl_label = "Falloff"
    bl_parent_id = "VIEW3D_PT_EmberForceSub"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 86

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        flow = context.scene.MantaPro.active_flow
        system = Shared.particles.find_ember_system(flow)
        return system

    def draw(self, context):
        Shared.ui.ember_force_falloff(self, context)


class VIEW3D_PT_EmberCacheSub(uiCore.Core, bpy.types.Panel):
    bl_label = "Cache Settings"
    bl_parent_id = "VIEW3D_PT_FlowEmberSub"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 85

    @ classmethod
    def poll(cls, context):
        flow = context.scene.MantaPro.active_flow
        system = Shared.particles.find_ember_system(flow)
        return system

    def draw_header(self, context):
        self.label(icon="FILE")

    def draw(self, context):
        Shared.ui.ember_cache(self, context)

