# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####


import bpy
from .. import Shared
from ..Shared import uiCore, ui_textures

from .. import preferences, Icons, QuickSetup

from ..Liquid import ui as ui_liquid
from .. Gas import ui as ui_gas

import os


class OBJECT_UL_force(bpy.types.UIList):
    MP_order_id = 3

    def draw_item(self, context, layout, data, item, icon, active_data, active_propname):
        if not item.obj:
            return
        ob = data
        domain = Shared.modifiers.get_modifier_domain(context=context)
        if not item.obj.users_scene:
            layout.alert = True
        if self.layout_type in {'DEFAULT'}:

            if domain:
                if domain.effector_weights.collection:
                    if domain.effector_weights.collection in item.obj.users_collection:
                        layout.enabled = True
                    else:
                        layout.enabled = False

            icon = Shared.forces.get_icon(item.obj.field.type)

            layout.prop(item.obj, "name", text="", icon=icon, emboss=False,)
            if item.obj.MantaPro.force_ember:
                layout.label(icon="MOD_PARTICLE_INSTANCE")
                layout.enabled = True

            if not layout.enabled:
                layout.label(text="Not in " +
                             domain.effector_weights.collection.name)


"""
 ███████████                                                                                         ████
░░███░░░░░░█                                                                                        ░░███
 ░███   █ ░   ██████  ████████   ██████   ██████   █████     ████████   ██████   ████████    ██████  ░███
 ░███████    ███░░███░░███░░███ ███░░███ ███░░███ ███░░     ░░███░░███ ░░░░░███ ░░███░░███  ███░░███ ░███
 ░███░░░█   ░███ ░███ ░███ ░░░ ░███ ░░░ ░███████ ░░█████     ░███ ░███  ███████  ░███ ░███ ░███████  ░███
 ░███  ░    ░███ ░███ ░███     ░███  ███░███░░░   ░░░░███    ░███ ░███ ███░░███  ░███ ░███ ░███░░░   ░███
 █████      ░░██████  █████    ░░██████ ░░██████  ██████     ░███████ ░░████████ ████ █████░░██████  █████
░░░░░        ░░░░░░  ░░░░░      ░░░░░░   ░░░░░░  ░░░░░░      ░███░░░   ░░░░░░░░ ░░░░ ░░░░░  ░░░░░░  ░░░░░
                                                             ░███
                                                             █████
                                                            ░░░░░
"""


class VIEW3D_PT_MantaProForceMain(uiCore.Core, bpy.types.Panel):
    bl_label = ""  # MantaPro Effector
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 17

    def draw_header(self, context):
        row = self.layout.row(align=True)
        row.label(text="MantaPro Force",
                  icon_value=Icons.get_icon_id("force_mixed"))

    def draw(self, context):
        settings = context.scene.MantaPro
        layout = self.layout

        self.set_layout("row", align=True)

        col = layout.column()
        col.template_list("OBJECT_UL_force", "", settings,
                          "forces", settings, "forces_index")

        self.set_layout("row", align=True)

        try:
            icon = Shared.forces.get_icon(
                settings.forces[settings.forces_index].obj.field.type)
            self.label(
                text=settings.forces[settings.forces_index].obj.name, icon=icon)
        except:
            self.label(text="")

        self.operator("mantapro.add_force_menu", icon="PLUS", text="")

        self.operator("mantapro.make_force_menu", icon="ADD",
                      text="")
        self.operator("mantapro.remove_force", icon="REMOVE", text="")

        self.operator("mantapro.find_all", icon="ZOOM_ALL", text="")


class VIEW3D_PT_MantaProForce(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_MantaProForceMain"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    bl_label = "settings"
    MP_order_id = 18

    @ classmethod
    def poll(cls, context):
        return context.scene.MantaPro.active_force

    def draw(self, context):
        force = context.scene.MantaPro.active_force
        settings = force.field

        self.set_layout("col")
        self.operator("mantapro.switch_force_menu")

        if settings.type == "FLUID_FLOW":
            Shared.forces.draw_fluid_flow(self, settings)
        elif settings.type == "FORCE":
            Shared.forces.draw_force(self, settings)
        elif settings.type == "WIND":
            Shared.forces.draw_wind(self, settings)
        elif settings.type == "VORTEX":
            Shared.forces.draw_vortex(self, settings)
        elif settings.type == "MAGNET":
            Shared.forces.draw_magnet(self, settings)
        elif settings.type == "HARMONIC":
            Shared.forces.draw_harmonic(self, settings)
        elif settings.type == "CHARGE":
            Shared.forces.draw_charge(self, settings)
        elif settings.type == "LENNARDJ":
            Shared.forces.draw_LJ(self, settings)
        elif settings.type == "TEXTURE":
            Shared.forces.draw_texture(self, settings)
        elif settings.type == "GUIDE":
            Shared.forces.draw_guide(self, settings)
        elif settings.type == "BOID":
            Shared.forces.draw_boid(self, settings)
        elif settings.type == "TURBULENCE":
            Shared.forces.draw_turbulence(self, settings)
        elif settings.type == "DRAG":
            Shared.forces.draw_drag(self, settings)


"""
 ███████████                                                            █████
░░███░░░░░░█                                                           ░░███
 ░███   █ ░   ██████  ████████   ██████   ██████      █████  █████ ████ ░███████   █████
 ░███████    ███░░███░░███░░███ ███░░███ ███░░███    ███░░  ░░███ ░███  ░███░░███ ███░░
 ░███░░░█   ░███ ░███ ░███ ░░░ ░███ ░░░ ░███████    ░░█████  ░███ ░███  ░███ ░███░░█████
 ░███  ░    ░███ ░███ ░███     ░███  ███░███░░░      ░░░░███ ░███ ░███  ░███ ░███ ░░░░███
 █████      ░░██████  █████    ░░██████ ░░██████     ██████  ░░████████ ████████  ██████
░░░░░        ░░░░░░  ░░░░░      ░░░░░░   ░░░░░░     ░░░░░░    ░░░░░░░░ ░░░░░░░░  ░░░░░░
"""


class VIEW3D_PT_MantaProForceFalloff(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_MantaProForce"
    bl_label = "Falloff"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 19

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        force = context.scene.MantaPro.active_force
        if force:
            settings = force.field
            if settings.type != "GUIDE":
                return True
            else:
                return False
        return False

    def draw(self, context):
        force = context.scene.MantaPro.active_force
        settings = force.field
        Shared.forces.draw_falloff(self, settings)


class VIEW3D_PT_MantaProForceFalloffRadial(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_MantaProForceFalloff"
    bl_label = ""
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 24

    @ classmethod
    def poll(cls, context):
        force = context.scene.MantaPro.active_force
        if force:
            settings = force.field
            if settings.falloff_type != "SPHERE":
                return True
            else:
                return False
        return False

    def draw_header(self, context):
        force = context.scene.MantaPro.active_force
        settings = force.field
        if settings.falloff_type == "CONE":
            self.label(text="Angular")
        elif settings.falloff_type == "TUBE":
            self.label(text="Radial")

    def draw(self, context):
        force = context.scene.MantaPro.active_force
        settings = force.field
        Shared.forces.draw_falloff_radial(self, settings)


class VIEW3D_PT_MantaProForceKink(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_MantaProForce"
    bl_label = "Kink"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 20

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        force = context.scene.MantaPro.active_force
        if force:
            settings = force.field
            if settings.type == "GUIDE":
                return True
            else:
                return False
        return False

    def draw(self, context):
        force = context.scene.MantaPro.active_force
        settings = force.field
        Shared.forces.draw_kink(self, settings)


"""
 ███████████                                          █████                          █████
░░███░░░░░░█                                         ░░███                          ░░███
 ░███   █ ░   ██████  ████████   ██████   ██████     ███████    ██████  █████ █████ ███████   █████ ████ ████████   ██████
 ░███████    ███░░███░░███░░███ ███░░███ ███░░███   ░░░███░    ███░░███░░███ ░░███ ░░░███░   ░░███ ░███ ░░███░░███ ███░░███
 ░███░░░█   ░███ ░███ ░███ ░░░ ░███ ░░░ ░███████      ░███    ░███████  ░░░█████░    ░███     ░███ ░███  ░███ ░░░ ░███████
 ░███  ░    ░███ ░███ ░███     ░███  ███░███░░░       ░███ ███░███░░░    ███░░░███   ░███ ███ ░███ ░███  ░███     ░███░░░
 █████      ░░██████  █████    ░░██████ ░░██████      ░░█████ ░░██████  █████ █████  ░░█████  ░░████████ █████    ░░██████
░░░░░        ░░░░░░  ░░░░░      ░░░░░░   ░░░░░░        ░░░░░   ░░░░░░  ░░░░░ ░░░░░    ░░░░░    ░░░░░░░░ ░░░░░      ░░░░░░
"""


class VIEW3D_PT_MantaProForceTexture(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_MantaProForce"
    bl_label = "Texture"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 21

    @ classmethod
    def poll(cls, context):
        force = context.scene.MantaPro.active_force
        if force:
            settings = force.field
            if settings.type == "TEXTURE":
                return True
            else:
                return False
        return False

    def draw(self, context):
        force = context.scene.MantaPro.active_force
        settings = force.field
        self.set_layout("col", align=True)
        self.ui_layout.template_ID_preview(
            settings, "texture", new="texture.new")


class VIEW3D_PT_MantaProForceTextureSettings(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_MantaProForceTexture"
    bl_label = "Texture Settings"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 22

    @ classmethod
    def poll(cls, context):
        force = context.scene.MantaPro.active_force
        if force:
            settings = force.field
            if settings.type == "TEXTURE" and settings.texture:
                return True
            else:
                return False
        return False

    def draw(self, context):
        force = context.scene.MantaPro.active_force
        settings = force.field
        self.set_layout("col", align=True)
        ui_textures.ui(self, settings.texture)


class VIEW3D_PT_ForceTextureColorSub(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_MantaProForceTexture"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "Color"
    bl_context = "objectmode"
    MP_order_id = 23

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        force = context.scene.MantaPro.active_force
        if force:
            if force.field.type != "NONE":
                if force.field.texture:
                    return True
        return False

    def draw(self, context):
        force = context.scene.MantaPro.active_force
        settings = force.field
        texture = settings.texture
        ui_textures.draw_color(self, texture)

