# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####

import bpy
from .. import Shared
from ..Shared import uiCore, ui_textures

from .. import preferences, Icons, QuickSetup

from ..Liquid import ui as ui_liquid
from .. Gas import ui as ui_gas

import os

"""
 ███████████                                       █████
░░███░░░░░███                                     ░░███
 ░███    ░███ ████████   ██████   █████   ██████  ███████    █████
 ░██████████ ░░███░░███ ███░░███ ███░░   ███░░███░░░███░    ███░░
 ░███░░░░░░   ░███ ░░░ ░███████ ░░█████ ░███████   ░███    ░░█████
 ░███         ░███     ░███░░░   ░░░░███░███░░░    ░███ ███ ░░░░███
 █████        █████    ░░██████  ██████ ░░██████   ░░█████  ██████
░░░░░        ░░░░░      ░░░░░░  ░░░░░░   ░░░░░░     ░░░░░  ░░░░░░
"""


class VIEW3D_PT_SaveSetup(uiCore.Core, bpy.types.Panel):
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "Presets"
    bl_context = "objectmode"
    MP_order_id = 26

    bl_options = {"DEFAULT_CLOSED"}

    def draw(self, context):
        settings = context.scene.MantaPro
        collection = settings.quick_setup_save_collection

        self.set_layout("col")
        self.label_prop(settings, "quick_setup_save_collection",
                        text="Collection")
        self.label_prop(settings, "quick_setup_save_category", text="Category")
        self.separator()
        self.prop(settings, "quick_setup_save_index")
        self.label_prop(settings, "quick_setup_save_name", text="Name")
        self.separator()
        if collection:
            collection_settings = collection.MantaPro
            self.set_layout("col", align=True)
            self.icon_prop(collection_settings, "use_materials")
            self.icon_prop(collection_settings, "add_particles")

            self.set_layout("col", align=True, boxed=True)
            self.icon_prop(collection_settings, "use_defaults")
            self.separator()

            self.icon_prop(collection_settings, "liquid_resolution")
            self.icon_prop(collection_settings, "gas_resolution")
            self.icon_prop(collection_settings, "liquid_sim_speed")
            self.icon_prop(collection_settings, "gas_sim_speed")
            self.icon_prop(collection_settings, "gas_flow_type")
            self.icon_prop(collection_settings, "liquid_set_collection")
            self.icon_prop(collection_settings, "gas_set_collection")

            self.set_layout("col", align=True)

            preset_name = settings.quick_setup_save_name
            self.label(text="Preset Name:  " + preset_name)

        self.operator("mantapro.quick_setup_save_op",
                      text="Save Preset", icon="FILE_TICK")


class VIEW3D_PT_RemoveSetup(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_SaveSetup"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "Remove"
    bl_context = "objectmode"
    MP_order_id = 27

    bl_options = {"DEFAULT_CLOSED"}

    def draw(self, context):
        liquid, gas, other = QuickSetup.get_custom()

        if not (liquid or gas or other):
            self.set_layout("col")
            self.label(text="No custom presets found")

        for i in liquid:
            self.set_layout("row", boxed=True)
            icon = Icons.get_icon_id("domain_liquid")
            self.label(text=i[3:-7].replace("_", " "), icon=icon)
            self.operator("mantapro.quick_setup_remove_menu",
                          icon="X", text="", settings=[["preset", i]])

        for i in gas:
            self.set_layout("row", boxed=True)
            icon = Icons.get_icon_id("domain_gas")
            self.label(text=i[3:-4].replace("_", " "), icon=icon)
            self.operator("mantapro.quick_setup_remove_menu",
                          icon="X", text="", settings=[["preset", i]])

        for i in other:
            self.set_layout("row", boxed=True)
            icon = Icons.get_icon_id("domain_mixed")
            self.label(text=i[3:].replace("_", " "), icon=icon)
            self.operator("mantapro.quick_setup_remove_menu",
                          icon="X", text="", settings=[["preset", i]])


class VIEW3D_PT_ExportImportSetup(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_SaveSetup"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "Import/Export"
    bl_context = "objectmode"
    MP_order_id = 28

    bl_options = {"DEFAULT_CLOSED"}

    def draw(self, context):
        liquid, gas, other = QuickSetup.get_custom()

        if not (liquid or gas or other):
            self.set_layout("col")
            self.label(text="No custom presets found")
            self.operator("mantapro.quick_setup_import_op", icon="IMPORT")
            return

        self.set_layout("col", align=True)
        self.operator("mantapro.quick_setup_import_op", icon="IMPORT")
        self.operator("mantapro.quick_setup_export_op", icon="EXPORT")


class VIEW3D_PT_ViewSetup(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_SaveSetup"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "View"
    bl_context = "objectmode"
    MP_order_id = 29

    bl_options = {"DEFAULT_CLOSED"}

    def draw(self, context):
        liquid, gas, other = QuickSetup.get_all()

        self.set_layout("col", boxed=True)
        for i in liquid:
            i = i[:3] + " " + i[3:]
            icon = Icons.get_icon_id("domain_liquid")
            self.label(text=i.replace("_", " "), icon=icon)

        self.set_layout("col", boxed=True)
        for i in gas:
            i = i[:3] + " " + i[3:]
            icon = Icons.get_icon_id("domain_gas")
            self.label(text=i.replace("_", " "), icon=icon)

        if other:
            self.set_layout("col", boxed=True)
            for i in other:
                i = i[:3] + " " + i[3:]
                icon = Icons.get_icon_id("domain_mixed")
                self.label(text=i.replace("_", " "), icon=icon)


"""
 ███████████             ███              █████
░░███░░░░░███           ░░░              ░░███
 ░███    ░███  ██████   ████  ████████   ███████
 ░██████████  ░░░░░███ ░░███ ░░███░░███ ░░░███░
 ░███░░░░░░    ███████  ░███  ░███ ░███   ░███
 ░███         ███░░███  ░███  ░███ ░███   ░███ ███
 █████       ░░████████ █████ ████ █████  ░░█████
░░░░░         ░░░░░░░░ ░░░░░ ░░░░ ░░░░░    ░░░░░
"""


class VIEW3D_PT_MantaProPanelPaint(uiCore.Core, bpy.types.Panel):
    bl_label = "MantaPro Paint"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = ".paint_common"
    MP_order_id = 25

    def draw(self, context):

        self.set_layout("col")

        self.operator("mantapro_gas.paint_end", icon="FILE_PARENT")


"""
 ██████████   ██████████ █████   █████
░░███░░░░███ ░░███░░░░░█░░███   ░░███
 ░███   ░░███ ░███  █ ░  ░███    ░███
 ░███    ░███ ░██████    ░███    ░███
 ░███    ░███ ░███░░█    ░░███   ███
 ░███    ███  ░███ ░   █  ░░░█████░
 ██████████   ██████████    ░░███
░░░░░░░░░░   ░░░░░░░░░░      ░░░

"""


class VIEW3D_PT_DEV(uiCore.Core, bpy.types.Panel):
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "DEV"
    MP_order_id = 88

    @ classmethod
    def poll(cls, context):
        return preferences.get_preferences().dev

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        flow = context.scene.MantaPro.active_flow
        effector = context.scene.MantaPro.active_effector
        self.set_layout("col")
        self.label("DEV")

        self.icon_prop(context.scene.MantaPro.DEV, "show_panel_id")

        if context.active_object:
            if context.active_object.material_slots:
                self.prop(
                    context.active_object.material_slots[0].material.MantaPro, "version")
            self.label_prop(context.active_object.MantaPro,
                            "particle_collection")

        self.set_layout("col")
        self.operator("mantapro.ui_lists")
        self.icon_prop(context.scene.MantaPro.auto_ops_settings,
                       "updated_preferences")
