# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####


import bpy
from . import pref_ui

import os


def get_preferences():

    return bpy.context.preferences.addons[__package__].preferences


def update_blank(self, context):
    if self.blank:
        self.blank = False


def update_abreveate_tab(self, context):
    base = os.path.abspath(os.path.dirname(__file__))
    file = os.path.join(base, "abreveate_tab")
    if self.abreveate_tab:
        open(file, "w").close()
    else:
        os.remove(file)


class Preference(bpy.types.AddonPreferences):
    bl_idname = __package__

    category: bpy.props.EnumProperty(items=[("GENERAL", "General", "General Prefrances", 0),
                                            ("DEFAULTS", "Defaults",
                                             "Defaults Prefrances", 1),
                                            ("KEY", "Key Binding", "Key Binding Prefrances", 2)],
                                     name="Category",
                                     default="GENERAL")

    """
               █████                                                        █████                 █████              █████
              ░░███                                                        ░░███                 ░░███              ░░███
      ██████   ░███████  ████████   ██████  █████ █████  ██████   ██████   ███████    ██████     ███████    ██████   ░███████
     ░░░░░███  ░███░░███░░███░░███ ███░░███░░███ ░░███  ███░░███ ░░░░░███ ░░░███░    ███░░███   ░░░███░    ░░░░░███  ░███░░███
      ███████  ░███ ░███ ░███ ░░░ ░███████  ░███  ░███ ░███████   ███████   ░███    ░███████      ░███      ███████  ░███ ░███
     ███░░███  ░███ ░███ ░███     ░███░░░   ░░███ ███  ░███░░░   ███░░███   ░███ ███░███░░░       ░███ ███ ███░░███  ░███ ░███
    ░░████████ ████████  █████    ░░██████   ░░█████   ░░██████ ░░████████  ░░█████ ░░██████      ░░█████ ░░████████ ████████
     ░░░░░░░░ ░░░░░░░░  ░░░░░      ░░░░░░     ░░░░░     ░░░░░░   ░░░░░░░░    ░░░░░   ░░░░░░        ░░░░░   ░░░░░░░░ ░░░░░░░░
    """
    base = os.path.abspath(os.path.dirname(__file__))
    file = os.path.join(base, "abreveate_tab")
    if os.path.exists(file):
        abreveate_tab_default = True
    else:
        abreveate_tab_default = False

    abreveate_tab: bpy.props.BoolProperty(name="Abreveate Tab Name (Blender Restart Required)",
                                          description="Abreveate the MantaPro tab name from 'MantaPro' to 'MP'\nBlender must be restated for this to take affect", default=abreveate_tab_default,
                                          update=update_abreveate_tab)

    """
                                                               ████
                                                              ░░███
      ███████  ██████  ████████    ██████  ████████   ██████   ░███
     ███░░███ ███░░███░░███░░███  ███░░███░░███░░███ ░░░░░███  ░███
    ░███ ░███░███████  ░███ ░███ ░███████  ░███ ░░░   ███████  ░███
    ░███ ░███░███░░░   ░███ ░███ ░███░░░   ░███      ███░░███  ░███
    ░░███████░░██████  ████ █████░░██████  █████    ░░████████ █████
     ░░░░░███ ░░░░░░  ░░░░ ░░░░░  ░░░░░░  ░░░░░      ░░░░░░░░ ░░░░░
     ███ ░███
    ░░██████
     ░░░░░░
    """

    # TODO set default False for release
    dev: bpy.props.BoolProperty(
        name="Dev-mode", description="diplays a panel with properties and tools used in development", default=False)

    ui_mode: bpy.props.EnumProperty(
        items=[("DEFAULT", "Default", "the default ui (fedback welcome)", 0),
               ("SIMPLIFIED", "Simplified",
                "simplified ui for beginners (fedback welcome)", 1),
               ("BLENDER", "Blender", "mimic blender's ui for fluid simulation", 2)],
        name="UI Mode",
        description="mode for MantaPro's UI",
        default="DEFAULT")

    show_list_ops: bpy.props.BoolProperty(name="Show add buttons in the context list (CTRL+SHIFT+C)",
                                          description="Show add buttons in the context list (CTRL+SHIFT+C)", default=True)

    move_to_collection: bpy.props.BoolProperty(name="Move created objects to the correct collections",
                                               description="Move created objects to the correct collections", default=True)

    """
                           █████
                          ░░███
      ██████   █████ ████ ███████    ██████      ██████  ████████   █████
     ░░░░░███ ░░███ ░███ ░░░███░    ███░░███    ███░░███░░███░░███ ███░░
      ███████  ░███ ░███   ░███    ░███ ░███   ░███ ░███ ░███ ░███░░█████
     ███░░███  ░███ ░███   ░███ ███░███ ░███   ░███ ░███ ░███ ░███ ░░░░███
    ░░████████ ░░████████  ░░█████ ░░██████    ░░██████  ░███████  ██████
     ░░░░░░░░   ░░░░░░░░    ░░░░░   ░░░░░░      ░░░░░░   ░███░░░  ░░░░░░
                                                         ░███
                                                         █████
                                                        ░░░░░
    """

    auto_ops: bpy.props.BoolProperty(name="Automatically turn auto operations on when performing certain operations",
                                     description="turn auto operations on when performing certain operations", default=True)

    auto_find: bpy.props.BoolProperty(name="Use Auto Find",
                                      description="automatically find all fluid sim objects in the scene", default=True)
    auto_remove: bpy.props.BoolProperty(name="Use Auto Remove",
                                        description="automatically remove any object form the lists if it is not in the scene", default=True)
    auto_v_selection: bpy.props.BoolProperty(name="Sync Viewport Selection to Lists",
                                             description="selected objects from the viewport get selected in the lists ", default=False)

    """
         █████             ██████                       ████   █████
        ░░███             ███░░███                     ░░███  ░░███
      ███████   ██████   ░███ ░░░   ██████   █████ ████ ░███  ███████    █████
     ███░░███  ███░░███ ███████    ░░░░░███ ░░███ ░███  ░███ ░░░███░    ███░░
    ░███ ░███ ░███████ ░░░███░      ███████  ░███ ░███  ░███   ░███    ░░█████
    ░███ ░███ ░███░░░    ░███      ███░░███  ░███ ░███  ░███   ░███ ███ ░░░░███
    ░░████████░░██████   █████    ░░████████ ░░████████ █████  ░░█████  ██████
     ░░░░░░░░  ░░░░░░   ░░░░░      ░░░░░░░░   ░░░░░░░░ ░░░░░    ░░░░░  ░░░░░░
    """
    liquid_resolution: bpy.props.IntProperty(
        name='Default Liquid Resolution',
        description='default liquid resolution',
        min=16,
        max=10000,
        default=43,
    )

    gas_resolution: bpy.props.IntProperty(
        name='Default Gas Resolution',
        description='Default Gas resolution',
        min=16,
        max=10000,
        default=43,
    )

    liquid_sim_speed: bpy.props.FloatProperty(
        name="Default Liquid Sim Speed",
        description="default liquid simulation speed",
        default=1.0,
        max=10.0,
        min=0.0001,
        precision=3)

    gas_sim_speed: bpy.props.FloatProperty(
        name="Default Gas Sim Speed",
        description="default gas simulation speed",
        default=1.0,
        max=10.0,
        min=0.0001,
        precision=3)

    gas_flow_type: bpy.props.EnumProperty(
        items=[("FIRE", "Fire", "Add fire", 0),
               ("BOTH", "Fire + Smoke", "Add fire and smoke", 1),
               ("SMOKE", "Smoke", "Add smoke", 2)],
        name="Default Flow Type",
        description="default flow type for gas flow objects",
        default="SMOKE")

    liquid_set_collection: bpy.props.BoolProperty(
        name="Use Collections for Liquid Quick Setup",
        description="Use flow and effector collection when using quick setup for liquid simulation",
        default=True)

    gas_set_collection: bpy.props.BoolProperty(
        name="Use Collections for Gas Quick Setup",
        description="Use flow and effector collection when using quick setup for gas simulation",
        default=True)

    blank: bpy.props.BoolProperty(default=False, update=update_blank)

    def draw(self, context):
        layout = self.layout

        layout.row().prop(self, "category", expand=True)

        if self.category == "GENERAL":
            pref_ui.draw_general(self, layout)
        elif self.category == "DEFAULTS":
            pref_ui.draw_defaults(self, layout)
        elif self.category == "KEY":
            pref_ui.draw_keys(self, layout)
