# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####
import bpy
import rna_keymap_ui


def draw_general(self, layout: bpy.types.UILayout):
    col = layout.column()
    col.label(text="UI mode:")
    col.prop(self, "ui_mode", text="")
    col.prop(self, "abreveate_tab")
    col.prop(self, "auto_ops")
    col.prop(self, "show_list_ops")
    col.prop(self, "move_to_collection")
    col.separator(factor=10)
    col.prop(self, "dev")


def draw_defaults(self, layout: bpy.types.UILayout):
    if self.ui_mode == "SIMPLIFIED":
        liquid_resolution = "Liquid Quality / Scale"
        gas_resolution = "Gas Quality / Scale"
        liquid_sim_speed = "Liquid Speed"
        gas_sim_speed = "Gas Speed"
    else:
        liquid_resolution = "Liquid Maximum Resolutions"
        gas_resolution = "Gas Maximum Resolutions"
        liquid_sim_speed = "Liquid Simulation Speed"
        gas_sim_speed = "Gas Simulation Speed"

    row = layout.row()
    row.label(text="Liquid")
    row.label(text="Gas")

    row = layout.row()
    row.prop(self, "liquid_resolution", text=liquid_resolution)
    row.prop(self, "gas_resolution", text=gas_resolution)

    row = layout.row()
    row.prop(self, "liquid_sim_speed", text=liquid_sim_speed)
    row.prop(self, "gas_sim_speed", text=gas_sim_speed)

    row = layout.row()
    row.prop(self, "liquid_set_collection")
    row.prop(self, "gas_set_collection")

    row = layout.row()

    row = layout.row()
    row.scale_y = 0.25
    row.label(text="")
    row.label(text="Default Flow Type")

    row = layout.row()

    row.prop(self, "blank", icon="BLANK1", text=" ")
    row.prop(self, "gas_flow_type", text="")

    col = layout.column()
    col.separator(factor=2)
    col.label(text="Auto Operations")
    col.prop(self, "auto_find")
    col.prop(self, "auto_remove")
    col.prop(self, "auto_v_selection")


def draw_keys(self, layout: bpy.types.UILayout):
    wm = bpy.context.window_manager
    kc = wm.keyconfigs.user
    km = kc.keymaps['Object Mode']
    ops = [
        "mantapro.replay_clear",
        "mantapro.ui_lists",
    ]
    for kmi in km.keymap_items:
        if kmi.idname in ops:
            rna_keymap_ui.draw_kmi([], kc, km, kmi, layout, 0)

    layout.separator(factor=0)
    layout.separator(factor=0)
