# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####
import bpy

"""
   █████████           ████  ████                     █████     ███
  ███░░░░░███         ░░███ ░░███                    ░░███     ░░░
 ███     ░░░   ██████  ░███  ░███   ██████   ██████  ███████   ████   ██████  ████████      ████████  ████████   ██████  ████████   █████
░███          ███░░███ ░███  ░███  ███░░███ ███░░███░░░███░   ░░███  ███░░███░░███░░███    ░░███░░███░░███░░███ ███░░███░░███░░███ ███░░
░███         ░███ ░███ ░███  ░███ ░███████ ░███ ░░░   ░███     ░███ ░███ ░███ ░███ ░███     ░███ ░███ ░███ ░░░ ░███ ░███ ░███ ░███░░█████
░░███     ███░███ ░███ ░███  ░███ ░███░░░  ░███  ███  ░███ ███ ░███ ░███ ░███ ░███ ░███     ░███ ░███ ░███     ░███ ░███ ░███ ░███ ░░░░███
 ░░█████████ ░░██████  █████ █████░░██████ ░░██████   ░░█████  █████░░██████  ████ █████    ░███████  █████    ░░██████  ░███████  ██████
  ░░░░░░░░░   ░░░░░░  ░░░░░ ░░░░░  ░░░░░░   ░░░░░░     ░░░░░  ░░░░░  ░░░░░░  ░░░░ ░░░░░     ░███░░░  ░░░░░      ░░░░░░   ░███░░░  ░░░░░░
                                                                                            ░███                         ░███
                                                                                            █████                        █████
                                                                                           ░░░░░                        ░░░░░
"""


def update_use_defaults(self, context):
    global updating
    if not updating:
        updating = True
        if self.use_defaults:
            self.liquid_resolution = True
            self.gas_resolution = True
            self.liquid_sim_speed = True
            self.gas_sim_speed = True
            self.gas_flow_type = True
            self.liquid_set_collection = True
            self.gas_set_collection = True
        else:
            self.liquid_resolution = False
            self.gas_resolution = False
            self.liquid_sim_speed = False
            self.gas_sim_speed = False
            self.gas_flow_type = False
            self.liquid_set_collection = False
            self.gas_set_collection = False
        updating = False


def update_collection_other(self, context):
    global updating
    updating = True
    if not (self.liquid_resolution and self.gas_resolution and self.liquid_sim_speed and self.gas_sim_speed and self.gas_flow_type and self.liquid_set_collection and self.gas_set_collection):
        self.use_defaults = False
    else:
        self.use_defaults = True
    updating = False


class CollectionProps(bpy.types.PropertyGroup):
    use_defaults: bpy.props.BoolProperty(
        name="use all defaults", default=False, update=update_use_defaults)

    use_materials: bpy.props.BoolProperty(name="use materials", default=True,
                                          description="adds the default material to domian objects on import")
    add_particles: bpy.props.BoolProperty(name="add particles", default=True,
                                          description="adds the default particle objects on import for liquid domains")

    liquid_resolution: bpy.props.BoolProperty(
        name="liquid resolution", default=True, update=update_collection_other)
    gas_resolution: bpy.props.BoolProperty(
        name="gas resolution", default=True, update=update_collection_other)
    liquid_sim_speed: bpy.props.BoolProperty(
        name="liquid sim speed", default=True, update=update_collection_other)
    gas_sim_speed: bpy.props.BoolProperty(
        name="gas sim speed", default=True, update=update_collection_other)
    gas_flow_type: bpy.props.BoolProperty(
        name="gas flow type", default=False, update=update_collection_other)
    liquid_set_collection: bpy.props.BoolProperty(
        name="liquid set collection", default=True, update=update_collection_other)
    gas_set_collection: bpy.props.BoolProperty(
        name="gas set collection", default=True, update=update_collection_other)


"""
                              ███           █████
                             ░░░           ░░███
 ████████   ██████   ███████ ████   █████  ███████    ██████  ████████
░░███░░███ ███░░███ ███░░███░░███  ███░░  ░░░███░    ███░░███░░███░░███
 ░███ ░░░ ░███████ ░███ ░███ ░███ ░░█████   ░███    ░███████  ░███ ░░░
 ░███     ░███░░░  ░███ ░███ ░███  ░░░░███  ░███ ███░███░░░   ░███
 █████    ░░██████ ░░███████ █████ ██████   ░░█████ ░░██████  █████
░░░░░      ░░░░░░   ░░░░░███░░░░░ ░░░░░░     ░░░░░   ░░░░░░  ░░░░░
                    ███ ░███
                   ░░██████
                    ░░░░░░
"""

classes = (
    CollectionProps,
)


def register():
    for i in classes:
        bpy.utils.register_class(i)
    bpy.types.Collection.MantaPro = bpy.props.PointerProperty(
        type=CollectionProps)


def unregister():
    for i in classes:
        bpy.utils.unregister_class(i)
    del bpy.types.Collection.MantaPro
