# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####
import bpy


"""
 ██████   ██████            █████                        ███            ████
░░██████ ██████            ░░███                        ░░░            ░░███
 ░███░█████░███   ██████   ███████    ██████  ████████  ████   ██████   ░███     ████████  ████████   ██████  ████████   █████
 ░███░░███ ░███  ░░░░░███ ░░░███░    ███░░███░░███░░███░░███  ░░░░░███  ░███    ░░███░░███░░███░░███ ███░░███░░███░░███ ███░░
 ░███ ░░░  ░███   ███████   ░███    ░███████  ░███ ░░░  ░███   ███████  ░███     ░███ ░███ ░███ ░░░ ░███ ░███ ░███ ░███░░█████
 ░███      ░███  ███░░███   ░███ ███░███░░░   ░███      ░███  ███░░███  ░███     ░███ ░███ ░███     ░███ ░███ ░███ ░███ ░░░░███
 █████     █████░░████████  ░░█████ ░░██████  █████     █████░░████████ █████    ░███████  █████    ░░██████  ░███████  ██████
░░░░░     ░░░░░  ░░░░░░░░    ░░░░░   ░░░░░░  ░░░░░     ░░░░░  ░░░░░░░░ ░░░░░     ░███░░░  ░░░░░      ░░░░░░   ░███░░░  ░░░░░░
                                                                                 ░███                         ░███
                                                                                 █████                        █████
                                                                                ░░░░░                        ░░░░░
"""


class MaterialProps(bpy.types.PropertyGroup):
    version: bpy.props.FloatProperty(
        name="Material version", default=1, min=1, precision=1)


"""
 ███████████                       █████     ███           ████
░░███░░░░░███                     ░░███     ░░░           ░░███
 ░███    ░███  ██████   ████████  ███████   ████   ██████  ░███   ██████     ████████  ████████   ██████  ████████   █████
 ░██████████  ░░░░░███ ░░███░░███░░░███░   ░░███  ███░░███ ░███  ███░░███   ░░███░░███░░███░░███ ███░░███░░███░░███ ███░░
 ░███░░░░░░    ███████  ░███ ░░░   ░███     ░███ ░███ ░░░  ░███ ░███████     ░███ ░███ ░███ ░░░ ░███ ░███ ░███ ░███░░█████
 ░███         ███░░███  ░███       ░███ ███ ░███ ░███  ███ ░███ ░███░░░      ░███ ░███ ░███     ░███ ░███ ░███ ░███ ░░░░███
 █████       ░░████████ █████      ░░█████  █████░░██████  █████░░██████     ░███████  █████    ░░██████  ░███████  ██████
░░░░░         ░░░░░░░░ ░░░░░        ░░░░░  ░░░░░  ░░░░░░  ░░░░░  ░░░░░░      ░███░░░  ░░░░░      ░░░░░░   ░███░░░  ░░░░░░
                                                                             ░███                         ░███
                                                                             █████                        █████
                                                                            ░░░░░                        ░░░░░
"""


class ParticleProps(bpy.types.PropertyGroup):
    is_ember: bpy.props.BoolProperty(default=False)


"""
                              ███           █████
                             ░░░           ░░███
 ████████   ██████   ███████ ████   █████  ███████    ██████  ████████
░░███░░███ ███░░███ ███░░███░░███  ███░░  ░░░███░    ███░░███░░███░░███
 ░███ ░░░ ░███████ ░███ ░███ ░███ ░░█████   ░███    ░███████  ░███ ░░░
 ░███     ░███░░░  ░███ ░███ ░███  ░░░░███  ░███ ███░███░░░   ░███
 █████    ░░██████ ░░███████ █████ ██████   ░░█████ ░░██████  █████
░░░░░      ░░░░░░   ░░░░░███░░░░░ ░░░░░░     ░░░░░   ░░░░░░  ░░░░░
                    ███ ░███
                   ░░██████
                    ░░░░░░
"""

classes = (
    MaterialProps,
    ParticleProps,
)


def register():
    for i in classes:
        bpy.utils.register_class(i)
    bpy.types.Material.MantaPro = bpy.props.PointerProperty(type=MaterialProps)
    bpy.types.ParticleSettings.MantaPro = bpy.props.PointerProperty(
        type=ParticleProps)


def unregister():
    for i in classes:
        bpy.utils.unregister_class(i)
    del bpy.types.Material.MantaPro
    del bpy.types.ParticleSettings.MantaPro
