# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####
import bpy
from . import uiCore


def get_icon(force_type: str):
    icon = "QUESTION"
    if force_type == "FLUID_FLOW":
        icon = "FORCE_FLUIDFLOW"
    elif force_type == "FORCE":
        icon = "FORCE_FORCE"
    elif force_type == "WIND":
        icon = "FORCE_WIND"
    elif force_type == "VORTEX":
        icon = "FORCE_VORTEX"
    elif force_type == "VORTEX":
        icon = "FORCE_VORTEX"
    elif force_type == "MAGNET":
        icon = "FORCE_MAGNETIC"
    elif force_type == "HARMONIC":
        icon = "FORCE_HARMONIC"
    elif force_type == "CHARGE":
        icon = "FORCE_CHARGE"
    elif force_type == "LENNARDJ":
        icon = "FORCE_LENNARDJONES"
    elif force_type == "TEXTURE":
        icon = "FORCE_TEXTURE"
    elif force_type == "GUIDE":
        icon = "FORCE_CURVE"
    elif force_type == "BOID":
        icon = "FORCE_BOID"
    elif force_type == "TURBULENCE":
        icon = "FORCE_TURBULENCE"
    elif force_type == "DRAG":
        icon = "FORCE_DRAG"

    return icon


def draw_add_menu(layout, operator):
    col = layout.column(align=True)
    if operator == "mantapro.add_force":
        col.operator(operator, text="Fluid Flow",
                     icon="FORCE_FLUIDFLOW").type = "FLUID"
    else:
        col.operator(operator, text="Fluid Flow",
                     icon="FORCE_FLUIDFLOW").type = "FLUID_FLOW"
    col.operator(operator, text="Force",
                 icon="FORCE_FORCE").type = "FORCE"
    col.operator(operator, text="Wind",
                 icon="FORCE_WIND").type = "WIND"

    col.operator(operator, text="Vortex",
                 icon="FORCE_VORTEX").type = "VORTEX"

    col.separator()
    # col.separator_spacer()
    col.separator()

    col.operator(operator, text="Magnetic",
                 icon="FORCE_MAGNETIC").type = "MAGNET"
    col.operator(operator, text="Harmonic",
                 icon="FORCE_HARMONIC").type = "HARMONIC"
    col.operator(operator, text="Charge",
                 icon="FORCE_CHARGE").type = "CHARGE"
    col.operator(operator, text="Lennard-Jones",
                 icon="FORCE_LENNARDJONES").type = "LENNARDJ"
    col.operator(operator, text="Texture",
                 icon="FORCE_TEXTURE").type = "TEXTURE"

    col.operator(operator, text="Curve Guide",
                 icon="FORCE_CURVE").type = "GUIDE"
    col.operator(operator, text="Boid",
                 icon="FORCE_BOID").type = "BOID"
    col.operator(operator, text="Turbulence",
                 icon="FORCE_TURBULENCE").type = "TURBULENCE"
    col.operator(operator, text="Drag",
                 icon="FORCE_DRAG").type = "DRAG"


def draw_falloff(self: uiCore.Core, settings):
    self.set_layout("col", align=True)
    self.label_prop(settings, "falloff_type", text="Shape")
    self.separator()

    self.label_prop(settings, "z_direction", text="Z Direction")
    self.separator()

    self.prop(settings, "falloff_power", text="Power")
    self.separator()

    self.icon_prop(settings, "use_min_distance")
    if settings.use_min_distance:
        self.prop(settings, "distance_min")

    self.separator()

    self.icon_prop(settings, "use_max_distance")
    if settings.use_max_distance:
        self.prop(settings, "distance_max")


def draw_falloff_radial(self: uiCore.Core, settings):
    self.set_layout("col", align=True)
    self.prop(settings, "radial_falloff")
    self.separator()

    self.icon_prop(settings, "use_radial_min")
    if settings.use_radial_min:
        self.prop(settings, "radial_min")

    self.separator()

    self.icon_prop(settings, "use_radial_max")
    if settings.use_radial_max:
        self.prop(settings, "radial_max")


def draw_kink(self: uiCore.Core, settings):
    self.set_layout("col", align=True)
    self.label_prop(settings, "guide_kink_type", text="Type")
    self.separator()
    if settings.guide_kink_type != "NONE":
        self.label_prop(settings, "guide_kink_axis", text="Axis")
        self.separator()
        self.prop(settings, "guide_kink_frequency")
        self.prop(settings, "guide_kink_shape")
        self.prop(settings, "guide_kink_amplitude")


def draw_fluid_flow(self: uiCore.Core, settings):
    self.set_layout("col", align=True)
    self.label_prop(settings, "shape", text="Shape")
    self.separator()
    self.prop(settings, "strength")
    self.prop(settings, "flow")
    self.separator()
    self.label_prop(settings, "source_object", text="Domain Object")
    self.separator()
    self.icon_prop(settings, "use_smoke_density")


def draw_force(self: uiCore.Core, settings):
    self.set_layout("col", align=True)
    self.label_prop(settings, "shape", text="Shape")
    self.separator()
    self.prop(settings, "strength")
    self.prop(settings, "flow")
    self.separator()
    self.icon_prop(settings, "apply_to_location")
    self.icon_prop(settings, "apply_to_rotation")
    self.separator()
    self.prop(settings, "noise")
    self.prop(settings, "seed")
    self.separator()
    self.icon_prop(settings, "use_gravity_falloff")
    self.icon_prop(settings, "use_absorption")
    self.separator()
    self.prop(settings, "wind_factor", slider=True)


def draw_wind(self: uiCore.Core, settings):
    self.set_layout("col", align=True)
    self.label_prop(settings, "shape", text="Shape")
    self.separator()
    self.prop(settings, "strength")
    self.prop(settings, "flow")
    self.separator()
    self.icon_prop(settings, "apply_to_location")
    self.icon_prop(settings, "apply_to_rotation")
    self.separator()
    self.prop(settings, "noise")
    self.prop(settings, "seed")
    self.separator()
    self.icon_prop(settings, "use_absorption")
    self.separator()
    self.prop(settings, "wind_factor", slider=True)


def draw_vortex(self: uiCore.Core, settings):
    self.set_layout("col", align=True)
    self.label_prop(settings, "shape", text="Shape")
    self.separator()
    self.prop(settings, "strength")
    self.prop(settings, "flow")
    self.separator()
    self.icon_prop(settings, "apply_to_location")
    self.icon_prop(settings, "apply_to_rotation")
    self.separator()
    self.prop(settings, "noise")
    self.prop(settings, "seed")
    self.separator()
    self.icon_prop(settings, "use_absorption")
    self.separator()
    self.prop(settings, "wind_factor", slider=True)


def draw_magnet(self: uiCore.Core, settings):
    self.set_layout("col", align=True)
    self.label_prop(settings, "shape", text="Shape")
    self.separator()
    self.prop(settings, "strength")
    self.prop(settings, "flow")
    self.separator()
    self.icon_prop(settings, "apply_to_location")
    self.icon_prop(settings, "apply_to_rotation")
    self.separator()
    self.prop(settings, "noise")
    self.prop(settings, "seed")
    self.separator()
    self.icon_prop(settings, "use_absorption")
    self.separator()
    self.prop(settings, "wind_factor", slider=True)


def draw_harmonic(self: uiCore.Core, settings):
    self.set_layout("col", align=True)
    self.label_prop(settings, "shape", text="Shape")
    self.separator()
    self.prop(settings, "strength")
    self.separator()
    self.prop(settings, "harmonic_damping", text="Damping")
    self.prop(settings, "rest_length")
    self.separator()
    self.icon_prop(settings, "apply_to_location")
    self.icon_prop(settings, "apply_to_rotation")
    self.separator()
    self.prop(settings, "noise")
    self.prop(settings, "seed")
    self.separator()
    self.icon_prop(settings, "use_multiple_springs")
    self.separator()
    self.icon_prop(settings, "use_absorption")
    self.separator()
    self.prop(settings, "wind_factor", slider=True)


def draw_charge(self: uiCore.Core, settings):
    self.set_layout("col", align=True)
    self.label_prop(settings, "shape", text="Shape")
    self.separator()
    self.prop(settings, "strength")
    self.prop(settings, "flow")
    self.separator()
    self.icon_prop(settings, "apply_to_location")
    self.icon_prop(settings, "apply_to_rotation")
    self.separator()
    self.prop(settings, "noise")
    self.prop(settings, "seed")
    self.separator()
    self.icon_prop(settings, "use_absorption")
    self.separator()
    self.prop(settings, "wind_factor", slider=True)


def draw_LJ(self: uiCore.Core, settings):
    self.set_layout("col", align=True)
    self.label_prop(settings, "shape", text="Shape")
    self.separator()
    self.prop(settings, "strength")
    self.prop(settings, "flow")
    self.separator()
    self.icon_prop(settings, "apply_to_location")
    self.icon_prop(settings, "apply_to_rotation")
    self.separator()
    self.prop(settings, "noise")
    self.prop(settings, "seed")
    self.separator()
    self.icon_prop(settings, "use_absorption")
    self.separator()
    self.prop(settings, "wind_factor", slider=True)


def draw_texture(self: uiCore.Core, settings):
    self.set_layout("col", align=True)
    self.label_prop(settings, "texture_mode", text="Texture Mode")
    self.separator()
    self.prop(settings, "strength")
    self.prop(settings, "texture_nabla")
    self.separator()
    self.icon_prop(settings, "use_object_coords")
    self.icon_prop(settings, "use_2d_force")


def draw_guide(self: uiCore.Core, settings):
    self.set_layout("col", align=True)

    self.prop(settings, "guide_minimum")
    self.prop(settings, "guide_free")
    self.prop(settings, "falloff_power")
    self.separator()
    self.icon_prop(settings, "use_guide_path_add")
    self.icon_prop(settings, "use_guide_path_weight")
    self.separator()
    self.prop(settings, "guide_clump_amount")
    self.prop(settings, "guide_clump_shape")
    self.separator()
    self.icon_prop(settings, "use_max_distance")
    if settings.use_max_distance:
        self.prop(settings, "distance_max")


def draw_boid(self: uiCore.Core, settings):
    self.set_layout("col", align=True)
    self.label_prop(settings, "shape", text="Shape")
    self.separator()
    self.prop(settings, "strength")
    self.prop(settings, "flow")
    self.separator()
    self.icon_prop(settings, "apply_to_location")
    self.icon_prop(settings, "apply_to_rotation")
    self.separator()
    self.prop(settings, "noise")
    self.prop(settings, "seed")
    self.separator()
    self.icon_prop(settings, "use_absorption")
    self.separator()
    self.prop(settings, "wind_factor", slider=True)


def draw_turbulence(self: uiCore.Core, settings):
    self.set_layout("col", align=True)
    self.label_prop(settings, "shape", text="Shape")
    self.separator()
    self.prop(settings, "strength")
    self.prop(settings, "flow")
    self.separator()
    self.prop(settings, "size")
    self.separator()
    self.icon_prop(settings, "apply_to_location")
    self.icon_prop(settings, "apply_to_rotation")
    self.separator()
    self.prop(settings, "noise")
    self.prop(settings, "seed")
    self.separator()
    self.icon_prop(settings, "use_global_coords")
    self.separator()
    self.icon_prop(settings, "use_absorption")
    self.separator()
    self.prop(settings, "wind_factor", slider=True)


def draw_drag(self: uiCore.Core, settings):
    self.set_layout("col", align=True)
    self.label_prop(settings, "shape", text="Shape")
    self.separator()
    self.prop(settings, "linear_drag", text="Linear")
    self.prop(settings, "quadratic_drag", text="Quadratic")
    self.separator()
    self.icon_prop(settings, "apply_to_location")
    self.icon_prop(settings, "apply_to_rotation")
    self.separator()
    self.prop(settings, "noise")
    self.prop(settings, "seed")
    self.separator()
    self.icon_prop(settings, "use_absorption")
    self.separator()
    self.prop(settings, "wind_factor", slider=True)
