# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####


import bpy


def find_modifier(obj):
    # return obj.modifiers["Fluid"]
    if obj:
        for modifier in obj.modifiers:
            if modifier.type == "FLUID":
                return modifier
    return None


def check_category(obj):
    """check and return the type of object it is (LIQUID, GAS, COLLISTION, SMOKE, etc...)"""
    if obj:
        settings = find_modifier(obj)
        if settings:
            if settings.fluid_type == "DOMAIN":
                return settings.domain_settings.domain_type
            elif settings.fluid_type == "FLOW":
                return settings.flow_settings.flow_type
            elif settings.fluid_type == "EFFECTOR":
                return settings.effector_settings.effector_type
    return None


def check_type_gas(obj, kind):
    """check for a modifier of a kind and if type is gas"""
    if not obj:
        return False

    modifier = find_modifier(obj)
    if modifier:
        if modifier.fluid_type == kind:

            if kind == "EFFECTOR":
                return True

            elif kind == "DOMAIN":
                if modifier.domain_settings.domain_type == 'GAS':
                    return True

            elif kind == "FLOW":
                if modifier.flow_settings.flow_type != 'LIQUID':
                    return True
    return False


def check_type_liquid(obj, kind):
    """check for a modifier of a kind and if type is liquid"""
    if not obj:
        return False

    if find_modifier(obj):
        if find_modifier(obj).fluid_type == kind:

            if kind == "EFFECTOR":
                return True

            elif kind == "DOMAIN":
                if find_modifier(obj).domain_settings.domain_type == 'LIQUID':
                    return True

            elif kind == "FLOW":
                if find_modifier(obj).flow_settings.flow_type == 'LIQUID':
                    return True
    return False


def get_modifier_domain(context=None, domain=None):
    """get domain modifier settings"""
    modifier_settings = None

    if domain:
        modifier_settings = find_modifier(domain).domain_settings

    elif context:
        domain = context.scene.MantaPro.active_domain
        if domain:
            modifier_settings = find_modifier(domain).domain_settings

    return modifier_settings


def find_ember_modifier(flow):
    for i in flow.modifiers:
        if i.type == "PARTICLE_SYSTEM":
            if i.particle_system.settings.MantaPro.is_ember:
                return i
    return None
