# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####
from .. import preferences
from . import modifiers


def UI_BLENDER() -> bool:
    ui_mode = preferences.get_preferences().ui_mode
    return ui_mode == 'BLENDER'


def UI_DEFAULT() -> bool:
    ui_mode = preferences.get_preferences().ui_mode
    return ui_mode == 'DEFAULT'


def UI_SIMPLIFIED() -> bool:
    ui_mode = preferences.get_preferences().ui_mode
    return ui_mode == 'SIMPLIFIED'


def DOMAIN(context) -> bool:
    return bool(modifiers.get_modifier_domain(context))


def FLOW(context) -> bool:
    if context.scene.MantaPro.active_flow:
        if modifiers.check_type_gas(context.scene.MantaPro.active_flow, "FLOW"):
            return True
        if modifiers.check_type_liquid(context.scene.MantaPro.active_flow, "FLOW"):
            return True
    return False


def FLOW_OUTFLOW(context) -> bool:
    modifier = modifiers.find_modifier(context.scene.MantaPro.active_flow).flow_settings
    return modifier.flow_behavior == "OUTFLOW"


def DOMAIN_GAS(context) -> bool:
    return modifiers.check_type_gas(context.scene.MantaPro.active_domain, "DOMAIN")


def DOMAIN_LIQUID(context) -> bool:
    return modifiers.check_type_liquid(context.scene.MantaPro.active_domain, "DOMAIN")


def FLOW_GAS(context) -> bool:
    return modifiers.check_type_gas(context.scene.MantaPro.active_flow, "FLOW")


def FLOW_LIQUID(context) -> bool:
    return modifiers.check_type_liquid(context.scene.MantaPro.active_flow, "FLOW")
