# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####

import bpy
from .. import preferences


class Core(bpy.types.Panel):
    MP_order_id = 0

    def __init__(self):
        self.ui_layout = self.layout
        self._ui_type = ["col", False, False]
        self._disabled = False

        if preferences.get_preferences().dev and bpy.context.scene.MantaPro.DEV.show_panel_id:
            self.dev = True
        else:
            self.dev = False
        if self.dev:
            self.ui_layout.label(text=str(self.MP_order_id))

    def set_layout(self, kind: str, align=False, reset=False, boxed=False):
        try:
            enabled = self.ui_layout.enabled
        except AttributeError:
            enabled = True

        if kind == 'col':
            if boxed:
                self.ui_layout = self.layout.box().column(align=align)
            else:
                self.ui_layout = self.layout.column(align=align)
        elif kind == 'row':
            if boxed:
                self.ui_layout = self.layout.box().row(align=align)
            else:
                self.ui_layout = self.layout.row(align=align)
        self._ui_type = [kind, align, boxed]

        if not enabled and not reset:
            self.enabled(False)

        if self._disabled:
            self.enabled(False)

    def ui_refresh(self):
        enabled = self.ui_layout.enabled
        self.set_layout(self._ui_type[0],
                        self._ui_type[1], boxed=self._ui_type[2])

        if not enabled:
            self.enabled(False)

    def ui_reset(self):
        self.set_layout(
            self._ui_type[0], self._ui_type[1], reset=True, boxed=self._ui_type[2])

    def prop(self, data, prop: str, text=None, icon="NONE", icon_only=False, invert_checkbox=False, slider=False, correct_slider=True):
        if text and slider and correct_slider:
            text = "  " + text
        self.ui_layout.prop(data, prop, text=text, icon=icon,
                            icon_only=icon_only, invert_checkbox=invert_checkbox, slider=slider)

    def icon_prop(self, data, prop: str,  text="", icon_on="CHECKBOX_HLT", icon_off="CHECKBOX_DEHLT", icon_only=False, invert=False):
        # TODO consider changing icons to icon_on="CHECKBOX_HLT", icon_off="CHECKBOX_DEHLT" maybe using a poll
        """draws a property with a icon"""
        if eval("data." + prop):
            icon = icon_on
        else:
            icon = icon_off

        if text:
            self.ui_layout.prop(data, prop, icon=icon,
                                text=text, invert_checkbox=invert)
        else:
            self.ui_layout.prop(data, prop, icon=icon,
                                icon_only=icon_only, invert_checkbox=invert)

    def label_prop(self, data, prop: str, text="", label_icon="NONE", prop_icon="NONE"):
        if not text:
            text = prop.replace("_", " ").capitalize()
        else:
            text += ":"
        self.label(text=text, icon=label_icon)
        self.prop(data, prop, text="", icon=prop_icon)

    def material_prop(self, prop, text: str = None):
        if text is None:
            text = prop.node.name + " " + prop.name
        self.prop(prop, "default_value", text=text)

    def label_material_prop(self, prop, text: str = None, icon="NONE"):
        if text is None:
            text = prop.node.name + " " + prop.name
        if type(icon) == str:
            self.label(text=text, icon=icon)
        else:
            self.label(text=text, icon_value=icon)
        self.material_prop(prop, text="")

    def prop_search(self, data, prop, search_data, search_prop, text=None, icon="NONE"):
        self.ui_layout.prop_search(
            data, prop, search_data, search_prop, text=text, icon=icon)

    def _operator_settings(self, operator: str, settings: list, text=None, icon="NONE"):
        op = self.operator(operator, text=text, icon=icon)

        for i in settings:
            if i[1] == True or i[1] == False:
                action = "op." + str(i[0]) + " = " + str(i[1])
            else:
                action = "op." + str(i[0]) + " = '" + str(i[1]) + "'"
            exec(action)
            return op

    def operator(self, operator: str, text=None, icon="NONE", settings=None):
        if settings is None:
            if type(icon) == str:
                return self.ui_layout.operator(operator, text=text, icon=icon)
            else:
                return self.ui_layout.operator(operator, text=text, icon_value=icon)
        else:
            if type(icon) == str:
                return self._operator_settings(operator, text=text, icon=icon, settings=settings)
            else:
                return self._operator_settings(operator, text=text, icon_value=icon, settings=settings)

    def label(self, text="", icon="NONE"):
        if type(icon) == str:
            self.ui_layout.label(text=text, icon=icon)
        else:
            self.ui_layout.label(text=text, icon_value=icon)

    def separator(self, factor=1.0):
        self.ui_layout.separator(factor=factor)

    def separator_spacer(self):
        self.ui_layout.separator_spacer()

    def enabled(self, val=True):
        if self._disabled and val:
            return
        self.ui_layout.enabled = val

    def force_disable(self, val=True):
        self.ui_layout.enabled = not val
        self._disabled = val

    def ui(self):
        return self.ui_layout

    def alert(self, value=True):
        self.ui_layout.alert = value
