# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####


import bpy
from ..Shared import uiCore


def draw_color(self: uiCore.Core, texture):
    self.set_layout("col", align=True)
    self.icon_prop(texture, "use_clamp")
    self.separator()
    self.label("Multiply")
    self.prop(texture, "factor_red", text="R")
    self.prop(texture, "factor_green", text="G")
    self.prop(texture, "factor_blue", text="B")

    self.separator()
    self.set_layout("col")
    self.prop(texture, "intensity")
    self.prop(texture, "contrast")
    self.prop(texture, "saturation")

    self.separator()
    self.set_layout("col")
    self.icon_prop(texture, "use_color_ramp")
    if texture.use_color_ramp:
        self.ui_layout.template_color_ramp(texture, "color_ramp", expand=False)


def ui(self: uiCore.Core, texture):
    self.set_layout("col")
    self.label_prop(texture, "type")
    self.separator()

    if texture.type == "BLEND":
        blend(self, texture)
    elif texture.type == "CLOUDS":
        clouds(self, texture)
    elif texture.type == 'DISTORTED_NOISE':
        distorted_noise(self, texture)
    elif texture.type == "IMAGE":
        image(self, texture)
    elif texture.type == "MAGIC":
        magic(self, texture)
    elif texture.type == "MARBLE":
        marble(self, texture)
    elif texture.type == "MUSGRAVE":
        musgrave(self, texture)
    elif texture.type == "NOISE":
        noise(self, texture)
    elif texture.type == "STUCCI":
        stucci(self, texture)
    elif texture.type == "VORONOI":
        voronoi(self, texture)
    elif texture.type == "WOOD":
        wood(self, texture)


def blend(self: uiCore.Core, texture):
    self.set_layout("col", boxed=True)

    self.label_prop(texture, "progression")

    self.label_prop(texture, "use_flip_axis", text="Orientation")


def clouds(self: uiCore.Core, texture):
    self.set_layout("col", boxed=True)

    self.label_prop(texture, "noise_basis", text="Noise Basis")
    self.label_prop(texture, "noise_type", text="Noise Type")
    self.set_layout("col")
    self.label_prop(texture, "cloud_type", text="Color")
    self.separator()

    self.set_layout("col", align=True)
    self.prop(texture, "noise_scale")
    self.prop(texture, "noise_depth")
    self.prop(texture, "nabla")


def distorted_noise(self: uiCore.Core, texture):
    self.set_layout("col", boxed=True)

    self.label_prop(texture, "noise_basis", text="Noise Basis")
    self.label_prop(texture, "noise_distortion", text="Noise Distortion")
    self.separator()

    self.set_layout("col", align=True)
    self.prop(texture, "distortion")
    self.prop(texture, "noise_scale")
    self.prop(texture, "nabla")


def image(self: uiCore.Core, texture):
    self.set_layout("col")

    self.ui_layout.template_image(texture, "image", texture.image_user)


def magic(self: uiCore.Core, texture):
    self.set_layout("col", align=True)

    self.prop(texture, "noise_depth")
    self.prop(texture, "turbulence")


def marble(self: uiCore.Core, texture):
    self.set_layout("col", align=True, boxed=True)

    self.label_prop(texture, "noise_basis", text="Noise Basis")
    self.separator()
    self.label_prop(texture, "marble_type", text="Pattern")

    self.set_layout("col", align=True, boxed=True)
    self.label_prop(texture, "noise_basis_2", text="Noise Basis 2")
    self.label_prop(texture, "noise_type", text="Noise Type")
    self.separator()

    self.set_layout("col", align=True)
    self.prop(texture, "noise_scale")
    self.prop(texture, "noise_depth")
    self.prop(texture, "turbulence")
    self.prop(texture, "nabla")


def musgrave(self: uiCore.Core, texture):
    self.set_layout("col", boxed=True)

    self.label_prop(texture, "noise_basis", text="Noise Basis")

    self.label_prop(texture, "musgrave_type",  text="Type")
    self.separator()

    self.set_layout("col", align=True)
    self.prop(texture, "noise_scale")
    self.prop(texture, "nabla")
    self.separator()

    self.set_layout("col", align=True)
    self.prop(texture, "dimension_max")
    self.prop(texture, "lacunarity")
    self.prop(texture, "octaves")
    self.separator()

    self.set_layout("col", align=True)
    self.prop(texture, "noise_intensity")
    self.separator()


def noise(self: uiCore.Core, texture):
    self.set_layout("col")


def stucci(self: uiCore.Core, texture):
    self.set_layout("col", boxed=True)

    self.label_prop(texture, "noise_basis", text="Noise Basis")

    self.label_prop(texture, "stucci_type", text="Type")

    self.set_layout("col")
    self.label_prop(texture, "noise_type", text="Noise Type")
    self.separator()

    self.set_layout("col", align=True)
    self.prop(texture, "noise_scale")
    self.prop(texture, "turbulence")


def voronoi(self: uiCore.Core, texture):
    self.set_layout("col")

    self.label_prop(texture, "distance_metric", text="Distance Metric")
    if texture.distance_metric == "MINKOVSKY":
        self.prop(texture, "minkovsky_exponent")
    self.separator()

    self.set_layout("col")
    self.label_prop(texture, "color_mode", text="Coloring")
    self.prop(texture, "noise_intensity")

    self.separator()

    self.set_layout("col", align=True)

    self.prop(texture, "noise_scale")
    self.prop(texture, "nabla")

    self.set_layout("col", align=True)
    self.label(text="Feature Weights")

    self.prop(texture, "weight_1", text="First", slider=True)
    self.prop(texture, "weight_2", text="Second", slider=True)
    self.prop(texture, "weight_3", text="Third", slider=True)
    self.prop(texture, "weight_4", text="Fourth", slider=True)


def wood(self: uiCore.Core, texture):
    self.set_layout("col", boxed=True)

    self.label_prop(texture, "noise_basis", text="Noise Basis")

    self.label_prop(texture, "wood_type", text="Pattern")

    self.set_layout("col", align=True, boxed=True)
    self.label_prop(texture, "noise_basis_2", text="Noise Basis 2")

    if texture.wood_type == "BANDNOISE" or texture.wood_type == "RINGNOISE":
        self.label_prop(texture, "noise_type", text="Noise Type")
        self.separator()

        self.set_layout("col", align=True)
        self.prop(texture, "noise_scale")
        self.prop(texture, "turbulence")
        self.prop(texture, "nabla")
