# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####
import bpy

from . import Optimizer
from . import preferences
from . import Props
from . import QuickSetup
from . import Icons
from . import Shared

from . import Liquid
from . import Gas

from . import Panels

bl_info = {
    "name": "MantaPro",
    "author": "Reston Stanton",
    "description": "Mantaflow simulation tools",
    "blender": (2, 93, 0),
    "version": (1, 2, 0),
    "location": "3DView > sidebar > MantaPro",
    "warning": "",  # TODO remove warning
    'support': 'COMMUNITY',
    'tracker_url': 'https://blendermarket.com/products/mantapro',
    "category": "Simulation"
}


# bpy.app.handlers.


def register():
    Optimizer.register()
    Shared.register()

    QuickSetup.register()
    Icons.register()
    preferences.register()

    Props.register()

    Gas.register()
    Liquid.register()

    Panels.register()


def unregister():
    Optimizer.unregister()
    Shared.unregister()

    QuickSetup.unregister()
    Icons.unregister()
    preferences.unregister()

    Props.unregister()

    Gas.unregister()
    Liquid.unregister()

    Panels.unregister()


# bug {AttributeError: module '__main__' has no attribute 'mVel_mesh5'} note different numbers at different times
