/*
 * Decompiled with CFR 0.152.
 */
package maqetta.zazl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import maqetta.zazl.MaqettaHTMLFilter;
import maqetta.zazl.MaqettaOSGiResourceLoader;
import org.davinci.ajaxLibrary.Library;
import org.dojotoolkit.compressor.JSCompressorFactory;
import org.dojotoolkit.compressor.shrinksafe.ShrinksafeJSCompressorFactory;
import org.dojotoolkit.optimizer.JSOptimizerFactory;
import org.dojotoolkit.optimizer.amd.rhinoast.AMDJSOptimizerFactory;
import org.dojotoolkit.optimizer.servlet.JSServlet;
import org.dojotoolkit.server.util.resource.ResourceLoader;
import org.dojotoolkit.server.util.rhino.RhinoClassLoader;
import org.eclipse.equinox.http.registry.HttpContextExtensionService;
import org.eclipse.equinox.http.servlet.ExtendedHttpService;
import org.maqetta.server.ServerManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private BundleContext bundleContext = null;
    private ServiceTracker httpServiceTracker = null;
    private ServiceReference httpServiceReference = null;
    private HttpContextExtensionService httpContextExtensionService = null;
    private ExtendedHttpService httpService = null;
    private HttpContext httpContext = null;
    private String httpContextName = "maqetta.core.server.httpcontext";
    private boolean registered = false;
    private Filter maqettaHTMLFilter = null;

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        this.httpServiceTracker = new HttpServiceTracker(bundleContext);
        this.httpServiceTracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.httpServiceTracker.close();
        this.httpServiceTracker = null;
        this.bundleContext = null;
    }

    protected boolean register() {
        if (!this.registered && this.httpService != null) {
            Library[] libraries;
            String[] bundleIds = new String[]{"org.json.js", "org.dojotoolkit.server.util.js", "org.dojotoolkit.optimizer.amd", "org.dojotoolkit.optimizer.servlet"};
            ArrayList<Library> srcLibraryList = new ArrayList<Library>();
            Library[] libraryArray = libraries = ServerManager.getServerManager().getLibraryManager().getAllLibraries();
            int n = libraries.length;
            int n2 = 0;
            while (n2 < n) {
                Library library = libraryArray[n2];
                if (library.getSourcePath() != null) {
                    srcLibraryList.add(library);
                }
                ++n2;
            }
            MaqettaOSGiResourceLoader resourceLoader = new MaqettaOSGiResourceLoader(this.bundleContext, bundleIds, ServerManager.getServerManager().getUserManager(), srcLibraryList);
            RhinoClassLoader rhinoClassLoader = new RhinoClassLoader((ResourceLoader)resourceLoader);
            ShrinksafeJSCompressorFactory jsCompressorFactory = null;
            Boolean jscompress = Boolean.valueOf(System.getProperty("maqetta.zazl.jscompress", "false"));
            if (jscompress.booleanValue()) {
                jsCompressorFactory = new ShrinksafeJSCompressorFactory();
            }
            AMDJSOptimizerFactory jsOptimizerFactory = new AMDJSOptimizerFactory();
            JSServlet jsServlet = new JSServlet((ResourceLoader)resourceLoader, (JSOptimizerFactory)jsOptimizerFactory, rhinoClassLoader, "zazl", null, null, (JSCompressorFactory)jsCompressorFactory);
            this.maqettaHTMLFilter = new MaqettaHTMLFilter(resourceLoader);
            try {
                System.out.println("Registering Zazl JavaScript servlet");
                this.httpService.registerServlet("/_javascript", (Servlet)jsServlet, null, null);
                System.out.println("Registering Maqetta HTML Filter for Zazl");
                Hashtable<String, String> initParams = new Hashtable<String, String>();
                ((Dictionary)initParams).put("filter-priority", "1");
                this.httpService.registerFilter("/maqetta/user/*.html", this.maqettaHTMLFilter, initParams, null);
                this.registered = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.registered;
    }

    private class HttpContextExtensionServiceTracker
    extends ServiceTracker {
        public HttpContextExtensionServiceTracker(BundleContext context) {
            super(context, HttpContextExtensionService.class.getName(), null);
        }

        public Object addingService(ServiceReference reference) {
            Activator.this.httpContextExtensionService = (HttpContextExtensionService)this.context.getService(reference);
            Activator.this.register();
            return Activator.this.httpContextExtensionService;
        }
    }

    private class HttpServiceTracker
    extends ServiceTracker {
        public HttpServiceTracker(BundleContext context) {
            super(context, ExtendedHttpService.class.getName(), null);
        }

        public Object addingService(ServiceReference reference) {
            Activator.this.httpServiceReference = reference;
            Activator.this.httpService = (ExtendedHttpService)this.context.getService(reference);
            Activator.this.register();
            return Activator.this.httpService;
        }

        public void removedService(ServiceReference reference, Object service) {
            if (Activator.this.registered) {
                Activator.this.httpService.unregister("/_javascript");
                Activator.this.httpService.unregisterFilter(Activator.this.maqettaHTMLFilter);
            }
            super.removedService(reference, service);
        }
    }
}

