/*
 * Decompiled with CFR 0.152.
 */
package maqetta.zazl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.filters.DefaultFilter;
import org.cyberneko.html.filters.Identity;
import org.cyberneko.html.filters.Writer;
import org.dojotoolkit.json.JSONParser;

public class HTMLParser
extends DefaultFilter {
    private static final String AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    private static final String FILTERS = "http://cyberneko.org/html/properties/filters";
    private static final String SCRIPT_TYPE = "text/javascript";
    private static final String WS_WORKSPACE = "/ws/workspace";
    private static final Pattern packagesRegex = Pattern.compile("'packages':\\[(\\{'name':'.+','location':'.+'\\})+\\]");
    private HTMLConfiguration parser = null;
    private String encoding = null;
    private String scriptURLPrefix = null;
    private String scriptURL = null;
    private String configScriptTag = null;
    private String dojoLoaderPath = null;
    private String zazlPath = null;

    public HTMLParser(java.io.Writer out, String encoding, String configScriptTag, String pathInfo) {
        String projectPath = pathInfo.substring(pathInfo.indexOf(WS_WORKSPACE) + WS_WORKSPACE.length());
        projectPath = projectPath.substring(0, projectPath.lastIndexOf(47));
        int removeCount = projectPath.indexOf("WebContent") == -1 ? 1 : 2;
        boolean isReview = projectPath.indexOf("/.review") != -1;
        int segCount = isReview ? 0 : HTMLParser.countSegments(projectPath) - removeCount;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < segCount) {
            sb.append("../");
            ++i;
        }
        sb.append("lib/zazl/zazl.js");
        this.zazlPath = sb.toString();
        this.encoding = encoding;
        this.configScriptTag = configScriptTag;
        this.parser = new HTMLConfiguration();
        this.parser.setFeature(AUGMENTATIONS, true);
        XMLDocumentFilter[] filters = new XMLDocumentFilter[]{this, new Identity(), new HTMLWriter(out, this.encoding)};
        this.parser.setProperty(FILTERS, (Object)filters);
    }

    public void parse(String html) throws IOException {
        this.parser.parse(new XMLInputSource(null, "", null, (Reader)new StringReader(html), this.encoding));
    }

    public void startDocument(XMLLocator locator, String encoding, Augmentations augs) throws XNIException {
        super.startDocument(locator, encoding, augs);
    }

    public void startElement(QName element, XMLAttributes attrs, Augmentations augs) throws XNIException {
        String src;
        String value;
        if (element.rawname.equalsIgnoreCase("script") && attrs != null && (value = attrs.getValue("type")) != null && value.equalsIgnoreCase(SCRIPT_TYPE) && (src = attrs.getValue("src")) != null && src.indexOf("/dojo/dojo.js") != -1) {
            this.scriptURL = src;
            this.scriptURLPrefix = this.scriptURL.substring(0, this.scriptURL.indexOf("/dojo/dojo.js"));
            this.dojoLoaderPath = this.scriptURL.substring(0, this.scriptURL.lastIndexOf(47) + 1);
            this.configScriptTag = this.configScriptTag.replace("__URLPREFIX__", this.scriptURLPrefix);
        }
        super.startElement(element, attrs, augs);
    }

    private static String normalize(String path) {
        try {
            URI uri = new URI(path);
            String normalized = uri.normalize().toString();
            return normalized;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static int countSegments(String path) {
        int count = 0;
        int i = 0;
        while (i < path.length()) {
            if (path.charAt(i) == '/') {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public class HTMLWriter
    extends Writer {
        PrintWriter pw;

        public HTMLWriter(java.io.Writer out, String encoding) {
            super(out, encoding);
            this.pw = null;
        }

        protected void printStartElement(QName element, XMLAttributes attrs) throws XNIException {
            if (element.rawname.equalsIgnoreCase("script") && attrs != null) {
                String value = attrs.getValue("type");
                if (value != null && value.equalsIgnoreCase(HTMLParser.SCRIPT_TYPE)) {
                    String src = attrs.getValue("src");
                    if (src != null && src.equals(HTMLParser.this.scriptURL)) {
                        String packagesString;
                        attrs.setValue(attrs.getIndex("src"), HTMLParser.this.zazlPath);
                        String dojoDataConfigStr = attrs.getValue(attrs.getIndex("data-dojo-config"));
                        HTMLParser.this.configScriptTag = HTMLParser.this.configScriptTag.replace("__DOJOCONFIG__", "{" + dojoDataConfigStr + "}");
                        attrs.removeAttributeAt(attrs.getIndex("data-dojo-config"));
                        Matcher m = packagesRegex.matcher(dojoDataConfigStr);
                        if (m.find() && (packagesString = m.group(0)) != null) {
                            StringBuffer sb = new StringBuffer();
                            try {
                                Map packages = (Map)JSONParser.parse((Reader)new StringReader(String.valueOf('{') + packagesString + '}'));
                                List packageList = (List)packages.get("packages");
                                for (Map pkg : packageList) {
                                    String name = (String)pkg.get("name");
                                    if (name.equals("zazl")) continue;
                                    String location = (String)pkg.get("location");
                                    location = HTMLParser.normalize(String.valueOf(HTMLParser.this.dojoLoaderPath) + location);
                                    sb.append("\t\t'");
                                    sb.append(name);
                                    sb.append("' : '");
                                    sb.append(location);
                                    sb.append("',\n");
                                }
                                sb.deleteCharAt(sb.length() - 1);
                                sb.deleteCharAt(sb.length() - 1);
                                HTMLParser.this.configScriptTag = HTMLParser.this.configScriptTag.replace("__PATHS__", sb.toString());
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    super.printStartElement(element, attrs);
                } else {
                    super.printStartElement(element, attrs);
                }
            } else {
                super.printStartElement(element, attrs);
            }
        }

        protected void printEndElement(QName element) throws XNIException {
            super.printEndElement(element);
            if (element.rawname.equalsIgnoreCase("script") && HTMLParser.this.scriptURL != null && HTMLParser.this.scriptURL.indexOf("/dojo/dojo.js") != -1) {
                this.fPrinter.println();
                this.fPrinter.println(HTMLParser.this.configScriptTag);
                HTMLParser.this.scriptURL = null;
            }
        }

        protected void printAttributeValue(String text) {
            int length = text.length();
            int j = 0;
            while (j < length) {
                char c = text.charAt(j);
                switch (c) {
                    case '\"': {
                        this.fPrinter.print("&quot;");
                        break;
                    }
                    case '<': {
                        this.fPrinter.print("&lt;");
                        break;
                    }
                    case '>': {
                        this.fPrinter.print("&gt;");
                        break;
                    }
                    case '&': {
                        this.fPrinter.print("&amp;");
                        break;
                    }
                    default: {
                        this.fPrinter.print(c);
                    }
                }
                ++j;
            }
            this.fPrinter.flush();
        }
    }
}

