/*
 * Decompiled with CFR 0.152.
 */
package maqetta.core.server.command;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.SimpleTimeZone;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import maqetta.core.server.user.DavinciProject;
import maqetta.core.server.user.ReviewManager;
import org.davinci.server.review.Comment;
import org.davinci.server.review.Utils;
import org.davinci.server.review.Version;
import org.davinci.server.review.cache.ReviewCacheManager;
import org.davinci.server.review.user.IDesignerUser;
import org.davinci.server.user.IUser;
import org.davinci.server.user.IUserManager;
import org.davinci.server.user.UserException;
import org.eclipse.orion.server.useradmin.UserEmailUtil;
import org.json.JSONException;
import org.json.JSONObject;
import org.maqetta.server.Command;
import org.maqetta.server.ServerManager;

public class AddComment
extends Command {
    private static final Logger theLogger = Logger.getLogger(AddComment.class.getName());

    public void handleCommand(HttpServletRequest req, HttpServletResponse resp, IUser user) throws IOException {
        Comment comment = this.extractComment(req);
        IUserManager userManager = ServerManager.getServerManager().getUserManager();
        String designerName = comment.getDesignerId();
        IUser designer = null;
        try {
            designer = ServerManager.LOCAL_INSTALL && "maqettaUser".equalsIgnoreCase(designerName) ? userManager.getUser("maqettaUser") : userManager.getUser(designerName);
        }
        catch (UserException e) {
            this.errorString = "Failure getting user for 'designer'. Reason: " + e.getMessage();
            theLogger.severe(this.errorString);
            return;
        }
        DavinciProject project = new DavinciProject();
        project.setOwnerId(designer.getUserID());
        comment.setProject(project);
        comment.setEmail(user.getPerson().getEmail());
        IDesignerUser du = ReviewManager.getReviewManager().getDesignerUser(designerName);
        Version version = du.getVersion(comment.getPageVersion());
        if (version != null && version.isClosed()) {
            this.errorString = "The version was closed by another user while editing. Please reload the review data.";
            return;
        }
        ArrayList<Comment> commentList = new ArrayList<Comment>(1);
        commentList.add(comment);
        ReviewCacheManager.$.updateComments(commentList);
        String emailResult = null;
        if (version != null && version.isReceiveEmail()) {
            Boolean zazl = req.getParameter("zazl") != null;
            emailResult = this.notifyRelatedPersons(user, designer, comment, req, zazl);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setCalendar(Calendar.getInstance(new SimpleTimeZone(0, "GMT")));
        try {
            JSONObject json = new JSONObject().put("id", (Object)comment.getId()).put("created", (Object)sdf.format(comment.getCreated())).put("email", (Object)user.getPerson().getEmail()).put("reviewer", (Object)user.getUserID());
            if (emailResult != null) {
                json.put("emailResult", (Object)emailResult);
            }
            this.responseString = json.toString();
        }
        catch (JSONException jSONException) {}
    }

    protected String notifyRelatedPersons(IUser reviewer, IUser designer, Comment comment, HttpServletRequest req, Boolean zazl) {
        String to = designer.getPerson().getEmail();
        if (to != null && !to.trim().equals("")) {
            String subject = Utils.getTemplates().getProperty("maqetta.review.commentNotificationSubject");
            String htmlContent = this.getHtmlContent(reviewer, comment, req.getRequestURL().toString(), zazl);
            try {
                UserEmailUtil.getUtil().sendEmail(subject, htmlContent, to);
            }
            catch (Exception exception) {
                return htmlContent;
            }
        }
        return "OK";
    }

    private String getHtmlContent(IUser reviewer, Comment comment, String requestUrl, Boolean zazl) {
        String commentTitle = comment.getSubject();
        String pageName = comment.getPageName();
        int index = pageName.lastIndexOf("/");
        if (index > -1) {
            pageName = pageName.substring(index + 1);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("displayName", reviewer.getPerson().getDisplayName());
        props.put("pagename", pageName);
        props.put("url", ReviewManager.getReviewManager().getReviewUrl(comment.getDesignerId(), comment.getPageVersion(), requestUrl, zazl));
        props.put("title", commentTitle);
        props.put("content", comment.getContent());
        props.put("pagestate", comment.getPageState());
        props.put("pagestatelist", comment.getPageStateList());
        props.put("viewscene", comment.getViewScene());
        props.put("viewscenelist", comment.getViewSceneList());
        props.put("time", comment.getCreated().toString());
        return Utils.substitute(Utils.getTemplates().getProperty("maqetta.review.commentTemplate"), props);
    }

    protected Comment extractComment(HttpServletRequest req) {
        Comment comment = new Comment();
        String paramValue = req.getParameter("id");
        comment.setId(paramValue);
        paramValue = req.getParameter("content");
        comment.setContent(paramValue);
        paramValue = req.getParameter("ownerId");
        comment.setOwnerId(paramValue);
        paramValue = req.getParameter("designerId");
        comment.setDesignerId(paramValue);
        paramValue = req.getParameter("pageName");
        comment.setPageName(paramValue);
        paramValue = req.getParameter("pageState");
        comment.setPageState(paramValue);
        paramValue = req.getParameter("pageStateList");
        comment.setPageStateList(paramValue);
        paramValue = req.getParameter("viewScene");
        comment.setViewScene(paramValue);
        paramValue = req.getParameter("viewSceneList");
        comment.setViewSceneList(paramValue);
        paramValue = req.getParameter("subject");
        comment.setSubject(paramValue);
        paramValue = req.getParameter("replyTo");
        comment.setReplyTo(paramValue);
        paramValue = req.getParameter("reopenVersion");
        comment.setReopenVersion(paramValue);
        paramValue = req.getParameter("drawingJson");
        comment.setDrawingJson(paramValue);
        comment.setCreated(new Date());
        return comment;
    }
}

