/*
 * Decompiled with CFR 0.152.
 */
package org.davinci.server.review.persistence;

import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.SimpleTimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.davinci.server.review.Comment;
import org.davinci.server.review.CommentFlag;
import org.davinci.server.review.CommentsDocument;
import org.davinci.server.user.IDavinciProject;
import org.maqetta.server.IStorage;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Unmarshaller {
    public CommentsDocument unmarshall(IDavinciProject project) {
        CommentsDocument commentsDoc = new CommentsDocument(project);
        try {
            IStorage file = project.getCommentsFileStorage();
            Document document = Unmarshaller.initCommentsFile(file);
            Node node = document.getFirstChild();
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Comment comm;
                node = children.item(i);
                if (node.getNodeType() == 1 && "comment".equalsIgnoreCase(node.getNodeName()) && (comm = this.unmarshallComment(node)) != null) {
                    comm.setProject(project);
                    commentsDoc.getCommentList().add(comm);
                }
                ++i;
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return commentsDoc;
    }

    protected Comment unmarshallComment(Node commentNode) throws DOMException, ParseException {
        if (commentNode == null || 1 != commentNode.getNodeType()) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setCalendar(Calendar.getInstance(new SimpleTimeZone(0, "GMT")));
        Comment comment = new Comment();
        NodeList children = commentNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeType() == 1) {
                if ("pageState".equalsIgnoreCase(node.getNodeName())) {
                    comment.setPageState(Unmarshaller.getValue(node));
                } else if ("pageStateList".equalsIgnoreCase(node.getNodeName())) {
                    comment.setPageStateList(Unmarshaller.getValue(node));
                } else if ("viewScene".equalsIgnoreCase(node.getNodeName())) {
                    comment.setViewScene(Unmarshaller.getValue(node));
                } else if ("viewSceneList".equalsIgnoreCase(node.getNodeName())) {
                    comment.setViewSceneList(Unmarshaller.getValue(node));
                } else if ("pageName".equalsIgnoreCase(node.getNodeName())) {
                    comment.setPageName(Unmarshaller.getValue(node));
                } else if ("subject".equalsIgnoreCase(node.getNodeName())) {
                    comment.setSubject(Unmarshaller.getValue(node));
                } else if ("content".equalsIgnoreCase(node.getNodeName())) {
                    comment.setContent(Unmarshaller.getValue(node));
                } else if ("drawingJson".equalsIgnoreCase(node.getNodeName())) {
                    comment.setDrawingJson(Unmarshaller.getValue(node));
                } else if ("created".equalsIgnoreCase(node.getNodeName())) {
                    comment.setCreated(sdf.parse(Unmarshaller.getValue(node)));
                } else if ("id".equalsIgnoreCase(node.getNodeName())) {
                    comment.setId(Unmarshaller.getValue(node));
                } else if ("ownerId".equalsIgnoreCase(node.getNodeName())) {
                    comment.setOwnerId(Unmarshaller.getValue(node));
                } else if ("designerId".equalsIgnoreCase(node.getNodeName())) {
                    comment.setDesignerId(Unmarshaller.getValue(node));
                } else if ("replyTo".equalsIgnoreCase(node.getNodeName())) {
                    comment.setReplyTo(Unmarshaller.getValue(node));
                } else if ("email".equalsIgnoreCase(node.getNodeName())) {
                    comment.setEmail(Unmarshaller.getValue(node));
                } else if ("reopenVersion".equalsIgnoreCase(node.getNodeName())) {
                    comment.setReopenVersion(Unmarshaller.getValue(node));
                }
            }
            ++i;
        }
        return comment;
    }

    protected static String getValue(Node node) {
        if (node == null) {
            return "";
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                return Unmarshaller.deescapeXml(child.getNodeValue());
            }
            ++i;
        }
        return "";
    }

    protected List<CommentFlag> unmarshallFlags(Node flagsNode) {
        LinkedList<CommentFlag> flagList = new LinkedList<CommentFlag>();
        if (flagsNode == null) {
            return flagList;
        }
        NodeList children = flagsNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeType() == 1 && "flag".equalsIgnoreCase(node.getNodeName())) {
                CommentFlag flag = new CommentFlag();
                NamedNodeMap attriMap = node.getAttributes();
                flag.setId(Integer.parseInt(attriMap.getNamedItem("id").getNodeValue()));
                flagList.add(flag);
            }
            ++i;
        }
        return flagList;
    }

    public static String deescapeXml(String content) {
        if (content == null || content.length() == 0) {
            return "";
        }
        String rlt = content.replaceAll("&lt;", "<");
        rlt = rlt.replaceAll("&gt;", ">");
        rlt = rlt.replaceAll("&amp;", "&");
        rlt = rlt.replaceAll("&quot;", "\"");
        rlt = rlt.replaceAll("&apos;", "'");
        rlt = rlt.replaceAll("%2F", "/");
        return rlt;
    }

    public static Document initCommentsFile(IStorage commentFile) throws IOException, TransformerFactoryConfigurationError, TransformerException, ParserConfigurationException, SAXException {
        if (commentFile == null) {
            return null;
        }
        IStorage parent = commentFile.getParentFile();
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if (commentFile.exists()) {
            return builder.parse(commentFile.getInputStream());
        }
        commentFile.createNewFile();
        OutputStream os = null;
        try {
            Document document = builder.newDocument();
            document.setXmlVersion("1.0");
            Element root = document.createElement("CommentsDocument");
            document.appendChild(root);
            DOMSource source = new DOMSource(document);
            StreamResult result = null;
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            os = commentFile.getOutputStream();
            result = new StreamResult(os);
            xformer.transform(source, result);
            Document document2 = document;
            return document2;
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }
}

