/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.configurator;

import java.io.File;
import java.io.IOException;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.orion.server.configurator.ConfiguratorActivator;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApplication
implements IApplication {
    private static final Integer EXIT_WORKSPACE_LOCKED = new Integer(15);
    private static final String EQUINOX_HTTP_JETTY = "org.eclipse.equinox.http.jetty";
    private static final String EQUINOX_HTTP_REGISTRY = "org.eclipse.equinox.http.registry";
    private IApplicationContext appContext;

    public Object start(IApplicationContext context) throws Exception {
        this.appContext = context;
        this.ensureBundleStarted(EQUINOX_HTTP_JETTY);
        this.ensureBundleStarted(EQUINOX_HTTP_REGISTRY);
        context.applicationRunning();
        Object instanceLocationCheck = this.checkInstanceLocation();
        if (instanceLocationCheck != null) {
            return instanceLocationCheck;
        }
        return IApplicationContext.EXIT_ASYNC_RESULT;
    }

    public void stop() {
        if (this.appContext != null) {
            this.appContext.setResult((Object)EXIT_OK, (IApplication)this);
        }
    }

    private Object checkInstanceLocation() {
        File workspaceDirectory;
        Location instanceLoc = ConfiguratorActivator.getDefault().getInstanceLocation();
        if (instanceLoc == null || !instanceLoc.isSet()) {
            this.getLogger().error("Instance location must be set");
            return EXIT_OK;
        }
        try {
            if (instanceLoc.lock()) {
                this.getLogger().info("Workspace location locked successfully: " + instanceLoc.getURL());
                return null;
            }
        }
        catch (IOException iOException) {
            this.getLogger().error("Workspace location could not be locked: " + instanceLoc.getURL());
        }
        if ((workspaceDirectory = new File(instanceLoc.getURL().getFile())).exists()) {
            this.getLogger().error("The workspace location is already in use by another server instance: " + workspaceDirectory);
            return EXIT_WORKSPACE_LOCKED;
        }
        this.getLogger().error("Workspace location could not be created: " + workspaceDirectory);
        return EXIT_OK;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger((String)"org.eclipse.orion.app");
    }

    private void ensureBundleStarted(String symbolicName) throws BundleException {
        Bundle bundle = ConfiguratorActivator.getDefault().getBundle(symbolicName);
        if (bundle != null && (bundle.getState() == 4 || bundle.getState() == 8)) {
            bundle.start(1);
        }
    }
}

