/*
 * Decompiled with CFR 0.152.
 */
package maqetta.server.orion.authentication.ldap;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import maqetta.server.orion.authentication.ldap.LdapAuthenticationService;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.resources.Base64;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.orion.server.useradmin.UnsupportedUserStoreException;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Version;

public class LdapLoginServlet
extends OrionServlet {
    private LdapAuthenticationService authenticationService;
    private static final long serialVersionUID = 4775066421312449563L;

    public LdapLoginServlet(LdapAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo;
        String string = pathInfo = req.getPathInfo() == null ? "" : req.getPathInfo();
        if (pathInfo.startsWith("/form")) {
            block15: {
                try {
                    LdapAuthenticationService.LoginResult authResult = LdapAuthenticationService.performAuthentication(req, resp);
                    if (authResult == LdapAuthenticationService.LoginResult.OK) {
                        String versionString = req.getHeader("Orion-Version");
                        Version version = versionString == null ? null : new Version(versionString);
                        String xRequestedWith = req.getHeader("X-Requested-With");
                        if (version != null || "XMLHttpRequest".equals(xRequestedWith)) {
                            resp.setStatus(200);
                            PrintWriter writer = resp.getWriter();
                            String uid = (String)req.getSession().getAttribute("user");
                            try {
                                JSONObject userJson = LdapAuthenticationService.getUserJson(uid, req.getContextPath());
                                writer.print(userJson);
                                resp.setContentType("application/json");
                            }
                            catch (JSONException jSONException) {}
                        }
                        resp.flushBuffer();
                        break block15;
                    }
                    if (authResult == LdapAuthenticationService.LoginResult.BLOCKED) {
                        this.displayError("Your account is not active. Please confirm your email before logging in.", req, resp);
                    } else {
                        this.displayError("Invalid user or password", req, resp);
                    }
                }
                catch (UnsupportedUserStoreException e) {
                    LogHelper.log((Throwable)e);
                    resp.sendError(404, e.getMessage());
                }
            }
            return;
        }
        if (pathInfo.startsWith("/canaddusers")) {
            JSONObject jsonResp = new JSONObject();
            try {
                jsonResp.put("CanAddUsers", LdapAuthenticationService.canAddUsers());
                jsonResp.put("ForceEmail", LdapAuthenticationService.forceEmail());
                jsonResp.put("RegistrationURI", (Object)LdapAuthenticationService.registrationURI());
            }
            catch (JSONException jSONException) {}
            resp.getWriter().print(jsonResp);
            resp.setContentType("application/json");
            return;
        }
        String user = this.authenticationService.getAuthenticatedUser(req, resp, this.authenticationService.getDefaultAuthenticationProperties());
        if (user != null) {
            resp.setStatus(200);
            try {
                resp.getWriter().print(LdapAuthenticationService.getUserJson(user, req.getContextPath()));
            }
            catch (JSONException e) {
                this.handleException(resp, "An error occured when creating JSON object for logged in user", (Exception)((Object)e));
            }
            return;
        }
    }

    private void displayError(String error, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String versionString = req.getHeader("Orion-Version");
        Version version = versionString == null ? null : new Version(versionString);
        String xRequestedWith = req.getHeader("X-Requested-With");
        if (version == null && !"XMLHttpRequest".equals(xRequestedWith)) {
            String url = "/ldaplogin/LoginWindow.html";
            if (req.getParameter("redirect") != null) {
                url = String.valueOf(url) + "?redirect=" + req.getParameter("redirect");
            }
            if (error == null) {
                error = "Invalid login";
            }
            url = String.valueOf(url) + (url.contains("?") ? "&" : "?");
            url = String.valueOf(url) + "error=" + new String(Base64.encode((byte[])error.getBytes()));
            resp.sendRedirect(url);
        } else {
            resp.setStatus(401);
            PrintWriter writer = resp.getWriter();
            JSONObject jsonError = new JSONObject();
            try {
                jsonError.put("error", (Object)error);
                writer.print(jsonError);
                resp.setContentType("application/json");
            }
            catch (JSONException jSONException) {}
        }
        resp.flushBuffer();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RequestDispatcher rd = req.getRequestDispatcher("/w3login/login");
        rd.forward((ServletRequest)req, (ServletResponse)resp);
    }
}

