/*
 * Decompiled with CFR 0.152.
 */
package maqetta.server.orion.authentication.ldap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import maqetta.server.orion.authentication.ldap.LdapLoginServlet;
import maqetta.server.orion.authentication.ldap.LdapLogoutServlet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.authentication.IAuthenticationService;
import org.eclipse.orion.server.user.profile.IOrionUserProfileNode;
import org.eclipse.orion.server.user.profile.IOrionUserProfileService;
import org.eclipse.orion.server.useradmin.IOrionCredentialsService;
import org.eclipse.orion.server.useradmin.UnsupportedUserStoreException;
import org.eclipse.orion.server.useradmin.User;
import org.json.JSONException;
import org.json.JSONObject;
import org.maqetta.server.ServerManager;
import org.osgi.framework.Version;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapAuthenticationService
implements IAuthenticationService {
    private static Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.login");
    private Properties defaultAuthenticationProperties;
    private boolean registered = false;
    private static IOrionCredentialsService userAdmin;
    private static IOrionUserProfileService userProfileService;
    private static boolean allowAnonymousAccountCreation;
    private static boolean forceEmailWhileCreatingAccount;
    private static String registrationURI;
    private static String CONFIG_PROVIDER_URL;
    private static String CONFIG_LOOKUP_PROVIDER_URL;
    private static String CONFIG_INITIAL_CONTEXT_FACTORY;
    private static String CONFIG_URL_PKG_PREFIXES;
    private static String CONFIG_REFERRAL;
    private static String CONFIG_SECURITY_AUTHENTICATION;
    private static String CONFIG_LOOKUP_SECURITY_AUTHENTICATION;
    private static String CONFIG_SECURITY_PROTOCOL;
    private static String CONFIG_LOOKUP_SECURITY_PROTOCOL;
    private static String CONFIG_BASE;
    private static String CONFIG_USER_FILTER;
    private static String CONFIG_USER_DISPLAYNAME;
    private static String CONFIG_USER_EMAIL;
    private static String CONFIG_SECURITY_PRINCIPAL;
    private static String CONFIG_SECURITY_CREDENTIALS;
    private static String CONFIG_KEYSTORE;
    private static String CONFIG_KEYSTOREPASSWORD;
    private static String CONFIG_TRUSTSTORE;
    private static String CONFIG_TRUSTSTOREPASSWORD;
    private static String CONFIG_TRUSTSTORETYPE;
    private static String PROVIDER_URL;
    private static String LOOKUP_PROVIDER_URL;
    private static String INITIAL_CONTEXT_FACTORY;
    private static String URL_PKG_PREFIXES;
    private static String REFERRAL;
    private static String SECURITY_AUTHENTICATION;
    private static String LOOKUP_SECURITY_AUTHENTICATION;
    private static String SECURITY_PROTOCOL;
    private static String LOOKUP_SECURITY_PROTOCOL;
    private static String BASE;
    private static String USER_FILTER;
    private static String USER_DISPLAYNAME;
    private static String USER_EMAIL;
    private static String TRUSTSTORE;
    private static String TRUSTSTOREPW;
    private static String TRUSTSTORETYPE;
    private static String KEYSTORE;
    private static String KEYSTOREPW;
    private static String BIND_USER;
    private static String BIND_PASSWORD;

    static {
        allowAnonymousAccountCreation = PreferenceHelper.getString((String)"orion.auth.user.creation", null) == null;
        forceEmailWhileCreatingAccount = PreferenceHelper.getString((String)"orion.auth.user.creation.force.email", (String)"false").equalsIgnoreCase("true");
        registrationURI = PreferenceHelper.getString((String)"orion.auth.registration.uri", null);
        CONFIG_PROVIDER_URL = "maqetta.auth.ldap.provider.url";
        CONFIG_LOOKUP_PROVIDER_URL = "maqetta.auth.ldap.lookup.provider.url";
        CONFIG_INITIAL_CONTEXT_FACTORY = "maqetta.auth.ldap.initial.context.factory";
        CONFIG_URL_PKG_PREFIXES = "maqetta.auth.ldap.url.pkg.prefixes";
        CONFIG_REFERRAL = "maqetta.auth.ldap.referral";
        CONFIG_SECURITY_AUTHENTICATION = "maqetta.auth.ldap.security.authentication";
        CONFIG_LOOKUP_SECURITY_AUTHENTICATION = "maqetta.auth.ldap.lookup.security.authentication";
        CONFIG_SECURITY_PROTOCOL = "maqetta.auth.ldap.security.protocol";
        CONFIG_LOOKUP_SECURITY_PROTOCOL = "maqetta.auth.ldap.lookup.security.protocol";
        CONFIG_BASE = "maqetta.auth.ldap.base";
        CONFIG_USER_FILTER = "maqetta.auth.ldap.user.filter";
        CONFIG_USER_DISPLAYNAME = "maqetta.auth.ldap.user.displayname";
        CONFIG_USER_EMAIL = "maqetta.auth.ldap.user.email";
        CONFIG_SECURITY_PRINCIPAL = "maqetta.auth.ldap.bind.user";
        CONFIG_SECURITY_CREDENTIALS = "maqetta.auth.ldap.bind.password";
        CONFIG_KEYSTORE = "maqetta.auth.ldap.keystore";
        CONFIG_KEYSTOREPASSWORD = "maqetta.auth.ldap.keystorepassword";
        CONFIG_TRUSTSTORE = "maqetta.auth.ldap.truststore";
        CONFIG_TRUSTSTOREPASSWORD = "maqetta.auth.ldap.truststorepassword";
        CONFIG_TRUSTSTORETYPE = "maqetta.auth.ldap.truststoretype";
        ServerManager serverMgr = ServerManager.getServerManager();
        PROVIDER_URL = serverMgr.getDavinciProperty(CONFIG_PROVIDER_URL);
        LOOKUP_PROVIDER_URL = serverMgr.getDavinciProperty(CONFIG_LOOKUP_PROVIDER_URL);
        if (LOOKUP_PROVIDER_URL == null) {
            LOOKUP_PROVIDER_URL = PROVIDER_URL;
        }
        if ((INITIAL_CONTEXT_FACTORY = serverMgr.getDavinciProperty(CONFIG_INITIAL_CONTEXT_FACTORY)) == null) {
            INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
        }
        if ((URL_PKG_PREFIXES = serverMgr.getDavinciProperty(CONFIG_URL_PKG_PREFIXES)) == null) {
            URL_PKG_PREFIXES = "com.sun.jndi.url";
        }
        if ((REFERRAL = serverMgr.getDavinciProperty(CONFIG_REFERRAL)) == null) {
            REFERRAL = "ignore";
        }
        SECURITY_AUTHENTICATION = serverMgr.getDavinciProperty(CONFIG_SECURITY_AUTHENTICATION);
        LOOKUP_SECURITY_AUTHENTICATION = serverMgr.getDavinciProperty(CONFIG_LOOKUP_SECURITY_AUTHENTICATION);
        if (LOOKUP_SECURITY_AUTHENTICATION == null) {
            LOOKUP_SECURITY_AUTHENTICATION = SECURITY_AUTHENTICATION;
        }
        SECURITY_PROTOCOL = serverMgr.getDavinciProperty(CONFIG_SECURITY_PROTOCOL);
        LOOKUP_SECURITY_PROTOCOL = serverMgr.getDavinciProperty(CONFIG_LOOKUP_SECURITY_PROTOCOL);
        BASE = serverMgr.getDavinciProperty(CONFIG_BASE);
        USER_FILTER = serverMgr.getDavinciProperty(CONFIG_USER_FILTER);
        if (USER_FILTER == null) {
            USER_FILTER = "email";
        }
        if ((USER_DISPLAYNAME = serverMgr.getDavinciProperty(CONFIG_USER_DISPLAYNAME)) == null) {
            USER_DISPLAYNAME = "displayname";
        }
        if ((USER_EMAIL = serverMgr.getDavinciProperty(CONFIG_USER_EMAIL)) == null) {
            USER_EMAIL = "email";
        }
        TRUSTSTORE = serverMgr.getDavinciProperty(CONFIG_TRUSTSTORE);
        TRUSTSTOREPW = serverMgr.getDavinciProperty(CONFIG_TRUSTSTOREPASSWORD);
        TRUSTSTORETYPE = serverMgr.getDavinciProperty(CONFIG_TRUSTSTORETYPE);
        KEYSTORE = serverMgr.getDavinciProperty(CONFIG_KEYSTORE);
        KEYSTOREPW = serverMgr.getDavinciProperty(CONFIG_KEYSTOREPASSWORD);
        BIND_USER = serverMgr.getDavinciProperty(CONFIG_SECURITY_PRINCIPAL);
        BIND_PASSWORD = serverMgr.getDavinciProperty(CONFIG_SECURITY_CREDENTIALS);
    }

    public LdapAuthenticationService() {
        if (TRUSTSTORE != null) {
            System.setProperty("javax.net.ssl.trustStore", TRUSTSTORE);
        }
        if (TRUSTSTOREPW != null) {
            System.setProperty("javax.net.ssl.trustStorePassword", TRUSTSTOREPW);
        }
        if (TRUSTSTORETYPE != null) {
            System.setProperty("javax.net.ssl.trustStoreType", TRUSTSTORETYPE);
        }
        if (KEYSTORE != null) {
            System.setProperty("javax.net.ssl.keyStore", KEYSTORE);
        }
        if (KEYSTOREPW != null) {
            System.setProperty("javax.net.ssl.keyStorePassword", KEYSTOREPW);
        }
    }

    public Properties getDefaultAuthenticationProperties() {
        return this.defaultAuthenticationProperties;
    }

    public String authenticateUser(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        String user = this.getAuthenticatedUser(req, resp, properties);
        if (user == null) {
            this.setNotAuthenticated(req, resp, properties);
        }
        return user;
    }

    public String getAuthenticatedUser(HttpServletRequest req, HttpServletResponse resp, Properties properties) {
        HttpSession s = req.getSession(true);
        return (String)s.getAttribute("user");
    }

    public String getAuthType() {
        return "FORM";
    }

    public void configure(Properties properties) {
        this.defaultAuthenticationProperties = properties;
    }

    private void setNotAuthenticated(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        resp.setHeader("WWW-Authenticate", "FORM");
        resp.setStatus(401);
        String versionString = req.getHeader("Orion-Version");
        Version version = versionString == null ? null : new Version(versionString);
        String xRequestedWith = req.getHeader("X-Requested-With");
        if (version == null && !"XMLHttpRequest".equals(xRequestedWith)) {
            resp.sendRedirect(String.valueOf(req.getContextPath()) + "/ldaplogin/LoginWindow.html?redirect=" + req.getRequestURL());
        } else {
            resp.setContentType("application/json; charset=UTF-8");
            JSONObject result = new JSONObject();
            try {
                result.put("SignInLocation", (Object)"/ldaplogin/LoginWindow.html");
                result.put("label", (Object)"Maqetta server");
                result.put("SignInKey", (Object)"ldapUser");
            }
            catch (JSONException e) {
                LogHelper.log((IStatus)new Status(4, "maqetta.server.orion.authentication.ldap", 1, "An error occured during authentication", (Throwable)e));
            }
            resp.getWriter().print(result.toString());
        }
    }

    public void setHttpService(HttpService httpService) {
        try {
            httpService.registerServlet("/login", (Servlet)new LdapLoginServlet(this), null, null);
            httpService.registerServlet("/logout", (Servlet)new LdapLogoutServlet(), null, null);
        }
        catch (ServletException e) {
            LogHelper.log((IStatus)new Status(4, "maqetta.server.orion.authentication.ldap", 1, "An error occured when registering servlets", (Throwable)e));
        }
        catch (NamespaceException e) {
            LogHelper.log((IStatus)new Status(4, "maqetta.server.orion.authentication.ldap", 1, "A namespace error occured when registering servlets", (Throwable)e));
        }
    }

    public void unsetHttpService(HttpService httpService) {
        if (httpService != null) {
            httpService.unregister("/login");
            httpService.unregister("/logout");
            httpService = null;
        }
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public boolean getRegistered() {
        return this.registered;
    }

    public static LoginResult performAuthentication(HttpServletRequest req, HttpServletResponse resp) throws IOException, UnsupportedUserStoreException {
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.login");
        String login = req.getParameter("login");
        User user = LdapAuthenticationService.getUserForCredentials(login, req.getParameter("password"));
        if (user != null) {
            if (user.getBlocked()) {
                return LoginResult.BLOCKED;
            }
            String actualLogin = user.getUid();
            if (logger.isInfoEnabled()) {
                logger.info("Login success: " + actualLogin);
            }
            req.getSession().setAttribute("user", (Object)actualLogin);
            IOrionUserProfileNode userProfileNode = LdapAuthenticationService.getUserProfileService().getUserProfileNode(actualLogin, "general");
            try {
                userProfileNode.put("lastlogintimestamp", new Long(System.currentTimeMillis()).toString(), false);
                userProfileNode.flush();
            }
            catch (CoreException e) {
                LogHelper.log((Throwable)e);
            }
            return LoginResult.OK;
        }
        if (login != null) {
            logger.info("Login failed: " + login);
        }
        return LoginResult.FAIL;
    }

    private static User getUserForCredentials(String login, String password) throws UnsupportedUserStoreException {
        User user;
        if (userAdmin == null) {
            throw new UnsupportedUserStoreException();
        }
        if (login == null) {
            return null;
        }
        if (login.equals("admin") && (user = userAdmin.getUser("login", login)) != null && user.hasCredential("password", (Object)password)) {
            return user;
        }
        try {
            JSONObject userJson = LdapAuthenticationService.getUserObject(login);
            if (userJson != null) {
                String dn = userJson.get("userDN").toString();
                String displayname = userJson.get(USER_DISPLAYNAME).toString();
                String email = userJson.get(USER_EMAIL).toString();
                logger.info("authenticate dn, email, displayname " + dn + " " + email + " " + displayname);
                LdapAuthenticationService.authenticate(dn, password);
                User user2 = userAdmin.getUser("login", login);
                if (user2 == null) {
                    user2 = LdapAuthenticationService.createOrionUser(login, email, displayname);
                }
                return user2;
            }
        }
        catch (AuthenticationException authenticationException) {
            logger.info("Invalid Credentials");
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static User createOrionUser(String login, String email, String name) {
        if (name == null) {
            name = login;
        }
        User newUser = new User(login, name, null);
        newUser.setEmail(email);
        newUser = userAdmin.createUser(newUser);
        try {
            AuthorizationService.addUserRight((String)newUser.getUid(), (String)newUser.getLocation());
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
        }
        return newUser;
    }

    public static boolean canAddUsers() {
        return allowAnonymousAccountCreation ? (userAdmin == null ? false : userAdmin.canCreateUsers()) : false;
    }

    public static boolean forceEmail() {
        return forceEmailWhileCreatingAccount;
    }

    public static String registrationURI() {
        return registrationURI;
    }

    public static IOrionCredentialsService getDefaultUserAdmin() {
        return userAdmin;
    }

    public void setUserAdmin(IOrionCredentialsService userAdmin) {
        LdapAuthenticationService.userAdmin = userAdmin;
    }

    public void unsetUserAdmin(IOrionCredentialsService userAdmin) {
        if (userAdmin.equals(LdapAuthenticationService.userAdmin)) {
            LdapAuthenticationService.userAdmin = null;
        }
    }

    public static JSONObject getUserJson(String uid, String contextPath) throws JSONException {
        User user;
        JSONObject obj;
        block5: {
            obj = new JSONObject();
            obj.put("login", (Object)uid);
            user = userAdmin.getUser("uid", uid);
            if (user != null) break block5;
            return null;
        }
        try {
            IOrionUserProfileNode generalUserProfile = LdapAuthenticationService.getUserProfileService().getUserProfileNode(uid, "general");
            obj.put("uid", (Object)uid);
            obj.put("login", (Object)user.getLogin());
            obj.put("Location", (Object)(String.valueOf(contextPath) + user.getLocation()));
            obj.put("Name", (Object)user.getName());
            if (generalUserProfile.get("lastlogintimestamp", null) != null) {
                Long lastLogin = Long.parseLong(generalUserProfile.get("lastlogintimestamp", ""));
                obj.put("lastlogintimestamp", (Object)lastLogin);
            }
        }
        catch (IllegalArgumentException e) {
            LogHelper.log((Throwable)e);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
        }
        return obj;
    }

    private static IOrionUserProfileService getUserProfileService() {
        return userProfileService;
    }

    public static void bindUserProfileService(IOrionUserProfileService _userProfileService) {
        userProfileService = _userProfileService;
    }

    public static void unbindUserProfileService(IOrionUserProfileService userProfileService) {
        userProfileService = null;
    }

    public static JSONObject getUserObject(String userId) throws NamingException {
        JSONObject user = null;
        ArrayList<String> attributeList = new ArrayList<String>();
        attributeList.add("cn");
        attributeList.add("dn");
        attributeList.add("o");
        attributeList.add("ou");
        attributeList.add("uid");
        attributeList.add(USER_DISPLAYNAME);
        attributeList.add(USER_EMAIL);
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
        props.setProperty("java.naming.provider.url", LOOKUP_PROVIDER_URL);
        props.setProperty("java.naming.factory.url.pkgs", URL_PKG_PREFIXES);
        props.setProperty("java.naming.referral", REFERRAL);
        props.setProperty("java.naming.security.authentication", LOOKUP_SECURITY_AUTHENTICATION);
        if (LOOKUP_SECURITY_PROTOCOL != null) {
            props.setProperty("java.naming.security.protocol", LOOKUP_SECURITY_PROTOCOL);
        }
        if (BIND_USER != null) {
            props.setProperty("java.naming.security.principal", BIND_USER);
        }
        if (BIND_PASSWORD != null) {
            props.setProperty("java.naming.security.credentials", BIND_PASSWORD);
        }
        InitialDirContext ctx = new InitialDirContext(props);
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        String[] al = new String[attributeList.size()];
        attributeList.toArray(al);
        constraints.setReturningAttributes(al);
        String filter = String.valueOf(USER_FILTER) + "=" + userId;
        logger.info("LDAP search '" + filter + "' ");
        try {
            try {
                NamingEnumeration<SearchResult> results = ctx.search(BASE, filter, constraints);
                if (results.hasMoreElements()) {
                    logger.info("has returned results..\n");
                    user = new JSONObject();
                    SearchResult sr = results.next();
                    NameParser parser = ctx.getNameParser(BASE);
                    Name userDN = parser.parse(BASE);
                    if (userDN == null) {
                        throw new NameNotFoundException();
                    }
                    userDN.addAll(parser.parse(sr.getName()));
                    user.put("userDN", (Object)userDN.toString());
                    Attributes attributes = sr.getAttributes();
                    NamingEnumeration<? extends Attribute> a = attributes.getAll();
                    while (a.hasMore()) {
                        Attribute attr = a.next();
                        String json = "";
                        NamingEnumeration<?> ne = attr.getAll();
                        while (ne.hasMore()) {
                            json = String.valueOf(json) + ne.next();
                        }
                        user.put(attr.getID(), (Object)json);
                    }
                } else {
                    logger.info("has returned no results..");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ctx.close();
            }
        }
        finally {
            ctx.close();
        }
        return user;
    }

    public static void authenticate(String userDN, String pw) throws Exception {
        logger.info("authenticate " + userDN);
        Hashtable<String, String> env = new Hashtable<String, String>(11);
        env.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
        env.put("java.naming.provider.url", PROVIDER_URL);
        env.put("java.naming.security.authentication", SECURITY_AUTHENTICATION);
        if (SECURITY_PROTOCOL != null) {
            env.put("java.naming.security.protocol", SECURITY_PROTOCOL);
        }
        env.put("java.naming.security.principal", userDN);
        env.put("java.naming.security.credentials", pw);
        InitialDirContext ctx = null;
        try {
            try {
                ctx = new InitialDirContext(env);
                logger.info("SUCCESSFUL");
            }
            catch (AuthenticationException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LoginResult {
        OK,
        FAIL,
        BLOCKED;

    }
}

