/*
 * Decompiled with CFR 0.152.
 */
package maqetta.core.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.davinci.ajaxLibrary.ILibraryManager;
import org.davinci.server.internal.Activator;
import org.davinci.server.user.IUser;
import org.davinci.server.user.IUserManager;
import org.davinci.server.user.UserException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.maqetta.server.IServerManager;
import org.maqetta.server.IVResource;
import org.maqetta.server.ServerManager;
import org.maqetta.server.VURL;
import org.maqetta.server.Validator;
import org.osgi.framework.Bundle;

public class DavinciPageServlet
extends HttpServlet {
    private static final Logger theLogger = Logger.getLogger(DavinciPageServlet.class.getName());
    private static final long serialVersionUID = 1L;
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String ETAG = "ETag";
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String PRAGMA = "Pragma";
    private static final String EXPIRES = "Expires";
    private static final long maxAge = 2592000L;
    protected IUserManager userManager;
    protected IServerManager serverManager;
    protected ILibraryManager libraryManager;

    public void initialize() {
        this.serverManager = ServerManager.getServerManager();
        this.userManager = this.serverManager.getUserManager();
        this.libraryManager = this.serverManager.getLibraryManager();
    }

    private void log(HttpServletRequest req, IUser user) {
        String query;
        String log = "RequestURL: " + req.getRequestURL().toString();
        if (user != null) {
            log = String.valueOf(log) + "\nUser: uid=" + user.getUserID();
            String email = user.getPerson().getEmail();
            if (email != null) {
                log = String.valueOf(log) + " email=" + email;
            }
        }
        if ((query = req.getQueryString()) != null) {
            log = String.valueOf(log) + "\nQuery: " + query;
        }
        Enumeration names = req.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String header = req.getHeader(name);
            if (header == null) continue;
            log = String.valueOf(log) + "\n" + name + ": " + header;
        }
        theLogger.info(log);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        IUser user = null;
        try {
            IVResource file;
            boolean isWorkingCopy;
            user = ServerManager.getServerManager().getUserManager().getUser(req);
            if (user == null) {
                resp.sendError(403);
                return;
            }
            String path = this.getPathInfo(req);
            if (path == null) {
                theLogger.warning("DavinciPageServlet:doPut getPathInfo returned Null for user: " + user.getUserID());
                resp.sendError(500);
                return;
            }
            boolean bl = isWorkingCopy = path.indexOf(".workingcopy") > -1;
            if (isWorkingCopy) {
                path = path.substring(0, path.indexOf(".workingcopy"));
            }
            if ((file = user.getResource(path)) == null) {
                theLogger.warning("DavinciPageServlet:doPut user.getResource(" + path + ") returned Null for user: " + user.getUserID());
                resp.sendError(404);
                return;
            }
            if (file.isVirtual()) {
                if ((file = user.createResource(path, file.isDirectory())).isDirectory()) {
                    file.mkdir();
                } else {
                    file.createNewInstance();
                }
            }
            if (file.exists()) {
                OutputStream os = file.getOutputStreem();
                DavinciPageServlet.transferStreams((InputStream)req.getInputStream(), os, false);
                if (!isWorkingCopy) {
                    file.flushWorkingCopy();
                }
            } else {
                resp.sendError(404);
            }
        }
        catch (RuntimeException re) {
            this.log(req, user);
            throw re;
        }
    }

    public String getPathInfo(HttpServletRequest req) {
        return req.getPathInfo();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        IUser user = null;
        try {
            if (this.serverManager == null) {
                this.initialize();
            }
            String previewParam = req.getParameter("preview");
            user = ServerManager.getServerManager().getUserManager().getUser(req);
            String pathInfo = this.getPathInfo(req);
            theLogger.finest("Page Servlet request: " + pathInfo + ", logged in=" + (user != null));
            if (pathInfo == null) {
                this.handleReview(req, resp);
                resp.sendRedirect("maqetta/");
            } else if (pathInfo != null && (pathInfo.equals("") || pathInfo.equals("/")) && previewParam == null) {
                if (!ServerManager.LOCAL_INSTALL) {
                    if (user == null) {
                        resp.sendRedirect("welcome");
                    } else {
                        this.writeMainPage(req, resp);
                    }
                } else {
                    this.writeMainPage(req, resp);
                }
            } else if (pathInfo.equals("/welcome")) {
                this.writeWelcomePage(req, resp);
            } else if (previewParam != null) {
                this.handlePreview(req, resp);
            } else if (pathInfo.startsWith("/user")) {
                this.handleWSRequest(req, resp, user);
            } else {
                resp.sendError(404);
            }
        }
        catch (RuntimeException re) {
            this.log(req, user);
            throw re;
        }
    }

    private void handleReview(HttpServletRequest req, HttpServletResponse resp) {
        String reviewVersion;
        String designerName = req.getParameter("reviewDesigner");
        if (this.validateReviewParms(designerName, reviewVersion = req.getParameter("reviewVersion"))) {
            Cookie designerCookie = new Cookie("davinci_designer", designerName);
            designerCookie.setPath("/");
            resp.addCookie(designerCookie);
            if (reviewVersion != null) {
                Cookie versionCookie = new Cookie("davinci_version", reviewVersion);
                versionCookie.setPath("/");
                resp.addCookie(versionCookie);
            }
        }
    }

    private boolean validateReviewParms(String designerName, String reviewVersion) {
        boolean returnVal;
        boolean bl = returnVal = designerName != null && reviewVersion != null;
        if (returnVal) {
            boolean validDesigner;
            try {
                validDesigner = ServerManager.getServerManager().getUserManager().isValidUser(designerName);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (UserException e) {
                throw new RuntimeException(e);
            }
            if (validDesigner) {
                returnVal = Validator.isValidISOTimeStamp(reviewVersion);
                if (!returnVal) {
                    theLogger.warning("validateReviewParms: Poorly formatted reviewVersion = " + reviewVersion);
                }
            } else {
                theLogger.warning("validateReviewParms: Invalid review designer name = " + designerName);
                returnVal = false;
            }
        }
        return returnVal;
    }

    protected URL getPageExtensionPath(String extensionPoint, String extensionName) {
        List extensions = this.serverManager.getExtensions(extensionPoint, extensionName);
        IConfigurationElement winner = null;
        int highest = -100000;
        int i = 0;
        while (i < extensions.size()) {
            IConfigurationElement extension = (IConfigurationElement)extensions.get(i);
            int priority = Integer.parseInt(extension.getAttribute("priority"));
            if (priority > highest) {
                winner = extension;
                highest = priority;
            }
            ++i;
        }
        String name = winner.getDeclaringExtension().getContributor().getName();
        Bundle bundle = Activator.getActivator().getOtherBundle(name);
        String path = winner.getAttribute("path");
        return bundle.getResource(path);
    }

    protected void writeWelcomePage(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        URL welcomePage = this.getPageExtensionPath("welcomePage", "welcomePage");
        VURL resourceURL = new VURL(welcomePage);
        this.writePage(req, resp, resourceURL, CacheHeaders.NO_CACHE);
    }

    protected void writeMainPage(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        URL welcomePage = this.getPageExtensionPath("mainPage", "mainPage");
        VURL resourceURL = new VURL(welcomePage);
        this.writePage(req, resp, resourceURL, CacheHeaders.NO_CACHE);
    }

    protected void handlePreview(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        URL previewPage = this.getPageExtensionPath("previewPage", "previewPage");
        VURL resourceURL = new VURL(previewPage);
        this.writePage(req, resp, resourceURL, CacheHeaders.CACHE);
    }

    protected void handleWSRequest(HttpServletRequest req, HttpServletResponse resp, IUser user) throws IOException, ServletException {
        IVResource userFile;
        String pathInfo = this.getPathInfo(req);
        Path path = new Path(pathInfo);
        if (path.hasTrailingSeparator()) {
            path = path.removeTrailingSeparator();
        }
        path = path.removeFirstSegments(1);
        String userName = path.segment(0);
        if (path.segmentCount() < 4 || !path.segment(1).equals("ws") || !path.segment(2).equals("workspace")) {
            theLogger.warning("incorrectly formed workspace path: " + path);
            resp.sendError(400);
            return;
        }
        path = path.removeFirstSegments(3);
        try {
            if (user == null) {
                user = ServerManager.getServerManager().getUserManager().getUser(userName);
            }
            if (user != null && user.getUserID().compareTo(userName) != 0) {
                user = ServerManager.getServerManager().getUserManager().getUser(userName);
            }
        }
        catch (UserException e) {
            throw new RuntimeException(e);
        }
        if (this.handleLibraryRequest(req, resp, (IPath)path, user)) {
            return;
        }
        if (user == null) {
            try {
                user = ServerManager.getServerManager().getUserManager().getUser(userName);
            }
            catch (UserException e) {
                throw new RuntimeException(e);
            }
            if (user == null) {
                theLogger.warning("user not found: " + userName);
                resp.sendError(404);
                return;
            }
        }
        if ((userFile = user.getResource(path.toString())) != null && !userFile.exists()) {
            if (path.getFileExtension() == null) {
                userFile = user.getResource(path.addFileExtension("html").toString());
            }
            if (!userFile.exists()) {
                theLogger.warning("user file not found: " + path);
                resp.sendError(404);
                return;
            }
        } else {
            resp.resetBuffer();
            resp.sendError(404);
        }
    }

    protected boolean handleLibraryRequest(HttpServletRequest req, HttpServletResponse resp, IPath path, IUser user) throws ServletException, IOException {
        IVResource libraryURL = user.getResource(path.toString());
        if (libraryURL != null) {
            CacheHeaders caching = libraryURL.readOnly() ? CacheHeaders.CACHE : CacheHeaders.NO_CACHE;
            this.writePage(req, resp, libraryURL, caching);
            return true;
        }
        return false;
    }

    protected void writePage(HttpServletRequest req, HttpServletResponse resp, IVResource resourceURL, CacheHeaders doCache) throws ServletException, IOException {
        if (resourceURL == null) {
            theLogger.warning("resource URL not found: " + resourceURL);
            resp.sendError(404);
            return;
        }
        URLConnection connection = resourceURL.openConnection();
        InputStream is = null;
        try {
            String ifNoneMatch;
            is = connection.getInputStream();
            long lastModified = connection.getLastModified();
            int contentLength = connection.getContentLength();
            String etag = null;
            if (lastModified != -1L && contentLength != -1) {
                etag = "W/\"" + contentLength + "-" + lastModified + "\"";
            }
            if ((ifNoneMatch = req.getHeader(IF_NONE_MATCH)) != null && etag != null && ifNoneMatch.compareTo(etag) == 0) {
                resp.setStatus(304);
                return;
            }
            long ifModifiedSince = req.getDateHeader(IF_MODIFIED_SINCE);
            if (ifModifiedSince > -1L && lastModified > 0L && lastModified <= ifModifiedSince + 999L) {
                resp.setStatus(304);
                return;
            }
            try {
                if (contentLength != -1) {
                    resp.setContentLength(contentLength);
                }
                String path = resourceURL.getPath();
                String contentType = req.getSession().getServletContext().getMimeType(path);
                if (contentType != null) {
                    resp.setContentType(contentType);
                }
                if (lastModified > 0L) {
                    resp.setDateHeader(LAST_MODIFIED, lastModified);
                }
                resp.setCharacterEncoding("UTF-8");
                if (etag != null) {
                    resp.setHeader(ETAG, etag);
                }
                if (doCache != CacheHeaders.NO_CACHE) {
                    resp.setDateHeader(EXPIRES, System.currentTimeMillis() + 2592000000L);
                    resp.setHeader(CACHE_CONTROL, "public, max-age=2592000, must-revalidate");
                } else {
                    resp.setDateHeader(EXPIRES, 0L);
                    resp.setHeader(CACHE_CONTROL, "no-cache");
                    resp.setHeader(PRAGMA, "no-cache");
                }
                try {
                    ServletOutputStream os = resp.getOutputStream();
                    int writtenContentLength = DavinciPageServlet.writeResource(is, (OutputStream)os);
                    if (contentLength == -1 || contentLength != writtenContentLength) {
                        resp.setContentLength(writtenContentLength);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    PrintWriter writer = resp.getWriter();
                    DavinciPageServlet.writeResource(is, writer);
                }
            }
            catch (FileNotFoundException e) {
                theLogger.log(Level.WARNING, "writePage file not found: " + resourceURL, e);
                resp.reset();
                resp.sendError(403);
            }
            catch (SecurityException e) {
                theLogger.log(Level.WARNING, "writePage security exception: " + resourceURL, e);
                resp.reset();
                resp.sendError(403);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    protected static int writeResource(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[8192];
        int bytesRead = is.read(buffer);
        int writtenContentLength = 0;
        while (bytesRead != -1) {
            os.write(buffer, 0, bytesRead);
            writtenContentLength += bytesRead;
            bytesRead = is.read(buffer);
        }
        return writtenContentLength;
    }

    protected static void writeResource(InputStream is, Writer writer) throws IOException {
        InputStreamReader reader = new InputStreamReader(is);
        try {
            char[] buffer = new char[8192];
            int charsRead = reader.read(buffer);
            while (charsRead != -1) {
                writer.write(buffer, 0, charsRead);
                charsRead = reader.read(buffer);
            }
        }
        finally {
            if (reader != null) {
                ((Reader)reader).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void transferStreams(InputStream source, OutputStream destination, boolean closeInput) throws IOException {
        byte[] buffer = new byte[8192];
        try {
            byte[] byArray = buffer;
            synchronized (buffer) {
                while (true) {
                    int bytesRead = -1;
                    bytesRead = source.read(buffer);
                    if (bytesRead == -1) break;
                    destination.write(buffer, 0, bytesRead);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        finally {
            if (closeInput) {
                source.close();
            } else {
                destination.close();
            }
        }
        {
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CacheHeaders {
        CACHE,
        NO_CACHE;

    }
}

