/*
 * Decompiled with CFR 0.152.
 */
package maqetta.core.server.command;

import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.davinci.server.user.IUser;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.maqetta.server.Command;
import org.maqetta.server.IProjectTemplatesManager;
import org.maqetta.server.ServerManager;

public class GetProjectTemplates
extends Command {
    public void handleCommand(HttpServletRequest req, HttpServletResponse resp, IUser user) throws IOException {
        Boolean error = false;
        String errorString = "";
        String searchString = "";
        String searchStringLC = "";
        int limit = 100;
        int offset = 0;
        String paramsJson = req.getParameter("params");
        if (paramsJson != null && !paramsJson.equals("")) {
            JSONObject params = null;
            try {
                params = new JSONObject(paramsJson);
                if (params.has("searchString")) {
                    searchString = params.getString("searchString");
                    searchStringLC = searchString.toLowerCase();
                }
                if (params.has("limit") && (limit = params.getInt("limit")) > 1000) {
                    limit = 1000;
                }
                if (params.has("offset")) {
                    offset = params.getInt("offset");
                }
            }
            catch (JSONException jSONException) {
                errorString = "cmd/DeleteProjectTemplates - json exception";
                error = true;
            }
        }
        IProjectTemplatesManager projectTemplatesManager = ServerManager.getServerManager().getProjectTemplatesManager();
        JSONObject projectTemplatesObject = projectTemplatesManager.getProjectTemplatesIndex(user);
        Boolean enableProjectSharingAll = projectTemplatesManager.getEnableProjectSharingAll();
        try {
            JSONArray allUserTemplates = projectTemplatesObject.getJSONArray("templates");
            int countList = allUserTemplates.length();
            ArrayList<JSONObject> ls = new ArrayList<JSONObject>();
            int i = 0;
            while (i < countList) {
                JSONObject template = allUserTemplates.getJSONObject(i);
                ls.add(template);
                ++i;
            }
            Collections.sort(ls, new JSONObjectComparable());
            JSONArray sortedUserTemplates = new JSONArray();
            for (JSONObject t : ls) {
                sortedUserTemplates.put((Object)t);
            }
            projectTemplatesObject.remove("templates");
            JSONObject responseObject = new JSONObject();
            responseObject.put("success", error == false);
            if (error.booleanValue()) {
                responseObject.put("error", (Object)errorString);
            } else {
                JSONArray returnTemplates = new JSONArray();
                int countAll = sortedUserTemplates.length();
                responseObject.put("searchString", (Object)searchString);
                responseObject.put("offset", offset);
                responseObject.put("limit", limit);
                responseObject.put("totalNumProjectTemplates", countAll);
                responseObject.put("enableProjectSharingAll", (Object)enableProjectSharingAll);
                int numFound = 0;
                int numAdded = 0;
                int i2 = 0;
                while (i2 < countAll) {
                    JSONObject template = sortedUserTemplates.getJSONObject(i2);
                    Boolean matches = searchStringLC.equals("") ? Boolean.valueOf(true) : Boolean.valueOf(this.match(template, "name", searchStringLC) != false || this.match(template, "description", searchStringLC) != false || this.match(template, "authorEmail", searchStringLC) != false);
                    if (matches.booleanValue()) {
                        if (numFound >= offset) {
                            returnTemplates.put((Object)template);
                            ++numAdded;
                        }
                        ++numFound;
                        if (numAdded >= limit) break;
                    }
                    ++i2;
                }
                projectTemplatesObject.put("projectTemplates", (Object)returnTemplates);
                responseObject.put("projectTemplatesObject", (Object)projectTemplatesObject);
            }
            this.responseString = responseObject.toString(2);
        }
        catch (JSONException jSONException) {
            this.responseString = "{\"success\":false, \"error\":\"cmd/DeleteProjectTemplates json exception\"}";
        }
        resp.setContentType("application/json;charset=UTF-8");
    }

    private Boolean match(JSONObject template, String propname, String searchString) {
        try {
            if (template.has(propname)) {
                String value = template.getString(propname);
                String valueLC = value.toLowerCase();
                if (valueLC.indexOf(searchString) >= 0) {
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class JSONObjectComparable
    extends JSONObject
    implements Comparator<JSONObject> {
        @Override
        public int compare(JSONObject o1, JSONObject o2) {
            try {
                Collator collator = Collator.getInstance();
                String thisName = o1.getString("name");
                String compareName = o2.getString("name");
                if (!thisName.equals(compareName)) {
                    int retval = collator.compare(thisName, compareName);
                    return retval;
                }
                String thisAuthorEmail = o1.getString("authorEmail");
                String compareAuthorEmail = o2.getString("authorEmail");
                int retval = collator.compare(thisAuthorEmail, compareAuthorEmail);
                return retval;
            }
            catch (JSONException jSONException) {
                return 0;
            }
        }
    }
}

