/*
 * Decompiled with CFR 0.152.
 */
package maqetta.core.server.command;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.davinci.server.user.IUser;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.maqetta.server.Command;
import org.maqetta.server.IProjectTemplatesManager;
import org.maqetta.server.ServerManager;

public class ModifyProjectTemplates
extends Command {
    public void handleCommand(HttpServletRequest req, HttpServletResponse resp, IUser user) throws IOException {
        Boolean error = false;
        String errorString = "";
        String paramsJson = req.getParameter("params");
        if (paramsJson == null || paramsJson.equals("")) {
            errorString = "cmd/ModifyProjectTemplates - No params object";
            error = true;
        }
        JSONArray params = null;
        try {
            params = new JSONArray(paramsJson);
        }
        catch (JSONException jSONException) {
            errorString = "cmd/ModifyProjectTemplates - json exception";
            error = true;
        }
        IProjectTemplatesManager projectTemplatesManager = ServerManager.getServerManager().getProjectTemplatesManager();
        if (!error.booleanValue()) {
            errorString = projectTemplatesManager.modifyProjectTemplates(user, params);
            error = errorString != null && !errorString.equals("");
        }
        JSONObject responseObject = new JSONObject();
        try {
            responseObject.put("success", error == false);
            if (error.booleanValue()) {
                responseObject.put("error", (Object)errorString);
            }
            this.responseString = responseObject.toString(2);
        }
        catch (JSONException jSONException) {
            this.responseString = "{\"success\":false, \"error\":\"cmd/ModifyProjectTemplates json exception\"}";
        }
        resp.setContentType("application/json;charset=UTF-8");
    }
}

