/*
 * Decompiled with CFR 0.152.
 */
package maqetta.core.server.user;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import maqetta.core.server.user.DesignerUser;
import org.davinci.server.review.ReviewerVersion;
import org.davinci.server.review.Version;
import org.davinci.server.review.cache.ReviewCacheManager;
import org.davinci.server.review.user.IDesignerUser;
import org.davinci.server.review.user.IReviewManager;
import org.davinci.server.review.user.Reviewer;
import org.davinci.server.user.IUser;
import org.davinci.server.user.UserException;
import org.eclipse.core.runtime.Path;
import org.maqetta.server.IStorage;
import org.maqetta.server.ServerManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReviewManager
implements IReviewManager {
    private static ReviewManager theReviewManager;
    public IStorage baseDirectory;
    Map<String, IDesignerUser> designerUsers = Collections.synchronizedMap(new HashMap());
    Map<String, Reviewer> reviewers = Collections.synchronizedMap(new HashMap());

    public static ReviewManager getReviewManager() {
        if (theReviewManager == null) {
            theReviewManager = new ReviewManager();
            if (!ReviewCacheManager.$.isAlive()) {
                ReviewCacheManager.$.start();
            }
        }
        return theReviewManager;
    }

    public ReviewManager() {
        this.baseDirectory = ServerManager.getServerManager().getBaseDirectory();
    }

    public void saveDraft(IDesignerUser user, Version version) throws IOException {
        IStorage commentingDir = user.getCommentingDirectory();
        if (!commentingDir.exists()) {
            commentingDir.mkdir();
            commentingDir.newInstance(commentingDir, "snapshot").mkdir();
        }
        this.saveVersionFile(user);
    }

    public void publish(IDesignerUser user, Version version) throws IOException {
        IStorage commentingDir = user.getCommentingDirectory();
        if (!commentingDir.exists()) {
            commentingDir.mkdir();
            commentingDir.newInstance(commentingDir, "snapshot").mkdir();
        }
        this.initVersionDir(user, version.getTime());
        this.saveVersionFile(user);
        this.saveReviewerVersionFiles(version);
        user.rebuildWorkspace();
    }

    private void saveReviewerVersionFiles(Version version) throws IOException {
        List<Reviewer> reviewers = version.getReviewers();
        for (Reviewer reviewer : reviewers) {
            this.saveReviewerVersionFile(reviewer);
        }
    }

    private void saveReviewerVersionFile(Reviewer reviewer) throws IOException {
        IStorage versionFile = this.getReviewerVersionFile(reviewer);
        ReviewerVersionFile file = new ReviewerVersionFile();
        file.save(versionFile, reviewer);
    }

    private IStorage getReviewerVersionFile(Reviewer reviewer) throws IOException {
        IStorage versionFile = this.baseDirectory.newInstance(this.getReviewerVersionDirectory(), this.buildBaseFileForFromReviewer(reviewer));
        return versionFile;
    }

    private String buildBaseFileForFromReviewer(Reviewer reviewer) {
        String fileName = String.valueOf(reviewer.getEmail()) + ".xml";
        return fileName;
    }

    private IStorage getReviewerVersionDirectory() throws IOException {
        IStorage reviewerVersionsDirectory = this.baseDirectory.newInstance(this.baseDirectory, ".review");
        if (!reviewerVersionsDirectory.exists()) {
            reviewerVersionsDirectory.mkdir();
        }
        return reviewerVersionsDirectory;
    }

    public void saveVersionFile(IDesignerUser user) throws IOException {
        IStorage commentingDir = user.getCommentingDirectory();
        IStorage versionFile = commentingDir.newInstance(commentingDir, "snapshot/versions.xml");
        VersionFile file = new VersionFile();
        file.save(versionFile, user);
    }

    private void initVersionDir(IDesignerUser user, String timeStamp) throws IOException {
        IStorage commentingDir = user.getCommentingDirectory();
        IStorage versionDir = commentingDir.newInstance(commentingDir, "snapshot/" + timeStamp);
        if (versionDir.exists()) {
            return;
        }
        versionDir.mkdir();
        IStorage userDir = user.getUserDirectory();
        IStorage[] files = userDir.listFiles();
        int i = 0;
        while (i < files.length) {
            IStorage destination;
            String path = files[i].getAbsolutePath();
            if (files[i].isFile() && path.indexOf(".workingcopy") < 0) {
                destination = versionDir.newInstance(files[i].getName());
                this.copyFile(files[i], destination);
            } else if (files[i].isDirectory() && path.indexOf(".download") < 0 && path.indexOf(".review") < 0 && path.indexOf(".svn") < 0 && this.containsPublishedFiles(files[i], user, timeStamp)) {
                destination = versionDir.newInstance(versionDir, files[i].getName());
                this.copyDirectory(files[i], destination);
            }
            ++i;
        }
    }

    private void copyDirectory(IStorage sourceDir, IStorage destinationDir) throws IOException {
        destinationDir.mkdirs();
        IStorage[] file = sourceDir.listFiles();
        int i = 0;
        while (i < file.length) {
            if (file[i].isFile()) {
                IStorage sourceFile = file[i];
                IStorage targetFile = destinationDir.newInstance(destinationDir, file[i].getName());
                this.copyFile(sourceFile, targetFile);
            }
            if (file[i].isDirectory()) {
                IStorage destination = destinationDir.newInstance(destinationDir, file[i].getName());
                this.copyDirectory(file[i], destination);
            }
            ++i;
        }
    }

    private void copyFile(IStorage source, IStorage destination) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            int len;
            destination.getParentFile().mkdirs();
            in = source.getInputStream();
            out = destination.getOutputStream();
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public IDesignerUser getDesignerUser(IUser user) throws IOException {
        String name = user.getUserID();
        IDesignerUser designer = this.designerUsers.get(name);
        if (designer == null) {
            designer = this.loadDesignerUser(user);
            this.designerUsers.put(name, designer);
        } else {
            designer.setRawUser(user);
        }
        return designer;
    }

    public IDesignerUser getDesignerUser(String name) throws IOException {
        IDesignerUser designer = this.designerUsers.get(name);
        if (designer == null) {
            IUser user;
            try {
                user = ServerManager.getServerManager().getUserManager().getUser(name);
            }
            catch (UserException e) {
                throw new RuntimeException(e);
            }
            if (user == null) {
                return null;
            }
            designer = this.getDesignerUser(user);
        }
        return designer;
    }

    public Reviewer getReviewer(String email) throws IOException {
        return this.getReviewer(null, email);
    }

    public Reviewer getReviewer(String name, String email) throws IOException {
        Reviewer reviewer = this.reviewers.get(email);
        if (reviewer == null) {
            reviewer = this.loadReviewer(name, email);
        }
        return reviewer;
    }

    public Reviewer isValid(String name, String id, String versionTime) {
        IDesignerUser user;
        try {
            user = this.getDesignerUser(name);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        if (versionTime == null && user.getLatestVersion() != null) {
            versionTime = user.getLatestVersion().getTime();
        }
        if (versionTime == null) {
            return null;
        }
        List<Version> versionList = user.getVersions();
        for (Version version : versionList) {
            if (!version.getTime().equals(versionTime)) continue;
            List<Reviewer> reviewers = version.getReviewers();
            for (Reviewer reviewer : reviewers) {
                if (!reviewer.getEmail().equals(id)) continue;
                return reviewer;
            }
        }
        return null;
    }

    private IDesignerUser loadDesignerUser(IUser user) throws IOException {
        DesignerUser designerUser = new DesignerUser(user);
        IStorage commentingDir = designerUser.getCommentingDirectory();
        IStorage versionFile = commentingDir.newInstance(commentingDir, "snapshot/versions.xml");
        if (versionFile.exists()) {
            VersionFile file = new VersionFile();
            List<Version> versions = file.load(versionFile);
            for (Version version : versions) {
                designerUser.addVersion(version);
                if (file.latestVersionID == null || !version.getVersionID().equals(file.latestVersionID)) continue;
                designerUser.setLatestVersion(version);
            }
        }
        return designerUser;
    }

    private Reviewer loadReviewer(String name, String email) throws IOException {
        Reviewer reviewer = new Reviewer(name, email);
        IStorage versionFile = this.getReviewerVersionFile(reviewer);
        if (versionFile.exists()) {
            ReviewerVersionFile file = new ReviewerVersionFile();
            List<ReviewerVersion> versions = file.load(versionFile);
            for (ReviewerVersion version : versions) {
                reviewer.addReviewerVersion(version);
            }
        }
        this.reviewers.put(email, reviewer);
        return reviewer;
    }

    private boolean containsPublishedFiles(IStorage dir, IDesignerUser user, String timeStamp) {
        for (Version version : user.getVersions()) {
            if (!version.getTime().equals(timeStamp)) continue;
            for (String res : version.resources) {
                Path resPath = new Path(res);
                while (resPath.segment(0).equals(".")) {
                    resPath = resPath.removeFirstSegments(1);
                }
                if (!dir.getName().equals(resPath.segment(0))) continue;
                return true;
            }
        }
        return false;
    }

    public String getReviewUrl(String designerId, String version, String requestUrl, Boolean zazl) {
        String prefix = requestUrl.substring(0, requestUrl.indexOf("/cmd/"));
        String suffix = "?reviewDesigner=" + designerId + "&" + "reviewVersion" + "=" + version;
        if (zazl.booleanValue()) {
            suffix = String.valueOf(suffix) + "&zazl=true";
        }
        return String.valueOf(prefix) + suffix;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReviewerVersionFile {
        private ReviewerVersionFile() {
        }

        /*
         * Exception decompiling
         */
        public void save(IStorage file, Reviewer reviewer) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public List<ReviewerVersion> load(IStorage file) throws IOException {
            ArrayList<ReviewerVersion> objects = new ArrayList<ReviewerVersion>();
            InputStream input = null;
            if (!file.exists()) return objects;
            try {
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    input = file.getInputStream();
                    Document document = parser.parse(input);
                    Element rootElement = document.getDocumentElement();
                    NodeList versionElements = rootElement.getElementsByTagName("version");
                    int i = 0;
                    while (i < versionElements.getLength()) {
                        Element versionElement = (Element)versionElements.item(i);
                        String designerID = versionElement.getAttribute("designerID");
                        String time = versionElement.getAttribute("time");
                        ReviewerVersion version = new ReviewerVersion(designerID, time);
                        objects.add(version);
                        ++i;
                    }
                    return objects;
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                    if (input == null) return objects;
                    input.close();
                    return objects;
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    if (input == null) return objects;
                    input.close();
                    return objects;
                }
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VersionFile {
        public String latestVersionID;

        private VersionFile() {
        }

        /*
         * Exception decompiling
         */
        public void save(IStorage file, IDesignerUser user) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public List<Version> load(IStorage file) throws IOException {
            ArrayList<Version> objects = new ArrayList<Version>();
            InputStream input = null;
            if (!file.exists()) return objects;
            try {
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    input = file.getInputStream();
                    Document document = parser.parse(input);
                    Element rootElement = document.getDocumentElement();
                    NodeList latestVersion = rootElement.getElementsByTagName("latestVersion");
                    this.latestVersionID = ((Element)latestVersion.item(0)).getAttribute("id");
                    NodeList versionElements = rootElement.getElementsByTagName("version");
                    int i = 0;
                    while (i < versionElements.getLength()) {
                        Element versionElement = (Element)versionElements.item(i);
                        String versionID = versionElement.getAttribute("id");
                        String time = versionElement.getAttribute("time");
                        String versionTitle = versionElement.getAttribute("title");
                        String isDraftString = versionElement.getAttribute("isDraft");
                        boolean isDraft = Boolean.parseBoolean(isDraftString);
                        String dueDate = versionElement.getAttribute("dueDate");
                        String width = versionElement.getAttribute("desireWidth");
                        String height = versionElement.getAttribute("desireHeight");
                        boolean isHasClosedManually = Boolean.parseBoolean(versionElement.getAttribute("hasClosedManually"));
                        String restartFrom = versionElement.getAttribute("restartFrom");
                        String description = versionElement.getAttribute("description");
                        boolean receiveEmail = Boolean.parseBoolean(versionElement.getAttribute("receiveEmail"));
                        boolean hasRestarted = Boolean.parseBoolean(versionElement.getAttribute("hasRestarted"));
                        Version version = new Version(versionID, time, isDraft, dueDate, width, height);
                        if (versionTitle == null) {
                            versionTitle = "";
                        }
                        version.setVersionTitle(versionTitle);
                        version.setHasClosedManually(isHasClosedManually);
                        version.setRestartFrom(restartFrom);
                        version.setDescription(description);
                        version.setReceiveEmail(receiveEmail);
                        version.setHasRestarted(hasRestarted);
                        NodeList reviewers = versionElement.getElementsByTagName("reviewer");
                        int j = 0;
                        while (j < reviewers.getLength()) {
                            Element reviewer = (Element)reviewers.item(j);
                            String reviewerName = reviewer.getAttribute("name");
                            String reviewerEmail = reviewer.getAttribute("email");
                            version.addReviewer(ReviewManager.getReviewManager().getReviewer(reviewerName, reviewerEmail));
                            ++j;
                        }
                        NodeList resources = versionElement.getElementsByTagName("resource");
                        int j2 = 0;
                        while (j2 < resources.getLength()) {
                            Element resource = (Element)resources.item(j2);
                            String path = resource.getAttribute("path");
                            version.addResource(path);
                            ++j2;
                        }
                        objects.add(version);
                        ++i;
                    }
                    return objects;
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                    if (input == null) return objects;
                    input.close();
                    return objects;
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    if (input == null) return objects;
                    input.close();
                    return objects;
                }
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
    }
}

