/*
 * Decompiled with CFR 0.152.
 */
package org.davinci.server.review.user;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.davinci.server.review.ReviewerVersion;
import org.davinci.server.user.IPerson;
import org.davinci.server.user.IPersonManager;
import org.maqetta.server.ServerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reviewer
implements IPerson {
    private String name;
    private String email;
    private Map<String, ReviewerVersion> versions = Collections.synchronizedMap(new HashMap());

    public Reviewer(String name, String email) {
        if (name == null) {
            name = "";
        }
        this.name = name;
        this.email = email;
    }

    @Override
    public String getUserID() {
        IPersonManager personManager;
        IPerson person;
        if (this.name.equals("") && (person = (personManager = ServerManager.getServerManager().getPersonManager()).getPersonByEmail(this.email)) != null) {
            this.name = person.getUserID();
        }
        return this.name;
    }

    public void setUserName(String name) {
        this.name = name;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void addReviewerVersion(ReviewerVersion version) {
        if (!this.versions.containsKey(version.getUniqueID())) {
            this.versions.put(version.getUniqueID(), version);
        }
    }

    public Iterator<ReviewerVersion> getReviewerVersions() {
        return this.versions.values().iterator();
    }

    @Override
    public String getDisplayName() {
        String displayName = this.getEmail();
        IPersonManager personManager = ServerManager.getServerManager().getPersonManager();
        IPerson person = personManager.getPersonByEmail(this.getEmail());
        if (person != null) {
            displayName = person.getDisplayName();
        }
        return displayName;
    }
}

