/*
 * Decompiled with CFR 0.152.
 */
package org.maqetta.server;

import java.io.EOFException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.davinci.server.internal.Activator;
import org.davinci.server.internal.command.CommandDescriptor;
import org.davinci.server.user.IUser;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.maqetta.server.Command;
import org.maqetta.server.ServerManager;

public class DavinciCommandServlet
extends HttpServlet {
    private static Logger theLogger = Logger.getLogger(DavinciCommandServlet.class.getName());
    private HashMap<String, CommandDescriptor> commands = new HashMap();
    private boolean initialized = false;

    private void log(HttpServletRequest req, String method, Throwable t, IUser user) {
        String query;
        theLogger.logp(Level.SEVERE, DavinciCommandServlet.class.getName(), method, "Unhandled Exception", t);
        String log = "RequestURL: " + req.getRequestURL().toString();
        if (user == null) {
            user = ServerManager.getServerManager().getUserManager().getUser(req);
        }
        if (user != null) {
            log = String.valueOf(log) + "\nUser: uid=" + user.getUserID();
            String email = user.getPerson().getEmail();
            if (email != null) {
                log = String.valueOf(log) + " email=" + email;
            }
        }
        if ((query = req.getQueryString()) != null) {
            log = String.valueOf(log) + "\nQuery: " + query;
        }
        Enumeration names = req.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String header = req.getHeader(name);
            if (header == null) continue;
            log = String.valueOf(log) + "\n" + name + ": " + header;
        }
        theLogger.info(log);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        IUser user = null;
        try {
            CommandDescriptor commandDescriptor;
            String pathInfo;
            resp.setCharacterEncoding("utf-8");
            if (!this.initialized) {
                this.initialize();
            }
            if ((pathInfo = req.getPathInfo()).startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
            if ((commandDescriptor = this.commands.get(pathInfo)).isPut()) {
                throw new AssertionError((Object)new String("commandDescriptor is Put in doGet"));
            }
            user = this.checkLogin(req, resp, commandDescriptor);
            if (user == null && !commandDescriptor.isNoLogin()) {
                return;
            }
            Command command = commandDescriptor.getCommand();
            command.init();
            command.handleCommand(req, resp, user);
            if (command.getErrorString() != null) {
                resp.sendError(400, command.getErrorString());
            } else if (command.getResponse() != null) {
                ServletOutputStream stream = resp.getOutputStream();
                stream.write(command.getResponse().getBytes("utf-8"));
            }
        }
        catch (RuntimeException re) {
            this.log(req, "doGet", re, user);
            throw re;
        }
        catch (EOFException eof) {
            throw eof;
        }
        catch (IOException ioe) {
            this.log(req, "doGet", ioe, user);
            throw ioe;
        }
        catch (Error e) {
            this.log(req, "doGet", e, user);
            throw e;
        }
    }

    private IUser checkLogin(HttpServletRequest req, HttpServletResponse resp, CommandDescriptor commandDescriptor) throws IOException {
        IUser user = ServerManager.getServerManager().getUserManager().getUser(req);
        if (user == null && !ServerManager.LOCAL_INSTALL && !commandDescriptor.isNoLogin()) {
            resp.sendError(401);
            return null;
        }
        return user;
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        IUser user = null;
        try {
            CommandDescriptor commandDescriptor;
            String pathInfo;
            if (!this.initialized) {
                this.initialize();
            }
            if ((pathInfo = req.getPathInfo()).startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
            if (!(commandDescriptor = this.commands.get(pathInfo)).isPut()) {
                throw new AssertionError((Object)new String("commandDescriptor is not Put in doPut"));
            }
            user = this.checkLogin(req, resp, commandDescriptor);
            if (user == null && !commandDescriptor.isNoLogin()) {
                return;
            }
            Command command = commandDescriptor.getCommand();
            command.init();
            command.handleCommand(req, resp, user);
        }
        catch (RuntimeException re) {
            this.log(req, "doPut", re, user);
            throw re;
        }
        catch (IOException ioe) {
            this.log(req, "doPut", ioe, user);
            throw ioe;
        }
        catch (Error e) {
            this.log(req, "doPut", e, user);
            throw e;
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        IUser user = null;
        try {
            CommandDescriptor commandDescriptor;
            String pathInfo;
            if (!this.initialized) {
                this.initialize();
            }
            if ((pathInfo = req.getPathInfo()).startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
            if ((commandDescriptor = this.commands.get(pathInfo)).isPut()) {
                throw new AssertionError((Object)new String("commandDescriptor is Put in doPost"));
            }
            user = this.checkLogin(req, resp, commandDescriptor);
            if (user == null && !commandDescriptor.isNoLogin()) {
                resp.sendError(401);
                return;
            }
            Command command = commandDescriptor.getCommand();
            command.init();
            command.handleCommand(req, resp, user);
            if (command.getErrorString() != null) {
                resp.sendError(400, command.getErrorString());
            } else if (command.getResponse() != null) {
                ServletOutputStream stream = resp.getOutputStream();
                stream.write(command.getResponse().getBytes("utf-8"));
            }
        }
        catch (RuntimeException re) {
            this.log(req, "doPost", re, user);
            throw re;
        }
        catch (IOException ioe) {
            this.log(req, "doPost", ioe, user);
            throw ioe;
        }
        catch (Error e) {
            this.log(req, "doPost", e, user);
            throw e;
        }
    }

    private void loadCommands() {
        IExtensionPoint point;
        IExtensionRegistry registry = Activator.getActivator().getRegistry();
        if (registry != null && (point = registry.getExtensionPoint("maqetta.core.server", "command")) != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if (elements[j].getName().equals("command")) {
                        CommandDescriptor cmd = new CommandDescriptor(elements[j]);
                        this.commands.put(cmd.getPath(), cmd);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void initialize() {
        if (this.commands.isEmpty()) {
            this.loadCommands();
        }
        this.initialized = true;
    }
}

