/*
 * Decompiled with CFR 0.152.
 */
package org.maqetta.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.eclipse.core.runtime.Path;
import org.maqetta.server.IVResource;

public class VDirectory
implements IVResource {
    private Vector children;
    private IVResource parent;
    private String name;
    private boolean readOnly;

    public VDirectory(IVResource parent, String name) {
        this(parent, name, false);
    }

    public VDirectory(IVResource parent, String name, boolean readOnly) {
        this.parent = parent;
        this.name = name;
        this.children = new Vector();
        this.readOnly = readOnly;
    }

    public boolean hasSource() {
        return false;
    }

    public boolean isSource() {
        return this.parent != null && this.parent.isSource();
    }

    public IVResource getSource() {
        return this;
    }

    protected VDirectory() {
        this.children = new Vector();
    }

    public IVResource create(String path) throws IOException {
        return null;
    }

    public void createNewInstance() throws IOException {
    }

    public boolean delete() throws IOException {
        return false;
    }

    public boolean exists() {
        return false;
    }

    public IVResource[] find(String path) {
        return this.findInLib(path);
    }

    private IVResource[] findInLib(String path) {
        String[] split = path.split("/");
        IVResource parent = this;
        int i = 0;
        while (parent != null && i < split.length) {
            if (split[i].indexOf("*") > -1 || split[i].indexOf("?") > -1) {
                return parent.findChildren(split[i]);
            }
            parent = parent.get(split[i]);
            ++i;
        }
        if (parent != null) {
            return new IVResource[]{parent};
        }
        return new IVResource[0];
    }

    public void flushWorkingCopy() {
    }

    public void setParent(IVResource parent) {
        this.parent = parent;
    }

    public InputStream getInputStreem() throws IOException {
        return null;
    }

    public String getName() {
        String name = this.name;
        if (name != null && name.length() > 0 && name.charAt(name.length() - 1) == '/') {
            name = name.substring(0, name.length() - 1);
        }
        if (name != null && name.length() > 0 && name.indexOf("./") == 0) {
            name = name.substring(1);
        }
        if (name != null && name.length() > 0 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return name;
    }

    public OutputStream getOutputStreem() throws FileNotFoundException, IOException {
        return null;
    }

    public IVResource getParent() {
        return this.parent;
    }

    public IVResource[] getParents() {
        IVResource parent = this.parent;
        ArrayList<IVResource> parents = new ArrayList<IVResource>();
        while (parent != null) {
            parents.add(0, parent);
            parent = parent.getParent();
        }
        return parents.toArray(new IVResource[parents.size()]);
    }

    public String getPath() {
        if (this.parent == null) {
            return this.name;
        }
        return new Path(this.parent.getPath()).append(this.name).toString();
    }

    public URI getURI() throws URISyntaxException {
        return null;
    }

    public boolean isDirectory() {
        return true;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isVirtual() {
        return true;
    }

    public IVResource[] listFiles() {
        return this.children.toArray(new IVResource[this.children.size()]);
    }

    public boolean mkdir() {
        return false;
    }

    public URLConnection openConnection() throws MalformedURLException, IOException {
        return null;
    }

    public void removeWorkingCopy() {
    }

    public void add(IVResource v) {
        int i = 0;
        while (i < this.children.size()) {
            IVResource child = (IVResource)this.children.get(i);
            if (child.getName().equals(v.getName())) {
                this.children.remove(i);
            }
            ++i;
        }
        v.setParent(this);
        this.children.add(v);
    }

    public IVResource get(String childName) {
        if (childName != null && childName.equals(".")) {
            return this;
        }
        int i = 0;
        while (i < this.children.size()) {
            IVResource child = (IVResource)this.children.get(i);
            if (child != null && child.getName().equals(childName)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return this.getPath();
    }

    public boolean isNew() {
        return false;
    }

    public boolean readOnly() {
        if (this.parent != null) {
            return this.readOnly || this.parent.readOnly();
        }
        return this.readOnly;
    }

    public IVResource[] findChildren(String childName) {
        String lastSegment;
        Path path = new Path(childName);
        Object filter = path.segment(0).equals("*") ? new NameFileFilter(path.lastSegment()) : ((lastSegment = path.lastSegment()).startsWith("*") ? new SuffixFileFilter(lastSegment.substring(1)) : null);
        Vector<IVResource> results = new Vector<IVResource>();
        int i = 0;
        while (i < this.children.size()) {
            IVResource r1 = (IVResource)this.children.get(i);
            File f1 = new File(r1.getName());
            if (filter.accept(f1)) {
                results.add(r1);
            }
            if (r1.isDirectory()) {
                IVResource[] more = r1.findChildren(childName);
                results.addAll(Arrays.asList(more));
            }
            ++i;
        }
        return results.toArray(new IVResource[results.size()]);
    }
}

