/*
 * Decompiled with CFR 0.152.
 */
package maqetta.server.orion;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import maqetta.server.orion.internal.Activator;
import org.eclipse.orion.server.useradmin.UserEmailUtil;

public class EmailOverrideFilter
implements Filter {
    private boolean called;
    private static final String EMAIL_CONFIRMATION_FILE = "/emails/EmailConfirmation.txt";
    private static final String EMAIL_CONFIRMATION_RESET_PASS_FILE = "/emails/EmailConfirmationPasswordReset.txt";
    private static final String EMAIL_PASSWORD_RESET = "/emails/PasswordReset.txt";
    private static final Logger theLogger = Logger.getLogger(EmailOverrideFilter.class.getName());

    public void init(FilterConfig arg0) throws ServletException {
        theLogger.info("Initializing...");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.called) {
            this.called = true;
            this.overrideEmailContents();
        }
        chain.doFilter(request, response);
    }

    private void overrideEmailContents() throws IOException, ServletException {
        theLogger.info("Overriding Orion email templates");
        UserEmailUtil util = UserEmailUtil.getUtil();
        try {
            this.setModifiedEmailContent(util, EMAIL_CONFIRMATION_FILE, "confirmationEmail");
            this.setModifiedEmailContent(util, EMAIL_CONFIRMATION_RESET_PASS_FILE, "confirmationResetPassEmail");
            this.setModifiedEmailContent(util, EMAIL_PASSWORD_RESET, "passwordResetEmail");
        }
        catch (IllegalArgumentException e) {
            this.handleException(e);
        }
        catch (SecurityException e) {
            this.handleException(e);
        }
        catch (URISyntaxException e) {
            this.handleException(e);
        }
        catch (InstantiationException e) {
            this.handleException(e);
        }
        catch (IllegalAccessException e) {
            this.handleException(e);
        }
        catch (InvocationTargetException e) {
            this.handleException(e);
        }
        catch (NoSuchFieldException e) {
            this.handleException(e);
        }
    }

    void handleException(Exception e) throws ServletException {
        throw new ServletException("Error overriding Orion email templates", (Throwable)e);
    }

    private void setModifiedEmailContent(UserEmailUtil util, String filename, String fieldname) throws URISyntaxException, IOException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        Object emailContent = this.createModifiedEmailContent(util, filename);
        if (emailContent != null) {
            Field confirmationEmail = UserEmailUtil.class.getDeclaredField(fieldname);
            confirmationEmail.setAccessible(true);
            confirmationEmail.set(util, emailContent);
        }
    }

    private Object createModifiedEmailContent(UserEmailUtil util, String filename) throws URISyntaxException, IOException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchFieldException {
        EmailContent ourEmailContent = new EmailContent(filename);
        Class<?> clazz = UserEmailUtil.class.getDeclaredClasses()[0];
        Constructor<?> ctor = clazz.getDeclaredConstructors()[0];
        ctor.setAccessible(true);
        Object emailContent = ctor.newInstance(util, filename);
        Field title = clazz.getDeclaredField("title");
        title.setAccessible(true);
        title.set(emailContent, ourEmailContent.getTitle());
        Field content = clazz.getDeclaredField("content");
        content.setAccessible(true);
        content.set(emailContent, ourEmailContent.getContent());
        return emailContent;
    }

    public void destroy() {
    }

    private class EmailContent {
        private String title;
        private String content;

        public String getTitle() {
            return this.title;
        }

        public String getContent() {
            return this.content;
        }

        public EmailContent(String fileName) throws URISyntaxException, IOException {
            URL entry = Activator.getDefault().getContext().getBundle().getEntry(fileName);
            if (entry == null) {
                throw new IOException("File not found: " + fileName);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(entry.openStream()));
            String line = null;
            try {
                this.title = reader.readLine();
                StringBuilder stringBuilder = new StringBuilder();
                String ls = System.getProperty("line.separator");
                while ((line = reader.readLine()) != null) {
                    stringBuilder.append(line);
                    stringBuilder.append(ls);
                }
                this.content = stringBuilder.toString();
            }
            finally {
                reader.close();
            }
        }
    }
}

