/*
 * Decompiled with CFR 0.152.
 */
package maqetta.server.orion;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Vector;
import maqetta.core.server.util.VResourceUtils;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.maqetta.server.IStorage;

public class VOrionStorage
implements IStorage {
    IFileStore store;
    String name;
    VOrionStorage parent;

    public VOrionStorage(String name, IFileStore store, VOrionStorage parent) {
        this.store = store;
        this.name = name;
        this.parent = parent;
    }

    public String getPath() {
        VOrionStorage parent = this.getParentFile();
        if (parent == null) {
            return this.name;
        }
        return new Path(parent.getPath()).append(this.name).toString();
    }

    public boolean readOnly() {
        return this.store.fetchInfo().getAttribute(2);
    }

    public boolean delete() throws IOException {
        try {
            this.store.delete(0, null);
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDirectory() {
        return this.store.fetchInfo().isDirectory();
    }

    public boolean exists() {
        return this.store.fetchInfo().exists();
    }

    public String getAbsolutePath() {
        return this.getPath();
    }

    public IStorage[] listFiles() {
        Vector<VOrionStorage> results = new Vector<VOrionStorage>();
        try {
            String[] children = this.store.childNames(0, null);
            int i = 0;
            while (i < children.length) {
                VOrionStorage child = new VOrionStorage(children[i], this.store.getChild(children[i]), this);
                results.add(child);
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return results.toArray(new IStorage[results.size()]);
    }

    public URI toURI() {
        return this.store.toURI();
    }

    public VOrionStorage getParentFile() {
        return this.parent;
    }

    public OutputStream getOutputStream() throws IOException {
        try {
            return this.store.openOutputStream(0, null);
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.store.openInputStream(0, null);
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }

    public void createNewFile() throws IOException {
        try {
            OutputStream stream = this.store.openOutputStream(0, null);
            stream.flush();
            stream.close();
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }

    public void mkdir() throws IOException {
        try {
            this.store.mkdir(0, null);
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }

    public boolean mkdirs() throws IOException {
        try {
            VOrionStorage parent = this.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            this.store.mkdir(0, null);
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
        return true;
    }

    public void renameTo(IStorage file) throws IOException {
        try {
            this.store.move(((VOrionStorage)file).store, 0, null);
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }

    public IStorage newInstance(String name) {
        VOrionStorage parent = this.getParentFile();
        while (parent != null && parent.getParentFile() != null) {
            parent = parent.getParentFile();
        }
        if (parent == null) {
            parent = this;
        }
        Path path = new Path(name);
        int i = 0;
        while (i < path.segmentCount()) {
            parent = (VOrionStorage)parent.create(path.segment(i));
            ++i;
        }
        return parent;
    }

    public IStorage newInstance(IStorage parent, String name) {
        return parent.create(name);
    }

    public IStorage newInstance(URI uri) {
        throw new RuntimeException("Unimplemented method");
    }

    public IStorage create(String name) {
        Path path = new Path(name);
        VOrionStorage result = this;
        int i = 0;
        int len = path.segmentCount();
        while (i < len) {
            IFileStore childStore = result.store.getChild(path.segment(i));
            result = new VOrionStorage(path.segment(i), childStore, result);
            ++i;
        }
        return result;
    }

    public Collection<IStorage> findFiles(IStorage parentFolder, String pathStr, boolean ignoreCase) {
        return this.findFiles(parentFolder, pathStr, ignoreCase, false);
    }

    public Collection<IStorage> findFiles(IStorage parentFolder, String pathStr, boolean ignoreCase, boolean immediate) {
        String[] parts = pathStr.split("/", 2);
        IStorage[] children = parentFolder.listFiles();
        Vector<IStorage> found = new Vector<IStorage>();
        IStorage[] iStorageArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStorage child = iStorageArray[n2];
            if (VResourceUtils.matches((String)child.getName(), (String)parts[0])) {
                if (parts.length > 1) {
                    found.addAll(this.findFiles(child, parts[1], ignoreCase, true));
                } else {
                    found.add(child);
                }
            }
            if (child.isDirectory() && !immediate) {
                found.addAll(this.findFiles(child, pathStr, ignoreCase));
            }
            ++n2;
        }
        return found;
    }

    public boolean isFile() {
        return !this.store.fetchInfo().isDirectory();
    }

    public String[] list() {
        try {
            return this.store.childNames(0, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    public String toString() {
        return this.getPath();
    }
}

