/*
 * Decompiled with CFR 0.152.
 */
package maqetta.server.orion.internal;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import maqetta.server.orion.MaqettaProjectDecorator;
import maqetta.server.orion.internal.IRegistryListener;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.core.IWebResourceDecorator;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer,
IRegistryChangeListener {
    public static volatile BundleContext bundleContext;
    public static final boolean DEBUG = true;
    public static final String LOCATION_WORKSPACE_SERVLET = "/workspace";
    public static final String LOCATION_FILE_SERVLET = "/file";
    public static final String LOCATION_PROJECT_SERVLET = "/project";
    public static final String PROP_USER_AREA = "org.eclipse.orion.server.core.userArea";
    private ArrayList<IRegistryListener> registryChangeListeners = new ArrayList();
    static Activator singleton;
    private static Bundle bundle;
    private PackageAdmin packageAdmin;
    private IExtensionRegistry registry;
    private ServiceTracker packageAdminTracker;
    private ServiceTracker registryTracker;
    private IFileStore rootStore;
    private Map<String, URI> aliases = Collections.synchronizedMap(new HashMap());
    private URI rootStoreURI;
    private ServiceRegistration<IWebResourceDecorator> maqProjectDecoratorRegistration;

    public static Activator getDefault() {
        return singleton;
    }

    public IFileStore getRootStore() {
        return this.rootStore;
    }

    public BundleContext getContext() {
        return bundleContext;
    }

    public static Activator getActivator() {
        return singleton;
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.getContext().getService(reference);
        if (service instanceof PackageAdmin && this.packageAdmin == null) {
            this.packageAdmin = (PackageAdmin)service;
        }
        if (service instanceof IExtensionRegistry && this.registry == null) {
            this.registry = (IExtensionRegistry)service;
            this.registryChanged(null);
            this.registry.addRegistryChangeListener((IRegistryChangeListener)this, "maqetta.core.server");
        }
        return service;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        if (service == this.packageAdmin) {
            this.packageAdmin = null;
        }
        if (service == this.registry) {
            this.registry = null;
        }
    }

    public IExtensionRegistry getRegistry() {
        return this.registry;
    }

    public void addRegistryChangeListener(IRegistryListener listener) {
        this.registryChangeListeners.add(listener);
    }

    public Bundle getOtherBundle(String symbolicName) {
        Bundle[] bundles = this.packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        for (IRegistryListener listener : this.registryChangeListeners) {
            listener.registryChanged();
        }
    }

    public IPath getPlatformLocation() {
        Collection refs;
        BundleContext context = Activator.getDefault().getContext();
        try {
            refs = context.getServiceReferences(Location.class, Location.INSTANCE_FILTER);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        if (refs.isEmpty()) {
            return null;
        }
        ServiceReference ref = (ServiceReference)refs.iterator().next();
        Location location = (Location)context.getService(ref);
        try {
            if (location == null) {
                return null;
            }
            URL root = location.getURL();
            if (root == null) {
                return null;
            }
            Path path = new Path(root.toExternalForm().substring(5));
            return path;
        }
        finally {
            context.ungetService(ref);
        }
    }

    public URI getRootLocationURI() {
        return this.rootStoreURI;
    }

    private void initializeFileSystem() {
        IPath location = this.getPlatformLocation();
        if (location == null) {
            throw new RuntimeException("Unable to compute base file system location");
        }
        this.rootStore = EFS.getLocalFileSystem().getStore(location);
        try {
            this.rootStore.mkdir(0, null);
            this.rootStoreURI = this.rootStore.toURI();
        }
        catch (CoreException e) {
            throw new RuntimeException("Instance location is read only: " + this.rootStore, e);
        }
        if (System.getProperty(PROP_USER_AREA) == null) {
            System.setProperty(PROP_USER_AREA, this.rootStore.getFileStore((IPath)new Path(".metadata/.plugins/org.eclipse.orion.server.core/userArea")).toString());
        }
    }

    public URI lookupAlias(String alias) {
        return this.aliases.get(alias);
    }

    public void registerAlias(String alias, URI location) {
        this.aliases.put(alias, location);
    }

    private void registerDecorators() {
        this.maqProjectDecoratorRegistration = bundleContext.registerService(IWebResourceDecorator.class, (Object)new MaqettaProjectDecorator(), null);
    }

    public void start(BundleContext context) throws Exception {
        bundle = context.getBundle();
        singleton = this;
        bundleContext = context;
        this.packageAdminTracker = new ServiceTracker(context, PackageAdmin.class.getName(), (ServiceTrackerCustomizer)this);
        this.packageAdminTracker.open();
        this.registryTracker = new ServiceTracker(context, IExtensionRegistry.class.getName(), (ServiceTrackerCustomizer)this);
        this.registryTracker.open();
        this.initializeFileSystem();
        this.registerDecorators();
    }

    public static Bundle getBundle() {
        return bundle;
    }

    public void stop(BundleContext context) throws Exception {
        this.unregisterDecorators();
        bundleContext = null;
    }

    private void unregisterDecorators() {
        if (this.maqProjectDecoratorRegistration != null) {
            this.maqProjectDecoratorRegistration.unregister();
            this.maqProjectDecoratorRegistration = null;
        }
    }
}

