/*
 * Decompiled with CFR 0.152.
 */
package maqetta.server.orion.user;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.orion.server.useradmin.IOrionCredentialsService;
import org.eclipse.orion.server.useradmin.User;
import org.eclipse.orion.server.useradmin.UserServiceHelper;
import org.json.JSONException;
import org.json.JSONObject;

public class LoginFixUpFilter
implements Filter {
    public static final String USERS_SERVLET_ALIAS = "/users";
    public static final String LOGIN_SERVLET_ALIAS = "/login";
    public static final String EMAILCONF_SERVLET_ALIAS = "/useremailconfirmation";
    private static final Logger theLogger = Logger.getLogger(LoginFixUpFilter.class.getName());
    private static final int USERNAME_MIN_LENGTH = 3;
    private static final int USERNAME_MAX_LENGTH = 20;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if ("POST".equals(httpRequest.getMethod())) {
            String servletPath = httpRequest.getServletPath();
            String pathInfo = httpRequest.getPathInfo();
            if (servletPath.equals(USERS_SERVLET_ALIAS) && pathInfo == null) {
                if (this.handleRegistration(httpRequest, httpResponse, chain)) {
                    return;
                }
            } else if (servletPath.equals(LOGIN_SERVLET_ALIAS) && pathInfo.equals("/form")) {
                if (this.handleLogin(httpRequest, httpResponse, chain)) {
                    return;
                }
            } else if (servletPath.equals(EMAILCONF_SERVLET_ALIAS) && pathInfo == null) {
                this.handleEmailConfig(httpRequest, httpResponse, chain);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private boolean handleRegistration(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String login = request.getParameter("login");
        if (login != null && login.length() > 0) {
            return false;
        }
        String email = request.getParameter("email");
        String name = request.getParameter("Name");
        IOrionCredentialsService userAdmin = this.getUserAdmin();
        RequestWrapper modifiedRequest = new RequestWrapper(request);
        modifiedRequest.setParameter("login", LoginFixUpFilter.generateUserId(userAdmin, email));
        if (name == null || name.length() == 0) {
            modifiedRequest.setParameter("Name", email);
        }
        chain.doFilter((ServletRequest)modifiedRequest, (ServletResponse)response);
        return true;
    }

    private boolean handleLogin(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String login = request.getParameter("login");
        if (login != null && login.length() > 0) {
            return false;
        }
        String email = request.getParameter("email");
        IOrionCredentialsService userAdmin = this.getUserAdmin();
        User user = userAdmin.getUser("email", email);
        if (user == null) {
            user = userAdmin.getUser("login", email);
            if (user != null) {
                user = this.fixOldUser(userAdmin, user);
            }
            if (user == null) {
                theLogger.finest("User object not found for " + email + ". Perhaps that user isn't registered yet.");
                return false;
            }
        }
        RequestWrapper modifiedRequest = new RequestWrapper(request);
        modifiedRequest.setParameter("login", user.getLogin());
        chain.doFilter((ServletRequest)modifiedRequest, (ServletResponse)response);
        return true;
    }

    private void handleEmailConfig(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        User user;
        IOrionCredentialsService userAdmin;
        JSONObject data;
        block9: {
            String email;
            block8: {
                block7: {
                    data = null;
                    data = OrionServlet.readJSONRequest((HttpServletRequest)request);
                    email = data.getString("email");
                    String login = data.getString("login");
                    if (login == null || login.length() <= 0) break block7;
                    RequestWrapper modifiedRequest = new RequestWrapper(request);
                    modifiedRequest.setData(data != null ? data.toString() : "");
                    chain.doFilter((ServletRequest)modifiedRequest, (ServletResponse)response);
                    return;
                }
                userAdmin = this.getUserAdmin();
                user = userAdmin.getUser("email", email);
                if (user == null) break block8;
                RequestWrapper modifiedRequest = new RequestWrapper(request);
                modifiedRequest.setData(data != null ? data.toString() : "");
                chain.doFilter((ServletRequest)modifiedRequest, (ServletResponse)response);
                return;
            }
            user = userAdmin.getUser("login", email);
            if (user != null) break block9;
            RequestWrapper modifiedRequest = new RequestWrapper(request);
            modifiedRequest.setData(data != null ? data.toString() : "");
            chain.doFilter((ServletRequest)modifiedRequest, (ServletResponse)response);
            return;
        }
        try {
            try {
                user = this.fixOldUser(userAdmin, user);
            }
            catch (JSONException e) {
                theLogger.log(Level.SEVERE, "Could not parse json request", e);
                RequestWrapper modifiedRequest = new RequestWrapper(request);
                modifiedRequest.setData(data != null ? data.toString() : "");
                chain.doFilter((ServletRequest)modifiedRequest, (ServletResponse)response);
                return;
            }
        }
        catch (Throwable throwable) {
            RequestWrapper modifiedRequest = new RequestWrapper(request);
            modifiedRequest.setData(data != null ? data.toString() : "");
            chain.doFilter((ServletRequest)modifiedRequest, (ServletResponse)response);
            throw throwable;
        }
        RequestWrapper modifiedRequest = new RequestWrapper(request);
        modifiedRequest.setData(data != null ? data.toString() : "");
        chain.doFilter((ServletRequest)modifiedRequest, (ServletResponse)response);
    }

    private IOrionCredentialsService getUserAdmin() {
        return UserServiceHelper.getDefault().getUserStore();
    }

    public static String generateUserId(IOrionCredentialsService userAdmin, String email) {
        String login = email.split("@", 2)[0];
        if ((login = login.replaceAll("[.\\-_+]", "")).length() > 20) {
            login = login.substring(0, 20);
        }
        if (LoginFixUpFilter.validateLogin(login)) {
            int counter = 0;
            String candidate = login;
            while (userAdmin.getUser("login", candidate) != null) {
                candidate = String.valueOf(login) + ++counter;
            }
            return candidate;
        }
        int randlen = new Random().nextInt(18) + 3;
        while (userAdmin.getUser("login", login = UUID.randomUUID().toString().replaceAll("-", "").substring(0, randlen)) != null) {
        }
        return login;
    }

    public User fixOldUser(IOrionCredentialsService userAdmin, User user) {
        IStatus status;
        String email = user.getLogin();
        String name = user.getName();
        String uid = user.getUid();
        user.setLogin(LoginFixUpFilter.generateUserId(userAdmin, email));
        user.setEmail(email);
        if (name.length() == 0) {
            user.setName(email);
        }
        if (!(status = userAdmin.updateUser(uid, user)).isOK()) {
            return null;
        }
        user.confirmEmail();
        userAdmin.updateUser(uid, user);
        if (!status.isOK()) {
            return null;
        }
        return user;
    }

    private static boolean validateLogin(String login) {
        if (login == null || login.length() == 0) {
            return false;
        }
        int length = login.length();
        if (length < 3) {
            return false;
        }
        if (length > 20) {
            return false;
        }
        if (login.equals("ultramegatron")) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!Character.isLetterOrDigit(login.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    class RequestWrapper
    extends HttpServletRequestWrapper {
        private HashMap<String, String[]> updatedMap;
        private String data;

        public RequestWrapper(HttpServletRequest request) {
            super(request);
            this.updatedMap = new HashMap();
            this.data = null;
            this.updatedMap.putAll(request.getParameterMap());
        }

        public String getParameter(String name) {
            String[] values = this.updatedMap.get(name);
            if (values != null && values.length > 0) {
                return values[0];
            }
            return null;
        }

        public Map<String, String[]> getParameterMap() {
            return this.updatedMap;
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.updatedMap.keySet());
        }

        public String[] getParameterValues(String name) {
            return this.updatedMap.get(name);
        }

        public ServletInputStream getInputStream() throws IOException {
            if (this.data == null) {
                return super.getInputStream();
            }
            String charset = this.getRequest().getCharacterEncoding();
            if (charset == null) {
                charset = Charset.defaultCharset().name();
            }
            byte[] bytes = this.data.getBytes(charset);
            final ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            return new ServletInputStream(){

                public int read() throws IOException {
                    return in.read();
                }
            };
        }

        public BufferedReader getReader() throws IOException {
            if (this.data == null) {
                return super.getReader();
            }
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
        }

        public void setParameter(String name, String value) {
            String[] values = new String[]{value};
            this.updatedMap.put(name, values);
        }

        public void setData(String newData) {
            this.data = newData;
        }
    }
}

