/*
 * Decompiled with CFR 0.152.
 */
package maqetta.server.orion.user;

import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import maqetta.core.server.user.manager.PersonManagerImpl;
import org.davinci.server.user.IPerson;
import org.davinci.server.user.UserException;
import org.eclipse.orion.server.useradmin.IOrionCredentialsService;
import org.eclipse.orion.server.useradmin.User;
import org.eclipse.orion.server.useradmin.UserServiceHelper;

public class OrionPersonManager
extends PersonManagerImpl {
    private static final Logger theLogger = Logger.getLogger(OrionPersonManager.class.getName());

    public IPerson addPerson(String userName, String password, String email) throws UserException {
        OrionPersonManager.assertValidUserId(userName);
        IPerson person = (IPerson)this.persons.get(userName);
        if (person != null) {
            return person;
        }
        person = new OrionPersonImpl(userName, password, email);
        this.persons.put(userName, person);
        theLogger.logp(Level.INFO, OrionPersonManager.class.getName(), "addPerson", "User added with following info: userName = " + userName + ", email = " + email);
        return person;
    }

    public IPerson login(String userName, String password) {
        OrionPersonManager.assertValidUserId(userName);
        IPerson person = (IPerson)this.persons.get(userName);
        if (person != null) {
            return person;
        }
        try {
            return this.addPerson(userName, null, null);
        }
        catch (UserException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isValidPassword(String userName, String password) {
        return true;
    }

    protected void savePersons() {
    }

    public IPerson getPerson(String userName) {
        OrionPersonManager.assertValidUserId(userName);
        IPerson person = (IPerson)this.persons.get(userName);
        if (person != null) {
            return person;
        }
        try {
            return this.addPerson(userName, null, null);
        }
        catch (UserException e) {
            e.printStackTrace();
            return null;
        }
    }

    public IPerson getPersonByEmail(String email) {
        User user = OrionPersonManager.getOrionUserByEmail(email);
        if (user != null) {
            try {
                return this.addPerson(user.getUid(), null, email);
            }
            catch (UserException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected void loadUsers() {
    }

    public IPerson[] getPersons(String email, int resultNumber, int start) {
        HashMap<String, OrionPersonImpl> users = new HashMap<String, OrionPersonImpl>();
        Set names = this.persons.keySet();
        int i = 0;
        for (String name : names) {
            String personEmail = ((IPerson)this.persons.get(name)).getEmail();
            if (name.indexOf(email) < 0 && personEmail.indexOf(email) < 0) continue;
            if (i >= start && i < start + resultNumber) {
                users.put(personEmail, new OrionPersonImpl(name, "", personEmail));
            }
            ++i;
        }
        return users.values().toArray(new IPerson[0]);
    }

    public String getPhotoRepositoryPath() {
        return "not-implemented";
    }

    private static void assertValidUserId(String uid) {
        if (uid.indexOf("@") != -1) {
            throw new Error("Invalid user ID");
        }
    }

    private static IOrionCredentialsService getUserAdmin() {
        return UserServiceHelper.getDefault().getUserStore();
    }

    protected static User getOrionUser(String key, String val) {
        return OrionPersonManager.getUserAdmin().getUser(key, val);
    }

    protected static User getOrionUser(String userName) {
        OrionPersonManager.assertValidUserId(userName);
        return OrionPersonManager.getOrionUser("uid", userName);
    }

    protected static User getOrionUserByEmail(String email) {
        return OrionPersonManager.getOrionUser("email", email);
    }

    static class OrionPersonImpl
    implements IPerson {
        private String email;
        private String name;

        public OrionPersonImpl(String userName, String password, String email) {
            this.name = userName;
            this.email = email;
        }

        public String getEmail() {
            if (this.email != null) {
                return this.email;
            }
            User user = OrionPersonManager.getOrionUser(this.getUserID());
            if (user != null) {
                this.email = user.getEmail();
            } else {
                theLogger.logp(Level.SEVERE, OrionPersonManager.class.getName(), "getEmail", "User '" + this.getUserID() + "' could not be found in IOrionCredentialsService.");
            }
            return this.email;
        }

        public String getUserID() {
            return this.name;
        }

        public String getDisplayName() {
            String displayName = "";
            User user = OrionPersonManager.getOrionUser(this.getUserID());
            if (user != null) {
                displayName = user.getName();
            } else {
                theLogger.logp(Level.SEVERE, OrionPersonManager.class.getName(), "getDisplayName", "User '" + this.getUserID() + "' could not be found in IOrionCredentialsService.");
            }
            if (displayName.length() < 1) {
                displayName = this.getEmail();
            }
            return displayName;
        }
    }
}

