/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.store.Directory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexDeletionPolicyWrapper
implements IndexDeletionPolicy {
    private final IndexDeletionPolicy deletionPolicy;
    private volatile Map<Long, IndexCommit> solrVersionVsCommits = new ConcurrentHashMap<Long, IndexCommit>();
    private final Map<Long, Long> reserves = new ConcurrentHashMap<Long, Long>();
    private volatile IndexCommit latestCommit;
    private final ConcurrentHashMap<Long, AtomicInteger> savedCommits = new ConcurrentHashMap();

    public IndexDeletionPolicyWrapper(IndexDeletionPolicy deletionPolicy) {
        this.deletionPolicy = deletionPolicy;
    }

    public IndexCommit getLatestCommit() {
        return this.latestCommit;
    }

    public IndexDeletionPolicy getWrappedDeletionPolicy() {
        return this.deletionPolicy;
    }

    public void setReserveDuration(Long indexVersion, long reserveTime) {
        Long previousTime;
        long timeToSet = System.currentTimeMillis() + reserveTime;
        while ((previousTime = this.reserves.put(indexVersion, timeToSet)) != null && previousTime > timeToSet) {
            timeToSet = previousTime;
        }
    }

    private void cleanReserves() {
        long currentTime = System.currentTimeMillis();
        for (Map.Entry<Long, Long> entry : this.reserves.entrySet()) {
            if (entry.getValue() >= currentTime) continue;
            this.reserves.remove(entry.getKey());
        }
    }

    private List<IndexCommitWrapper> wrap(List<IndexCommit> list) {
        ArrayList<IndexCommitWrapper> result = new ArrayList<IndexCommitWrapper>();
        for (IndexCommit indexCommit : list) {
            result.add(new IndexCommitWrapper(indexCommit));
        }
        return result;
    }

    public synchronized void saveCommitPoint(Long indexCommitVersion) {
        AtomicInteger reserveCount = this.savedCommits.get(indexCommitVersion);
        if (reserveCount == null) {
            reserveCount = new AtomicInteger();
        }
        reserveCount.incrementAndGet();
        this.savedCommits.put(indexCommitVersion, reserveCount);
    }

    public synchronized void releaseCommitPoint(Long indexCommitVersion) {
        AtomicInteger reserveCount = this.savedCommits.get(indexCommitVersion);
        if (reserveCount == null) {
            return;
        }
        if (reserveCount.decrementAndGet() <= 0) {
            this.savedCommits.remove(indexCommitVersion);
        }
    }

    public void onInit(List list) throws IOException {
        List<IndexCommitWrapper> wrapperList = this.wrap(list);
        this.deletionPolicy.onInit(wrapperList);
        this.updateCommitPoints(wrapperList);
        this.cleanReserves();
    }

    public void onCommit(List list) throws IOException {
        List<IndexCommitWrapper> wrapperList = this.wrap(list);
        this.deletionPolicy.onCommit(wrapperList);
        this.updateCommitPoints(wrapperList);
        this.cleanReserves();
    }

    public IndexCommit getCommitPoint(Long version) {
        return this.solrVersionVsCommits.get(version);
    }

    public Map<Long, IndexCommit> getCommits() {
        return this.solrVersionVsCommits;
    }

    private void updateCommitPoints(List<IndexCommitWrapper> list) {
        ConcurrentHashMap<Long, IndexCommit> map = new ConcurrentHashMap<Long, IndexCommit>();
        for (IndexCommitWrapper wrapper : list) {
            if (wrapper.isDeleted()) continue;
            map.put(wrapper.getVersion(), wrapper.delegate);
        }
        this.solrVersionVsCommits = map;
        this.latestCommit = list.get((int)(list.size() - 1)).delegate;
    }

    private class IndexCommitWrapper
    extends IndexCommit {
        IndexCommit delegate;

        IndexCommitWrapper(IndexCommit delegate) {
            this.delegate = delegate;
        }

        public String getSegmentsFileName() {
            return this.delegate.getSegmentsFileName();
        }

        public Collection getFileNames() throws IOException {
            return this.delegate.getFileNames();
        }

        public Directory getDirectory() {
            return this.delegate.getDirectory();
        }

        public void delete() {
            Long version = this.delegate.getVersion();
            Long reserve = (Long)IndexDeletionPolicyWrapper.this.reserves.get(version);
            if (reserve != null && System.currentTimeMillis() < reserve) {
                return;
            }
            if (IndexDeletionPolicyWrapper.this.savedCommits.containsKey(version)) {
                return;
            }
            this.delegate.delete();
        }

        public int getSegmentCount() {
            return this.delegate.getSegmentCount();
        }

        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public long getVersion() {
            return this.delegate.getVersion();
        }

        public long getGeneration() {
            return this.delegate.getGeneration();
        }

        public boolean isDeleted() {
            return this.delegate.isDeleted();
        }

        public long getTimestamp() throws IOException {
            return this.delegate.getTimestamp();
        }

        public Map getUserData() throws IOException {
            return this.delegate.getUserData();
        }
    }
}

