/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.sftpfile;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.sftpfile.ChannelCache;
import org.eclipse.orion.internal.server.sftpfile.SynchronizedChannel;
import org.eclipse.osgi.util.NLS;

public class SftpFileStore
extends FileStore {
    private static final Path HOME = new Path("~");
    private final URI host;
    private final IPath path;
    private IFileInfo cachedInfo;

    private static FileInfo attrsToInfo(String fileName, SftpATTRS stat) {
        FileInfo info = new FileInfo(fileName);
        info.setExists(true);
        info.setDirectory(stat.isDir());
        info.setLength(stat.getSize());
        info.setLastModified((long)stat.getMTime() * 1000L);
        return info;
    }

    public SftpFileStore(URI host, IPath path) {
        this.host = host;
        this.path = path.segmentCount() == 0 ? HOME : path;
    }

    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        SynchronizedChannel channel = this.getChannel();
        try {
            Vector<ChannelSftp.LsEntry> children = channel.ls(this.getPathString(channel));
            ArrayList<FileInfo> childInfos = new ArrayList<FileInfo>(children.size());
            for (ChannelSftp.LsEntry child : children) {
                if (this.shouldSkip(child.getFilename())) continue;
                childInfos.add(SftpFileStore.attrsToInfo(child.getFilename(), child.getAttrs()));
            }
            return childInfos.toArray(new IFileInfo[childInfos.size()]);
        }
        catch (Exception e) {
            ChannelCache.flush(this.host);
            throw this.wrap(e);
        }
    }

    private String getPathString(SynchronizedChannel channel) throws SftpException {
        if (this.path.segmentCount() > 0 && this.path.segment(0).equals(HOME.segment(0))) {
            Path result = new Path(channel.getHome());
            result = result.append(this.path.removeFirstSegments(1));
            return result.toString();
        }
        return this.path.toString();
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        SynchronizedChannel channel = this.getChannel();
        try {
            Vector<ChannelSftp.LsEntry> children = channel.ls(this.getPathString(channel));
            ArrayList<String> childNames = new ArrayList<String>(children.size());
            for (ChannelSftp.LsEntry child : children) {
                if (this.shouldSkip(child.getFilename())) continue;
                childNames.add(child.getFilename());
            }
            return childNames.toArray(new String[childNames.size()]);
        }
        catch (Exception e) {
            ChannelCache.flush(this.host);
            throw this.wrap(e);
        }
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        SynchronizedChannel channel = this.getChannel();
        try {
            SftpATTRS stat = channel.stat(this.getPathString(channel));
            this.cachedInfo = SftpFileStore.attrsToInfo(this.getName(), stat);
            return this.cachedInfo;
        }
        catch (Exception e) {
            ChannelCache.flush(this.host);
            throw this.wrap(e);
        }
    }

    private SynchronizedChannel getChannel() throws CoreException {
        return ChannelCache.getChannel(this.host);
    }

    public IFileStore getChild(String name) {
        return new SftpFileStore(this.host, this.path.append(name));
    }

    public String getName() {
        return this.path.lastSegment();
    }

    public IFileStore getParent() {
        return new SftpFileStore(this.host, this.path.removeLastSegments(1));
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        SynchronizedChannel channel = this.getChannel();
        try {
            try {
                channel.mkdir(this.getPathString(channel));
            }
            catch (SftpException sftpException) {
                SftpATTRS stat = channel.stat(this.getPathString(channel));
                if (stat.isDir()) {
                    return this;
                }
                throw sftpException;
            }
        }
        catch (Exception e) {
            ChannelCache.flush(this.host);
            throw this.wrap(e);
        }
        return this;
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        SynchronizedChannel channel = this.getChannel();
        try {
            return new BufferedInputStream(channel.get(this.getPathString(channel)));
        }
        catch (Exception e) {
            ChannelCache.flush(this.host);
            throw this.wrap(e);
        }
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        SynchronizedChannel channel = this.getChannel();
        try {
            return new BufferedOutputStream(channel.put(this.getPathString(channel)));
        }
        catch (Exception e) {
            ChannelCache.flush(this.host);
            throw this.wrap(e);
        }
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        SynchronizedChannel channel = this.getChannel();
        try {
            IFileInfo info = this.cachedInfo;
            if (info == null) {
                info = this.fetchInfo();
            }
            if (info.isDirectory()) {
                channel.rmdir(this.getPathString(channel));
            } else {
                channel.rm(this.getPathString(channel));
            }
        }
        catch (Exception e) {
            ChannelCache.flush(this.host);
            throw this.wrap(e);
        }
    }

    protected boolean shouldSkip(String fileName) {
        return ".".equals(fileName) || "..".equals(fileName);
    }

    public URI toURI() {
        return URIUtil.append((URI)this.host, (String)this.path.toString());
    }

    private CoreException wrap(Exception e) {
        String msg = NLS.bind((String)"Failure connecting to {0}", (Object)this.host, (Object)e.getMessage());
        return new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.servlets", msg, (Throwable)e));
    }
}

