/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core.users;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.orion.internal.server.core.Activator;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class OrionPreferencesLocal
extends EclipsePreferences {
    private int segmentCount;
    private String qualifier;
    private IPath location;
    private IEclipsePreferences loadLevel;
    private static Set<String> loadedNodes = Collections.synchronizedSet(new HashSet());
    private static boolean initialized = false;
    private static IPath baseLocation = OrionPreferencesLocal.computeLocation();

    public OrionPreferencesLocal() {
        this(null, null);
    }

    private static IPath computeLocation() {
        Collection refs;
        BundleContext context = Activator.getDefault().getContext();
        try {
            refs = context.getServiceReferences(Location.class, Location.INSTANCE_FILTER);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        if (refs.isEmpty()) {
            return null;
        }
        ServiceReference ref = (ServiceReference)refs.iterator().next();
        Location location = (Location)context.getService(ref);
        try {
            URL root;
            if (location == null) {
                return null;
            }
            try {
                root = location.getDataArea("org.eclipse.orion.server.core");
            }
            catch (IOException iOException) {
                context.ungetService(ref);
                return null;
            }
            if (root == null) {
                return null;
            }
            Path path = new Path(root.toExternalForm().substring(5));
            return path;
        }
        finally {
            context.ungetService(ref);
        }
    }

    private OrionPreferencesLocal(EclipsePreferences parent, String name) {
        super(parent, name);
        this.initializeChildren();
        String path = this.absolutePath();
        this.segmentCount = OrionPreferencesLocal.getSegmentCount((String)path);
        if (this.segmentCount < 2) {
            return;
        }
        this.qualifier = OrionPreferencesLocal.getSegment((String)path, (int)1);
        if (this.qualifier == null) {
            return;
        }
        if (baseLocation != null) {
            this.location = this.computeLocation(baseLocation, this.qualifier);
        }
    }

    protected IPath getLocation() {
        return this.location;
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.name());
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            OrionPreferencesLocal node = this;
            int i = 2;
            while (i < this.segmentCount) {
                node = (EclipsePreferences)node.parent();
                ++i;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeChildren() {
        if (initialized || this.parent == null) {
            return;
        }
        try {
            OrionPreferencesLocal orionPreferencesLocal = this;
            synchronized (orionPreferencesLocal) {
                block10: {
                    if (baseLocation != null) break block10;
                    return;
                }
                String[] names = this.computeChildren(baseLocation);
                int i = 0;
                while (i < names.length) {
                    this.addChild(names[i], null);
                    ++i;
                }
            }
        }
        finally {
            initialized = true;
        }
    }

    protected EclipsePreferences internalCreate(EclipsePreferences nodeParent, String nodeName, Object context) {
        return new OrionPreferencesLocal(nodeParent, nodeName);
    }
}

