/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.formopenid;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.authentication.formopenid.FormOpenIdAuthenticationService;
import org.eclipse.orion.server.authentication.openid.OpenIdException;
import org.eclipse.orion.server.authentication.openid.OpenIdHelper;
import org.eclipse.orion.server.authentication.openid.OpendIdProviderDescription;
import org.eclipse.orion.server.authentication.openid.OpenidConsumer;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.resources.Base64;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageOpenidsServlet
extends HttpServlet {
    private static final long serialVersionUID = 5478748783512325610L;
    private FormOpenIdAuthenticationService authenticationService;
    private OpenidConsumer consumer;

    public ManageOpenidsServlet(FormOpenIdAuthenticationService formOpenIdAuthenticationService) {
        this.authenticationService = formOpenIdAuthenticationService;
    }

    private String getConfiguredOpenIds() {
        return (String)(this.authenticationService.getDefaultAuthenticationProperties() == null ? null : this.authenticationService.getDefaultAuthenticationProperties().get("openids"));
    }

    private static void writeOpenIdError(String error, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter("redirect") == null) {
            resp.setContentType("text/html; charset=UTF-8");
            PrintWriter out = resp.getWriter();
            out.println("<html><head></head>");
            out.print("<body onload=\"window.opener.handleOpenIDResponse((window.location+'').split('?')[1],'");
            out.print(error);
            out.println("');window.close();\">");
            out.println("</body>");
            out.println("</html>");
            out.close();
            return;
        }
        resp.setContentType("text/html; charset=UTF-8");
        PrintWriter out = resp.getWriter();
        out.println("<html><head></head>");
        String url = req.getParameter("redirect");
        url = url.replaceAll("/&error(\\=[^&]*)?(?=&|$)|^error(\\=[^&]*)?(&|$)/", "");
        out.print("<body onload=\"window.location.replace('");
        out.print(url.toString());
        if (url.contains("?")) {
            out.print("&error=");
        } else {
            out.print("?error=");
        }
        out.print(new String(Base64.encode((byte[])error.getBytes())));
        out.println("');\">");
        out.println("</body>");
        out.println("</html>");
    }

    private List<OpendIdProviderDescription> getSupportedOpenids(HttpServletRequest req) {
        List<OpendIdProviderDescription> openidProviders;
        String customOpenids;
        String string = customOpenids = req.getAttribute("openids") == null ? this.getConfiguredOpenIds() : (String)req.getAttribute("openids");
        if (customOpenids == null || customOpenids.trim().length() == 0) {
            openidProviders = OpenIdHelper.getDefaultOpenIdProviders();
        } else {
            try {
                openidProviders = OpenIdHelper.getSupportedOpenIdProviders(customOpenids);
            }
            catch (JSONException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication", "Cannot load openid list, JSON format expected", (Throwable)e));
                openidProviders = OpenIdHelper.getDefaultOpenIdProviders();
            }
        }
        return openidProviders;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = req.getPathInfo() == null ? "" : req.getPathInfo();
        try {
            if (pathInfo.startsWith("/openid")) {
                String openid = req.getParameter("openid");
                if (openid != null) {
                    this.consumer = OpenIdHelper.redirectToOpenIdProvider(req, response, this.consumer);
                    return;
                }
                String op_return = req.getParameter("op_return");
                if (op_return != null) {
                    OpenIdHelper.handleOpenIdReturn(req, response, this.consumer);
                    return;
                }
            }
        }
        catch (OpenIdException e) {
            ManageOpenidsServlet.writeOpenIdError(e.getMessage(), req, response);
            return;
        }
        JSONArray providersJson = new JSONArray();
        for (OpendIdProviderDescription provider : this.getSupportedOpenids(req)) {
            JSONObject providerJson = new JSONObject();
            try {
                providerJson.put("Name", (Object)provider.getName());
                providerJson.put("Image", (Object)provider.getImage());
                providerJson.put("Url", (Object)provider.getAuthSite());
                providersJson.put((Object)providerJson);
            }
            catch (JSONException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication", "Exception writing OpenId provider " + provider.getName(), (Throwable)e));
            }
        }
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        writer.append(providersJson.toString());
        writer.flush();
    }
}

