/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.useradmin;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.orion.server.user.profile.IOrionUserProfileService;
import org.eclipse.orion.server.useradmin.IOrionCredentialsService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserServiceHelper {
    private Map<String, IOrionCredentialsService> userStores = new HashMap<String, IOrionCredentialsService>();
    private IOrionCredentialsService defaultUserAdmin;
    private IOrionUserProfileService userProfileService;
    private static UserServiceHelper singleton;

    public static UserServiceHelper getDefault() {
        return singleton;
    }

    public void activate() {
        singleton = this;
    }

    public void deactivate() {
        singleton = null;
    }

    public Set<String> getSupportedUserStores() {
        return this.userStores.keySet();
    }

    public void setUserAdmin(IOrionCredentialsService userAdmin) {
        if (userAdmin instanceof IOrionCredentialsService) {
            IOrionCredentialsService eclipseWebUserAdmin = userAdmin;
            this.userStores.put(eclipseWebUserAdmin.getStoreName(), eclipseWebUserAdmin);
            if (this.defaultUserAdmin == null || "Orion".equals(eclipseWebUserAdmin.getStoreName())) {
                this.defaultUserAdmin = eclipseWebUserAdmin;
            }
        }
    }

    public void unsetUserAdmin(IOrionCredentialsService userAdmin) {
        if (userAdmin instanceof IOrionCredentialsService) {
            Iterator<IOrionCredentialsService> iterator;
            IOrionCredentialsService eclipseWebUserAdmin = userAdmin;
            this.userStores.remove(eclipseWebUserAdmin.getStoreName());
            if (userAdmin.equals(this.defaultUserAdmin) && (iterator = this.userStores.values().iterator()).hasNext()) {
                this.defaultUserAdmin = iterator.next();
            }
        }
    }

    public IOrionCredentialsService getUserStore() {
        return this.defaultUserAdmin;
    }

    public IOrionUserProfileService getUserProfileService() {
        return this.userProfileService;
    }

    public void bindUserProfileService(IOrionUserProfileService userProfileService) {
        this.userProfileService = userProfileService;
    }

    public void unbindUserProfileService(IOrionUserProfileService userProfileService) {
        this.userProfileService = null;
    }
}

