/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.core.Activator;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;

public class LogHelper {
    private static FrameworkLogEntry getLog(IStatus status) {
        IStatus[] children;
        IStatus coreStatus;
        int stackCode;
        Throwable t = status.getException();
        ArrayList<FrameworkLogEntry> childlist = new ArrayList<FrameworkLogEntry>();
        int n = stackCode = t instanceof CoreException ? 1 : 0;
        if (stackCode == 1 && (coreStatus = ((CoreException)t).getStatus()) != null) {
            childlist.add(LogHelper.getLog(coreStatus));
        }
        if (status.isMultiStatus()) {
            children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                childlist.add(LogHelper.getLog(children[i]));
                ++i;
            }
        }
        children = childlist.size() == 0 ? null : childlist.toArray(new FrameworkLogEntry[childlist.size()]);
        return new FrameworkLogEntry(status.getPlugin(), status.getSeverity(), status.getCode(), status.getMessage(), stackCode, t, (FrameworkLogEntry[])children);
    }

    public static void log(IStatus status) {
        FrameworkLog log = Activator.getFrameworkLog();
        if (log != null) {
            log.log(LogHelper.getLog(status));
        } else {
            System.out.println(status.getMessage());
            if (status.getException() != null) {
                status.getException().printStackTrace();
            }
        }
    }

    public static void log(Throwable t) {
        LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core", "Internal server error", t));
    }
}

