/*
 * Decompiled with CFR 0.152.
 */
package maqetta.server.orion;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.core.IWebResourceDecorator;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MaqettaProjectDecorator
implements IWebResourceDecorator {
    public void addAtributesFor(HttpServletRequest request, URI resource, JSONObject representation) {
        Path resourcePath = new Path(String.valueOf(request.getServletPath()) + (request.getPathInfo() == null ? "" : request.getPathInfo()));
        if ("/workspace".equals(request.getServletPath()) && resourcePath.segmentCount() == 2) {
            try {
                JSONArray projObjects = representation.getJSONArray("Children");
                int i = 0;
                while (i < projObjects.length()) {
                    JSONObject projectObject = (JSONObject)projObjects.get(i);
                    if (this.checkMaqettaProject(projectObject)) {
                        projectObject.put("maqettaProject", true);
                    } else {
                        projectObject.put("maqettaProject", false);
                    }
                    ++i;
                }
            }
            catch (JSONException jSONException) {
                try {
                    if (this.checkMaqettaProject(representation)) {
                        representation.put("maqettaProject", true);
                    } else {
                        representation.put("rootFolder", true);
                    }
                }
                catch (JSONException e1) {
                    e1.printStackTrace();
                }
                catch (CoreException e2) {
                    e2.printStackTrace();
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if ("/file".equals(request.getServletPath())) {
            try {
                JSONArray projObjects = representation.getJSONArray("Children");
                int i = 0;
                while (i < projObjects.length()) {
                    JSONObject projectObject = (JSONObject)projObjects.get(i);
                    if (projectObject.getBoolean("Directory")) {
                        projectObject.put("maqettaProject", false);
                    }
                    ++i;
                }
            }
            catch (JSONException jSONException) {
                try {
                    representation.put("maqettaProject", true);
                }
                catch (JSONException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private boolean checkMaqettaProject(JSONObject projectObject) throws JSONException, CoreException {
        WebProject project = WebProject.fromId((String)projectObject.getString("Id"));
        IFileStore settings = project.getProjectStore().getChild(".settings");
        if (settings == null) {
            return false;
        }
        IFileStore libFile = settings.getChild("libs.settings");
        return libFile != null && libFile.fetchInfo().exists();
    }
}

