/*
 * Decompiled with CFR 0.152.
 */
package maqetta.server.orion.user;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import maqetta.core.server.user.User;
import maqetta.core.server.util.VResourceUtils;
import maqetta.server.orion.VOrionResource;
import maqetta.server.orion.VOrionWorkspace;
import maqetta.server.orion.VOrionWorkspaceStorage;
import maqetta.server.orion.internal.Activator;
import org.davinci.server.user.IPerson;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.eclipse.orion.internal.server.servlets.workspace.WebUser;
import org.eclipse.orion.internal.server.servlets.workspace.WebWorkspace;
import org.eclipse.orion.internal.server.servlets.workspace.WorkspaceResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.users.OrionScope;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.maqetta.server.IProjectTemplatesManager;
import org.maqetta.server.IStorage;
import org.maqetta.server.IVResource;
import org.maqetta.server.ServerManager;
import org.osgi.framework.Bundle;

public class OrionUser
extends User {
    private WebUser webuser = WebUser.fromUserId((String)this.getUserID());
    private WebWorkspace webWorkspace;
    protected static final IScopeContext scope = new OrionScope();
    protected IEclipsePreferences store;
    private static String DEFAULT_WORKSPACE = "MyWorkspace";
    private static final Logger theLogger = Logger.getLogger(ServerManager.class.getName());

    public OrionUser(IPerson person) throws CoreException {
        super(person);
        try {
            JSONArray workspaceJson = this.webuser.getWorkspacesJSON();
            if (workspaceJson.length() != 0) {
                JSONObject workObj = (JSONObject)workspaceJson.get(0);
                this.webWorkspace = WebWorkspace.fromId((String)workObj.getString("Id"));
            } else {
                this.webWorkspace = this.createWorkspace(DEFAULT_WORKSPACE);
            }
        }
        catch (JSONException e) {
            throw new CoreException((IStatus)new Status(4, null, null, (Throwable)e));
        }
        this.userDirectory = new VOrionWorkspaceStorage(this.webWorkspace, this.getUserID());
        this.rebuildWorkspace();
    }

    public IVResource newWorkspaceRoot() {
        return new VOrionWorkspace((VOrionWorkspaceStorage)this.userDirectory);
    }

    public IVResource createOrionProject(String name) throws IOException {
        return this.workspace.create(name);
    }

    private IStorage getStorage() {
        return this.userDirectory;
    }

    public boolean isProject(String projectName) {
        Collection baseFile = this.userDirectory.findFiles(this.userDirectory, String.valueOf(projectName) + "/" + ".settings" + "/" + "libs.settings", false);
        return baseFile.size() > 0;
    }

    public String computeMaqettaPath(String orionPathStr, String contextStr) throws CoreException {
        Path orionPath = new Path(orionPathStr);
        Path contextPath = new Path(contextStr);
        assert (contextPath.isPrefixOf((IPath)orionPath)) : "`orionPath` doesn't include expected servlet context";
        orionPath = orionPath.removeFirstSegments(orionPath.matchingFirstSegments((IPath)contextPath));
        String workspaceId = orionPath.segment(1);
        String projectName = orionPath.segment(2);
        WebProject proj = WebWorkspace.fromId((String)workspaceId).getProjectByName(projectName);
        String path = projectName;
        IFileStore child = null;
        int i = 3;
        while (i < orionPath.segmentCount()) {
            child = proj.getProjectStore().getChild(orionPath.segment(i));
            path = String.valueOf(path) + "/" + child.getName();
            ++i;
        }
        return path;
    }

    public IVResource createProject(String projectName, String projectToClone, String projectTemplateDirectoryName, String basePath, boolean initFiles) throws IOException {
        if (this.isProject(projectName)) {
            return this.getResource(projectName);
        }
        IVResource project = this.createOrionProject(projectName);
        IStorage userDir = this.getUserDirectory();
        IStorage projectDir = userDir.newInstance(projectName);
        if (basePath != null && !basePath.equals("")) {
            project.create(String.valueOf(basePath) + "/");
        }
        if (initFiles) {
            IProjectTemplatesManager projectTemplatesManager;
            IStorage projectTemplatesDirectory;
            IStorage templateDir;
            List extensions = ServerManager.getServerManager().getExtensions("initialUserFiles", "initalUserFile");
            for (IConfigurationElement libraryElement : extensions) {
                String path = libraryElement.getAttribute("path");
                String name = libraryElement.getDeclaringExtension().getContributor().getName();
                Bundle bundle = Activator.getActivator().getOtherBundle(name);
                IStorage file = this.getStorage().newInstance(project.getPath());
                if (basePath != null && !basePath.equals("")) {
                    file = file.newInstance(String.valueOf(project.getPath()) + "/" + basePath);
                }
                VResourceUtils.copyDirectory((IStorage)file, (String)path, (Bundle)bundle);
            }
            IStorage basePathDir = basePath != null && !basePath.equals("") ? projectDir.newInstance(projectDir, basePath) : projectDir;
            if (projectTemplateDirectoryName != null && !projectTemplateDirectoryName.equals("") && (templateDir = (projectTemplatesDirectory = (projectTemplatesManager = ServerManager.getServerManager().getProjectTemplatesManager()).getProjectTemplatesDirectory()).newInstance(projectTemplatesDirectory, projectTemplateDirectoryName)).exists()) {
                IStorage[] files = templateDir.listFiles();
                int i = 0;
                while (i < files.length) {
                    IStorage destination;
                    IStorage file = files[i];
                    if (file.isDirectory() && file.getName().equals(".settings")) {
                        IStorage destinationDir = projectDir.newInstance(projectDir, ".settings");
                        destinationDir.mkdirs();
                        IStorage[] dotSettingsFiles = file.listFiles();
                        int j = 0;
                        while (j < dotSettingsFiles.length) {
                            IStorage settingsFile = dotSettingsFiles[j];
                            IStorage destination2 = file.newInstance(file, settingsFile.getName());
                            if (settingsFile.getName().equals("libs.settings") && basePath != null && !basePath.equals("")) {
                                this.copyFileAddWebContent(settingsFile, destination2);
                            } else {
                                this.copyFile(settingsFile, destination2);
                            }
                            ++j;
                        }
                    } else if (file.isFile()) {
                        destination = basePathDir.newInstance(basePathDir, file.getName());
                        this.copyFile(file, destination);
                    } else if (file.isDirectory()) {
                        destination = basePathDir.newInstance(basePathDir, file.getName());
                        this.copyDirectory(file, destination);
                    }
                    ++i;
                }
            }
            if (projectToClone != null && !projectToClone.equals("")) {
                IStorage projectToCloneDir = userDir.newInstance(projectToClone);
                IStorage webContentDir = projectToCloneDir.newInstance(projectToCloneDir, "WebContent");
                Boolean oldProjectIsEclipse = webContentDir.exists();
                Boolean newProjectIsEclipse = basePath != null && !basePath.equals("");
                if (projectToCloneDir.exists()) {
                    IStorage[] files = projectToCloneDir.listFiles();
                    int i = 0;
                    while (i < files.length) {
                        IStorage file = files[i];
                        String filename = file.getPath();
                        Path path = new Path(filename);
                        if (!file.isFile() || path.segmentCount() <= 0 || !path.segment(1).equals(".project")) {
                            IStorage destination;
                            if (file.isDirectory() && file.getName().equals(".settings")) {
                                IStorage destinationDir = projectDir.newInstance(projectDir, ".settings");
                                destinationDir.mkdirs();
                                IStorage[] dotSettingsFiles = file.listFiles();
                                int j = 0;
                                while (j < dotSettingsFiles.length) {
                                    IStorage settingsFile = dotSettingsFiles[j];
                                    if (settingsFile.getName().equals("libs.settings")) {
                                        IStorage destination3 = destinationDir.newInstance(destinationDir, settingsFile.getName());
                                        if (!oldProjectIsEclipse.booleanValue() && newProjectIsEclipse.booleanValue()) {
                                            this.copyFileAddWebContent(settingsFile, destination3);
                                        } else if (oldProjectIsEclipse.booleanValue() && !newProjectIsEclipse.booleanValue()) {
                                            this.copyFileStripWebContent(settingsFile, destination3);
                                        } else {
                                            this.copyFile(settingsFile, destination3);
                                        }
                                    }
                                    ++j;
                                }
                            } else if (file.isDirectory() && path.segmentCount() > 1 && path.segment(1).equals("WebContent")) {
                                this.copyDirectory(file, basePathDir);
                            } else if (file.isFile()) {
                                destination = basePathDir.newInstance(basePathDir, file.getName());
                                this.copyFile(file, destination);
                            } else if (file.isDirectory()) {
                                destination = basePathDir.newInstance(basePathDir, file.getName());
                                this.copyDirectory(file, destination);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        this.addBaseSettings(projectName);
        this.rebuildWorkspace();
        return project;
    }

    public boolean isValid(String path) {
        return true;
    }

    public IVResource createResource(String path, boolean isFolder) throws IOException {
        String path1 = path;
        if (path1.startsWith("./")) {
            path1 = path.substring(2);
        } else if (path.length() > 0 && path.charAt(0) == '.') {
            path1 = path.substring(1);
        }
        if (!this.isValid(String.valueOf(this.userDirectory.getAbsolutePath()) + "/" + path1)) {
            return null;
        }
        IVResource userFile = this.workspace.create(path);
        if (isFolder) {
            userFile.mkdir();
        } else {
            userFile.createNewInstance();
        }
        return userFile;
    }

    public IVResource getUserFile(String p1) {
        IPath a2;
        IStorage workingCopy;
        if (p1 == null || p1.equals("")) {
            return this.workspace;
        }
        String path = p1;
        while (path.length() > 0 && (path.charAt(0) == '.' || path.charAt(0) == '/' || path.charAt(0) == '\\')) {
            path = path.substring(1);
        }
        IPath a = new Path(this.userDirectory.getAbsolutePath()).append(path);
        IStorage parentStorage = this.userDirectory.newInstance(a.toString());
        if (!parentStorage.exists() && !(workingCopy = this.userDirectory.newInstance((a2 = new Path(this.userDirectory.getAbsolutePath()).append(String.valueOf(path) + ".workingcopy")).toString())).exists()) {
            return null;
        }
        Object parent = this.workspace;
        Path halfPath = new Path("");
        int i = 1;
        int len = a.segmentCount();
        while (i < len) {
            halfPath = halfPath.append(a.segment(i));
            IStorage f = this.userDirectory.newInstance(halfPath.toString());
            parent = new VOrionResource(f, (IVResource)parent, a.segment(i));
            ++i;
        }
        return parent;
    }

    public WebWorkspace createWorkspace(String workspaceName) throws CoreException {
        WebWorkspace workspace = this.webuser.createWorkspace(workspaceName);
        URI loc = URI.create("/workspace");
        JSONObject result = WorkspaceResourceHandler.toJSON((WebWorkspace)workspace, (URI)loc, (URI)loc);
        String resultLocation = result.optString("Location");
        AuthorizationService.addUserRight((String)this.getUserID(), (String)URI.create(resultLocation).getPath());
        AuthorizationService.addUserRight((String)this.getUserID(), (String)(String.valueOf(URI.create(resultLocation).getPath()) + "/*"));
        String filePath = "/file/" + workspace.getId();
        AuthorizationService.addUserRight((String)this.getUserID(), (String)filePath);
        AuthorizationService.addUserRight((String)this.getUserID(), (String)(String.valueOf(filePath) + "/*"));
        return workspace;
    }

    public IVResource[] listFiles(String path) {
        IVResource r1;
        IVResource[] found = new IVResource[]{};
        if (path == null || path.equals(".")) {
            path = "";
        }
        if ((r1 = this.getResource(path)) != null && r1.isDirectory()) {
            found = r1.listFiles();
        }
        if ((r1 = this.getLibFile(path)) != null && r1.isDirectory()) {
            IVResource[] list = r1.listFiles();
            found = VResourceUtils.merge((IVResource[])found, (IVResource[])list);
        }
        return found;
    }

    private void copyFileAddWebContent(IStorage source, IStorage destination) throws IOException {
        this.copyFileAddStripWebContent(source, destination, "add");
    }

    private void copyFileStripWebContent(IStorage source, IStorage destination) throws IOException {
        this.copyFileAddStripWebContent(source, destination, "strip");
    }

    private void copyFileAddStripWebContent(IStorage source, IStorage destination, String action) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            try {
                String line;
                destination.getParentFile().mkdirs();
                in = source.getInputStream();
                out = destination.getOutputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
                while ((line = br.readLine()) != null) {
                    String adjustedLine = action.equals("add") ? line.replace("virtualRoot=\"", "virtualRoot=\"WebContent/") : (action.equals("strip") ? line.replace("virtualRoot=\"WebContent/", "virtualRoot=\"") : line);
                    int len = adjustedLine.length();
                    ByteBuffer bb = ByteBuffer.wrap(adjustedLine.getBytes());
                    out.write(bb.array(), 0, len);
                    out.write(10);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            String desc = "IOException with createProjectTemplate";
            theLogger.log(Level.SEVERE, desc, e);
            throw new Error(desc, e);
        }
    }
}

