/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geometry.shape;

import org.apache.lucene.spatial.geometry.shape.Geometry2D;
import org.apache.lucene.spatial.geometry.shape.IntersectCase;
import org.apache.lucene.spatial.geometry.shape.LineSegment;
import org.apache.lucene.spatial.geometry.shape.Point2D;
import org.apache.lucene.spatial.geometry.shape.Rectangle;
import org.apache.lucene.spatial.geometry.shape.Vector2D;

public class Ellipse
implements Geometry2D {
    private Point2D center;
    private double a;
    private double b;
    private double k1;
    private double k2;
    private double k3;
    private double s;
    private double c;

    public Ellipse() {
        this.center = new Point2D(0.0, 0.0);
    }

    private double SQR(double d) {
        return d * d;
    }

    public Ellipse(Point2D p1, Point2D p2, double angle) {
        this.center = new Point2D();
        this.center.x((p1.x() + p2.x()) * 0.5);
        this.center.y((p1.y() + p2.y()) * 0.5);
        double angleRad = Math.toRadians(angle);
        this.c = Math.cos(angleRad);
        this.s = Math.sin(angleRad);
        double dx = Math.abs(p2.x() - p1.x()) * 0.5;
        double dy = Math.abs(p2.y() - p1.y()) * 0.5;
        if (dx >= dy) {
            this.a = dx;
            this.b = dy;
        } else {
            this.a = dy;
            this.b = dx;
        }
        this.k1 = this.SQR(this.c / this.a) + this.SQR(this.s / this.b);
        this.k2 = 2.0 * this.s * this.c * (1.0 / this.SQR(this.a) - 1.0 / this.SQR(this.b));
        this.k3 = this.SQR(this.s / this.a) + this.SQR(this.c / this.b);
    }

    public int intersect(LineSegment seg, Point2D pt0, Point2D pt1) {
        if (pt0 == null) {
            pt0 = new Point2D();
        }
        if (pt1 == null) {
            pt1 = new Point2D();
        }
        double x1 = this.center.x();
        double y1 = this.center.y();
        double u1 = seg.A.x();
        double v1 = seg.A.y();
        double u2 = seg.B.x();
        double v2 = seg.B.y();
        double dx = u2 - u1;
        double dy = v2 - v1;
        double q0 = this.k1 * this.SQR(u1 - x1) + this.k2 * (u1 - x1) * (v1 - y1) + this.k3 * this.SQR(v1 - y1) - 1.0;
        double q1 = 2.0 * this.k1 * dx * (u1 - x1) + this.k2 * dx * (v1 - y1) + this.k2 * dy * (u1 - x1) + 2.0 * this.k3 * dy * (v1 - y1);
        double q2 = this.k1 * this.SQR(dx) + this.k2 * dx * dy + this.k3 * this.SQR(dy);
        double d = this.SQR(q1) - 4.0 * q0 * q2;
        if (d < 0.0) {
            return 0;
        }
        if (d == 0.0) {
            double t = -q1 / (2.0 * q2);
            if (0.0 <= t && t <= 1.0) {
                pt0.x(u1 + t * dx);
                pt0.y(v1 + t * dy);
                return 1;
            }
            return 0;
        }
        int n = 0;
        double q = Math.sqrt(d);
        double t = (-q1 - q) / (2.0 * q2);
        if (0.0 <= t && t <= 1.0) {
            pt0.x(u1 + t * dx);
            pt0.y(v1 + t * dy);
            ++n;
        }
        if (0.0 <= (t = (-q1 + q) / (2.0 * q2)) && t <= 1.0) {
            if (n == 0) {
                pt0.x(u1 + t * dx);
                pt0.y(v1 + t * dy);
                ++n;
            } else {
                pt1.x(u1 + t * dx);
                pt1.y(v1 + t * dy);
                ++n;
            }
        }
        return n;
    }

    public IntersectCase intersect(Rectangle r) {
        Point2D ul = new Point2D(r.MinPt().x(), r.MaxPt().y());
        Point2D ur = new Point2D(r.MaxPt().x(), r.MaxPt().y());
        Point2D ll = new Point2D(r.MinPt().x(), r.MinPt().y());
        Point2D lr = new Point2D(r.MaxPt().x(), r.MinPt().y());
        if (this.contains(ul) && this.contains(ur) && this.contains(ll) && this.contains(lr)) {
            return IntersectCase.CONTAINS;
        }
        LineSegment bottom = new LineSegment(ll, lr);
        Point2D pt0 = new Point2D();
        Point2D pt1 = new Point2D();
        if (this.intersect(bottom, pt0, pt1) > 0) {
            return IntersectCase.INTERSECTS;
        }
        LineSegment top = new LineSegment(ul, ur);
        if (this.intersect(top, pt0, pt1) > 0) {
            return IntersectCase.INTERSECTS;
        }
        LineSegment left = new LineSegment(ll, ul);
        if (this.intersect(left, pt0, pt1) > 0) {
            return IntersectCase.INTERSECTS;
        }
        LineSegment right = new LineSegment(lr, ur);
        if (this.intersect(right, pt0, pt1) > 0) {
            return IntersectCase.INTERSECTS;
        }
        return r.contains(this.center) ? IntersectCase.WITHIN : IntersectCase.OUTSIDE;
    }

    public double area() {
        throw new UnsupportedOperationException();
    }

    public Point2D centroid() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Point2D pt) {
        double dx = pt.x() - this.center.x();
        double dy = pt.y() - this.center.y();
        double eq = this.k1 * this.SQR(dx) + this.k2 * dx * dy + this.k3 * this.SQR(dy) - 1.0;
        return eq <= 0.0;
    }

    public void translate(Vector2D v) {
        throw new UnsupportedOperationException();
    }
}

