require({cache:{
'url:dijit/templates/CheckedMenuItem.html':"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitemcheckbox\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuItemIcon dijitCheckedMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t\t<span class=\"dijitCheckedMenuItemIconChar\">&#10003;</span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,labelNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">&#160;</td>\n</tr>\n",
'davinci/html/CSSModel':function(){
define({
shorthand: [
	['border',['border-width', 'border-style','border-color', 'border-top', 'border-left', 'border-right', 'border-bottom']],
	['border-width',['border-top-width','border-right-width','border-bottom-width','border-left-width']],
	['border-style',['border-top-style','border-right-style','border-bottom-style','border-left-style']],
	['border-color',['border-top-color','border-right-color','border-bottom-color','border-left-color']],
	['border-bottom',['border-bottom-width', 'border-bottom-style','border-bottom-color']],
	['border-top',['border-top-width', 'border-top-style','border-top-color']],
	['border-left',['border-left-width', 'border-left-style','border-left-color']],
	['border-right',['border-right-width', 'border-right-style','border-right-color']],
	['font',['font-size', 'line-height','font-weight','font-style','font-family','line-height']],
	['border-radius',['border-top-left-radius', 'border-top-right-radius','border-bottom-right-radius','border-bottom-left-radius']],
	['-moz-border-radius',['-moz-border-radius-topleft', '-moz-border-radius-topright','-moz-border-radius-bottomright','-moz-border-radius-bottomleft']],
	['margin',['margin-top', 'margin-right', 'margin-bottom', 'margin-left']],
	['padding',['padding-top', 'padding-right', 'padding-bottom', 'padding-left']],
	['background',['background-color', 'background-image', 'background-repeat', 'background-position', 'background-attachment']]
]});
},
'dijit/form/TextBox':function(){
define([
	"dojo/_base/declare", // declare
	"dojo/dom-construct", // domConstruct.create
	"dojo/dom-style", // domStyle.getComputedStyle
	"dojo/_base/kernel", // kernel.deprecated
	"dojo/_base/lang", // lang.hitch
	"dojo/sniff", // has("ie") has("mozilla")
	"./_FormValueWidget",
	"./_TextBoxMixin",
	"dojo/text!./templates/TextBox.html",
	"../main"	// to export dijit._setSelectionRange, remove in 2.0
], function(declare, domConstruct, domStyle, kernel, lang, has,
			_FormValueWidget, _TextBoxMixin, template, dijit){

	// module:
	//		dijit/form/TextBox

	var TextBox = declare("dijit.form.TextBox", [_FormValueWidget, _TextBoxMixin], {
		// summary:
		//		A base class for textbox form inputs

		templateString: template,
		_singleNodeTemplate: '<input class="dijit dijitReset dijitLeft dijitInputField" data-dojo-attach-point="textbox,focusNode" autocomplete="off" type="${type}" ${!nameAttrSetting} />',

		_buttonInputDisabled: has("ie") ? "disabled" : "", // allows IE to disallow focus, but Firefox cannot be disabled for mousedown events

		baseClass: "dijitTextBox",

		postMixInProperties: function(){
			var type = this.type.toLowerCase();
			if(this.templateString && this.templateString.toLowerCase() == "input" || ((type == "hidden" || type == "file") && this.templateString == this.constructor.prototype.templateString)){
				this.templateString = this._singleNodeTemplate;
			}
			this.inherited(arguments);
		},

		postCreate: function(){
			this.inherited(arguments);

			if(has("ie") < 9){
				// IE INPUT tag fontFamily has to be set directly using STYLE
				// the defer gives IE a chance to render the TextBox and to deal with font inheritance
				this.defer(function(){
					try{
						var s = domStyle.getComputedStyle(this.domNode); // can throw an exception if widget is immediately destroyed
						if(s){
							var ff = s.fontFamily;
							if(ff){
								var inputs = this.domNode.getElementsByTagName("INPUT");
								if(inputs){
									for(var i=0; i < inputs.length; i++){
										inputs[i].style.fontFamily = ff;
									}
								}
							}
						}
					}catch(e){/*when used in a Dialog, and this is called before the dialog is
					 shown, s.fontFamily would trigger "Invalid Argument" error.*/}
				});
			}
		},

		_onInput: function(e){
			this.inherited(arguments);
			if(this.intermediateChanges){ // _TextBoxMixin uses onInput
				// allow the key to post to the widget input box
				this.defer(function(){ this._handleOnChange(this.get('value'), false); });
			}
		},

		_setPlaceHolderAttr: function(v){
			this._set("placeHolder", v);
			if(!this._phspan){
				this._attachPoints.push('_phspan');
				// dijitInputField class gives placeHolder same padding as the input field
				// parent node already has dijitInputField class but it doesn't affect this <span>
				// since it's position: absolute.
				this._phspan = domConstruct.create('span',{ onmousedown:function(e){ e.preventDefault(); }, className:'dijitPlaceHolder dijitInputField'},this.textbox,'after');
			}
			this._phspan.innerHTML="";
			this._phspan.appendChild(this._phspan.ownerDocument.createTextNode(v));
			this._updatePlaceHolder();
		},

		_updatePlaceHolder: function(){
			if(this._phspan){
				this._phspan.style.display=(this.placeHolder&&!this.focused&&!this.textbox.value)?"":"none";
			}
		},

		_setValueAttr: function(value, /*Boolean?*/ priorityChange, /*String?*/ formattedValue){
			this.inherited(arguments);
			this._updatePlaceHolder();
		},

		getDisplayedValue: function(){
			// summary:
			//		Deprecated.  Use get('displayedValue') instead.
			// tags:
			//		deprecated
			kernel.deprecated(this.declaredClass+"::getDisplayedValue() is deprecated. Use get('displayedValue') instead.", "", "2.0");
			return this.get('displayedValue');
		},

		setDisplayedValue: function(/*String*/ value){
			// summary:
			//		Deprecated.  Use set('displayedValue', ...) instead.
			// tags:
			//		deprecated
			kernel.deprecated(this.declaredClass+"::setDisplayedValue() is deprecated. Use set('displayedValue', ...) instead.", "", "2.0");
			this.set('displayedValue', value);
		},

		_onBlur: function(e){
			if(this.disabled){ return; }
			this.inherited(arguments);
			this._updatePlaceHolder();

			if(has("mozilla")){
				if(this.selectOnClick){
					// clear selection so that the next mouse click doesn't reselect
					this.textbox.selectionStart = this.textbox.selectionEnd = undefined;
				}
			}
		},

		_onFocus: function(/*String*/ by){
			if(this.disabled || this.readOnly){ return; }
			this.inherited(arguments);
			this._updatePlaceHolder();
		}
	});

	if(has("ie")){
		TextBox.prototype._isTextSelected = function(){
			var range = this.ownerDocument.selection.createRange();
			var parent = range.parentElement();
			return parent == this.textbox && range.text.length > 0;
		};

		// Overrides definition of _setSelectionRange from _TextBoxMixin (TODO: move to _TextBoxMixin.js?)
		dijit._setSelectionRange = _TextBoxMixin._setSelectionRange = function(/*DomNode*/ element, /*Number?*/ start, /*Number?*/ stop){
			if(element.createTextRange){
				var r = element.createTextRange();
				r.collapse(true);
				r.moveStart("character", -99999); // move to 0
				r.moveStart("character", start); // delta from 0 is the correct position
				r.moveEnd("character", stop-start);
				r.select();
			}
		}
	}

	return TextBox;
});

},
'davinci/review/view/CommentExplorerView':function(){
define([
	"dojo/_base/declare",
	"davinci/Runtime",
	"davinci/review/model/ReviewTreeModel",
	"davinci/Workbench",
	"davinci/workbench/ViewPart",
	"dijit/Tree",
	"dojo/date/stamp",
	"dojo/date/locale",
	"davinci/review/actions/CloseVersionAction",
	"davinci/review/actions/EditVersionAction",
	"davinci/review/actions/OpenVersionAction",
	"dijit/Toolbar",
	"dijit/ToolbarSeparator",
	"dijit/form/Button",
	"dijit/form/TextBox",
    "dojo/i18n!./nls/view",
    "dojo/i18n!../widgets/nls/widgets",
    "davinci/ui/widgets/TransformTreeMixin"
], function(declare, Runtime, ReviewTreeModel, Workbench, ViewPart, Tree, stamp, locale, CloseVersionAction,
		EditVersionAction, OpenVersionAction, Toolbar, ToolbarSeparator, Button, TextBox, viewNls, widgetsNls) {

var getIconClass = function(item, opened) {
	// summary:
	//		Return the icon class of the tree nodes
	if (item.elementType == "ReviewVersion") {
		if (item.isDraft) { 
			return "draft-open";
		}
		if (item.closed) {
			return opened ? "reviewFolder-open-disabled":"reviewFolder-closed-disabled";
		}
		if (!item.closed) {
			return opened ? "reviewFolder-open":"reviewFolder-closed";
		}
	}

	if (item.elementType=="ReviewFile") {
		if (item.parent.closed) {
			return "disabledReviewFileIcon";
		}
		var icon;
		var fileType = item.getExtension();
		var extension = Runtime.getExtension("davinci.fileType", function (extension) {
			return extension.extension == fileType;
		});
		if (extension) {
			icon=extension.iconClass;
		}
		return icon ||	"dijitLeaf";
	}
	return "dijitLeaf";
};
	
getLabelClass = function(item, opened) {
	// summary:
	//		Return the label class of the tree nodes
	
	var labelClass = "dijitTreeLabel";
	if (item.elementType == "ReviewVersion") {
		if (item.designerId == Runtime.userName) {
			labelClass = "reviewOwnedByUserLabel";
		} else {
			labelClass = "reviewOwnedByOtherLabel";
		}
	}
	
	return labelClass;
};

var getSortTransforms = function() {
	return [
	    function(items) {
	    	return items.sort(function (file1,file2) {
	    		return file1.timeStamp > file2.timeStamp ? -1 : file1.timeStamp < file2.timeStamp ? 1 : 0;
	    	});
	    }
	];
};
	
var CommentExplorerView = declare(ViewPart, {

	postCreate: function() {
		this.inherited(arguments);

		var model= new ReviewTreeModel();
		this.model = model;
		var transforms = getSortTransforms();
		transforms.push(function(items) {
			return items.filter(this.commentingFilter.filterItem, this);
		}.bind(this));
		this.tree = new Tree({
			id: "reviewCommentExplorerViewTree",
			persist: false,
			showRoot: false,
			model: model,
			labelAttr: "name", 
			childrenAttrs: "children",
			getIconClass: dojo.hitch(this, this._getIconClass),
			getLabelClass: dojo.hitch(this, this._getLabelClass),
			transforms: transforms,
			isMultiSelect: true
		});

		this.setContent(this.tree); 
		this.attachToolbar();
		this.tree.startup();
		dojo.connect(this.tree, 'onDblClick',  
				dojo.hitch(this, this._dblClick));
		dojo.connect(this.tree, 'onClick', dojo.hitch(this, this._click));
		dojo.connect(this.tree,'_onNodeMouseEnter', dojo.hitch(this, this._over));
		dojo.connect(this.tree,'_onNodeMouseLeave', dojo.hitch(this, this._leave));
		dojo.connect(this.tree,'_setSelectedNodesAttr', function () {
			this._publishSelectionChanges();
		}.bind(this));

		this.subscribe("/davinci/review/selectionChanged", "_updateActionBar");
		this.subscribe("/davinci/review/resourceChanged", function(result, type, changedResource) {
			if (changedResource && changedResource.timeStamp) {
				davinci.review.model.resource.root.findVersion(changedResource.timeStamp).then(function(node){
					if (node) { 
						this.tree.set("selectedItem", node);
					} else {
						this.tree.set("selectedItems", []);
					}
					this._publishSelectionChanges();
					
					// NOTE: This feels like a hack, but if all children of the root are deleted (making the
					// root empty), then the tree will collapse the root node. And, then when we add a node back in,
					// that node is invisible because the tree thinks the root node is collapsed.  So, 
					// we'll circumvent that by telling it the root node to expand. If already expanded, this 
					// has no effect.
					this.tree.rootNode.expand();
				}.bind(this));
			}
		});

		var popup = Workbench.createPopup({ 
			partID: 'davinci.review.reviewNavigator',
			context: this,
			domNode: this.tree.domNode, 
			openCallback: function (event) {
				//Select the item in the tree user right-clicked on
				var w = dijit.getEnclosingWidget(event.target);
				if(!w || !w.item){
					return;
				}
				this.tree.set("path", this._buildTreePath(w.item));
		 	}.bind(this)
		});

		var o = Workbench.getActionSets("davinci.review.reviewNavigator");
		var actions = o.clonedActionSets;
		if (actions && actions.length == 1) {
			dojo.forEach(actions[0].actions, dojo.hitch(this, function(action) {
					if (action.keyBinding) {
						if (!this.keyBindings) {
							this.keyBindings = [];
						}

						this.keyBindings.push({keyBinding: action.keyBinding, action: action});
					}
			}));
		}

		dojo.connect(this.tree.domNode, "onkeypress", this, "_onKeyPress");

		this.infoCardContent = dojo.cache("davinci", "review/widgets/templates/InfoCard.html", "<div class=\"detail_title\">${detail_title}</div>\n<div>\n\t<div class=\"detail_div\"><span>${your_role}:</span><span class=\"detail_role\">${detail_role}</span><span>${due_by}:</span><span class=\"${detail_dueDate_class}\">${detail_dueDate}</span></div>\n\t<div class=\"detail_div\"><span>${created_by}:</span><span class=\"detail_creator\">${detail_creator}</div>\n\t<div class=\"detail_div\"><span>${creation_date}:</span><span class=\"detail_creationDate\">${detail_creationDate}</div>\n</div>\n<div class=\"detail_div\"><strong>${artifacts_in_rev}</strong></div>\n${detail_files}\n<div class=\"detail_div\"><strong>${reviewers}</strong></div>\n${detail_reviewers}");

		// Customize dijit._masterTT so that it will not be closed when the cursor is hovering on it
		if (!dijit._masterTT) { 
			dijit._masterTT = new dijit._MasterTooltip();
		}
		this.connect(dijit._masterTT.domNode, "mouseover", function() {
			this._deleteDelTimer();
		});
		this.connect(dijit._masterTT.domNode, "mouseleave", function() {
			this._lastAnchorNode && this._leave();
		});
		
		//Keep track of editor selection so that we can expand tree appropriately
		dojo.subscribe("/davinci/ui/editorSelected", function(obj){
			var editor = obj.editor;
			if (editor && editor.editorID === "davinci.review.CommentReviewEditor") {
				var fileNodeItem = editor.resourceFile;
				var versionNodeItem = fileNodeItem.parent;
				
				//We want to collapse everything but the version folder of the review held in the editor
				dojo.forEach(this.model.root.children, function(nodeItem) {
					if (nodeItem != versionNodeItem) {
						var treeNodes = this.tree.getNodesByItem(nodeItem);
						
						if (treeNodes.length > 0) {
							var treeNode = treeNodes[0];
							if (treeNode.isExpanded) {
								// NOTE: Hate to use private function of dijit.Tree, but if I
								// use treeNode.collapse, the node can no longer be re-expanded
								// by the user
								this.tree._collapseNode(treeNode);
							}
						}
					}
				}.bind(this));
				
				//Set the path (which expands tree as necessary)
				this.tree.set("path", this._buildTreePath(fileNodeItem));
			}
		 }.bind(this));
	},
	
	_buildTreePath: function(item) {
		var path = [];
		for(var loopItem=item; loopItem; loopItem = loopItem.parent) {
			path.unshift(loopItem);
		}
		return path;
	},

	_updateActionBar: function(item, context) {
		if (context!=this||!item||!item.length) {
			this.closeBtn.set("disabled",true);
			this.editBtn.set("disabled",true);
			return;
		}
		var selectedVersion = item[0].resource.elementType == "ReviewFile" ? item[0].resource.parent : item[0].resource;
		Runtime.reviewers = selectedVersion.reviewers || [];
		var isDesigner = selectedVersion.designerId == Runtime.userName;
		var isVersion = selectedVersion.elementType == "ReviewVersion";
		var isDraft = selectedVersion.isDraft;
		this.closeBtn.set("disabled", !isDesigner || !isVersion || selectedVersion.closed || isDraft); 
		this.openBtn.set("disabled", !isDesigner || !isVersion || !selectedVersion.closedManual || isDraft);
		this.editBtn.set("disabled", !isDesigner || !isVersion);
	},

	getTopAdditions: function() {
		var toolbar = new Toolbar({}, dojo.create("div"));
		var closeBtn = new Button({
			id: toolbar.get("id") + ".Close",
			showLabel: false,
			label: viewNls.closeVersion,
			disabled: true,
			iconClass: "viewActionIcon closeVersionIcon",
			onClick: dojo.hitch(this, "_closeVersion")
		});
		this.closeBtn = closeBtn;

		var openBtn = new Button({
			id: toolbar.get("id")+".Open",
			showLabel:false,
			label: viewNls.openVersion,
			disabled:true,
			iconClass: "viewActionIcon openVersionIcon",
			onClick: dojo.hitch(this,"_openVersion")
		});
		this.openBtn = openBtn;
		var editBtn = new Button({
			id: toolbar.get("id") + ".Edit",
			showLabel: false,
			label: viewNls.editVersion,
			disabled: true,
			iconClass: "viewActionIcon editVersionIcon",
			onClick: dojo.hitch(this,"_editVersion")
		});
		this.editBtn = editBtn;

		var input = new TextBox({
			id:"reviewExplorerFilter",
			placeHolder: viewNls.filter,
			onKeyUp: dojo.hitch(this,this._filter)
		});

		toolbar.addChild(closeBtn);
		toolbar.addChild(openBtn);
		toolbar.addChild(new dijit.ToolbarSeparator());
		toolbar.addChild(editBtn);

		dojo.place(dojo.create("br"), toolbar.domNode);
		toolbar.addChild(input);
		dojo.addClass(toolbar.domNode, "davinciCommentExplorer");
		return toolbar.domNode;
	},

	_closeVersion: function() {
		(new CloseVersionAction()).run(this);
	},

	_openVersion: function() {
		(new OpenVersionAction()).run(this);
	},

	_editVersion: function() {
		(new EditVersionAction()).run(this);
	},

	_filter: function(e) {
		//if(e.keyCode != dojo.keys.ENTER)return;
		var text = dijit.byId("reviewExplorerFilter").get("value");
		this.commentingFilter.filterString=text;
		dojo.forEach(this.model.root.children,dojo.hitch(this, function(item) {
			item.getChildren(function(children) { 
				this.model.onChildrenChange(item, children);
			}.bind(this));
		}));
	},

	commentingFilter: {
		filterString: "",
		filterItem: function(item) {
			var filterString = this.commentingFilter.filterString;
			if (!filterString) { 
				return true;
			} else {
				if (item.elementType == "ReviewFile") {
					return item.name.toLowerCase().indexOf(filterString.toLowerCase()) >= 0;
				}
				return true;
			}
		}
	},

	destroy: function() {
		this.inherited(arguments);
	},

	_dblClick: function(node) {
		if (node.isDraft || node.parent.isDraft) {
			if (node.designerId == Runtime.userName || node.parent.designerId == Runtime.userName) {
				this._openPublishWizard(node.isDraft ? node : node.parent);
			}
			return;
		}
		if (node.elementType == "ReviewFile") {
			Workbench.openEditor({
				fileName: node,
				content: node.getText()
			});
		}
	},

	_click: function(node) {
		this._publishSelectionChanges();
	},
	
	_publishSelectionChanges: function() {
		var items = this.getSelection();
		this.publish("/davinci/review/selectionChanged", [items, this]);
	},
	
	getSelection: function() {
		var items = dojo.map(this.tree.get('selectedItems'), function(item) { return {resource:item};});
		return items;
	},

	_over: function(node) {
		if (node.item.elementType != "ReviewVersion") { 
			return;
		}
		if (!this._showTimer) {
			// Build the tooltip
			var item = node.item, template = {}, c;

			template.detail_title = item.name;

			template.your_role = widgetsNls.yourRole;
			template.due_by = widgetsNls.dueBy;
			template.created_by = widgetsNls.createdBy;
			template.creation_date = widgetsNls.creationDate;
			template.artifacts_in_rev = widgetsNls.artifactsInRev;
			template.reviewers = widgetsNls.reviewers;

			
			template.detail_role = (item.designerId == Runtime.userName) ? viewNls.designer : viewNls.reviewer;
			template.detail_dueDate = item.dueDate == "infinite" ? viewNls.infinite : locale.format(item.dueDate, {
				selector:'date',
				formatLength:'long'
			});
			
			var creatorString = Runtime.getUserDisplayNamePlusEmail({
				email: item.designerEmail,
				userDisplayName: item.designerDisplayName,
				userId: item.designerId
			});
			template.detail_creator = creatorString;
			
			//Creation date - use short format, but tolerate RFC3339
			var stampArgs = item.timeStamp.match(/^(\d{4})(\d{2})(\d{2})\T(\d{2})(\d{2})(\d{2})\Z$/);
			var timeStampDate = stamp.fromISOString(stampArgs ? dojo.replace("{1}-{2}-{3}T{4}:{5}:{6}Z", stampArgs) : item.timeStamp);
			template.detail_creationDate = locale.format(timeStampDate, {
				formatLength:'medium'
			});

			template.detail_files = "";
			item.getChildren(function(children) {
				dojo.forEach(children, function(i) {
					var label = i.getLabel();
					template.detail_files += "<div><span>"
						+ label.substr(0, label.length - 4)
						+ "</span><span class='dijitTreeIcon reviewFileIcon detail_file'></span></div>";
				});
				template.detail_reviewers = "";
				dojo.forEach(item.reviewers, function(i) {
					if (i.email != item.designerEmail) {
						var reviewer = "<div>" + i.email + "</div>";
						if ((i.displayName != "") && (i.email != i.displayName)) {
							reviewer = "<div>" + i.displayName +" &lt;" + i.email + "&gt;</div>";
						}
						template.detail_reviewers += reviewer;
					}
				});
				item.closed ? template.detail_dueDate_class = "closed" : template.detail_dueDate_class = "notClosed";
	
				this._showTimer = setTimeout(dojo.hitch(this, function() {
					this._deleteDelTimer();
					dijit.showTooltip(dojo.string.substitute(this.infoCardContent, template), node.rowNode);
					this._lastAnchorNode = node;
					delete this._showTimer;
					this._createDelTimer(15000);
				}), 1000);
			}.bind(this));
		}
	},

	_leave: function(node) {
		this._deleteDelTimer();
		if (this._showTimer) {
			clearTimeout(this._showTimer);
			delete this._showTimer;
		}
		if (this._lastAnchorNode) {
			this._createDelTimer(1000);
		}
	},
	
	_createDelTimer: function(timeoutMs){
		this._delTimer = setTimeout(dojo.hitch(this, function() {
			this._hideTooltip();
			delete this._delTimer;
		}), timeoutMs);
	},
	
	_deleteDelTimer: function(){
		if(this._delTimer){
			clearTimeout(this._delTimer);
			delete this._delTimer;
		}
	},
	
	_hideTooltip: function(){
		if (this._lastAnchorNode) {
			dijit.hideTooltip(this._lastAnchorNode.rowNode);
			this._lastAnchorNode = null;
		}
	},

	_openPublishWizard: function(node) {
		var action = new davinci.review.actions.PublishAction(node);
		action.run();
	},

	_getIconClass: function(item, opened) {
		return getIconClass(item, opened);
	},
	
	_getLabelClass: function(item, opened) {
		return getLabelClass(item, opened);
	},

	_onKeyPress: function(e) {
		var stopEvent = dojo.some(this.keyBindings, dojo.hitch(this, function(binding) {
			if (Runtime.isKeyEqualToEvent(binding.keyBinding, e)) {
				davinci.Workbench._runAction(binding.action, this, binding.action.id);
				return true;
			}
		}));

		if (stopEvent) {
			dojo.stopEvent(e);
		}

		return stopEvent;
	}
});

//Make get getIconClass, etc. publicly available as a "static" function
CommentExplorerView.getIconClass = getIconClass;
CommentExplorerView.getLabelClass = getLabelClass;
CommentExplorerView.getSortTransforms = getSortTransforms;

return CommentExplorerView;

});

},
'dojox/grid/DataGrid':function(){
define([
	"../main",
	"dojo/_base/array",
	"dojo/_base/lang",
	"dojo/_base/json",
	"dojo/_base/sniff",
	"dojo/_base/declare",
	"./_Grid",
	"./DataSelection",
	"dojo/_base/html"
], function(dojox, array, lang, json, has, declare, _Grid, DataSelection, html){

/*=====
declare("dojox.grid.__DataCellDef", dojox.grid.__CellDef, {
	constructor: function(){
		// field: String?
		//		The attribute to read from the dojo.data item for the row.
		// fields: String[]?
		//		An array of fields to grab the values of and pass as an array to the grid
		// get: Function?
		//		function(rowIndex, item?){} rowIndex is of type Integer, item is of type
		//		Object.  This function will be called when a cell requests data.  Returns
		//		the unformatted data for the cell.
	}
});
=====*/

/*=====
declare("dojox.grid.__DataViewDef", dojox.grid.__ViewDef, {
	constructor: function(){
		// cells: dojox.grid.__DataCellDef[]|Array[dojox.grid.__DataCellDef[]]?
		//		The structure of the cells within this grid.
		// defaultCell: dojox.grid.__DataCellDef?
		//		A cell definition with default values for all cells in this view.  If
		//		a property is defined in a cell definition in the "cells" array and
		//		this property, the cell definition's property will override this
		//		property's property.
	}
});
=====*/

var DataGrid = declare("dojox.grid.DataGrid", _Grid, {
	store: null,
	query: null,
	queryOptions: null,
	fetchText: '...',
	sortFields: null,
	
	// updateDelay: int
	//		Time, in milliseconds, to delay updates automatically so that multiple
	//		calls to onSet/onNew/onDelete don't keep rerendering the grid.  Set
	//		to 0 to immediately cause updates.  A higher value will result in
	//		better performance at the expense of responsiveness of the grid.
	updateDelay: 1,

/*=====
	// structure: dojox.grid.__DataViewDef|dojox.grid.__DataViewDef[]|dojox.grid.__DataCellDef[]|Array[dojox.grid.__DataCellDef[]]
	//		View layout definition.
	structure: '',
=====*/

	// You can specify items instead of a query, if you like.  They do not need
	// to be loaded - but the must be items in the store
	items: null,
	
	_store_connects: null,
	_by_idty: null,
	_by_idx: null,
	_cache: null,
	_pages: null,
	_pending_requests: null,
	_bop: -1,
	_eop: -1,
	_requests: 0,
	rowCount: 0,

	_isLoaded: false,
	_isLoading: false,
	
	// keepSelection: Boolean
	//		Whether keep selection after sort, filter etc.
	keepSelection: false,	
	
	postCreate: function(){
		this._pages = [];
		this._store_connects = [];
		this._by_idty = {};
		this._by_idx = [];
		this._cache = [];
		this._pending_requests = {};

		this._setStore(this.store);
		this.inherited(arguments);
	},
	
	destroy: function(){
		this.selection.destroy();
		this.inherited(arguments);
	},

	createSelection: function(){
		this.selection = new DataSelection(this);
	},

	get: function(inRowIndex, inItem){
		// summary:
		//		Default data getter.
		// description:
		//		Provides data to display in a grid cell. Called in grid cell context.
		//		So this.cell.index is the column index.
		// inRowIndex: Integer
		//		Row for which to provide data
		// returns:
		//		Data to display for a given grid cell.
		
		if(inItem && this.field == "_item" && !this.fields){
			return inItem;
		}else if(inItem && this.fields){
			var ret = [];
			var s = this.grid.store;
			array.forEach(this.fields, function(f){
				ret = ret.concat(s.getValues(inItem, f));
			});
			return ret;
		}else if(!inItem && typeof inRowIndex === "string"){
			return this.inherited(arguments);
		}
		return (!inItem ? this.defaultValue : (!this.field ? this.value : (this.field == "_item" ? inItem : this.grid.store.getValue(inItem, this.field))));
	},

	_checkUpdateStatus: function(){
		if(this.updateDelay > 0){
			var iStarted = false;
			if(this._endUpdateDelay){
				clearTimeout(this._endUpdateDelay);
				delete this._endUpdateDelay;
				iStarted = true;
			}
			if(!this.updating){
				this.beginUpdate();
				iStarted = true;
			}
			if(iStarted){
				var _this = this;
				this._endUpdateDelay = setTimeout(function(){
					delete _this._endUpdateDelay;
					_this.endUpdate();
				}, this.updateDelay);
			}
		}
	},
	
	_onSet: function(item, attribute, oldValue, newValue){
		this._checkUpdateStatus();
		var idx = this.getItemIndex(item);
		if(idx>-1){
			this.updateRow(idx);
		}
	},
	
	_createItem: function(item, index){
		var idty = this._hasIdentity ? this.store.getIdentity(item) : json.toJson(this.query) + ":idx:" + index + ":sort:" + json.toJson(this.getSortProps());
		var o = this._by_idty[idty] = { idty: idty, item: item };
		return o;
	},

	_addItem: function(item, index, noUpdate){
		this._by_idx[index] = this._createItem(item, index);
		if(!noUpdate){
			this.updateRow(index);
		}
	},

	_onNew: function(item, parentInfo){
		this._checkUpdateStatus();
		var rowCount = this.get('rowCount');
		this._addingItem = true;
		this.updateRowCount(rowCount+1);
		this._addingItem = false;
		this._addItem(item, rowCount);
		this.showMessage();
	},

	_onDelete: function(item){
		this._checkUpdateStatus();
		var idx = this._getItemIndex(item, true);

		if(idx >= 0){
			// When a row is deleted, all rest rows are shifted down,
			// and migrate from page to page. If some page is not
			// loaded yet empty rows can migrate to initialized pages
			// without refreshing. It causes empty rows in some pages, see:
			// http://bugs.dojotoolkit.org/ticket/6818
			// this code fix this problem by reseting loaded page info
			this._pages = [];
			this._bop = -1;
			this._eop = -1;

			var o = this._by_idx[idx];
			this._by_idx.splice(idx, 1);
			delete this._by_idty[o.idty];
			this.updateRowCount(this.get('rowCount')-1);
			if(this.get('rowCount') === 0){
				this.showMessage(this.noDataMessage);
			}
		}
		if(this.selection.isSelected(idx)){
			this.selection.deselect(idx);
			this.selection.selected.splice(idx, 1);
		}
	},

	_onRevert: function(){
		this._refresh();
	},

	setStore: function(store, query, queryOptions){
		if(this._requestsPending(0)){
			return;
		}
		this._setQuery(query, queryOptions);
		this._setStore(store);
		this._refresh(true);
	},
	
	setQuery: function(query, queryOptions){
		if(this._requestsPending(0)){
			return;
		}
		this._setQuery(query, queryOptions);
		this._refresh(true);
	},
	
	setItems: function(items){
		this.items = items;
		this._setStore(this.store);
		this._refresh(true);
	},
	
	_setQuery: function(query, queryOptions){
		this.query = query;
		this.queryOptions = queryOptions || this.queryOptions;
	},

	_setStore: function(store){
		if(this.store && this._store_connects){
			array.forEach(this._store_connects, this.disconnect, this);
		}
		this.store = store;

		if(this.store){
			var f = this.store.getFeatures();
			var h = [];

			this._canEdit = !!f["dojo.data.api.Write"] && !!f["dojo.data.api.Identity"];
			this._hasIdentity = !!f["dojo.data.api.Identity"];

			if(!!f["dojo.data.api.Notification"] && !this.items){
				h.push(this.connect(this.store, "onSet", "_onSet"));
				h.push(this.connect(this.store, "onNew", "_onNew"));
				h.push(this.connect(this.store, "onDelete", "_onDelete"));
			}
			if(this._canEdit){
				h.push(this.connect(this.store, "revert", "_onRevert"));
			}

			this._store_connects = h;
		}
	},

	_onFetchBegin: function(size, req){
		if(!this.scroller){ return; }
		if(this.rowCount != size){
			if(req.isRender){
				this.scroller.init(size, this.keepRows, this.rowsPerPage);
				this.rowCount = size;
				this._setAutoHeightAttr(this.autoHeight, true);
				this._skipRowRenormalize = true;
				this.prerender();
				this._skipRowRenormalize = false;
			}else{
				this.updateRowCount(size);
			}
		}
		if(!size){
			this.views.render();
			this._resize();
			this.showMessage(this.noDataMessage);
			this.focus.initFocusView();
		}else{
			this.showMessage();
		}
	},

	_onFetchComplete: function(items, req){
		if(!this.scroller){ return; }
		if(items && items.length > 0){
			//console.log(items);
			array.forEach(items, function(item, idx){
				this._addItem(item, req.start+idx, true);
			}, this);
			this.updateRows(req.start, items.length);
			if(req.isRender){
				this.setScrollTop(0);
				this.postrender();
			}else if(this._lastScrollTop){
				this.setScrollTop(this._lastScrollTop);
			}
			if(has("ie")){
				html.setSelectable(this.domNode, this.selectable);
			}	
		}
		delete this._lastScrollTop;
		if(!this._isLoaded){
			this._isLoading = false;
			this._isLoaded = true;
		}
		this._pending_requests[req.start] = false;
	},

	_onFetchError: function(err, req){
		console.log(err);
		delete this._lastScrollTop;
		if(!this._isLoaded){
			this._isLoading = false;
			this._isLoaded = true;
			this.showMessage(this.errorMessage);
		}
		this._pending_requests[req.start] = false;
		this.onFetchError(err, req);
	},

	onFetchError: function(err, req){
	},

	_fetch: function(start, isRender){
		start = start || 0;
		if(this.store && !this._pending_requests[start]){
			if(!this._isLoaded && !this._isLoading){
				this._isLoading = true;
				this.showMessage(this.loadingMessage);
			}
			this._pending_requests[start] = true;
			//console.log("fetch: ", start);
			try{
				if(this.items){
					var items = this.items;
					var store = this.store;
					this.rowsPerPage = items.length;
					var req = {
						start: start,
						count: this.rowsPerPage,
						isRender: isRender
					};
					this._onFetchBegin(items.length, req);
					
					// Load them if we need to
					var waitCount = 0;
					array.forEach(items, function(i){
						if(!store.isItemLoaded(i)){ waitCount++; }
					});
					if(waitCount === 0){
						this._onFetchComplete(items, req);
					}else{
						var onItem = function(item){
							waitCount--;
							if(waitCount === 0){
								this._onFetchComplete(items, req);
							}
						};
						array.forEach(items, function(i){
							if(!store.isItemLoaded(i)){
								store.loadItem({item: i, onItem: onItem, scope: this});
							}
						}, this);
					}
				}else{
					this.store.fetch({
						start: start,
						count: this.rowsPerPage,
						query: this.query,
						sort: this.getSortProps(),
						queryOptions: this.queryOptions,
						isRender: isRender,
						onBegin: lang.hitch(this, "_onFetchBegin"),
						onComplete: lang.hitch(this, "_onFetchComplete"),
						onError: lang.hitch(this, "_onFetchError")
					});
				}
			}catch(e){
				this._onFetchError(e, {start: start, count: this.rowsPerPage});
			}
		}
	},

	_clearData: function(){
		this.updateRowCount(0);
		this._by_idty = {};
		this._by_idx = [];
		this._pages = [];
		this._bop = this._eop = -1;
		this._isLoaded = false;
		this._isLoading = false;
	},

	getItem: function(idx){
		var data = this._by_idx[idx];
		if(!data||(data&&!data.item)){
			this._preparePage(idx);
			return null;
		}
		return data.item;
	},

	getItemIndex: function(item){
		return this._getItemIndex(item, false);
	},
	
	_getItemIndex: function(item, isDeleted){
		if(!isDeleted && !this.store.isItem(item)){
			return -1;
		}

		var idty = this._hasIdentity ? this.store.getIdentity(item) : null;

		for(var i=0, l=this._by_idx.length; i<l; i++){
			var d = this._by_idx[i];
			if(d && ((idty && d.idty == idty) || (d.item === item))){
				return i;
			}
		}
		return -1;
	},

	filter: function(query, reRender){
		this.query = query;
		if(reRender){
			this._clearData();
		}
		this._fetch();
	},

	_getItemAttr: function(idx, attr){
		var item = this.getItem(idx);
		return (!item ? this.fetchText : this.store.getValue(item, attr));
	},

	// rendering
	_render: function(){
		if(this.domNode.parentNode){
			this.scroller.init(this.get('rowCount'), this.keepRows, this.rowsPerPage);
			this.prerender();
			this._fetch(0, true);
		}
	},

	// paging
	_requestsPending: function(inRowIndex){
		return this._pending_requests[inRowIndex];
	},

	_rowToPage: function(inRowIndex){
		return (this.rowsPerPage ? Math.floor(inRowIndex / this.rowsPerPage) : inRowIndex);
	},

	_pageToRow: function(inPageIndex){
		return (this.rowsPerPage ? this.rowsPerPage * inPageIndex : inPageIndex);
	},

	_preparePage: function(inRowIndex){
		if((inRowIndex < this._bop || inRowIndex >= this._eop) && !this._addingItem){
			var pageIndex = this._rowToPage(inRowIndex);
			this._needPage(pageIndex);
			this._bop = pageIndex * this.rowsPerPage;
			this._eop = this._bop + (this.rowsPerPage || this.get('rowCount'));
		}
	},

	_needPage: function(inPageIndex){
		if(!this._pages[inPageIndex]){
			this._pages[inPageIndex] = true;
			this._requestPage(inPageIndex);
		}
	},

	_requestPage: function(inPageIndex){
		var row = this._pageToRow(inPageIndex);
		var count = Math.min(this.rowsPerPage, this.get('rowCount') - row);
		if(count > 0){
			this._requests++;
			if(!this._requestsPending(row)){
				setTimeout(lang.hitch(this, "_fetch", row, false), 1);
				//this.requestRows(row, count);
			}
		}
	},

	getCellName: function(inCell){
		return inCell.field;
		//console.log(inCell);
	},

	_refresh: function(isRender){
		this._clearData();
		this._fetch(0, isRender);
	},

	sort: function(){
		this.edit.apply();
		this._lastScrollTop = this.scrollTop;
		this._refresh();
	},

	canSort: function(){
		return (!this._isLoading);
	},

	getSortProps: function(){
		var c = this.getCell(this.getSortIndex());
		if(!c){
			if(this.sortFields){
				return this.sortFields;
			}
			return null;
		}else{
			var desc = c["sortDesc"];
			var si = !(this.sortInfo>0);
			if(typeof desc == "undefined"){
				desc = si;
			}else{
				desc = si ? !desc : desc;
			}
			return [{ attribute: c.field, descending: desc }];
		}
	},

	styleRowState: function(inRow){
		// summary:
		//		Perform row styling
		if(this.store && this.store.getState){
			var states=this.store.getState(inRow.index), c='';
			for(var i=0, ss=["inflight", "error", "inserting"], s; s=ss[i]; i++){
				if(states[s]){
					c = ' dojoxGridRow-' + s;
					break;
				}
			}
			inRow.customClasses += c;
		}
	},

	onStyleRow: function(inRow){
		this.styleRowState(inRow);
		this.inherited(arguments);
	},

	// editing
	canEdit: function(inCell, inRowIndex){
		return this._canEdit;
	},

	_copyAttr: function(idx, attr){
		var row = {};
		var backstop = {};
		var src = this.getItem(idx);
		return this.store.getValue(src, attr);
	},

	doStartEdit: function(inCell, inRowIndex){
		if(!this._cache[inRowIndex]){
			this._cache[inRowIndex] = this._copyAttr(inRowIndex, inCell.field);
		}
		this.onStartEdit(inCell, inRowIndex);
	},

	doApplyCellEdit: function(inValue, inRowIndex, inAttrName){
		this.store.fetchItemByIdentity({
			identity: this._by_idx[inRowIndex].idty,
			onItem: lang.hitch(this, function(item){
				var oldValue = this.store.getValue(item, inAttrName);
				if(typeof oldValue == 'number'){
					inValue = isNaN(inValue) ? inValue : parseFloat(inValue);
				}else if(typeof oldValue == 'boolean'){
					inValue = inValue == 'true' ? true : inValue == 'false' ? false : inValue;
				}else if(oldValue instanceof Date){
					var asDate = new Date(inValue);
					inValue = isNaN(asDate.getTime()) ? inValue : asDate;
				}
				this.store.setValue(item, inAttrName, inValue);
				this.onApplyCellEdit(inValue, inRowIndex, inAttrName);
			})
		});
	},

	doCancelEdit: function(inRowIndex){
		var cache = this._cache[inRowIndex];
		if(cache){
			this.updateRow(inRowIndex);
			delete this._cache[inRowIndex];
		}
		this.onCancelEdit.apply(this, arguments);
	},

	doApplyEdit: function(inRowIndex, inDataAttr){
		var cache = this._cache[inRowIndex];
		/*if(cache){
			var data = this.getItem(inRowIndex);
			if(this.store.getValue(data, inDataAttr) != cache){
				this.update(cache, data, inRowIndex);
			}
			delete this._cache[inRowIndex];
		}*/
		this.onApplyEdit(inRowIndex);
	},

	removeSelectedRows: function(){
		// summary:
		//		Remove the selected rows from the grid.
		if(this._canEdit){
			this.edit.apply();
			var fx = lang.hitch(this, function(items){
				if(items.length){
					array.forEach(items, this.store.deleteItem, this.store);
					this.selection.clear();
				}
			});
			if(this.allItemsSelected){
				this.store.fetch({
							query: this.query,
							queryOptions: this.queryOptions,
							onComplete: fx});
			}else{
				fx(this.selection.getSelected());
			}
		}
	}
});

DataGrid.cell_markupFactory = function(cellFunc, node, cellDef){
	var field = lang.trim(html.attr(node, "field")||"");
	if(field){
		cellDef.field = field;
	}
	cellDef.field = cellDef.field||cellDef.name;
	var fields = lang.trim(html.attr(node, "fields")||"");
	if(fields){
		cellDef.fields = fields.split(",");
	}
	if(cellFunc){
		cellFunc(node, cellDef);
	}
};

DataGrid.markupFactory = function(props, node, ctor, cellFunc){
	return _Grid.markupFactory(props, node, ctor,
					lang.partial(DataGrid.cell_markupFactory, cellFunc));
};

return DataGrid;

});

},
'davinci/review/model/ReviewTreeModel':function(){
define([
	    "dojo/_base/declare",
	    "davinci/Runtime",
	    "davinci/model/Path",
	    "davinci/review/model/Resource"
], function(declare, Runtime, Path, Resource){
	
return declare("davinci.review.model.ReviewTreeModel", null, {

	foldersOnly: false,

	constructor: function(args) {
		this.root = Resource.getRoot();
		this.subscription = [dojo.subscribe("/davinci/review/resourceChanged", this, this.resourceChanged)];
	},

	destroy: function() {
		this.subscriptions.forEach(dojo.unsubscribe);
	},

	getRoot: function(onItem) {
		onItem(this.root);
	},

	mayHaveChildren: function(/*dojo.data.Item*/ item) {
		return item.elementType == "ReviewVersion" && !item.isDraft;
	},
	
	getChildren: function(/*dojo.data.Item*/ parentItem, /*function(items)*/ onComplete, /*function(items)*/ onError) {
		parentItem.getChildren(onComplete, onError);
	},
	
	getIdentity: function(/* item */ item) {
		return item.getPath();
	},

	resourceChanged: function(result, type, changedResource) {
		// Remove the changed resource and its children from the tree. Shortly, we will
		// tell the tree about it's new children. But, if a child's identity matches the 
		// identity of an existing item in the model, it will not be replaced with the 
		// new data. Hence, the need to delete the changed resource before adding it back
		// in.
		if (changedResource) {
			if (changedResource._isLoaded) {
				changedResource.getChildren(function(children) { children.forEach(this.onDelete, this); }.bind(this), true);
			}
			
			this.onDelete(changedResource);
		}
		
		// Reload the children. 
		var parent = this.root;
		parent._isLoaded = false;
		parent.getChildren(function(children) { 
			//Add new children
			this.onChildrenChange(parent, children);
		}.bind(this));
	},

	getLabel: function(/*dojo.data.Item*/ item) {
		var label = item.getName();
		if (item.elementType == "ReviewVersion" && item.isDraft) {
			label += " (Draft)";
		}
		if (item.elementType == "ReviewFile") {
			var path = new Path(label);
			var segments = path.getSegments();
			var editorExtension = Runtime.getExtension("davinci.editor", function (extension){
				return extension.id === "davinci.review.CommentReviewEditor";
			});
			var extension = "."+editorExtension.extensions;
			label = segments[segments.length-1] + extension;
		}
		return label;
	},

	newItem: function(/* Object? */ args, /*Item?*/ parent){ 
	},

	pasteItem: function(/*Item*/ childItem, /*Item*/ oldParentItem, /*Item*/ newParentItem, /*Boolean*/ bCopy) {
	},

	onChange: function(/*dojo.data.Item*/ item) {
	},
	
	onDelete: function(/*dojo.data.Item*/ item) {
	},

	onChildrenChange: function(/*dojo.data.Item*/ parent, /*dojo.data.Item[]*/ newChildrenList) {
	}

});
});

},
'dojox/grid/_FocusManager':function(){
define([
	"dojo/_base/array",
	"dojo/_base/lang",
	"dojo/_base/declare",
	"dojo/_base/connect",
	"dojo/_base/event",
	"dojo/_base/sniff",
	"dojo/query",
	"./util",
	"dojo/_base/html"
], function(array, lang, declare, connect, event, has, query, util, html){

// focus management
return declare("dojox.grid._FocusManager", null, {
	// summary:
	//		Controls grid cell focus. Owned by grid and used internally for focusing.
	//		Note: grid cell actually receives keyboard input only when cell is being edited.
	constructor: function(inGrid){
		this.grid = inGrid;
		this.cell = null;
		this.rowIndex = -1;
		this._connects = [];
		this._headerConnects = [];
		this.headerMenu = this.grid.headerMenu;
		this._connects.push(connect.connect(this.grid.domNode, "onfocus", this, "doFocus"));
		this._connects.push(connect.connect(this.grid.domNode, "onblur", this, "doBlur"));
		this._connects.push(connect.connect(this.grid.domNode, "mousedown", this, "_mouseDown"));
		this._connects.push(connect.connect(this.grid.domNode, "mouseup", this, "_mouseUp"));
		this._connects.push(connect.connect(this.grid.domNode, "oncontextmenu", this, "doContextMenu"));
		this._connects.push(connect.connect(this.grid.lastFocusNode, "onfocus", this, "doLastNodeFocus"));
		this._connects.push(connect.connect(this.grid.lastFocusNode, "onblur", this, "doLastNodeBlur"));
		this._connects.push(connect.connect(this.grid,"_onFetchComplete", this, "_delayedCellFocus"));
		this._connects.push(connect.connect(this.grid,"postrender", this, "_delayedHeaderFocus"));
	},
	destroy: function(){
		array.forEach(this._connects, connect.disconnect);
		array.forEach(this._headerConnects, connect.disconnect);
		delete this.grid;
		delete this.cell;
	},
	_colHeadNode: null,
	_colHeadFocusIdx: null,
	_contextMenuBindNode: null,
	tabbingOut: false,
	focusClass: "dojoxGridCellFocus",
	focusView: null,
	initFocusView: function(){
		this.focusView = this.grid.views.getFirstScrollingView() || this.focusView || this.grid.views.views[0];
		this._initColumnHeaders();
	},
	isFocusCell: function(inCell, inRowIndex){
		// summary:
		//		states if the given cell is focused
		// inCell: object
		//		grid cell object
		// inRowIndex: int
		//		grid row index
		// returns:
		//		true of the given grid cell is focused
		return (this.cell == inCell) && (this.rowIndex == inRowIndex);
	},
	isLastFocusCell: function(){
		if(this.cell){
			return (this.rowIndex == this.grid.rowCount-1) && (this.cell.index == this.grid.layout.cellCount-1);
		}
		return false;
	},
	isFirstFocusCell: function(){
		if(this.cell){
			return (this.rowIndex === 0) && (this.cell.index === 0);
		}
		return false;
	},
	isNoFocusCell: function(){
		return (this.rowIndex < 0) || !this.cell;
	},
	isNavHeader: function(){
		// summary:
		//		states whether currently navigating among column headers.
		// returns:
		//		true if focus is on a column header; false otherwise.
		return (!!this._colHeadNode);
	},
	getHeaderIndex: function(){
		// summary:
		//		if one of the column headers currently has focus, return its index.
		// returns:
		//		index of the focused column header, or -1 if none have focus.
		if(this._colHeadNode){
			return array.indexOf(this._findHeaderCells(), this._colHeadNode);
		}else{
			return -1;
		}
	},
	_focusifyCellNode: function(inBork){
		var n = this.cell && this.cell.getNode(this.rowIndex);
		if(n){
			html.toggleClass(n, this.focusClass, inBork);
			if(inBork){
				var sl = this.scrollIntoView();
				try{
					if(has("webkit") || !this.grid.edit.isEditing()){
						util.fire(n, "focus");
						if(sl){ this.cell.view.scrollboxNode.scrollLeft = sl; }
					}
				}catch(e){}
			}
		}
	},
	_delayedCellFocus: function(){
		if(this.isNavHeader()||!this.grid.focused){
				return;
		}
		var n = this.cell && this.cell.getNode(this.rowIndex);
		if(n){
			try{
				if(!this.grid.edit.isEditing()){
					html.toggleClass(n, this.focusClass, true);
					if(this._colHeadNode){
						this.blurHeader();
					}
					util.fire(n, "focus");
				}
			}
			catch(e){}
		}
	},
	_delayedHeaderFocus: function(){
		if(this.isNavHeader()){
			this.focusHeader();
			//this.grid.domNode.focus();
		}
	},
	_initColumnHeaders: function(){
		array.forEach(this._headerConnects, connect.disconnect);
		this._headerConnects = [];
		var headers = this._findHeaderCells();
		for(var i = 0; i < headers.length; i++){
			this._headerConnects.push(connect.connect(headers[i], "onfocus", this, "doColHeaderFocus"));
			this._headerConnects.push(connect.connect(headers[i], "onblur", this, "doColHeaderBlur"));
		}
	},
	_findHeaderCells: function(){
		// This should be a one liner:
		//	query("th[tabindex=-1]", this.grid.viewsHeaderNode);
		// But there is a bug in query() for IE -- see trac #7037.
		var allHeads = query("th", this.grid.viewsHeaderNode);
		var headers = [];
		for (var i = 0; i < allHeads.length; i++){
			var aHead = allHeads[i];
			var hasTabIdx = html.hasAttr(aHead, "tabIndex");
			var tabindex = html.attr(aHead, "tabIndex");
			if (hasTabIdx && tabindex < 0) {
				headers.push(aHead);
			}
		}
		return headers;
	},
	_setActiveColHeader: function(/*Node*/colHeaderNode, /*Integer*/colFocusIdx, /*Integer*/ prevColFocusIdx){
		//console.log("setActiveColHeader() - colHeaderNode:colFocusIdx:prevColFocusIdx = " + colHeaderNode + ":" + colFocusIdx + ":" + prevColFocusIdx);
		this.grid.domNode.setAttribute("aria-activedescendant",colHeaderNode.id);
		if (prevColFocusIdx != null && prevColFocusIdx >= 0 && prevColFocusIdx != colFocusIdx){
			html.toggleClass(this._findHeaderCells()[prevColFocusIdx],this.focusClass,false);
		}
		html.toggleClass(colHeaderNode,this.focusClass, true);
		this._colHeadNode = colHeaderNode;
		this._colHeadFocusIdx = colFocusIdx;
		this._scrollHeader(this._colHeadFocusIdx);
	},
	scrollIntoView: function(){
		var info = (this.cell ? this._scrollInfo(this.cell) : null);
		if(!info || !info.s){
			return null;
		}
		var rt = this.grid.scroller.findScrollTop(this.rowIndex);
		// place cell within horizontal view
		if(info.n && info.sr){
			if(info.n.offsetLeft + info.n.offsetWidth > info.sr.l + info.sr.w){
				info.s.scrollLeft = info.n.offsetLeft + info.n.offsetWidth - info.sr.w;
			}else if(info.n.offsetLeft < info.sr.l){
				info.s.scrollLeft = info.n.offsetLeft;
			}
		}
		// place cell within vertical view
		if(info.r && info.sr){
			if(rt + info.r.offsetHeight > info.sr.t + info.sr.h){
				this.grid.setScrollTop(rt + info.r.offsetHeight - info.sr.h);
			}else if(rt < info.sr.t){
				this.grid.setScrollTop(rt);
			}
		}

		return info.s.scrollLeft;
	},
	_scrollInfo: function(cell, domNode){
		if(cell){
			var cl = cell,
				sbn = cl.view.scrollboxNode,
				sbnr = {
					w: sbn.clientWidth,
					l: sbn.scrollLeft,
					t: sbn.scrollTop,
					h: sbn.clientHeight
				},
				rn = cl.view.getRowNode(this.rowIndex);
			return {
				c: cl,
				s: sbn,
				sr: sbnr,
				n: (domNode ? domNode : cell.getNode(this.rowIndex)),
				r: rn
			};
		}
		return null;
	},
	_scrollHeader: function(currentIdx){
		var info = null;
		if(this._colHeadNode){
			var cell = this.grid.getCell(currentIdx);
			if(!cell){ return; }
			info = this._scrollInfo(cell, cell.getNode(0));
		}
		if(info && info.s && info.sr && info.n){
			// scroll horizontally as needed.
			var scroll = info.sr.l + info.sr.w;
			if(info.n.offsetLeft + info.n.offsetWidth > scroll){
				info.s.scrollLeft = info.n.offsetLeft + info.n.offsetWidth - info.sr.w;
			}else if(info.n.offsetLeft < info.sr.l){
				info.s.scrollLeft = info.n.offsetLeft;
			}else if(has('ie') <= 7 && cell && cell.view.headerNode){
				// Trac 7158: scroll dojoxGridHeader for IE7 and lower
				cell.view.headerNode.scrollLeft = info.s.scrollLeft;
			}
		}
	},
	_isHeaderHidden: function(){
		// summary:
		//		determine if the grid headers are hidden
		//		relies on documented technique of setting .dojoxGridHeader { display:none; }
		// returns: Boolean
		//		true if headers are hidden
		//		false if headers are not hidden
		
		var curView = this.focusView;
		if (!curView){
			// find one so we can determine if headers are hidden
			// there is no focusView after adding items to empty grid (test_data_grid_empty.html)
			for (var i = 0, cView; (cView = this.grid.views.views[i]); i++) {
				if(cView.headerNode ){
					curView=cView;
					break;
				}
			}
		}
		return (curView && html.getComputedStyle(curView.headerNode).display == "none");
	},
	colSizeAdjust: function (e, colIdx, delta){ // adjust the column specified by colIdx by the specified delta px
		var headers = this._findHeaderCells();
		var view = this.focusView;
		if(!view || !view.header.tableMap.map){
			for(var i = 0, cView; (cView = this.grid.views.views[i]); i++){
				// find first view with a tableMap in order to work with empty grid
				if(cView.header.tableMap.map){
					view=cView;
					break;
				}
			}
		}
		var curHeader = headers[colIdx];
		if (!view || (colIdx == headers.length-1 && colIdx === 0)){
			return; // can't adjust single col. grid
		}
		view.content.baseDecorateEvent(e);
		// need to adjust event with header cell info since focus is no longer on header cell
		e.cellNode = curHeader; //this.findCellTarget(e.target, e.rowNode);
		e.cellIndex = view.content.getCellNodeIndex(e.cellNode);
		e.cell = (e.cellIndex >= 0 ? this.grid.getCell(e.cellIndex) : null);
		if (view.header.canResize(e)){
			var deltaObj = {
				l: delta
			};
			var drag = view.header.colResizeSetup(e,false);
			view.header.doResizeColumn(drag, null, deltaObj);
			view.update();
		}
	},
	styleRow: function(inRow){
		return;
	},
	setFocusIndex: function(inRowIndex, inCellIndex){
		// summary:
		//		focuses the given grid cell
		// inRowIndex: int
		//		grid row index
		// inCellIndex: int
		//		grid cell index
		this.setFocusCell(this.grid.getCell(inCellIndex), inRowIndex);
	},
	setFocusCell: function(inCell, inRowIndex){
		// summary:
		//		focuses the given grid cell
		// inCell: object
		//		grid cell object
		// inRowIndex: int
		//		grid row index
		if(inCell && !this.isFocusCell(inCell, inRowIndex)){
			this.tabbingOut = false;
			if (this._colHeadNode){
				this.blurHeader();
			}
			this._colHeadNode = this._colHeadFocusIdx = null;
			this.focusGridView();
			this._focusifyCellNode(false);
			this.cell = inCell;
			this.rowIndex = inRowIndex;
			this._focusifyCellNode(true);
		}
		// even if this cell isFocusCell, the document focus may need to be rejiggered
		// call opera on delay to prevent keypress from altering focus
		if(has('opera')){
			setTimeout(lang.hitch(this.grid, 'onCellFocus', this.cell, this.rowIndex), 1);
		}else{
			this.grid.onCellFocus(this.cell, this.rowIndex);
		}
	},
	next: function(){
		// summary:
		//	focus next grid cell
		if(this.cell){
			var row=this.rowIndex, col=this.cell.index+1, cc=this.grid.layout.cellCount-1, rc=this.grid.rowCount-1;
			if(col > cc){
				col = 0;
				row++;
			}
			if(row > rc){
				col = cc;
				row = rc;
			}
			if(this.grid.edit.isEditing()){ //when editing, only navigate to editable cells
				var nextCell = this.grid.getCell(col);
				if (!this.isLastFocusCell() && (!nextCell.editable ||
					this.grid.canEdit && !this.grid.canEdit(nextCell, row))){
					this.cell=nextCell;
					this.rowIndex=row;
					this.next();
					return;
				}
			}
			this.setFocusIndex(row, col);
		}
	},
	previous: function(){
		// summary:
		//	focus previous grid cell
		if(this.cell){
			var row=(this.rowIndex || 0), col=(this.cell.index || 0) - 1;
			if(col < 0){
				col = this.grid.layout.cellCount-1;
				row--;
			}
			if(row < 0){
				row = 0;
				col = 0;
			}
			if(this.grid.edit.isEditing()){ //when editing, only navigate to editable cells
				var prevCell = this.grid.getCell(col);
				if (!this.isFirstFocusCell() && !prevCell.editable){
					this.cell=prevCell;
					this.rowIndex=row;
					this.previous();
					return;
				}
			}
			this.setFocusIndex(row, col);
		}
	},
	move: function(inRowDelta, inColDelta) {
		// summary:
		//		focus grid cell or  simulate focus to column header based on position relative to current focus
		// inRowDelta: int
		//		vertical distance from current focus
		// inColDelta: int
		//		horizontal distance from current focus

		var colDir = inColDelta < 0 ? -1 : 1;
		// Handle column headers.
		if(this.isNavHeader()){
			var headers = this._findHeaderCells();
			var savedIdx = currentIdx = array.indexOf(headers, this._colHeadNode);
			currentIdx += inColDelta;
			while(currentIdx >=0 && currentIdx < headers.length && headers[currentIdx].style.display == "none"){
				// skip over hidden column headers
				currentIdx += colDir;
			}
			if((currentIdx >= 0) && (currentIdx < headers.length)){
				this._setActiveColHeader(headers[currentIdx],currentIdx, savedIdx);
			}
		}else{
			if(this.cell){
				// Handle grid proper.
				var sc = this.grid.scroller,
					r = this.rowIndex,
					rc = this.grid.rowCount-1,
					row = Math.min(rc, Math.max(0, r+inRowDelta));
				if(inRowDelta){
					if(inRowDelta>0){
						if(row > sc.getLastPageRow(sc.page)){
							//need to load additional data, let scroller do that
							this.grid.setScrollTop(this.grid.scrollTop+sc.findScrollTop(row)-sc.findScrollTop(r));
						}
					}else if(inRowDelta<0){
						if(row <= sc.getPageRow(sc.page)){
							//need to load additional data, let scroller do that
							this.grid.setScrollTop(this.grid.scrollTop-sc.findScrollTop(r)-sc.findScrollTop(row));
						}
					}
				}
				var cc = this.grid.layout.cellCount-1,
				i = this.cell.index,
				col = Math.min(cc, Math.max(0, i+inColDelta));
				var cell = this.grid.getCell(col);
				while(col>=0 && col < cc && cell && cell.hidden === true){
					// skip hidden cells
					col += colDir;
					cell = this.grid.getCell(col);
				}
				if (!cell || cell.hidden === true){
					// don't change col if would move to hidden
					col = i;
				}
				//skip hidden row|cell
				var n = cell.getNode(row);
				if(!n && inRowDelta){
					if((row + inRowDelta) >= 0 && (row + inRowDelta) <= rc){
						this.move(inRowDelta > 0 ? ++inRowDelta : --inRowDelta, inColDelta);
					}
					return;
				}else if((!n || html.style(n, "display") === "none") && inColDelta){
					if((col + inColDelta) >= 0 && (col + inColDelta) <= cc){
						this.move(inRowDelta, inColDelta > 0 ? ++inColDelta : --inColDelta);
					}
					return;
				}
				this.setFocusIndex(row, col);
				if(inRowDelta){
					this.grid.updateRow(r);
				}
			}
		}
	},
	previousKey: function(e){
		if(this.grid.edit.isEditing()){
			event.stop(e);
			this.previous();
		}else if(!this.isNavHeader() && !this._isHeaderHidden()) {
			this.grid.domNode.focus(); // will call doFocus and set focus into header.
			event.stop(e);
		}else{
			this.tabOut(this.grid.domNode);
			if (this._colHeadFocusIdx != null) { // clear grid header focus
				html.toggleClass(this._findHeaderCells()[this._colHeadFocusIdx], this.focusClass, false);
				this._colHeadFocusIdx = null;
			}
			this._focusifyCellNode(false);
		}
	},
	nextKey: function(e) {
		var isEmpty = (this.grid.rowCount === 0);
		if(e.target === this.grid.domNode && this._colHeadFocusIdx == null){
			this.focusHeader();
			event.stop(e);
		}else if(this.isNavHeader()){
			// if tabbing from col header, then go to grid proper.
			this.blurHeader();
			if(!this.findAndFocusGridCell()){
				this.tabOut(this.grid.lastFocusNode);
			}
			this._colHeadNode = this._colHeadFocusIdx= null;
		}else if(this.grid.edit.isEditing()){
			event.stop(e);
			this.next();
		}else{
			this.tabOut(this.grid.lastFocusNode);
		}
	},
	tabOut: function(inFocusNode){
		this.tabbingOut = true;
		inFocusNode.focus();
	},
	focusGridView: function(){
		util.fire(this.focusView, "focus");
	},
	focusGrid: function(inSkipFocusCell){
		this.focusGridView();
		this._focusifyCellNode(true);
	},
	findAndFocusGridCell: function(){
		// summary:
		//		find the first focusable grid cell
		// returns: Boolean
		//		true if focus was set to a cell
		//		false if no cell found to set focus onto
		
		var didFocus = true;
		var isEmpty = (this.grid.rowCount === 0); // If grid is empty this.grid.rowCount == 0
		if (this.isNoFocusCell() && !isEmpty){
			var cellIdx = 0;
			var cell = this.grid.getCell(cellIdx);
			if (cell.hidden) {
				// if first cell isn't visible, use _colHeadFocusIdx
				// could also use a while loop to find first visible cell - not sure that is worth it
				cellIdx = this.isNavHeader() ? this._colHeadFocusIdx : 0;
			}
			this.setFocusIndex(0, cellIdx);
		}
		else if (this.cell && !isEmpty){
			if (this.focusView && !this.focusView.rowNodes[this.rowIndex]){
				// if rowNode for current index is undefined (likely as a result of a sort and because of #7304)
				// scroll to that row
				this.grid.scrollToRow(this.rowIndex);
			}
			this.focusGrid();
		}else {
			didFocus = false;
		}
		this._colHeadNode = this._colHeadFocusIdx= null;
		return didFocus;
	},
	focusHeader: function(){
		var headerNodes = this._findHeaderCells();
		var saveColHeadFocusIdx = this._colHeadFocusIdx;
		if (this._isHeaderHidden()){
			// grid header is hidden, focus a cell
			this.findAndFocusGridCell();
		}
		else if (!this._colHeadFocusIdx) {
			if (this.isNoFocusCell()) {
				this._colHeadFocusIdx = 0;
			}
			else {
				this._colHeadFocusIdx = this.cell.index;
			}
		}
		this._colHeadNode = headerNodes[this._colHeadFocusIdx];
		while(this._colHeadNode && this._colHeadFocusIdx >=0 && this._colHeadFocusIdx < headerNodes.length &&
				this._colHeadNode.style.display == "none"){
			// skip over hidden column headers
			this._colHeadFocusIdx++;
			this._colHeadNode = headerNodes[this._colHeadFocusIdx];
		}
		if(this._colHeadNode && this._colHeadNode.style.display != "none"){
			// Column header cells know longer receive actual focus.  So, for keyboard invocation of
			// contextMenu to work, the contextMenu must be bound to the grid.domNode rather than the viewsHeaderNode.
			// unbind the contextmenu from the viewsHeaderNode and to the grid when header cells are active.  Reset
			// the binding back to the viewsHeaderNode when header cells are no longer acive (in blurHeader) #10483
			if (this.headerMenu && this._contextMenuBindNode != this.grid.domNode){
				this.headerMenu.unBindDomNode(this.grid.viewsHeaderNode);
				this.headerMenu.bindDomNode(this.grid.domNode);
				this._contextMenuBindNode = this.grid.domNode;
			}
			this._setActiveColHeader(this._colHeadNode, this._colHeadFocusIdx, saveColHeadFocusIdx);
			this._scrollHeader(this._colHeadFocusIdx);
			this._focusifyCellNode(false);
		}else {
			// all col head nodes are hidden - focus the grid
			this.findAndFocusGridCell();
		}
	},
	blurHeader: function(){
		html.removeClass(this._colHeadNode, this.focusClass);
		html.removeAttr(this.grid.domNode,"aria-activedescendant");
		// reset contextMenu onto viewsHeaderNode so right mouse on header will invoke (see focusHeader)
		if (this.headerMenu && this._contextMenuBindNode == this.grid.domNode) {
			var viewsHeader = this.grid.viewsHeaderNode;
			this.headerMenu.unBindDomNode(this.grid.domNode);
			this.headerMenu.bindDomNode(viewsHeader);
			this._contextMenuBindNode = viewsHeader;
		}
	},
	doFocus: function(e){
		// trap focus only for grid dom node
		if(e && e.target != e.currentTarget){
			event.stop(e);
			return;
		}
		// don't change focus if clicking on scroller bar
		if(this._clickFocus){
			return;
		}
		// do not focus for scrolling if grid is about to blur
		if(!this.tabbingOut){
			this.focusHeader();
		}
		this.tabbingOut = false;
		event.stop(e);
	},
	doBlur: function(e){
		event.stop(e);	// FF2
	},
	doContextMenu: function(e){
	//stop contextMenu event if no header Menu to prevent default/browser contextMenu
		if (!this.headerMenu){
			event.stop(e);
		}
	},
	doLastNodeFocus: function(e){
		if (this.tabbingOut){
			this._focusifyCellNode(false);
		}else if(this.grid.rowCount >0){
			if (this.isNoFocusCell()){
				this.setFocusIndex(0,0);
			}
			this._focusifyCellNode(true);
		}else {
			this.focusHeader();
		}
		this.tabbingOut = false;
		event.stop(e);	 // FF2
	},
	doLastNodeBlur: function(e){
		event.stop(e);	 // FF2
	},
	doColHeaderFocus: function(e){
		this._setActiveColHeader(e.target,html.attr(e.target, "idx"),this._colHeadFocusIdx);
		this._scrollHeader(this.getHeaderIndex());
		event.stop(e);
	},
	doColHeaderBlur: function(e){
		html.toggleClass(e.target, this.focusClass, false);
	},
	_mouseDown: function(e){
		// a flag indicating grid is being focused by clicking
		this._clickFocus = dojo.some(this.grid.views.views, function(v){
			return v.scrollboxNode === e.target;
		});
	},
	_mouseUp: function(e){
		this._clickFocus = false;
	}
});
});
},
'davinci/de/widgets/NewDijit':function(){
define(["dojo/_base/declare",
        "dijit/_Widget",
        "dijit/_Templated",
        "dojo/text!./templates/NewDijit.html",
        "dijit/form/RadioButton",
        "dijit/form/TextBox",
        "dijit/form/Button"
        
       
],function(declare,  _Widget, _Templated, templateString){
	return declare("davinci.de.widgets.NewDijit",   [_Widget,_Templated], {
		widgetsInTemplate: true,
		templateString: templateString,
		_okButton: null,
		_dijitName : null,
		_widgetGroup: null,
		_replaceSelection : null,
		
		postMixInProperties : function() {
			this.inherited(arguments);
		},
		
		postCreate : function(){
			this.inherited(arguments);
			dojo.connect(this._dijitName, "onkeyup", this, '_checkValid');
			
			
		},
		
		
		_checkValid : function(){
			// make sure the Dijit name is OK.
			var name = dojo.attr(this._dijitName, "value");
			var valid = (name!=null);
			this._okButton.set( 'disabled', !valid);
		},
		
		okButton : function(){
			this.value = {'name': dojo.attr(this._dijitName, "value"), 
					     //'group':dojo.attr(this._widgetGroup, "value"),
					     'replaceSelection':dojo.attr(this._replaceSelection, "checked")};
		},	
		
		_getValueAttr : function(){
			return this.value;
		},
		cancelButton: function(){
			this.cancel = true;
			this.onClose();
		},
	
		onClose : function(){}
	
	});
});
},
'davinci/model/resource/Resource':function(){
define([
	"dojo/_base/declare",
	"dojo/_base/xhr",
	"dojo/_base/connect",
	"dojo/Deferred",
	"davinci/Runtime",
	"davinci/model/Model",
	"davinci/model/Path"
], function(declare, xhr, connect, Deferred, Runtime, Model, Path) {

return declare("davinci.model.resource.Resource", Model, {

	/**  
	 * @class davinci.model.resource.Resource
	 * @constructor 
	 * @extends davinci.model.Model
	 */
	constructor: function() {
		this.elementType = "Resource";
		this.name = "";
		this.parent = null;
		this._id = dijit.getUniqueId("maqFileResource");
	},

	getName: function() {
		return this.name;
	},

	getPath: function() {
		if (this.parent) {
			return this.parent.getPath() + "/" + this.name;
		}
		return this.name;
	},

	readOnly: function() {
		if (this.hasOwnProperty("_readOnly")) {
			return this._readOnly || (this.parent != null && this.parent.readOnly());
		}
		if( this.parent) {
			return this.parent.readOnly();
		}
		return false;
	},

	getURL: function() {
		var path = this.getPath();
		if(path.indexOf("./") == 0 ) {
			path = path.substring(2, path.length);
		}
		var userWorkspaceUrl = Runtime.getUserWorkspaceUrl();
		
		/* need a special flavor or URI Rewrite to encode files with # */
		return  userWorkspaceUrl + path;
	},

	rename: function(newName) {
		var newPath = new Path(this.getPath()).removeLastSegments().append(newName);
		return xhr.get({
			url: "cmd/rename", 
			handleAs: "text", 
			content: {oldName: this.getPath(), newName: newPath.toString()} 
		}).then(function() {
			this.name = newName;
			connect.publish("/davinci/resource/resourceChanged", ["renamed", this]);
		}.bind(this));
	},

	getParentFolder: function() {
		if (this.elementType == "File") {
			return this.parent;
		}
		return this;
	},

	isVirtual: function() {
		return !!this.libraryId;
	},

	visit: function(visitor, dontLoad) {
		var dontVisitChildren = visitor.visit(this);
		if (!this._isLoaded && this.elementType == "Folder" && !dontLoad) {
			this.getChildren(dojo.hitch(this, function() { 
				dojo.forEach(this.children, function(child) { child.visit(visitor,dontLoad); });
			}));
		} else if (this.children && !dontVisitChildren) {
			dojo.forEach(this.children, function(child) {
				child.visit(visitor, dontLoad);
			});
		}
	},

	deleteResource: function(localOnly) {
		var promise,
			modifyModel = function(){
				var name = this.getName();
				this.parent.children.some(function(child, i, children) {
					if(child.getName() == name) {
						children.splice(i, 1);
						return true;
					}				
				});
	
				connect.publish("/davinci/resource/resourceChanged", ["deleted", this]);
			}.bind(this);

		if (localOnly) {
			promise = new Deferred();
			modifyModel();
			promise.resolve();
		} else {
			promise = xhr.get({
				url: "cmd/deleteResource",
				handleAs: "text",
				content: {path: this.getPath()}
			}).then(
				modifyModel,
				function(){
					//TODO: refresh the resource in the tree if it is a dir -- delete may have been partial.
				}
			);
		}
		return promise;
	},

	getId: function() {
		return this._id;
	}
});
});
},
'dijit/_Templated':function(){
define([
	"./_WidgetBase",
	"./_TemplatedMixin",
	"./_WidgetsInTemplateMixin",
	"dojo/_base/array", // array.forEach
	"dojo/_base/declare", // declare
	"dojo/_base/lang", // lang.extend lang.isArray
	"dojo/_base/kernel" // kernel.deprecated
], function(_WidgetBase, _TemplatedMixin, _WidgetsInTemplateMixin, array, declare, lang, kernel){

	// module:
	//		dijit/_Templated

	// These arguments can be specified for widgets which are used in templates.
	// Since any widget can be specified as sub widgets in template, mix it
	// into the base widget class.  (This is a hack, but it's effective.)
	// Remove for 2.0.   Also, hide from API doc parser.
	lang.extend(_WidgetBase, /*===== {} || =====*/ {
		waiRole: "",
		waiState:""
	});

	return declare("dijit._Templated", [_TemplatedMixin, _WidgetsInTemplateMixin], {
		// summary:
		//		Deprecated mixin for widgets that are instantiated from a template.
		//		Widgets should use _TemplatedMixin plus if necessary _WidgetsInTemplateMixin instead.

		// widgetsInTemplate: [protected] Boolean
		//		Should we parse the template to find widgets that might be
		//		declared in markup inside it?  False by default.
		widgetsInTemplate: false,

		constructor: function(){
			kernel.deprecated(this.declaredClass + ": dijit._Templated deprecated, use dijit._TemplatedMixin and if necessary dijit._WidgetsInTemplateMixin", "", "2.0");
		},

		_attachTemplateNodes: function(rootNode, getAttrFunc){

			this.inherited(arguments);

			// Do deprecated waiRole and waiState
			var nodes = lang.isArray(rootNode) ? rootNode : (rootNode.all || rootNode.getElementsByTagName("*"));
			var x = lang.isArray(rootNode) ? 0 : -1;
			for(; x<nodes.length; x++){
				var baseNode = (x == -1) ? rootNode : nodes[x];

				// waiRole, waiState
				var role = getAttrFunc(baseNode, "waiRole");
				if(role){
					baseNode.setAttribute("role", role);
				}
				var values = getAttrFunc(baseNode, "waiState");
				if(values){
					array.forEach(values.split(/\s*,\s*/), function(stateValue){
						if(stateValue.indexOf('-') != -1){
							var pair = stateValue.split('-');
							baseNode.setAttribute("aria-"+pair[0], pair[1]);
						}
					});
				}
			}
		}
	});
});

},
'davinci/ve/States':function(){
/// Set a global flag so that AppStates.js doesn't run its standard initialization logic
// because the page editor has its own states initialization logic.
if (typeof davinci === "undefined") { davinci = {}; }
davinci.AppStatesDontInitialize = true;

define([
        "dojo/_base/declare",
        "dojo/_base/connect",
    	"dojo/query",
    	"dojo/dom-class",
    	"dojo/dom-style",
    	"dojo/_base/window",
    	"dijit/registry",
    	"davinci/Runtime",
    	"davinci/Workbench",
        "davinci/maqetta/AppStates",
    	"./utils/GeomUtils",
        "./commands/EventCommand",
        "./commands/StyleCommand",
    	"davinci/ve/utils/StyleArray",
    	"davinci/workbench/Preferences",
        "dojo/i18n!davinci/ve/nls/ve"
], function(declare, connect, query, domClass, domStyle, dojoWin, registry, Runtime, Workbench, 
		maqettaStates, GeomUtils, EventCommand, StyleCommand, StyleArray, Preferences, veNls){

// Some of the logic in this file is invoked via commandStack processing,
// which does a dojo.withDoc() to set the document to the user's document
var appDocument = document;

var veStates = declare(maqettaStates, {
	
	/**
	 * Updates CSS properties for the given node due to a transition
	 * from application state (from an old state to a new state).
	 * Called indirectly when the current state changes (via a setState call)
	 * from code that listens to event /maqetta/appstates/state/changed
	 * @param {Element} node
	 * @param {[object]} statesArray  
	 *    Array of "state containers" that apply to this node,
	 *    with furthest ancestor at position 0 and nearest at position length-1.
	 *    Each item in array is an object with these properties
	 *      statesArray[i].node - a state container node
	 *      statesArray[i].oldState - the previous appstate that had been active on this state container node
	 *      statesArray[i].newState - the new appstate for this state container node
	 */
	_update: function(node, statesArray) {
		if(!Runtime.currentEditor || Runtime.currentEditor.declaredClass != "davinci.ve.PageEditor"){
			return;
		}
		if (!node || !node._dvWidget || (!node._maqAppStates && node._maqDeltas)){
			return;
		}
		var widget = node._dvWidget;
		this._refresh(widget);
//FIXME: Generalize beyond BODY?
		//var body = node.ownerDocument.body;
		//var currentState = this.getState(body);
		//if(!this.isNormalState(currentState)){
//FIXME: Is this really necessary? Shouldn't we be calling setState only on state containers?
			//this.setState(currentState, node, {updateWhenCurrent:true, silent:true});
		//}		
	},
	
	_refresh: function(widget){
		/* if the widget is a child of a dijiContainer widget 
		 * we may need to refresh the parent to make it all look correct in page editor
		 * */ 
		var parent = widget.getParent();
		if (parent.dijitWidget){
			this._refresh(parent);
		} else if (widget && widget.resize){
			widget.resize();
		}
	},
		
	_updateEvents: function(node, state, name) {
		if(!node || !node._dvWidget){
			return;
		}
		var widget = node._dvWidget;
//FIXME: What's this doing? Why this particular set of events?
		var events = ["onclick", "onmouseover", "onmouseout", "onfocus", "onblur"];
		var properties;
		for(var i in events){
			var event = events[i];
			var value = widget && widget.properties && widget.properties[event];
			if (typeof value == "string" && value.indexOf("davinci.states.setState") >= 0) {
				var original = value;
				value = value.replace("'" + state + "'", "'" + name + "'");
				if (value !== original) {
					properties = properties || {};
					properties[event] = value;
				}
			}
		}
		
		var context = this.getContext();
		if (context) {
			var command = new EventCommand(widget, properties);
			context.getCommandStack().execute(command);
		}
	},
	
	normalize: function(type, node, name, value) {
		switch(type) {
			case "style":
				var currentStatesList = this.getStatesListCurrent(node);
				for(var i=0; i<currentStatesList.length; i++){
					currentStatesList[i] = 'Normal';
				}
				var normalValueArray = this.getStyle(node, currentStatesList, name);
				if (normalValueArray) {
					for(var i=0; i<normalValueArray.length; i++){
						if(normalValueArray[i][name]){
							value = normalValueArray[i][name];
						}
					}
				}
				break;
		}
		return value;
	},
	
	normalizeArray: function(type, node, name, valueArray) {
		var newValueArray = dojo.clone(valueArray);
		switch(type) {
			case "style":
				var currentStatesList = this.getStatesListCurrent(node);
				for(var i=0; i<currentStatesList.length; i++){
					currentStatesList[i] = 'Normal';
				}
				var normalValueArray = this.getStyle(node, currentStatesList, name);
				if (normalValueArray) {
					// Remove all entries from valueArray that are in normalValueArray
					for(var i=0; i<normalValueArray.length; i++){
					var nItem = normalValueArray[i];
					for(var nProp in nItem){	// should be only one property 
						for(var j=newValueArray.length-1; j>=0; j--){
							var vItem = newValueArray[j];
							for(var vProp in vItem){	// should be only one property
								if(vProp == nProp){
									newValueArray.splice(j, 1);
									break;
								}
							}
						}
					}
				}
				// Append values from normalValueArray
				newValueArray = newValueArray.concat(normalValueArray);
				}
				break;
		}
		return newValueArray;
	},
	
	getEditor: function() {
		return Runtime.currentEditor;
	},
	
	getContext: function() {
		var editor = this.getEditor();
		return editor && (editor.getContext && editor.getContext() || editor.context);
	},
	
	getDocument: function() {
		var context = this.getContext();
		return context && context.getDocument && context.getDocument();
	},
	
	/**
	 * Force a call to setState so that styling properties get reset for the given node
	 * based on the current application state.
	 */
	resetState: function(node){
		if(!node){
			return;
		}
		var stateContainers = this.getStateContainersForNode(node);
		var focusState = this.getFocus(node.ownerDocument.body);
		for(var i=0; i<stateContainers.length; i++){
			var stateContainerNode = stateContainers[i];
			var currentState = this.getState(stateContainerNode);
			var focus = (focusState && stateContainerNode == focusState.stateContainerNode && currentState == focusState.state);
			this.setState(currentState, stateContainerNode, { focus:focus, updateWhenCurrent:true, silent:false });	
		}
	},
	
	_updateSrcState: function (node, noSrcChanges){
		var widget = (node && node._dvWidget);
		if(!widget){
			return;
		}
		var existingDefsAttr = widget._srcElement.getAttribute(davinci.states.APPSTATES_ATTRIBUTE);
		var existingDeltasAttr = widget._srcElement.getAttribute(davinci.states.DELTAS_ATTRIBUTE);
		if (widget && widget._srcElement) {
			var obj=this.serialize(node);
			if(obj.maqAppStates){	// _maqAppStates properties was present
				obj.maqAppStates.trim();
			}
			if(obj.maqAppStates){
				widget._srcElement.addAttribute(davinci.states.APPSTATES_ATTRIBUTE, obj.maqAppStates);
			}else{
				widget._srcElement.removeAttribute(davinci.states.APPSTATES_ATTRIBUTE);
			}
			if(obj.maqDeltas){	// _maqDeltas properties was present
				obj.maqDeltas.trim();
			}
			if(obj.maqDeltas){
				widget._srcElement.addAttribute(davinci.states.DELTAS_ATTRIBUTE, obj.maqDeltas);
			}else{
				widget._srcElement.removeAttribute(davinci.states.DELTAS_ATTRIBUTE);
			}
			var newDefsAttr = widget._srcElement.getAttribute(davinci.states.APPSTATES_ATTRIBUTE);
			var newDeltasAttr = widget._srcElement.getAttribute(davinci.states.DELTAS_ATTRIBUTE);
			if(existingDefsAttr !== newDefsAttr || existingDeltasAttr !== newDeltasAttr){
				var editor = this.getEditor();
				if(editor && editor._visualChanged){
					editor._visualChanged(noSrcChanges);	// Tell app that source view needs updating
				}			
			}
		}

	},
	
//FIXME: Need to deal with recursive state containers
	// Application "state" has been removed from the document
	// Recursively remove all references to that state from given node and descendants
	_removeStateFromNodeRecursive: function(node, state){
		var widget = node._dvWidget;
		if(!node || !widget || !state){
			return;
		}
		this._removeStateFromNode(node, state);
		var children = widget.getChildren();
		for(var i=0; i<children.length; i++){
			this._removeStateFromNodeRecursive(children[i].domNode, state);
		}
	},
	
	// Remove all references to given "state" from given node
	_removeStateFromNode: function(node, state){
		if(node && node._maqDeltas && node._maqDeltas[state]){
			delete node._maqDeltas[state];
			var hasAnyProperties = false;
			for (var prop in node._maqDeltas) {
				if(prop !== 'undefined'){
					hasAnyProperties = true;
					break;
				}
			}
			if (!hasAnyProperties){
				delete node._maqDeltas;
			}
			this._updateSrcState(node);
		}
	},

	// Remove any application states information that are defined on particular widgets
	// for all states that aren't in the master list of application states.
	// (This is to clean up after bugs found in older releases)
	removeUnusedStates: function(context){
		if(!context){
			return;
		}
		var allWidgets = context.getAllWidgets();
		for(var i=0; i<allWidgets.length; i++){
			var node = allWidgets[i].domNode;
			if(node.tagName !== 'BODY'){
				if(node && node._maqDeltas){
					var allStatesForNode = this.getAllStatesForNode(node);
					for(var state in node._maqDeltas){
						if(state !== 'undefined' && allStatesForNode.indexOf(state) < 0){
							this._removeStateFromNode(node, state);
						}
					}
				}
			}
		}
	},

	/**
	 * Returns array index into states object for given state
	 * Mostly used so that a null or undefined or 'Normal' state will get converted to string 'undefined'
	 * to compensate for screwy way that States.js is currently implemented
	 * @param {string|null|undefined} state  Current state
	 * @returns {string}  Returns either original state string or 'undefined'
	 */
	_getStateIndex:function(state){
		var stateIndex;
		if(!state || state == 'Normal' || state == 'undefined'){
			//FIXME: we are using 'undefined' as name of Normal state due to accidental programming
			stateIndex = 'undefined';
		}else{
			stateIndex = state;
		}
		return stateIndex;
	},

	getCurrentStateIndex:function(){
//FIXME: getState(node)
		return this._getStateIndex(this.getState());
	},

	getApplyToStateIndex:function(applyToWhichStates){
		var currentState = this.getState();
		var state;
		if(applyToWhichStates === "current" && currentState && currentState != 'Normal' && currentState != 'undefined'){
			state = currentState;
		}else{
			state = undefined;
		}
		return this._getStateIndex(state);
	},

	/**
	 * Returns the effective value for the 'display' property for the given widget in the given state.
	 * Also returns the state which defined the 'display' property.
	 * @param context {davinci.ve.Context} a context
	 * @param widget {davinci.ve._Widget} A dvWidget
	 * @param state [{String}] Optional parameter. If not provided or null or undefined or empty string,
	 * 		then query for 'display' property on base state. Else, query for 'display' on given state.
	 * @param overrides [{object}] Optional parameter. If provided, has the following fields
	 * 			overrides['undefined'] [{string}] - Use this 'display' value for the Background/Normal/undefined state
	 * 			overrides[state] [{string}] - Use this 'display' value for the state "state"
	 * @return {Object} with two properties
	 * 		effectiveDisplayValue {string} none|block|inline-block|etc
	 * 		effectiveState {string} where "undefined" represents the base/NORMAL state
	 */
	getEffectiveDisplayValue: function(context, widget, state, overrides){
		var domNode = widget ? widget.domNode : null;
		var effectiveDisplayValue = 'none';
		// Quirk in code: Normal state is represented as "undefined" in data structures
		var effectiveState = state || 'undefined';
		
		// If "state" represents a custom state and there is an override 'display' value for that state,
		// then use that override value
		if(overrides && typeof overrides[effectiveState] == 'string' && overrides[effectiveState] != '$MAQ_DELETE_PROPERTY$'){
			effectiveDisplayValue = overrides[effectiveState];
			stateOverride = true;
		}else{
			if(domNode){
				var stateOverride = false;
				if(domNode._maqDeltas && !(overrides && overrides[effectiveState] == '$MAQ_DELETE_PROPERTY$')){
					var style = (domNode._maqDeltas[state] && domNode._maqDeltas[state].style);
					if(style){
						for(var i=0; i<style.length; i++){
							var styleArray = style[i];
							for(var prop in styleArray){
								if(prop == 'display'){
									effectiveDisplayValue = styleArray[prop];
									stateOverride = true;
								}
							}
						}
					}
				}
				if(!stateOverride){
					// If there is an override 'display' value for the Background/Normal/undefined state,
					// then use that override value
					if(overrides && typeof overrides['undefined'] == 'string'){
						effectiveDisplayValue = overrides['undefined'];
					}else{
						// See if there is a "undefined"/Normal/Background value in _maqDeltas
						var undefinedStyle = (domNode._maqDeltas && domNode._maqDeltas['undefined'] && domNode._maqDeltas['undefined'].style);
						var undefinedValue = false;
						if(undefinedStyle){
							for(var i=0; i<undefinedStyle.length; i++){
								var styleArray = undefinedStyle[i];
								for(var prop in styleArray){
									if(prop == 'display'){
										effectiveDisplayValue = styleArray[prop];
										undefinedValue = true;
									}
								}
							}
						}
						if(!undefinedValue){
							// Else query the DOM for computed 'display' value
							effectiveDisplayValue = domStyle.get(domNode, 'display');
						}
					}
					effectiveState = 'undefined';
				}
				// If offsetLeft/Right/Top/Bottom are all zero, then widget is not visible
				if(domNode.offsetLeft==0 && domNode.offsetTop==0 && domNode.offsetWidth==0 && domNode.offsetHeight==0){
					effectiveDisplayValue = 'none';
				}else{
					// If any ancestors have display:none, then this widget is invisible
					while(domNode && domNode.tagName.toUpperCase() != 'BODY'){
						// Sometimes browsers haven't set up defaultView yet,
						// and domStyle.get will raise exception if defaultView isn't there yet
						if(domNode && domNode.ownerDocument && domNode.ownerDocument.defaultView){
							var computedStyleDisplay = domStyle.get(domNode, 'display');
							if(computedStyleDisplay == 'none'){
								effectiveDisplayValue = 'none';
								break;
							}
						}
						domNode = domNode.parentNode;
					}
				}
			}else{
				effectiveDisplayValue = 'none';
			}
		}
		return {effectiveDisplayValue: effectiveDisplayValue, effectiveState: effectiveState};
	},

	/**
	 * Checks to see if any of the properties listed in proplist are defined
	 * in any of the currently active states for the given node
	 * @param {Element} node
	 * @param {Array[string]} proplist
	 * @returns {undefined|string}  Return either nothing if search is empty, or name of first state encountered
	 */
	propertyDefinedForAnyCurrentState: function(node, proplist){
		var whichState;
		var maqDeltas = node._maqDeltas;
		if(maqDeltas){
			var stateContainers = this.getStateContainersForNode(node);
			outer_loop:
			for(var i=stateContainers.length-1; i>=0; i--){
				var stateContainer = stateContainers[i];
				var currentState = this.getState(stateContainer);
				var stateIndex = (!currentState || currentState == this.NORMAL) ? 'undefined' : currentState;
				var stateStyles = maqDeltas[stateIndex] && maqDeltas[stateIndex].style;
				if(stateStyles){
					for(var s=0; s<stateStyles.length; s++){
						var o = stateStyles[s];
						for(var j=0; j<proplist.length; j++){
							if(o.hasOwnProperty(proplist[j])){
								whichState = currentState;
								break outer_loop;
							}
						}
					}
				}
			}
		}
		return whichState;
	},
	
	_customStateActive: function(context){
		if(!context){
			return false;
		}
		// FIXME: assumes only state container is root node of doc
		var state = this.getState(context.rootNode);
		return state;	// undefined => default/base/Normal state
	},
	
	updateStateIcons: function(context){
		if(!context || !context.editor || context.editor != Runtime.currentEditor || context.editor.declaredClass != "davinci.ve.PageEditor"){
			return;
		}
		// Sometimes this routine is called as part of commandStack processing,
		// which does a dojo.withDoc(userdoc). This ensures we have the right document.
		dojoWin.withDoc(appDocument, function(){
			var manageStatesButton = query('.manageStatesButton')[0];
			var manageStatesButtonWidget = registry.byNode(manageStatesButton);
			var iconNode = query('.manageStatesIcon')[0];
			if(manageStatesButtonWidget && iconNode){
				if(this.manageStatesActive(context)){
					domClass.remove(iconNode, 'manageStatesIconDisabled');
					manageStatesButtonWidget.set('disabled', false);
				}else{
					domClass.add(iconNode, 'manageStatesIconDisabled');
					manageStatesButtonWidget.set('disabled', true);
				}
			}
			var editorPrefs = Preferences.getPreferences('davinci.ve.editorPrefs', davinci.Workbench.getProject());
			var newWidgetsCurrentState = editorPrefs.newWidgetsCurrentState;
			var newWidgetsCurrentStateButton = query('.newWidgetsCurrentStateButton')[0];
			var newWidgetsCurrentStateButtonWidget = registry.byNode(newWidgetsCurrentStateButton);
			var iconNode = query('.newWidgetsCurrentStateIcon')[0];
			if(newWidgetsCurrentStateButtonWidget && iconNode){
				if(this.newWidgetsCurrentStateActive(context)){
					domClass.remove(iconNode, 'newWidgetsCurrentStateIconDisabled');
				}else{
					domClass.add(iconNode, 'newWidgetsCurrentStateIconDisabled');
				}
				if(newWidgetsCurrentState){
					domClass.remove(iconNode, 'newWidgetsCurrentStateIconOff');
					domClass.add(iconNode, 'newWidgetsCurrentStateIconOn');
					newWidgetsCurrentStateButtonWidget.set('title', veNls.NewWidgetsCurrentStateTitleCurrentState);
				}else{
					domClass.remove(iconNode, 'newWidgetsCurrentStateIconOn');
					domClass.add(iconNode, 'newWidgetsCurrentStateIconOff');
					newWidgetsCurrentStateButtonWidget.set('title', veNls.NewWidgetsCurrentStateTitleBackground);
				}
			}
		}.bind(this));
	},
	
	/**
	 * Returns true if the manageStates feature can be active at this time.
	 * Only true when user has selected a custom state.
	 */
	manageStatesActive: function(context){
		return context && context.getSelection().length;
	},
	
	/**
	 * Returns true if the newWidgetsCurrentState feature can be active at this time.
	 * Only true when user has selected a custom state.
	 */
	newWidgetsCurrentStateActive: function(context){
		return this._customStateActive(context);
	},
	
	/**
	 * Returns true if the highlightBaseWidgets feature can be active at this time.
	 * Only true when user has selected a custom state.
	 */
	highlightBaseWidgetsActive: function(context){
		return this._customStateActive(context);
	},
	
	/**
	 * Update all of the highlights that show which widgets appear in a custom state
	 * but which are actually visible on the base state and "shining through" to custom state
	 */
	updateHighlightsBaseStateWidgets: function(context){
		// Have to use a setTimeout because widgets that have embedded SVG content
		// (shapes and clipart) will not have proper size until the SVG content is
		// loaded, and that content is loaded asynchronously by some browsers.
		// This is a safe operation to put into a setTimeout because the only
		// changes that happen are on the decorative chrome that overlays the widgets
		// on the canvas.
		setTimeout(function(){
			if(!context || !context.editor || context.editor != Runtime.currentEditor || context.editor.declaredClass != "davinci.ve.PageEditor"){
				return;
			}
			// Sometimes this routine is called as part of commandStack processing,
			// which does a dojo.withDoc(userdoc). This ensures we have the right document.
			dojoWin.withDoc(appDocument, function(){
				var editorPrefs = Preferences.getPreferences('davinci.ve.editorPrefs', davinci.Workbench.getProject());
				var highlightBaseWidgets = editorPrefs.highlightBaseWidgets;
				var highlightBaseWidgetsActive = this.highlightBaseWidgetsActive(context);
				var highlightBaseWidgetsButton = query('.highlightBaseWidgetsButton')[0];
				var highlightBaseWidgetsButtonWidget = registry.byNode(highlightBaseWidgetsButton);
				var iconNode = query('.highlightBaseWidgetsIcon')[0];
				if(highlightBaseWidgetsButtonWidget && iconNode){
					if(highlightBaseWidgetsActive){
						domClass.remove(iconNode, 'highlightBaseWidgetsIconDisabled');
					}else{
						domClass.add(iconNode, 'highlightBaseWidgetsIconDisabled');
					}
					if(highlightBaseWidgets){
						domClass.add(iconNode, 'highlightBaseWidgetsIconOn');
						domClass.remove(iconNode, 'highlightBaseWidgetsIconOff');
					}else{
						domClass.add(iconNode, 'highlightBaseWidgetsIconOff');
						domClass.remove(iconNode, 'highlightBaseWidgetsIconOn');
					}
				}
				// FIXME: assumes only state container is root node of doc
				var state = this.getState(context.rootNode);
				var focusContainer = dojo.byId('focusContainer');
				if(focusContainer){
					var shiningThroughDivs = query('.maqBaseStateShiningThrough', focusContainer);
					for(var i=0; i<shiningThroughDivs.length; i++){
						var div = shiningThroughDivs[i];
						div.parentNode.removeChild(div);
					}
					if(state && highlightBaseWidgets){
							var allWidgets = context.getAllWidgets();
							var widgetsNotInBaseState = [];
							for(var i=0; i<allWidgets.length; i++){
								var widget = allWidgets[i];
								if(widget.domNode && widget.domNode.tagName && widget.domNode.tagName.toUpperCase() == 'BODY'){
									continue;
								}
								var obj = this.getEffectiveDisplayValue(context, widget, state);
								var effectiveDisplayValue = obj.effectiveDisplayValue;
								var effectiveState = obj.effectiveState;
								if(effectiveDisplayValue != 'none' && effectiveState == 'undefined'){
									widgetsNotInBaseState.push(widget);
								}
							}
							var doc = context.getDocument();
							var focusContainerBounds = GeomUtils.getBorderBoxPageCoords(focusContainer);
							var parentIframe = context.getParentIframe();
							var parentIFrameBounds = GeomUtils.getBorderBoxPageCoords(parentIframe);
							var iframeFocusContainerAdjustLeft = parentIFrameBounds.l - focusContainerBounds.l;
							var iframeFocusContainerAdjustTop = parentIFrameBounds.t - focusContainerBounds.t;
							var bodyElement = doc.body;
							var scrollLeft = GeomUtils.getScrollLeft(bodyElement);
							var scrollTop = GeomUtils.getScrollTop(bodyElement);
							for(var j=0; j<widgetsNotInBaseState.length; j++){
								var domNode = widgetsNotInBaseState[j].domNode;
								if(domNode){
									//FIXME: use dojo.position instead?
									var rect = GeomUtils.getBorderBoxPageCoords(domNode);
									rect.l += (iframeFocusContainerAdjustLeft - scrollLeft);
									rect.t += (iframeFocusContainerAdjustTop - scrollTop);
									var div = doc.createElement('div');
									div.className = 'maqBaseStateShiningThrough';
									div.style.left = rect.l + 'px';
									div.style.top = rect.t + 'px';
									div.style.width = rect.w + 'px';
									div.style.height = rect.h + 'px';
									focusContainer.appendChild(div);
								}
							}					
					}
				}
			}.bind(this));
		}.bind(this), 10);
	},

	initialize: function() {
	
		if (!this.subscribed) {
		
			connect.subscribe("/maqetta/appstates/state/changed", dojo.hitch(this, function(e) { 
				var editor = this.getEditor();
				if (!dojo.isObject(e.node) || !editor || editor.declaredClass != "davinci.ve.PageEditor"){
					return;
				} // ignore if node is not an object (eg '$all') and ignore updates in theme editor

				dojo.publish("/maqetta/appstates/state/changed/start", [e]);
				// If rootWidget, then loop through children, else loop starting with this widget.
				var widget = (e.node && e.node._dvWidget);
				var widget = (widget == this.getContext().rootWidget) ? widget : widget.getParent();
				var n = widget.domNode;

				var children = davinci.states._getChildrenOfNode(n);
				while (children.length) {
					var child = children.shift();
					if (!this.isContainer(child)) {
						children = children.concat(davinci.states._getChildrenOfNode(child));
					}
					var statesArray = this.getStatesArray(child, e.oldState, e.newState, e.stateContainerNode);
					this._update(child, statesArray);
				}
				dojo.publish("/maqetta/appstates/state/changed/end", [e]);

				// Trigger update of the selection box in case the selected widget changed size or moved
				var context = this.getContext();
				if (context) {
					context.clearCachedWidgetBounds();
					// Note: updateHighlightsBaseStateWidgets() updates the state of 
					// the highlightBaseWidgets icon (called by updateFocusAll())
					context.updateFocusAll();
					this.updateStateIcons(context);
				}
			}));
			
			connect.subscribe("/davinci/states/state/renamed", dojo.hitch(this, function(e) { 
				var editor = this.getEditor();
				if (!editor || editor.declaredClass == "davinci.themeEditor.ThemeEditor") return; // ignore updates in theme editor
				var widget = (e.node && e.node._dvWidget);

				var children = davinci.states._getChildrenOfNode(e.node);
				while (children.length) {
					var child = children.shift();
					if (!this.isContainer(child)) {
						children = children.concat(davinci.states._getChildrenOfNode(child));
					}
					this.rename(child, e.oldName, e.newName, true);
					this._updateEvents(child, e.oldName, e.newName);
				}
				var state = this.getState(e.stateContainerNode);
				if (state === e.oldName) {
					this.setState(e.newName, e.stateContainerNode, {updateWhenCurrent:false, silent:true});
				}
			}));
			
			connect.subscribe("/davinci/states/state/style/changed", dojo.hitch(this, function(e) { 
//FIXME: getState(node)
//FIXME: what's the difference between e.state and containerState?
				var containerState = this.getState();
				if (containerState == e.state) {
					var stateContainerNode = this.findStateContainer(e.node, e.state);
					var statesArray = this.getStatesArray(e.node, e.state, e.state, stateContainerNode);
					this._update(e.node, statesArray);
				}
			}));
			
			connect.subscribe("/davinci/ui/widget/replaced", dojo.hitch(this, function(newWidget, oldWidget) { 
//FIXME: getState(node)
				var containerState = this.getState();
				if (containerState) {
					var stateContainerNode = this.findStateContainer(newWidget.domNode, containerState);
					var statesArray = this.getStatesArray(newWidget.domNode, containerState, containerState, stateContainerNode);
					this._update(newWidget.domNode, statesArray);
				}
			}));
			
			connect.subscribe("/davinci/states/state/removed", dojo.hitch(this, function(params) {
				// Application "state" has been removed from the document
				// Recursively remove all references to that state from given node and descendants
				if(!params){
					return;
				}
				this._removeStateFromNodeRecursive(params.node, params.state);
			}));
			
			connect.subscribe('/davinci/ui/context/statesLoaded', dojo.hitch(this, function() {
				var context = this.getContext();
				// Note: updateHighlightsBaseStateWidgets() updates the state of 
				// the highlightBaseWidgets icon (called by updateFocusAll())
				context.updateFocusAll();
				this.updateStateIcons(context);
			}));
			
			connect.subscribe('/davinci/ui/context/statesLoaded', dojo.hitch(this, function() {
				var context = this.getContext();
				// Note: updateHighlightsBaseStateWidgets() updates the state of 
				// the highlightBaseWidgets icon (called by updateFocusAll())
				context.updateFocusAll();
				this.updateStateIcons(context);
			}));
			
			connect.subscribe("/davinci/ui/widgetSelected", dojo.hitch(this, function() {
				var context = this.getContext();
				this.updateStateIcons(context);
			}));
			
			this.subscribed = true;
		}
	}
});

//TODO: change to use singleton pattern for this module?
davinci.ve.states = new veStates();
davinci.ve.states.initialize();

return davinci.ve.states;
});

},
'davinci/css':function(){
/**
 * AMD plugin to load a CSS file using <link>.
 */

define([
	"dojo/_base/window",
	"dojo/dom-construct",
	"dojo/dom-attr" // sub-dependency, workaround for #2047
], function(baseWindow, construct) {

var head = baseWindow.doc.getElementsByTagName('head')[0],
	cache = {};

return {
	load: function(id, require, callback) {
		var url = require.toUrl(id);
		if (url in cache) {
			// already loaded
			callback();
			return;
		}

		construct.create('link',
			{
				rel: 'stylesheet',
				type: 'text/css',
				href: url
			},
			head
		);
		cache[url] = 1;
		callback();
	}
};

});
},
'url:dijit/form/templates/ComboButton.html':"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tcellspacing='0' cellpadding='0' role=\"presentation\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonNode\" data-dojo-attach-point=\"buttonNode\" data-dojo-attach-event=\"ondijitclick:_onClick,onkeypress:_onButtonKeyPress\"\n\t\t><div id=\"${id}_button\" class=\"dijitReset dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><div class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitInline dijitButtonText\" id=\"${id}_label\" data-dojo-attach-point=\"containerNode\" role=\"presentation\"></div\n\t\t></div\n\t\t></td\n\t\t><td id=\"${id}_arrow\" class='dijitReset dijitRight dijitButtonNode dijitArrowButton'\n\t\t\tdata-dojo-attach-point=\"_popupStateNode,focusNode,_buttonNode\"\n\t\t\tdata-dojo-attach-event=\"onkeypress:_onArrowKeyPress\"\n\t\t\ttitle=\"${optionsTitle}\"\n\t\t\trole=\"button\" aria-haspopup=\"true\"\n\t\t\t><div class=\"dijitReset dijitArrowButtonInner\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitArrowButtonChar\" role=\"presentation\">&#9660;</div\n\t\t></td\n\t\t><td style=\"display:none !important;\"\n\t\t\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" data-dojo-attach-point=\"valueNode\" role=\"presentation\"\n\t\t/></td></tr></tbody\n></table>\n",
'dijit/DialogUnderlay':function(){
define([
	"dojo/_base/declare", // declare
	"dojo/dom-attr", // domAttr.set
	"dojo/window", // winUtils.getBox
	"./_Widget",
	"./_TemplatedMixin",
	"./BackgroundIframe"
], function(declare, domAttr, winUtils, _Widget, _TemplatedMixin, BackgroundIframe){

	// module:
	//		dijit/DialogUnderlay

	return declare("dijit.DialogUnderlay", [_Widget, _TemplatedMixin], {
		// summary:
		//		The component that blocks the screen behind a `dijit.Dialog`
		//
		// description:
		//		A component used to block input behind a `dijit.Dialog`. Only a single
		//		instance of this widget is created by `dijit.Dialog`, and saved as
		//		a reference to be shared between all Dialogs as `dijit._underlay`
		//
		//		The underlay itself can be styled based on and id:
		//	|	#myDialog_underlay { background-color:red; }
		//
		//		In the case of `dijit.Dialog`, this id is based on the id of the Dialog,
		//		suffixed with _underlay.

		// Template has two divs; outer div is used for fade-in/fade-out, and also to hold background iframe.
		// Inner div has opacity specified in CSS file.
		templateString: "<div class='dijitDialogUnderlayWrapper'><div class='dijitDialogUnderlay' data-dojo-attach-point='node'></div></div>",

		// Parameters on creation or updatable later

		// dialogId: String
		//		Id of the dialog.... DialogUnderlay's id is based on this id
		dialogId: "",

		// class: String
		//		This class name is used on the DialogUnderlay node, in addition to dijitDialogUnderlay
		"class": "",

		_setDialogIdAttr: function(id){
			domAttr.set(this.node, "id", id + "_underlay");
			this._set("dialogId", id);
		},

		_setClassAttr: function(clazz){
			this.node.className = "dijitDialogUnderlay " + clazz;
			this._set("class", clazz);
		},

		postCreate: function(){
			// summary:
			//		Append the underlay to the body
			this.ownerDocumentBody.appendChild(this.domNode);
		},

		layout: function(){
			// summary:
			//		Sets the background to the size of the viewport
			//
			// description:
			//		Sets the background to the size of the viewport (rather than the size
			//		of the document) since we need to cover the whole browser window, even
			//		if the document is only a few lines long.
			// tags:
			//		private

			var is = this.node.style,
				os = this.domNode.style;

			// hide the background temporarily, so that the background itself isn't
			// causing scrollbars to appear (might happen when user shrinks browser
			// window and then we are called to resize)
			os.display = "none";

			// then resize and show
			var viewport = winUtils.getBox(this.ownerDocument);
			os.top = viewport.t + "px";
			os.left = viewport.l + "px";
			is.width = viewport.w + "px";
			is.height = viewport.h + "px";
			os.display = "block";
		},

		show: function(){
			// summary:
			//		Show the dialog underlay
			this.domNode.style.display = "block";
			this.layout();
			this.bgIframe = new BackgroundIframe(this.domNode);
		},

		hide: function(){
			// summary:
			//		Hides the dialog underlay
			this.bgIframe.destroy();
			delete this.bgIframe;
			this.domNode.style.display = "none";
		}
	});
});

},
'dijit/layout/ScrollingTabController':function(){
define([
	"dojo/_base/array", // array.forEach
	"dojo/_base/declare", // declare
	"dojo/dom-class", // domClass.add domClass.contains
	"dojo/dom-geometry", // domGeometry.contentBox
	"dojo/dom-style", // domStyle.style
	"dojo/_base/fx", // Animation
	"dojo/_base/lang", // lang.hitch
	"dojo/on",
	"dojo/query", // query
	"dojo/sniff", // has("ie"), has("webkit"), has("quirks")
	"../registry",	// registry.byId()
	"dojo/text!./templates/ScrollingTabController.html",
	"dojo/text!./templates/_ScrollingTabControllerButton.html",
	"./TabController",
	"./utils",	// marginBox2contextBox, layoutChildren
	"../_WidgetsInTemplateMixin",
	"../Menu",
	"../MenuItem",
	"../form/Button",
	"../_HasDropDown",
	"dojo/NodeList-dom" // NodeList.style
], function(array, declare, domClass, domGeometry, domStyle, fx, lang, on, query, has,
	registry, tabControllerTemplate, buttonTemplate, TabController, layoutUtils, _WidgetsInTemplateMixin,
	Menu, MenuItem, Button, _HasDropDown){

// module:
//		dijit/layout/ScrollingTabController


var ScrollingTabController = declare("dijit.layout.ScrollingTabController", [TabController, _WidgetsInTemplateMixin], {
	// summary:
	//		Set of tabs with left/right arrow keys and a menu to switch between tabs not
	//		all fitting on a single row.
	//		Works only for horizontal tabs (either above or below the content, not to the left
	//		or right).
	// tags:
	//		private

	baseClass: "dijitTabController dijitScrollingTabController",

	templateString: tabControllerTemplate,

	// useMenu: [const] Boolean
	//		True if a menu should be used to select tabs when they are too
	//		wide to fit the TabContainer, false otherwise.
	useMenu: true,

	// useSlider: [const] Boolean
	//		True if a slider should be used to select tabs when they are too
	//		wide to fit the TabContainer, false otherwise.
	useSlider: true,

	// tabStripClass: [const] String
	//		The css class to apply to the tab strip, if it is visible.
	tabStripClass: "",

	widgetsInTemplate: true,

	// _minScroll: Number
	//		The distance in pixels from the edge of the tab strip which,
	//		if a scroll animation is less than, forces the scroll to
	//		go all the way to the left/right.
	_minScroll: 5,

	// Override default behavior mapping class to DOMNode
	_setClassAttr: { node: "containerNode", type: "class" },

	buildRendering: function(){
		this.inherited(arguments);
		var n = this.domNode;

		this.scrollNode = this.tablistWrapper;
		this._initButtons();

		if(!this.tabStripClass){
			this.tabStripClass = "dijitTabContainer" +
				this.tabPosition.charAt(0).toUpperCase() +
				this.tabPosition.substr(1).replace(/-.*/, "") +
				"None";
			domClass.add(n, "tabStrip-disabled")
		}

		domClass.add(this.tablistWrapper, this.tabStripClass);
	},

	onStartup: function(){
		this.inherited(arguments);

		// TabController is hidden until it finishes drawing, to give
		// a less visually jumpy instantiation.   When it's finished, set visibility to ""
		// to that the tabs are hidden/shown depending on the container's visibility setting.
		domStyle.set(this.domNode, "visibility", "");
		this._postStartup = true;

		// changes to the tab button label or iconClass will have changed the width of the
		// buttons, so do a resize
		this.own(on(this.containerNode, "attrmodified-label, attrmodified-iconclass", lang.hitch(this, function(evt){
			if(this._dim){
				this.resize(this._dim);
			}
		})));
	},

	onAddChild: function(page, insertIndex){
		this.inherited(arguments);

		// Increment the width of the wrapper when a tab is added
		// This makes sure that the buttons never wrap.
		// The value 200 is chosen as it should be bigger than most
		// Tab button widths.
		domStyle.set(this.containerNode, "width",
			(domStyle.get(this.containerNode, "width") + 200) + "px");
	},

	onRemoveChild: function(page, insertIndex){
		// null out _selectedTab because we are about to delete that dom node
		var button = this.pane2button[page.id];
		if(this._selectedTab === button.domNode){
			this._selectedTab = null;
		}

		this.inherited(arguments);
	},

	_initButtons: function(){
		// summary:
		//		Creates the buttons used to scroll to view tabs that
		//		may not be visible if the TabContainer is too narrow.

		// Make a list of the buttons to display when the tab labels become
		// wider than the TabContainer, and hide the other buttons.
		// Also gets the total width of the displayed buttons.
		this._btnWidth = 0;
		this._buttons = query("> .tabStripButton", this.domNode).filter(function(btn){
			if((this.useMenu && btn == this._menuBtn.domNode) ||
				(this.useSlider && (btn == this._rightBtn.domNode || btn == this._leftBtn.domNode))){
				this._btnWidth += domGeometry.getMarginSize(btn).w;
				return true;
			}else{
				domStyle.set(btn, "display", "none");
				return false;
			}
		}, this);
	},

	_getTabsWidth: function(){
		var children = this.getChildren();
		if(children.length){
			var leftTab = children[this.isLeftToRight() ? 0 : children.length - 1].domNode,
				rightTab = children[this.isLeftToRight() ? children.length - 1 : 0].domNode;
			return rightTab.offsetLeft + rightTab.offsetWidth - leftTab.offsetLeft;
		}else{
			return 0;
		}
	},

	_enableBtn: function(width){
		// summary:
		//		Determines if the tabs are wider than the width of the TabContainer, and
		//		thus that we need to display left/right/menu navigation buttons.
		var tabsWidth = this._getTabsWidth();
		width = width || domStyle.get(this.scrollNode, "width");
		return tabsWidth > 0 && width < tabsWidth;
	},

	resize: function(dim){
		// summary:
		//		Hides or displays the buttons used to scroll the tab list and launch the menu
		//		that selects tabs.

		// Save the dimensions to be used when a child is renamed.
		this._dim = dim;

		// Set my height to be my natural height (tall enough for one row of tab labels),
		// and my content-box width based on margin-box width specified in dim parameter.
		// But first reset scrollNode.height in case it was set by layoutChildren() call
		// in a previous run of this method.
		this.scrollNode.style.height = "auto";
		var cb = this._contentBox = layoutUtils.marginBox2contentBox(this.domNode, {h: 0, w: dim.w});
		cb.h = this.scrollNode.offsetHeight;
		domGeometry.setContentSize(this.domNode, cb);

		// Show/hide the left/right/menu navigation buttons depending on whether or not they
		// are needed.
		var enable = this._enableBtn(this._contentBox.w);
		this._buttons.style("display", enable ? "" : "none");

		// Position and size the navigation buttons and the tablist
		this._leftBtn.layoutAlign = "left";
		this._rightBtn.layoutAlign = "right";
		this._menuBtn.layoutAlign = this.isLeftToRight() ? "right" : "left";
		layoutUtils.layoutChildren(this.domNode, this._contentBox,
			[this._menuBtn, this._leftBtn, this._rightBtn, {domNode: this.scrollNode, layoutAlign: "client"}]);

		// set proper scroll so that selected tab is visible
		if(this._selectedTab){
			if(this._anim && this._anim.status() == "playing"){
				this._anim.stop();
			}
			this.scrollNode.scrollLeft = this._convertToScrollLeft(this._getScrollForSelectedTab());
		}

		// Enable/disabled left right buttons depending on whether or not user can scroll to left or right
		this._setButtonClass(this._getScroll());

		this._postResize = true;

		// Return my size so layoutChildren() can use it.
		// Also avoids IE9 layout glitch on browser resize when scroll buttons present
		return {h: this._contentBox.h, w: dim.w};
	},

	_getScroll: function(){
		// summary:
		//		Returns the current scroll of the tabs where 0 means
		//		"scrolled all the way to the left" and some positive number, based on #
		//		of pixels of possible scroll (ex: 1000) means "scrolled all the way to the right"
		return (this.isLeftToRight() || has("ie") < 8 || (has("ie") && has("quirks")) || has("webkit")) ? this.scrollNode.scrollLeft :
				domStyle.get(this.containerNode, "width") - domStyle.get(this.scrollNode, "width")
					 + (has("ie") >= 8 ? -1 : 1) * this.scrollNode.scrollLeft;
	},

	_convertToScrollLeft: function(val){
		// summary:
		//		Given a scroll value where 0 means "scrolled all the way to the left"
		//		and some positive number, based on # of pixels of possible scroll (ex: 1000)
		//		means "scrolled all the way to the right", return value to set this.scrollNode.scrollLeft
		//		to achieve that scroll.
		//
		//		This method is to adjust for RTL funniness in various browsers and versions.
		if(this.isLeftToRight() || has("ie") < 8 || (has("ie") && has("quirks")) || has("webkit")){
			return val;
		}else{
			var maxScroll = domStyle.get(this.containerNode, "width") - domStyle.get(this.scrollNode, "width");
			return (has("ie") >= 8 ? -1 : 1) * (val - maxScroll);
		}
	},

	onSelectChild: function(/*dijit/_WidgetBase*/ page){
		// summary:
		//		Smoothly scrolls to a tab when it is selected.

		var tab = this.pane2button[page.id];
		if(!tab || !page){return;}

		var node = tab.domNode;

		// Save the selection
		if(node != this._selectedTab){
			this._selectedTab = node;

			// Scroll to the selected tab, except on startup, when scrolling is handled in resize()
			if(this._postResize){
				var sl = this._getScroll();

				if(sl > node.offsetLeft ||
						sl + domStyle.get(this.scrollNode, "width") <
						node.offsetLeft + domStyle.get(node, "width")){
					this.createSmoothScroll().play();
				}
			}
		}

		this.inherited(arguments);
	},

	_getScrollBounds: function(){
		// summary:
		//		Returns the minimum and maximum scroll setting to show the leftmost and rightmost
		//		tabs (respectively)
		var children = this.getChildren(),
			scrollNodeWidth = domStyle.get(this.scrollNode, "width"),		// about 500px
			containerWidth = domStyle.get(this.containerNode, "width"),	// 50,000px
			maxPossibleScroll = containerWidth - scrollNodeWidth,	// scrolling until right edge of containerNode visible
			tabsWidth = this._getTabsWidth();

		if(children.length && tabsWidth > scrollNodeWidth){
			// Scrolling should happen
			return {
				min: this.isLeftToRight() ? 0 : children[children.length-1].domNode.offsetLeft,
				max: this.isLeftToRight() ?
					(children[children.length-1].domNode.offsetLeft + children[children.length-1].domNode.offsetWidth) - scrollNodeWidth :
					maxPossibleScroll
			};
		}else{
			// No scrolling needed, all tabs visible, we stay either scrolled to far left or far right (depending on dir)
			var onlyScrollPosition = this.isLeftToRight() ? 0 : maxPossibleScroll;
			return {
				min: onlyScrollPosition,
				max: onlyScrollPosition
			};
		}
	},

	_getScrollForSelectedTab: function(){
		// summary:
		//		Returns the scroll value setting so that the selected tab
		//		will appear in the center
		var w = this.scrollNode,
			n = this._selectedTab,
			scrollNodeWidth = domStyle.get(this.scrollNode, "width"),
			scrollBounds = this._getScrollBounds();

		// TODO: scroll minimal amount (to either right or left) so that
		// selected tab is fully visible, and just return if it's already visible?
		var pos = (n.offsetLeft + domStyle.get(n, "width")/2) - scrollNodeWidth/2;
		pos = Math.min(Math.max(pos, scrollBounds.min), scrollBounds.max);

		// TODO:
		// If scrolling close to the left side or right side, scroll
		// all the way to the left or right.  See this._minScroll.
		// (But need to make sure that doesn't scroll the tab out of view...)
		return pos;
	},

	createSmoothScroll: function(x){
		// summary:
		//		Creates a dojo._Animation object that smoothly scrolls the tab list
		//		either to a fixed horizontal pixel value, or to the selected tab.
		// description:
		//		If an number argument is passed to the function, that horizontal
		//		pixel position is scrolled to.  Otherwise the currently selected
		//		tab is scrolled to.
		// x: Integer?
		//		An optional pixel value to scroll to, indicating distance from left.

		// Calculate position to scroll to
		if(arguments.length > 0){
			// position specified by caller, just make sure it's within bounds
			var scrollBounds = this._getScrollBounds();
			x = Math.min(Math.max(x, scrollBounds.min), scrollBounds.max);
		}else{
			// scroll to center the current tab
			x = this._getScrollForSelectedTab();
		}

		if(this._anim && this._anim.status() == "playing"){
			this._anim.stop();
		}

		var self = this,
			w = this.scrollNode,
			anim = new fx.Animation({
				beforeBegin: function(){
					if(this.curve){ delete this.curve; }
					var oldS = w.scrollLeft,
						newS = self._convertToScrollLeft(x);
					anim.curve = new fx._Line(oldS, newS);
				},
				onAnimate: function(val){
					w.scrollLeft = val;
				}
			});
		this._anim = anim;

		// Disable/enable left/right buttons according to new scroll position
		this._setButtonClass(x);

		return anim; // dojo/_base/fx/Animation
	},

	_getBtnNode: function(/*Event*/ e){
		// summary:
		//		Gets a button DOM node from a mouse click event.
		// e:
		//		The mouse click event.
		var n = e.target;
		while(n && !domClass.contains(n, "tabStripButton")){
			n = n.parentNode;
		}
		return n;
	},

	doSlideRight: function(/*Event*/ e){
		// summary:
		//		Scrolls the menu to the right.
		// e:
		//		The mouse click event.
		this.doSlide(1, this._getBtnNode(e));
	},

	doSlideLeft: function(/*Event*/ e){
		// summary:
		//		Scrolls the menu to the left.
		// e:
		//		The mouse click event.
		this.doSlide(-1,this._getBtnNode(e));
	},

	doSlide: function(/*Number*/ direction, /*DomNode*/ node){
		// summary:
		//		Scrolls the tab list to the left or right by 75% of the widget width.
		// direction:
		//		If the direction is 1, the widget scrolls to the right, if it is -1,
		//		it scrolls to the left.

		if(node && domClass.contains(node, "dijitTabDisabled")){return;}

		var sWidth = domStyle.get(this.scrollNode, "width");
		var d = (sWidth * 0.75) * direction;

		var to = this._getScroll() + d;

		this._setButtonClass(to);

		this.createSmoothScroll(to).play();
	},

	_setButtonClass: function(/*Number*/ scroll){
		// summary:
		//		Disables the left scroll button if the tabs are scrolled all the way to the left,
		//		or the right scroll button in the opposite case.
		// scroll: Integer
		//		amount of horizontal scroll

		var scrollBounds = this._getScrollBounds();
		this._leftBtn.set("disabled", scroll <= scrollBounds.min);
		this._rightBtn.set("disabled", scroll >= scrollBounds.max);
	}
});


var ScrollingTabControllerButtonMixin = declare("dijit.layout._ScrollingTabControllerButtonMixin", null, {
	baseClass: "dijitTab tabStripButton",

	templateString: buttonTemplate,

		// Override inherited tabIndex: 0 from dijit/form/Button, because user shouldn't be
		// able to tab to the left/right/menu buttons
	tabIndex: "",

	// Similarly, override FormWidget.isFocusable() because clicking a button shouldn't focus it
	// either (this override avoids focus() call in FormWidget.js)
	isFocusable: function(){ return false; }
});

// Class used in template
declare("dijit.layout._ScrollingTabControllerButton",
	[Button, ScrollingTabControllerButtonMixin]);

// Class used in template
declare(
	"dijit.layout._ScrollingTabControllerMenuButton",
	[Button, _HasDropDown, ScrollingTabControllerButtonMixin],
{
	// id of the TabContainer itself
	containerId: "",

	// -1 so user can't tab into the button, but so that button can still be focused programatically.
	// Because need to move focus to the button (or somewhere) before the menu is hidden or IE6 will crash.
	tabIndex: "-1",

	isLoaded: function(){
		// recreate menu every time, in case the TabContainer's list of children (or their icons/labels) have changed
		return false;
	},

	loadDropDown: function(callback){
		this.dropDown = new Menu({
			id: this.containerId + "_menu",
			ownerDocument: this.ownerDocument,
			dir: this.dir,
			lang: this.lang,
			textDir: this.textDir
		});
		var container = registry.byId(this.containerId);
		array.forEach(container.getChildren(), function(page){
			var menuItem = new MenuItem({
				id: page.id + "_stcMi",
				label: page.title,
				iconClass: page.iconClass,
				disabled: page.disabled,
				ownerDocument: this.ownerDocument,
				dir: page.dir,
				lang: page.lang,
				textDir: page.textDir,
				onClick: function(){
					container.selectChild(page);
				}
			});
			this.dropDown.addChild(menuItem);
		}, this);
		callback();
	},

	closeDropDown: function(/*Boolean*/ focus){
		this.inherited(arguments);
		if(this.dropDown){
			this.dropDown.destroyRecursive();
			delete this.dropDown;
		}
	}
});

return ScrollingTabController;
});

},
'davinci/html/CSSCombinedSelector':function(){
/**
 * @class davinci.html.CSSCombinedSelector
 * @constructor
 * @extends davinci.html.CSSElement
 */
define([
	"dojo/_base/declare",
	"davinci/html/CSSElement"
], function(declare, CSSElement) {

return declare("davinci.html.CSSCombinedSelector", CSSElement, {

	constructor: function() {
		this.selectors = [];
		this.combiners = [];
		this.elementType = "CSSCombinedSelector";
	},

	matchesSelector: function(selector) {
		if (selector.elementType == this.elementType) {
			if (selector.selectors.length == this.selectors.length) {
				for ( var i = 0; i < this.selectors.length; i++ ) {
					if (this.combiners[i] != selector.combiners[i]) {
						return false;
					}
					if (!this.selectors[i].matchesSelector(selector.selectors[i])) {
						return false;
					}
				}
				return true;
			}
		}
	},

	getText: function(context) {
		var s = "";
		for ( var i = 0; i < this.selectors.length - 1; i++ ) {
			s = s + this.selectors[i].getText(context);
			if (this.combiners[i] != " ") {
				s += ' ' + this.combiners[i] + ' ';
			} else {
				s += this.combiners[i];
			}
		}
		s = s + this.selectors[this.selectors.length - 1].getText(context);
		return s;
	},

	matches: function(domNode) {
		var selectorInx = this.selectors.length - 1;
		var totalSpecific = 0;
		for ( var i = 0; i < domNode.length; i++ ) {
			var specific;

			if ((specific = this.selectors[selectorInx].matches(domNode, i)) >= 0) {
				totalSpecific += specific;
				selectorInx-- ;
				if (selectorInx < 0) {
					return totalSpecific;
				}
			}
			if (i == 0 && specific < 0)
				return -1;
		}
	},

	visit: function(visitor) {
		if (!visitor.visit(this)) {
			for ( var i = 0; i < this.children.length; i++ ) {
				this.children[i].visit(visitor);
			}
			for ( var i = 0; i < this.selectors.length; i++ ) {
				this.selectors[i].visit(visitor);
			}
		}
		if (visitor.endVisit) {
			visitor.endVisit(this); 
		}
	},

	getCSSRule: function() {
		return this.parent;
	}

});
});


},
'davinci/review/model/resource/Folder':function(){
define([
	"dojo/_base/declare",
	"davinci/model/resource/Resource",
	"davinci/review/model/resource/File",
	"dojo/_base/xhr",
	"dojo/date/stamp"
], function(declare, Resource, reviewFile, xhr, stamp) {

return declare("davinci.review.model.resource.Folder", Resource, {

	isDraft: false,
	closed: false,
	width: 0,
	height: 0,

	constructor: function(proc) {
		dojo.mixin(this, proc);
		this.elementType = "ReviewVersion";
		this.dueDate = this.dueDate == "infinite" ? this.dueDate : stamp.fromISOString(this.dueDate);
	},

	//deprecated
	getChildrenSync: function(onComplete, sync) {
		this.getChildren(onComplete);
	},

	getChildren: function(onComplete, onError) {
		if (this._isLoaded) {
			onComplete.call(null, this.children);
		} else {
			if (this._loading) {
				this._loading.then(
					function(){ onComplete.call(null, this.children); }.bind(this),
					onError);
			} else {
				var designerName = this.designerId || "";
				this._loading = xhr.get({
					url: "cmd/listReviewFiles",
					handleAs: "json",
					content: {
						designer: designerName,
						version: this.timeStamp
					}
				}).then(function(responseObject, ioArgs) {
					this.children = responseObject.map(function(file){
						return new reviewFile(file.path, this);
					}, this);
					this._isLoaded=true;
					onComplete.call(null, this.children);
					delete this._loading;
				}.bind(this),
				onError);
			}
		}
	},
	
	getPath: function() {
		if (this.parent) {
			return this.parent.getPath() + "/" + this.timeStamp;
		}
		return this.timeStamp;
	}
});
});



},
'davinci/ve/input/MultiFieldSmartInput':function(){
define([
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/_base/connect",
	"dojo/dom-style",
	"davinci/Runtime",
	"davinci/ve/input/SmartInput",
	"davinci/ve/widget",
	"davinci/ve/commands/ModifyCommand",
	"dojox/html/entities",
	"dijit/form/DateTextBox",
	"dijit/form/TimeTextBox",
	"dojo/i18n!dijit/nls/common",
	//"dojo/i18n!./nls/webContent",
	"dojo/text!./templates/MultiFieldSmartInput.html",
	"dojo/text!./templates/MultiFieldTableRowSmartInput.html",
	"dojo/text!./templates/MultiFieldMultiLineTableRowSmartInput.html",
	"dijit/Tooltip",
	"davinci/css!./templates/MultiFieldSmartInput.css"
], function(
	declare,
	lang,
	connect,
	style,
	Runtime,
	SmartInput,
	Widget,
	ModifyCommand,
	entities,
	DateTextBox,
	TimeTextBox,
	commonNls,
//	webContent,
	mainTemplateString,
	trTemplateString,
	trMultiLineTemplateString,
	Tooltip
) {

 

var MultiFieldSmartInput = declare(SmartInput, {

	property: [{"property":"placeholder", "multiLine": false}, {"property":"value", "multiLine": false}],
	displayOnCreate: "true",
	delimiter: ", ",
	multiLine: "true",
	supportsHTML: "false", 
	//helpText: "Enter values....",
	_substitutedMainTemplate: null,
	
	destroyTooltips: function() {
		this.property.forEach (function(p) {
			var prop = p.property || p.child.property;
			var tooltip = dijit.byId('MultiFieldSmartInput_SmartInput_checkbox_'+prop+'_tooltip');
			tooltip.destroyRecursive();			
		}.bind(this));
	},
	_getEditor: function() {
		return Runtime.currentEditor;
	},
	
	_getContext: function() {
		var editor = this._getEditor();
		return editor && (editor.getContext && editor.getContext() || editor.context);
	},
	
	getHelpText: function() {
		var str="";
		if (this.helpText) {
			str = this.helpText;
		} else {
			this.property.forEach(function(p){
				var prop = p.property || p.child.property;
				var description = this._widget.metadata.property[prop] ? this._widget.metadata.property[prop].description : null;
				if (p.helpText) {
					description = p.helpText;
				}
				if (description) {
					str = str + "<i>"+this.getTitle(prop)+":</i> "+ entities.encode(description) + "<br>";
				}
			}.bind(this));
		}
		if (str.length < 1) {
			str = 'The toolkit provider has not supplied help for this widget, please consult your provider.';
		}
		return str;
		
	},
	
	getTitle: function(prop) {
		return prop; // just use the prop as the title.
		/*if (this._widget.metadata.property[prop].title) {
			return this._widget.metadata.property[prop].title;
		} else {
			return prop;
		}*/
	},
	
	getPropertyObject: function(prop) {
		for (var i = 0; i < this.property.length; i++ ) {
			var property = this.property[i].property || this.property[i].child.property;
			if (this.property[i].property && (this.property[i].property == prop)) {
				return this.property[i];
			} else if (this.property[i].child && (this.property[i].child.property == prop)) {
				return this.property[i].child;
			}
		}
	},
	
	onOk: function(e){

		var context = this._getContext();
		var props = {};
		var children = null;
		this.property.forEach (function(p) {
			var prop = p.property || p.child.property;
			var value = this._getStringValueOfTextBox(prop);
			var checkbox = dijit.byId('MultiFieldSmartInput_SmartInput_checkbox_'+prop);
			if (!p.supportsHTML || !checkbox.checked) { // encode if plan text
				value = entities.encode(value);
			}
		//	if (p.multiLine) {
				if (p.child) {
					children = this.parseChildren(p, value);
					if (p.property) {
						// some multiline widgets support value for selection, it breaks others.
						// so only included if required.
						props[p.property] = this.getSelectedOption(this._widget, children);;
					}
				} else {
					props[p.property] = value;
				}
				
			/*} else {
				props[p.property] = value;
			}*/
		}.bind(this));
		var command =  new ModifyCommand(this._widget, props, children, context);
		context.getCommandStack().execute(command);
		//Hide
		this.hide(); 
	},
	
	parseChildren: function(p, value) {
		var data = this._widget.getData();
		var items = this.parseItems(value);
		var children = data.children;// this.getChildren(widget);
		
		for (var i = 0; i < items.length; i++) {
			var value = items[i];
			var text = value.text;
			if (!p.child.supportsHTML){
				items[i].text = dojox.html.entities.decode(text);
			}
			if (i < children.length) {
				var child = children[i];
				child.children = text;
				child.properties.value = text;
				child.properties.selected = value.selected;
			} else {
				//  new child
				child = {};
				child.type = p.child.type;
				child.properties = {};
				child.properties[p.child.property] = text;
				if (value.selected) {
					child.properties.selected = value.selected;
				}
				child.children = text || value;
				children.push(child);
				
			}
			
		}
		
		if (items.length > 0) {
			var length = children.length;
			for (var i = items.length; i < length; i++) {
				children.pop();
			}
		}
		return children;
		
		/*var command = new ModifyCommand(widget, this.getProperties(widget, values), children);
		this._getContext().getCommandStack().execute(command);
		return command.newWidget;*/
	},

	hide: function(){

			if (this._inline) {
				var value;
				while (connection = this._connection.pop()){
					if (connection) {
						dojo.disconnect(connection);
					}
				}
				var smartInputContainer = this._findSmartInputContainer(this._widget._edit_context.frameNode);
				if(!smartInputContainer){
					console.log('ERROR. MultiFieldSmartInput.js _loading(). No ancestor ContentPane');
					return;
				}
				if (this._loadingDiv) {
					smartInputContainer.removeChild(this._loadingDiv);
				}
				if(this._inline.style.display != "none" ){
					this._format = this.getFormat();
					this._inline.style.display = "none";
					this.destroyTooltips();
					this._inline.destroyRecursive();
					delete this._inline;  
	                var iebPointer = smartInputContainer.ownerDocument.getElementById('iebPointer');
					smartInputContainer.removeChild(iebPointer);
					var context=this._widget.getContext();
					var userdoc = context.getDocument();	// inner document = user's document
					userdoc.defaultView.focus();	// Make sure the userdoc is the focus object for keyboard events
				}
	 
			}

	},
	
	
	show: function(widgetId) {
		this._lastKeyCode = 0;
		this._widget = Widget.byId(widgetId);
		var data = this._widget.getData();
		
			
		var width = 200;
		var height = 255;
		this._loading(height, width);
			
		dojo.addClass('ieb', "MultiFieldSmartInput");
		var content = this._getTemplate();
		this._inline.attr("content", content);
		this._connection.push(dojo.connect(this._inline, "onBlur", this, "onOk")); 
		this._connectHelpDiv();
		this._connectResizeHandle();
		this._connectSimDiv();
		if (this._loadingDiv) {
			this._loadingDiv.style.backgroundImage = 'none'; // turn off spinner
		}
		var prop = this.property[0].property || this.property[0].child.property;
		var targetEdit = dijit.byId('MultiFieldSmartInput_SmartInput_'+prop);
		dijit.selectInputText(targetEdit.textbox);
		targetEdit.focus();
		this.connectEditBoxes();
		this.setStartSize();
		this.resize(null);

	},
	
	connectEditBoxes: function() {

		this.property.forEach (function(p) {
			var prop = p.property || p.child.property
			var targetDijit = dijit.byId('MultiFieldSmartInput_SmartInput_'+prop);
			this._connection.push(dojo.connect(targetDijit, "onMouseDown", this, "stopEvent"));
			this._connection.push(dojo.connect(targetDijit, "onKeyUp", this, "handleEvent"));
			var checkboxDiv = dojo.byId('MultiFieldSmartInput_SmartInput_checkbox_div_'+prop);
			targetDijit = dijit.byId('MultiFieldSmartInput_SmartInput_checkbox_'+prop);
			this._connection.push(dojo.connect(targetDijit, "onClick", this, "htmlCheckbox"));
			new Tooltip({
				 	id: 'MultiFieldSmartInput_SmartInput_checkbox_'+prop+'_tooltip',
		            connectId: [checkboxDiv],
		            label: "the text for the tooltip"
		       });
		
			this.updateFormats(prop);
		}.bind(this));
		
		
	},
	
	containsHtml: function(value){
		var n = dojo.create("div", { innerHTML: value});
		var format = n.children.length ? 'html' : 'text';
		return format;

	},
	
	htmlCheckbox: function(e) {

		var id = e.currentTarget.id.split("_");
		var prop = id[id.length-1];
		var editBox = dijit.byId('MultiFieldSmartInput_SmartInput_'+prop);
		var targetDijit = dijit.byId(e.currentTarget.id+'_tooltip');
		var text = editBox.getValue();
		var format = 'html';
		if (!e.currentTarget.checked) {
			text = entities.encode(text);
			format = 'text'
		} 
		targetDijit.attr('label','Format contents as '+format+':<br>'+text);
	
	},
	
	setStartSize: function() {
		// calculate the height based on the edit boxs
		var tds = dojo.query('.MultiFieldSmartInput_SmartInput_value', 'davinci.ve.input.MultiFieldSmartInput_table');
		// Find the widest label
		var height = 0;
		tds.forEach(function(td){
				height += td.clientHeight + 5;
		});
		var targetObj = dojo.byId("iedResizeDiv");
		var target = dijit.byId("iedResizeDiv");
		//targetObj._setStyleAttr({width: boxWidth + "px", height: boxheight + "px", maxHeight: boxheight + "px"}); // needed for multi line
		dojo.style('iedResizeDiv', 'height', height  + 5 + "px");
		dojo.style('iedResizeDiv', 'minHeight', height  + 5 + "px");
	},


	
	handleEvent: function(event){
		var multiLine = false;
		for (var i = 0; i < this.property.length; i++) {
			var p = this.property[i];
			var prop = p.property || p.child.property;
			if (event.currentTarget.id.indexOf('MultiFieldSmartInput_SmartInput_'+prop) > -1) {
				multiLine = p.multiLine;
				break;
			}
		}
		
		if (event.keyCode == 13) {
			if (!multiLine || multiLine == "false" || this._lastKeyCode == 13){ // back to back CR
				this.onOk();
			}
		} else {
			var x = event.target.id.split("_");
			var prop = x[x.length-1];
			this.updateFormats(prop);
		}
		this._lastKeyCode = event.keyCode;
		this.updateSimStyle();
	},
	
	updateFormats: function(prop) {

		var value = this._getStringValueOfTextBox(prop);
		var disabled = true;
		
		if (this.getPropertyObject(prop).supportsHTML && this.containsHtmlMarkUp(value)) {
			dojo.style('MultiFieldSmartInput_SmartInput_checkbox_div_'+prop,'display', '');
		} else {
			dojo.style('MultiFieldSmartInput_SmartInput_checkbox_div_'+prop,'display', 'none');
		}
		
		var tooltip = dijit.byId('MultiFieldSmartInput_SmartInput_checkbox_'+prop+'_tooltip');
		var checkbox = dijit.byId('MultiFieldSmartInput_SmartInput_checkbox_'+prop);
		var format = 'html';
		if (!checkbox.checked) {
			value = entities.encode(value);
			format = 'text'
		} 
		tooltip.attr('label','Format contents as '+format+':<br>'+value);
		this.resize(null);
				

	},
	serializeChildren: function(data) {
		
		var result = [];
		data.children.forEach(function(child){
			var text = child.properties.value ? child.properties.value : child.children;
			text = entities.decode(text);
			var selected = (child.properties.selected || data.properties.value == text) ? "+" : "";
			result.push(selected + text);
		}.bind(this));
			
		return result = this.serializeItems(result);
 
	},
		
	resize: function(e) {
	//	this.inherited(arguments);	
		var labelWidth = 40;
		
		var tds = dojo.query('.MultiFieldSmartInput_SmartInput_label', 'davinci.ve.input.MultiFieldSmartInput_table');
		// Find the widest label
		tds.forEach(function(td){
			if (td.clientWidth > labelWidth) {
				labelWidth = td.clientWidth;
			}
		});
		// set all label tds to the widest label
		tds.forEach(function(td){
			if (td.clientWidth < labelWidth) {
				dojo.style(td, 'width',  labelWidth + "px");
			}
		});
		var checkboxWidth = 0;
		tds = dojo.query('.MultiFieldSmartInput_SmartInput_checkbox', 'davinci.ve.input.MultiFieldSmartInput_table');
		// Find the widest checkbox
		tds.forEach(function(td){
			if (td.clientWidth > checkboxWidth) {
				checkboxWidth = td.clientWidth;
			}
		});
		// set all checkbox tds to the widest label
		tds.forEach(function(td){
			if (td.clientWidth < checkboxWidth) {
				dojo.style(td, 'width',  checkboxWidth + "px");
			}
		});
		var targetObj = dojo.byId("iedResizeDiv");
		var boxWidth = targetObj.clientWidth	- 5;
		var boxheight = targetObj.clientHeight -6;
		boxWidth = targetObj.clientWidth	/*+2*/ -8;
		boxheight = targetObj.clientHeight	-50; // new for text area
		if (boxheight < 25) {
			boxheight = 25;
		}
		var multiLineEditBoxs = [];
		var singleLineEditBoxsHeight = 0;
		this.property.forEach (function(p) {
			var prop = p.property || p.child.property
			var targetEditBoxDijit = dijit.byId('MultiFieldSmartInput_SmartInput_'+prop);
			targetEditBoxDijit._setStyleAttr({width: targetObj.clientWidth - (labelWidth + checkboxWidth + 20) + "px"});
			if (p.multiLine) {
				multiLineEditBoxs.push(targetEditBoxDijit);
			} else {
				singleLineEditBoxsHeight += targetEditBoxDijit.domNode.clientHeight;	
			}
		}.bind(this));
		if (multiLineEditBoxs.length > 0) {
			// we have multiline boxes to devide up the leftover hieght
			var unusedHeight = targetObj.clientHeight - singleLineEditBoxsHeight;
			var height = (unusedHeight- 25) / multiLineEditBoxs.length  ;
			multiLineEditBoxs.forEach(function(textBox){
				textBox._setStyleAttr({height: height + "px", maxHeight: height + "px"});
			}.bind(this));
		}
		/*if (targetEditBoxDijit) {
			targetEditBoxDijit._setStyleAttr({width: boxWidth + "px", height: boxheight + "px", maxHeight: boxheight + "px"}); // needed for multi line
		}
		targetEditBoxDijit._setStyleAttr({width: targetObj.clientWidth - (labelWidth + 20) + "px"});
		labelEditBoxDijit._setStyleAttr({width: targetObj.clientWidth - (labelWidth + 20) + "px"});*/
				
		dojo.style('ieb', 'width', targetObj.clientWidth + 15 + "px");
		dojo.style('davinci.ve.input.SmartInput_radio_div', 'width', targetObj.clientWidth +  5 + "px");
		

	},

	_getTemplate: function() {
		//if (!this._substitutedMainTemplate) {
			this._substitutedMainTemplate = 
				dojo.replace(mainTemplateString, {
						buttonOk: commonNls.buttonOk,
						buttonCancel: commonNls.buttonCancel,
						tableContent: this._addPropertiesToHTML(),
						helpText: this.getHelpText()
				});
	//	}

		return this._substitutedMainTemplate;
	},
	
	_addPropertiesToHTML: function(){
		
		var data = this._widget.getData();
		var tableContent = "";
		this.property.forEach(function(p){
			var value = data.properties[p.property]  ||  ""; 
			var checked = this.containsHtmlMarkUp(value) ? "checked" : "";
			var prop = p.property || p.child.property;
			if (p.child) {
				value = this.serializeChildren(data);
			}
			if (p.multiLine) {
				tableContent +=
					dojo.replace(trMultiLineTemplateString, {
							label: this.getTitle(prop),
							textboxId: 'MultiFieldSmartInput_SmartInput_'+prop,
							textboxValue: value,
							checkboxDivId: 'MultiFieldSmartInput_SmartInput_checkbox_div_'+prop,
							checkboxId: 'MultiFieldSmartInput_SmartInput_checkbox_'+prop,
							checked: checked
					});
			} else {
				var format = this._widget.metadata.property[prop] ? this._widget.metadata.property[prop].format : null;
				var textboxType = "dijit/form/TextBox";
				if (format) {
					if (format == 'date'){
						textboxType = "dijit/form/DateTextBox";
					} else if (format == 'time'){
						textboxType = "dijit/form/TimeTextBox";
					}
				}
				tableContent +=
				dojo.replace(trTemplateString, {
						label: this.getTitle(prop),
						textboxType: textboxType,
						textboxId: 'MultiFieldSmartInput_SmartInput_'+prop,
						textboxValue: value,
						checkboxDivId: 'MultiFieldSmartInput_SmartInput_checkbox_div_'+prop,
						checkboxId: 'MultiFieldSmartInput_SmartInput_checkbox_'+prop,
						checked: checked
				});
			}
			
		}.bind(this));
		return tableContent;
		
	},
	
	getSelectedOption: function(widget, options) {

		var value="";
		for (var i = 0; i < options.length; i++) {
			var option = options[i];
			if (option.properties.selected) {
				value = option.properties.value;
				break;
			} 
		}
		return value;
	},
	
	_getStringValueOfTextBox: function(prop) {
		var targetEditBoxDijit = dijit.byId('MultiFieldSmartInput_SmartInput_'+prop);
		var value = targetEditBoxDijit.getValue();
		if (value && (value instanceof Date)) { // Date
			if (targetEditBoxDijit instanceof DateTextBox ) {
					value = value.toISOString().substring(0, 10);
			} else if (targetEditBoxDijit instanceof TimeTextBox ) {
					value = "T" + value.toTimeString().substring(0, 8);
			}
		} 
		return value;
	},
	
	updateSimStyle: function(){},
	

});


return MultiFieldSmartInput;

});
},
'dijit/tree/TreeStoreModel':function(){
define([
	"dojo/_base/array", // array.filter array.forEach array.indexOf array.some
	"dojo/aspect", // aspect.after
	"dojo/_base/declare", // declare
	"dojo/_base/lang" // lang.hitch
], function(array, aspect, declare, lang){

	// module:
	//		dijit/tree/TreeStoreModel

	return declare("dijit.tree.TreeStoreModel", null, {
		// summary:
		//		Implements dijit/Tree/model connecting to a dojo.data store with a single
		//		root item.  Any methods passed into the constructor will override
		//		the ones defined here.

		// store: dojo/data/api/Read
		//		Underlying store
		store: null,

		// childrenAttrs: String[]
		//		One or more attribute names (attributes in the dojo.data item) that specify that item's children
		childrenAttrs: ["children"],

		// newItemIdAttr: String
		//		Name of attribute in the Object passed to newItem() that specifies the id.
		//
		//		If newItemIdAttr is set then it's used when newItem() is called to see if an
		//		item with the same id already exists, and if so just links to the old item
		//		(so that the old item ends up with two parents).
		//
		//		Setting this to null or "" will make every drop create a new item.
		newItemIdAttr: "id",

		// labelAttr: String
		//		If specified, get label for tree node from this attribute, rather
		//		than by calling store.getLabel()
		labelAttr: "",

		// root: [readonly] dojo/data/Item
		//		Pointer to the root item (read only, not a parameter)
		root: null,

		// query: anything
		//		Specifies datastore query to return the root item for the tree.
		//		Must only return a single item.   Alternately can just pass in pointer
		//		to root item.
		// example:
		//	|	{id:'ROOT'}
		query: null,

		// deferItemLoadingUntilExpand: Boolean
		//		Setting this to true will cause the TreeStoreModel to defer calling loadItem on nodes
		//		until they are expanded. This allows for lazying loading where only one
		//		loadItem (and generally one network call, consequently) per expansion
		//		(rather than one for each child).
		//		This relies on partial loading of the children items; each children item of a
		//		fully loaded item should contain the label and info about having children.
		deferItemLoadingUntilExpand: false,

		constructor: function(/* Object */ args){
			// summary:
			//		Passed the arguments listed above (store, etc)
			// tags:
			//		private

			lang.mixin(this, args);

			this.connects = [];

			var store = this.store;
			if(!store.getFeatures()['dojo.data.api.Identity']){
				throw new Error("dijit.tree.TreeStoreModel: store must support dojo.data.Identity");
			}

			// if the store supports Notification, subscribe to the notification events
			if(store.getFeatures()['dojo.data.api.Notification']){
				this.connects = this.connects.concat([
					aspect.after(store, "onNew", lang.hitch(this, "onNewItem"), true),
					aspect.after(store, "onDelete", lang.hitch(this, "onDeleteItem"), true),
					aspect.after(store, "onSet", lang.hitch(this, "onSetItem"), true)
				]);
			}
		},

		destroy: function(){
			var h;
			while(h = this.connects.pop()){ h.remove(); }
			// TODO: should cancel any in-progress processing of getRoot(), getChildren()
		},

		// =======================================================================
		// Methods for traversing hierarchy

		getRoot: function(onItem, onError){
			// summary:
			//		Calls onItem with the root item for the tree, possibly a fabricated item.
			//		Calls onError on error.
			if(this.root){
				onItem(this.root);
			}else{
				this.store.fetch({
					query: this.query,
					onComplete: lang.hitch(this, function(items){
						if(items.length != 1){
							throw new Error("dijit.tree.TreeStoreModel: root query returned " + items.length +
								" items, but must return exactly one");
						}
						this.root = items[0];
						onItem(this.root);
					}),
					onError: onError
				});
			}
		},

		mayHaveChildren: function(/*dojo/data/Item*/ item){
			// summary:
			//		Tells if an item has or may have children.  Implementing logic here
			//		avoids showing +/- expando icon for nodes that we know don't have children.
			//		(For efficiency reasons we may not want to check if an element actually
			//		has children until user clicks the expando node)
			return array.some(this.childrenAttrs, function(attr){
				return this.store.hasAttribute(item, attr);
			}, this);
		},

		getChildren: function(/*dojo/data/Item*/ parentItem, /*function(items)*/ onComplete, /*function*/ onError){
			// summary:
			//		Calls onComplete() with array of child items of given parent item, all loaded.

			var store = this.store;
			if(!store.isItemLoaded(parentItem)){
				// The parent is not loaded yet, we must be in deferItemLoadingUntilExpand
				// mode, so we will load it and just return the children (without loading each
				// child item)
				var getChildren = lang.hitch(this, arguments.callee);
				store.loadItem({
					item: parentItem,
					onItem: function(parentItem){
						getChildren(parentItem, onComplete, onError);
					},
					onError: onError
				});
				return;
			}
			// get children of specified item
			var childItems = [];
			for(var i=0; i<this.childrenAttrs.length; i++){
				var vals = store.getValues(parentItem, this.childrenAttrs[i]);
				childItems = childItems.concat(vals);
			}

			// count how many items need to be loaded
			var _waitCount = 0;
			if(!this.deferItemLoadingUntilExpand){
				array.forEach(childItems, function(item){ if(!store.isItemLoaded(item)){ _waitCount++; } });
			}

			if(_waitCount == 0){
				// all items are already loaded (or we aren't loading them).  proceed...
				onComplete(childItems);
			}else{
				// still waiting for some or all of the items to load
				array.forEach(childItems, function(item, idx){
					if(!store.isItemLoaded(item)){
						store.loadItem({
							item: item,
							onItem: function(item){
								childItems[idx] = item;
								if(--_waitCount == 0){
									// all nodes have been loaded, send them to the tree
									onComplete(childItems);
								}
							},
							onError: onError
						});
					}
				});
			}
		},

		// =======================================================================
		// Inspecting items

		isItem: function(/* anything */ something){
			return this.store.isItem(something);	// Boolean
		},

		fetchItemByIdentity: function(/* object */ keywordArgs){
			this.store.fetchItemByIdentity(keywordArgs);
		},

		getIdentity: function(/* item */ item){
			return this.store.getIdentity(item);	// Object
		},

		getLabel: function(/*dojo/data/Item*/ item){
			// summary:
			//		Get the label for an item
			if(this.labelAttr){
				return this.store.getValue(item,this.labelAttr);	// String
			}else{
				return this.store.getLabel(item);	// String
			}
		},

		// =======================================================================
		// Write interface

		newItem: function(/* dijit/tree/dndSource.__Item */ args, /*dojo/data/api/Item*/ parent, /*int?*/ insertIndex){
			// summary:
			//		Creates a new item.   See `dojo/data/api/Write` for details on args.
			//		Used in drag & drop when item from external source dropped onto tree.
			// description:
			//		Developers will need to override this method if new items get added
			//		to parents with multiple children attributes, in order to define which
			//		children attribute points to the new item.

			var pInfo = {parent: parent, attribute: this.childrenAttrs[0]}, LnewItem;

			if(this.newItemIdAttr && args[this.newItemIdAttr]){
				// Maybe there's already a corresponding item in the store; if so, reuse it.
				this.fetchItemByIdentity({identity: args[this.newItemIdAttr], scope: this, onItem: function(item){
					if(item){
						// There's already a matching item in store, use it
						this.pasteItem(item, null, parent, true, insertIndex);
					}else{
						// Create new item in the tree, based on the drag source.
						LnewItem=this.store.newItem(args, pInfo);
						if(LnewItem && (insertIndex!=undefined)){
							// Move new item to desired position
							this.pasteItem(LnewItem, parent, parent, false, insertIndex);
						}
					}
				}});
			}else{
				// [as far as we know] there is no id so we must assume this is a new item
				LnewItem=this.store.newItem(args, pInfo);
				if(LnewItem && (insertIndex!=undefined)){
					// Move new item to desired position
					this.pasteItem(LnewItem, parent, parent, false, insertIndex);
				}
			}
		},

		pasteItem: function(/*Item*/ childItem, /*Item*/ oldParentItem, /*Item*/ newParentItem, /*Boolean*/ bCopy, /*int?*/ insertIndex){
			// summary:
			//		Move or copy an item from one parent item to another.
			//		Used in drag & drop
			var store = this.store,
				parentAttr = this.childrenAttrs[0];	// name of "children" attr in parent item

			// remove child from source item, and record the attribute that child occurred in
			if(oldParentItem){
				array.forEach(this.childrenAttrs, function(attr){
					if(store.containsValue(oldParentItem, attr, childItem)){
						if(!bCopy){
							var values = array.filter(store.getValues(oldParentItem, attr), function(x){
								return x != childItem;
							});
							store.setValues(oldParentItem, attr, values);
						}
						parentAttr = attr;
					}
				});
			}

			// modify target item's children attribute to include this item
			if(newParentItem){
				if(typeof insertIndex == "number"){
					// call slice() to avoid modifying the original array, confusing the data store
					var childItems = store.getValues(newParentItem, parentAttr).slice();
					childItems.splice(insertIndex, 0, childItem);
					store.setValues(newParentItem, parentAttr, childItems);
				}else{
					store.setValues(newParentItem, parentAttr,
						store.getValues(newParentItem, parentAttr).concat(childItem));
				}
			}
		},

		// =======================================================================
		// Callbacks

		onChange: function(/*dojo/data/Item*/ /*===== item =====*/){
			// summary:
			//		Callback whenever an item has changed, so that Tree
			//		can update the label, icon, etc.   Note that changes
			//		to an item's children or parent(s) will trigger an
			//		onChildrenChange() so you can ignore those changes here.
			// tags:
			//		callback
		},

		onChildrenChange: function(/*===== parent, newChildrenList =====*/){
			// summary:
			//		Callback to do notifications about new, updated, or deleted items.
			// parent: dojo/data/Item
			// newChildrenList: dojo/data/Item[]
			// tags:
			//		callback
		},

		onDelete: function(/*dojo/data/Item*/ /*===== item =====*/){
			// summary:
			//		Callback when an item has been deleted.
			// description:
			//		Note that there will also be an onChildrenChange() callback for the parent
			//		of this item.
			// tags:
			//		callback
		},

		// =======================================================================
		// Events from data store

		onNewItem: function(/* dojo/data/Item */ item, /* Object */ parentInfo){
			// summary:
			//		Handler for when new items appear in the store, either from a drop operation
			//		or some other way.   Updates the tree view (if necessary).
			// description:
			//		If the new item is a child of an existing item,
			//		calls onChildrenChange() with the new list of children
			//		for that existing item.
			//
			// tags:
			//		extension

			// We only care about the new item if it has a parent that corresponds to a TreeNode
			// we are currently displaying
			if(!parentInfo){
				return;
			}

			// Call onChildrenChange() on parent (ie, existing) item with new list of children
			// In the common case, the new list of children is simply parentInfo.newValue or
			// [ parentInfo.newValue ], although if items in the store has multiple
			// child attributes (see `childrenAttr`), then it's a superset of parentInfo.newValue,
			// so call getChildren() to be sure to get right answer.
			this.getChildren(parentInfo.item, lang.hitch(this, function(children){
				this.onChildrenChange(parentInfo.item, children);
			}));
		},

		onDeleteItem: function(/*Object*/ item){
			// summary:
			//		Handler for delete notifications from underlying store
			this.onDelete(item);
		},

		onSetItem: function(item, attribute /*===== , oldValue, newValue =====*/){
			// summary:
			//		Updates the tree view according to changes in the data store.
			// description:
			//		Handles updates to an item's children by calling onChildrenChange(), and
			//		other updates to an item by calling onChange().
			//
			//		See `onNewItem` for more details on handling updates to an item's children.
			// item: Item
			// attribute: attribute-name-string
			// oldValue: Object|Array
			// newValue: Object|Array
			// tags:
			//		extension

			if(array.indexOf(this.childrenAttrs, attribute) != -1){
				// item's children list changed
				this.getChildren(item, lang.hitch(this, function(children){
					// See comments in onNewItem() about calling getChildren()
					this.onChildrenChange(item, children);
				}));
			}else{
				// item's label/icon/etc. changed.
				this.onChange(item);
			}
		}
	});
});

},
'dijit/_HasDropDown':function(){
define([
	"dojo/_base/declare", // declare
	"dojo/_base/Deferred",
	"dojo/_base/event", // event.stop
	"dojo/dom", // dom.isDescendant
	"dojo/dom-attr", // domAttr.set
	"dojo/dom-class", // domClass.add domClass.contains domClass.remove
	"dojo/dom-geometry", // domGeometry.marginBox domGeometry.position
	"dojo/dom-style", // domStyle.set
	"dojo/has",	// has("touch")
	"dojo/keys", // keys.DOWN_ARROW keys.ENTER keys.ESCAPE
	"dojo/_base/lang", // lang.hitch lang.isFunction
	"dojo/on",
	"dojo/window", // winUtils.getBox
	"./registry",	// registry.byNode()
	"./focus",
	"./popup",
	"./_FocusMixin"
], function(declare, Deferred, event,dom, domAttr, domClass, domGeometry, domStyle, has, keys, lang, on,
			winUtils, registry, focus, popup, _FocusMixin){


	// module:
	//		dijit/_HasDropDown

	return declare("dijit._HasDropDown", _FocusMixin, {
		// summary:
		//		Mixin for widgets that need drop down ability.

		// _buttonNode: [protected] DomNode
		//		The button/icon/node to click to display the drop down.
		//		Can be set via a data-dojo-attach-point assignment.
		//		If missing, then either focusNode or domNode (if focusNode is also missing) will be used.
		_buttonNode: null,

		// _arrowWrapperNode: [protected] DomNode
		//		Will set CSS class dijitUpArrow, dijitDownArrow, dijitRightArrow etc. on this node depending
		//		on where the drop down is set to be positioned.
		//		Can be set via a data-dojo-attach-point assignment.
		//		If missing, then _buttonNode will be used.
		_arrowWrapperNode: null,

		// _popupStateNode: [protected] DomNode
		//		The node to set the popupActive class on.
		//		Can be set via a data-dojo-attach-point assignment.
		//		If missing, then focusNode or _buttonNode (if focusNode is missing) will be used.
		_popupStateNode: null,

		// _aroundNode: [protected] DomNode
		//		The node to display the popup around.
		//		Can be set via a data-dojo-attach-point assignment.
		//		If missing, then domNode will be used.
		_aroundNode: null,

		// dropDown: [protected] Widget
		//		The widget to display as a popup.  This widget *must* be
		//		defined before the startup function is called.
		dropDown: null,

		// autoWidth: [protected] Boolean
		//		Set to true to make the drop down at least as wide as this
		//		widget.  Set to false if the drop down should just be its
		//		default width
		autoWidth: true,

		// forceWidth: [protected] Boolean
		//		Set to true to make the drop down exactly as wide as this
		//		widget.  Overrides autoWidth.
		forceWidth: false,

		// maxHeight: [protected] Integer
		//		The max height for our dropdown.
		//		Any dropdown taller than this will have scrollbars.
		//		Set to 0 for no max height, or -1 to limit height to available space in viewport
		maxHeight: 0,

		// dropDownPosition: [const] String[]
		//		This variable controls the position of the drop down.
		//		It's an array of strings with the following values:
		//
		//		- before: places drop down to the left of the target node/widget, or to the right in
		//		  the case of RTL scripts like Hebrew and Arabic
		//		- after: places drop down to the right of the target node/widget, or to the left in
		//		  the case of RTL scripts like Hebrew and Arabic
		//		- above: drop down goes above target node
		//		- below: drop down goes below target node
		//
		//		The list is positions is tried, in order, until a position is found where the drop down fits
		//		within the viewport.
		//
		dropDownPosition: ["below","above"],

		// _stopClickEvents: Boolean
		//		When set to false, the click events will not be stopped, in
		//		case you want to use them in your subclass
		_stopClickEvents: true,

		_onDropDownMouseDown: function(/*Event*/ e){
			// summary:
			//		Callback when the user mousedown's on the arrow icon
			if(this.disabled || this.readOnly){ return; }

			// Prevent default to stop things like text selection, but don't stop propagation, so that:
			//		1. TimeTextBox etc. can focus the <input> on mousedown
			//		2. dropDownButtonActive class applied by _CssStateMixin (on button depress)
			//		3. user defined onMouseDown handler fires
			e.preventDefault();

			this._docHandler = this.connect(this.ownerDocument, "mouseup", "_onDropDownMouseUp");

			this.toggleDropDown();
		},

		_onDropDownMouseUp: function(/*Event?*/ e){
			// summary:
			//		Callback when the user lifts their mouse after mouse down on the arrow icon.
			//		If the drop down is a simple menu and the mouse is over the menu, we execute it, otherwise, we focus our
			//		drop down widget.  If the event is missing, then we are not
			//		a mouseup event.
			//
			//		This is useful for the common mouse movement pattern
			//		with native browser `<select>` nodes:
			//
			//		1. mouse down on the select node (probably on the arrow)
			//		2. move mouse to a menu item while holding down the mouse button
			//		3. mouse up.  this selects the menu item as though the user had clicked it.
			if(e && this._docHandler){
				this.disconnect(this._docHandler);
			}
			var dropDown = this.dropDown, overMenu = false;

			if(e && this._opened){
				// This code deals with the corner-case when the drop down covers the original widget,
				// because it's so large.  In that case mouse-up shouldn't select a value from the menu.
				// Find out if our target is somewhere in our dropdown widget,
				// but not over our _buttonNode (the clickable node)
				var c = domGeometry.position(this._buttonNode, true);
				if(!(e.pageX >= c.x && e.pageX <= c.x + c.w) ||
					!(e.pageY >= c.y && e.pageY <= c.y + c.h)){
					var t = e.target;
					while(t && !overMenu){
						if(domClass.contains(t, "dijitPopup")){
							overMenu = true;
						}else{
							t = t.parentNode;
						}
					}
					if(overMenu){
						t = e.target;
						if(dropDown.onItemClick){
							var menuItem;
							while(t && !(menuItem = registry.byNode(t))){
								t = t.parentNode;
							}
							if(menuItem && menuItem.onClick && menuItem.getParent){
								menuItem.getParent().onItemClick(menuItem, e);
							}
						}
						return;
					}
				}
			}
			if(this._opened){
				if(dropDown.focus && dropDown.autoFocus !== false){
					// Focus the dropdown widget - do it on a delay so that we
					// don't steal back focus from the dropdown.
					this._focusDropDownTimer = this.defer(function(){
						dropDown.focus();
						delete this._focusDropDownTimer;
					});
				}
			}else{
				// The drop down arrow icon probably can't receive focus, but widget itself should get focus.
				// defer() needed to make it work on IE (test DateTextBox)
				this.defer("focus");
			}

			if(has("touch")){
				this._justGotMouseUp = true;
				this.defer(function(){
					this._justGotMouseUp = false;
				});
			}
		},

		_onDropDownClick: function(/*Event*/ e){
			if(has("touch") && !this._justGotMouseUp){
				// If there was no preceding mousedown/mouseup (like on android), then simulate them to
				// toggle the drop down.
				//
				// The if(has("touch") is necessary since IE and desktop safari get spurious onclick events
				// when there are nested tables (specifically, clicking on a table that holds a dijit/form/Select,
				// but not on the Select itself, causes an onclick event on the Select)
				this._onDropDownMouseDown(e);
				this._onDropDownMouseUp(e);
			}

			// The drop down was already opened on mousedown/keydown; just need to call stopEvent().
			if(this._stopClickEvents){
				event.stop(e);
			}
		},

		buildRendering: function(){
			this.inherited(arguments);

			this._buttonNode = this._buttonNode || this.focusNode || this.domNode;
			this._popupStateNode = this._popupStateNode || this.focusNode || this._buttonNode;

			// Add a class to the "dijitDownArrowButton" type class to _buttonNode so theme can set direction of arrow
			// based on where drop down will normally appear
			var defaultPos = {
					"after" : this.isLeftToRight() ? "Right" : "Left",
					"before" : this.isLeftToRight() ? "Left" : "Right",
					"above" : "Up",
					"below" : "Down",
					"left" : "Left",
					"right" : "Right"
			}[this.dropDownPosition[0]] || this.dropDownPosition[0] || "Down";
			domClass.add(this._arrowWrapperNode || this._buttonNode, "dijit" + defaultPos + "ArrowButton");
		},

		postCreate: function(){
			// summary:
			//		set up nodes and connect our mouse and keyboard events

			this.inherited(arguments);

			var keyboardEventNode = this.focusNode || this.domNode;
			this.own(
				on(this._buttonNode, "mousedown", lang.hitch(this, "_onDropDownMouseDown")),
				on(this._buttonNode, "click", lang.hitch(this, "_onDropDownClick")),
				on(keyboardEventNode, "keydown", lang.hitch(this, "_onKey")),
				on(keyboardEventNode, "keyup", lang.hitch(this, "_onKeyUp"))
			);
		},

		destroy: function(){
			if(this.dropDown){
				// Destroy the drop down, unless it's already been destroyed.  This can happen because
				// the drop down is a direct child of <body> even though it's logically my child.
				if(!this.dropDown._destroyed){
					this.dropDown.destroyRecursive();
				}
				delete this.dropDown;
			}
			this.inherited(arguments);
		},

		_onKey: function(/*Event*/ e){
			// summary:
			//		Callback when the user presses a key while focused on the button node

			if(this.disabled || this.readOnly){ return; }
			var d = this.dropDown, target = e.target;
			if(d && this._opened && d.handleKey){
				if(d.handleKey(e) === false){
					/* false return code means that the drop down handled the key */
					event.stop(e);
					return;
				}
			}
			if(d && this._opened && e.keyCode == keys.ESCAPE){
				this.closeDropDown();
				event.stop(e);
			}else if(!this._opened &&
					(e.keyCode == keys.DOWN_ARROW ||
						( (e.keyCode == keys.ENTER || e.keyCode == keys.SPACE) &&
						  //ignore enter and space if the event is for a text input
						  ((target.tagName || "").toLowerCase() !== 'input' ||
						     (target.type && target.type.toLowerCase() !== 'text'))))){
				// Toggle the drop down, but wait until keyup so that the drop down doesn't
				// get a stray keyup event, or in the case of key-repeat (because user held
				// down key for too long), stray keydown events
				this._toggleOnKeyUp = true;
				event.stop(e);
			}
		},

		_onKeyUp: function(){
			if(this._toggleOnKeyUp){
				delete this._toggleOnKeyUp;
				this.toggleDropDown();
				var d = this.dropDown;	// drop down may not exist until toggleDropDown() call
				if(d && d.focus){
					this.defer(lang.hitch(d, "focus"), 1);
				}
			}
		},

		_onBlur: function(){
			// summary:
			//		Called magically when focus has shifted away from this widget and it's dropdown

			// Don't focus on button if the user has explicitly focused on something else (happens
			// when user clicks another control causing the current popup to close)..
			// But if focus is inside of the drop down then reset focus to me, because IE doesn't like
			// it when you display:none a node with focus.
			var focusMe = focus.curNode && this.dropDown && dom.isDescendant(focus.curNode, this.dropDown.domNode);

			this.closeDropDown(focusMe);

			this.inherited(arguments);
		},

		isLoaded: function(){
			// summary:
			//		Returns true if the dropdown exists and it's data is loaded.  This can
			//		be overridden in order to force a call to loadDropDown().
			// tags:
			//		protected

			return true;
		},

		loadDropDown: function(/*Function*/ loadCallback){
			// summary:
			//		Creates the drop down if it doesn't exist, loads the data
			//		if there's an href and it hasn't been loaded yet, and then calls
			//		the given callback.
			// tags:
			//		protected

			// TODO: for 2.0, change API to return a Deferred, instead of calling loadCallback?
			loadCallback();
		},

		loadAndOpenDropDown: function(){
			// summary:
			//		Creates the drop down if it doesn't exist, loads the data
			//		if there's an href and it hasn't been loaded yet, and
			//		then opens the drop down.  This is basically a callback when the
			//		user presses the down arrow button to open the drop down.
			// returns: Deferred
			//		Deferred for the drop down widget that
			//		fires when drop down is created and loaded
			// tags:
			//		protected
			var d = new Deferred(),
				afterLoad = lang.hitch(this, function(){
					this.openDropDown();
					d.resolve(this.dropDown);
				});
			if(!this.isLoaded()){
				this.loadDropDown(afterLoad);
			}else{
				afterLoad();
			}
			return d;
		},

		toggleDropDown: function(){
			// summary:
			//		Callback when the user presses the down arrow button or presses
			//		the down arrow key to open/close the drop down.
			//		Toggle the drop-down widget; if it is up, close it, if not, open it
			// tags:
			//		protected

			if(this.disabled || this.readOnly){ return; }
			if(!this._opened){
				this.loadAndOpenDropDown();
			}else{
				this.closeDropDown();
			}
		},

		openDropDown: function(){
			// summary:
			//		Opens the dropdown for this widget.   To be called only when this.dropDown
			//		has been created and is ready to display (ie, it's data is loaded).
			// returns:
			//		return value of dijit/popup.open()
			// tags:
			//		protected

			var dropDown = this.dropDown,
				ddNode = dropDown.domNode,
				aroundNode = this._aroundNode || this.domNode,
				self = this;

			// Prepare our popup's height and honor maxHeight if it exists.

			// TODO: isn't maxHeight dependent on the return value from dijit/popup.open(),
			// ie, dependent on how much space is available (BK)

			if(!this._preparedNode){
				this._preparedNode = true;
				// Check if we have explicitly set width and height on the dropdown widget dom node
				if(ddNode.style.width){
					this._explicitDDWidth = true;
				}
				if(ddNode.style.height){
					this._explicitDDHeight = true;
				}
			}

			// Code for resizing dropdown (height limitation, or increasing width to match my width)
			if(this.maxHeight || this.forceWidth || this.autoWidth){
				var myStyle = {
					display: "",
					visibility: "hidden"
				};
				if(!this._explicitDDWidth){
					myStyle.width = "";
				}
				if(!this._explicitDDHeight){
					myStyle.height = "";
				}
				domStyle.set(ddNode, myStyle);

				// Figure out maximum height allowed (if there is a height restriction)
				var maxHeight = this.maxHeight;
				if(maxHeight == -1){
					// limit height to space available in viewport either above or below my domNode
					// (whichever side has more room)
					var viewport = winUtils.getBox(this.ownerDocument),
						position = domGeometry.position(aroundNode, false);
					maxHeight = Math.floor(Math.max(position.y, viewport.h - (position.y + position.h)));
				}

				// Attach dropDown to DOM and make make visibility:hidden rather than display:none
				// so we call startup() and also get the size
				popup.moveOffScreen(dropDown);

				if(dropDown.startup && !dropDown._started){
					dropDown.startup(); // this has to be done after being added to the DOM
				}
				// Get size of drop down, and determine if vertical scroll bar needed.  If no scroll bar needed,
				// use overflow:visible rather than overflow:hidden so off-by-one errors don't hide drop down border.
				var mb = domGeometry.getMarginSize(ddNode);
				var overHeight = (maxHeight && mb.h > maxHeight);
				domStyle.set(ddNode, {
					overflowX: "visible",
					overflowY: overHeight ? "auto" : "visible"
				});
				if(overHeight){
					mb.h = maxHeight;
					if("w" in mb){
						mb.w += 16;	// room for vertical scrollbar
					}
				}else{
					delete mb.h;
				}

				// Adjust dropdown width to match or be larger than my width
				if(this.forceWidth){
					mb.w = aroundNode.offsetWidth;
				}else if(this.autoWidth){
					mb.w = Math.max(mb.w, aroundNode.offsetWidth);
				}else{
					delete mb.w;
				}

				// And finally, resize the dropdown to calculated height and width
				if(lang.isFunction(dropDown.resize)){
					dropDown.resize(mb);
				}else{
					domGeometry.setMarginBox(ddNode, mb);
				}
			}

			var retVal = popup.open({
				parent: this,
				popup: dropDown,
				around: aroundNode,
				orient: this.dropDownPosition,
				onExecute: function(){
					self.closeDropDown(true);
				},
				onCancel: function(){
					self.closeDropDown(true);
				},
				onClose: function(){
					domAttr.set(self._popupStateNode, "popupActive", false);
					domClass.remove(self._popupStateNode, "dijitHasDropDownOpen");
					self._set("_opened", false);	// use set() because _CssStateMixin is watching
				}
			});
			domAttr.set(this._popupStateNode, "popupActive", "true");
			domClass.add(this._popupStateNode, "dijitHasDropDownOpen");
			this._set("_opened", true);	// use set() because _CssStateMixin is watching
			this.domNode.setAttribute("aria-expanded", "true");
			
			return retVal;
		},

		closeDropDown: function(/*Boolean*/ focus){
			// summary:
			//		Closes the drop down on this widget
			// focus:
			//		If true, refocuses the button widget
			// tags:
			//		protected

			if(this._focusDropDownTimer){
				this._focusDropDownTimer.remove();
				delete this._focusDropDownTimer;
			}
			if(this._opened){
				this.domNode.setAttribute("aria-expanded", "false");
				if(focus){ this.focus(); }
				popup.close(this.dropDown);
				this._opened = false;
			}
		}

	});
});

},
'dojo/dnd/Selector':function(){
define([
	"../_base/array", "../_base/declare", "../_base/event", "../_base/kernel", "../_base/lang",
	"../dom", "../dom-construct", "../mouse", "../_base/NodeList", "../on", "../touch", "./common", "./Container"
], function(array, declare, event, kernel, lang, dom, domConstruct, mouse, NodeList, on, touch, dnd, Container){

// module:
//		dojo/dnd/Selector

/*
	Container item states:
		""			- an item is not selected
		"Selected"	- an item is selected
		"Anchor"	- an item is selected, and is an anchor for a "shift" selection
*/

/*=====
var __SelectorArgs = declare([Container.__ContainerArgs], {
	// singular: Boolean
	//		allows selection of only one element, if true
	singular: false,

	// autoSync: Boolean
	//		autosynchronizes the source with its list of DnD nodes,
	autoSync: false
});
=====*/

var Selector = declare("dojo.dnd.Selector", Container, {
	// summary:
	//		a Selector object, which knows how to select its children

	/*=====
	// selection: Set<String>
	//		The set of id's that are currently selected, such that this.selection[id] == 1
	//		if the node w/that id is selected.  Can iterate over selected node's id's like:
	//	|		for(var id in this.selection)
	selection: {},
	=====*/

	constructor: function(node, params){
		// summary:
		//		constructor of the Selector
		// node: Node||String
		//		node or node's id to build the selector on
		// params: __SelectorArgs?
		//		a dictionary of parameters
		if(!params){ params = {}; }
		this.singular = params.singular;
		this.autoSync = params.autoSync;
		// class-specific variables
		this.selection = {};
		this.anchor = null;
		this.simpleSelection = false;
		// set up events
		this.events.push(
			on(this.node, touch.press, lang.hitch(this, "onMouseDown")),
			on(this.node, touch.release, lang.hitch(this, "onMouseUp"))
		);
	},

	// object attributes (for markup)
	singular: false,	// is singular property

	// methods
	getSelectedNodes: function(){
		// summary:
		//		returns a list (an array) of selected nodes
		var t = new NodeList();
		var e = dnd._empty;
		for(var i in this.selection){
			if(i in e){ continue; }
			t.push(dom.byId(i));
		}
		return t;	// NodeList
	},
	selectNone: function(){
		// summary:
		//		unselects all items
		return this._removeSelection()._removeAnchor();	// self
	},
	selectAll: function(){
		// summary:
		//		selects all items
		this.forInItems(function(data, id){
			this._addItemClass(dom.byId(id), "Selected");
			this.selection[id] = 1;
		}, this);
		return this._removeAnchor();	// self
	},
	deleteSelectedNodes: function(){
		// summary:
		//		deletes all selected items
		var e = dnd._empty;
		for(var i in this.selection){
			if(i in e){ continue; }
			var n = dom.byId(i);
			this.delItem(i);
			domConstruct.destroy(n);
		}
		this.anchor = null;
		this.selection = {};
		return this;	// self
	},
	forInSelectedItems: function(/*Function*/ f, /*Object?*/ o){
		// summary:
		//		iterates over selected items;
		//		see `dojo/dnd/Container.forInItems()` for details
		o = o || kernel.global;
		var s = this.selection, e = dnd._empty;
		for(var i in s){
			if(i in e){ continue; }
			f.call(o, this.getItem(i), i, this);
		}
	},
	sync: function(){
		// summary:
		//		sync up the node list with the data map

		Selector.superclass.sync.call(this);

		// fix the anchor
		if(this.anchor){
			if(!this.getItem(this.anchor.id)){
				this.anchor = null;
			}
		}

		// fix the selection
		var t = [], e = dnd._empty;
		for(var i in this.selection){
			if(i in e){ continue; }
			if(!this.getItem(i)){
				t.push(i);
			}
		}
		array.forEach(t, function(i){
			delete this.selection[i];
		}, this);

		return this;	// self
	},
	insertNodes: function(addSelected, data, before, anchor){
		// summary:
		//		inserts new data items (see `dojo/dnd/Container.insertNodes()` method for details)
		// addSelected: Boolean
		//		all new nodes will be added to selected items, if true, no selection change otherwise
		// data: Array
		//		a list of data items, which should be processed by the creator function
		// before: Boolean
		//		insert before the anchor, if true, and after the anchor otherwise
		// anchor: Node
		//		the anchor node to be used as a point of insertion
		var oldCreator = this._normalizedCreator;
		this._normalizedCreator = function(item, hint){
			var t = oldCreator.call(this, item, hint);
			if(addSelected){
				if(!this.anchor){
					this.anchor = t.node;
					this._removeItemClass(t.node, "Selected");
					this._addItemClass(this.anchor, "Anchor");
				}else if(this.anchor != t.node){
					this._removeItemClass(t.node, "Anchor");
					this._addItemClass(t.node, "Selected");
				}
				this.selection[t.node.id] = 1;
			}else{
				this._removeItemClass(t.node, "Selected");
				this._removeItemClass(t.node, "Anchor");
			}
			return t;
		};
		Selector.superclass.insertNodes.call(this, data, before, anchor);
		this._normalizedCreator = oldCreator;
		return this;	// self
	},
	destroy: function(){
		// summary:
		//		prepares the object to be garbage-collected
		Selector.superclass.destroy.call(this);
		this.selection = this.anchor = null;
	},

	// mouse events
	onMouseDown: function(e){
		// summary:
		//		event processor for onmousedown
		// e: Event
		//		mouse event
		if(this.autoSync){ this.sync(); }
		if(!this.current){ return; }
		if(!this.singular && !dnd.getCopyKeyState(e) && !e.shiftKey && (this.current.id in this.selection)){
			this.simpleSelection = true;
			if(mouse.isLeft(e)){
				// Accept the left button and stop the event.   Stopping the event prevents text selection while
				// dragging.   However, don't stop the event on mobile because that prevents a click event,
				// and also prevents scroll (see #15838).
				// For IE we don't stop event when multiple buttons are pressed.
				event.stop(e);
			}
			return;
		}
		if(!this.singular && e.shiftKey){
			if(!dnd.getCopyKeyState(e)){
				this._removeSelection();
			}
			var c = this.getAllNodes();
			if(c.length){
				if(!this.anchor){
					this.anchor = c[0];
					this._addItemClass(this.anchor, "Anchor");
				}
				this.selection[this.anchor.id] = 1;
				if(this.anchor != this.current){
					var i = 0, node;
					for(; i < c.length; ++i){
						node = c[i];
						if(node == this.anchor || node == this.current){ break; }
					}
					for(++i; i < c.length; ++i){
						node = c[i];
						if(node == this.anchor || node == this.current){ break; }
						this._addItemClass(node, "Selected");
						this.selection[node.id] = 1;
					}
					this._addItemClass(this.current, "Selected");
					this.selection[this.current.id] = 1;
				}
			}
		}else{
			if(this.singular){
				if(this.anchor == this.current){
					if(dnd.getCopyKeyState(e)){
						this.selectNone();
					}
				}else{
					this.selectNone();
					this.anchor = this.current;
					this._addItemClass(this.anchor, "Anchor");
					this.selection[this.current.id] = 1;
				}
			}else{
				if(dnd.getCopyKeyState(e)){
					if(this.anchor == this.current){
						delete this.selection[this.anchor.id];
						this._removeAnchor();
					}else{
						if(this.current.id in this.selection){
							this._removeItemClass(this.current, "Selected");
							delete this.selection[this.current.id];
						}else{
							if(this.anchor){
								this._removeItemClass(this.anchor, "Anchor");
								this._addItemClass(this.anchor, "Selected");
							}
							this.anchor = this.current;
							this._addItemClass(this.current, "Anchor");
							this.selection[this.current.id] = 1;
						}
					}
				}else{
					if(!(this.current.id in this.selection)){
						this.selectNone();
						this.anchor = this.current;
						this._addItemClass(this.current, "Anchor");
						this.selection[this.current.id] = 1;
					}
				}
			}
		}
		event.stop(e);
	},
	onMouseUp: function(/*===== e =====*/){
		// summary:
		//		event processor for onmouseup
		// e: Event
		//		mouse event
		if(!this.simpleSelection){ return; }
		this.simpleSelection = false;
		this.selectNone();
		if(this.current){
			this.anchor = this.current;
			this._addItemClass(this.anchor, "Anchor");
			this.selection[this.current.id] = 1;
		}
	},
	onMouseMove: function(/*===== e =====*/){
		// summary:
		//		event processor for onmousemove
		// e: Event
		//		mouse event
		this.simpleSelection = false;
	},

	// utilities
	onOverEvent: function(){
		// summary:
		//		this function is called once, when mouse is over our container
		this.onmousemoveEvent = on(this.node, touch.move, lang.hitch(this, "onMouseMove"));
	},
	onOutEvent: function(){
		// summary:
		//		this function is called once, when mouse is out of our container
		if(this.onmousemoveEvent){
			this.onmousemoveEvent.remove();
			delete this.onmousemoveEvent;
		}
	},
	_removeSelection: function(){
		// summary:
		//		unselects all items
		var e = dnd._empty;
		for(var i in this.selection){
			if(i in e){ continue; }
			var node = dom.byId(i);
			if(node){ this._removeItemClass(node, "Selected"); }
		}
		this.selection = {};
		return this;	// self
	},
	_removeAnchor: function(){
		if(this.anchor){
			this._removeItemClass(this.anchor, "Anchor");
			this.anchor = null;
		}
		return this;	// self
	}
});

return Selector;

});

},
'davinci/workbench/_ToolbaredContainer':function(){
define([
    "dojo/_base/declare",
    "dijit/layout/_LayoutWidget",
    "dijit/_Templated"
], function(declare, LayoutWidget, Templated){

return declare("davinci.workbench._ToolbaredContainer", [LayoutWidget, Templated], {
	templateString: "<div><div dojoAttachPoint='titleBarDiv' class='palette_titleBarDiv'></div><div dojoAttachPoint='toolbarDiv' class='toolbaredContainer_toolbarDiv'></div><div dojoAttachPoint='containerNode'></div></div>",

	gutters: false,
	_toolbarCreated:{},

	layout: function() {
		// Configure the main pane to take up all the space except for where the toolbar is

		// position and size the toolbar and the container node
		var children = [
			{ domNode: this.titleBarDiv, layoutAlign: "top" },
			{ domNode: this.toolbarDiv, layoutAlign: "top" },
			{ domNode: this.containerNode, layoutAlign: "client" }
		];

		dijit.layout.layoutChildren(this.domNode, this._contentBox, children);
		// Compute size to make each of my children.
		// children[2] is the margin-box size of this.containerNode, set by layoutChildren() call above
		this._containerContentBox = dijit.layout.marginBox2contentBox(this.containerNode, children[2]);
		var widget = dijit.byNode(this.containerNode);
		if (widget && widget.resize) {
			widget.resize(this._containerContentBox);
		}
		dojo.marginBox(this.containerNode, children[2]);//KLUDGE: top doesn't get set without this.
	},

	setContent: function(/*Widget*/data){
		this.mainWidget = data;
		
		var domNode = data.domNode || data;
		
		dojo.place(domNode, this.containerNode, "replace");
		this.containerNode = domNode;

		//TODO: move this to part of the widget life cycle
		if (!this.toolbarCreated(this.declaredClass)) {
			this._createToolbar(this.declaredClass);
		}
		this.titleBarDiv.innerHTML = '<span class="paletteCloseBox"></span><span class="titleBarDivTitle">'+this.title+'</span>';
		var closeBoxNodes = dojo.query('.paletteCloseBox', this.titleBarDiv);
		if(closeBoxNodes.length > 0){
			var closeBox = closeBoxNodes[0];
			dojo.connect(closeBox, 'click', this, function(event){
				davinci.Workbench.collapsePaletteContainer(event.currentTarget);
			});
		}
		if(this._started) this.layout();
	},

	removeContent: function()
	{
		var newContainer=dojo.doc.createElement("div");
		dojo.place( newContainer, this.containerNode,"replace");
		this.containerNode=newContainer;
		if (this.mainWidget) {
			this.mainWidget.destroy();
		}
		delete this.mainWidget;
	},
	
	_getViewActions: function(){},

	getTopAdditions: function(){},

	/**
	 * Creates toolbar for this view or editor using data from appropriate *.plugin.js directives
	 * for this particular view or editor.
	 * Note that this routine can be overridden by a subclass (e.g., EditorContainer.js)
	 * @param {string} editorClass  Class name for editor, such as 'davinci.ve.PageEditor'
	 */
	_createToolbar: function(containerClass){
		var Workbench = require('davinci/Workbench');
		var toolbarDiv = this.getToolbarDiv();
		
		var topAddition=this.getTopAdditions();
		if (topAddition) {
			toolbarDiv.appendChild(topAddition);
		}
		
		// If descendant class provides a value for toolbarMenuActionSets,
		// then use that value to create a right-side dropdown menu
    	if(this.toolbarMenuActionSets){
    		// Note: menu routines in Dojo and Workbench require unique names
    		var unique="m" + Date.now();
    		var menuContainerId=unique+"_menucontainer";
        	var menuContainerElem = dojo.create("span", {'id':menuContainerId, 'class':"paletteDropdown"}, toolbarDiv);
    		var menuId=unique+"_menu";
        	var menuElem = dojo.create("span", {id:menuId}, menuContainerElem);
        	Workbench.updateMenubar(menuElem, this.toolbarMenuActionSets);
    	}
    	
		var viewActions=this._getViewActions();
        if (viewActions && viewActions.length)
        {
        	var tempDiv = dojo.create('div',{'class':'toolbaredContainer_toolbarDiv'});
    		var tb=dojo.create("span", {style: {display: "inline-block"}},tempDiv);
    		
        	var toolbar = Workbench._createToolBar('toolbarPath', tb, viewActions,this._getViewContext());
    		dojo.style(toolbar.domNode,{"display":"inline-block", "float":"left"});
            this.toolbarCreated(containerClass, toolbar);
        }
	},
	
	_getViewContext: function()
	{
		return this;
	},
	
	/**
	 * Returns an {Element} that is the container DIV into which editor toolbar should go
	 * This function can be overridden by subclasses (e.g., EditorContainer.js)
	 */
	getToolbarDiv: function(){
		return this.toolbarDiv;
	},
	
	/**
	 * Getter/setting for whether toolbar has been created.
	 * Note that this function can be overridden by a subclass (e.g., EditorContainer)
	 * @param {string} containerClass  Class name for view or editor, such as 'davinci.ve.PageEditor'
	 * @param {boolean} [toolbar]  If provided, toolbar widget
	 * @returns {boolean}  Whether toolbar has been created
	 */
	toolbarCreated: function(containerClass, toolbar){
		if(arguments.length > 1){
			this._toolbarCreated[containerClass] = toolbar;
		}
		return this._toolbarCreated[containerClass];
	},
	
	/**
	 * Attach this class's toolbar to its toolbarDiv
	 */
	attachToolbar: function(){
		var toolbar = this.toolbarCreated(this.declaredClass);
		var toolbarDiv = this.getToolbarDiv();
		if(toolbar && toolbar.domNode && toolbarDiv){
			toolbarDiv.innerHTML = '';
			toolbarDiv.appendChild(toolbar.domNode);
		}
	}

//TODO: implement destroy/getChildren to destroy toolbarDiv and containerNode?
});
});

},
'davinci/ve/tools/_Tool':function(){
define(["dojo/_base/declare",
        "davinci/ve/widget",
        "davinci/ve/metadata",
		"davinci/ve/utils/GeomUtils"], function(declare, widget, metadata, GeomUtils){

return declare("davinci.ve.tools._Tool", null, {

	_getTarget: function(){
		return this._target;
	},

	/**
	 * Update the editFeedback box(es) that are superimposed over the canvas to capture
	 * mouse events over primitive widgets, thereby preventing default mouse event handlers
	 * on widgets from receiving events during page editing
	 * @param {object} target  A DOM node which (in almost all cases) has received a mouseover event
	 * @param {object) event  The event object
	 */
	_setTarget: function(target, event){
		
		if(!this._targetOverlays){
			this._targetOverlays = [];
		}

		if(this._matchesTargetOverlay(target)){
			return;
		}

		var containerNode = this._context.getContainerNode();
		var w;
		
		while(target && target != containerNode){
			w = widget.getEnclosingWidget(target);
			// Not sure when w.getContext() won't be true. Maybe that check deals with
			// widgets that are either not completely ready or in process of being deleted?
			// If anyone knows answer, please update this comment.
			if(w && !w.getContext()){
				target = w.domNode.parentNode;
				w = null;
			}else if (w && davinci.ve.metadata.queryDescriptor(w.type, "enablePointerEvents")) {
				// By default, this function posts an overlay DIV over primitive widgets to mask/capture 
				// mouse/touch/pointer events  that might otherwise trigger a widget's own interactive logic, 
				// such as bringing up popup menus or onhover styling.
				// The "enablePointerEvents" descriptor property says don't mask/capture these events
				// and let those events go right through into the underlying widget.
				w = null;
				break;
			}else{
				// Flow typically comes to here. The following check determines if
				// current widget is a container, which means it can contain other widgets.
				// If a container, then don't put editFeedback overlay over this DOM node
				// because we want user to be able to click-select on child widgets,
				// (unless the "isControl" metadata override is set for this widget type).
				if (w && w.getContainerNode()) {
					// Some Dijit widgets inherit from dijit._Container even those
					// they aren't really meant to contain child widgets.
					// "isControl" metadata flag overrides and says this is really 
					// a primitive widget not a container widget.
					if (!davinci.ve.metadata.queryDescriptor(w.type, "isControl")) {
						w = null;
					}
				}
				break;
			}
		}

		if(w){
			//target is what we calculated for "w"
			this._target = w;
			
			//Change the dimensions of the overlay region based on the target
			this._updateTargetOverlays(event);

			//Insert overlay element(s)
			this._insertTargetOverlays();
		}else{
			//No target, so remove the overlay region(s)
			this._removeTargetOverlays();
			this._target = null;
		}
	},
	
	// Calculate bounds for "target" overlay rectangle(s)
	_updateTargetOverlays: function(event){
		//Let's clear out overlay regions array
		this._removeTargetOverlays();
		if(!this._target){
			return;
		}
		
		var domNode = this._target.domNode;
		var maxZIndex = this._getMaxZIndex(domNode);
		if(this._targetOverlays){
			
			//See if helper wants to tell us what to use for target overlays
			var helper = this._target.getHelper();
			if(helper && helper.getTargetOverlays) {
				var customTargetOverlays = helper.getTargetOverlays(this._target);
				if (customTargetOverlays && customTargetOverlays.length > 0) {
					dojo.forEach(customTargetOverlays, function(customOverlay) {
						//Create a new overlay div and set up according to dimensions
						//from the helper
						var overlay =
								this._getNewTargetOverlay(customOverlay,
										customOverlay.x, customOverlay.y,
										customOverlay.width, customOverlay.height,
										maxZIndex);
	
						//Add new overlay div to our overall list
						this._targetOverlays.push(overlay);
		            }, this);
					
					
					//We're done here
					return;
				}
			} 

			var left = domNode.offsetLeft;
			var top = domNode.offsetTop;
			var width = domNode.offsetWidth;
			var height = domNode.offsetHeight;

			if(event){
				
				// This code addresses #2136, where CSS transforms shift the widget and 
				// therefore offsetLeft/Top/Width/Height are not reliable indicators
				// of a node's bounds. Unfortunately, there are no getBoundingBox APIs
				// in browsers today that give the post-transform bounds on a node.
				// However, at least WebKit is smart enough to have onmouseover event
				// deal with the post-transform location of a particular node.
				// So, to deal with this issue, increase the bounding box to include pageX/pageY.
				var diff;
				var borderBoxPageCoords = GeomUtils.getBorderBoxPageCoordsCached(domNode);
				if(event.pageX < borderBoxPageCoords.l){
					diff = borderBoxPageCoords.l - event.pageX;
					left -= diff;
					width += diff;
				}
				if(event.pageY < borderBoxPageCoords.t){
					diff = borderBoxPageCoords.t - event.pageY;
					top -= diff;
					height += diff;
				}
				if(event.pageX > borderBoxPageCoords.l + borderBoxPageCoords.w){
					diff = event.pageX - (borderBoxPageCoords.l + borderBoxPageCoords.w);
					width += diff;
				}
				if(event.pageY > borderBoxPageCoords.t + borderBoxPageCoords.h){
					diff = event.pageY - (borderBoxPageCoords.t + borderBoxPageCoords.h);
					height += diff;
				}
			}

			//No special overlay regions, so let's just do the normal thing and calculate
			//overlay region dimensions ourselves
			var overlay =
					this._getNewTargetOverlay(domNode, left, top, width, height, maxZIndex);	

			//Add new overlay div to our overall list
			this._targetOverlays.push(overlay);
		}
	},

	//Calculate zIndex -- we want a zIndex at least equal to the maximum
	//zIndex of domNode and it's descendants. This comes into play
	//with HorizontalSlider/VerticalSlider where the progress bar and the 
	//knob on the progress bar have higher zIndex values than the slider
	//itself.
	_getMaxZIndex: function(startNode) {
		//We want to look at the computed zIndex of the startNode and all
		//descendant's of startNode to find the maximum zIndex value
		var max_zIndexStr = dojo.style(startNode, "zIndex");
		dojo.query("*", startNode).forEach(function(node){
			var node_zIndexStr = dojo.style(node, "zIndex");
			var node_zIndexNumber = Number(node_zIndexStr);
			var max_zIndexNumber = Number(max_zIndexStr);
			if (!isNaN(node_zIndexNumber)) {
				//Our node's zIndex maps to a valid number
				if (isNaN(max_zIndexNumber)) {
					//Our max is not a valid number, so replace it
					max_zIndexStr = node_zIndexStr;
				} else if (node_zIndexNumber > max_zIndexNumber) {
					//Both our node and max zIndices map to valid numbers,
					//so replace max with node zIndex if greater
					max_zIndexStr = node_zIndexStr;
				}
			}
			//We don't care about the else case (where node's zIndex does not represent a number)
		});

		return max_zIndexStr;
	},
	
	_getNewTargetOverlay: function(domNode, x, y, width, height, zIndex) {
		var overlay = this._context.getDojo().create("div", {
			className: "editFeedback",
			style: {
				position: "absolute",
				opacity: 0.1,
				left: x + "px",
				top: y + "px",
				width: width + "px",
				height: height + "px",
				zIndex: zIndex
			}
		});
		return overlay;
	},
	
	_insertTargetOverlays: function() {
		if (this._targetOverlays && this._target) {
			var domNode = this._target.domNode;
			var parentNode = domNode.parentNode;
			dojo.forEach(this._targetOverlays, function(overlay) {
				parentNode.insertBefore(overlay, domNode.nextSibling);
            }, this);
		}
	},
	
	_removeTargetOverlays: function() {
		if (this._targetOverlays && this._target) {
			//Need to go in reverse order so pop removes right item from array
			for (var i = this._targetOverlays.length - 1; i >= 0; i--) {
				var overlay = this._targetOverlays[i];
				dojo.destroy(overlay);
				this._targetOverlays.pop();
            }
		}
	},
	

	_matchesTargetOverlay: function(target) {
		return dojo.some(this._targetOverlays, function(entry) {
			return target == entry;
		}, this);
	}
});
});
},
'dijit/_MenuBase':function(){
define([
	"dojo/_base/array",	// array.indexOf
	"dojo/_base/declare", // declare
	"dojo/dom", // dom.isDescendant domClass.replace
	"dojo/dom-attr",
	"dojo/dom-class", // domClass.replace
	"dojo/_base/lang", // lang.hitch
	"dojo/mouse",	// mouse.enter, mouse.leave
	"dojo/on",
	"dojo/window",
	"./a11yclick",
	"./popup",
	"./registry",
	"./_Widget",
	"./_KeyNavContainer",
	"./_TemplatedMixin"
], function(array, declare, dom, domAttr, domClass, lang, mouse, on, winUtils,
			a11yclick, pm, registry, _Widget, _KeyNavContainer, _TemplatedMixin){


// module:
//		dijit/_MenuBase

return declare("dijit._MenuBase",
	[_Widget, _TemplatedMixin, _KeyNavContainer],
{
	// summary:
	//		Base class for Menu and MenuBar

	// parentMenu: [readonly] Widget
	//		pointer to menu that displayed me
	parentMenu: null,

	// popupDelay: Integer
	//		number of milliseconds before hovering (without clicking) causes the popup to automatically open.
	popupDelay: 500,

	// autoFocus: Boolean
	//		A toggle to control whether or not a Menu gets focused when opened as a drop down from a MenuBar
	//		or DropDownButton/ComboButton.   Note though that it always get focused when opened via the keyboard.
	autoFocus: false,

	childSelector: function(/*DOMNode*/ node){
		// summary:
		//		Selector (passed to on.selector()) used to identify MenuItem child widgets, but exclude inert children
		//		like MenuSeparator.  If subclass overrides to a string (ex: "> *"), the subclass must require dojo/query.
		// tags:
		//		protected

		var widget = registry.byNode(node);
		return node.parentNode == this.containerNode && widget && widget.focus;
	},

	postCreate: function(){
		var self = this,
			matches = typeof this.childSelector == "string" ? this.childSelector : lang.hitch(this, "childSelector");
		this.own(
			on(this.containerNode, on.selector(matches, mouse.enter), function(){
				self.onItemHover(registry.byNode(this));
			}),
			on(this.containerNode, on.selector(matches, mouse.leave), function(){
				self.onItemUnhover(registry.byNode(this));
			}),
			on(this.containerNode, on.selector(matches, a11yclick), function(evt){
				self.onItemClick(registry.byNode(this), evt);
				evt.stopPropagation();
				evt.preventDefault();
			})
		);
		this.inherited(arguments);
	},

	onExecute: function(){
		// summary:
		//		Attach point for notification about when a menu item has been executed.
		//		This is an internal mechanism used for Menus to signal to their parent to
		//		close them, because they are about to execute the onClick handler.  In
		//		general developers should not attach to or override this method.
		// tags:
		//		protected
	},

	onCancel: function(/*Boolean*/ /*===== closeAll =====*/){
		// summary:
		//		Attach point for notification about when the user cancels the current menu
		//		This is an internal mechanism used for Menus to signal to their parent to
		//		close them.  In general developers should not attach to or override this method.
		// tags:
		//		protected
	},

	_moveToPopup: function(/*Event*/ evt){
		// summary:
		//		This handles the right arrow key (left arrow key on RTL systems),
		//		which will either open a submenu, or move to the next item in the
		//		ancestor MenuBar
		// tags:
		//		private

		if(this.focusedChild && this.focusedChild.popup && !this.focusedChild.disabled){
			this.onItemClick(this.focusedChild, evt);
		}else{
			var topMenu = this._getTopMenu();
			if(topMenu && topMenu._isMenuBar){
				topMenu.focusNext();
			}
		}
	},

	_onPopupHover: function(/*Event*/ /*===== evt =====*/){
		// summary:
		//		This handler is called when the mouse moves over the popup.
		// tags:
		//		private

		// if the mouse hovers over a menu popup that is in pending-close state,
		// then stop the close operation.
		// This can't be done in onItemHover since some popup targets don't have MenuItems (e.g. ColorPicker)
		if(this.currentPopup && this.currentPopup._pendingClose_timer){
			var parentMenu = this.currentPopup.parentMenu;
			// highlight the parent menu item pointing to this popup
			if(parentMenu.focusedChild){
				parentMenu.focusedChild._setSelected(false);
			}
			parentMenu.focusedChild = this.currentPopup.from_item;
			parentMenu.focusedChild._setSelected(true);
			// cancel the pending close
			this._stopPendingCloseTimer(this.currentPopup);
		}
	},

	onItemHover: function(/*MenuItem*/ item){
		// summary:
		//		Called when cursor is over a MenuItem.
		// tags:
		//		protected

		// Don't do anything unless user has "activated" the menu by:
		//		1) clicking it
		//		2) opening it from a parent menu (which automatically focuses it)
		if(this.isActive){
			this.focusChild(item);
			if(this.focusedChild.popup && !this.focusedChild.disabled && !this.hover_timer){
				this.hover_timer = this.defer("_openPopup", this.popupDelay);
			}
		}
		// if the user is mixing mouse and keyboard navigation,
		// then the menu may not be active but a menu item has focus,
		// but it's not the item that the mouse just hovered over.
		// To avoid both keyboard and mouse selections, use the latest.
		if(this.focusedChild){
			this.focusChild(item);
		}
		this._hoveredChild = item;

		item._set("hovering", true);
	},

	_onChildBlur: function(item){
		// summary:
		//		Called when a child MenuItem becomes inactive because focus
		//		has been removed from the MenuItem *and* it's descendant menus.
		// tags:
		//		private
		this._stopPopupTimer();
		item._setSelected(false);
		// Close all popups that are open and descendants of this menu
		var itemPopup = item.popup;
		if(itemPopup){
			this._stopPendingCloseTimer(itemPopup);
			itemPopup._pendingClose_timer = this.defer(function(){
				itemPopup._pendingClose_timer = null;
				if(itemPopup.parentMenu){
					itemPopup.parentMenu.currentPopup = null;
				}
				pm.close(itemPopup); // this calls onClose
			}, this.popupDelay);
		}
	},

	onItemUnhover: function(/*MenuItem*/ item){
		// summary:
		//		Callback fires when mouse exits a MenuItem
		// tags:
		//		protected

		if(this.isActive){
			this._stopPopupTimer();
		}
		if(this._hoveredChild == item){ this._hoveredChild = null; }

		item._set("hovering", false);
	},

	_stopPopupTimer: function(){
		// summary:
		//		Cancels the popup timer because the user has stop hovering
		//		on the MenuItem, etc.
		// tags:
		//		private
		if(this.hover_timer){
			this.hover_timer = this.hover_timer.remove();
		}
	},

	_stopPendingCloseTimer: function(/*dijit/_WidgetBase*/ popup){
		// summary:
		//		Cancels the pending-close timer because the close has been preempted
		// tags:
		//		private
		if(popup._pendingClose_timer){
			popup._pendingClose_timer = popup._pendingClose_timer.remove();
		}
	},

	_stopFocusTimer: function(){
		// summary:
		//		Cancels the pending-focus timer because the menu was closed before focus occured
		// tags:
		//		private
		if(this._focus_timer){
			this._focus_timer = this._focus_timer.remove();
		}
	},

	_getTopMenu: function(){
		// summary:
		//		Returns the top menu in this chain of Menus
		// tags:
		//		private
		for(var top=this; top.parentMenu; top=top.parentMenu);
		return top;
	},

	onItemClick: function(/*dijit/_WidgetBase*/ item, /*Event*/ evt){
		// summary:
		//		Handle clicks on an item.
		// tags:
		//		private

		// this can't be done in _onFocus since the _onFocus events occurs asynchronously
		if(typeof this.isShowingNow == 'undefined'){ // non-popup menu
			this._markActive();
		}

		this.focusChild(item);

		if(item.disabled){ return false; }

		if(item.popup){
			this._openPopup(evt.type == "keypress");
		}else{
			// before calling user defined handler, close hierarchy of menus
			// and restore focus to place it was when menu was opened
			this.onExecute();

			// user defined handler for click
			item._onClick ? item._onClick(evt) : item.onClick(evt);
		}
	},

	_openPopup: function(/*Boolean*/ focus){
		// summary:
		//		Open the popup to the side of/underneath the current menu item, and optionally focus first item
		// tags:
		//		protected

		this._stopPopupTimer();
		var from_item = this.focusedChild;
		if(!from_item){ return; } // the focused child lost focus since the timer was started
		var popup = from_item.popup;
		if(!popup.isShowingNow){
			if(this.currentPopup){
				this._stopPendingCloseTimer(this.currentPopup);
				pm.close(this.currentPopup);
			}
			popup.parentMenu = this;
			popup.from_item = from_item; // helps finding the parent item that should be focused for this popup
			var self = this;
			pm.open({
				parent: this,
				popup: popup,
				around: from_item.domNode,
				orient: this._orient || ["after", "before"],
				onCancel: function(){ // called when the child menu is canceled
					// set isActive=false (_closeChild vs _cleanUp) so that subsequent hovering will NOT open child menus
					// which seems aligned with the UX of most applications (e.g. notepad, wordpad, paint shop pro)
					self.focusChild(from_item);	// put focus back on my node
					self._cleanUp();			// close the submenu (be sure this is done _after_ focus is moved)
					from_item._setSelected(true); // oops, _cleanUp() deselected the item
					self.focusedChild = from_item;	// and unset focusedChild
				},
				onExecute: lang.hitch(this, "_cleanUp")
			});

			this.currentPopup = popup;
			// detect mouseovers to handle lazy mouse movements that temporarily focus other menu items
			popup.connect(popup.domNode, "onmouseenter", lang.hitch(self, "_onPopupHover")); // cleaned up when the popped-up widget is destroyed on close
		}

		if(focus && popup.focus){
			// If user is opening the popup via keyboard (right arrow, or down arrow for MenuBar), then focus the popup.
			// If the cursor happens to collide with the popup, it will generate an onmouseover event
			// even though the mouse wasn't moved.  Use defer() to call popup.focus so that
			// our focus() call overrides the onmouseover event, rather than vice-versa.  (#8742)
			popup._focus_timer = this.defer(lang.hitch(popup, function(){
				this._focus_timer = null;
				this.focus();
			}));
		}
	},

	_markActive: function(){
		// summary:
		//		Mark this menu's state as active.
		//		Called when this Menu gets focus from:
		//
		//		1. clicking it (mouse or via space/arrow key)
		//		2. being opened by a parent menu.
		//
		//		This is not called just from mouse hover.
		//		Focusing a menu via TAB does NOT automatically set isActive
		//		since TAB is a navigation operation and not a selection one.
		//		For Windows apps, pressing the ALT key focuses the menubar
		//		menus (similar to TAB navigation) but the menu is not active
		//		(ie no dropdown) until an item is clicked.
		this.isActive = true;
		domClass.replace(this.domNode, "dijitMenuActive", "dijitMenuPassive");
	},

	onOpen: function(/*Event*/ /*===== e =====*/){
		// summary:
		//		Callback when this menu is opened.
		//		This is called by the popup manager as notification that the menu
		//		was opened.
		// tags:
		//		private

		this.isShowingNow = true;
		this._markActive();
	},

	_markInactive: function(){
		// summary:
		//		Mark this menu's state as inactive.
		this.isActive = false; // don't do this in _onBlur since the state is pending-close until we get here
		domClass.replace(this.domNode, "dijitMenuPassive", "dijitMenuActive");
	},

	onClose: function(){
		// summary:
		//		Callback when this menu is closed.
		//		This is called by the popup manager as notification that the menu
		//		was closed.
		// tags:
		//		private

		this._stopFocusTimer();
		this._markInactive();
		this.isShowingNow = false;
		this.parentMenu = null;
	},

	_closeChild: function(){
		// summary:
		//		Called when submenu is clicked or focus is lost.  Close hierarchy of menus.
		// tags:
		//		private
		this._stopPopupTimer();

		if(this.currentPopup){
			// If focus is on a descendant MenuItem then move focus to me,
			// because IE doesn't like it when you display:none a node with focus,
			// and also so keyboard users don't lose control.
			// Likely, immediately after a user defined onClick handler will move focus somewhere
			// else, like a Dialog.
			if(array.indexOf(this._focusManager.activeStack, this.id) >= 0){
				domAttr.set(this.focusedChild.focusNode, "tabIndex", this.tabIndex);
				this.focusedChild.focusNode.focus();
			}
			// Close all popups that are open and descendants of this menu
			pm.close(this.currentPopup);
			this.currentPopup = null;
		}

		if(this.focusedChild){ // unhighlight the focused item
			this.focusedChild._setSelected(false);
			this.onItemUnhover(this.focusedChild);
			this.focusedChild = null;
		}
	},

	_onItemFocus: function(/*MenuItem*/ item){
		// summary:
		//		Called when child of this Menu gets focus from:
		//
		//		1. clicking it
		//		2. tabbing into it
		//		3. being opened by a parent menu.
		//
		//		This is not called just from mouse hover.
		if(this._hoveredChild && this._hoveredChild != item){
			this.onItemUnhover(this._hoveredChild);	// any previous mouse movement is trumped by focus selection
		}
	},

	_onBlur: function(){
		// summary:
		//		Called when focus is moved away from this Menu and it's submenus.
		// tags:
		//		protected
		this._cleanUp();
		this.inherited(arguments);
	},

	_cleanUp: function(){
		// summary:
		//		Called when the user is done with this menu.  Closes hierarchy of menus.
		// tags:
		//		private

		this._closeChild(); // don't call this.onClose since that's incorrect for MenuBar's that never close
		if(typeof this.isShowingNow == 'undefined'){ // non-popup menu doesn't call onClose
			this._markInactive();
		}
	}
});

});

},
'davinci/html/CSSProperty':function(){
/**
 * @class davinci.html.CSSProperty
 * @constructor
 * @extends davinci.html.CSSElement
 * 
 * possible fields url : a url value numberValue : the numeric part of a value
 * units : the units of a numeric value
 * 
 */
define([
	"dojo/_base/declare",
	"davinci/html/CSSElement"
], function(declare, CSSElement) {

return declare("davinci.html.CSSProperty", CSSElement, {

	constructor: function(name, value, parent) {
		this.elementType = "CSSProperty";
		this.name = name || "";
		this.value = value || "";
		this.parent = parent;
		this.expanded = [];
		this.lengthValues = [];
	},

	getValue: function() {
		return this.value;
	},
	
	getText: function(context) {
		var s = "";
		if (this.comment && !context.noComments) {
			s += "\n  " + this.comment.getText(context);
		}
		s += this.name + " : " + this.value;
		if (this.isNotImportant) {
			s += ' !important';
		}
		s += ";";
		if (this.postComment && !context.noComments) {
			s += this.postComment.getText(context);
		}
		return s;
	},

	getCSSRule: function() {
		return this.parent;
	},
	
	addProperty: function(name, value) {
		var property = new CSSProperty(name, value, this);
		this.properties.push(property);
	},

	getURL: function() {
		if (this.url) {
			var path = new davinci.model.Path(this.getCSSFile().url);
			path = path.getParentPath().append(this.url);
			return path.toString();
		}
	}

});
});


},
'dojo/i18n':function(){
define(["./_base/kernel", "require", "./has", "./_base/array", "./_base/config", "./_base/lang", "./_base/xhr", "./json", "module"],
	function(dojo, require, has, array, config, lang, xhr, json, module){

	// module:
	//		dojo/i18n

	has.add("dojo-preload-i18n-Api",
		// if true, define the preload localizations machinery
		1
	);

	 1 || has.add("dojo-v1x-i18n-Api",
		// if true, define the v1.x i18n functions
		1
	);

	var
		thisModule = dojo.i18n =
			{
				// summary:
				//		This module implements the dojo/i18n! plugin and the v1.6- i18n API
				// description:
				//		We choose to include our own plugin to leverage functionality already contained in dojo
				//		and thereby reduce the size of the plugin compared to various loader implementations. Also, this
				//		allows foreign AMD loaders to be used without their plugins.
			},

		nlsRe =
			// regexp for reconstructing the master bundle name from parts of the regexp match
			// nlsRe.exec("foo/bar/baz/nls/en-ca/foo") gives:
			// ["foo/bar/baz/nls/en-ca/foo", "foo/bar/baz/nls/", "/", "/", "en-ca", "foo"]
			// nlsRe.exec("foo/bar/baz/nls/foo") gives:
			// ["foo/bar/baz/nls/foo", "foo/bar/baz/nls/", "/", "/", "foo", ""]
			// so, if match[5] is blank, it means this is the top bundle definition.
			// courtesy of http://requirejs.org
			/(^.*(^|\/)nls)(\/|$)([^\/]*)\/?([^\/]*)/,

		getAvailableLocales = function(
			root,
			locale,
			bundlePath,
			bundleName
		){
			// summary:
			//		return a vector of module ids containing all available locales with respect to the target locale
			//		For example, assuming:
			//
			//		- the root bundle indicates specific bundles for "fr" and "fr-ca",
			//		-  bundlePath is "myPackage/nls"
			//		- bundleName is "myBundle"
			//
			//		Then a locale argument of "fr-ca" would return
			//
			//			["myPackage/nls/myBundle", "myPackage/nls/fr/myBundle", "myPackage/nls/fr-ca/myBundle"]
			//
			//		Notice that bundles are returned least-specific to most-specific, starting with the root.
			//
			//		If root===false indicates we're working with a pre-AMD i18n bundle that doesn't tell about the available locales;
			//		therefore, assume everything is available and get 404 errors that indicate a particular localization is not available

			for(var result = [bundlePath + bundleName], localeParts = locale.split("-"), current = "", i = 0; i<localeParts.length; i++){
				current += (current ? "-" : "") + localeParts[i];
				if(!root || root[current]){
					result.push(bundlePath + current + "/" + bundleName);
				}
			}
			return result;
		},

		cache = {},

		getBundleName = function(moduleName, bundleName, locale){
			locale = locale ? locale.toLowerCase() : dojo.locale;
			moduleName = moduleName.replace(/\./g, "/");
			bundleName = bundleName.replace(/\./g, "/");
			return (/root/i.test(locale)) ?
				(moduleName + "/nls/" + bundleName) :
				(moduleName + "/nls/" + locale + "/" + bundleName);
		},

		getL10nName = dojo.getL10nName = function(moduleName, bundleName, locale){
			return moduleName = module.id + "!" + getBundleName(moduleName, bundleName, locale);
		},

		doLoad = function(require, bundlePathAndName, bundlePath, bundleName, locale, load){
			// summary:
			//		get the root bundle which instructs which other bundles are required to construct the localized bundle
			require([bundlePathAndName], function(root){
				var current = lang.clone(root.root),
					availableLocales = getAvailableLocales(!root._v1x && root, locale, bundlePath, bundleName);
				require(availableLocales, function(){
					for (var i = 1; i<availableLocales.length; i++){
						current = lang.mixin(lang.clone(current), arguments[i]);
					}
					// target may not have been resolve (e.g., maybe only "fr" exists when "fr-ca" was requested)
					var target = bundlePathAndName + "/" + locale;
					cache[target] = current;
					load();
				});
			});
		},

		normalize = function(id, toAbsMid){
			// summary:
			//		id may be relative.
			//		preload has form `*preload*<path>/nls/<module>*<flattened locales>` and
			//		therefore never looks like a relative
			return /^\./.test(id) ? toAbsMid(id) : id;
		},

		getLocalesToLoad = function(targetLocale){
			var list = config.extraLocale || [];
			list = lang.isArray(list) ? list : [list];
			list.push(targetLocale);
			return list;
		},

		load = function(id, require, load){
			// summary:
			//		id is in one of the following formats
			//
			//		1. <path>/nls/<bundle>
			//			=> load the bundle, localized to config.locale; load all bundles localized to
			//			config.extraLocale (if any); return the loaded bundle localized to config.locale.
			//
			//		2. <path>/nls/<locale>/<bundle>
			//			=> load then return the bundle localized to <locale>
			//
			//		3. *preload*<path>/nls/<module>*<JSON array of available locales>
			//			=> for config.locale and all config.extraLocale, load all bundles found
			//			in the best-matching bundle rollup. A value of 1 is returned, which
			//			is meaningless other than to say the plugin is executing the requested
			//			preloads
			//
			//		In cases 1 and 2, <path> is always normalized to an absolute module id upon entry; see
			//		normalize. In case 3, it <path> is assumed to be absolute; this is arranged by the builder.
			//
			//		To load a bundle means to insert the bundle into the plugin's cache and publish the bundle
			//		value to the loader. Given <path>, <bundle>, and a particular <locale>, the cache key
			//
			//			<path>/nls/<bundle>/<locale>
			//
			//		will hold the value. Similarly, then plugin will publish this value to the loader by
			//
			//			define("<path>/nls/<bundle>/<locale>", <bundle-value>);
			//
			//		Given this algorithm, other machinery can provide fast load paths be preplacing
			//		values in the plugin's cache, which is public. When a load is demanded the
			//		cache is inspected before starting any loading. Explicitly placing values in the plugin
			//		cache is an advanced/experimental feature that should not be needed; use at your own risk.
			//
			//		For the normal AMD algorithm, the root bundle is loaded first, which instructs the
			//		plugin what additional localized bundles are required for a particular locale. These
			//		additional locales are loaded and a mix of the root and each progressively-specific
			//		locale is returned. For example:
			//
			//		1. The client demands "dojo/i18n!some/path/nls/someBundle
			//
			//		2. The loader demands load(some/path/nls/someBundle)
			//
			//		3. This plugin require's "some/path/nls/someBundle", which is the root bundle.
			//
			//		4. Assuming config.locale is "ab-cd-ef" and the root bundle indicates that localizations
			//		are available for "ab" and "ab-cd-ef" (note the missing "ab-cd", then the plugin
			//		requires "some/path/nls/ab/someBundle" and "some/path/nls/ab-cd-ef/someBundle"
			//
			//		5. Upon receiving all required bundles, the plugin constructs the value of the bundle
			//		ab-cd-ef as...
			//
			//				mixin(mixin(mixin({}, require("some/path/nls/someBundle"),
			//		  			require("some/path/nls/ab/someBundle")),
			//					require("some/path/nls/ab-cd-ef/someBundle"));
			//
			//		This value is inserted into the cache and published to the loader at the
			//		key/module-id some/path/nls/someBundle/ab-cd-ef.
			//
			//		The special preload signature (case 3) instructs the plugin to stop servicing all normal requests
			//		(further preload requests will be serviced) until all ongoing preloading has completed.
			//
			//		The preload signature instructs the plugin that a special rollup module is available that contains
			//		one or more flattened, localized bundles. The JSON array of available locales indicates which locales
			//		are available. Here is an example:
			//
			//			*preload*some/path/nls/someModule*["root", "ab", "ab-cd-ef"]
			//
			//		This indicates the following rollup modules are available:
			//
			//			some/path/nls/someModule_ROOT
			//			some/path/nls/someModule_ab
			//			some/path/nls/someModule_ab-cd-ef
			//
			//		Each of these modules is a normal AMD module that contains one or more flattened bundles in a hash.
			//		For example, assume someModule contained the bundles some/bundle/path/someBundle and
			//		some/bundle/path/someOtherBundle, then some/path/nls/someModule_ab would be expressed as follows:
			//
			//			define({
			//				some/bundle/path/someBundle:<value of someBundle, flattened with respect to locale ab>,
			//				some/bundle/path/someOtherBundle:<value of someOtherBundle, flattened with respect to locale ab>,
			//			});
			//
			//		E.g., given this design, preloading for locale=="ab" can execute the following algorithm:
			//
			//			require(["some/path/nls/someModule_ab"], function(rollup){
			//				for(var p in rollup){
			//					var id = p + "/ab",
			//					cache[id] = rollup[p];
			//					define(id, rollup[p]);
			//				}
			//			});
			//
			//		Similarly, if "ab-cd" is requested, the algorithm can determine that "ab" is the best available and
			//		load accordingly.
			//
			//		The builder will write such rollups for every layer if a non-empty localeList  profile property is
			//		provided. Further, the builder will include the following cache entry in the cache associated with
			//		any layer.
			//
			//			"*now":function(r){r(['dojo/i18n!*preload*<path>/nls/<module>*<JSON array of available locales>']);}
			//
			//		The *now special cache module instructs the loader to apply the provided function to context-require
			//		with respect to the particular layer being defined. This causes the plugin to hold all normal service
			//		requests until all preloading is complete.
			//
			//		Notice that this algorithm is rarely better than the standard AMD load algorithm. Consider the normal case
			//		where the target locale has a single segment and a layer depends on a single bundle:
			//
			//		Without Preloads:
			//
			//		1. Layer loads root bundle.
			//		2. bundle is demanded; plugin loads single localized bundle.
			//
			//		With Preloads:
			//
			//		1. Layer causes preloading of target bundle.
			//		2. bundle is demanded; service is delayed until preloading complete; bundle is returned.
			//
			//		In each case a single transaction is required to load the target bundle. In cases where multiple bundles
			//		are required and/or the locale has multiple segments, preloads still requires a single transaction whereas
			//		the normal path requires an additional transaction for each additional bundle/locale-segment. However all
			//		of these additional transactions can be done concurrently. Owing to this analysis, the entire preloading
			//		algorithm can be discard during a build by setting the has feature dojo-preload-i18n-Api to false.

			if(has("dojo-preload-i18n-Api")){
				var split = id.split("*"),
					preloadDemand = split[1] == "preload";
				if(preloadDemand){
					if(!cache[id]){
						// use cache[id] to prevent multiple preloads of the same preload; this shouldn't happen, but
						// who knows what over-aggressive human optimizers may attempt
						cache[id] = 1;
						preloadL10n(split[2], json.parse(split[3]), 1, require);
					}
					// don't stall the loader!
					load(1);
				}
				if(preloadDemand || waitForPreloads(id, require, load)){
					return;
				}
			}

			var match = nlsRe.exec(id),
				bundlePath = match[1] + "/",
				bundleName = match[5] || match[4],
				bundlePathAndName = bundlePath + bundleName,
				localeSpecified = (match[5] && match[4]),
				targetLocale =	localeSpecified || dojo.locale,
				loadTarget = bundlePathAndName + "/" + targetLocale,
				loadList = localeSpecified ? [targetLocale] : getLocalesToLoad(targetLocale),
				remaining = loadList.length,
				finish = function(){
					if(!--remaining){
						load(lang.delegate(cache[loadTarget]));
					}
				};
			array.forEach(loadList, function(locale){
				var target = bundlePathAndName + "/" + locale;
				if(has("dojo-preload-i18n-Api")){
					checkForLegacyModules(target);
				}
				if(!cache[target]){
					doLoad(require, bundlePathAndName, bundlePath, bundleName, locale, finish);
				}else{
					finish();
				}
			});
		};

	if(has("dojo-unit-tests")){
		var unitTests = thisModule.unitTests = [];
	}

	if(has("dojo-preload-i18n-Api") ||  1 ){
		var normalizeLocale = thisModule.normalizeLocale = function(locale){
				var result = locale ? locale.toLowerCase() : dojo.locale;
				return result == "root" ? "ROOT" : result;
			},

			isXd = function(mid, contextRequire){
				return ( 1  &&  1 ) ?
					contextRequire.isXdUrl(require.toUrl(mid + ".js")) :
					true;
			},

			preloading = 0,

			preloadWaitQueue = [],

			preloadL10n = thisModule._preloadLocalizations = function(/*String*/bundlePrefix, /*Array*/localesGenerated, /*boolean?*/ guaranteedAmdFormat, /*function?*/ contextRequire){
				// summary:
				//		Load available flattened resource bundles associated with a particular module for dojo/locale and all dojo/config.extraLocale (if any)
				// description:
				//		Only called by built layer files. The entire locale hierarchy is loaded. For example,
				//		if locale=="ab-cd", then ROOT, "ab", and "ab-cd" are loaded. This is different than v1.6-
				//		in that the v1.6- would only load ab-cd...which was *always* flattened.
				//
				//		If guaranteedAmdFormat is true, then the module can be loaded with require thereby circumventing the detection algorithm
				//		and the extra possible extra transaction.

				// If this function is called from legacy code, then guaranteedAmdFormat and contextRequire will be undefined. Since the function
				// needs a require in order to resolve module ids, fall back to the context-require associated with this dojo/i18n module, which
				// itself may have been mapped.
				contextRequire = contextRequire || require;

				function doRequire(mid, callback){
					if(isXd(mid, contextRequire) || guaranteedAmdFormat){
						contextRequire([mid], callback);
					}else{
						syncRequire([mid], callback, contextRequire);
					}
				}

				function forEachLocale(locale, func){
					// given locale= "ab-cd-ef", calls func on "ab-cd-ef", "ab-cd", "ab", "ROOT"; stops calling the first time func returns truthy
					var parts = locale.split("-");
					while(parts.length){
						if(func(parts.join("-"))){
							return;
						}
						parts.pop();
					}
					func("ROOT");
				}

				function preload(locale){
					locale = normalizeLocale(locale);
					forEachLocale(locale, function(loc){
						if(array.indexOf(localesGenerated, loc)>=0){
							var mid = bundlePrefix.replace(/\./g, "/")+"_"+loc;
							preloading++;
							doRequire(mid, function(rollup){
								for(var p in rollup){
									cache[require.toAbsMid(p) + "/" + loc] = rollup[p];
								}
								--preloading;
								while(!preloading && preloadWaitQueue.length){
									load.apply(null, preloadWaitQueue.shift());
								}
							});
							return true;
						}
						return false;
					});
				}

				preload();
				array.forEach(dojo.config.extraLocale, preload);
			},

			waitForPreloads = function(id, require, load){
				if(preloading){
					preloadWaitQueue.push([id, require, load]);
				}
				return preloading;
			},

			checkForLegacyModules = function()
				{};
	}

	if( 1 ){
		// this code path assumes the dojo loader and won't work with a standard AMD loader
		var amdValue = {},
			evalBundle =
				// use the function ctor to keep the minifiers away (also come close to global scope, but this is secondary)
				new Function(
					"__bundle",				   // the bundle to evalutate
					"__checkForLegacyModules", // a function that checks if __bundle defined __mid in the global space
					"__mid",				   // the mid that __bundle is intended to define
					"__amdValue",

					// returns one of:
					//		1 => the bundle was an AMD bundle
					//		a legacy bundle object that is the value of __mid
					//		instance of Error => could not figure out how to evaluate bundle

					  // used to detect when __bundle calls define
					  "var define = function(mid, factory){define.called = 1; __amdValue.result = factory || mid;},"
					+ "	   require = function(){define.called = 1;};"

					+ "try{"
					+		"define.called = 0;"
					+		"eval(__bundle);"
					+		"if(define.called==1)"
								// bundle called define; therefore signal it's an AMD bundle
					+			"return __amdValue;"

					+		"if((__checkForLegacyModules = __checkForLegacyModules(__mid)))"
								// bundle was probably a v1.6- built NLS flattened NLS bundle that defined __mid in the global space
					+			"return __checkForLegacyModules;"

					+ "}catch(e){}"
					// evaulating the bundle was *neither* an AMD *nor* a legacy flattened bundle
					// either way, re-eval *after* surrounding with parentheses

					+ "try{"
					+		"return eval('('+__bundle+')');"
					+ "}catch(e){"
					+		"return e;"
					+ "}"
				),

			syncRequire = function(deps, callback, require){
				var results = [];
				array.forEach(deps, function(mid){
					var url = require.toUrl(mid + ".js");

					function load(text){
						var result = evalBundle(text, checkForLegacyModules, mid, amdValue);
						if(result===amdValue){
							// the bundle was an AMD module; re-inject it through the normal AMD path
							// we gotta do this since it could be an anonymous module and simply evaluating
							// the text here won't provide the loader with the context to know what
							// module is being defined()'d. With browser caching, this should be free; further
							// this entire code path can be circumvented by using the AMD format to begin with
							results.push(cache[url] = amdValue.result);
						}else{
							if(result instanceof Error){
								console.error("failed to evaluate i18n bundle; url=" + url, result);
								result = {};
							}
							// nls/<locale>/<bundle-name> indicates not the root.
							results.push(cache[url] = (/nls\/[^\/]+\/[^\/]+$/.test(url) ? result : {root:result, _v1x:1}));
						}
					}

					if(cache[url]){
						results.push(cache[url]);
					}else{
						var bundle = require.syncLoadNls(mid);
						// don't need to check for legacy since syncLoadNls returns a module if the module
						// (1) was already loaded, or (2) was in the cache. In case 1, if syncRequire is called
						// from getLocalization --> load, then load will have called checkForLegacyModules() before
						// calling syncRequire; if syncRequire is called from preloadLocalizations, then we
						// don't care about checkForLegacyModules() because that will be done when a particular
						// bundle is actually demanded. In case 2, checkForLegacyModules() is never relevant
						// because cached modules are always v1.7+ built modules.
						if(bundle){
							results.push(bundle);
						}else{
							if(!xhr){
								try{
									require.getText(url, true, load);
								}catch(e){
									results.push(cache[url] = {});
								}
							}else{
								xhr.get({
									url:url,
									sync:true,
									load:load,
									error:function(){
										results.push(cache[url] = {});
									}
								});
							}
						}
					}
				});
				callback && callback.apply(null, results);
			};

		checkForLegacyModules = function(target){
			// legacy code may have already loaded [e.g] the raw bundle x/y/z at x.y.z; when true, push into the cache
			for(var result, names = target.split("/"), object = dojo.global[names[0]], i = 1; object && i<names.length-1; object = object[names[i++]]){}
			if(object){
				result = object[names[i]];
				if(!result){
					// fallback for incorrect bundle build of 1.6
					result = object[names[i].replace(/-/g,"_")];
				}
				if(result){
					cache[target] = result;
				}
			}
			return result;
		};

		thisModule.getLocalization = function(moduleName, bundleName, locale){
			var result,
				l10nName = getBundleName(moduleName, bundleName, locale);
			load(
				l10nName,

				// isXd() and syncRequire() need a context-require in order to resolve the mid with respect to a reference module.
				// Since this legacy function does not have the concept of a reference module, resolve with respect to this
				// dojo/i18n module, which, itself may have been mapped.
				(!isXd(l10nName, require) ? function(deps, callback){ syncRequire(deps, callback, require); } : require),

				function(result_){ result = result_; }
			);
			return result;
		};

		if(has("dojo-unit-tests")){
			unitTests.push(function(doh){
				doh.register("tests.i18n.unit", function(t){
					var check;

					check = evalBundle("{prop:1}", checkForLegacyModules, "nonsense", amdValue);
					t.is({prop:1}, check); t.is(undefined, check[1]);

					check = evalBundle("({prop:1})", checkForLegacyModules, "nonsense", amdValue);
					t.is({prop:1}, check); t.is(undefined, check[1]);

					check = evalBundle("{'prop-x':1}", checkForLegacyModules, "nonsense", amdValue);
					t.is({'prop-x':1}, check); t.is(undefined, check[1]);

					check = evalBundle("({'prop-x':1})", checkForLegacyModules, "nonsense", amdValue);
					t.is({'prop-x':1}, check); t.is(undefined, check[1]);

					check = evalBundle("define({'prop-x':1})", checkForLegacyModules, "nonsense", amdValue);
					t.is(amdValue, check); t.is({'prop-x':1}, amdValue.result);

					check = evalBundle("define('some/module', {'prop-x':1})", checkForLegacyModules, "nonsense", amdValue);
					t.is(amdValue, check); t.is({'prop-x':1}, amdValue.result);

					check = evalBundle("this is total nonsense and should throw an error", checkForLegacyModules, "nonsense", amdValue);
					t.is(check instanceof Error, true);
				});
			});
		}
	}

	return lang.mixin(thisModule, {
		dynamic:true,
		normalize:normalize,
		load:load,
		cache:cache
	});
});

},
'dojox/html/ellipsis':function(){
define("dojox/html/ellipsis",["dojo/_base/kernel", "dojo/_base/lang", "dojo/_base/array", "dojo/_base/Color", "dojo/colors"], function(d){
	/*=====
	return {
		// summary:
		//		offers cross-browser support for text-overflow: ellipsis
		// description:
		//		Add "dojoxEllipsis" on any node that you want to ellipsis-ize. In order to function properly,
		//		the node with the dojoxEllipsis class set on it should be a child of a node with a defined width.
		//		It should also be a block-level element (i.e. `<div>`) - it will not work on td elements.
		//		NOTE: When using the dojoxEllipsis class within tables, the table needs to have the table-layout: fixed style
	};
	=====*/
	
	if(d.isFF < 7){ //TODO: feature detect text-overflow in computed style?
		// The delay (in ms) to wait so that we don't keep querying when many
		// changes happen at once - set config "dojoxFFEllipsisDelay" if you
		// want a different value
		var delay = 1;
		if("dojoxFFEllipsisDelay" in d.config){
			delay = Number(d.config.dojoxFFEllipsisDelay);
			if(isNaN(delay)){
				delay = 1;
			}
		}
		try{
			var createXULEllipsis = (function(){
				// Create our stub XUL elements for cloning later
				// NOTE: this no longer works as of FF 4.0:
				// https://developer.mozilla.org/En/Firefox_4_for_developers#Remote_XUL_support_removed
				var sNS = 'http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul';
				var xml = document.createElementNS(sNS, 'window');
				var label = document.createElementNS(sNS, 'description');
				label.setAttribute('crop', 'end');
				xml.appendChild(label);

				return function(/* Node */ n){
					// Summary:
					//		Given a node, it creates the XUL and sets its
					//		content so that it will have an ellipsis
					var x = xml.cloneNode(true);
					x.firstChild.setAttribute('value', n.textContent);
					n.innerHTML = '';
					n.appendChild(x);
				};
			})();
		}catch(e){}
		
		// Create our iframe elements for cloning later
		var create = d.create;
		var dd = d.doc;
		var dp = d.place;
		var iFrame = create("iframe", {className: "dojoxEllipsisIFrame",
					src: "javascript:'<html><head><script>if(\"loadFirebugConsole\" in window){window.loadFirebugConsole();}</script></head><body></body></html>'", style: {display: "none"}});
		var rollRange = function(/* W3C Range */ r, /* int? */ cnt){
			// summary:
			//		Rolls the given range back one character from the end
			// r: W3C Range
			//		The range to roll back
			// cnt: int?
			//		An optional number of times to roll back (defaults 1)
			if(r.collapsed){
				// Do nothing - we are already collapsed
				return;
			}
			if(cnt > 0){
				do{
					rollRange(r);
					cnt--;
				}while(cnt);
				return;
			}
			if(r.endContainer.nodeType == 3 && r.endOffset > 0){
				r.setEnd(r.endContainer, r.endOffset - 1);
			}else if(r.endContainer.nodeType == 3){
				r.setEndBefore(r.endContainer);
				rollRange(r);
				return;
			}else if(r.endOffset && r.endContainer.childNodes.length >= r.endOffset){
				var nCont = r.endContainer.childNodes[r.endOffset - 1];
				if(nCont.nodeType == 3){
					r.setEnd(nCont, nCont.length - 1);
				}else if(nCont.childNodes.length){
					r.setEnd(nCont, nCont.childNodes.length);
					rollRange(r);
					return;
				}else{
					r.setEndBefore(nCont);
					rollRange(r);
					return;
				}
			}else{
				r.setEndBefore(r.endContainer);
				rollRange(r);
				return;
			}
		};
		var createIFrameEllipsis = function(/* Node */ n){
			// summary:
			//		Given a node, it creates an iframe and and ellipsis div and
			//		sets up the connections so that they will work correctly.
			//		This function is used when createXULEllipsis is not able
			//		to be used (because there is markup within the node) - it's
			//		a bit slower, but does the trick
			var c = create("div", {className: "dojoxEllipsisContainer"});
			var e = create("div", {className: "dojoxEllipsisShown", style: {display: "none"}});
			n.parentNode.replaceChild(c, n);
			c.appendChild(n);
			c.appendChild(e);
			var i = iFrame.cloneNode(true);
			var ns = n.style;
			var es = e.style;
			var ranges;
			var resizeNode = function(){
				ns.display = "";
				es.display = "none";
				if(n.scrollWidth <= n.offsetWidth){ return; }
				var r = dd.createRange();
				r.selectNodeContents(n);
				ns.display = "none";
				es.display = "";
				var done = false;
				do{
					var numRolls = 1;
					dp(r.cloneContents(), e, "only");
					var sw = e.scrollWidth, ow = e.offsetWidth;
					done = (sw <= ow);
					var pct = (1 - ((ow * 1) / sw));
					if(pct > 0){
						numRolls = Math.max(Math.round(e.textContent.length * pct) - 1, 1);
					}
					rollRange(r, numRolls);
				}while(!r.collapsed && !done);
			};
			i.onload = function(){
				i.contentWindow.onresize = resizeNode;
				resizeNode();
			};
			c.appendChild(i);
		};

		// Function for updating the ellipsis
		var hc = d.hasClass;
		var doc = d.doc;
		var s, fn, opt;
		if(doc.querySelectorAll){
			s = doc;
			fn = "querySelectorAll";
			opt = ".dojoxEllipsis";
		}else if(doc.getElementsByClassName){
			s = doc;
			fn = "getElementsByClassName";
			opt = "dojoxEllipsis";
		}else{
			s = d;
			fn = "query";
			opt = ".dojoxEllipsis";
		}
		fx = function(){
			d.forEach(s[fn].apply(s, [opt]), function(n){
				if(!n || n._djx_ellipsis_done){ return; }
				n._djx_ellipsis_done = true;
				if(createXULEllipsis && n.textContent == n.innerHTML && !hc(n, "dojoxEllipsisSelectable")){
					// We can do the faster XUL version, instead of calculating
					createXULEllipsis(n);
				}else{
					createIFrameEllipsis(n);
				}
			});
		};
		
		d.addOnLoad(function(){
			// Apply our initial stuff
			var t = null;
			var c = null;
			var connFx = function(){
				if(c){
					// disconnect us - so we don't fire anymore
					d.disconnect(c);
					c = null;
				}
				if(t){ clearTimeout(t); }
				t = setTimeout(function(){
					t = null;
					fx();
					// Connect to the modified function so that we can catch
					// our next change
					c = d.connect(d.body(), "DOMSubtreeModified", connFx);
				}, delay);
			};
			connFx();
		});
	}
});

},
'dijit/tree/ForestStoreModel':function(){
define([
	"dojo/_base/array", // array.indexOf array.some
	"dojo/_base/declare", // declare
	"dojo/_base/kernel", // global
	"dojo/_base/lang", // lang.hitch
	"./TreeStoreModel"
], function(array, declare, kernel, lang, TreeStoreModel){

// module:
//		dijit/tree/ForestStoreModel

return declare("dijit.tree.ForestStoreModel", TreeStoreModel, {
	// summary:
	//		Interface between a dijit.Tree and a dojo.data store that doesn't have a root item,
	//		a.k.a. a store that has multiple "top level" items.
	//
	// description:
	//		Use this class to wrap a dojo.data store, making all the items matching the specified query
	//		appear as children of a fabricated "root item".  If no query is specified then all the
	//		items returned by fetch() on the underlying store become children of the root item.
	//		This class allows dijit.Tree to assume a single root item, even if the store doesn't have one.
	//
	//		When using this class the developer must override a number of methods according to their app and
	//		data, including:
	//
	//		- onNewRootItem
	//		- onAddToRoot
	//		- onLeaveRoot
	//		- onNewItem
	//		- onSetItem

	// Parameters to constructor

	// rootId: String
	//		ID of fabricated root item
	rootId: "$root$",

	// rootLabel: String
	//		Label of fabricated root item
	rootLabel: "ROOT",

	// query: String
	//		Specifies the set of children of the root item.
	// example:
	//	|	{type:'continent'}
	query: null,

	// End of parameters to constructor

	constructor: function(params){
		// summary:
		//		Sets up variables, etc.
		// tags:
		//		private

		// Make dummy root item
		this.root = {
			store: this,
			root: true,
			id: params.rootId,
			label: params.rootLabel,
			children: params.rootChildren	// optional param
		};
	},

	// =======================================================================
	// Methods for traversing hierarchy

	mayHaveChildren: function(/*dojo/data/Item*/ item){
		// summary:
		//		Tells if an item has or may have children.  Implementing logic here
		//		avoids showing +/- expando icon for nodes that we know don't have children.
		//		(For efficiency reasons we may not want to check if an element actually
		//		has children until user clicks the expando node)
		// tags:
		//		extension
		return item === this.root || this.inherited(arguments);
	},

	getChildren: function(/*dojo/data/Item*/ parentItem, /*function(items)*/ callback, /*function*/ onError){
		// summary:
		//		Calls onComplete() with array of child items of given parent item, all loaded.
		if(parentItem === this.root){
			if(this.root.children){
				// already loaded, just return
				callback(this.root.children);
			}else{
				this.store.fetch({
					query: this.query,
					onComplete: lang.hitch(this, function(items){
						this.root.children = items;
						callback(items);
					}),
					onError: onError
				});
			}
		}else{
			this.inherited(arguments);
		}
	},

	// =======================================================================
	// Inspecting items

	isItem: function(/* anything */ something){
		return (something === this.root) ? true : this.inherited(arguments);
	},

	fetchItemByIdentity: function(/* object */ keywordArgs){
		if(keywordArgs.identity == this.root.id){
			var scope = keywordArgs.scope || kernel.global;
			if(keywordArgs.onItem){
				keywordArgs.onItem.call(scope, this.root);
			}
		}else{
			this.inherited(arguments);
		}
	},

	getIdentity: function(/* item */ item){
		return (item === this.root) ? this.root.id : this.inherited(arguments);
	},

	getLabel: function(/* item */ item){
		return	(item === this.root) ? this.root.label : this.inherited(arguments);
	},

	// =======================================================================
	// Write interface

	newItem: function(/* dijit/tree/dndSource.__Item */ args, /*Item*/ parent, /*int?*/ insertIndex){
		// summary:
		//		Creates a new item.   See dojo/data/api/Write for details on args.
		//		Used in drag & drop when item from external source dropped onto tree.
		if(parent === this.root){
			this.onNewRootItem(args);
			return this.store.newItem(args);
		}else{
			return this.inherited(arguments);
		}
	},

	onNewRootItem: function(/* dijit/tree/dndSource.__Item */ /*===== args =====*/){
		// summary:
		//		User can override this method to modify a new element that's being
		//		added to the root of the tree, for example to add a flag like root=true
	},

	pasteItem: function(/*Item*/ childItem, /*Item*/ oldParentItem, /*Item*/ newParentItem, /*Boolean*/ bCopy, /*int?*/ insertIndex){
		// summary:
		//		Move or copy an item from one parent item to another.
		//		Used in drag & drop
		if(oldParentItem === this.root){
			if(!bCopy){
				// It's onLeaveRoot()'s responsibility to modify the item so it no longer matches
				// this.query... thus triggering an onChildrenChange() event to notify the Tree
				// that this element is no longer a child of the root node
				this.onLeaveRoot(childItem);
			}
		}
		this.inherited(arguments, [childItem,
			oldParentItem === this.root ? null : oldParentItem,
			newParentItem === this.root ? null : newParentItem,
			bCopy,
			insertIndex
		]);
		if(newParentItem === this.root){
			// It's onAddToRoot()'s responsibility to modify the item so it matches
			// this.query... thus triggering an onChildrenChange() event to notify the Tree
			// that this element is now a child of the root node
			this.onAddToRoot(childItem);
		}
	},

	// =======================================================================
	// Handling for top level children

	onAddToRoot: function(/* item */ item){
		// summary:
		//		Called when item added to root of tree; user must override this method
		//		to modify the item so that it matches the query for top level items
		// example:
		//	|	store.setValue(item, "root", true);
		// tags:
		//		extension
		console.log(this, ": item ", item, " added to root");
	},

	onLeaveRoot: function(/* item */ item){
		// summary:
		//		Called when item removed from root of tree; user must override this method
		//		to modify the item so it doesn't match the query for top level items
		// example:
		//	|	store.unsetAttribute(item, "root");
		// tags:
		//		extension
		console.log(this, ": item ", item, " removed from root");
	},

	// =======================================================================
	// Events from data store

	_requeryTop: function(){
		// reruns the query for the children of the root node,
		// sending out an onSet notification if those children have changed
		var oldChildren = this.root.children || [];
		this.store.fetch({
			query: this.query,
			onComplete: lang.hitch(this, function(newChildren){
				this.root.children = newChildren;

				// If the list of children or the order of children has changed...
				if(oldChildren.length != newChildren.length ||
					array.some(oldChildren, function(item, idx){ return newChildren[idx] != item;})){
					this.onChildrenChange(this.root, newChildren);
				}
			})
		});
	},

	onNewItem: function(/* dojo/data/api/Item */ item, /* Object */ parentInfo){
		// summary:
		//		Handler for when new items appear in the store.  Developers should override this
		//		method to be more efficient based on their app/data.
		// description:
		//		Note that the default implementation requeries the top level items every time
		//		a new item is created, since any new item could be a top level item (even in
		//		addition to being a child of another item, since items can have multiple parents).
		//
		//		If developers can detect which items are possible top level items (based on the item and the
		//		parentInfo parameters), they should override this method to only call _requeryTop() for top
		//		level items.  Often all top level items have parentInfo==null, but
		//		that will depend on which store you use and what your data is like.
		// tags:
		//		extension
		this._requeryTop();

		this.inherited(arguments);
	},

	onDeleteItem: function(/*Object*/ item){
		// summary:
		//		Handler for delete notifications from underlying store

		// check if this was a child of root, and if so send notification that root's children
		// have changed
		if(array.indexOf(this.root.children, item) != -1){
			this._requeryTop();
		}

		this.inherited(arguments);
	},

	onSetItem: function(/* item */ item,
					/* attribute-name-string */ attribute,
					/* Object|Array */ oldValue,
					/* Object|Array */ newValue){
		// summary:
		//		Updates the tree view according to changes to an item in the data store.
		//		Developers should override this method to be more efficient based on their app/data.
		// description:
		//		Handles updates to an item's children by calling onChildrenChange(), and
		//		other updates to an item by calling onChange().
		//
		//		Also, any change to any item re-executes the query for the tree's top-level items,
		//		since this modified item may have started/stopped matching the query for top level items.
		//
		//		If possible, developers should override this function to only call _requeryTop() when
		//		the change to the item has caused it to stop/start being a top level item in the tree.
		// tags:
		//		extension

		this._requeryTop();
		this.inherited(arguments);
	}

});

});

},
'dijit/PopupMenuBarItem':function(){
define([
	"dojo/_base/declare", // declare
	"./PopupMenuItem",
	"./MenuBarItem"
], function(declare, PopupMenuItem, MenuBarItem){

	// module:
	//		dijit/PopupMenuBarItem

	var _MenuBarItemMixin = MenuBarItem._MenuBarItemMixin;

	return declare("dijit.PopupMenuBarItem", [PopupMenuItem, _MenuBarItemMixin], {
		// summary:
		//		Item in a MenuBar like "File" or "Edit", that spawns a submenu when pressed (or hovered)
	});
});

},
'dojox/html/metrics':function(){
define(["dojo/_base/kernel","dojo/_base/lang", "dojo/_base/sniff", "dojo/ready", "dojo/_base/unload",
		"dojo/_base/window", "dojo/dom-geometry"],
  function(kernel,lang,has,ready,UnloadUtil,Window,DOMGeom){
	var dhm = lang.getObject("dojox.html.metrics",true);
	var dojox = lang.getObject("dojox");

	//	derived from Morris John's emResized measurer
	dhm.getFontMeasurements = function(){
		// summary:
		//		Returns an object that has pixel equivilents of standard font size values.
		var heights = {
			'1em':0, '1ex':0, '100%':0, '12pt':0, '16px':0, 'xx-small':0, 'x-small':0,
			'small':0, 'medium':0, 'large':0, 'x-large':0, 'xx-large':0
		};
	
		if(has("ie")){
			//	we do a font-size fix if and only if one isn't applied already.
			//	NOTE: If someone set the fontSize on the HTML Element, this will kill it.
			Window.doc.documentElement.style.fontSize="100%";
		}
	
		//	set up the measuring node.
		var div=Window.doc.createElement("div");
		var ds = div.style;
		ds.position="absolute";
		ds.left="-100px";
		ds.top="0";
		ds.width="30px";
		ds.height="1000em";
		ds.borderWidth="0";
		ds.margin="0";
		ds.padding="0";
		ds.outline="0";
		ds.lineHeight="1";
		ds.overflow="hidden";
		Window.body().appendChild(div);
	
		//	do the measurements.
		for(var p in heights){
			ds.fontSize = p;
			heights[p] = Math.round(div.offsetHeight * 12/16) * 16/12 / 1000;
		}
		
		Window.body().removeChild(div);
		div = null;
		return heights; 	//	object
	};

	var fontMeasurements = null;
	
	dhm.getCachedFontMeasurements = function(recalculate){
		if(recalculate || !fontMeasurements){
			fontMeasurements = dhm.getFontMeasurements();
		}
		return fontMeasurements;
	};

	var measuringNode = null, empty = {};
	dhm.getTextBox = function(/* String */ text, /* Object */ style, /* String? */ className){
		var m, s;
		if(!measuringNode){
			m = measuringNode = Window.doc.createElement("div");
			// Container that we can set contraints on so that it doesn't
			// trigger a scrollbar.
			var c = Window.doc.createElement("div");
			c.appendChild(m);
			s = c.style;
			s.overflow='scroll';
			s.position = "absolute";
			s.left = "0px";
			s.top = "-10000px";
			s.width = "1px";
			s.height = "1px";
			s.visibility = "hidden";
			s.borderWidth = "0";
			s.margin = "0";
			s.padding = "0";
			s.outline = "0";
			Window.body().appendChild(c);
		}else{
			m = measuringNode;
		}
		// reset styles
		m.className = "";
		s = m.style;
		s.borderWidth = "0";
		s.margin = "0";
		s.padding = "0";
		s.outline = "0";
		// set new style
		if(arguments.length > 1 && style){
			for(var i in style){
				if(i in empty){ continue; }
				s[i] = style[i];
			}
		}
		// set classes
		if(arguments.length > 2 && className){
			m.className = className;
		}
		// take a measure
		m.innerHTML = text;
		var box = DOMGeom.position(m);
		// position doesn't report right (reports 1, since parent is 1)
		// So we have to look at the scrollWidth to get the real width
		// Height is right.
		box.w = m.parentNode.scrollWidth;
		return box;
	};

	//	determine the scrollbar sizes on load.
	var scroll={ w:16, h:16 };
	dhm.getScrollbar=function(){ return { w:scroll.w, h:scroll.h }; };

	dhm._fontResizeNode = null;

	dhm.initOnFontResize = function(interval){
		var f = dhm._fontResizeNode = Window.doc.createElement("iframe");
		var fs = f.style;
		fs.position = "absolute";
		fs.width = "5em";
		fs.height = "10em";
		fs.top = "-10000px";
		fs.display = "none";
		if(has("ie")){
			f.onreadystatechange = function(){
				if(f.contentWindow.document.readyState == "complete"){
					f.onresize = f.contentWindow.parent[dojox._scopeName].html.metrics._fontresize;
				}
			};
		}else{
			f.onload = function(){
				f.contentWindow.onresize = f.contentWindow.parent[dojox._scopeName].html.metrics._fontresize;
			};
		}
		//The script tag is to work around a known firebug race condition.  See comments in bug #9046
		f.setAttribute("src", "javascript:'<html><head><script>if(\"loadFirebugConsole\" in window){window.loadFirebugConsole();}</script></head><body></body></html>'");
		Window.body().appendChild(f);
		dhm.initOnFontResize = function(){};
	};

	dhm.onFontResize = function(){};
	dhm._fontresize = function(){
		dhm.onFontResize();
	};

	UnloadUtil.addOnUnload(function(){
		// destroy our font resize iframe if we have one
		var f = dhm._fontResizeNode;
		if(f){
			if(has("ie") && f.onresize){
				f.onresize = null;
			}else if(f.contentWindow && f.contentWindow.onresize){
				f.contentWindow.onresize = null;
			}
			dhm._fontResizeNode = null;
		}
	});

	ready(function(){
		// getScrollbar metrics node
		try{
			var n=Window.doc.createElement("div");
			n.style.cssText = "top:0;left:0;width:100px;height:100px;overflow:scroll;position:absolute;visibility:hidden;";
			Window.body().appendChild(n);
			scroll.w = n.offsetWidth - n.clientWidth;
			scroll.h = n.offsetHeight - n.clientHeight;
			Window.body().removeChild(n);
			//console.log("Scroll bar dimensions: ", scroll);
			delete n;
		}catch(e){}

		// text size poll setup
		if("fontSizeWatch" in kernel.config && !!kernel.config.fontSizeWatch){
			dhm.initOnFontResize();
		}
	});
	return dhm;
});
},
'davinci/model/Comment':function(){
/**
 * @class davinci.model.Comment
 * @extends davinci.model.Model
 * @constructor
 */
define([
	"dojo/_base/declare",
	"davinci/model/Model"
], function(declare, Model) {

return declare("davinci.model.Comment", Model, {

	constructor: function() {
		this.elementType = "Comment";
		this.nosemicolon = true;
	},

	addComment: function(type, start, stop, text) {
		if (this.comments == null) {
			this.comments = [];
		}
		this.comments[this.comments.length] = {
				commentType:type,
				start:start,
				stop:stop,
				s:text
		};
	},

	appendComment: function(text) {
		var comment = this.comments[this.comments.length-1];
		comment.s += text;
		comment.stop += text.length;
	},

	getText: function (context) {
		var s="";
		for(var i = 0; i<this.comments.length; i++) {
			if (this.comments[i].commentType == "line") {
				s += "//" + this.comments[i].s + "\n";
			} else if (this.comments[i].commentType == "block") {
				s += "/*" + this.comments[i].s + "*/\n";
			}	
		}
		return s;
	}

});
});

},
'url:davinci/ve/input/templates/MultiFieldTableRowSmartInput.html':"<tr>\n\t<td class=\"MultiFieldSmartInput_SmartInput_label\" >\n\t\t{label}\n\t</td>\n\t<td>\n\t\t<div class=\"MultiFieldSmartInput_SmartInput_value\">\n\t\t\t<input type=\"text\" name=\"{textboxId}\"  data-dojo-type=\"{textboxType}\" data-dojo-props=\"trim:true\" value=\"{textboxValue}\" id=\"{textboxId}\">\n\t    </div>\n    </td>\n    <td class=\"MultiFieldSmartInput_SmartInput_checkbox\">\n    \t<div id=\"{checkboxDivId}\">\n    \t\t<input id=\"{checkboxId}\" name=\"{checkboxId}\" data-dojo-type=\"dijit/form/CheckBox\" {checked} />\n\t\t\t<label for=\"{checkboxId}\">html</label>\n    \t</div>\n\t</td>\n</tr>\n\n",
'davinci/html/HTMLItem':function(){
/**  
 * @class davinci.html.HTMLItem
 * @constructor 
 * @extends davinci.model.Model
 */
define([
	"dojo/_base/declare",
	"davinci/html/HTMLModel"
], function(declare, HTMLModel) {

return declare("davinci.html.HTMLItem", HTMLModel, {

	constructor: function() {
		this.elementType = "HTMLItem"; 
	},

	getLabel: function() {
		return this.getText({indent: 0});
	},

	onChange: function(arg) {
		// called when the model changes
		//debugger;
		if (this.parent) {
			if (arg) {
				this.parent.onChange(arg);
			}
		}
	},

	_addWS: function(lines, indent) {
		lines = lines || 0;
		indent = indent || 0;
		var res = [];
		for (var i=0; i<lines; i++) {
			res.push("\n");
		}
		res.push("                                          ".substring(0, indent));
		return res.join("");
	},

	close: function() {
		for(var i = 0; i<this.children.length; i++) {
			this.children[i].close();
		}
	},

	getID: function() {
		return this.parent.getID() + ":" + this.startOffset + ":" + this.getLabel();
	},

	getHTMLFile: function() { 
		var element = this;
		while (element && element.elementType != "HTMLFile") {
			element = element.parent;
		}
		return element;
	}

});
});



},
'davinci/ve/ObjectWidget':function(){
define([
	"dojo/_base/declare",
	"dojo/dom-attr",
	"./_Widget"
], function(
	declare,
	domAttr,
	_Widget
) {

return declare("davinci.ve.ObjectWidget", _Widget, {

	isObjectWidget: true,

	constructor: function (params,node,dijitWidget,metadata,srcElement) {
		if (typeof dijitWidget === 'string') {
			domAttr.set(node, 'data-dojo-type', dijitWidget);
			if (srcElement) {
				srcElement.addAttribute('data-dojo-type', dijitWidget);
			}
		}
	},

	postCreate: function() {
		var id = this._params.jsId,
			dj = require("davinci/ve/widget")._dojo(this.domNode),
			object;
		if (id) {
			domAttr.set(this.domNode, 'jsId', id);
			var type = this.getObjectType();
			if (type) {
				var c = dj.getObject(type.replace(/\//g, ".")); // FIXME: assumes global object definition matching module id
				if (c) {
					if (c.markupFactory) {
						object = c.markupFactory(this._params, this.domNode, c);
					} else if(c.prototype && c.prototype.markupFactory) {
						object = c.prototype.markupFactory(this._params, this.domNode, c);
					} else {
						object = new c(this._params, this.domNode);
					}
					if (object) {
						object._edit_object_id = id;
						dj.setObject(id, object);
					}
				}
			}
		} else {
			id = this.getObjectId();
			if (id) {
				object = dj.getObject(id);
				if (object) {
					object._edit_object_id = id;
				}
			}
		}
	},

	getObjectType: function() {
		var node = this.domNode,
			type = domAttr.get(node, 'data-dojo-type') || domAttr.get(node, 'dojoType');
		type = type.replace(/\./g, "/");
		return type;
	},

	getObjectId: function() {
		return domAttr.get(this.domNode, 'jsId');
	},

	_getChildren: function() {
		return [];
	}

});

});

},
'davinci/model/parser/Tokenizer':function(){
define([
	"dojo/_base/declare",
	"davinci/js/JSExpression"
], function(declare, JSExpression) {

return {

	/* String streams are the things fed to parsers (which can feed them
	 * to a tokenizer if they want). They provide peek and next methods
	 * for looking at the current character (next 'consumes' this
	 * character, peek does not), and a get method for retrieving all the
	 * text that was consumed since the last time get was called.
	 *
	 * An easy mistake to make is to let a StopIteration exception finish
	 * the token stream while there are still characters pending in the
	 * string stream (hitting the end of the buffer while parsing a
	 * token). To make it easier to detect such errors, the stringstreams
	 * throw an exception when this happens.
	 */

//	Make a stringstream stream out of an iterator that returns strings.
//	This is applied to the result of traverseDOM (see codemirror.js),
//	and the resulting stream is fed to the parser.
	stringStream: function(source) {
		// String that's currently being iterated over.
		var current = "";
		// Position in that string.
		var pos = 0;
		var offset=0;
		// Accumulator for strings that have been iterated over but not
		// get()-ed yet.
		var accum = "";
		// Make sure there are more characters ready, or throw
		// StopIteration.
		function ensureChars() {
			while (pos == current.length) {
				accum += current;
				current = ""; // In case source.next() throws
				pos = 0;
				try {
					current = source.next();
				} catch (e) {
					if (e != StopIteration) { 
						throw e; 
					} else { return false; }
				}
			}
			return true;
		}

		return {
			// peek: -> character
			// Return the next character in the stream.
			peek: function() {
				if (!ensureChars()) return null;
				return current.charAt(pos);
			},

			// next: -> character
			// Get the next character, throw StopIteration if at end, check
			// for unused content.
			next: function() {
				if (!ensureChars()) {
					if (accum.length > 0)
						throw "End of stringstream reached without emptying buffer ('" + accum + "').";
					else
						throw StopIteration;
				}
				return current.charAt(pos++);
			},

			// get(): -> string
			// Return the characters iterated over since the last call to
			// .get().
			get: function() {
				var temp = accum;
				accum = "";
				if (pos > 0){
					temp += current.slice(0, pos);
					current = current.slice(pos);
					pos = 0;
				}
				offset+=temp.length;
				return temp;
			},

			getOffset: function()  {
				return offset;
			},

			// Push a string back into the stream.
			push: function(str) {
				current = current.slice(0, pos) + str + current.slice(pos);
				offset-=str.length;
			},

			lookAhead: function(str, consume, skipSpaces, caseInsensitive) {
				function cased(str) { return caseInsensitive ? str.toLowerCase() : str; }
				str = cased(str);
				var found = false;

				var _accum = accum, _pos = pos;
				if (skipSpaces) {
					this.nextWhileMatches(/[\s\u00a0]/);
				}

				while (true) {
					var end = pos + str.length, left = current.length - pos;
					if (end <= current.length) {
						found = str == cased(current.slice(pos, end));
						pos = end;
						break;
					} else if (str.slice(0, left) == cased(current.slice(pos))) {
						accum += current; current = "";
						try {current = source.next();}
						catch (e) {if (e != StopIteration) throw e; break;}
						pos = 0;
						str = str.slice(left);
					} else {
						break;
					}
				}

				if (!(found && consume)) {
					current = accum.slice(_accum.length) + current;
					pos = _pos;
					accum = _accum;
				}

				return found;
			},

			// Wont't match past end of line.
			lookAheadRegex: function(regex, consume) {
				if (regex.source.charAt(0) != "^") {
					throw new Error("Regexps passed to lookAheadRegex must start with ^");
				}
				// Fetch the rest of the line
				while (current.indexOf("\n", pos) == -1) {
					try { 
						current += source.next(); 
					}catch (e) { 
						if (e != StopIteration) { 
							throw e; break; 
						} 
					}
				}
				var matched = current.slice(pos).match(regex);
				if (matched && consume) {
					pos += matched[0].length;
				}
				return matched;
			},

			// Utils built on top of the above
			// more: -> boolean
			// Produce true if the stream isn't empty.
			more: function() {
				return this.peek() !== null;
			},

			applies: function(test) {
				var next = this.peek();
				return (next !== null && test(next));
			},

			nextWhile: function(test) {
				var next;
				while ((next = this.peek()) !== null && test(next))
					this.next();
			},

			matches: function(re) {
				var next = this.peek();
				return (next !== null && re.test(next));
			},

			nextWhileMatches: function(re) {
				var next;
				while ((next = this.peek()) !== null && re.test(next))
					this.next();
			},

			equals: function(ch) {
				return ch === this.peek();
			},

			endOfLine: function() {
				var next = this.peek();
				return next == null || next == "\n";
			}
		};
	},

//	A framework for simple tokenizers. Takes care of newlines and
//	white-space, and of getting the text from the source stream into
//	the token object. A state is a function of two arguments -- a
//	string stream and a setState function. The second can be used to
//	change the tokenizer's state, and can be ignored for stateless
//	tokenizers. This function should advance the stream over a token
//	and return a string or object containing information about the next
//	token, or null to pass and have the (new) state be called to finish
//	the token. When a string is given, it is wrapped in a {style, type}
//	object. In the resulting object, the characters consumed are stored
//	under the content property. Any whitespace following them is also
//	automatically consumed, and added to the value property. (Thus,
//	content is the actual meaningful part of the token, while value
//	contains all the text it spans.)

	tokenizer: function(source, state) {
//		Newlines are always a separate token.
		function isWhiteSpace(ch) {
			// The messy regexp is because IE's regexp matcher is of the
			// opinion that non-breaking spaces are no whitespace.
			return ch != "\n" && /^[\s\u00a0]*$/.test(ch);
		}

		var tokenizer = {
				state: state,

				take: function(type) {
					if (typeof(type) == "string")
						type = {style: type, type: type};

					type.offset=source.getOffset();
					type.content = (type.content || "") + source.get();
//					console.log("offset="+type.offset+", content= "+type.content);   
					if (!/\n$/.test(type.content))
						source.nextWhile(isWhiteSpace);
					type.value = type.content + source.get();
					return type;
				},

				next: function () {
					if (!source.more()) throw StopIteration;

					var type;
					if (source.equals("\n")) {
						source.next();
						return this.take("whitespace");
					}

					if (source.applies(isWhiteSpace)) {
						type = "whitespace";
					} else {
						while (!type) {
							type = this.state(source, function(s) { tokenizer.state = s; });
						}
					}
					return this.take(type);
				}
		};
		return tokenizer;
	}

};

});
},
'dijit/form/_ComboBoxMenuMixin':function(){
define([
	"dojo/_base/array", // array.forEach
	"dojo/_base/declare", // declare
	"dojo/dom-attr", // domAttr.set
	"dojo/i18n", // i18n.getLocalization
	"dojo/i18n!./nls/ComboBox"
], function(array, declare, domAttr, i18n){

// module:
//		dijit/form/_ComboBoxMenuMixin

return declare( "dijit.form._ComboBoxMenuMixin", null, {
	// summary:
	//		Focus-less menu for internal use in `dijit/form/ComboBox`
	// tags:
	//		private

	// _messages: Object
	//		Holds "next" and "previous" text for paging buttons on drop down
	_messages: null,

	postMixInProperties: function(){
		this.inherited(arguments);
		this._messages = i18n.getLocalization("dijit.form", "ComboBox", this.lang);
	},

	buildRendering: function(){
		this.inherited(arguments);

		// fill in template with i18n messages
		this.previousButton.innerHTML = this._messages["previousMessage"];
		this.nextButton.innerHTML = this._messages["nextMessage"];
	},

	_setValueAttr: function(/*Object*/ value){
		this.value = value;
		this.onChange(value);
	},

	onClick: function(/*DomNode*/ node){
		if(node == this.previousButton){
			this._setSelectedAttr(null);
			this.onPage(-1);
		}else if(node == this.nextButton){
			this._setSelectedAttr(null);
			this.onPage(1);
		}else{
			this.onChange(node);
		}
	},

	// stubs
	onChange: function(/*Number*/ /*===== direction =====*/){
		// summary:
		//		Notifies ComboBox/FilteringSelect that user selected an option.
		// tags:
		//		callback
	},

	onPage: function(/*Number*/ /*===== direction =====*/){
		// summary:
		//		Notifies ComboBox/FilteringSelect that user clicked to advance to next/previous page.
		// tags:
		//		callback
	},

	onClose: function(){
		// summary:
		//		Callback from dijit.popup code to this widget, notifying it that it closed
		// tags:
		//		private
		this._setSelectedAttr(null);
	},

	_createOption: function(/*Object*/ item, labelFunc){
		// summary:
		//		Creates an option to appear on the popup menu subclassed by
		//		`dijit/form/FilteringSelect`.

		var menuitem = this._createMenuItem();
		var labelObject = labelFunc(item);
		if(labelObject.html){
			menuitem.innerHTML = labelObject.label;
		}else{
			menuitem.appendChild(
				menuitem.ownerDocument.createTextNode(labelObject.label)
			);
		}
		// #3250: in blank options, assign a normal height
		if(menuitem.innerHTML == ""){
			menuitem.innerHTML = "&#160;";	// &nbsp;
		}

		// update menuitem.dir if BidiSupport was required
		this.applyTextDir(menuitem, (menuitem.innerText || menuitem.textContent || ""));

		return menuitem;
	},

	createOptions: function(results, options, labelFunc){
		// summary:
		//		Fills in the items in the drop down list
		// results:
		//		Array of items
		// options:
		//		The options to the query function of the store
		//
		// labelFunc:
		//		Function to produce a label in the drop down list from a dojo.data item

		this.items = results;

		// display "Previous . . ." button
		this.previousButton.style.display = (options.start == 0) ? "none" : "";
		domAttr.set(this.previousButton, "id", this.id + "_prev");
		// create options using _createOption function defined by parent
		// ComboBox (or FilteringSelect) class
		// #2309:
		//		iterate over cache nondestructively
		array.forEach(results, function(item, i){
			var menuitem = this._createOption(item, labelFunc);
			menuitem.setAttribute("item", i);	// index to this.items; use indirection to avoid mem leak
			domAttr.set(menuitem, "id", this.id + i);
			this.nextButton.parentNode.insertBefore(menuitem, this.nextButton);
		}, this);
		// display "Next . . ." button
		var displayMore = false;
		// Try to determine if we should show 'more'...
		if(results.total && !results.total.then && results.total != -1){
			if((options.start + options.count) < results.total){
				displayMore = true;
			}else if((options.start + options.count) > results.total && options.count == results.length){
				// Weird return from a data store, where a start + count > maxOptions
				// implies maxOptions isn't really valid and we have to go into faking it.
				// And more or less assume more if count == results.length
				displayMore = true;
			}
		}else if(options.count == results.length){
			//Don't know the size, so we do the best we can based off count alone.
			//So, if we have an exact match to count, assume more.
			displayMore = true;
		}

		this.nextButton.style.display = displayMore ? "" : "none";
		domAttr.set(this.nextButton,"id", this.id + "_next");
	},

	clearResultList: function(){
		// summary:
		//		Clears the entries in the drop down list, but of course keeps the previous and next buttons.
		var container = this.containerNode;
		while(container.childNodes.length > 2){
			container.removeChild(container.childNodes[container.childNodes.length-2]);
		}
		this._setSelectedAttr(null);
	},

	highlightFirstOption: function(){
		// summary:
		//		Highlight the first real item in the list (not Previous Choices).
		this.selectFirstNode();
	},

	highlightLastOption: function(){
		// summary:
		//		Highlight the last real item in the list (not More Choices).
		this.selectLastNode();
	},

	selectFirstNode: function(){
		this.inherited(arguments);
		if(this.getHighlightedOption() == this.previousButton){
			this.selectNextNode();
		}
	},

	selectLastNode: function(){
		this.inherited(arguments);
		if(this.getHighlightedOption() == this.nextButton){
			this.selectPreviousNode();
		}
	},

	getHighlightedOption: function(){
		return this.selected;
	}
});

});

},
'dijit/form/_SearchMixin':function(){
define([
	"dojo/data/util/filter", // patternToRegExp
	"dojo/_base/declare", // declare
	"dojo/_base/event", // event.stop
	"dojo/keys", // keys
	"dojo/_base/lang", // lang.clone lang.hitch
	"dojo/query", // query
	"dojo/sniff", // has("ie")
	"dojo/string", // string.substitute
	"dojo/when",
	"../registry"	// registry.byId
], function(filter, declare, event, keys, lang, query, has, string, when, registry){

	// module:
	//		dijit/form/_SearchMixin


	return declare("dijit.form._SearchMixin", null, {
		// summary:
		//		A mixin that implements the base functionality to search a store based upon user-entered text such as
		//		with `dijit/form/ComboBox` or `dijit/form/FilteringSelect`
		// tags:
		//		protected

		// pageSize: Integer
		//		Argument to data provider.
		//		Specifies maximum number of search results to return per query
		pageSize: Infinity,

		// store: [const] dojo/store/api/Store
		//		Reference to data provider object used by this ComboBox.
		//		The store must accept an object hash of properties for its query. See `query` and `queryExpr` for details.
		store: null,

		// fetchProperties: Object
		//		Mixin to the store's fetch.
		//		For example, to set the sort order of the ComboBox menu, pass:
		//	|	{ sort: [{attribute:"name",descending: true}] }
		//		To override the default queryOptions so that deep=false, do:
		//	|	{ queryOptions: {ignoreCase: true, deep: false} }
		fetchProperties:{},

		// query: Object
		//		A query that can be passed to `store` to initially filter the items.
		//		ComboBox overwrites any reference to the `searchAttr` and sets it to the `queryExpr` with the user's input substituted.
		query: {},

		// searchDelay: Integer
		//		Delay in milliseconds between when user types something and we start
		//		searching based on that value
		searchDelay: 200,

		// searchAttr: String
		//		Search for items in the data store where this attribute (in the item)
		//		matches what the user typed
		searchAttr: "name",

		// queryExpr: String
		//		This specifies what query is sent to the data store,
		//		based on what the user has typed.  Changing this expression will modify
		//		whether the results are only exact matches, a "starting with" match,
		//		etc.
		//		dojo.data query expression pattern.
		//		`${0}` will be substituted for the user text.
		//		`*` is used for wildcards.
		//		`${0}*` means "starts with", `*${0}*` means "contains", `${0}` means "is"
		queryExpr: "${0}*",

		// ignoreCase: Boolean
		//		Set true if the query should ignore case when matching possible items
		ignoreCase: true,

		_abortQuery: function(){
			// stop in-progress query
			if(this.searchTimer){
				this.searchTimer = this.searchTimer.remove();
			}
			if(this._queryDeferHandle){
				this._queryDeferHandle = this._queryDeferHandle.remove();
			}
			if(this._fetchHandle){
				if(this._fetchHandle.abort){
					this._cancelingQuery = true;
					this._fetchHandle.abort();
					this._cancelingQuery = false;
				}
				if(this._fetchHandle.cancel){
					this._cancelingQuery = true;
					this._fetchHandle.cancel();
					this._cancelingQuery = false;
				}
				this._fetchHandle = null;
			}
		},

		_processInput: function(/*Event*/ evt){
			// summary:
			//		Handles input (keyboard/paste) events
			if(this.disabled || this.readOnly){ return; }
			var key = evt.charOrCode;

			// except for cutting/pasting case - ctrl + x/v
			if(evt.altKey || ((evt.ctrlKey || evt.metaKey) && (key != 'x' && key != 'v')) || key == keys.SHIFT){
				return; // throw out weird key combinations and spurious events
			}

			var doSearch = false;
			this._prev_key_backspace = false;

			switch(key){
				case keys.DELETE:
				case keys.BACKSPACE:
					this._prev_key_backspace = true;
					this._maskValidSubsetError = true;
					doSearch = true;
					break;

				default:
					// Non char keys (F1-F12 etc..) shouldn't start a search..
					// Ascii characters and IME input (Chinese, Japanese etc.) should.
					//IME input produces keycode == 229.
					doSearch = typeof key == 'string' || key == 229;
			}
			if(doSearch){
				// need to wait a tad before start search so that the event
				// bubbles through DOM and we have value visible
				if(!this.store){
					this.onSearch();
				}else{
					this.searchTimer = this.defer("_startSearchFromInput", 1);
				}
			}
		},

		onSearch: function(/*===== results, query, options =====*/){
			// summary:
			//		Callback when a search completes.
			//
			// results: Object
			//		An array of items from the originating _SearchMixin's store.
			//
			// query: Object
			//		A copy of the originating _SearchMixin's query property.
			//
			// options: Object
			//		The additional parameters sent to the originating _SearchMixin's store, including: start, count, queryOptions.
			//
			// tags:
			//		callback
		},

		_startSearchFromInput: function(){
			this._startSearch(this.focusNode.value.replace(/([\\\*\?])/g, "\\$1"));
		},

		_startSearch: function(/*String*/ text){
			// summary:
			//		Starts a search for elements matching text (text=="" means to return all items),
			//		and calls onSearch(...) when the search completes, to display the results.

			this._abortQuery();
			var
				_this = this,
				// Setup parameters to be passed to store.query().
				// Create a new query to prevent accidentally querying for a hidden
				// value from FilteringSelect's keyField
				query = lang.clone(this.query), // #5970
				options = {
					start: 0,
					count: this.pageSize,
					queryOptions: {		// remove for 2.0
						ignoreCase: this.ignoreCase,
						deep: true
					}
				},
				qs = string.substitute(this.queryExpr, [text]),
				q,
				startQuery = function(){
					var resPromise = _this._fetchHandle = _this.store.query(query, options);
					if(_this.disabled || _this.readOnly || (q !== _this._lastQuery)){
						return;
					} // avoid getting unwanted notify
					when(resPromise, function(res){
						_this._fetchHandle = null;
						if(!_this.disabled && !_this.readOnly && (q === _this._lastQuery)){ // avoid getting unwanted notify
							when(resPromise.total, function(total){
								res.total = total;
								var pageSize = _this.pageSize;
								if(isNaN(pageSize) || pageSize > res.total){ pageSize = res.total; }
								// Setup method to fetching the next page of results
								res.nextPage = function(direction){
									//	tell callback the direction of the paging so the screen
									//	reader knows which menu option to shout
									options.direction = direction = direction !== false;
									options.count = pageSize;
									if(direction){
										options.start += res.length;
										if(options.start >= res.total){
											options.count = 0;
										}
									}else{
										options.start -= pageSize;
										if(options.start < 0){
											options.count = Math.max(pageSize + options.start, 0);
											options.start = 0;
										}
									}
									if(options.count <= 0){
										res.length = 0;
										_this.onSearch(res, query, options);
									}else{
										startQuery();
									}
								};
								_this.onSearch(res, query, options);
							});
						}
					}, function(err){
						_this._fetchHandle = null;
						if(!_this._cancelingQuery){	// don't treat canceled query as an error
							console.error(_this.declaredClass + ' ' + err.toString());
						}
					});
				};

			lang.mixin(options, this.fetchProperties);

			// Generate query
			if(this.store._oldAPI){
				// remove this branch for 2.0
				q = qs;
			}else{
				// Query on searchAttr is a regex for benefit of dojo/store/Memory,
				// but with a toString() method to help dojo/store/JsonRest.
				// Search string like "Co*" converted to regex like /^Co.*$/i.
				q = filter.patternToRegExp(qs, this.ignoreCase);
				q.toString = function(){ return qs; };
			}

			// set _lastQuery, *then* start the timeout
			// otherwise, if the user types and the last query returns before the timeout,
			// _lastQuery won't be set and their input gets rewritten
			this._lastQuery = query[this.searchAttr] = q;
			this._queryDeferHandle = this.defer(startQuery, this.searchDelay);
		},

		//////////// INITIALIZATION METHODS ///////////////////////////////////////

		constructor: function(){
			this.query={};
			this.fetchProperties={};
		},

		postMixInProperties: function(){
			if(!this.store){
				var list = this.list;
				if(list){
					this.store = registry.byId(list);
				}
			}
			this.inherited(arguments);
		}
	});
});

},
'dojox/grid/_RowSelector':function(){
define([
	"dojo/_base/declare",
	"./_View"
], function(declare, _View){

return declare('dojox.grid._RowSelector', _View, {
	// summary:
	//	Custom grid view. If used in a grid structure, provides a small selectable region for grid rows.
	defaultWidth: "2em",
	noscroll: true,
	padBorderWidth: 2,
	buildRendering: function(){
		this.inherited('buildRendering', arguments);
		this.scrollboxNode.style.overflow = "hidden";
		this.headerNode.style.visibility = "hidden";
	},
	getWidth: function(){
		return this.viewWidth || this.defaultWidth;
	},
	buildRowContent: function(inRowIndex, inRowNode){
		var w = this.contentWidth || 0;
		inRowNode.innerHTML = '<table class="dojoxGridRowbarTable" style="width:' + w + 'px;height:1px;" border="0" cellspacing="0" cellpadding="0" role="presentation"><tr><td class="dojoxGridRowbarInner">&nbsp;</td></tr></table>';
	},
	renderHeader: function(){
	},
	updateRow: function(){
	},
	resize: function(){
		this.adaptHeight();
	},
	adaptWidth: function(){
		// Only calculate this here - rather than every call to buildRowContent
		if(!("contentWidth" in this) && this.contentNode && this.contentNode.offsetWidth > 0){
			this.contentWidth = this.contentNode.offsetWidth - this.padBorderWidth;
		}
	},
	// styling
	doStyleRowNode: function(inRowIndex, inRowNode){
		var n = [ "dojoxGridRowbar dojoxGridNonNormalizedCell" ];
		if(this.grid.rows.isOver(inRowIndex)){
			n.push("dojoxGridRowbarOver");
		}
		if(this.grid.selection.isSelected(inRowIndex)){
			n.push("dojoxGridRowbarSelected");
		}
		inRowNode.className = n.join(" ");
	},
	// event handlers
	domouseover: function(e){
		this.grid.onMouseOverRow(e);
	},
	domouseout: function(e){
		if(!this.isIntraRowEvent(e)){
			this.grid.onMouseOutRow(e);
		}
	}
});
});
},
'davinci/ve/GenericWidget':function(){
define([
        "dojo/_base/declare",
        "./_Widget"
//        "./widget"
], function(declare, _Widget) {

return declare("davinci.ve.GenericWidget", _Widget, {
	isGenericWidget: true,
	constructor: function (params,node,type,metadata,srcElement) {
		dojo.attr(node, "dvwidget", type);
		if(srcElement) {
			srcElement.addAttribute("dvwidget", type);
		}
	},
	buildRendering: function() {
//		if(this.srcNodeRef) {
//			this.domNode = this.srcNodeRef;
//		}else{
//			this.domNode = dojo.doc.createElement("div");
//		}
		this.containerNode = this.domNode; // for getDescendants()
		if(this._params) {
			for(var name in this._params) {
				this.domNode.setAttribute(name, this._params[name]);
			}
			this._params = undefined;
		}
/*REMOVE THIS
		try{
			// this won't work on an SVG element in FireFox
			dojo.addClass(this.domNode, "HtmlWidget");
		}catch(e) {
			console.debug("Error in davinci.ve.helpers.loadHtmlWidget.buildRendering: "+e);
		}
*/
	},
	_getChildrenData: function(options) {
		var childrenData = [];
		var childNodes = this.domNode.childNodes;
		for(var i = 0; i < childNodes.length; i++) {
			var n = childNodes[i];
			var d;
			switch(n.nodeType) {
			case 1: // Element
				var w = require("davinci/ve/widget").byNode(n);
				if(w) {
					d = w.getData( options);
				}
				break;
			case 3: // Text
				d = n.nodeValue.trim();
				if(d && options.serialize) {
					d = davinci.html.escapeXml(d);
				}
				break;
			case 8: // Comment
				d = "<!--" + n.nodeValue + "-->";
				break;
			}
			if(d) {
				childrenData.push(d);
			}
		}
		if(childrenData.length === 0) {
			return undefined;
		}
		return childrenData;
	},

	setProperties: function(properties) {
		var node = this.domNode;

		for(var name in properties) {
			if (name === 'style') { // needed for position absolute
				dojo.style(node, properties[name]);
			} else {
				if(!properties[name]) {
					node.removeAttribute(name);
				} else {
					node[name]= properties[name];
		//			dojo.attr(node,name,properties[name]);
				}
			}

		}
		this.inherited(arguments);
	},

	_attr: function(name,value) {
		if (arguments.length>1) {
			this.domNode.setAttribute(name, value);
		} else {
			return this.domNode.getAttribute(name);
		}
	},

	getTagName: function() {
		return this.domNode.nodeName.toLowerCase();
	}
});

});

},
'url:dijit/form/templates/DropDownButton.html':"<span class=\"dijit dijitReset dijitInline\"\n\t><span class='dijitReset dijitInline dijitButtonNode'\n\t\tdata-dojo-attach-event=\"ondijitclick:_onClick\" data-dojo-attach-point=\"_buttonNode\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"focusNode,titleNode,_arrowWrapperNode\"\n\t\t\trole=\"button\" aria-haspopup=\"true\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\"\n\t\t\t\tdata-dojo-attach-point=\"iconNode\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode,_popupStateNode\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonInner\"></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonChar\">&#9660;</span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\" tabIndex=\"-1\"\n\t\tdata-dojo-attach-point=\"valueNode\" role=\"presentation\"\n/></span>\n",
'dojo/dnd/Manager':function(){
define([
	"../_base/array",  "../_base/declare", "../_base/event", "../_base/lang", "../_base/window",
	"../dom-class", "../Evented", "../has", "../keys", "../on", "../topic", "../touch",
	"./common", "./autoscroll", "./Avatar"
], function(array, declare, event, lang, win, domClass, Evented, has, keys, on, topic, touch,
	dnd, autoscroll, Avatar){

// module:
//		dojo/dnd/Manager

var Manager = declare("dojo.dnd.Manager", [Evented], {
	// summary:
	//		the manager of DnD operations (usually a singleton)
	constructor: function(){
		this.avatar  = null;
		this.source = null;
		this.nodes = [];
		this.copy  = true;
		this.target = null;
		this.canDropFlag = false;
		this.events = [];
	},

	// avatar's offset from the mouse
	OFFSET_X: has("touch") ? 0 : 16,
	OFFSET_Y: has("touch") ? -64 : 16,

	// methods
	overSource: function(source){
		// summary:
		//		called when a source detected a mouse-over condition
		// source: Object
		//		the reporter
		if(this.avatar){
			this.target = (source && source.targetState != "Disabled") ? source : null;
			this.canDropFlag = Boolean(this.target);
			this.avatar.update();
		}
		topic.publish("/dnd/source/over", source);
	},
	outSource: function(source){
		// summary:
		//		called when a source detected a mouse-out condition
		// source: Object
		//		the reporter
		if(this.avatar){
			if(this.target == source){
				this.target = null;
				this.canDropFlag = false;
				this.avatar.update();
				topic.publish("/dnd/source/over", null);
			}
		}else{
			topic.publish("/dnd/source/over", null);
		}
	},
	startDrag: function(source, nodes, copy){
		// summary:
		//		called to initiate the DnD operation
		// source: Object
		//		the source which provides items
		// nodes: Array
		//		the list of transferred items
		// copy: Boolean
		//		copy items, if true, move items otherwise

		// Tell autoscroll that a drag is starting
		autoscroll.autoScrollStart(win.doc);

		this.source = source;
		this.nodes  = nodes;
		this.copy   = Boolean(copy); // normalizing to true boolean
		this.avatar = this.makeAvatar();
		win.body().appendChild(this.avatar.node);
		topic.publish("/dnd/start", source, nodes, this.copy);
		this.events = [
			on(win.doc, touch.move, lang.hitch(this, "onMouseMove")),
			on(win.doc, touch.release,   lang.hitch(this, "onMouseUp")),
			on(win.doc, "keydown",   lang.hitch(this, "onKeyDown")),
			on(win.doc, "keyup",     lang.hitch(this, "onKeyUp")),
			// cancel text selection and text dragging
			on(win.doc, "dragstart",   event.stop),
			on(win.body(), "selectstart", event.stop)
		];
		var c = "dojoDnd" + (copy ? "Copy" : "Move");
		domClass.add(win.body(), c);
	},
	canDrop: function(flag){
		// summary:
		//		called to notify if the current target can accept items
		var canDropFlag = Boolean(this.target && flag);
		if(this.canDropFlag != canDropFlag){
			this.canDropFlag = canDropFlag;
			this.avatar.update();
		}
	},
	stopDrag: function(){
		// summary:
		//		stop the DnD in progress
		domClass.remove(win.body(), ["dojoDndCopy", "dojoDndMove"]);
		array.forEach(this.events, function(handle){ handle.remove(); });
		this.events = [];
		this.avatar.destroy();
		this.avatar = null;
		this.source = this.target = null;
		this.nodes = [];
	},
	makeAvatar: function(){
		// summary:
		//		makes the avatar; it is separate to be overwritten dynamically, if needed
		return new Avatar(this);
	},
	updateAvatar: function(){
		// summary:
		//		updates the avatar; it is separate to be overwritten dynamically, if needed
		this.avatar.update();
	},

	// mouse event processors
	onMouseMove: function(e){
		// summary:
		//		event processor for onmousemove
		// e: Event
		//		mouse event
		var a = this.avatar;
		if(a){
			autoscroll.autoScrollNodes(e);
			//autoscroll.autoScroll(e);
			var s = a.node.style;
			s.left = (e.pageX + this.OFFSET_X) + "px";
			s.top  = (e.pageY + this.OFFSET_Y) + "px";
			var copy = Boolean(this.source.copyState(dnd.getCopyKeyState(e)));
			if(this.copy != copy){
				this._setCopyStatus(copy);
			}
		}
		if(has("touch")){
			// Prevent page from scrolling so that user can drag instead.
			e.preventDefault();
		}
	},
	onMouseUp: function(e){
		// summary:
		//		event processor for onmouseup
		// e: Event
		//		mouse event
		if(this.avatar){
			if(this.target && this.canDropFlag){
				var copy = Boolean(this.source.copyState(dnd.getCopyKeyState(e)));
				topic.publish("/dnd/drop/before", this.source, this.nodes, copy, this.target, e);
				topic.publish("/dnd/drop", this.source, this.nodes, copy, this.target, e);
			}else{
				topic.publish("/dnd/cancel");
			}
			this.stopDrag();
		}
	},

	// keyboard event processors
	onKeyDown: function(e){
		// summary:
		//		event processor for onkeydown:
		//		watching for CTRL for copy/move status, watching for ESCAPE to cancel the drag
		// e: Event
		//		keyboard event
		if(this.avatar){
			switch(e.keyCode){
				case keys.CTRL:
					var copy = Boolean(this.source.copyState(true));
					if(this.copy != copy){
						this._setCopyStatus(copy);
					}
					break;
				case keys.ESCAPE:
					topic.publish("/dnd/cancel");
					this.stopDrag();
					break;
			}
		}
	},
	onKeyUp: function(e){
		// summary:
		//		event processor for onkeyup, watching for CTRL for copy/move status
		// e: Event
		//		keyboard event
		if(this.avatar && e.keyCode == keys.CTRL){
			var copy = Boolean(this.source.copyState(false));
			if(this.copy != copy){
				this._setCopyStatus(copy);
			}
		}
	},

	// utilities
	_setCopyStatus: function(copy){
		// summary:
		//		changes the copy status
		// copy: Boolean
		//		the copy status
		this.copy = copy;
		this.source._markDndStatus(this.copy);
		this.updateAvatar();
		domClass.replace(win.body(),
			"dojoDnd" + (this.copy ? "Copy" : "Move"),
			"dojoDnd" + (this.copy ? "Move" : "Copy"));
	}
});

// dnd._manager:
//		The manager singleton variable. Can be overwritten if needed.
dnd._manager = null;

Manager.manager = dnd.manager = function(){
	// summary:
	//		Returns the current DnD manager.  Creates one if it is not created yet.
	if(!dnd._manager){
		dnd._manager = new Manager();
	}
	return dnd._manager;	// Object
};

return Manager;
});

},
'davinci/model/resource/File':function(){
  /**  
   * @class davinci.model.resource.File
     * @constructor 
     * @extends davinci.model.resource.Resource
   */
define([
	"dojo/_base/declare",
	"dojo/_base/xhr",
	"davinci/Runtime",
	"davinci/model/resource/Resource",
	"davinci/model/resource/Marker",
	"davinci/ve/utils/URLRewrite"
], function(declare, xhr, Runtime, Resource, Marker, URLRewrite) {

return declare("davinci.model.resource.File", Resource, {

	constructor: function(name,parent) {
		this.elementType = "File";
		this.name = name;
		this.parent = parent;
		this.markers = [];
		this.extension = name.substr(name.lastIndexOf('.') + 1);
	},

	// deprecated.  use extension property instead
	getExtension: function() {
		return this.extension;
	},

	clearMarkers: function() {
		this.markers = [];
	},

	addMarker: function(type,line,text) {
		this.markers.push(new Marker(this, type, line, text));
	},

	getMarkers: function(markerTypes) {
		var result=[];
		if (this.markers)
			for (var i=0; i<this.markers.length; i++)
			{
				var marker = this.markers[i];
				if (!markerTypes) {
					result.push(marker);
				} else if (typeof markerTypes == 'string') { 
					if (marker.type == markerTypes) {
						result.push(marker);
					}
				} else {
					dojo.forEach(markerTypes,function (type) {
						if (type == marker.type) {
							result.push(marker);
						}
					});
				}
			}
		return result;
	},

	setContents: function(content, isWorkingCopy){
		if (this.isNew && !isWorkingCopy) {
			this.isNew = false;
		}
		var workingCopyExtension = isWorkingCopy ? ".workingcopy" : "";
		var path = encodeURI(this.getPath() + workingCopyExtension);
		var promise = xhr.put({
			url: path,
			putData: content,
			handleAs: "text",
			contentType: "text/html"
		});
		promise.then(function(res){
			this.dirtyResource = isWorkingCopy;
			dojo.publish("/davinci/resource/resourceChanged", ["modified", this]);
			return this;
		}.bind(this), function(err){ 
			// more meaningful error message should be reported to user higher up the food chain...
			console.error("An error occurred: davinci.model.resource.File.prototype.setContents " + err + " : " + path);
			return err;
		});
		return promise;
	},

	// deprecated.  Use getContent instead.
	getContentSync: function(){
		return Runtime.serverJSONRequest({
			url: URLRewrite.encodeURI(this.getURL()),
			handleAs: "text",
			sync: true
		});
	},

	getContent: function() {
		return xhr.get({
			url: URLRewrite.encodeURI(this.getURL()),
			handleAs: "text"
		});
	},

	removeWorkingCopy: function() {
		Runtime.serverJSONRequest({
			url:"cmd/removeWorkingCopy",
			handleAs:"text",
			content:{path: this.getPath()},
			sync:true
		});
		if (this.isNew) {
			this.deleteResource(true);
		}
	}
   
});
});


},
'dijit/form/ToggleButton':function(){
define([
	"dojo/_base/declare", // declare
	"dojo/_base/kernel", // kernel.deprecated
	"./Button",
	"./_ToggleButtonMixin"
], function(declare, kernel, Button, _ToggleButtonMixin){

	// module:
	//		dijit/form/ToggleButton


	return declare("dijit.form.ToggleButton", [Button, _ToggleButtonMixin], {
		// summary:
		//		A templated button widget that can be in two states (checked or not).
		//		Can be base class for things like tabs or checkbox or radio buttons.

		baseClass: "dijitToggleButton",

		setChecked: function(/*Boolean*/ checked){
			// summary:
			//		Deprecated.  Use set('checked', true/false) instead.
			kernel.deprecated("setChecked("+checked+") is deprecated. Use set('checked',"+checked+") instead.", "", "2.0");
			this.set('checked', checked);
		}
	});
});

},
'davinci/html/CSSRule':function(){
/**
 * @class davinci.html.CSSRule
 * @constructor
 * @extends davinci.html.CSSElement
 */
define([
	"dojo/_base/declare",
	"davinci/html/CSSElement",
	"davinci/html/CSSParser",
	"davinci/html/CSSProperty"
], function(declare, CSSElement, CSSParser, CSSProperty) {

return declare("davinci.html.CSSRule", CSSElement, {

	constructor: function() {
		this.elementType = "CSSRule";
		this.selectors = [];
		this.properties = [];
	},

	getText: function(context) {
		var s = "";
		context = context || [];
		if (this.comment && !context.noComments) {
			s += /*"\n  " +*/ this.comment.getText(context); //#2166
		}
		s += this.getSelectorText(context);
		s = s + " {";
		for ( var i = 0; i < this.properties.length; i++ ) {
			s = s + "\n    " + this.properties[i].getText(context);
		}
		s = s + "\n}\n";
		if (this.postComment && !context.noComments) {
			s += /*"\n  " +*/ this.postComment.getText(context); //#2166
		}
		return s;
	},

	setText: function(text) {
		var options = {
				xmode : 'style',
				css : true
		};
		var result = require("davinci/html/CSSParser").parse(text, this);

		// first child is actually the parsed element, so replace this with child
		dojo.mixin(this, this.children[0]);
		var parentOffset = (this.parent) ? this.parent.endOffset : 0;
		this.startOffset = parentOffset + 1;
		this.setDirty(true);
	},

	addProperty: function(name, value) {
		var property = new CSSProperty(name, value, this);
		this.properties.push(property);
		this.setDirty(true);
		this.onChange();
	},

	insertProperty: function(name, value, atIndex) {
		/* insert a property at given index */
		var property;
		property = this.getProperty(name);
		if (property) {
			this.removeProperty(name);
		}

		property = new CSSProperty(name, value, this);
		this.properties.splice(atIndex, 0, property);
		this.setDirty(true);
		this.onChange();
	},

	getSelectorText: function(context) {
		var s = "";
		for ( var i = 0; i < this.selectors.length; i++ ) {
			if (i > 0)
				s = s + ", ";
			s = s + this.selectors[i].getText(context);
		}
		return s;
	},

	matches: function(domNode) {
		domNode = this._convertNode(domNode);
		var specific;
		for ( var i = 0; i < this.selectors.length; i++ ) {
			if ((specific = this.selectors[i].matches(domNode)) >= 0) {
				return specific;
			}
		}
	},

	visit: function(visitor) {
		if (!visitor.visit(this)) {
			for ( var i = 0; i < this.children.length; i++ ) {
				this.children[i].visit(visitor);
			}
			for ( var i = 0; i < this.selectors.length; i++ ) {
				this.selectors[i].visit(visitor);
			}
		}
		if (visitor.endVisit) {
			visitor.endVisit(this);
		}
	},

	hasSelector: function(selectorText) {
		for ( var i = 0; i < this.selectors.length; i++ ) {
			if (this.selectors[i].getLabel() == selectorText) {
				return true;
			}
		}
		return false;
	},

	matchesSelectors: function(selectors) {
		for ( var j = 0; j < selectors.length; j++ ) {
			for ( var i = 0; i < this.selectors.length; i++ ) {
				if (this.selectors[i].matchesSelector(selectors[j])) {
					return true;
				}
			}
		}
		return false;
	},

	getCSSRule: function() {
		return this;
	},

	getLabel: function() {
		return this.getSelectorText({});
	},

	getProperty: function(propertyName) {
		for ( var i = 0; i < this.properties.length; i++ ) {
			if (propertyName == this.properties[i].name) {
				return this.properties[i];
			}
		}
	},

	hasProperty: function(propertyName) {
		for ( var i = 0; i < this.properties.length; i++ ) {
			if (propertyName == this.properties[i].name) {
				return true;
			}
		}
	},

	/**
	 * If propertyName is not provided, returns all CSS properties declared in this rule.
	 * If propertyName is provide, return all CSS property declarations for that property only.
	 * @param {string} propertyName  CSS propername name (e.g., 'font-size')
	 * @returns {Array[Object]} where Object has single property, such as [{display:'none'},{'font-size':'12px'}]
	 */
	getProperties: function(propertyName) {
		var values = [];
		for ( var i = 0; i < this.properties.length; i++ ) {
			if (!propertyName || propertyName == this.properties[i].name) {
				values.push( this.properties[i]);
			}
		}
		return values;
	},

	setProperty: function(name, value) {
		var property = this.getProperty(name);
		if (!value) {
			this.removeProperty(name);
		} else if (property) {
			property.value = value;
		} else {
			property = new CSSProperty();
			property.name = name;
			property.value = value;
			this.properties.push(property);
			property.parent = this;
		}
		this.setDirty(true);
		this.onChange();

	},

	removeProperty: function(propertyName) {
		for ( var i = 0; i < this.properties.length; i++ ) {
			if (propertyName == this.properties[i].name) {
				this.properties.splice(i, 1);
			}
		}
		this.setDirty(true);
		this.onChange();
	},

	removeAllProperties: function() {
		this.properties = [];
		this.setDirty(true);
		this.onChange();
	},

	removeStyleValues: function(propertyNames) {
		var newProperties = [];
		for ( var i = 0; i < this.properties.length; i++ ) {
			var found;
			for ( var j = 0; j < propertyNames.length && !found; j++ ) {
				found = propertyNames[j] == this.properties[i].name;
			}
			if (!found) {
				newProperties = this.properties[i];
			}
		}
		this.properties = newProperties;
		this.setDirty(true);
		this.onChange();
	}

});
});

},
'dijit/form/DateTextBox':function(){
define([
	"dojo/_base/declare", // declare
	"../Calendar",
	"./_DateTimeTextBox"
], function(declare, Calendar, _DateTimeTextBox){

	// module:
	//		dijit/form/DateTextBox

	return declare("dijit.form.DateTextBox", _DateTimeTextBox, {
		// summary:
		//		A validating, serializable, range-bound date text box with a drop down calendar
		// example:
		// |	new DateTextBox({value: new Date(2009, 0, 20)})
		// example:
		// |	<input data-dojo-type='dijit/form/DateTextBox' value='2009-01-20'>

		baseClass: "dijitTextBox dijitComboBox dijitDateTextBox",
		popupClass: Calendar,
		_selector: "date",

		// value: Date
		//		The value of this widget as a JavaScript Date object, with only year/month/day specified.
		//		If specified in markup, use the format specified in `stamp.fromISOString`.
		//		set("value", ...) accepts either a Date object or a string.
		value: new Date("")	// value.toString()="NaN"
	});
});

},
'davinci/html/html.plugin':function(){
define([
	'require'
//	'../Workbench'
], function(require) {

return {
	id: "davinci.html",
	"davinci.editor": [
		{
			id: "HTMLEditor",
			name: "HTML Editor",
			extensions: "html",
			isDefault: false,
			//TODO implement		 icon: "",
			editorClass: "davinci/html/ui/HTMLEditor",
			palettePerspective: "davinci.html.htmlEditor",
            expandPalettes: ["left"]
		},
		{
			id: "CSSEditor",
			name: "CSS Editor",
			extensions: "css",
			isDefault: true,
			//TODO implement		 icon: "",
			editorClass: "davinci/html/ui/CSSEditor",
			palettePerspective: "davinci.html.htmlEditor",
            expandPalettes: ["left"]
		},
		{
			id: "ImageViewer",
			name: "Image Viewer",
			extensions: "jpg,gif,jpeg,png",
			isDefault: true,
			//TODO implement		 icon: "",
			editorClass: "davinci/html/ui/ImageViewer",
			palettePerspective: "davinci.html.htmlEditor",
            expandPalettes: ["left"]
		}
	],
	"davinci.editorActions": {
		editorContribution: {
			targetID: "davinci.html.CSSEditor",
			actions: [
		      {
                  id: "savecombo",
                  className: "maqLabelButton",
                  showLabel: true,
                  label: "Save",
                  toolbarPath: "save",
                  type:'ComboButton',
                  run: function() {
                      require(['../Workbench'], function(workbench) {
                      		require("../ui/Resource").save();
                      });
                  },
                  isEnabled: function(context) {
                      return require('../Workbench').getOpenEditor();
                  },
                  menu:[
                     {
                          iconClass: 'saveIcon',
                          run: function() {
                          		require("../ui/Resource").save();
                          },
                          isEnabled: function(context) {
                              return require('../Workbench').getOpenEditor();
                          },
                          label: "Save",
                  		keyBinding: {accel: true, charOrCode: "s", allowGlobal: true}
                      },
                      {
                          iconClass: 'saveAsIcon',
                          run: function() {
                              require("../ui/Resource").saveAs('html');
                          },
                          isEnabled: function(context) {
                              return require('../Workbench').getOpenEditor();
                          },
                          label: "Save As",
                  		keyBinding: {accel: true, shift: true, charOrCode: "s", allowGlobal: true}
                      }
                  ]
              }
			]
		}
	},
	"davinci.preferences": [
		{
			name: "HTML",
			id: "general",
			category: ""
		}
	],
	"davinci.fileType": [
		{
			extension: "html",
			iconClass: "htmlFileIcon",
			type: "text"
		},
		{
			extension: "css",
			iconClass: "cssFileIcon",
			type: "text"
		},
		{
			extension: "jpeg",
			iconClass: "imageFileIcon",
			type: "image"
		},
		{
			extension: "jpg",
			iconClass: "imageFileIcon",
			type: "image"
		},
		{
			extension: "png",
			iconClass: "imageFileIcon",
			type: "image"
		},
		{
			extension: "gif",
			iconClass: "imageFileIcon",
			type: "image"
		}
	],
	
	"davinci.perspective": [
        {
            id: "htmlEditor",
            title: "HTML Editor",
            views: [
                {
                    viewID: "davinci.ve.Palette",
                    position: "left",
                    hidden: true
                },
                {
                    viewID: "davinci.ui.outline",
                    position: "left",
                    hidden: true
                },
                {
                    viewID: "davinci.ve.style",
                    position: "right"
                },
                {
                    viewID: "davinci.ui.comment",
                    position: "right",
                    hidden: true
                },
                {
                    viewID: "davinci.ve.states",
                    position: "right-bottom",
                    hidden: true
                },
                {
                    viewID: "davinci.ui.navigator",
                    position: "left-bottom",
                    selected: true
                },
                {
                    viewID: "davinci.review.reviewNavigator",
                    position: "left"
                }
            ]
        }
    ]
};

});
},
'davinci/html/HTMLParser':function(){
define([
	"dojo/_base/declare",
	"davinci/html/HTMLText",
	"davinci/html/HTMLElement",
	"davinci/html/HTMLAttribute",
	"davinci/html/HTMLComment",
	"davinci/html/PHPBlock",
	"davinci/model/parser/Tokenizer",
	"davinci/html/CSSParser"
], function(declare, HTMLText, HTMLElement, HTMLAttribute, HTMLComment, PHPBlock, Tokenizer, CSSParser) {

/* This file defines an XML parser, with a few kludges to make it
 * useable for HTML. autoSelfClosers defines a set of tag names that
 * are expected to not have a closing tag, and doNotIndent specifies
 * the tags inside of which no indentation should happen (see Config
 * object). These can be disabled by passing the editor an object like
 * {useHTMLKludges: false} as parserConfig option.
 */

var XMLParser  = (function() {
	var Kludges = {
			autoSelfClosers: {"br": true, "img": true, "hr": true, "link": true, "input": true,
				"meta": true, "col": true, "frame": true, "base": true, "area": true},
				doNotIndent: {"pre": true, "!cdata": true}
	};
	var NoKludges = {autoSelfClosers: {}, doNotIndent: {"!cdata": true}};
	var UseKludges = Kludges;
	var alignCDATA = false;

	// Simple stateful tokenizer for XML documents. Returns a
	// MochiKit-style iterator, with a state property that contains a
	// function encapsulating the current state. See tokenize.js.
	var tokenizeXML = (function() {
		function inText(source, setState) {
			var ch = source.next();
			if (ch == "<") {
				if (source.equals("!")) {
					source.next();
					if (source.equals("[")) {
						if (source.lookAhead("[CDATA[", true)) {
							setState(inBlock("xml-cdata", "]]>"));
							return null;
						} else {
							return "xml-text";
						}
					} else if (source.lookAhead("--", true)) {
						setState(inBlock("xml-comment", "-->"));
						return null;
					} else if (source.lookAhead("DOCTYPE", true)) {
						source.nextWhileMatches(/[\w\._\-]/);
						setState(inBlock("xml-doctype", ">"));
						return "xml-doctype";
					} else {
						return "xml-text";
					}
				} else if (source.equals("?")) {
					source.next();
					if(source.lookAhead('php', true/*consume*/, false/*skipSpaces*/, true/*caseInsensitive*/)){
						setState(inIgnore("php-block", "?>"));
						return null;
					}else{
						source.nextWhileMatches(/[\w\._\-]/);
						setState(inBlock("xml-processing", "?>"));
						return "xml-processing";
					}
				} else {
					if (source.equals("/")) source.next();
					setState(inTag);
					return "xml-punctuation";
				}
			} else if (ch == "&") {
				while (!source.endOfLine()) {
					if (source.next() == ";")
						break;
				}
				return "xml-entity";
			} else {
				source.nextWhileMatches(/[^&<\n]/);
				return "xml-text";
			}
		}

		function inTag(source, setState) {
			var ch = source.next();
			if (ch == ">") {
				setState(inText);
				return "xml-punctuation";
			} else if (/[?\/]/.test(ch) && source.equals(">")) {
				source.next();
				setState(inText);
				return "xml-punctuation";
			} else if (ch == "=") {
				return "xml-punctuation";
			} else if (/[\'\"]/.test(ch)) {
				setState(inAttribute(ch));
				return null;
			} else {
				source.nextWhileMatches(/[^\s\u00a0=<>\"\'\/?]/);
				return "xml-name";
			}
		}

		function inAttribute(quote) {
			return function(source, setState) {
				while (!source.endOfLine()) {
					if (source.next() == quote) {
						setState(inTag);
						break;
					}
				}
				return "xml-attribute";
			};
		}

		function inBlock(style, terminator) {
			return function(source, setState) {
				while (!source.endOfLine()) {
					if (source.lookAhead(terminator, true)) {
						setState(inText);
						break;
					}
					source.next();
				}
				return style;
			};
		}

		function inIgnore(style, terminator) {
			return function(source, setState) {
				var terminated = false;
				while (!source.endOfLine()) {
					if (source.lookAhead(terminator, true)) {
						terminated = true;
						setState(inText);
						break;
					}
					source.next();
				}
				if(!terminated && source.endOfLine()){
					source.next();
				}else{
					while(source.lookAheadRegex(/^[\ \t]/, true)){
					}
					if(source.endOfLine()){
						source.next();
					}
				}
				return style;
			};
		}

		return function(source, startState) {
			return Tokenizer.tokenizer(source, startState || inText);
		};
	})();

	// The parser. The structure of this function largely follows that of
	// parseJavaScript in parsejavascript.js (there is actually a bit more
	// shared code than I'd like), but it is quite a bit simpler.
	function parseXML(source) {
		var tokens = tokenizeXML(source), token;
		var cc = [base];
		var tokenNr = 0, indented = 0;
		var currentTag = null, context = null;
		var consume;

		function push(fs) {
			for (var i = fs.length - 1; i >= 0; i--)
				cc.push(fs[i]);
		}
		function cont() {
			push(arguments);
			consume = true;
		}
		function pass() {
			push(arguments);
			consume = false;
		}

		function markErr() {
			token.style += " xml-error";
		}
		function expect(text) {
			return function(style, content) {
				if (content == text) cont();
				else {markErr(); cont(arguments.callee);}
			};
		}

		function pushContext(tagname, startOfLine) {
			var noIndent = UseKludges.doNotIndent.hasOwnProperty(tagname) || (context && context.noIndent);
			context = {prev: context, name: tagname, indent: indented, startOfLine: startOfLine, noIndent: noIndent};
		}

		function popContext() {
			context = context.prev;
		}

		function computeIndentation(baseContext) {
			return function(nextChars, current) {
				var context = baseContext;
				if (context && context.noIndent)
					return current;
				if (alignCDATA && /<!\[CDATA\[/.test(nextChars))
					return 0;
				if (context && /^<\//.test(nextChars))
					context = context.prev;
				while (context && !context.startOfLine)
					context = context.prev;
				if (context)
					return context.indent + indentUnit;
				else
					return 0;
			};
		}

		function base() {
			return pass(element, base);
		}

		var harmlessTokens = {"xml-text": true, "xml-entity": true, "xml-comment": true, "xml-processing": true, "xml-doctype": true, "php-block": true};

		function element(style, content) {
			if (content == "<") cont(tagname, attributes, endtag(tokenNr == 1));
			else if (content == "</") cont(closetagname, expect(">"));
			else if (style == "xml-cdata") {
				if (!context || context.name != "!cdata") pushContext("!cdata");
				if (/\]\]>$/.test(content)) popContext();
				cont();
			}
			else if (harmlessTokens.hasOwnProperty(style)) cont();
			else {markErr(); cont();}
		}

		function tagname(style, content) {
			if (style == "xml-name") {
				currentTag = content.toLowerCase();
				token.style = "xml-tagname";
				cont();
			}
			else {
				currentTag = null;
				pass();
			}
		}

		function closetagname(style, content) {
			if (style == "xml-name") {
				token.style = "xml-tagname";
				if (context && content.toLowerCase() == context.name) popContext();
				else markErr();
			}
			cont();
		}

		function endtag(startOfLine) {
			return function(style, content) {
				if (content == "/>" || (content == ">" && UseKludges.autoSelfClosers.hasOwnProperty(currentTag))) cont();
				else if (content == ">") {pushContext(currentTag, startOfLine); cont();}
				else {markErr(); cont(arguments.callee);}
			};
		}

		function attributes(style) {
			if (style == "xml-name") {token.style = "xml-attname"; cont(attribute, attributes);}
			else pass();
		}

		function attribute(style, content) {
			if (content == "=") cont(value);
			else if (content == ">" || content == "/>") pass(endtag);
			else pass();
		}

		function value(style) {
			if (style == "xml-attribute") cont(value);
			else pass();
		}

		return {
			indentation: function() {return indented;},

			next: function(){
				token = tokens.next();
				if (token.style == "whitespace" && tokenNr == 0)
					indented = token.value.length;
				else
					tokenNr++;
				if (token.content == "\n") {
					indented = tokenNr = 0;
					token.indentation = computeIndentation(context);
				}

				if (token.style == "whitespace" || token.type == "xml-comment" || token.type == "php-block")
					return token;

				while (true) {
					consume = false;
					cc.pop()(token.style, token.content);
					if (consume) return token;
				}
			},

			copy: function() {
				var _cc = cc.concat([]), _tokenState = tokens.state, _context = context;
				var parser = this;

				return function(input){
					cc = _cc.concat([]);
					tokenNr = indented = 0;
					context = _context;
					tokens = tokenizeXML(input, _tokenState);
					return parser;
				};
			}
		};
	}

	return {
		make: parseXML,
		electricChars: "/",
		configure: function(config) {
			if (config.useHTMLKludges != null)
				UseKludges = config.useHTMLKludges ? Kludges : NoKludges;
			if (config.alignCDATA)
				alignCDATA = config.alignCDATA;
		}
	};
})();

var parse = function(text, parentElement) {
	var txtStream = { next : function () {if (++this.count==1)  return text; else {throw StopIteration;}} , count:0, text:text};
	var stream = Tokenizer.stringStream(txtStream);
	var parser = XMLParser.make(stream);
	var token;
	var errors=[];
	function error(text){errors.push(text);}

	var stack=[];
	stack.push(parentElement);
	var htmlText;
	var inComment, inPhpBlock;

	function addText(text, offset) {
		htmlText = new HTMLText();
		htmlText.wasParsed = true;
		htmlText.startOffset = offset;
		stack[stack.length-1].addChild(htmlText, undefined, true);
		htmlText.value = text;

	}

	function addTrailingWS(token) {
		if (token.content != token.value) {
			addText(token.value.substring(token.content.length), token.offset+token.value.length);
		}
	}

	function updateFMInfo(str,element) {
		var lines = str.split("\n");
		var indent = lines[lines.length-1].length;
		if (element.children.length) {
			lastElement = element.children[element.children.length-1];
			lastElement._fmLine = lines.length-1;
			lastElement._fmIndent = indent;
		}  else {
			element._fmChildLine = lines.length-1;
			element._fmChildIndent = indent;
		}
	}

	function updateText() {
		if (htmlText != null && !htmlText.value.match(/\S/)) {
			var lastElement = stack[stack.length-1];
			lastElement.children.pop();	// remove the htmlText
			updateFMInfo(htmlText.value, lastElement);
		}
		htmlText = null;
	}

	function parseStyle()  {
		var lastElement = stack[stack.length-1];
		stream.nextWhileMatches(/[\s\u00a0]/);
		var str = stream.get();
		if (htmlText != null)  {
			htmlText.value += str;
			updateText();
		} else {
			updateFMInfo(str, lastElement);
		}
		CSSParser.parse(stream, lastElement);
	}

	function nextToken(ignoreWS) {
		token = parser.next();
		while (ignoreWS &&  token.style == "whitespace") {
			token = parser.next();
		}
		return token;
	}

	try {
		do {
			token = parser.next();
			switch (token.style) {
			case "xml-punctuation" : {
				updateText();
				if (token.content == "<") {
					var model = new HTMLElement();
					model.wasParsed = true;
					model.startOffset = token.offset;
					stack[stack.length-1].addChild(model, undefined, true);
					nextToken(true);
					if (token.style == "xml-tagname")
						model.tag = token.content;
					else
						error("expecting tag name");

					while ((token = nextToken(true)).style == "xml-attname") {
						var attribute = new HTMLAttribute();
						attribute.wasParsed = true;
						model.attributes.push(attribute);
						attribute.name = token.content;
						attribute.startOffset = token.offset;
						nextToken(true);
						if (token.content == "=") {
							token = parser.next();
							if (token.style == "xml-attribute") {
								var s=token.content;
								attribute.setValue(s.substring(1,s.length-1));

							} else {
								error ("expecting attribute value");
							}
						} else {
							attribute.noValue = true;
							attribute.setValue(true);
						}
						attribute.endOffset = token.offset-1;
						if (attribute.noValue && token.style != "xml-attname")
							break;
					}
					if (token.style != "xml-punctuation")
						error("expecting >");
					else {
						model.startTagOffset = token.offset;
						if (token.content == ">")
							stack.push(model);
						else {
							model.noEndTag = true;
							model = stack[stack.length-1];
						}
						addTrailingWS(token);
					}
					if (model.tag == "style") {
						parseStyle();
					}

				} else if (token.value == "</") {
					var prevModel = model;
					token = parser.next();
					if (model.tag == "script") {
						model.script=model.getElementText();
					}
					stack.pop();
					model = stack[stack.length-1];
					token = parser.next();
					prevModel.endOffset = token.offset;
					addTrailingWS(token);
				}
				inPhpBlock = null;
			}
			break;
			case "xml-text" :
			case "whitespace" :
			case "xml-entity" : {
				if (inComment) {
					inComment.value += token.value;
				} else if ( inPhpBlock ) {
					inPhpBlock.value += token.value;
				} else {
					if (!htmlText) {
						addText(token.value, token.offset);
					} else {
						htmlText.value += token.value;
					}
				}
				inPhpBlock = null;
			}
			break;
			case "xml-comment" : {
				updateText();
				var comment = new HTMLComment();
				comment.wasParsed = true;
				comment.startOffset = token.offset;
				comment.value = token.content.substring(4,token.content.length-3);
				comment.endOffset = token.offset+token.content.length;
				stack[stack.length-1].addChild(comment, undefined, true);
				inPhpBlock = null;
			}
			break;
			case "php-block" : {
				updateText();
				var phpBlock = new PHPBlock();
				phpBlock.wasParsed = true;
				phpBlock.startOffset = token.offset;
				phpBlock.value = token.content;
				phpBlock.endOffset = token.offset+token.content.length;
				stack[stack.length-1].addChild(phpBlock, undefined, true);
				inPhpBlock = phpBlock;
			}
			break;
			case "xml-doctype" : {
				if (!inComment)  {
					updateText();
					var comment = new HTMLComment();
					comment.wasParsed = true;
					comment.startOffset = token.offset;
					comment.value = token.value.substring(2);
					stack[stack.length-1].addChild(comment, undefined, true);
					comment.isProcessingInstruction = true;
					token = parser.next();
				}
				var lastChar = token.content.length-1;
				if (token.content.charAt(token.content.length-1) == ">") {
					comment.endOffset = token.offset + token.content.length;
					comment.value += token.content.substring(0, lastChar);
					addTrailingWS(token);
					inComment = undefined;
				}  else {
					inComment = comment;
					comment.value += token.content;
				}
				inPhpBlock = null;
			}
			break;		  
			}
		} while (true);
	} catch (e) {}

	return { errors:errors, endOffset:(token?token.offset:0) };
};

return {
	parse: parse
};

});
},
'dijit/form/ComboButton':function(){
define([
	"dojo/_base/declare", // declare
	"dojo/_base/event", // event.stop
	"dojo/keys", // keys
	"../focus",		// focus.focus()
	"./DropDownButton",
	"dojo/text!./templates/ComboButton.html"
], function(declare, event, keys, focus, DropDownButton, template){

// module:
//		dijit/form/ComboButton

return declare("dijit.form.ComboButton", DropDownButton, {
	// summary:
	//		A combination button and drop-down button.
	//		Users can click one side to "press" the button, or click an arrow
	//		icon to display the drop down.
	//
	// example:
	// |	<button data-dojo-type="dijit/form/ComboButton" onClick="...">
	// |		<span>Hello world</span>
	// |		<div data-dojo-type="dijit/Menu">...</div>
	// |	</button>
	//
	// example:
	// |	var button1 = new ComboButton({label: "hello world", onClick: foo, dropDown: "myMenu"});
	// |	dojo.body().appendChild(button1.domNode);
	//

	templateString: template,

	// Map widget attributes to DOMNode attributes.
	_setIdAttr: "",	// override _FormWidgetMixin which puts id on the focusNode
	_setTabIndexAttr: ["focusNode", "titleNode"],
	_setTitleAttr: "titleNode",

	// optionsTitle: String
	//		Text that describes the options menu (accessibility)
	optionsTitle: "",

	baseClass: "dijitComboButton",

	// Set classes like dijitButtonContentsHover or dijitArrowButtonActive depending on
	// mouse action over specified node
	cssStateNodes: {
		"buttonNode": "dijitButtonNode",
		"titleNode": "dijitButtonContents",
		"_popupStateNode": "dijitDownArrowButton"
	},

	_focusedNode: null,

	_onButtonKeyPress: function(/*Event*/ evt){
		// summary:
		//		Handler for right arrow key when focus is on left part of button
		if(evt.charOrCode == keys[this.isLeftToRight() ? "RIGHT_ARROW" : "LEFT_ARROW"]){
			focus.focus(this._popupStateNode);
			event.stop(evt);
		}
	},

	_onArrowKeyPress: function(/*Event*/ evt){
		// summary:
		//		Handler for left arrow key when focus is on right part of button
		if(evt.charOrCode == keys[this.isLeftToRight() ? "LEFT_ARROW" : "RIGHT_ARROW"]){
			focus.focus(this.titleNode);
			event.stop(evt);
		}
	},

	focus: function(/*String*/ position){
		// summary:
		//		Focuses this widget to according to position, if specified,
		//		otherwise on arrow node
		// position:
		//		"start" or "end"
		if(!this.disabled){
			focus.focus(position == "start" ? this.titleNode : this._popupStateNode);
		}
	}
});

});

},
'url:dijit/templates/Calendar.html':"<table cellspacing=\"0\" cellpadding=\"0\" class=\"dijitCalendarContainer\" role=\"grid\" aria-labelledby=\"${id}_mddb ${id}_year\">\n\t<thead>\n\t\t<tr class=\"dijitReset dijitCalendarMonthContainer\" valign=\"top\">\n\t\t\t<th class='dijitReset dijitCalendarArrow' data-dojo-attach-point=\"decrementMonth\">\n\t\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitCalendarIncrementControl dijitCalendarDecrease\" role=\"presentation\"/>\n\t\t\t\t<span data-dojo-attach-point=\"decreaseArrowNode\" class=\"dijitA11ySideArrow\">-</span>\n\t\t\t</th>\n\t\t\t<th class='dijitReset' colspan=\"5\">\n\t\t\t\t<div data-dojo-attach-point=\"monthNode\">\n\t\t\t\t</div>\n\t\t\t</th>\n\t\t\t<th class='dijitReset dijitCalendarArrow' data-dojo-attach-point=\"incrementMonth\">\n\t\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitCalendarIncrementControl dijitCalendarIncrease\" role=\"presentation\"/>\n\t\t\t\t<span data-dojo-attach-point=\"increaseArrowNode\" class=\"dijitA11ySideArrow\">+</span>\n\t\t\t</th>\n\t\t</tr>\n\t\t<tr role=\"row\">\n\t\t\t${!dayCellsHtml}\n\t\t</tr>\n\t</thead>\n\t<tbody data-dojo-attach-point=\"dateRowsNode\" data-dojo-attach-event=\"onclick: _onDayClick\" class=\"dijitReset dijitCalendarBodyContainer\">\n\t\t\t${!dateRowsHtml}\n\t</tbody>\n\t<tfoot class=\"dijitReset dijitCalendarYearContainer\">\n\t\t<tr>\n\t\t\t<td class='dijitReset' valign=\"top\" colspan=\"7\" role=\"presentation\">\n\t\t\t\t<div class=\"dijitCalendarYearLabel\">\n\t\t\t\t\t<span data-dojo-attach-point=\"previousYearLabelNode\" class=\"dijitInline dijitCalendarPreviousYear\" role=\"button\"></span>\n\t\t\t\t\t<span data-dojo-attach-point=\"currentYearLabelNode\" class=\"dijitInline dijitCalendarSelectedYear\" role=\"button\" id=\"${id}_year\"></span>\n\t\t\t\t\t<span data-dojo-attach-point=\"nextYearLabelNode\" class=\"dijitInline dijitCalendarNextYear\" role=\"button\"></span>\n\t\t\t\t</div>\n\t\t\t</td>\n\t\t</tr>\n\t</tfoot>\n</table>\n",
'dijit/form/_AutoCompleterMixin':function(){
define([
	"dojo/data/util/filter", // patternToRegExp
	"dojo/_base/declare", // declare
	"dojo/dom-attr", // domAttr.get
	"dojo/_base/event", // event.stop
	"dojo/keys",
	"dojo/_base/lang", // lang.clone lang.hitch
	"dojo/query", // query
	"dojo/regexp", // regexp.escapeString
	"dojo/sniff", // has("ie")
	"dojo/string", // string.substitute
	"./DataList",
	"../registry",	// registry.byId
	"./_TextBoxMixin",	// defines _TextBoxMixin.selectInputText
	"./_SearchMixin"
], function(filter, declare, domAttr, event, keys, lang, query, regexp, has, string,
			DataList, registry, _TextBoxMixin, SearchMixin){

	// module:
	//		dijit/form/_AutoCompleterMixin

	return declare("dijit.form._AutoCompleterMixin", SearchMixin, {
		// summary:
		//		A mixin that implements the base functionality for `dijit/form/ComboBox`/`dijit/form/FilteringSelect`
		// description:
		//		All widgets that mix in dijit/form/_AutoCompleterMixin must extend `dijit/form/_FormValueWidget`.
		// tags:
		//		protected

		// item: Object
		//		This is the item returned by the dojo/store/api/Store implementation that
		//		provides the data for this ComboBox, it's the currently selected item.
		item: null,

		// autoComplete: Boolean
		//		If user types in a partial string, and then tab out of the `<input>` box,
		//		automatically copy the first entry displayed in the drop down list to
		//		the `<input>` field
		autoComplete: true,

		// highlightMatch: String
		//		One of: "first", "all" or "none".
		//
		//		If the ComboBox/FilteringSelect opens with the search results and the searched
		//		string can be found, it will be highlighted.  If set to "all"
		//		then will probably want to change `queryExpr` parameter to '*${0}*'
		//
		//		Highlighting is only performed when `labelType` is "text", so as to not
		//		interfere with any HTML markup an HTML label might contain.
		highlightMatch: "first",

		// labelAttr: String?
		//		The entries in the drop down list come from this attribute in the
		//		dojo.data items.
		//		If not specified, the searchAttr attribute is used instead.
		labelAttr: "",

		// labelType: String
		//		Specifies how to interpret the labelAttr in the data store items.
		//		Can be "html" or "text".
		labelType: "text",

		// Flags to _HasDropDown to limit height of drop down to make it fit in viewport
		maxHeight: -1,

		// For backwards compatibility let onClick events propagate, even clicks on the down arrow button
		_stopClickEvents: false,

		_getCaretPos: function(/*DomNode*/ element){
			// khtml 3.5.2 has selection* methods as does webkit nightlies from 2005-06-22
			var pos = 0;
			if(typeof(element.selectionStart) == "number"){
				// FIXME: this is totally borked on Moz < 1.3. Any recourse?
				pos = element.selectionStart;
			}else if(has("ie")){
				// in the case of a mouse click in a popup being handled,
				// then the win.doc.selection is not the textarea, but the popup
				// var r = win.doc.selection.createRange();
				// hack to get IE 6 to play nice. What a POS browser.
				var tr = element.ownerDocument.selection.createRange().duplicate();
				var ntr = element.createTextRange();
				tr.move("character",0);
				ntr.move("character",0);
				try{
					// If control doesn't have focus, you get an exception.
					// Seems to happen on reverse-tab, but can also happen on tab (seems to be a race condition - only happens sometimes).
					// There appears to be no workaround for this - googled for quite a while.
					ntr.setEndPoint("EndToEnd", tr);
					pos = String(ntr.text).replace(/\r/g,"").length;
				}catch(e){
					// If focus has shifted, 0 is fine for caret pos.
				}
			}
			return pos;
		},

		_setCaretPos: function(/*DomNode*/ element, /*Number*/ location){
			location = parseInt(location);
			_TextBoxMixin.selectInputText(element, location, location);
		},

		_setDisabledAttr: function(/*Boolean*/ value){
			// Additional code to set disabled state of ComboBox node.
			// Overrides _FormValueWidget._setDisabledAttr() or ValidationTextBox._setDisabledAttr().
			this.inherited(arguments);
			this.domNode.setAttribute("aria-disabled", value ? "true" : "false");
		},

		_onKey: function(/*Event*/ evt){
			// summary:
			//		Handles keyboard events

			if(evt.charCode >= 32){ return; } // alphanumeric reserved for searching

			var key = evt.charCode || evt.keyCode;

			// except for cutting/pasting case - ctrl + x/v
			if(key == keys.ALT || key == keys.CTRL || key == keys.META || key == keys.SHIFT){
				return; // throw out spurious events
			}

			var pw = this.dropDown;
			var highlighted = null;
			this._abortQuery();

			// _HasDropDown will do some of the work:
			//
			//	1. when drop down is not yet shown:
			//		- if user presses the down arrow key, call loadDropDown()
			//	2. when drop down is already displayed:
			//		- on ESC key, call closeDropDown()
			//		- otherwise, call dropDown.handleKey() to process the keystroke
			this.inherited(arguments);

			if(evt.altKey || evt.ctrlKey || evt.metaKey){ return; } // don't process keys with modifiers  - but we want shift+TAB

			if(this._opened){
				highlighted = pw.getHighlightedOption();
			}
			switch(key){
				case keys.PAGE_DOWN:
				case keys.DOWN_ARROW:
				case keys.PAGE_UP:
				case keys.UP_ARROW:
					// Keystroke caused ComboBox_menu to move to a different item.
					// Copy new item to <input> box.
					if(this._opened){
						this._announceOption(highlighted);
					}
					event.stop(evt);
					break;

				case keys.ENTER:
					// prevent submitting form if user presses enter. Also
					// prevent accepting the value if either Next or Previous
					// are selected
					if(highlighted){
						// only stop event on prev/next
						if(highlighted == pw.nextButton){
							this._nextSearch(1);
							event.stop(evt); // prevent submit
							break;
						}else if(highlighted == pw.previousButton){
							this._nextSearch(-1);
							event.stop(evt); // prevent submit
							break;
						}
						event.stop(evt); // prevent submit if ENTER was to choose an item
					}else{
						// Update 'value' (ex: KY) according to currently displayed text
						this._setBlurValue(); // set value if needed
						this._setCaretPos(this.focusNode, this.focusNode.value.length); // move cursor to end and cancel highlighting
					}
					// fall through

				case keys.TAB:
					var newvalue = this.get('displayedValue');
					//	if the user had More Choices selected fall into the
					//	_onBlur handler
					if(pw && (
						newvalue == pw._messages["previousMessage"] ||
						newvalue == pw._messages["nextMessage"])
					){
						break;
					}
					if(highlighted){
						this._selectOption(highlighted);
					}
					// fall through

				case keys.ESCAPE:
					if(this._opened){
						this._lastQuery = null; // in case results come back later
						this.closeDropDown();
					}
					break;
			}
		},

		_autoCompleteText: function(/*String*/ text){
			// summary:
			//		Fill in the textbox with the first item from the drop down
			//		list, and highlight the characters that were
			//		auto-completed. For example, if user typed "CA" and the
			//		drop down list appeared, the textbox would be changed to
			//		"California" and "ifornia" would be highlighted.

			var fn = this.focusNode;

			// IE7: clear selection so next highlight works all the time
			_TextBoxMixin.selectInputText(fn, fn.value.length);
			// does text autoComplete the value in the textbox?
			var caseFilter = this.ignoreCase? 'toLowerCase' : 'substr';
			if(text[caseFilter](0).indexOf(this.focusNode.value[caseFilter](0)) == 0){
				var cpos = this.autoComplete ? this._getCaretPos(fn) : fn.value.length;
				// only try to extend if we added the last character at the end of the input
				if((cpos+1) > fn.value.length){
					// only add to input node as we would overwrite Capitalisation of chars
					// actually, that is ok
					fn.value = text;//.substr(cpos);
					// visually highlight the autocompleted characters
					_TextBoxMixin.selectInputText(fn, cpos);
				}
			}else{
				// text does not autoComplete; replace the whole value and highlight
				fn.value = text;
				_TextBoxMixin.selectInputText(fn);
			}
		},

		_openResultList: function(/*Object*/ results, /*Object*/ query, /*Object*/ options){
			// summary:
			//		Callback when a search completes.
			// description:
			//		1. generates drop-down list and calls _showResultList() to display it
			//		2. if this result list is from user pressing "more choices"/"previous choices"
			//			then tell screen reader to announce new option
			var wasSelected = this.dropDown.getHighlightedOption();
			this.dropDown.clearResultList();
			if(!results.length && options.start == 0){ // if no results and not just the previous choices button
				this.closeDropDown();
				return;
			}
			this._nextSearch = this.dropDown.onPage = lang.hitch(this, function(direction){
				results.nextPage(direction !== -1);
				this.focus();
			});

			// Fill in the textbox with the first item from the drop down list,
			// and highlight the characters that were auto-completed. For
			// example, if user typed "CA" and the drop down list appeared, the
			// textbox would be changed to "California" and "ifornia" would be
			// highlighted.

			this.dropDown.createOptions(
				results,
				options,
				lang.hitch(this, "_getMenuLabelFromItem")
			);

			// show our list (only if we have content, else nothing)
			this._showResultList();

			// #4091:
			//		tell the screen reader that the paging callback finished by
			//		shouting the next choice
			if("direction" in options){
				if(options.direction){
					this.dropDown.highlightFirstOption();
				}else if(!options.direction){
					this.dropDown.highlightLastOption();
				}
				if(wasSelected){
					this._announceOption(this.dropDown.getHighlightedOption());
				}
			}else if(this.autoComplete && !this._prev_key_backspace
				// when the user clicks the arrow button to show the full list,
				// startSearch looks for "*".
				// it does not make sense to autocomplete
				// if they are just previewing the options available.
				&& !/^[*]+$/.test(query[this.searchAttr].toString())){
					this._announceOption(this.dropDown.containerNode.firstChild.nextSibling); // 1st real item
			}
		},

		_showResultList: function(){
			// summary:
			//		Display the drop down if not already displayed, or if it is displayed, then
			//		reposition it if necessary (reposition may be necessary if drop down's height changed).
			this.closeDropDown(true);
			this.openDropDown();
			this.domNode.setAttribute("aria-expanded", "true");
		},

		loadDropDown: function(/*Function*/ /*===== callback =====*/){
			// Overrides _HasDropDown.loadDropDown().
			// This is called when user has pressed button icon or pressed the down arrow key
			// to open the drop down.
			this._startSearchAll();
		},

		isLoaded: function(){
			// signal to _HasDropDown that it needs to call loadDropDown() to load the
			// drop down asynchronously before displaying it
			return false;
		},

		closeDropDown: function(){
			// Overrides _HasDropDown.closeDropDown().  Closes the drop down (assuming that it's open).
			// This method is the callback when the user types ESC or clicking
			// the button icon while the drop down is open.  It's also called by other code.
			this._abortQuery();
			if(this._opened){
				this.inherited(arguments);
				this.domNode.setAttribute("aria-expanded", "false");
				this.focusNode.removeAttribute("aria-activedescendant");
			}
		},

		_setBlurValue: function(){
			// if the user clicks away from the textbox OR tabs away, set the
			// value to the textbox value
			// #4617:
			//		if value is now more choices or previous choices, revert
			//		the value
			var newvalue = this.get('displayedValue');
			var pw = this.dropDown;
			if(pw && (
				newvalue == pw._messages["previousMessage"] ||
				newvalue == pw._messages["nextMessage"]
				)
			){
				this._setValueAttr(this._lastValueReported, true);
			}else if(typeof this.item == "undefined"){
				// Update 'value' (ex: KY) according to currently displayed text
				this.item = null;
				this.set('displayedValue', newvalue);
			}else{
				if(this.value != this._lastValueReported){
					this._handleOnChange(this.value, true);
				}
				this._refreshState();
			}
		},

		_setItemAttr: function(/*item*/ item, /*Boolean?*/ priorityChange, /*String?*/ displayedValue){
			// summary:
			//		Set the displayed valued in the input box, and the hidden value
			//		that gets submitted, based on a dojo.data store item.
			// description:
			//		Users shouldn't call this function; they should be calling
			//		set('item', value)
			// tags:
			//		private
			var value = '';
			if(item){
				if(!displayedValue){
					displayedValue = this.store._oldAPI ?	// remove getValue() for 2.0 (old dojo.data API)
						this.store.getValue(item, this.searchAttr) : item[this.searchAttr];
				}
				value = this._getValueField() != this.searchAttr ? this.store.getIdentity(item) : displayedValue;
			}
			this.set('value', value, priorityChange, displayedValue, item);
		},

		_announceOption: function(/*Node*/ node){
			// summary:
			//		a11y code that puts the highlighted option in the textbox.
			//		This way screen readers will know what is happening in the
			//		menu.

			if(!node){
				return;
			}
			// pull the text value from the item attached to the DOM node
			var newValue;
			if(node == this.dropDown.nextButton ||
				node == this.dropDown.previousButton){
				newValue = node.innerHTML;
				this.item = undefined;
				this.value = '';
			}else{
				var item = this.dropDown.items[node.getAttribute("item")];
				newValue = (this.store._oldAPI ?	// remove getValue() for 2.0 (old dojo.data API)
					this.store.getValue(item, this.searchAttr) : item[this.searchAttr]).toString();
				this.set('item', item, false, newValue);
			}
			// get the text that the user manually entered (cut off autocompleted text)
			this.focusNode.value = this.focusNode.value.substring(0, this._lastInput.length);
			// set up ARIA activedescendant
			this.focusNode.setAttribute("aria-activedescendant", domAttr.get(node, "id"));
			// autocomplete the rest of the option to announce change
			this._autoCompleteText(newValue);
		},

		_selectOption: function(/*DomNode*/ target){
			// summary:
			//		Menu callback function, called when an item in the menu is selected.
			this.closeDropDown();
			if(target){
				this._announceOption(target);
			}
			this._setCaretPos(this.focusNode, this.focusNode.value.length);
			this._handleOnChange(this.value, true);
		},

		_startSearchAll: function(){
			this._startSearch('');
		},

		_startSearchFromInput: function(){
			this.item = undefined; // undefined means item needs to be set
			this.inherited(arguments);
		},

		_startSearch: function(/*String*/ key){
			// summary:
			//		Starts a search for elements matching key (key=="" means to return all items),
			//		and calls _openResultList() when the search completes, to display the results.
			if(!this.dropDown){
				var popupId = this.id + "_popup",
					dropDownConstructor = lang.isString(this.dropDownClass) ?
						lang.getObject(this.dropDownClass, false) : this.dropDownClass;
				this.dropDown = new dropDownConstructor({
					onChange: lang.hitch(this, this._selectOption),
					id: popupId,
					dir: this.dir,
					textDir: this.textDir
				});
				this.focusNode.removeAttribute("aria-activedescendant");
				this.textbox.setAttribute("aria-owns",popupId); // associate popup with textbox
			}
			this._lastInput = key; // Store exactly what was entered by the user.
			this.inherited(arguments);
		},

		_getValueField: function(){
			// summary:
			//		Helper for postMixInProperties() to set this.value based on data inlined into the markup.
			//		Returns the attribute name in the item (in dijit/form/_ComboBoxDataStore) to use as the value.
			return this.searchAttr;
		},

		//////////// INITIALIZATION METHODS ///////////////////////////////////////

		postMixInProperties: function(){
			this.inherited(arguments);
			if(!this.store){
				var srcNodeRef = this.srcNodeRef;
				// if user didn't specify store, then assume there are option tags
				this.store = new DataList({}, srcNodeRef);

				// if there is no value set and there is an option list, set
				// the value to the first value to be consistent with native Select
				// Firefox and Safari set value
				// IE6 and Opera set selectedIndex, which is automatically set
				// by the selected attribute of an option tag
				// IE6 does not set value, Opera sets value = selectedIndex
				if(!("value" in this.params)){
					var item = (this.item = this.store.fetchSelectedItem());
					if(item){
						var valueField = this._getValueField();
						// remove getValue() for 2.0 (old dojo.data API)
						this.value = this.store._oldAPI ? this.store.getValue(item, valueField) : item[valueField];
					}
				}
			}
		},

		postCreate: function(){
			// summary:
			//		Subclasses must call this method from their postCreate() methods
			// tags:
			//		protected

			// find any associated label element and add to ComboBox node.
			var label=query('label[for="'+this.id+'"]');
			if(label.length){
				if(!label[0].id){ label[0].id = this.id + "_label"; }
				this.domNode.setAttribute("aria-labelledby", label[0].id);

			}
			this.inherited(arguments);
			this.connect(this, "onSearch", "_openResultList");
		},

		_getMenuLabelFromItem: function(/*Item*/ item){
			var label = this.labelFunc(item, this.store),
				labelType = this.labelType;
			// If labelType is not "text" we don't want to screw any markup ot whatever.
			if(this.highlightMatch != "none" && this.labelType == "text" && this._lastInput){
				label = this.doHighlight(label, this._lastInput);
				labelType = "html";
			}
			return {html: labelType == "html", label: label};
		},

		doHighlight: function(/*String*/ label, /*String*/ find){
			// summary:
			//		Highlights the string entered by the user in the menu.  By default this
			//		highlights the first occurrence found. Override this method
			//		to implement your custom highlighting.
			// tags:
			//		protected

			var
				// Add (g)lobal modifier when this.highlightMatch == "all" and (i)gnorecase when this.ignoreCase == true
				modifiers = (this.ignoreCase ? "i" : "") + (this.highlightMatch == "all" ? "g" : ""),
				i = this.queryExpr.indexOf("${0}");
			find = regexp.escapeString(find); // escape regexp special chars
			//If < appears in label, and user presses t, we don't want to highlight the t in the escaped "&lt;"
			//first find out every occurences of "find", wrap each occurence in a pair of "\uFFFF" characters (which
			//should not appear in any string). then html escape the whole string, and replace '\uFFFF" with the
			//HTML highlight markup. 
			return this._escapeHtml(label.replace(
				new RegExp((i == 0 ? "^" : "") + "("+ find +")" + (i == (this.queryExpr.length - 4) ? "$" : ""), modifiers),
				'\uFFFF$1\uFFFF')).replace(
					/\uFFFF([^\uFFFF]+)\uFFFF/g, '<span class="dijitComboBoxHighlightMatch">$1</span>'
			); // returns String, (almost) valid HTML (entities encoded)
		},

		_escapeHtml: function(/*String*/ str){
			// TODO Should become dojo.html.entities(), when exists use instead
			// summary:
			//		Adds escape sequences for special characters in XML: `&<>"'`
			str = String(str).replace(/&/gm, "&amp;").replace(/</gm, "&lt;")
				.replace(/>/gm, "&gt;").replace(/"/gm, "&quot;"); //balance"
			return str; // string
		},

		reset: function(){
			// Overrides the _FormWidget.reset().
			// Additionally reset the .item (to clean up).
			this.item = null;
			this.inherited(arguments);
		},

		labelFunc: function(item, store){
			// summary:
			//		Computes the label to display based on the dojo.data store item.
			// item: Object
			//		The item from the store
			// store: dojo/store/api/Store
			//		The store.
			// returns:
			//		The label that the ComboBox should display
			// tags:
			//		private

			// Use toString() because XMLStore returns an XMLItem whereas this
			// method is expected to return a String (#9354).
			// Remove getValue() for 2.0 (old dojo.data API)
			return (store._oldAPI ? store.getValue(item, this.labelAttr || this.searchAttr) :
				item[this.labelAttr || this.searchAttr]).toString(); // String
		},

		_setValueAttr: function(/*String*/ value, /*Boolean?*/ priorityChange, /*String?*/ displayedValue, /*item?*/ item){
			// summary:
			//		Hook so set('value', value) works.
			// description:
			//		Sets the value of the select.
			this._set("item", item||null); // value not looked up in store
			if(value == null /* or undefined */){ value = ''; } // null translates to blank
			this.inherited(arguments);
		},
		_setTextDirAttr: function(/*String*/ textDir){
			// summary:
			//		Setter for textDir, needed for the dropDown's textDir update.
			// description:
			//		Users shouldn't call this function; they should be calling
			//		set('textDir', value)
			// tags:
			//		private
			this.inherited(arguments);
			// update the drop down also (_ComboBoxMenuMixin)
			if(this.dropDown){
				this.dropDown._set("textDir", textDir);
			}
		}
	});
});

},
'davinci/ve/DijitWidget':function(){
define([
	"require",
	"dojo/_base/declare",
	"dojo/_base/window",
	"dojo/_base/lang",
	"dojo/dom-attr",
	"dojo/parser",
	"./_Widget",
	"./metadata"
//	"./widget"
], function(
	require,
	declare,
	dwindow,
	dlang,
	domAttr,
	parser,
	_Widget,
	metadata
) {

var SCRATCHSPACE = '__DijitWidgetScratchSpace';

return declare("davinci.ve.DijitWidget", _Widget, {

	isDijitWidget: true,

	//FIXME: Horrible constructor design.
	//For CreateTool, all 6 params are passed in, but dijitWidget and widgetType have same value
	//For file opening, only dijitWidget (3rd param) and widgetType (6th param) are passed in.
	constructor: function(mixin, node, dijitWidget, metadata, srcElement, widgetType) {
		if (typeof dijitWidget === 'string') {
			// XXX we should just add dojo type in metadata and remove this code
			// add dojo type to node
			var type = domAttr.get(node, 'data-dojo-type') || domAttr.get(node, 'dojoType');
			if (!type) {
				domAttr.set(node, 'data-dojo-type', dijitWidget);
			}
			if (srcElement) {
				srcElement.addAttribute('data-dojo-type', dijitWidget);
			}

			var doc = node.ownerDocument,
				win = doc.defaultView,
				ss = doc[SCRATCHSPACE];
			if (!ss) {
				// Since node is sometimes completely replaced by the Dojo parser,
				// it needs a parent. Create (and cache) a DIV to use as the
				// temporary parent.
				ss = doc[SCRATCHSPACE] = doc.createElement('div');
			}
			ss.appendChild(node);

			// instantiate widget, in context of editor iframe
			var instances = win.require('dojo/parser').instantiate(
				[node],
				mixin,
				// Don't allow `instantiate()` to call the widget's `startup()`;
				// it's called later by Maqetta.
				{
					noStart: true
				}
			);
			dijitWidget = instances[0];

			if (ss.firstChild) {
				// remove from scratch space
				// - some widget (i.e. Dialog) get added to special locations,
				//   not to the parent of the incoming `node`.  Therefore, we
				//   need to check before removing child from `ss`.
				ss.removeChild(ss.firstChild);
			}

			// XXX move this block after `if`?
			this.domNode = dijitWidget.domNode;
			dijitWidget.domNode._dvWidget = this;
			this.isLayoutContainer = dijitWidget.isLayoutContainer;
		} else {
			if(!widgetType){
				this.type = dijitWidget.declaredClass.replace(/\./g, "/"); //FIXME: not a safe association;
			}else{
				this.type = widgetType.replace(/\./g, "/");
			}
		}

		var allowedChild = davinci.ve.metadata.getAllowedChild(this.type);
		this.acceptsHTMLChildren = allowedChild[0] === 'ANY' ||
								   allowedChild.toString().toUpperCase().indexOf('HTML') !== -1;
		this.dijitWidget=dijitWidget;
		this.containerNode=dijitWidget.containerNode;
		this.styleNode=dijitWidget.styleNode;
		this.id=dijitWidget.id;
	},

	getParent: function() {
		if(!this.dijitWidget || !this.dijitWidget.domNode || !this.dijitWidget.domNode.parentNode){
			return;
		}
		var veWidget = require("davinci/ve/widget");
		var widget = this.dijitWidget;
		do{
			widget = veWidget.getEnclosingWidget(widget.domNode.parentNode);
		}while(widget && widget.dijitWidget && widget.dijitWidget.declaredClass.split(".").pop().charAt(0) == "_");
			// skip intermediates, like _AccordionInnerContentPane
			//TODO: use widget.getParent() and have it support this behavior?
		return widget;
	},

	_getChildren: function(attach) {
        if (this.acceptsHTMLChildren) {
            return this.inherited(arguments);
        }

		var children=[];

		if (davinci.ve.metadata.getAllowedChild(this.type)[0] !== 'NONE') {
			this.dijitWidget.getChildren().forEach(function(child) {
				// The "_maqNotDVWidget" property on a Dijit indicates that even though
				// Dojo treats the given DOM node as a child, Maqetta should ignore it
				// This was necessary to deal with #3425 because Heading creates a real
				// widget (with data-dojo-type and everything) under the hood 
				// when the 'back' property gets a value. 
				// To use this feature, Helper functions on an ancestor
				// widget need to put this property on any child widgets that the Maqetta
				// page editor needs to ignore.
				// FIXME: There has to be a cleaner way of doing this.
				if(!child._maqNotDVWidget){
					if (attach) {
						children.push(require("davinci/ve/widget").getWidget(child.domNode));
					} else {
	                    var widget = child.domNode && child.domNode._dvWidget;
	                    if (widget) {
	                        children.push(widget);
	                    }
	                }
				}
			});
		}
		return children;
	},

	_getContainerNode: function() {
		return this.containerNode || this.domNode;
	},

	selectChild: function(widget)
	{
		if (this.dijitWidget.selectChild) {
			this.dijitWidget.selectChild(widget.dijitWidget);
		}
	},
	
	_addChildToDom: function(child, index) {
		// Dijit's addChild() only works for widgets whose children are all Dijit
		// widgets themselves.  Therefore, we only call that function if the
		// widget does not accept HTML children.
		if (!this.acceptsHTMLChildren) {
			this.dijitWidget.addChild(child.dijitWidget, index);
		} else {
			this.inherited(arguments);

			// See impl of dijit._Container.addChild()
			var dw = child.dijitWidget;
			if (dw && this.dijitWidget._started && !dw._started) {
				child.startup();
			}
		}
	},

    _removeChildFromDom: function(/*Widget*/child) {
        if (this.dijitWidget.removeChild && child.dijitWidget) {
            this.dijitWidget.removeChild(child.dijitWidget);
        } else {
            this.inherited(arguments);
        }
    },

    _getPropertyValue: function(name) {
        return this.dijitWidget.get(name);
    },

	startup: function() {
		this.dijitWidget.startup();
	},

	isLayout: function() {
		var context = this.getContext();
		// make sure we are comparing against the same two classes within same two documents
		var djit = context.getDijit();
		var retval = this.dijitWidget.isInstanceOf(djit.layout._LayoutWidget);
		return retval;
	},

	resize: function() {
		var helper = this.getHelper();
		if (helper && helper.resize) {
			helper.resize(this);
		} else {
			if (this.dijitWidget.resize) {
				this.dijitWidget.resize();
			}
		}
	},

	renderWidget: function() {
		if(this.dijitWidget.render) {
			this.dijitWidget.render();
		}else if(this.dijitWidget.chart) { // TODO: move to helper
			var box = dojo.marginBox(this.dijitWidget.domNode);
			this.dijitWidget.resize(box);
		}
		if (this.domNode.parentNode._dvWidget && this.domNode.parentNode._dvWidget.isDijitWidget) {
			this._refresh(this.domNode.parentNode);
		}
	},

	_refresh: function(node) {
		/* if the widget is a child of a dijitContainer widget
		 * we may need to refresh the parent to make it all look correct in page editor
		 */
		var parentNode = node.parentNode;
		if (parentNode._dvWidget && parentNode._dvWidget.isDijitWidget) {
			this._refresh(parentNode);
		} else if (node._dvWidget.resize) {
			node._dvWidget.resize(); // this step may not be needed
		}
	},

	_attr: function (name,value)
	{
		return this.dijitWidget.get.apply(this.dijitWidget, arguments);
	}
});

});

},
'dojox/grid/Selection':function(){
define([
	"dojo/_base/declare",
	"dojo/_base/array",
	"dojo/_base/lang",
	"dojo/dom-attr"
], function(declare, array, lang, domAttr){

return declare("dojox.grid.Selection", null, {
	// summary:
	//		Manages row selection for grid. Owned by grid and used internally
	//		for selection. Override to implement custom selection.

	constructor: function(inGrid){
		this.grid = inGrid;
		this.selected = [];

		this.setMode(inGrid.selectionMode);
	},

	mode: 'extended',

	selected: null,
	updating: 0,
	selectedIndex: -1,
	rangeStartIndex: -1,

	setMode: function(mode){
		if(this.selected.length){
			this.deselectAll();
		}
		if(mode != 'extended' && mode != 'multiple' && mode != 'single' && mode != 'none'){
			this.mode = 'extended';
		}else{
			this.mode = mode;
		}
	},

	onCanSelect: function(inIndex){
		return this.grid.onCanSelect(inIndex);
	},

	onCanDeselect: function(inIndex){
		return this.grid.onCanDeselect(inIndex);
	},

	onSelected: function(inIndex){
	},

	onDeselected: function(inIndex){
	},

	//onSetSelected: function(inIndex, inSelect) { };
	onChanging: function(){
	},

	onChanged: function(){
	},

	isSelected: function(inIndex){
		if(this.mode == 'none'){
			return false;
		}
		return this.selected[inIndex];
	},

	getFirstSelected: function(){
		if(!this.selected.length||this.mode == 'none'){ return -1; }
		for(var i=0, l=this.selected.length; i<l; i++){
			if(this.selected[i]){
				return i;
			}
		}
		return -1;
	},

	getNextSelected: function(inPrev){
		if(this.mode == 'none'){ return -1; }
		for(var i=inPrev+1, l=this.selected.length; i<l; i++){
			if(this.selected[i]){
				return i;
			}
		}
		return -1;
	},

	getSelected: function(){
		var result = [];
		for(var i=0, l=this.selected.length; i<l; i++){
			if(this.selected[i]){
				result.push(i);
			}
		}
		return result;
	},

	getSelectedCount: function(){
		var c = 0;
		for(var i=0; i<this.selected.length; i++){
			if(this.selected[i]){
				c++;
			}
		}
		return c;
	},

	_beginUpdate: function(){
		if(this.updating === 0){
			this.onChanging();
		}
		this.updating++;
	},

	_endUpdate: function(){
		this.updating--;
		if(this.updating === 0){
			this.onChanged();
		}
	},

	select: function(inIndex){
		if(this.mode == 'none'){ return; }
		if(this.mode != 'multiple'){
			this.deselectAll(inIndex);
			this.addToSelection(inIndex);
		}else{
			this.toggleSelect(inIndex);
		}
	},

	addToSelection: function(inIndex){
		if(this.mode == 'none'){ return; }
		if(lang.isArray(inIndex)){
			array.forEach(inIndex, this.addToSelection, this);
			return;
		}
		inIndex = Number(inIndex);
		if(this.selected[inIndex]){
			this.selectedIndex = inIndex;
		}else{
			if(this.onCanSelect(inIndex) !== false){
				this.selectedIndex = inIndex;
				var rowNode = this.grid.getRowNode(inIndex);
				if(rowNode){
					domAttr.set(rowNode, "aria-selected", "true");
				}
				this._beginUpdate();
				this.selected[inIndex] = true;
				//this.grid.onSelected(inIndex);
				this.onSelected(inIndex);
				//this.onSetSelected(inIndex, true);
				this._endUpdate();
			}
		}
	},

	deselect: function(inIndex){
		if(this.mode == 'none'){ return; }
		if(lang.isArray(inIndex)){
			array.forEach(inIndex, this.deselect, this);
			return;
		}
		inIndex = Number(inIndex);
		if(this.selectedIndex == inIndex){
			this.selectedIndex = -1;
		}
		if(this.selected[inIndex]){
			if(this.onCanDeselect(inIndex) === false){
				return;
			}
			var rowNode = this.grid.getRowNode(inIndex);
			if(rowNode){
				domAttr.set(rowNode, "aria-selected", "false");
			}
			this._beginUpdate();
			delete this.selected[inIndex];
			//this.grid.onDeselected(inIndex);
			this.onDeselected(inIndex);
			//this.onSetSelected(inIndex, false);
			this._endUpdate();
		}
	},

	setSelected: function(inIndex, inSelect){
		this[(inSelect ? 'addToSelection' : 'deselect')](inIndex);
	},

	toggleSelect: function(inIndex){
		if(lang.isArray(inIndex)){
			array.forEach(inIndex, this.toggleSelect, this);
			return;
		}
		this.setSelected(inIndex, !this.selected[inIndex]);
	},

	_range: function(inFrom, inTo, func){
		var s = (inFrom >= 0 ? inFrom : inTo), e = inTo;
		if(s > e){
			e = s;
			s = inTo;
		}
		for(var i=s; i<=e; i++){
			func(i);
		}
	},

	selectRange: function(inFrom, inTo){
		this._range(inFrom, inTo, lang.hitch(this, "addToSelection"));
	},

	deselectRange: function(inFrom, inTo){
		this._range(inFrom, inTo, lang.hitch(this, "deselect"));
	},

	insert: function(inIndex){
		this.selected.splice(inIndex, 0, false);
		if(this.selectedIndex >= inIndex){
			this.selectedIndex++;
		}
	},

	remove: function(inIndex){
		this.selected.splice(inIndex, 1);
		if(this.selectedIndex >= inIndex){
			this.selectedIndex--;
		}
	},

	deselectAll: function(inExcept){
		for(var i in this.selected){
			if((i!=inExcept)&&(this.selected[i]===true)){
				this.deselect(i);
			}
		}
	},

	clickSelect: function(inIndex, inCtrlKey, inShiftKey){
		if(this.mode == 'none'){ return; }
		this._beginUpdate();
		if(this.mode != 'extended'){
			this.select(inIndex);
		}else{
			if(!inShiftKey || this.rangeStartIndex < 0){
				this.rangeStartIndex = inIndex;
			}
			if(!inCtrlKey){
				this.deselectAll(inIndex);
			}
			if(inShiftKey){
				this.selectRange(this.rangeStartIndex, inIndex);
			}else if(inCtrlKey){
				this.toggleSelect(inIndex);
			}else{
				this.addToSelection(inIndex);
			}
		}
		this._endUpdate();
	},

	clickSelectEvent: function(e){
		this.clickSelect(e.rowIndex, dojo.isCopyKey(e), e.shiftKey);
	},

	clear: function(){
		this._beginUpdate();
		this.deselectAll();
		this._endUpdate();
	}
});
});
},
'url:dijit/layout/templates/_ScrollingTabControllerButton.html':"<div data-dojo-attach-event=\"onclick:_onClick\" class=\"dijitTabInnerDiv dijitTabContent dijitButtonContents\"  data-dojo-attach-point=\"focusNode\">\n\t<img role=\"presentation\" alt=\"\" src=\"${_blankGif}\" class=\"dijitTabStripIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t<span data-dojo-attach-point=\"containerNode,titleNode\" class=\"dijitButtonText\"></span>\n</div>",
'dijit/form/MappedTextBox':function(){
define([
	"dojo/_base/declare", // declare
	"dojo/dom-construct", // domConstruct.place
	"./ValidationTextBox"
], function(declare, domConstruct, ValidationTextBox){

	// module:
	//		dijit/form/MappedTextBox

	return declare("dijit.form.MappedTextBox", ValidationTextBox, {
		// summary:
		//		A dijit/form/ValidationTextBox subclass which provides a base class for widgets that have
		//		a visible formatted display value, and a serializable
		//		value in a hidden input field which is actually sent to the server.
		// description:
		//		The visible display may
		//		be locale-dependent and interactive.  The value sent to the server is stored in a hidden
		//		input field which uses the `name` attribute declared by the original widget.  That value sent
		//		to the server is defined by the dijit/form/MappedTextBox.serialize() method and is typically
		//		locale-neutral.
		// tags:
		//		protected

		postMixInProperties: function(){
			this.inherited(arguments);

			// we want the name attribute to go to the hidden <input>, not the displayed <input>,
			// so override _FormWidget.postMixInProperties() setting of nameAttrSetting
			this.nameAttrSetting = "";
		},

		// Override default behavior to assign name to focusNode
		_setNameAttr: null,

		serialize: function(val /*=====, options =====*/){
			// summary:
			//		Overridable function used to convert the get('value') result to a canonical
			//		(non-localized) string.  For example, will print dates in ISO format, and
			//		numbers the same way as they are represented in javascript.
			// val: anything
			// options: Object?
			// tags:
			//		protected extension
			return val.toString ? val.toString() : ""; // String
		},

		toString: function(){
			// summary:
			//		Returns widget as a printable string using the widget's value
			// tags:
			//		protected
			var val = this.filter(this.get('value')); // call filter in case value is nonstring and filter has been customized
			return val != null ? (typeof val == "string" ? val : this.serialize(val, this.constraints)) : ""; // String
		},

		validate: function(){
			// Overrides `dijit/form/TextBox.validate`
			this.valueNode.value = this.toString();
			return this.inherited(arguments);
		},

		buildRendering: function(){
			// Overrides `dijit/_TemplatedMixin/buildRendering`

			this.inherited(arguments);

			// Create a hidden <input> node with the serialized value used for submit
			// (as opposed to the displayed value).
			// Passing in name as markup rather than calling domConstruct.create() with an attrs argument
			// to make query(input[name=...]) work on IE. (see #8660)
			this.valueNode = domConstruct.place("<input type='hidden'" + (this.name ? ' name="' + this.name.replace(/"/g, "&quot;") + '"' : "") + "/>", this.textbox, "after");
		},

		reset: function(){
			// Overrides `dijit/form/ValidationTextBox.reset` to
			// reset the hidden textbox value to ''
			this.valueNode.value = '';
			this.inherited(arguments);
		}
	});
});

},
'dijit/form/ComboBoxMixin':function(){
define([
	"dojo/_base/declare", // declare
	"dojo/_base/Deferred",
	"dojo/_base/kernel", // kernel.deprecated
	"dojo/_base/lang", // lang.mixin
	"dojo/store/util/QueryResults",
	"./_AutoCompleterMixin",
	"./_ComboBoxMenu",
	"../_HasDropDown",
	"dojo/text!./templates/DropDownBox.html"
], function(declare, Deferred, kernel, lang, QueryResults, _AutoCompleterMixin, _ComboBoxMenu, _HasDropDown, template){


	// module:
	//		dijit/form/ComboBoxMixin

	return declare("dijit.form.ComboBoxMixin", [_HasDropDown, _AutoCompleterMixin], {
		// summary:
		//		Provides main functionality of ComboBox widget

		// dropDownClass: [protected extension] Function String
		//		Dropdown widget class used to select a date/time.
		//		Subclasses should specify this.
		dropDownClass: _ComboBoxMenu,

		// hasDownArrow: Boolean
		//		Set this textbox to have a down arrow button, to display the drop down list.
		//		Defaults to true.
		hasDownArrow: true,

		templateString: template,

		baseClass: "dijitTextBox dijitComboBox",

		/*=====
		// store: [const] dojo/store/api/Store|dojo/data/api/Read
		//		Reference to data provider object used by this ComboBox.
		//
		//		Should be dojo/store/api/Store, but dojo/data/api/Read supported
		//		for backwards compatibility.
		store: null,
		=====*/

		// Set classes like dijitDownArrowButtonHover depending on
		// mouse action over button node
		cssStateNodes: {
			"_buttonNode": "dijitDownArrowButton"
		},

		_setHasDownArrowAttr: function(/*Boolean*/ val){
			this._set("hasDownArrow", val);
			this._buttonNode.style.display = val ? "" : "none";
		},

		_showResultList: function(){
			// hide the tooltip
			this.displayMessage("");
			this.inherited(arguments);
		},

		_setStoreAttr: function(store){
			// For backwards-compatibility, accept dojo.data store in addition to dojo/store/api/Store.  Remove in 2.0.
			if(!store.get){
				lang.mixin(store, {
					_oldAPI: true,
					get: function(id){
						// summary:
						//		Retrieves an object by it's identity. This will trigger a fetchItemByIdentity.
						//		Like dojo/store/DataStore.get() except returns native item.
						var deferred = new Deferred();
						this.fetchItemByIdentity({
							identity: id,
							onItem: function(object){
								deferred.resolve(object);
							},
							onError: function(error){
								deferred.reject(error);
							}
						});
						return deferred.promise;
					},
					query: function(query, options){
						// summary:
						//		Queries the store for objects.   Like dojo/store/DataStore.query()
						//		except returned Deferred contains array of native items.
						var deferred = new Deferred(function(){ fetchHandle.abort && fetchHandle.abort(); });
						deferred.total = new Deferred();
						var fetchHandle = this.fetch(lang.mixin({
							query: query,
							onBegin: function(count){
								deferred.total.resolve(count);
							},
							onComplete: function(results){
								deferred.resolve(results);
							},
							onError: function(error){
								deferred.reject(error);
							}
						}, options));
						return QueryResults(deferred);
					}
				});
			}
			this._set("store", store);
		},

		postMixInProperties: function(){
			// Since _setValueAttr() depends on this.store, _setStoreAttr() needs to execute first.
			// Unfortunately, without special code, it ends up executing second.
			var store = this.params.store || this.store;
			if(store){
				this._setStoreAttr(store);
			}

			this.inherited(arguments);

			// User may try to access this.store.getValue() etc.  in a custom labelFunc() function.
			// It's not available with the new data store for handling inline <option> tags, so add it.
			if(!this.params.store && !this.store._oldAPI){
				var clazz = this.declaredClass;
				lang.mixin(this.store, {
					getValue: function(item, attr){
						kernel.deprecated(clazz + ".store.getValue(item, attr) is deprecated for builtin store.  Use item.attr directly", "", "2.0");
						return item[attr];
					},
					getLabel: function(item){
						kernel.deprecated(clazz + ".store.getLabel(item) is deprecated for builtin store.  Use item.label directly", "", "2.0");
						return item.name;
					},
					fetch: function(args){
						kernel.deprecated(clazz + ".store.fetch() is deprecated for builtin store.", "Use store.query()", "2.0");
						var shim = ["dojo/data/ObjectStore"];	// indirection so it doesn't get rolled into a build
						require(shim, lang.hitch(this, function(ObjectStore){
							new ObjectStore({objectStore: this}).fetch(args);
						}));
					}
				});
			}
		}
	});
});

},
'dijit/form/_TextBoxMixin':function(){
define([
	"dojo/_base/array", // array.forEach
	"dojo/_base/declare", // declare
	"dojo/dom", // dom.byId
	"dojo/_base/event", // event.stop
	"dojo/keys", // keys.ALT keys.CAPS_LOCK keys.CTRL keys.META keys.SHIFT
	"dojo/_base/lang", // lang.mixin
	"dojo/on", // on
	"../main"	// for exporting dijit._setSelectionRange, dijit.selectInputText
], function(array, declare, dom, event, keys, lang, on, dijit){

// module:
//		dijit/form/_TextBoxMixin

var _TextBoxMixin = declare("dijit.form._TextBoxMixin", null, {
	// summary:
	//		A mixin for textbox form input widgets

	// trim: Boolean
	//		Removes leading and trailing whitespace if true.  Default is false.
	trim: false,

	// uppercase: Boolean
	//		Converts all characters to uppercase if true.  Default is false.
	uppercase: false,

	// lowercase: Boolean
	//		Converts all characters to lowercase if true.  Default is false.
	lowercase: false,

	// propercase: Boolean
	//		Converts the first character of each word to uppercase if true.
	propercase: false,

	// maxLength: String
	//		HTML INPUT tag maxLength declaration.
	maxLength: "",

	// selectOnClick: [const] Boolean
	//		If true, all text will be selected when focused with mouse
	selectOnClick: false,

	// placeHolder: String
	//		Defines a hint to help users fill out the input field (as defined in HTML 5).
	//		This should only contain plain text (no html markup).
	placeHolder: "",

	_getValueAttr: function(){
		// summary:
		//		Hook so get('value') works as we like.
		// description:
		//		For `dijit/form/TextBox` this basically returns the value of the `<input>`.
		//
		//		For `dijit/form/MappedTextBox` subclasses, which have both
		//		a "displayed value" and a separate "submit value",
		//		This treats the "displayed value" as the master value, computing the
		//		submit value from it via this.parse().
		return this.parse(this.get('displayedValue'), this.constraints);
	},

	_setValueAttr: function(value, /*Boolean?*/ priorityChange, /*String?*/ formattedValue){
		// summary:
		//		Hook so set('value', ...) works.
		//
		// description:
		//		Sets the value of the widget to "value" which can be of
		//		any type as determined by the widget.
		//
		// value:
		//		The visual element value is also set to a corresponding,
		//		but not necessarily the same, value.
		//
		// formattedValue:
		//		If specified, used to set the visual element value,
		//		otherwise a computed visual value is used.
		//
		// priorityChange:
		//		If true, an onChange event is fired immediately instead of
		//		waiting for the next blur event.

		var filteredValue;
		if(value !== undefined){
			// TODO: this is calling filter() on both the display value and the actual value.
			// I added a comment to the filter() definition about this, but it should be changed.
			filteredValue = this.filter(value);
			if(typeof formattedValue != "string"){
				if(filteredValue !== null && ((typeof filteredValue != "number") || !isNaN(filteredValue))){
					formattedValue = this.filter(this.format(filteredValue, this.constraints));
				}else{ formattedValue = ''; }
			}
		}
		if(formattedValue != null /* and !undefined */ && ((typeof formattedValue) != "number" || !isNaN(formattedValue)) && this.textbox.value != formattedValue){
			this.textbox.value = formattedValue;
			this._set("displayedValue", this.get("displayedValue"));
		}

		if(this.textDir == "auto"){
			this.applyTextDir(this.focusNode, formattedValue);
		}

		this.inherited(arguments, [filteredValue, priorityChange]);
	},

	// displayedValue: String
	//		For subclasses like ComboBox where the displayed value
	//		(ex: Kentucky) and the serialized value (ex: KY) are different,
	//		this represents the displayed value.
	//
	//		Setting 'displayedValue' through set('displayedValue', ...)
	//		updates 'value', and vice-versa.  Otherwise 'value' is updated
	//		from 'displayedValue' periodically, like onBlur etc.
	//
	//		TODO: move declaration to MappedTextBox?
	//		Problem is that ComboBox references displayedValue,
	//		for benefit of FilteringSelect.
	displayedValue: "",

	_getDisplayedValueAttr: function(){
		// summary:
		//		Hook so get('displayedValue') works.
		// description:
		//		Returns the displayed value (what the user sees on the screen),
		//		after filtering (ie, trimming spaces etc.).
		//
		//		For some subclasses of TextBox (like ComboBox), the displayed value
		//		is different from the serialized value that's actually
		//		sent to the server (see `dijit/form/ValidationTextBox.serialize()`)

		// TODO: maybe we should update this.displayedValue on every keystroke so that we don't need
		// this method
		// TODO: this isn't really the displayed value when the user is typing
		return this.filter(this.textbox.value);
	},

	_setDisplayedValueAttr: function(/*String*/ value){
		// summary:
		//		Hook so set('displayedValue', ...) works.
		// description:
		//		Sets the value of the visual element to the string "value".
		//		The widget value is also set to a corresponding,
		//		but not necessarily the same, value.

		if(value == null /* or undefined */){ value = '' }
		else if(typeof value != "string"){ value = String(value) }

		this.textbox.value = value;

		// sets the serialized value to something corresponding to specified displayedValue
		// (if possible), and also updates the textbox.value, for example converting "123"
		// to "123.00"
		this._setValueAttr(this.get('value'), undefined);

		this._set("displayedValue", this.get('displayedValue'));

		// textDir support
		if(this.textDir == "auto"){
			this.applyTextDir(this.focusNode, value);
		}
	},

	format: function(value /*=====, constraints =====*/){
		// summary:
		//		Replaceable function to convert a value to a properly formatted string.
		// value: String
		// constraints: Object
		// tags:
		//		protected extension
		return value == null /* or undefined */ ? "" : (value.toString ? value.toString() : value);
	},

	parse: function(value /*=====, constraints =====*/){
		// summary:
		//		Replaceable function to convert a formatted string to a value
		// value: String
		// constraints: Object
		// tags:
		//		protected extension

		return value;	// String
	},

	_refreshState: function(){
		// summary:
		//		After the user types some characters, etc., this method is
		//		called to check the field for validity etc.  The base method
		//		in `dijit/form/TextBox` does nothing, but subclasses override.
		// tags:
		//		protected
	},

	/*=====
	onInput: function(event){
		// summary:
		//		Connect to this function to receive notifications of various user data-input events.
		//		Return false to cancel the event and prevent it from being processed.
		// event:
		//		keydown | keypress | cut | paste | input
		// tags:
		//		callback
	},
	=====*/
	onInput: function(){},

	__skipInputEvent: false,
	_onInput: function(/*Event*/ evt){
		// summary:
		//		Called AFTER the input event has happened

		// set text direction according to textDir that was defined in creation
		if(this.textDir == "auto"){
			this.applyTextDir(this.focusNode, this.focusNode.value);
		}

		this._processInput(evt);
	},

	_processInput: function(/*Event*/ evt){
		// summary:
		//		Default action handler for user input events

		this._refreshState();

		// In case someone is watch()'ing for changes to displayedValue
		this._set("displayedValue", this.get("displayedValue"));
	},

	postCreate: function(){
		// setting the value here is needed since value="" in the template causes "undefined"
		// and setting in the DOM (instead of the JS object) helps with form reset actions
		this.textbox.setAttribute("value", this.textbox.value); // DOM and JS values should be the same

		this.inherited(arguments);

		// normalize input events to reduce spurious event processing
		//	onkeydown: do not forward modifier keys
		//		       set charOrCode to numeric keycode
		//	onkeypress: do not forward numeric charOrCode keys (already sent through onkeydown)
		//	onpaste & oncut: set charOrCode to 229 (IME)
		//	oninput: if primary event not already processed, set charOrCode to 229 (IME), else do not forward
		var handleEvent = function(e){
			var charOrCode;
			if(e.type == "keydown"){
				charOrCode = e.keyCode;
				switch(charOrCode){ // ignore state keys
					case keys.SHIFT:
					case keys.ALT:
					case keys.CTRL:
					case keys.META:
					case keys.CAPS_LOCK:
					case keys.NUM_LOCK:
					case keys.SCROLL_LOCK:
						return;
				}
				if(!e.ctrlKey && !e.metaKey && !e.altKey){ // no modifiers
					switch(charOrCode){ // ignore location keys
						case keys.NUMPAD_0:
						case keys.NUMPAD_1:
						case keys.NUMPAD_2:
						case keys.NUMPAD_3:
						case keys.NUMPAD_4:
						case keys.NUMPAD_5:
						case keys.NUMPAD_6:
						case keys.NUMPAD_7:
						case keys.NUMPAD_8:
						case keys.NUMPAD_9:
						case keys.NUMPAD_MULTIPLY:
						case keys.NUMPAD_PLUS:
						case keys.NUMPAD_ENTER:
						case keys.NUMPAD_MINUS:
						case keys.NUMPAD_PERIOD:
						case keys.NUMPAD_DIVIDE:
							return;
					}
					if((charOrCode >= 65 && charOrCode <= 90) || (charOrCode >= 48 && charOrCode <= 57) || charOrCode == keys.SPACE){
						return; // keypress will handle simple non-modified printable keys
					}
					var named = false;
					for(var i in keys){
						if(keys[i] === e.keyCode){
							named = true;
							break;
						}
					}
					if(!named){ return; } // only allow named ones through
				}
			}
			charOrCode = e.charCode >= 32 ? String.fromCharCode(e.charCode) : e.charCode;
			if(!charOrCode){
				charOrCode = (e.keyCode >= 65 && e.keyCode <= 90) || (e.keyCode >= 48 && e.keyCode <= 57) || e.keyCode == keys.SPACE ? String.fromCharCode(e.keyCode) : e.keyCode;
			}
			if(!charOrCode){
				charOrCode = 229; // IME
			}
			if(e.type == "keypress"){
				if(typeof charOrCode != "string"){ return; }
				if((charOrCode >= 'a' && charOrCode <= 'z') || (charOrCode >= 'A' && charOrCode <= 'Z') || (charOrCode >= '0' && charOrCode <= '9') || (charOrCode === ' ')){
					if(e.ctrlKey || e.metaKey || e.altKey){ return; } // can only be stopped reliably in keydown
				}
			}
			if(e.type == "input"){
				if(this.__skipInputEvent){ // duplicate event
					this.__skipInputEvent = false;
					return;
				}
			}else{
				this.__skipInputEvent = true;
			}
			// create fake event to set charOrCode and to know if preventDefault() was called
			var faux = { faux: true }, attr;
			for(attr in e){
				if(attr != "layerX" && attr != "layerY"){ // prevent WebKit warnings
					var v = e[attr];
					if(typeof v != "function" && typeof v != "undefined"){ faux[attr] = v; }
				}
			}
			lang.mixin(faux, {
				charOrCode: charOrCode,
				_wasConsumed: false,
				preventDefault: function(){
					faux._wasConsumed = true;
					e.preventDefault();
				},
				stopPropagation: function(){ e.stopPropagation(); }
			});
			// give web page author a chance to consume the event
			//console.log(faux.type + ', charOrCode = (' + (typeof charOrCode) + ') ' + charOrCode + ', ctrl ' + !!faux.ctrlKey + ', alt ' + !!faux.altKey + ', meta ' + !!faux.metaKey + ', shift ' + !!faux.shiftKey);
			if(this.onInput(faux) === false){ // return false means stop
				faux.preventDefault();
				faux.stopPropagation();
			}
			if(faux._wasConsumed){ return; } // if preventDefault was called
			this.defer(function(){ this._onInput(faux); }); // widget notification after key has posted
		};
		this.own(on(this.textbox, "keydown, keypress, paste, cut, input, compositionend", lang.hitch(this, handleEvent)));
	},

	_blankValue: '', // if the textbox is blank, what value should be reported
	filter: function(val){
		// summary:
		//		Auto-corrections (such as trimming) that are applied to textbox
		//		value on blur or form submit.
		// description:
		//		For MappedTextBox subclasses, this is called twice
		//
		//		- once with the display value
		//		- once the value as set/returned by set('value', ...)
		//
		//		and get('value'), ex: a Number for NumberTextBox.
		//
		//		In the latter case it does corrections like converting null to NaN.  In
		//		the former case the NumberTextBox.filter() method calls this.inherited()
		//		to execute standard trimming code in TextBox.filter().
		//
		//		TODO: break this into two methods in 2.0
		//
		// tags:
		//		protected extension
		if(val === null){ return this._blankValue; }
		if(typeof val != "string"){ return val; }
		if(this.trim){
			val = lang.trim(val);
		}
		if(this.uppercase){
			val = val.toUpperCase();
		}
		if(this.lowercase){
			val = val.toLowerCase();
		}
		if(this.propercase){
			val = val.replace(/[^\s]+/g, function(word){
				return word.substring(0,1).toUpperCase() + word.substring(1);
			});
		}
		return val;
	},

	_setBlurValue: function(){
		this._setValueAttr(this.get('value'), true);
	},

	_onBlur: function(e){
		if(this.disabled){ return; }
		this._setBlurValue();
		this.inherited(arguments);
	},

	_isTextSelected: function(){
		return this.textbox.selectionStart != this.textbox.selectionEnd;
	},

	_onFocus: function(/*String*/ by){
		if(this.disabled || this.readOnly){ return; }

		// Select all text on focus via click if nothing already selected.
		// Since mouse-up will clear the selection, need to defer selection until after mouse-up.
		// Don't do anything on focus by tabbing into the widget since there's no associated mouse-up event.
		if(this.selectOnClick && by == "mouse"){
			this._selectOnClickHandle = this.connect(this.domNode, "onmouseup", function(){
				// Only select all text on first click; otherwise users would have no way to clear
				// the selection.
				this.disconnect(this._selectOnClickHandle);
				this._selectOnClickHandle = null;

				// Check if the user selected some text manually (mouse-down, mouse-move, mouse-up)
				// and if not, then select all the text
				if(!this._isTextSelected()){
					_TextBoxMixin.selectInputText(this.textbox);
				}
			});
			// in case the mouseup never comes
			this.defer(function(){ 
				if(this._selectOnClickHandle){
					this.disconnect(this._selectOnClickHandle);
					this._selectOnClickHandle = null;
				}
			}, 500); // if mouseup not received soon, then treat it as some gesture
		}
		// call this.inherited() before refreshState(), since this.inherited() will possibly scroll the viewport
		// (to scroll the TextBox into view), which will affect how _refreshState() positions the tooltip
		this.inherited(arguments);

		this._refreshState();
	},

	reset: function(){
		// Overrides `dijit/_FormWidget/reset()`.
		// Additionally resets the displayed textbox value to ''
		this.textbox.value = '';
		this.inherited(arguments);
	},

	_setTextDirAttr: function(/*String*/ textDir){
		// summary:
		//		Setter for textDir.
		// description:
		//		Users shouldn't call this function; they should be calling
		//		set('textDir', value)
		// tags:
		//		private

		// only if new textDir is different from the old one
		// and on widgets creation.
		if(!this._created
			|| this.textDir != textDir){
				this._set("textDir", textDir);
				// so the change of the textDir will take place immediately.
				this.applyTextDir(this.focusNode, this.focusNode.value);
		}
	}
});


_TextBoxMixin._setSelectionRange = dijit._setSelectionRange = function(/*DomNode*/ element, /*Number?*/ start, /*Number?*/ stop){
	if(element.setSelectionRange){
		element.setSelectionRange(start, stop);
	}
};

_TextBoxMixin.selectInputText = dijit.selectInputText = function(/*DomNode*/ element, /*Number?*/ start, /*Number?*/ stop){
	// summary:
	//		Select text in the input element argument, from start (default 0), to stop (default end).

	// TODO: use functions in _editor/selection.js?
	element = dom.byId(element);
	if(isNaN(start)){ start = 0; }
	if(isNaN(stop)){ stop = element.value ? element.value.length : 0; }
	try{
		element.focus();
		_TextBoxMixin._setSelectionRange(element, start, stop);
	}catch(e){ /* squelch random errors (esp. on IE) from unexpected focus changes or DOM nodes being hidden */ }
};

return _TextBoxMixin;
});

},
'davinci/html/HTMLModel':function(){
define([
	"dojo/_base/declare",
	"davinci/model/Model"
], function(declare, Model) {

if (!davinci.html) {
    davinci.html={};
}

davinci.html._noFormatElements = {
    span:true,
    b:true,
    it:true
};

davinci.html.escapeXml = function(value) {
    if(!value){
        return value;
    }
    return value.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
};

davinci.html.unEscapeXml = function(value) {
    if(!value || typeof value !== "string") {
        return value;
    }
    return value.replace(/&quot;/g, '"').replace(/&gt;/g, ">").replace(/&lt;/g, "<").replace(/&amp;/g, "&");
};

return declare("davinci.html.HTMLModel", Model, {
});
});
},
'dijit/form/SimpleTextarea':function(){
define([
	"dojo/_base/declare", // declare
	"dojo/dom-class", // domClass.add
	"dojo/sniff", // has("ie") has("opera")
	"./TextBox"
], function(declare, domClass, has, TextBox){

// module:
//		dijit/form/SimpleTextarea


return declare("dijit.form.SimpleTextarea", TextBox, {
	// summary:
	//		A simple textarea that degrades, and responds to
	//		minimal LayoutContainer usage, and works with dijit/form/Form.
	//		Doesn't automatically size according to input, like Textarea.
	//
	// example:
	//	|	<textarea data-dojo-type="dijit/form/SimpleTextarea" name="foo" value="bar" rows=30 cols=40></textarea>
	//
	// example:
	//	|	new SimpleTextarea({ rows:20, cols:30 }, "foo");

	baseClass: "dijitTextBox dijitTextArea",

	// rows: Number
	//		The number of rows of text.
	rows: "3",

	// rows: Number
	//		The number of characters per line.
	cols: "20",

	templateString: "<textarea ${!nameAttrSetting} data-dojo-attach-point='focusNode,containerNode,textbox' autocomplete='off'></textarea>",

	postMixInProperties: function(){
		// Copy value from srcNodeRef, unless user specified a value explicitly (or there is no srcNodeRef)
		// TODO: parser will handle this in 2.0
		if(!this.value && this.srcNodeRef){
			this.value = this.srcNodeRef.value;
		}
		this.inherited(arguments);
	},

	buildRendering: function(){
		this.inherited(arguments);
		if(has("ie") && this.cols){ // attribute selectors is not supported in IE6
			domClass.add(this.textbox, "dijitTextAreaCols");
		}
	},

	filter: function(/*String*/ value){
		// Override TextBox.filter to deal with newlines... specifically (IIRC) this is for IE which writes newlines
		// as \r\n instead of just \n
		if(value){
			value = value.replace(/\r/g,"");
		}
		return this.inherited(arguments);
	},

	_onInput: function(/*Event?*/ e){
		// Override TextBox._onInput() to enforce maxLength restriction
		if(this.maxLength){
			var maxLength = parseInt(this.maxLength);
			var value = this.textbox.value.replace(/\r/g,'');
			var overflow = value.length - maxLength;
			if(overflow > 0){
				var textarea = this.textbox;
				if(textarea.selectionStart){
					var pos = textarea.selectionStart;
					var cr = 0;
					if(has("opera")){
						cr = (this.textbox.value.substring(0,pos).match(/\r/g) || []).length;
					}
					this.textbox.value = value.substring(0,pos-overflow-cr)+value.substring(pos-cr);
					textarea.setSelectionRange(pos-overflow, pos-overflow);
				}else if(this.ownerDocument.selection){ //IE
					textarea.focus();
					var range = this.ownerDocument.selection.createRange();
					// delete overflow characters
					range.moveStart("character", -overflow);
					range.text = '';
					// show cursor
					range.select();
				}
			}
		}
		this.inherited(arguments);
	}
});

});

},
'davinci/js/JSModel':function(){
define([
	"dojo/_base/declare",
	"davinci/model/Model"
], function(declare, Model) {

if (!davinci.js) {
    davinci.js = {};
}

return declare("davinci.js.JSModel", Model, {
});
});

},
'url:dijit/layout/templates/_TabButton.html':"<div role=\"presentation\" data-dojo-attach-point=\"titleNode,innerDiv,tabContent\" class=\"dijitTabInner dijitTabContent\">\n\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon dijitTabButtonIcon\" data-dojo-attach-point='iconNode'/>\n\t<span data-dojo-attach-point='containerNode,focusNode' class='tabLabel'></span>\n\t<span class=\"dijitInline dijitTabCloseButton dijitTabCloseIcon\" data-dojo-attach-point='closeNode'\n\t\t  role=\"presentation\">\n\t\t<span data-dojo-attach-point='closeText' class='dijitTabCloseText'>[x]</span\n\t\t\t\t></span>\n</div>\n",
'davinci/review/model/resource/root':function(){
define([
	"dojo/_base/declare",
	"davinci/model/resource/Resource",
	"davinci/review/model/resource/Folder",
	"davinci/Runtime",
	"dojo/Deferred"
], function(declare, Resource, reviewFolder, Runtime, Deferred) {

var root = declare(Resource, {

	constructor: function(args) {
		this.elementType = "ReviewRoot";
		this.name = "root";
		this.parent = null;
	},

	findFile: function(version, fileName) {
		var promise = new Deferred();
		this.getChildren(function(children) {
			var node = null;
			dojo.forEach(children, function(item) {
				if (item.timeStamp == version) {
					node = item;
				}
			});
	
			var result = null;
			if (node != null) {
				node.getChildren(function(children) {
					dojo.forEach(children, function(item) {
						if (this._fileNamesEqual(item.name, fileName)) { 
							result = item;
						}
					}.bind(this));
					promise.resolve(result);
				}.bind(this));
			}
		}.bind(this));
		return promise;
	},
	
	_fileNamesEqual: function(file1, file2) {
		if (file1.indexOf("./") != 0) {
			file1 = "./" + file1;
		}
		if (file2.indexOf("./") != 0) {
			file2 = "./" + file2;
		}
		
		return file1 === file2;
	},

	findVersion: function(designerId, version) {
		var promise = new Deferred();
		
		//Get the top-level nodes of the tree (e.g., the children)
		this.getChildren(function(children) {
			//Look amongst the children for a match
			var foundVersion = null;
			dojo.some(children,function(item){
				if (item.designerId == designerId && item.timeStamp == version) {
					foundVersion = item;
					return true;
				}
				return false;
			});
			promise.resolve(foundVersion);
		});
		
		return promise;
	},

	getChildren: function(onComplete, onError) {
		if (!this._isLoaded) {
			if (this._loading) {
				this._loading.push(onComplete);
				return;
			}
			this._loading = [];
			this._loading.push(onComplete);
			
			Runtime.serverJSONRequest({
				url:  "cmd/listVersions",
				load : dojo.hitch(this, function(responseObject, ioArgs) {
					this.children=[];
					for (var i=0; i<responseObject.length; i++) {
						var child = new reviewFolder(dojo.mixin({
							name:responseObject[i].versionTitle,
							parent:this
						},responseObject[i]));
						this.children.push(child);
					}
					this._isLoaded=true;
					dojo.forEach(this._loading,function(item) {
						(item)(this.children);
					},this);
					delete this._loading;
				})
			});
			return;
		}
		onComplete(this.children);
	},
	
	getPath: function() {
		return ".review/snapshot";
	}

});

return dojo.setObject("davinci.review.model.resource.root", new root());

});
     

},
'dijit/PopupMenuItem':function(){
define([
	"dojo/_base/declare", // declare
	"dojo/dom-style", // domStyle.set
	"dojo/query", // query
	"./registry",	// registry.byNode
	"./MenuItem",
	"./hccss"
], function(declare, domStyle, query, registry, MenuItem){

	// module:
	//		dijit/PopupMenuItem

	return declare("dijit.PopupMenuItem", MenuItem, {
		// summary:
		//		An item in a Menu that spawn a drop down (usually a drop down menu)

		_fillContent: function(){
			// summary:
			//		When Menu is declared in markup, this code gets the menu label and
			//		the popup widget from the srcNodeRef.
			// description:
			//		srcNodeRefinnerHTML contains both the menu item text and a popup widget
			//		The first part holds the menu item text and the second part is the popup
			// example:
			// |	<div data-dojo-type="dijit/PopupMenuItem">
			// |		<span>pick me</span>
			// |		<popup> ... </popup>
			// |	</div>
			// tags:
			//		protected

			if(this.srcNodeRef){
				var nodes = query("*", this.srcNodeRef);
				this.inherited(arguments, [nodes[0]]);

				// save pointer to srcNode so we can grab the drop down widget after it's instantiated
				this.dropDownContainer = this.srcNodeRef;
			}
		},

		startup: function(){
			if(this._started){ return; }
			this.inherited(arguments);

			// we didn't copy the dropdown widget from the this.srcNodeRef, so it's in no-man's
			// land now.  move it to win.doc.body.
			if(!this.popup){
				var node = query("[widgetId]", this.dropDownContainer)[0];
				this.popup = registry.byNode(node);
			}
			this.ownerDocumentBody.appendChild(this.popup.domNode);
			this.popup.startup();

			this.popup.domNode.style.display="none";
			if(this.arrowWrapper){
				domStyle.set(this.arrowWrapper, "visibility", "");
			}
			this.focusNode.setAttribute("aria-haspopup", "true");
		},

		destroyDescendants: function(/*Boolean*/ preserveDom){
			if(this.popup){
				// Destroy the popup, unless it's already been destroyed.  This can happen because
				// the popup is a direct child of <body> even though it's logically my child.
				if(!this.popup._destroyed){
					this.popup.destroyRecursive(preserveDom);
				}
				delete this.popup;
			}
			this.inherited(arguments);
		}
	});
});

},
'dijit/_TimePicker':function(){
define([
	"dojo/_base/array", // array.forEach
	"dojo/date", // date.compare
	"dojo/date/locale", // locale.format
	"dojo/date/stamp", // stamp.fromISOString stamp.toISOString
	"dojo/_base/declare", // declare
	"dojo/dom-class", // domClass.add domClass.contains domClass.toggle
	"dojo/dom-construct", // domConstruct.create
	"dojo/_base/event", // event.stop
	"dojo/_base/kernel", // deprecated
	"dojo/keys", // keys
	"dojo/_base/lang", // lang.mixin
	"dojo/sniff", // has(...)
	"dojo/query", // query
	"dojo/mouse", // mouse.wheel
	"./typematic",
	"./_Widget",
	"./_TemplatedMixin",
	"./form/_FormValueWidget",
	"dojo/text!./templates/TimePicker.html"
], function(array, ddate, locale, stamp, declare, domClass, domConstruct, event, kernel, keys, lang, has, query, mouse,
			typematic, _Widget, _TemplatedMixin, _FormValueWidget, template){

	// module:
	//		dijit/_TimePicker


	var TimePicker = declare("dijit._TimePicker", [_Widget, _TemplatedMixin], {
		// summary:
		//		A graphical time picker.
		//		This widget is used internally by other widgets and is not available
		//		as a standalone widget due to lack of accessibility support.

		templateString: template,

		// baseClass: [protected] String
		//		The root className to use for the various states of this widget
		baseClass: "dijitTimePicker",

		// clickableIncrement: String
		//		ISO-8601 string representing the amount by which
		//		every clickable element in the time picker increases.
		//		Set in local time, without a time zone.
		//		Example: `T00:15:00` creates 15 minute increments
		//		Must divide dijit/_TimePicker.visibleIncrement evenly
		clickableIncrement: "T00:15:00",

		// visibleIncrement: String
		//		ISO-8601 string representing the amount by which
		//		every element with a visible time in the time picker increases.
		//		Set in local time, without a time zone.
		//		Example: `T01:00:00` creates text in every 1 hour increment
		visibleIncrement: "T01:00:00",

		// visibleRange: String
		//		ISO-8601 string representing the range of this TimePicker.
		//		The TimePicker will only display times in this range.
		//		Example: `T05:00:00` displays 5 hours of options
		visibleRange: "T05:00:00",

		// value: String
		//		Date to display.
		//		Defaults to current time and date.
		//		Can be a Date object or an ISO-8601 string.
		//		If you specify the GMT time zone (`-01:00`),
		//		the time will be converted to the local time in the local time zone.
		//		Otherwise, the time is considered to be in the local time zone.
		//		If you specify the date and isDate is true, the date is used.
		//		Example: if your local time zone is `GMT -05:00`,
		//		`T10:00:00` becomes `T10:00:00-05:00` (considered to be local time),
		//		`T10:00:00-01:00` becomes `T06:00:00-05:00` (4 hour difference),
		//		`T10:00:00Z` becomes `T05:00:00-05:00` (5 hour difference between Zulu and local time)
		//		`yyyy-mm-ddThh:mm:ss` is the format to set the date and time
		//		Example: `2007-06-01T09:00:00`
		value: new Date(),

		_visibleIncrement:2,
		_clickableIncrement:1,
		_totalIncrements:10,

		// constraints: TimePicker.__Constraints
		//		Specifies valid range of times (start time, end time)
		constraints:{},

/*=====
		serialize: function(val, options){
			// summary:
			//		User overridable function used to convert the attr('value') result to a String
			// val: Date
			//		The current value
			// options: Object?
			// tags:
			//		protected
		},
=====*/
		serialize: stamp.toISOString,

/*=====
		// filterString: string
		//		The string to filter by
		filterString: "",
=====*/

		setValue: function(/*Date*/ value){
			// summary:
			//		Deprecated.  Used set('value') instead.
			// tags:
			//		deprecated
			kernel.deprecated("dijit._TimePicker:setValue() is deprecated.  Use set('value', ...) instead.", "", "2.0");
			this.set('value', value);
		},

		_setValueAttr: function(/*Date*/ date){
			// summary:
			//		Hook so set('value', ...) works.
			// description:
			//		Set the value of the TimePicker.
			//		Redraws the TimePicker around the new date.
			// tags:
			//		protected
			this._set("value", date);
			this._showText();
		},

		_setFilterStringAttr: function(val){
			// summary:
			//		Called by TimeTextBox to filter the values shown in my list
			this._set("filterString", val);
			this._showText();
		},

		isDisabledDate: function(/*===== dateObject, locale =====*/){
			// summary:
			//		May be overridden to disable certain dates in the TimePicker e.g. `isDisabledDate=locale.isWeekend`
			// dateObject: Date
			// locale: String?
			// type:
			//		extension
			return false; // Boolean
		},

		_getFilteredNodes: function(/*number*/ start, /*number*/ maxNum, /*Boolean*/ before, /*DOMnode*/ lastNode){
			// summary:
			//		Returns an array of nodes with the filter applied.  At most maxNum nodes
			//		will be returned - but fewer may be returned as well.  If the
			//		before parameter is set to true, then it will return the elements
			//		before the given index
			// tags:
			//		private
			var
				nodes = [],
				lastValue = lastNode ? lastNode.date : this._refDate,
				n,
				i = start,
				max = this._maxIncrement + Math.abs(i),
				chk = before ? -1 : 1,
				dec = before ? 1 : 0,
				inc = 1 - dec;
			do{
				i -= dec;
				n = this._createOption(i);
				if(n){
					if((before && n.date > lastValue) || (!before && n.date < lastValue)){
						break; // don't wrap
					}
					nodes[before ? "unshift" : "push"](n);
					lastValue = n.date;
				}
				i += inc;
			}while(nodes.length < maxNum && (i*chk) < max);
			return nodes;
		},

		_showText: function(){
			// summary:
			//		Displays the relevant choices in the drop down list
			// tags:
			//		private
			var fromIso = stamp.fromISOString;
			this.timeMenu.innerHTML = "";
			this._clickableIncrementDate=fromIso(this.clickableIncrement);
			this._visibleIncrementDate=fromIso(this.visibleIncrement);
			this._visibleRangeDate=fromIso(this.visibleRange);
			// get the value of the increments and the range in seconds (since 00:00:00) to find out how many divs to create
			var
				sinceMidnight = function(/*Date*/ date){
					return date.getHours() * 60 * 60 + date.getMinutes() * 60 + date.getSeconds();
				},
				clickableIncrementSeconds = sinceMidnight(this._clickableIncrementDate),
				visibleIncrementSeconds = sinceMidnight(this._visibleIncrementDate),
				visibleRangeSeconds = sinceMidnight(this._visibleRangeDate),
				// round reference date to previous visible increment
				time = (this.value || this.currentFocus).getTime();

			this._refDate = new Date(time - time % (clickableIncrementSeconds*1000));
			this._refDate.setFullYear(1970,0,1); // match parse defaults

			// assume clickable increment is the smallest unit
			this._clickableIncrement = 1;
			// divide the visible range by the clickable increment to get the number of divs to create
			// example: 10:00:00/00:15:00 -> display 40 divs
			this._totalIncrements = visibleRangeSeconds / clickableIncrementSeconds;
			// divide the visible increments by the clickable increments to get how often to display the time inline
			// example: 01:00:00/00:15:00 -> display the time every 4 divs
			this._visibleIncrement = visibleIncrementSeconds / clickableIncrementSeconds;
			// divide the number of seconds in a day by the clickable increment in seconds to get the
			// absolute max number of increments.
			this._maxIncrement = (60 * 60 * 24) / clickableIncrementSeconds;

			var
				// Find the nodes we should display based on our filter.
				// Limit to 10 nodes displayed as a half-hearted attempt to stop drop down from overlapping <input>.
				count = Math.min(this._totalIncrements, 10),
				after = this._getFilteredNodes(0, (count >> 1) + 1, false),
				moreAfter = [],
				estBeforeLength = count - after.length,
				before = this._getFilteredNodes(0, estBeforeLength, true, after[0]);
			if(before.length < estBeforeLength && after.length > 0){
				moreAfter = this._getFilteredNodes(after[after.length-1].idx + 1, estBeforeLength - before.length, false, after[after.length-1]);
			}
			array.forEach(before.concat(after, moreAfter), function(n){ this.timeMenu.appendChild(n); }, this);
			// never show empty due to a bad filter
			if(!before.length && !after.length && !moreAfter.length && this.filterString){
				this.filterString = '';
				this._showText();
			}
		},

		constructor: function(/*===== params, srcNodeRef =====*/){
			// summary:
			//		Create the widget.
			// params: Object|null
			//		Hash of initialization parameters for widget, including scalar values (like title, duration etc.)
			//		and functions, typically callbacks like onClick.
			//		The hash can contain any of the widget's properties, excluding read-only properties.
			// srcNodeRef: DOMNode|String?
			//		If a srcNodeRef (DOM node) is specified, replace srcNodeRef with my generated DOM tree

			this.constraints = {};
		},

		postMixInProperties: function(){
			this.inherited(arguments);
			this._setConstraintsAttr(this.constraints); // this needs to happen now (and later) due to codependency on _set*Attr calls
		},

		_setConstraintsAttr: function(/* Object */ constraints){
			// brings in visibleRange, increments, etc.
			lang.mixin(this, constraints);

			// locale needs the lang in the constraints as locale
			if(!constraints.locale){
				constraints.locale = this.lang;
			}
		},

		postCreate: function(){
			// assign typematic mouse listeners to the arrow buttons
			this.connect(this.timeMenu, mouse.wheel, "_mouseWheeled");
			this.own(
				typematic.addMouseListener(this.upArrow, this, "_onArrowUp", 33, 250),
				typematic.addMouseListener(this.downArrow, this, "_onArrowDown", 33, 250)
			);

			this.inherited(arguments);
		},

		_buttonMouse: function(/*Event*/ e){
			// summary:
			//		Handler for hover (and unhover) on up/down arrows
			// tags:
			//		private

			// in non-IE browser the "mouseenter" event will become "mouseover",
			// but in IE it's still "mouseenter"
			domClass.toggle(e.currentTarget, e.currentTarget == this.upArrow ? "dijitUpArrowHover" : "dijitDownArrowHover",
				e.type == "mouseenter" || e.type == "mouseover");
		},

		_createOption: function(/*Number*/ index){
			// summary:
			//		Creates a clickable time option
			// tags:
			//		private
			var date = new Date(this._refDate);
			var incrementDate = this._clickableIncrementDate;
			date.setTime(date.getTime()
				+ incrementDate.getHours() * index * 3600000
				+ incrementDate.getMinutes() * index * 60000
				+ incrementDate.getSeconds() * index * 1000);
			if(this.constraints.selector == "time"){
				date.setFullYear(1970,0,1); // make sure each time is for the same date
			}
			var dateString = locale.format(date, this.constraints);
			if(this.filterString && dateString.toLowerCase().indexOf(this.filterString) !== 0){
				// Doesn't match the filter - return null
				return null;
			}

			var div = this.ownerDocument.createElement("div");
			div.className = this.baseClass+"Item";
			div.date = date;
			div.idx = index;
			domConstruct.create('div',{
				"class": this.baseClass + "ItemInner",
				innerHTML: dateString
			}, div);

			if(index%this._visibleIncrement<1 && index%this._visibleIncrement>-1){
				domClass.add(div, this.baseClass+"Marker");
			}else if(!(index%this._clickableIncrement)){
				domClass.add(div, this.baseClass+"Tick");
			}

			if(this.isDisabledDate(date)){
				// set disabled
				domClass.add(div, this.baseClass+"ItemDisabled");
			}
			if(this.value && !ddate.compare(this.value, date, this.constraints.selector)){
				div.selected = true;
				domClass.add(div, this.baseClass+"ItemSelected");
				if(domClass.contains(div, this.baseClass+"Marker")){
					domClass.add(div, this.baseClass+"MarkerSelected");
				}else{
					domClass.add(div, this.baseClass+"TickSelected");
				}

				// Initially highlight the current value.   User can change highlight by up/down arrow keys
				// or mouse movement.
				this._highlightOption(div, true);
			}
			return div;
		},

		_onOptionSelected: function(/*Object*/ tgt){
			// summary:
			//		Called when user clicks an option in the drop down list
			// tags:
			//		private
			var tdate = tgt.target.date || tgt.target.parentNode.date;
			if(!tdate || this.isDisabledDate(tdate)){ return; }
			this._highlighted_option = null;
			this.set('value', tdate);
			this.onChange(tdate);
		},

		onChange: function(/*Date*/ /*===== time =====*/){
			// summary:
			//		Notification that a time was selected.  It may be the same as the previous value.
			// tags:
			//		public
		},

		_highlightOption: function(/*node*/ node, /*Boolean*/ highlight){
			// summary:
			//		Turns on/off highlight effect on a node based on mouse out/over event
			// tags:
			//		private
			if(!node){return;}
			if(highlight){
				if(this._highlighted_option){
					this._highlightOption(this._highlighted_option, false);
				}
				this._highlighted_option = node;
			}else if(this._highlighted_option !== node){
				return;
			}else{
				this._highlighted_option = null;
			}
			domClass.toggle(node, this.baseClass+"ItemHover", highlight);
			if(domClass.contains(node, this.baseClass+"Marker")){
				domClass.toggle(node, this.baseClass+"MarkerHover", highlight);
			}else{
				domClass.toggle(node, this.baseClass+"TickHover", highlight);
			}
		},

		onmouseover: function(/*Event*/ e){
			// summary:
			//		Handler for onmouseover event
			// tags:
			//		private
			this._keyboardSelected = null;
			var tgr = (e.target.parentNode === this.timeMenu) ? e.target : e.target.parentNode;
			// if we aren't targeting an item, then we return
			if(!domClass.contains(tgr, this.baseClass+"Item")){return;}
			this._highlightOption(tgr, true);
		},

		onmouseout: function(/*Event*/ e){
			// summary:
			//		Handler for onmouseout event
			// tags:
			//		private
			this._keyboardSelected = null;
			var tgr = (e.target.parentNode === this.timeMenu) ? e.target : e.target.parentNode;
			this._highlightOption(tgr, false);
		},

		_mouseWheeled: function(/*Event*/ e){
			// summary:
			//		Handle the mouse wheel events
			// tags:
			//		private
			this._keyboardSelected = null;
			event.stop(e);
			// we're not _measuring_ the scroll amount, just direction
			this[(e.wheelDelta>0 ? "_onArrowUp" : "_onArrowDown")](); // yes, we're making a new dom node every time you mousewheel, or click
		},

		_onArrowUp: function(count){
			// summary:
			//		Handler for up arrow key.
			// description:
			//		Removes the bottom time and add one to the top
			// tags:
			//		private
			if(count === -1){
				domClass.remove(this.upArrow, "dijitUpArrowActive");
				return;
			}else if(count === 0){
				domClass.add(this.upArrow, "dijitUpArrowActive");

			} // typematic end
			if(!this.timeMenu.childNodes.length){ return; }
			var index = this.timeMenu.childNodes[0].idx;
			var divs = this._getFilteredNodes(index, 1, true, this.timeMenu.childNodes[0]);
			if(divs.length){
				this.timeMenu.removeChild(this.timeMenu.childNodes[this.timeMenu.childNodes.length - 1]);
				this.timeMenu.insertBefore(divs[0], this.timeMenu.childNodes[0]);
			}
		},

		_onArrowDown: function(count){
			// summary:
			//		Handler for up arrow key.
			// description:
			//		Remove the top time and add one to the bottom
			// tags:
			//		private
			if(count === -1){
				domClass.remove(this.downArrow, "dijitDownArrowActive");
				return;
			}else if(count === 0){
				domClass.add(this.downArrow, "dijitDownArrowActive");
			} // typematic end
			if(!this.timeMenu.childNodes.length){ return; }
			var index = this.timeMenu.childNodes[this.timeMenu.childNodes.length - 1].idx + 1;
			var divs = this._getFilteredNodes(index, 1, false, this.timeMenu.childNodes[this.timeMenu.childNodes.length - 1]);
			if(divs.length){
				this.timeMenu.removeChild(this.timeMenu.childNodes[0]);
				this.timeMenu.appendChild(divs[0]);
			}
		},

		handleKey: function(/*Event*/ e){
			// summary:
			//		Called from `dijit/form/_DateTimeTextBox` to pass a keypress event
			//		from the `dijit/form/TimeTextBox` to be handled in this widget
			// tags:
			//		protected
			if(e.keyCode == keys.DOWN_ARROW || e.keyCode == keys.UP_ARROW){
				event.stop(e);
				// Figure out which option to highlight now and then highlight it
				if(this._highlighted_option && !this._highlighted_option.parentNode){
					this._highlighted_option = null;
				}
				var timeMenu = this.timeMenu,
					tgt = this._highlighted_option || query("." + this.baseClass + "ItemSelected", timeMenu)[0];
				if(!tgt){
					tgt = timeMenu.childNodes[0];
				}else if(timeMenu.childNodes.length){
					if(e.keyCode == keys.DOWN_ARROW && !tgt.nextSibling){
						this._onArrowDown();
					}else if(e.keyCode == keys.UP_ARROW && !tgt.previousSibling){
						this._onArrowUp();
					}
					if(e.keyCode == keys.DOWN_ARROW){
						tgt = tgt.nextSibling;
					}else{
						tgt = tgt.previousSibling;
					}
				}
				this._highlightOption(tgt, true);
				this._keyboardSelected = tgt;
				return false;
			}else if(e.keyCode == keys.ENTER || e.keyCode === keys.TAB){
				// mouse hover followed by TAB is NO selection
				if(!this._keyboardSelected && e.keyCode === keys.TAB){
					return true;	// true means don't call stopEvent()
				}

				// Accept the currently-highlighted option as the value
				if(this._highlighted_option){
					this._onOptionSelected({target: this._highlighted_option});
				}

				// Call stopEvent() for ENTER key so that form doesn't submit,
				// but not for TAB, so that TAB does switch focus
				return e.keyCode === keys.TAB;
			}
			return undefined;
		}
	});

	/*=====
	 TimePicker.__Constraints = declare(locale.__FormatOptions, {
		 // clickableIncrement: String
		 //		See `dijit/_TimePicker.clickableIncrement`
		 clickableIncrement: "T00:15:00",

		 // visibleIncrement: String
		 //		See `dijit/_TimePicker.visibleIncrement`
		 visibleIncrement: "T01:00:00",

		 // visibleRange: String
		 //		See `dijit/_TimePicker.visibleRange`
		 visibleRange: "T05:00:00"
	 });
	 =====*/

	return TimePicker;
});

},
'url:davinci/ve/input/templates/MultiFieldSmartInput.html':"<div id=\"iedResizeDiv\"  class=\"iedResizeDiv\"> \n<div dojoType=\"dijit.layout.ContentPane\" class=\"MultiFieldSmartInput_SmartInput_CP\">\n  <table id=\"davinci.ve.input.MultiFieldSmartInput_table\"> \n    <tbody> \n      {tableContent}\n    </tbody> \n  </table> \n</div>   \n  <div id=\"smartInputSim\" class=\"smartInputSim\" style=\"display:none;\"></div>\n  <div id=\"iedResizeHandle\" dojoType=\"dojox.layout.ResizeHandle\" targetId=\"iedResizeDiv\" constrainMin=\"true\" maxWidth=\"200\" maxHeight=\"600\" minWidth=\"240\" minHeight=\"60\"  activeResize=\"true\" intermediateChanges=\"true\"></div>\n</div>\n</td>\n</tr>\n</table>\n<div id=\"davinci.ve.input.SmartInput_div\"  class=\"davinciVeInputSmartInputDiv\"> \n  <div id=\"davinci.ve.input.SmartInput_radio_div\" class=\"smartInputRadioDiv\"> \n   <div class=\"smartInputHelpDiv\"> \n      <span id=\"davinci.ve.input.SmartInput_img_help\"  title=\"Help\" class=\"inlineEditHelp\"> </span>\n      <span class=\"smartInputSpacerSpan\">\n      <button id=\"davinci.ve.input.SmartInput_ok\"  dojoType=\"dijit.form.Button\" type=\"submit\" class=\"inlineEditHelpOk\">{buttonOk}</button> <button id=davinci.ve.input.SmartInput_cancel dojoType=\"dijit.form.Button\" class=\"inlineEditHelpCancel\">{buttonCancel}</button>  \n      </span>   \n    </div> \n    <div id=\"davinci.ve.input.SmartInput_div_help\" style=\"display:none;\" class=\"smartInputHelpTextDiv\"> \n      <div dojoType=\"dijit.layout.ContentPane\" class=\"smartInputHelpTextDivContentPane\" style=\"padding:0;\">{helpText}</div> \n      <div style=\"text-align: left; padding:0; height:2px;\"></div> \n    </div> \n  </div> \n</div> \n\n",
'dijit/form/RadioButton':function(){
define([
	"dojo/_base/declare", // declare
	"./CheckBox",
	"./_RadioButtonMixin"
], function(declare, CheckBox, _RadioButtonMixin){

	// module:
	//		dijit/form/RadioButton

	return declare("dijit.form.RadioButton", [CheckBox, _RadioButtonMixin], {
		// summary:
		//		Same as an HTML radio, but with fancy styling.

		baseClass: "dijitRadio"
	});
});

},
'davinci/ui/OpenThemeDialog':function(){
define(["dojo/_base/declare",
        "dijit/_Templated",
        "dijit/_Widget",
        "dojo/i18n!davinci/ui/nls/ui",
        "dojo/i18n!dijit/nls/common",
        "dojo/text!./templates/OpenThemeDialog.html",
        "davinci/ui/widgets/ThemeSelection"

  ],function(declare, _Templated, _Widget,  uiNLS, commonNLS, templateString){
	return declare("davinci.ui.OpenThemeDialog",   [_Widget, _Templated], {
		templateString: templateString,
		widgetsInTemplate: true,
		_themeChooser : null,
		
		startup : function(){
			var langObj = uiNLS;
			this.inherited(arguments);
			var value = this._themeChooser.get('numberOfThemes') ;
			if(value<1){
				alert(langObj.noUserThemes);
				setTimeout(dojo.hitch(this,function(){
						 				
									    this.destroyRecursive();
									    this.cancel = true;
										this.onClose();}, 500));
				
				
			}
		},
		
		postMixInProperties : function() {
			var langObj = uiNLS;
			var dijitLangObj = commonNLS;
			dojo.mixin(this, langObj);
			dojo.mixin(this, dijitLangObj);
			this.inherited(arguments);
		},
		
		_checkValid : function(){
			var isOk = true;
			var oldTheme = this._themeChooser.attr('value');
			
			if(oldTheme==null || oldTheme ==""){
				isOk = false;
				
				
			}
			this._okButton.set( 'disabled', !isOk);
		},
		
		
		okButton : function(){
			var newTheme = this._themeChooser.attr('value');
			
			davinci.Workbench.openEditor({
				fileName: newTheme.getFile(),
				content: newTheme});
		},
		cancelButton : function(){
			this.cancel = true;
			this.onClose();
		}
		

	});
});


},
'dojox/widget/Toaster':function(){
define([
	"dojo/_base/declare", // declare
        "dojo/_base/lang", // lang.getObject...
	"dojo/_base/connect", // connect.connect, connect.subscribe
	"dojo/_base/fx", // fx.fadeOut
        "dojo/dom-style", // domStyle.set
	"dojo/dom-class", // domClass.add
	"dojo/dom-geometry", // domGeometry.getMarginBox
	"dijit/registry",    // registry.getUniqueId()
	"dijit/_WidgetBase",
	"dijit/_TemplatedMixin",
	"dijit/BackgroundIframe",
	"dojo/fx",
	"dojo/has",
	"dojo/_base/window",
	"dojo/window"
], function(declare, lang, connect, baseFx, domStyle, domClass, domGeometry, registry, WidgetBase, Templated, BackgroundIframe, coreFx, has, baseWindow, window){

	lang.getObject("dojox.widget", true);
	
	var capitalize = function(/* String */w){
	    return w.substring(0,1).toUpperCase() + w.substring(1);
	};

	return declare("dojox.widget.Toaster", [WidgetBase, Templated], {
		// summary:
		//		Message that slides in from the corner of the screen, used for notifications
		//		like "new email".

		templateString: '<div class="dijitToasterClip" dojoAttachPoint="clipNode"><div class="dijitToasterContainer" dojoAttachPoint="containerNode" dojoAttachEvent="onclick:onSelect"><div class="dijitToasterContent" dojoAttachPoint="contentNode"></div></div></div>',

		// messageTopic: String
		//		Name of topic; anything published to this topic will be displayed as a message.
		//		Message format is either String or an object like
		//		{message: "hello word", type: "error", duration: 500}
		messageTopic: "",

		// messageTypes: Enumeration
		//		Possible message types.
		messageTypes: {
			MESSAGE: "message",
			WARNING: "warning",
			ERROR: "error",
			FATAL: "fatal"
		},

		// defaultType: String
		//		If message type isn't specified (see "messageTopic" parameter),
		//		then display message as this type.
		//		Possible values in messageTypes enumeration ("message", "warning", "error", "fatal")
		defaultType: "message",

		// positionDirection: String
		//		Position from which message slides into screen, one of
		//		["br-up", "br-left", "bl-up", "bl-right", "tr-down", "tr-left", "tl-down", "tl-right"]
		positionDirection: "br-up",

		// positionDirectionTypes: Array
		//		Possible values for positionDirection parameter
		positionDirectionTypes: ["br-up", "br-left", "bl-up", "bl-right", "tr-down", "tr-left", "tl-down", "tl-right"],

		// duration: Integer
		//		Number of milliseconds to show message
		duration: 2000,

		// slideDuration: Integer
		//		Number of milliseconds for the slide animation, increasing will cause the Toaster
		//		to slide in more slowly.
		slideDuration: 500,

		// separator: String
		//		String used to separate messages if consecutive calls are made to setContent before previous messages go away
		separator: "<hr></hr>",

		postCreate: function(){
			this.inherited(arguments);
			this.hide();

			// place node as a child of body for positioning
			baseWindow.body().appendChild(this.domNode);

			if(this.messageTopic){
				connect.subscribe(this.messageTopic, this, "_handleMessage");
			}
		},

		_handleMessage: function(/*String|Object*/message){
			if(lang.isString(message)){
				this.setContent(message);
			}else{
				this.setContent(message.message, message.type, message.duration);
			}
		},

		setContent: function(/*String|Function*/message, /*String*/messageType, /*int?*/duration){
			// summary:
			//		sets and displays the given message and show duration
			// message:
			//		the message. If this is a function, it will be called with this toaster widget as the only argument.
			// messageType:
			//		type of message; possible values in messageTypes enumeration ("message", "warning", "error", "fatal")
			// duration:
			//		duration in milliseconds to display message before removing it. Widget has default value.
			duration = duration||this.duration;
			// sync animations so there are no ghosted fades and such
			if(this.slideAnim){
				if(this.slideAnim.status() != "playing"){
					this.slideAnim.stop();
				}
				if(this.slideAnim.status() == "playing" || (this.fadeAnim && this.fadeAnim.status() == "playing")){
					setTimeout(lang.hitch(this, function(){
						this.setContent(message, messageType, duration);
					}), 50);
					return;
				}
			}

			// determine type of content and apply appropriately
			for(var type in this.messageTypes){
				domClass.remove(this.containerNode, "dijitToaster" + capitalize(this.messageTypes[type]));
			}

			domStyle.set(this.containerNode, "opacity", 1);

			this._setContent(message);

			domClass.add(this.containerNode, "dijitToaster" + capitalize(messageType || this.defaultType));

			// now do funky animation of widget appearing from
			// bottom right of page and up
			this.show();
			var nodeSize = domGeometry.getMarginBox(this.containerNode);
			this._cancelHideTimer();
			if(this.isVisible){
				this._placeClip();
				//update hide timer if no sticky message in stack
				if(!this._stickyMessage) {
					this._setHideTimer(duration);
				}
			}else{
				var style = this.containerNode.style;
				var pd = this.positionDirection;
				// sets up initial position of container node and slide-out direction
				if(pd.indexOf("-up") >= 0){
					style.left=0+"px";
					style.top=nodeSize.h + 10 + "px";
				}else if(pd.indexOf("-left") >= 0){
					style.left=nodeSize.w + 10 +"px";
					style.top=0+"px";
				}else if(pd.indexOf("-right") >= 0){
					style.left = 0 - nodeSize.w - 10 + "px";
					style.top = 0+"px";
				}else if(pd.indexOf("-down") >= 0){
					style.left = 0+"px";
					style.top = 0 - nodeSize.h - 10 + "px";
				}else{
					throw new Error(this.id + ".positionDirection is invalid: " + pd);
				}
				this.slideAnim = coreFx.slideTo({
					node: this.containerNode,
					top: 0, left: 0,
					duration: this.slideDuration});
				this.connect(this.slideAnim, "onEnd", function(nodes, anim){
						//we build the fadeAnim here so we dont have to duplicate it later
						// can't do a fadeHide because we're fading the
						// inner node rather than the clipping node
						this.fadeAnim = baseFx.fadeOut({
							node: this.containerNode,
							duration: 1000});
						this.connect(this.fadeAnim, "onEnd", function(evt){
							this.isVisible = false;
							this.hide();
						});
						this._setHideTimer(duration);
						this.connect(this, 'onSelect', function(evt){
							this._cancelHideTimer();
							//force clear sticky message
							this._stickyMessage=false;
							this.fadeAnim.play();
						});

						this.isVisible = true;
					});
				this.slideAnim.play();
			}
		},

		_setContent: function(message){
			if(lang.isFunction(message)){
				message(this);
				return;
			}
			if(message && this.isVisible){
				message = this.contentNode.innerHTML + this.separator + message;
			}
			this.contentNode.innerHTML = message;
		},
		_cancelHideTimer:function(){
			if (this._hideTimer){
				clearTimeout(this._hideTimer);
				this._hideTimer=null;
			}
		},

		_setHideTimer:function(duration){
			this._cancelHideTimer();
			//if duration == 0 we keep the message displayed until clicked
			if(duration>0){
				this._cancelHideTimer();
				this._hideTimer=setTimeout(lang.hitch(this, function(evt){
					// we must hide the iframe in order to fade
					// TODO: figure out how to fade with a BackgroundIframe
					if(this.bgIframe && this.bgIframe.iframe){
						this.bgIframe.iframe.style.display="none";
					}
					this._hideTimer=null;
					//force clear sticky message
					this._stickyMessage=false;
					this.fadeAnim.play();
				}), duration);
			}
			else
				this._stickyMessage=true;
		},

		_placeClip: function(){
			var view = window.getBox();

			var nodeSize = domGeometry.getMarginBox(this.containerNode);

			var style = this.clipNode.style;
			// sets up the size of the clipping node
			style.height = nodeSize.h+"px";
			style.width = nodeSize.w+"px";

			// sets up the position of the clipping node
			var pd = this.positionDirection;
			if(pd.match(/^t/)){
				style.top = view.t+"px";
			}else if(pd.match(/^b/)){
				style.top = (view.h - nodeSize.h - 2 + view.t)+"px";
			}
			if(pd.match(/^[tb]r-/)){
				style.left = (view.w - nodeSize.w - 1 - view.l)+"px";
			}else if(pd.match(/^[tb]l-/)){
				style.left = 0 + "px";
			}

			style.clip = "rect(0px, " + nodeSize.w + "px, " + nodeSize.h + "px, 0px)";
			if(has("ie")){
				if(!this.bgIframe){
					this.clipNode.id = registry.getUniqueId("dojox_widget_Toaster_clipNode");
					this.bgIframe = new BackgroundIframe(this.clipNode);
				}
				var iframe = this.bgIframe.iframe;
				if(iframe){ iframe.style.display="block"; }
			}
		},

		onSelect: function(/*Event*/e){
			// summary:
			//		callback for when user clicks the message
		},

		show: function(){
			// summary:'
			//		show the Toaster
			domStyle.set(this.domNode, 'display', 'block');

			this._placeClip();

			if(!this._scrollConnected){
				this._scrollConnected = connect.connect(window, "onscroll", this, this._placeClip);
			}
		},

		hide: function(){
			// summary:
			//		hide the Toaster

			domStyle.set(this.domNode, 'display', 'none');

			if(this._scrollConnected){
				connect.disconnect(this._scrollConnected);
				this._scrollConnected = false;
			}

			domStyle.set(this.containerNode, "opacity", 1);
		}
	});

});

},
'dojox/data/QueryReadStore':function(){
define(["dojo", "dojox", "dojo/data/util/sorter", "dojo/string"], function(dojo, dojox) {

dojo.declare("dojox.data.QueryReadStore",
	null,
	{
		// summary:
		//		This class provides a store that is mainly intended to be used
		//		for loading data dynamically from the server, used i.e. for
		//		retrieving chunks of data from huge data stores on the server (by server-side filtering!).
		//		Upon calling the fetch() method of this store the data are requested from
		//		the server if they are not yet loaded for paging (or cached).
		//
		//		For example used for a combobox which works on lots of data. It
		//		can be used to retrieve the data partially upon entering the
		//		letters "ac" it returns only items like "action", "acting", etc.
		//
		//		note:
		//		The field name "id" in a query is reserved for looking up data
		//		by id. This is necessary as before the first fetch, the store
		//		has no way of knowing which field the server will declare as
		//		identifier.
		//
		// example:
		// |	// The parameter "query" contains the data that are sent to the server.
		// |	var store = new dojox.data.QueryReadStore({url:'/search.php'});
		// |	store.fetch({query:{name:'a'}, queryOptions:{ignoreCase:false}});
		//
		// |	// Since "serverQuery" is given, it overrules and those data are
		// |	// sent to the server.
		// |	var store = new dojox.data.QueryReadStore({url:'/search.php'});
		// |	store.fetch({serverQuery:{name:'a'}, queryOptions:{ignoreCase:false}});
		//
		// |	<div dojoType="dojox.data.QueryReadStore"
		// |		jsId="store2"
		// |		url="../tests/stores/QueryReadStore.php"
		// |		requestMethod="post"></div>
		// |	<div dojoType="dojox.grid.data.DojoData"
		// |		jsId="model2"
		// |		store="store2"
		// |		sortFields="[{attribute: 'name', descending: true}]"
		// |		rowsPerPage="30"></div>
		// |	<div dojoType="dojox.Grid" id="grid2"
		// |		model="model2"
		// |		structure="gridLayout"
		// |		style="height:300px; width:800px;"></div>

		// todo:
		//		- there is a bug in the paging, when i set start:2, count:5 after an initial fetch() and doClientPaging:true
		//		  it returns 6 elemetns, though count=5, try it in QueryReadStore.html
		//		- add optional caching
		//		- when the first query searched for "a" and the next for a subset of
		//		  the first, i.e. "ab" then we actually dont need a server request, if
		//		  we have client paging, we just need to filter the items we already have
		//		  that might also be tooo much logic
		
		url:"",
		requestMethod:"get",
		//useCache:false,
		
		// We use the name in the errors, once the name is fixed hardcode it, may be.
		_className:"dojox.data.QueryReadStore",
		
		// This will contain the items we have loaded from the server.
		// The contents of this array is optimized to satisfy all read-api requirements
		// and for using lesser storage, so the keys and their content need some explaination:
		//		this._items[0].i - the item itself
		//		this._items[0].r - a reference to the store, so we can identify the item
		//			securely. We set this reference right after receiving the item from the
		//			server.
		_items:[],
		
		// Store the last query that triggered xhr request to the server.
		// So we can compare if the request changed and if we shall reload
		// (this also depends on other factors, such as is caching used, etc).
		_lastServerQuery:null,
		
		// Store how many rows we have so that we can pass it to a clientPaging handler
		_numRows:-1,
		
		// Store a hash of the last server request. Actually I introduced this
		// for testing, so I can check if no unnecessary requests were issued for
		// client-side-paging.
		lastRequestHash:null,
		
		// doClientPaging: Boolean
		//		By default every request for paging is sent to the server.
		doClientPaging:false,
	
		// doClientSorting: Boolean
		//		By default all the sorting is done serverside before the data is returned
		//		which is the proper place to be doing it for really large datasets.
		doClientSorting:false,
	
		// Items by identify for Identify API
		_itemsByIdentity:null,
		
		// Identifier used
		_identifier:null,
	
		_features: {'dojo.data.api.Read':true, 'dojo.data.api.Identity':true},
	
		_labelAttr: "label",
		
		constructor: function(/* Object */ params){
			dojo.mixin(this,params);
		},
		
		getValue: function(/* item */ item, /* attribute-name-string */ attribute, /* value? */ defaultValue){
			//	According to the Read API comments in getValue() and exception is
			//	thrown when an item is not an item or the attribute not a string!
			this._assertIsItem(item);
			if(!dojo.isString(attribute)){
				throw new Error(this._className+".getValue(): Invalid attribute, string expected!");
			}
			if(!this.hasAttribute(item, attribute)){
				// read api says: return defaultValue "only if *item* does not have a value for *attribute*."
				// Is this the case here? The attribute doesn't exist, but a defaultValue, sounds reasonable.
				if(defaultValue){
					return defaultValue;
				}
			}
			return item.i[attribute];
		},
		
		getValues: function(/* item */ item, /* attribute-name-string */ attribute){
			this._assertIsItem(item);
			var ret = [];
			if(this.hasAttribute(item, attribute)){
				ret.push(item.i[attribute]);
			}
			return ret;
		},
		
		getAttributes: function(/* item */ item){
			this._assertIsItem(item);
			var ret = [];
			for(var i in item.i){
				ret.push(i);
			}
			return ret;
		},
	
		hasAttribute: function(/* item */ item,	/* attribute-name-string */ attribute){
			// summary:
			//		See dojo/data/api/Read.hasAttribute()
			return this.isItem(item) && typeof item.i[attribute]!="undefined";
		},
		
		containsValue: function(/* item */ item, /* attribute-name-string */ attribute, /* anything */ value){
			var values = this.getValues(item, attribute);
			var len = values.length;
			for(var i=0; i<len; i++){
				if(values[i] == value){
					return true;
				}
			}
			return false;
		},
		
		isItem: function(/* anything */ something){
			// Some basic tests, that are quick and easy to do here.
			// >>> var store = new dojox.data.QueryReadStore({});
			// >>> store.isItem("");
			// false
			//
			// >>> var store = new dojox.data.QueryReadStore({});
			// >>> store.isItem({});
			// false
			//
			// >>> var store = new dojox.data.QueryReadStore({});
			// >>> store.isItem(0);
			// false
			//
			// >>> var store = new dojox.data.QueryReadStore({});
			// >>> store.isItem({name:"me", label:"me too"});
			// false

			if(something){
				return typeof something.r != "undefined" && something.r == this;
			}
			return false;
		},
		
		isItemLoaded: function(/* anything */ something){
			// Currently we dont have any state that tells if an item is loaded or not
			// if the item exists its also loaded.
			// This might change when we start working with refs inside items ...
			return this.isItem(something);
		},
	
		loadItem: function(/* object */ args){
			if(this.isItemLoaded(args.item)){
				return;
			}
			// Actually we have nothing to do here, or at least I dont know what to do here ...
		},
	
		fetch:function(/* Object? */ request){
			// summary:
			//		See dojo.data.util.simpleFetch.fetch() this is just a copy and I adjusted
			//		only the paging, since it happens on the server if doClientPaging is
			//		false, thx to http://trac.dojotoolkit.org/ticket/4761 reporting this.
			//		Would be nice to be able to use simpleFetch() to reduce copied code,
			//		but i dont know how yet. Ideas please!
			request = request || {};
			if(!request.store){
				request.store = this;
			}
			var self = this;
		
			var _errorHandler = function(errorData, requestObject){
				if(requestObject.onError){
					var scope = requestObject.scope || dojo.global;
					requestObject.onError.call(scope, errorData, requestObject);
				}
			};
		
			var _fetchHandler = function(items, requestObject, numRows){
				var oldAbortFunction = requestObject.abort || null;
				var aborted = false;
				
				var startIndex = requestObject.start?requestObject.start:0;
				if(self.doClientPaging == false){
					// For client paging we dont need no slicing of the result.
					startIndex = 0;
				}
				var endIndex = requestObject.count?(startIndex + requestObject.count):items.length;
		
				requestObject.abort = function(){
					aborted = true;
					if(oldAbortFunction){
						oldAbortFunction.call(requestObject);
					}
				};
		
				var scope = requestObject.scope || dojo.global;
				if(!requestObject.store){
					requestObject.store = self;
				}
				if(requestObject.onBegin){
					requestObject.onBegin.call(scope, numRows, requestObject);
				}
				if(requestObject.sort && self.doClientSorting){
					items.sort(dojo.data.util.sorter.createSortFunction(requestObject.sort, self));
				}
				if(requestObject.onItem){
					for(var i = startIndex; (i < items.length) && (i < endIndex); ++i){
						var item = items[i];
						if(!aborted){
							requestObject.onItem.call(scope, item, requestObject);
						}
					}
				}
				if(requestObject.onComplete && !aborted){
					var subset = null;
					if(!requestObject.onItem){
						subset = items.slice(startIndex, endIndex);
					}
					requestObject.onComplete.call(scope, subset, requestObject);
				}
			};
			this._fetchItems(request, _fetchHandler, _errorHandler);
			return request;	// Object
		},
	
		getFeatures: function(){
			return this._features;
		},
	
		close: function(/*dojo/data/api/Request|Object?*/ request){
			// I have no idea if this is really needed ...
		},
	
		getLabel: function(/* item */ item){
			// summary:
			//		See dojo/data/api/Read.getLabel()
			if(this._labelAttr && this.isItem(item)){
				return this.getValue(item, this._labelAttr); //String
			}
			return undefined; //undefined
		},
	
		getLabelAttributes: function(/* item */ item){
			// summary:
			//		See dojo/data/api/Read.getLabelAttributes()
			if(this._labelAttr){
				return [this._labelAttr]; //array
			}
			return null; //null
		},
		
		_xhrFetchHandler: function(data, request, fetchHandler, errorHandler){
			data = this._filterResponse(data);
			if(data.label){
				this._labelAttr = data.label;
			}
			var numRows = data.numRows || -1;

			this._items = [];
			// Store a ref to "this" in each item, so we can simply check if an item
			// really origins form here (idea is from ItemFileReadStore, I just don't know
			// how efficient the real storage use, garbage collection effort, etc. is).
			dojo.forEach(data.items,function(e){
				this._items.push({i:e, r:this});
			},this);
			
			var identifier = data.identifier;
			this._itemsByIdentity = {};
			if(identifier){
				this._identifier = identifier;
				var i;
				for(i = 0; i < this._items.length; ++i){
					var item = this._items[i].i;
					var identity = item[identifier];
					if(!this._itemsByIdentity[identity]){
						this._itemsByIdentity[identity] = item;
					}else{
						throw new Error(this._className+":  The json data as specified by: [" + this.url + "] is malformed.  Items within the list have identifier: [" + identifier + "].  Value collided: [" + identity + "]");
					}
				}
			}else{
				this._identifier = Number;
				for(i = 0; i < this._items.length; ++i){
					this._items[i].n = i;
				}
			}
			
			// TODO actually we should do the same as dojo.data.ItemFileReadStore._getItemsFromLoadedData() to sanitize
			// (does it really sanititze them) and store the data optimal. should we? for security reasons???
			numRows = this._numRows = (numRows === -1) ? this._items.length : numRows;
			fetchHandler(this._items, request, numRows);
			this._numRows = numRows;
		},
		
		_fetchItems: function(request, fetchHandler, errorHandler){
			// summary:
			//		The request contains the data as defined in the Read-API.
			//		Additionally there is following keyword "serverQuery".
			//
			//		####The *serverQuery* parameter, optional.
			//
			//		This parameter contains the data that will be sent to the server.
			//		If this parameter is not given the parameter "query"'s
			//		data are sent to the server. This is done for some reasons:
			//
			//		- to specify explicitly which data are sent to the server, they
			//		  might also be a mix of what is contained in "query", "queryOptions"
			//		  and the paging parameters "start" and "count" or may be even
			//		  completely different things.
			//		- don't modify the request.query data, so the interface using this
			//		  store can rely on unmodified data, as the combobox dijit currently
			//		  does it, it compares if the query has changed
			//		- request.query is required by the Read-API
			//
			//		I.e. the following examples might be sent via GET:
			//	|	  fetch({query:{name:"abc"}, queryOptions:{ignoreCase:true}})
			//		  the URL will become:   /url.php?name=abc
			//
			//	|	  fetch({serverQuery:{q:"abc", c:true}, query:{name:"abc"}, queryOptions:{ignoreCase:true}})
			//		  the URL will become:   /url.php?q=abc&c=true
			//	|	  // The serverQuery-parameter has overruled the query-parameter
			//	|	  // but the query parameter stays untouched, but is not sent to the server!
			//	|	  // The serverQuery contains more data than the query, so they might differ!

			var serverQuery = request.serverQuery || request.query || {};
			//Need to add start and count
			if(!this.doClientPaging){
				serverQuery.start = request.start || 0;
				// Count might not be sent if not given.
				if(request.count){
					serverQuery.count = request.count;
				}
			}
			if(!this.doClientSorting && request.sort){
				var sortInfo = [];
				dojo.forEach(request.sort, function(sort){
					if(sort && sort.attribute){
						sortInfo.push((sort.descending ? "-" : "") + sort.attribute);
					}
				});
				serverQuery.sort = sortInfo.join(',');
			}
			// Compare the last query and the current query by simply json-encoding them,
			// so we dont have to do any deep object compare ... is there some dojo.areObjectsEqual()???
			if(this.doClientPaging && this._lastServerQuery !== null &&
				dojo.toJson(serverQuery) == dojo.toJson(this._lastServerQuery)
				){
				this._numRows = (this._numRows === -1) ? this._items.length : this._numRows;
				fetchHandler(this._items, request, this._numRows);
			}else{
				var xhrFunc = this.requestMethod.toLowerCase() == "post" ? dojo.xhrPost : dojo.xhrGet;
				var xhrHandler = xhrFunc({url:this.url, handleAs:"json-comment-optional", content:serverQuery, failOk: true});
				request.abort = function(){
					xhrHandler.cancel();
				};
				xhrHandler.addCallback(dojo.hitch(this, function(data){
					this._xhrFetchHandler(data, request, fetchHandler, errorHandler);
				}));
				xhrHandler.addErrback(function(error){
					errorHandler(error, request);
				});
				// Generate the hash using the time in milliseconds and a randon number.
				// Since Math.randon() returns something like: 0.23453463, we just remove the "0."
				// probably just for esthetic reasons :-).
				this.lastRequestHash = new Date().getTime()+"-"+String(Math.random()).substring(2);
				this._lastServerQuery = dojo.mixin({}, serverQuery);
			}
		},
		
		_filterResponse: function(data){
			// summary:
			//		If the data from servers needs to be processed before it can be processed by this
			//		store, then this function should be re-implemented in subclass. This default
			//		implementation just return the data unchanged.
			// data:
			//		The data received from server
			return data;
		},
	
		_assertIsItem: function(/* item */ item){
			// summary:
			//		It throws an error if item is not valid, so you can call it in every method that needs to
			//		throw an error when item is invalid.
			// item:
			//		The item to test for being contained by the store.
			if(!this.isItem(item)){
				throw new Error(this._className+": Invalid item argument.");
			}
		},
	
		_assertIsAttribute: function(/* attribute-name-string */ attribute){
			// summary:
			//		This function tests whether the item passed in is indeed a valid 'attribute' like type for the store.
			// attribute:
			//		The attribute to test for being contained by the store.
			if(typeof attribute !== "string"){
				throw new Error(this._className+": Invalid attribute argument ('"+attribute+"').");
			}
		},
	
		fetchItemByIdentity: function(/* Object */ keywordArgs){
			// summary:
			//		See dojo/data/api/Identity.fetchItemByIdentity()
	
			// See if we have already loaded the item with that id
			// In case there hasn't been a fetch yet, _itemsByIdentity is null
			// and thus a fetch will be triggered below.
			if(this._itemsByIdentity){
				var item = this._itemsByIdentity[keywordArgs.identity];
				if(!(item === undefined)){
					if(keywordArgs.onItem){
						var scope = keywordArgs.scope ? keywordArgs.scope : dojo.global;
						keywordArgs.onItem.call(scope, {i:item, r:this});
					}
					return;
				}
			}
	
			// Otherwise we need to go remote
			// Set up error handler
			var _errorHandler = function(errorData, requestObject){
				var scope = keywordArgs.scope ? keywordArgs.scope : dojo.global;
				if(keywordArgs.onError){
					keywordArgs.onError.call(scope, errorData);
				}
			};
			
			// Set up fetch handler
			var _fetchHandler = function(items, requestObject){
				var scope = keywordArgs.scope ? keywordArgs.scope : dojo.global;
				try{
					// There is supposed to be only one result
					var item = null;
					if(items && items.length == 1){
						item = items[0];
					}
					
					// If no item was found, item is still null and we'll
					// fire the onItem event with the null here
					if(keywordArgs.onItem){
						keywordArgs.onItem.call(scope, item);
					}
				}catch(error){
					if(keywordArgs.onError){
						keywordArgs.onError.call(scope, error);
					}
				}
			};
			
			// Construct query
			var request = {serverQuery:{id:keywordArgs.identity}};
			
			// Dispatch query
			this._fetchItems(request, _fetchHandler, _errorHandler);
		},
		
		getIdentity: function(/* item */ item){
			// summary:
			//		See dojo/data/api/Identity.getIdentity()
			var identifier = null;
			if(this._identifier === Number){
				identifier = item.n; // Number
			}else{
				identifier = item.i[this._identifier];
			}
			return identifier;
		},
		
		getIdentityAttributes: function(/* item */ item){
			// summary:
			//		See dojo/data/api/Identity.getIdentityAttributes()
			return [this._identifier];
		}
	}
);

return dojox.data.QueryReadStore;
});

},
'url:dijit/templates/TimePicker.html':"<div id=\"widget_${id}\" class=\"dijitMenu\"\n    ><div data-dojo-attach-point=\"upArrow\" class=\"dijitButtonNode dijitUpArrowButton\" data-dojo-attach-event=\"onmouseenter:_buttonMouse,onmouseleave:_buttonMouse\"\n\t\t><div class=\"dijitReset dijitInline dijitArrowButtonInner\" role=\"presentation\">&#160;</div\n\t\t><div class=\"dijitArrowButtonChar\">&#9650;</div></div\n    ><div data-dojo-attach-point=\"timeMenu,focusNode\" data-dojo-attach-event=\"onclick:_onOptionSelected,onmouseover,onmouseout\"></div\n    ><div data-dojo-attach-point=\"downArrow\" class=\"dijitButtonNode dijitDownArrowButton\" data-dojo-attach-event=\"onmouseenter:_buttonMouse,onmouseleave:_buttonMouse\"\n\t\t><div class=\"dijitReset dijitInline dijitArrowButtonInner\" role=\"presentation\">&#160;</div\n\t\t><div class=\"dijitArrowButtonChar\">&#9660;</div></div\n></div>\n",
'davinci/ve/utils/pseudoClass':function(){
define([], function(){
	var pseudoClass = 'maqettaPseudoClass';

	return {
		MAQETTA_PSEUDO_CLASS: pseudoClass,

		replace: function (selectorText) {
			return ['hover', 'link', 'visited', 'active', 'focus', 'first-letter', 'first-line', 'first-child', 'before', 'after']
				.reduce(function(text, pClass){
					return text.replace(
						new RegExp(':'+pClass,'g'),
							"." + pseudoClass
								+ pClass[0].toUpperCase() + pClass.slice(1));
			}, selectorText);
		}
	};
});

},
'davinci/ui/about':function(){
define([
        "dojo/_base/declare",
        "../Workbench",
        "davinci/version",
        "davinci/repositoryinfo",
        "dojo/date/locale",
        "dojo/date/stamp",
        "dojo/i18n!davinci/ui/nls/ui",
        "dojo/i18n!dijit/nls/common",
        "dijit/form/Button"
   ],function(declare, Workbench, DavinciVersion, Repositoryinfo, Locale, Stamp, uiNLS, commonNLS){
		var about = declare("davinci.ui.about", null, {});
		about.show = function(){
				var langObj = uiNLS;

				var formHTML = "<div class='about_container'>"
						+ "<div class='about_version'>"
						+ dojo.string.substitute(langObj.productVersion,
								[ DavinciVersion ]) + "</div>";
				var ri = Repositoryinfo, revision = ri.revision;
				var bd = ri.buildtime;
				var date = Stamp.fromISOString(bd);
				if (date) {
					bd = Locale.format(date, {
						formatLength : 'medium'
					});
				}
				if (bd) {
					formHTML += "<div class='about_date'>"
							+ dojo.string.substitute(langObj.productDate,
									[ bd ]) + "</div>";
				}
				if (revision) {
					// formHTML += "<div class='about_build'>"+langObj.build+"<a
					// href='https://github.com/maqetta/maqetta/commit/"+revision+"'>"+
					// revision.substr(0,15) +"...</a></div>";
					var revisionLink = "<a href='https://github.com/maqetta/maqetta/commit/"
							+ revision
							+ "'>"
							+ revision.substr(0, 15)
							+ "...</a>";
					formHTML += "<div class='about_build'>"
							+ dojo.string.substitute(langObj.build,
									[ revisionLink ]) + "</div>";
				}
				formHTML += "</div>";

				Workbench.showMessage(langObj.aboutMaqetta, formHTML);
			}
		return about;
});
},
'davinci/Workbench':function(){
define([
    "dojo/_base/lang",
    "require",
	"./Runtime",
	"./model/Path",
	"./workbench/ViewPart",
	"./workbench/EditorContainer",
	"./ui/Dialog",
	"dijit/Toolbar",
	"dijit/ToolbarSeparator",
	"dijit/Menu",
	"dijit/MenuBar",
	"dijit/MenuItem",
	"dijit/MenuSeparator",
	"dijit/PopupMenuBarItem",
	"dijit/form/Button",
	"dijit/form/DropDownButton",
	"dijit/form/ComboButton",
	"dijit/form/ToggleButton",
	"dijit/layout/BorderContainer",
	"dijit/layout/StackController",
	"dijit/layout/StackContainer",
	"dijit/layout/ContentPane",
	"dijit/layout/TabController",
	"dijit/layout/TabContainer",
	"system/resource",
	"dojo/i18n!./nls/webContent",
	"./ve/metadata",
	"dojo/Deferred",
	"dojo/promise/all",
	"dojo/_base/declare",
	"dojo/_base/connect",
	"dojo/_base/xhr",
	"./review/model/resource/root",
	"dojo/i18n!./ve/nls/common",
	"./ve/utils/GeomUtils",
	"dojo/i18n!./ui/nls/common",
	"davinci/review/model/resource/root"
], function(
		lang,
		require,
		Runtime,
		Path,
		ViewPart,
		EditorContainer,
		Dialog,
		Toolbar,
		ToolbarSeparator,
		Menu,
		MenuBar,
		MenuItem,
		MenuSeparator,
		PopupMenuBarItem,
		Button,
		DropDownButton,
		ComboButton,
		ToggleButton,
		BorderContainer,
		StackController,
		StackContainer,
		ContentPane,
		TabController,
		TabContainer,
		sysResource,
		webContent,
		metadata,
		Deferred,
		all,
		declare,
		connect,
		xhr,
		reviewResource,
		veNLS,
		GeomUtils,
		uiCommonNls,
		revResource
) {

var paletteTabWidth = 71;	// Width of tabs for left- and right-side palettes
var paletteTabDelta = 20;	// #pixels - if this many or fewer pixels of tab are showing, treat as collapsed
var paletteCache = {};

// Cheap polyfill to approximate bind(), make Safari happy
Function.prototype.bind = Function.prototype.bind || function(that){ return dojo.hitch(that, this);};

// Convert filename path into an ID string
var filename2id = function(fileName) {
	return "editor-" + encodeURIComponent(fileName.replace(/[\/| |\t]/g, "_")).replace(/%/g, ":");
};
// Convert the result from filename2id into a different ID string that replaces "editor" with "shadow"
var editorIdToShadowId = function(editorFileName) {
	return editorFileName.replace(/^editor/, "shadow");
};
//Convert the result from filename2id into a different ID string that replaces "editor" with "shadow"
var shadowIdToEditorId = function(shadowFileName) {
	return shadowFileName.replace(/^shadow/, "editor");
};

var handleIoError = function (deferred, reason) {
	/*
	 *  Called by the subscription to /dojo/io/error , "
	 *  /dojo/io/error" is sent whenever an IO request has errored.
     *	It passes the error and the dojo.Deferred
     *	for the request with the topic.
	 */

	if (reason.status == 401 || reason.status == 403) {
		sessionTimedOut();
	// Only handle error if it is as of result of a failed XHR connection, not
	// (for example) if a callback throws an error. (For dojo.xhr, def.cancel()
	// is only called if connection fails or if it times out.)
	} else if (deferred.canceled === true) {
		// Filter on XHRs for maqetta server commands.  Possible values which we
		// test for:
		//     cmd/findResource
		//     ./cmd/createResource
		//     http://<host>/maqetta/cmd/getComments
		var reCmdXhr = new RegExp('(^|\\.\\/|' + document.baseURI + '\\/)cmd\\/');
		var url = deferred.ioArgs.url;
		if (reCmdXhr.test(url)) {
			// Make exception for "getBluePageInfo" because it regularly gets cancelled
			// by the type ahead searching done from the combo box on the 3rd panel of
			// the R&C wizard. The cancellation is not really an error.
			if (url.indexOf("getBluePageInfo") >= 0) {
				return;
			}
		} else {
			// Must not be a Maqetta URL (like for JSONP on GridX), so skip
			return;
		}

		Runtime.handleError(reason.message);
		console.warn('Failed to load url=' + url + ' message=' + reason.message +
				' status=' + reason.status);
	}
};

var sessionTimedOut = function(){
	var loginHref = "welcome";
	var dialog = new Dialog({
        title: webContent.sessionTimedOut
      //,  style: "width: 300px"
    });
	var message =  dojo.string.substitute(webContent.sessionTimedOutMsg, {hrefLoc: loginHref});
	dialog.set("content", message);
	dojo.connect(dialog, "onCancel", null, function(){window.location.href = loginHref;});
	setTimeout(function(){window.location.href=loginHref;}, 10000); // redirect to login in 10 sec
	dialog.show();
};

var initializeWorkbenchState = function(){	
	// The _expandCollapsePaletteContainers() call  below collapses the 
	// left-side and right-side palettes before
	// we open any of the editors (and then subsequently potentially expand
	// the left-side and/or right-side palettes as required by that editor).
	// The dontPreserveWidth parameter bubbles down to collapsePaletteContainer()
	// and tells it to *not* cache the current palette width (which it normally does)
	davinci.Workbench._expandCollapsePaletteContainers(null, {dontPreserveWidth:true});

	var isReview = function (resPath) {
		return resPath.indexOf(".review") > -1;
	};

	var getReviewVersion = function (resPath) {
		return new Path(resPath).segment(2);
	};
	
	var getReviewResource = function (resPath) {
		return new Path(resPath).removeFirstSegments(3);
	};

	var init = function (state) {
		// The following event triggers palettes such as SwitchingStyleViews.js to know
		// that workbench has completed initialization of the initial perspective
		// and associated views. Put after the xhr.get to allow execution parallelism.
		dojo.publish("/davinci/ui/initialPerspectiveReady", []);

		if (state.project) {
			Workbench.setActiveProject(state.project);
		}
		if (state.editors) {
			state.version = davinci.version;
			
			var project,
				singleProject = Workbench.singleProjectMode();
		
			if (singleProject) {
				project = new Path(Workbench.getProject());
			}
		
			state.editors.forEach(function(editor){
				var isReviewRes = isReview(editor);
				if(!isReviewRes && singleProject){
					// open all reviews and if running in single user mode, only load editors 
					// open for specific projects
					if (!new Path(editor).startsWith(project)) {
						return;
					}
				}
				
				var handleResource = function(resource) {
					// check if activeEditor is part of the current project or not
					var isActiveEditorInProject = true;
		
					if (singleProject) {
						var path = new Path(state.activeEditor);
						if (!path.startsWith(project)) {
							isActiveEditorInProject = false;
						}
					}
					
					var noSelect = editor != state.activeEditor;
		
					if (noSelect && !isActiveEditorInProject && !isReview(state.activeEditor)) {
						// if the active editor is not in our project, force selection
						noSelect = false;
						state.activeEditor = editor; // this is now the active editor
					}
		
					if (resource) {
						Workbench.openEditor({
							fileName: resource,
							noSelect: noSelect,
							isDirty: resource.isDirty(),
							startup: false,
							initializationTime: true
						});
					}
				};
				
				if(isReviewRes){
					var version = getReviewVersion(editor);
					var resPath = getReviewResource(editor).toString();
					reviewResource.findFile(version, resPath).then(function(resource) {
						 handleResource(resource);
					});
				}else{
					handleResource(sysResource.findResource(editor));
				}
			});
		} else {
			state.editors = [];
		}
	};

	if (!Workbench._state){
		Workbench._state = Runtime.getWorkbenchState();
	}

	
	// This code loads the first file from a given review.  The review comes in as a URL parameter from an invitation.

	var designerName  = dojo.cookie("davinci_designer");
	var reviewVersion = dojo.cookie("davinci_version");
	dojo.cookie("davinci_designer", null, {expires: -1, path:"/"});
	dojo.cookie("davinci_version", null, {expires: -1, path:"/"});
	if (reviewVersion && designerName) {
		//we got here from a review link so add the review files to the editors to be opened 
		// at start up
		revResource.findVersion(designerName, reviewVersion).then(function(node) {
			if (node) {
				// if we found a node, then the user clicked a review link to get here, so
				node.getChildren(function(children){
						// if we found a node, then the user clicked a review link to get here, so
						// let's open review files 
						children.forEach(function(review, index){
							var p = review.getPath();
							if (index == 0) {
								// set the active editor to the first review file
								Workbench._state.activeEditor = p; 
							}
							// check to ensure that the review is not already in the list of editors open
							if (Workbench._state.editors.indexOf(p) < 0) {
								Workbench._state.editors.push(p);
							}
						}.bind(this));
					init(Workbench._state);
				});
				
			}
		}.bind(this));
	} else {
		init(Workbench._state);
	}
	Workbench.setupGlobalKeyboardHandler();
};

var Workbench = {
	activePerspective: "",
	actionScope: [],
	_DEFAULT_PROJECT: "project1",
	hideEditorTabs: true,
	_editorTabClosing: {},
	_shadowTabClosing: {},

	run: function() {
		Runtime.run();
		Workbench._initKeys();
		Workbench._baseTitle = dojo.doc.title;

		// Set up top banner region. (Top banner is an extensibility point)
		if(window.maqetta && maqetta.TopBanner && maqetta.TopBanner.setup){
			maqetta.TopBanner.setup();
		}

		Runtime.subscribe("/davinci/resource/resourceChanged",
			function (type, changedResource) {
				if (type == 'deleted') {
					var editorId = filename2id(changedResource.getPath());
					var shadowId = editorIdToShadowId(editorId);
					var editorContainer = dijit.byId(editorId);
					var shadowTab = dijit.byId(shadowId);
					if (editorContainer && !editorContainer._isClosing) {
						var editorsContainer = dijit.byId("editors_container");
						var shadowTabContainer = dijit.byId("davinci_file_tabs");
						editorsContainer.removeChild(editorContainer);
						editorContainer.destroyRecursive();
						shadowTabContainer.removeChild(shadowTab);
						shadowTab.destroyRecursive();
					}
				}
			}
		);
		Runtime.subscribe('/dojo/io/error', handleIoError); // /dojo/io/error" is sent whenever an IO request has errored. 
		                                                   // requires djConfig.ioPublish be set to true in pagedesigner.html

		Runtime.subscribe("/davinci/states/state/changed",
			function(e) {
				// e:{node:..., newState:..., oldState:...}
				var currentEditor = Runtime.currentEditor;
				// ignore updates in theme editor and review editor
				if ((currentEditor.declaredClass != "davinci.ve.themeEditor.ThemeEditor" &&
						currentEditor.declaredClass != "davinci.review.editor.ReviewEditor") /*"davinci.ve.VisualEditor"*/) {
					currentEditor.visualEditor.onContentChange.apply(currentEditor.visualEditor, arguments);
				}
			}
		);
		Runtime.subscribe("/davinci/ui/widgetPropertiesChanges",
			function() {
				var ve = Runtime.currentEditor.visualEditor;
				ve._objectPropertiesChange.apply(ve, arguments);
			}
		);

		// bind overlay widgets to corresponding davinci states. singleton; no need to unsubscribe
		connect.subscribe("/davinci/states/state/changed", function(args) {
			//FIXME: This is page editor-specific logic within Workbench.
			var context = (Runtime.currentEditor && Runtime.currentEditor.declaredClass == "davinci.ve.PageEditor" && 
					Runtime.currentEditor.visualEditor && Runtime.currentEditor.visualEditor.context);
			if(!context){
				return;
			}
			var prefix = "_show:", widget, dvWidget, helper;
			var thisDijit = context ? context.getDijit() : null;
			var widgetUtils = require("davinci/ve/widget");
			if (args.newState && !args.newState.indexOf(prefix)) {
				widget = thisDijit.byId(args.newState.substring(6));
				dvWidget = widgetUtils.getWidget(widget.domNode);
				helper = dvWidget.getHelper();
				helper && helper.popup && helper.popup(dvWidget);
			}
			if (args.oldState && !args.oldState.indexOf(prefix)) {
				widget = thisDijit.byId(args.oldState.substring(6));
				dvWidget = widgetUtils.getWidget(widget.domNode);
				helper = dvWidget.getHelper();
				helper && helper.tearDown && helper.tearDown(dvWidget);
			}
		});

		// bind overlay widgets to corresponding davinci states. singleton; no need to unsubscribe
		connect.subscribe("/davinci/ui/repositionFocusContainer", function(args) {
			Workbench._repositionFocusContainer();
		});

		var d = xhr.get({
	    	url: "cmd/getInitializationInfo",
	    	handleAs: "json"
	    }).then(function(result){
			Runtime._initializationInfo = result;

	    	var userInfo = result.userInfo;
	    	Runtime.isLocalInstall = userInfo.userId == 'maqettaUser';

			// Needed by review code
            Runtime.userName = userInfo.userId;
            Runtime.userEmail = userInfo.email;
            return metadata.init();
	    }).then(function(){
			var perspective = Runtime.initialPerspective || "davinci.ui.main";
			dojo.query('.loading').orphan();
			Workbench.showPerspective(perspective);
			Workbench._updateTitle();
			initializeWorkbenchState();			
		}).otherwise(function(result){
			dojo.query('#load_screen').addContent(dojo.string.substitute(webContent.startupError, [result.message]), "only")/*.addClass("error")*/;
		});

		Workbench._lastAutoSave = Date.now();
		setInterval(dojo.hitch(this,"_autoSave"),30000);
		return d;
	},

	unload: function () {
		Workbench._autoSave();
	},

	logoff: function(args) {
		dojo.create("div", {
				'class': 'loading',
				innerHTML: '<table><tr><td><span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>&nbsp;Logging off...</td></tr></table>' // FIXME: i18n
			}, dojo.body(), "first");

		Workbench.unload();
		return xhr.get({
			url: "cmd/logoff",
			handleAs: "text"
		}).then(function(result) {
			location.href = "welcome";
		});
	},

	/**
	 * Creates a toolbar widget out of the definitions in the plugin file(s)
	 * @param {string} toolbarProp  The property name from plugin file that corresponds to this particular toolbar
	 * @param {Element} targetDiv  Container DIV into which this toolbar should be instantiated
	 * @param actionSets  Action sets from plugin file(s)
	 * @param context  Document context FIXME: 95% sure that parameter is obsolete
	 * @returns {Toolbar}  toolbar widget
	 */
	_createToolBar: function (toolbarProp, targetDiv, actionSets, context){
		var _toolbarcache = [];
		if (!actionSets) {
		   actionSets = Runtime.getExtensions('davinci.actionSets');
		}
		for (var i = 0, len = actionSets.length; i < len; i++) {
			var actions = actionSets[i].actions;
			for (var k = 0, len2 = actions.length; k < len2; k++) {
				var action = actions[k],
					toolBarPath = action[toolbarProp];
				if (toolBarPath) {
					if (!_toolbarcache[toolBarPath]) {
						_toolbarcache[toolBarPath] = [];
					}
					_toolbarcache[toolBarPath].push(action);
				}
			}
		}
	
		var toolbar1 = new Toolbar({'class':"davinciToolbar"}, targetDiv);   
		var radioGroups = {};
		var firstgroup = true;
		for (var value in _toolbarcache) {
			if (!firstgroup) {
				var separator = new ToolbarSeparator();
				toolbar1.addChild(separator);
			} else {
				firstgroup = false;
			}
			var actions = _toolbarcache[value];
			for (var p = 0; p<actions.length; p++) {
				var action = actions[p];
				// dont add dupes
		
				Workbench._loadActionClass(action);
				var parms = {showLabel:false/*, id:(id + "_toolbar")*/};
				['label','showLabel','iconClass'].forEach(function(prop){
					if(action.hasOwnProperty(prop)){
						parms[prop] = action[prop];
					}
				});
				if (action.className) {
					parms['class'] = action.className;
				}
				var dojoAction;
				var dojoActionDeferred = new Deferred();
				if(action.menu && (action.type == 'DropDownButton' || action.type == 'ComboButton')){
					var menu = new Menu({
						style: "display: none;"
					});
					for(var ddIndex=0; ddIndex<action.menu.length; ddIndex++){
						var menuItemObj = action.menu[ddIndex];
						Workbench._loadActionClass(menuItemObj);
						var menuItemParms = {
							onClick: dojo.hitch(this, "_runAction", menuItemObj, context)
						};
						var props = ['label','iconClass'];
						props.forEach(function(prop){
							if(menuItemObj[prop]){
								menuItemParms[prop] = menuItemObj[prop];
							}
						});
						var menuItem = new MenuItem(menuItemParms);
						menuItem._maqAction = menuItemObj;
						menu.addChild(menuItem);
					}
					parms.dropDown = menu;
					if(action.type == 'DropDownButton'){
						dojoAction = new DropDownButton(parms);
					}else{
						dojoAction = new ComboButton(parms);
					}
					dojoAction.onClick = dojo.hitch(this, "_runAction", action, context);
					dojoAction._maqAction = action;
					dojoActionDeferred.resolve();
				}else if (action.toggle || action.radioGroup) {
					dojoAction = new ToggleButton(parms);
					dojoAction.item = action;
					dojoAction.set('checked', action.initialValue);
					if (action.radioGroup) {
						var group = radioGroups[action.radioGroup];
						if (!group) {
							group = radioGroups[action.radioGroup]=[];
						}
						group.push(dojoAction);
						dojoAction.onChange = dojo.hitch(this, "_toggleButton", dojoAction, context, group);
					} else {
						dojoAction.onChange = dojo.hitch(this,"_runAction", action, context);
					}
					dojoAction._maqAction = action;
					dojoActionDeferred.resolve();
				}else if(action.type){
					require([action.type], function(ReviewToolBarText) {
						dojoAction = new ReviewToolBarText();
						dojoAction._maqActiond = action;
						dojoActionDeferred.resolve();
					});
				}else{
					dojoAction = new Button(parms);
					dojoAction.onClick = dojo.hitch(this, "_runAction", action, context);
					dojoAction._maqAction = action;
					dojoActionDeferred.resolve();
				}
				if (action.icon) {
					var imageNode = document.createElement('img');
					imageNode.src = action.icon;
					imageNode.height = imageNode.width = 18;
					dojoAction.domNode.appendChild(imageNode);
				}
				dojoActionDeferred.then(function(){
					toolbar1.addChild(dojoAction);
					//FIXME: looks like the parameter to isEnabled is "context",
					//but maybe that should be the current editor instead. Whatever, 
					//targetObjectId just has to be wrong.
					if (action.isEnabled && !action.isEnabled(/*FIXME: targetObjectId*/)) { 
						dojoAction.isEnabled = action.isEnabled;
						dojoAction.set('disabled', true);
					} else {
						dojoAction.set('disabled', false);
					}
				});
			}
		}
		return toolbar1;
	},

	showPerspective: function(perspectiveID) {
		Workbench.activePerspective = perspectiveID;
		var menuTree = Workbench._createMenuTree();	// no params means include "everything else"
		Workbench._updateMainMenubar(dojo.byId('davinci_main_menu'), menuTree);

		var o = this.getActionSets('davinci.ui.editorMenuBar');
		var clonedActionSets = o.clonedActionSets;
		if(clonedActionSets.length){
			menuTree = Workbench._createMenuTree(clonedActionSets);
			Workbench._updateMainMenubar(dojo.byId('maq_banner_editor_commands'), menuTree);
		}

		var mainBody = dojo.byId('mainBody');
		if (!mainBody.tabs) {
			mainBody.tabs = [];
		}
		
		/* Large border container for the entire page */
		var mainBodyContainer = dijit.byId('mainBody');

		if (!mainBodyContainer) {
			mainBodyContainer = new BorderContainer({
				gutters: false,
				region: "center",
				design: 'sidebar'
			}, mainBody);
		}
		var perspective = Runtime.getExtension("davinci.perspective",perspectiveID);

		if (!perspective) {
			Runtime.handleError(dojo.string.substitute(webContent.perspectiveNotFound,[perspectiveID]));
		}

		perspective = dojo.clone(perspective);	// clone so views aren't added to original definition

		var extensions = Runtime.getExtensions("davinci.perspectiveExtension",
				function (extension) {
					return extension.targetID === perspectiveID;
				});
		dojo.forEach(extensions, function (extension) {
			// TODO: should check if view is already in perspective. filter + concat instead of foreach + push?
			dojo.forEach(extension.views, function (view){ perspective.views.push(view); });
		});

		if (!mainBody.editorsStackContainer) {
			Workbench.editorsStackContainer = mainBody.editorsStackContainer =
				new StackContainer({
					region:'center',
					id: "editorsStackContainer",
					controllerWidget: "dijit.layout.StackController"
				});
		}
		// FIXME: THIS BYPASSES THE PLUGIN SYSTEM.
		// Hardcoding this for now. Need to figure out how to turn change
		// welcome page logic into something that is defined by ve_plugin.js.
		mainBodyContainer.addChild(mainBody.editorsStackContainer);
		if (!mainBody.editorsWelcomePage) {
			Workbench.editorsWelcomePage = mainBody.editorsWelcomePage =
				new ContentPane({
					id: "editorsWelcomePage",
					href: "app/davinci/ve/resources/welcome_to_maqetta.html"
				});
		}
		mainBody.editorsStackContainer.addChild(mainBody.editorsWelcomePage);
		if (!mainBody.tabs.editors) {
			Workbench.editorTabs = mainBody.tabs.editors =
				new (Workbench.hideEditorTabs ? StackContainer : TabContainer)({
					id: "editors_container",
					controllerWidget: (Workbench.hideEditorTabs ? "dijit.layout.StackController" : "dijit.layout.TabController")
				});
			Workbench.editorTabs.setTitle = function(editorContainer, title) { 
				editorContainer.attr('title', title);
				// After letting Dijit put the title onto the ContentPane,
				// force title to null string on the domNode so that the
				// browser doesn't show an annoying tooltip while hovering
				// over an editor.
				editorContainer.domNode.title = '';
				if(!Workbench.hideEditorTabs){
					this.tablist.pane2button[editorContainer.id].attr('label', title);
				}else{
					var editorId = editorContainer.id;
					var shadowId = editorIdToShadowId(editorId);
					var shadowTabContainer = dijit.byId("davinci_file_tabs");
					var titleWithDirty = title + (editorContainer.isDirty ? '<span class="dirtyFileAsterisk"></span>'  : '');
					shadowTabContainer.tablist.pane2button[shadowId].attr('label', titleWithDirty);
				}
			};
			
			dojo.connect(mainBody.tabs.editors, "removeChild", this, Workbench._editorTabClosed);
		}
		mainBody.editorsStackContainer.addChild(mainBody.tabs.editors);
		mainBody.editorsStackContainer.selectChild(mainBody.editorsWelcomePage);
		dojo.connect(dijit.byId("editors_container"), "selectChild", function(child) {
			if(!Workbench._processingSelectChild){
				Workbench._processingSelectChild = true;
				var editorId = child.id;
				var shadowId = editorIdToShadowId(editorId);
				var shadowTab = dijit.byId(shadowId);
				var shadowTabContainer = dijit.byId("davinci_file_tabs");
				if(shadowTab && shadowTabContainer){
					shadowTabContainer.selectChild(shadowTab);
				}
				if (child.editor) {
					Workbench._switchEditor(child.editor);
				}
				Workbench._processingSelectChild = false;
			}
		});
		mainBodyContainer.startup();

		// Put the toolbar and the main window in a border container
		var appBorderContainer = dijit.byId('davinci_app');
		if (!appBorderContainer) {
			appBorderContainer = new BorderContainer({
				design: "headline",
				gutters: false,
				liveSplitters: false
			}, "davinci_app");
			
			var topBarPane = new ContentPane({
				region: "top",
				layoutPriority:1
			}, "davinci_top_bar");
			
			var mainStackContainer = Workbench.mainStackContainer = mainBody.editorsStackContainer =
				new StackContainer({
					region:'center',
					id: "mainStackContainer",
					controllerWidget: "dijit.layout.StackController"
				});

			var mainBorderContainer = Workbench.mainBorderContainer = new BorderContainer({
				design: "headline",
				gutters: false,
				id:'mainBorderContainer',
				liveSplitters: false
			});
			
			var shadowTabContainer = Workbench.shadowTabs = new TabContainer({
				id:'davinci_file_tabs',
				closable: true,
				region: "top",
				layoutPriority:1,
				style:'display:none'
			});
			
			Workbench.shadowTabs.setTitle = function(tab, title) { 
				tab.attr('title', title);
				this.tablist.pane2button[tab.id].attr('label', title);
			};
			dojo.connect(shadowTabContainer, "selectChild", function(child) {
				var shadowId = child.id;
				var editorId = shadowIdToEditorId(shadowId);
				var editorContainer = dijit.byId(editorId);
				var editorsContainer = dijit.byId("editors_container");
				if (editorsContainer && editorContainer && editorContainer.editor) {
					// This is trigger (indirectly) the selectChild callback function on 
					// the editors_container widget, which will trigger Workbench._switchEditor
					editorsContainer.selectChild(editorContainer);
				}
			});
			dojo.connect(shadowTabContainer, "removeChild", this, Workbench._shadowTabClosed);
			var toolbarPane = new ContentPane({
				id:'davinci_toolbar_pane',
				region: "top",
				layoutPriority:1,
				content:'<div id="davinci_toolbar_container"></div>',
				style:'display:none'
			});
		
			appBorderContainer.addChild(topBarPane);
			appBorderContainer.addChild(mainStackContainer);
			mainStackContainer.addChild(mainBorderContainer);
			mainStackContainer.selectChild(mainBorderContainer);

			mainBorderContainer.addChild(shadowTabContainer);
			mainBorderContainer.addChild(toolbarPane);
			mainBorderContainer.addChild(mainBodyContainer);
			appBorderContainer.layout();	
			appBorderContainer.startup();
			Workbench._originalOnResize = window.onresize;
			window.onresize = Workbench.onResize; //alert("All done");}
			dojo.connect(mainBodyContainer, 'onMouseUp', this, 'onResize');
			
			var shadowTabMenu = dijit.byId('davinci_file_tabs_tablist_Menu');
			if(shadowTabMenu){
				shadowTabMenu.addChild(new dijit.MenuItem({
					label: veNLS.closeAllEditors,
					onClick: this.closeAllEditors
				}));
			}
		}
		/* close all of the old views */
		for (var position in mainBody.tabs.perspective) {
			var view = mainBody.tabs.perspective[position];
			if(!view) {
				continue;
			}
			dojo.forEach(view.getChildren(), function(child) {
				view.removeChild(child);
				if (position != 'left' && position != 'right') {
					child.destroyRecursive(false);
				}
			});
			view.destroyRecursive(false);
			delete mainBody.tabs.perspective[position];
		}

		this._showViewPromises = dojo.map(perspective.views, function(view) {
			return Workbench.showView(view.viewID, view.selected, view.hidden);
		}, this);

		//FIXME: This is also ugly - creating a special DIV for visual editor's selection chrome
		//Note sure how best to factor this out, though.
		davinci.Workbench.focusContainer = dojo.create('div', {'class':'focusContainer', id:'focusContainer'}, document.body);

		// kludge to workaround problem where tabs are sometimes cutoff/shifted to the left in Chrome for Mac
		// would be nice if we had a workbench onload event that we could attach this to instead of relying on a timeout
		setTimeout(function() {
			appBorderContainer.resize();
			dojo.publish("/davinci/workbench/ready", []);
		}.bind(this), 3000);
	},

	onResize: function(e){
		var target = e.explicitOriginalTarget ? e.explicitOriginalTarget : e.srcElement;
		if (e.type == 'resize' || ((target.id && (target.id.indexOf('dijit_layout__Splitter_')>-1) || 
			(target.nextSibling && target.nextSibling.id && target.nextSibling.id.indexOf('dijit_layout__Splitter_')>-1)))) {
			var ed = davinci && Runtime.currentEditor;
			if (ed && ed.onResize) {
				ed.onResize();
			}
		}
		if (Workbench._originalOnResize) {
			Workbench._originalOnResize();
		}
		Workbench._repositionFocusContainer();
	},

	updateMenubar: function(node, actionSets) {
		var menuTree = Workbench._createMenuTree(actionSets);

		var menuTop = dijit.byId(node.id);
		if (!menuTop) {
			menuTop = new MenuBar({'class': 'dijitInline'}, node);
		}
		Workbench._addItemsToMenubar(menuTree, menuTop);
	},
	
	_updateMainMenubar: function(menuDiv, menuTree) {
		for (var i=0; i<menuTree.length; i++) {
			var menuTreeItem = menuTree[i];
			for (var j=0;j<menuTreeItem.menus.length;j++) {
				var menu = menuTreeItem.menus[j];
				var menuWidget = Workbench._createMenu(menu);
				menu.id = menu.id.replace(".", "-"); // kludge to work around the fact that '.' is being used for ids, and that's not compatible with CSS
				// Set up top banner region. (Top banner is an extensibility point)
				if(window.maqetta && maqetta.TopBanner && maqetta.TopBanner.attachMenu){
					maqetta.TopBanner.attachMenu(menu, menuWidget, menuDiv);
				}else{
					var widget = dijit.byId(menu.id + "-dropdown");
					if(!widget) {
						var params = { label: menu.label, dropDown: menuWidget, id: menu.id + "-dropdown" };
						if(menu.hasOwnProperty('showLabel')){
							params.showLabel = menu.showLabel;
						}
						if(menu.hasOwnProperty('iconClass')){
							params.iconClass = menu.iconClass;
						}
						if(menu.hasOwnProperty('className')){
							params['class'] = menu.className;
						}
						widget = new DropDownButton(params);
						menuDiv.appendChild(widget.domNode);
					}
				}
			}
		}
	},

	_addItemsToMenubar: function(menuTree, menuTop) {
		dojo.forEach(menuTree, function(m) {
			var menus = m.menus,
				menuLen = menus.length;
			if (menuLen) {
				dojo.forEach (menus, function(menu) {
					menu.id = menu.id.replace(/\./g, "-"); // kludge to work around the fact that '.' is being used for ids, and that's not compatible with CSS
					var menuWidget = Workbench._createMenu(menu),
						widget =  dijit.byId(menu.id + "-dropdown");
					if (!widget) {
						widget = new PopupMenuBarItem({
							label: menu.label,
							popup: menuWidget,
							id: menu.id + "-dropdown"
						});
					}
					menuTop.addChild(widget);
				}, this);
			}
		}, this);
	},
	/* returns either the active editor, or the editor with given resource open */
	getOpenEditor: function(resource) {
		
		if(resource!=null){
			var tab = dijit.byId(filename2id(resource.getPath()));
			if (tab) {
				return tab.editor;
			}
			return null; // no editor found for given resource
		}
		
		
		var editorsContainer = dijit.byId("editors_container");
		if (editorsContainer && editorsContainer.selectedChildWidget && editorsContainer.selectedChildWidget.editor) {
			return editorsContainer.selectedChildWidget.editor;
		}
		return null;
	},

	closeActiveEditor: function() {
		var editorsContainer = dijit.byId("editors_container");
		var shadowTabContainer = dijit.byId("davinci_file_tabs");

		if (editorsContainer && editorsContainer.selectedChildWidget && editorsContainer.selectedChildWidget.editor) {
			var editorId = selectedChildWidget.id;
			var shadowId = editorIdToShadowId(editorId);
			editorsContainer.closeChild(editorsContainer.selectedChildWidget);
			var shadowTab = dijit.byId(shadowId);
			if(shadowTab){
				shadowTabContainer.closeChild(shadowTab);
			}
		}
	},

	closeAllEditors: function() {
		var editorsContainer = dijit.byId("editors_container");

		if (editorsContainer) {
			editorsContainer.getChildren().forEach(function(child){
				editorsContainer.closeChild(child);
			});
		}
	},

	getAllOpenEditorIds: function() {
	},

	showModal: function(content, title, style, callback, submitOnEnter, onShow) {
		return Dialog.showModal(content, title, style, callback, submitOnEnter, onShow);
	},

	// simple dialog with an automatic OK button that closes it.
	showMessage: function(title, message, style, callback, submitOnEnter) {
		return Dialog.showMessage(title, message, style, callback, submitOnEnter);
	},

	// OK/Cancel dialog with a settable okLabel
	showDialog: function(params) {
		return Dialog.showDialog(params);
	},

	_createMenuTree: function(actionSets, pathsOptional) {
		if (!actionSets) {  // only get action sets not associated with part
			actionSets =  Runtime.getExtensions("davinci.actionSets", function (actionSet) {
				var associations = Runtime.getExtensions("davinci.actionSetPartAssociations", function(actionSetPartAssociation) {
					return actionSetPartAssociation.targetID == actionSet.id;
				});	
				return associations.length == 0;
			});
		}
		var menuTree = [];
		function findID(m, id) { //ALP: dijit.byId?
			for ( var j = 0, jLen = m.length; j < jLen; j++) {
				for ( var k = 0, kLen = m[j].menus.length; k < kLen; k++) {
					if (id == m[j].menus[k].id) {
						return m[j].menus[k].menus;
					}
				}
			}
		}

		function addItem(item, path,pathsOptional) {
			path = path || "additions";
			path = path.split('/');
			var m = menuTree;

			Workbench._loadActionClass(item);
			
			var sep = path[path.length - 1];
			if (path.length > 1) {
				for ( var i = 0, len = path.length - 1; i < len; i++) {
					var k = findID(m, path[i]);
					if (k) {
						m = k;
					}
				}
			}
			for ( var i = 0, len = m.length; i < len; i++) {
				if (m[i].id == sep) {
					var menus = m[i].menus;
					menus.push(item);
					if (item.separator) { // if menu
						var wasAdditions = false;
						menus = item.menus = [];
						for ( var j = 0; j < item.separator.length; j += 2) {
							var id = item.separator[j];
	
							wasAdditions = id == "additions";
							menus.push( {
								id: id,
								isSeparator: item.separator[j + 1],
								menus: []
							});
						}
						if (!wasAdditions) {
							menus.push({
								id: "additions",
								isSeparator: false,
								menus: []
							});
						}
					}
					return;
				}
			}
			if (pathsOptional) {
				menuTree.push( {
					id: sep,
					isSeparator: false,
					menus: [item]
				});
			}
		}
	
		for ( var actionSetN = 0, len = actionSets.length; actionSetN < len; actionSetN++) {
			var actionSet = actionSets[actionSetN];
			if (actionSet.visible) {
				if (actionSet.menu) {
					for ( var menuN = 0, menuLen = actionSet.menu.length; menuN < menuLen; menuN++) {
						var menu = actionSet.menu[menuN];
						if (menu.__mainMenu) {
							for ( var j = 0; j < menu.separator.length; j += 2) {
								menuTree.push({
									id: menu.separator[j],
									isSeparator: menu.separator[j + 1],
									menus: []
								});
							}
						} else {
							addItem(menu, menu.path,pathsOptional);
							if (menu.populate instanceof Function) {
								var menuItems = menu.populate();
								for (var item in menuItems) {
									addItem(menuItems[item], menuItems[item].menubarPath);
								}
							}
								
						}
					}
				}
			}
		}
		
		for ( var actionSetN = 0, len = actionSets.length; actionSetN < len; actionSetN++) {
			var actionSet = actionSets[actionSetN];
			if (actionSet.visible) {
				for ( var actionN = 0, actionLen = actionSet.actions.length; actionN < actionLen; actionN++) {
					var action = actionSet.actions[actionN];
					if (action.menubarPath) {
						addItem(action, action.menubarPath,pathsOptional);
					}
				}
			}
		}
		return menuTree;
	},

	_loadActionClass: function(item) {
		if (typeof item.action == "string") {
			require([item.action], function(ActionClass){
				item.action = new ActionClass();
				item.action.item = item;
			});
		}
	},

	_createMenu: function(menu, context) {
		var menuWidget,menus,connectFunction;
		if (menu.menus) {  // creating dropdown
		  menuWidget = new Menu({parentMenu: menu });
		  menus = menu.menus;
		  connectFunction = "onOpen";
		} else {	// creating popup
			menuWidget = new PopupMenu({});
			menus = menu;
			connectFunction="menuOpened";
		}

		menuWidget.domNode.style.display = "none";
		menuWidget.actionContext = context;
		this._rebuildMenu(menuWidget, menus);
		dojo.connect(menuWidget, connectFunction, this, function(evt) {
			if (menuWidget._widgetCallback) { // create popup
				  menuWidget._widgetCallback(evt);
			}
			this._rebuildMenu(menuWidget, menus).focus(); // call focus again, now that we messed with the widget contents
		});
		return menuWidget;
	},
	/*
	 * running in single project mode or multi project mode
	 */
	singleProjectMode: function() {
		return true;
	},
	
	getProject: function() {
		return Workbench.getActiveProject() || Workbench._DEFAULT_PROJECT;
	},
	
	
	loadProject: function(projectName) {
		Workbench.setActiveProject(projectName);
		return Workbench.updateWorkbenchState().then(function(){
			// make sure the server has maqetta setup for the project
			location.href="cmd/configProject?configOnly=true&project=" + encodeURIComponent(projectName);
		});
		
		// if the project was set via URL parameter, clear it off.  
		
	
	},

	//FIXME: remove. Use Runtime.location() instead.
	location: function() {
		return Runtime.location();
	},

	_rebuildMenu: function (menuWidget, menus) {
		dojo.forEach(menuWidget.getChildren(), function(child){
			menuWidget.removeChild(child);
			child.destroy();
		});
		menuWidget.focusedChild = null; // TODO: dijit.Menu bug?  Removing a focused child should probably reset focusedChild for us

		var addSeparator, menuAdded;
		menus.forEach(function(menu, i){
			if (menu.menus.length) {
				if (menu.isSeparator && i>0) {
					addSeparator=true;
				}
				menu.menus.forEach(function(item){
					if (addSeparator && menuAdded) {
						menuWidget.addChild(new MenuSeparator({}));
						addSeparator=false;
					}
					menuAdded = true;
					var label = item.label;
					if (item.action && item.action.getName) {
						label = item.action.getName();
					}
					if (item.separator) {
						var subMenu = Workbench._createMenu(item);
						var popupParent = new MenuItem({
							label: label,
							popup: subMenu,
							id: subMenu.id + "item"
						});
						popupParent.actionContext = menuWidget.actionContext;
						menuWidget.addChild(popupParent);
					} else {
						var enabled = true;
						if (item.isEnabled) {
							var selection = Runtime.getSelection(),
								resource = selection[0] && selection[0].resource;
							enabled = resource ? item.isEnabled(resource) : false;
						}

						if (item.action) {
							if (item.action.shouldShow && !item.action.shouldShow(menuWidget.actionContext, {menu: menuWidget})) {
								return;
							}
							//FIXME: study this code for bugs.
							//menuWidget.actionContext: is that always the current context?
							//There were other bugs where framework objects pointed to wrong context/doc
							enabled = item.action.isEnabled && item.action.isEnabled(menuWidget.actionContext);
						}

						var menuArgs = {
								label: label,
								id: item.id,
								disabled: !enabled,
								onClick: dojo.hitch(this, "_runAction", item, menuWidget.actionContext)
						};
						if (item.iconClass) {
							menuArgs.iconClass = item.iconClass;
						}

						menuWidget.addChild(new MenuItem(menuArgs));
					}
				}, this);
			}
		}, this);

		return menuWidget;
	},
	
	_toggleButton: function(button, context, group, arg) {
		if (!button.checked) {
			return;
		}
		group.forEach(function(item) {
			if (item != button) {
				item.set('checked', false);
			}
		});
		Workbench._runAction(button.item,context,button.item.id);
	},

	//FIXME: "context" is really an editor, isn't it? Like davinci.ve.PageEditor?
	_runAction: function(item, context, arg) {
		//FIXME: Not sure this code is correct, but sometimes this routine is passed
		//a context object that is not associated with the current document
		if(context && Runtime.currentEditor){
			context = Runtime.currentEditor;
		}
		if (item.run) {
			item.run();
		} else if (item.action) {
			if (dojo.isString(item.action)) {
				this._loadActionClass(item);
			}
			item.action.run(context);
		} else if (item.method && context && context[item.method] instanceof Function) {
			context[item.method](arg);
		} else if (item.commandID) {
			Runtime.executeCommand(item.commandID);
		}
	},

	showView: function(viewId, shouldFocus, hidden){
		var d = new Deferred();

		try {
			var mainBodyContainer = dijit.byId('mainBody'),
				view = Runtime.getExtension("davinci.view", viewId),
				mainBody = dojo.byId('mainBody'),
				perspectiveId = Workbench.activePerspective,
				perspective = Runtime.getExtension("davinci.perspective", perspectiveId),
				position = 'left',
				cp1;

			dojo.some(perspective.views, function(view){
				if(view.viewID ==  viewId){
					position = view.position;
					return true;
				}	
			});
			
			mainBody.tabs = mainBody.tabs || {};				
			mainBody.tabs.perspective = mainBody.tabs.perspective || {};
	
			// NOTE: Left-side and right-side palettes start up with 71px width
			// which happens to be the exact pixel size of the palette tabs.
			// This 71px setting prevents the user from seeing an initial flash
			// of temporarily opened left-side and right-side palettes.
			if (position == 'right' && !mainBody.tabs.perspective.right) {
				mainBodyContainer.addChild(mainBody.tabs.perspective.right = 
					new BorderContainer({'class':'davinciPaletteContainer', 
						style: 'width: '+paletteTabWidth+'px;', id:"right_mainBody", 
						minSize:paletteTabWidth,	// prevent user from dragging splitter too far towards edge
						region:'right', gutters: false, splitter:true}));
				mainBody.tabs.perspective.right.startup();
				// expandToSize is what expandPaletteContainer() uses as the
				// width of the palette when it is in expanded state.
				paletteCache.right_mainBody = {
					expandToSize:340,
					initialExpandToSize:340
				};
			}
	
			if (position == 'left' && !mainBody.tabs.perspective.left) {
				mainBodyContainer.addChild(mainBody.tabs.perspective.left = 
					new BorderContainer({'class':'davinciPaletteContainer', 
						style: 'width: '+paletteTabWidth+'px;', id:"left_mainBody", 
						minSize:paletteTabWidth,	// prevent user from dragging splitter too far towards edge
						region:'left', gutters: false, splitter:true}));
				mainBody.tabs.perspective.left.startup();
				// expandToSize is what expandPaletteContainer() uses as the
				// width of the palette when it is in expanded state.
				paletteCache["left_mainBody"] = {
					expandToSize:318,
					initialExpandToSize:318
				};
			}
	
			if (position === 'left' || position === 'right') {
				position += "-top";
			}
			var positionSplit = position;
	
			if (!mainBody.tabs.perspective[position]) {
				positionSplit = position.split('-');
	
				var region = positionSplit[0],
					parent = mainBodyContainer,
					clazz = 'davinciPalette ',
					style = '';
				if (positionSplit[1] && (region == 'left' || region == 'right')) {
					parent = mainBody.tabs.perspective[region];
					region = positionSplit[1];
					if (positionSplit[1] == "top") {
						region = "center";
						clazz += "davinciTopPalette";
					} else {
						style = 'height:30%;';
						clazz += "davinciBottomPalette";
					}
				} else if(region == 'bottom') {
					style = 'height:80px;';
					clazz += "davinciBottomPalette";
				}
				cp1 = mainBody.tabs.perspective[position] = new TabContainer({
					region: region,
					id:'palette-tabcontainer-'+position,
					tabPosition:positionSplit[0]+'-h',
					tabStrip:false,
					'class': clazz,
					style: style,
					splitter: region != "center",
					controllerWidget: "dijit.layout.TabController"
				});
				parent.addChild(cp1);
				dojo.connect(cp1, 'selectChild', this, function(tab){
					if(tab && tab.domNode){
						var tc = tab.getParent();
						// Don't mess with which tab is selected or do any collapse/expand
						// if selectChild is called in response to adding the first child
						// of a TabContainer, which causes an implicit selectFirst(),
						// or other programmatic selectChild() event (in particular, 
						// SwitchingStyleView.js puts _maqDontExpandCollapse on tabcontainer)
						if(!this._showViewAddChildInProcess && !tc._maqDontExpandCollapse){
							if(tc._maqLastSelectedChild == tab){
								this._expandCollapsePaletteContainer(tab);						
							}else{
								this.expandPaletteContainer(tab.domNode);						
							}
						}
						tc._maqLastSelectedChild = tab;
					}
				}.bind(this));
			} else {
				cp1 = mainBody.tabs.perspective[position];
			}
	
			if (dojo.some(cp1.getChildren(), function(child){ return child.id == view.id; })) {
				return;
			}
			this.instantiateView(view).then(function(tab) {
				this._showViewAddChildInProcess = true;
				if (!hidden) {
					cp1.addChild(tab);
				}
				this._showViewAddChildInProcess = false;
				// Put a tooltip on the tab button. Note that native TabContainer
				// doesn't offer a tooltip capability for its tabs
				var controlButton = tab.controlButton;
				if(controlButton && controlButton.domNode){
					controlButton.domNode.title = view.title + ' ' +  veNLS.palette;
				}
				if(shouldFocus) {
					cp1.selectChild(tab);
				}
				
				d.resolve(tab);
			}.bind(this));
		  } catch (ex) {
			  console.error("Error loading view: "+view.id);
			  console.error(ex);
		  }
		  
		  return d;
	},

	instantiateView: function(view) {
		var d = new Deferred(),
		tab = dijit.byId(view.id);
		if (tab) {
			d.resolve(tab);
		} else {
			require([view.viewClass], function(viewCtor){
				var params = { title: view.title,
						id: view.id, closable: false, view: view };
				if(view.iconClass){
					params.iconClass = view.iconClass;
				}
				if(!Workbench.palettes){
					Workbench.palettes = {};
				}
				// Stash the instantiated object corresponding to each palette class in
				// associative array davinci.palettes, indexed by view.viewClass.
				// Then pass the instantiated object as the argument to d.resolve().
				d.resolve((Workbench.palettes[view.viewClass] = new (viewCtor || ViewPart)(params),
						Workbench.palettes[view.viewClass]));
			});
		}
		return d;
	},

	hideView: function(viewId){
		for (var position in mainBody.tabs.perspective) {
			if(position=='left' || position == 'right'){
				position+='-top';
			}
			if(!mainBody.tabs.perspective[position]){
				continue;
			}
			var children = mainBody.tabs.perspective[position].getChildren();
			var found = false;
			for (var i = 0; i < children.length && !found; i++) {
				if (children[i].id == viewId) {
					mainBody.tabs.perspective[position].removeChild(children[i]);
					children[i].destroyRecursive(false);
				}
			}									
		}
	},

	toggleView: function(viewId) {
		var found = dojo.byId(viewId);
		if(found) {
			Workbench.hideView(viewId);
		} else{
			Workbench.showView(viewId, true);
		}
	},

	openEditor: function (keywordArgs, newHtmlParams) {
		try{
			var fileName=keywordArgs.fileName,
				fileExtension;
			if (typeof fileName=='string') {
				fileExtension=fileName.substr(fileName.lastIndexOf('.')+1);
			} else {
				fileExtension=fileName.getExtension();
				fileName=fileName.getPath();
			}
	
			var editorContainer = dijit.byId(filename2id(fileName)),
				editorsContainer = dijit.byId("editors_container");
	
			if (editorContainer) {
				// already open
				editorsContainer.selectChild(editorContainer);
				var editor=editorContainer.editor;
				if (keywordArgs.startOffset) {
					editor.select(keywordArgs);
				}
				return;
			}
			var editorCreateCallback=keywordArgs.editorCreateCallback;
			
			var editorExtensions=Runtime.getExtensions("davinci.editor", function (extension){
				 if (typeof extension.extensions =="string") {
					 extension.extensions=extension.extensions.split(',');
				 }
				 return dojo.some(extension.extensions, function(e){
					 return e.toLowerCase() == fileExtension.toLowerCase();
				 });
			});
	
			var editorExtension = editorExtensions[0];
			if (editorExtensions.length>1){
				dojo.some(editorExtensions, function(extension){
					editorExtension = extension;
					return extension.isDefault;
				});
			}
	
			Workbench._createEditor(editorExtension, fileName, keywordArgs, newHtmlParams).then(function(editor) {
				if(editorCreateCallback){
					editorCreateCallback.call(window, editor);
				}
	
				if(!keywordArgs.noSelect) {
					 Runtime.currentEditor = editor;
				}			
			}, function(error) {
				console.error("Error opening editor for filename: " + fileName, error);
			});
		} catch (ex) {
			console.error("Exception opening editor for filename: "+ keywordArgs && keywordArgs.fileName);
			console.error(ex);
		}

	},
	
	_createEditor: function(editorExtension, fileName, keywordArgs, newHtmlParams) {
		
		var d = new Deferred();
		var nodeName = fileName.split('/').pop();
		var extension = keywordArgs && keywordArgs.fileName && keywordArgs.fileName.extension ? 
				"." + keywordArgs.fileName.extension : "";
		nodeName += (extension == ".rev" ? extension : "");

		dojo.query('.loading').orphan();

		var editorsStackContainer = dijit.byId('editorsStackContainer'),
			editors_container = dijit.byId('editors_container');
		if (editorsStackContainer && editors_container) {
			editorsStackContainer.selectChild(editors_container);
			Workbench.mainStackContainer.selectChild(Workbench.mainBorderContainer);
		}

		var editorContainer = dijit.byId(filename2id(fileName)),
			editorsContainer = dijit.byId("editors_container"),
			shadowTabContainer = dijit.byId("davinci_file_tabs"),
			editorCreated = false,
			shadowTab = null;
		if (!editorContainer) {
			editorCreated = true;

			var editorId = filename2id(fileName);
			var shadowId = editorIdToShadowId(editorId);
			editorContainer = new EditorContainer({
				title: nodeName,
				id: editorId, 
				'class': "EditorContainer",
				isDirty: keywordArgs.isDirty
			});
			shadowTab = new ContentPane({
				title:nodeName,
				closable: true,
				id:shadowId
			});
			shadowTab.onClose = function(tc, tab){
				
				var shadowId = tab.id;
				var editorId = shadowIdToEditorId(shadowId);
				var editorContainer = dijit.byId(editorId);
				var editorsContainer = dijit.byId("editors_container");
				function okToClose(){
					editorContainer._skipDirtyCheck = true;
					editorContainer.onClose.apply(editorContainer, [editorsContainer, editorContainer]);
					tc.removeChild(tab);
					tab.destroyRecursive();
				}
				function saveAndClose(){
					editorContainer.editor.save();
					okToClose();
				}
				if(editorsContainer && editorContainer){
					if (editorContainer.editor.isDirty){
						//Give editor a chance to give us a more specific message
						var message = editorContainer.editor.getOnUnloadWarningMessage();
						if (!message) {
							//No editor-specific message, so use our canned one
							message = dojo.string.substitute(webContent.fileHasUnsavedChanges, [editorContainer._getTitle()]);
						}
						Workbench.showDialog({
								title: editorContainer._getTitle(),
								content: message, 
								style: {width: 300}, 
								okLabel: uiCommonNls.save,
								okCallback: dojo.hitch(this,saveAndClose),
								hideLabel: null,
								submitOnEnter:true,
								extendLabels: [uiCommonNls.discard],
								extendCallbacks: [dojo.hitch(this,okToClose)]
							});
					} else {
						okToClose();
					}
				}
			};
		}
		
		if (!editorExtension) {
			editorExtension = {
				editorClass: 'davinci/ui/TextEditor',
				id: 'davinci.ui.TextEditor'
			};
		}

		if (editorCreated) {
			editorsContainer.addChild(editorContainer);
			shadowTabContainer.addChild(shadowTab);
		}

		// add loading spinner
		if(!Workbench.hideEditorTabs){
			var loadIcon = dojo.query('.dijitTabButtonIcon',editorContainer.controlButton.domNode);
			dojo.addClass(loadIcon[0],'tabButtonLoadingIcon');
			dojo.removeClass(loadIcon[0],'dijitNoIcon');
		}
		
		if (!keywordArgs.noSelect) {
			editorsContainer.selectChild(editorContainer);
		}
		//FIXME: this is very kludgy. At initialization time, we want EditorContainer.js 
		//to filter past all editors except the current filename to prevent the cs=null issue #3279.
		//But when not at initialization time, we need to make sure the
		//current activeEditor is set to the "fileName".
		if(!keywordArgs.initializationTime){
			Workbench._state.activeEditor = fileName;
		}
		editorContainer.setEditor(editorExtension, fileName, true, keywordArgs.fileName, editorContainer.domNode, newHtmlParams).then(function(editor) {
			if (keywordArgs.startLine) {
				editorContainer.editor.select(keywordArgs);
			}
			
			if (!keywordArgs.noSelect) {
	            if (Workbench._state.editors.indexOf(fileName) === -1) {
	            	Workbench._state.editors.push(fileName);
	            }
				Workbench._switchEditor(editorContainer.editor, keywordArgs.startup);
			}

			if(!Workbench.hideEditorTabs){
				dojo.removeClass(loadIcon[0],'tabButtonLoadingIcon');
				dojo.addClass(loadIcon[0],'dijitNoIcon');
			}

			setTimeout(function() {
				editorContainer.resize(); //kludge, forces editor to correct size, delayed to force contents to redraw
			}, 100);
			d.resolve(editorContainer.editor);
		}, function(error) {
			if(!Workbench.hideEditorTabs){
				dojo.removeClass(loadIcon[0],'tabButtonLoadingIcon');
				dojo.addClass(loadIcon[0],'tabButtonErrorIcon');
			}

			d.reject(error);
		});
		return d;
	},

	createPopup: function(args) {
		var partID = args.partID, domNode=args.domNode, 
			context=args.context,
			widgetCallback=args.openCallback;
		
		var o = this.getActionSets(partID);
		var clonedActionSets = o.clonedActionSets;
		var actionSets = o.actionSets;
		if(clonedActionSets.length > 0){
			var menuTree=Workbench._createMenuTree(clonedActionSets,true);
			Workbench._initActionsKeys(actionSets, args);
			var popup=Workbench._createMenu(menuTree,context);
			if (popup && domNode) {
				popup.bindDomNode(domNode);
			}
			popup._widgetCallback=widgetCallback;
			popup._partID = partID;
			return popup;
		}
	},

	getActionSets: function(partID){
		var actionSetIDs = [];
		Runtime.getExtension("davinci.actionSetPartAssociations", function (extension) {
			return extension.parts.some(function(part) {
				if (part == partID) {
					actionSetIDs.push(extension.targetID);
					return true;
				}
			});
		});
		
		var actionSets;
		var clonedActionSets = [];
		if (actionSetIDs.length) {
		   actionSets = Runtime.getExtensions("davinci.actionSets", function (extension) {
				return actionSetIDs.some(function(setID) { return setID == extension.id; });
			});
		   if (actionSets.length) {
			   // Determine if any widget libraries have indicated they want to augment the actions in
			   // the action set
			   actionSets.forEach(function(actionSet) {
				   var libraryActions = metadata.getLibraryActions(actionSet.id);
				   if (libraryActions.length) {
					   // We want to augment the action list, so let's copy the
					   // action set before pushing new items onto the end of the
					   // array.
					   actionSet = lang.mixin({}, actionSet); // shallow obj copy
					   actionSet.actions = actionSet.actions.concat(libraryActions); // copy array, add libraryActions
				   }
				   clonedActionSets.push(actionSet);
			   });
			}
		}
		return { actionSets: actionSets, clonedActionSets: clonedActionSets};
	},

	_initActionsKeys: function(actionSets, args) {
		var keysDomNode = args.keysDomNode || args.domNode,
			keys = {},
			wasKey;
		dojo.forEach(actionSets, function(actionSet){
			dojo.forEach(actionSet.actions, function(action){
				if (action.keySequence) {
					keys[action.keySequence]=action;
					wasKey=true;
				}
			});
		});
		if (wasKey) {
			var context=args.context;
          dojo.connect(keysDomNode, "onkeydown", function (e){
				var seq = Workbench._keySequence(e),
					actionItem = keys[seq];
				if (actionItem) {
					if (actionItem.action.shouldShow && !actionItem.action.shouldShow(context)) {
						return;
					}
					if (actionItem.action.isEnabled(context)) {
						Workbench._runAction(actionItem,context);
					}
        	  }
          });
		}
	},
	
	_initKeys: function () {
		var keys={all: []};
		var keyExtensions=Runtime.getExtensions("davinci.keyBindings");
		dojo.forEach(keyExtensions, function(keyExt){
			var contextID= keyExt.contextID || "all";
			var keyContext=keys[contextID];
			if (!keyContext) {
			  keyContext=keys[contextID]=[];
			}
			
			keyContext[keyExt.sequence]=keyExt.commandID;
		});

		Workbench.keyBindings=keys;
	},

	handleKey: function (e) {
		if (!Workbench.keyBindings) {
			return;
		}
		var seq=Workbench._keySequence(e);
		var cmd;
		if (Workbench.currentContext && Workbench.keyBindings[Workbench.currentContext]) {
			cmd=Workbench.keyBindings[Workbench.currentContext][seq];
		}
		if (!cmd) {
			cmd=Workbench.keyBindings.all[seq];
		}
		if (cmd) {
			Runtime.executeCommand(cmd);
			return true;
		}
	},
	
	_keySequence: function (e) {
		var seq=[];
		if (window.event) 
		{
			if (window.event.ctrlKey) {
				seq.push("M1");
			}
			if (window.event.shiftKey) {
				seq.push("M2");
			}
			if (window.event.altKey) {
				seq.push("M3");
			}
		}
		else 
		{
			if (e.ctrlKey || (e.modifiers==2) || (e.modifiers==3) || (e.modifiers>5)) {
				seq.push("M1");
			}
			if (e.shiftKey || (e.modifiers>3)) {
				seq.push("M2");
			}
			if(e.modifiers) {
				if (e.altKey || (e.modifiers % 2)) {
					seq.push("M3");
				}
			}
			else {
				if (e.altKey) {
					seq.push("M3");
				}
			}
		}
		
		var letter=String.fromCharCode(e.keyCode);
		if (/[A-Z0-9]/.test(letter)) {
			//letter=e.keyChar;
		} else {
			var keyTable = {
				46: "del",
				114: "f3"
			};

			letter = keyTable[e.keyCode] || "xxxxxxxxxx";
		}
		letter=letter.toUpperCase();
		if (letter==' ') {
			letter="' '";
		}
				
		seq.push(letter);
		return seq.join("+");
	},

	setActionScope: function(scopeID,scope) {
		Workbench.actionScope[scopeID]=scope;
	},
	
	findView: function (viewID) {
		var domNode=dijit.byId(viewID);
		if (domNode) {
			return domNode;
		}
	},

	_switchEditor: function(newEditor, startup) {
		var oldEditor = Runtime.currentEditor;
		Runtime.currentEditor = newEditor;
		Workbench._state.activeEditor=newEditor ? newEditor.fileName : null;
		this._removeFocusContainerChildren();	//FIXME: Visual editor logic bleeding into Workbench
		this._showEditorTopPanes();
		try {
			dojo.publish("/davinci/ui/editorSelected", [{
				editor: newEditor,
				oldEditor: oldEditor
			}]);
		} catch (ex) {
			console.error(ex);
		}
		Workbench._updateTitle(newEditor);
		
		setTimeout(function(){
			// kludge: if there is a visualeditor and it is already populated, resize to make Dijit visualEditor contents resize
			// If editor is still starting up, there is code on completion to do a resize
			// seems necessary due to combination of 100%x100% layouts and extraneous width/height measurements serialized in markup
			if (newEditor && newEditor.visualEditor && newEditor.visualEditor.context && newEditor.visualEditor.context.isActive()) {
				newEditor.visualEditor.context.getTopWidgets().forEach(function (widget) { if (widget.resize) { widget.resize(); } });
			}
			
			this._repositionFocusContainer();
		}.bind(this), 1000);
		
		all(this._showViewPromises).then(function() {
			if(newEditor && newEditor.focus) { 
				newEditor.focus(); 
			}

			//Rearrange palettes based on new editor
			this._rearrangePalettes(newEditor);
			
			//Collapse/expand the left and right-side palettes
			//depending on "expandPalettes" properties
			this._expandCollapsePaletteContainers(newEditor);
		}.bind(this));

		if(!startup) {
			Workbench.saveState = true;
		}
	},

	_rearrangePalettes: function(newEditor) {
		var palettePerspectiveId,
			newEditorRightPaletteExpanded,
			newEditorLeftPaletteExpanded;
		
		//Determine what perspective to get palette info out of based on whether we have an editor or not
		if (newEditor) {
			// First, we will get the metadata for the extension and get its list of 
			// palettes to bring to the top
			var editorExtensions=Runtime.getExtensions("davinci.editor", function (extension){
				return newEditor ? (extension.id === newEditor.editorID) : false;
			});
			if (editorExtensions && editorExtensions.length > 0) {
				var editorExtension = editorExtensions[0];
				palettePerspectiveId = editorExtension.palettePerspective;
			}
			
			//Remember if palettes had been expanded because as we add/remove/select tabs these values will be 
			//altered and we'll want to restore them
			newEditorRightPaletteExpanded = newEditor._rightPaletteExpanded;
			newEditorLeftPaletteExpanded= newEditor._leftPaletteExpanded;
		} else {
			//No editor, so use the initital perspective
			palettePerspectiveId = Runtime.initialPerspective || "davinci.ui.main";
		}
			
		if (palettePerspectiveId) {
			var palettePerspective = Runtime.getExtension("davinci.perspective", palettePerspectiveId);
			if (!palettePerspective) {
				Runtime.handleError(dojo.string.substitute(webContent.perspectiveNotFound,[editorExtension.palettePerspective]));
			}
			var paletteDefs = palettePerspective.views;

			// Loop through palette ids and select appropriate palettes
			dojo.forEach(paletteDefs, function(paletteDef) {
				// Look up the tab for the palette and get its 
				// parent to find the right TabContainer
				var paletteId = paletteDef.viewID;
				var position = paletteDef.position;
				if (position.indexOf("bottom") < 0) {
					position += "-top";
				}
				var tab = dijit.byId(paletteId);
				if (tab) {
					var tabContainer = tab.getParent();
					var desiredTabContainer = mainBody.tabs.perspective[position];
					
					//Move tab
					if (tabContainer != desiredTabContainer) {
						if (tabContainer) {
							//Need to remove from the old tabbed container
							tabContainer.removeChild(tab);
						}
						if (!paletteDef.hidden) {
							desiredTabContainer.addChild(tab);
							tabContainer = desiredTabContainer;
						}
					}

					// Select/hide tab
					if (tabContainer) {
						if (paletteDef.hidden) {
							tabContainer.removeChild(tab);
						} else {
							if (paletteDef.selected) {
								// This flag prevents Workbench.js logic from triggering expand/collapse
								// logic based on selectChild() event
								tabContainer._maqDontExpandCollapse = true;
								tabContainer.selectChild(tab);
								delete tabContainer._maqDontExpandCollapse;
							}
						}
					}
				}
			});
		}
		
		//Restore left/right palette expanded states that were saved earlier
		if (newEditor) {
			if (newEditor.hasOwnProperty("_rightPaletteExpanded")) {
				newEditor._rightPaletteExpanded = newEditorRightPaletteExpanded;
			}
			if (newEditor.hasOwnProperty("_leftPaletteExpanded")) {
				newEditor._leftPaletteExpanded = newEditorLeftPaletteExpanded;
			}
		}
	},
	
	_nearlyCollapsed: function(paletteContainerNode){
		// Check actual width of palette area. If actual width is smaller than the
		// size of the tabs plus a small delta, then treat as if the palettes are collapsed
		var width = dojo.style(paletteContainerNode, 'width');
		if(typeof width == 'string'){
			width = parseInt(width);
		}
		return width < (paletteTabWidth + paletteTabDelta);
	},

	_expandCollapsePaletteContainer: function(tab) {
		if(!tab || !tab.domNode){
			return;
		}
		var paletteContainerNode = davinci.Workbench.findPaletteContainerNode(tab.domNode);
		if(!paletteContainerNode.id){
			return;
		}
		var expanded = paletteContainerNode._maqExpanded;
		var expandToSize; 
		if(this._nearlyCollapsed(paletteContainerNode)){
			expanded = false;
			expandToSize = (paletteCache[paletteContainerNode.id].expandToSize >= (paletteTabWidth + paletteTabDelta)) ?
					paletteCache[paletteContainerNode.id].expandToSize : paletteCache[paletteContainerNode.id].initialExpandToSize;
		}
		if(expanded){
			this.collapsePaletteContainer(paletteContainerNode);
		}else{
			this.expandPaletteContainer(paletteContainerNode, {expandToSize:expandToSize});
		}
	},

	_expandCollapsePaletteContainers: function(newEditor, params) {
		var leftBC = dijit.byId('left_mainBody');
		var rightBC = dijit.byId('right_mainBody');
		if(!newEditor){
			if(leftBC){
				this.collapsePaletteContainer(leftBC.domNode, params);
			}
			if(rightBC){
				this.collapsePaletteContainer(rightBC.domNode, params);
			}			
		}else{
			// First, we will get the metadata for the extension and get its list of 
			// palettes to bring to the top
			var editorExtensions=Runtime.getExtensions("davinci.editor", function (extension){
				return extension.id === newEditor.editorID;
			});
			if (editorExtensions && editorExtensions.length > 0) {
				var expandPalettes = editorExtensions[0].expandPalettes;
				var expand;
				if(leftBC){
					if(newEditor && newEditor.hasOwnProperty("_leftPaletteExpanded")){
						expand = newEditor._leftPaletteExpanded;
					}else{
						expand = (expandPalettes && expandPalettes.indexOf('left')>=0);
					}
					if(expand){
						this.expandPaletteContainer(leftBC.domNode, params);
					}else{
						this.collapsePaletteContainer(leftBC.domNode, params);
					}
				}
				if(rightBC){
					if(newEditor && newEditor.hasOwnProperty("_rightPaletteExpanded")){
						expand = newEditor._rightPaletteExpanded;
					}else{
						expand = (expandPalettes && expandPalettes.indexOf('right')>=0);
					}
					if(expand){
						this.expandPaletteContainer(rightBC.domNode, params);
					}else{
						this.collapsePaletteContainer(rightBC.domNode, params);
					}
				}
			}
			
		}
	},

	_updateTitle: function(currentEditor) {
		var newTitle=Workbench._baseTitle;
		if (currentEditor) {
			newTitle = newTitle + " - ";
			if (currentEditor.isDirty) {
				newTitle=newTitle+"*";
			}
			newTitle=newTitle+currentEditor.fileName;
		}
		dojo.doc.title=newTitle;
	},

	/**
	 * With standard TabContainer setup, this callback is invoked 
	 * whenever an editor tab is closed via user action.
	 * But if we are using the "shadow" approach where there is a shadow
	 * TabContainer that shows tabs for the open files, and a StackContainer
	 * to hold the actual editors, then this callback is invoked indirectly
	 * via a removeChild() call in routine _shadowTabClosed() below.
	 * @param page  The child widget that is being closed.
	 */
	_editorTabClosed: function(page) {
		if(!davinci.Workbench._editorTabClosing[page.id]){
			davinci.Workbench._editorTabClosing[page.id] = true;
			if (page && page.editor && page.editor.fileName) {
				var editorId = page.id;
				var shadowId = editorIdToShadowId(editorId);
				var shadowTabContainer = dijit.byId("davinci_file_tabs");
				var shadowTab = dijit.byId(shadowId);
				var i = Workbench._state.editors.indexOf(page.editor.fileName);
	            if (i != -1) {
	            	Workbench._state.editors.splice(i, 1);
	            }
				Workbench.saveState = true;
				if(!davinci.Workbench._shadowTabClosing[shadowId]){
					shadowTabContainer.removeChild(shadowTab);
					shadowTab.destroyRecursive();
				}
			}
			var editors=dijit.byId("editors_container").getChildren();
			if (!editors.length) {
				Workbench._switchEditor(null);
				this._expandCollapsePaletteContainers(null);
				var editorsStackContainer = dijit.byId('editorsStackContainer');
				var editorsWelcomePage = dijit.byId('editorsWelcomePage');
				if (editorsStackContainer && editorsWelcomePage){
					editorsStackContainer.selectChild(editorsWelcomePage);
				}
				this._hideEditorTopPanes();
			}
			delete davinci.Workbench._editorTabClosing[page.id];
		}
	},

	/**
	 * When using the "shadow" approach where there is a shadow
	 * TabContainer that shows tabs for the open files, and a StackContainer
	 * to hold the actual editors, then this callback is invoked when a user clicks
	 * on the tab of the shadow TabContainer. This routine then calls
	 * removeChild() on the StackContainer to remove to corresponding editor.
	 * @param page  The child widget that is being closed.
	 */
	_shadowTabClosed: function(page) {
		if(!davinci.Workbench._shadowTabClosing[page.id]){
			davinci.Workbench._shadowTabClosing[page.id] = true;
			var shadowId = page.id;
			var editorId = shadowIdToEditorId(shadowId);
			if(!davinci.Workbench._editorTabClosing[editorId]){
				var editorContainer = dijit.byId(editorId);
				var editorsContainer = dijit.byId("editors_container");
				if(editorsContainer && editorContainer){
					editorsContainer.removeChild(editorContainer);
					editorContainer.destroyRecursive();
				}
			}
			delete davinci.Workbench._shadowTabClosing[page.id];
		}
	},

	getActiveProject: function() {
		/* need to check if there is a project in the URL.  if so, it takes precidence
		 * to the workbench setting
		 */
		
		if (!Workbench._state){
			Workbench._state = Runtime.getWorkbenchState();
		}
		var urlProject = dojo.queryToObject(dojo.doc.location.search.substr((dojo.doc.location.search[0] === "?" ? 1 : 0))).project;
		
		if(urlProject){
			Workbench.loadProject(urlProject);
		}
		
		if (Workbench._state.hasOwnProperty("project")) {
			return Workbench._state.project;
		}

		return Workbench._DEFAULT_PROJECT;
	},
	
	setActiveProject: function(project){
		if(!Workbench._state){
			Workbench._state = {};
		}
		Workbench._state.project = project;
		Workbench.saveState = true;
	},
	
	/**
	 * Retrieves a custom property from current workbench state
	 * @param {string} propName  Name of custom property
	 * @return {any} propValue  Any JavaScript value.
	 */
	workbenchStateCustomPropGet: function(propName){
		if(typeof propName == 'string'){
			return Workbench._state[propName];
		}
	},
	
	/**
	 * Assign a custom property to current workbench state and persist new workbench state to server
	 * @param {string} propName  Name of custom property
	 * @param {any} propValue  Any JavaScript value. If undefined, then remove given propName from current workbench state.
	 */
	workbenchStateCustomPropSet: function(propName, propValue){
		if(typeof propName == 'string'){
			if(typeof propValue == 'undefined'){
				delete Workbench._state[propName];
			}else{
				Workbench._state[propName] = propValue;
			}
			Workbench.saveState = true;
		}
	},

	clearWorkbenchState: function() {
		Workbench._state = {};
		return Workbench.updateWorkbenchState();
	},

	updateWorkbenchState: function(){
		delete Workbench.saveState;
		return xhr.put({
			url: "cmd/setWorkbenchState",
			putData: JSON.stringify(Workbench._state),
			handleAs:"text"
		});
	},

	_autoSave: function(){
		var lastSave = Workbench._lastAutoSave;
		var anyErrors = false;
		function saveDirty(editor){
			if (editor.isReadOnly || !editor.isDirty) {
				return;
			}
			
			var modified = editor.lastModifiedTime;
			if (modified && modified > lastSave){
				try {
					editor.save(true);
				}catch(ex){
					console.error("Error while autosaving file:" + ex);
					anyErrors = true;
				}
			}
		}
		if(Workbench.editorTabs){
			dojo.forEach(Workbench.editorTabs.getChildren(), saveDirty);
		}
		if(!anyErrors){
			Workbench._lastAutoSave = Date.now();
		}		              
	},

	setupGlobalKeyboardHandler: function() {
		var actionSets = Runtime.getExtensions('davinci.actionSets');

		dojo.forEach(actionSets, function(actionSet) {
			if (actionSet.id == "davinci.ui.main" || actionSet.id == "davinci.ui.editorActions") {
				dojo.forEach(actionSet.actions, function(action) {
					if (action.keyBinding) {
						Runtime.registerKeyBinding(action.keyBinding, action);
					}
				});
			}
		});
	},
	
	/**
	 * Look for the "palette container node" from node or one of its descendants,
	 * where the palette container node id identified by its
	 * having class 'davinciPaletteContainer'
	 * @param {Element} node  reference node
	 * @returns {Element|undefined}  the palette container node, if found
	 */
	findPaletteContainerNode: function(node){
		var paletteContainerNode;
		var n = node;
		while(n && n.tagName != 'BODY'){
			if(dojo.hasClass(n, 'davinciPaletteContainer')){
				paletteContainerNode = n;
				break;
			}
			n = n.parentNode;
		}
		return paletteContainerNode;
	},
	
	/**
	 * In response to clicking on palette's collapse button,
	 * collapse all palettes within the given palette container node to just show tabs.
	 * @param {Element} node  A descendant node of the palette container node.
	 * 		In practice, the node for the collapse icon (that the user has clicked).
	 * @params {object} params
	 *      params.dontPreserveWidth says to not cache current palette width
	 */
	collapsePaletteContainer: function(node, params){
		var paletteContainerNode = davinci.Workbench.findPaletteContainerNode(node);
		if(paletteContainerNode && paletteContainerNode.id){
			var id = paletteContainerNode.id;
			var paletteContainerNodeWidth = dojo.style(paletteContainerNode, 'width');
			var paletteContainerWidget = dijit.byNode(paletteContainerNode);
			var tablistNodes = dojo.query('[role=tablist]', paletteContainerNode);
			if(paletteContainerWidget && tablistNodes.length > 0){
				var tablistNode = tablistNodes[0];
				var tablistNodeSize = dojo.marginBox(tablistNode);
				var parentWidget = paletteContainerWidget.getParent();
				if(parentWidget && parentWidget.resize && tablistNodeSize && tablistNodeSize.w){
					if(!this._nearlyCollapsed(paletteContainerNode) && (!params || !params.dontPreserveWidth)){
						paletteCache[id].expandToSize = paletteContainerNodeWidth; // Note: just a number, no 'px' at end
					}
					paletteContainerNode.style.width = tablistNodeSize.w + 'px';
					parentWidget.resize();
					paletteContainerWidget._isCollapsed = true;
				}
			}
			dojo.removeClass(paletteContainerNode, 'maqPaletteExpanded');
			paletteContainerNode._maqExpanded = false;
			davinci.Workbench._repositionFocusContainer();
			var currentEditor = Runtime.currentEditor;
			if(currentEditor){
				if(paletteContainerNode.id == 'left_mainBody'){
					currentEditor._leftPaletteExpanded = false;
				}else if(paletteContainerNode.id == 'right_mainBody'){
					currentEditor._rightPaletteExpanded = false;
				}
			}
		}
	},
	
	/**
	 * In response to user clicking on one of the palette tabs,
	 * see if the parent palette container node is collapsed.
	 * If so, expand it.
	 * @param {Element} node  A descendant node of the palette container node.
	 * 		In practice, the node for the collapse icon (that the user has clicked).
	 * @param {object} params  A descendant node of the palette container node.
	 * 		params.expandToSize {number}  Desired width upon expansion
	 */
	expandPaletteContainer: function(node, params){
		var expandToSize = params && params.expandToSize;
		var paletteContainerNode = davinci.Workbench.findPaletteContainerNode(node);
		if(paletteContainerNode && paletteContainerNode.id){
			var id = paletteContainerNode.id;
			var paletteContainerWidget = dijit.byNode(paletteContainerNode);
			if(expandToSize){
				paletteCache[id].expandToSize = expandToSize;
			}
			if(paletteContainerWidget && paletteCache[id].expandToSize){
				var parentWidget = paletteContainerWidget.getParent();
				if(parentWidget && parentWidget.resize){
					paletteContainerNode.style.width = paletteCache[id].expandToSize + 'px';
					parentWidget.resize();
					delete paletteContainerWidget._isCollapsed;
				}
			}
			dojo.addClass(paletteContainerNode, 'maqPaletteExpanded');
			paletteContainerNode._maqExpanded = true;
			davinci.Workbench._repositionFocusContainer();
			var currentEditor = Runtime.currentEditor;
			if(currentEditor){
				if(paletteContainerNode.id == 'left_mainBody'){
					currentEditor._leftPaletteExpanded = true;
				}else if(paletteContainerNode.id == 'right_mainBody'){
					currentEditor._rightPaletteExpanded = true;
				}
			}
		}
	},

	/**
	 * Reposition the focusContainer node to align exactly with the position of editors_container node
	 */
	_repositionFocusContainer: function(){
		var editors_container = dojo.byId('editors_container');
		var focusContainer = dojo.byId('focusContainer');
		if(editors_container && focusContainer){
			var currentEditor = Runtime.currentEditor;
			var box;
			if(currentEditor && currentEditor.getFocusContainerBounds){
				box = currentEditor.getFocusContainerBounds();
			}else{
				box = GeomUtils.getBorderBoxPageCoords(editors_container);
			}
			if(box){
				focusContainer.style.left = box.l + 'px';
				focusContainer.style.top = box.t + 'px';
				focusContainer.style.width = box.w + 'px';
				focusContainer.style.height = box.h + 'px';
				if(currentEditor && currentEditor.getContext){
					var context = currentEditor.getContext();
					if(context && context.updateFocusAll){
						context.updateFocusAll();
					}
				}
			}
		}
	},
	
	_hideShowEditorTopPanes: function(displayPropValue){
		var davinci_app = dijit.byId('davinci_app');
		var davinci_file_tabs = dijit.byId('davinci_file_tabs');
		var davinci_toolbar_pane = dijit.byId('davinci_toolbar_pane');
		davinci_file_tabs.domNode.style.display = displayPropValue;
		davinci_toolbar_pane.domNode.style.display = displayPropValue;
		davinci_app.resize();
	},
	_hideEditorTopPanes: function(){
		this._hideShowEditorTopPanes('none');
	},
	_showEditorTopPanes: function(){
		this._hideShowEditorTopPanes('block');
	},
	
	_removeFocusContainerChildren: function(){
		davinci.Workbench.focusContainer.innerHTML = '';
	},

	_XX_last_member: true	// dummy with no trailing ','
};

var PopupMenu = declare(Menu, {

	menuOpened: function (event) {},
	
	_openMyself: function(event){
		this.menuOpened(event);
		var open;
		try{
			// Create a DIV that will overlay entire app and capture events that might go to interior iframes
			var menuOverlayDiv = document.getElementById('menuOverlayDiv');
			if(!menuOverlayDiv){
				menuOverlayDiv = dojo.create('div', {id:'menuOverlayDiv', style:'left:0px; top:0px; width:100%; height:100%; position:absolute; z-index:10;'}, document.body);
			}
			if(this.adjustPosition){
				var offsetPosition=this.adjustPosition(event);
					open = dijit.popup.open;
					dijit.popup.open = function(args){
						args.x += offsetPosition.x;
						args.y += offsetPosition.y;
						open.call(dijit.popup, args);
					};
			}
			this.onClose = function(){
				var menuOverlayDiv = document.getElementById('menuOverlayDiv');
				if(menuOverlayDiv){
					menuOverlayDiv.parentNode.removeChild(menuOverlayDiv);
				}
			}.bind(this);
			this.inherited(arguments);
		}finally{
			if(open){
				dijit.popup.open = open;
			}
		}
	}
});

// put workbench state upload on a timer to reduce number of requests to the server
window.setInterval(function(){
	if (Workbench.saveState) {
		Workbench.updateWorkbenchState();		
	}
}, 1000);

dojo.setObject("davinci.Workbench", Workbench);
return Workbench;
});

},
'davinci/ve/themeEditor/metadata/CSSThemeProvider':function(){
define(["dojo/_base/declare", "../../utils/pseudoClass"], function(declare, pseudoClass) {

//TODO: Create custom HTML metadata provider similar to CSS

return declare("davinci.ve.themeEditor.metadata.CSSThemeProvider", null, {

	module: "davinci.lib",
	path: "theme/tundra.json", 
	
	constructor: function(resources, theme){
		this._theme = theme;
		this.url = encodeURI(resources[0].getURL());
		this.getWidgets();
	},

	getWidgets: function(){
		if(!this._widgets){
			var style_obj = undefined;
			dojo.xhrGet({
				url: "" + this.url, //dojo.moduleUrl(this.module, this.path),
				handleAs: "json",
				sync: true,
				load: function(result){style_obj = result;}
			});
			this._widgets = style_obj;
			this._createDefaults();
			
		}
		return this._widgets;
	},
	
	_createDefaults: function(){
		var ret = true;
		for (var a in this._widgets){
			var toolkit = this._widgets[a];
			for (var b in toolkit){
				var widget = toolkit[b];
				for (var c in widget.states){
					var state = widget.states[c];
					var selector = this.getStyleSelectors(a+'.'+b, c); // this will create the default selctors if missing
				}
				for (var sw in widget.subwidgets){
					var subwidget = widget.subwidgets[sw];
					for (var c in subwidget.states){
						var state = subwidget.states[c];
						var selector = this.getStyleSelectors(a+'.'+b, c, sw); // this will create the default selctors if missing
					}
				}
			}
		}
		return;
	
	},
	
	getRelativeStyleSelectorsText: function(widgetType, state, subwidget,properties, className){
		var selectors = this.getStyleSelectors(widgetType, state,subwidget);
		var relativeSelectors = [];
		for (s in selectors){
			properties.forEach(function(property){
				var foundProp = false;
				for(var p=0;!foundProp && p<selectors[s].length;p++){
					if(selectors[s][p]==property || selectors[s][p] == '$std_10')
						foundProp=true;
					
				}
				if(foundProp){
					var text = "" + s;
					var classes = text.split(" ");
					text = "";
					classes.forEach(function(c){
						// remove the theme body class ex .claro
						if (c != "."+className) {
							text += " " + c;
						}
					}.bind(this));
					relativeSelectors.push(text.replace(/^\s*/, "").replace(/\s*$/, "")); // trim leading trailing white space
					return;
				}
			}.bind(this));
			
		}
		return relativeSelectors;
		
	},
	
	getStyleSelectors: function(widgetType, state, subwidget){
		//debugger;
		if(!widgetType){
			console.log('metadata:getStyleSelectors no widgetType');
			return;
		}
		if(!state) {
			state = 'Normal';
		}
		var selectors;
		var p = widgetType.split(/[\.\/]/);
		var w = p[0];
		var n = p[p.length-1];
		if(subwidget && (w in this._widgets) && (n in this._widgets[w])){
			var sw = (subwidget.id) ? subwidget.id : subwidget;
			if (!this._widgets[w][n].subwidgets[''+sw].states[''+state]) {
				return null; // not valid state
			}
			selectors = this._widgets[w][n].subwidgets[''+sw].states[''+state].selectors;
			if (!selectors || selectors == '$auto'){
				selectors = this._createDefaultSelectors(''+w+sw,state);
				this._widgets[w][n].subwidgets[''+sw].states[''+state].selectors = selectors;
			}
		}else if( this._widgets && (w in this._widgets) && (n in this._widgets[w])) {
			if (this._widgets[w][n].states[''+state]){ // does widget support this state?
				selectors = this._widgets[w][n].states[''+state].selectors;
				if (!selectors || selectors == '$auto'){
					selectors = this._createDefaultSelectors(''+w+n,state);
					this._widgets[w][n].states[''+state].selectors = selectors;
				}
			}
			
		}else{
			//console.log("metadata:getStyleSelectors metadata not found for " + widgetType + " state: " + state + " subwidget " + subwidget);
		}
		return selectors;
	},
	
	getElementStyleProperties: function (widgetType, state, subwidget){
		if(!widgetType){
			console.log('metadata:getElementStyleProperties no widgetType');
			return;
		}
		if(!state) {
			state = 'Normal';
		}
		var elementProps;
		var p = widgetType.split(/[\.\/]/);
		var w = p[0];
		var n = p[p.length-1];
		if(subwidget && (w in this._widgets) && (n in this._widgets[w])){
			var sw = (subwidget.id) ? subwidget.id : subwidget;
			if (!(this._widgets[w][n].subwidgets[''+sw].states[''+state]) || !(this._widgets[w][n].subwidgets[''+sw].states[''+state].element) || !(this._widgets[w][n].subwidgets[''+sw].states[''+state].element.style)) return null; // not valid 
			elementProps = this._widgets[w][n].subwidgets[''+sw].states[''+state].element.style;
//			if (!elementProps /*|| elementProps == '$auto'*/){
//				//elementProps = this._createDefaultElementProps(''+w+sw,state);
//				this._widgets[w][n].subwidgets[''+sw].states[''+state].selectors = selectors;
//			}
		}else if( this._widgets && (w in this._widgets) && (n in this._widgets[w])) {
			if (this._widgets[w][n].states[''+state] && this._widgets[w][n].states[''+state].element && this._widgets[w][n].states[''+state].element.style){ // does widget support this state?
				elementProps = this._widgets[w][n].states[''+state].element.style;
//				if (!selectors || selectors == '$auto'){
//					selectors = this._createDefaultSelectors(''+w+n,state);
//					this._widgets[w][n].states[''+state].selectors = selectors;
//				}
			}
			
		}else{
			console.log("metadata not found for" + widgetType + " state: " + state + " subwidget " + subwidget);
		}
		return elementProps;
	},
	_createDefaultSelectors: function(widgetName, state){
		var selector;
		if (state == 'Normal'){
			selector = '.'+this._theme.className+' .' + widgetName;
		} else {
			selector = '.'+this._theme.className+' .' + widgetName + state;
		}
		var selectors = {};
		selectors[selector] =  ["$std_10"];
	   return selectors;		
	},
	
	_createDefaultQuery: function(widgetName, state){
		return '.' + widgetName;
	},
	 
    _simulateState: function(q, s, mode, updateWidget){
        var querys = (q instanceof Array) ? q : [q];
        var simulates = (s instanceof Array) ? s : [s];

        for (var i = 0; i < simulates.length; i++){
            var simulate = simulates[i];
            var query = querys[i];
            var index;
            var attribute;
            var attributeValue;
            if ((index = simulate.indexOf(':')) > -1){
                attribute = simulate.substring(index+1);
                simulate = simulate.substring(0, index);
                index = attribute.indexOf('=');
                if(index > -1){
                    attributeValue = attribute.substring(index+1);
                    attribute = attribute.substring(0, index);
                } else {
                    attributeValue =  attribute;
                }
            }
            var nodes = dojo.query(query,updateWidget.domNode);
            var n = nodes[0];
            if(!n){ // might already be at the top node.
                n = updateWidget.domNode;
            }
            try {
                if(mode == 'add'){
                    if(attribute){
                        n.setAttribute(attribute, attributeValue);
                    }
                    if(simulate){
                        dojo.addClass(n,simulate);
                    }
                } else { 
                    if(attribute){
                        n.removeAttribute(attribute);
                    }
                    if (simulate){
                        dojo.removeClass(n,simulate);
                    }
                }
           } catch(e){
        	   console.error('CSSThemeProvider._simulateState invalid simulate in metadata for ' + updateWidget.type + " " + q + ": "  + s);
           }
        }
	},
	
	_updateStyle: function(updateWidget, widgetType, state, mode){
		if (updateWidget.id === 'all') return; // global all widget 
		var init = false;
		if(!state) {
			state = 'Normal';
			init = true;
		}
		if(!this._widgets){
			return null;
		}
		if (!widgetType){
			widgetType = updateWidget.type;
		}
//		if (widgetType == 'davinci.ve.widget.HtmlWidget' || widgetType == 'davinci.ve.helpers.HtmlWidget') {
//			 widgetType = 'html.' + node.localName;
//		 }
		var p = widgetType.split(/[\.\/]/);
		var w = p[0];
		var n = p[p.length-1];
//		var query;
//		var simulate;
		var widget = this._widgets[w][n];
		// some widgets do not start in a normal state. like TabContainer
		if (state === 'Normal' && init == true && mode === 'remove' && this._widgets[w][n].startState){
			state = this._widgets[w][n].startState;
		} 
		if (this._widgets[w][n].states[''+state]){
			var q = this._widgets[w][n].states[''+state].query;
			if (!q || q == '$auto'){
				q = this._createDefaultQuery(w+n, state);
				widget.states[''+state].query = q;
			}

			var s = this._widgets[w][n].states[''+state].simulate;
			if(!s){
				s = ' ';
				var selectors = this.getStyleSelectors(widgetType, state);
				var cssClass = '';
				for (var selector in selectors){
					cssClass = pseudoClass.replace(selector);
					cssClass  = cssClass.replace(/\./g,' ');
					cssClass = cssClass.replace(this._theme.className,'');
					s += ' ' + cssClass;
				}
				if(state != 'Normal'){
						s = w + state + ' ' + s; // add the default state class
				}
			}
			if (state != 'Normal'){ // Normal is the base class do not remove it.
				s += ' ' + pseudoClass.MAQETTA_PSEUDO_CLASS + state; // add the browser Pseudo Class emeulation
			    this._simulateState(q, s, mode, updateWidget);
			}
		}

		for(var sub in widget.subwidgets){
			var subwidget = widget.subwidgets[sub];
			// some widgets do not start in a normal state. like TabContainer
			if (state === 'Normal' && init == true && mode === 'remove' && subwidget.startState){
				state = subwidget.startState;
			} 
			if (subwidget.states[''+state]){ // only add if subwidget has this state
				var q = subwidget.states[''+state].query;
				var s = subwidget.states[''+state].simulate;
				if (!q || q == '$auto'){
					q = this._createDefaultQuery(w+sub, state);
					subwidget.states[''+state].query = q;
				}
				if(!s){
					var selectors = this.getStyleSelectors(widgetType, state, sub);
					var cssClass = '';
					s = ' ';
					for (var selector in selectors){
						cssClass = pseudoClass.replace(selector)
							.replace(/\./g,' ')
							.replace(this._theme.className,'');
						s += ' ' + cssClass;
					}
					if(state != 'Normal'){
							s = w + state + ' ' + s; // add the default state class
						}
				}
				if (state != 'Normal'){ // Normal is the base class do not remove it.
	                this._simulateState(q, s, mode, updateWidget);
	            }
				/*query = q; //push(q);
				simulate = s; //.push(s);
				var nodes = dojo.query(query,updateWidget.domNode);
				var n = nodes[0];
				if(!n){ // might already be at the top node.
					n = updateWidget.domNode;
				}
				if (state != 'Normal'){ // Normal is the base class do not remove it.
					if(mode == 'add'){
						dojo.addClass(n,simulate);
					} else { 
						dojo.removeClass(n,simulate);
					}
				}*/
				
			}
		}

		return;
	},
	
	setStyleValues: function(node, widgetType, state, subwidget){
		this._updateStyle(node, widgetType, state, 'add');
	},
	removeStyleValues: function(node, widgetType, state, subwidget){
		if(state && state != 'Normal'){
			this._updateStyle(node, widgetType, state, 'remove');
		}
		
	}, 
	
	setWidgetStyleValues: function(node, state){
		var widget = davinci.ve.widget.getWidget(node);
		this._updateStyle(node, null, state, 'add');
	},
	removeWidgetStyleValues: function(node, state){
		//if(state && state != 'Normal'){
			this._updateStyle(node, null, state, 'remove');
		//}
		
	}, 
	
	getDomNode: function (node, widgetType, subwidget, state){
		if(!this._widgets){
				return null;
		}
		if(!state){
			state = 'Normal';
		}
			
		var p = widgetType.split(/[\.\/]/);
		var w = p[0];
		var n = p[p.length-1];
		var query;
		try {
			if (subwidget){
				query = this._widgets[w][n].subwidgets[''+subwidget].states[''+state].query;
				if (!query || query == '$auto'){
					query = this._createDefaultQuery(w+subwidget, state);
					this._widgets[w][n].subwidgets[''+subwidget].states[''+state].query = query;
				}
			}else{
				query = this._widgets[w][n].states[''+state].query;
				if (!query || query == '$auto'){
					query = this._createDefaultQuery(w+n, state);
					this._widgets[w][n].states[''+state].query = query;
				}
			}
		} catch (e) {
			console.log(e, 'w=' + w, 'n=' + n);
			return null;
		}
		var q;
		if (query instanceof Array){ 
			// Array so just use the first element for domNode query
			q = query[0];
		} else {
			q = query;
		}
		
		var nodes = dojo.query(q,node);
		var n = nodes[0];
		if(!n){ // might already be at the top node.
			n = node;
		}
		return n;
		
	},
	
	getMetadata: function(widgetType){
		if (!widgetType) {
			return undefined;
		}
		var p = widgetType.split(/[\.\/]/);
		var w = p[0];
		var n = p[p.length-1];
		var s = this._widgets && this._widgets[w] && this._widgets[w][n];
		return s;
	},
	
	getWidgetType: function(widget){
		var widgetType;
		widgetType = widget.type;

//		if (widgetType == 'davinci.ve.widget.HtmlWidget' || widgetType == 'davinci.ve.helpers.HtmlWidget') {
//			 widgetType = 'html.' + node.localName;
//		 }
		var id = widget.id;
		if(id.indexOf('all') === 0){ // this is a  mythical widget used for global change of widgets 
			widgetType = widgetType + '.$' + id; // add this to the end so it will match the key in the metadata
		}
		return widgetType;
	},
	
	
	isPropertyVaildForWidgetRule : function(rule, property, widget, subWidget, state){

		var widgetType = this.getWidgetType(widget);
		var widgetMetaData = this.getMetadata(widgetType);
		if (subWidget) {
			widgetMetaData = widgetMetaData.subwidgets[subWidget];
		}
		if (state) {
			widgetMetaData = widgetMetaData.states[state];
		} else {
			widgetMetaData = widgetMetaData.states['Normal'];
		}
		var selectorText = rule.getSelectorText();
		for (var selector in widgetMetaData.selectors){
			var props = widgetMetaData.selectors[selector];
			//if (containsSelector(rule, selector)){
			if (selectorText == selector){ // match the complete selector
				//console.log('found the selector ' + selectorText);
				for (var i=0; i < props.length; i++){
					var prop = props[i];
					if (prop == '$std_10' || prop == property){
						//console.log('Valid: ' + property + ' for CSSRule ' + selectorText);
						return true;
					}
				}
			}
		}
		//return this.isPropertyRuleValid(rule, property, widgetMetaData);
		return false;
	},
	
	isPropertyRuleValid: function(rule, property, widgetMetaData){
		var selectorText = rule.getSelectorText();
		for (var c in widgetMetaData.states){
			var state = widgetMetaData.states[c];
			for (var selector in state.selectors){
				var props = state.selectors[selector];
				//if (containsSelector(rule, selector)){
				if (selectorText == selector){ // match the complete selector
					//console.log('found the selector ' + selectorText);
					for (var i=0; i < props.length; i++){
						var prop = props[i];
						if (prop == '$std_10' || prop == property){
							//console.log('Valid: ' + property + ' for CSSRule ' + selectorText);
							return true;
						}
					}
				}
			}
		}
		for (var sw in widgetMetaData.subwidgets){
			var subwidget = widgetMetaData.subwidgets[sw];
			for (var c in subwidget.states){
				var state = subwidget.states[c];
				for (var selector in state.selectors){
					var props = state.selectors[selector];
					//if (containsSelector(rule, selector)){
					if (selectorText == selector){ // match the complete selector
						//console.log('found the selector ' + selectorText); 
						for (var i=0; i < props.length; i++){
							var prop = props[i];
							if (prop == '$std_10' || prop == property){
								//console.log('Valid: ' + property + ' for CSSRule ' + selectorText);
								return true;
							}
						}
					}
				}
			}
		}
        return false;
		
		function containsSelector(rule, selectorText){
			for (var i=0;i<rule.selectors.length; i++)
			{
				var selectorName = rule.selectors[i].getText();
				if (selectorName == selectorText)
					return true;
			}
			return false;
		}
		
	},
	
		
	isPropertyValidForRule: function(rule, property){
		var ret = false;
		var selectorText = rule.getSelectorText();
		for (var a in this._widgets){
			var toolkit = this._widgets[a];
			for (var b in toolkit){
				var widget = toolkit[b];
				if(this.isPropertyRuleValid(rule, property, widget)){
					return true;
				}
			}
		}
		console.log('Invalid: ' + property + ' for CSSRule ' + selectorText);
		return ret;
		
	},
	
	getStatesForAllWidgets: function(){
		if (!this._widgets){
			return null;
		}
		states = [];
		for (var a in this._widgets){
			var toolkit = this._widgets[a];
			for (var b in toolkit){
 			  if (b.indexOf('$all') != 0){ // don't inclue the states for the all widgets
				var widget = toolkit[b];
				for (var c in widget.states){
					states[c] = c;
				}
				for (var sw in widget.subwidgets){
					var subwidget = widget.subwidgets[sw];
					for (var c in subwidget.states){
						states[c] = c;
					}
				}
 			  }
			}
		 }
		retStates = [];
		for (var s in states){
			retStates.push(s);
		}
		return retStates.sort();
	},
	
	isStateValid: function(widget, state, subW){
		if (!this._widgets){
			return false;
		}
		if (widget.id === 'all' && state != 'Normal'){
			return false;
		}
		var widgetType = widget.type;
		var widgetMetaData = this.getMetadata(widgetType);
		if (widgetMetaData.states[state] && !subW){
			// it has the state
			return true;
		}
		if (!subW){
			for (var sw in widgetMetaData.subwidgets){
				var subwidget = widgetMetaData.subwidgets[sw];
				if(subwidget.states[state]){
					return true;
				}
			}
		} else {
			var subwidget = widgetMetaData.subwidgets[subW];
			if(subwidget && subwidget.states[state]){
				return true;
			}
		}
		return false;
	}
});

});

},
'davinci/de/resource':function(){
define(["davinci/de/widgets/NewDijit",
        "davinci/Workbench",
        "davinci/workbench/Preferences",
        "system/resource",
        "davinci/de/DijitTemplatedGenerator",
        "davinci/library",
        "davinci/ui/Dialog",
        "davinci/ve/actions/ReplaceAction",
        "dojo/promise/all"
],function(NewDijit, Workbench, Preferences, Resource, DijitTemplatedGenerator, dLibrary, Dialog, ReplaceAction, all){

	// For developer notes on how custom widgets work in Maqetta, see:
	// https://github.com/maqetta/maqetta/wiki/Custom-widgets	
	
	var dt = {
		/* base packages.json metadata */
		WIDGETS_JSON : {version:"1.0", localPath:true, customWidgetSpec:1,
						"categories":{"custom":{name:"Custom widget", description:"Custom widget", widgetClass:"dijit"}}, widgets:[]},
		
		
		createDijiFromNewDialog : function(){
			var projectDialog = new NewDijit({});
			var oldEditor = Workbench.getOpenEditor();
			var oldFileName = oldEditor.fileName;
			var oldResource = Resource.findResource(oldFileName);
			var model = oldEditor.model;
			
			var openEditor = Workbench.getOpenEditor();
    		var context = openEditor.getContext();
    		var selection = context.getSelection();
    		if(!dt.validWidget(selection)){
    			Dialog.showModal("Invalid Selection.  Please select a single container widget to create a new Widget", "Error creating Widget...");
    			return;
    		}
    		
			Workbench.showModal(projectDialog, "Dijit Widget...", {height:60, width: 250}, function(){
		    	if (!projectDialog.cancel) {
		    		var widgetData = projectDialog.attr('value');
		    		dt.createDijit(widgetData, model, oldResource, context, selection).then(function(){
			    		if(widgetData.replaceSelection){
			    			new ReplaceAction().run(context, widgetData.group + "." + widgetData.name);
			    		}

			    		//FIXME: Force a browser refresh. This is the atom bomb approach.
				    	//Reason for doing this is that the custom palette list in widget palette
				    	//and all of the require/packages logic happens during application initialization.
				    	//It might be possible to prevent the reload without too much work, but for now we
				    	//do a browser refresh.
				    	window.location.reload(false);
		    		});
		    	}
				return true;
			});
		},
		
		/* 
		 * returns true if the selection is valid for creating a new widget. only 
		 * support creating widgets from selected container widgets 
		 * 
		 * */
		validWidget : function(selection){
			/*
			 * 
			 * Need to check for dojo containers somehow..?
			 * 
			 */
			if (selection==null || selection.length!=1) return false;
			var widget = selection[0];
			return (widget.acceptsHTMLChildren);
		},
		
		_createNameSpace : function(name, parent){
			var namesplit = name.split(".");
			var base = Workbench.getProject();
			parent = parent || Resource.findResource(base);
			
			if(namesplit.length>1){
				for(var i=0;i<namesplit.length-1;i++){
					var folder = parent.getChildSync(namesplit[i]);
					if(folder!=null){
						parent = folder;
					}else{
						parent = parent.createResource(namesplit[i],true);
					}
				}
				
			}
			return parent;
		},
		
		_createFolder : function(name, parent){
			var namesplit = name.split("/");
			var base = Workbench.getProject();
			parent = parent || Resource.findResource(base);
			
			if(namesplit.length){
				for(var i=0;i<namesplit.length;i++){
					
					if(namesplit[i]==".") continue;
					
					var folder = parent.getChildSync(namesplit[i]);
					if(folder!=null){
						parent = folder;
					}else{
						parent = parent.createResource(namesplit[i],true);
					}
				}
				
			}
			return parent;
		},
		
		createDijit : function(widgetData, model, resource, context, selection){
			var qualifiedWidgetDot = widgetData.name + "." + widgetData.name;
			var qualifiedWidgetSlash = widgetData.name + "/" + widgetData.name;
			
			var base = Workbench.getProject();
			var prefs = Preferences.getPreferences('davinci.ui.ProjectPrefs',base);
			if(!prefs.widgetFolder){
				prefs.widgetFolder = "WebContent/custom";
				Preferences.savePreferences('davinci.ui.ProjectPrefs',base, prefs);
			}
			
			
			var parent = dt._createFolder(prefs.widgetFolder);
			
			var widgetNamespace = dt._createNameSpace(qualifiedWidgetDot, parent);
			/*
			if(namesplit.length>1){
				widgetSingleName = namesplit[namesplit.length-1];
			}
			*/
			var customWidgets = widgetNamespace.getChildSync(widgetData.name + "_widgets.json");
			if(customWidgets==null){
				customWidgets = widgetNamespace.createResource(widgetData.name +"_widgets.json");
			}
			
			/* packages.json metadata */
			var customWidgetsJson = dojo.clone(dt.WIDGETS_JSON);
			customWidgetsJson.name = widgetData.name;
			customWidgetsJson.longName = widgetData.name;
			
			var widgetsObj = {
				name:widgetData.name, 
				description: widgetData.name, 
				type:qualifiedWidgetSlash, 
				category:"custom", 
				iconLocal:true, 
				icon:"app/davinci/img/maqetta.png"
			};
			var topElementModel = selection[0]._srcElement;
			for(var i=0, atts=topElementModel.attributes, len=atts.length; i<len; i++){
				var att = atts[i];
				if(!att.noPersist){
					if(!widgetsObj.properties){
						widgetsObj.properties = {};
					}
					widgetsObj.properties[att.name] = att.value;
				}
			}
			customWidgetsJson.widgets.push(widgetsObj);
			var promises = [customWidgets.setContents(JSON.stringify(customWidgetsJson, undefined, '\t'))];
			var content = new DijitTemplatedGenerator({}).buildSource(model, qualifiedWidgetSlash, widgetData.name, false, context, selection);
			
			for(var type in content){
				switch(type){
					case 'amd':
						break;
					case 'html':
						var html = widgetNamespace.createResource(widgetData.name + ".html");
						promises.push(html.setContents(content.html));
						break;
					case 'js':
						var widgetResource = widgetNamespace.createResource(widgetData.name + ".js");
						promises.push(widgetResource.setContents(content.js));
						break;
					case 'metadata':
						var metaResource = widgetNamespace.createResource(widgetData.name + "_oam.json");
						promises.push(metaResource.setContents(content.metadata));
						dLibrary.addCustomWidgets(base, customWidgets, widgetNamespace.getPath(), customWidgetsJson);
						break;
				}
			}

			return all(promises);
		}
	};

	return dt;
});
},
'davinci/ve/themeEditor/metadata/query':function(){
define(["dojo/_base/declare","davinci/ve/utils/URLRewrite"], function(declare,URLRewrite) {

return declare("davinci.ve.themeEditor.metadata.query", null, {
	
	constructor : function(files,modules){
		this.files = files;
		this.cache = {};
		this.lastLoaded = -1;
		this.modules = modules;
		this.modulePrefix = null;
		this.modulePrefix = ".";
		if(modules){
			for(var i = 0;i<modules.length;i++){
				
				this.modulePrefix += "/" + modules[i];
			}
		}
	},
	getType : function (widget){
		var type = null;
		if(widget.declaredClass){
			type=widget.type;
		}else{ // string
			type = widget;
			if(type.substring(0, 5) == "html."){
				tagName = type.substring(5);
	
			}
		}
		return type;
	},
	_loadNextFile : function (){
		var currentFile = this.files[++this.lastLoaded];
		var _URL = null;
		if(currentFile.getURL){
			_URL = URLRewrite.encodeURI(currentFile.getURL());
		}else{
			_URL = this.modulePrefix + currentFile;
			
		}
		var md = null;
		dojo.xhrGet({
			url: _URL,
			handleAs: "json",
			sync: true,
			load: function(result){md = result;} 
		});
		return md;
	},
	_fullyLoaded : function (){
		return this.files.length <= (this.lastLoaded+1);
		
	},
	_cacheNext : function(){
			var metadata = this._loadNextFile();
			dojo.mixin(this.cache, metadata);
	},
	
	getMetaData : function(type){

		var path = type.split(/[\.\/]/);
			
			/*
			 * (12/1/2010)
			(12:34:43 PM) Bradley Childs: shoudln't we have the full type path in the JSON ?
			(12:35:00 PM) Bradley Childs: there may be a dijit.form2.button
			(12:35:03 PM) Bill Reed: yes, we removed the full path.. layout is the same way
			(12:35:32 PM) Bradley Childs: so we ignore any of the middle parts?
			(12:35:40 PM) Bradley Childs: if its dijit.1.2.3.4.button
			(12:35:41 PM) Bill Reed: yup
			(12:35:48 PM) Bradley Childs: all the parts we care about its dijit and button?
			(12:35:58 PM) Bill Reed: correct
			(12:36:00 PM) Bradley Childs: ok
			(12:36:06 PM) Bradley Childs: is that by design?
			(12:36:17 PM) Bill Reed: yes, Jon
			 * 
			 * 
			 * so we only looking for front and back pieces, ignoring the middle bits.
			 */
			
			var front = path.length>=0 ? path[0] : path;
			var back = path.length>=0 ? path[path.length-1] : path;
			var metadata = this.cache[front] ; 
			if(metadata && metadata[back])
				return metadata[back];
			
			if(!this._fullyLoaded()){
				this._cacheNext();
				return this.getMetaData(type);
			}
			return null;
	}
});

});
},
'dojo/dnd/autoscroll':function(){
define(["../_base/lang", "../sniff", "../_base/window", "../dom-geometry", "../dom-style", "../window"],
	function(lang, has, win, domGeom, domStyle, winUtils){

// module:
//		dojo/dnd/autoscroll

var exports = {
	// summary:
	//		Used by dojo/dnd/Manager to scroll document or internal node when the user
	//		drags near the edge of the viewport or a scrollable node
};
lang.setObject("dojo.dnd.autoscroll", exports);

exports.getViewport = winUtils.getBox;

exports.V_TRIGGER_AUTOSCROLL = 32;
exports.H_TRIGGER_AUTOSCROLL = 32;

exports.V_AUTOSCROLL_VALUE = 16;
exports.H_AUTOSCROLL_VALUE = 16;

// These are set by autoScrollStart().
// Set to default values in case autoScrollStart() isn't called. (back-compat, remove for 2.0)
var viewport,
	doc = win.doc,
	maxScrollTop = Infinity,
	maxScrollLeft = Infinity;

exports.autoScrollStart = function(d){
	// summary:
	//		Called at the start of a drag.
	// d: Document
	//		The document of the node being dragged.

	doc = d;
	viewport = winUtils.getBox(doc);

	// Save height/width of document at start of drag, before it gets distorted by a user dragging an avatar past
	// the document's edge
	var html = win.body(doc).parentNode;
	maxScrollTop = Math.max(html.scrollHeight - viewport.h, 0);
	maxScrollLeft = Math.max(html.scrollWidth - viewport.w, 0);	// usually 0
};

exports.autoScroll = function(e){
	// summary:
	//		a handler for mousemove and touchmove events, which scrolls the window, if
	//		necessary
	// e: Event
	//		mousemove/touchmove event

	// FIXME: needs more docs!
	var v = viewport || winUtils.getBox(doc), // getBox() call for back-compat, in case autoScrollStart() wasn't called
		html = win.body(doc).parentNode,
		dx = 0, dy = 0;
	if(e.clientX < exports.H_TRIGGER_AUTOSCROLL){
		dx = -exports.H_AUTOSCROLL_VALUE;
	}else if(e.clientX > v.w - exports.H_TRIGGER_AUTOSCROLL){
		dx = Math.min(exports.H_AUTOSCROLL_VALUE, maxScrollLeft - html.scrollLeft);	// don't scroll past edge of doc
	}
	if(e.clientY < exports.V_TRIGGER_AUTOSCROLL){
		dy = -exports.V_AUTOSCROLL_VALUE;
	}else if(e.clientY > v.h - exports.V_TRIGGER_AUTOSCROLL){
		dy = Math.min(exports.V_AUTOSCROLL_VALUE, maxScrollTop - html.scrollTop);	// don't scroll past edge of doc
	}
	window.scrollBy(dx, dy);
};

exports._validNodes = {"div": 1, "p": 1, "td": 1};
exports._validOverflow = {"auto": 1, "scroll": 1};

exports.autoScrollNodes = function(e){
	// summary:
	//		a handler for mousemove and touchmove events, which scrolls the first available
	//		Dom element, it falls back to exports.autoScroll()
	// e: Event
	//		mousemove/touchmove event

	// FIXME: needs more docs!

	var b, t, w, h, rx, ry, dx = 0, dy = 0, oldLeft, oldTop;

	for(var n = e.target; n;){
		if(n.nodeType == 1 && (n.tagName.toLowerCase() in exports._validNodes)){
			var s = domStyle.getComputedStyle(n),
				overflow = (s.overflow.toLowerCase() in exports._validOverflow),
				overflowX = (s.overflowX.toLowerCase() in exports._validOverflow),
				overflowY = (s.overflowY.toLowerCase() in exports._validOverflow);
			if(overflow || overflowX || overflowY){
				b = domGeom.getContentBox(n, s);
				t = domGeom.position(n, true);
			}
			// overflow-x
			if(overflow || overflowX){
				w = Math.min(exports.H_TRIGGER_AUTOSCROLL, b.w / 2);
				rx = e.pageX - t.x;
				if(has("webkit") || has("opera")){
					// FIXME: this code should not be here, it should be taken into account
					// either by the event fixing code, or the domGeom.position()
					// FIXME: this code doesn't work on Opera 9.5 Beta
					rx += win.body().scrollLeft;
				}
				dx = 0;
				if(rx > 0 && rx < b.w){
					if(rx < w){
						dx = -w;
					}else if(rx > b.w - w){
						dx = w;
					}
					oldLeft = n.scrollLeft;
					n.scrollLeft = n.scrollLeft + dx;
				}
			}
			// overflow-y
			if(overflow || overflowY){
				//console.log(b.l, b.t, t.x, t.y, n.scrollLeft, n.scrollTop);
				h = Math.min(exports.V_TRIGGER_AUTOSCROLL, b.h / 2);
				ry = e.pageY - t.y;
				if(has("webkit") || has("opera")){
					// FIXME: this code should not be here, it should be taken into account
					// either by the event fixing code, or the domGeom.position()
					// FIXME: this code doesn't work on Opera 9.5 Beta
					ry += win.body().scrollTop;
				}
				dy = 0;
				if(ry > 0 && ry < b.h){
					if(ry < h){
						dy = -h;
					}else if(ry > b.h - h){
						dy = h;
					}
					oldTop = n.scrollTop;
					n.scrollTop  = n.scrollTop  + dy;
				}
			}
			if(dx || dy){ return; }
		}
		try{
			n = n.parentNode;
		}catch(x){
			n = null;
		}
	}
	exports.autoScroll(e);
};

return exports;

});

},
'dijit/form/_RadioButtonMixin':function(){
define([
	"dojo/_base/array", // array.forEach
	"dojo/_base/declare", // declare
	"dojo/dom-attr", // domAttr.set
	"dojo/_base/event", // event.stop
	"dojo/_base/lang", // lang.hitch
	"dojo/query", // query
	"../registry"	// registry.getEnclosingWidget
], function(array, declare, domAttr, event, lang, query, registry){

	// module:
	//		dijit/form/_RadioButtonMixin

	return declare("dijit.form._RadioButtonMixin", null, {
		// summary:
		//		Mixin to provide widget functionality for an HTML radio button

		// type: [private] String
		//		type attribute on `<input>` node.
		//		Users should not change this value.
		type: "radio",

		_getRelatedWidgets: function(){
			// Private function needed to help iterate over all radio buttons in a group.
			var ary = [];
			query("input[type=radio]", this.focusNode.form || this.ownerDocument).forEach( // can't use name= since query doesn't support [] in the name
				lang.hitch(this, function(inputNode){
					if(inputNode.name == this.name && inputNode.form == this.focusNode.form){
						var widget = registry.getEnclosingWidget(inputNode);
						if(widget){
							ary.push(widget);
						}
					}
				})
			);
			return ary;
		},

		_setCheckedAttr: function(/*Boolean*/ value){
			// If I am being checked then have to deselect currently checked radio button
			this.inherited(arguments);
			if(!this._created){ return; }
			if(value){
				array.forEach(this._getRelatedWidgets(), lang.hitch(this, function(widget){
					if(widget != this && widget.checked){
						widget.set('checked', false);
					}
				}));
			}
		},

		_getSubmitValue: function(/*String*/ value){
			return value === null ? "on" : value;
		},

		_onClick: function(/*Event*/ e){
			if(this.checked || this.disabled){ // nothing to do
				event.stop(e);
				return false;
			}
			if(this.readOnly){ // ignored by some browsers so we have to resync the DOM elements with widget values
				event.stop(e);
				array.forEach(this._getRelatedWidgets(), lang.hitch(this, function(widget){
					domAttr.set(this.focusNode || this.domNode, 'checked', widget.checked);
				}));
				return false;
			}
			return this.inherited(arguments);
		}
	});
});

},
'dojo/data/ItemFileWriteStore':function(){
define(["../_base/lang", "../_base/declare", "../_base/array", "../_base/json", "../_base/kernel",
	"./ItemFileReadStore", "../date/stamp"
], function(lang, declare, arrayUtil, jsonUtil, kernel, ItemFileReadStore, dateStamp){

// module:
//		dojo/data/ItemFileWriteStore

return declare("dojo.data.ItemFileWriteStore", ItemFileReadStore, {
	// summary:
	//		TODOC

	constructor: function(/* object */ keywordParameters){
		// keywordParameters:
		//		The structure of the typeMap object is as follows:
		// |	{
		// |		type0: function || object,
		// |		type1: function || object,
		// |		...
		// |		typeN: function || object
		// |	}
		//		Where if it is a function, it is assumed to be an object constructor that takes the
		//		value of _value as the initialization parameters.  It is serialized assuming object.toString()
		//		serialization.  If it is an object, then it is assumed
		//		to be an object of general form:
		// |	{
		// |		type: function, //constructor.
		// |		deserialize:	function(value) //The function that parses the value and constructs the object defined by type appropriately.
		// |		serialize:	function(object) //The function that converts the object back into the proper file format form.
		// |	}

		// ItemFileWriteStore extends ItemFileReadStore to implement these additional dojo.data APIs
		this._features['dojo.data.api.Write'] = true;
		this._features['dojo.data.api.Notification'] = true;

		// For keeping track of changes so that we can implement isDirty and revert
		this._pending = {
			_newItems:{},
			_modifiedItems:{},
			_deletedItems:{}
		};

		if(!this._datatypeMap['Date'].serialize){
			this._datatypeMap['Date'].serialize = function(obj){
				return dateStamp.toISOString(obj, {zulu:true});
			};
		}
		//Disable only if explicitly set to false.
		if(keywordParameters && (keywordParameters.referenceIntegrity === false)){
			this.referenceIntegrity = false;
		}

		// this._saveInProgress is set to true, briefly, from when save() is first called to when it completes
		this._saveInProgress = false;
	},

	referenceIntegrity: true, //Flag that defaultly enabled reference integrity tracking.  This way it can also be disabled pogrammatially or declaratively.

	_assert: function(/* boolean */ condition){
		if(!condition){
			throw new Error("assertion failed in ItemFileWriteStore");
		}
	},

	_getIdentifierAttribute: function(){
		// this._assert((identifierAttribute === Number) || (dojo.isString(identifierAttribute)));
		return this.getFeatures()['dojo.data.api.Identity'];
	},


/* dojo/data/api/Write */

	newItem: function(/* Object? */ keywordArgs, /* Object? */ parentInfo){
		// summary:
		//		See dojo/data/api/Write.newItem()

		this._assert(!this._saveInProgress);

		if(!this._loadFinished){
			// We need to do this here so that we'll be able to find out what
			// identifierAttribute was specified in the data file.
			this._forceLoad();
		}

		if(typeof keywordArgs != "object" && typeof keywordArgs != "undefined"){
			throw new Error("newItem() was passed something other than an object");
		}
		var newIdentity = null;
		var identifierAttribute = this._getIdentifierAttribute();
		if(identifierAttribute === Number){
			newIdentity = this._arrayOfAllItems.length;
		}else{
			newIdentity = keywordArgs[identifierAttribute];
			if(typeof newIdentity === "undefined"){
				throw new Error("newItem() was not passed an identity for the new item");
			}
			if(lang.isArray(newIdentity)){
				throw new Error("newItem() was not passed an single-valued identity");
			}
		}

		// make sure this identity is not already in use by another item, if identifiers were
		// defined in the file.  Otherwise it would be the item count,
		// which should always be unique in this case.
		if(this._itemsByIdentity){
			this._assert(typeof this._itemsByIdentity[newIdentity] === "undefined");
		}
		this._assert(typeof this._pending._newItems[newIdentity] === "undefined");
		this._assert(typeof this._pending._deletedItems[newIdentity] === "undefined");

		var newItem = {};
		newItem[this._storeRefPropName] = this;
		newItem[this._itemNumPropName] = this._arrayOfAllItems.length;
		if(this._itemsByIdentity){
			this._itemsByIdentity[newIdentity] = newItem;
			//We have to set the identifier now, otherwise we can't look it
			//up at calls to setValueorValues in parentInfo handling.
			newItem[identifierAttribute] = [newIdentity];
		}
		this._arrayOfAllItems.push(newItem);

		//We need to construct some data for the onNew call too...
		var pInfo = null;

		// Now we need to check to see where we want to assign this thingm if any.
		if(parentInfo && parentInfo.parent && parentInfo.attribute){
			pInfo = {
				item: parentInfo.parent,
				attribute: parentInfo.attribute,
				oldValue: undefined
			};

			//See if it is multi-valued or not and handle appropriately
			//Generally, all attributes are multi-valued for this store
			//So, we only need to append if there are already values present.
			var values = this.getValues(parentInfo.parent, parentInfo.attribute);
			if(values && values.length > 0){
				var tempValues = values.slice(0, values.length);
				if(values.length === 1){
					pInfo.oldValue = values[0];
				}else{
					pInfo.oldValue = values.slice(0, values.length);
				}
				tempValues.push(newItem);
				this._setValueOrValues(parentInfo.parent, parentInfo.attribute, tempValues, false);
				pInfo.newValue = this.getValues(parentInfo.parent, parentInfo.attribute);
			}else{
				this._setValueOrValues(parentInfo.parent, parentInfo.attribute, newItem, false);
				pInfo.newValue = newItem;
			}
		}else{
			//Toplevel item, add to both top list as well as all list.
			newItem[this._rootItemPropName]=true;
			this._arrayOfTopLevelItems.push(newItem);
		}

		this._pending._newItems[newIdentity] = newItem;

		//Clone over the properties to the new item
		for(var key in keywordArgs){
			if(key === this._storeRefPropName || key === this._itemNumPropName){
				// Bummer, the user is trying to do something like
				// newItem({_S:"foo"}).  Unfortunately, our superclass,
				// ItemFileReadStore, is already using _S in each of our items
				// to hold private info.  To avoid a naming collision, we
				// need to move all our private info to some other property
				// of all the items/objects.  So, we need to iterate over all
				// the items and do something like:
				//	  item.__S = item._S;
				//	  item._S = undefined;
				// But first we have to make sure the new "__S" variable is
				// not in use, which means we have to iterate over all the
				// items checking for that.
				throw new Error("encountered bug in ItemFileWriteStore.newItem");
			}
			var value = keywordArgs[key];
			if(!lang.isArray(value)){
				value = [value];
			}
			newItem[key] = value;
			if(this.referenceIntegrity){
				for(var i = 0; i < value.length; i++){
					var val = value[i];
					if(this.isItem(val)){
						this._addReferenceToMap(val, newItem, key);
					}
				}
			}
		}
		this.onNew(newItem, pInfo); // dojo/data/api/Notification call
		return newItem; // item
	},

	_removeArrayElement: function(/* Array */ array, /* anything */ element){
		var index = arrayUtil.indexOf(array, element);
		if(index != -1){
			array.splice(index, 1);
			return true;
		}
		return false;
	},

	deleteItem: function(/* dojo/data/api/Item */ item){
		// summary:
		//		See dojo/data/api/Write.deleteItem()
		this._assert(!this._saveInProgress);
		this._assertIsItem(item);

		// Remove this item from the _arrayOfAllItems, but leave a null value in place
		// of the item, so as not to change the length of the array, so that in newItem()
		// we can still safely do: newIdentity = this._arrayOfAllItems.length;
		var indexInArrayOfAllItems = item[this._itemNumPropName];
		var identity = this.getIdentity(item);

		//If we have reference integrity on, we need to do reference cleanup for the deleted item
		if(this.referenceIntegrity){
			//First scan all the attributes of this items for references and clean them up in the map
			//As this item is going away, no need to track its references anymore.

			//Get the attributes list before we generate the backup so it
			//doesn't pollute the attributes list.
			var attributes = this.getAttributes(item);

			//Backup the map, we'll have to restore it potentially, in a revert.
			if(item[this._reverseRefMap]){
				item["backup_" + this._reverseRefMap] = lang.clone(item[this._reverseRefMap]);
			}

			//TODO:  This causes a reversion problem.  This list won't be restored on revert since it is
			//attached to the 'value'. item, not ours.  Need to back tese up somehow too.
			//Maybe build a map of the backup of the entries and attach it to the deleted item to be restored
			//later.  Or just record them and call _addReferenceToMap on them in revert.
			arrayUtil.forEach(attributes, function(attribute){
				arrayUtil.forEach(this.getValues(item, attribute), function(value){
					if(this.isItem(value)){
						//We have to back up all the references we had to others so they can be restored on a revert.
						if(!item["backupRefs_" + this._reverseRefMap]){
							item["backupRefs_" + this._reverseRefMap] = [];
						}
						item["backupRefs_" + this._reverseRefMap].push({id: this.getIdentity(value), attr: attribute});
						this._removeReferenceFromMap(value, item, attribute);
					}
				}, this);
			}, this);

			//Next, see if we have references to this item, if we do, we have to clean them up too.
			var references = item[this._reverseRefMap];
			if(references){
				//Look through all the items noted as references to clean them up.
				for(var itemId in references){
					var containingItem = null;
					if(this._itemsByIdentity){
						containingItem = this._itemsByIdentity[itemId];
					}else{
						containingItem = this._arrayOfAllItems[itemId];
					}
					//We have a reference to a containing item, now we have to process the
					//attributes and clear all references to the item being deleted.
					if(containingItem){
						for(var attribute in references[itemId]){
							var oldValues = this.getValues(containingItem, attribute) || [];
							var newValues = arrayUtil.filter(oldValues, function(possibleItem){
								return !(this.isItem(possibleItem) && this.getIdentity(possibleItem) == identity);
							}, this);
							//Remove the note of the reference to the item and set the values on the modified attribute.
							this._removeReferenceFromMap(item, containingItem, attribute);
							if(newValues.length < oldValues.length){
								this._setValueOrValues(containingItem, attribute, newValues, true);
							}
						}
					}
				}
			}
		}

		this._arrayOfAllItems[indexInArrayOfAllItems] = null;

		item[this._storeRefPropName] = null;
		if(this._itemsByIdentity){
			delete this._itemsByIdentity[identity];
		}
		this._pending._deletedItems[identity] = item;

		//Remove from the toplevel items, if necessary...
		if(item[this._rootItemPropName]){
			this._removeArrayElement(this._arrayOfTopLevelItems, item);
		}
		this.onDelete(item); // dojo/data/api/Notification call
		return true;
	},

	setValue: function(/* dojo/data/api/Item */ item, /* attribute-name-string */ attribute, /* almost anything */ value){
		// summary:
		//		See dojo/data/api/Write.set()
		return this._setValueOrValues(item, attribute, value, true); // boolean
	},

	setValues: function(/* dojo/data/api/Item */ item, /* attribute-name-string */ attribute, /* array */ values){
		// summary:
		//		See dojo/data/api/Write.setValues()
		return this._setValueOrValues(item, attribute, values, true); // boolean
	},

	unsetAttribute: function(/* dojo/data/api/Item */ item, /* attribute-name-string */ attribute){
		// summary:
		//		See dojo/data/api/Write.unsetAttribute()
		return this._setValueOrValues(item, attribute, [], true);
	},

	_setValueOrValues: function(/* dojo/data/api/Item */ item, /* attribute-name-string */ attribute, /* anything */ newValueOrValues, /*boolean?*/ callOnSet){
		this._assert(!this._saveInProgress);

		// Check for valid arguments
		this._assertIsItem(item);
		this._assert(lang.isString(attribute));
		this._assert(typeof newValueOrValues !== "undefined");

		// Make sure the user isn't trying to change the item's identity
		var identifierAttribute = this._getIdentifierAttribute();
		if(attribute == identifierAttribute){
			throw new Error("ItemFileWriteStore does not have support for changing the value of an item's identifier.");
		}

		// To implement the Notification API, we need to make a note of what
		// the old attribute value was, so that we can pass that info when
		// we call the onSet method.
		var oldValueOrValues = this._getValueOrValues(item, attribute);

		var identity = this.getIdentity(item);
		if(!this._pending._modifiedItems[identity]){
			// Before we actually change the item, we make a copy of it to
			// record the original state, so that we'll be able to revert if
			// the revert method gets called.  If the item has already been
			// modified then there's no need to do this now, since we already
			// have a record of the original state.
			var copyOfItemState = {};
			for(var key in item){
				if((key === this._storeRefPropName) || (key === this._itemNumPropName) || (key === this._rootItemPropName)){
					copyOfItemState[key] = item[key];
				}else if(key === this._reverseRefMap){
					copyOfItemState[key] = lang.clone(item[key]);
				}else{
					copyOfItemState[key] = item[key].slice(0, item[key].length);
				}
			}
			// Now mark the item as dirty, and save the copy of the original state
			this._pending._modifiedItems[identity] = copyOfItemState;
		}

		// Okay, now we can actually change this attribute on the item
		var success = false;

		if(lang.isArray(newValueOrValues) && newValueOrValues.length === 0){

			// If we were passed an empty array as the value, that counts
			// as "unsetting" the attribute, so we need to remove this
			// attribute from the item.
			success = delete item[attribute];
			newValueOrValues = undefined; // used in the onSet Notification call below

			if(this.referenceIntegrity && oldValueOrValues){
				var oldValues = oldValueOrValues;
				if(!lang.isArray(oldValues)){
					oldValues = [oldValues];
				}
				for(var i = 0; i < oldValues.length; i++){
					var value = oldValues[i];
					if(this.isItem(value)){
						this._removeReferenceFromMap(value, item, attribute);
					}
				}
			}
		}else{
			var newValueArray;
			if(lang.isArray(newValueOrValues)){
				// Unfortunately, it's not safe to just do this:
				//	  newValueArray = newValueOrValues;
				// Instead, we need to copy the array, which slice() does very nicely.
				// This is so that our internal data structure won't
				// get corrupted if the user mucks with the values array *after*
				// calling setValues().
				newValueArray = newValueOrValues.slice(0, newValueOrValues.length);
			}else{
				newValueArray = [newValueOrValues];
			}

			//We need to handle reference integrity if this is on.
			//In the case of set, we need to see if references were added or removed
			//and update the reference tracking map accordingly.
			if(this.referenceIntegrity){
				if(oldValueOrValues){
					var oldValues = oldValueOrValues;
					if(!lang.isArray(oldValues)){
						oldValues = [oldValues];
					}
					//Use an associative map to determine what was added/removed from the list.
					//Should be O(n) performant.  First look at all the old values and make a list of them
					//Then for any item not in the old list, we add it.  If it was already present, we remove it.
					//Then we pass over the map and any references left it it need to be removed (IE, no match in
					//the new values list).
					var map = {};
					arrayUtil.forEach(oldValues, function(possibleItem){
						if(this.isItem(possibleItem)){
							var id = this.getIdentity(possibleItem);
							map[id.toString()] = true;
						}
					}, this);
					arrayUtil.forEach(newValueArray, function(possibleItem){
						if(this.isItem(possibleItem)){
							var id = this.getIdentity(possibleItem);
							if(map[id.toString()]){
								delete map[id.toString()];
							}else{
								this._addReferenceToMap(possibleItem, item, attribute);
							}
						}
					}, this);
					for(var rId in map){
						var removedItem;
						if(this._itemsByIdentity){
							removedItem = this._itemsByIdentity[rId];
						}else{
							removedItem = this._arrayOfAllItems[rId];
						}
						this._removeReferenceFromMap(removedItem, item, attribute);
					}
				}else{
					//Everything is new (no old values) so we have to just
					//insert all the references, if any.
					for(var i = 0; i < newValueArray.length; i++){
						var value = newValueArray[i];
						if(this.isItem(value)){
							this._addReferenceToMap(value, item, attribute);
						}
					}
				}
			}
			item[attribute] = newValueArray;
			success = true;
		}

		// Now we make the dojo/data/api/Notification call
		if(callOnSet){
			this.onSet(item, attribute, oldValueOrValues, newValueOrValues);
		}
		return success; // boolean
	},

	_addReferenceToMap: function(/* dojo/data/api/Item */ refItem, /* dojo/data/api/Item */ parentItem, /* string */ attribute){
		// summary:
		//		Method to add an reference map entry for an item and attribute.
		// description:
		//		Method to add an reference map entry for an item and attribute.
		// refItem:
		//		The item that is referenced.
		// parentItem:
		//		The item that holds the new reference to refItem.
		// attribute:
		//		The attribute on parentItem that contains the new reference.

		var parentId = this.getIdentity(parentItem);
		var references = refItem[this._reverseRefMap];

		if(!references){
			references = refItem[this._reverseRefMap] = {};
		}
		var itemRef = references[parentId];
		if(!itemRef){
			itemRef = references[parentId] = {};
		}
		itemRef[attribute] = true;
	},

	_removeReferenceFromMap: function(/* dojo/data/api/Item */ refItem, /* dojo/data/api/Item */ parentItem, /* string */ attribute){
		// summary:
		//		Method to remove an reference map entry for an item and attribute.
		// description:
		//		Method to remove an reference map entry for an item and attribute.  This will
		//		also perform cleanup on the map such that if there are no more references at all to
		//		the item, its reference object and entry are removed.
		// refItem:
		//		The item that is referenced.
		// parentItem:
		//		The item holding a reference to refItem.
		// attribute:
		//		The attribute on parentItem that contains the reference.
		var identity = this.getIdentity(parentItem);
		var references = refItem[this._reverseRefMap];
		var itemId;
		if(references){
			for(itemId in references){
				if(itemId == identity){
					delete references[itemId][attribute];
					if(this._isEmpty(references[itemId])){
						delete references[itemId];
					}
				}
			}
			if(this._isEmpty(references)){
				delete refItem[this._reverseRefMap];
			}
		}
	},

	_dumpReferenceMap: function(){
		// summary:
		//		Function to dump the reverse reference map of all items in the store for debug purposes.
		// description:
		//		Function to dump the reverse reference map of all items in the store for debug purposes.
		var i;
		for(i = 0; i < this._arrayOfAllItems.length; i++){
			var item = this._arrayOfAllItems[i];
			if(item && item[this._reverseRefMap]){
				console.log("Item: [" + this.getIdentity(item) + "] is referenced by: " + jsonUtil.toJson(item[this._reverseRefMap]));
			}
		}
	},

	_getValueOrValues: function(/* dojo/data/api/Item */ item, /* attribute-name-string */ attribute){
		var valueOrValues = undefined;
		if(this.hasAttribute(item, attribute)){
			var valueArray = this.getValues(item, attribute);
			if(valueArray.length == 1){
				valueOrValues = valueArray[0];
			}else{
				valueOrValues = valueArray;
			}
		}
		return valueOrValues;
	},

	_flatten: function(/* anything */ value){
		if(this.isItem(value)){
			// Given an item, return an serializable object that provides a
			// reference to the item.
			// For example, given kermit:
			//	  var kermit = store.newItem({id:2, name:"Kermit"});
			// we want to return
			//	  {_reference:2}
			return {_reference: this.getIdentity(value)};
		}else{
			if(typeof value === "object"){
				for(var type in this._datatypeMap){
					var typeMap = this._datatypeMap[type];
					if(lang.isObject(typeMap) && !lang.isFunction(typeMap)){
						if(value instanceof typeMap.type){
							if(!typeMap.serialize){
								throw new Error("ItemFileWriteStore:  No serializer defined for type mapping: [" + type + "]");
							}
							return {_type: type, _value: typeMap.serialize(value)};
						}
					}else if(value instanceof typeMap){
						//SImple mapping, therefore, return as a toString serialization.
						return {_type: type, _value: value.toString()};
					}
				}
			}
			return value;
		}
	},

	_getNewFileContentString: function(){
		// summary:
		//		Generate a string that can be saved to a file.
		//		The result should look similar to:
		//		http://trac.dojotoolkit.org/browser/dojo/trunk/tests/data/countries.json
		var serializableStructure = {};

		var identifierAttribute = this._getIdentifierAttribute();
		if(identifierAttribute !== Number){
			serializableStructure.identifier = identifierAttribute;
		}
		if(this._labelAttr){
			serializableStructure.label = this._labelAttr;
		}
		serializableStructure.items = [];
		for(var i = 0; i < this._arrayOfAllItems.length; ++i){
			var item = this._arrayOfAllItems[i];
			if(item !== null){
				var serializableItem = {};
				for(var key in item){
					if(key !== this._storeRefPropName && key !== this._itemNumPropName && key !== this._reverseRefMap && key !== this._rootItemPropName){
						var valueArray = this.getValues(item, key);
						if(valueArray.length == 1){
							serializableItem[key] = this._flatten(valueArray[0]);
						}else{
							var serializableArray = [];
							for(var j = 0; j < valueArray.length; ++j){
								serializableArray.push(this._flatten(valueArray[j]));
								serializableItem[key] = serializableArray;
							}
						}
					}
				}
				serializableStructure.items.push(serializableItem);
			}
		}
		var prettyPrint = true;
		return jsonUtil.toJson(serializableStructure, prettyPrint);
	},

	_isEmpty: function(something){
		// summary:
		//		Function to determine if an array or object has no properties or values.
		// something:
		//		The array or object to examine.
		var empty = true;
		if(lang.isObject(something)){
			var i;
			for(i in something){
				empty = false;
				break;
			}
		}else if(lang.isArray(something)){
			if(something.length > 0){
				empty = false;
			}
		}
		return empty; //boolean
	},

	save: function(/* object */ keywordArgs){
		// summary:
		//		See dojo/data/api/Write.save()
		this._assert(!this._saveInProgress);

		// this._saveInProgress is set to true, briefly, from when save is first called to when it completes
		this._saveInProgress = true;

		var self = this;
		var saveCompleteCallback = function(){
			self._pending = {
				_newItems:{},
				_modifiedItems:{},
				_deletedItems:{}
			};

			self._saveInProgress = false; // must come after this._pending is cleared, but before any callbacks
			if(keywordArgs && keywordArgs.onComplete){
				var scope = keywordArgs.scope || kernel.global;
				keywordArgs.onComplete.call(scope);
			}
		};
		var saveFailedCallback = function(err){
			self._saveInProgress = false;
			if(keywordArgs && keywordArgs.onError){
				var scope = keywordArgs.scope || kernel.global;
				keywordArgs.onError.call(scope, err);
			}
		};

		if(this._saveEverything){
			var newFileContentString = this._getNewFileContentString();
			this._saveEverything(saveCompleteCallback, saveFailedCallback, newFileContentString);
		}
		if(this._saveCustom){
			this._saveCustom(saveCompleteCallback, saveFailedCallback);
		}
		if(!this._saveEverything && !this._saveCustom){
			// Looks like there is no user-defined save-handler function.
			// That's fine, it just means the datastore is acting as a "mock-write"
			// store -- changes get saved in memory but don't get saved to disk.
			saveCompleteCallback();
		}
	},

	revert: function(){
		// summary:
		//		See dojo/data/api/Write.revert()
		this._assert(!this._saveInProgress);

		var identity;
		for(identity in this._pending._modifiedItems){
			// find the original item and the modified item that replaced it
			var copyOfItemState = this._pending._modifiedItems[identity];
			var modifiedItem = null;
			if(this._itemsByIdentity){
				modifiedItem = this._itemsByIdentity[identity];
			}else{
				modifiedItem = this._arrayOfAllItems[identity];
			}

			// Restore the original item into a full-fledged item again, we want to try to
			// keep the same object instance as if we don't it, causes bugs like #9022.
			copyOfItemState[this._storeRefPropName] = this;
			for(var key in modifiedItem){
				delete modifiedItem[key];
			}
			lang.mixin(modifiedItem, copyOfItemState);
		}
		var deletedItem;
		for(identity in this._pending._deletedItems){
			deletedItem = this._pending._deletedItems[identity];
			deletedItem[this._storeRefPropName] = this;
			var index = deletedItem[this._itemNumPropName];

			//Restore the reverse refererence map, if any.
			if(deletedItem["backup_" + this._reverseRefMap]){
				deletedItem[this._reverseRefMap] = deletedItem["backup_" + this._reverseRefMap];
				delete deletedItem["backup_" + this._reverseRefMap];
			}
			this._arrayOfAllItems[index] = deletedItem;
			if(this._itemsByIdentity){
				this._itemsByIdentity[identity] = deletedItem;
			}
			if(deletedItem[this._rootItemPropName]){
				this._arrayOfTopLevelItems.push(deletedItem);
			}
		}
		//We have to pass through it again and restore the reference maps after all the
		//undeletes have occurred.
		for(identity in this._pending._deletedItems){
			deletedItem = this._pending._deletedItems[identity];
			if(deletedItem["backupRefs_" + this._reverseRefMap]){
				arrayUtil.forEach(deletedItem["backupRefs_" + this._reverseRefMap], function(reference){
					var refItem;
					if(this._itemsByIdentity){
						refItem = this._itemsByIdentity[reference.id];
					}else{
						refItem = this._arrayOfAllItems[reference.id];
					}
					this._addReferenceToMap(refItem, deletedItem, reference.attr);
				}, this);
				delete deletedItem["backupRefs_" + this._reverseRefMap];
			}
		}

		for(identity in this._pending._newItems){
			var newItem = this._pending._newItems[identity];
			newItem[this._storeRefPropName] = null;
			// null out the new item, but don't change the array index so
			// so we can keep using _arrayOfAllItems.length.
			this._arrayOfAllItems[newItem[this._itemNumPropName]] = null;
			if(newItem[this._rootItemPropName]){
				this._removeArrayElement(this._arrayOfTopLevelItems, newItem);
			}
			if(this._itemsByIdentity){
				delete this._itemsByIdentity[identity];
			}
		}

		this._pending = {
			_newItems:{},
			_modifiedItems:{},
			_deletedItems:{}
		};
		return true; // boolean
	},

	isDirty: function(/* item? */ item){
		// summary:
		//		See dojo/data/api/Write.isDirty()
		if(item){
			// return true if the item is dirty
			var identity = this.getIdentity(item);
			return new Boolean(this._pending._newItems[identity] ||
				this._pending._modifiedItems[identity] ||
				this._pending._deletedItems[identity]).valueOf(); // boolean
		}else{
			// return true if the store is dirty -- which means return true
			// if there are any new items, dirty items, or modified items
			return !this._isEmpty(this._pending._newItems) ||
				!this._isEmpty(this._pending._modifiedItems) ||
				!this._isEmpty(this._pending._deletedItems); // boolean
		}
	},

/* dojo/data/api/Notification */

	onSet: function(/* dojo/data/api/Item */ item,
					/*attribute-name-string*/ attribute,
					/*object|array*/ oldValue,
					/*object|array*/ newValue){
		// summary:
		//		See dojo/data/api/Notification.onSet()

		// No need to do anything. This method is here just so that the
		// client code can connect observers to it.
	},

	onNew: function(/* dojo/data/api/Item */ newItem, /*object?*/ parentInfo){
		// summary:
		//		See dojo/data/api/Notification.onNew()

		// No need to do anything. This method is here just so that the
		// client code can connect observers to it.
	},

	onDelete: function(/* dojo/data/api/Item */ deletedItem){
		// summary:
		//		See dojo/data/api/Notification.onDelete()

		// No need to do anything. This method is here just so that the
		// client code can connect observers to it.
	},

	close: function(/* object? */ request){
		 // summary:
		 //		Over-ride of base close function of ItemFileReadStore to add in check for store state.
		 // description:
		 //		Over-ride of base close function of ItemFileReadStore to add in check for store state.
		 //		If the store is still dirty (unsaved changes), then an error will be thrown instead of
		 //		clearing the internal state for reload from the url.

		 //Clear if not dirty ... or throw an error
		 if(this.clearOnClose){
			 if(!this.isDirty()){
				 this.inherited(arguments);
			 }else{
				 //Only throw an error if the store was dirty and we were loading from a url (cannot reload from url until state is saved).
				 throw new Error("dojo.data.ItemFileWriteStore: There are unsaved changes present in the store.  Please save or revert the changes before invoking close.");
			 }
		 }
	}
});

});

},
'url:dijit/templates/TreeNode.html':"<div class=\"dijitTreeNode\" role=\"presentation\"\n\t><div data-dojo-attach-point=\"rowNode\" class=\"dijitTreeRow dijitInline\" role=\"presentation\"\n\t\t><div data-dojo-attach-point=\"indentNode\" class=\"dijitInline\"></div\n\t\t><img src=\"${_blankGif}\" alt=\"\" data-dojo-attach-point=\"expandoNode\" class=\"dijitTreeExpando\" role=\"presentation\"\n\t\t/><span data-dojo-attach-point=\"expandoNodeText\" class=\"dijitExpandoText\" role=\"presentation\"\n\t\t></span\n\t\t><span data-dojo-attach-point=\"contentNode\"\n\t\t\tclass=\"dijitTreeContent\" role=\"presentation\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" data-dojo-attach-point=\"iconNode\" class=\"dijitIcon dijitTreeIcon\" role=\"presentation\"\n\t\t\t/><span data-dojo-attach-point=\"labelNode\" class=\"dijitTreeLabel\" role=\"treeitem\" tabindex=\"-1\" aria-selected=\"false\"></span>\n\t\t</span\n\t></div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitTreeContainer\" role=\"presentation\" style=\"display: none;\"></div>\n</div>\n",
'davinci/ve/commands/MoveCommand':function(){
define([
    	"dojo/_base/declare",
    	"dojo/dom-geometry",
    	"davinci/ve/widget",
    	"davinci/ve/States",
    	"davinci/ve/utils/StyleArray",
    	"davinci/ve/utils/GeomUtils"
], function(declare, domGeom, Widget, States, StyleArray, GeomUtils){


return declare("davinci.ve.commands.MoveCommand", null, {
	name: "move",

	constructor: function(widget, left, top, commandForXYDeltas, oldBox, applyToWhichState, disableSnapping){
		this._id = (widget ? widget.id : undefined);
		this._context = widget.getContext();
		
		this._newBox = {l: left , t: top};
		// Because snapping will shift the first widget in a hard-to-predict
		// way, MoveCommand will store the actual shift amount on each command
		// object upon computing the actual final shift amount and then store
		// that amount on the command object. This allows multiple selection moves
		// to work with snapping such that selected widgets 2-N are shifted
		// by the same amount as the first widget.
		this._commandForXYDeltas = commandForXYDeltas;
		
		this._oldBox = oldBox;
		
		// applyToWhichState controls whether style change is attached to Normal or other states
		//   (null|undefined|"undefined"|"Normal") => apply to Normal state
		//   other string => apply to that particular state
		this._applyToStateIndex = (!applyToWhichState || applyToWhichState=='Normal' || applyToWhichState=='undefined')
									? 'undefined' : applyToWhichState;
		
		this._disableSnapping = disableSnapping;
	},

	execute: function(){
		if(!this._id){
			return;
		}
		var widget = Widget.byId(this._id);
		if(!widget || !widget.domNode){
			return;
		}
		var context = this._context;

		if(!this._oldBox){
			var box = widget.getMarginBox();
			this._oldBox = {l: box.l, t: box.t, w:box.w, h:box.h};
		}
		if(!widget.domNode.offsetParent){
			return;
		}
		var offsetParentPageBox = dojo.position(widget.domNode.offsetParent, true);
		if(!offsetParentPageBox){
			return;
		}
		if(this._commandForXYDeltas){
			this._newBox.l = this._oldBox.l + this._commandForXYDeltas._deltaX;
			this._newBox.t = this._oldBox.t + this._commandForXYDeltas._deltaY;
		}else{
			if(!this._disableSnapping && context && context._snapX){
				var w = this._oldBox.w;
				if(context._snapX.typeRefObj=="left"){
					this._newBox.l = context._snapX.x;
				}else if(w && context._snapX.typeRefObj=="right"){
					this._newBox.l = context._snapX.x - w;
				}else if(w && context._snapX.typeRefObj=="center"){
					this._newBox.l = context._snapX.x - w/2;
				}
			}
			if(!this._disableSnapping && context && context._snapY){
				var h = this._oldBox.h;
				if(context._snapY.typeRefObj=="top"){
					this._newBox.t = context._snapY.y;
				}else if(h && context._snapY.typeRefObj=="bottom"){
					this._newBox.t = context._snapY.y - h;
				}else if(h && context._snapY.typeRefObj=="middle"){
					this._newBox.t = context._snapY.y - h/2;
				}
			}
		}
		// These two values might be used by subsequent MoveCommands via this._commandForXYDeltas
		this._deltaX = this._newBox.l - this._oldBox.l;
		this._deltaY = this._newBox.t - this._oldBox.t;

		// this._newBox holds page-relative coordinates.
		// Subtract off offsetParent's borderbox coordinate (in page-relative coords from dojo.position), and
		// subtract off offsetParent's border, because left: and top: are relative to offsetParent's borderbox
		var offsetParentBorderBoxPageCoords = GeomUtils.getBorderBoxPageCoords(widget.domNode.offsetParent);
		var borderExtents = domGeom.getBorderExtents(widget.domNode.offsetParent);
		var newLeft = this._newBox.l - offsetParentBorderBoxPageCoords.l - borderExtents.l;
		var newTop = this._newBox.t - offsetParentBorderBoxPageCoords.t - borderExtents.t;
		var newStyleArray = [{left:newLeft+'px'},{top:newTop+'px'}] ;
        var styleValuesAllStates = widget.getStyleValuesAllStates();
		this._oldStyleValuesAllStates = dojo.clone(styleValuesAllStates);
		if(this._oldBox){
			var oldLeft = this._oldBox.l - offsetParentBorderBoxPageCoords.l - borderExtents.l;
			var oldTop = this._oldBox.t - offsetParentBorderBoxPageCoords.t - borderExtents.t;
			this._oldStyleValuesAllStates[this._applyToStateIndex] = 
					StyleArray.mergeStyleArrays(this._oldStyleValuesAllStates[this._applyToStateIndex], 
								[{left:oldLeft+'px'}, {top:oldTop+'px'}]);
		}
		if(styleValuesAllStates[this._applyToStateIndex]){
			styleValuesAllStates[this._applyToStateIndex] = StyleArray.mergeStyleArrays(styleValuesAllStates[this._applyToStateIndex], newStyleArray);
		}else{
			styleValuesAllStates[this._applyToStateIndex] = newStyleArray;
		}
		widget.setStyleValuesAllStates(styleValuesAllStates);
		var currentStatesList = States.getStatesListCurrent(widget.domNode);
		var styleValuesCanvas = StyleArray.mergeStyleArrays([], styleValuesAllStates['undefined']);
		for(var i=0; i<currentStatesList.length; i++){
			if(styleValuesAllStates[currentStatesList[i]]){
				styleValuesCanvas = StyleArray.mergeStyleArrays(styleValuesCanvas, styleValuesAllStates[currentStatesList[i]]);
			}
		}
		widget.setStyleValuesCanvas(styleValuesCanvas);
		widget.setStyleValuesModel(styleValuesAllStates['undefined']);
		widget.refresh();

		// Recompute styling properties in case we aren't in Normal state
		States.resetState(widget.domNode);
		
		//FIXME: Various widget changed events (/davinci/ui/widget*Changed) need to be cleaned up.
		// I defined yet another one here (widgetPropertiesChanged) just before Preview3
		// rather than re-use or alter one of the existing widget*Changed events just before
		// the Preview 3 release to minimize risk of bad side effects, with idea we would clean up later.
		// For time being, I made payload compatible with /davinci/ui/widgetSelectionChanged. 
		// Double array is necessary because dojo.publish strips out the outer array.
		dojo.publish("/davinci/ui/widgetPropertiesChanged",[[widget]]);
	},

	undo: function(){
		if(!this._id){
			return;
		}
		var widget = Widget.byId(this._id);
		if(!widget){
			return;
		}

		var styleValuesAllStates = this._oldStyleValuesAllStates;
		var currentStateIndex = this._applyToStateIndex;
		widget.setStyleValuesAllStates(styleValuesAllStates);
		var styleValuesCanvas = StyleArray.mergeStyleArrays(styleValuesAllStates['undefined'], styleValuesAllStates[currentStateIndex]);
		widget.setStyleValuesCanvas(styleValuesCanvas);
		widget.setStyleValuesModel(this._oldStyleValuesAllStates['undefined']);
		
		widget.refresh();
		
		// Recompute styling properties in case we aren't in Normal state
		davinci.ve.states.resetState(widget.domNode);
		
		dojo.publish("/davinci/ui/widgetPropertiesChanged",[[widget]]);
	}
});
});

},
'dojo/dnd/TimedMoveable':function(){
define(["../_base/declare", "./Moveable" /*=====, "./Mover" =====*/], function(declare, Moveable /*=====, Mover =====*/){
	// module:
	//		dojo/dnd/TimedMoveable

	/*=====
	var __TimedMoveableArgs = declare([Moveable.__MoveableArgs], {
		// timeout: Number
		//		delay move by this number of ms,
		//		accumulating position changes during the timeout
		timeout: 0
	});
	=====*/

	// precalculate long expressions
	var oldOnMove = Moveable.prototype.onMove;

	return declare("dojo.dnd.TimedMoveable", Moveable, {
		// summary:
		//		A specialized version of Moveable to support an FPS throttling.
		//		This class puts an upper restriction on FPS, which may reduce
		//		the CPU load. The additional parameter "timeout" regulates
		//		the delay before actually moving the moveable object.

		// object attributes (for markup)
		timeout: 40,	// in ms, 40ms corresponds to 25 fps

		constructor: function(node, params){
			// summary:
			//		an object that makes a node moveable with a timer
			// node: Node||String
			//		a node (or node's id) to be moved
			// params: __TimedMoveableArgs
			//		object with additional parameters.

			// sanitize parameters
			if(!params){ params = {}; }
			if(params.timeout && typeof params.timeout == "number" && params.timeout >= 0){
				this.timeout = params.timeout;
			}
		},

		onMoveStop: function(/*Mover*/ mover){
			if(mover._timer){
				// stop timer
				clearTimeout(mover._timer);
				// reflect the last received position
				oldOnMove.call(this, mover, mover._leftTop);
			}
			Moveable.prototype.onMoveStop.apply(this, arguments);
		},
		onMove: function(/*Mover*/ mover, /*Object*/ leftTop){
			mover._leftTop = leftTop;
			if(!mover._timer){
				var _t = this;	// to avoid using dojo.hitch()
				mover._timer = setTimeout(function(){
					// we don't have any pending requests
					mover._timer = null;
					// reflect the last received position
					oldOnMove.call(_t, mover, mover._leftTop);
				}, this.timeout);
			}
		}
	});
});

},
'davinci/ve/themeEditor/themeEditor.plugin':function(){
define([
	'require'
//	'../../Workbench'
], function(require) {

return {
	id: "davinci.themeEdit", 
	"davinci.perspective": {
		id:"themeEdit",
		title:"Theme Editor",
		views: [
			{
                viewID: "davinci.ve.Palette",
                position: "left",
                hidden: true
            },
            {
                viewID: "davinci.ui.outline",
                position: "left",
                hidden: true
            },
            {
                viewID: "davinci.ve.style",
                position: "right"
            },
            {
                viewID: "davinci.ui.comment",
                position: "right",
                hidden: true
            },
            {
                viewID: "davinci.ve.states",
                position: "right-bottom",
                selected: true
            },
            {
                viewID: "davinci.ui.navigator",
                position: "left-bottom",
                selected: true
            },
            {
                viewID: "davinci.review.reviewNavigator",
                position: "left"
            }
		]
	},
	"davinci.editor": {
		id:"ThemeEditor",
		name:"Theme Editor",
		//extensions : ["css", "theme"],
		extensions : "theme",
		defaultContent : "./defaultContent.css",
		isDefault : true,
		//TODO implement		 icon : "",
		editorClass: "davinci/ve/themeEditor/ThemeEditor",
		palettePerspective: "davinci.themeEdit.themeEdit",
        expandPalettes: ["right"]
	},
	"davinci.editorActions": {
		editorContribution: {
			targetID: "davinci.ve.ThemeEditor",
			actions: [
				{
                	id: "undo",
                    //iconClass: 'undoIcon',
                    action: "davinci/actions/UndoAction",
                    label: "Undo",
                    className: "maqLabelButton",
                    showLabel: true,
                    toolbarPath: "undoredo",
                    keyBinding: {accel: true, charOrCode: "z"}
                },
                {
                    id: "redo",
                    //iconClass: 'redoIcon',
                    action: "davinci/actions/RedoAction",
                    className: "maqLabelButton",
                    showLabel: true,
                    label: "Redo",
                    toolbarPath: "undoredo",
                    keyBinding: {accel: true, shift: true, charOrCode: "z"}
                },
                {
                    id: "save",
                    className: "maqLabelButton",
                    showLabel: true,
                    label: "Save",
                    toolbarPath: "save",
					run: function() {
						require('../../Workbench').getOpenEditor().save();
					},
					isEnabled: function(context) {
						return require('../../Workbench').getOpenEditor();
					}
				}
	/*,
					{
						id: "saveas",
						iconClass: 'saveAsIcon',
						run: function() {
							require("../../ui/Resource").saveAs();
						},
						isEnabled : function(context){
							var isEnabled =  davinci.Workbench.getOpenEditor();
							return isEnabled;
							
						},
						label: "Save As",
						toolbarPath: "save"
					}*/
			]
		}
	}
};

});
},
'davinci/ve/input/SmartInput':function(){
define([
	"dojo/_base/declare",
	"dojo/dom-geometry",
	"davinci/ve/commands/ModifyRichTextCommand",
	"dijit/layout/ContentPane",
	"dijit/form/SimpleTextarea",
	"dijit/form/TextBox",
	"dojox/html/entities",
	"dojox/html/ellipsis",
	"dojox/layout/ResizeHandle",
	"dojo/i18n!davinci/ve/nls/ve",
	"dojo/i18n!dijit/nls/common"
], function(declare, domGeometry, ModifyRichTextCommand, ContentPane, SimpleTextarea, TextBox, entities, ellipsis, ResizeHandle, veNls, commonNls){

	// temporary workaround for nls.  the i18n dependencies aren't loading properly
//	veNls = dojo.i18n.getLocalization("davinci.ve","ve");
//	commonNls = dojo.i18n.getLocalization("dijit","common");

return declare("davinci.ve.input.SmartInput", null, {

	property: null,
	_X_MOVE_RANGE: 10,
	_Y_MOVE_RANGE: 10,
	_POINTER_TOP_OFFSET: -13,
	
	multiLine: "false",
	//supportsHTML: "false",
	//helpText:  'If you use any markup characters (&lt;,&gt;,&amp;), you need to specify whether the text represents literal (plain) text or HTML markup that should be parsed (using an innerHTML assignment).',
	
	displayOnCreate: "true",
	_connection: [],
	
	getHelpText: function(){
		if (this.helpText) {
			return this.helpText;
		}
		if (this.isHtmlSupported()){
			return veNls.smartInputHelp1;
		} 
		return veNls.smartInputHelp2;
		
	},
	
	isHtmlSupported: function(){
		if (!this.supportsHTML){
			if ( this._widget.type.match("^html")=='html') { // default for html widgets is html is supported
				this.supportsHTML = "true";
			} else {
				this.supportsHTML = "false";
			}
		}
		
		if (typeof(this.supportsHTML) === 'boolean'){
			return this.supportsHTML;
		}
		
		if (this.supportsHTML=== 'true'){
			return true;
		} else {
			return false;
		}
	
	},
	
	parse: function(input) {
		return input;
	},

	parseItems: function(input) {
		if (this.trim) input = dojo.trim(input);
		var items;
		if (input.match(/[^\\][\r\n]/)) {
			items = this.parseItemsInRows(input);
		} else {
			items = this.parseItemsInColumns(input);
		}
		return items;
	},
	
	parseItemsInRows: function(input) {
		var items = this.splitRows(input);

		//TODO: try dojo.map
		var length = items.length;
		for (var i = 0; i < length; i++) {
			var item = items[i];
			item = this.parseItem(item);
			items[i] = item;
		}
		return items;
	},
	
	parseItemsInColumns: function(input) {
		var items = this.splitColumns(input);
		
		//TODO: try dojo.map
		var length = items.length;
		for (var i = 0; i < length; i++) {
			var item = items[i];
			item = this.parseItem(item);
			items[i] = item;
		}
		return items;
	},
	
	parseGrid: function(input) {
		var rows = this.splitRows(input);
		
		var numRows = rows.length;
		for (var i = 0; i < numRows; i++) {
			var row = rows[i];
			var items = this.parseItemsInColumns(row);
			rows[i] = items;
		}
		return rows;		
	},

	parseItem: function (item) {
		var regex=/^([-~!>|(*)[+\]]*) ?(.*)$/;
		var specialChars=null;
		var text = item;
		
		var result=item.match(regex);
		if (result) {
			specialChars=result[1];
			text=result[2];
		}
		
		var indent=0;
		var disabled=false;
		var selected=false;
		var closednode=false;
		
		if (specialChars) {
			for (var i = 0; i < specialChars.length; i++){
				var c = specialChars[i];
				switch(c) {
					case '-':
					case '~':
					case '!':
						disabled = true;
						break;
					case '>':
						indent++;
						break;
					case '*':
					case '+':
						selected = true;
						break;
					default:
				}
			}
		}
		
		var parsedItem = {original:item, specialChars:specialChars, text:text, indent:indent, disabled:disabled, selected:selected};
		return parsedItem;
	},

	splitRows: function (text) {
		var split = [];
		var i;
		var line = "";
		var escaped = false;
		for(i = 0; i < text.length; i++){
			var c = text.charAt(i);
			switch(c){
				case '\\':
					if (escaped) {
						line += c;
					}
					escaped = !escaped;
					break;
				case 'r':
					if (escaped) {
						line += '\r';
						escaped = false;
					} else {
						line += c;
					}
					break;
				case 'n':
					if (escaped) {
						line += '\n';
						escaped = false;
					} else {
						line += c;
					}
					break;
				case '\r':
				case '\n':
					if (escaped) {
						line += c;
						escaped = false;
					} else {
						if (this.trim) line = dojo.trim(line);
						split.push(line);
						line = "";
					}
					break;
				default:
					line += c;
					escaped = false;
			}
		}
		if (line) {
			if (this.trim) line = dojo.trim(line);
			split.push(line);
		}
		return split;
	},
	
	splitColumns: function (text) {
		var split = [];
		var i;
		var line = "";
		var escaped = false;
		for(i = 0; i < text.length; i++){
			var c = text.charAt(i);
			switch(c){
				case '\\':
					if (escaped) {
						line += c;
					}
					escaped = !escaped;
					break;
				case 'r':
					if (escaped) {
						line += '\r';
						escaped = false;
					} else {
						line += c;
					}
					break;
				case 'n':
					if (escaped) {
						line += '\n';
						escaped = false;
					} else {
						line += c;
					}
					break;
				case ',':
					if (escaped) {
						line += c;
						escaped = false;
					} else {
						if (this.trim) line = dojo.trim(line);
						split.push(line);
						line = "";
					}
					break;
				default:
					line += c;
					escaped = false;
			}
		}
		if (line) {
			if (this.trim) line = dojo.trim(line);
			split.push(line);
		}
		return split;
	},
	
	serializeItems: function(items) {
		var result = this.format == "columns" ? this.serializeColumns(items) : this.serializeRows(items);
		return result;
	},
	
	serializeColumns: function(items) {
		for (var i = 0; i < items.length; i++) {
			var item = items[i];
			item = item.replace(/\\/g, "\\\\");
			items[i] = item.replace(/,/g, "\\,");
		}
		var result = items.join(", ");
		return result;
	},
	
	serializeRows: function(items) {
		for (var i = 0; i < items.length; i++) {
			var item = items[i];
			item = item.replace(/\\/g, "\\\\");
			items[i] = item.replace(/\n/g, "\\\n");
		}
		var result = items.join("\n");
		return result;
	},
	
	inlineEditActive: function() {
		if(this._inline && this._inline.style.display != "none" && this._inline.eb){
			return true;
		}else{
			return false;
		}
	},
	
	show: function(widgetId) {
		this._widget = davinci.ve.widget.byId(widgetId);
		
		if (!this._inline) {
			this._createInline();

		}


		var updateEditBoxValue = dojo.hitch(this, function(value){
			this._inline.style.display = "block";
			this.setFormat(value);
			var customMap = [
			                  ["\u0026","amp"], 
			                  ["\u0022","quot"],
			                  ["\u003C","lt"], 
			                  ["\u003E","gt"]/*,
			                  ["\u00A0","nbsp"]*/
		                     ]; 
			value = entities.decode(value, customMap);
			this._inline.eb.set('value', String(value));
			this.updateFormats();
			this.help(false);  // first time, don't display help but resize as needed
			dijit.selectInputText(this._inline.eb.textbox);
			this.updateSimStyle();
			this._inline.eb.textbox.focus();
		});

		var node = this._node(this._widget);
		
		var property = this.property;
		var djprop = (property==="maq_innerText") ? "innerHTML" : property;
		var value;
		if (property) {
			if (node) {
				value = dojo.attr(node, djprop);
			} else if (djprop === "innerHTML" || djprop == "textContent"){
				value = this._widget._srcElement.getElementText(this._context); // wdr
				// Collapse all white space before showing content
				value = value.replace(/\s+/g,' ');

			}else {
				value = this._widget.attr(property);
			}
		}
		
		if (this.serialize) {
			this.serialize(node || this._widget, updateEditBoxValue, value);
		}
		else if (property) {
			updateEditBoxValue(value);
		}
	},
		
	_createInline: function(){

		
		if (this.multiLine && this.multiLine != "false"){
			this._loading(115, 200 /*, 'auto', 'auto'*/);
			var t = this._getTemplate();
			this._inline.set("content",t);
		}else {
			this._loading(85, 200);
			var t = this._getTemplate();
			this._inline.set("content",t);
		}

		this._inline.eb = dijit.byId("davinciIleb");
		this._connection.push(dojo.connect(this._inline.eb, "onMouseDown", this, "stopEvent"));
		this._connection.push(dojo.connect(this._inline.eb, "onKeyDown", this, "stopEvent_Intercept_Enter"));
		this._connection.push(dojo.connect(this._inline.eb, "onKeyUp", this, "handleEvent"));
		if (this.multiLine == "true"){                                  
/*FIXME: TO DIRECT TO PROPS PALETTE, NEED TO DISABLE */
			this._connection.push(dojo.connect(this._inline.eb, "onBlur", this, "onBlur"));
/*ENDFIXME*/
			this._connectSimDiv();

		}

		
		var text = this._widget._srcElement.getElementText(this._context); // just the inside text
		this._inline.eb.setValue(text);
		this._loadingDiv.style.backgroundImage = 'none'; // turn off spinner
		this._inline._setStyleAttr({display: "block"});
		this._connectHelpDiv();
		this._connectResizeHandle();
		/* 
		 * dijit/focus._onBlurNode is setting a setTimeout to deal with OnBlur events.
		 * 
		   // if the blur event isn't followed by a focus event then mark all widgets as inactive.
			if(this._clearActiveWidgetsTimer){
				clearTimeout(this._clearActiveWidgetsTimer);
			}
			this._clearActiveWidgetsTimer = setTimeout(lang.hitch(this, function(){
				delete this._clearActiveWidgetsTimer;
				this._setStack([]);
				this.prevNode = null;
			}), 100);
          * 
          *  SmartInput is setting the focus on the smart input widget box so when the dijit.focus
          *  setTimeout fires the _setStack changes the focus, fire our onBlur closing the edit box.
          *  This only seems to be an issue for SackContainerInput and mostly for Accordion.
          *  So I added the timeout below to wait until after the diji.focus has fired.
          *  FIXME: There must be a better solution than this!
		 */
		
		window.setTimeout(function(){
			if(this._inline && this._inline.eb && this._inline.eb.textbox){
				this._inline.eb.textbox.focus();
			}
/*FIXME: DISABLING FOR NOW */
			this._connection.push(dojo.connect(this._inline, "onBlur", this, "onOk")); //comment out for debug
/*ENDFIXME*/
		}.bind(this), 500);
		
		this.resize(null);

	
	},
	
	_connectHelpDiv: function(){
		var help = dojo.byId('davinci.ve.input.SmartInput_img_help');
		this._connection.push(dojo.connect(help, "onclick", this, "toggleHelp"));
		// since the button is a submit button, we need to listen to _onSubmit as it is expecting a form widget
		this._connection.push(dojo.connect(dijit.byId('davinci.ve.input.SmartInput_ok'), "_onSubmit", this, "onOk")); // same effect ad click away..
		this._connection.push(dojo.connect(dijit.byId('davinci.ve.input.SmartInput_cancel'), "onClick", this, "onCancel")); // same effect ad click away..
	},
	
	_findSmartInputContainer: function(frameNode){
/*FIXME: With new design, put SmartInput onto BODY*/
		return document.body;
/*FIXME: TO DIRECT TO PROPS PALETTE, NEED TO DISABLE*/
		var smartInputContainer = frameNode.parentNode;
		while(!dojo.hasClass(smartInputContainer,'dijitContentPane')){
			smartInputContainer = smartInputContainer.parentNode;
		}
		return smartInputContainer;
/*ENDFIXME*/
/*FIXME: TO DIRECT TO PROPS PALETTE, NEED TO ENABLE
		return document.querySelector('.primaryPropertiesContainer') || document.body;
*/
	},
	
	_loading: function(height, width /*, styleHeight, styleWidth*/){

		var iframeNode = this._widget._edit_context.frameNode;
		var doc = iframeNode.ownerDocument;
		var loading = doc.createElement("div");
		var smartInputContainer = this._findSmartInputContainer(iframeNode);
		if(!smartInputContainer){
		//loading.innerHTML='<table><tr><td>'+langObj.loading+'</td></tr></table>';
			return;
		}
		smartInputContainer.appendChild(loading);
		this._loadingDiv = loading;
/*FIXME: TO DIRECT TO PROPS PALETTE, NEED TO DISABLE*/
		dojo.addClass(loading,'smartInputLoading');
/*ENDFIXME*/
		var inline= doc.createElement("div");
		inline.id = 'ieb';
/*FIXME: TO DIRECT TO PROPS PALETTE, NEED TO DISABLE*/
		dojo.addClass(inline,'inlineEdit dijitTooltipContainer');
/*ENDFIXME*/
		var inlinePointer = doc.createElement("div");
		inlinePointer.id = 'iebPointer';
		//dojo.addClass(inlinePointer,'inlineEditConnectorBelow');
		this._inline = inline;
		smartInputContainer.appendChild(inline);
		smartInputContainer.appendChild(inlinePointer);
/*FIXME: TO DIRECT TO PROPS PALETTE, NEED TO DISABLE*/
		var m2 = new dojo.dnd.Moveable("ieb");
		this._connection.push(dojo.connect(m2, "onMoveStart", this, "onMoveStart")); 
		this._connection.push(dojo.connect(m2, "onMoveStop", this, "onMoveStop")); 
/*ENDFIXME*/

		var pFloatingPane = new ContentPane({}, inline);
		
		this._inline = pFloatingPane;

		// lets position the coverup
		var veContentArea = dijit.byId("editorsStackContainer").domNode; 
		var p = domGeometry.position(veContentArea);
		this._loadingDiv.style.position = "absolute";
		this._loadingDiv.style.left = p.x+"px";
		this._loadingDiv.style.top = p.y+"px";
		this._loadingDiv.style.width = p.w+"px";
		this._loadingDiv.style.height = p.h+"px";

		var box = this._widget.getMarginBox();
		var iframe_box = dojo.position(iframeNode);
		var contentPane_box = dojo.position(smartInputContainer);
		// Take into account iframe shifting due to mobile silhouettes
		// The extra -1 needed to avoid extra pixel shift, probably for a border
		var silhouette_shift_x = (iframe_box.x - contentPane_box.x) + smartInputContainer.scrollLeft - 1;
		var silhouette_shift_y = (iframe_box.y - contentPane_box.y) + smartInputContainer.scrollTop - 1;
		var clientHeight = smartInputContainer.clientHeight;
		var clientWidth = smartInputContainer.clientWidth;
        // find the correct placement of box  based on client viewable area
		var yOffset = 26;
		var top = yOffset;
		var pointerLocation = 0;
		if ((box.y + height + yOffset) < clientHeight){
			top = box.y /*box.t*/  +  yOffset;
			dojo.addClass(inlinePointer,'inlineEditConnectorBelow');
		}else if((box.y - height /*- yOffset*/) > 0){
			top = box.y - height /*- yOffset /*box.t*/ ;
			//dojo.addClass(inlinePointer,'inlineEditConnectorAbove');
			pointerLocation = height + 12;
		} else {
			top = 0 /*box.t*/  + yOffset ;
		}
		var left = '0';
;
		if ((box.x + width + 20) < clientWidth){
			left = box.x /*box.t*/  ;
		}else if((box.x + width) > clientWidth){
			var t = box.x - width + box.w /*20*/ /*box.t*/;
			
			if (t < 0){
				t = 0;
			}
			left = t ;
		} 
		left += silhouette_shift_x;
		top += silhouette_shift_y;
		
		this._inline._setStyleAttr({display: "block", /*backgroundColor: "red",*/ top: top + 'px', left: left + 'px',  padding:"1px", overflow: "hidden", backgroundImage: "none"}); // padding needed to keep scroll bars off
		this._startTop = top;
		this._startLeft = left;
		dojo.style(inlinePointer, 'left', box.x + 20 + silhouette_shift_x + 'px');
		//dojo.style(inlinePointer, 'left', left + 20 + pointerLocation +  'px');
		
		dojo.style(inlinePointer, 'top', top + pointerLocation + this._POINTER_TOP_OFFSET  + 'px');
				

	},
	
	handleEvent: function(event){
		switch (event.keyCode) {
			case 13: // enter
				var multiLine = this.multiLine;

				if (!multiLine || multiLine == "false" || this._lastKeyCode == 13 || event.ctrlKey) {
					this.onOk();
				} else if (event.which == dojo.keys.ENTER && event.ctrlKey) {
					this.onOk();
				}
				break;

			case 27: // ESC
				this.onCancel();
				break;

			default:
				this.updateFormats();
		}

		this._lastKeyCode = event.keyCode;
		this.updateSimStyle();
	},
	
	onOk: function(e){
		this.hide();
	},
	
	onCancel: function(e){
		this.hide(true);
	},
	
//	onMouseOver: function(e){
//		dojo.addClass(e.target, "inlineEditHelpOkCancel");
//		
//	},
//	
//	onMouseOut: function(e){
//		dojo.removeClass(e.target, "inlineEditHelpOkCancel");
//	},
	
	onMoveStart: function(mover){
	
		dojo.style('iebPointer', 'display', 'none');
		
	},
	
	onMoveStop: function(mover){
		
		var left = dojo.style('ieb', 'left');
		var top = dojo.style('ieb', 'top');
		var moveLeft = this._startLeft - left;
		var moveTop = top - this._startTop;
		if (moveTop < this._Y_MOVE_RANGE &&  moveTop > (-this._Y_MOVE_RANGE) ){
			dojo.style('iebPointer', 'display', '');
			dojo.style('iebPointer', 'top', this._startTop + this._POINTER_TOP_OFFSET + moveTop + 'px');
		}else{
			dojo.style('iebPointer', 'display', 'none'); // out or range so we are done
			return;
		}
		if (moveLeft < this._X_MOVE_RANGE &&  moveLeft > (-this._X_MOVE_RANGE)){
			dojo.style('iebPointer', 'display', '');
		}else{
			dojo.style('iebPointer', 'display', 'none'); // out or range so we are done
			return;
		}
		
		
	},
		
	stopEvent: function(e){
		// Don't let mousedown event bubble up to daVinci main processing.
		// Mainline logic of daVinci will interpret it as an attempt to select an object
		// and since the click is in the inline edit control, which isn't a document widget,
		// this will end up as an unselect-all action.
		//FIXME stopPropation() doesn't work on old IEs
		e.stopPropagation();
		this.updateSimStyle();
	},
	
	stopEvent_Intercept_Enter: function(e){
		this.stopEvent(e);
		// For single-line SmartInput, don't let Enter key
		// wipe out the currently selected text input
		if(e.keyCode == 13 && !this.multiLine){
			e.preventDefault();
		}
	},
	
	
	_node: function() {
		var node;
		var path = this.path;
		var selector = this.selector;
		if (path || selector) {
			node = this._widget.domNode; 
			if (path) {
				node = dojo.getObject(path, false, this._widget);
			}
			if (selector) {
				node = dojo.query(selector, node)[0];
			}
		}
		return node;
	},
	
	updateWidget: function(value){
		
		if (this._widget._destroyed)
			return;

			if (this.parse) {
				value = this.parse(value);
			}

			var node = this._node(this._widget);
			var context=this._widget.getContext();
			var inlineEditProp = this.property;
			var djprop = (inlineEditProp==="maq_innerText") ? "innerHTML" : inlineEditProp;
			if (this.update) {
					
				var updatedWidget = this.update(node || this._widget, value, inlineEditProp);
                if (updatedWidget) {
                    this._widget = updatedWidget; // FIXME: this was this_selectedWidget
                }
                //dojo.publish("/davinci/ui/selectionPropertiesChange",[{editor:null, widget:this._selectedWidget, subwidget:null, cssValues:null, computedCssValues:null}]); // update the object pallete
				//this._selectedWidget._edit_context.select(this._selectedWidget, null, false); // redraw the box around the widget
                context.select(this._widget, null, false); // redraw the box around the
            }
			else if (inlineEditProp) {
				if (node) {
					dojo.attr(node, djprop, value); // FIXME: Make this work with serialization/undo stack
					// FIXME: Need to serialize changes into the model
					// The follow code, however, doesn't work for some reason. May need to ask Phil.
					// Also, the code doesn't take into account 'selector'. Model needs something like
					// dojo.query to put a property on a particular node.
					//var srcElement = this._selectedWidget._srcElement;	//FIXME: Shouldn't there be a getSourceElement in widget.js?
					//srcElement.addAttribute(inlineEditProp, value);
				} else {
					var values={};
					if (value && (typeof value == 'string')){
						value = value.replace(/\n/g, ''); // new lines breaks create widget richtext
					}
					var children = null;
					if (inlineEditProp == 'textContent'){
						// set the children to be the same as the textContect so the dom is correct.
						children = value;
						
					}else{
						values[inlineEditProp]=value;
					}
					var command;

					if (djprop === 'innerHTML'){
						values.richText = values[inlineEditProp];
						delete values[inlineEditProp];
						command = new ModifyRichTextCommand(this._widget, values, null, context);
					}else{
						command = new davinci.ve.commands.ModifyCommand(this._widget, values, children, context);
					}
					this._widget._edit_context.getCommandStack().execute(command);
					this._widget=command.newWidget;	
					this._widget._edit_context._focuses[0]._selectedWidget = this._widget; // get the focus on the current node
				}
                context.select(this._widget, null, false); // redraw the box around the widget
			}

	},
	
	hide: function(cancel){
		if (this._inline) {
			var value;
			while (connection = this._connection.pop()){
				if (connection) {
					dojo.disconnect(connection);
				}
			}
			var smartInputContainer = this._findSmartInputContainer(this._widget._edit_context.frameNode);
			if(!smartInputContainer){
				console.log('ERROR. SmartInput.js _loading(). No ancestor ContentPane');
				return;
			}
			if (this._loadingDiv) {
				smartInputContainer.removeChild(this._loadingDiv);
			}
			if(this._inline.style.display != "none" && this._inline.eb){
				value = this._inline.eb.get('value');
				this._value = value;
				this._format = this.getFormat();
				this._inline.style.display = "none";
				if (this._inline.eb){
					this._inline.eb.destroyRecursive();
					delete this._inline.eb;
				}
				this._inline.destroyRecursive();
				delete this._inline;  
                var iebPointer = smartInputContainer.ownerDocument.getElementById('iebPointer');
				smartInputContainer.removeChild(iebPointer);
				
				if(value != null && !cancel){
				if (!this.disableEncode && this._format === 'text' ) // added to support dijit.TextBox that does not support html markup in the value and should not be encoded. wdr
						value = entities.encode(value);
				
					this.updateWidget(value);
				}
				var context=this._widget.getContext();
				var userdoc = context.getDocument();	// inner document = user's document
				userdoc.defaultView.focus();	// Make sure the userdoc is the focus object for keyboard events
			}
 
		}
	},
	
	getFormat: function(){
		var htmlRadio = dijit.byId('davinci.ve.input.SmartInput_radio_html');
		var format = 'text';
		if (htmlRadio && htmlRadio.checked)
			format = 'html';
		return format;
	},
	
		

		containsHtmlMarkUp: function (str){
			
//			var str2 =  entities.encode(str);
//			if (str === str2) {
//				return false;
//			} 
//			return true;
			
			var n = dojo.create("div", { innerHTML: str});
			if (n.children.length > 0){
				return true;
			}else{
				return false;
			}
		},
		
		toggleHelp: function(){

			var help = dojo.byId('davinci.ve.input.SmartInput_img_help');
			if (dojo.hasClass(help, "inlineEditHelpSelected")){
				this.help(false);
			} else {
				this.help(true);
			}
			dojo.toggleClass(help, "inlineEditHelpSelected");
		},
		
		setFormat: function(value){
			var htmlRadio = dijit.byId('davinci.ve.input.SmartInput_radio_html');
			var textRadio = dijit.byId('davinci.ve.input.SmartInput_radio_text');
			var n = dojo.create("div", { innerHTML: value});
			var format = n.children.length ? 'html' : 'text';
			if (format === 'html'){
				htmlRadio.set('checked', true);
				textRadio.set('checked', false);
			}else{ 
				htmlRadio.set('checked', false);
				textRadio.set('checked', true);
			}
			this._format = format;

		},
		
		help: function(display){
			var helpDiv = dojo.byId('davinci.ve.input.SmartInput_div_help');
			var radioDiv = dojo.byId('davinci.ve.input.SmartInput_radio_div');
			if (display){
				dojo.style(helpDiv, 'display', '');
				//dojo.style(radioDiv, 'height', '150px');
			}else{
				dojo.style(helpDiv, 'display', 'none');
//				if (this.isHtmlSupported()){
//					dojo.style(radioDiv, 'height', '60px');
//				} else {
//					dojo.style(radioDiv, 'height', '40px'); // div can be smaller, no text is displayed
//				}
			}
		},
		
		updateFormats: function(){
			
			var value = this._inline.eb.get('value');
			var disabled = true;
			if (this.containsHtmlMarkUp(value)) {
				disabled = false;
			}
			
			// NOTE: if you put a break point in here while debugging it will break the dojoEllipsis
			var localDojo = this._widget.getContext().getDojo();
			var textObj = dojo.byId("davinci.ve.input.SmartInput_radio_text_width_div");
			//var what = entities.encode(dojox.html.entities.encode(value));
			var what = entities.encode(value);
			textObj.innerHTML = '<div class="dojoxEllipsis">' + dojo.replace('Plain text ({0})', [what]) + '</div>'; // FIXME: i18n
			var htmlObj = dojo.byId("davinci.ve.input.SmartInput_radio_html_width_div");
			htmlObj.innerHTML = '<div id="davinci.ve.input.SmartInput_radio_html_div" class="dojoxEllipsis">'+veNls.htmlMarkup+'</div>';
			var htmlRadio = dijit.byId('davinci.ve.input.SmartInput_radio_html');
			var textRadio = dijit.byId('davinci.ve.input.SmartInput_radio_text');
			var table = dojo.byId('davinci.ve.input.SmartInput_table');
			htmlRadio.setDisabled(disabled);
			textRadio.setDisabled(disabled);
			if (disabled){
				dojo.addClass(textObj,'inlineEditDisabled');
				dojo.addClass(htmlObj,'inlineEditDisabled');
				htmlRadio.set('checked', false);
				textRadio.set('checked', true);
			}else{
				dojo.removeClass(textObj,'inlineEditDisabled');
				dojo.removeClass(htmlObj,'inlineEditDisabled');
			}
			if (!disabled && this.isHtmlSupported()){
				dojo.style(textRadio.domNode, 'display', '');
				dojo.style(htmlRadio.domNode, 'display', '');
				dojo.style(htmlObj, 'display', '');
				dojo.style(textObj, 'display', '');
				dojo.style(table, 'display', '');
			} else {
				dojo.style(textRadio.domNode, 'display', 'none');
				dojo.style(htmlRadio.domNode, 'display', 'none');
				dojo.style(htmlObj, 'display', 'none');
				dojo.style(textObj, 'display', 'none');
				dojo.style(table, 'display', 'none');
			}
			
		},
		
		resize: function(e){
			var targetObj = dojo.byId("iedResizeDiv");
			var targetEditBoxDijit = dijit.byId("davinciIleb");
			var boxWidth = targetObj.clientWidth  - 5;
			var boxheight = targetObj.clientHeight -6;
			var smartInputRadioDivWidth = targetObj.clientWidth -10;
			boxWidth = targetObj.clientWidth  /*+2*/ -8;
			boxheight = targetObj.clientHeight  -20; // new for text area
			smartInputRadioDivWidth = targetObj.clientWidth -9;
			var simObj = dojo.byId("smartInputSim");
			dojo.style(simObj,'width',boxWidth + 10 + "px");
			this.updateSimStyle();
		
			if (targetEditBoxDijit) {
				targetEditBoxDijit._setStyleAttr({width: boxWidth + "px", height: boxheight + "px", maxHeight: boxheight + "px"}); // needed for multi line
				targetEditBoxDijit._setStyleAttr({width: targetObj.clientWidth + "px"});
			}
			var obj = dojo.byId("davinci.ve.input.SmartInput_radio_div");
			dojo.style(obj,'width',smartInputRadioDivWidth+ 2 +"px");
			obj = dojo.byId("davinci.ve.input.SmartInput_radio_text_width_div");
			dojo.style(obj,'width',targetObj.clientWidth -50 + "px");
			obj = dojo.byId("davinci.ve.input.SmartInput_radio_html_width_div");
			dojo.style(obj,'width',targetObj.clientWidth -50 + "px");
		},
		
		onBlur: function(e){
			this.updateSimStyle(e);
		},
		
		updateSimStyle: function(e){
			
			var targetEditBoxDijit = dijit.byId("davinciIleb");
			var simObj = dojo.byId("smartInputSim");
			if (simObj){
				var s = dojo.style(targetEditBoxDijit.domNode);
				dojo.style(simObj,'borderColor',s.borderTopColor);
				dojo.style(simObj,'backgroundColor',s.backgroundColor);
			}
			
		},

		_getTemplate: function(){
			var editBox = ''+
				'<div id="iedResizeDiv" class="iedResizeDiv" >' + 
//			       '<input id="davinciIleb" class="davinciIleb smartInputTextBox" type="text"  dojoType="dijit.form.TextBox"  />' +
				   '<textarea  dojoType="dijit.form.SimpleTextarea" name="davinciIleb" trim="true" id="davinciIleb" class="smartInputTextArea" ></textarea>'+
				   '<div id="smartInputSim" class="smartInputSim" ></div>'+
					'<div id="iedResizeHandle" dojoType="dojox.layout.ResizeHandle" targetId="iedResizeDiv" constrainMin="true" maxWidth="200" maxHeight="600" minWidth="200" minHeight="55"  activeResize="true" intermediateChanges="true" ></div>' +
		//			'<div id="iedResizeHandle" dojoType="dojox.layout.ResizeHandle" targetId="iedResizeDiv" constrainMin="true" maxWidth="200" maxHeight="200" minWidth="200" minHeight="19" resizeAxis="x" activeResize="true" intermediateChanges="true" ></div>' +
				'</div>';
			if (this.multiLine === "true"){
				editBox = ''+
				'<div id="iedResizeDiv" class="iedResizeDiv" >' + 
					'<textarea  dojoType="dijit.form.SimpleTextarea" name="davinciIleb" trim="true" id="davinciIleb" class="smartInputTextAreaMulti" ></textarea>'+
					'<div id="smartInputSim" class="smartInputSim" ></div>'+
//					'<div id="smartInputSim" style="height:10px; border-color: #B5BCC7; border-style: solid; border-width: 0px 3px 3px 3px;  background-color: #F7FCFF;"></div>'+
					'<div id="iedResizeHandle" dojoType="dojox.layout.ResizeHandle" targetId="iedResizeDiv" constrainMin="true" maxWidth="200" maxHeight="600" minWidth="200" minHeight="80"  activeResize="true" intermediateChanges="true" ></div>' +
				'</div>';
			}
			var template = ''+ editBox +
			'<div  id="davinci.ve.input.SmartInput_div"  class="davinciVeInputSmartInputDiv" >' + 
    			'<div id="davinci.ve.input.SmartInput_radio_div" class="smartInputRadioDiv" >' + 
    				'<table id="davinci.ve.input.SmartInput_table"> ' +
    					'<tbody>' + 
    						'<tr> ' +
    							'<td class="smartInputTd1" > ' +
    								'<input id="davinci.ve.input.SmartInput_radio_text" showlabel="true" type="radio" dojoType="dijit.form.RadioButton" disabled="false" readOnly="false" intermediateChanges="false" checked="true"> </input> '+
		             			'</td> ' +
		             			'<td class="smartInputTd2" >'+ 
		             				'<div id="davinci.ve.input.SmartInput_radio_text_width_div" class="smartInputRadioTextDiv">'+
//		             				'<div id="davinci.ve.input.SmartInput_radio_text_div" class="dojoxEllipsis">'+
//		             					'Plain text (Button)xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx'+
//		             				'</div>'+
		             				'</div>'+
	             				'</td> ' +
             				'</tr>'+
             				'<tr> '+
             					'<td class="smartInputTd1"> <input id="davinci.ve.input.SmartInput_radio_html" showlabel="true" type="radio" dojoType="dijit.form.RadioButton"> </input>  </td> '+
             					'<td class="smartInputTd2">'+
             						'<div id="davinci.ve.input.SmartInput_radio_html_width_div" class="smartInputRadioTextDiv">'+
//             						'<div id="davinci.ve.input.SmartInput_radio_html_div" class="dojoxEllipsis">'+
//             							'HTML markup'+
//             						'</div>'+
             						'</div>'+
	             				'</td> '+
         					'</tr> '+
     					'</tbody>'+ 
 					'</table> '+
					'<div class="smartInputHelpDiv" > '+
		        		'<span id="davinci.ve.input.SmartInput_img_help"  title="Help" class="inlineEditHelp" > </span>'+
			        	'<span class="smartInputSpacerSpan" >'+
			        	'<button id="davinci.ve.input.SmartInput_ok"  dojoType="dijit.form.Button" type="submit" class="inlineEditHelpOk" >'+commonNls.buttonOk+'</button> <button id=davinci.ve.input.SmartInput_cancel dojoType="dijit.form.Button" class="inlineEditHelpCancel"> '+commonNls.buttonCancel+'</button>  '+
			        	'</span>   '+
			        '</div> '+
			        '<div id="davinci.ve.input.SmartInput_div_help" style="display:none;" class="smartInputHelpTextDiv" > '+
			        	'<div dojoType="dijit.layout.ContentPane" class="smartInputHelpTextDivContentPane "style="padding:0;" >'+this.getHelpText()+ '</div> '+
			        	'<div style="text-align: left; padding:0; height:2px;" ></div> '+
			        '</div> '+
		        '</div>' + 
	        '</div> '+
	        '';
 			return template;
		},
		
		_connectResizeHandle: function(){
			var resizeHandle = dijit.byId('iedResizeHandle');
			this._connection.push(dojo.connect(resizeHandle, "onResize", this, "resize"));
		},
		
		_connectSimDiv: function(){
			this._connection.push(dojo.connect(this._inline.eb, "onFocus", this, "updateSimStyle"));
			this._connection.push(dojo.connect(this._inline.eb, "onMouseOver", this, "updateSimStyle")); 
			this._connection.push(dojo.connect(this._inline.eb, "onMouseOut", this, "updateSimStyle"));
			this._connection.push(dojo.connect(dojo.byId(' davinci.ve.input.SmartInput_div'), "onclick", this, "updateSimStyle"));
		}
});
});

},
'url:dijit/templates/Tree.html':"<div class=\"dijitTree dijitTreeContainer\" role=\"tree\">\n\t<div class=\"dijitInline dijitTreeIndent\" style=\"position: absolute; top: -9999px\" data-dojo-attach-point=\"indentDetector\"></div>\n</div>\n",
'dijit/form/_ListMouseMixin':function(){
define([
	"dojo/_base/declare", // declare
	"dojo/mouse",
	"dojo/on",
	"dojo/touch",
	"./_ListBase"
], function(declare, mouse, on, touch, _ListBase){

// module:
//		dijit/form/_ListMouseMixin

return declare( "dijit.form._ListMouseMixin", _ListBase, {
	// summary:
	//		a Mixin to handle mouse or touch events for a focus-less menu
	//		Abstract methods that must be defined externally:
	//
	//		- onClick: item was chosen (mousedown somewhere on the menu and mouseup somewhere on the menu)
	// tags:
	//		private

	postCreate: function(){
		this.inherited(arguments);

		this.own(on(this.domNode, touch.press, function(evt){ evt.preventDefault(); })); // prevent focus shift on list scrollbar press

		this._listConnect(touch.press, "_onMouseDown");
		this._listConnect(touch.release, "_onMouseUp");
		this._listConnect(mouse.enter, "_onMouseOver");
		this._listConnect(mouse.leave, "_onMouseOut");
	},

	_onMouseDown: function(/*Event*/ evt, /*DomNode*/ target){
		if(this._hoveredNode){
			this.onUnhover(this._hoveredNode);
			this._hoveredNode = null;
		}
		this._isDragging = true;
		this._setSelectedAttr(target);
	},

	_onMouseUp: function(/*Event*/ evt, /*DomNode*/ target){
		this._isDragging = false;
		var selectedNode = this.selected;
		var hoveredNode = this._hoveredNode;
		if(selectedNode && target == selectedNode){
			this.onClick(selectedNode);
		}else if(hoveredNode && target == hoveredNode){ // drag to select
			this._setSelectedAttr(hoveredNode);
			this.onClick(hoveredNode);
		}
	},

	_onMouseOut: function(/*Event*/ evt, /*DomNode*/ target){
		if(this._hoveredNode){
			this.onUnhover(this._hoveredNode);
			this._hoveredNode = null;
		}
		if(this._isDragging){
			this._cancelDrag = (new Date()).getTime() + 1000; // cancel in 1 second if no _onMouseOver fires
		}
	},

	_onMouseOver: function(/*Event*/ evt, /*DomNode*/ target){
		if(this._cancelDrag){
			var time = (new Date()).getTime();
			if(time > this._cancelDrag){
				this._isDragging = false;
			}
			this._cancelDrag = null;
		}
		this._hoveredNode = target;
		this.onHover(target);
		if(this._isDragging){
			this._setSelectedAttr(target);
		}
	}
});

});

},
'dojo/cookie':function(){
define(["./_base/kernel", "./regexp"], function(dojo, regexp){

// module:
//		dojo/cookie

/*=====
var __cookieProps = {
	// expires: Date|String|Number?
	//		If a number, the number of days from today at which the cookie
	//		will expire. If a date, the date past which the cookie will expire.
	//		If expires is in the past, the cookie will be deleted.
	//		If expires is omitted or is 0, the cookie will expire when the browser closes.
	// path: String?
	//		The path to use for the cookie.
	// domain: String?
	//		The domain to use for the cookie.
	// secure: Boolean?
	//		Whether to only send the cookie on secure connections
};
=====*/


dojo.cookie = function(/*String*/name, /*String?*/ value, /*__cookieProps?*/ props){
	// summary:
	//		Get or set a cookie.
	// description:
	//		If one argument is passed, returns the value of the cookie
	//		For two or more arguments, acts as a setter.
	// name:
	//		Name of the cookie
	// value:
	//		Value for the cookie
	// props:
	//		Properties for the cookie
	// example:
	//		set a cookie with the JSON-serialized contents of an object which
	//		will expire 5 days from now:
	//	|	require(["dojo/cookie", "dojo/json"], function(cookie, json){
	//	|		cookie("configObj", json.stringify(config, {expires: 5 }));
	//	|	});
	//
	// example:
	//		de-serialize a cookie back into a JavaScript object:
	//	|	require(["dojo/cookie", "dojo/json"], function(cookie, json){
	//	|		config = json.parse(cookie("configObj"));
	//	|	});
	//
	// example:
	//		delete a cookie:
	//	|	require(["dojo/cookie"], function(cookie){
	//	|		cookie("configObj", null, {expires: -1});
	//	|	});
	var c = document.cookie, ret;
	if(arguments.length == 1){
		var matches = c.match(new RegExp("(?:^|; )" + regexp.escapeString(name) + "=([^;]*)"));
		ret = matches ? decodeURIComponent(matches[1]) : undefined; 
	}else{
		props = props || {};
// FIXME: expires=0 seems to disappear right away, not on close? (FF3)  Change docs?
		var exp = props.expires;
		if(typeof exp == "number"){
			var d = new Date();
			d.setTime(d.getTime() + exp*24*60*60*1000);
			exp = props.expires = d;
		}
		if(exp && exp.toUTCString){ props.expires = exp.toUTCString(); }

		value = encodeURIComponent(value);
		var updatedCookie = name + "=" + value, propName;
		for(propName in props){
			updatedCookie += "; " + propName;
			var propValue = props[propName];
			if(propValue !== true){ updatedCookie += "=" + propValue; }
		}
		document.cookie = updatedCookie;
	}
	return ret; // String|undefined
};

dojo.cookie.isSupported = function(){
	// summary:
	//		Use to determine if the current browser supports cookies or not.
	//
	//		Returns true if user allows cookies.
	//		Returns false if user doesn't allow cookies.

	if(!("cookieEnabled" in navigator)){
		this("__djCookieTest__", "CookiesAllowed");
		navigator.cookieEnabled = this("__djCookieTest__") == "CookiesAllowed";
		if(navigator.cookieEnabled){
			this("__djCookieTest__", "", {expires: -1});
		}
	}
	return navigator.cookieEnabled;
};

return dojo.cookie;
});

},
'url:dijit/form/templates/DropDownBox.html':"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\"\n\trole=\"combobox\"\n\t><div class='dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer'\n\t\tdata-dojo-attach-point=\"_buttonNode, _popupStateNode\" role=\"presentation\"\n\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"button presentation\" aria-hidden=\"true\"\n\t\t\t${_buttonInputDisabled}\n\t/></div\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class='dijitReset dijitInputInner' ${!nameAttrSetting} type=\"text\" autocomplete=\"off\"\n\t\t\tdata-dojo-attach-point=\"textbox,focusNode\" role=\"textbox\" aria-haspopup=\"true\"\n\t/></div\n></div>\n",
'davinci/model/Path':function(){
define([
	"dojo/_base/declare"
], function(declare) {

if ( typeof davinci.model === "undefined" ) { davinci.model = {}; }
if ( typeof davinci.model.Path === "undefined" ) { davinci.model.Path = {}; }

var Path = declare("davinci.model.Path", null, {

	/**
	 * @class davinci.model.Path
	 * @constructor     
	 */
	constructor: function(path, hasLeading, hasTrailing) {
		path = path || '.';  // if empty string, use '.'
		if (typeof path == 'string') {
			this.path = path;
			this.getSegments();
		} else {
			this.segments = path;
			this.hasLeading = hasLeading;
			this.hasTrailing = hasTrailing;
		}
	},

	endsWith: function(tail) {
		var segments = dojo.clone(this.segments);
		var tailSegments = (new Path(tail)).getSegments();
		while (tailSegments.length > 0 && segments.length > 0) {
			if (tailSegments.pop() != segments.pop()) {
				return false;
			}
		}
		return true;
	},

	getExtension: function() {
		if (!this.extension) {
			this.extension = this.path.substr(this.path.lastIndexOf('.')+1);
		}
		return this.extension;
	},

	segment : function(index){
		var segs = this.getSegments();
		if(segs.length < index) return null;
		return segs[index];
	},
	
	getSegments: function() {
		if (!this.segments) {
			var path = this.path;
			this.segments = path.split('/');
			if (path.charAt(0) == '/') {
				this.hasLeading = true;
			}
			if (path.charAt(path.length-1) == '/') {
				this.hasTrailing = true;
				// If the path ends in '/', split() will create an array whose last element
				// is an empty string. Remove that here.
				this.segments.pop();
			}
			this._canonicalize();
		}
		return this.segments;
	},

	isAbsolute: function(  ) {
		return this.hasLeading;
	},

	getParentPath: function() {
		if (!this._parentPath) {
			var parentSegments = dojo.clone(this.segments);
			parentSegments.pop();
			this._parentPath = new Path(parentSegments, this.hasLeading);
		}
		return dojo.clone(this._parentPath);
	},

	_clone: function() {
		return new Path(dojo.clone(this.segments), this.hasLeading, this.hasTrailing);
	},

	append: function(tail) {
		tail = tail || "";
		if (typeof tail == 'string') {
			tail = new Path(tail);
		}
		if (tail.isAbsolute()) {
			return tail;
		}
		var mySegments = this.segments;
		var tailSegments = tail.getSegments();
		var newSegments = mySegments.concat(tailSegments);
		var result = new Path(newSegments, this.hasLeading, tail.hasTrailing);
		if (tailSegments[0] == ".." || tailSegments[0] == ".") { 
			result._canonicalize();
		}
		return result;
	},

	toString: function() {
		var result = [];
		if (this.hasLeading) {
			result.push('/');
		}
		for (var i=0; i<this.segments.length; i++) {
			if (i > 0) {
				result.push('/');
			}
			result.push(this.segments[i]);
		}
		if (this.hasTrailing) {
			result.push('/');
		}
		return result.join("");
	},

	removeRelative : function(){
		var segs = this.getSegments();
		if(segs.length > 0 && segs[1]==".")
			return this.removeFirstSegments(1);
		return this;
	},
	
	relativeTo: function(base, ignoreFilename) {
		if (typeof base == 'string') {
			base = new Path(base);
		}
		var mySegments = this.segments;
		if (this.isAbsolute()) {
			return this;
		}
		var baseSegments = base.getSegments();
		var commonLength = this.matchingFirstSegments(base);
		var baseSegmentLength = baseSegments.length;
		if (ignoreFilename) {
			baseSegmentLength = baseSegmentLength -1;
		}
		var differenceLength = baseSegmentLength - commonLength;
		var newSegmentLength = differenceLength + mySegments.length - commonLength;
		if (newSegmentLength == 0) {
			return davinci.model.Path.EMPTY;
		}
		var newSegments = [];
		for (var i=0; i<differenceLength; i++) {
			newSegments.push('..');
		}
		for (var i=commonLength; i<mySegments.length; i++) {
			newSegments.push(mySegments[i]);
		}
		return  new Path(newSegments, false, this.hasTrailing);
	},

	startsWith: function(anotherPath) {
		var count = this.matchingFirstSegments(anotherPath);
		return anotherPath._length() == count;
	},

	_length: function(anotherPath) {
		return this.segments.length;
	},

	matchingFirstSegments: function(anotherPath) {
		var mySegments = this.segments;
		var pathSegments = anotherPath.getSegments();
		var max = Math.min(mySegments.length, pathSegments.length);
		var count = 0;
		for (var i = 0; i < max; i++) {
			if (mySegments[i] != pathSegments[i]) {
				return count;
			}
			count++;
		}
		return count;
	},

	removeFirstSegments: function(count) {
		return new Path(this.segments.slice(count, this.segments.length), this.hasLeading, this.hasTrailing);
	},

	removeMatchingLastSegments: function(anotherPath) {
		var match = this.matchingFirstSegments(anotherPath);
		return this.removeLastSegments(match);
	},

	removeMatchingFirstSegments: function(anotherPath) {
		var match = this.matchingFirstSegments(anotherPath);
		return this._clone().removeFirstSegments(match);
	},

	removeLastSegments: function(count) {
		if(!count) {
			count = 1;
		}
		return new Path(this.segments.slice(0, this.segments.length-count), this.hasLeading, this.hasTrailing);
	},

	lastSegment: function() {
		return this.segments[this.segments.length-1];
	},

	firstSegment: function(length) {
		return this.segments[length || 0];
	},

	equals: function(anotherPath) {
		if (this.segments.length != anotherPath.segments.length) {
			return false;
		}
		for (var i=0; i<this.segments.length; i++) {
			if (anotherPath.segments[i] != this.segments[i]) {
				return false;
			};
		}
		return true;
	},

	_canonicalize: function() {
		
		var doIt;
		var segments = this.segments;
		for (var i=0; i<segments.length; i++) {
			if (segments[i] == "." || segments[i] == "..") {
				doIt = true; 
				break;
			}
		}
		if (doIt) {
			var stack = [];
			for (var i = 0; i < segments.length; i++) {
				if (segments[i] == "..") {
					if (stack.length == 0) {
						// if the stack is empty we are going out of our scope 
						// so we need to accumulate segments.  But only if the original
						// path is relative.  If it is absolute then we can't go any higher than
						// root so simply toss the .. references.
						if (!this.hasLeading) {
							stack.push(segments[i]); //stack push
						}
					} else {
						// if the top is '..' then we are accumulating segments so don't pop
						if (".." == stack[stack.length - 1]) {
							stack.push("..");
						} else {
							stack.pop();
						}
					}
					//collapse current references
				} else if (segments[i] != "." || this.segments.length == 1) {
					stack.push(segments[i]); //stack push
				}
			}
			//if the number of segments hasn't changed, then no modification needed
			if (stack.length == segments.length) {
				return;
			}
			this.segments = stack;
		}
	}

});
	davinci.model.Path.EMPTY = new Path(""); 
	return Path;
});
},
'davinci/workbench/Preferences':function(){
define([
	"dojo/_base/declare",
	"dojo/_base/xhr",
	"dojo/_base/lang",
	"dojo/topic",
	"dojo/dom",
//    "../Workbench",
    "../Runtime",
//   "../Theme",
    "dijit/_WidgetBase",
    "dijit/_TemplatedMixin",
    "dijit/_WidgetsInTemplateMixin",
    "dijit/registry",
    "davinci/ui/Dialog",
    "dijit/Tree",
    "dijit/tree/ForestStoreModel",
    "dojo/data/ItemFileReadStore",
    "dojo/i18n!./nls/workbench",
    "dojo/i18n!dijit/nls/common",
    "dojo/text!./templates/Preferences.html",
    "dijit/form/Button"
], function(
	declare,
	xhr,
	lang,
	topic,
	dom,
	/*Workbench,*/
	Runtime,
	/*Theme,*/
	WidgetBase,
	TemplatedMixin,
	WidgetsInTemplateMixin,
	registry,
	Dialog,
	Tree,
	ForestStoreModel,
	ItemFileReadStore,
	workbenchStrings,
	commonStrings,
	templateString
) {


var DIALOG_WIDTH = 650;
var DIALOG_HEIGHT = 350;

var PreferencesWidget = declare([WidgetBase, TemplatedMixin, WidgetsInTemplateMixin], {

	templateString: templateString,

	commonStrings: commonStrings,

	resize: function() {
		this.borderContainer.resize();
	}
});
	
var Preferences = {
	_allPrefs: {},

	savePreferences: function(id, base, preferences){
		xhr.put({
			url: "cmd/setPreferences?id="+id + "&base=" + encodeURIComponent(base),
			putData: JSON.stringify(preferences),
			handleAs: "json",
			contentType: "text/html"
		}).then(function() {
			if(!Preferences._allPrefs[base]) {
				Preferences._allPrefs[base] = {};			
			}
			
			Preferences._allPrefs[base][id] = preferences;
			
			topic.publish("/davinci/preferencesChanged", {id: id, preferences: preferences});
		});
	},

	_loadExtensions: function (){
		 if(!Preferences._extensions) { Preferences._extensions=Runtime.getExtensions("davinci.preferences"); }
	},
	
	showPreferencePage: function(){
		Preferences._loadExtensions();
		var prefJson = Preferences.getPrefJson();

		//FIXME: Temporary hack to hide project preferences
		//Can't just delete them because other parts of the code query for a particular preference
		//Instead, just make it so that project preferences don't appear in preferences dialog
		//Issue https://github.com/maqetta/maqetta/issues/3658 is reminder to restore project preferences
		if(prefJson.items){
			for(var i=prefJson.items.length-1; i>=0; i--){
				var item = prefJson.items[i];
				if(item.hide){
					prefJson.items.splice(i,1);
				}
			}
		}

		if(!prefJson || prefJson.length < 1) {
			alert(workbenchStrings.noUserPref);
			return;
		}

		this.dialog = Dialog.showModal(new PreferencesWidget({}), workbenchStrings.preferences,
				{width: DIALOG_WIDTH, height: DIALOG_HEIGHT});

		var itemStore = new ItemFileReadStore({data: prefJson, jsId: "prefTreeDataStore"});	
		var forestModel = new ForestStoreModel({
			jsId: "fileModel",
			labelAttr: "name",
			store: itemStore,
			rootId: 'root'
		});
		
		// save "path" for first pane
		var path = ['root'];
		var items = prefJson.items;
		if (items) {
			do {
				var item = items[0];
				path.push(item.id);
				items = item.children;
			} while (items);
		}

		var dojoTree = registry.byId("prefTree");
		if(!dojoTree) {
			dojoTree = new Tree({
				model: forestModel, 
				id: 'prefTree',
				persist: false,
				query: "{type:'directory'}",
				label: "Preferences", 
				labelAttr: "name", 
				showRoot: false,
				childrenAttrs: "children",
				openOnClick: true,
				autoExpand: true
			});
		}
		dojoTree.onClick = function(node) { Preferences.setPaneContent(node); };
		dom.byId("pref.TreePane").appendChild(dojoTree.domNode);
		dojoTree.startup();

		// auto-select first pane
		dojoTree.onLoadDeferred.then(function() {
			dojoTree.set('paths', [path]).then(function() {
				dojoTree.focusNode(dojoTree.selectedNode);
				Preferences.setPaneContent(dojoTree.selectedItem);
			});
		});
	},

	getPrefJson: function(){
		//build the proper json structure before returning it.  this is to save a lot of time over riding model methods for the tree.
		var ejson = Preferences._extensions;
		if (!ejson) {
			return [];
		}

		var flatNodeTree = [];
		for(var i = 0;i<ejson.length;i++){
			ejson[i]._index=i;
			if(ejson[i].category){
				if(!flatNodeTree[ejson[i].category]){
					flatNodeTree[ejson[i].category]  = [];
				}
				
				flatNodeTree[ejson[i].category].push(ejson[i]);
				
			}else{
				if(!flatNodeTree.root) {
					flatNodeTree.root = [];
				}
				flatNodeTree.root.push(ejson[i]);
			}
		}
		
		var treeJson = flatNodeTree.root.map(function(node){
			return {
				id: node.id,
				name: node.name,
				hide: node.hide,
				index: node._index,
				children: Preferences._getPrefJsonChildren(node.id, flatNodeTree)
			};
		});
		
		return {
			identifier: 'id',
			items: treeJson
		};
	},
	
	_getPrefJsonChildren: function(catId, valuesArray){
		var children = valuesArray[catId];
		if (!children) {
			return [];
		}
		var freechildren = []; // FIXME: use map
		for(var p = 0;p<children.length;p++){
			freechildren[p] = {
				id: children[p].id,
				name: children[p].name,
				index: children[p]._index
			};
			if(valuesArray[children[p].id]){	
				freechildren[p].children = Preferences._getPrefJsonChildren(children[p].id, valuesArray) ;
			}
		}
		return freechildren;
	},

	setPaneContent: function(node){
		var domNode;
		delete Preferences._currentPane;
		var extension = Preferences._extensions[node.index[0]];
		var prefs = Preferences.getPreferences(extension.id, davinci.Workbench.getProject());
		if (extension.pane){
			require([extension.pane], function(cls) {
				var pane=new cls();
				Preferences._currentPane=pane;
				Preferences._currentPane._extension=extension;
				Preferences._currentPane.setPreferences(prefs);
				registry.byId("pref.RightPane").setContent(pane.domNode);
			});
		}
		else if (extension.pageContent){
			domNode=document.createTextNode(extension.pageContent);
		}
		else {
			domNode=document.createTextNode("");
		}
		if (domNode) {
			registry.byId("pref.RightPane").setContent( domNode );
		}
	},
	
	_save: function(listOfPages){
		if (Preferences._currentPane)
		{
			var prefs=Preferences._currentPane.getPreferences();
			var id=Preferences._currentPane._extension.id;
			var base = davinci.Workbench.getProject();
			
			Preferences.savePreferences(id, base, prefs);
			if(Preferences._currentPane.save){
				Preferences._currentPane.save(prefs);
			}
		}
		for(var i = 0;i<listOfPages.length;i++){
			try{
				if(listOfPages[i].save) {
					listOfPages[i].save();
				}
			}catch(ex){console.log(ex); }
			if(listOfPages[i].children && listOfPages[i].children.length > 0) {
				Preferences._save(listOfPages[i].children);
			}
		}
	},

	save: function (){
		Preferences._save(Preferences._extensions);
		Preferences.finish();
	},

	finish: function (){
		Preferences._extensions=null;
		Preferences._currentPane=null;
		this.dialog.destroyRecursive(false);
		this.dialog = null;
	},
	
	getPreferences: function (id, base){
		
		if(!Preferences._allPrefs[base]) {
			Preferences._allPrefs[base] = {};
		}
		
		if (!Preferences._allPrefs[base][id]){
			var prefs= Runtime.serverJSONRequest({
			   url:"cmd/getPreferences",
			   handleAs:"json",
			   content:{id:id, base: base},
			   sync: true
			});
			if(!prefs){
				prefs=Preferences.getDefaultPreferences(id);
			}
			Preferences._allPrefs[base][id]=prefs;
		}
		return Preferences._allPrefs[base][id];
	},
	
	
	getDefaultPreferences: function(id){
		Preferences._loadExtensions();
		for(var i =0;i<Preferences._extensions.length;i++){
			if(Preferences._extensions[i].id==id){
				if (typeof Preferences._extensions[i].defaultValues === 'string'){
					var prefs= Runtime.serverJSONRequest({
						   url:Preferences._extensions[i].defaultValues, handleAs:"json", sync:true  });
					return prefs.defaultValues;
				}
				return Preferences._extensions[i].defaultValues;
			}
		}
	}
	
};
return lang.setObject("davinci.workbench.Preferences", Preferences);
});

},
'davinci/model/resource/Marker':function(){
   /**  
    * @class davinci.model.resource.Marker
      * @constructor 
    */
define([
	"dojo/_base/declare",
	"davinci/model/resource/Resource"
], function(declare, Resource) {

return declare("davinci.model.resource.Marker", Resource, {

	constructor: function(resource, type, line, text) {
		this.resource = resource;
		this.type = type;
		this.line = line;
		this.text = text;
	}

});
});
   

},
'dojox/grid/_ViewManager':function(){
define([
	"dojo/_base/declare",
	"dojo/_base/sniff",
	"dojo/dom-class"
], function(declare, has, domClass){

return declare('dojox.grid._ViewManager', null, {
	// summary:
	//		A collection of grid views. Owned by grid and used internally for managing grid views.
	// description:
	//		Grid creates views automatically based on grid's layout structure.
	//		Users should typically not need to access individual views or the views collection directly.
	constructor: function(inGrid){
		this.grid = inGrid;
	},

	defaultWidth: 200,

	views: [],

	// operations
	resize: function(){
		this.onEach("resize");
	},

	render: function(){
		this.onEach("render");
	},

	// views
	addView: function(inView){
		inView.idx = this.views.length;
		this.views.push(inView);
	},

	destroyViews: function(){
		for(var i=0, v; v=this.views[i]; i++){
			v.destroy();
		}
		this.views = [];
	},

	getContentNodes: function(){
		var nodes = [];
		for(var i=0, v; v=this.views[i]; i++){
			nodes.push(v.contentNode);
		}
		return nodes;
	},

	forEach: function(inCallback){
		for(var i=0, v; v=this.views[i]; i++){
			inCallback(v, i);
		}
	},

	onEach: function(inMethod, inArgs){
		inArgs = inArgs || [];
		for(var i=0, v; v=this.views[i]; i++){
			if(inMethod in v){
				v[inMethod].apply(v, inArgs);
			}
		}
	},

	// layout
	normalizeHeaderNodeHeight: function(){
		var rowNodes = [];
		for(var i=0, v; (v=this.views[i]); i++){
			if(v.headerContentNode.firstChild){
				rowNodes.push(v.headerContentNode);
			}
		}
		this.normalizeRowNodeHeights(rowNodes);
	},

	normalizeRowNodeHeights: function(inRowNodes){
		var h = 0;
		var currHeights = [];
		if(this.grid.rowHeight){
			h = this.grid.rowHeight;
		}else{
			if(inRowNodes.length <= 1){
				// no need to normalize if we are the only one...
				return;
			}
			for(var i=0, n; (n=inRowNodes[i]); i++){
				// We only care about the height - so don't use marginBox.  This
				// depends on the container not having any margin (which it shouldn't)
				// Also - we only look up the height if the cell doesn't have the
				// dojoxGridNonNormalizedCell class (like for row selectors)
				if(!domClass.contains(n, "dojoxGridNonNormalizedCell")){
					currHeights[i] = n.firstChild.offsetHeight;
					h =  Math.max(h, currHeights[i]);
				}
			}
			h = (h >= 0 ? h : 0);
	
			//Work around odd FF3 rendering bug: #8864.
			//A one px increase fixes FireFox 3's rounding bug for fractional font sizes.
			if((has('mozilla') || has('ie') > 8 ) && h){h++;}
		}
		for(i=0; (n=inRowNodes[i]); i++){
			if(currHeights[i] != h){
				n.firstChild.style.height = h + "px";
			}
		}
	},
	
	resetHeaderNodeHeight: function(){
		for(var i=0, v, n; (v=this.views[i]); i++){
			n = v.headerContentNode.firstChild;
			if(n){
				n.style.height = "";
			}
		}
	},

	renormalizeRow: function(inRowIndex){
		var rowNodes = [];
		for(var i=0, v, n; (v=this.views[i])&&(n=v.getRowNode(inRowIndex)); i++){
			n.firstChild.style.height = '';
			rowNodes.push(n);
		}
		this.normalizeRowNodeHeights(rowNodes);
	},

	getViewWidth: function(inIndex){
		return this.views[inIndex].getWidth() || this.defaultWidth;
	},

	// must be called after view widths are properly set or height can be miscalculated
	// if there are flex columns
	measureHeader: function(){
		// need to reset view header heights so they are properly measured.
		this.resetHeaderNodeHeight();
		this.forEach(function(inView){
			inView.headerContentNode.style.height = '';
		});
		var h = 0;
		// calculate maximum view header height
		this.forEach(function(inView){
			h = Math.max(inView.headerNode.offsetHeight, h);
		});
		return h;
	},

	measureContent: function(){
		var h = 0;
		this.forEach(function(inView){
			h = Math.max(inView.domNode.offsetHeight, h);
		});
		return h;
	},

	findClient: function(inAutoWidth){
		// try to use user defined client
		var c = this.grid.elasticView || -1;
		// attempt to find implicit client
		if(c < 0){
			for(var i=1, v; (v=this.views[i]); i++){
				if(v.viewWidth){
					for(i=1; (v=this.views[i]); i++){
						if(!v.viewWidth){
							c = i;
							break;
						}
					}
					break;
				}
			}
		}
		// client is in the middle by default
		if(c < 0){
			c = Math.floor(this.views.length / 2);
		}
		return c;
	},

	arrange: function(l, w){
		var i, v, vw, len = this.views.length, self = this;
		// find the client
		var c = (w <= 0 ? len : this.findClient());
		// layout views
		var setPosition = function(v, l){
			var ds = v.domNode.style;
			var hs = v.headerNode.style;

			if(!self.grid.isLeftToRight()){
				ds.right = l + 'px';
				// fixed rtl, the scrollbar is on the right side in FF < 4
				if(has('ff') < 4){
					hs.right = l + v.getScrollbarWidth() + 'px';
				}else{
					hs.right = l + 'px';
				}
				if(!has('webkit')){
					hs.width = parseInt(hs.width, 10) - v.getScrollbarWidth() + 'px';					
				}
			}else{
				ds.left = l + 'px';
				hs.left = l + 'px';
			}
			ds.top = 0 + 'px';
			hs.top = 0;
		};
		// for views left of the client
		//BiDi TODO: The left and right should not appear in BIDI environment. Should be replaced with
		//leading and tailing concept.
		for(i=0; (v=this.views[i])&&(i<c); i++){
			// get width
			vw = this.getViewWidth(i);
			// process boxes
			v.setSize(vw, 0);
			setPosition(v, l);
			if(v.headerContentNode && v.headerContentNode.firstChild){
				vw = v.getColumnsWidth()+v.getScrollbarWidth();
			}else{
				vw = v.domNode.offsetWidth;
			}
			// update position
			l += vw;
		}
		// next view (is the client, i++ == c)
		i++;
		// start from the right edge
		var r = w;
		// for views right of the client (iterated from the right)
		for(var j=len-1; (v=this.views[j])&&(i<=j); j--){
			// get width
			vw = this.getViewWidth(j);
			// set size
			v.setSize(vw, 0);
			// measure in pixels
			vw = v.domNode.offsetWidth;
			// update position
			r -= vw;
			// set position
			setPosition(v, r);
		}
		if(c<len){
			v = this.views[c];
			// position the client box between left and right boxes
			vw = Math.max(1, r-l);
			// set size
			v.setSize(vw + 'px', 0);
			setPosition(v, l);
		}
		return l;
	},

	// rendering
	renderRow: function(inRowIndex, inNodes, skipRenorm){
		var rowNodes = [];
		for(var i=0, v, n, rowNode; (v=this.views[i])&&(n=inNodes[i]); i++){
			rowNode = v.renderRow(inRowIndex);
			n.appendChild(rowNode);
			rowNodes.push(rowNode);
		}
		if(!skipRenorm){
			this.normalizeRowNodeHeights(rowNodes);
		}
	},
	
	rowRemoved: function(inRowIndex){
		this.onEach("rowRemoved", [ inRowIndex ]);
	},
	
	// updating
	updateRow: function(inRowIndex, skipRenorm){
		for(var i=0, v; v=this.views[i]; i++){
			v.updateRow(inRowIndex);
		}
		if(!skipRenorm){
			this.renormalizeRow(inRowIndex);
		}
	},
	
	updateRowStyles: function(inRowIndex){
		this.onEach("updateRowStyles", [ inRowIndex ]);
	},
	
	// scrolling
	setScrollTop: function(inTop){
		var top = inTop;
		for(var i=0, v; v=this.views[i]; i++){
			top = v.setScrollTop(inTop);
			// Work around IE not firing scroll events that cause header offset
			// issues to occur.
			if(has('ie') && v.headerNode && v.scrollboxNode){
				v.headerNode.scrollLeft = v.scrollboxNode.scrollLeft;
			}
		}
		return top;
		//this.onEach("setScrollTop", [ inTop ]);
	},
	
	getFirstScrollingView: function(){
		// summary:
		//		Returns the first grid view with a scroll bar
		for(var i=0, v; (v=this.views[i]); i++){
			if(v.hasHScrollbar() || v.hasVScrollbar()){
				return v;
			}
		}
		return null;
	}
});
});
},
'dijit/form/NumberTextBox':function(){
define([
	"dojo/_base/declare", // declare
	"dojo/_base/lang", // lang.hitch lang.mixin
	"dojo/number", // number._realNumberRegexp number.format number.parse number.regexp
	"./RangeBoundTextBox"
], function(declare, lang, number, RangeBoundTextBox){

	// module:
	//		dijit/form/NumberTextBox


	var NumberTextBoxMixin = declare("dijit.form.NumberTextBoxMixin", null, {
		// summary:
		//		A mixin for all number textboxes
		// tags:
		//		protected

		// Override ValidationTextBox.pattern.... we use a reg-ex generating function rather
		// than a straight regexp to deal with locale (plus formatting options too?)
		pattern: number.regexp,

		/*=====
		// constraints: NumberTextBox.__Constraints
		//		Despite the name, this parameter specifies both constraints on the input
		//		(including minimum/maximum allowed values) as well as
		//		formatting options like places (the number of digits to display after
		//		the decimal point).
		constraints: {},
		======*/

		// value: Number
		//		The value of this NumberTextBox as a Javascript Number (i.e., not a String).
		//		If the displayed value is blank, the value is NaN, and if the user types in
		//		an gibberish value (like "hello world"), the value is undefined
		//		(i.e. get('value') returns undefined).
		//
		//		Symmetrically, set('value', NaN) will clear the displayed value,
		//		whereas set('value', undefined) will have no effect.
		value: NaN,

		// editOptions: [protected] Object
		//		Properties to mix into constraints when the value is being edited.
		//		This is here because we edit the number in the format "12345", which is
		//		different than the display value (ex: "12,345")
		editOptions: { pattern: '#.######' },

		/*=====
		_formatter: function(value, options){
			// summary:
			//		_formatter() is called by format().  It's the base routine for formatting a number,
			//		as a string, for example converting 12345 into "12,345".
			// value: Number
			//		The number to be converted into a string.
			// options: number.__FormatOptions?
			//		Formatting options
			// tags:
			//		protected extension

			return "12345";		// String
		},
		 =====*/
		_formatter: number.format,

		postMixInProperties: function(){
			this.inherited(arguments);
			this._set("type", "text"); // in case type="number" was specified which messes up parse/format
		},

		_setConstraintsAttr: function(/*Object*/ constraints){
			var places = typeof constraints.places == "number"? constraints.places : 0;
			if(places){ places++; } // decimal rounding errors take away another digit of precision
			if(typeof constraints.max != "number"){
				constraints.max = 9 * Math.pow(10, 15-places);
			}
			if(typeof constraints.min != "number"){
				constraints.min = -9 * Math.pow(10, 15-places);
			}
			this.inherited(arguments, [ constraints ]);
			if(this.focusNode && this.focusNode.value && !isNaN(this.value)){
				this.set('value', this.value);
			}
		},

		_onFocus: function(){
			if(this.disabled){ return; }
			var val = this.get('value');
			if(typeof val == "number" && !isNaN(val)){
				var formattedValue = this.format(val, this.constraints);
				if(formattedValue !== undefined){
					this.textbox.value = formattedValue;
				}
			}
			this.inherited(arguments);
		},

		format: function(/*Number*/ value, /*number.__FormatOptions*/ constraints){
			// summary:
			//		Formats the value as a Number, according to constraints.
			// tags:
			//		protected

			var formattedValue = String(value);
			if(typeof value != "number"){ return formattedValue; }
			if(isNaN(value)){ return ""; }
			// check for exponential notation that dojo/number.format() chokes on
			if(!("rangeCheck" in this && this.rangeCheck(value, constraints)) && constraints.exponent !== false && /\de[-+]?\d/i.test(formattedValue)){
				return formattedValue;
			}
			if(this.editOptions && this.focused){
				constraints = lang.mixin({}, constraints, this.editOptions);
			}
			return this._formatter(value, constraints);
		},

		/*=====
		_parser: function(value, constraints){
			// summary:
			//		Parses the string value as a Number, according to constraints.
			// value: String
			//		String representing a number
			// constraints: number.__ParseOptions
			//		Formatting options
			// tags:
			//		protected

			return 123.45;		// Number
		},
		=====*/
		_parser: number.parse,

		parse: function(/*String*/ value, /*number.__FormatOptions*/ constraints){
			// summary:
			//		Replaceable function to convert a formatted string to a number value
			// tags:
			//		protected extension

			var v = this._parser(value, lang.mixin({}, constraints, (this.editOptions && this.focused) ? this.editOptions : {}));
			if(this.editOptions && this.focused && isNaN(v)){
				v = this._parser(value, constraints); // parse w/o editOptions: not technically needed but is nice for the user
			}
			return v;
		},

		_getDisplayedValueAttr: function(){
			var v = this.inherited(arguments);
			return isNaN(v) ? this.textbox.value : v;
		},

		filter: function(/*Number*/ value){
			// summary:
			//		This is called with both the display value (string), and the actual value (a number).
			//		When called with the actual value it does corrections so that '' etc. are represented as NaN.
			//		Otherwise it dispatches to the superclass's filter() method.
			//
			//		See `dijit/form/TextBox.filter()` for more details.
			return (value == null /* or undefined */ || value === '') ? NaN : this.inherited(arguments); // set('value', null||''||undefined) should fire onChange(NaN)
		},

		serialize: function(/*Number*/ value, /*Object?*/ options){
			// summary:
			//		Convert value (a Number) into a canonical string (ie, how the number literal is written in javascript/java/C/etc.)
			// tags:
			//		protected
			return (typeof value != "number" || isNaN(value)) ? '' : this.inherited(arguments);
		},

		_setBlurValue: function(){
			var val = lang.hitch(lang.mixin({}, this, { focused: true }), "get")('value'); // parse with editOptions
			this._setValueAttr(val, true);
		},

		_setValueAttr: function(/*Number*/ value, /*Boolean?*/ priorityChange, /*String?*/ formattedValue){
			// summary:
			//		Hook so set('value', ...) works.
			if(value !== undefined && formattedValue === undefined){
				formattedValue = String(value);
				if(typeof value == "number"){
					if(isNaN(value)){ formattedValue = '' }
					// check for exponential notation that number.format chokes on
					else if(("rangeCheck" in this && this.rangeCheck(value, this.constraints)) || this.constraints.exponent === false || !/\de[-+]?\d/i.test(formattedValue)){
						formattedValue = undefined; // lets format compute a real string value
					}
				}else if(!value){ // 0 processed in if branch above, ''|null|undefined flows through here
					formattedValue = '';
					value = NaN;
				}else{ // non-numeric values
					value = undefined;
				}
			}
			this.inherited(arguments, [value, priorityChange, formattedValue]);
		},

		_getValueAttr: function(){
			// summary:
			//		Hook so get('value') works.
			//		Returns Number, NaN for '', or undefined for unparseable text
			var v = this.inherited(arguments); // returns Number for all values accepted by parse() or NaN for all other displayed values

			// If the displayed value of the textbox is gibberish (ex: "hello world"), this.inherited() above
			// returns NaN; this if() branch converts the return value to undefined.
			// Returning undefined prevents user text from being overwritten when doing _setValueAttr(_getValueAttr()).
			// A blank displayed value is still returned as NaN.
			if(isNaN(v) && this.textbox.value !== ''){
				if(this.constraints.exponent !== false && /\de[-+]?\d/i.test(this.textbox.value) && (new RegExp("^"+number._realNumberRegexp(lang.mixin({}, this.constraints))+"$").test(this.textbox.value))){	// check for exponential notation that parse() rejected (erroneously?)
					var n = Number(this.textbox.value);
					return isNaN(n) ? undefined : n; // return exponential Number or undefined for random text (may not be possible to do with the above RegExp check)
				}else{
					return undefined; // gibberish
				}
			}else{
				return v; // Number or NaN for ''
			}
		},

		isValid: function(/*Boolean*/ isFocused){
			// Overrides dijit/form/RangeBoundTextBox.isValid() to check that the editing-mode value is valid since
			// it may not be formatted according to the regExp validation rules
			if(!this.focused || this._isEmpty(this.textbox.value)){
				return this.inherited(arguments);
			}else{
				var v = this.get('value');
				if(!isNaN(v) && this.rangeCheck(v, this.constraints)){
					if(this.constraints.exponent !== false && /\de[-+]?\d/i.test(this.textbox.value)){ // exponential, parse doesn't like it
						return true; // valid exponential number in range
					}else{
						return this.inherited(arguments);
					}
				}else{
					return false;
				}
			}
		}
	});

	var NumberTextBox = declare("dijit.form.NumberTextBox", [RangeBoundTextBox, NumberTextBoxMixin], {
		// summary:
		//		A TextBox for entering numbers, with formatting and range checking
		// description:
		//		NumberTextBox is a textbox for entering and displaying numbers, supporting
		//		the following main features:
		//
		//		1. Enforce minimum/maximum allowed values (as well as enforcing that the user types
		//			a number rather than a random string)
		//		2. NLS support (altering roles of comma and dot as "thousands-separator" and "decimal-point"
		//			depending on locale).
		//		3. Separate modes for editing the value and displaying it, specifically that
		//			the thousands separator character (typically comma) disappears when editing
		//			but reappears after the field is blurred.
		//		4. Formatting and constraints regarding the number of places (digits after the decimal point)
		//			allowed on input, and number of places displayed when blurred (see `constraints` parameter).

		baseClass: "dijitTextBox dijitNumberTextBox"
	});

	NumberTextBox.Mixin = NumberTextBoxMixin;	// for monkey patching

	/*=====
	 NumberTextBox.__Constraints = declare([RangeBoundTextBox.__Constraints, number.__FormatOptions, number.__ParseOptions], {
		 // summary:
		 //		Specifies both the rules on valid/invalid values (minimum, maximum,
		 //		number of required decimal places), and also formatting options for
		 //		displaying the value when the field is not focused.
		 // example:
		 //		Minimum/maximum:
		 //		To specify a field between 0 and 120:
		 //	|		{min:0,max:120}
		 //		To specify a field that must be an integer:
		 //	|		{fractional:false}
		 //		To specify a field where 0 to 3 decimal places are allowed on input:
		 //	|		{places:'0,3'}
	 });
	 =====*/

	return NumberTextBox;
});

},
'dojo/promise/all':function(){
define([
	"../_base/array",
	"../Deferred",
	"../when"
], function(array, Deferred, when){
	"use strict";

	// module:
	//		dojo/promise/all

	var some = array.some;

	return function all(objectOrArray){
		// summary:
		//		Takes multiple promises and returns a new promise that is fulfilled
		//		when all promises have been fulfilled.
		// description:
		//		Takes multiple promises and returns a new promise that is fulfilled
		//		when all promises have been fulfilled. If one of the promises is rejected,
		//		the returned promise is also rejected. Canceling the returned promise will
		//		*not* cancel any passed promises.
		// objectOrArray: Object|Array?
		//		The promise will be fulfilled with a list of results if invoked with an
		//		array, or an object of results when passed an object (using the same
		//		keys). If passed neither an object or array it is resolved with an
		//		undefined value.
		// returns: dojo/promise/Promise

		var object, array;
		if(objectOrArray instanceof Array){
			array = objectOrArray;
		}else if(objectOrArray && typeof objectOrArray === "object"){
			object = objectOrArray;
		}

		var results;
		var keyLookup = [];
		if(object){
			array = [];
			for(var key in object){
				if(Object.hasOwnProperty.call(object, key)){
					keyLookup.push(key);
					array.push(object[key]);
				}
			}
			results = {};
		}else if(array){
			results = [];
		}

		if(!array || !array.length){
			return new Deferred().resolve(results);
		}

		var deferred = new Deferred();
		deferred.promise.always(function(){
			results = keyLookup = null;
		});
		var waiting = array.length;
		some(array, function(valueOrPromise, index){
			if(!object){
				keyLookup.push(index);
			}
			when(valueOrPromise, function(value){
				if(!deferred.isFulfilled()){
					results[keyLookup[index]] = value;
					if(--waiting === 0){
						deferred.resolve(results);
					}
				}
			}, deferred.reject);
			return deferred.isFulfilled();
		});
		return deferred.promise;	// dojo/promise/Promise
	};
});

},
'dijit/form/TimeTextBox':function(){
define([
	"dojo/_base/declare", // declare
	"dojo/keys", // keys.DOWN_ARROW keys.ENTER keys.ESCAPE keys.TAB keys.UP_ARROW
	"dojo/_base/lang", // lang.hitch
	"../_TimePicker",
	"./_DateTimeTextBox"
], function(declare, keys, lang, _TimePicker, _DateTimeTextBox){

	// module:
	//		dijit/form/TimeTextBox


	/*=====
	var __Constraints = declare([_DateTimeTextBox.__Constraints, _TimePicker.__Constraints], {
	});
	=====*/

	return declare("dijit.form.TimeTextBox", _DateTimeTextBox, {
		// summary:
		//		A validating, serializable, range-bound time text box with a drop down time picker

		baseClass: "dijitTextBox dijitComboBox dijitTimeTextBox",
		popupClass: _TimePicker,
		_selector: "time",

/*=====
		// constraints: __Constraints
		constraints:{},
=====*/

		// value: Date
		//		The value of this widget as a JavaScript Date object.  Note that the date portion implies time zone and daylight savings rules.
		//
		//		Example:
		// |	new dijit/form/TimeTextBox({value: stamp.fromISOString("T12:59:59", new Date())})
		//
		//		When passed to the parser in markup, must be specified according to locale-independent
		//		`stamp.fromISOString` format.
		//
		//		Example:
		// |	<input data-dojo-type='dijit/form/TimeTextBox' value='T12:34:00'>
		value: new Date(""),		// value.toString()="NaN"
		//FIXME: in markup, you have no control over daylight savings

		_onKey: function(evt){
			if(this.disabled || this.readOnly){ return; }
			this.inherited(arguments);

			// If the user has backspaced or typed some numbers, then filter the result list
			// by what they typed.  Maybe there's a better way to detect this, like _handleOnChange()?
			switch(evt.keyCode){
				case keys.ENTER:
				case keys.TAB:
				case keys.ESCAPE:
				case keys.DOWN_ARROW:
				case keys.UP_ARROW:
					// these keys have special meaning
					break;
				default:
					// defer() because the keystroke hasn't yet appeared in the <input>,
					// so the get('displayedValue') call below won't give the result we want.
					this.defer(function(){
						// set this.filterString to the filter to apply to the drop down list;
						// it will be used in openDropDown()
						var val = this.get('displayedValue');
						this.filterString = (val && !this.parse(val, this.constraints)) ? val.toLowerCase() : "";

						// close the drop down and reopen it, in order to filter the items shown in the list
						// and also since the drop down may need to be repositioned if the number of list items has changed
						// and it's being displayed above the <input>
						if(this._opened){
							this.closeDropDown();
						}
						this.openDropDown();
					});
			}
		}
	});
});

},
'davinci/review/model/resource/Empty':function(){
define([
	"dojo/_base/declare",
	"davinci/model/resource/Resource"
], function(declare, Resource) {

return declare("davinci.review.model.resource.Empty", Resource, {

	constructor: function(args) {
		this.elementType="Folder";
		this.name="root";
		this.parent=null;
	},

	getChildren: function() {
		return this.children;
	}

});
});

},
'url:dijit/form/templates/Button.html':"<span class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><span class=\"dijitReset dijitInline dijitButtonNode\"\n\t\tdata-dojo-attach-event=\"ondijitclick:_onClick\" role=\"presentation\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode,focusNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span class=\"dijitReset dijitToggleButtonIconChar\">&#x25CF;</span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t></span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\"\n\t\ttabIndex=\"-1\" role=\"presentation\" data-dojo-attach-point=\"valueNode\"\n/></span>\n",
'davinci/ve/widget':function(){
define([
	"davinci/html/HTMLElement", //HTMLElement
	"../Runtime",
	"./metadata",
	"dojo/Deferred",
	"./DijitWidget",
	"./GenericWidget",
	"./HTMLWidget",
	"./ObjectWidget",
	"dojo/window"
], function(
	HTMLElement,
	Runtime,
	metadata,
	Deferred,
	DijitWidget,
	GenericWidget,
	HTMLWidget,
	ObjectWidget,
	dojoWindow
) {

var helperCache = {};

//Add temporary IDs to nested children
//Assumes iframe's DOM and the model are in sync regarding the order of child nodes
var childrenAddIds = function(context, node, srcElement) {
	 for (var i=0;i<srcElement.children.length; i++) {
		 var childNodeDOM = node.childNodes[i];
		 var childNodeModel = srcElement.children[i];
		 if((childNodeDOM && childNodeDOM.nodeType==1/*element*/) && childNodeModel.elementType=="HTMLElement"){ //node may have a different child count - wdr
			 childNodeDOM.id = context.getUniqueID(childNodeModel);
			 childrenAddIds(context,childNodeDOM,childNodeModel);
		 }
	 }
};

var parseNodeData = function(node, options) {
	// summary:
	// 		Same general routine as widgetObject._getData,
	// 		only adding the "html." prefix to the widget type to make it look like a widget to the Dojo Composition Tool.
	//
	if(!node){
		return undefined;
	}

	options = options || {};

	var data = {};
	data.properties = {};

	for(var i = 0; i < node.attributes.length; i++){
		var a = node.attributes[i];
		if(!a.specified || !a.nodeValue){
			continue;
		}
		var n = a.nodeName.toLowerCase();
		if(n == "id" || n == "widgetid" || n == "style"){
			continue;
		}else if(n.charAt(0) == "_"){
			continue;
		}
		var v = a.nodeValue;
		if(v && n == "class"){
			v = v.replace("HtmlWidget", "").trim();
			if(!v){
				continue;
			}
		}
//		if(options.serialize){
//			var p = properties[n];
//			if(p && p.type == "url"){
//				v = context.getContentUrl(v);
//			}
//		}
		data.properties[n] = v;
	}

	if(node.tagName.toLowerCase() == "script"){
		data.children = (node.innerHTML || undefined);
	}//else{
	//	data.children = widgetObject._getChildrenData(widget, options);
	//}
	return data;
};

var widgetObject = {
_dojo: function(node) {
	var doc = node ? (node.ownerDocument || node) : dojo.doc;
//TODO: for some reason node.ownerDocument is occasionally null
	doc=doc||dojo.doc;
	var win = dojoWindow.get(doc);
	return win.dojo || dojo;
},

_dijit: function(node) {
	var doc = node ? (node.ownerDocument || node) : dojo.doc;
	var win = dojoWindow.get(doc);
	return win.dijit || dijit;
},

//Turns text into an an array of style values
parseStyleValues: function(text) {
	var values = [];
	if(text){
		dojo.forEach(text.split(";"), function(s){
			var i = s.indexOf(":");
			if(i > 0){
				var n = s.substring(0, i).trim();
				var v = s.substring(i + 1).trim();
				var o = {};
				o[n] = v;
				values.push(o);
			}
		});
	}
	return values;
},

//Looks for a particular property within styleArray
retrieveStyleProperty: function(styleArray, propName, defaultValue){
	var propValue = defaultValue;
	if(styleArray) {
		dojo.some(styleArray, function(o){
			if(o.hasOwnProperty(propName)){
				propValue = o[propName];
				return true;
			}
		});
	}
	return propValue;
},

//sets value of a particular property in styleArray (or adds if property not found)
setStyleProperty: function(styleArray, propName, value){
	var modifiedProperty = false;
	if(styleArray) {
		dojo.some(styleArray, function(o){
			if(o.hasOwnProperty(propName)){
				o[propName] = value;
				modifiedProperty = true;
				return true;
			}
		});
	}
	if (!modifiedProperty) {
		var o = {};
		o[propName] = value;
		styleArray.push(o);
	}
},

//turn styleArray back into string
getStyleString: function(styleArray) {
	var styleStr = "";
	dojo.forEach(styleArray, function(style) {
		for (var p in style){
			if (style[p]){
				styleStr = styleStr + p +':' + style[p] + ';';
			}
		}
	});
	return styleStr;
},

/**
 * Return instance of "managed" widget which contains the given 'node'.
 *
 * @param {DOMElement | davinci.ve._Widget} node
 * 			Element for which to find enclosing "managed" widget.
 *
 * @return "managed" widget instance which contains 'node'; 'undefined' if no
 * 			such valid widget instance is found.
 * @type {davinci.ve._Widget}
 */
getEnclosingWidget: function(node) {
	var richText = widgetObject.getEnclosingWidgetForRichText(node);
	if (richText) {
		return richText;
	}
	var enc = node;
	while (enc) {
		if (enc._dvWidget) {
			return enc._dvWidget;
		}
		//        DOMElement || davinci.ve._Widget
		enc = enc.parentNode || (enc.domNode && enc.domNode.parentNode);
	}
},

getEnclosingWidgetForRichText: function(node) {
	if (!node || !node._dvWidget){ return; }
	if (node._dvWidget.type === 'html.stickynote' || node._dvWidget.type === 'html.richtext' ){
		return node._dvWidget;
	} else if (node.parentNode){
		return widgetObject.getEnclosingWidgetForRichText(node.parentNode);
	} else {
		return null;
	}
},

// used by helpers
getUniqueObjectId: function(type, node) {
	if(!type){
		return undefined;
	}

	var base = type.substring((type.lastIndexOf("/") || type.lastIndexOf(".")) + 1);
	var i = 1;
	var id = base + "_" + i++;
	var dj = widgetObject._dojo(node);
	while(dj.getObject(id) || dj.byId(id)){
		id = base + "_" + i++;
	}
	return id;
},

//FIXME: This is a hack so that meaningful names
//don't show a bunch of ugly prefix stuff.
//Need a better approach for this.
_remove_prefix: function(str){
	var returnstr = str;
	var prefixes_to_remove=[
	                	    'dijit/form/',
	                	    'dijit/layout/',
	                	    'dijit/',
	                	    'dojox/mobile/',
	                	    'html.',
	                	    'html/',
	                	    'OpenAjax.',
	                	    'OpenAjax/'];
	for(var i=0; i<prefixes_to_remove.length; i++){
		if(str.indexOf(prefixes_to_remove[i])==0){ // use ===?
			returnstr=str.substr(prefixes_to_remove[i].length);
			//FIXME: Another hack. Need a better approach for this.
			//Special case logic for HTML widgets
			if(prefixes_to_remove[i]=='html.'){
				returnstr='&lt;'+returnstr+'&gt;';
			}
			break;
		}
	}
	return returnstr;
},

_getWidgetNameText: function(type){
	var text = "<span class='propertiesTitleWidgetName'>";
	text+=this._remove_prefix(type);
	text+="</span> ";
	return text;
},

_getWidgetClassText: function(id, className){
	var text = "<span class='propertiesTitleClassName'>";
	//text += node.tagName;
	if (id) {
		text += "#" + id;
	}
	if (className) {
		text += "." + className.replace(/\s+/g,".");
	}
	text += "</span> ";
	return text;
},

/**
 * Simpler version of getLabel, called as part of review/commenting,
 * when there isn't a widget object available.
 * @param node
 * @returns string to display in Maqetta's UI
 */
getLabelForNode: function(node) {
	var type = node.getAttribute('data-dojo-type') || node.getAttribute('dojoType');
	if(!type){
		type = node.tagName.toLowerCase();
	}
	type = type.replace(/\./g, "/");
	var text = this._getWidgetNameText(type);
	//FIXME: temporarily not showing classname because mobile views look better
	// in review/commenting, but really instead of hard-coding this, we should
	// default to showing classname and allow sceneManager to override the default
	if(node.id /* || node.className*/){
		text += this._getWidgetClassText(node.id /*, node.className*/);
	}
	return text;
},

getLabel: function(widget) {
	var text = this._getWidgetNameText(widget.type);

	var widgetText,
		helper = widgetObject.getWidgetHelper(widget.type);
	if (helper && helper.getWidgetText) {
		widgetText = helper.getWidgetText(widget);
	}

	//TODO: move to getWidgetText helper methods
	var domNode = widget.domNode;
	switch(widget.type.replace(/\//g, ".")){
		case 'dijit.form.ComboBox':
		case 'dijit.form.Button':
			widgetText = widget.attr("label");
			break;
		case 'dijit.layout.ContentPane':
			widgetText = widget.attr("title");
			break;
		case 'html.label':
			widgetText = domNode.innerHTML;
			break;
		case 'html.img':
			widgetText = domNode.alt;
			if(!widgetText){
				widgetText = domNode.title;
			}
	}

	if (widgetText) {
		text += "<span class='propertiesTitleWidgetText'>" + widgetText + "</span> ";
	}

	if (helper && helper.getWidgetDescriptor) {
		text += " <span class='propertiesTitleWidgetDescriptor'>" + helper.getWidgetDescriptor(widget) + "</span> ";
	}

	/* add the class */
	var srcElement = widget._srcElement;
	var id = widget.getId();
	var classAttr = srcElement && srcElement.getAttribute("class");
	var className = classAttr && classAttr.trim();
	if (id || className) {
/*
		text += "<span class='propertiesTitleClassName'>";
		//text += node.tagName;
		if (id) {
			text += "#" + id;
		}
		if (className) {
			text += "." + className.replace(/\s+/g,".");
		}
		text += "</span> ";
*/
		text += this._getWidgetClassText(id, className);
	}

	if (helper && helper.getWidgetTextExtra) {
		text += helper.getWidgetTextExtra(widget);
	}

	//TODO: move to getWidgetTextExtra helper methods
	if (widget.type == 'html.img') {
		text += '<span>' + domNode.src.substr(domNode.src.lastIndexOf('/') + 1) + '</span>';
	}
	return text;
},

byId: function(id, doc) {
	var node=dojo.byId(id, doc && doc.body ? doc : undefined); // we're sometimes getting called with context as the second arg; don't pass it as a doc.
	if (node)
	{
		if (node._dvWidget) {
			return node._dvWidget;
		}
		var widget=widgetObject.getEnclosingWidget(node);
		if (widget.id==id) {
			return widget;
		}
	}
	if(Runtime.currentEditor && Runtime.currentEditor.currentEditor && Runtime.currentEditor.currentEditor.context){
		var context = Runtime.currentEditor.currentEditor.context;
		return context.widgetHash[id];
	}
	return undefined;
},

byNode: function(node) {
	if (node._dvWidget) {
		return node._dvWidget;
	}
//	var d = widgetObject._dijit(node);
//	var w= d.byNode(node);
//	if (w)
//	{
//		node._dvWidget=w;
//	}
//	return w;
},

/**
 * Main routine for creating a new widget on the current page canvas
 * @param {object} data  (Needs to be documented!)
 */
createWidget: function(widgetData) {
	if(!widgetData || !widgetData.type){
		return undefined;
	}
	// Some logic below changes the data.properties object. We don't want to mess up
	// other downstream logic in the product, particularly given than data
	// sometimes is a pointer to the original widget object from widgets.json.
	// For purposes of this routine, OK to do a shallow clone of data and data.properties.
	var data = dojo.mixin({}, widgetData);
	if(data.properties){
		data.properties = dojo.mixin({}, widgetData.properties);
	}
	
	var type = data.type, c, theme, dojoType,
		md = metadata.query(type);
	if (!md) {
	    return undefined;
	}

	if(data.properties){
		// ContentPane content:"" as a default is confusing ModifyCommand.  If we pass this as a default, it will
		// empty out ContentPanes anytime they're modified, so remove for now.  We could remove this property from the metadata.
		if("content" in data.properties && !data.properties.content){
			delete data.properties.content;
		}
		if(data.properties.theme){
			theme = data.properties.theme.themeName;
		}
	}
	var widgetClassId = metadata.queryDescriptor(type, "widgetClass");
	var widgetClass;
	if(widgetClassId == "object"){
		dojoType = type;
		widgetClass = ObjectWidget;
		// Temporary Hack: Required when object specifies a jsId, otherwise object is not created
		// see davinci.ve.ObjectWidget::postCreate::if(id)::var type = this.getObjectType(); (type = undefined without the following lines to add dojoType to the element attributes)
		// Drag tree onto canvas to test.
		// Berkland: Please review! (needs replacing)
		md.attributes = md.attributes || {};
		md.attributes.dojoType = dojoType;
	}else if(widgetClassId == "html"){
		widgetClass = HTMLWidget;
//	}else if(widgetClassId == "OpenAjax"){
//		widgetClassName="davinci.ve.OpenAjaxWidget";
	}else if(widgetClassId == "dijit"){
		widgetClass = DijitWidget;
	} else { // if(widgetClassId == "generic"){
		widgetClass = GenericWidget;
	}
	if(!widgetClass){
		//debugger;
		return undefined;
	}
	c = widgetClass;

	// XXX eventually replace with dojo.place()?
	// XXX Technically, there can be more than one 'content'
    var content = md.content.trim().replace(/\s+/g, ' ');
	var node = dojoWindow.get(dojo.doc).dojo._toDom(content);
	// XXX Used to create node like this, which added attributes from metadata, is there still a way to do this?
	//	var node = dojo.create(md.tagName || "div", md.attributes);

	// Check if widget content consists of more than one node
	if (node.nodeType === 11 /*DOCUMENT_FRAGMENT_NODE*/) {
	    var count = 0,
	        n = null,
	        children = node.childNodes;
	    for (var i = 0; i < children.length; i++) {
	        if (children[i].nodeType !== 8 /*COMMENT_NODE*/) {
	            count++;
	            n = children[i];
	            if (count > 1) {
	                break;
	            }
	        }
	    }
	    // XXX more than one node not supported
	    if (count > 1) {
	        console.error("ERROR: complex widget content not supported");
	        return;
	    }
        node = n;
	}

    var srcElement = new HTMLElement(node.tagName.toLowerCase());
    if (node.hasAttributes()) {
        var attrs = node.attributes;
        for (var j = attrs.length - 1; j >= 0; --j) {
            srcElement.addAttribute(attrs[j].name, attrs[j].value);
        }
    }
    if (node.innerHTML) {
        srcElement.addText(node.innerHTML);
    }

    var requiresId = metadata.queryDescriptor(type, "requiresId"),
    	name = metadata.queryDescriptor(type, "name"),
    	idRoot = requiresId && name.match(/^[A-Za-z]\w*$/) ? name : undefined;

    node.id = (data.properties && data.properties.id) || data.context.getUniqueID(srcElement, idRoot);

	var children = data.children;
	if(children){
		if(dojo.isString(children)){
			node.innerHTML = children;
			var nodeNameLC = node.nodeName.toLowerCase();
			// 'id' attribute might be temporary. Store off temporarily.
			var idattr = srcElement._getAttribute('id');
			// Temporarily add string as a text node
			srcElement.addText(children);
			// Retrieve outerHTML version, which won't include a temporary 'id' attribute
			var temp_outerHTML = srcElement.getText(data.context);
			// Black out existing children, which will unattach the textnode child inserted above
			srcElement.children = [];
			// Reparse the element
			srcElement.setText(temp_outerHTML);
			// Restore 'id' attribute.
			if(idattr){
				srcElement.addAttribute(idattr.name,idattr.value,idattr.noPersist);
			}
			// Add a temporary ID to all of the nested elements that do not have an ID
			childrenAddIds(data.context, node, srcElement);
		}else{ // Array
			dojo.forEach(children, function(c){
				if (!c){
					return;
				}
				if(dojo.isString(c)){ // Text or Comment
					if(c.length > 7 && c.substring(0, 4) == "<!--" &&
						c.substring(c.length - 3) == "-->"){
						node.appendChild(dojo.doc.createComment(c.substring(4, c.length - 3)));
						srcElement.addComment(c.substring(4, c.length - 3));
					}else{
						node.appendChild(dojo.doc.createTextNode(c));
						srcElement.addText(c);
					}
				}else{
					c.context=data.context;
                    // XXX Need to load requires on 'c' first?
					var child = widgetObject.createWidget(c);
					if(child){
						node.appendChild(child.domNode);
						srcElement.addChild(child._srcElement);
					}
				}
			});
		}
	}
	//need a helper to process the data for horizontalSlider prior to creating the widget
	// -- may be needed for other widgets with properties of dataype array
	var helper = widgetObject.getWidgetHelper(type);
	if(helper && helper.preProcessData){
        data =  helper.preProcessData(data);
	}

	// Strip out event attributes and a[href] attributes. We want them in the model
	// but not in the DOM within page canvas.
	// FIXME: should make the check for a[href] into a helper so other
	// widgets can register similar attributes
	var canvasAndModelProps = {};
	var modelOnlyProps = {};
	for (var p in data.properties) {
		var propval = data.properties[p];
		if (propval != null){ /*"!=" checks for null/undefined some properties may be false like Tree showRoot */  
			if(p.substr(0,2).toLowerCase()!="on" && !(srcElement.tag.toLowerCase()=='a' && p.toLowerCase()=='href')) { 
				canvasAndModelProps[p] = propval;
			}else{
				modelOnlyProps[p] = propval;
			}
		}
	}
	var widget = new c(canvasAndModelProps, node, type, md, srcElement, type);
	widget._srcElement=srcElement;

	if(widget.chart && (data.properties && data.properties.theme)){
		widget.chart.theme.themeName = theme;
	}

	/* this was _edit_scripts which didn't seem right */
	if(data.scripts){
		widget.scripts = data.scripts;
	}
//	var df = widgetObject.getDavinciFields(data);
//
//	dojo.mixin(widget, df);

	if(data.context) {
		widget._edit_context = data.context;
	}

	if(data.properties){	
		widget.setProperties(canvasAndModelProps);
		widget.setProperties(modelOnlyProps, true);
	}

//FIXME: Does data.states ever have a value? 
//Yes, gets called when changing 'selected' property on a View
	if(data.maqAppStates || data.maqDeltas){
		if(data.maqAppStates){
			widget.domNode._maqAppStates = dojo.clone(data.maqAppStates);
		}
		if(data.maqDeltas){
			widget.domNode._maqDeltas = dojo.clone(data.maqDeltas);
		}
		var obj = davinci.states.serialize(widget.domNode);
		if(obj.maqAppStates){	// if node has a _maqAppStates property
			widget._srcElement.addAttribute(davinci.states.APPSTATES_ATTRIBUTE, obj.maqAppStates);
		}
		if(obj.maqDeltas){	// if node has a _maqDeltas property
			widget._srcElement.addAttribute(davinci.states.DELTAS_ATTRIBUTE, obj.maqDeltas);
		}
	}
	
	// In some cases we are handling certain attributes within data-dojo-props 
	// or via child HTML elements, and we do not want to allow those attributes 
	// to be written out into the final HTML. Here, we give the helper a chance to 
	// remove those attributes.
	var helper = widgetObject.getWidgetHelper(type);
	if(helper && helper.cleanSrcElement){
		helper.cleanSrcElement(widget._srcElement);
	}
	if(helper && helper.postCreateWidget){
		helper.postCreateWidget(widget);
	}

	return widget;
},

_createSrcElement: function(node) {
	var srcElement = new HTMLElement(node.tagName.toLowerCase());
	if (node.hasAttributes()) {
	    var attrs = node.attributes;
	    for (var j = attrs.length - 1; j >= 0; --j) {
	        srcElement.addAttribute(attrs[j].name, attrs[j].value);
	    }
	}
	return srcElement;
},

// assumes the caller has already primed the cache by calling requireWidgetHelper
getWidgetHelper: function(type) {
	return helperCache[type];
},

requireWidgetHelper: function(type) {
	var d = new Deferred();
	metadata.getHelper(type, 'helper').then(function(HelperCtor) {
		if (HelperCtor) {
			d.resolve(helperCache[type] = new HelperCtor());
		} else {
			d.resolve();
		}
	});
	return d;
},

getWidget: function(node){
	if(!node || node.nodeType != 1){
		return undefined;
	}

	var widget = widgetObject.byNode(node);
	if(!widget){
		var ctor;
		var data = parseNodeData(node);
//		var oaWidgetType=node.getAttribute("oawidget");
		var dvWidgetType=node.getAttribute("dvwidget");
		if (node.hasAttribute("widgetid") || node.hasAttribute("data-dojo-type") ||
				node.hasAttribute("dojotype"))
		{
			var d = widgetObject._dijit(node);
			var w = d.byNode(node);
			var widgetType = node.getAttribute("data-dojo-type") || node.getAttribute("dojotype");
			if (w) {
				widget = new DijitWidget(data,node,w,null,null,widgetType);
			} else {
				widget = new ObjectWidget(data,node);
			}
//		}else if (oaWidgetType){
//			widget = new OpenAjaxWidget(data,node,oaWidgetType);
		}else if (dvWidgetType){
			widget = new GenericWidget(data,node,dvWidgetType);
		}else{
			if(node.nodeName == "svg"){
				//FIXME: inline SVG support not yet available
				return undefined;
			}
			widget = new HTMLWidget(data,node);
		}
	}

	return widget;
}
};

dojo.setObject("davinci.ve.widget", widgetObject); // temporary
return widgetObject;
});

},
'davinci/actions/Action':function(){
define([
	"dojo/_base/declare"
], function(declare){

return declare("davinci.actions.Action", null, {
	item:null,

	run: function(selection){
	},
	
	isEnabled: function(selection){
		return true;
	},
	
	getName: function(){
		return this.item.label;
	}

});
});

},
'davinci/ve/commands/StyleCommand':function(){
define([
    	"dojo/_base/declare",
    	"davinci/ve/widget",
    	"davinci/ve/utils/StyleArray"
    	//"davinci/ve/widget", // circular dep
    	//"davinci/ve/States" // circular dep
], function(declare, Widget, StyleArray){


return declare("davinci.ve.commands.StyleCommand", null, {

	name: "style",

	constructor: function(widget, values, applyToWhichState){
	
		this._newValues = values;
		this._id = widget ? widget.id : undefined;
		// applyToWhichState controls whether style change is attached to Normal or other states
		//   (null|undefined|"undefined"|"Normal") => apply to Normal state
		//   other string => apply to that particular state
		this._applyToStateIndex = (!applyToWhichState || applyToWhichState=='Normal' || applyToWhichState=='undefined')
									? 'undefined' : applyToWhichState;
	},

	add: function(command){
		if(!command || command._id != this._id){
			return;
		}

		if(command._newValues){
			dojo.mixin(this._newValues, command._newValues);
		}
	},
	
	execute: function(){
		if(!this._id || !this._newValues){
			return;
		}
		var widget = require("davinci/ve/widget").byId(this._id);
		if(!widget || !widget.domNode){
			return;
		}
		
		var veStates = require("davinci/ve/States");
		var styleValuesAllStates = widget.getStyleValuesAllStates();
		this._oldStyleValuesAllStates = dojo.clone(styleValuesAllStates);
		if(styleValuesAllStates[this._applyToStateIndex]){
			styleValuesAllStates[this._applyToStateIndex] = StyleArray.mergeStyleArrays(styleValuesAllStates[this._applyToStateIndex], this._newValues);
		}else{
			styleValuesAllStates[this._applyToStateIndex] = this._newValues;
		}
		
		// Remove any properties that are flagged for removal.
		var styleArrayThisState = styleValuesAllStates[this._applyToStateIndex];
		for(var i=styleArrayThisState.length-1; i>=0; i--){
			var obj = styleArrayThisState[i];
			var anyValuesLeft = false;
			for(var prop in obj){
				var value = obj[prop];
				if(value == '$MAQ_DELETE_PROPERTY$'){
					delete obj[prop];
				}else{
					anyValuesLeft = true;
				}
			}
			if(!anyValuesLeft){
				styleArrayThisState.splice(i, 1);
			}
		}
		
		widget.setStyleValuesAllStates(styleValuesAllStates);
		var currentStatesList = veStates.getStatesListCurrent(widget.domNode);
		var styleValuesCanvas = StyleArray.mergeStyleArrays([], styleValuesAllStates['undefined']);
		for(var i=0; i<currentStatesList.length; i++){
			if(styleValuesAllStates[currentStatesList[i]]){
				styleValuesCanvas = StyleArray.mergeStyleArrays(styleValuesCanvas, styleValuesAllStates[currentStatesList[i]]);
			}
		}
		widget.setStyleValuesCanvas(styleValuesCanvas);
		widget.setStyleValuesModel(styleValuesAllStates['undefined']);
		widget.refresh();
		// Recompute styling properties in case we aren't in Normal state
		veStates.resetState(widget.domNode);
				
		//FIXME: Various widget changed events (/davinci/ui/widget*Changed) need to be cleaned up.
		// I defined yet another one here (widgetPropertiesChanged) just before Preview3
		// rather than re-use or alter one of the existing widget*Changed events just before
		// the Preview 3 release to minimize risk of bad side effects, with idea we would clean up later.
		// For time being, I made payload compatible with /davinci/ui/widgetSelectionChanged. 
		// Double array is necessary because dojo.publish strips out the outer array.
		dojo.publish("/davinci/ui/widgetPropertiesChanged",[[widget]]);
	},

	undo: function(){
		if(!this._id || !this._oldStyleValuesAllStates){
			return;
		}
		var widget = require("davinci/ve/widget").byId(this._id);
		if(!widget){
			return;
		}

		var veStates = require("davinci/ve/States");
		var styleValuesAllStates = this._oldStyleValuesAllStates;
		var currentStateIndex = this._applyToStateIndex;
		widget.setStyleValuesAllStates(styleValuesAllStates);
		var styleValuesCanvas = StyleArray.mergeStyleArrays(styleValuesAllStates['undefined'], styleValuesAllStates[currentStateIndex]);
		widget.setStyleValuesCanvas(styleValuesCanvas);
		widget.setStyleValuesModel(this._oldStyleValuesAllStates['undefined']);
		
		widget.refresh();
		// Recompute styling properties in case we aren't in Normal state
		require("davinci/ve/States").resetState(widget.domNode);
		
		//FIXME: Various widget changed events (/davinci/ui/widget*Changed) need to be cleaned up.
		// I defined yet another one here (widgetPropertiesChanged) just before Preview3
		// rather than re-use or alter one of the existing widget*Changed events just before
		// the Preview 3 release to minimize risk of bad side effects, with idea we would clean up later.
		// For time being, I made payload compatible with /davinci/ui/widgetSelectionChanged. 
		// Double array is necessary because dojo.publish strips out the outer array.
		dojo.publish("/davinci/ui/widgetPropertiesChanged", [[widget]]);
	}
});
});

},
'dojox/main':function(){
define(["dojo/_base/kernel"], function(dojo) {
	// module:
	//		dojox/main

	/*=====
	return {
		// summary:
		//		The dojox package main module; dojox package is somewhat unusual in that the main module currently just provides an empty object.
		//		Apps should require modules from the dojox packages directly, rather than loading this module.
	};
	=====*/

	return dojo.dojox;
});
},
'url:davinci/ui/templates/ThemeSetsDialog.html':"<div>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<table style=\"width: 90%\">\n\t\t\t<tr>\n\t\t\t\t\t<td style=\"width:40%; vertical-align: top;\">\n\t\t\t\t\t\t\t<table> \n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td style=\" vertical-align: top;\" >\n\t\t\t\t\t\t\t\t\t\t\t\t\t<label>${uiNLS.themeSets}</label><select  id=\"theme_select_themeset_theme_select\" name=\"theme_select_themeset_theme_select\" size=\"10\" style=\"margin-bottom: 5px; width: 190px;\" ></select>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<div id=\"toolbar1\" data-dojo-type=\"dijit.Toolbar\" class=\"toolbaredContainer_toolbarDiv davinciToolbar\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<div data-dojo-type=\"dijit.form.Button\" id=\"theme_select_themeset_add\" data-dojo-props=\"iconClass:'viewActionIcon addThemeSetIcon', showLabel:false \">${uiNLS.addThemeSet}</div>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<span data-dojo-type=\"dijit.ToolbarSeparator\"></span>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<div data-dojo-type=\"dijit.form.Button\" id=\"theme_select_themeset_delete\" data-dojo-props=\"iconClass:'viewActionIcon removeThemeSetIcon', showLabel:false \">${uiNLS.deleteThemeSet}</div>\n\t\t\t\t\t\t\t\t\t\t\t\t\t </div>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t\t<td><div style=\"border-right: 1px solid #ccc; width: 1px; height: 250px; margin-left: 10px; margin-top: 10px;\"></div></td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td></td><td></td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t</td>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t\t<table style=\"width: 100%; margin-left:10px; margin-right:10px;\">\n\t\t\t\t\t\t\t\t\t<tr><td colspan=\"2\">${uiNLS.currentlySelectedThemeSet}</td><tr>\n\t\t\t\t\t\t\t\t\t<tr><td style=\"width: 18%;\">${uiNLS.themeSetName}</td><td style=\"text-align: center;\"><input dojoType=\"dijit.form.TextBox\" id=\"theme_select_themeset_theme_select_textbox\" readonly= \"true\" style=\"width: 175px;\" ></input><input type=\"button\" dojoType=\"dijit.form.Button\" id=\"theme_select_rename_button\" label=\"Rename\" style=\"margin-left: 5px;\"></td></tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t<div style=\"border-top: 1px solid; top: 231px; border-top-color: #ccc; left: 429px; width: 300px; height: 11px; margin-top: 6px; margin-left:10px;\"></div>\n\t\t\t\t\t\t\t<table style=\"margin-left: 15px; width: 100%;\">\n\t\t\t\t\t\t\t\t\t<tr><td style=\"width: 139px;\">${uiNLS.desktopTheme}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_desktop_theme_select\"type=\"text\"  style=\"width: 175px;\"  ></select></td></tr>\n\t\t\t\t\t\t\t\t\t<tr><td>${uiNLS.mobileTheme}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_mobile_theme_select\"type=\"text\"  style=\"width: 175px;\" ></select></td></tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t<table id=\"theme_select_devices_table\" style=\"margin-left:30px; border-collapse: separate; border-spacing: 0 0; width: 100%\">\n\t\t\t\t\t\t\t<tr><td style=\"width: 129px;\">${uiNLS.android}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_android_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>\n\t\t\t\t\t\t\t<tr><td>${uiNLS.blackberry}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_blackberry_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>\n\t\t\t\t\t\t\t<tr><td>${uiNLS.ipad}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_ipad_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>\n\t\t\t\t\t\t\t<tr><td>${uiNLS.iphone}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_iphone_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>\n\t\t\t\t\t\t\t<tr><td>${uiNLS.other}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_other_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>\n\t\t\t\t\t\t\t</table>\n\t\t\n\t\t\t\t\t </td>\n\t\t\t </tr>\n\t\t</table>\n\t</div>\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button dojoType=\"dijit.form.Button\" id=\"theme_select_ok_button\" label=\"${uiNLS.save}\" class=\"maqPrimaryButton\" type=\"submit\"></button>\n\t\t<button dojoType=\"dijit.form.Button\" id=\"theme_select_cancel_button\" label=\"${commonNLS.buttonCancel}\" class=\"maqSecondaryButton\"></button>\n\t</div>\n</div>\n",
'url:dijit/templates/MenuItem.html':"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon dijitMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">\n\t\t<div data-dojo-attach-point=\"arrowWrapper\" style=\"visibility: hidden\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuExpand\"/>\n\t\t\t<span class=\"dijitMenuExpandA11y\">+</span>\n\t\t</div>\n\t</td>\n</tr>\n",
'url:dijit/form/templates/CheckBox.html':"<div class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><input\n\t \t${!nameAttrSetting} type=\"${type}\" role=\"${type}\" aria-checked=\"false\" ${checkedAttrSetting}\n\t\tclass=\"dijitReset dijitCheckBoxInput\"\n\t\tdata-dojo-attach-point=\"focusNode\"\n\t \tdata-dojo-attach-event=\"onclick:_onClick\"\n/></div>\n",
'davinci/review/actions/EditVersionAction':function(){
define([
	"dojo/_base/declare",
	"./_ReviewNavigatorCommon",
	"./PublishAction",
	"../../Runtime",
	"dojox/widget/Toaster",
	"dojo/i18n!./nls/actions"
], function(declare, _ReviewNavigatorCommon, PublishAction, Runtime, Toaster, nls) {

return declare("davinci.review.actions.EditVersionAction", [_ReviewNavigatorCommon], {

	run: function(context) {
		var selection = this._getSelection(context);
		if(!selection || !selection.length) return;
		var item = selection[0].resource.elementType=="ReviewFile"?selection[0].resource.parent:selection[0].resource;
		var action = new PublishAction(item);
		action.run();
	},

	isEnabled: function(context) {
		var selection = this._getSelection(context);
		if (selection && selection.length > 0) {
			var item = selection[0].resource.elementType=="ReviewFile"?selection[0].resource.parent:selection[0].resource;
			if (item.designerId == Runtime.userName) { 
				//Only enable if the current user is also the review's designer
				return true;
			}
		} 
		return false;
	}
});
});
},
'davinci/review/model/resource/File':function(){
define([
	"dojo/_base/declare",
	"davinci/Runtime",
	"davinci/model/resource/File",
	"davinci/model/Path",
	"dojo/Deferred"
], function(declare, Runtime, File, Path, Deferred) {

return declare("davinci.review.model.resource.File", File, {

	constructor: function(name, parent) {
		this.elementType = "ReviewFile";
		this.name = name;
		this.parent = parent;
		this.extension = "rev";
	},

	getLabel: function() {
		var path = new Path(this.name);
		var segments = path.getSegments();
		var editorExtension = Runtime.getExtension("davinci.editor", function (extension){
			return extension.id === "davinci.review.CommentReviewEditor";
		});
		var extension = "."+editorExtension.extensions;
		return label = segments[segments.length-1] + extension;
	},

	getContentSync: function() {
		return "";
	},

	getContent: function() {
		return new Deferred().resolve("");
	},

	removeWorkingCopy: function() {
		return;
	}

});
});

},
'davinci/commands/CommandStack':function(){
define([
	    "dojo/_base/declare"
], function(declare){
	
return declare("davinci.commands.CommandStack", null, {
	// summary:
//	A history of commands that have occurred that keeps track of undo and redo history.

	constructor: function(context){
		this._context = context;
		this._undoStack = [];
		this._redoStack = [];
	},

	execute: function(command){
		// summary:
		//		Runs the specified command, records the execution state in the undo history, and clears the redo buffer.
		if(!command){
			return;
		}

		var quietExecute;
		if (this._context && this._context.declaredClass != 'davinci.ve.themeEditor.Context') {
			// changing doc root causes problems with Style palette  
			quietExecute = dojo.withDoc(this._context.getDocument(), "execute", command, [this._context]);
		} else {
			quietExecute = command.execute();
		}
		this._undoStack.push(command);
		this._redoStack = [];

		if (!quietExecute) {
			this.onExecute(command, "execute");			
		}
	},

	undo: function(){
		// summary:
		//		Undoes the last executed command, and records the undone command state in the redo history.
		if(!this.canUndo()){
			return;
		}

		var command = this._undoStack.pop();
		if (command._runDelegate) {
			command._runDelegate.undoDelegate(command);
		} else {
			if (this._context && this._context.declaredClass != 'davinci.ve.themeEditor.Context') {
			 //changing doc root causes problems with Style palette 
				dojo.withDoc(this._context.getDocument(), "undo", command);
			} else {
			  command.undo();
			}
		}
		this._redoStack.push(command);

		this.onExecute(command, "undo");
	},

	redo: function(){
		// summary:
		//		Redo any commands that have been undone (most recently undone first).
		if(!this.canRedo()){
			return;
		}

		var command = this._redoStack.pop();
		if (command._runDelegate) {
			command._runDelegate.redoDelegate(command);
		} else {
			if (this._context && this._context.declaredClass != 'davinci.ve.themeEditor.Context') {
				// changing doc root causes problems with Style palette 
				dojo.withDoc(this._context.getDocument(), "execute", command);
			} else {
			  command.execute();
			}
		}

		this._undoStack.push(command);

		this.onExecute(command, "redo");
	},

	canUndo: function(){
		// summary:
		//		Returns true if there are any commands that have been executed that can be undone, false otherwise
		return this._undoStack.length > 0;
	},

	canRedo: function(){
		// summary:
		//		Returns true if there are any commands that have been undone that can be redone, false otherwise.
		return this._redoStack.length > 0;
	},

	getUndoCount: function(){
		// summary:
		//		Returns how many commands are in the undo stack.
		return this._undoStack.length;
	},

	getRedoCount: function(){
		// summary:
		//		Returns how many commands are in the redo stack.
		return this._redoStack.length;
	},

	clear: function(){
		// summary:
		//		Clears the undo and redo stacks.
		this._undoStack = [];
		this._redoStack = [];
	},
	
	jump: function(point, silent){
		var undoCount = this.getUndoCount();
		var redoCount = this.getRedoCount();
		if(point == undoCount){
			return point; // nothing to do
		}
		if(point < 0 || point > undoCount + redoCount){
			return -1; // invalid point
		}

		var n = point - undoCount;
		if(silent){
			// when called with "silent" true, no command is executed/undone
			// the caller is responsible to set content
			if(n < 0){
				while(n < 0){
					this._redoStack.push(this._undoStack.pop());
					n++;
				}
			}else{
				while(n > 0){
					this._undoStack.push(this._redoStack.pop());
					n--;
				}
			}
		}else{
			if(n < 0){
				while(n < 0){
					this.undo();
					n++;
				}
			}else{
				while(n > 0){
					this.redo();
					n--;
				}
			}
		}
		return point;
	},

	onExecute: function(command, reason){
	},

	undoDelegate: function(command) {
	},

	redoDelegate: function(command) {
	}
});
});


},
'davinci/ui/ThemeSetsDialog':function(){
define(["dojo/_base/declare",
				"davinci/ui/Dialog",
    		"dijit/_Widget",
    		"dijit/_Templated",
        "davinci/workbench/Preferences",
        "davinci/Workbench",
        "davinci/library",
        "dojo/text!./templates/ThemeSetsDialog.html",
        "dojo/text!./templates/ThemeSetsRenameDialog.html",
        "dojo/i18n!davinci/ui/nls/ui",
        "dojo/i18n!dijit/nls/common",
        "davinci/Theme",
        "dijit/form/ValidationTextBox",
        "dijit/form/Button",
        "dijit/Toolbar"
        
],function(declare, Dialog, _Widget, _Templated, Preferences, Workbench, Library, templateString, renameTemplateString, uiNLS, commonNLS, Theme){
	declare("davinci.ui.ThemeSetsDialogWidget", [_Widget, _Templated], {
		templateString: templateString,
		widgetsInTemplate: true,

		uiNLS: uiNLS,
		commonNLS: commonNLS
	});

	declare("davinci.ui.ThemeSetsDialogRenameWidget", [_Widget, _Templated], {
		templateString: renameTemplateString,
		widgetsInTemplate: true,

		uiNLS: uiNLS,
		commonNLS: commonNLS
	});

	return dojo.declare("davinci.ui.ThemeSetsDialog",   null, {
	    
	    constructor : function(){
	        this._connections = [];
	        this._dialog = new Dialog({
	            id: "manageThemeSets",
	            title: uiNLS.themeSetsDialog,
	            contentStyle: {width: 580}
	        });
	        dojo.connect(this._dialog, "onCancel", this, "onClose");
	        this._dojoThemeSets = Theme.getThemeSets( Workbench.getProject());
	        if (!this._dojoThemeSets){ 
	            this._dojoThemeSets =  Theme.dojoThemeSets;
	            Theme.saveThemeSets( Workbench.getProject(), this._dojoThemeSets);
	            
	        }
	        if (!this._dojoThemeSets.themeSets[0]) {
	            this._dojoThemeSets.themeSets.push(dojo.clone(Theme.custom_themeset));
	            Theme.saveThemeSets( Workbench.getProject(), this._dojoThemeSets);
	        }
	        this._dojoThemeSets = dojo.clone(this._dojoThemeSets); // make a copy so we won't effect the real object
	        
	        this._dialog.attr("content", new davinci.ui.ThemeSetsDialogWidget({}));
	        this._connections.push(dojo.connect(dojo.byId('theme_select_themeset_theme_select'), "onchange", this, "onChange"));
	        this._connections.push(dojo.connect(dijit.byId('theme_select_themeset_add'), "onClick", this, "addThemeSet"));
	        this._connections.push(dojo.connect(dijit.byId('theme_select_themeset_delete'), "onClick", this, "deleteThemeSet"));
	        this._connections.push(dojo.connect(dijit.byId('theme_select_rename_button'), "onClick", this, "renameThemeSet"));
	        this._connections.push(dojo.connect(dijit.byId('theme_select_desktop_theme_select'), "onChange", this, "onDesktopChange"));
	        this._connections.push(dojo.connect(dijit.byId('theme_select_mobile_theme_select'), "onChange", this, "onMobileChange"));
	        this._connections.push(dojo.connect(dijit.byId('theme_select_ok_button'), "_onSubmit", this, "onOk"));
	        this._connections.push(dojo.connect(dijit.byId('theme_select_cancel_button'), "onClick", this, "onClose"));
	        
	        this._connections.push(dojo.connect(dijit.byId('theme_select_android_select'), "onChange", this, "onAndroidThemeChange"));
	        this._connections.push(dojo.connect(dijit.byId('theme_select_blackberry_select'), "onChange", this, "onBlackberryThemeChange"));
	        this._connections.push(dojo.connect(dijit.byId('theme_select_ipad_select'), "onChange", this, "oniPadThemeChange"));
	        this._connections.push(dojo.connect(dijit.byId('theme_select_iphone_select'), "onChange", this, "oniPhoneThemeChange"));
	        this._connections.push(dojo.connect(dijit.byId('theme_select_other_select'), "onChange", this, "onOtherThemeChange"));
	        
	        this.addThemeSets();
	        this._selectedThemeSet = this._dojoThemeSets.themeSets[0];
	        dijit.byId('theme_select_themeset_theme_select_textbox').attr('value',this._selectedThemeSet.name);
	        this.addThemes(this._selectedThemeSet);
	        this._dialog.show();
	  
	    },
	    
	    addThemeSets: function(){

	       
	        var select = dojo.byId('theme_select_themeset_theme_select');
	        for (var i = 0; i < this._dojoThemeSets.themeSets.length; i++){
	            var c = dojo.doc.createElement('option');
	            c.innerHTML = this._dojoThemeSets.themeSets[i].name;
	            c.value = this._dojoThemeSets.themeSets[i].name;
	            if (i === 0 ) {
	                c.selected = '1';
	            }
	            select.appendChild(c);
	        }
	        
	    },
	    
	    addThemes: function(themeSet){

	        this._themeData = Library.getThemes(Workbench.getProject(), this.workspaceOnly); 
	        var dtSelect = dijit.byId('theme_select_desktop_theme_select');
	        dtSelect.options = [];
	        var androidSelect = dijit.byId('theme_select_android_select');
	        androidSelect.options = [];
	        var blackberrySelect = dijit.byId('theme_select_blackberry_select');
	        blackberrySelect.options = [];
	        var ipadSelect = dijit.byId('theme_select_ipad_select');
	        ipadSelect.options = [];
	        var iphoneSelect = dijit.byId('theme_select_iphone_select');
	        iphoneSelect.options = [];
	        var otherSelect = dijit.byId('theme_select_other_select');
	        otherSelect.options = [];
	        var mblSelect = dijit.byId('theme_select_mobile_theme_select');
	        dtSelect.options = [];
	        mblSelect.options = [];
	        mblSelect.addOption({value: Theme.default_theme, label: Theme.default_theme});
	        this._themeCount = this._themeData.length;
	        for (var i = 0; i < this._themeData.length; i++){
	            var opt = {value: this._themeData[i].name, label: this._themeData[i].name};
	            if (this._themeData[i].type === 'dojox.mobile'){
	                mblSelect.addOption(opt);
	                androidSelect.addOption(opt);
	                blackberrySelect.addOption(opt);
	                ipadSelect.addOption(opt);
	                iphoneSelect.addOption(opt);
	                otherSelect.addOption(opt);
	            } else {
	                dtSelect.addOption(opt);
	            }
	            
	        }
	        dtSelect.attr( 'value', themeSet.desktopTheme);
	        for (var d = 0; d < themeSet.mobileTheme.length; d++){
	            var device = themeSet.mobileTheme[d].device.toLowerCase(); 
	            switch (device) {
	            case 'android':
	                androidSelect.attr( 'value', themeSet.mobileTheme[d].theme);
	                break;
	            case 'blackberry':
	                blackberrySelect.attr( 'value', themeSet.mobileTheme[d].theme);
	                break;
	            case 'ipad':
	                ipadSelect.attr( 'value', themeSet.mobileTheme[d].theme);
	                break;
	            case 'iphone':
	                iphoneSelect.attr( 'value', themeSet.mobileTheme[d].theme);
	                break;
	            case 'other':
	                otherSelect.attr( 'value', themeSet.mobileTheme[d].theme);
	                break;
	            }
	        }
	        if (Theme.singleMobileTheme(themeSet)) {
	            mblSelect.attr( 'value', themeSet.mobileTheme[themeSet.mobileTheme.length-1].theme);
	        } else {
	            mblSelect.attr( 'value', Theme.default_theme); 
	            this.onMobileChange(Theme.default_theme); //force refresh
	        }
	        
	    },
	    
	    addThemeSet: function(e) {
	        var newThemeSet;
	        if (this._selectedThemeSet) {
	            newThemeSet = dojo.clone(this._selectedThemeSet);
	        } else {
	            newThemeSet = dojo.clone(Theme.default_themeset);
	        }

	        var newThemeSetName = newThemeSet.name;
	        // make sure the name is unique
	        var nameIndex = 0;
	        for (var n = 0; n < this._dojoThemeSets.themeSets.length; n++){
	            if (this._dojoThemeSets.themeSets[n].name == newThemeSetName){
	                nameIndex++;
	                newThemeSetName = newThemeSet.name + '_' + nameIndex;
	                n = -1; // start search a first theme set with new name
	            }
	        }
	        newThemeSet.name = newThemeSetName;
	        this._dojoThemeSets.themeSets.push(newThemeSet);
	        var select = dojo.byId('theme_select_themeset_theme_select');
	        var c = dojo.doc.createElement('option');
	        c.innerHTML = newThemeSet.name;
	        c.value = newThemeSet.name;
	        select.appendChild(c);
	        
	    },
	    
	    deleteThemeSet: function(e) {
	        var select = dojo.byId('theme_select_themeset_theme_select');
	        var node = select[select.selectedIndex];
	        if (!node) {
	        	return;
	        }
	        for (var n = 0; n < this._dojoThemeSets.themeSets.length; n++){
	            if (this._dojoThemeSets.themeSets[n].name == node.value){
	                this._dojoThemeSets.themeSets.splice(n, 1);
	                break;
	            }
	        }
	        this._selectedThemeSet = null;
	        select.removeChild(node);
	        dijit.byId('theme_select_themeset_theme_select_textbox').attr('value','');
	        var renameButton = dijit.byId('theme_select_rename_button');
	        var desktopSelect = dijit.byId('theme_select_desktop_theme_select');
	        var mobileSelect = dijit.byId('theme_select_mobile_theme_select');
	        var androidSelect = dijit.byId('theme_select_android_select');
	        var blackberrySelect = dijit.byId('theme_select_blackberry_select');
	        var ipadSelect = dijit.byId('theme_select_ipad_select');
	        var iphoneSelect = dijit.byId('theme_select_iphone_select');
	        var otherSelect = dijit.byId('theme_select_other_select');
	        renameButton.set('disabled', true);
	        desktopSelect.set('disabled', true);
	        mobileSelect.set('disabled', true);
	        androidSelect.set('disabled', true);
            blackberrySelect.set('disabled', true);
            ipadSelect.set('disabled', true);
            iphoneSelect.set('disabled', true);
            otherSelect.set('disabled', true);
	        
	        
	    },
	    
	    renameThemeSet: function(e) {
	        
	        var langObj = uiNLS;
	        var loc = commonNLS;
	        var select = dojo.byId('theme_select_themeset_theme_select');
	        this._renameDialog = new Dialog({
	            id: "rename",
	            title: langObj.renameThemeSet,
	            contentStyle: {width: 300},
	            content: new davinci.ui.ThemeSetsDialogRenameWidget({})
	        });
	        this._renameDialog._themesetConnections = [];
	        this._renameDialog._themesetConnections.push(dojo.connect(dijit.byId('theme_set_rename_ok_button'), "onClick", this, "onOkRename"));
	        this._renameDialog._themesetConnections.push(dojo.connect(dijit.byId('theme_set_rename_cancel_button'), "onClick", this, "onCloseRename"));
	        this._renameDialog._themesetConnections.push(dojo.connect(this._renameDialog, "onCancel", this, "onCloseRename"));
	        this._renameDialog.show();
	        var editBox = dijit.byId('theme_select_themeset_rename_textbox');
	        editBox.attr('value', this._selectedThemeSet.name);
	        dijit.selectInputText(editBox);
	         
	    },
	    
	    onOkRename: function(e) {
	        
	        var newName = dijit.byId('theme_select_themeset_rename_textbox').attr('value');
	        if (newName) {
	            for (var n = 0; n < this._dojoThemeSets.themeSets.length; n++){
	                if (this._dojoThemeSets.themeSets[n].name == newName){
	                    alert('Theme set name already use');
	                    return;
	                }
	            }
	            var select = dojo.byId('theme_select_themeset_theme_select');
	            var node = select[select.selectedIndex];
	            var oldName = this._selectedThemeSet.name;
	            node.innerHTML = newName;
	            node.value = newName;
	            this._selectedThemeSet.name = newName;
	            dijit.byId('theme_select_themeset_theme_select_textbox').attr('value',this._selectedThemeSet.name);
	        }
	        
	        this.onCloseRename(e);
	    },
	    
	    onCloseRename: function(e) {
	    	
	        while (connection = this._renameDialog._themesetConnections.pop()){
	            dojo.disconnect(connection);
	        }
	        this._renameDialog.destroyDescendants();
	        this._renameDialog.destroy();
	        delete this._renameDialog;
	    },
	    
	    onClick: function(e) {
	        e.target.setAttribute('selected', false);
	        var select = dojo.byId('theme_select_themeset_theme_select');
	        select.setAttribute( 'value', this._selectedThemeSet.name);
	    },
	    
	    onChange : function(e){

	        var name = e.target[e.target.selectedIndex].value;
	        for (var i = 0; i < this._dojoThemeSets.themeSets.length; i++){
	            if (this._dojoThemeSets.themeSets[i].name == name) {
	            	this._selectedThemeSet = this._dojoThemeSets.themeSets[i];
	                this.addThemes(this._dojoThemeSets.themeSets[i]);
	                dijit.byId('theme_select_themeset_theme_select_textbox').attr('value',this._selectedThemeSet.name);
	                var renameButton = dijit.byId('theme_select_rename_button');
	    	        var desktopSelect = dijit.byId('theme_select_desktop_theme_select');
	    	        var mobileSelect = dijit.byId('theme_select_mobile_theme_select');
	                renameButton.set('disabled', false);
	                desktopSelect.set('disabled', false);
	                mobileSelect.set('disabled', false);
	                break;
	            }
	         
	        }
	        
	    },
	    
	    onDesktopChange : function(e){
	  
	        this._selectedThemeSet.desktopTheme = e;
	               
	    },
	    
	    onMobileChange : function(e){
	        
	        var androidSelect = dijit.byId('theme_select_android_select');
	        var blackberrySelect = dijit.byId('theme_select_blackberry_select');
	        var ipadSelect = dijit.byId('theme_select_ipad_select');
	        var iphoneSelect = dijit.byId('theme_select_iphone_select');
	        var otherSelect = dijit.byId('theme_select_other_select');
	        
	        function setDeviceSelect(device, value, disabled){
	        	 switch (device) {
	                case 'android':
	                    androidSelect.attr( 'value', value);
	                    androidSelect.set('disabled', disabled);
	                    break;
	                case 'blackberry':
	                    blackberrySelect.attr( 'value', value);
	                    blackberrySelect.set('disabled', disabled);
	                    break;
	                case 'ipad':
	                    ipadSelect.attr( 'value', value);
	                    ipadSelect.set('disabled', disabled);
	                    break;
	                case 'iphone':
	                    iphoneSelect.attr( 'value', value);
	                    iphoneSelect.set('disabled', disabled);
	                    break;
	                case 'other':
	                    otherSelect.attr( 'value', value);
	                    otherSelect.set('disabled', disabled);
	                    break;
	                }
	        }
	        
	        if ((e === '(device-specific)') ) {
	            for (var d = 0; d < this._selectedThemeSet.mobileTheme.length; d++){
	                var device = this._selectedThemeSet.mobileTheme[d].device.toLowerCase(); 
	                setDeviceSelect(device, this._selectedThemeSet.mobileTheme[d].theme, false);
	            }
	        } else {
	            for (var d = 0; d < this._selectedThemeSet.mobileTheme.length; d++){
	                var device = this._selectedThemeSet.mobileTheme[d].device.toLowerCase(); 
	                this._selectedThemeSet.mobileTheme[d].theme = e;
	                setDeviceSelect(device, this._selectedThemeSet.mobileTheme[d].theme, true);
	            }
	        }
	   
	        
	    },
	    
	    onDeviceThemeChange: function(device, e){
	        for (var d = 0; d < this._selectedThemeSet.mobileTheme.length; d++){
	            if (this._selectedThemeSet.mobileTheme[d].device.toLowerCase() === device.toLowerCase()){
	                this._selectedThemeSet.mobileTheme[d].theme = e;
	                break;
	            }
	        }
	    },
	    
	    onAndroidThemeChange: function(e){
	        this.onDeviceThemeChange('android', e);
	    },
	    
	    onBlackberryThemeChange: function(e){
	        this.onDeviceThemeChange('blackberry', e);
	    },
	    
	    oniPadThemeChange: function(e){
	        this.onDeviceThemeChange('ipad', e);
	    },
	    
	    oniPhoneThemeChange: function(e){
	        this.onDeviceThemeChange('iphone', e);
	    },
	    
	    onOtherThemeChange: function(e){
	        this.onDeviceThemeChange('other', e);
	    },
	    
	       
	     onOk: function(e){

	         Theme.saveThemeSets( Workbench.getProject(), this._dojoThemeSets);
	         this.onClose(e);

	     },
	     
	     onClose: function(e){

	         while (connection = this._connections.pop()){
	             dojo.disconnect(connection);
	         }
	         this._dialog.destroyDescendants();
	         this._dialog.destroy();
	         delete this._dialog;
	     },
	     
	      
	     onDeleteThemeSet: function(e){

	        for (var i = 0; i < this._dojoThemeSets.themeSets.length; i++){
	            if (this._dojoThemeSets.themeSets[i].name === this._currentThemeSet.name){
	                var themeName = this._dojoThemeSets.themeSets[i-1].name;
	                var cb = dijit.byId('theme_select');
	                cb.store.fetchItemByIdentity({
	                    identity: this._dojoThemeSets.themeSets[i].name,
	                    onItem: function(item){
	                        cb.store.deleteItem(item);
	                        cb.store.save();
	                    }
	                });
	                this._dojoThemeSets.themeSets.splice(i,1); // removes the theme set from the array 
	                this._currentThemeSet = null;
	                cb.attr( 'value', themeName); 
	                break;
	            }
	           
	        }
	        
	    }
	});
	
});



},
'davinci/ui/widgets/ThemeSelection':function(){
define(["dojo/_base/declare",
        "dijit/_Widget",
        "davinci/library",
        "davinci/Runtime",
        "davinci/Workbench",
        "system/resource",
        "dojo/i18n!davinci/ui/nls/ui",
        "dojo/i18n!dijit/nls/common"
  ],function(declare, _Widget, Library,Runtime, Workbench, Resource,uiNLS, commonNLS){
	return declare("davinci.ui.widgets.ThemeSelection", [_Widget], {
	    
	    workspaceOnly : true,
	    message: 'Theme version does not match workspace version this could produce unexpected results. We suggest recreating the custom theme using the current version of Maqetta and deleting the existing theme.',
	    
	    /* setup basic DOM */
	    buildRendering: function(){
	        var div = dojo.doc.createElement("div");
	        this._select = dojo.doc.createElement("select");
	        div.appendChild(this._select);
	        this._warnDiv = dojo.doc.createElement("div");
	        div.appendChild(this._warnDiv);
	        this.domNode = div;
	        dojo.style(this._select, "width","180px");
	        dojo.style(this.domNode, "width","100%");
	        dojo.connect(this._select, "onchange", this, "_onChange");
	    },
	
	    /* populate the theme selection, depends on the "workspaceOnly" attribute being set post create */
	    postCreate : function(){
	    	
	        this._themeData = Library.getThemes(Workbench.getProject(), this.workspaceOnly);
	        this._themeCount = this._themeData.length;
	        for (var i = 0; i < this._themeData.length; i++){
	            var op = dojo.doc.createElement("option");
	            op.value =this._themeData[i].name;
	            op.text = this._themeData[i].name;
	            this._select.appendChild(op);
	            
	        }
	        if(this._selection)
	            this._selectValue(this._selection);
	    },
	    
	    _setBaseAttr : function(base){
	        this._base = base;
	    },
	    
	    _getBaseAttr : function(){
	        return this._base;
	    },
	    
	    _getNumberOfThemesAttr : function(){
	        return this._themeCount;
	    },
	    
	    _setValueAttr : function(value){

	    	if(!this._hasValue(value)) return;
	    	
	        this._selection = value;
	        if(value && value.name){
	            this._selection = value.name; 
	        }
	        this._selectValue(this._selection);
	    },
	    
	    _hasValue : function(themeName){
	        
	        for(var i=0;i<this._select.children.length;i++){
	            if(this._select.children[i].value==themeName){
	                return true;
	            }
	        }
	        return false;
	    },
	    
	    _selectValue : function(value){
	        
	        var found = false;
	        for(var i=0;i<this._select.children.length;i++){
	            if(this._select.children[i].selected)
	                this._select.children[i].selected = false;
	            
	            if(!found && this._select.children[i].value==value){
	                this._select.children[i].selected = true;
	                var found = true;
	            }
	        }
	        
	        if(!found && value!=null){
	            var op = dojo.doc.createElement("option");
	            op.value = value;
	            op.text = value;
	            op.selected = true;
	            this._select.appendChild(op);   
	        }
	    },
	    _getValueAttr : function(){
	        var name = dojo.attr(this._select, "value");
	        
	        for(var i=0;i<this._themeData.length;i++){
	            if(this._themeData[i]['name'] == name )
	                return this._themeData[i];
	            
	        }
	            
	        return null;
	    },
	    
	    _setWorkspaceOnlyAttr : function(value){
	        this.workspaceOnly = value;
	    },
	    
	    onChange : function(){
	        
	    },
	    
	    _onChange :function(){
	        
	        var currentValue = this._getValueAttr();
	        if( currentValue==null  ||  this._blockChange)
	            return;
	        this.value = currentValue;
	        this._cookieName = 'maqetta_'+currentValue.name+'_'+currentValue.version;
	        var warnCookie = dojo.cookie(this._cookieName);
	        if (this.dojoVersion && currentValue.version !== this.dojoVersion && !warnCookie){
	            this._warnDiv.innerHTML = '<table>' + 
	                                            '<tr><td></td><td>'+this.message+'</td><td></td></tr>'+
	                                             '<tr><td></td><td align="center"><button data-dojo-type="dijit.form.Button" type="button" id="davinci.ui.widgets.ThemeSelection.ok">Ok</button><button data-dojo-type="dijit.form.Button" type="button" id="davinci.ui.widgets.ThemeSelection.cancel">Cancel</button></td><td></td></tr>'+
	                                       '</table>';
	            var ok = dijit.byId('davinci.ui.widgets.ThemeSelection.ok');
	            var cancel = dijit.byId('davinci.ui.widgets.ThemeSelection.cancel');
	            dojo.connect(ok, "onClick", this, "_warnOk");
	            dojo.connect(cancel, "onClick", this, "_warnCancel");
	            
	            
	        } else {
	            this.onChange();
	        }
	        
	        
	        
	    },
	    _getThemeDataAttr : function(){
	        return this._themeData;
	    },
	    
	    _warnOk: function(){
	        dojo.cookie(this._cookieName, "true");
	        this._destroy();
	        this.onChange();
	        
	    },
	    
	    _warnCancel: function(){
	        this._destroy();
	        this.onClose();
	        
	    },
	    
	    _destroy: function(){
	        var ok = dijit.byId('davinci.ui.widgets.ThemeSelection.ok');
	        dojo.disconnect(ok);
	        ok.destroy();
	        var cancel = dijit.byId('davinci.ui.widgets.ThemeSelection.cancel');
	        dojo.disconnect(cancel);
	        cancel.destroy();
	    }
	    
	    
	});

});
},
'dijit/Tooltip':function(){
define([
	"dojo/_base/array", // array.forEach array.indexOf array.map
	"dojo/_base/declare", // declare
	"dojo/_base/fx", // fx.fadeIn fx.fadeOut
	"dojo/dom", // dom.byId
	"dojo/dom-class", // domClass.add
	"dojo/dom-geometry", // domGeometry.position
	"dojo/dom-style", // domStyle.set, domStyle.get
	"dojo/_base/lang", // lang.hitch lang.isArrayLike
	"dojo/mouse",
	"dojo/on",
	"dojo/sniff", // has("ie")
	"./_base/manager",	// manager.defaultDuration
	"./place",
	"./_Widget",
	"./_TemplatedMixin",
	"./BackgroundIframe",
	"dojo/text!./templates/Tooltip.html",
	"./main"		// sets dijit.showTooltip etc. for back-compat
], function(array, declare, fx, dom, domClass, domGeometry, domStyle, lang, mouse, on, has,
			manager, place, _Widget, _TemplatedMixin, BackgroundIframe, template, dijit){

	// module:
	//		dijit/Tooltip


	// TODO: Tooltip should really share more positioning code with TooltipDialog, like:
	//		- the orient() method
	//		- the connector positioning code in show()
	//		- the dijitTooltip[Dialog] class
	//
	// The problem is that Tooltip's implementation supplies it's own <iframe> and interacts directly
	// with dijit/place, rather than going through dijit/popup like TooltipDialog and other popups (ex: Menu).

	var MasterTooltip = declare("dijit._MasterTooltip", [_Widget, _TemplatedMixin], {
		// summary:
		//		Internal widget that holds the actual tooltip markup,
		//		which occurs once per page.
		//		Called by Tooltip widgets which are just containers to hold
		//		the markup
		// tags:
		//		protected

		// duration: Integer
		//		Milliseconds to fade in/fade out
		duration: manager.defaultDuration,

		templateString: template,

		postCreate: function(){
			this.ownerDocumentBody.appendChild(this.domNode);

			this.bgIframe = new BackgroundIframe(this.domNode);

			// Setup fade-in and fade-out functions.
			this.fadeIn = fx.fadeIn({ node: this.domNode, duration: this.duration, onEnd: lang.hitch(this, "_onShow") });
			this.fadeOut = fx.fadeOut({ node: this.domNode, duration: this.duration, onEnd: lang.hitch(this, "_onHide") });
		},

		show: function(innerHTML, aroundNode, position, rtl, textDir){
			// summary:
			//		Display tooltip w/specified contents to right of specified node
			//		(To left if there's no space on the right, or if rtl == true)
			// innerHTML: String
			//		Contents of the tooltip
			// aroundNode: DomNode|dijit/place.__Rectangle
			//		Specifies that tooltip should be next to this node / area
			// position: String[]?
			//		List of positions to try to position tooltip (ex: ["right", "above"])
			// rtl: Boolean?
			//		Corresponds to `WidgetBase.dir` attribute, where false means "ltr" and true
			//		means "rtl"; specifies GUI direction, not text direction.
			// textDir: String?
			//		Corresponds to `WidgetBase.textdir` attribute; specifies direction of text.


			if(this.aroundNode && this.aroundNode === aroundNode && this.containerNode.innerHTML == innerHTML){
				return;
			}

			if(this.fadeOut.status() == "playing"){
				// previous tooltip is being hidden; wait until the hide completes then show new one
				this._onDeck=arguments;
				return;
			}
			this.containerNode.innerHTML=innerHTML;

			if(textDir){
				this.set("textDir", textDir);
			}

			this.containerNode.align = rtl? "right" : "left"; //fix the text alignment

			var pos = place.around(this.domNode, aroundNode,
				position && position.length ? position : Tooltip.defaultPosition, !rtl, lang.hitch(this, "orient"));

			// Position the tooltip connector for middle alignment.
			// This could not have been done in orient() since the tooltip wasn't positioned at that time.
			var aroundNodeCoords = pos.aroundNodePos;
			if(pos.corner.charAt(0) == 'M' && pos.aroundCorner.charAt(0) == 'M'){
				this.connectorNode.style.top = aroundNodeCoords.y + ((aroundNodeCoords.h - this.connectorNode.offsetHeight) >> 1) - pos.y + "px";
				this.connectorNode.style.left = "";
			}else if(pos.corner.charAt(1) == 'M' && pos.aroundCorner.charAt(1) == 'M'){
				this.connectorNode.style.left = aroundNodeCoords.x + ((aroundNodeCoords.w - this.connectorNode.offsetWidth) >> 1) - pos.x + "px";
			}else{
				// Not *-centered, but just above/below/after/before
				this.connectorNode.style.left = "";
				this.connectorNode.style.top = "";
			}

			// show it
			domStyle.set(this.domNode, "opacity", 0);
			this.fadeIn.play();
			this.isShowingNow = true;
			this.aroundNode = aroundNode;
		},

		orient: function(/*DomNode*/ node, /*String*/ aroundCorner, /*String*/ tooltipCorner, /*Object*/ spaceAvailable, /*Object*/ aroundNodeCoords){
			// summary:
			//		Private function to set CSS for tooltip node based on which position it's in.
			//		This is called by the dijit popup code.   It will also reduce the tooltip's
			//		width to whatever width is available
			// tags:
			//		protected

			this.connectorNode.style.top = ""; //reset to default

			var heightAvailable = spaceAvailable.h,
				widthAvailable = spaceAvailable.w;

			node.className = "dijitTooltip " +
				{
					"MR-ML": "dijitTooltipRight",
					"ML-MR": "dijitTooltipLeft",
					"TM-BM": "dijitTooltipAbove",
					"BM-TM": "dijitTooltipBelow",
					"BL-TL": "dijitTooltipBelow dijitTooltipABLeft",
					"TL-BL": "dijitTooltipAbove dijitTooltipABLeft",
					"BR-TR": "dijitTooltipBelow dijitTooltipABRight",
					"TR-BR": "dijitTooltipAbove dijitTooltipABRight",
					"BR-BL": "dijitTooltipRight",
					"BL-BR": "dijitTooltipLeft"
				}[aroundCorner + "-" + tooltipCorner];

			// reset width; it may have been set by orient() on a previous tooltip show()
			this.domNode.style.width = "auto";

			// Reduce tooltip's width to the amount of width available, so that it doesn't overflow screen.
			// Note that sometimes widthAvailable is negative, but we guard against setting style.width to a
			// negative number since that causes an exception on IE.
			var size = domGeometry.position(this.domNode);
			if(has("ie") == 9){
				// workaround strange IE9 bug where setting width to offsetWidth causes words to wrap
				size.w += 2;
			}

			var width = Math.min((Math.max(widthAvailable,1)), size.w);

			domGeometry.setMarginBox(this.domNode, {w: width});

			// Reposition the tooltip connector.
			if(tooltipCorner.charAt(0) == 'B' && aroundCorner.charAt(0) == 'B'){
				var bb = domGeometry.position(node);
				var tooltipConnectorHeight = this.connectorNode.offsetHeight;
				if(bb.h > heightAvailable){
					// The tooltip starts at the top of the page and will extend past the aroundNode
					var aroundNodePlacement = heightAvailable - ((aroundNodeCoords.h + tooltipConnectorHeight) >> 1);
					this.connectorNode.style.top = aroundNodePlacement + "px";
					this.connectorNode.style.bottom = "";
				}else{
					// Align center of connector with center of aroundNode, except don't let bottom
					// of connector extend below bottom of tooltip content, or top of connector
					// extend past top of tooltip content
					this.connectorNode.style.bottom = Math.min(
						Math.max(aroundNodeCoords.h/2 - tooltipConnectorHeight/2, 0),
						bb.h - tooltipConnectorHeight) + "px";
					this.connectorNode.style.top = "";
				}
			}else{
				// reset the tooltip back to the defaults
				this.connectorNode.style.top = "";
				this.connectorNode.style.bottom = "";
			}

			return Math.max(0, size.w - widthAvailable);
		},

		_onShow: function(){
			// summary:
			//		Called at end of fade-in operation
			// tags:
			//		protected
			if(has("ie")){
				// the arrow won't show up on a node w/an opacity filter
				this.domNode.style.filter="";
			}
		},

		hide: function(aroundNode){
			// summary:
			//		Hide the tooltip

			if(this._onDeck && this._onDeck[1] == aroundNode){
				// this hide request is for a show() that hasn't even started yet;
				// just cancel the pending show()
				this._onDeck=null;
			}else if(this.aroundNode === aroundNode){
				// this hide request is for the currently displayed tooltip
				this.fadeIn.stop();
				this.isShowingNow = false;
				this.aroundNode = null;
				this.fadeOut.play();
			}else{
				// just ignore the call, it's for a tooltip that has already been erased
			}
		},

		_onHide: function(){
			// summary:
			//		Called at end of fade-out operation
			// tags:
			//		protected

			this.domNode.style.cssText="";	// to position offscreen again
			this.containerNode.innerHTML="";
			if(this._onDeck){
				// a show request has been queued up; do it now
				this.show.apply(this, this._onDeck);
				this._onDeck=null;
			}
		},

		_setAutoTextDir: function(/*Object*/node){
			// summary:
			//		Resolve "auto" text direction for children nodes
			// tags:
			//		private

			this.applyTextDir(node, has("ie") ? node.outerText : node.textContent);
			array.forEach(node.children, function(child){this._setAutoTextDir(child); }, this);
		},

		_setTextDirAttr: function(/*String*/ textDir){
			// summary:
			//		Setter for textDir.
			// description:
			//		Users shouldn't call this function; they should be calling
			//		set('textDir', value)
			// tags:
			//		private

			this._set("textDir", textDir);

			if (textDir == "auto"){
				this._setAutoTextDir(this.containerNode);
			}else{
				this.containerNode.dir = this.textDir;
			}
		}
	});

	dijit.showTooltip = function(innerHTML, aroundNode, position, rtl, textDir){
		// summary:
		//		Static method to display tooltip w/specified contents in specified position.
		//		See description of dijit/Tooltip.defaultPosition for details on position parameter.
		//		If position is not specified then dijit/Tooltip.defaultPosition is used.
		// innerHTML: String
		//		Contents of the tooltip
		// aroundNode: place.__Rectangle
		//		Specifies that tooltip should be next to this node / area
		// position: String[]?
		//		List of positions to try to position tooltip (ex: ["right", "above"])
		// rtl: Boolean?
		//		Corresponds to `WidgetBase.dir` attribute, where false means "ltr" and true
		//		means "rtl"; specifies GUI direction, not text direction.
		// textDir: String?
		//		Corresponds to `WidgetBase.textdir` attribute; specifies direction of text.

		// After/before don't work, but for back-compat convert them to the working after-centered, before-centered.
		// Possibly remove this in 2.0.   Alternately, get before/after to work.
		if(position){
			position = array.map(position, function(val){
				return {after: "after-centered", before: "before-centered"}[val] || val;
			});
		}

		if(!Tooltip._masterTT){ dijit._masterTT = Tooltip._masterTT = new MasterTooltip(); }
		return Tooltip._masterTT.show(innerHTML, aroundNode, position, rtl, textDir);
	};

	dijit.hideTooltip = function(aroundNode){
		// summary:
		//		Static method to hide the tooltip displayed via showTooltip()
		return Tooltip._masterTT && Tooltip._masterTT.hide(aroundNode);
	};

	var Tooltip = declare("dijit.Tooltip", _Widget, {
		// summary:
		//		Pops up a tooltip (a help message) when you hover over a node.
		//		Also provides static show() and hide() methods that can be used without instantiating a dijit/Tooltip.

		// label: String
		//		Text to display in the tooltip.
		//		Specified as innerHTML when creating the widget from markup.
		label: "",

		// showDelay: Integer
		//		Number of milliseconds to wait after hovering over/focusing on the object, before
		//		the tooltip is displayed.
		showDelay: 400,

		// connectId: String|String[]|DomNode|DomNode[]
		//		Id of domNode(s) to attach the tooltip to.
		//		When user hovers over specified dom node(s), the tooltip will appear.
		connectId: [],

		// position: String[]
		//		See description of `dijit/Tooltip.defaultPosition` for details on position parameter.
		position: [],

		// selector: String?
		//		CSS expression to apply this Tooltip to descendants of connectIds, rather than to
		//		the nodes specified by connectIds themselves.    Useful for applying a Tooltip to
		//		a range of rows in a table, tree, etc.   Use in conjunction with getContent() parameter.
		//		Ex: connectId: myTable, selector: "tr", getContent: function(node){ return ...; }
		//
		//		The application must require() an appropriate level of dojo/query to handle the selector.
		selector: "",

		// TODO: in 2.0 remove support for multiple connectIds.   selector gives the same effect.
		// So, change connectId to a "", remove addTarget()/removeTarget(), etc.

		_setConnectIdAttr: function(/*String|String[]}DomNode|DomNode[]*/ newId){
			// summary:
			//		Connect to specified node(s)

			// Remove connections to old nodes (if there are any)
			array.forEach(this._connections || [], function(nested){
				array.forEach(nested, function(handle){ handle.remove(); });
			}, this);

			// Make array of id's to connect to, excluding entries for nodes that don't exist yet, see startup()
			this._connectIds = array.filter(lang.isArrayLike(newId) ? newId : (newId ? [newId] : []),
					function(id){ return dom.byId(id, this.ownerDocument); }, this);

			// Make connections
			this._connections = array.map(this._connectIds, function(id){
				var node = dom.byId(id, this.ownerDocument),
					selector = this.selector,
					delegatedEvent = selector ?
						function(eventType){ return on.selector(selector, eventType); } :
						function(eventType){ return eventType; },
					self = this;
				return [
					on(node, delegatedEvent(mouse.enter), function(){
						self._onHover(this);
					}),
					on(node, delegatedEvent("focusin"), function(){
						self._onHover(this);
					}),
					on(node, delegatedEvent(mouse.leave), lang.hitch(self, "_onUnHover")),
					on(node, delegatedEvent("focusout"), lang.hitch(self, "_onUnHover"))
				];
			}, this);

			this._set("connectId", newId);
		},

		addTarget: function(/*OomNode|String*/ node){
			// summary:
			//		Attach tooltip to specified node if it's not already connected

			// TODO: remove in 2.0 and just use set("connectId", ...) interface

			var id = node.id || node;
			if(array.indexOf(this._connectIds, id) == -1){
				this.set("connectId", this._connectIds.concat(id));
			}
		},

		removeTarget: function(/*DomNode|String*/ node){
			// summary:
			//		Detach tooltip from specified node

			// TODO: remove in 2.0 and just use set("connectId", ...) interface

			var id = node.id || node,	// map from DOMNode back to plain id string
				idx = array.indexOf(this._connectIds, id);
			if(idx >= 0){
				// remove id (modifies original this._connectIds but that's OK in this case)
				this._connectIds.splice(idx, 1);
				this.set("connectId", this._connectIds);
			}
		},

		buildRendering: function(){
			this.inherited(arguments);
			domClass.add(this.domNode,"dijitTooltipData");
		},

		startup: function(){
			this.inherited(arguments);

			// If this tooltip was created in a template, or for some other reason the specified connectId[s]
			// didn't exist during the widget's initialization, then connect now.
			var ids = this.connectId;
			array.forEach(lang.isArrayLike(ids) ? ids : [ids], this.addTarget, this);
		},

		getContent: function(/*DomNode*/ node){
			// summary:
			//		User overridable function that return the text to display in the tooltip.
			// tags:
			//		extension
			return this.label || this.domNode.innerHTML;
		},

		_onHover: function(/*DomNode*/ target){
			// summary:
			//		Despite the name of this method, it actually handles both hover and focus
			//		events on the target node, setting a timer to show the tooltip.
			// tags:
			//		private
			if(!this._showTimer){
				this._showTimer = this.defer(function(){ this.open(target); }, this.showDelay);
			}
		},

		_onUnHover: function(){
			// summary:
			//		Despite the name of this method, it actually handles both mouseleave and blur
			//		events on the target node, hiding the tooltip.
			// tags:
			//		private

			if(this._showTimer){
				this._showTimer.remove();
				delete this._showTimer;
			}
			this.close();
		},

		open: function(/*DomNode*/ target){
			// summary:
			//		Display the tooltip; usually not called directly.
			// tags:
			//		private

			if(this._showTimer){
				this._showTimer.remove();
				delete this._showTimer;
			}

			var content = this.getContent(target);
			if(!content){
				return;
			}
			Tooltip.show(content, target, this.position, !this.isLeftToRight(), this.textDir);

			this._connectNode = target;		// _connectNode means "tooltip currently displayed for this node"
			this.onShow(target, this.position);
		},

		close: function(){
			// summary:
			//		Hide the tooltip or cancel timer for show of tooltip
			// tags:
			//		private

			if(this._connectNode){
				// if tooltip is currently shown
				Tooltip.hide(this._connectNode);
				delete this._connectNode;
				this.onHide();
			}
			if(this._showTimer){
				// if tooltip is scheduled to be shown (after a brief delay)
				this._showTimer.remove();
				delete this._showTimer;
			}
		},

		onShow: function(/*===== target, position =====*/){
			// summary:
			//		Called when the tooltip is shown
			// tags:
			//		callback
		},

		onHide: function(){
			// summary:
			//		Called when the tooltip is hidden
			// tags:
			//		callback
		},

		destroy: function(){
			this.close();

			// Remove connections manually since they aren't registered to be removed by _WidgetBase
			array.forEach(this._connections || [], function(nested){
				array.forEach(nested, function(handle){ handle.remove(); });
			}, this);

			this.inherited(arguments);
		}
	});

	Tooltip._MasterTooltip = MasterTooltip;		// for monkey patching
	Tooltip.show = dijit.showTooltip;		// export function through module return value
	Tooltip.hide = dijit.hideTooltip;		// export function through module return value

	Tooltip.defaultPosition = ["after-centered", "before-centered"];

	/*=====
	lang.mixin(Tooltip, {
		 // defaultPosition: String[]
		 //		This variable controls the position of tooltips, if the position is not specified to
		 //		the Tooltip widget or *TextBox widget itself.  It's an array of strings with the values
		 //		possible for `dijit/place.around()`.   The recommended values are:
		 //
		 //		- before-centered: centers tooltip to the left of the anchor node/widget, or to the right
		 //		  in the case of RTL scripts like Hebrew and Arabic
		 //		- after-centered: centers tooltip to the right of the anchor node/widget, or to the left
		 //		  in the case of RTL scripts like Hebrew and Arabic
		 //		- above-centered: tooltip is centered above anchor node
		 //		- below-centered: tooltip is centered above anchor node
		 //
		 //		The list is positions is tried, in order, until a position is found where the tooltip fits
		 //		within the viewport.
		 //
		 //		Be careful setting this parameter.  A value of "above-centered" may work fine until the user scrolls
		 //		the screen so that there's no room above the target node.   Nodes with drop downs, like
		 //		DropDownButton or FilteringSelect, are especially problematic, in that you need to be sure
		 //		that the drop down and tooltip don't overlap, even when the viewport is scrolled so that there
		 //		is only room below (or above) the target node, but not both.
	 });
	=====*/
	return Tooltip;
});

},
'url:dijit/templates/MenuSeparator.html':"<tr class=\"dijitMenuSeparator\">\n\t<td class=\"dijitMenuSeparatorIconCell\">\n\t\t<div class=\"dijitMenuSeparatorTop\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n\t<td colspan=\"3\" class=\"dijitMenuSeparatorLabelCell\">\n\t\t<div class=\"dijitMenuSeparatorTop dijitMenuSeparatorLabel\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n</tr>",
'davinci/review/actions/PublishAction':function(){
define([
	"dojo/_base/declare",
	"davinci/actions/Action",
	"davinci/review/widgets/PublishWizard",
	"davinci/Runtime",
	"dojox/widget/Toaster",
	"davinci/ui/Dialog",
	"dojo/i18n!./nls/actions"
], function(declare, Action, PublishWizard, Runtime, Toaster, Dialog, actionsNls) {

var PublishAction = declare("davinci.review.actions.PublishAction", [Action], {

	constructor: function(node, isRestart) {
		this.node =  node;
		this.isRestart = isRestart;
		if (node && node.isRestart) {
			this.isRestart = true;
		}
	},

	run : function() {
		var publishWizard = this.publishWizard = new PublishWizard();
		this.dialog = new Dialog({
			contentStyle: {width:650,height:350},
			title: this.node ? actionsNls.editReview : actionsNls.newReview,
			onCancel: dojo.hitch(this, this.close),
			onHide: dojo.hitch(this, this.hide)
		});
		this.dialog.setContent(publishWizard);
		this.dialog.show();
		dojo.connect(publishWizard, "onClose", this, this.close);
		publishWizard.initData(this.node, this.isRestart).then(function() {
			publishWizard.updateSubmit();
			publishWizard.reviewerStackContainer.resize();
		});
	},

	hide: function() {
		this.dialog.destroyRecursive();
	},

	close: function() {
		this.dialog.hide();
	}

});

return PublishAction;

});
},
'dijit/form/DropDownButton':function(){
define([
	"dojo/_base/declare", // declare
	"dojo/_base/lang",	// hitch
	"dojo/query", // query
	"../registry",	// registry.byNode
	"../popup",		// dijit.popup2.hide
	"./Button",
	"../_Container",
	"../_HasDropDown",
	"dojo/text!./templates/DropDownButton.html"
], function(declare, lang, query, registry, popup, Button, _Container, _HasDropDown, template){

// module:
//		dijit/form/DropDownButton


return declare("dijit.form.DropDownButton", [Button, _Container, _HasDropDown], {
	// summary:
	//		A button with a drop down
	//
	// example:
	// |	<button data-dojo-type="dijit/form/DropDownButton">
	// |		Hello world
	// |		<div data-dojo-type="dijit/Menu">...</div>
	// |	</button>
	//
	// example:
	// |	var button1 = new DropDownButton({ label: "hi", dropDown: new dijit.Menu(...) });
	// |	win.body().appendChild(button1);
	//

	baseClass : "dijitDropDownButton",

	templateString: template,

	_fillContent: function(){
		// Overrides Button._fillContent().
		//
		// My inner HTML contains both the button contents and a drop down widget, like
		// <DropDownButton>  <span>push me</span>  <Menu> ... </Menu> </DropDownButton>
		// The first node is assumed to be the button content. The widget is the popup.

		if(this.srcNodeRef){ // programatically created buttons might not define srcNodeRef
			//FIXME: figure out how to filter out the widget and use all remaining nodes as button
			//	content, not just nodes[0]
			var nodes = query("*", this.srcNodeRef);
			this.inherited(arguments, [nodes[0]]);

			// save pointer to srcNode so we can grab the drop down widget after it's instantiated
			this.dropDownContainer = this.srcNodeRef;
		}
	},

	startup: function(){
		if(this._started){ return; }

		// the child widget from srcNodeRef is the dropdown widget.  Insert it in the page DOM,
		// make it invisible, and store a reference to pass to the popup code.
		if(!this.dropDown && this.dropDownContainer){
			var dropDownNode = query("[widgetId]", this.dropDownContainer)[0];
			this.dropDown = registry.byNode(dropDownNode);
			delete this.dropDownContainer;
		}
		if(this.dropDown){
			popup.hide(this.dropDown);
		}

		this.inherited(arguments);
	},

	isLoaded: function(){
		// Returns whether or not we are loaded - if our dropdown has an href,
		// then we want to check that.
		var dropDown = this.dropDown;
		return (!!dropDown && (!dropDown.href || dropDown.isLoaded));
	},

	loadDropDown: function(/*Function*/ callback){
		// Default implementation assumes that drop down already exists,
		// but hasn't loaded it's data (ex: ContentPane w/href).
		// App must override if the drop down is lazy-created.
		var dropDown = this.dropDown;
		var handler = dropDown.on("load", lang.hitch(this, function(){
			handler.remove();
			callback();
		}));
		dropDown.refresh();		// tell it to load
	},

	isFocusable: function(){
		// Overridden so that focus is handled by the _HasDropDown mixin, not by
		// the _FormWidget mixin.
		return this.inherited(arguments) && !this._mouseDown;
	}
});

});

},
'dojox/grid/cells':function(){
define(["../main", "./cells/_base"], function(dojox){
	return dojox.grid.cells;
});
},
'dojo/date':function(){
define(["./has", "./_base/lang"], function(has, lang){
// module:
//		dojo/date

var date = {
	// summary:
	//		Date manipulation utilities
};

date.getDaysInMonth = function(/*Date*/dateObject){
	// summary:
	//		Returns the number of days in the month used by dateObject
	var month = dateObject.getMonth();
	var days = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
	if(month == 1 && date.isLeapYear(dateObject)){ return 29; } // Number
	return days[month]; // Number
};

date.isLeapYear = function(/*Date*/dateObject){
	// summary:
	//		Determines if the year of the dateObject is a leap year
	// description:
	//		Leap years are years with an additional day YYYY-02-29, where the
	//		year number is a multiple of four with the following exception: If
	//		a year is a multiple of 100, then it is only a leap year if it is
	//		also a multiple of 400. For example, 1900 was not a leap year, but
	//		2000 is one.

	var year = dateObject.getFullYear();
	return !(year%400) || (!(year%4) && !!(year%100)); // Boolean
};

// FIXME: This is not localized
date.getTimezoneName = function(/*Date*/dateObject){
	// summary:
	//		Get the user's time zone as provided by the browser
	// dateObject:
	//		Needed because the timezone may vary with time (daylight savings)
	// description:
	//		Try to get time zone info from toString or toLocaleString method of
	//		the Date object -- UTC offset is not a time zone.  See
	//		http://www.twinsun.com/tz/tz-link.htm Note: results may be
	//		inconsistent across browsers.

	var str = dateObject.toString(); // Start looking in toString
	var tz = ''; // The result -- return empty string if nothing found
	var match;

	// First look for something in parentheses -- fast lookup, no regex
	var pos = str.indexOf('(');
	if(pos > -1){
		tz = str.substring(++pos, str.indexOf(')'));
	}else{
		// If at first you don't succeed ...
		// If IE knows about the TZ, it appears before the year
		// Capital letters or slash before a 4-digit year
		// at the end of string
		var pat = /([A-Z\/]+) \d{4}$/;
		if((match = str.match(pat))){
			tz = match[1];
		}else{
		// Some browsers (e.g. Safari) glue the TZ on the end
		// of toLocaleString instead of putting it in toString
			str = dateObject.toLocaleString();
			// Capital letters or slash -- end of string,
			// after space
			pat = / ([A-Z\/]+)$/;
			if((match = str.match(pat))){
				tz = match[1];
			}
		}
	}

	// Make sure it doesn't somehow end up return AM or PM
	return (tz == 'AM' || tz == 'PM') ? '' : tz; // String
};

// Utility methods to do arithmetic calculations with Dates

date.compare = function(/*Date*/date1, /*Date?*/date2, /*String?*/portion){
	// summary:
	//		Compare two date objects by date, time, or both.
	// description:
	//		Returns 0 if equal, positive if a > b, else negative.
	// date1:
	//		Date object
	// date2:
	//		Date object.  If not specified, the current Date is used.
	// portion:
	//		A string indicating the "date" or "time" portion of a Date object.
	//		Compares both "date" and "time" by default.  One of the following:
	//		"date", "time", "datetime"

	// Extra step required in copy for IE - see #3112
	date1 = new Date(+date1);
	date2 = new Date(+(date2 || new Date()));

	if(portion == "date"){
		// Ignore times and compare dates.
		date1.setHours(0, 0, 0, 0);
		date2.setHours(0, 0, 0, 0);
	}else if(portion == "time"){
		// Ignore dates and compare times.
		date1.setFullYear(0, 0, 0);
		date2.setFullYear(0, 0, 0);
	}

	if(date1 > date2){ return 1; } // int
	if(date1 < date2){ return -1; } // int
	return 0; // int
};

date.add = function(/*Date*/date, /*String*/interval, /*int*/amount){
	// summary:
	//		Add to a Date in intervals of different size, from milliseconds to years
	// date: Date
	//		Date object to start with
	// interval:
	//		A string representing the interval.  One of the following:
	//		"year", "month", "day", "hour", "minute", "second",
	//		"millisecond", "quarter", "week", "weekday"
	// amount:
	//		How much to add to the date.

	var sum = new Date(+date); // convert to Number before copying to accomodate IE (#3112)
	var fixOvershoot = false;
	var property = "Date";

	switch(interval){
		case "day":
			break;
		case "weekday":
			//i18n FIXME: assumes Saturday/Sunday weekend, but this is not always true.  see dojo/cldr/supplemental

			// Divide the increment time span into weekspans plus leftover days
			// e.g., 8 days is one 5-day weekspan / and two leftover days
			// Can't have zero leftover days, so numbers divisible by 5 get
			// a days value of 5, and the remaining days make up the number of weeks
			var days, weeks;
			var mod = amount % 5;
			if(!mod){
				days = (amount > 0) ? 5 : -5;
				weeks = (amount > 0) ? ((amount-5)/5) : ((amount+5)/5);
			}else{
				days = mod;
				weeks = parseInt(amount/5);
			}
			// Get weekday value for orig date param
			var strt = date.getDay();
			// Orig date is Sat / positive incrementer
			// Jump over Sun
			var adj = 0;
			if(strt == 6 && amount > 0){
				adj = 1;
			}else if(strt == 0 && amount < 0){
			// Orig date is Sun / negative incrementer
			// Jump back over Sat
				adj = -1;
			}
			// Get weekday val for the new date
			var trgt = strt + days;
			// New date is on Sat or Sun
			if(trgt == 0 || trgt == 6){
				adj = (amount > 0) ? 2 : -2;
			}
			// Increment by number of weeks plus leftover days plus
			// weekend adjustments
			amount = (7 * weeks) + days + adj;
			break;
		case "year":
			property = "FullYear";
			// Keep increment/decrement from 2/29 out of March
			fixOvershoot = true;
			break;
		case "week":
			amount *= 7;
			break;
		case "quarter":
			// Naive quarter is just three months
			amount *= 3;
			// fallthrough...
		case "month":
			// Reset to last day of month if you overshoot
			fixOvershoot = true;
			property = "Month";
			break;
//		case "hour":
//		case "minute":
//		case "second":
//		case "millisecond":
		default:
			property = "UTC"+interval.charAt(0).toUpperCase() + interval.substring(1) + "s";
	}

	if(property){
		sum["set"+property](sum["get"+property]()+amount);
	}

	if(fixOvershoot && (sum.getDate() < date.getDate())){
		sum.setDate(0);
	}

	return sum; // Date
};

date.difference = function(/*Date*/date1, /*Date?*/date2, /*String?*/interval){
	// summary:
	//		Get the difference in a specific unit of time (e.g., number of
	//		months, weeks, days, etc.) between two dates, rounded to the
	//		nearest integer.
	// date1:
	//		Date object
	// date2:
	//		Date object.  If not specified, the current Date is used.
	// interval:
	//		A string representing the interval.  One of the following:
	//		"year", "month", "day", "hour", "minute", "second",
	//		"millisecond", "quarter", "week", "weekday"
	//
	//		Defaults to "day".

	date2 = date2 || new Date();
	interval = interval || "day";
	var yearDiff = date2.getFullYear() - date1.getFullYear();
	var delta = 1; // Integer return value

	switch(interval){
		case "quarter":
			var m1 = date1.getMonth();
			var m2 = date2.getMonth();
			// Figure out which quarter the months are in
			var q1 = Math.floor(m1/3) + 1;
			var q2 = Math.floor(m2/3) + 1;
			// Add quarters for any year difference between the dates
			q2 += (yearDiff * 4);
			delta = q2 - q1;
			break;
		case "weekday":
			var days = Math.round(date.difference(date1, date2, "day"));
			var weeks = parseInt(date.difference(date1, date2, "week"));
			var mod = days % 7;

			// Even number of weeks
			if(mod == 0){
				days = weeks*5;
			}else{
				// Weeks plus spare change (< 7 days)
				var adj = 0;
				var aDay = date1.getDay();
				var bDay = date2.getDay();

				weeks = parseInt(days/7);
				mod = days % 7;
				// Mark the date advanced by the number of
				// round weeks (may be zero)
				var dtMark = new Date(date1);
				dtMark.setDate(dtMark.getDate()+(weeks*7));
				var dayMark = dtMark.getDay();

				// Spare change days -- 6 or less
				if(days > 0){
					switch(true){
						// Range starts on Sat
						case aDay == 6:
							adj = -1;
							break;
						// Range starts on Sun
						case aDay == 0:
							adj = 0;
							break;
						// Range ends on Sat
						case bDay == 6:
							adj = -1;
							break;
						// Range ends on Sun
						case bDay == 0:
							adj = -2;
							break;
						// Range contains weekend
						case (dayMark + mod) > 5:
							adj = -2;
					}
				}else if(days < 0){
					switch(true){
						// Range starts on Sat
						case aDay == 6:
							adj = 0;
							break;
						// Range starts on Sun
						case aDay == 0:
							adj = 1;
							break;
						// Range ends on Sat
						case bDay == 6:
							adj = 2;
							break;
						// Range ends on Sun
						case bDay == 0:
							adj = 1;
							break;
						// Range contains weekend
						case (dayMark + mod) < 0:
							adj = 2;
					}
				}
				days += adj;
				days -= (weeks*2);
			}
			delta = days;
			break;
		case "year":
			delta = yearDiff;
			break;
		case "month":
			delta = (date2.getMonth() - date1.getMonth()) + (yearDiff * 12);
			break;
		case "week":
			// Truncate instead of rounding
			// Don't use Math.floor -- value may be negative
			delta = parseInt(date.difference(date1, date2, "day")/7);
			break;
		case "day":
			delta /= 24;
			// fallthrough
		case "hour":
			delta /= 60;
			// fallthrough
		case "minute":
			delta /= 60;
			// fallthrough
		case "second":
			delta /= 1000;
			// fallthrough
		case "millisecond":
			delta *= date2.getTime() - date1.getTime();
	}

	// Round for fractional values and DST leaps
	return Math.round(delta); // Number (integer)
};

// Don't use setObject() because it may overwrite dojo/date/stamp (if that has already been loaded)
 1  && lang.mixin(lang.getObject("dojo.date", true), date);

return date;
});

},
'davinci/review/review.plugin':function(){
define([
	"davinci/css!./resources/Comment.css"
], function() {

return {
	id: "davinci.review",
	"davinci.view": [
		{
			id: "comment",
			title: "Comments",
			viewClass: "davinci/review/view/CommentView",
            iconClass: "paletteIcon paletteIconComments"
		},
		{
			id: "reviewNavigator",
			title: "Reviews",
			viewClass: "davinci/review/view/CommentExplorerView",
            iconClass: "paletteIcon paletteIconReviews"

		},
		{
			id: "state",
			title: "States",
			viewClass: "davinci/ve/views/StatesView",
            iconClass: "paletteIcon paletteIconStates"
		}
	],
	"davinci.perspective": {
		id: "review",
		title: "Review",
		views: [
            {
                viewID: "davinci.ve.Palette",
                position: "left",
                hidden: true
            },
            {
                viewID: "davinci.ui.outline",
                position: "left",
                hidden: true
            },
            {
                viewID: "davinci.ve.style",
                position: "right"
            },
            {
                viewID: "davinci.ui.comment",
                position: "right",
                selected: true
            },
            {
                viewID: "davinci.ve.states",
                position: "right-bottom"
            },
            {
                viewID: "davinci.ui.navigator",
                position: "left-bottom"
            },
            {
                viewID: "davinci.review.reviewNavigator",
                position: "left",
                selected: true
            }
		]
	},
	"davinci.editor": [
		{
			id: "CommentReviewEditor",
			name: "Review Editor",
			extensions: "rev",
			isDefault: true,
			editorClass: "davinci/review/editor/ReviewEditor",
			editorClassName: "ReviewEditor",
			palettePerspective: "davinci.review.review",
	        expandPalettes: ["right"]
		}
	],
	"davinci.fileType": [
		{
			extension: "rev",
			iconClass: "reviewFileIcon",
			type: "text"
		}
	],
	"davinci.actionSets": [
		{
			id: "editorActionsReview",
			visible: true,
			actions: [
				{
					id: "newReview",
					action: "davinci/review/actions/PublishAction",
	                iconClass: "newOpenMenuItem newReviewMenuItem",
					label: "Review...",
					menubarPath: "davinci.new/newTheme"
				}
			]
		},
		{
			id: "reviewExplorerActions",
			visible: true,
			actions: [
				{
					id: "davinci.review.view",
					label: "Open",
					action: "davinci/review/actions/ViewFileAction",
					//iconClass: "viewActionIcon reviewFileIcon",
					menubarPath: "newfile"
				},
				{
					id: "davinci.review.edit",
					label: "Edit...",
					action: "davinci/review/actions/EditVersionAction",
					//iconClass: "viewActionIcon editVersionIcon",
					menubarPath: "newfile"
				},
				{
					id: "davinci.review.open",
					label: "Start",
					action: "davinci/review/actions/OpenVersionAction",
					//iconClass: "viewActionIcon openVersionIcon",
					menubarPath: "newfile"
				},
				{
					id: "davinci.review.close",
					label: "Stop...",
					action: "davinci/review/actions/CloseVersionAction",
					//iconClass: "viewActionIcon closeVersionIcon",
					menubarPath: "newfile"
				},
				{
					id: "davinci.review.delete",
					label: "Delete...",
					action: "davinci/review/actions/DeleteVersionAction",
					//iconClass: "viewActionIcon deleteVersionIcon",
					menubarPath: "newfile",
					keyBinding: {charOrCode: [dojo.keys.DELETE, dojo.keys.BACKSPACE]}
				},
				{
					id: "davinci.review.restart",
					label: "Republish...",
					action: "davinci/review/actions/RestartVersionAction",
					menubarPath: "newfile"
				}
			]

		}
	],
	"davinci.actionSetPartAssociations": [
		{
			targetID: "davinci.review.editorActionsReview",
			parts: ["davinci.ui.editorMenuBar"]
		  },
		{
			targetID: "davinci.review.reviewExplorerActions",
			parts: ["davinci.review.reviewNavigator"]
		}
	],
	"davinci.annotationActions": {
		editorContribution: {
			actions: [
				{
					id: "arrow",
					label: "Draw arrow",
					iconClass: "davinciAnnotationIcon davinciAnnotationIconArrow",
					action: "davinci/review/actions/ArrowAction",
					toolbarPath: "annotationtools"
				},
				{
					id: "rect",
					label: "Draw rectangle",
					iconClass: "davinciAnnotationIcon davinciAnnotationIconRect",
					action: "davinci/review/actions/RectAction",
					toolbarPath: "annotationtools"
				},
				{
					id: "ellipse",
					label: "Draw ellipse",
					iconClass: "davinciAnnotationIcon davinciAnnotationIconEllipse",
					action: "davinci/review/actions/EllipseAction",
					toolbarPath: "annotationtools"
				},
				{
					id: "textAnnotation",
					label: "Draw text",
					iconClass: "davinciAnnotationIcon davinciAnnotationIconText",
					action: "davinci/review/actions/TextAction",
					toolbarPath: "annotationtools"
				},
				{
				    id: "deleteAnnotation",
				    iconClass: "davinciAnnotationIcon davinciAnnotationIconDelete",
				    label: "Delete Annotation",
				    action: "davinci/review/actions/DeleteAnnotationAction",
				    toolbarPath: "annotationtools_delete",
				    keyBinding: {charOrCode: [dojo.keys.DELETE, dojo.keys.BACKSPACE]}
				}
			]
		}
	},
    "davinci.editorActions": {
        editorContribution: {
            targetID: "davinci.review.CommentReviewEditor",
            actions: [
                {
                    id: "ReviewToolBarText",
                    type: "davinci/review/widgets/ReviewToolBarText",
                    toolbarPath: "ReviewToolBarText"
                }
            ]
        }
    }

};

});
},
'davinci/ui/widgets/TransformTreeMixin':function(){
define("davinci/ui/widgets/TransformTreeMixin", ["dijit/Tree"], function(tree) {

// Adds the capability to filter and/or re-order elements in a tree, e.g. alphabetically
// The proper way to do this would be through the data store, but there's presently no way
// to pass sort options to store.fetch, and no option to arrange anything but top-level nodes
// So, we'll do it in the widget as a mixin, iterating through an optional array on a
// property called 'transforms', similar to what was done in davinci.ui.widgets.Tree.

	var postCreate = dijit.Tree.prototype.postCreate;
	dijit.Tree.prototype.postCreate = function() {
		// override _onItemChildrenChange before it's connected in postCreate()
		var _onItemChildrenChange = dijit.Tree.prototype._onItemChildrenChange;
		dijit.Tree.prototype._onItemChildrenChange = function(/*dojo.data.Item*/ parent, /*dojo.data.Item[]*/ newChildrenList){
			if (this.transforms) {
				this.transforms.forEach(function(transform){
					newChildrenList = transform(newChildrenList);
				});
			}
			_onItemChildrenChange.apply(this, [parent, newChildrenList]);
		}

		// override model.getChildren() to apply the transforms
		var getChildren = this.model.getChildren;
		this.model.getChildren = dojo.hitch(this, function(/*dojo.data.Item*/ parentItem, /*function(items)*/ onComplete, /*function*/ onError){
			var completeHandler=onComplete;
			if (this.transforms) {
				completeHandler=dojo.hitch(this, function (items) {
					this.transforms.forEach(function(transform){
						items = transform(items);
					});
					onComplete(items);
				});
			}
			getChildren.apply(this.model, [parentItem, completeHandler, onError]);
		});

		postCreate.apply(this);
	};
});

},
'dojox/grid/_Layout':function(){
define([
	"dojo/_base/kernel",
	"../main",
	"dojo/_base/declare",
	"dojo/_base/array",
	"dojo/_base/lang",
	"dojo/dom-geometry",
	"./cells",
	"./_RowSelector"
], function(dojo, dojox, declare, array, lang, domGeometry){

return declare("dojox.grid._Layout", null, {
	// summary:
	//	Controls grid cell layout. Owned by grid and used internally.
	constructor: function(inGrid){
		this.grid = inGrid;
	},
	// flat array of grid cells
	cells: [],
	// structured array of grid cells
	structure: null,
	// default cell width
	defaultWidth: '6em',

	// methods
	moveColumn: function(sourceViewIndex, destViewIndex, cellIndex, targetIndex, before){
		var source_cells = this.structure[sourceViewIndex].cells[0];
		var dest_cells = this.structure[destViewIndex].cells[0];

		var cell = null;
		var cell_ri = 0;
		var target_ri = 0;

		for(var i=0, c; c=source_cells[i]; i++){
			if(c.index == cellIndex){
				cell_ri = i;
				break;
			}
		}
		cell = source_cells.splice(cell_ri, 1)[0];
		cell.view = this.grid.views.views[destViewIndex];

		for(i=0, c=null; c=dest_cells[i]; i++){
			if(c.index == targetIndex){
				target_ri = i;
				break;
			}
		}
		if(!before){
			target_ri += 1;
		}
		dest_cells.splice(target_ri, 0, cell);

		var sortedCell = this.grid.getCell(this.grid.getSortIndex());
		if(sortedCell){
			sortedCell._currentlySorted = this.grid.getSortAsc();
		}

		this.cells = [];
		cellIndex = 0;
		var v;
		for(i=0; v=this.structure[i]; i++){
			for(var j=0, cs; cs=v.cells[j]; j++){
				for(var k=0; c=cs[k]; k++){
					c.index = cellIndex;
					this.cells.push(c);
					if("_currentlySorted" in c){
						var si = cellIndex + 1;
						si *= c._currentlySorted ? 1 : -1;
						this.grid.sortInfo = si;
						delete c._currentlySorted;
					}
					cellIndex++;
				}
			}
		}
		
		//Fix #9481 - reset idx in cell markup
		array.forEach(this.cells, function(c){
			var marks = c.markup[2].split(" ");
			var oldIdx = parseInt(marks[1].substring(5));//get old "idx"
			if(oldIdx != c.index){
				marks[1] = "idx=\"" + c.index + "\"";
				c.markup[2] = marks.join(" ");
			}
		});
		
		this.grid.setupHeaderMenu();
		//this.grid.renderOnIdle();
	},

	setColumnVisibility: function(columnIndex, visible){
		var cell = this.cells[columnIndex];
		if(cell.hidden == visible){
			cell.hidden = !visible;
			var v = cell.view, w = v.viewWidth;
			if(w && w != "auto"){
				v._togglingColumn = domGeometry.getMarginBox(cell.getHeaderNode()).w || 0;
			}
			v.update();
			return true;
		}else{
			return false;
		}
	},
	
	addCellDef: function(inRowIndex, inCellIndex, inDef){
		var self = this;
		var getCellWidth = function(inDef){
			var w = 0;
			if(inDef.colSpan > 1){
				w = 0;
			}else{
				w = inDef.width || self._defaultCellProps.width || self.defaultWidth;

				if(!isNaN(w)){
					w = w + "em";
				}
			}
			return w;
		};

		var props = {
			grid: this.grid,
			subrow: inRowIndex,
			layoutIndex: inCellIndex,
			index: this.cells.length
		};

		if(inDef && inDef instanceof dojox.grid.cells._Base){
			var new_cell = lang.clone(inDef);
			props.unitWidth = getCellWidth(new_cell._props);
			new_cell = lang.mixin(new_cell, this._defaultCellProps, inDef._props, props);
			return new_cell;
		}

		var cell_type = inDef.type || inDef.cellType || this._defaultCellProps.type || this._defaultCellProps.cellType || dojox.grid.cells.Cell;
		if(lang.isString(cell_type)){
			cell_type = lang.getObject(cell_type);
		}

		props.unitWidth = getCellWidth(inDef);
		return new cell_type(lang.mixin({}, this._defaultCellProps, inDef, props));
	},
	
	addRowDef: function(inRowIndex, inDef){
		var result = [];
		var relSum = 0, pctSum = 0, doRel = true;
		for(var i=0, def, cell; (def=inDef[i]); i++){
			cell = this.addCellDef(inRowIndex, i, def);
			result.push(cell);
			this.cells.push(cell);
			// Check and calculate the sum of all relative widths
			if(doRel && cell.relWidth){
				relSum += cell.relWidth;
			}else if(cell.width){
				var w = cell.width;
				if(typeof w == "string" && w.slice(-1) == "%"){
					pctSum += window.parseInt(w, 10);
				}else if(w == "auto"){
					// relative widths doesn't play nice with auto - since we
					// don't have a way of knowing how much space the auto is
					// supposed to take up.
					doRel = false;
				}
			}
		}
		if(relSum && doRel){
			// We have some kind of relWidths specified - so change them to %
			array.forEach(result, function(cell){
				if(cell.relWidth){
					cell.width = cell.unitWidth = ((cell.relWidth / relSum) * (100 - pctSum)) + "%";
				}
			});
		}
		return result;
	
	},

	addRowsDef: function(inDef){
		var result = [];
		if(lang.isArray(inDef)){
			if(lang.isArray(inDef[0])){
				for(var i=0, row; inDef && (row=inDef[i]); i++){
					result.push(this.addRowDef(i, row));
				}
			}else{
				result.push(this.addRowDef(0, inDef));
			}
		}
		return result;
	},
	
	addViewDef: function(inDef){
		this._defaultCellProps = inDef.defaultCell || {};
		if(inDef.width && inDef.width == "auto"){
			delete inDef.width;
		}
		return lang.mixin({}, inDef, {cells: this.addRowsDef(inDef.rows || inDef.cells)});
	},
	
	setStructure: function(inStructure){
		this.fieldIndex = 0;
		this.cells = [];
		var s = this.structure = [];

		if(this.grid.rowSelector){
			var sel = { type: dojox._scopeName + ".grid._RowSelector" };

			if(lang.isString(this.grid.rowSelector)){
				var width = this.grid.rowSelector;

				if(width == "false"){
					sel = null;
				}else if(width != "true"){
					sel['width'] = width;
				}
			}else{
				if(!this.grid.rowSelector){
					sel = null;
				}
			}

			if(sel){
				s.push(this.addViewDef(sel));
			}
		}

		var isCell = function(def){
			return ("name" in def || "field" in def || "get" in def);
		};

		var isRowDef = function(def){
			if(lang.isArray(def)){
				if(lang.isArray(def[0]) || isCell(def[0])){
					return true;
				}
			}
			return false;
		};

		var isView = function(def){
			return (def !== null && lang.isObject(def) &&
					("cells" in def || "rows" in def || ("type" in def && !isCell(def))));
		};

		if(lang.isArray(inStructure)){
			var hasViews = false;
			for(var i=0, st; (st=inStructure[i]); i++){
				if(isView(st)){
					hasViews = true;
					break;
				}
			}
			if(!hasViews){
				s.push(this.addViewDef({ cells: inStructure }));
			}else{
				for(i=0; (st=inStructure[i]); i++){
					if(isRowDef(st)){
						s.push(this.addViewDef({ cells: st }));
					}else if(isView(st)){
						s.push(this.addViewDef(st));
					}
				}
			}
		}else if(isView(inStructure)){
			// it's a view object
			s.push(this.addViewDef(inStructure));
		}

		this.cellCount = this.cells.length;
		this.grid.setupHeaderMenu();
	}
});
});
},
'dijit/form/RangeBoundTextBox':function(){
define([
	"dojo/_base/declare", // declare
	"dojo/i18n", // i18n.getLocalization
	"./MappedTextBox"
], function(declare, i18n, MappedTextBox){

	// module:
	//		dijit/form/RangeBoundTextBox


	var RangeBoundTextBox = declare("dijit.form.RangeBoundTextBox", MappedTextBox, {
		// summary:
		//		Base class for textbox form widgets which defines a range of valid values.

		// rangeMessage: String
		//		The message to display if value is out-of-range
		rangeMessage: "",

		/*=====
		// constraints: RangeBoundTextBox.__Constraints
		constraints: {},
		======*/

		rangeCheck: function(/*Number*/ primitive, /*dijit/form/RangeBoundTextBox.__Constraints*/ constraints){
			// summary:
			//		Overridable function used to validate the range of the numeric input value.
			// tags:
			//		protected
			return	("min" in constraints? (this.compare(primitive,constraints.min) >= 0) : true) &&
				("max" in constraints? (this.compare(primitive,constraints.max) <= 0) : true); // Boolean
		},

		isInRange: function(/*Boolean*/ /*===== isFocused =====*/){
			// summary:
			//		Tests if the value is in the min/max range specified in constraints
			// tags:
			//		protected
			return this.rangeCheck(this.get('value'), this.constraints);
		},

		_isDefinitelyOutOfRange: function(){
			// summary:
			//		Returns true if the value is out of range and will remain
			//		out of range even if the user types more characters
			var val = this.get('value');
			if(val == null){ return false; } // not yet valid enough to compare to
			var outOfRange = false;
			if("min" in this.constraints){
				var min = this.constraints.min;
				outOfRange = this.compare(val, ((typeof min == "number") && min >= 0 && val != 0) ? 0 : min) < 0;
			}
			if(!outOfRange && ("max" in this.constraints)){
				var max = this.constraints.max;
				outOfRange = this.compare(val, ((typeof max != "number") || max > 0) ? max : 0) > 0;
			}
			return outOfRange;
		},

		_isValidSubset: function(){
			// summary:
			//		Overrides `dijit/form/ValidationTextBox._isValidSubset()`.
			//		Returns true if the input is syntactically valid, and either within
			//		range or could be made in range by more typing.
			return this.inherited(arguments) && !this._isDefinitelyOutOfRange();
		},

		isValid: function(/*Boolean*/ isFocused){
			// Overrides dijit/form/ValidationTextBox.isValid() to check that the value is also in range.
			return this.inherited(arguments) &&
				((this._isEmpty(this.textbox.value) && !this.required) || this.isInRange(isFocused)); // Boolean
		},

		getErrorMessage: function(/*Boolean*/ isFocused){
			// Overrides dijit/form/ValidationTextBox.getErrorMessage() to print "out of range" message if appropriate
			var v = this.get('value');
			if(v != null /* and !undefined */ && v !== '' && (typeof v != "number" || !isNaN(v)) && !this.isInRange(isFocused)){ // don't check isInRange w/o a real value
				return this.rangeMessage; // String
			}
			return this.inherited(arguments);
		},

		postMixInProperties: function(){
			this.inherited(arguments);
			if(!this.rangeMessage){
				this.messages = i18n.getLocalization("dijit.form", "validate", this.lang);
				this.rangeMessage = this.messages.rangeMessage;
			}
		},

		applyTextDir: function(/*===== element, text =====*/){
			// summary:
			//		The function overridden in the _BidiSupport module,
			//		originally used for setting element.dir according to this.textDir.
			//		In this case does nothing.
			// element: Object
			// text: String
			// tags:
			//		protected.
		}
	});
	/*=====
	RangeBoundTextBox.__Constraints = declare(null, {
		// min: Number
		//		Minimum signed value.  Default is -Infinity
		// max: Number
		//		Maximum signed value.  Default is +Infinity
	});
	=====*/
	return RangeBoundTextBox;
});

},
'dijit/layout/_ContentPaneResizeMixin':function(){
define([
	"dojo/_base/array", // array.filter array.forEach
	"dojo/_base/declare", // declare
	"dojo/dom-class",	// domClass.contains domClass.toggle
	"dojo/dom-geometry",// domGeometry.contentBox domGeometry.marginBox
	"dojo/dom-style",
	"dojo/_base/lang", // lang.mixin
	"dojo/query", // query
	"dojo/sniff", // has("ie")
	"../registry",	// registry.byId
	"../Viewport",
	"./utils"	// marginBox2contextBox
], function(array, declare, domClass, domGeometry, domStyle, lang, query, has,
			registry, Viewport, layoutUtils){

// module:
//		dijit/layout/_ContentPaneResizeMixin


return declare("dijit.layout._ContentPaneResizeMixin", null, {
	// summary:
	//		Resize() functionality of ContentPane.   If there's a single layout widget
	//		child then it will call resize() with the same dimensions as the ContentPane.
	//		Otherwise just calls resize on each child.
	//
	//		Also implements basic startup() functionality, where starting the parent
	//		will start the children

	// doLayout: Boolean
	//		- false - don't adjust size of children
	//		- true - if there is a single visible child widget, set it's size to however big the ContentPane is
	doLayout: true,

	// isLayoutContainer: [protected] Boolean
	//		Indicates that this widget will call resize() on it's child widgets
	//		when they become visible.
	isLayoutContainer: true,

	startup: function(){
		// summary:
		//		See `dijit/layout/_LayoutWidget.startup()` for description.
		//		Although ContentPane doesn't extend _LayoutWidget, it does implement
		//		the same API.

		if(this._started){ return; }

		var parent = this.getParent();
		this._childOfLayoutWidget = parent && parent.isLayoutContainer;

		// I need to call resize() on my child/children (when I become visible), unless
		// I'm the child of a layout widget in which case my parent will call resize() on me and I'll do it then.
		this._needLayout = !this._childOfLayoutWidget;

		this.inherited(arguments);

		if(this._isShown()){
			this._onShow();
		}

		if(!this._childOfLayoutWidget){
			// Since my parent isn't a layout container, and my style *may be* width=height=100%
			// or something similar (either set directly or via a CSS class),
			// monitor when viewport size changes so that I can re-layout.
			// This is more for subclasses of ContentPane than ContentPane itself, although it
			// could be useful for a ContentPane if it has a single child widget inheriting ContentPane's size.
			this.own(Viewport.on("resize", lang.hitch(this, "resize")));
		}
	},

	_checkIfSingleChild: function(){
		// summary:
		//		Test if we have exactly one visible widget as a child,
		//		and if so assume that we are a container for that widget,
		//		and should propagate startup() and resize() calls to it.
		//		Skips over things like data stores since they aren't visible.

		var candidateWidgets = [],
			otherVisibleNodes = false;

		query("> *", this.containerNode).some(function(node){
			var widget = registry.byNode(node);
			if(widget && widget.resize){
				candidateWidgets.push(widget);
			}else if(node.offsetHeight){
				otherVisibleNodes = true;
			}
		});

		this._singleChild = candidateWidgets.length == 1 && !otherVisibleNodes ?
			candidateWidgets[0] : null;

		// So we can set overflow: hidden to avoid a safari bug w/scrollbars showing up (#9449)
		domClass.toggle(this.containerNode, this.baseClass + "SingleChild", !!this._singleChild);
	},

	resize: function(changeSize, resultSize){
		// summary:
		//		See `dijit/layout/_LayoutWidget.resize()` for description.
		//		Although ContentPane doesn't extend _LayoutWidget, it does implement
		//		the same API.

		this._resizeCalled = true;

		this._scheduleLayout(changeSize, resultSize);
	},

	_scheduleLayout: function(changeSize, resultSize){
		// summary:
		//		Resize myself, and call resize() on each of my child layout widgets, either now
		//		(if I'm currently visible) or when I become visible
		if(this._isShown()){
			this._layout(changeSize, resultSize);
		}else{
			this._needLayout = true;
			this._changeSize = changeSize;
			this._resultSize = resultSize;
		}
	},

	_layout: function(changeSize, resultSize){
		// summary:
		//		Resize myself according to optional changeSize/resultSize parameters, like a layout widget.
		//		Also, since I am an isLayoutContainer widget, each of my children expects me to
		//		call resize() or layout() on it.
		//
		//		Should be called on initialization and also whenever we get new content
		//		(from an href, or from set('content', ...))... but deferred until
		//		the ContentPane is visible

		delete this._needLayout;

		// For the TabContainer --> BorderContainer --> ContentPane case, _onShow() is
		// never called directly, so resize() is our trigger to do the initial href download (see [20099]).
		// However, don't load href for closed TitlePanes.
		if(!this._wasShown && this.open !== false){
			this._onShow();
		}

		// Set margin box size, unless it wasn't specified, in which case use current size.
		if(changeSize){
			domGeometry.setMarginBox(this.domNode, changeSize);
		}

		// Compute content box size of containerNode in case we [later] need to size our single child.
		var cn = this.containerNode;
		if(cn === this.domNode){
			// If changeSize or resultSize was passed to this method and this.containerNode ==
			// this.domNode then we can compute the content-box size without querying the node,
			// which is more reliable (similar to LayoutWidget.resize) (see for example #9449).
			var mb = resultSize || {};
			lang.mixin(mb, changeSize || {}); // changeSize overrides resultSize
			if(!("h" in mb) || !("w" in mb)){
				mb = lang.mixin(domGeometry.getMarginBox(cn), mb); // just use domGeometry.setMarginBox() to fill in missing values
			}
			this._contentBox = layoutUtils.marginBox2contentBox(cn, mb);
		}else{
			this._contentBox = domGeometry.getContentBox(cn);
		}

		this._layoutChildren();
	},

	_layoutChildren: function(){
		// Call _checkIfSingleChild() again in case app has manually mucked w/the content
		// of the ContentPane (rather than changing it through the set("content", ...) API.
		if(this.doLayout){
			this._checkIfSingleChild();
		}

		if(this._singleChild && this._singleChild.resize){
			var cb = this._contentBox || domGeometry.getContentBox(this.containerNode);

			// note: if widget has padding this._contentBox will have l and t set,
			// but don't pass them to resize() or it will doubly-offset the child
			this._singleChild.resize({w: cb.w, h: cb.h});
		}else{
			// All my child widgets are independently sized (rather than matching my size),
			// but I still need to call resize() on each child to make it layout.
			array.forEach(this.getChildren(), function(widget){
				if(widget.resize){
					widget.resize();
				}
			});
		}
	},

	_isShown: function(){
		// summary:
		//		Returns true if the content is currently shown.
		// description:
		//		If I am a child of a layout widget then it actually returns true if I've ever been visible,
		//		not whether I'm currently visible, since that's much faster than tracing up the DOM/widget
		//		tree every call, and at least solves the performance problem on page load by deferring loading
		//		hidden ContentPanes until they are first shown

		if(this._childOfLayoutWidget){
			// If we are TitlePane, etc - we return that only *IF* we've been resized
			if(this._resizeCalled && "open" in this){
				return this.open;
			}
			return this._resizeCalled;
		}else if("open" in this){
			return this.open;		// for TitlePane, etc.
		}else{
			var node = this.domNode, parent = this.domNode.parentNode;
			return (node.style.display != 'none') && (node.style.visibility != 'hidden') && !domClass.contains(node, "dijitHidden") &&
					parent && parent.style && (parent.style.display != 'none');
		}
	},

	_onShow: function(){
		// summary:
		//		Called when the ContentPane is made visible
		// description:
		//		For a plain ContentPane, this is called on initialization, from startup().
		//		If the ContentPane is a hidden pane of a TabContainer etc., then it's
		//		called whenever the pane is made visible.
		//
		//		Does layout/resize of child widget(s)

		// Need to keep track of whether ContentPane has been shown (which is different than
		// whether or not it's currently visible).
		this._wasShown = true;

		if(this._needLayout){
			// If a layout has been scheduled for when we become visible, do it now
			this._layout(this._changeSize, this._resultSize);
		}

		this.inherited(arguments);
	}
});

});

},
'dojo/dnd/Moveable':function(){
define([
	"../_base/array", "../_base/declare", "../_base/event", "../_base/lang",
	"../dom", "../dom-class", "../Evented", "../on", "../topic", "../touch", "./common", "./Mover", "../_base/window"
], function(array, declare, event, lang, dom, domClass, Evented, on, topic, touch, dnd, Mover, win){

// module:
//		dojo/dnd/Moveable


var Moveable = declare("dojo.dnd.Moveable", [Evented], {
	// summary:
	//		an object, which makes a node movable

	// object attributes (for markup)
	handle: "",
	delay: 0,
	skip: false,

	constructor: function(node, params){
		// node: Node
		//		a node (or node's id) to be moved
		// params: Moveable.__MoveableArgs?
		//		optional parameters
		this.node = dom.byId(node);
		if(!params){ params = {}; }
		this.handle = params.handle ? dom.byId(params.handle) : null;
		if(!this.handle){ this.handle = this.node; }
		this.delay = params.delay > 0 ? params.delay : 0;
		this.skip  = params.skip;
		this.mover = params.mover ? params.mover : Mover;
		this.events = [
			on(this.handle, touch.press, lang.hitch(this, "onMouseDown")),
			// cancel text selection and text dragging
			on(this.handle, "dragstart",   lang.hitch(this, "onSelectStart")),
			on(this.handle, "selectstart",   lang.hitch(this, "onSelectStart"))
		];
	},

	// markup methods
	markupFactory: function(params, node, Ctor){
		return new Ctor(node, params);
	},

	// methods
	destroy: function(){
		// summary:
		//		stops watching for possible move, deletes all references, so the object can be garbage-collected
		array.forEach(this.events, function(handle){ handle.remove(); });
		this.events = this.node = this.handle = null;
	},

	// mouse event processors
	onMouseDown: function(e){
		// summary:
		//		event processor for onmousedown/ontouchstart, creates a Mover for the node
		// e: Event
		//		mouse/touch event
		if(this.skip && dnd.isFormElement(e)){ return; }
		if(this.delay){
			this.events.push(
				on(this.handle, touch.move, lang.hitch(this, "onMouseMove")),
				on(this.handle, touch.release, lang.hitch(this, "onMouseUp"))
			);
			this._lastX = e.pageX;
			this._lastY = e.pageY;
		}else{
			this.onDragDetected(e);
		}
		event.stop(e);
	},
	onMouseMove: function(e){
		// summary:
		//		event processor for onmousemove/ontouchmove, used only for delayed drags
		// e: Event
		//		mouse/touch event
		if(Math.abs(e.pageX - this._lastX) > this.delay || Math.abs(e.pageY - this._lastY) > this.delay){
			this.onMouseUp(e);
			this.onDragDetected(e);
		}
		event.stop(e);
	},
	onMouseUp: function(e){
		// summary:
		//		event processor for onmouseup, used only for delayed drags
		// e: Event
		//		mouse event
		for(var i = 0; i < 2; ++i){
			this.events.pop().remove();
		}
		event.stop(e);
	},
	onSelectStart: function(e){
		// summary:
		//		event processor for onselectevent and ondragevent
		// e: Event
		//		mouse event
		if(!this.skip || !dnd.isFormElement(e)){
			event.stop(e);
		}
	},

	// local events
	onDragDetected: function(/*Event*/ e){
		// summary:
		//		called when the drag is detected;
		//		responsible for creation of the mover
		new this.mover(this.node, e, this);
	},
	onMoveStart: function(/*Mover*/ mover){
		// summary:
		//		called before every move operation
		topic.publish("/dnd/move/start", mover);
		domClass.add(win.body(), "dojoMove");
		domClass.add(this.node, "dojoMoveItem");
	},
	onMoveStop: function(/*Mover*/ mover){
		// summary:
		//		called after every move operation
		topic.publish("/dnd/move/stop", mover);
		domClass.remove(win.body(), "dojoMove");
		domClass.remove(this.node, "dojoMoveItem");
	},
	onFirstMove: function(/*===== mover, e =====*/){
		// summary:
		//		called during the very first move notification;
		//		can be used to initialize coordinates, can be overwritten.
		// mover: Mover
		// e: Event

		// default implementation does nothing
	},
	onMove: function(mover, leftTop /*=====, e =====*/){
		// summary:
		//		called during every move notification;
		//		should actually move the node; can be overwritten.
		// mover: Mover
		// leftTop: Object
		// e: Event
		this.onMoving(mover, leftTop);
		var s = mover.node.style;
		s.left = leftTop.l + "px";
		s.top  = leftTop.t + "px";
		this.onMoved(mover, leftTop);
	},
	onMoving: function(/*===== mover, leftTop =====*/){
		// summary:
		//		called before every incremental move; can be overwritten.
		// mover: Mover
		// leftTop: Object

		// default implementation does nothing
	},
	onMoved: function(/*===== mover, leftTop =====*/){
		// summary:
		//		called after every incremental move; can be overwritten.
		// mover: Mover
		// leftTop: Object

		// default implementation does nothing
	}
});

/*=====
Moveable.__MoveableArgs = declare([], {
	// handle: Node||String
	//		A node (or node's id), which is used as a mouse handle.
	//		If omitted, the node itself is used as a handle.
	handle: null,

	// delay: Number
	//		delay move by this number of pixels
	delay: 0,

	// skip: Boolean
	//		skip move of form elements
	skip: false,

	// mover: Object
	//		a constructor of custom Mover
	mover: dnd.Mover
});
=====*/

return Moveable;
});

},
'dojo/store/util/SimpleQueryEngine':function(){
define(["../../_base/array" /*=====, "../api/Store" =====*/], function(arrayUtil /*=====, Store =====*/){

// module:
//		dojo/store/util/SimpleQueryEngine

return function(query, options){
	// summary:
	//		Simple query engine that matches using filter functions, named filter
	//		functions or objects by name-value on a query object hash
	//
	// description:
	//		The SimpleQueryEngine provides a way of getting a QueryResults through
	//		the use of a simple object hash as a filter.  The hash will be used to
	//		match properties on data objects with the corresponding value given. In
	//		other words, only exact matches will be returned.
	//
	//		This function can be used as a template for more complex query engines;
	//		for example, an engine can be created that accepts an object hash that
	//		contains filtering functions, or a string that gets evaluated, etc.
	//
	//		When creating a new dojo.store, simply set the store's queryEngine
	//		field as a reference to this function.
	//
	// query: Object
	//		An object hash with fields that may match fields of items in the store.
	//		Values in the hash will be compared by normal == operator, but regular expressions
	//		or any object that provides a test() method are also supported and can be
	//		used to match strings by more complex expressions
	//		(and then the regex's or object's test() method will be used to match values).
	//
	// options: dojo/store/api/Store.QueryOptions?
	//		An object that contains optional information such as sort, start, and count.
	//
	// returns: Function
	//		A function that caches the passed query under the field "matches".  See any
	//		of the "query" methods on dojo.stores.
	//
	// example:
	//		Define a store with a reference to this engine, and set up a query method.
	//
	//	|	var myStore = function(options){
	//	|		//	...more properties here
	//	|		this.queryEngine = SimpleQueryEngine;
	//	|		//	define our query method
	//	|		this.query = function(query, options){
	//	|			return QueryResults(this.queryEngine(query, options)(this.data));
	//	|		};
	//	|	};

	// create our matching query function
	switch(typeof query){
		default:
			throw new Error("Can not query with a " + typeof query);
		case "object": case "undefined":
			var queryObject = query;
			query = function(object){
				for(var key in queryObject){
					var required = queryObject[key];
					if(required && required.test){
						// an object can provide a test method, which makes it work with regex
						if(!required.test(object[key], object)){
							return false;
						}
					}else if(required != object[key]){
						return false;
					}
				}
				return true;
			};
			break;
		case "string":
			// named query
			if(!this[query]){
				throw new Error("No filter function " + query + " was found in store");
			}
			query = this[query];
			// fall through
		case "function":
			// fall through
	}
	function execute(array){
		// execute the whole query, first we filter
		var results = arrayUtil.filter(array, query);
		// next we sort
		var sortSet = options && options.sort;
		if(sortSet){
			results.sort(typeof sortSet == "function" ? sortSet : function(a, b){
				for(var sort, i=0; sort = sortSet[i]; i++){
					var aValue = a[sort.attribute];
					var bValue = b[sort.attribute];
					if (aValue != bValue){
						return !!sort.descending == (aValue == null || aValue > bValue) ? -1 : 1;
					}
				}
				return 0;
			});
		}
		// now we paginate
		if(options && (options.start || options.count)){
			var total = results.length;
			results = results.slice(options.start || 0, (options.start || 0) + (options.count || Infinity));
			results.total = total;
		}
		return results;
	}
	execute.matches = query;
	return execute;
};

});

},
'davinci/Runtime':function(){
define([
	"dojo/i18n!./nls/webContent",
	"./commands/CommandStack",
	"./ui.plugin",
	"./html/html.plugin",
	"./js/js.plugin",
	"./ve/ve.plugin",
	"./ve/themeEditor/themeEditor.plugin",
	"./review/review.plugin",
	"./UserActivityMonitor"
], function(
	webContent,
	CommandStack,
	ui_plugin,
	html_plugin,
	js_plugin,
	ve_plugin,
	themeEditor_plugin,
	review_plugin,
	UserActivityMonitor
) {

// list of plugins to load
var plugins = [
	ui_plugin,
	html_plugin,
	js_plugin,
	ve_plugin,
	themeEditor_plugin,
	review_plugin
];

var Runtime = {
	plugins: [],
	extensionPoints: [],
	subscriptions: [],
	currentSelection: [],
	commandStack: new CommandStack(),

	getUser: function() {
		return this._initializationInfo.userInfo;
	},

	getWorkbenchState: function() {
		return this._initializationInfo.workbenchState;
	},

	/**
	 * Returns the site-specific data for "name"
	 * @param name {string}  Site-specific data index (e.g., "defaultThemeSet")
	 * @returns
	 */
	getSiteConfigData: function(name){
		return this._initializationInfo[name];
	},

	getDefaultThemeSet: function() {
		return this.getSiteConfigData("defaultThemeSet");
	},
	
	/*
	 * Based on the information available, provides an appropriate string to
	 * display that identifies the user. 
	 * 
	 * userInfo should be of the form:
	 * 
	 * 		{
	 * 			email: "person@place.com",
	 *			isLocalInstall: "false",
	 * 			userDisplayName: "",
	 *			userId: "A";
	 * 		}
	 * 
	 * Because of the current user sign-up we have with Orion, we're not making 
	 * any attempt to honor userId. In the future, it would be nice if the server
	 * could signal us if userId is appropriate.
	 * 
	 * If userInfo is undefined, then the function will look up the info for the
	 * current user.
	 * 
	 */
	getUserDisplayName: function(userInfo) {
		if (!userInfo) {
			userInfo = this.getUser();
		}

		// Can't reliably use userId anymore (because of Orion), so first try first name and then
		// drop back to e-mail
		var displayName = userInfo.userDisplayName;
		if (!userInfo.userDisplayName) {
			displayName = userInfo.email;
		}
		return displayName;		
	},

	getUserEmail: function(userInfo) {
		if (!userInfo) {
			userInfo = this.getUser();
		}
		return userInfo.email;
	},

	/*
	 * The goal is to return a string of the form:
	 * 
	 * 		displayName <email>
	 * 
	 * such as
	 * 
	 * 		Joe <joesmith@place.com>
	 * 
	 * but if displayName = email, then email will be returned.
	 * 
	 */
	getUserDisplayNamePlusEmail: function(userInfo) {
		if (!userInfo) {
			userInfo = this.getUser();
		}
		
		var result = this.getUserDisplayName(userInfo);
		
		if (result != userInfo.email) {
			result += " &lt;" + userInfo.email + "&gt;";
		}

		return result;
	},
	
	loadPlugins: function() {
		plugins.forEach(function(plugin) {
			var pluginID = plugin.id;
			Runtime.plugins[pluginID] = plugin;
			for (var id in plugin) {
				var extension = plugin[id];
				if (typeof extension != "string") {
					if (extension instanceof Array) {
						extension.forEach(function(ext) {
							Runtime._addExtension(id, ext, pluginID);
						});
					} else {
						Runtime._addExtension(id, extension, pluginID);
					}
				}
			}
		});
	},

	singleUserMode: function() {
		return Runtime.isLocalInstall;
	},

	/*
	 * If in single user mode, returns the current active project.
	 * 
	 */
	
	location: function(){
		return document.location.href.split("?")[0];
	},

	getUserWorkspaceUrl: function(){
		var loc = this.location();
		if (loc.slice(-1) == '/') {
			loc = loc.slice(0, -1);
		}
		return loc+'/user/'+Runtime.userName+'/ws/workspace/';
	},

	run: function() {
		// add class to root HTML element to indicate if mac or windows
		// this is because of different alignment on mac/chrome vs win/chrome
		// FIXME: this platform-dependent logic might not be necessary if
		// main toolbar changes or different CSS applies to that toolbar
		if (dojo.isMac) {
			dojo.addClass(document.documentElement,"isMac");
		}
		
	    // determine if the browser supports CSS3 transitions
	    var thisStyle = document.body.style;
	    Runtime.supportsCSS3Transitions = thisStyle.WebkitTransition !== undefined ||
	        thisStyle.MozTransition !== undefined ||
	        thisStyle.OTransition !== undefined ||
	        thisStyle.transition !== undefined;
		
		Runtime.subscribe("/davinci/ui/selectionChanged",Runtime._selectionChanged);
		
		// intercept BS key - prompt user before navigating backwards
		dojo.connect(dojo.doc.documentElement, "onkeypress", function(e){
			if(e.charOrCode==8){
				window.davinciBackspaceKeyTime = Date.now();
			}
		});	
		UserActivityMonitor.setUpInActivityMonitor(dojo.doc, this);

		// add key press listener
		dojo.connect(dojo.doc.documentElement, "onkeydown", this, "_handleGlobalDocumentKeyEvent");
				
		dojo.addOnUnload(function (e) {
			//This will hold a warning message (if any) that we'll want to display to the
			//user.
			var message = null;
			
			//Loop through all of the editor containers and give them a chance to tell us
			//the user should be warned before leaving the page.
			var editorContainers = (davinci.Workbench && davinci.Workbench.editorTabs) ? 
					davinci.Workbench.editorTabs.getChildren() : [];
			var editorsWithWarningsCount = 0;
			for (var i = 0; i < editorContainers.length; i++) {
				var editorContainer = editorContainers[i];
				if (editorContainer.editor) {
					var editorResponse = editorContainer.editor.getOnUnloadWarningMessage();

					if (editorResponse) {
						//Let's keep track of the first message. If we end up finding multiple messages, we'll
						//augment what the user will see shortly.
						if (!message) {
							message = editorResponse;
						}
						editorsWithWarningsCount++;
					}
				}
			}
			//If multiple warnings, augment message user will see
			if (editorsWithWarningsCount > 1) {
				message = dojo.string.substitute(webContent.multipleFilesUnsaved, [message, editorsWithWarningsCount]);
			}
			
			if (!message) {
				//No warnings so far, let's see if use maybe accidentally hit backspace
				var shouldDisplayForBackspace = Date.now() - window.davinciBackspaceKeyTime < 100;
				if (shouldDisplayForBackspace) {
					message = webContent.careful;
				}
			}
			
			if (message) {
				// We've found warnings, so we want to warn the user they run the risk of 
				// losing data if they leave the page.
				
				// For Mozilla/IE, we need to see the return value directly on the 
				// event. But, note in FF 4 and later that the browser ignores our
				// message and uses a default message of its own.
				if (e = e || window.event) {
					e.returnValue = message;
				}
				
				// For other browsers (like Chrome), the message returned by the
				// handler is honored.
				return message;
			}
		});
	},
	
	subscribe: function(topic,func) {
		Runtime.subscriptions.push(dojo.subscribe(topic,this,func));
	},
	
	destroy: function() {
		dojo.forEach(Runtime.subscriptions, dojo.unsubscribe);
	},
	
	_addExtension: function(id, extension, pluginID) {
		if (extension.id) {
			extension.id = pluginID + "." + extension.id;
		}

		Runtime.extensionPoints[id] = Runtime.extensionPoints[id] || [];
		var extensions = Runtime.extensionPoints[id];
		extensions.push(extension);
		Runtime.extensionPoints[id] = extensions;
	},
	
	getExtensions: function(extensionID, testFunction) {
		
		var extensions = Runtime.extensionPoints[extensionID];
		if (testFunction) {
			var matching=[];
			var isFunction = testFunction instanceof Function;
			if (extensions) {
				return extensions.filter(function(ext) {
					return (isFunction && testFunction(ext)) || ext.id == testFunction;
				});
			}
		}
		return extensions;
	},
	
	getExtension: function(extensionID, testFunction) {
		return Runtime.getExtensions(extensionID, testFunction)[0];
	},

	handleError: function(error) {
		var redirectUrl = "welcome";
		if(Runtime.singleUserMode()){
			redirectUrl = ".";
		}
		
		window.document.body.innerHTML = dojo.string.substitute(webContent.serverConnectError, {redirectUrl:redirectUrl, error: error});
	},

	executeCommand: function(cmdID) {
		var cmd=Runtime.getExtension("davinci.commands", cmdID);
		if (cmd && cmd.run) {
			cmd.run();
		}
	},
	
	_selectionChanged: function(selection) {
		Runtime.currentSelection=selection;
	},
	
	getSelection: function() {
		return Runtime.currentSelection;
	},

	// deprecated.  will fail for async.  use dojo/_base/xhr directly
	serverJSONRequest: function (ioArgs) {
		var resultObj;
		var args = {handleAs: "json"};
		dojo.mixin(args, ioArgs);

		dojo.xhrGet(args).then(function(result) {
			if (result) {
				resultObj=result;
			}
		});

		return resultObj;
	},

	registerKeyBinding: function(keyBinding, pluginAction) {
		if (!this._globalKeyBindings) {
			this._globalKeyBindings = [];
		}

		this._globalKeyBindings.push({keyBinding: keyBinding, action: pluginAction});
	},

	/* called by any widgets that pass in events from other documents, so iframes from editors */
	handleKeyEvent: function(e) {
		this._handleKeyEvent(e, true);
	},

	/* called when events are trigged on the main document */
	_handleGlobalDocumentKeyEvent: function(e) {
		this._handleKeyEvent(e);
	},

	_handleKeyEvent: function(e, isFromSubDocument) {
		if (!this._globalKeyBindings) {
			return;
		}

		var stopEvent = false;

		stopEvent = dojo.some(this._globalKeyBindings, dojo.hitch(this, function(globalBinding) {
			if (Runtime.isKeyEqualToEvent(globalBinding.keyBinding, e)) {
				davinci.Workbench._runAction(globalBinding.action);
				return true;
			}
		}));

		if (stopEvent) {
			dojo.stopEvent(e);
		} else if (!isFromSubDocument) {
			// if not from sub document, let the active editor take a stab
			if (this.currentEditor && this.currentEditor.handleKeyEvent) {
				// pass in true to tell it its a global event
				this.currentEditor.handleKeyEvent(e, true);
			}
		}
	},

	// compares keybinding to event
	isKeyEqualToEvent: function(keybinding, e) {
		var equal = true;

		var hasAccel = ((e.ctrlKey && !dojo.isMac) || (dojo.isMac && e.metaKey))
		var hasMeta = ((e.altKey && !dojo.isMac) || (dojo.isMac && e.ctrlKey))


		if (!!keybinding.accel !== hasAccel) {
			equal = false;
		}

		if (!!keybinding.meta !== hasMeta) {
			equal = false;
		}

		if (!!keybinding.shift !== e.shiftKey) {
			equal = false;
		}

		if (equal && keybinding.charOrCode && e.which) {
			if (dojo.isArray(keybinding.charOrCode)) {
				equal = dojo.some(keybinding.charOrCode, dojo.hitch(this, function(charOrCode) {
					return this._comparecharOrCode(charOrCode, e);
				}));
			} else {
				equal = this._comparecharOrCode(keybinding.charOrCode, e);
			}
		}

		return equal;
	},

	_comparecharOrCode: function(charOrCode, e) {
		var equal;

		if (dojo.isString(charOrCode)) {
			// if we have a string, use fromCharCode
			equal = (charOrCode.toLowerCase() === String.fromCharCode(e.which).toLowerCase());
		} else {
			equal = (charOrCode === e.which);
		}

		return equal;
	}
};

return Runtime;
});

},
'davinci/js/JSFile':function(){
/**
 * @class davinci.js.JSFile
 * @constructor
 * @extends davinci.js.JSElement
 */
define([
	"dojo/_base/declare",
	"davinci/js/JSElement"
], function(declare, JSElement) {

return declare("davinci.js.JSFile", JSElement, {

	constructor: function(origin) {
		this.elementType = "JSFile";
		this.nosemicolon = true;
		this._textContent = "";
		// id only, never loaded
		if (origin) {
			this.origin = origin;
		}
	},

	getText: function(context) {
		return this._textContent;
	},

	setText: function(text) {
		this._textContent = text;
	},

	getLabel: function() {
		return this.fileName;
	},

	getID: function() {
		return this.fileName;
	},

	visit: function(visitor) {
		var dontVisitChildren;

		dontVisitChildren = visitor.visit(this);
		if (!dontVisitChildren) {
			for ( var i = 0; i < this.children.length; i++ ) {
				this.children[i].visit(visitor);
			}
		}
		if (visitor.endVisit) {
			visitor.endVisit(this);
		}
	}

});
});
},
'dojox/grid/_View':function(){
define([
	"dojo",
	"dijit/registry",
	"../main",
	"dojo/_base/declare",
	"dojo/_base/array",
	"dojo/_base/lang",
	"dojo/_base/connect",
	"dojo/_base/sniff",
	"dojo/query",
	"dojo/_base/window",
	"dojo/text!./resources/View.html",
	"dojo/dnd/Source",
	"dijit/_Widget",
	"dijit/_TemplatedMixin",
	"dojox/html/metrics",
	"./util",
	"dojo/_base/html",
	"./_Builder",
	"dojo/dnd/Avatar",
	"dojo/dnd/Manager"
], function(dojo, dijit, dojox, declare, array, lang, connect, has, query,
	win, template, Source, _Widget, _TemplatedMixin, metrics, util, html, _Builder, Avatar, Manager){

	// a private function
	var getStyleText = function(inNode, inStyleText){
		return inNode.style.cssText == undefined ? inNode.getAttribute("style") : inNode.style.cssText;
	};

	// some public functions
	var _View = declare('dojox.grid._View', [_Widget, _TemplatedMixin], {
		// summary:
		//		A collection of grid columns. A grid is comprised of a set of views that stack horizontally.
		//		Grid creates views automatically based on grid's layout structure.
		//		Users should typically not need to access individual views directly.
		//
		// defaultWidth: String
		//		Default width of the view
		defaultWidth: "18em",

		// viewWidth: String
		//		Width for the view, in valid css unit
		viewWidth: "",

		templateString: template,

		classTag: 'dojoxGrid',
		marginBottom: 0,
		rowPad: 2,

		// _togglingColumn: int
		//		Width of the column being toggled (-1 for none)
		_togglingColumn: -1,
		
		// _headerBuilderClass: Object
		//		The class to use for our header builder
		_headerBuilderClass: _Builder._HeaderBuilder,
		
		// _contentBuilderClass: Object
		//		The class to use for our content builder
		_contentBuilderClass: _Builder._ContentBuilder,
		
		postMixInProperties: function(){
			this.rowNodes = {};
		},

		postCreate: function(){
			this.connect(this.scrollboxNode,"onscroll","doscroll");
			util.funnelEvents(this.contentNode, this, "doContentEvent", [ 'mouseover', 'mouseout', 'click', 'dblclick', 'contextmenu', 'mousedown' ]);
			util.funnelEvents(this.headerNode, this, "doHeaderEvent", [ 'dblclick', 'mouseover', 'mouseout', 'mousemove', 'mousedown', 'click', 'contextmenu' ]);
			this.content = new this._contentBuilderClass(this);
			this.header = new this._headerBuilderClass(this);
			//BiDi: in RTL case, style width='9000em' causes scrolling problem in head node
			if(!this.grid.isLeftToRight()){
				this.headerNodeContainer.style.width = "";
			}
		},

		destroy: function(){
			html.destroy(this.headerNode);
			delete this.headerNode;
			for(var i in this.rowNodes){
				this._cleanupRowWidgets(this.rowNodes[i]);
				html.destroy(this.rowNodes[i]);
			}
			this.rowNodes = {};
			if(this.source){
				this.source.destroy();
			}
			this.inherited(arguments);
		},

		// focus
		focus: function(){
			if(has('ie') || has('webkit') || has('opera')){
				this.hiddenFocusNode.focus();
			}else{
				this.scrollboxNode.focus();
			}
		},

		setStructure: function(inStructure){
			var vs = (this.structure = inStructure);
			// FIXME: similar logic is duplicated in layout
			if(vs.width && !isNaN(vs.width)){
				this.viewWidth = vs.width + 'em';
			}else{
				this.viewWidth = vs.width || (vs.noscroll ? 'auto' : this.viewWidth); //|| this.defaultWidth;
			}
			this._onBeforeRow = vs.onBeforeRow||function(){};
			this._onAfterRow = vs.onAfterRow||function(){};
			this.noscroll = vs.noscroll;
			if(this.noscroll){
				this.scrollboxNode.style.overflow = "hidden";
			}
			this.simpleStructure = Boolean(vs.cells.length == 1);
			// bookkeeping
			this.testFlexCells();
			// accomodate new structure
			this.updateStructure();
		},
		
		_cleanupRowWidgets: function(inRowNode){
			// Summary:
			//		Cleans up the widgets for the given row node so that
			//		we can reattach them if needed
			if(inRowNode){
				array.forEach(query("[widgetId]", inRowNode).map(dijit.byNode), function(w){
					if(w._destroyOnRemove){
						w.destroy();
						delete w;
					}else if(w.domNode && w.domNode.parentNode){
						w.domNode.parentNode.removeChild(w.domNode);
					}
				});
			}
		},
		
		onBeforeRow: function(inRowIndex, cells){
			this._onBeforeRow(inRowIndex, cells);
			if(inRowIndex >= 0){
				this._cleanupRowWidgets(this.getRowNode(inRowIndex));
			}
		},
		
		onAfterRow: function(inRowIndex, cells, inRowNode){
			this._onAfterRow(inRowIndex, cells, inRowNode);
			var g = this.grid;
			array.forEach(query(".dojoxGridStubNode", inRowNode), function(n){
				if(n && n.parentNode){
					var lw = n.getAttribute("linkWidget");
					var cellIdx = window.parseInt(html.attr(n, "cellIdx"), 10);
					var cellDef = g.getCell(cellIdx);
					var w = dijit.byId(lw);
					if(w){
						n.parentNode.replaceChild(w.domNode, n);
						if(!w._started){
							w.startup();
						}
						dojo.destroy(n);
					}else{
						n.innerHTML = "";
					}
				}
			}, this);
		},

		testFlexCells: function(){
			// FIXME: cheater, this function does double duty as initializer and tester
			this.flexCells = false;
			for(var j=0, row; (row=this.structure.cells[j]); j++){
				for(var i=0, cell; (cell=row[i]); i++){
					cell.view = this;
					this.flexCells = this.flexCells || cell.isFlex();
				}
			}
			return this.flexCells;
		},

		updateStructure: function(){
			// header builder needs to update table map
			this.header.update();
			// content builder needs to update markup cache
			this.content.update();
		},

		getScrollbarWidth: function(){
			var hasScrollSpace = this.hasVScrollbar();
			var overflow = html.style(this.scrollboxNode, "overflow");
			if(this.noscroll || !overflow || overflow == "hidden"){
				hasScrollSpace = false;
			}else if(overflow == "scroll"){
				hasScrollSpace = true;
			}
			return (hasScrollSpace ? metrics.getScrollbar().w : 0); // Integer
		},

		getColumnsWidth: function(){
			var h = this.headerContentNode;
			return h && h.firstChild ? (h.firstChild.offsetWidth || html.style(h.firstChild, 'width')) : 0; // Integer
		},

		setColumnsWidth: function(width){
			this.headerContentNode.firstChild.style.width = width + 'px';
			if(this.viewWidth){
				this.viewWidth = width + 'px';
			}
		},

		getWidth: function(){
			return this.viewWidth || (this.getColumnsWidth()+this.getScrollbarWidth()) +'px'; // String
		},

		getContentWidth: function(){
			return Math.max(0, html._getContentBox(this.domNode).w - this.getScrollbarWidth()) + 'px'; // String
		},

		render: function(){
			this.scrollboxNode.style.height = '';
			this.renderHeader();
			if(this._togglingColumn >= 0){
				this.setColumnsWidth(this.getColumnsWidth() - this._togglingColumn);
				this._togglingColumn = -1;
			}
			var cells = this.grid.layout.cells;
			var getSibling = lang.hitch(this, function(node, before){
				!this.grid.isLeftToRight() && (before = !before);
				var inc = before?-1:1;
				var idx = this.header.getCellNodeIndex(node) + inc;
				var cell = cells[idx];
				while(cell && cell.getHeaderNode() && cell.getHeaderNode().style.display == "none"){
					idx += inc;
					cell = cells[idx];
				}
				if(cell){
					return cell.getHeaderNode();
				}
				return null;
			});
			if(this.grid.columnReordering && this.simpleStructure){
				if(this.source){
					this.source.destroy();
				}
				
				// Create the top and bottom markers
				var bottomMarkerId = "dojoxGrid_bottomMarker";
				var topMarkerId = "dojoxGrid_topMarker";
				if(this.bottomMarker){
					html.destroy(this.bottomMarker);
				}
				this.bottomMarker = html.byId(bottomMarkerId);
				if(this.topMarker){
					html.destroy(this.topMarker);
				}
				this.topMarker = html.byId(topMarkerId);
				if (!this.bottomMarker) {
					this.bottomMarker = html.create("div", {
						"id": bottomMarkerId,
						"class": "dojoxGridColPlaceBottom"
					}, win.body());
					this._hide(this.bottomMarker);

					
					this.topMarker = html.create("div", {
						"id": topMarkerId,
						"class": "dojoxGridColPlaceTop"
					}, win.body());
					this._hide(this.topMarker);
				}
				this.arrowDim = html.contentBox(this.bottomMarker);

				var headerHeight = html.contentBox(this.headerContentNode.firstChild.rows[0]).h;
				
				this.source = new Source(this.headerContentNode.firstChild.rows[0], {
					horizontal: true,
					accept: [ "gridColumn_" + this.grid.id ],
					viewIndex: this.index,
					generateText: false,
					onMouseDown: lang.hitch(this, function(e){
						this.header.decorateEvent(e);
						if((this.header.overRightResizeArea(e) || this.header.overLeftResizeArea(e)) &&
							this.header.canResize(e) && !this.header.moveable){
							this.header.beginColumnResize(e);
						}else{
							if(this.grid.headerMenu){
								this.grid.headerMenu.onCancel(true);
							}
							// IE reports a left click as 1, where everything else reports 0
							if(e.button === (has('ie') < 9 ? 1 : 0)){
								Source.prototype.onMouseDown.call(this.source, e);
							}
						}
					}),
					onMouseOver: lang.hitch(this, function(e){
						var src = this.source;
						if(src._getChildByEvent(e)){
							Source.prototype.onMouseOver.apply(src, arguments);
						}
					}),
					_markTargetAnchor: lang.hitch(this, function(before){
						var src = this.source;
						if(src.current == src.targetAnchor && src.before == before){ return; }
						if(src.targetAnchor && getSibling(src.targetAnchor, src.before)){
							src._removeItemClass(getSibling(src.targetAnchor, src.before), src.before ? "After" : "Before");
						}
						Source.prototype._markTargetAnchor.call(src, before);
						
						var target = before ? src.targetAnchor : getSibling(src.targetAnchor, src.before);
						var endAdd = 0;

						if (!target) {
							target = src.targetAnchor;
							endAdd = html.contentBox(target).w + this.arrowDim.w/2 + 2;
						}

						var pos = html.position(target, true);
						var left = Math.floor(pos.x - this.arrowDim.w/2 + endAdd);

						html.style(this.bottomMarker, "visibility", "visible");
						html.style(this.topMarker, "visibility", "visible");
						html.style(this.bottomMarker, {
							"left": left + "px",
							"top" : (headerHeight + pos.y) + "px"
						});

						html.style(this.topMarker, {
							"left": left + "px",
							"top" : (pos.y - this.arrowDim.h) + "px"
						});

						if(src.targetAnchor && getSibling(src.targetAnchor, src.before)){
							src._addItemClass(getSibling(src.targetAnchor, src.before), src.before ? "After" : "Before");
						}
					}),
					_unmarkTargetAnchor: lang.hitch(this, function(){
						var src = this.source;
						if(!src.targetAnchor){ return; }
						if(src.targetAnchor && getSibling(src.targetAnchor, src.before)){
							src._removeItemClass(getSibling(src.targetAnchor, src.before), src.before ? "After" : "Before");
						}
						this._hide(this.bottomMarker);
						this._hide(this.topMarker);
						Source.prototype._unmarkTargetAnchor.call(src);
					}),
					destroy: lang.hitch(this, function(){
						connect.disconnect(this._source_conn);
						connect.unsubscribe(this._source_sub);
						Source.prototype.destroy.call(this.source);
						if(this.bottomMarker){
							html.destroy(this.bottomMarker);
							delete this.bottomMarker;
						}
						if(this.topMarker){
							html.destroy(this.topMarker);
							delete this.topMarker;
						}
					}),
					onDndCancel: lang.hitch(this, function(){
						Source.prototype.onDndCancel.call(this.source);
						this._hide(this.bottomMarker);
						this._hide(this.topMarker);
					})
				});

				this._source_conn = connect.connect(this.source, "onDndDrop", this, "_onDndDrop");
				this._source_sub = connect.subscribe("/dnd/drop/before", this, "_onDndDropBefore");
				this.source.startup();
			}
		},
		
		_hide: function(node){
			html.style(node, {
				top: "-10000px",
				"visibility": "hidden"
			});
		},

		_onDndDropBefore: function(source, nodes, copy){
			if(Manager.manager().target !== this.source){
				return;
			}
			this.source._targetNode = this.source.targetAnchor;
			this.source._beforeTarget = this.source.before;
			var views = this.grid.views.views;
			var srcView = views[source.viewIndex];
			var tgtView = views[this.index];
			if(tgtView != srcView){
				srcView.convertColPctToFixed();
				tgtView.convertColPctToFixed();
			}
		},

		_onDndDrop: function(source, nodes, copy){
			if(Manager.manager().target !== this.source){
				if(Manager.manager().source === this.source){
					this._removingColumn = true;
				}
				return;
			}
			this._hide(this.bottomMarker);
			this._hide(this.topMarker);

			var getIdx = function(n){
				return n ? html.attr(n, "idx") : null;
			};
			var w = html.marginBox(nodes[0]).w;
			if(source.viewIndex !== this.index){
				var views = this.grid.views.views;
				var srcView = views[source.viewIndex];
				var tgtView = views[this.index];
				if(srcView.viewWidth && srcView.viewWidth != "auto"){
					srcView.setColumnsWidth(srcView.getColumnsWidth() - w);
				}
				if(tgtView.viewWidth && tgtView.viewWidth != "auto"){
					tgtView.setColumnsWidth(tgtView.getColumnsWidth());
				}
			}
			var stn = this.source._targetNode;
			var stb = this.source._beforeTarget;
			!this.grid.isLeftToRight() && (stb = !stb);
			var layout = this.grid.layout;
			var idx = this.index;
			delete this.source._targetNode;
			delete this.source._beforeTarget;
			
			layout.moveColumn(
				source.viewIndex,
				idx,
				getIdx(nodes[0]),
				getIdx(stn),
				stb);
		},

		renderHeader: function(){
			this.headerContentNode.innerHTML = this.header.generateHtml(this._getHeaderContent);
			if(this.flexCells){
				this.contentWidth = this.getContentWidth();
				this.headerContentNode.firstChild.style.width = this.contentWidth;
			}
			util.fire(this, "onAfterRow", [-1, this.structure.cells, this.headerContentNode]);
		},

		// note: not called in 'view' context
		_getHeaderContent: function(inCell){
			var n = inCell.name || inCell.grid.getCellName(inCell);
			if(/^\s+$/.test(n)){
				n = '&nbsp;'//otherwise arrow styles will be messed up
			}
			var ret = [ '<div class="dojoxGridSortNode' ];
			
			if(inCell.index != inCell.grid.getSortIndex()){
				ret.push('">');
			}else{
				ret = ret.concat([ ' ',
							inCell.grid.sortInfo > 0 ? 'dojoxGridSortUp' : 'dojoxGridSortDown',
							'"><div class="dojoxGridArrowButtonChar">',
							inCell.grid.sortInfo > 0 ? '&#9650;' : '&#9660;',
							'</div><div class="dojoxGridArrowButtonNode" role="presentation"></div>',
							'<div class="dojoxGridColCaption">']);
			}
			ret = ret.concat([n, '</div></div>']);
			return ret.join('');
		},

		resize: function(){
			this.adaptHeight();
			this.adaptWidth();
		},

		hasHScrollbar: function(reset){
			var hadScroll = this._hasHScroll||false;
			if(this._hasHScroll == undefined || reset){
				if(this.noscroll){
					this._hasHScroll = false;
				}else{
					var style = html.style(this.scrollboxNode, "overflow");
					if(style == "hidden"){
						this._hasHScroll = false;
					}else if(style == "scroll"){
						this._hasHScroll = true;
					}else{
						this._hasHScroll = (this.scrollboxNode.offsetWidth - this.getScrollbarWidth() < this.contentNode.offsetWidth );
					}
				}
			}
			if(hadScroll !== this._hasHScroll){
				this.grid.update();
			}
			return this._hasHScroll; // Boolean
		},

		hasVScrollbar: function(reset){
			var hadScroll = this._hasVScroll||false;
			if(this._hasVScroll == undefined || reset){
				if(this.noscroll){
					this._hasVScroll = false;
				}else{
					var style = html.style(this.scrollboxNode, "overflow");
					if(style == "hidden"){
						this._hasVScroll = false;
					}else if(style == "scroll"){
						this._hasVScroll = true;
					}else{
						this._hasVScroll = (this.scrollboxNode.scrollHeight > this.scrollboxNode.clientHeight);
					}
				}
			}
			if(hadScroll !== this._hasVScroll){
				this.grid.update();
			}
			return this._hasVScroll; // Boolean
		},
		
		convertColPctToFixed: function(){
			// Fix any percentage widths to be pixel values
			var hasPct = false;
			this.grid.initialWidth = "";
			var cellNodes = query("th", this.headerContentNode);
			var fixedWidths = array.map(cellNodes, function(c, vIdx){
				var w = c.style.width;
				html.attr(c, "vIdx", vIdx);
				if(w && w.slice(-1) == "%"){
					hasPct = true;
				}else if(w && w.slice(-2) == "px"){
					return window.parseInt(w, 10);
				}
				return html.contentBox(c).w;
			});
			if(hasPct){
				array.forEach(this.grid.layout.cells, function(cell, idx){
					if(cell.view == this){
						var cellNode = cell.view.getHeaderCellNode(cell.index);
						if(cellNode && html.hasAttr(cellNode, "vIdx")){
							var vIdx = window.parseInt(html.attr(cellNode, "vIdx"));
							this.setColWidth(idx, fixedWidths[vIdx]);
							html.removeAttr(cellNode, "vIdx");
						}
					}
				}, this);
				return true;
			}
			return false;
		},

		adaptHeight: function(minusScroll){
			if(!this.grid._autoHeight){
				var h = (this.domNode.style.height && parseInt(this.domNode.style.height.replace(/px/,''), 10)) || this.domNode.clientHeight;
				var self = this;
				var checkOtherViewScrollers = function(){
					var v;
					for(var i in self.grid.views.views){
						v = self.grid.views.views[i];
						if(v !== self && v.hasHScrollbar()){
							return true;
						}
					}
					return false;
				};
				if(minusScroll || (this.noscroll && checkOtherViewScrollers())){
					h -= metrics.getScrollbar().h;
				}
				util.setStyleHeightPx(this.scrollboxNode, h);
			}
			this.hasVScrollbar(true);
		},

		adaptWidth: function(){
			if(this.flexCells){
				// the view content width
				this.contentWidth = this.getContentWidth();
				this.headerContentNode.firstChild.style.width = this.contentWidth;
			}
			// FIXME: it should be easier to get w from this.scrollboxNode.clientWidth,
			// but clientWidth seemingly does not include scrollbar width in some cases
			var w = this.scrollboxNode.offsetWidth - this.getScrollbarWidth();
			if(!this._removingColumn){
				w = Math.max(w, this.getColumnsWidth()) + 'px';
			}else{
				w = Math.min(w, this.getColumnsWidth()) + 'px';
				this._removingColumn = false;
			}
			var cn = this.contentNode;
			cn.style.width = w;
			this.hasHScrollbar(true);
		},

		setSize: function(w, h){
			var ds = this.domNode.style;
			var hs = this.headerNode.style;

			if(w){
				ds.width = w;
				hs.width = w;
			}
			ds.height = (h >= 0 ? h + 'px' : '');
		},

		renderRow: function(inRowIndex){
			var rowNode = this.createRowNode(inRowIndex);
			this.buildRow(inRowIndex, rowNode);
			//this.grid.edit.restore(this, inRowIndex);
			return rowNode;
		},

		createRowNode: function(inRowIndex){
			var node = document.createElement("div");
			node.className = this.classTag + 'Row';
			if (this instanceof dojox.grid._RowSelector){
				html.attr(node,"role","presentation");
			}else{
				html.attr(node,"role","row");
				if (this.grid.selectionMode != "none") {
					node.setAttribute("aria-selected", "false"); //rows can be selected so add aria-selected prop
				}
			}
			node[util.gridViewTag] = this.id;
			node[util.rowIndexTag] = inRowIndex;
			this.rowNodes[inRowIndex] = node;
			return node;
		},

		buildRow: function(inRowIndex, inRowNode){
			
			this.buildRowContent(inRowIndex, inRowNode);
		  	
			this.styleRow(inRowIndex, inRowNode);
		  
		 
		},

		buildRowContent: function(inRowIndex, inRowNode){
			inRowNode.innerHTML = this.content.generateHtml(inRowIndex, inRowIndex);
			if(this.flexCells && this.contentWidth){
				// FIXME: accessing firstChild here breaks encapsulation
				inRowNode.firstChild.style.width = this.contentWidth;
			}
			util.fire(this, "onAfterRow", [inRowIndex, this.structure.cells, inRowNode]);
		},

		rowRemoved:function(inRowIndex){
			if(inRowIndex >= 0){
				this._cleanupRowWidgets(this.getRowNode(inRowIndex));
			}
			this.grid.edit.save(this, inRowIndex);
			delete this.rowNodes[inRowIndex];
		},

		getRowNode: function(inRowIndex){
			return this.rowNodes[inRowIndex];
		},

		getCellNode: function(inRowIndex, inCellIndex){
			var row = this.getRowNode(inRowIndex);
			if(row){
				return this.content.getCellNode(row, inCellIndex);
			}
		},

		getHeaderCellNode: function(inCellIndex){
			if(this.headerContentNode){
				return this.header.getCellNode(this.headerContentNode, inCellIndex);
			}
		},

		// styling
		styleRow: function(inRowIndex, inRowNode){
			inRowNode._style = getStyleText(inRowNode);
			this.styleRowNode(inRowIndex, inRowNode);
		},

		styleRowNode: function(inRowIndex, inRowNode){
			if(inRowNode){
				this.doStyleRowNode(inRowIndex, inRowNode);
			}
		},

		doStyleRowNode: function(inRowIndex, inRowNode){
			this.grid.styleRowNode(inRowIndex, inRowNode);
		},

		// updating
		updateRow: function(inRowIndex){
			var rowNode = this.getRowNode(inRowIndex);
			if(rowNode){
				rowNode.style.height = '';
				this.buildRow(inRowIndex, rowNode);
			}
			return rowNode;
		},

		updateRowStyles: function(inRowIndex){
			this.styleRowNode(inRowIndex, this.getRowNode(inRowIndex));
		},

		// scrolling
		lastTop: 0,
		firstScroll:0,
		_nativeScroll: false,

		doscroll: function(inEvent){
			if(has('ff') >= 13){
				this._nativeScroll = true;
			}
			//var s = dojo.marginBox(this.headerContentNode.firstChild);
			var isLtr = this.grid.isLeftToRight();
			if(this.firstScroll < 2){
				if((!isLtr && this.firstScroll == 1) || (isLtr && this.firstScroll === 0)){
					var s = html.marginBox(this.headerNodeContainer);
					if(has('ie')){
						this.headerNodeContainer.style.width = s.w + this.getScrollbarWidth() + 'px';
					}else if(has('mozilla')){
						//TODO currently only for FF, not sure for safari and opera
						this.headerNodeContainer.style.width = s.w - this.getScrollbarWidth() + 'px';
						//this.headerNodeContainer.style.width = s.w + 'px';
						//set scroll to right in FF
						this.scrollboxNode.scrollLeft = isLtr ?
							this.scrollboxNode.clientWidth - this.scrollboxNode.scrollWidth :
							this.scrollboxNode.scrollWidth - this.scrollboxNode.clientWidth;
					}
				}
				this.firstScroll++;
			}
			this.headerNode.scrollLeft = this.scrollboxNode.scrollLeft;
			// 'lastTop' is a semaphore to prevent feedback-loop with setScrollTop below
			var top = this.scrollboxNode.scrollTop;
			if(top !== this.lastTop){
				this.grid.scrollTo(top);
			}
			this._nativeScroll = false;
		},

		setScrollTop: function(inTop){
			// 'lastTop' is a semaphore to prevent feedback-loop with doScroll above
			this.lastTop = inTop;
			if(!this._nativeScroll){
				//fix #15487
				this.scrollboxNode.scrollTop = inTop;
			}
			return this.scrollboxNode.scrollTop;
		},

		// event handlers (direct from DOM)
		doContentEvent: function(e){
			if(this.content.decorateEvent(e)){
				this.grid.onContentEvent(e);
			}
		},

		doHeaderEvent: function(e){
			if(this.header.decorateEvent(e)){
				this.grid.onHeaderEvent(e);
			}
		},

		// event dispatch(from Grid)
		dispatchContentEvent: function(e){
			return this.content.dispatchEvent(e);
		},

		dispatchHeaderEvent: function(e){
			return this.header.dispatchEvent(e);
		},

		// column resizing
		setColWidth: function(inIndex, inWidth){
			this.grid.setCellWidth(inIndex, inWidth + 'px');
		},

		update: function(){
			if(!this.domNode){
				return;
			}
			this.content.update();
			this.grid.update();
			//get scroll after update or scroll left setting goes wrong on IE.
			//See trac: #8040
			var left = this.scrollboxNode.scrollLeft;
			this.scrollboxNode.scrollLeft = left;
			this.headerNode.scrollLeft = left;
		}
	});

	var _GridAvatar = declare("dojox.grid._GridAvatar", Avatar, {
		construct: function(){
			var dd = win.doc;

			var a = dd.createElement("table");
			a.cellPadding = a.cellSpacing = "0";
			a.className = "dojoxGridDndAvatar";
			a.style.position = "absolute";
			a.style.zIndex = 1999;
			a.style.margin = "0px"; // to avoid dojo.marginBox() problems with table's margins
			var b = dd.createElement("tbody");
			var tr = dd.createElement("tr");
			var td = dd.createElement("td");
			var img = dd.createElement("td");
			tr.className = "dojoxGridDndAvatarItem";
			img.className = "dojoxGridDndAvatarItemImage";
			img.style.width = "16px";
			var source = this.manager.source, node;
			if(source.creator){
				// create an avatar representation of the node
				node = source._normalizedCreator(source.getItem(this.manager.nodes[0].id).data, "avatar").node;
			}else{
				// or just clone the node and hope it works
				node = this.manager.nodes[0].cloneNode(true);
				var table, tbody;
				if(node.tagName.toLowerCase() == "tr"){
					// insert extra table nodes
					table = dd.createElement("table");
					tbody = dd.createElement("tbody");
					tbody.appendChild(node);
					table.appendChild(tbody);
					node = table;
				}else if(node.tagName.toLowerCase() == "th"){
					// insert extra table nodes
					table = dd.createElement("table");
					tbody = dd.createElement("tbody");
					var r = dd.createElement("tr");
					table.cellPadding = table.cellSpacing = "0";
					r.appendChild(node);
					tbody.appendChild(r);
					table.appendChild(tbody);
					node = table;
				}
			}
			node.id = "";
			td.appendChild(node);
			tr.appendChild(img);
			tr.appendChild(td);
			html.style(tr, "opacity", 0.9);
			b.appendChild(tr);

			a.appendChild(b);
			this.node = a;

			var m = Manager.manager();
			this.oldOffsetY = m.OFFSET_Y;
			m.OFFSET_Y = 1;
		},
		destroy: function(){
			Manager.manager().OFFSET_Y = this.oldOffsetY;
			this.inherited(arguments);
		}
	});

	var oldMakeAvatar = Manager.manager().makeAvatar;
	Manager.manager().makeAvatar = function(){
		var src = this.source;
		if(src.viewIndex !== undefined && !html.hasClass(win.body(),"dijit_a11y")){
			return new _GridAvatar(this);
		}
		return oldMakeAvatar.call(Manager.manager());
	};

	return _View;

});
},
'url:davinci/review/widgets/templates/MailFailureDialogContent.html':"<div>\n<div class='mailFailureInfo'>${inviteNotSent}</div>\n<div class='mailFailureExtraInfo'>${mailFailureMsg}</div>\n<div class='mailFailureContent'>${htmlContent}</div>\n</div>\n",
'dijit/MenuItem':function(){
define([
	"dojo/_base/declare", // declare
	"dojo/dom", // dom.setSelectable
	"dojo/dom-attr", // domAttr.set
	"dojo/dom-class", // domClass.toggle
	"dojo/_base/kernel", // kernel.deprecated
	"dojo/sniff", // has("ie")
	"./_Widget",
	"./_TemplatedMixin",
	"./_Contained",
	"./_CssStateMixin",
	"dojo/text!./templates/MenuItem.html"
], function(declare, dom, domAttr, domClass, kernel, has,
			_Widget, _TemplatedMixin, _Contained, _CssStateMixin, template){

	// module:
	//		dijit/MenuItem

	return declare("dijit.MenuItem",
		[_Widget, _TemplatedMixin, _Contained, _CssStateMixin],
		{
		// summary:
		//		A line item in a Menu Widget

		// Make 3 columns
		// icon, label, and expand arrow (BiDi-dependent) indicating sub-menu
		templateString: template,

		baseClass: "dijitMenuItem",

		// label: String
		//		Menu text
		label: "",
		_setLabelAttr: function(val){
			this.containerNode.innerHTML = 	val;
			this._set("label", val);
			if(this.textDir === "auto"){
				this.applyTextDir(this.focusNode, this.label);
			}
		},

		// iconClass: String
		//		Class to apply to DOMNode to make it display an icon.
		iconClass: "dijitNoIcon",
		_setIconClassAttr: { node: "iconNode", type: "class" },

		// accelKey: String
		//		Text for the accelerator (shortcut) key combination.
		//		Note that although Menu can display accelerator keys there
		//		is no infrastructure to actually catch and execute these
		//		accelerators.
		accelKey: "",

		// disabled: Boolean
		//		If true, the menu item is disabled.
		//		If false, the menu item is enabled.
		disabled: false,

		_fillContent: function(/*DomNode*/ source){
			// If button label is specified as srcNodeRef.innerHTML rather than
			// this.params.label, handle it here.
			if(source && !("label" in this.params)){
				this.set('label', source.innerHTML);
			}
		},

		buildRendering: function(){
			this.inherited(arguments);
			var label = this.id+"_text";
			domAttr.set(this.containerNode, "id", label);
			if(this.accelKeyNode){
				domAttr.set(this.accelKeyNode, "id", this.id + "_accel");
				label += " " + this.id + "_accel";
			}
			this.domNode.setAttribute("aria-labelledby", label);
			dom.setSelectable(this.domNode, false);
		},

		onClick: function(/*Event*/){
			// summary:
			//		User defined function to handle clicks
			// tags:
			//		callback
		},

		focus: function(){
			// summary:
			//		Focus on this MenuItem
			try{
				if(has("ie") == 8){
					// needed for IE8 which won't scroll TR tags into view on focus yet calling scrollIntoView creates flicker (#10275)
					this.containerNode.focus();
				}
				this.focusNode.focus();
			}catch(e){
				// this throws on IE (at least) in some scenarios
			}
		},

		_onFocus: function(){
			// summary:
			//		This is called by the focus manager when focus
			//		goes to this MenuItem or a child menu.
			// tags:
			//		protected
			this._setSelected(true);
			this.getParent()._onItemFocus(this);

			this.inherited(arguments);
		},

		_setSelected: function(selected){
			// summary:
			//		Indicate that this node is the currently selected one
			// tags:
			//		private

			/***
			 * TODO: remove this method and calls to it, when _onBlur() is working for MenuItem.
			 * Currently _onBlur() gets called when focus is moved from the MenuItem to a child menu.
			 * That's not supposed to happen, but the problem is:
			 * In order to allow dijit.popup's getTopPopup() to work,a sub menu's popupParent
			 * points to the parent Menu, bypassing the parent MenuItem... thus the
			 * MenuItem is not in the chain of active widgets and gets a premature call to
			 * _onBlur()
			 */

			domClass.toggle(this.domNode, "dijitMenuItemSelected", selected);
		},

		setLabel: function(/*String*/ content){
			// summary:
			//		Deprecated.   Use set('label', ...) instead.
			// tags:
			//		deprecated
			kernel.deprecated("dijit.MenuItem.setLabel() is deprecated.  Use set('label', ...) instead.", "", "2.0");
			this.set("label", content);
		},

		setDisabled: function(/*Boolean*/ disabled){
			// summary:
			//		Deprecated.   Use set('disabled', bool) instead.
			// tags:
			//		deprecated
			kernel.deprecated("dijit.Menu.setDisabled() is deprecated.  Use set('disabled', bool) instead.", "", "2.0");
			this.set('disabled', disabled);
		},
		_setDisabledAttr: function(/*Boolean*/ value){
			// summary:
			//		Hook for attr('disabled', ...) to work.
			//		Enable or disable this menu item.

			this.focusNode.setAttribute('aria-disabled', value ? 'true' : 'false');
			this._set("disabled", value);
		},
		_setAccelKeyAttr: function(/*String*/ value){
			// summary:
			//		Hook for attr('accelKey', ...) to work.
			//		Set accelKey on this menu item.

			this.accelKeyNode.style.display=value?"":"none";
			this.accelKeyNode.innerHTML=value;
			//have to use colSpan to make it work in IE
			domAttr.set(this.containerNode,'colSpan',value?"1":"2");

			this._set("accelKey", value);
		},
		_setTextDirAttr: function(/*String*/ textDir){
			// summary:
			//		Setter for textDir.
			// description:
			//		Users shouldn't call this function; they should be calling
			//		set('textDir', value)
			// tags:
			//		private

			// only if new textDir is different from the old one
			// and on widgets creation.
			if(!this._created || this.textDir != textDir){
				this._set("textDir", textDir);
				this.applyTextDir(this.focusNode, this.label);
			}
		}		
	});
});

},
'dijit/layout/TabController':function(){
define([
	"dojo/_base/declare", // declare
	"dojo/dom", // dom.setSelectable
	"dojo/dom-attr", // domAttr.attr
	"dojo/dom-class", // domClass.toggle
	"dojo/i18n", // i18n.getLocalization
	"dojo/_base/lang", // lang.hitch lang.trim
	"./StackController",
	"../registry",
	"../Menu",
	"../MenuItem",
	"dojo/text!./templates/_TabButton.html",
	"dojo/i18n!../nls/common"
], function(declare, dom, domAttr, domClass, i18n, lang, StackController, registry, Menu, MenuItem, template){

	// module:
	//		dijit/layout/TabController

	var TabButton = declare("dijit.layout._TabButton", StackController.StackButton, {
		// summary:
		//		A tab (the thing you click to select a pane).
		// description:
		//		Contains the title of the pane, and optionally a close-button to destroy the pane.
		//		This is an internal widget and should not be instantiated directly.
		// tags:
		//		private

		// baseClass: String
		//		The CSS class applied to the domNode.
		baseClass: "dijitTab",

		// Apply dijitTabCloseButtonHover when close button is hovered
		cssStateNodes: {
			closeNode: "dijitTabCloseButton"
		},

		templateString: template,

		// Override _FormWidget.scrollOnFocus.
		// Don't scroll the whole tab container into view when the button is focused.
		scrollOnFocus: false,

		buildRendering: function(){
			this.inherited(arguments);

			dom.setSelectable(this.containerNode, false);
		},

		startup: function(){
			this.inherited(arguments);
			var n = this.domNode;

			// Required to give IE6 a kick, as it initially hides the
			// tabs until they are focused on.
			this.defer(function(){
				n.className = n.className;
			}, 1);
		},

		_setCloseButtonAttr: function(/*Boolean*/ disp){
			// summary:
			//		Hide/show close button
			this._set("closeButton", disp);
			domClass.toggle(this.domNode, "dijitClosable", disp);
			this.closeNode.style.display = disp ? "" : "none";
			if(disp){
				var _nlsResources = i18n.getLocalization("dijit", "common");
				if(this.closeNode){
					domAttr.set(this.closeNode, "title", _nlsResources.itemClose);
				}
			}
		},

		_setDisabledAttr: function(/*Boolean*/ disabled){
			// summary:
			//		Make tab selected/unselectable

			this.inherited(arguments);

			// Don't show tooltip for close button when tab is disabled
			if(this.closeNode){
				if(disabled){
					domAttr.remove(this.closeNode, "title");
				}else{
					var _nlsResources = i18n.getLocalization("dijit", "common");
					domAttr.set(this.closeNode, "title", _nlsResources.itemClose);
				}
			}
		},

		_setLabelAttr: function(/*String*/ content){
			// summary:
			//		Hook for set('label', ...) to work.
			// description:
			//		takes an HTML string.
			//		Inherited ToggleButton implementation will Set the label (text) of the button;
			//		Need to set the alt attribute of icon on tab buttons if no label displayed
			this.inherited(arguments);
			if(!this.showLabel && !this.params.title){
				this.iconNode.alt = lang.trim(this.containerNode.innerText || this.containerNode.textContent || '');
			}
		}
	});

	var TabController = declare("dijit.layout.TabController", StackController, {
		// summary:
		//		Set of tabs (the things with titles and a close button, that you click to show a tab panel).
		//		Used internally by `dijit/layout/TabContainer`.
		// description:
		//		Lets the user select the currently shown pane in a TabContainer or StackContainer.
		//		TabController also monitors the TabContainer, and whenever a pane is
		//		added or deleted updates itself accordingly.
		// tags:
		//		private

		baseClass: "dijitTabController",

		templateString: "<div role='tablist' data-dojo-attach-event='onkeypress:onkeypress'></div>",

		// tabPosition: String
		//		Defines where tabs go relative to the content.
		//		"top", "bottom", "left-h", "right-h"
		tabPosition: "top",

		// buttonWidget: Constructor
		//		The tab widget to create to correspond to each page
		buttonWidget: TabButton,

		// buttonWidgetCloseClass: String
		//		Class of [x] close icon, used by event delegation code to tell when close button was clicked
		buttonWidgetCloseClass: "dijitTabCloseButton",

		postCreate: function(){
			this.inherited(arguments);

			// Setup a close menu to be shared between all the closable tabs (excluding disabled tabs)
			var closeMenu = new Menu({
				id: this.id+"_Menu",
				ownerDocument: this.ownerDocument,
				dir: this.dir,
				lang: this.lang,
				textDir: this.textDir,
				targetNodeIds: [this.domNode],
				selector: function(node){
					return domClass.contains(node, "dijitClosable") && !domClass.contains(node, "dijitTabDisabled");
				}
			});
			this.own(closeMenu);

			var _nlsResources = i18n.getLocalization("dijit", "common"),
				controller = this;
			closeMenu.addChild(new MenuItem({
				label: _nlsResources.itemClose,
				ownerDocument: this.ownerDocument,
				dir: this.dir,
				lang: this.lang,
				textDir: this.textDir,
				onClick: function(evt){
					var button = registry.byNode(this.getParent().currentTarget);
					controller.onCloseButtonClick(button.page);
				}
			}));
		}
	});

	TabController.TabButton = TabButton;	// for monkey patching

	return TabController;
});

},
'dijit/MenuBarItem':function(){
define([
	"dojo/_base/declare", // declare
	"./MenuItem",
	"dojo/text!./templates/MenuBarItem.html"
], function(declare, MenuItem, template){

	// module:
	//		dijit/MenuBarItem

	var _MenuBarItemMixin = declare("dijit._MenuBarItemMixin", null, {
		templateString: template,

		// Map widget attributes to DOMNode attributes.
		_setIconClassAttr: null	// cancel MenuItem setter because we don't have a place for an icon
	});

	var MenuBarItem = declare("dijit.MenuBarItem", [MenuItem, _MenuBarItemMixin], {
		// summary:
		//		Item in a MenuBar that's clickable, and doesn't spawn a submenu when pressed (or hovered)

	});
	MenuBarItem._MenuBarItemMixin = _MenuBarItemMixin;	// dojox.mobile is accessing this


	return MenuBarItem;
});

},
'dojo/cldr/supplemental':function(){
define(["../_base/lang", "../i18n"], function(lang, i18n){

// module:
//		dojo/cldr/supplemental


var supplemental = {
	// summary:
	//		TODOC
};
lang.setObject("dojo.cldr.supplemental", supplemental);

supplemental.getFirstDayOfWeek = function(/*String?*/locale){
	// summary:
	//		Returns a zero-based index for first day of the week
	// description:
	//		Returns a zero-based index for first day of the week, as used by the local (Gregorian) calendar.
	//		e.g. Sunday (returns 0), or Monday (returns 1)

	// from http://www.unicode.org/cldr/data/common/supplemental/supplementalData.xml:supplementalData/weekData/firstDay
	var firstDay = {/*default is 1=Monday*/
		bd:5,mv:5,
		ae:6,af:6,bh:6,dj:6,dz:6,eg:6,iq:6,ir:6,jo:6,kw:6,
		ly:6,ma:6,om:6,qa:6,sa:6,sd:6,sy:6,ye:6,
		ag:0,ar:0,as:0,au:0,br:0,bs:0,bt:0,bw:0,by:0,bz:0,ca:0,cn:0,
		co:0,dm:0,'do':0,et:0,gt:0,gu:0,hk:0,hn:0,id:0,ie:0,il:0,'in':0,
		jm:0,jp:0,ke:0,kh:0,kr:0,la:0,mh:0,mm:0,mo:0,mt:0,mx:0,mz:0,
		ni:0,np:0,nz:0,pa:0,pe:0,ph:0,pk:0,pr:0,py:0,sg:0,sv:0,th:0,
		tn:0,tt:0,tw:0,um:0,us:0,ve:0,vi:0,ws:0,za:0,zw:0
	};

	var country = supplemental._region(locale);
	var dow = firstDay[country];
	return (dow === undefined) ? 1 : dow; /*Number*/
};

supplemental._region = function(/*String?*/locale){
	locale = i18n.normalizeLocale(locale);
	var tags = locale.split('-');
	var region = tags[1];
	if(!region){
		// IE often gives language only (#2269)
		// Arbitrary mappings of language-only locales to a country:
		region = {de:"de", en:"us", es:"es", fi:"fi", fr:"fr", he:"il", hu:"hu", it:"it",
			ja:"jp", ko:"kr", nl:"nl", pt:"br", sv:"se", zh:"cn"}[tags[0]];
	}else if(region.length == 4){
		// The ISO 3166 country code is usually in the second position, unless a
		// 4-letter script is given. See http://www.ietf.org/rfc/rfc4646.txt
		region = tags[2];
	}
	return region;
};

supplemental.getWeekend = function(/*String?*/locale){
	// summary:
	//		Returns a hash containing the start and end days of the weekend
	// description:
	//		Returns a hash containing the start and end days of the weekend according to local custom using locale,
	//		or by default in the user's locale.
	//		e.g. {start:6, end:0}

	// from http://www.unicode.org/cldr/data/common/supplemental/supplementalData.xml:supplementalData/weekData/weekend{Start,End}
	var weekendStart = {/*default is 6=Saturday*/
			'in':0,
			af:4,dz:4,ir:4,om:4,sa:4,ye:4,
			ae:5,bh:5,eg:5,il:5,iq:5,jo:5,kw:5,ly:5,ma:5,qa:5,sd:5,sy:5,tn:5
		},

		weekendEnd = {/*default is 0=Sunday*/
			af:5,dz:5,ir:5,om:5,sa:5,ye:5,
			ae:6,bh:5,eg:6,il:6,iq:6,jo:6,kw:6,ly:6,ma:6,qa:6,sd:6,sy:6,tn:6
		},

		country = supplemental._region(locale),
		start = weekendStart[country],
		end = weekendEnd[country];

	if(start === undefined){start=6;}
	if(end === undefined){end=0;}
	return {start:start, end:end}; /*Object {start,end}*/
};

return supplemental;
});

},
'dijit/MenuBar':function(){
define([
	"dojo/_base/declare", // declare
	"dojo/_base/event", // event.stop
	"dojo/keys", // keys.DOWN_ARROW
	"./_MenuBase",
	"dojo/text!./templates/MenuBar.html"
], function(declare, event, keys, _MenuBase, template){

// module:
//		dijit/MenuBar

return declare("dijit.MenuBar", _MenuBase, {
	// summary:
	//		A menu bar, listing menu choices horizontally, like the "File" menu in most desktop applications

	templateString: template,

	baseClass: "dijitMenuBar",

	// _isMenuBar: [protected] Boolean
	//		This is a MenuBar widget, not a (vertical) Menu widget.
	_isMenuBar: true,

	postCreate: function(){
		this.inherited(arguments);
		var l = this.isLeftToRight();
		this.connectKeyNavHandlers(
			l ? [keys.LEFT_ARROW] : [keys.RIGHT_ARROW],
			l ? [keys.RIGHT_ARROW] : [keys.LEFT_ARROW]
		);

		// parameter to dijit.popup.open() about where to put popup (relative to this.domNode)
		this._orient = ["below"];
	},

	_moveToPopup: function(/*Event*/ evt){
		// summary:
		//		This handles the down arrow key, opening a submenu if one exists.
		//		Unlike _MenuBase._moveToPopup(), will never move to the next item in the MenuBar.
		// tags:
		//		private

		if(this.focusedChild && this.focusedChild.popup && !this.focusedChild.disabled){
			this.onItemClick(this.focusedChild, evt);
		}
	},

	focusChild: function(item){
		// overload focusChild so that whenever the focus is moved to a new item,
		// check the previous focused whether it has its popup open, if so, after
		// focusing the new item, open its submenu immediately
		var prev_item = this.focusedChild,
			showpopup = prev_item && prev_item.popup && prev_item.popup.isShowingNow;
		this.inherited(arguments);
		if(showpopup && item.popup && !item.disabled){
			this._openPopup(true);		// TODO: on down arrow, _openPopup() is called here and in onItemClick()
		}
	},

	_onKeyPress: function(/*Event*/ evt){
		// summary:
		//		Handle keyboard based menu navigation.
		// tags:
		//		protected

		if(evt.ctrlKey || evt.altKey){ return; }

		switch(evt.charOrCode){
			case keys.DOWN_ARROW:
				this._moveToPopup(evt);
				event.stop(evt);
		}
	},

	onItemClick: function(/*dijit/_WidgetBase*/ item, /*Event*/ evt){
		// summary:
		//		Handle clicks on an item.   Also called by _moveToPopup() due to a down-arrow key on the item.
		//		Cancels a dropdown if already open and click is either mouse or space/enter.
		//		Don't close dropdown due to down arrow.
		// tags:
		//		private
		if(item.popup && item.popup.isShowingNow && (evt.type !== "keypress" || evt.keyCode !== keys.DOWN_ARROW)){
			item.popup.onCancel();
		}else{
			this.inherited(arguments);
		}
	}
});

});

},
'dijit/ToolbarSeparator':function(){
define([
	"dojo/_base/declare", // declare
	"dojo/dom", // dom.setSelectable
	"./_Widget",
	"./_TemplatedMixin"
], function(declare, dom, _Widget, _TemplatedMixin){

	// module:
	//		dijit/ToolbarSeparator


	return declare("dijit.ToolbarSeparator", [_Widget, _TemplatedMixin], {
		// summary:
		//		A spacer between two `dijit.Toolbar` items

		templateString: '<div class="dijitToolbarSeparator dijitInline" role="presentation"></div>',

		buildRendering: function(){
			this.inherited(arguments);
			dom.setSelectable(this.domNode, false);
		},

		isFocusable: function(){
			// summary:
			//		This widget isn't focusable, so pass along that fact.
			// tags:
			//		protected
			return false;
		}
	});
});

},
'davinci/html/CSSAtRule':function(){
define([
	"dojo/_base/declare",
	"davinci/html/CSSElement"
], function(declare, CSSElement) {

return declare("davinci.html.CSSAtRule", CSSElement, {

	constructor: function() {
		this.elementType = "CSSAtRule";
	},

	getCSSFile: function() {
		return this.parent;
	},
	
	getText: function(context) {
		s = "@";
		s = s + this.name + " " + this.value + "\n";
		return s;
	}
});
});

},
'dijit/layout/StackController':function(){
define([
	"dojo/_base/array", // array.forEach array.indexOf array.map
	"dojo/_base/declare", // declare
	"dojo/dom-class",
	"dojo/_base/event", // event.stop
	"dojo/keys", // keys
	"dojo/_base/lang", // lang.getObject
	"dojo/on",
	"../focus",		// focus.focus()
	"../registry",	// registry.byId
	"../_Widget",
	"../_TemplatedMixin",
	"../_Container",
	"../form/ToggleButton",
	"dojo/i18n!../nls/common"
], function(array, declare, domClass, event, keys, lang, on,
			focus, registry, _Widget, _TemplatedMixin, _Container, ToggleButton){

	// module:
	//		dijit/layout/StackController

	var StackButton = declare("dijit.layout._StackButton", ToggleButton, {
		// summary:
		//		Internal widget used by StackContainer.
		// description:
		//		The button-like or tab-like object you click to select or delete a page
		// tags:
		//		private

		// Override _FormWidget.tabIndex.
		// StackContainer buttons are not in the tab order by default.
		// Probably we should be calling this.startupKeyNavChildren() instead.
		tabIndex: "-1",

		// closeButton: Boolean
		//		When true, display close button for this tab
		closeButton: false,
		
		_aria_attr: "aria-selected",

		buildRendering: function(/*Event*/ evt){
			this.inherited(arguments);
			(this.focusNode || this.domNode).setAttribute("role", "tab");
		}
	});


	var StackController = declare("dijit.layout.StackController", [_Widget, _TemplatedMixin, _Container], {
		// summary:
		//		Set of buttons to select a page in a `dijit/layout/StackContainer`
		// description:
		//		Monitors the specified StackContainer, and whenever a page is
		//		added, deleted, or selected, updates itself accordingly.

		baseClass: "dijitStackController",

		templateString: "<span role='tablist' data-dojo-attach-event='onkeypress'></span>",

		// containerId: [const] String
		//		The id of the page container that I point to
		containerId: "",

		// buttonWidget: [const] Constructor
		//		The button widget to create to correspond to each page
		buttonWidget: StackButton,

		// buttonWidgetCloseClass: String
		//		CSS class of [x] close icon, used by event delegation code to tell when close button was clicked
		buttonWidgetCloseClass: "dijitStackCloseButton",

		constructor: function(params /*===== , srcNodeRef =====*/){
			// summary:
			//		Create the widget.
			// params: Object|null
			//		Hash of initialization parameters for widget, including scalar values (like title, duration etc.)
			//		and functions, typically callbacks like onClick.
			//		The hash can contain any of the widget's properties, excluding read-only properties.
			// srcNodeRef: DOMNode|String?
			//		If a srcNodeRef (DOM node) is specified, replace srcNodeRef with my generated DOM tree

			this.pane2button = {};		// mapping from pane id to buttons
		},

		postCreate: function(){
			this.inherited(arguments);

			// Listen to notifications from StackContainer.
			// TODO: do this through bubbled events instead of topics
			this.subscribe(this.containerId+"-startup", "onStartup");
			this.subscribe(this.containerId+"-addChild", "onAddChild");
			this.subscribe(this.containerId+"-removeChild", "onRemoveChild");
			this.subscribe(this.containerId+"-selectChild", "onSelectChild");
			this.subscribe(this.containerId+"-containerKeyPress", "onContainerKeyPress");

			// Listen for click events to select or close tabs.
			// No need to worry about ENTER/SPACE key handling: tabs are selected via left/right arrow keys,
			// and closed via shift-F10 (to show the close menu).
			this.connect(this.containerNode, 'click', function(evt){
				var button = registry.getEnclosingWidget(evt.target);
				if(button != this.containerNode && !button.disabled && button.page){
					for(var target = evt.target; target !== this.containerNode; target = target.parentNode){
						if(domClass.contains(target, this.buttonWidgetCloseClass)){
							this.onCloseButtonClick(button.page);
							break;
						}else if(target == button.domNode){
							this.onButtonClick(button.page);
							break;
						}
					}
				}
			});
		},

		onStartup: function(/*Object*/ info){
			// summary:
			//		Called after StackContainer has finished initializing
			// tags:
			//		private
			array.forEach(info.children, this.onAddChild, this);
			if(info.selected){
				// Show button corresponding to selected pane (unless selected
				// is null because there are no panes)
				this.onSelectChild(info.selected);
			}

			// Reflect events like page title changes to tab buttons
			var containerNode = registry.byId(this.containerId).containerNode,
				pane2button = this.pane2button,
				paneToButtonAttr = {
					"title": "label",
					"showtitle": "showLabel",
					"iconclass": "iconClass",
					"closable": "closeButton",
					"tooltip": "title",
					"disabled": "disabled"
				},
				connectFunc = function(attr, buttonAttr){
					return on(containerNode, "attrmodified-" + attr, function(evt){
						var button = pane2button[evt.detail && evt.detail.widget && evt.detail.widget.id];
						if(button){
							button.set(buttonAttr, evt.detail.newValue);
						}
					});
				};
			for(var attr in paneToButtonAttr){
				this.own(connectFunc(attr, paneToButtonAttr[attr]));
			}
		},

		destroy: function(){
			// Since the buttons are internal to the StackController widget, destroy() should remove them, which is
			// done by calling onRemoveChild().
			for(var pane in this.pane2button){
				this.onRemoveChild(registry.byId(pane));
			}

			// TODO: destroyRecursive() will call destroy() on each child button twice.   Once from the above code,
			// and once because _WidgetBase.destroyDescendants() deletes anything inside of this.containerNode.
			// Probably shouldn't attach that DOMNode as this.containerNode.

			this.inherited(arguments);
		},

		onAddChild: function(/*dijit/_WidgetBase*/ page, /*Integer?*/ insertIndex){
			// summary:
			//		Called whenever a page is added to the container.
			//		Create button corresponding to the page.
			// tags:
			//		private

			// create an instance of the button widget
			// (remove typeof buttonWidget == string support in 2.0)
			var Cls = lang.isString(this.buttonWidget) ? lang.getObject(this.buttonWidget) : this.buttonWidget;
			var button = new Cls({
				id: this.id + "_" + page.id,
				name: this.id + "_" + page.id,
				label: page.title,
				disabled: page.disabled,
				ownerDocument: this.ownerDocument,
				dir: page.dir,
				lang: page.lang,
				textDir: page.textDir,
				showLabel: page.showTitle,
				iconClass: page.iconClass,
				closeButton: page.closable,
				title: page.tooltip,
				page: page
			});

			this.addChild(button, insertIndex);
			this.pane2button[page.id] = button;
			page.controlButton = button;	// this value might be overwritten if two tabs point to same container
			if(!this._currentChild){
				// If this is the first child then StackContainer will soon publish that it's selected,
				// but before that StackContainer calls layout(), and before layout() is called the
				// StackController needs to have the proper height... which means that the button needs
				// to be marked as selected now.   See test_TabContainer_CSS.html for test.
				this.onSelectChild(page);
			}
		},

		onRemoveChild: function(/*dijit/_WidgetBase*/ page){
			// summary:
			//		Called whenever a page is removed from the container.
			//		Remove the button corresponding to the page.
			// tags:
			//		private

			if(this._currentChild === page){ this._currentChild = null; }

			var button = this.pane2button[page.id];
			if(button){
				this.removeChild(button);
				delete this.pane2button[page.id];
				button.destroy();
			}
			delete page.controlButton;
		},

		onSelectChild: function(/*dijit/_WidgetBase*/ page){
			// summary:
			//		Called when a page has been selected in the StackContainer, either by me or by another StackController
			// tags:
			//		private

			if(!page){ return; }

			if(this._currentChild){
				var oldButton=this.pane2button[this._currentChild.id];
				oldButton.set('checked', false);
				oldButton.focusNode.setAttribute("tabIndex", "-1");
			}

			var newButton=this.pane2button[page.id];
			newButton.set('checked', true);
			this._currentChild = page;
			newButton.focusNode.setAttribute("tabIndex", "0");
			var container = registry.byId(this.containerId);
			container.containerNode.setAttribute("aria-labelledby", newButton.id);
		},

		onButtonClick: function(/*dijit/_WidgetBase*/ page){
			// summary:
			//		Called whenever one of my child buttons is pressed in an attempt to select a page
			// tags:
			//		private

			var button = this.pane2button[page.id];

			// For TabContainer where the tabs are <span>, need to set focus explicitly when left/right arrow
			focus.focus(button.focusNode);

			if(this._currentChild && this._currentChild.id === page.id) {
				//In case the user clicked the checked button, keep it in the checked state because it remains to be the selected stack page.
				button.set('checked', true);
			}
			var container = registry.byId(this.containerId);
			container.selectChild(page);
		},

		onCloseButtonClick: function(/*dijit/_WidgetBase*/ page){
			// summary:
			//		Called whenever one of my child buttons [X] is pressed in an attempt to close a page
			// tags:
			//		private

			var container = registry.byId(this.containerId);
			container.closeChild(page);
			if(this._currentChild){
				var b = this.pane2button[this._currentChild.id];
				if(b){
					focus.focus(b.focusNode || b.domNode);
				}
			}
		},

		// TODO: this is a bit redundant with forward, back api in StackContainer
		adjacent: function(/*Boolean*/ forward){
			// summary:
			//		Helper for onkeypress to find next/previous button
			// tags:
			//		private

			if(!this.isLeftToRight() && (!this.tabPosition || /top|bottom/.test(this.tabPosition))){ forward = !forward; }
			// find currently focused button in children array
			var children = this.getChildren();
			var idx = array.indexOf(children, this.pane2button[this._currentChild.id]),
				current = children[idx];

			// Pick next/previous non-disabled button to focus on.   If we get back to the original button it means
			// that all buttons must be disabled, so return current child to avoid an infinite loop.
			var child;
			do{
				idx = (idx + (forward ? 1 : children.length - 1)) % children.length;
				child = children[idx];
			}while(child.disabled && child != current);

			return child; // dijit/_WidgetBase
		},

		onkeypress: function(/*Event*/ e){
			// summary:
			//		Handle keystrokes on the page list, for advancing to next/previous button
			//		and closing the current page if the page is closable.
			// tags:
			//		private

			if(this.disabled || e.altKey ){ return; }
			var forward = null;
			if(e.ctrlKey || !e._djpage){
				switch(e.charOrCode){
					case keys.LEFT_ARROW:
					case keys.UP_ARROW:
						if(!e._djpage){ forward = false; }
						break;
					case keys.PAGE_UP:
						if(e.ctrlKey){ forward = false; }
						break;
					case keys.RIGHT_ARROW:
					case keys.DOWN_ARROW:
						if(!e._djpage){ forward = true; }
						break;
					case keys.PAGE_DOWN:
						if(e.ctrlKey){ forward = true; }
						break;
					case keys.HOME:
						// Navigate to first non-disabled child
						var children = this.getChildren();
						for(var idx = 0; idx < children.length; idx++){
							var child = children[idx];
							if(!child.disabled){
								this.onButtonClick(child.page);
								break;
							}
						}
						event.stop(e);
						break;
					case keys.END:
						// Navigate to last non-disabled child
						var children = this.getChildren();
						for(var idx = children.length-1; idx >= 0; idx--){
							var child = children[idx];
							if(!child.disabled){
								this.onButtonClick(child.page);
								break;
							}
						}
						event.stop(e);
						break;
					case keys.DELETE:
						if(this._currentChild.closable){
							this.onCloseButtonClick(this._currentChild);
						}
						event.stop(e);
						break;
					default:
						if(e.ctrlKey){
							if(e.charOrCode === keys.TAB){
								this.onButtonClick(this.adjacent(!e.shiftKey).page);
								event.stop(e);
							}else if(e.charOrCode == "w"){
								if(this._currentChild.closable){
									this.onCloseButtonClick(this._currentChild);
								}
								event.stop(e); // avoid browser tab closing.
							}
						}
				}
				// handle next/previous page navigation (left/right arrow, etc.)
				if(forward !== null){
					this.onButtonClick(this.adjacent(forward).page);
					event.stop(e);
				}
			}
		},

		onContainerKeyPress: function(/*Object*/ info){
			// summary:
			//		Called when there was a keypress on the container
			// tags:
			//		private
			info.e._djpage = info.page;
			this.onkeypress(info.e);
		}
	});

	StackController.StackButton = StackButton;	// for monkey patching

	return StackController;
});

},
'dojox/grid/_RowManager':function(){
define([
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/dom-class"
], function(declare, lang, domClass){

	var setStyleText = function(inNode, inStyleText){
		if(inNode.style.cssText == undefined){
			inNode.setAttribute("style", inStyleText);
		}else{
			inNode.style.cssText = inStyleText;
		}
	};

	return declare("dojox.grid._RowManager", null, {
		//	Stores information about grid rows. Owned by grid and used internally.
		constructor: function(inGrid){
			this.grid = inGrid;
		},
		linesToEms: 2,
		overRow: -2,
		// styles
		prepareStylingRow: function(inRowIndex, inRowNode){
			return {
				index: inRowIndex,
				node: inRowNode,
				odd: Boolean(inRowIndex&1),
				selected: !!this.grid.selection.isSelected(inRowIndex),
				over: this.isOver(inRowIndex),
				customStyles: "",
				customClasses: "dojoxGridRow"
			};
		},
		styleRowNode: function(inRowIndex, inRowNode){
			var row = this.prepareStylingRow(inRowIndex, inRowNode);
			this.grid.onStyleRow(row);
			this.applyStyles(row);
		},
		applyStyles: function(inRow){
			var i = inRow;

			i.node.className = i.customClasses;
			var h = i.node.style.height;
			setStyleText(i.node, i.customStyles + ';' + (i.node._style||''));
			i.node.style.height = h;
		},
		updateStyles: function(inRowIndex){
			this.grid.updateRowStyles(inRowIndex);
		},
		// states and events
		setOverRow: function(inRowIndex){
			var last = this.overRow;
			this.overRow = inRowIndex;
			if((last!=this.overRow)&&(lang.isString(last) || last >= 0)){
				this.updateStyles(last);
			}
			this.updateStyles(this.overRow);
		},
		isOver: function(inRowIndex){
			return (this.overRow == inRowIndex && !domClass.contains(this.grid.domNode, "dojoxGridColumnResizing"));
		}
	});
});
},
'davinci/ve/commands/ResizeCommand':function(){
define([
		"dojo/_base/declare",
		"dojo/dom-geometry",
		"davinci/ve/widget",
		"davinci/ve/States",
		"davinci/ve/utils/StyleArray"
], function(declare, Geometry, Widget, States, StyleArray){


return declare("davinci.ve.commands.ResizeCommand", null, {


	name: "resize",

	constructor: function(widget, width, height, applyToWhichState){
		this._id = (widget ? widget.id : undefined);
		var number_regex = /^\s*[-+]?[0-9]*\.?[0-9]+\s*$/;
	
		/* make sure these values are numeric */
		if(number_regex.test(width)){
			width = parseFloat(width);
		}
		if(number_regex.test(height)){
			height = parseFloat(height);
		}

		this._newBox = {w: width, h: height};
		
		// applyToWhichState controls whether style change is attached to Normal or other states
		//   (null|undefined|"undefined"|"Normal") => apply to Normal state
		//   other string => apply to that particular state
		this._applyToStateIndex = (!applyToWhichState || applyToWhichState=='Normal' || applyToWhichState=='undefined')
									? 'undefined' : applyToWhichState;
	},

	execute: function(){
		
		if(!this._id || !this._newBox){
			return;
		}
		var widget = Widget.byId(this._id);
		if(!widget || !widget.domNode){
			return;
		}
		var node = widget.domNode;
		
		// Adjustments for widgets whose root tag has special CSS treatment
		// where width/height specify border-box instead of content-box
		//FIXME: This logic doesn't take into account the possibility that
		//uses have set borders and padding to different values for different states
		//Unlikely combination, but nevertheless not dealt with here properly
		var cs = node.ownerDocument.defaultView.getComputedStyle(node);
		var oldBox = Geometry.getContentBox(node, cs);
		this._oldBox = {w:oldBox.w, h:oldBox.h};
		var w = this._newBox.w;
		var h = this._newBox.h;
		if(this._usesBorderBox(node)){
			var pb = Geometry.getPadBorderExtents(node, cs);
			if(typeof w == 'number' && w >= 0){
				w += pb.w;
			}
			if(typeof h == 'number' && h >= 0){
				h += pb.h;
			}
		}

		//var newStyleArray = [{width:w+'px'},{height:h+'px'}] ;
		var newStyleArray = [{}] ;
		if(typeof w == 'number'){
			newStyleArray[0].width = w+'px';
		}else if(typeof w == 'string'){
			newStyleArray[0].width = w;
		}
		if(typeof h == 'number'){
			newStyleArray[0].height = h+'px';
		}else if(typeof h == 'string'){
			newStyleArray[0].height = h;
		}
		var styleValuesAllStates = widget.getStyleValuesAllStates();
		this._oldStyleValuesAllStates = dojo.clone(styleValuesAllStates);
		if(this._oldBox){
			//FIXME: Undo will force a width/height values onto inline style
			//that might not have been there before.
			this._oldStyleValuesAllStates[this._applyToStateIndex] = 
					StyleArray.mergeStyleArrays(this._oldStyleValuesAllStates[this._applyToStateIndex], 
								[{width:this._oldBox.w+'px'}, {height:this._oldBox.h+'px'}]);
		}
		if(styleValuesAllStates[this._applyToStateIndex]){
			styleValuesAllStates[this._applyToStateIndex] = StyleArray.mergeStyleArrays(styleValuesAllStates[this._applyToStateIndex], newStyleArray);
		}else{
			styleValuesAllStates[this._applyToStateIndex] = newStyleArray;
		}
		
		widget.setStyleValuesAllStates(styleValuesAllStates);
		var currentStatesList = States.getStatesListCurrent(widget.domNode);
		var styleValuesCanvas = StyleArray.mergeStyleArrays([], styleValuesAllStates['undefined']);
		for(var i=0; i<currentStatesList.length; i++){
			if(styleValuesAllStates[currentStatesList[i]]){
				styleValuesCanvas = StyleArray.mergeStyleArrays(styleValuesCanvas, styleValuesAllStates[currentStatesList[i]]);
			}
		}
		widget.setStyleValuesCanvas(styleValuesCanvas);
		widget.setStyleValuesModel(styleValuesAllStates['undefined']);
		this._resize(widget);
		
		// Recompute styling properties in case we aren't in Normal state
		States.resetState(widget.domNode);
		
		//FIXME: Various widget changed events (/davinci/ui/widget*Changed) need to be cleaned up.
		// I defined yet another one here (widgetPropertiesChanged) just before Preview3
		// rather than re-use or alter one of the existing widget*Changed events just before
		// the Preview 3 release to minimize risk of bad side effects, with idea we would clean up later.
		// For time being, I made payload compatible with /davinci/ui/widgetSelectionChanged. 
		// Double array is necessary because dojo.publish strips out the outer array.
		dojo.publish("/davinci/ui/widgetPropertiesChanged",[[widget]]);
	},
	setContext : function(context){
		this._context = context;
	},
	
	undo: function(){
		if(!this._id){
			return;
		}
		var widget = Widget.byId(this._id);
		if(!widget){
			return;
		}
		var styleValuesAllStates = this._oldStyleValuesAllStates;
		var currentStateIndex = this._applyToStateIndex;
		widget.setStyleValuesAllStates(styleValuesAllStates);
		var styleValuesCanvas = StyleArray.mergeStyleArrays(styleValuesAllStates['undefined'], styleValuesAllStates[currentStateIndex]);
		widget.setStyleValuesCanvas(styleValuesCanvas);
		widget.setStyleValuesModel(this._oldStyleValuesAllStates['undefined']);

		this._resize(widget);
		
		// Recompute styling properties in case we aren't in Normal state
		States.resetState(widget.domNode);
		
		dojo.publish("/davinci/ui/widgetPropertiesChanged",[[widget]]);
	},
	
	/**
	 * Mostly a duplicate of private function found in dojo/dom-geometry.js
	 * Returns true if node uses border-box layout
	 * TABLE and BUTTON (and INPUT type=button) are always border-box by default.
	 */
	_usesBorderBox:function (/*DomNode*/node){
		var tagName = node.tagName.toLowerCase();
		var type = node.getAttribute('type');
		if(type){
			type = type.toLowerCase(type);
		}
		return tagName == "table" || tagName == "button" || (tagName == 'input' && type == 'button'); // boolean
	},

	_resize: function(widget){
		var parent = widget.getParent();
		if(parent && parent.dijitWidget && parent.dijitWidget.isLayoutContainer){
			parent.resize();
		}else if(widget.resize){
			widget.resize();
		}
		widget.renderWidget();
		widget._updateSrcStyle();
	}

});
});

},
'davinci/html/CSSImport':function(){
/**
 * @class davinci.html.CSSImport
 * @constructor
 * @extends davinci.html.CSSElement
 */
define([
	"dojo/_base/declare",
	"davinci/html/CSSElement",
	"davinci/model/Path",
	"davinci/html/CSSFile"
], function(declare, CSSElement, Path, CSSFile) {

return declare("davinci.html.CSSImport", CSSElement, {

	constructor: function() {
		this.elementType = "CSSImport";
	},

	getCSSFile: function() {
		return this.parent;
	},

	setUrl: function(url) {
		this.url = url;
	},

	visit: function(visitor) {
		if (!visitor.visit(this)) {
			for ( var i = 0; i < this.children.length; i++ ) {
				this.children[i].visit(visitor);
			}
			if (this.cssFile) {
				this.cssFile.visit(visitor);
			}
		}
		if (visitor.endVisit) {
			visitor.endVisit(this);
		}
	},
	
	getText: function(context) {
		s = "@import ";
		if (this.isURL) {
			s += 'url("' + this.url + '");';
		} else {
			s += '"' + this.url + '";';
		}

		return s;
	},
	
	close: function(includeImports) {
		// the return of the CSSFile model needs to happen in the import instead of the CSSFile
		// if we return it in the CSSFile close we end up returning it twice due of the visit logic
		require("davinci/model/Factory").closeModel(this.cssFile); 
		if (this.connection) {
			dojo.disconnect(this.connection);
		}
		delete this.connection;
	},

	load: function(includeImports) {
		var p = this.parent;
		while (p && !(p.url || p.fileName)) {
			p = p.parent;
		}

		var path = new Path(p.url || p.fileName);
		path = path.getParentPath().append(this.url);
		var myUrl = path.toString();
       	// have to use the require or we get a circular dependency 
		this.cssFile = require("davinci/model/Factory").getModel({
			url : myUrl,
			loader : this.parent.loader,
			includeImports : this.parent.includeImports || includeImports
		});
		this.cssFile.relativeURL = this.url;
		this.connection = dojo.connect(this.cssFile, 'onChange', this.parent, 'onChange');
	}

});
});






},
'davinci/ui/Dialog':function(){
define([
	"dojo/_base/declare",
	"dijit/form/Button",
	"dijit/Dialog",
	"dojo/dom-geometry",
	"dojo/dom-style",
	"dojo/_base/connect",
	"dojo/window",
	"dojo/parser",
	"dojo/i18n!davinci/ve/nls/common",
	"dojox/layout/ResizeHandle",
], function(declare, Button, Dialog, domGeometry, style, connect, winUtils,
		parser, veNLS, ResizeHandle) {

var DialogClass = declare(Dialog, {
	contentStyle: null,

	buildRendering: function() {
		this.inherited(arguments);
		dojo.addClass(this.domNode, "resizableDialog");

		if (this.submitOnEnter) {
			dojo.addClass(this.domNode, "submitOnEnter");
		}
	},

	_setContent: function(cont, isFakeContent) {
		this.inherited(arguments);

		var div = dojo.doc.createElement("div");
		this.containerNode.appendChild(div);

		new ResizeHandle({targetId: this.id}, div);

		// we want to listen in the content are if it exists
		var contentNode = dojo.query(".dijitDialogPaneContentArea", this.containerNode)[0];
		if (contentNode) {
			dojo.connect(contentNode, "onkeydown", this, "_onKeyDown");
		} else {
			dojo.connect(this.domNode, "onkeydown", this, "_onKeyDown");
		}
	},

	resize: function(coords) {
		if (coords) {
			// compute paddings
			var computedStyle = style.getComputedStyle(this.containerNode);
			var output = domGeometry.getPadExtents(this.containerNode, computedStyle);

			var c = {w: coords.w-output.w, h: coords.h-output.h}
			c.h -= domGeometry.getMarginBox(this.titleBar).h;

			var contentArea = dojo.query(".dijitDialogPaneContentArea", this.containerNode)[0];
			var actionArea = dojo.query(".dijitDialogPaneActionBar", this.containerNode)[0];

			// subtract actionbar area
			c.h -= domGeometry.getMarginBox(actionArea).h;

			if (c.w) {
				dojo.style(contentArea, "width", c.w+"px");
			}

			if (c.h) {
				dojo.style(contentArea, "height", c.h+"px");
			}
			// resize children
			dojo.forEach(this.getChildren(), dojo.hitch(this, function(child) {
					if (child.resize) {
						child.resize({w: c.w, h: c.h});
					}
			}));
		}
	},

	show: function() {
		var result = this.inherited(arguments);

		// show will do initial sizing, lets now check if we have overrides
		if (this.contentStyle) {
			if (typeof(this.contentStyle) == "object") {
				var r = {}
				if (this.contentStyle.width) {
					r.w = parseInt(this.contentStyle.width);
				}

				if (this.contentStyle.height) {
					r.h = parseInt(this.contentStyle.height);
				}

				var viewport = winUtils.getBox(this.ownerDocument);
				viewport.w *= this.maxRatio;
				viewport.h *= this.maxRatio;

				if (r.h > viewport.h) {
					var containerSize = domGeometry.position(this.containerNode),
						w = Math.min(r.w, viewport.w) - (r.w - containerSize.w),
						h = Math.min(r.h, viewport.h) - (r.h - containerSize.h);
						r.h = viewport.h;
				}

				this.resize(r);
			}

			// reposition after changing sizes
			this._size();
			this._position();

			// clear any containerNode specific dimensions ot make resize work
			dojo.style(this.containerNode, "width", "auto");
			dojo.style(this.containerNode, "height", "auto");

//			this.layout();  //TODO: method disappeared in 1.8.0b1
		}

		return result;
	},

	_onKeyDown: function(e) {
		var hasAccel = ((e.ctrlKey && !dojo.isMac) || (dojo.isMac && e.metaKey))

		if (e.which == dojo.keys.ENTER && (hasAccel || this.submitOnEnter)) {
			// Accel enter submits a dialog, or just enter if submitOnEnter is true. 
			// We do this by looking for a submit input // and faking a mouse click event.
			var submitButtons = dojo.query("input[type=submit]", this.containerNode);

			if (submitButtons.length > 0) {
				var b = dijit.getEnclosingWidget(submitButtons[0]);

				var evt = document.createEvent("MouseEvents");
				evt.initMouseEvent("click", true, true, window, 0, 0, 0, 0, 0, false, false, false,
						false, 0, null);
				b._onClick(evt);
			}
		}
	}
});

// static helper methods
DialogClass._timedDestroy = function(dialog, handles) {
	if (handles) {
		handles.forEach(connect.disconnect);
	}

	// Timing situation here where we destroy the dialog before its fadeout animation
	// completes which will throw an exception.  So we listen to onHide to know
	// the dialog has finished hiding itself before we destroy it.
	var hndl = connect.connect(dialog, "onHide", function() {
		connect.disconnect(hndl);
		dialog.destroyRecursive();
	});

	dialog.hide();
}

DialogClass.showModal = function(content, title, style, callback, submitOnEnter, onShow) {
	var handles = [];

	var params = {
		title: title,
		content: content,
		contentStyle: style,
		submitOnEnter: submitOnEnter
	};
	if(onShow){
		params.onShow = onShow;
	}
	var myDialog = new DialogClass(params);

	var _onExecute = dojo.hitch(this, function() {
		var cancel = false;
		if (callback) {
			cancel = callback();
		}

		if (cancel) {
			return;
		}

		this._timedDestroy(myDialog, handles);
	});

	handles.push(connect.connect(myDialog, "onExecute", content, _onExecute));

	if (content.onExecute) {
		handles.push(connect.connect(content, "onExecute", content, _onExecute));
	}

	handles.push(connect.connect(content, "onClose", dojo.hitch(this, function() {
		this._timedDestroy(myDialog, handles);
	})));

	// handle the close button
	handles.push(connect.connect(myDialog, "onCancel", dojo.hitch(this, function() {
		this._timedDestroy(myDialog, handles);
	})));

	myDialog.show();

	return myDialog;
},

// simple dialog with an automatic OK button that closes it.
DialogClass.showMessage = function(title, message, style, callback, submitOnEnter) {
	return this.showDialog({
		title: title, 
		content: message, 
		style: style, 
		okCallback: callback, 
		okLabel: null, 
		hideCancel: true
	})
},

/**
 * OK/Cancel dialog with a settable okLabel
 * @param params {object}
 * 		params.title {string} Dialog title string
* 		params.content {string} HTML content for dialog
* 		params.style {string}
 * 		params.okLabel {string}
 * 		params.okCallback {function}
 * 		params.hideCancel {boolean}
 * 		params.submitOnEnter {boolean}
 * 		params.extendLabels [{string}] - Labels for additional buttons
 * 		params.extendCallbacks [{function}] - Callback functions for additional buttons
 */
DialogClass.showDialog = function(params) {
	var title = params.title;
	var content = params.content;
	var style = params.style;
	var callback = params.okCallback;
	var okLabel = params.okLabel;
	var hideCancel = params.hideCancel;
	var submitOnEnter = params.submitOnEnter;
	var extendLabels = params.extendLabels;
	var extendCallbacks = params.extendCallbacks;
	
	var myDialog;
	var handles = [];

	// construct the new contents
	var newContent = document.createElement("div");

	var dialogContents = document.createElement("div");
	dojo.addClass(dialogContents, "dijitDialogPaneContentArea");

	newContent.appendChild(dialogContents);

	var dialogActions = document.createElement("div");
	dojo.addClass(dialogActions, "dijitDialogPaneActionBar");

	var submitButton = new Button({label: okLabel ? okLabel : veNLS.ok, type: "submit", "class": "maqPrimaryButton"})
	dialogActions.appendChild(submitButton.domNode);

	var _onCancel = dojo.hitch(this, function() {
		this._timedDestroy(myDialog, handles);
	});
	
	// Add additional buttons if any are specified
	if(extendLabels && extendCallbacks && extendLabels.length > 0 && extendLabels.length === extendCallbacks.length){
		for(var i=0; i<extendLabels.length; i++){
			var customButtonOnClick = function(i){
				if(extendCallbacks[i]){
					extendCallbacks[i]();
				}
				myDialog.onCancel();
			}.bind(this, i);
			dialogActions.appendChild(new Button({label: extendLabels[i], onClick: customButtonOnClick, "class": "maqSecondaryButton"}).domNode);
		}
	}

	if (!hideCancel) {
		function _onCancelClick() {
			myDialog.onCancel();
		}
		dialogActions.appendChild(new Button({label: veNLS.cancel, onClick: _onCancelClick, "class": "maqSecondaryButton"}).domNode);
	}

	newContent.appendChild(dialogActions);

	myDialog = new DialogClass({
		title: title,
		content: newContent,
		contentStyle: style,
		submitOnEnter: submitOnEnter
	});

	// Add the content here to avoid building the widgets twice
	if (dojo.isString(content)) {
		dialogContents.innerHTML = content;
		parser.parse(dialogContents);
	} else {
		if (content.domNode) {
			dialogContents.appendChild(content.domNode);
		} else {
			dialogContents.appendChild(content);
		}
	}

	handles.push(connect.connect(myDialog, "onExecute", dojo.hitch(this, function() {
		if (callback) {
			callback();
		}
		_onCancel();
	})));

	handles.push(connect.connect(myDialog, "onCancel", dojo.hitch(this, function() {
		_onCancel();
	})));

	myDialog.show();

	return myDialog;
}

return DialogClass;
});

},
'dojox/validate/regexp':function(){
define(["dojo/_base/lang", "dojo/regexp", "dojox/main"], 
  function(lang, regexp, dojox){

var dxregexp = lang.getObject("validate.regexp", true, dojox);
dxregexp = dojox.validate.regexp = {
	
	ipAddress: function(flags){
		// summary:
		//		Builds a RE that matches an IP Address
		// description:
		//		Supports 5 formats for IPv4: dotted decimal, dotted hex, dotted octal, decimal and hexadecimal.
		//		Supports 2 formats for Ipv6.
		// flags: Object?
		//		All flags are boolean with default = true.
		//
		//		- flags.allowDottedDecimal  Example, 207.142.131.235.  No zero padding.
		//		- flags.allowDottedHex  Example, 0x18.0x11.0x9b.0x28.  Case insensitive.  Zero padding allowed.
		//		- flags.allowDottedOctal  Example, 0030.0021.0233.0050.  Zero padding allowed.
		//		- flags.allowDecimal  Example, 3482223595.  A decimal number between 0-4294967295.
		//		- flags.allowHex  Example, 0xCF8E83EB.  Hexadecimal number between 0x0-0xFFFFFFFF.
		//		  Case insensitive.  Zero padding allowed.
		//		- flags.allowIPv6   IPv6 address written as eight groups of four hexadecimal digits.
		
		//	FIXME: ipv6 can be written multiple ways IIRC
		//		- flags.allowHybrid   IPv6 address written as six groups of four hexadecimal digits
		//		-   followed by the usual 4 dotted decimal digit notation of IPv4. x:x:x:x:x:x:d.d.d.d

		// assign default values to missing paramters
		flags = (typeof flags == "object") ? flags : {};
		if(typeof flags.allowDottedDecimal != "boolean"){ flags.allowDottedDecimal = true; }
		if(typeof flags.allowDottedHex != "boolean"){ flags.allowDottedHex = true; }
		if(typeof flags.allowDottedOctal != "boolean"){ flags.allowDottedOctal = true; }
		if(typeof flags.allowDecimal != "boolean"){ flags.allowDecimal = true; }
		if(typeof flags.allowHex != "boolean"){ flags.allowHex = true; }
		if(typeof flags.allowIPv6 != "boolean"){ flags.allowIPv6 = true; }
		if(typeof flags.allowHybrid != "boolean"){ flags.allowHybrid = true; }

		// decimal-dotted IP address RE.
		var dottedDecimalRE =
			// Each number is between 0-255.  Zero padding is not allowed.
			"((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])";

		// dotted hex IP address RE.  Each number is between 0x0-0xff.  Zero padding is allowed, e.g. 0x00.
		var dottedHexRE = "(0[xX]0*[\\da-fA-F]?[\\da-fA-F]\\.){3}0[xX]0*[\\da-fA-F]?[\\da-fA-F]";

		// dotted octal IP address RE.  Each number is between 0000-0377.
		// Zero padding is allowed, but each number must have at least 4 characters.
		var dottedOctalRE = "(0+[0-3][0-7][0-7]\\.){3}0+[0-3][0-7][0-7]";

		// decimal IP address RE.  A decimal number between 0-4294967295.
		var decimalRE =  "(0|[1-9]\\d{0,8}|[1-3]\\d{9}|4[01]\\d{8}|42[0-8]\\d{7}|429[0-3]\\d{6}|" +
			"4294[0-8]\\d{5}|42949[0-5]\\d{4}|429496[0-6]\\d{3}|4294967[01]\\d{2}|42949672[0-8]\\d|429496729[0-5])";

		// hexadecimal IP address RE.
		// A hexadecimal number between 0x0-0xFFFFFFFF. Case insensitive.  Zero padding is allowed.
		var hexRE = "0[xX]0*[\\da-fA-F]{1,8}";

		// IPv6 address RE.
		// The format is written as eight groups of four hexadecimal digits, x:x:x:x:x:x:x:x,
		// where x is between 0000-ffff. Zero padding is optional. Case insensitive.
		var ipv6RE = "([\\da-fA-F]{1,4}\\:){7}[\\da-fA-F]{1,4}";

		// IPv6/IPv4 Hybrid address RE.
		// The format is written as six groups of four hexadecimal digits,
		// followed by the 4 dotted decimal IPv4 format. x:x:x:x:x:x:d.d.d.d
		var hybridRE = "([\\da-fA-F]{1,4}\\:){6}" +
			"((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])";

		// Build IP Address RE
		var a = [];
		if(flags.allowDottedDecimal){ a.push(dottedDecimalRE); }
		if(flags.allowDottedHex){ a.push(dottedHexRE); }
		if(flags.allowDottedOctal){ a.push(dottedOctalRE); }
		if(flags.allowDecimal){ a.push(decimalRE); }
		if(flags.allowHex){ a.push(hexRE); }
		if(flags.allowIPv6){ a.push(ipv6RE); }
		if(flags.allowHybrid){ a.push(hybridRE); }

		var ipAddressRE = "";
		if(a.length > 0){
			ipAddressRE = "(" + a.join("|") + ")";
		}
		return ipAddressRE; // String
	},

	host: function(flags){
		// summary:
		//		Builds a RE that matches a host
		// description:
		//		A host is a named host (A-z0-9_- but not starting with -), a domain name or an IP address, possibly followed by a port number.
		// flags: Object?
		//		- flags.allowNamed Allow a named host for local networks. Default is false.
		//		- flags.allowIP  Allow an IP address for hostname.  Default is true.
		//		- flags.allowLocal  Allow the host to be "localhost".  Default is false.
		//		- flags.allowPort  Allow a port number to be present.  Default is true.
		//		- flags in regexp.ipAddress can be applied.

		// assign default values to missing paramters
		flags = (typeof flags == "object") ? flags : {};

		if(typeof flags.allowIP != "boolean"){ flags.allowIP = true; }
		if(typeof flags.allowLocal != "boolean"){ flags.allowLocal = false; }
		if(typeof flags.allowPort != "boolean"){ flags.allowPort = true; }
		if(typeof flags.allowNamed != "boolean"){ flags.allowNamed = false; }

		//TODO: support unicode hostnames?
		// Domain name labels can not end with a dash.
		var domainLabelRE = "(?:[\\da-zA-Z](?:[-\\da-zA-Z]{0,61}[\\da-zA-Z])?)";
		var domainNameRE = "(?:[a-zA-Z](?:[-\\da-zA-Z]{0,6}[\\da-zA-Z])?)"; // restricted version to allow backwards compatibility with allowLocal, allowIP

		// port number RE
		var portRE = flags.allowPort ? "(\\:\\d+)?" : "";

		// build host RE
		var hostNameRE = "((?:" + domainLabelRE + "\\.)+" + domainNameRE + "\\.?)";
		if(flags.allowIP){ hostNameRE += "|" +  dxregexp.ipAddress(flags); }
		if(flags.allowLocal){ hostNameRE += "|localhost"; }
		if(flags.allowNamed){ hostNameRE += "|^[^-][a-zA-Z0-9_-]*"; }
		return "(" + hostNameRE + ")" + portRE; // String

	},

	url: function(flags){
		// summary:
		//		Builds a regular expression that matches a URL
		// flags: Object?
		//		- flags.scheme  Can be true, false, or [true, false].
		//		-   This means: required, not allowed, or match either one.
		//		- flags in regexp.host can be applied.
		//		- flags in regexp.ipAddress can be applied.

		// assign default values to missing paramters
		flags = (typeof flags == "object") ? flags : {};
		if(!("scheme" in flags)){ flags.scheme = [true, false]; }

		// Scheme RE
		var protocolRE = regexp.buildGroupRE(flags.scheme,
			function(q){ if(q){ return "(https?|ftps?)\\://"; } return ""; }
		);

		// Path and query and anchor RE
		var pathRE = "(/(?:[^?#\\s/]+/)*(?:[^?#\\s/]+(?:\\?[^?#\\s/]*)?(?:#[A-Za-z][\\w.:-]*)?)?)?";

		return protocolRE + dxregexp.host(flags) + pathRE;
	},

	emailAddress: function(flags){
		// summary:
		//		Builds a regular expression that matches an email address
		// flags: Object?
		//		- flags.allowCruft  Allow address like `<mailto:foo@yahoo.com>`.  Default is false.
		//		- flags in regexp.host can be applied.
		//		- flags in regexp.ipAddress can be applied.

		// assign default values to missing paramters
		flags = (typeof flags == "object") ? flags : {};
		if (typeof flags.allowCruft != "boolean") { flags.allowCruft = false; }
		flags.allowPort = false; // invalid in email addresses

		// user name RE per rfc5322
		var usernameRE = "([!#-'*+\\-\\/-9=?A-Z^-~]+[.])*[!#-'*+\\-\\/-9=?A-Z^-~]+";

		// build emailAddress RE
		var emailAddressRE = usernameRE + "@" + dxregexp.host(flags);

		// Allow email addresses with cruft
		if ( flags.allowCruft ) {
			emailAddressRE = "<?(mailto\\:)?" + emailAddressRE + ">?";
		}

		return emailAddressRE; // String
	},

	emailAddressList: function(flags){
		// summary:
		//		Builds a regular expression that matches a list of email addresses.
		// flags: Object?
		//		- flags.listSeparator  The character used to separate email addresses.  Default is ";", ",", "\n" or " ".
		//		- flags in regexp.emailAddress can be applied.
		//		- flags in regexp.host can be applied.
		//		- flags in regexp.ipAddress can be applied.

		// assign default values to missing paramters
		flags = (typeof flags == "object") ? flags : {};
		if(typeof flags.listSeparator != "string"){ flags.listSeparator = "\\s;,"; }

		// build a RE for an Email Address List
		var emailAddressRE = dxregexp.emailAddress(flags);
		var emailAddressListRE = "(" + emailAddressRE + "\\s*[" + flags.listSeparator + "]\\s*)*" +
			emailAddressRE + "\\s*[" + flags.listSeparator + "]?\\s*";

		return emailAddressListRE; // String
	},
	
	numberFormat: function(flags){
		// summary:
		//		Builds a regular expression to match any sort of number based format
		// description:
		//		Use this method for phone numbers, social security numbers, zip-codes, etc.
		//		The RE can match one format or one of multiple formats.
		//
		//		Format:
		//
		//		- #        Stands for a digit, 0-9.
		//		- ?        Stands for an optional digit, 0-9 or nothing.
		//		- All other characters must appear literally in the expression.
		//
		// example:
		//		- "(###) ###-####"		-    ->   (510) 542-9742
		//		- "(###) ###-#### x#???" ->   (510) 542-9742 x153
		//		- "###-##-####"		- 		-   ->   506-82-1089		-    i.e. social security number
		//		- "#####-####"		- 		-    ->   98225-1649		- 		- i.e. zip code
		//
		// flags:  Object?
		//		- flags.format  A string or an Array of strings for multiple formats.

		// assign default values to missing paramters
		flags = (typeof flags == "object") ? flags : {};
		if(typeof flags.format == "undefined"){ flags.format = "###-###-####"; }

		// Converts a number format to RE.
		var digitRE = function(format){
			// escape all special characters, except '?'
			return regexp.escapeString(format, "?")
				// Now replace '?' with Regular Expression
				.replace(/\?/g, "\\d?")
				// replace # with Regular Expression
				.replace(/#/g, "\\d")
			;
		};

		// build RE for multiple number formats
		return regexp.buildGroupRE(flags.format, digitRE); //String
	},
	
	ca: {

		postalCode: function(){
			// summary:
			//		String regular Express to match Canadain Postal Codes
			return "([A-Z][0-9][A-Z] [0-9][A-Z][0-9])";
		},

		province: function(){
			// summary:
			//		a regular expression to match Canadian Province Abbreviations
			return "(AB|BC|MB|NB|NL|NS|NT|NU|ON|PE|QC|SK|YT)";
		}

	},
	
	us:{
		state: function(flags){
			// summary:
			//		A regular expression to match US state and territory abbreviations
			// flags: Object?
			//		- flags.allowTerritories  Allow Guam, Puerto Rico, etc.  Default is true.
			//		- flags.allowMilitary  Allow military 'states', e.g. Armed Forces Europe (AE).  Default is true.

			// assign default values to missing parameters
			flags = (typeof flags == "object") ? flags : {};
			if(typeof flags.allowTerritories != "boolean"){ flags.allowTerritories = true; }
			if(typeof flags.allowMilitary != "boolean"){ flags.allowMilitary = true; }

			// state RE
			var statesRE =
				"AL|AK|AZ|AR|CA|CO|CT|DE|DC|FL|GA|HI|ID|IL|IN|IA|KS|KY|LA|ME|MD|MA|MI|MN|MS|MO|MT|" +
				"NE|NV|NH|NJ|NM|NY|NC|ND|OH|OK|OR|PA|RI|SC|SD|TN|TX|UT|VT|VA|WA|WV|WI|WY";

			// territories RE
			var territoriesRE = "AS|FM|GU|MH|MP|PW|PR|VI";

			// military states RE
			var militaryRE = "AA|AE|AP";

			// Build states and territories RE
			if(flags.allowTerritories){ statesRE += "|" + territoriesRE; }
			if(flags.allowMilitary){ statesRE += "|" + militaryRE; }

			return "(" + statesRE + ")"; // String
		}

	}
	
};

return dxregexp;

});

},
'dojo/dnd/Mover':function(){
define([
	"../_base/array", "../_base/declare", "../_base/event", "../_base/lang", "../sniff", "../_base/window",
	"../dom", "../dom-geometry", "../dom-style", "../Evented", "../on", "../touch", "./common", "./autoscroll"
], function(array, declare, event, lang, has, win, dom, domGeom, domStyle, Evented, on, touch, dnd, autoscroll){

// module:
//		dojo/dnd/Mover

return declare("dojo.dnd.Mover", [Evented], {
	// summary:
	//		an object which makes a node follow the mouse, or touch-drag on touch devices.
	//		Used as a default mover, and as a base class for custom movers.

	constructor: function(node, e, host){
		// node: Node
		//		a node (or node's id) to be moved
		// e: Event
		//		a mouse event, which started the move;
		//		only pageX and pageY properties are used
		// host: Object?
		//		object which implements the functionality of the move,
		//	 	and defines proper events (onMoveStart and onMoveStop)
		this.node = dom.byId(node);
		this.marginBox = {l: e.pageX, t: e.pageY};
		this.mouseButton = e.button;
		var h = (this.host = host), d = node.ownerDocument;
		this.events = [
			// At the start of a drag, onFirstMove is called, and then the following
			// listener is disconnected.
			on(d, touch.move, lang.hitch(this, "onFirstMove")),

			// These are called continually during the drag
			on(d, touch.move, lang.hitch(this, "onMouseMove")),

			// And these are called at the end of the drag
			on(d, touch.release,  lang.hitch(this, "onMouseUp")),

			// cancel text selection and text dragging
			on(d, "dragstart",   event.stop),
			on(d.body, "selectstart", event.stop)
		];

		// Tell autoscroll that a drag is starting
		autoscroll.autoScrollStart(d);

		// notify that the move has started
		if(h && h.onMoveStart){
			h.onMoveStart(this);
		}
	},
	// mouse event processors
	onMouseMove: function(e){
		// summary:
		//		event processor for onmousemove/ontouchmove
		// e: Event
		//		mouse/touch event
		autoscroll.autoScroll(e);
		var m = this.marginBox;
		this.host.onMove(this, {l: m.l + e.pageX, t: m.t + e.pageY}, e);
		event.stop(e);
	},
	onMouseUp: function(e){
		if(has("webkit") && has("mac") && this.mouseButton == 2 ?
				e.button == 0 : this.mouseButton == e.button){ // TODO Should condition be met for touch devices, too?
			this.destroy();
		}
		event.stop(e);
	},
	// utilities
	onFirstMove: function(e){
		// summary:
		//		makes the node absolute; it is meant to be called only once.
		//		relative and absolutely positioned nodes are assumed to use pixel units
		var s = this.node.style, l, t, h = this.host;
		switch(s.position){
			case "relative":
			case "absolute":
				// assume that left and top values are in pixels already
				l = Math.round(parseFloat(s.left)) || 0;
				t = Math.round(parseFloat(s.top)) || 0;
				break;
			default:
				s.position = "absolute";	// enforcing the absolute mode
				var m = domGeom.getMarginBox(this.node);
				// event.pageX/pageY (which we used to generate the initial
				// margin box) includes padding and margin set on the body.
				// However, setting the node's position to absolute and then
				// doing domGeom.marginBox on it *doesn't* take that additional
				// space into account - so we need to subtract the combined
				// padding and margin.  We use getComputedStyle and
				// _getMarginBox/_getContentBox to avoid the extra lookup of
				// the computed style.
				var b = win.doc.body;
				var bs = domStyle.getComputedStyle(b);
				var bm = domGeom.getMarginBox(b, bs);
				var bc = domGeom.getContentBox(b, bs);
				l = m.l - (bc.l - bm.l);
				t = m.t - (bc.t - bm.t);
				break;
		}
		this.marginBox.l = l - this.marginBox.l;
		this.marginBox.t = t - this.marginBox.t;
		if(h && h.onFirstMove){
			h.onFirstMove(this, e);
		}

		// Disconnect touch.move that call this function
		this.events.shift().remove();
	},
	destroy: function(){
		// summary:
		//		stops the move, deletes all references, so the object can be garbage-collected
		array.forEach(this.events, function(handle){ handle.remove(); });
		// undo global settings
		var h = this.host;
		if(h && h.onMoveStop){
			h.onMoveStop(this);
		}
		// destroy objects
		this.events = this.node = this.host = null;
	}
});

});

},
'davinci/review/widgets/OpenReviewDialog':function(){
define(["dojo/_base/declare",
        "dijit/_Templated",
        "dijit/_Widget",
        "dijit/Tree",
        "davinci/review/view/CommentExplorerView",
        "davinci/review/model/ReviewTreeModel",
        "davinci/Workbench",
        "dojo/i18n!davinci/ui/nls/ui",
        "dojo/i18n!dijit/nls/common",
        "dojo/text!./templates/OpenReviewDialog.html",
        "dijit/form/Button", //used in template
        "dijit/layout/ContentPane" //used in template
        
],function(declare, _Templated, _Widget, Tree, CommentExplorerView, ReviewTreeModel, Workbench, uiNLS, commonNLS, templateString){
	return declare("davinci.ui.widgets.OpenFile",   [_Widget, _Templated], {
		widgetsInTemplate: true,
		templateString: templateString,
		
		fileDialogFileName : null,
		fileDialogParentFolder: null,
		
		postMixInProperties: function() {
			dojo.mixin(this, uiNLS);
			dojo.mixin(this, commonNLS);
			if (!this.finishButtonLabel) {
				this.finishButtonLabel = uiNLS.open;
			}
			this.inherited(arguments);
		},
		
		postCreate: function(){
			this.inherited(arguments);
			
			//Create the tree
			var model= new ReviewTreeModel();
			this.model = model;
			var tree = this.tree = new Tree({
				id: "openReviewDialogTree",
				persist: false,
				showRoot: false,
				model: model,
				labelAttr: "name", 
				childrenAttrs: "children",
				getIconClass: CommentExplorerView.getIconClass,
				getLabelClass: CommentExplorerView.getLabelClass,
				transforms: CommentExplorerView.getSortTransforms()
			});
			
			//Add tree to dialog
			this.treeContentPane.set("content", tree);
		
			//Watch for selection changes on tree
			tree.watch("selectedItems", dojo.hitch(this, this._updateFields));
		},
	
		startup: function() {		
			this.tree.startup();
		},
		
		_updateFields: function(){
			//Clear out old values
			this.okButton.set("disabled", true);
			this._selectedResource = null;
			
			//Get selected items
			var resources = this.tree.get('selectedItems');
			
			//Determine if we have one valid item selected
			if (resources && resources.length == 1) {
				var resource = resources[0];
				if (resource.elementType == "ReviewFile") {
					this.okButton.set("disabled", false);
					this._selectedResource = resource;
				}
			}	
		},

		_okButton: function(){
			if (this._selectedResource) {
				//Open editor
				var item = this._selectedResource;
				davinci.Workbench.openEditor({
					fileName: item,
					content: item.getText()
				});
				
				this.cancel = false;
			}
		},
		
		_cancelButton: function(){
			this.onClose();
		},

		resize: function(coords) {
			this.treeContentPane.resize(coords);
		},
		
		onClose: function() {

		}
	});
});
},
'dijit/layout/TabContainer':function(){
define([
	"dojo/_base/lang", // lang.getObject
	"dojo/_base/declare", // declare
	"./_TabContainerBase",
	"./TabController",
	"./ScrollingTabController"
], function(lang, declare, _TabContainerBase, TabController, ScrollingTabController){

	// module:
	//		dijit/layout/TabContainer


	return declare("dijit.layout.TabContainer", _TabContainerBase, {
		// summary:
		//		A Container with tabs to select each child (only one of which is displayed at a time).
		// description:
		//		A TabContainer is a container that has multiple panes, but shows only
		//		one pane at a time.  There are a set of tabs corresponding to each pane,
		//		where each tab has the name (aka title) of the pane, and optionally a close button.
		//
		//		See `StackContainer.ChildWidgetProperties` for details on the properties that can be set on
		//		children of a `TabContainer`.

		// useMenu: [const] Boolean
		//		True if a menu should be used to select tabs when they are too
		//		wide to fit the TabContainer, false otherwise.
		useMenu: true,

		// useSlider: [const] Boolean
		//		True if a slider should be used to select tabs when they are too
		//		wide to fit the TabContainer, false otherwise.
		useSlider: true,

		// controllerWidget: Class
		//		An optional parameter to override the widget used to display the tab labels
		controllerWidget: "",

		_makeController: function(/*DomNode*/ srcNode){
			// summary:
			//		Instantiate tablist controller widget and return reference to it.
			//		Callback from _TabContainerBase.postCreate().
			// tags:
			//		protected extension

			// "string" branch for back-compat, remove for 2.0
			var cls = this.baseClass + "-tabs" + (this.doLayout ? "" : " dijitTabNoLayout"),
				TabController = typeof this.controllerWidget == "string" ? lang.getObject(this.controllerWidget) :
						this.controllerWidget;

			return new TabController({
				id: this.id + "_tablist",
				ownerDocument: this.ownerDocument,
				dir: this.dir,
				lang: this.lang,
				textDir: this.textDir,
				tabPosition: this.tabPosition,
				doLayout: this.doLayout,
				containerId: this.id,
				"class": cls,
				nested: this.nested,
				useMenu: this.useMenu,
				useSlider: this.useSlider,
				tabStripClass: this.tabStrip ? this.baseClass + (this.tabStrip ? "":"No") + "Strip": null
			}, srcNode);
		},

		postMixInProperties: function(){
			this.inherited(arguments);

			// Scrolling controller only works for horizontal non-nested tabs
			if(!this.controllerWidget){
				this.controllerWidget = (this.tabPosition == "top" || this.tabPosition == "bottom") && !this.nested ?
							ScrollingTabController : TabController;
			}
		}
	});
});

},
'davinci/commands/CompoundCommand':function(){
define([
	    "dojo/_base/declare"
], function(declare){
	
return declare("davinci.commands.CompoundCommand", null, {
	// summary:
//	Represents a command that consists of multiple subcommands.

	name: "compound",
	_commands :[],
	
	constructor: function(command){
		this._commands = [];
		if(command){
			this._commands = [command];
		}
	},

	add: function(command){
		// summary:
		//		Adds the command to this command's list of commands to execute.
		if(!command){
			return;
		}

		if(!this._commands){
			if(command.name == "compound"){
				this._commands = command._commands;
			}else{
				this._commands = [command];
			}
		}else{
			if(command.name == "compound"){
				// merge commands
				dojo.forEach(command._commands, function(c){
					this.add(c);
				}, this);
				return;
			}else if(command.name == "modify"){
				// merge modify command
				var id = command._oldId;
				for(var i = 0; i < this._commands.length; i++){
					var c = this._commands[i];
					if(c.name == "modify" && c._oldId == id){
						c.add(command);
						return;
					}
				}
			}
			this._commands.push(command);
		}
	},


	setContext : function(context){
		for(var i = 0;i<this._commands.length;i++)
			if(this._commands[i].setContext) 
				this._commands[i].setContext(context);
		
		
	},
	isEmpty: function(){
		// summary:
		//		Returns whether this command has any subcommands to execute.
		return (!this._commands || this._commands.length === 0);
	},

	execute: function(){
		// summary:
		//		Executes this command, which in turn executes each child command in the order they were added.
		if(!this._commands){
			return;
		}

		for(var i = 0; i < this._commands.length; i++){
			this._commands[i].execute();
			if(this._commands[i]._oldId && this._commands[i]._newId){
				this._oldId = this._commands[i]._oldId;
				this._newId = this._commands[i]._newId;
			}
		}
	},

	undo: function(){
		// summary:
		//		Undoes each of the child commands (in reverse order).
		if(!this._commands){
			return;
		}

		for(var i = this._commands.length - 1; i >= 0; i--){
			this._commands[i].undo();
		}
	}

});
});

},
'davinci/maqetta/AppStates':function(){
define(["dojo/_base/connect", "dojo/dom-style", "dojo/dom", "dojo/_base/html", "dojo/_base/window", "dojo/_base/array", "dojo/parser", "require", "dojo/json", "dojo/_base/lang"], 
function(connect, domStyle, dom, dhtml, dwindow, darray, dparser, require, JSON, lang){ // needed for IE9 compat view mode

var States = function(){};
States.prototype = {

	NORMAL: "Normal",
	DELTAS_ATTRIBUTE: "data-maq-deltas",
	DELTAS_ATTRIBUTE_P6: "dvStates",	// Attribute name used in Preview6 or earlier
	APPSTATES_ATTRIBUTE: "data-maq-appstates",
	APPSTATES_ATTRIBUTE_P6: "dvStates",	// Attribute name used in Preview6 or earlier
	reImportant: /^(.*)(!\ *important)(.*)/,

	/**
	 * Returns true if the given node has application states (i.e., node._maqAppStates has a value)
	 */
	isStateContainer: function(node){
		return !!(node && node._maqAppStates);
	},
	
	/**
	 * Returns an array of all ancestor nodes that are state containers (due to having a _maqAppStates property)
	 * @param node
	 * @returns {Array[Element]}  an array of Elements for all ancestor state containers.
	 *      If this node is a state container, it is included in the list.
	 *      First element in array should be the BODY element.
	 */
	getStateContainersForNode: function(node){
		var allStateContainers = [];
		var n = node;
		while(n){
			if(n._maqAppStates){
				allStateContainers.splice(0, 0, n);
			}
			if(n.tagName == 'BODY'){
				break;
			}
			n = n.parentNode;
		}
		return allStateContainers;
	},
	
	/**
	 * Returns an array of all nodes that are state containers (due to having a _maqAppStates property)
	 * @param rootnode
	 * @returns {Array[Element]}  an array of Elements for all state containers in document
	 */
	getAllStateContainers: function(rootnode){
		var allStateContainers = [];
		var that = this;
		function findStateContainers(currentNode){
			if(currentNode._maqAppStates){
				allStateContainers.push(currentNode);
			}
			var children = that._getChildrenOfNode(currentNode);
			for(var i=0; i<children.length; i++){
				findStateContainers(children[i]);
			}
		}
		findStateContainers(rootnode);
		return allStateContainers;
	},
	
	/**
	 * Returns a statesArray data structure for the given node
	 * @param {Element} node  An element node in the document
	 * @param {string|undefined} oldState  The state which used to be active
	 * @param {string|undefined} newState  The state which has now become active
	 * @param {Element} stateContainerNode  The (state container) element on which oldState and newState are defined
	 * @returns {[object]} statesArray  
	 *    Array of "state containers" that apply to this node,
	 *    with furthest ancestor at position 0 and nearest at position length-1.
	 *    Each item in array is an object with these properties
	 *      statesArray[i].node - a state container node
	 *      statesArray[i].oldState - the previous appstate that had been active on this state container node
	 *      statesArray[i].newState - the new appstate for this state container node
	 */ 
	getStatesArray: function(node, oldState, newState, stateContainerNode){
		var statesArray = [];
		if(node){
			var pn = node.parentNode;
			while(pn){
				if(pn._maqAppStates){
					
					if(pn == stateContainerNode){
						statesArray.splice(0, 0, {node:pn, oldState:oldState, newState:newState});
					}else{
						var current = pn._maqAppStates.states ? pn._maqAppStates.states.current : undefined;
						statesArray.splice(0, 0, {node:pn, oldState:current, newState:current});
					}
				}
				if(pn.tagName == 'BODY'){
					break;
				}
				pn = pn.parentNode;
			}
		}
		return statesArray;
	},

	/**
	 * Returns the nearest ancestor node that defines the given state.
	 * @param {Element} node  An element node in the document
	 * @param {string} state  The name of a state
	 * @returns {Element|undefined}  state container node (or undefined if not found)
	 */ 
	findStateContainer: function(node, state){
		if(node){
			var pn = node.parentNode;
			while(pn){
				if(pn._maqAppStates && 
						(!state || state == this.NORMAL ||  
						(pn._maqAppStates.states && pn._maqAppStates.states.indexOf(state)>=0))){
					return pn;
				}
				if(pn.tagName == 'BODY'){
					break;
				}
				pn = pn.parentNode;
			}
		}
	},

	/**
	 * Returns a flat list of all states that apply to the given node.
	 * @param {Element} node  An element node in the document
	 * @returns {[string]}  An array of strings, one item for each state that 
	 *       that is defined by a parent state container.
	 *       Note that there might be duplicate names.
	 *       "Normal" is only added once even if there are multiple
	 *       state containers.
	 */ 
	getAllStatesForNode: function(node){
		var statesList = [this.NORMAL];
		if(node){
			var pn = node.parentNode;
			while(pn){
				if(pn._maqAppStates && pn._maqAppStates.states){
					var states = pn._maqAppStates.states ? pn._maqAppStates.states : [];
					for(var i=0; i<states.length; i++){
						statesList.push(states[i]);
					}
				}
				if(pn.tagName == 'BODY'){
					break;
				}
				pn = pn.parentNode;
			}
		}
		return statesList;
	},

	/**
	 * Returns the array of application states that are currently active on the given node.
	 * If app states are only defined on BODY, then the return array will only have 1 item.
	 * If nested app state containers, then the returned array will have multiple items,
	 * with the furthest ancestor state container at position 0 and nearest at position length-1.
	 * @param {Element} node  An element node in the document
	 * @returns {[string|undefined]}  An array of strings, where each entry is either undefined
	 *           (indicating Normal state) or a state name.
	 */ 
	getStatesListCurrent: function(node){
		var statesList = [];
		if(node){
			var pn = node.parentNode;
			while(pn){
				if(pn._maqAppStates){
					statesList.splice(0, 0, pn._maqAppStates.current);
				}
				if(pn.tagName == 'BODY'){
					break;
				}
				pn = pn.parentNode;
			}
		}
		return statesList;
	},

	/**
	 * Returns the array of objects that lists all statecontainers that are on the given rootnode
	 * or any descendants and the currently active state for each given statecontainer.
	 * @param {Element} rootnode  
	 * @returns {[object]}  An array of objects, where each object has the following properties
	 *           {Element} stateContainerNode
	 *           {string|undefined|null} currently active state
	 */ 
	getAllCurrentStates: function(rootnode){
		var allStateContainers = this.getAllStateContainers(rootnode);
		var currentStates = [];
		for(var i=0; i<allStateContainers.length; i++){
			var node = allStateContainers[i];
			var state = this.getState(node);
			currentStates.push({ stateContainerNode:node, state:state });
		}
		return currentStates;
	},

	/**
	 * Returns the array of application states declared on the given node.
	 * At this point, only the BODY node can have application states declared on it.
	 * In future, maybe application states will include a recursive feature.
	 * @param {Element} node  BODY node for document
	 */ 
	getStates: function(node){
		var states = node && node._maqAppStates;
		var names = ["Normal"];
		if(states){
			var statesList = states.states ? states.states : [];
			for(var i=0; i<statesList.length; i++){
				var name = statesList[i];
				if(name != 'Normal'){
					names.push(name);
				}
			}
		}
		return names;
	},

	/**
	 * Internal routine. Returns state container corresponding to state and ElemOrEvent.
	 * @param {undefined|null|string} state   we are searching for a state container that defines this state
	 * @param {Element|Event} ElemOrEvent 
	 *        If an Element, then either the given Element is the state container
	 *        or we will march up the ancestor tree until finding the state container.
	 *        If an Event, then either the Event.currentTarget is the state container
	 *        or we will march up the ancestor tree until finding the state container.
	 * @returns {Element}
	 */
	_getSCNodeFromElemOrEvent: function(state, ElemOrEvent) {
		var node;
		// Determine if second param is an Element or Event object
		if(ElemOrEvent && ElemOrEvent.tagName && ElemOrEvent.nodeName){
			// ElemOrEvent is an Element
			node = ElemOrEvent._maqAppStates ? ElemOrEvent : this.findStateContainer(ElemOrEvent, state);
		}else if(ElemOrEvent && ElemOrEvent.target && ElemOrEvent.currentTarget){
			// ElemOrEvent is an Event
			node = ElemOrEvent.currentTarget;
			if(!node._maqAppStates){
				node = this.findStateContainer(node, state);
			}
		}else{
			node = this.getContainer();;
		}
		return node;
	},
	
	/**
	 * Hook for when included in Maqetta page editor.
	 * The Maqetta page editor provides a subclass that overwrites this empty routine.
	 * When in the page editor, this function updates the "model" with latest states info
	 * for a given node.
	 * @param {Element} node
	 */
	_updateSrcState: function (node){
	},
	
	/**
	 * Returns true if the given application "state" exists.
	 * @param {Element} node  Right now must be BODY element
	 * @param {string} state  Name of state that might or not exist already
	 * return {boolean} 
	 */
	hasState: function(node, state){ 
		return !!(node && node._maqAppStates && node._maqAppStates.states && node._maqAppStates.states.indexOf(state)>=0);
	},

	/**
	 * Returns the current state for the given state container node.
	 */
	getState: function(node){
		return node && node._maqAppStates && node._maqAppStates.current;
	},
	
	/**
	 * Change the current "state" for a particular state container node.
	 * This will trigger updates to the document such that various properties
	 * on various node will be altered (e.g., visibility of particular nodes)
	 * because the document defines state-specific values for particular properties.
	 * This routine doesn't actually do any updates; instead, updates happen
	 * by publishing a /maqetta/appstates/state/changed event, which indirectly causes
	 * the _update() routine to be called for the given node.
	 * 
	 * @param {null|undefined|string} newState  If null|undefined, switch to "Normal" state, else to "newState"
	 * @param {Element|Event} ElemOrEvent  Identifies state container.
	 *        If an Element, then either the given Element is the state container
	 *        or we will march up the ancestor tree until finding the state container.
	 *        If an Event, then either the Event.currentTarget is the state container
	 *        or we will march up the ancestor tree until finding the state container.
	 * @param [{object}] params  (Optional) Various flags
	 *     params.updateWhenCurrent {boolean}  Force update logic to run even if newState is same as current state
	 *     params.silent {boolean}  If true, don't broadcast the state change via /davinci/states/state/changed
	 *     params.focus {boolean}  If true, then set the document-level "application state focus" 
	 *                             to the given state on the given state container.
	 *                             This feature is primarily used by design-time tools.
	 *     params.initial {boolean}  If provided and true, then this state becomes initial state
	 *                             at document load time for the given state container.
	 *                             If provided and false, then remove any designation that this
	 *                             state should be the initial state at document load time.
	 *                             This feature is primarily used by design-time tools.
	 * Subscribe using davinci.states.subscribe("/maqetta/appstates/state/changed", callback).
	 * FIXME: updateWhenCurrent is ugly. Higher level code could include that logic
	 * FIXME: silent is ugly. Higher level code code broadcast the change.
	 */
	setState: function(newState, ElemOrEvent, params){
		var updateWhenCurrent = params ? params.updateWhenCurrent : false;
		var silent = params ? params.silent : false;
		var focus = params ? params.focus : false;
		var node = this._getSCNodeFromElemOrEvent(newState, ElemOrEvent);
		if (!node || !node._maqAppStates || (!updateWhenCurrent && node._maqAppStates.current == newState)) {
			return;
		}
		var oldState = node._maqAppStates.current;
		if (this.isNormalState(newState)) {
			if(node._maqAppStates.hasOwnProperty('current')){
				delete node._maqAppStates.current;
			}
			newState = undefined;
		} else {
			node._maqAppStates.current = newState;
		}
		if(focus){
			this._setFocus(newState, node);
		}
		if(params && params.hasOwnProperty('initial')){
			if(params.initial){
				node._maqAppStates.initial = newState;
			}else if(node._maqAppStates.initial){
				delete node._maqAppStates.initial;
			}
		}
		if (!silent) {
//FIXME: Reconcile node and stateContainerNode
			connect.publish("/maqetta/appstates/state/changed", 
					[{node:node, newState:newState, oldState:oldState, stateContainerNode:node}]);
		}

		// if no new state we can skip setting the dirty flag
		this._updateSrcState (node, !newState);		
	},

	/**
	 * Returns the application state for the given state container node
	 * that should show at document load time.
	 */
	getInitial: function(node){
		return node && node._maqAppStates && node._maqAppStates.initial;
	},
	
	/**
	 * Returns the document-level "focus" for the application states feature.
	 * The "focus" consists of a particular state within a particular state container.
	 * This feature is primarily used by design-time tools.
	 * @param {Element} rootNode  BODY element for document
	 * @returns {null|object}
	 *      return null if a search through document did not find any state containers
	 *      that claim to have the focus
	 *      if search finds at least one state container that claims to have focus,
	 *      then for first one encountered, return an object of form
	 *      { stateContainerNode:{Element}, state:{string} }
	 */
	getFocus: function(rootNode){
		if(!rootNode){
			return null;
		}
		var allStateContainerNodes = this.getAllStateContainers(rootNode);
		for(var i=0; i<allStateContainerNodes.length; i++){
			var maqAppStates = allStateContainerNodes[i]._maqAppStates;
			if(maqAppStates && maqAppStates.hasOwnProperty('focus')){
				return { stateContainerNode:allStateContainerNodes[i], state:maqAppStates.focus };
			}
		}
		return null;
	},

	/**
	 * Internal routine, calls by setState() if the "set focus" flag says that we should
	 * set the document-level "focus" to a particular state within a particular state container.
	 * This feature is primarily used by design-time tools.
	 * @param {null|undefined|string} state  If null|undefined, set focus to "Normal" state, else to "newState"
	 * @param {Element} node  Identifies state container.
	 */
	_setFocus: function(newState, node){
		if (!node || !node._maqAppStates) {
			return;
		}
		var rootNode = (node.ownerDocument && node.ownerDocument.body);
		if(!rootNode){
			return;
		}
		var currentFocus = this.getFocus(rootNode);
		if(currentFocus && currentFocus.stateContainerNode == node && currentFocus.state == newState){
			return;
		}
		var maqAppStates;
		var allStateContainerNodes = this.getAllStateContainers(rootNode);
		for(var i=0; i<allStateContainerNodes.length; i++){
			maqAppStates = allStateContainerNodes[i]._maqAppStates;
			if(maqAppStates){
				delete maqAppStates.focus;
			}
		}
		node._maqAppStates.focus = newState;
	},

//FIXME: Need to pass node into this routine
	/**
	 * Returns true if the given application "state" is the NORMAL state.
	 * If "state" is not provided, then this routine responds whether the current
	 * state is the Normal state.
	 * If "state" is provided but is either null or undefined, then return true (i.e., NORMAL state).
	 * @param {null|undefined|String} state
	 * @returns {Boolean}
	 */
	isNormalState: function(state) {
		if (arguments.length == 0) {
			state = this.getState();
		}
		return !state || state == this.NORMAL;
	},

	/**
	 * Merges styleArray2's values into styleArray1. styleArray2 thus overrides styleArray1
	 * @param {Array} styleArray1  List of CSS styles to apply to this node for the given "state".
	 * 		This is an array of objects, where each object specifies a single propname:propvalue.
	 * 		eg. [{'display':'none'},{'color':'red'}]
	 * @param {Array} styleArray2
	 */
	_styleArrayMixin: function(styleArray1, styleArray2){
		// Remove all entries in styleArray1 that matching entry in styleArray2
		if(styleArray2){
			for(var j=0; j<styleArray2.length; j++){
				var item2 = styleArray2[j];
				for(var prop2 in item2){
					for(var i=styleArray1.length-1; i>=0; i--){
						var item1 = styleArray1[i];
						if(item1.hasOwnProperty(prop2)){
							styleArray1.splice(i, 1);
						}
					}
				}
			}
			// Add all entries from styleArray2 onto styleArray1
			for(var k=0; k<styleArray2.length; k++){
				styleArray1.push(styleArray2[k]);
			}
		}
	},
	
	/**
	 * Returns style values for the given node when a particular set of application states are active.
	 * The list of application states is passed in as an array.
	 * @param {Element} node
	 * @param {[string]} statesList  
	 *    Array of appstate names. If all appstates are defined on BODY, then
	 *    the array will only have one item. If there are nested app state containers,
	 *    then the list will have multiple items, with the applicable state on furthest
	 *    ancestor at position 0 and nearest at position length-1.
	 * @param {string} name  Optional property name. If present, then returned value only contains that one property.
	 *    If not provided, then return all properties.
	 * @returns {Array} An array of objects, where each object has a single propname:propvalue.
	 *		For example, [{'display':'none'},{'color':'red'}]
	 */
	getStyle: function(node, statesList /*FIXME state */, name) {
		var styleArray, newStyleArray = [];
//FIXME: Make sure node and statesList are always sent to getStyle
		for(var i=0; i<statesList.length; i++){
			var state = statesList[i];
			// return all styles specific to this state
			styleArray = node && node._maqDeltas && node._maqDeltas[state] && node._maqDeltas[state].style;
			// states defines on deeper containers override states on ancestor containers
			this._styleArrayMixin(newStyleArray, styleArray);
			if (arguments.length > 2) {
				// Remove any properties that don't match 'name'
				if(newStyleArray){
					for(var j=newStyleArray.length-1; j>=0; j--){
						var item = newStyleArray[j];
						for(var prop in item){		// should be only one prop per item
							if(prop != name){
								newStyleArray.splice(j, 1);
								break;
							}
						}
					}
				}
			}
		}
		return newStyleArray;
	},
	
	/**
	 * Returns true if the CSS property "name" is defined on the given node for the given "state".
	 * style values for the given node and the given application "state".
	 * @param {Element} node
	 * @param {string} state
	 * @param {string} name
	 * @returns {boolean} 
	 */
	hasStyle: function(node, state, name) {
		if (!node || !name) { return; }
		
		if(node._maqDeltas && node._maqDeltas[state] && node._maqDeltas[state].style){
			var valueArray = node._maqDeltas[state].style;
			for(var i=0; i<valueArray[i]; i++){
				if(valueArray[i].hasProperty(name)){
					return true;
				}
			}
		}else{
			return false;
		}
	},	
	
	/**
	 * Update the CSS for the given node for the given application "state".
	 * This routine doesn't actually do any screen updates; instead, updates happen
	 * by publishing a /maqetta/appstates/state/changed event, which indirectly causes
	 * the _update() routine to be called for the given node.
	 * @param {Element} node
	 * @param {string} state
	 * @param {Array} styleArray  List of CSS styles to apply to this node for the given "state".
	 * 		This is an array of objects, where each object specifies a single propname:propvalue.
	 * 		eg. [{'display':'none'},{'color':'red'}]
	 * @param {boolean} _silent  If true, don't broadcast the state change via /maqetta/appstates/state/changed
	 */
	setStyle: function(node, state, styleArray, silent) {
		if (!node || !styleArray) { return; }
		
		node._maqDeltas = node._maqDeltas || {};
		node._maqDeltas[state] = node._maqDeltas[state] || {};
		node._maqDeltas[state].style = node._maqDeltas[state].style || [];
		
		// Remove existing entries that match any of entries in styleArray
		var oldArray = node._maqDeltas[state].style;
		if(styleArray){
			for (var i=0; i<styleArray.length; i++){
				var newItem = styleArray[i];
				for (var newProp in newItem){	// There should be only one prop per item
					for (var j=oldArray.length-1; j>=0; j--){
						var oldItem = oldArray[j];
						for (var oldProp in oldItem){	// There should be only one prop per item
							if(newProp == oldProp){
								oldArray.splice(j, 1);
								break;
							}
						}
					}
				}
			}
		}
		//Make sure all new values are properly formatted (e.g, add 'px' to end of certain properties)
		var newArray;
		if(styleArray){
			for(var j=0; j<styleArray.length; j++){
				for(var p in styleArray[j]){	// should be only one prop per item
					var value =  styleArray[j][p];
					if (typeof value != "undefined" && value !== null) {
						if(typeof newArray == 'undefined'){
							newArray = [];
						}
						var o = {};
						o[p] = this._getFormattedValue(p, value);
						newArray.push(o);
					}
				}
			}
		}
		if(oldArray && newArray){
			node._maqDeltas[state].style = oldArray.concat(newArray);
		}else if(oldArray){
			node._maqDeltas[state].style = oldArray;
		}else if(newArray){
			node._maqDeltas[state].style = newArray;
		}else{
			node._maqDeltas[state].style = undefined;
		}
			
		if (!silent) {
			connect.publish("/davinci/states/state/style/changed", [{node:node, state:state, style:styleArray}]);
		}
		this._updateSrcState (node);
	},
	
	/**
	 * convert "property-name" to "propertyName"
	 */
	_convertStyleName: function(name) {
		if(name.indexOf("-") >= 0){
			// convert "property-name" to "propertyName"
			var names = name.split("-");
			name = names[0];
			for(var i = 1; i < names.length; i++){
				var n = names[i];
				name += (n.charAt(0).toUpperCase() + n.substring(1));
			}
		}
		return name;
	},
	
	_DYNAMIC_PROPERTIES: { width:1, height:1, top:1, right:1, bottom:1, left:1 },
	
	/**
	 * Make sure length values have a 'px' at end
	 * FIXME: What about other properties that take lengths? Seems arbitrary to help out
	 * with only a few properties.
	 */
	_getFormattedValue: function(name, value) {
		//FIXME: This code needs to be analyzed more carefully
		// Right now, only checking six properties which might be set via dynamic
		// drag actions on canvas. If just a raw number value, then add "px" to end.
		if(name in this._DYNAMIC_PROPERTIES){
			if(typeof value != 'string'){
				return value+"px";
			}
			var trimmed_value = require("dojo/_base/lang").trim(value);
			// See if value is a number
			if(/^[-+]?[0-9]*\.?[0-9]+$/.test(trimmed_value)){
				value = trimmed_value+"px";
			}
		}
		return value;			
	},
	
	/**
	 * Takes the current statesArray array and returns a simple array
	 * of the same number of items where each item indicates the state name
	 * corresponding to the given propName (which in practice can only be
	 * 'oldState' or 'newState').
	 * @param {[object]} statesArray  
	 *    Array of "state containers" that apply to this node,
	 *    with furthest ancestor at position 0 and nearest at position length-1.
	 *    Each item in array is an object with these properties
	 *      statesArray[i].node - a state container node
	 *      statesArray[i].oldState - the previous appstate that had been active on this state container node
	 *      statesArray[i].newState - the new appstate for this state container node
	 * @param {string} propName  property name to use as index into items in array
	 *                           (in practice, can only be 'oldState' or 'newState')
	 */
	_getStatesListUsingPropName: function(statesArray, propName){
		var statesList = [];
		if(statesArray){
			for(var i=0; i<statesArray.length; i++){
				statesList.push(statesArray[i][propName]);
			}
		}
		return statesList;
	},
	
	/**
	 * Utility routine to clean up styling on a given "node"
	 * to reset CSS properties for "Normal" state.
	 * First, remove any properties that were defined for "oldState".
	 * Then, add properties defined for Normal state.
	 * @param {Element} node
	 * @param {[object]} statesArray  
	 *    Array of "state containers" that apply to this node,
	 *    with furthest ancestor at position 0 and nearest at position length-1.
	 *    Each item in array is an object with these properties
	 *      statesArray[i].node - a state container node
	 *      statesArray[i].oldState - the previous appstate that had been active on this state container node
	 *      statesArray[i].newState - the new appstate for this state container node
	 */
	_resetAndCacheNormalStyle: function(node, statesArray) {

		if(!node || !statesArray){
			return;
		}
		for(var i=0; i < statesArray.length; i++){
			var oldState = statesArray[i].oldState;
			
			var oldStatesList = this._getStatesListUsingPropName(statesArray, 'oldState');
			var oldStateStyleArray = this.getStyle(node, oldStatesList);
			var normalStatesList = this._getStatesListUsingPropName(statesArray);
			var normalStyleArray = this.getStyle(node, normalStatesList);
			
			// Clear out any styles corresponding to the oldState
			if(oldStateStyleArray){
				for(var j=0; j<oldStateStyleArray.length; j++){
					var oItem = oldStateStyleArray[j];
					for(var oProp in oItem){	// Should only be one prop
						var convertedName = this._convertStyleName(oProp);
						node.style[convertedName] = '';
					}
				}
			}
			
			// Reset normal styles
			if(normalStyleArray){
				for(var k=0; k<normalStyleArray.length; k++){
					var nItem = normalStyleArray[k];
					for(var nProp in nItem){	// Should only be one prop
						var convertedName = this._convertStyleName(nProp);
						var style = node.style;
						var value = this._getFormattedValue(nProp, nItem[nProp])+'';
						var matches = value ? value.match(this.reImportant) : null;
						if(matches){	// if value includes !important
							var t = matches[1]+matches[3];
							t = lang.trim(t); // IE9 does not like spaces at the end of the value
							if(style.setProperty){
								style.setProperty(nProp, t, 'important');
							}else{
								node.style[convertedName] = t; 
							}
						}else{
							node.style[convertedName] = value;
						}
					}
				}
			}
		}
	},
	
	/**
	 * Updates CSS properties for the given node due to a transition
	 * from application state (from an old state to a new state).
	 * Called indirectly when the current state changes (via a setState call)
	 * from code that listens to event /maqetta/appstates/state/changed
	 * @param {Element} node
	 * @param {[object]} statesArray  
	 *    Array of "state containers" that apply to this node,
	 *    with furthest ancestor at position 0 and nearest at position length-1.
	 *    Each item in array is an object with these properties
	 *      statesArray[i].node - a state container node
	 *      statesArray[i].oldState - the previous appstate that had been active on this state container node
	 *      statesArray[i].newState - the new appstate for this state container node
	 */
	_update: function(node, statesArray) {
		if (!node || !node._maqDeltas){
			return;
		}

		var newStatesList = this._getStatesListUsingPropName(statesArray, 'newState');
		var styleArray = this.getStyle(node, newStatesList);
		
		this._resetAndCacheNormalStyle(node, statesArray);

		// Apply new style
		if(styleArray){
			for(var i=0; i<styleArray.length; i++){
				var style = styleArray[i];
				for (var name in style) {	// should be only one prop in style
					var convertedName = this._convertStyleName(name);
					var value = style[name]+'';
					var matches = value ? value.match(this.reImportant) : null;
					if(matches){	// if value includes !important
						var t = matches[1]+matches[3];
						t = lang.trim(t); // IE9 does not like spaces at the end of the value
						if(style.setProperty){
							style.setProperty(name, t, 'important');
						}else{
							node.style[convertedName] = t; 
						}
					}else{
						node.style[convertedName] = value;
					}
				}
			}
		}
		
		//FIXME: This is Dojo-specific. Other libraries are likely to need a similar hook.
		var dijitWidget, parent;
		if(node.id && node.ownerDocument){
			// TODO: referencing the global 'require' is not valid.  What's the right way to access this module?
			var byId = node.ownerDocument.defaultView./*require("dijit/registry")*/dijit.byId;
			if(byId){
				dijitWidget = byId && byId(node.id);				
			}
		}
		if(dijitWidget && dijitWidget.getParent){
			parent = dijitWidget.getParent();
		}
		if(parent && parent.resize){
			parent.resize();
		}else if(dijitWidget && dijitWidget.resize){
			dijitWidget.resize();
		}
	},
	
	/**
	 * Returns true if the given node is an application state "container".
	 * Right now, only BODY can be such a container.
	 * @param {Element} node
	 * @returns {Boolean}
	 */
	isContainer: function(node) {
//FIXME: Need to generalize this for nested states
		var result = false;
		if (node) {
			var doc = this.getDocument();
			if (node === (doc && doc.body) || node.tagName == "BODY") {
				result = true;
			}
		}
		return result;
	},
	
	/**
	 * Returns BODY node for current document.
	 * @returns {Element}
	 */
	getContainer: function() {
		return document.body;
	},
	
	/**
	 * Adds a state to the list of states declared by the node.
	 * Right now, node must by the BODY element.
	 * Subscribe using davinci.states.subscribe("/davinci/states/state/added", callback).
	 * @param node {Element} State container node
	 * @param state {string} Name of state to add
	 * @param params [{object}] Optional parameters:
	 *    params.index - Splice the new state into the list of states at this position
	 */
	add: function(node, state, params){ 
		if (!node || this.hasState(node, state)) {
			//FIXME: This should probably be an error of some sort
			return;
		}
		var stateIndex = params && params.index;
		node._maqAppStates = node._maqAppStates || {};
		node._maqAppStates.states = node._maqAppStates.states || [];
		if(typeof stateIndex == 'number' && stateIndex >= 0){
			node._maqAppStates.states.splice(stateIndex, 0, state);
		}else{
			node._maqAppStates.states.push(state);
		}
		connect.publish("/davinci/states/state/added", [{node:node, state:state}]);
		this._updateSrcState (node);
	},
	
	/** 
	 * Removes a state to the list of states declared by the node.
	 * Right now, node must by the BODY element.
	 * Subscribe using davinci.states.subscribe("/davinci/states/state/removed", callback).
	 */
	remove: function(node, state){
		if (!node || !node._maqAppStates || !node._maqAppStates.states || !this.hasState(node, state)) {
			return;
		}
		var idx = node._maqAppStates.states.indexOf(state);
		if(idx < 0){
			return;
		}
		var currentState = this.getState(node);
		var body = node.ownerDocument.body;
		var statesFocus = this.getFocus(body);
		node._maqAppStates.states.splice(idx, 1);
		var params = {};
		if(statesFocus && statesFocus.stateContainerNode == node && statesFocus.state == state){
			params.focus = true;
			params.updateWhenCurrent = true;
		}
		if (state == currentState) {
			this.setState(undefined, node, params);
		}
		connect.publish("/davinci/states/state/removed", [{node:node, state:state}]);
		this._updateSrcState (node);
	},
	
	/**
	 * Renames a state in the list of states declared by the widget.
	 * Subscribe using connect.subscribe("/davinci/states/renamed", callback).
	 * @param {Element} stateContainerNode  A DOM element that is a state container node (i.e., has _maqAppStates property)
	 * @param {object} params  Various params:
	 *    params.oldName {string} old state name (i.e., state name to change)
	 *    params.newName {string} new state name
	 * @returns {boolean}  Return true with success, false if failure
	 */
	rename: function(stateContainerNode, params){
		if(!params){
			return false;
		}
		var oldName = params.oldName;
		var newName = params.newName;
		if (!stateContainerNode || !stateContainerNode._maqAppStates || 
				!stateContainerNode._maqAppStates.states || !stateContainerNode._maqAppStates.states.length){
			return false;
		}
		var states = stateContainerNode._maqAppStates.states;
		if(states.indexOf(oldName) < 0 || states.indexOf(newName) >= 0){
			return false;
		}
		states.splice(states.indexOf(oldName), 1, newName);
		if(stateContainerNode._maqAppStates.focus === oldName){
			stateContainerNode._maqAppStates.focus = newName;
		}
		if(stateContainerNode._maqAppStates.current === oldName){
			stateContainerNode._maqAppStates.current = newName;
		}
		
		var nodes = [stateContainerNode];
		var currentState = this.getState(stateContainerNode);
		nodes = nodes.concat(this._getChildrenOfNode(stateContainerNode));
		while (nodes.length) {
			var node = nodes.shift();
			if(node._maqDeltas && node._maqDeltas[oldName]){
				node._maqDeltas[newName] = node._maqDeltas[oldName];
				delete node._maqDeltas[oldName];
			}
			nodes = nodes.concat(this._getChildrenOfNode(node));
			var statesArray = this.getStatesArray(node, null, newName, stateContainerNode);
			this._update(node, statesArray);
			this._updateSrcState (node);
		}
		connect.publish("/davinci/states/state/renamed", [{node:node, oldName:oldName, newName:newName, stateContainerNode:node }]);
		return true;
	},
	
	/**
	 * Returns true if object does not directly have property 'name'
	 * (versus inherited it from a prototype).
	 */
	_isEmpty: function(object) {
		for (var name in object) {
			if (object.hasOwnProperty(name)) {
				return false;
			}
		}
		return true;
	},
	
	/**
	 * Call JSON stringify on an object, make sure
	 * all single quotes are escaped and replace double-quotes with single quotes
	 */
	stringifyWithQuotes: function(o){
		str = JSON.stringify(o);
		// Escape single quotes that aren't already escaped
		str = str.replace(/(\\)?'/g, function($0, $1){ 
			return $1 ? $0 : "\\'";
		});
		// Replace double quotes with single quotes
		str = str.replace(/"/g, "'");
		return str;
	},
	
	/**
	 * Convert the _maqAppStates and _maqDeltas properties on the given node into JSON-encoded strings.
	 * @param {Element} node
	 * @returns {object}  Object of form {maqAppStates:<string>,maqDeltas:<string>} 
	 *                    where both maqAppStates and maqDeltas are included in object 
	 *                    only if respective property is on the node
	 */
	serialize: function(node) {
		var that = this;
		var munge = function(propval){
			var str = null;
			if(node[propval]){
				var o = require("dojo/_base/lang").clone(node[propval]);
				delete o["undefined"];
				if (!that._isEmpty(o)) {
					str = this.stringifyWithQuotes(o);
				}
			}
			return str;
		}.bind(this);
		var obj = {};
		if (!node){
			return obj;
		}
		var maqAppStates = munge('_maqAppStates');
		if(typeof maqAppStates == 'string'){
			obj.maqAppStates = maqAppStates;
		}
		var maqDeltas = munge('_maqDeltas');
		if(typeof maqDeltas == 'string'){
			obj.maqDeltas = maqDeltas;
		}
		return obj;
	},

	/**
	 * Convert a string representation of widget-specific states information into a JavaScript object
	 * using JSON.parse.
	 * The string representation is typically the value of this.DELTAS_ATTRIBUTE (dvStates)
	 * @param states  string representation of widget-specific states information
	 * @param {object} options  
	 *    options.isBody {boolean}  whether we are deserializing BODY element
	 * @return {object}  JavaScript result from JSON.parse
	 */
	deserialize: function(states, options) {
		if (typeof states == "string") {
			// Replace unescaped single quotes with double quotes, unescape escaped single quotes
			states = states.replace(/(\\)?'/g, function($0, $1){ 
					return $1 ? "'" : '"';
			});
			states = JSON.parse(states);
			this._migrate_m4_m5(states);	// Upgrade old files
			states = this._migrate_m6_m7(states, options && options.isBody);
		}
		return states;
	},
	
	/**
	 * The format of the states attribute (this.DELTAS_ATTRIBUTE = 'dvStates') changed
	 * from Preview4 to Preview5. This routine upgrades the states object in place
	 * from Preview4 or earlier data structure into data structure used by Preview 5.
	 * @param {object} states  "states" object that might be in Preview4 format
	 */
	_migrate_m4_m5: function(states){
		// We changed the states structure for Preview5 release. It used to be
		// a JSON representation of an associative array: {'display':'none', 'color':'red'}
		// But with Preview5 it is now an array of single property declarations such as:
		// [{'display':'none'}, {'color':'red';}]. The array approach was necessary to
		// deal with complexities of background-image, where there might be multiple values
		// for a single property.
		for (var s in states){
			var state = states[s];
			if(state){
				var style = state.style;
				if(style && !style.length){	// if style exists but isn't an array
					var statesArray = [];
					for(var prop in style){
						var o = {};
						o[prop] = style[prop];
						statesArray.push(o);
					}
					state.style = statesArray;
				}
			}
		}
	},
	
	/**
	 * The format of the states attribute (this.DELTAS_ATTRIBUTE = 'dvStates') on the BODY changed
	 * from M6 to M7. This routine returns an M7-compatible states structure created
	 * from an M6-compatible states structure.
	 * @param {object} m6bodystates  "states" object that might be in M6 format
	 * @param {boolean} isBody  whether the "states" is for a BODY element
	 * @returns {object} m7bodystates  "states" object in M7 format
	 */
	_migrate_m6_m7: function(states, isBody){
		// We changed the states structure on BODY for M7 release. It used to be
		// a JSON representation of a simple associative array: 
		//    dvStates="{'Add Task':{'origin':true},'Task Added':{'origin':true}}"
		// But with M7 it is a different associative array, with properties 'states' and 'current':
		// where 'states' is an array of strings that lists all user-defined states on the BODY
		//    dvStates="{'states':['Add Task':'Task Added'],'current':'Add Task'}"
		// and where 'current' is a string that (if specified) indicates which state should be
		// active at page startup.
		
		// if either no param, or if states object has a states property, return original object
		if(!states || states.states){
			return states;
		}
		// otherwise, migrate from M6 to M7
		if(isBody){
			var statesArray = [];
			for(var s in states){
				if(s != 'current'){
					statesArray.push(s);
				}
			}
			if(statesArray.length > 0){
				return { states:statesArray };
			}else{
				return undefined;
			}
		}else{
			delete states.current;
			return states;
		}
	},
	
	/**
	 * Stuffs a JavaScript property (the states object) onto the given node.
	 * @param {Element} node  
	 * @param maqAppStates   the string value of the list of states attribute
	 * @param maqDeltas   the string value of the property deltas for various states
	 */
	store: function(node, maqAppStates, maqDeltas) {
		if (!node){
			return;
		}
		this.clear(node);
//FIXME: Generalize for nested state containers?
		var isBody = (node.tagName == 'BODY');
		if(maqAppStates){
			node._maqAppStates = this.deserialize(maqAppStates, {isBody:isBody});
		}
		if(maqDeltas){
			node._maqDeltas = this.deserialize(maqDeltas, {isBody:isBody});
		}
		connect.publish("/davinci/states/stored", []);
	},
	
	/**
	 * Returns the string value of the attribute that holds node-specific states information (dvStates)
	 * @param {Element} node  
	 * @returns {object}  Object with two props, defs:{string|null} and deltas:{string|null},
	 *                    which hold DELTAS and DEFS attribute values, respectively
	 */
	retrieve: function(node) {
		if (!node){
			return;
		}
		var maqAppStates_attribute = node.getAttribute(this.APPSTATES_ATTRIBUTE);
		if(!maqAppStates_attribute && node.tagName === 'BODY'){
			// Previous versions used different attribute name (ie, 'dvStates')
			maqAppStates_attribute = node.getAttribute(this.APPSTATES_ATTRIBUTE_P6);
		}
		var maqDeltas_attribute = node.getAttribute(this.DELTAS_ATTRIBUTE);
		if(!maqDeltas_attribute && node.tagName !== 'BODY'){
			// Previous versions used different attribute name (ie, 'dvStates')
			maqDeltas_attribute = node.getAttribute(this.DELTAS_ATTRIBUTE_P6);
		}
		return {maqAppStates:maqAppStates_attribute, maqDeltas:maqDeltas_attribute};
	},

	/**
	 * Removes the states property on the given node
	 * @param {Element} node  
	 */
	clear: function(node) {
		if (!node) return;
		if (node._maqAppStates) { // IE8
			delete node._maqAppStates;
		}
		if (node._maqDeltas) { // IE8
			delete node._maqDeltas;
		}
	},
	
	/**
	 * Parse an element.style string, return a valueArray, which is an array
	 * of objects, where each object holds a single CSS property value
	 * (e.g., [{'display':'none'},{'color':'red'}]
	 * @param text
	 * @returns {Array}  valueArray: [{propname:propvalue}...]
	 */
	_parseStyleValues: function(text) {
		var values = [];
		if(text){
			darray.forEach(text.split(";"), function(s){
				var i = s.indexOf(":");
				if(i > 0){
					var n = s.substring(0, i).trim();
					var v = s.substring(i + 1).trim();
					var o = {};
					o[n] = v;
					values.push(o);
				}
			});
		}
		return values;
	},

	/**
	 * Store original element.style values into node._maqAppStates['undefined'].style
	 * Called by _preserveStates
	 * @param node  
	 * @param {String} elemStyle  element.style string
	 */
	transferElementStyle: function(node, elemStyle) {
		if(node){
			var states = node._maqDeltas;
			var valueArray = this._parseStyleValues(elemStyle);
			if(!states['undefined']){
				states['undefined'] = {};
			}
			states['undefined'].style = valueArray;
		}
	},
	
	/**
	 * Returns current document object.
	 * Make into a function because in Maqetta page editor a subclass overrides this routine.
	 */
	getDocument: function() {
		return document;
	},
	
	/**
	 * Returns true if AppStates.js should run its initialization logic.
	 * If an editor that embeds this routine (e.g., the Maqetta page editor)
	 * provides its own alternate initialization logic, then the editor
	 * needs to set davinci.AppStatesDontInitialize to true before
	 * AppStates.js is loaded and initialized.
	 */
	shouldInitialize: function() {
		return !davinci.AppStatesDontInitialize;
	},

	/**
	 * Returns all child elements for given Element
	 * Note: can't just use node.children because node.children isn't available for SVG nodes.
	 * @param {Element} node
	 * @returns {Array} array of child nodes
	 */
	_getChildrenOfNode: function(node) {
		var children = [];
		for (var i=0; i<node.childNodes.length; i++){
			var n = node.childNodes[i];
			if(n.nodeType === 1){	// Element
				children.push(n);
			}
		}
		return children;
	},
	
	initialize: function() {	
		if (!this.subscribed) {
			connect.subscribe("/maqetta/appstates/state/changed", this, function(e) { 
				if(e.editorClass){
					// Event targets one of Maqetta's editors, not from runtime events
					return;
				}
				var children = davinci.states._getChildrenOfNode(e.node);
				while (children.length) {
					var child = children.shift();
					if (!davinci.states.isContainer(child)) {
						children = children.concat(davinci.states._getChildrenOfNode(child));
					}
					var statesArray = this.getStatesArray(child, e.oldState, e.newState, e.stateContainerNode);
					davinci.states._update(child, statesArray);
				}
			});
			
			this.subscribed = true;
		}
	}
};

//FIXME: remove all references to davinci global and davinci.states
if (typeof davinci === "undefined") { davinci = {}; }
var singleton = davinci.states = new States();

(function(){

	singleton.initialize();
	
	if (singleton.shouldInitialize()) {
	
		// Patch the dojo parse method to preserve states data
		if (typeof require != "undefined") {
			require(["dojo/_base/lang", "dojo/query", "dojo/aspect"], function(lang, query, aspect) {
				var count = 0,
					alreadyHooked = false;

				// hook main dojo/parser (or dojox.mobile.parser, which also defines a parse method)
				var hook = function(parser) {
					if(!alreadyHooked){
						// Note that Dojo parser can be called multiple times at document load time
						// where it parses different components of the document -- not all of the
						// document is parsed with that first call to the parser. As a result,
						// we might end up calling _restoreStates() multiple time for the same 
						// particular document fragments, and reassigning the "states" property
						// multiple times, but otherwise Dojo might wipe out the previously installed
						// "states" property.
						aspect.around(parser, "parse", function(parse) {
							var cache = {};
							return function(rootNode, args) {
								// logic below to compute "root" was copied from dojo's parser.js
								var root;
								if(!args && rootNode && rootNode.rootNode){
									args = rootNode;
									root = args.rootNode;
								}else{
									root = rootNode;
								}
								root = root ? dhtml.byId(root) : dwindow.body();
								_preserveStates(cache);
								var results = parse.apply(this, arguments);
								_restoreStates(cache, root);
								return results;
							};
						});
						dojo.parser.parse = parser.parse; // for backwards compatibility
						alreadyHooked = true;
					}
				};

				try {
					var parser = require("dojox/mobile/parser");
					hook.apply(parser);
				} catch(e) {
					// only include the regular parser if the mobile parser isn't available
				}

				if(!parser) {
					hook.call(null, dparser);
				}

				/**
				 * Preserve states specified on widgets.
				 * Invoked from code above that wraps the dojo parser such that
				 * dojo parsing is sandwiched between calls to _preserveStates and _restoreStates.
				 */
				var _preserveStates = function (cache) {
					var prefix = 'maqTempClass';
					var doc = singleton.getDocument();
	
					// Preserve the body states directly on the dom node
					if(!doc.body._maqAlreadyPreserved){
						var statesAttributes = davinci.states.retrieve(doc.body);
						if (statesAttributes && statesAttributes.maqAppStates) {
							cache.body = statesAttributes.maqAppStates;
						}
						doc.body._maqAlreadyPreserved = true;
					}
	
					// Preserve states of children of body in the cache
					//FIXME: why can't we just query for nodes that have this.DELTAS_ATTRIBUTE?
					query("*", doc).forEach(function(node){
						// Because Dojo parser gets called recursively (multiple times), 
						// but preserveStates/restoreStates go through entire document,
						// The second part of the check, className.indexOf(), is there because 
						// an earlier pass of the parser might have replaced the node, 
						// and therefore the _maqAlreadyPreserved flag would be lost.
						var className = node.getAttribute('class') 
						if(!className){
							className = '';
						}
						if(!node._maqAlreadyPreserved && className.indexOf(prefix)<0){
							node._maqAlreadyPreserved = true;
							var statesAttributes = singleton.retrieve(node);
							if (node.tagName != "BODY" && statesAttributes && (statesAttributes.maqAppStates || statesAttributes.maqDeltas)) {
								var tempClass = prefix+count;
								className = className + ' ' + tempClass;
								node.setAttribute('class', className);
								count++;
								cache[tempClass] = {};
								if(statesAttributes.maqAppStates){
									cache[tempClass].maqAppStates = statesAttributes.maqAppStates;
								}
								if(statesAttributes.maqDeltas){
									cache[tempClass].maqDeltas = statesAttributes.maqDeltas;
								}
								if(node.style){
									cache[tempClass].style = node.style.cssText;
								}else{
									// Shouldn't be here
									console.error('States.js _preserveStates. No value for node.style.')
								}
							}
						}
					});
				};
				
				/**
				 * Restore widget states from cache
				 * Invoked from code below that wraps the dojo parser such that
				 * dojo parsing is sandwiched between calls to _preserveStates and _restoreStates.
				 */
				var _restoreStates = function (cache, rootNode) {
					var doc = singleton.getDocument(),
						currentStateCache = [],
						maqAppStatesString, maqDeltasString, maqAppStates, maqDeltas;
					for(var id in cache){
						var node;
						if(id == 'body'){
							node = doc.body;
						}else{
							node = doc.querySelectorAll('.'+id)[0];
						}
						if(node){
							var isBody = (node.tagName == 'BODY');
//FIXME: Temporary - doesn't yet take into account nested state containers
							maqAppStatesString = maqDeltasString = maqAppStates = maqDeltas = null;
							if(isBody){
								maqAppStatesString = cache[id];
							}else{
								maqAppStatesString = cache[id].maqAppStates;
								maqDeltasString = cache[id].maqDeltas;
							}
							if(maqAppStatesString){
								maqAppStates = singleton.deserialize(maqAppStatesString, {isBody:isBody});
							}
							if(maqDeltasString){
								maqDeltas = singleton.deserialize(maqDeltasString, {isBody:isBody});
							}
							if(maqAppStates){
								if(maqAppStates.initial){
									// If user defined an initial state, then set current to that state
									maqAppStates.current = maqAppStates.initial;
								}else{
									if(maqAppStates.focus){
										// Can't have focus on a state that isn't current
										delete maqAppStates.focus; 
									}
									// Otherwise, delete any current state so that we will be in Normal state by default
									delete maqAppStates.current;
								}
							}
							singleton.store(node, maqAppStates, maqDeltas);
							if(maqDeltasString){
								//FIXME: maybe not be general enough
								davinci.states.transferElementStyle(node, cache[id].style);
							}
						}
					}
					
					// Call setState() on all of the state containers that have non-default
					// values for their current state (which was set to initial state earlier
					// in this routine).
					var allStateContainers = singleton.getAllStateContainers(doc.body);
					var statesInfo = [];
					for(var i=0; i<allStateContainers.length; i++){
						var stateContainer = allStateContainers[i];
						if(stateContainer._maqAppStates && typeof stateContainer._maqAppStates.current == 'string'){
							var focus = stateContainer._maqAppStates.focus;
							singleton.setState(stateContainer._maqAppStates.current, stateContainer, {updateWhenCurrent:true, focus:focus});
						}
					}
				};
			});
		}
	}
})();

// Bind to watch for overlay widgets at runtime.  Dijit-specific, at this time
if (!davinci.Workbench && typeof dijit != "undefined"){
	connect.subscribe("/maqetta/appstates/state/changed", function(args) {
		var w;
		var byId = (args && args.node && args.node.ownerDocument && args.node.ownerDocument.defaultView &&
					args.node.ownerDocument.defaultView./*require("dijit/registry")*/dijit.byId);
		if(byId){
			if (args.newState && !args.newState.indexOf("_show:")) {
				w = byId(args.newState.substring(6));
				w && w.show && w.show();
			} else if (args.oldState && !args.oldState.indexOf("_show:")) {
				w = byId(args.oldState.substring(6));
				w && w.hide && w.hide();
			}
		}
	});
}

return States;
});


},
'url:dijit/templates/Menu.html':"<table class=\"dijit dijitMenu dijitMenuPassive dijitReset dijitMenuTable\" role=\"menu\" tabIndex=\"${tabIndex}\"\n\t   data-dojo-attach-event=\"onkeypress:_onKeyPress\" cellspacing=\"0\">\n\t<tbody class=\"dijitReset\" data-dojo-attach-point=\"containerNode\"></tbody>\n</table>\n",
'dojo/dnd/Avatar':function(){
define([
	"../_base/declare",
	"../_base/window",
	"../dom",
	"../dom-attr",
	"../dom-class",
	"../dom-construct",
	"../hccss",
	"../query"
], function(declare, win, dom, domAttr, domClass, domConstruct, has, query){

// module:
//		dojo/dnd/Avatar

return declare("dojo.dnd.Avatar", null, {
	// summary:
	//		Object that represents transferred DnD items visually
	// manager: Object
	//		a DnD manager object

	constructor: function(manager){
		this.manager = manager;
		this.construct();
	},

	// methods
	construct: function(){
		// summary:
		//		constructor function;
		//		it is separate so it can be (dynamically) overwritten in case of need

		var a = domConstruct.create("table", {
				"class": "dojoDndAvatar",
				style: {
					position: "absolute",
					zIndex:   "1999",
					margin:   "0px"
				}
			}),
			source = this.manager.source, node,
			b = domConstruct.create("tbody", null, a),
			tr = domConstruct.create("tr", null, b),
			td = domConstruct.create("td", null, tr),
			k = Math.min(5, this.manager.nodes.length), i = 0;

		if(has("highcontrast")){
			domConstruct.create("span", {
				id : "a11yIcon",
				innerHTML : this.manager.copy ? '+' : "<"
			}, td)
		}
		domConstruct.create("span", {
			innerHTML: source.generateText ? this._generateText() : ""
		}, td);

		// we have to set the opacity on IE only after the node is live
		domAttr.set(tr, {
			"class": "dojoDndAvatarHeader",
			style: {opacity: 0.9}
		});
		for(; i < k; ++i){
			if(source.creator){
				// create an avatar representation of the node
				node = source._normalizedCreator(source.getItem(this.manager.nodes[i].id).data, "avatar").node;
			}else{
				// or just clone the node and hope it works
				node = this.manager.nodes[i].cloneNode(true);
				if(node.tagName.toLowerCase() == "tr"){
					// insert extra table nodes
					var table = domConstruct.create("table"),
						tbody = domConstruct.create("tbody", null, table);
					tbody.appendChild(node);
					node = table;
				}
			}
			node.id = "";
			tr = domConstruct.create("tr", null, b);
			td = domConstruct.create("td", null, tr);
			td.appendChild(node);
			domAttr.set(tr, {
				"class": "dojoDndAvatarItem",
				style: {opacity: (9 - i) / 10}
			});
		}
		this.node = a;
	},
	destroy: function(){
		// summary:
		//		destructor for the avatar; called to remove all references so it can be garbage-collected
		domConstruct.destroy(this.node);
		this.node = false;
	},
	update: function(){
		// summary:
		//		updates the avatar to reflect the current DnD state
		domClass.toggle(this.node, "dojoDndAvatarCanDrop", this.manager.canDropFlag);
		if(has("highcontrast")){
			var icon = dom.byId("a11yIcon");
			var text = '+';   // assume canDrop && copy
			if (this.manager.canDropFlag && !this.manager.copy){
				text = '< '; // canDrop && move
			}else if (!this.manager.canDropFlag && !this.manager.copy){
				text = "o"; //!canDrop && move
			}else if(!this.manager.canDropFlag){
				text = 'x';  // !canDrop && copy
			}
			icon.innerHTML=text;
		}
		// replace text
		query(("tr.dojoDndAvatarHeader td span" +(has("highcontrast") ? " span" : "")), this.node).forEach(
			function(node){
				node.innerHTML = this.manager.source.generateText ? this._generateText() : "";
			}, this);
	},
	_generateText: function(){
		// summary:
		//		generates a proper text to reflect copying or moving of items
		return this.manager.nodes.length.toString();
	}
});

});

},
'url:dijit/layout/templates/TabContainer.html':"<div class=\"dijitTabContainer\">\n\t<div class=\"dijitTabListWrapper\" data-dojo-attach-point=\"tablistNode\"></div>\n\t<div data-dojo-attach-point=\"tablistSpacer\" class=\"dijitTabSpacer ${baseClass}-spacer\"></div>\n\t<div class=\"dijitTabPaneWrapper ${baseClass}-container\" data-dojo-attach-point=\"containerNode\"></div>\n</div>\n",
'dijit/form/Button':function(){
define([
	"require",
	"dojo/_base/declare", // declare
	"dojo/dom-class", // domClass.toggle
	"dojo/has",			// has("dijit-legacy-requires")
	"dojo/_base/kernel", // kernel.deprecated
	"dojo/_base/lang", // lang.trim
	"dojo/ready",
	"./_FormWidget",
	"./_ButtonMixin",
	"dojo/text!./templates/Button.html"
], function(require, declare, domClass, has, kernel, lang, ready, _FormWidget, _ButtonMixin, template){

// module:
//		dijit/form/Button

// Back compat w/1.6, remove for 2.0
if(has("dijit-legacy-requires")){
	ready(0, function(){
		var requires = ["dijit/form/DropDownButton", "dijit/form/ComboButton", "dijit/form/ToggleButton"];
		require(requires);	// use indirection so modules not rolled into a build
	});
}

return declare("dijit.form.Button", [_FormWidget, _ButtonMixin], {
	// summary:
	//		Basically the same thing as a normal HTML button, but with special styling.
	// description:
	//		Buttons can display a label, an icon, or both.
	//		A label should always be specified (through innerHTML) or the label
	//		attribute.  It can be hidden via showLabel=false.
	// example:
	// |	<button data-dojo-type="dijit/form/Button" onClick="...">Hello world</button>
	//
	// example:
	// |	var button1 = new Button({label: "hello world", onClick: foo});
	// |	dojo.body().appendChild(button1.domNode);

	// showLabel: Boolean
	//		Set this to true to hide the label text and display only the icon.
	//		(If showLabel=false then iconClass must be specified.)
	//		Especially useful for toolbars.
	//		If showLabel=true, the label will become the title (a.k.a. tooltip/hint) of the icon.
	//
	//		The exception case is for computers in high-contrast mode, where the label
	//		will still be displayed, since the icon doesn't appear.
	showLabel: true,

	// iconClass: String
	//		Class to apply to DOMNode in button to make it display an icon
	iconClass: "dijitNoIcon",
	_setIconClassAttr: { node: "iconNode", type: "class" },

	baseClass: "dijitButton",

	templateString: template,

	// Map widget attributes to DOMNode attributes.
	_setValueAttr: "valueNode",

	_onClick: function(/*Event*/ e){
		// summary:
		//		Internal function to handle click actions
		var ok = this.inherited(arguments);
		if(ok){
			if(this.valueNode){
				this.valueNode.click();
				e.preventDefault(); // cancel BUTTON click and continue with hidden INPUT click
                e.stopPropagation();    // avoid two events bubbling from Button widget
				// leave ok = true so that subclasses can do what they need to do
			}
		}
		return ok;
	},

	_fillContent: function(/*DomNode*/ source){
		// Overrides _Templated._fillContent().
		// If button label is specified as srcNodeRef.innerHTML rather than
		// this.params.label, handle it here.
		// TODO: remove the method in 2.0, parser will do it all for me
		if(source && (!this.params || !("label" in this.params))){
			var sourceLabel = lang.trim(source.innerHTML);
			if(sourceLabel){
				this.label = sourceLabel; // _applyAttributes will be called after buildRendering completes to update the DOM
			}
		}
	},

	_setShowLabelAttr: function(val){
		if(this.containerNode){
			domClass.toggle(this.containerNode, "dijitDisplayNone", !val);
		}
		this._set("showLabel", val);
	},

	setLabel: function(/*String*/ content){
		// summary:
		//		Deprecated.  Use set('label', ...) instead.
		kernel.deprecated("dijit.form.Button.setLabel() is deprecated.  Use set('label', ...) instead.", "", "2.0");
		this.set("label", content);
	},

	_setLabelAttr: function(/*String*/ content){
		// summary:
		//		Hook for set('label', ...) to work.
		// description:
		//		Set the label (text) of the button; takes an HTML string.
		//		If the label is hidden (showLabel=false) then and no title has
		//		been specified, then label is also set as title attribute of icon.
		this.inherited(arguments);
		if(!this.showLabel && !("title" in this.params)){
			this.titleNode.title = lang.trim(this.containerNode.innerText || this.containerNode.textContent || '');
		}
	}
});


});


},
'davinci/review/actions/OpenVersionAction':function(){
define([
	"dojo/_base/declare",
	"./_ReviewNavigatorCommon",
	"davinci/Runtime",
	"dojox/widget/Toaster",
	"dojo/i18n!./nls/actions"
], function(declare, _ReviewNavigatorCommon, Runtime, Toaster, nls) {

var OpenVersionAction = declare("davinci.review.actions.OpenVersionAction", [_ReviewNavigatorCommon], {

	run: function(context) {
		var selection = this._getSelection(context);
		if (!selection || !selection.length)  { 
			return;
		}
		var item = selection[0].resource.elementType=="ReviewFile"?selection[0].resource.parent:selection[0].resource;
		dojo.xhrGet({
			url: "cmd/managerVersion",
			sync:false,
			handleAs:"text",
			content:{
				'type' :'open',
				'vTime':item.timeStamp}
		}).then(function (result) {
			if (result=="OK") {
				if (typeof hasToaster == "undefined") {
					new Toaster({
						position: "br-left",
						duration: 4000,
						messageTopic: "/davinci/review/resourceChanged"
					});
					hasToaster = true;
				}
				dojo.publish("/davinci/review/resourceChanged", [{message:nls.openSuccessful, type:"message"},"open",item]);
			}
		});
	},

	isEnabled: function(context) {
		var selection = this._getSelection(context);
		if (!selection || selection.length == 0) { 
			return false;
		}
		var item = selection[0].resource.elementType=="ReviewFile"?selection[0].resource.parent:selection[0].resource;
		if (item.designerId == Runtime.userName) { 
			//Only enable if the current user is also the review's designer
			if (item.closed&&item.closedManual&&!item.isDraft) { 
				return true;
			}
		}
		return false;
	}
});

return OpenVersionAction;

});
},
'davinci/html/HTMLElement':function(){
/**
 * @class davinci.html.HTMLElement
 * @constructor
 * @extends davinci.html.HTMLItem
 */
define([
	"dojo/_base/declare",
	"davinci/html/HTMLItem",
	"davinci/html/HTMLText",
	"davinci/html/HTMLComment",
	"davinci/html/HTMLAttribute"
], function(declare, HTMLItem, HTMLText, HTMLComment, HTMLAttribute) {

return declare("davinci.html.HTMLElement", HTMLItem, {

	constructor: function(tag) {
		this.elementType = "HTMLElement";
		this.attributes = [];
		this.tag = tag || "";
		this._fmChildLine = 0;
		this._fmChildIndent = 0;
	},

	add: function(stmt) {
		if (!this.statements) { this.statements=[]; }
		this.statements.push(stmt);
		this.onChange();
	},

	getText: function(context) {
		context = context || {};
		var s = "";
		var doFormat;
		context.indent += 2;
		s = s + "<" + this.tag;
		for (var i=0; i<this.attributes.length; i++) {
			var attrtext = this.attributes[i].getText(context);
			// noPersist attributes return empty string
			if (attrtext.length>0) {
				s=s+" "+attrtext;
			}
		}
		if (this.noEndTag) {
			s = s + "/>";
		} else {
			s = s + '>';
			s = s + this._addWS(this._fmChildLine, this._fmChildIndent);
			if (this.statements) {
				for (var i=0; i<this.statements.length; i++) {
					s = s + this.statements[i].printStatement(context, this.statements[i]);
				}
			} else if (this.script) {
				s = s + this.script;
			} else {
				if (this.children.length>0) {
					var isStyle = this.tag == "style";

					for (var i=0; i<this.children.length; i++) {
						s = s + this.children[i].getText(context);
						if (isStyle) {
							var lines = this._fmChildLine,
							indent = this._fmChildIndent || 0;
							if (i+1 == this.children.length) {
								lines = this._fmLine;
								indent = this._fmIndent;

							}
							s = s + this._addWS(lines, indent);
						}
					}
				}
			}
			if (doFormat && this.children.length>0) {
				s = s + "\n" + "                                          ".substring(0,  context.indent+1);
			}
			s = s+  "</"+this.tag +">";
		} 
		context.indent -= 2;
		s = s + this._addWS(this._fmLine, this._fmIndent);

		return s;
	},

	_formatModel: function( newElement, index, context) {

		var offset = 0;
		var lfSize = 1;		// should check if 2
		if (index == undefined)
			index = this.children.length;

		function addIndent(indent, elemChild, elem) {
			offset += (lfSize + indent);
			if (elemChild) {
				elemChild._fmChildLine = 1;
				elemChild._fmChildIndent = context.indent;
			} else {
				elem._fmLine = 1;
				elem._fmIndent = context.indent;
			}

		}

		function formatElem(elem, context) {
			elem.startOffset = offset;
			elem.wasParsed = true;
			offset += elem.tag.length + 2;
			for (var i=0; i<elem.attributes.length; i++) {
				elem.attributes[i].startOffset = offset;
				var attrtext = elem.attributes[i].getText(context);
				if (attrtext.length>0)
					offset+=1+attrtext.length;
				elem.attributes[i].endOffset=offset-1;
			}
			if (elem.noEndTag) {
				offset++;
			}
			elem.startTagOffset = offset;
			var  s= "";
			if (elem.statements) {
				for (var i=0; i<elem.statements.length; i++) {
					s = s + elem.statements[i].printStatement(context, elem.statements[i]);
				}
			} else if (elem.script) {
				s=elem.script;
			}
			if (s) {
				offset+=s.length;
			} else if (elem.children.length>0) {
				var doFormat;
				if (!davinci.html._noFormatElements[elem.tag]) {
					context.indent += 2;
					addIndent(context.indent, elem);
					doFormat=true;
				}
				var lastChild;
				for (var i=0; i<elem.children.length; i++) {
					var child = elem.children[i];
					switch (child.elementType) {
					case "HTMLElement":
						if (lastChild && lastChild.elementType != "HTMLText" && !davinci.html._noFormatElements[child.tag]) {
							addIndent(context.indent,null, lastChild);
						}
						formatElem(child,context);
						break;
					case "HTMLText":
						child.startOffset = offset;
						offset += child.value.length;
						break;
					case "HTMLComment":
						child.startOffset = offset;
						offset += child.value.length;
						offset++;
						if (child.isProcessingInstruction) {
							offset+=2;
						}
						break;
					default:
						debugger;
					}
					lastChild=child;
				}
				if (doFormat)
					context.indent -= 2;
				if (lastChild && lastChild.elementType != "HTMLText")
					addIndent(context.indent, null, lastChild);
			}
			offset += elem.tag.length + 3;
			elem.endOffset = offset - 1;
		}
		var elem1, elem2;
		if (!this.children.length || index == 0) {
			elem1 = this;
			offset = this.startTagOffset + 1;
		} else {
			elem2 = this.children[index-1];
			offset = elem2.endOffset + 1;
		}
		var startOffset = offset;
		if (!davinci.html._noFormatElements[newElement.tag]) {
			addIndent(context.indent, elem1, elem2);
			newElement._fmLine = 1;
			newElement._fmIndent = (index < this.children.length) ? context.indent : context.indent-2;
		}
		formatElem(newElement,context);
		return (offset>startOffset) ? offset-startOffset : 0;
	},

	getElementText: function(context) {
		context = context || {};
		var s = "" ;
		if (this.children.length > 0) {
			for (var i=0; i<this.children.length; i++)
				if (this.children[i].elementType!="HTMLComment") {
					s=s+this.children[i].getText(context);
				}
		} else if (this.script) {
			return this.script;
		}else if (this.statements) {
			for (var i=0;i<this.statements.length; i++) {
				s = s + this.statements[i].printStatement(context, this.statements[i]);
			}
		}
		return s;
	},

	getChildElements: function(tagName, recurse, result) {
		result = result || [];
		for (var i=0; i<this.children.length; i++) {
			if (this.children[i].tag == tagName) {
				result.push(this.children[i]);
			}
			if (recurse && this.children[i].elementType == "HTMLElement") {
				this.children[i].getChildElements(tagName, recurse, result);
			}
		}
		return result;
	},

	getChildElement: function(tagName) {
		for (var i=0; i<this.children.length; i++)
			if (this.children[i].tag == tagName) {
				return this.children[i];
			}
	},

	hasAttribute: function(name) {
		for (var i=0; i<this.attributes.length; i++) {
			if (this.attributes[i].name == name) {
				return true;
			}
		}
		return false;
	},

	getAttribute: function(name) {
		var attr = this._getAttribute(name);
		if (attr) {
			return attr.value;
		}
	},

	_getAttribute: function(name) {
		for (var i=0; i<this.attributes.length; i++) {
			if (this.attributes[i].name == name) {
				return this.attributes[i];
			}
		}
	},

	addText: function(text) {
		this.addChild(new HTMLText(text));
		this.onChange();
	},

	addComment: function(text) {
		this.addChild(new HTMLComment(text));
		this.onChange();
	},

	getLabel: function() {
		return "<" + this.tag + ">";
	},

	addAttribute: function(name, value, noPersist) {
		if (name == 'textContent') {
			this.children = [];
			this.addText(value);
			return;
		}
		var delta;
		var startOffset = (this.attributes.length > 0) ?
				this.attributes[this.attributes.length-1].endOffset + 1 :
					this.startTagOffset -(this.noEndTag ? 2 : 1);
				var attr = this._getAttribute(name);
				var add;
				if (!attr) {
					attr = new HTMLAttribute();
					add = true;
					delta = name.length + value.length + 4;
					attr.startOffset = startOffset;
					attr.endOffset = startOffset + delta - 1;
				} else {
					delta = value.length-attr.value.length;
				}
				attr.name = name;
				attr.setValue(value);
				attr.noPersist = noPersist;
				if (this.wasParsed && !noPersist && delta > 0) {
					this.getHTMLFile().updatePositions(startOffset, delta);
				}
				// delay adding til after other positions updated
				if (add) {
					this.attributes.push(attr);
				}
				this.onChange();
	},

	removeAttribute: function(name) {
		this.attributes.every(function(attr, idx, arr) {
			if (attr.name === name) {
				arr.splice(idx, 1);
				// Make sure that getHTMLFile() returns a non-null value. This
				// HTMLElement may be standalone (not part of a file); for example,
				// see code in davinci.ve.widget.createWidget().
				var file = this.getHTMLFile();
				if (!attr.noPersist && file) {
					var s = attr.getText();
					file.updatePositions(attr.startOffest, 0 - (s.length + 1));
				}
				return false; // break
			}
			return true;
		}, this);
		this.onChange();
	},

	setAttribute: function(name, value) {
		this.removeAttribute(name);
		this.addAttribute(name, value);
	},

	getUniqueID: function(noPersist) {
		var attr = this.getAttribute("id");
		if (!attr) {
			var file = this.getHTMLFile();
			if (!file.uniqueIDs) {
				file.uniqueIDs = {};
			}
			var id;
			if (!file.uniqueIDs.hasOwnProperty(this.tag)) {
				id = file.uniqueIDs[this.tag]=0;
			} else
				id = ++file.uniqueIDs[this.tag];
			this.addAttribute("id", this.tag+"_"+id,noPersist);	 
		}
	},

	findElement: function(id) {
		var attr = this.getAttribute("id");
		if (id == attr ) {
			return this;
		}
		for (var i=0; i<this.children.length; i++) {
			if (this.children[i].elementType == "HTMLElement") {
				var found = this.children[i].findElement(id);
				if (found) {
					return found;
				}
			}
		}
	},

	insertBefore: function(newChild, beforeChild) {
		var index = dojo.indexOf(this.children, beforeChild);
		if (index<0) {
			index=undefined;
		}
		this.addChild(newChild, index);
		this.onChange();
	},

	addChild: function(newChild,index, fromParser) {
		if (!fromParser && this.wasParsed) {
			if (newChild.elementType == 'HTMLElement') {
				// calculate indent
				var myIndent = this._getIndent();
				var childIndent;
				// if inserting before element, use same indent as that element
				if (index < this.children.length && this.children[index].elementType == "HTMLElement")	{
					childIndent = this.children[index]._getIndent();
				} else {
					if (this.children.length) {
						dojo.forEach(this.children, function(element){
							if (element.elementType == "HTMLElement")
								childIndent = element._getIndent();
						});
					} else {
						childIndent = myIndent+1;
					}
				}
				var indent = childIndent;
				var context = {indent:indent};
				var delta = this._formatModel(newChild,index, context);

				this.getHTMLFile().updatePositions(newChild.startOffset, delta);

			} else if (newChild.elementType == "HTMLText" || newChild.elementType.substring(0,3) == "CSS") {
				var s = newChild.getText();
				var offset = this.children.length ? this.children[this.children.length-1].endOffset : this.startTagOffset;
				var len = s.length;
				if (len > 0) {
					if (newChild.elementType!="HTMLText")
						len += this._fmChildIndent + 1;	// if css, add indent+lf
					this.getHTMLFile().updatePositions(offset+1, len);
				}
				newChild.startOffset = offset+1;
				newChild.endOffset = newChild.startOffset+s.length-1;
			}

		}
		HTMLItem.prototype.addChild.apply(this,arguments);
	},

	removeChild: function(child) {
		var index = dojo.indexOf(this.children, child);
		var lfSize = 1;
		if (index >= 0) {
			var delta = 1 + child.endOffset - child.startOffset;

			if (child.elementType == "HTMLElement") {
				if (this.children.length == 1) {
					delta += this._fmChildLine * lfSize + this._fmChildIndent;
					this._fmChildIndent -= 2;
				} else {
					if (index > 0 && this.children[index-1].elementType == "HTMLElement") {
						var prevChild = this.children[index-1];
						delta += prevChild._fmLine * lfSize + prevChild._fmIndent;
					}
					if (index+1 == this.children.length && this.children[index-1].elementType == "HTMLElement")
						this.children[index-1]._fmChildIndent -= 2;
				}
			}

			if (delta > 0 && this.wasParsed) {
				this.getHTMLFile().updatePositions(child.startOffset,0-delta);
			}
		}
		HTMLItem.prototype.removeChild.apply(this,arguments);
	},

	_textModify: function(newText, oldText) {
		var delta = newText.length-oldText.length;
		if (delta != 0 && this.wasParsed) {
			this.getHTMLFile().updatePositions( this.startOffset, delta);
		}
	}, 

	setScript: function(script) {
		this._textModify(script, this.script);
		this.script = script;

	},

	_previous: function() {
		var inx = dojo.indexOf(this.parent.children, this);
		if  (inx > 0)  {
			return this.parent.children[inx-1];
		}
	},

	_getIndent: function() {
		var prev = this._previous();
		if (prev) {
			if (prev.elementType == " HTMLText") {
				var txt = prev.value.split('\n');
				return txt[txt.length-1].length;
			} else {
				return prev._fmIndent;
			}
		} else {
			return this.parent._fmChildIndent;
		}
	},

	visit: function (visitor) {
		if (!visitor.visit(this)) {
			for (var i=0; i<this.attributes.length; i++) {
				this.attributes[i].visit(visitor);
			}
			for (var i=0; i<this.children.length; i++) {
				this.children[i].visit(visitor);
			}
		}
		if(visitor.endVisit) { visitor.endVisit(this); }
	},

	setText: function (text) {
		// clear cached values
		this.script = '';

		var options = {xmode:'outer'};
		var currentParent = this.parent;
		var result = require("davinci/html/HTMLParser").parse(text,this);

		this.errors = result.errors;
		// first child is actually the parsed element, so replace this with child
		dojo.mixin(this, this.children[0]);
		this.parent = currentParent;
		this.visit({
			visit:function(node){
				delete node.wasParsed;
			},
			rules :[]
		});
		this.onChange();
	}

});
});


},
'davinci/ve/metadata':function(){
define([
	"require",
	"dojo/Deferred",
    "dojo/promise/all",
    "dojo/_base/lang",
    "dojo/_base/connect",
   // "davinci/Workbench",
	"../library",
	"../model/Path",
	"../repositoryinfo"
], function(require, Deferred, all, lang, connect, Library, Path, info) {

	var Metadata,
		Workbench,
    
    // Array of library descriptors.
    	libraries = {},
    // Widget metadata cache
    // XXX Should there be a limit on metadata objects in memory?
    	mdCache = {},
    // Cache for instantiated helper objects.  See getHelper().
    	helperCache = {},
    // Localization strings
    	l10n = null,
    // Each callbacks.js file gets its own deferred.
    // Ensures page editors don't start processing until all callback.js files are ready
    	deferredGets = [],

        libExtends = {},

    	defaultProperties = {
	        id: {datatype: "string", hidden: true},
	        lang: {datatype: "string", hidden: true},
	        dir: {datatype: "string", hidden: true},
	        "class": {datatype: "string", hidden: true},
	        style: {datatype: "string", hidden: true},
	        title: {datatype: "string", hidden: true}
    	};

    dojo.subscribe("/davinci/ui/libraryChanged/start", function() {
        // XXX We should be smart about this and only reload data for libraries whose path has
        //  changed.  This code currently nukes everything, reloading all libs, even those that
        //  haven't changed.
        libraries = {};
        mdCache = {};
        helperCache = {};
        l10n = null;
        Metadata.init().then(function() {
        	dojo.publish("/davinci/ui/libraryChanged");
        });
    });

    /**
     * Copies/adds all properties of one or more sources to dest; returns dest.
     * Similar to dojo.mixin(), except this function does a deep merge.
     * 
     * @param  {Object} dest
     *          The object to which to copy/add all properties contained in source. If dest is
     *          falsy, then a new object is manufactured before copying/adding properties
     *          begins.
     * @param  {Object} srcs
     *          One of more objects from which to draw all properties to copy into dest. Srcs
     *          are processed left-to-right and if more than one of these objects contain the
     *          same property name, the right-most value "wins".
     * @return {Object}
     *          dest, as modified
     */
    function deepMixin(dest, srcs) {
        dest = dest || {};
        for (var i = 1, l = arguments.length; i < l; i++) {
            var src = arguments[i],
                name,
                val;
            for (name in src) {
                if (src.hasOwnProperty(name)) {
                    val = src[name];
                    if (!(name in dest) || (typeof val !== 'object' && dest[name] !== val)) {
                        dest[name] = val;
                    } else {
                        deepMixin(dest[name], val);
                    }
                }
            }
        }
        return dest;
    }

	function parsePackage(pkg, path) {
		libraries[pkg.name] = pkg;
		path = new Path(path);

		// merge in the 'oam' and 'maqetta' overlays
		var overlays = pkg.overlays;
		for (var name in overlays) {
			if (overlays.hasOwnProperty(name)) {
				if (name === 'oam' || name === 'maqetta') {
					deepMixin(pkg, overlays[name]);
				}
			}
        }
		delete pkg.overlays;

        // Register a module identifier for the metadata and library code paths;
        // used by helper and creation tool classes.
        pkg.__metadataModuleId = 'maq-metadata-' + pkg.name;
        var locPath = new Path(location.href);
        var packages = [ {
            name : pkg.__metadataModuleId,
            location : locPath.append(path).append(pkg.directories.metadata).toString()
        } ];
        if (pkg.name != "dojo") {
            // Don't register another "dojo" lib to compete with core.client. Also, note
            // no longer adding pkg.version to module id because not compatible when
            // we go to custom build the library.
            pkg.__libraryModuleId = pkg.name;
            var libPath = 'app/static/lib/' + pkg.name + '/' + pkg.version;

            packages.push({
                name: pkg.__libraryModuleId,
                location: locPath.append(libPath).toString()
            });
        }
        require = require({
            packages: packages
        });

        // read in Maqetta-specific "scripts"
        var deferred; // dojo/Deferred or value
		if (lang.exists("scripts.widget_metadata", pkg)) {
			if (typeof pkg.scripts.widget_metadata == "string") {
				var widgetsJsonPath = path.append(pkg.scripts.widget_metadata);
				deferred = dojo.xhrGet({
					url : widgetsJsonPath.toString() + "?" + info.revision,
					handleAs : "json"
				}).then(function(data) {
					if (data) {
						var widgetsJsonParentPath = widgetsJsonPath.getParentPath();
						return parseLibraryDescriptor(pkg.name, data,
								widgetsJsonParentPath, widgetsJsonParentPath); // lop off "*.json"
		            }
		        });
			} else {
                // the "widgets.json" data is presented inline in package.json
				deferred = parseLibraryDescriptor(pkg.name, pkg.scripts.widget_metadata, path);
			}
	    }
    
        if (lang.exists("scripts.callbacks", pkg)) {
            var d = new Deferred();
            require([pkg.scripts.callbacks], function(cb) {
                pkg.$callbacks = cb;
                d.resolve();
            });
            deferredGets.push(d);
        }

        return deferred;
    }

	function parseLibraryDescriptor(libName, descriptor, descriptorParentFolderPath, moduleFolderPath) {
		if (!libName) {
			console.error("parseLibraryDescriptor: missing 'libName' arg");
		}

		var pkg = libraries[libName];
		var path = descriptorParentFolderPath;
		// XXX Should remove $descriptorFolderPath. This info is already stored in the packages
		//   structure; just use that. (NOTE: $descriptorFolderPath is also used by custom widgets)
        descriptor.$descriptorFolderPath = path.toString();
        descriptor.$moduleFolderPath = moduleFolderPath.toString();
        
		// Handle custom widgets, which call this function without first calling
		// parsePackage().
		if (!pkg) {
			libraries[libName] = {
				$wm: descriptor,
				name:descriptor.name,
				version:descriptor.version
			};
			// NOTE: Custom widgets include __metadataModuleId on the descriptor
			if(descriptor.__metadataModuleId){
				libraries[libName].__metadataModuleId = descriptor.__metadataModuleId;
			}
			pkg = libraries[libName];
		} else if (pkg.$widgets) {
			descriptor.widgets.forEach(function(item) {
				pkg.$wm.widgets.push(item);
			});
			for (var name in descriptor.categories) {
				if (! pkg.$wm.categories.hasOwnProperty(name)) {
					pkg.$wm.categories[name] = descriptor.categories[name];
				}
			}
		}else if(pkg.$wm){
			/* metadata already exists, mix the new widgets with old */
			for(var z=0;z<descriptor.widgets.length;z++){
				var found = false;
				for(var ll=0;!found && ll<pkg.$wm.widgets.length;ll++){
					if(pkg.$wm.widgets[ll].type==descriptor.widgets[z].type)
						found = true;
				}
				
				if(!found){
					pkg.$wm.widgets.push(descriptor.widgets[z]);
				}
			}
			
		
		} else if(!pkg.$wm) {
			// XXX For now, put data from widgets.json as sub-property of package.json
			//   data.  Later, this should be split up into separate APIs.
			//   
			//   libraries[] = pkg = {
			//       name:
			//       description:
			//       version:
			//       directories: {
			//           lib:
			//           metadata:
			//       }
			//       scripts: {
			//           widget_metadata:  URL
			//       }
			//       $wm: {    // from widgets.json
			//          categories: {}
			//          widgets: []
			//          $providedTypes: {} - assoc attray, each entry points to a widget descriptor
			//          $providedTags: {} - assoc array, each entry points to an array of widget descriptors
			//          $descriptorFolderPath:
			//          $moduleFolderPath:
			//       }
			//       $callbacks:  JS
			//   }
			pkg.$wm = descriptor;
		}

		var wm = pkg.$wm;
		
		function addTag(wm, tag, item){
			if(typeof wm.$providedTags[tag] == 'undefined'){
				wm.$providedTags[tag] = [];
			}
			wm.$providedTags[tag].push(item);
		}
        
		wm.$providedTypes = wm.$providedTypes || {};
		wm.$providedTags = wm.$providedTags || {};

		wm.widgets.forEach(function(item) {
			wm.$providedTypes[item.type] = item;
			// In widgets.json, item.tags can be either a string or an array of strings.
			if(typeof item.tags == 'string'){
				addTag(wm, item.tags, item);
			}else if(item.tags && item.tags.length){
				for(var tagindex=0; tagindex<item.tags.length; tagindex++){
					addTag(wm, item.tags[tagindex], item);
				}
			}
        	if (item.icon && !item.iconLoc