/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"url:dijit/templates/CheckedMenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitemcheckbox\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuItemIcon dijitCheckedMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t\t<span class=\"dijitCheckedMenuItemIconChar\">&#10003;</span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,labelNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">&#160;</td>\n</tr>\n","davinci/html/CSSModel":function(){
define({shorthand:[["border",["border-width","border-style","border-color","border-top","border-left","border-right","border-bottom"]],["border-width",["border-top-width","border-right-width","border-bottom-width","border-left-width"]],["border-style",["border-top-style","border-right-style","border-bottom-style","border-left-style"]],["border-color",["border-top-color","border-right-color","border-bottom-color","border-left-color"]],["border-bottom",["border-bottom-width","border-bottom-style","border-bottom-color"]],["border-top",["border-top-width","border-top-style","border-top-color"]],["border-left",["border-left-width","border-left-style","border-left-color"]],["border-right",["border-right-width","border-right-style","border-right-color"]],["font",["font-size","line-height","font-weight","font-style","font-family","line-height"]],["border-radius",["border-top-left-radius","border-top-right-radius","border-bottom-right-radius","border-bottom-left-radius"]],["-moz-border-radius",["-moz-border-radius-topleft","-moz-border-radius-topright","-moz-border-radius-bottomright","-moz-border-radius-bottomleft"]],["margin",["margin-top","margin-right","margin-bottom","margin-left"]],["padding",["padding-top","padding-right","padding-bottom","padding-left"]],["background",["background-color","background-image","background-repeat","background-position","background-attachment"]]]});
},"dijit/form/TextBox":function(){
define(["dojo/_base/declare","dojo/dom-construct","dojo/dom-style","dojo/_base/kernel","dojo/_base/lang","dojo/sniff","./_FormValueWidget","./_TextBoxMixin","dojo/text!./templates/TextBox.html","../main"],function(_1,_2,_3,_4,_5,_6,_7,_8,_9,_a){
var _b=_1("dijit.form.TextBox",[_7,_8],{templateString:_9,_singleNodeTemplate:"<input class=\"dijit dijitReset dijitLeft dijitInputField\" data-dojo-attach-point=\"textbox,focusNode\" autocomplete=\"off\" type=\"${type}\" ${!nameAttrSetting} />",_buttonInputDisabled:_6("ie")?"disabled":"",baseClass:"dijitTextBox",postMixInProperties:function(){
var _c=this.type.toLowerCase();
if(this.templateString&&this.templateString.toLowerCase()=="input"||((_c=="hidden"||_c=="file")&&this.templateString==this.constructor.prototype.templateString)){
this.templateString=this._singleNodeTemplate;
}
this.inherited(arguments);
},postCreate:function(){
this.inherited(arguments);
if(_6("ie")<9){
this.defer(function(){
try{
var s=_3.getComputedStyle(this.domNode);
if(s){
var ff=s.fontFamily;
if(ff){
var _d=this.domNode.getElementsByTagName("INPUT");
if(_d){
for(var i=0;i<_d.length;i++){
_d[i].style.fontFamily=ff;
}
}
}
}
}
catch(e){
}
});
}
},_onInput:function(e){
this.inherited(arguments);
if(this.intermediateChanges){
this.defer(function(){
this._handleOnChange(this.get("value"),false);
});
}
},_setPlaceHolderAttr:function(v){
this._set("placeHolder",v);
if(!this._phspan){
this._attachPoints.push("_phspan");
this._phspan=_2.create("span",{onmousedown:function(e){
e.preventDefault();
},className:"dijitPlaceHolder dijitInputField"},this.textbox,"after");
}
this._phspan.innerHTML="";
this._phspan.appendChild(this._phspan.ownerDocument.createTextNode(v));
this._updatePlaceHolder();
},_updatePlaceHolder:function(){
if(this._phspan){
this._phspan.style.display=(this.placeHolder&&!this.focused&&!this.textbox.value)?"":"none";
}
},_setValueAttr:function(_e,_f,_10){
this.inherited(arguments);
this._updatePlaceHolder();
},getDisplayedValue:function(){
_4.deprecated(this.declaredClass+"::getDisplayedValue() is deprecated. Use get('displayedValue') instead.","","2.0");
return this.get("displayedValue");
},setDisplayedValue:function(_11){
_4.deprecated(this.declaredClass+"::setDisplayedValue() is deprecated. Use set('displayedValue', ...) instead.","","2.0");
this.set("displayedValue",_11);
},_onBlur:function(e){
if(this.disabled){
return;
}
this.inherited(arguments);
this._updatePlaceHolder();
if(_6("mozilla")){
if(this.selectOnClick){
this.textbox.selectionStart=this.textbox.selectionEnd=undefined;
}
}
},_onFocus:function(by){
if(this.disabled||this.readOnly){
return;
}
this.inherited(arguments);
this._updatePlaceHolder();
}});
if(_6("ie")){
_b.prototype._isTextSelected=function(){
var _12=this.ownerDocument.selection.createRange();
var _13=_12.parentElement();
return _13==this.textbox&&_12.text.length>0;
};
_a._setSelectionRange=_8._setSelectionRange=function(_14,_15,_16){
if(_14.createTextRange){
var r=_14.createTextRange();
r.collapse(true);
r.moveStart("character",-99999);
r.moveStart("character",_15);
r.moveEnd("character",_16-_15);
r.select();
}
};
}
return _b;
});
},"davinci/review/view/CommentExplorerView":function(){
define(["dojo/_base/declare","davinci/Runtime","davinci/review/model/ReviewTreeModel","davinci/Workbench","davinci/workbench/ViewPart","dijit/Tree","dojo/date/stamp","dojo/date/locale","davinci/review/actions/CloseVersionAction","davinci/review/actions/EditVersionAction","davinci/review/actions/OpenVersionAction","dijit/Toolbar","dijit/ToolbarSeparator","dijit/form/Button","dijit/form/TextBox","dojo/i18n!./nls/view","dojo/i18n!../widgets/nls/widgets","davinci/ui/widgets/TransformTreeMixin"],function(_17,_18,_19,_1a,_1b,_1c,_1d,_1e,_1f,_20,_21,_22,_23,_24,_25,_26,_27){
var _28=function(_29,_2a){
if(_29.elementType=="ReviewVersion"){
if(_29.isDraft){
return "draft-open";
}
if(_29.closed){
return _2a?"reviewFolder-open-disabled":"reviewFolder-closed-disabled";
}
if(!_29.closed){
return _2a?"reviewFolder-open":"reviewFolder-closed";
}
}
if(_29.elementType=="ReviewFile"){
if(_29.parent.closed){
return "disabledReviewFileIcon";
}
var _2b;
var _2c=_29.getExtension();
var _2d=_18.getExtension("davinci.fileType",function(_2e){
return _2e.extension==_2c;
});
if(_2d){
_2b=_2d.iconClass;
}
return _2b||"dijitLeaf";
}
return "dijitLeaf";
};
getLabelClass=function(_2f,_30){
var _31="dijitTreeLabel";
if(_2f.elementType=="ReviewVersion"){
if(_2f.designerId==_18.userName){
_31="reviewOwnedByUserLabel";
}else{
_31="reviewOwnedByOtherLabel";
}
}
return _31;
};
var _32=function(){
return [function(_33){
return _33.sort(function(_34,_35){
return _34.timeStamp>_35.timeStamp?-1:_34.timeStamp<_35.timeStamp?1:0;
});
}];
};
var _36=_17(_1b,{postCreate:function(){
this.inherited(arguments);
var _37=new _19();
this.model=_37;
var _38=_32();
_38.push(function(_39){
return _39.filter(this.commentingFilter.filterItem,this);
}.bind(this));
this.tree=new _1c({id:"reviewCommentExplorerViewTree",persist:false,showRoot:false,model:_37,labelAttr:"name",childrenAttrs:"children",getIconClass:dojo.hitch(this,this._getIconClass),getLabelClass:dojo.hitch(this,this._getLabelClass),transforms:_38,isMultiSelect:true});
this.setContent(this.tree);
this.attachToolbar();
this.tree.startup();
dojo.connect(this.tree,"onDblClick",dojo.hitch(this,this._dblClick));
dojo.connect(this.tree,"onClick",dojo.hitch(this,this._click));
dojo.connect(this.tree,"_onNodeMouseEnter",dojo.hitch(this,this._over));
dojo.connect(this.tree,"_onNodeMouseLeave",dojo.hitch(this,this._leave));
dojo.connect(this.tree,"_setSelectedNodesAttr",function(){
this._publishSelectionChanges();
}.bind(this));
this.subscribe("/davinci/review/selectionChanged","_updateActionBar");
this.subscribe("/davinci/review/resourceChanged",function(_3a,_3b,_3c){
if(_3c&&_3c.timeStamp){
davinci.review.model.resource.root.findVersion(_3c.timeStamp).then(function(_3d){
if(_3d){
this.tree.set("selectedItem",_3d);
}else{
this.tree.set("selectedItems",[]);
}
this._publishSelectionChanges();
this.tree.rootNode.expand();
}.bind(this));
}
});
var _3e=_1a.createPopup({partID:"davinci.review.reviewNavigator",context:this,domNode:this.tree.domNode,openCallback:function(_3f){
var w=dijit.getEnclosingWidget(_3f.target);
if(!w||!w.item){
return;
}
this.tree.set("path",this._buildTreePath(w.item));
}.bind(this)});
var o=_1a.getActionSets("davinci.review.reviewNavigator");
var _40=o.clonedActionSets;
if(_40&&_40.length==1){
dojo.forEach(_40[0].actions,dojo.hitch(this,function(_41){
if(_41.keyBinding){
if(!this.keyBindings){
this.keyBindings=[];
}
this.keyBindings.push({keyBinding:_41.keyBinding,action:_41});
}
}));
}
dojo.connect(this.tree.domNode,"onkeypress",this,"_onKeyPress");
this.infoCardContent=dojo.cache("davinci","review/widgets/templates/InfoCard.html","<div class=\"detail_title\">${detail_title}</div>\n<div>\n\t<div class=\"detail_div\"><span>${your_role}:</span><span class=\"detail_role\">${detail_role}</span><span>${due_by}:</span><span class=\"${detail_dueDate_class}\">${detail_dueDate}</span></div>\n\t<div class=\"detail_div\"><span>${created_by}:</span><span class=\"detail_creator\">${detail_creator}</div>\n\t<div class=\"detail_div\"><span>${creation_date}:</span><span class=\"detail_creationDate\">${detail_creationDate}</div>\n</div>\n<div class=\"detail_div\"><strong>${artifacts_in_rev}</strong></div>\n${detail_files}\n<div class=\"detail_div\"><strong>${reviewers}</strong></div>\n${detail_reviewers}");
if(!dijit._masterTT){
dijit._masterTT=new dijit._MasterTooltip();
}
this.connect(dijit._masterTT.domNode,"mouseover",function(){
this._deleteDelTimer();
});
this.connect(dijit._masterTT.domNode,"mouseleave",function(){
this._lastAnchorNode&&this._leave();
});
dojo.subscribe("/davinci/ui/editorSelected",function(obj){
var _42=obj.editor;
if(_42&&_42.editorID==="davinci.review.CommentReviewEditor"){
var _43=_42.resourceFile;
var _44=_43.parent;
dojo.forEach(this.model.root.children,function(_45){
if(_45!=_44){
var _46=this.tree.getNodesByItem(_45);
if(_46.length>0){
var _47=_46[0];
if(_47.isExpanded){
this.tree._collapseNode(_47);
}
}
}
}.bind(this));
this.tree.set("path",this._buildTreePath(_43));
}
}.bind(this));
},_buildTreePath:function(_48){
var _49=[];
for(var _4a=_48;_4a;_4a=_4a.parent){
_49.unshift(_4a);
}
return _49;
},_updateActionBar:function(_4b,_4c){
if(_4c!=this||!_4b||!_4b.length){
this.closeBtn.set("disabled",true);
this.editBtn.set("disabled",true);
return;
}
var _4d=_4b[0].resource.elementType=="ReviewFile"?_4b[0].resource.parent:_4b[0].resource;
_18.reviewers=_4d.reviewers||[];
var _4e=_4d.designerId==_18.userName;
var _4f=_4d.elementType=="ReviewVersion";
var _50=_4d.isDraft;
this.closeBtn.set("disabled",!_4e||!_4f||_4d.closed||_50);
this.openBtn.set("disabled",!_4e||!_4f||!_4d.closedManual||_50);
this.editBtn.set("disabled",!_4e||!_4f);
},getTopAdditions:function(){
var _51=new _22({},dojo.create("div"));
var _52=new _24({id:_51.get("id")+".Close",showLabel:false,label:_26.closeVersion,disabled:true,iconClass:"viewActionIcon closeVersionIcon",onClick:dojo.hitch(this,"_closeVersion")});
this.closeBtn=_52;
var _53=new _24({id:_51.get("id")+".Open",showLabel:false,label:_26.openVersion,disabled:true,iconClass:"viewActionIcon openVersionIcon",onClick:dojo.hitch(this,"_openVersion")});
this.openBtn=_53;
var _54=new _24({id:_51.get("id")+".Edit",showLabel:false,label:_26.editVersion,disabled:true,iconClass:"viewActionIcon editVersionIcon",onClick:dojo.hitch(this,"_editVersion")});
this.editBtn=_54;
var _55=new _25({id:"reviewExplorerFilter",placeHolder:_26.filter,onKeyUp:dojo.hitch(this,this._filter)});
_51.addChild(_52);
_51.addChild(_53);
_51.addChild(new dijit.ToolbarSeparator());
_51.addChild(_54);
dojo.place(dojo.create("br"),_51.domNode);
_51.addChild(_55);
dojo.addClass(_51.domNode,"davinciCommentExplorer");
return _51.domNode;
},_closeVersion:function(){
(new _1f()).run(this);
},_openVersion:function(){
(new _21()).run(this);
},_editVersion:function(){
(new _20()).run(this);
},_filter:function(e){
var _56=dijit.byId("reviewExplorerFilter").get("value");
this.commentingFilter.filterString=_56;
dojo.forEach(this.model.root.children,dojo.hitch(this,function(_57){
_57.getChildren(function(_58){
this.model.onChildrenChange(_57,_58);
}.bind(this));
}));
},commentingFilter:{filterString:"",filterItem:function(_59){
var _5a=this.commentingFilter.filterString;
if(!_5a){
return true;
}else{
if(_59.elementType=="ReviewFile"){
return _59.name.toLowerCase().indexOf(_5a.toLowerCase())>=0;
}
return true;
}
}},destroy:function(){
this.inherited(arguments);
},_dblClick:function(_5b){
if(_5b.isDraft||_5b.parent.isDraft){
if(_5b.designerId==_18.userName||_5b.parent.designerId==_18.userName){
this._openPublishWizard(_5b.isDraft?_5b:_5b.parent);
}
return;
}
if(_5b.elementType=="ReviewFile"){
_1a.openEditor({fileName:_5b,content:_5b.getText()});
}
},_click:function(_5c){
this._publishSelectionChanges();
},_publishSelectionChanges:function(){
var _5d=this.getSelection();
this.publish("/davinci/review/selectionChanged",[_5d,this]);
},getSelection:function(){
var _5e=dojo.map(this.tree.get("selectedItems"),function(_5f){
return {resource:_5f};
});
return _5e;
},_over:function(_60){
if(_60.item.elementType!="ReviewVersion"){
return;
}
if(!this._showTimer){
var _61=_60.item,_62={},c;
_62.detail_title=_61.name;
_62.your_role=_27.yourRole;
_62.due_by=_27.dueBy;
_62.created_by=_27.createdBy;
_62.creation_date=_27.creationDate;
_62.artifacts_in_rev=_27.artifactsInRev;
_62.reviewers=_27.reviewers;
_62.detail_role=(_61.designerId==_18.userName)?_26.designer:_26.reviewer;
_62.detail_dueDate=_61.dueDate=="infinite"?_26.infinite:_1e.format(_61.dueDate,{selector:"date",formatLength:"long"});
var _63=_18.getUserDisplayNamePlusEmail({email:_61.designerEmail,userDisplayName:_61.designerDisplayName,userId:_61.designerId});
_62.detail_creator=_63;
var _64=_61.timeStamp.match(/^(\d{4})(\d{2})(\d{2})\T(\d{2})(\d{2})(\d{2})\Z$/);
var _65=_1d.fromISOString(_64?dojo.replace("{1}-{2}-{3}T{4}:{5}:{6}Z",_64):_61.timeStamp);
_62.detail_creationDate=_1e.format(_65,{formatLength:"medium"});
_62.detail_files="";
_61.getChildren(function(_66){
dojo.forEach(_66,function(i){
var _67=i.getLabel();
_62.detail_files+="<div><span>"+_67.substr(0,_67.length-4)+"</span><span class='dijitTreeIcon reviewFileIcon detail_file'></span></div>";
});
_62.detail_reviewers="";
dojo.forEach(_61.reviewers,function(i){
if(i.email!=_61.designerEmail){
var _68="<div>"+i.email+"</div>";
if((i.displayName!="")&&(i.email!=i.displayName)){
_68="<div>"+i.displayName+" &lt;"+i.email+"&gt;</div>";
}
_62.detail_reviewers+=_68;
}
});
_61.closed?_62.detail_dueDate_class="closed":_62.detail_dueDate_class="notClosed";
this._showTimer=setTimeout(dojo.hitch(this,function(){
this._deleteDelTimer();
dijit.showTooltip(dojo.string.substitute(this.infoCardContent,_62),_60.rowNode);
this._lastAnchorNode=_60;
delete this._showTimer;
this._createDelTimer(15000);
}),1000);
}.bind(this));
}
},_leave:function(_69){
this._deleteDelTimer();
if(this._showTimer){
clearTimeout(this._showTimer);
delete this._showTimer;
}
if(this._lastAnchorNode){
this._createDelTimer(1000);
}
},_createDelTimer:function(_6a){
this._delTimer=setTimeout(dojo.hitch(this,function(){
this._hideTooltip();
delete this._delTimer;
}),_6a);
},_deleteDelTimer:function(){
if(this._delTimer){
clearTimeout(this._delTimer);
delete this._delTimer;
}
},_hideTooltip:function(){
if(this._lastAnchorNode){
dijit.hideTooltip(this._lastAnchorNode.rowNode);
this._lastAnchorNode=null;
}
},_openPublishWizard:function(_6b){
var _6c=new davinci.review.actions.PublishAction(_6b);
_6c.run();
},_getIconClass:function(_6d,_6e){
return _28(_6d,_6e);
},_getLabelClass:function(_6f,_70){
return getLabelClass(_6f,_70);
},_onKeyPress:function(e){
var _71=dojo.some(this.keyBindings,dojo.hitch(this,function(_72){
if(_18.isKeyEqualToEvent(_72.keyBinding,e)){
davinci.Workbench._runAction(_72.action,this,_72.action.id);
return true;
}
}));
if(_71){
dojo.stopEvent(e);
}
return _71;
}});
_36.getIconClass=_28;
_36.getLabelClass=getLabelClass;
_36.getSortTransforms=_32;
return _36;
});
},"dojox/grid/DataGrid":function(){
define(["../main","dojo/_base/array","dojo/_base/lang","dojo/_base/json","dojo/_base/sniff","dojo/_base/declare","./_Grid","./DataSelection","dojo/_base/html"],function(_73,_74,_75,_76,has,_77,_78,_79,_7a){
var _7b=_77("dojox.grid.DataGrid",_78,{store:null,query:null,queryOptions:null,fetchText:"...",sortFields:null,updateDelay:1,items:null,_store_connects:null,_by_idty:null,_by_idx:null,_cache:null,_pages:null,_pending_requests:null,_bop:-1,_eop:-1,_requests:0,rowCount:0,_isLoaded:false,_isLoading:false,keepSelection:false,postCreate:function(){
this._pages=[];
this._store_connects=[];
this._by_idty={};
this._by_idx=[];
this._cache=[];
this._pending_requests={};
this._setStore(this.store);
this.inherited(arguments);
},destroy:function(){
this.selection.destroy();
this.inherited(arguments);
},createSelection:function(){
this.selection=new _79(this);
},get:function(_7c,_7d){
if(_7d&&this.field=="_item"&&!this.fields){
return _7d;
}else{
if(_7d&&this.fields){
var ret=[];
var s=this.grid.store;
_74.forEach(this.fields,function(f){
ret=ret.concat(s.getValues(_7d,f));
});
return ret;
}else{
if(!_7d&&typeof _7c==="string"){
return this.inherited(arguments);
}
}
}
return (!_7d?this.defaultValue:(!this.field?this.value:(this.field=="_item"?_7d:this.grid.store.getValue(_7d,this.field))));
},_checkUpdateStatus:function(){
if(this.updateDelay>0){
var _7e=false;
if(this._endUpdateDelay){
clearTimeout(this._endUpdateDelay);
delete this._endUpdateDelay;
_7e=true;
}
if(!this.updating){
this.beginUpdate();
_7e=true;
}
if(_7e){
var _7f=this;
this._endUpdateDelay=setTimeout(function(){
delete _7f._endUpdateDelay;
_7f.endUpdate();
},this.updateDelay);
}
}
},_onSet:function(_80,_81,_82,_83){
this._checkUpdateStatus();
var idx=this.getItemIndex(_80);
if(idx>-1){
this.updateRow(idx);
}
},_createItem:function(_84,_85){
var _86=this._hasIdentity?this.store.getIdentity(_84):_76.toJson(this.query)+":idx:"+_85+":sort:"+_76.toJson(this.getSortProps());
var o=this._by_idty[_86]={idty:_86,item:_84};
return o;
},_addItem:function(_87,_88,_89){
this._by_idx[_88]=this._createItem(_87,_88);
if(!_89){
this.updateRow(_88);
}
},_onNew:function(_8a,_8b){
this._checkUpdateStatus();
var _8c=this.get("rowCount");
this._addingItem=true;
this.updateRowCount(_8c+1);
this._addingItem=false;
this._addItem(_8a,_8c);
this.showMessage();
},_onDelete:function(_8d){
this._checkUpdateStatus();
var idx=this._getItemIndex(_8d,true);
if(idx>=0){
this._pages=[];
this._bop=-1;
this._eop=-1;
var o=this._by_idx[idx];
this._by_idx.splice(idx,1);
delete this._by_idty[o.idty];
this.updateRowCount(this.get("rowCount")-1);
if(this.get("rowCount")===0){
this.showMessage(this.noDataMessage);
}
}
if(this.selection.isSelected(idx)){
this.selection.deselect(idx);
this.selection.selected.splice(idx,1);
}
},_onRevert:function(){
this._refresh();
},setStore:function(_8e,_8f,_90){
if(this._requestsPending(0)){
return;
}
this._setQuery(_8f,_90);
this._setStore(_8e);
this._refresh(true);
},setQuery:function(_91,_92){
if(this._requestsPending(0)){
return;
}
this._setQuery(_91,_92);
this._refresh(true);
},setItems:function(_93){
this.items=_93;
this._setStore(this.store);
this._refresh(true);
},_setQuery:function(_94,_95){
this.query=_94;
this.queryOptions=_95||this.queryOptions;
},_setStore:function(_96){
if(this.store&&this._store_connects){
_74.forEach(this._store_connects,this.disconnect,this);
}
this.store=_96;
if(this.store){
var f=this.store.getFeatures();
var h=[];
this._canEdit=!!f["dojo.data.api.Write"]&&!!f["dojo.data.api.Identity"];
this._hasIdentity=!!f["dojo.data.api.Identity"];
if(!!f["dojo.data.api.Notification"]&&!this.items){
h.push(this.connect(this.store,"onSet","_onSet"));
h.push(this.connect(this.store,"onNew","_onNew"));
h.push(this.connect(this.store,"onDelete","_onDelete"));
}
if(this._canEdit){
h.push(this.connect(this.store,"revert","_onRevert"));
}
this._store_connects=h;
}
},_onFetchBegin:function(_97,req){
if(!this.scroller){
return;
}
if(this.rowCount!=_97){
if(req.isRender){
this.scroller.init(_97,this.keepRows,this.rowsPerPage);
this.rowCount=_97;
this._setAutoHeightAttr(this.autoHeight,true);
this._skipRowRenormalize=true;
this.prerender();
this._skipRowRenormalize=false;
}else{
this.updateRowCount(_97);
}
}
if(!_97){
this.views.render();
this._resize();
this.showMessage(this.noDataMessage);
this.focus.initFocusView();
}else{
this.showMessage();
}
},_onFetchComplete:function(_98,req){
if(!this.scroller){
return;
}
if(_98&&_98.length>0){
_74.forEach(_98,function(_99,idx){
this._addItem(_99,req.start+idx,true);
},this);
this.updateRows(req.start,_98.length);
if(req.isRender){
this.setScrollTop(0);
this.postrender();
}else{
if(this._lastScrollTop){
this.setScrollTop(this._lastScrollTop);
}
}
if(has("ie")){
_7a.setSelectable(this.domNode,this.selectable);
}
}
delete this._lastScrollTop;
if(!this._isLoaded){
this._isLoading=false;
this._isLoaded=true;
}
this._pending_requests[req.start]=false;
},_onFetchError:function(err,req){
delete this._lastScrollTop;
if(!this._isLoaded){
this._isLoading=false;
this._isLoaded=true;
this.showMessage(this.errorMessage);
}
this._pending_requests[req.start]=false;
this.onFetchError(err,req);
},onFetchError:function(err,req){
},_fetch:function(_9a,_9b){
_9a=_9a||0;
if(this.store&&!this._pending_requests[_9a]){
if(!this._isLoaded&&!this._isLoading){
this._isLoading=true;
this.showMessage(this.loadingMessage);
}
this._pending_requests[_9a]=true;
try{
if(this.items){
var _9c=this.items;
var _9d=this.store;
this.rowsPerPage=_9c.length;
var req={start:_9a,count:this.rowsPerPage,isRender:_9b};
this._onFetchBegin(_9c.length,req);
var _9e=0;
_74.forEach(_9c,function(i){
if(!_9d.isItemLoaded(i)){
_9e++;
}
});
if(_9e===0){
this._onFetchComplete(_9c,req);
}else{
var _9f=function(_a0){
_9e--;
if(_9e===0){
this._onFetchComplete(_9c,req);
}
};
_74.forEach(_9c,function(i){
if(!_9d.isItemLoaded(i)){
_9d.loadItem({item:i,onItem:_9f,scope:this});
}
},this);
}
}else{
this.store.fetch({start:_9a,count:this.rowsPerPage,query:this.query,sort:this.getSortProps(),queryOptions:this.queryOptions,isRender:_9b,onBegin:_75.hitch(this,"_onFetchBegin"),onComplete:_75.hitch(this,"_onFetchComplete"),onError:_75.hitch(this,"_onFetchError")});
}
}
catch(e){
this._onFetchError(e,{start:_9a,count:this.rowsPerPage});
}
}
},_clearData:function(){
this.updateRowCount(0);
this._by_idty={};
this._by_idx=[];
this._pages=[];
this._bop=this._eop=-1;
this._isLoaded=false;
this._isLoading=false;
},getItem:function(idx){
var _a1=this._by_idx[idx];
if(!_a1||(_a1&&!_a1.item)){
this._preparePage(idx);
return null;
}
return _a1.item;
},getItemIndex:function(_a2){
return this._getItemIndex(_a2,false);
},_getItemIndex:function(_a3,_a4){
if(!_a4&&!this.store.isItem(_a3)){
return -1;
}
var _a5=this._hasIdentity?this.store.getIdentity(_a3):null;
for(var i=0,l=this._by_idx.length;i<l;i++){
var d=this._by_idx[i];
if(d&&((_a5&&d.idty==_a5)||(d.item===_a3))){
return i;
}
}
return -1;
},filter:function(_a6,_a7){
this.query=_a6;
if(_a7){
this._clearData();
}
this._fetch();
},_getItemAttr:function(idx,_a8){
var _a9=this.getItem(idx);
return (!_a9?this.fetchText:this.store.getValue(_a9,_a8));
},_render:function(){
if(this.domNode.parentNode){
this.scroller.init(this.get("rowCount"),this.keepRows,this.rowsPerPage);
this.prerender();
this._fetch(0,true);
}
},_requestsPending:function(_aa){
return this._pending_requests[_aa];
},_rowToPage:function(_ab){
return (this.rowsPerPage?Math.floor(_ab/this.rowsPerPage):_ab);
},_pageToRow:function(_ac){
return (this.rowsPerPage?this.rowsPerPage*_ac:_ac);
},_preparePage:function(_ad){
if((_ad<this._bop||_ad>=this._eop)&&!this._addingItem){
var _ae=this._rowToPage(_ad);
this._needPage(_ae);
this._bop=_ae*this.rowsPerPage;
this._eop=this._bop+(this.rowsPerPage||this.get("rowCount"));
}
},_needPage:function(_af){
if(!this._pages[_af]){
this._pages[_af]=true;
this._requestPage(_af);
}
},_requestPage:function(_b0){
var row=this._pageToRow(_b0);
var _b1=Math.min(this.rowsPerPage,this.get("rowCount")-row);
if(_b1>0){
this._requests++;
if(!this._requestsPending(row)){
setTimeout(_75.hitch(this,"_fetch",row,false),1);
}
}
},getCellName:function(_b2){
return _b2.field;
},_refresh:function(_b3){
this._clearData();
this._fetch(0,_b3);
},sort:function(){
this.edit.apply();
this._lastScrollTop=this.scrollTop;
this._refresh();
},canSort:function(){
return (!this._isLoading);
},getSortProps:function(){
var c=this.getCell(this.getSortIndex());
if(!c){
if(this.sortFields){
return this.sortFields;
}
return null;
}else{
var _b4=c["sortDesc"];
var si=!(this.sortInfo>0);
if(typeof _b4=="undefined"){
_b4=si;
}else{
_b4=si?!_b4:_b4;
}
return [{attribute:c.field,descending:_b4}];
}
},styleRowState:function(_b5){
if(this.store&&this.store.getState){
var _b6=this.store.getState(_b5.index),c="";
for(var i=0,ss=["inflight","error","inserting"],s;s=ss[i];i++){
if(_b6[s]){
c=" dojoxGridRow-"+s;
break;
}
}
_b5.customClasses+=c;
}
},onStyleRow:function(_b7){
this.styleRowState(_b7);
this.inherited(arguments);
},canEdit:function(_b8,_b9){
return this._canEdit;
},_copyAttr:function(idx,_ba){
var row={};
var _bb={};
var src=this.getItem(idx);
return this.store.getValue(src,_ba);
},doStartEdit:function(_bc,_bd){
if(!this._cache[_bd]){
this._cache[_bd]=this._copyAttr(_bd,_bc.field);
}
this.onStartEdit(_bc,_bd);
},doApplyCellEdit:function(_be,_bf,_c0){
this.store.fetchItemByIdentity({identity:this._by_idx[_bf].idty,onItem:_75.hitch(this,function(_c1){
var _c2=this.store.getValue(_c1,_c0);
if(typeof _c2=="number"){
_be=isNaN(_be)?_be:parseFloat(_be);
}else{
if(typeof _c2=="boolean"){
_be=_be=="true"?true:_be=="false"?false:_be;
}else{
if(_c2 instanceof Date){
var _c3=new Date(_be);
_be=isNaN(_c3.getTime())?_be:_c3;
}
}
}
this.store.setValue(_c1,_c0,_be);
this.onApplyCellEdit(_be,_bf,_c0);
})});
},doCancelEdit:function(_c4){
var _c5=this._cache[_c4];
if(_c5){
this.updateRow(_c4);
delete this._cache[_c4];
}
this.onCancelEdit.apply(this,arguments);
},doApplyEdit:function(_c6,_c7){
var _c8=this._cache[_c6];
this.onApplyEdit(_c6);
},removeSelectedRows:function(){
if(this._canEdit){
this.edit.apply();
var fx=_75.hitch(this,function(_c9){
if(_c9.length){
_74.forEach(_c9,this.store.deleteItem,this.store);
this.selection.clear();
}
});
if(this.allItemsSelected){
this.store.fetch({query:this.query,queryOptions:this.queryOptions,onComplete:fx});
}else{
fx(this.selection.getSelected());
}
}
}});
_7b.cell_markupFactory=function(_ca,_cb,_cc){
var _cd=_75.trim(_7a.attr(_cb,"field")||"");
if(_cd){
_cc.field=_cd;
}
_cc.field=_cc.field||_cc.name;
var _ce=_75.trim(_7a.attr(_cb,"fields")||"");
if(_ce){
_cc.fields=_ce.split(",");
}
if(_ca){
_ca(_cb,_cc);
}
};
_7b.markupFactory=function(_cf,_d0,_d1,_d2){
return _78.markupFactory(_cf,_d0,_d1,_75.partial(_7b.cell_markupFactory,_d2));
};
return _7b;
});
},"davinci/review/model/ReviewTreeModel":function(){
define(["dojo/_base/declare","davinci/Runtime","davinci/model/Path","davinci/review/model/Resource"],function(_d3,_d4,_d5,_d6){
return _d3("davinci.review.model.ReviewTreeModel",null,{foldersOnly:false,constructor:function(_d7){
this.root=_d6.getRoot();
this.subscription=[dojo.subscribe("/davinci/review/resourceChanged",this,this.resourceChanged)];
},destroy:function(){
this.subscriptions.forEach(dojo.unsubscribe);
},getRoot:function(_d8){
_d8(this.root);
},mayHaveChildren:function(_d9){
return _d9.elementType=="ReviewVersion"&&!_d9.isDraft;
},getChildren:function(_da,_db,_dc){
_da.getChildren(_db,_dc);
},getIdentity:function(_dd){
return _dd.getPath();
},resourceChanged:function(_de,_df,_e0){
if(_e0){
if(_e0._isLoaded){
_e0.getChildren(function(_e1){
_e1.forEach(this.onDelete,this);
}.bind(this),true);
}
this.onDelete(_e0);
}
var _e2=this.root;
_e2._isLoaded=false;
_e2.getChildren(function(_e3){
this.onChildrenChange(_e2,_e3);
}.bind(this));
},getLabel:function(_e4){
var _e5=_e4.getName();
if(_e4.elementType=="ReviewVersion"&&_e4.isDraft){
_e5+=" (Draft)";
}
if(_e4.elementType=="ReviewFile"){
var _e6=new _d5(_e5);
var _e7=_e6.getSegments();
var _e8=_d4.getExtension("davinci.editor",function(_e9){
return _e9.id==="davinci.review.CommentReviewEditor";
});
var _ea="."+_e8.extensions;
_e5=_e7[_e7.length-1]+_ea;
}
return _e5;
},newItem:function(_eb,_ec){
},pasteItem:function(_ed,_ee,_ef,_f0){
},onChange:function(_f1){
},onDelete:function(_f2){
},onChildrenChange:function(_f3,_f4){
}});
});
},"dojox/grid/_FocusManager":function(){
define(["dojo/_base/array","dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/_base/event","dojo/_base/sniff","dojo/query","./util","dojo/_base/html"],function(_f5,_f6,_f7,_f8,_f9,has,_fa,_fb,_fc){
return _f7("dojox.grid._FocusManager",null,{constructor:function(_fd){
this.grid=_fd;
this.cell=null;
this.rowIndex=-1;
this._connects=[];
this._headerConnects=[];
this.headerMenu=this.grid.headerMenu;
this._connects.push(_f8.connect(this.grid.domNode,"onfocus",this,"doFocus"));
this._connects.push(_f8.connect(this.grid.domNode,"onblur",this,"doBlur"));
this._connects.push(_f8.connect(this.grid.domNode,"mousedown",this,"_mouseDown"));
this._connects.push(_f8.connect(this.grid.domNode,"mouseup",this,"_mouseUp"));
this._connects.push(_f8.connect(this.grid.domNode,"oncontextmenu",this,"doContextMenu"));
this._connects.push(_f8.connect(this.grid.lastFocusNode,"onfocus",this,"doLastNodeFocus"));
this._connects.push(_f8.connect(this.grid.lastFocusNode,"onblur",this,"doLastNodeBlur"));
this._connects.push(_f8.connect(this.grid,"_onFetchComplete",this,"_delayedCellFocus"));
this._connects.push(_f8.connect(this.grid,"postrender",this,"_delayedHeaderFocus"));
},destroy:function(){
_f5.forEach(this._connects,_f8.disconnect);
_f5.forEach(this._headerConnects,_f8.disconnect);
delete this.grid;
delete this.cell;
},_colHeadNode:null,_colHeadFocusIdx:null,_contextMenuBindNode:null,tabbingOut:false,focusClass:"dojoxGridCellFocus",focusView:null,initFocusView:function(){
this.focusView=this.grid.views.getFirstScrollingView()||this.focusView||this.grid.views.views[0];
this._initColumnHeaders();
},isFocusCell:function(_fe,_ff){
return (this.cell==_fe)&&(this.rowIndex==_ff);
},isLastFocusCell:function(){
if(this.cell){
return (this.rowIndex==this.grid.rowCount-1)&&(this.cell.index==this.grid.layout.cellCount-1);
}
return false;
},isFirstFocusCell:function(){
if(this.cell){
return (this.rowIndex===0)&&(this.cell.index===0);
}
return false;
},isNoFocusCell:function(){
return (this.rowIndex<0)||!this.cell;
},isNavHeader:function(){
return (!!this._colHeadNode);
},getHeaderIndex:function(){
if(this._colHeadNode){
return _f5.indexOf(this._findHeaderCells(),this._colHeadNode);
}else{
return -1;
}
},_focusifyCellNode:function(_100){
var n=this.cell&&this.cell.getNode(this.rowIndex);
if(n){
_fc.toggleClass(n,this.focusClass,_100);
if(_100){
var sl=this.scrollIntoView();
try{
if(has("webkit")||!this.grid.edit.isEditing()){
_fb.fire(n,"focus");
if(sl){
this.cell.view.scrollboxNode.scrollLeft=sl;
}
}
}
catch(e){
}
}
}
},_delayedCellFocus:function(){
if(this.isNavHeader()||!this.grid.focused){
return;
}
var n=this.cell&&this.cell.getNode(this.rowIndex);
if(n){
try{
if(!this.grid.edit.isEditing()){
_fc.toggleClass(n,this.focusClass,true);
if(this._colHeadNode){
this.blurHeader();
}
_fb.fire(n,"focus");
}
}
catch(e){
}
}
},_delayedHeaderFocus:function(){
if(this.isNavHeader()){
this.focusHeader();
}
},_initColumnHeaders:function(){
_f5.forEach(this._headerConnects,_f8.disconnect);
this._headerConnects=[];
var _101=this._findHeaderCells();
for(var i=0;i<_101.length;i++){
this._headerConnects.push(_f8.connect(_101[i],"onfocus",this,"doColHeaderFocus"));
this._headerConnects.push(_f8.connect(_101[i],"onblur",this,"doColHeaderBlur"));
}
},_findHeaderCells:function(){
var _102=_fa("th",this.grid.viewsHeaderNode);
var _103=[];
for(var i=0;i<_102.length;i++){
var _104=_102[i];
var _105=_fc.hasAttr(_104,"tabIndex");
var _106=_fc.attr(_104,"tabIndex");
if(_105&&_106<0){
_103.push(_104);
}
}
return _103;
},_setActiveColHeader:function(_107,_108,_109){
this.grid.domNode.setAttribute("aria-activedescendant",_107.id);
if(_109!=null&&_109>=0&&_109!=_108){
_fc.toggleClass(this._findHeaderCells()[_109],this.focusClass,false);
}
_fc.toggleClass(_107,this.focusClass,true);
this._colHeadNode=_107;
this._colHeadFocusIdx=_108;
this._scrollHeader(this._colHeadFocusIdx);
},scrollIntoView:function(){
var info=(this.cell?this._scrollInfo(this.cell):null);
if(!info||!info.s){
return null;
}
var rt=this.grid.scroller.findScrollTop(this.rowIndex);
if(info.n&&info.sr){
if(info.n.offsetLeft+info.n.offsetWidth>info.sr.l+info.sr.w){
info.s.scrollLeft=info.n.offsetLeft+info.n.offsetWidth-info.sr.w;
}else{
if(info.n.offsetLeft<info.sr.l){
info.s.scrollLeft=info.n.offsetLeft;
}
}
}
if(info.r&&info.sr){
if(rt+info.r.offsetHeight>info.sr.t+info.sr.h){
this.grid.setScrollTop(rt+info.r.offsetHeight-info.sr.h);
}else{
if(rt<info.sr.t){
this.grid.setScrollTop(rt);
}
}
}
return info.s.scrollLeft;
},_scrollInfo:function(cell,_10a){
if(cell){
var cl=cell,sbn=cl.view.scrollboxNode,sbnr={w:sbn.clientWidth,l:sbn.scrollLeft,t:sbn.scrollTop,h:sbn.clientHeight},rn=cl.view.getRowNode(this.rowIndex);
return {c:cl,s:sbn,sr:sbnr,n:(_10a?_10a:cell.getNode(this.rowIndex)),r:rn};
}
return null;
},_scrollHeader:function(_10b){
var info=null;
if(this._colHeadNode){
var cell=this.grid.getCell(_10b);
if(!cell){
return;
}
info=this._scrollInfo(cell,cell.getNode(0));
}
if(info&&info.s&&info.sr&&info.n){
var _10c=info.sr.l+info.sr.w;
if(info.n.offsetLeft+info.n.offsetWidth>_10c){
info.s.scrollLeft=info.n.offsetLeft+info.n.offsetWidth-info.sr.w;
}else{
if(info.n.offsetLeft<info.sr.l){
info.s.scrollLeft=info.n.offsetLeft;
}else{
if(has("ie")<=7&&cell&&cell.view.headerNode){
cell.view.headerNode.scrollLeft=info.s.scrollLeft;
}
}
}
}
},_isHeaderHidden:function(){
var _10d=this.focusView;
if(!_10d){
for(var i=0,_10e;(_10e=this.grid.views.views[i]);i++){
if(_10e.headerNode){
_10d=_10e;
break;
}
}
}
return (_10d&&_fc.getComputedStyle(_10d.headerNode).display=="none");
},colSizeAdjust:function(e,_10f,_110){
var _111=this._findHeaderCells();
var view=this.focusView;
if(!view||!view.header.tableMap.map){
for(var i=0,_112;(_112=this.grid.views.views[i]);i++){
if(_112.header.tableMap.map){
view=_112;
break;
}
}
}
var _113=_111[_10f];
if(!view||(_10f==_111.length-1&&_10f===0)){
return;
}
view.content.baseDecorateEvent(e);
e.cellNode=_113;
e.cellIndex=view.content.getCellNodeIndex(e.cellNode);
e.cell=(e.cellIndex>=0?this.grid.getCell(e.cellIndex):null);
if(view.header.canResize(e)){
var _114={l:_110};
var drag=view.header.colResizeSetup(e,false);
view.header.doResizeColumn(drag,null,_114);
view.update();
}
},styleRow:function(_115){
return;
},setFocusIndex:function(_116,_117){
this.setFocusCell(this.grid.getCell(_117),_116);
},setFocusCell:function(_118,_119){
if(_118&&!this.isFocusCell(_118,_119)){
this.tabbingOut=false;
if(this._colHeadNode){
this.blurHeader();
}
this._colHeadNode=this._colHeadFocusIdx=null;
this.focusGridView();
this._focusifyCellNode(false);
this.cell=_118;
this.rowIndex=_119;
this._focusifyCellNode(true);
}
if(has("opera")){
setTimeout(_f6.hitch(this.grid,"onCellFocus",this.cell,this.rowIndex),1);
}else{
this.grid.onCellFocus(this.cell,this.rowIndex);
}
},next:function(){
if(this.cell){
var row=this.rowIndex,col=this.cell.index+1,cc=this.grid.layout.cellCount-1,rc=this.grid.rowCount-1;
if(col>cc){
col=0;
row++;
}
if(row>rc){
col=cc;
row=rc;
}
if(this.grid.edit.isEditing()){
var _11a=this.grid.getCell(col);
if(!this.isLastFocusCell()&&(!_11a.editable||this.grid.canEdit&&!this.grid.canEdit(_11a,row))){
this.cell=_11a;
this.rowIndex=row;
this.next();
return;
}
}
this.setFocusIndex(row,col);
}
},previous:function(){
if(this.cell){
var row=(this.rowIndex||0),col=(this.cell.index||0)-1;
if(col<0){
col=this.grid.layout.cellCount-1;
row--;
}
if(row<0){
row=0;
col=0;
}
if(this.grid.edit.isEditing()){
var _11b=this.grid.getCell(col);
if(!this.isFirstFocusCell()&&!_11b.editable){
this.cell=_11b;
this.rowIndex=row;
this.previous();
return;
}
}
this.setFocusIndex(row,col);
}
},move:function(_11c,_11d){
var _11e=_11d<0?-1:1;
if(this.isNavHeader()){
var _11f=this._findHeaderCells();
var _120=currentIdx=_f5.indexOf(_11f,this._colHeadNode);
currentIdx+=_11d;
while(currentIdx>=0&&currentIdx<_11f.length&&_11f[currentIdx].style.display=="none"){
currentIdx+=_11e;
}
if((currentIdx>=0)&&(currentIdx<_11f.length)){
this._setActiveColHeader(_11f[currentIdx],currentIdx,_120);
}
}else{
if(this.cell){
var sc=this.grid.scroller,r=this.rowIndex,rc=this.grid.rowCount-1,row=Math.min(rc,Math.max(0,r+_11c));
if(_11c){
if(_11c>0){
if(row>sc.getLastPageRow(sc.page)){
this.grid.setScrollTop(this.grid.scrollTop+sc.findScrollTop(row)-sc.findScrollTop(r));
}
}else{
if(_11c<0){
if(row<=sc.getPageRow(sc.page)){
this.grid.setScrollTop(this.grid.scrollTop-sc.findScrollTop(r)-sc.findScrollTop(row));
}
}
}
}
var cc=this.grid.layout.cellCount-1,i=this.cell.index,col=Math.min(cc,Math.max(0,i+_11d));
var cell=this.grid.getCell(col);
while(col>=0&&col<cc&&cell&&cell.hidden===true){
col+=_11e;
cell=this.grid.getCell(col);
}
if(!cell||cell.hidden===true){
col=i;
}
var n=cell.getNode(row);
if(!n&&_11c){
if((row+_11c)>=0&&(row+_11c)<=rc){
this.move(_11c>0?++_11c:--_11c,_11d);
}
return;
}else{
if((!n||_fc.style(n,"display")==="none")&&_11d){
if((col+_11d)>=0&&(col+_11d)<=cc){
this.move(_11c,_11d>0?++_11d:--_11d);
}
return;
}
}
this.setFocusIndex(row,col);
if(_11c){
this.grid.updateRow(r);
}
}
}
},previousKey:function(e){
if(this.grid.edit.isEditing()){
_f9.stop(e);
this.previous();
}else{
if(!this.isNavHeader()&&!this._isHeaderHidden()){
this.grid.domNode.focus();
_f9.stop(e);
}else{
this.tabOut(this.grid.domNode);
if(this._colHeadFocusIdx!=null){
_fc.toggleClass(this._findHeaderCells()[this._colHeadFocusIdx],this.focusClass,false);
this._colHeadFocusIdx=null;
}
this._focusifyCellNode(false);
}
}
},nextKey:function(e){
var _121=(this.grid.rowCount===0);
if(e.target===this.grid.domNode&&this._colHeadFocusIdx==null){
this.focusHeader();
_f9.stop(e);
}else{
if(this.isNavHeader()){
this.blurHeader();
if(!this.findAndFocusGridCell()){
this.tabOut(this.grid.lastFocusNode);
}
this._colHeadNode=this._colHeadFocusIdx=null;
}else{
if(this.grid.edit.isEditing()){
_f9.stop(e);
this.next();
}else{
this.tabOut(this.grid.lastFocusNode);
}
}
}
},tabOut:function(_122){
this.tabbingOut=true;
_122.focus();
},focusGridView:function(){
_fb.fire(this.focusView,"focus");
},focusGrid:function(_123){
this.focusGridView();
this._focusifyCellNode(true);
},findAndFocusGridCell:function(){
var _124=true;
var _125=(this.grid.rowCount===0);
if(this.isNoFocusCell()&&!_125){
var _126=0;
var cell=this.grid.getCell(_126);
if(cell.hidden){
_126=this.isNavHeader()?this._colHeadFocusIdx:0;
}
this.setFocusIndex(0,_126);
}else{
if(this.cell&&!_125){
if(this.focusView&&!this.focusView.rowNodes[this.rowIndex]){
this.grid.scrollToRow(this.rowIndex);
}
this.focusGrid();
}else{
_124=false;
}
}
this._colHeadNode=this._colHeadFocusIdx=null;
return _124;
},focusHeader:function(){
var _127=this._findHeaderCells();
var _128=this._colHeadFocusIdx;
if(this._isHeaderHidden()){
this.findAndFocusGridCell();
}else{
if(!this._colHeadFocusIdx){
if(this.isNoFocusCell()){
this._colHeadFocusIdx=0;
}else{
this._colHeadFocusIdx=this.cell.index;
}
}
}
this._colHeadNode=_127[this._colHeadFocusIdx];
while(this._colHeadNode&&this._colHeadFocusIdx>=0&&this._colHeadFocusIdx<_127.length&&this._colHeadNode.style.display=="none"){
this._colHeadFocusIdx++;
this._colHeadNode=_127[this._colHeadFocusIdx];
}
if(this._colHeadNode&&this._colHeadNode.style.display!="none"){
if(this.headerMenu&&this._contextMenuBindNode!=this.grid.domNode){
this.headerMenu.unBindDomNode(this.grid.viewsHeaderNode);
this.headerMenu.bindDomNode(this.grid.domNode);
this._contextMenuBindNode=this.grid.domNode;
}
this._setActiveColHeader(this._colHeadNode,this._colHeadFocusIdx,_128);
this._scrollHeader(this._colHeadFocusIdx);
this._focusifyCellNode(false);
}else{
this.findAndFocusGridCell();
}
},blurHeader:function(){
_fc.removeClass(this._colHeadNode,this.focusClass);
_fc.removeAttr(this.grid.domNode,"aria-activedescendant");
if(this.headerMenu&&this._contextMenuBindNode==this.grid.domNode){
var _129=this.grid.viewsHeaderNode;
this.headerMenu.unBindDomNode(this.grid.domNode);
this.headerMenu.bindDomNode(_129);
this._contextMenuBindNode=_129;
}
},doFocus:function(e){
if(e&&e.target!=e.currentTarget){
_f9.stop(e);
return;
}
if(this._clickFocus){
return;
}
if(!this.tabbingOut){
this.focusHeader();
}
this.tabbingOut=false;
_f9.stop(e);
},doBlur:function(e){
_f9.stop(e);
},doContextMenu:function(e){
if(!this.headerMenu){
_f9.stop(e);
}
},doLastNodeFocus:function(e){
if(this.tabbingOut){
this._focusifyCellNode(false);
}else{
if(this.grid.rowCount>0){
if(this.isNoFocusCell()){
this.setFocusIndex(0,0);
}
this._focusifyCellNode(true);
}else{
this.focusHeader();
}
}
this.tabbingOut=false;
_f9.stop(e);
},doLastNodeBlur:function(e){
_f9.stop(e);
},doColHeaderFocus:function(e){
this._setActiveColHeader(e.target,_fc.attr(e.target,"idx"),this._colHeadFocusIdx);
this._scrollHeader(this.getHeaderIndex());
_f9.stop(e);
},doColHeaderBlur:function(e){
_fc.toggleClass(e.target,this.focusClass,false);
},_mouseDown:function(e){
this._clickFocus=dojo.some(this.grid.views.views,function(v){
return v.scrollboxNode===e.target;
});
},_mouseUp:function(e){
this._clickFocus=false;
}});
});
},"davinci/de/widgets/NewDijit":function(){
define(["dojo/_base/declare","dijit/_Widget","dijit/_Templated","dojo/text!./templates/NewDijit.html","dijit/form/RadioButton","dijit/form/TextBox","dijit/form/Button"],function(_12a,_12b,_12c,_12d){
return _12a("davinci.de.widgets.NewDijit",[_12b,_12c],{widgetsInTemplate:true,templateString:_12d,_okButton:null,_dijitName:null,_widgetGroup:null,_replaceSelection:null,postMixInProperties:function(){
this.inherited(arguments);
},postCreate:function(){
this.inherited(arguments);
dojo.connect(this._dijitName,"onkeyup",this,"_checkValid");
},_checkValid:function(){
var name=dojo.attr(this._dijitName,"value");
var _12e=(name!=null);
this._okButton.set("disabled",!_12e);
},okButton:function(){
this.value={"name":dojo.attr(this._dijitName,"value"),"replaceSelection":dojo.attr(this._replaceSelection,"checked")};
},_getValueAttr:function(){
return this.value;
},cancelButton:function(){
this.cancel=true;
this.onClose();
},onClose:function(){
}});
});
},"davinci/model/resource/Resource":function(){
define(["dojo/_base/declare","dojo/_base/xhr","dojo/_base/connect","dojo/Deferred","davinci/Runtime","davinci/model/Model","davinci/model/Path"],function(_12f,xhr,_130,_131,_132,_133,Path){
return _12f("davinci.model.resource.Resource",_133,{constructor:function(){
this.elementType="Resource";
this.name="";
this.parent=null;
this._id=dijit.getUniqueId("maqFileResource");
},getName:function(){
return this.name;
},getPath:function(){
if(this.parent){
return this.parent.getPath()+"/"+this.name;
}
return this.name;
},readOnly:function(){
if(this.hasOwnProperty("_readOnly")){
return this._readOnly||(this.parent!=null&&this.parent.readOnly());
}
if(this.parent){
return this.parent.readOnly();
}
return false;
},getURL:function(){
var path=this.getPath();
if(path.indexOf("./")==0){
path=path.substring(2,path.length);
}
var _134=_132.getUserWorkspaceUrl();
return _134+path;
},rename:function(_135){
var _136=new Path(this.getPath()).removeLastSegments().append(_135);
return xhr.get({url:"cmd/rename",handleAs:"text",content:{oldName:this.getPath(),newName:_136.toString()}}).then(function(){
this.name=_135;
_130.publish("/davinci/resource/resourceChanged",["renamed",this]);
}.bind(this));
},getParentFolder:function(){
if(this.elementType=="File"){
return this.parent;
}
return this;
},isVirtual:function(){
return !!this.libraryId;
},visit:function(_137,_138){
var _139=_137.visit(this);
if(!this._isLoaded&&this.elementType=="Folder"&&!_138){
this.getChildren(dojo.hitch(this,function(){
dojo.forEach(this.children,function(_13a){
_13a.visit(_137,_138);
});
}));
}else{
if(this.children&&!_139){
dojo.forEach(this.children,function(_13b){
_13b.visit(_137,_138);
});
}
}
},deleteResource:function(_13c){
var _13d,_13e=function(){
var name=this.getName();
this.parent.children.some(function(_13f,i,_140){
if(_13f.getName()==name){
_140.splice(i,1);
return true;
}
});
_130.publish("/davinci/resource/resourceChanged",["deleted",this]);
}.bind(this);
if(_13c){
_13d=new _131();
_13e();
_13d.resolve();
}else{
_13d=xhr.get({url:"cmd/deleteResource",handleAs:"text",content:{path:this.getPath()}}).then(_13e,function(){
});
}
return _13d;
},getId:function(){
return this._id;
}});
});
},"dijit/_Templated":function(){
define(["./_WidgetBase","./_TemplatedMixin","./_WidgetsInTemplateMixin","dojo/_base/array","dojo/_base/declare","dojo/_base/lang","dojo/_base/kernel"],function(_141,_142,_143,_144,_145,lang,_146){
lang.extend(_141,{waiRole:"",waiState:""});
return _145("dijit._Templated",[_142,_143],{widgetsInTemplate:false,constructor:function(){
_146.deprecated(this.declaredClass+": dijit._Templated deprecated, use dijit._TemplatedMixin and if necessary dijit._WidgetsInTemplateMixin","","2.0");
},_attachTemplateNodes:function(_147,_148){
this.inherited(arguments);
var _149=lang.isArray(_147)?_147:(_147.all||_147.getElementsByTagName("*"));
var x=lang.isArray(_147)?0:-1;
for(;x<_149.length;x++){
var _14a=(x==-1)?_147:_149[x];
var role=_148(_14a,"waiRole");
if(role){
_14a.setAttribute("role",role);
}
var _14b=_148(_14a,"waiState");
if(_14b){
_144.forEach(_14b.split(/\s*,\s*/),function(_14c){
if(_14c.indexOf("-")!=-1){
var pair=_14c.split("-");
_14a.setAttribute("aria-"+pair[0],pair[1]);
}
});
}
}
}});
});
},"davinci/ve/States":function(){
if(typeof davinci==="undefined"){
davinci={};
}
davinci.AppStatesDontInitialize=true;
define(["dojo/_base/declare","dojo/_base/connect","dojo/query","dojo/dom-class","dojo/dom-style","dojo/_base/window","dijit/registry","davinci/Runtime","davinci/Workbench","davinci/maqetta/AppStates","./utils/GeomUtils","./commands/EventCommand","./commands/StyleCommand","davinci/ve/utils/StyleArray","davinci/workbench/Preferences","dojo/i18n!davinci/ve/nls/ve"],function(_14d,_14e,_14f,_150,_151,_152,_153,_154,_155,_156,_157,_158,_159,_15a,_15b,_15c){
var _15d=document;
var _15e=_14d(_156,{_update:function(node,_15f){
if(!_154.currentEditor||_154.currentEditor.declaredClass!="davinci.ve.PageEditor"){
return;
}
if(!node||!node._dvWidget||(!node._maqAppStates&&node._maqDeltas)){
return;
}
var _160=node._dvWidget;
this._refresh(_160);
},_refresh:function(_161){
var _162=_161.getParent();
if(_162.dijitWidget){
this._refresh(_162);
}else{
if(_161&&_161.resize){
_161.resize();
}
}
},_updateEvents:function(node,_163,name){
if(!node||!node._dvWidget){
return;
}
var _164=node._dvWidget;
var _165=["onclick","onmouseover","onmouseout","onfocus","onblur"];
var _166;
for(var i in _165){
var _167=_165[i];
var _168=_164&&_164.properties&&_164.properties[_167];
if(typeof _168=="string"&&_168.indexOf("davinci.states.setState")>=0){
var _169=_168;
_168=_168.replace("'"+_163+"'","'"+name+"'");
if(_168!==_169){
_166=_166||{};
_166[_167]=_168;
}
}
}
var _16a=this.getContext();
if(_16a){
var _16b=new _158(_164,_166);
_16a.getCommandStack().execute(_16b);
}
},normalize:function(type,node,name,_16c){
switch(type){
case "style":
var _16d=this.getStatesListCurrent(node);
for(var i=0;i<_16d.length;i++){
_16d[i]="Normal";
}
var _16e=this.getStyle(node,_16d,name);
if(_16e){
for(var i=0;i<_16e.length;i++){
if(_16e[i][name]){
_16c=_16e[i][name];
}
}
}
break;
}
return _16c;
},normalizeArray:function(type,node,name,_16f){
var _170=dojo.clone(_16f);
switch(type){
case "style":
var _171=this.getStatesListCurrent(node);
for(var i=0;i<_171.length;i++){
_171[i]="Normal";
}
var _172=this.getStyle(node,_171,name);
if(_172){
for(var i=0;i<_172.length;i++){
var _173=_172[i];
for(var _174 in _173){
for(var j=_170.length-1;j>=0;j--){
var _175=_170[j];
for(var _176 in _175){
if(_176==_174){
_170.splice(j,1);
break;
}
}
}
}
}
_170=_170.concat(_172);
}
break;
}
return _170;
},getEditor:function(){
return _154.currentEditor;
},getContext:function(){
var _177=this.getEditor();
return _177&&(_177.getContext&&_177.getContext()||_177.context);
},getDocument:function(){
var _178=this.getContext();
return _178&&_178.getDocument&&_178.getDocument();
},resetState:function(node){
if(!node){
return;
}
var _179=this.getStateContainersForNode(node);
var _17a=this.getFocus(node.ownerDocument.body);
for(var i=0;i<_179.length;i++){
var _17b=_179[i];
var _17c=this.getState(_17b);
var _17d=(_17a&&_17b==_17a.stateContainerNode&&_17c==_17a.state);
this.setState(_17c,_17b,{focus:_17d,updateWhenCurrent:true,silent:false});
}
},_updateSrcState:function(node,_17e){
var _17f=(node&&node._dvWidget);
if(!_17f){
return;
}
var _180=_17f._srcElement.getAttribute(davinci.states.APPSTATES_ATTRIBUTE);
var _181=_17f._srcElement.getAttribute(davinci.states.DELTAS_ATTRIBUTE);
if(_17f&&_17f._srcElement){
var obj=this.serialize(node);
if(obj.maqAppStates){
obj.maqAppStates.trim();
}
if(obj.maqAppStates){
_17f._srcElement.addAttribute(davinci.states.APPSTATES_ATTRIBUTE,obj.maqAppStates);
}else{
_17f._srcElement.removeAttribute(davinci.states.APPSTATES_ATTRIBUTE);
}
if(obj.maqDeltas){
obj.maqDeltas.trim();
}
if(obj.maqDeltas){
_17f._srcElement.addAttribute(davinci.states.DELTAS_ATTRIBUTE,obj.maqDeltas);
}else{
_17f._srcElement.removeAttribute(davinci.states.DELTAS_ATTRIBUTE);
}
var _182=_17f._srcElement.getAttribute(davinci.states.APPSTATES_ATTRIBUTE);
var _183=_17f._srcElement.getAttribute(davinci.states.DELTAS_ATTRIBUTE);
if(_180!==_182||_181!==_183){
var _184=this.getEditor();
if(_184&&_184._visualChanged){
_184._visualChanged(_17e);
}
}
}
},_removeStateFromNodeRecursive:function(node,_185){
var _186=node._dvWidget;
if(!node||!_186||!_185){
return;
}
this._removeStateFromNode(node,_185);
var _187=_186.getChildren();
for(var i=0;i<_187.length;i++){
this._removeStateFromNodeRecursive(_187[i].domNode,_185);
}
},_removeStateFromNode:function(node,_188){
if(node&&node._maqDeltas&&node._maqDeltas[_188]){
delete node._maqDeltas[_188];
var _189=false;
for(var prop in node._maqDeltas){
if(prop!=="undefined"){
_189=true;
break;
}
}
if(!_189){
delete node._maqDeltas;
}
this._updateSrcState(node);
}
},removeUnusedStates:function(_18a){
if(!_18a){
return;
}
var _18b=_18a.getAllWidgets();
for(var i=0;i<_18b.length;i++){
var node=_18b[i].domNode;
if(node.tagName!=="BODY"){
if(node&&node._maqDeltas){
var _18c=this.getAllStatesForNode(node);
for(var _18d in node._maqDeltas){
if(_18d!=="undefined"&&_18c.indexOf(_18d)<0){
this._removeStateFromNode(node,_18d);
}
}
}
}
}
},_getStateIndex:function(_18e){
var _18f;
if(!_18e||_18e=="Normal"||_18e=="undefined"){
_18f="undefined";
}else{
_18f=_18e;
}
return _18f;
},getCurrentStateIndex:function(){
return this._getStateIndex(this.getState());
},getApplyToStateIndex:function(_190){
var _191=this.getState();
var _192;
if(_190==="current"&&_191&&_191!="Normal"&&_191!="undefined"){
_192=_191;
}else{
_192=undefined;
}
return this._getStateIndex(_192);
},getEffectiveDisplayValue:function(_193,_194,_195,_196){
var _197=_194?_194.domNode:null;
var _198="none";
var _199=_195||"undefined";
if(_196&&typeof _196[_199]=="string"&&_196[_199]!="$MAQ_DELETE_PROPERTY$"){
_198=_196[_199];
_19a=true;
}else{
if(_197){
var _19a=false;
if(_197._maqDeltas&&!(_196&&_196[_199]=="$MAQ_DELETE_PROPERTY$")){
var _19b=(_197._maqDeltas[_195]&&_197._maqDeltas[_195].style);
if(_19b){
for(var i=0;i<_19b.length;i++){
var _19c=_19b[i];
for(var prop in _19c){
if(prop=="display"){
_198=_19c[prop];
_19a=true;
}
}
}
}
}
if(!_19a){
if(_196&&typeof _196["undefined"]=="string"){
_198=_196["undefined"];
}else{
var _19d=(_197._maqDeltas&&_197._maqDeltas["undefined"]&&_197._maqDeltas["undefined"].style);
var _19e=false;
if(_19d){
for(var i=0;i<_19d.length;i++){
var _19c=_19d[i];
for(var prop in _19c){
if(prop=="display"){
_198=_19c[prop];
_19e=true;
}
}
}
}
if(!_19e){
_198=_151.get(_197,"display");
}
}
_199="undefined";
}
if(_197.offsetLeft==0&&_197.offsetTop==0&&_197.offsetWidth==0&&_197.offsetHeight==0){
_198="none";
}else{
while(_197&&_197.tagName.toUpperCase()!="BODY"){
if(_197&&_197.ownerDocument&&_197.ownerDocument.defaultView){
var _19f=_151.get(_197,"display");
if(_19f=="none"){
_198="none";
break;
}
}
_197=_197.parentNode;
}
}
}else{
_198="none";
}
}
return {effectiveDisplayValue:_198,effectiveState:_199};
},propertyDefinedForAnyCurrentState:function(node,_1a0){
var _1a1;
var _1a2=node._maqDeltas;
if(_1a2){
var _1a3=this.getStateContainersForNode(node);
outer_loop:
for(var i=_1a3.length-1;i>=0;i--){
var _1a4=_1a3[i];
var _1a5=this.getState(_1a4);
var _1a6=(!_1a5||_1a5==this.NORMAL)?"undefined":_1a5;
var _1a7=_1a2[_1a6]&&_1a2[_1a6].style;
if(_1a7){
for(var s=0;s<_1a7.length;s++){
var o=_1a7[s];
for(var j=0;j<_1a0.length;j++){
if(o.hasOwnProperty(_1a0[j])){
_1a1=_1a5;
break outer_loop;
}
}
}
}
}
}
return _1a1;
},_customStateActive:function(_1a8){
if(!_1a8){
return false;
}
var _1a9=this.getState(_1a8.rootNode);
return _1a9;
},updateStateIcons:function(_1aa){
if(!_1aa||!_1aa.editor||_1aa.editor!=_154.currentEditor||_1aa.editor.declaredClass!="davinci.ve.PageEditor"){
return;
}
_152.withDoc(_15d,function(){
var _1ab=_14f(".manageStatesButton")[0];
var _1ac=_153.byNode(_1ab);
var _1ad=_14f(".manageStatesIcon")[0];
if(_1ac&&_1ad){
if(this.manageStatesActive(_1aa)){
_150.remove(_1ad,"manageStatesIconDisabled");
_1ac.set("disabled",false);
}else{
_150.add(_1ad,"manageStatesIconDisabled");
_1ac.set("disabled",true);
}
}
var _1ae=_15b.getPreferences("davinci.ve.editorPrefs",davinci.Workbench.getProject());
var _1af=_1ae.newWidgetsCurrentState;
var _1b0=_14f(".newWidgetsCurrentStateButton")[0];
var _1b1=_153.byNode(_1b0);
var _1ad=_14f(".newWidgetsCurrentStateIcon")[0];
if(_1b1&&_1ad){
if(this.newWidgetsCurrentStateActive(_1aa)){
_150.remove(_1ad,"newWidgetsCurrentStateIconDisabled");
}else{
_150.add(_1ad,"newWidgetsCurrentStateIconDisabled");
}
if(_1af){
_150.remove(_1ad,"newWidgetsCurrentStateIconOff");
_150.add(_1ad,"newWidgetsCurrentStateIconOn");
_1b1.set("title",_15c.NewWidgetsCurrentStateTitleCurrentState);
}else{
_150.remove(_1ad,"newWidgetsCurrentStateIconOn");
_150.add(_1ad,"newWidgetsCurrentStateIconOff");
_1b1.set("title",_15c.NewWidgetsCurrentStateTitleBackground);
}
}
}.bind(this));
},manageStatesActive:function(_1b2){
return _1b2&&_1b2.getSelection().length;
},newWidgetsCurrentStateActive:function(_1b3){
return this._customStateActive(_1b3);
},highlightBaseWidgetsActive:function(_1b4){
return this._customStateActive(_1b4);
},updateHighlightsBaseStateWidgets:function(_1b5){
setTimeout(function(){
if(!_1b5||!_1b5.editor||_1b5.editor!=_154.currentEditor||_1b5.editor.declaredClass!="davinci.ve.PageEditor"){
return;
}
_152.withDoc(_15d,function(){
var _1b6=_15b.getPreferences("davinci.ve.editorPrefs",davinci.Workbench.getProject());
var _1b7=_1b6.highlightBaseWidgets;
var _1b8=this.highlightBaseWidgetsActive(_1b5);
var _1b9=_14f(".highlightBaseWidgetsButton")[0];
var _1ba=_153.byNode(_1b9);
var _1bb=_14f(".highlightBaseWidgetsIcon")[0];
if(_1ba&&_1bb){
if(_1b8){
_150.remove(_1bb,"highlightBaseWidgetsIconDisabled");
}else{
_150.add(_1bb,"highlightBaseWidgetsIconDisabled");
}
if(_1b7){
_150.add(_1bb,"highlightBaseWidgetsIconOn");
_150.remove(_1bb,"highlightBaseWidgetsIconOff");
}else{
_150.add(_1bb,"highlightBaseWidgetsIconOff");
_150.remove(_1bb,"highlightBaseWidgetsIconOn");
}
}
var _1bc=this.getState(_1b5.rootNode);
var _1bd=dojo.byId("focusContainer");
if(_1bd){
var _1be=_14f(".maqBaseStateShiningThrough",_1bd);
for(var i=0;i<_1be.length;i++){
var div=_1be[i];
div.parentNode.removeChild(div);
}
if(_1bc&&_1b7){
var _1bf=_1b5.getAllWidgets();
var _1c0=[];
for(var i=0;i<_1bf.length;i++){
var _1c1=_1bf[i];
if(_1c1.domNode&&_1c1.domNode.tagName&&_1c1.domNode.tagName.toUpperCase()=="BODY"){
continue;
}
var obj=this.getEffectiveDisplayValue(_1b5,_1c1,_1bc);
var _1c2=obj.effectiveDisplayValue;
var _1c3=obj.effectiveState;
if(_1c2!="none"&&_1c3=="undefined"){
_1c0.push(_1c1);
}
}
var doc=_1b5.getDocument();
var _1c4=_157.getBorderBoxPageCoords(_1bd);
var _1c5=_1b5.getParentIframe();
var _1c6=_157.getBorderBoxPageCoords(_1c5);
var _1c7=_1c6.l-_1c4.l;
var _1c8=_1c6.t-_1c4.t;
var _1c9=doc.body;
var _1ca=_157.getScrollLeft(_1c9);
var _1cb=_157.getScrollTop(_1c9);
for(var j=0;j<_1c0.length;j++){
var _1cc=_1c0[j].domNode;
if(_1cc){
var rect=_157.getBorderBoxPageCoords(_1cc);
rect.l+=(_1c7-_1ca);
rect.t+=(_1c8-_1cb);
var div=doc.createElement("div");
div.className="maqBaseStateShiningThrough";
div.style.left=rect.l+"px";
div.style.top=rect.t+"px";
div.style.width=rect.w+"px";
div.style.height=rect.h+"px";
_1bd.appendChild(div);
}
}
}
}
}.bind(this));
}.bind(this),10);
},initialize:function(){
if(!this.subscribed){
_14e.subscribe("/maqetta/appstates/state/changed",dojo.hitch(this,function(e){
var _1cd=this.getEditor();
if(!dojo.isObject(e.node)||!_1cd||_1cd.declaredClass!="davinci.ve.PageEditor"){
return;
}
dojo.publish("/maqetta/appstates/state/changed/start",[e]);
var _1ce=(e.node&&e.node._dvWidget);
var _1ce=(_1ce==this.getContext().rootWidget)?_1ce:_1ce.getParent();
var n=_1ce.domNode;
var _1cf=davinci.states._getChildrenOfNode(n);
while(_1cf.length){
var _1d0=_1cf.shift();
if(!this.isContainer(_1d0)){
_1cf=_1cf.concat(davinci.states._getChildrenOfNode(_1d0));
}
var _1d1=this.getStatesArray(_1d0,e.oldState,e.newState,e.stateContainerNode);
this._update(_1d0,_1d1);
}
dojo.publish("/maqetta/appstates/state/changed/end",[e]);
var _1d2=this.getContext();
if(_1d2){
_1d2.clearCachedWidgetBounds();
_1d2.updateFocusAll();
this.updateStateIcons(_1d2);
}
}));
_14e.subscribe("/davinci/states/state/renamed",dojo.hitch(this,function(e){
var _1d3=this.getEditor();
if(!_1d3||_1d3.declaredClass=="davinci.themeEditor.ThemeEditor"){
return;
}
var _1d4=(e.node&&e.node._dvWidget);
var _1d5=davinci.states._getChildrenOfNode(e.node);
while(_1d5.length){
var _1d6=_1d5.shift();
if(!this.isContainer(_1d6)){
_1d5=_1d5.concat(davinci.states._getChildrenOfNode(_1d6));
}
this.rename(_1d6,e.oldName,e.newName,true);
this._updateEvents(_1d6,e.oldName,e.newName);
}
var _1d7=this.getState(e.stateContainerNode);
if(_1d7===e.oldName){
this.setState(e.newName,e.stateContainerNode,{updateWhenCurrent:false,silent:true});
}
}));
_14e.subscribe("/davinci/states/state/style/changed",dojo.hitch(this,function(e){
var _1d8=this.getState();
if(_1d8==e.state){
var _1d9=this.findStateContainer(e.node,e.state);
var _1da=this.getStatesArray(e.node,e.state,e.state,_1d9);
this._update(e.node,_1da);
}
}));
_14e.subscribe("/davinci/ui/widget/replaced",dojo.hitch(this,function(_1db,_1dc){
var _1dd=this.getState();
if(_1dd){
var _1de=this.findStateContainer(_1db.domNode,_1dd);
var _1df=this.getStatesArray(_1db.domNode,_1dd,_1dd,_1de);
this._update(_1db.domNode,_1df);
}
}));
_14e.subscribe("/davinci/states/state/removed",dojo.hitch(this,function(_1e0){
if(!_1e0){
return;
}
this._removeStateFromNodeRecursive(_1e0.node,_1e0.state);
}));
_14e.subscribe("/davinci/ui/context/statesLoaded",dojo.hitch(this,function(){
var _1e1=this.getContext();
_1e1.updateFocusAll();
this.updateStateIcons(_1e1);
}));
_14e.subscribe("/davinci/ui/context/statesLoaded",dojo.hitch(this,function(){
var _1e2=this.getContext();
_1e2.updateFocusAll();
this.updateStateIcons(_1e2);
}));
_14e.subscribe("/davinci/ui/widgetSelected",dojo.hitch(this,function(){
var _1e3=this.getContext();
this.updateStateIcons(_1e3);
}));
this.subscribed=true;
}
}});
davinci.ve.states=new _15e();
davinci.ve.states.initialize();
return davinci.ve.states;
});
},"davinci/css":function(){
define(["dojo/_base/window","dojo/dom-construct","dojo/dom-attr"],function(_1e4,_1e5){
var head=_1e4.doc.getElementsByTagName("head")[0],_1e6={};
return {load:function(id,_1e7,_1e8){
var url=_1e7.toUrl(id);
if(url in _1e6){
_1e8();
return;
}
_1e5.create("link",{rel:"stylesheet",type:"text/css",href:url},head);
_1e6[url]=1;
_1e8();
}};
});
},"url:dijit/form/templates/ComboButton.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tcellspacing='0' cellpadding='0' role=\"presentation\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonNode\" data-dojo-attach-point=\"buttonNode\" data-dojo-attach-event=\"ondijitclick:_onClick,onkeypress:_onButtonKeyPress\"\n\t\t><div id=\"${id}_button\" class=\"dijitReset dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><div class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitInline dijitButtonText\" id=\"${id}_label\" data-dojo-attach-point=\"containerNode\" role=\"presentation\"></div\n\t\t></div\n\t\t></td\n\t\t><td id=\"${id}_arrow\" class='dijitReset dijitRight dijitButtonNode dijitArrowButton'\n\t\t\tdata-dojo-attach-point=\"_popupStateNode,focusNode,_buttonNode\"\n\t\t\tdata-dojo-attach-event=\"onkeypress:_onArrowKeyPress\"\n\t\t\ttitle=\"${optionsTitle}\"\n\t\t\trole=\"button\" aria-haspopup=\"true\"\n\t\t\t><div class=\"dijitReset dijitArrowButtonInner\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitArrowButtonChar\" role=\"presentation\">&#9660;</div\n\t\t></td\n\t\t><td style=\"display:none !important;\"\n\t\t\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" data-dojo-attach-point=\"valueNode\" role=\"presentation\"\n\t\t/></td></tr></tbody\n></table>\n","dijit/DialogUnderlay":function(){
define(["dojo/_base/declare","dojo/dom-attr","dojo/window","./_Widget","./_TemplatedMixin","./BackgroundIframe"],function(_1e9,_1ea,_1eb,_1ec,_1ed,_1ee){
return _1e9("dijit.DialogUnderlay",[_1ec,_1ed],{templateString:"<div class='dijitDialogUnderlayWrapper'><div class='dijitDialogUnderlay' data-dojo-attach-point='node'></div></div>",dialogId:"","class":"",_setDialogIdAttr:function(id){
_1ea.set(this.node,"id",id+"_underlay");
this._set("dialogId",id);
},_setClassAttr:function(_1ef){
this.node.className="dijitDialogUnderlay "+_1ef;
this._set("class",_1ef);
},postCreate:function(){
this.ownerDocumentBody.appendChild(this.domNode);
},layout:function(){
var is=this.node.style,os=this.domNode.style;
os.display="none";
var _1f0=_1eb.getBox(this.ownerDocument);
os.top=_1f0.t+"px";
os.left=_1f0.l+"px";
is.width=_1f0.w+"px";
is.height=_1f0.h+"px";
os.display="block";
},show:function(){
this.domNode.style.display="block";
this.layout();
this.bgIframe=new _1ee(this.domNode);
},hide:function(){
this.bgIframe.destroy();
delete this.bgIframe;
this.domNode.style.display="none";
}});
});
},"dijit/layout/ScrollingTabController":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/fx","dojo/_base/lang","dojo/on","dojo/query","dojo/sniff","../registry","dojo/text!./templates/ScrollingTabController.html","dojo/text!./templates/_ScrollingTabControllerButton.html","./TabController","./utils","../_WidgetsInTemplateMixin","../Menu","../MenuItem","../form/Button","../_HasDropDown","dojo/NodeList-dom"],function(_1f1,_1f2,_1f3,_1f4,_1f5,fx,lang,on,_1f6,has,_1f7,_1f8,_1f9,_1fa,_1fb,_1fc,Menu,_1fd,_1fe,_1ff){
var _200=_1f2("dijit.layout.ScrollingTabController",[_1fa,_1fc],{baseClass:"dijitTabController dijitScrollingTabController",templateString:_1f8,useMenu:true,useSlider:true,tabStripClass:"",widgetsInTemplate:true,_minScroll:5,_setClassAttr:{node:"containerNode",type:"class"},buildRendering:function(){
this.inherited(arguments);
var n=this.domNode;
this.scrollNode=this.tablistWrapper;
this._initButtons();
if(!this.tabStripClass){
this.tabStripClass="dijitTabContainer"+this.tabPosition.charAt(0).toUpperCase()+this.tabPosition.substr(1).replace(/-.*/,"")+"None";
_1f3.add(n,"tabStrip-disabled");
}
_1f3.add(this.tablistWrapper,this.tabStripClass);
},onStartup:function(){
this.inherited(arguments);
_1f5.set(this.domNode,"visibility","");
this._postStartup=true;
this.own(on(this.containerNode,"attrmodified-label, attrmodified-iconclass",lang.hitch(this,function(evt){
if(this._dim){
this.resize(this._dim);
}
})));
},onAddChild:function(page,_201){
this.inherited(arguments);
_1f5.set(this.containerNode,"width",(_1f5.get(this.containerNode,"width")+200)+"px");
},onRemoveChild:function(page,_202){
var _203=this.pane2button[page.id];
if(this._selectedTab===_203.domNode){
this._selectedTab=null;
}
this.inherited(arguments);
},_initButtons:function(){
this._btnWidth=0;
this._buttons=_1f6("> .tabStripButton",this.domNode).filter(function(btn){
if((this.useMenu&&btn==this._menuBtn.domNode)||(this.useSlider&&(btn==this._rightBtn.domNode||btn==this._leftBtn.domNode))){
this._btnWidth+=_1f4.getMarginSize(btn).w;
return true;
}else{
_1f5.set(btn,"display","none");
return false;
}
},this);
},_getTabsWidth:function(){
var _204=this.getChildren();
if(_204.length){
var _205=_204[this.isLeftToRight()?0:_204.length-1].domNode,_206=_204[this.isLeftToRight()?_204.length-1:0].domNode;
return _206.offsetLeft+_206.offsetWidth-_205.offsetLeft;
}else{
return 0;
}
},_enableBtn:function(_207){
var _208=this._getTabsWidth();
_207=_207||_1f5.get(this.scrollNode,"width");
return _208>0&&_207<_208;
},resize:function(dim){
this._dim=dim;
this.scrollNode.style.height="auto";
var cb=this._contentBox=_1fb.marginBox2contentBox(this.domNode,{h:0,w:dim.w});
cb.h=this.scrollNode.offsetHeight;
_1f4.setContentSize(this.domNode,cb);
var _209=this._enableBtn(this._contentBox.w);
this._buttons.style("display",_209?"":"none");
this._leftBtn.layoutAlign="left";
this._rightBtn.layoutAlign="right";
this._menuBtn.layoutAlign=this.isLeftToRight()?"right":"left";
_1fb.layoutChildren(this.domNode,this._contentBox,[this._menuBtn,this._leftBtn,this._rightBtn,{domNode:this.scrollNode,layoutAlign:"client"}]);
if(this._selectedTab){
if(this._anim&&this._anim.status()=="playing"){
this._anim.stop();
}
this.scrollNode.scrollLeft=this._convertToScrollLeft(this._getScrollForSelectedTab());
}
this._setButtonClass(this._getScroll());
this._postResize=true;
return {h:this._contentBox.h,w:dim.w};
},_getScroll:function(){
return (this.isLeftToRight()||has("ie")<8||(has("ie")&&has("quirks"))||has("webkit"))?this.scrollNode.scrollLeft:_1f5.get(this.containerNode,"width")-_1f5.get(this.scrollNode,"width")+(has("ie")>=8?-1:1)*this.scrollNode.scrollLeft;
},_convertToScrollLeft:function(val){
if(this.isLeftToRight()||has("ie")<8||(has("ie")&&has("quirks"))||has("webkit")){
return val;
}else{
var _20a=_1f5.get(this.containerNode,"width")-_1f5.get(this.scrollNode,"width");
return (has("ie")>=8?-1:1)*(val-_20a);
}
},onSelectChild:function(page){
var tab=this.pane2button[page.id];
if(!tab||!page){
return;
}
var node=tab.domNode;
if(node!=this._selectedTab){
this._selectedTab=node;
if(this._postResize){
var sl=this._getScroll();
if(sl>node.offsetLeft||sl+_1f5.get(this.scrollNode,"width")<node.offsetLeft+_1f5.get(node,"width")){
this.createSmoothScroll().play();
}
}
}
this.inherited(arguments);
},_getScrollBounds:function(){
var _20b=this.getChildren(),_20c=_1f5.get(this.scrollNode,"width"),_20d=_1f5.get(this.containerNode,"width"),_20e=_20d-_20c,_20f=this._getTabsWidth();
if(_20b.length&&_20f>_20c){
return {min:this.isLeftToRight()?0:_20b[_20b.length-1].domNode.offsetLeft,max:this.isLeftToRight()?(_20b[_20b.length-1].domNode.offsetLeft+_20b[_20b.length-1].domNode.offsetWidth)-_20c:_20e};
}else{
var _210=this.isLeftToRight()?0:_20e;
return {min:_210,max:_210};
}
},_getScrollForSelectedTab:function(){
var w=this.scrollNode,n=this._selectedTab,_211=_1f5.get(this.scrollNode,"width"),_212=this._getScrollBounds();
var pos=(n.offsetLeft+_1f5.get(n,"width")/2)-_211/2;
pos=Math.min(Math.max(pos,_212.min),_212.max);
return pos;
},createSmoothScroll:function(x){
if(arguments.length>0){
var _213=this._getScrollBounds();
x=Math.min(Math.max(x,_213.min),_213.max);
}else{
x=this._getScrollForSelectedTab();
}
if(this._anim&&this._anim.status()=="playing"){
this._anim.stop();
}
var self=this,w=this.scrollNode,anim=new fx.Animation({beforeBegin:function(){
if(this.curve){
delete this.curve;
}
var oldS=w.scrollLeft,newS=self._convertToScrollLeft(x);
anim.curve=new fx._Line(oldS,newS);
},onAnimate:function(val){
w.scrollLeft=val;
}});
this._anim=anim;
this._setButtonClass(x);
return anim;
},_getBtnNode:function(e){
var n=e.target;
while(n&&!_1f3.contains(n,"tabStripButton")){
n=n.parentNode;
}
return n;
},doSlideRight:function(e){
this.doSlide(1,this._getBtnNode(e));
},doSlideLeft:function(e){
this.doSlide(-1,this._getBtnNode(e));
},doSlide:function(_214,node){
if(node&&_1f3.contains(node,"dijitTabDisabled")){
return;
}
var _215=_1f5.get(this.scrollNode,"width");
var d=(_215*0.75)*_214;
var to=this._getScroll()+d;
this._setButtonClass(to);
this.createSmoothScroll(to).play();
},_setButtonClass:function(_216){
var _217=this._getScrollBounds();
this._leftBtn.set("disabled",_216<=_217.min);
this._rightBtn.set("disabled",_216>=_217.max);
}});
var _218=_1f2("dijit.layout._ScrollingTabControllerButtonMixin",null,{baseClass:"dijitTab tabStripButton",templateString:_1f9,tabIndex:"",isFocusable:function(){
return false;
}});
_1f2("dijit.layout._ScrollingTabControllerButton",[_1fe,_218]);
_1f2("dijit.layout._ScrollingTabControllerMenuButton",[_1fe,_1ff,_218],{containerId:"",tabIndex:"-1",isLoaded:function(){
return false;
},loadDropDown:function(_219){
this.dropDown=new Menu({id:this.containerId+"_menu",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir});
var _21a=_1f7.byId(this.containerId);
_1f1.forEach(_21a.getChildren(),function(page){
var _21b=new _1fd({id:page.id+"_stcMi",label:page.title,iconClass:page.iconClass,disabled:page.disabled,ownerDocument:this.ownerDocument,dir:page.dir,lang:page.lang,textDir:page.textDir,onClick:function(){
_21a.selectChild(page);
}});
this.dropDown.addChild(_21b);
},this);
_219();
},closeDropDown:function(_21c){
this.inherited(arguments);
if(this.dropDown){
this.dropDown.destroyRecursive();
delete this.dropDown;
}
}});
return _200;
});
},"davinci/html/CSSCombinedSelector":function(){
define(["dojo/_base/declare","davinci/html/CSSElement"],function(_21d,_21e){
return _21d("davinci.html.CSSCombinedSelector",_21e,{constructor:function(){
this.selectors=[];
this.combiners=[];
this.elementType="CSSCombinedSelector";
},matchesSelector:function(_21f){
if(_21f.elementType==this.elementType){
if(_21f.selectors.length==this.selectors.length){
for(var i=0;i<this.selectors.length;i++){
if(this.combiners[i]!=_21f.combiners[i]){
return false;
}
if(!this.selectors[i].matchesSelector(_21f.selectors[i])){
return false;
}
}
return true;
}
}
},getText:function(_220){
var s="";
for(var i=0;i<this.selectors.length-1;i++){
s=s+this.selectors[i].getText(_220);
if(this.combiners[i]!=" "){
s+=" "+this.combiners[i]+" ";
}else{
s+=this.combiners[i];
}
}
s=s+this.selectors[this.selectors.length-1].getText(_220);
return s;
},matches:function(_221){
var _222=this.selectors.length-1;
var _223=0;
for(var i=0;i<_221.length;i++){
var _224;
if((_224=this.selectors[_222].matches(_221,i))>=0){
_223+=_224;
_222--;
if(_222<0){
return _223;
}
}
if(i==0&&_224<0){
return -1;
}
}
},visit:function(_225){
if(!_225.visit(this)){
for(var i=0;i<this.children.length;i++){
this.children[i].visit(_225);
}
for(var i=0;i<this.selectors.length;i++){
this.selectors[i].visit(_225);
}
}
if(_225.endVisit){
_225.endVisit(this);
}
},getCSSRule:function(){
return this.parent;
}});
});
},"davinci/review/model/resource/Folder":function(){
define(["dojo/_base/declare","davinci/model/resource/Resource","davinci/review/model/resource/File","dojo/_base/xhr","dojo/date/stamp"],function(_226,_227,_228,xhr,_229){
return _226("davinci.review.model.resource.Folder",_227,{isDraft:false,closed:false,width:0,height:0,constructor:function(proc){
dojo.mixin(this,proc);
this.elementType="ReviewVersion";
this.dueDate=this.dueDate=="infinite"?this.dueDate:_229.fromISOString(this.dueDate);
},getChildrenSync:function(_22a,sync){
this.getChildren(_22a);
},getChildren:function(_22b,_22c){
if(this._isLoaded){
_22b.call(null,this.children);
}else{
if(this._loading){
this._loading.then(function(){
_22b.call(null,this.children);
}.bind(this),_22c);
}else{
var _22d=this.designerId||"";
this._loading=xhr.get({url:"cmd/listReviewFiles",handleAs:"json",content:{designer:_22d,version:this.timeStamp}}).then(function(_22e,_22f){
this.children=_22e.map(function(file){
return new _228(file.path,this);
},this);
this._isLoaded=true;
_22b.call(null,this.children);
delete this._loading;
}.bind(this),_22c);
}
}
},getPath:function(){
if(this.parent){
return this.parent.getPath()+"/"+this.timeStamp;
}
return this.timeStamp;
}});
});
},"davinci/ve/input/MultiFieldSmartInput":function(){
define(["dojo/_base/declare","dojo/_base/lang","dojo/_base/connect","dojo/dom-style","davinci/Runtime","davinci/ve/input/SmartInput","davinci/ve/widget","davinci/ve/commands/ModifyCommand","dojox/html/entities","dijit/form/DateTextBox","dijit/form/TimeTextBox","dojo/i18n!dijit/nls/common","dojo/text!./templates/MultiFieldSmartInput.html","dojo/text!./templates/MultiFieldTableRowSmartInput.html","dojo/text!./templates/MultiFieldMultiLineTableRowSmartInput.html","dijit/Tooltip","davinci/css!./templates/MultiFieldSmartInput.css"],function(_230,lang,_231,_232,_233,_234,_235,_236,_237,_238,_239,_23a,_23b,_23c,_23d,_23e){
var _23f=_230(_234,{property:[{"property":"placeholder","multiLine":false},{"property":"value","multiLine":false}],displayOnCreate:"true",delimiter:", ",multiLine:"true",supportsHTML:"false",_substitutedMainTemplate:null,destroyTooltips:function(){
this.property.forEach(function(p){
var prop=p.property||p.child.property;
var _240=dijit.byId("MultiFieldSmartInput_SmartInput_checkbox_"+prop+"_tooltip");
_240.destroyRecursive();
}.bind(this));
},_getEditor:function(){
return _233.currentEditor;
},_getContext:function(){
var _241=this._getEditor();
return _241&&(_241.getContext&&_241.getContext()||_241.context);
},getHelpText:function(){
var str="";
if(this.helpText){
str=this.helpText;
}else{
this.property.forEach(function(p){
var prop=p.property||p.child.property;
var _242=this._widget.metadata.property[prop]?this._widget.metadata.property[prop].description:null;
if(p.helpText){
_242=p.helpText;
}
if(_242){
str=str+"<i>"+this.getTitle(prop)+":</i> "+_237.encode(_242)+"<br>";
}
}.bind(this));
}
if(str.length<1){
str="The toolkit provider has not supplied help for this widget, please consult your provider.";
}
return str;
},getTitle:function(prop){
return prop;
},getPropertyObject:function(prop){
for(var i=0;i<this.property.length;i++){
var _243=this.property[i].property||this.property[i].child.property;
if(this.property[i].property&&(this.property[i].property==prop)){
return this.property[i];
}else{
if(this.property[i].child&&(this.property[i].child.property==prop)){
return this.property[i].child;
}
}
}
},onOk:function(e){
var _244=this._getContext();
var _245={};
var _246=null;
this.property.forEach(function(p){
var prop=p.property||p.child.property;
var _247=this._getStringValueOfTextBox(prop);
var _248=dijit.byId("MultiFieldSmartInput_SmartInput_checkbox_"+prop);
if(!p.supportsHTML||!_248.checked){
_247=_237.encode(_247);
}
if(p.child){
_246=this.parseChildren(p,_247);
if(p.property){
_245[p.property]=this.getSelectedOption(this._widget,_246);
}
}else{
_245[p.property]=_247;
}
}.bind(this));
var _249=new _236(this._widget,_245,_246,_244);
_244.getCommandStack().execute(_249);
this.hide();
},parseChildren:function(p,_24a){
var data=this._widget.getData();
var _24b=this.parseItems(_24a);
var _24c=data.children;
for(var i=0;i<_24b.length;i++){
var _24a=_24b[i];
var text=_24a.text;
if(!p.child.supportsHTML){
_24b[i].text=dojox.html.entities.decode(text);
}
if(i<_24c.length){
var _24d=_24c[i];
_24d.children=text;
_24d.properties.value=text;
_24d.properties.selected=_24a.selected;
}else{
_24d={};
_24d.type=p.child.type;
_24d.properties={};
_24d.properties[p.child.property]=text;
if(_24a.selected){
_24d.properties.selected=_24a.selected;
}
_24d.children=text||_24a;
_24c.push(_24d);
}
}
if(_24b.length>0){
var _24e=_24c.length;
for(var i=_24b.length;i<_24e;i++){
_24c.pop();
}
}
return _24c;
},hide:function(){
if(this._inline){
var _24f;
while(connection=this._connection.pop()){
if(connection){
dojo.disconnect(connection);
}
}
var _250=this._findSmartInputContainer(this._widget._edit_context.frameNode);
if(!_250){
return;
}
if(this._loadingDiv){
_250.removeChild(this._loadingDiv);
}
if(this._inline.style.display!="none"){
this._format=this.getFormat();
this._inline.style.display="none";
this.destroyTooltips();
this._inline.destroyRecursive();
delete this._inline;
var _251=_250.ownerDocument.getElementById("iebPointer");
_250.removeChild(_251);
var _252=this._widget.getContext();
var _253=_252.getDocument();
_253.defaultView.focus();
}
}
},show:function(_254){
this._lastKeyCode=0;
this._widget=_235.byId(_254);
var data=this._widget.getData();
var _255=200;
var _256=255;
this._loading(_256,_255);
dojo.addClass("ieb","MultiFieldSmartInput");
var _257=this._getTemplate();
this._inline.attr("content",_257);
this._connection.push(dojo.connect(this._inline,"onBlur",this,"onOk"));
this._connectHelpDiv();
this._connectResizeHandle();
this._connectSimDiv();
if(this._loadingDiv){
this._loadingDiv.style.backgroundImage="none";
}
var prop=this.property[0].property||this.property[0].child.property;
var _258=dijit.byId("MultiFieldSmartInput_SmartInput_"+prop);
dijit.selectInputText(_258.textbox);
_258.focus();
this.connectEditBoxes();
this.setStartSize();
this.resize(null);
},connectEditBoxes:function(){
this.property.forEach(function(p){
var prop=p.property||p.child.property;
var _259=dijit.byId("MultiFieldSmartInput_SmartInput_"+prop);
this._connection.push(dojo.connect(_259,"onMouseDown",this,"stopEvent"));
this._connection.push(dojo.connect(_259,"onKeyUp",this,"handleEvent"));
var _25a=dojo.byId("MultiFieldSmartInput_SmartInput_checkbox_div_"+prop);
_259=dijit.byId("MultiFieldSmartInput_SmartInput_checkbox_"+prop);
this._connection.push(dojo.connect(_259,"onClick",this,"htmlCheckbox"));
new _23e({id:"MultiFieldSmartInput_SmartInput_checkbox_"+prop+"_tooltip",connectId:[_25a],label:"the text for the tooltip"});
this.updateFormats(prop);
}.bind(this));
},containsHtml:function(_25b){
var n=dojo.create("div",{innerHTML:_25b});
var _25c=n.children.length?"html":"text";
return _25c;
},htmlCheckbox:function(e){
var id=e.currentTarget.id.split("_");
var prop=id[id.length-1];
var _25d=dijit.byId("MultiFieldSmartInput_SmartInput_"+prop);
var _25e=dijit.byId(e.currentTarget.id+"_tooltip");
var text=_25d.getValue();
var _25f="html";
if(!e.currentTarget.checked){
text=_237.encode(text);
_25f="text";
}
_25e.attr("label","Format contents as "+_25f+":<br>"+text);
},setStartSize:function(){
var tds=dojo.query(".MultiFieldSmartInput_SmartInput_value","davinci.ve.input.MultiFieldSmartInput_table");
var _260=0;
tds.forEach(function(td){
_260+=td.clientHeight+5;
});
var _261=dojo.byId("iedResizeDiv");
var _262=dijit.byId("iedResizeDiv");
dojo.style("iedResizeDiv","height",_260+5+"px");
dojo.style("iedResizeDiv","minHeight",_260+5+"px");
},handleEvent:function(_263){
var _264=false;
for(var i=0;i<this.property.length;i++){
var p=this.property[i];
var prop=p.property||p.child.property;
if(_263.currentTarget.id.indexOf("MultiFieldSmartInput_SmartInput_"+prop)>-1){
_264=p.multiLine;
break;
}
}
if(_263.keyCode==13){
if(!_264||_264=="false"||this._lastKeyCode==13){
this.onOk();
}
}else{
var x=_263.target.id.split("_");
var prop=x[x.length-1];
this.updateFormats(prop);
}
this._lastKeyCode=_263.keyCode;
this.updateSimStyle();
},updateFormats:function(prop){
var _265=this._getStringValueOfTextBox(prop);
var _266=true;
if(this.getPropertyObject(prop).supportsHTML&&this.containsHtmlMarkUp(_265)){
dojo.style("MultiFieldSmartInput_SmartInput_checkbox_div_"+prop,"display","");
}else{
dojo.style("MultiFieldSmartInput_SmartInput_checkbox_div_"+prop,"display","none");
}
var _267=dijit.byId("MultiFieldSmartInput_SmartInput_checkbox_"+prop+"_tooltip");
var _268=dijit.byId("MultiFieldSmartInput_SmartInput_checkbox_"+prop);
var _269="html";
if(!_268.checked){
_265=_237.encode(_265);
_269="text";
}
_267.attr("label","Format contents as "+_269+":<br>"+_265);
this.resize(null);
},serializeChildren:function(data){
var _26a=[];
data.children.forEach(function(_26b){
var text=_26b.properties.value?_26b.properties.value:_26b.children;
text=_237.decode(text);
var _26c=(_26b.properties.selected||data.properties.value==text)?"+":"";
_26a.push(_26c+text);
}.bind(this));
return _26a=this.serializeItems(_26a);
},resize:function(e){
var _26d=40;
var tds=dojo.query(".MultiFieldSmartInput_SmartInput_label","davinci.ve.input.MultiFieldSmartInput_table");
tds.forEach(function(td){
if(td.clientWidth>_26d){
_26d=td.clientWidth;
}
});
tds.forEach(function(td){
if(td.clientWidth<_26d){
dojo.style(td,"width",_26d+"px");
}
});
var _26e=0;
tds=dojo.query(".MultiFieldSmartInput_SmartInput_checkbox","davinci.ve.input.MultiFieldSmartInput_table");
tds.forEach(function(td){
if(td.clientWidth>_26e){
_26e=td.clientWidth;
}
});
tds.forEach(function(td){
if(td.clientWidth<_26e){
dojo.style(td,"width",_26e+"px");
}
});
var _26f=dojo.byId("iedResizeDiv");
var _270=_26f.clientWidth-5;
var _271=_26f.clientHeight-6;
_270=_26f.clientWidth-8;
_271=_26f.clientHeight-50;
if(_271<25){
_271=25;
}
var _272=[];
var _273=0;
this.property.forEach(function(p){
var prop=p.property||p.child.property;
var _274=dijit.byId("MultiFieldSmartInput_SmartInput_"+prop);
_274._setStyleAttr({width:_26f.clientWidth-(_26d+_26e+20)+"px"});
if(p.multiLine){
_272.push(_274);
}else{
_273+=_274.domNode.clientHeight;
}
}.bind(this));
if(_272.length>0){
var _275=_26f.clientHeight-_273;
var _276=(_275-25)/_272.length;
_272.forEach(function(_277){
_277._setStyleAttr({height:_276+"px",maxHeight:_276+"px"});
}.bind(this));
}
dojo.style("ieb","width",_26f.clientWidth+15+"px");
dojo.style("davinci.ve.input.SmartInput_radio_div","width",_26f.clientWidth+5+"px");
},_getTemplate:function(){
this._substitutedMainTemplate=dojo.replace(_23b,{buttonOk:_23a.buttonOk,buttonCancel:_23a.buttonCancel,tableContent:this._addPropertiesToHTML(),helpText:this.getHelpText()});
return this._substitutedMainTemplate;
},_addPropertiesToHTML:function(){
var data=this._widget.getData();
var _278="";
this.property.forEach(function(p){
var _279=data.properties[p.property]||"";
var _27a=this.containsHtmlMarkUp(_279)?"checked":"";
var prop=p.property||p.child.property;
if(p.child){
_279=this.serializeChildren(data);
}
if(p.multiLine){
_278+=dojo.replace(_23d,{label:this.getTitle(prop),textboxId:"MultiFieldSmartInput_SmartInput_"+prop,textboxValue:_279,checkboxDivId:"MultiFieldSmartInput_SmartInput_checkbox_div_"+prop,checkboxId:"MultiFieldSmartInput_SmartInput_checkbox_"+prop,checked:_27a});
}else{
var _27b=this._widget.metadata.property[prop]?this._widget.metadata.property[prop].format:null;
var _27c="dijit/form/TextBox";
if(_27b){
if(_27b=="date"){
_27c="dijit/form/DateTextBox";
}else{
if(_27b=="time"){
_27c="dijit/form/TimeTextBox";
}
}
}
_278+=dojo.replace(_23c,{label:this.getTitle(prop),textboxType:_27c,textboxId:"MultiFieldSmartInput_SmartInput_"+prop,textboxValue:_279,checkboxDivId:"MultiFieldSmartInput_SmartInput_checkbox_div_"+prop,checkboxId:"MultiFieldSmartInput_SmartInput_checkbox_"+prop,checked:_27a});
}
}.bind(this));
return _278;
},getSelectedOption:function(_27d,_27e){
var _27f="";
for(var i=0;i<_27e.length;i++){
var _280=_27e[i];
if(_280.properties.selected){
_27f=_280.properties.value;
break;
}
}
return _27f;
},_getStringValueOfTextBox:function(prop){
var _281=dijit.byId("MultiFieldSmartInput_SmartInput_"+prop);
var _282=_281.getValue();
if(_282&&(_282 instanceof Date)){
if(_281 instanceof _238){
_282=_282.toISOString().substring(0,10);
}else{
if(_281 instanceof _239){
_282="T"+_282.toTimeString().substring(0,8);
}
}
}
return _282;
},updateSimStyle:function(){
},});
return _23f;
});
},"dijit/tree/TreeStoreModel":function(){
define(["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/_base/lang"],function(_283,_284,_285,lang){
return _285("dijit.tree.TreeStoreModel",null,{store:null,childrenAttrs:["children"],newItemIdAttr:"id",labelAttr:"",root:null,query:null,deferItemLoadingUntilExpand:false,constructor:function(args){
lang.mixin(this,args);
this.connects=[];
var _286=this.store;
if(!_286.getFeatures()["dojo.data.api.Identity"]){
throw new Error("dijit.tree.TreeStoreModel: store must support dojo.data.Identity");
}
if(_286.getFeatures()["dojo.data.api.Notification"]){
this.connects=this.connects.concat([_284.after(_286,"onNew",lang.hitch(this,"onNewItem"),true),_284.after(_286,"onDelete",lang.hitch(this,"onDeleteItem"),true),_284.after(_286,"onSet",lang.hitch(this,"onSetItem"),true)]);
}
},destroy:function(){
var h;
while(h=this.connects.pop()){
h.remove();
}
},getRoot:function(_287,_288){
if(this.root){
_287(this.root);
}else{
this.store.fetch({query:this.query,onComplete:lang.hitch(this,function(_289){
if(_289.length!=1){
throw new Error("dijit.tree.TreeStoreModel: root query returned "+_289.length+" items, but must return exactly one");
}
this.root=_289[0];
_287(this.root);
}),onError:_288});
}
},mayHaveChildren:function(item){
return _283.some(this.childrenAttrs,function(attr){
return this.store.hasAttribute(item,attr);
},this);
},getChildren:function(_28a,_28b,_28c){
var _28d=this.store;
if(!_28d.isItemLoaded(_28a)){
var _28e=lang.hitch(this,arguments.callee);
_28d.loadItem({item:_28a,onItem:function(_28f){
_28e(_28f,_28b,_28c);
},onError:_28c});
return;
}
var _290=[];
for(var i=0;i<this.childrenAttrs.length;i++){
var vals=_28d.getValues(_28a,this.childrenAttrs[i]);
_290=_290.concat(vals);
}
var _291=0;
if(!this.deferItemLoadingUntilExpand){
_283.forEach(_290,function(item){
if(!_28d.isItemLoaded(item)){
_291++;
}
});
}
if(_291==0){
_28b(_290);
}else{
_283.forEach(_290,function(item,idx){
if(!_28d.isItemLoaded(item)){
_28d.loadItem({item:item,onItem:function(item){
_290[idx]=item;
if(--_291==0){
_28b(_290);
}
},onError:_28c});
}
});
}
},isItem:function(_292){
return this.store.isItem(_292);
},fetchItemByIdentity:function(_293){
this.store.fetchItemByIdentity(_293);
},getIdentity:function(item){
return this.store.getIdentity(item);
},getLabel:function(item){
if(this.labelAttr){
return this.store.getValue(item,this.labelAttr);
}else{
return this.store.getLabel(item);
}
},newItem:function(args,_294,_295){
var _296={parent:_294,attribute:this.childrenAttrs[0]},_297;
if(this.newItemIdAttr&&args[this.newItemIdAttr]){
this.fetchItemByIdentity({identity:args[this.newItemIdAttr],scope:this,onItem:function(item){
if(item){
this.pasteItem(item,null,_294,true,_295);
}else{
_297=this.store.newItem(args,_296);
if(_297&&(_295!=undefined)){
this.pasteItem(_297,_294,_294,false,_295);
}
}
}});
}else{
_297=this.store.newItem(args,_296);
if(_297&&(_295!=undefined)){
this.pasteItem(_297,_294,_294,false,_295);
}
}
},pasteItem:function(_298,_299,_29a,_29b,_29c){
var _29d=this.store,_29e=this.childrenAttrs[0];
if(_299){
_283.forEach(this.childrenAttrs,function(attr){
if(_29d.containsValue(_299,attr,_298)){
if(!_29b){
var _29f=_283.filter(_29d.getValues(_299,attr),function(x){
return x!=_298;
});
_29d.setValues(_299,attr,_29f);
}
_29e=attr;
}
});
}
if(_29a){
if(typeof _29c=="number"){
var _2a0=_29d.getValues(_29a,_29e).slice();
_2a0.splice(_29c,0,_298);
_29d.setValues(_29a,_29e,_2a0);
}else{
_29d.setValues(_29a,_29e,_29d.getValues(_29a,_29e).concat(_298));
}
}
},onChange:function(){
},onChildrenChange:function(){
},onDelete:function(){
},onNewItem:function(item,_2a1){
if(!_2a1){
return;
}
this.getChildren(_2a1.item,lang.hitch(this,function(_2a2){
this.onChildrenChange(_2a1.item,_2a2);
}));
},onDeleteItem:function(item){
this.onDelete(item);
},onSetItem:function(item,_2a3){
if(_283.indexOf(this.childrenAttrs,_2a3)!=-1){
this.getChildren(item,lang.hitch(this,function(_2a4){
this.onChildrenChange(item,_2a4);
}));
}else{
this.onChange(item);
}
}});
});
},"dijit/_HasDropDown":function(){
define(["dojo/_base/declare","dojo/_base/Deferred","dojo/_base/event","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","dojo/window","./registry","./focus","./popup","./_FocusMixin"],function(_2a5,_2a6,_2a7,dom,_2a8,_2a9,_2aa,_2ab,has,keys,lang,on,_2ac,_2ad,_2ae,_2af,_2b0){
return _2a5("dijit._HasDropDown",_2b0,{_buttonNode:null,_arrowWrapperNode:null,_popupStateNode:null,_aroundNode:null,dropDown:null,autoWidth:true,forceWidth:false,maxHeight:0,dropDownPosition:["below","above"],_stopClickEvents:true,_onDropDownMouseDown:function(e){
if(this.disabled||this.readOnly){
return;
}
e.preventDefault();
this._docHandler=this.connect(this.ownerDocument,"mouseup","_onDropDownMouseUp");
this.toggleDropDown();
},_onDropDownMouseUp:function(e){
if(e&&this._docHandler){
this.disconnect(this._docHandler);
}
var _2b1=this.dropDown,_2b2=false;
if(e&&this._opened){
var c=_2aa.position(this._buttonNode,true);
if(!(e.pageX>=c.x&&e.pageX<=c.x+c.w)||!(e.pageY>=c.y&&e.pageY<=c.y+c.h)){
var t=e.target;
while(t&&!_2b2){
if(_2a9.contains(t,"dijitPopup")){
_2b2=true;
}else{
t=t.parentNode;
}
}
if(_2b2){
t=e.target;
if(_2b1.onItemClick){
var _2b3;
while(t&&!(_2b3=_2ad.byNode(t))){
t=t.parentNode;
}
if(_2b3&&_2b3.onClick&&_2b3.getParent){
_2b3.getParent().onItemClick(_2b3,e);
}
}
return;
}
}
}
if(this._opened){
if(_2b1.focus&&_2b1.autoFocus!==false){
this._focusDropDownTimer=this.defer(function(){
_2b1.focus();
delete this._focusDropDownTimer;
});
}
}else{
this.defer("focus");
}
if(has("touch")){
this._justGotMouseUp=true;
this.defer(function(){
this._justGotMouseUp=false;
});
}
},_onDropDownClick:function(e){
if(has("touch")&&!this._justGotMouseUp){
this._onDropDownMouseDown(e);
this._onDropDownMouseUp(e);
}
if(this._stopClickEvents){
_2a7.stop(e);
}
},buildRendering:function(){
this.inherited(arguments);
this._buttonNode=this._buttonNode||this.focusNode||this.domNode;
this._popupStateNode=this._popupStateNode||this.focusNode||this._buttonNode;
var _2b4={"after":this.isLeftToRight()?"Right":"Left","before":this.isLeftToRight()?"Left":"Right","above":"Up","below":"Down","left":"Left","right":"Right"}[this.dropDownPosition[0]]||this.dropDownPosition[0]||"Down";
_2a9.add(this._arrowWrapperNode||this._buttonNode,"dijit"+_2b4+"ArrowButton");
},postCreate:function(){
this.inherited(arguments);
var _2b5=this.focusNode||this.domNode;
this.own(on(this._buttonNode,"mousedown",lang.hitch(this,"_onDropDownMouseDown")),on(this._buttonNode,"click",lang.hitch(this,"_onDropDownClick")),on(_2b5,"keydown",lang.hitch(this,"_onKey")),on(_2b5,"keyup",lang.hitch(this,"_onKeyUp")));
},destroy:function(){
if(this.dropDown){
if(!this.dropDown._destroyed){
this.dropDown.destroyRecursive();
}
delete this.dropDown;
}
this.inherited(arguments);
},_onKey:function(e){
if(this.disabled||this.readOnly){
return;
}
var d=this.dropDown,_2b6=e.target;
if(d&&this._opened&&d.handleKey){
if(d.handleKey(e)===false){
_2a7.stop(e);
return;
}
}
if(d&&this._opened&&e.keyCode==keys.ESCAPE){
this.closeDropDown();
_2a7.stop(e);
}else{
if(!this._opened&&(e.keyCode==keys.DOWN_ARROW||((e.keyCode==keys.ENTER||e.keyCode==keys.SPACE)&&((_2b6.tagName||"").toLowerCase()!=="input"||(_2b6.type&&_2b6.type.toLowerCase()!=="text"))))){
this._toggleOnKeyUp=true;
_2a7.stop(e);
}
}
},_onKeyUp:function(){
if(this._toggleOnKeyUp){
delete this._toggleOnKeyUp;
this.toggleDropDown();
var d=this.dropDown;
if(d&&d.focus){
this.defer(lang.hitch(d,"focus"),1);
}
}
},_onBlur:function(){
var _2b7=_2ae.curNode&&this.dropDown&&dom.isDescendant(_2ae.curNode,this.dropDown.domNode);
this.closeDropDown(_2b7);
this.inherited(arguments);
},isLoaded:function(){
return true;
},loadDropDown:function(_2b8){
_2b8();
},loadAndOpenDropDown:function(){
var d=new _2a6(),_2b9=lang.hitch(this,function(){
this.openDropDown();
d.resolve(this.dropDown);
});
if(!this.isLoaded()){
this.loadDropDown(_2b9);
}else{
_2b9();
}
return d;
},toggleDropDown:function(){
if(this.disabled||this.readOnly){
return;
}
if(!this._opened){
this.loadAndOpenDropDown();
}else{
this.closeDropDown();
}
},openDropDown:function(){
var _2ba=this.dropDown,_2bb=_2ba.domNode,_2bc=this._aroundNode||this.domNode,self=this;
if(!this._preparedNode){
this._preparedNode=true;
if(_2bb.style.width){
this._explicitDDWidth=true;
}
if(_2bb.style.height){
this._explicitDDHeight=true;
}
}
if(this.maxHeight||this.forceWidth||this.autoWidth){
var _2bd={display:"",visibility:"hidden"};
if(!this._explicitDDWidth){
_2bd.width="";
}
if(!this._explicitDDHeight){
_2bd.height="";
}
_2ab.set(_2bb,_2bd);
var _2be=this.maxHeight;
if(_2be==-1){
var _2bf=_2ac.getBox(this.ownerDocument),_2c0=_2aa.position(_2bc,false);
_2be=Math.floor(Math.max(_2c0.y,_2bf.h-(_2c0.y+_2c0.h)));
}
_2af.moveOffScreen(_2ba);
if(_2ba.startup&&!_2ba._started){
_2ba.startup();
}
var mb=_2aa.getMarginSize(_2bb);
var _2c1=(_2be&&mb.h>_2be);
_2ab.set(_2bb,{overflowX:"visible",overflowY:_2c1?"auto":"visible"});
if(_2c1){
mb.h=_2be;
if("w" in mb){
mb.w+=16;
}
}else{
delete mb.h;
}
if(this.forceWidth){
mb.w=_2bc.offsetWidth;
}else{
if(this.autoWidth){
mb.w=Math.max(mb.w,_2bc.offsetWidth);
}else{
delete mb.w;
}
}
if(lang.isFunction(_2ba.resize)){
_2ba.resize(mb);
}else{
_2aa.setMarginBox(_2bb,mb);
}
}
var _2c2=_2af.open({parent:this,popup:_2ba,around:_2bc,orient:this.dropDownPosition,onExecute:function(){
self.closeDropDown(true);
},onCancel:function(){
self.closeDropDown(true);
},onClose:function(){
_2a8.set(self._popupStateNode,"popupActive",false);
_2a9.remove(self._popupStateNode,"dijitHasDropDownOpen");
self._set("_opened",false);
}});
_2a8.set(this._popupStateNode,"popupActive","true");
_2a9.add(this._popupStateNode,"dijitHasDropDownOpen");
this._set("_opened",true);
this.domNode.setAttribute("aria-expanded","true");
return _2c2;
},closeDropDown:function(_2c3){
if(this._focusDropDownTimer){
this._focusDropDownTimer.remove();
delete this._focusDropDownTimer;
}
if(this._opened){
this.domNode.setAttribute("aria-expanded","false");
if(_2c3){
this.focus();
}
_2af.close(this.dropDown);
this._opened=false;
}
}});
});
},"dojo/dnd/Selector":function(){
define(["../_base/array","../_base/declare","../_base/event","../_base/kernel","../_base/lang","../dom","../dom-construct","../mouse","../_base/NodeList","../on","../touch","./common","./Container"],function(_2c4,_2c5,_2c6,_2c7,lang,dom,_2c8,_2c9,_2ca,on,_2cb,dnd,_2cc){
var _2cd=_2c5("dojo.dnd.Selector",_2cc,{constructor:function(node,_2ce){
if(!_2ce){
_2ce={};
}
this.singular=_2ce.singular;
this.autoSync=_2ce.autoSync;
this.selection={};
this.anchor=null;
this.simpleSelection=false;
this.events.push(on(this.node,_2cb.press,lang.hitch(this,"onMouseDown")),on(this.node,_2cb.release,lang.hitch(this,"onMouseUp")));
},singular:false,getSelectedNodes:function(){
var t=new _2ca();
var e=dnd._empty;
for(var i in this.selection){
if(i in e){
continue;
}
t.push(dom.byId(i));
}
return t;
},selectNone:function(){
return this._removeSelection()._removeAnchor();
},selectAll:function(){
this.forInItems(function(data,id){
this._addItemClass(dom.byId(id),"Selected");
this.selection[id]=1;
},this);
return this._removeAnchor();
},deleteSelectedNodes:function(){
var e=dnd._empty;
for(var i in this.selection){
if(i in e){
continue;
}
var n=dom.byId(i);
this.delItem(i);
_2c8.destroy(n);
}
this.anchor=null;
this.selection={};
return this;
},forInSelectedItems:function(f,o){
o=o||_2c7.global;
var s=this.selection,e=dnd._empty;
for(var i in s){
if(i in e){
continue;
}
f.call(o,this.getItem(i),i,this);
}
},sync:function(){
_2cd.superclass.sync.call(this);
if(this.anchor){
if(!this.getItem(this.anchor.id)){
this.anchor=null;
}
}
var t=[],e=dnd._empty;
for(var i in this.selection){
if(i in e){
continue;
}
if(!this.getItem(i)){
t.push(i);
}
}
_2c4.forEach(t,function(i){
delete this.selection[i];
},this);
return this;
},insertNodes:function(_2cf,data,_2d0,_2d1){
var _2d2=this._normalizedCreator;
this._normalizedCreator=function(item,hint){
var t=_2d2.call(this,item,hint);
if(_2cf){
if(!this.anchor){
this.anchor=t.node;
this._removeItemClass(t.node,"Selected");
this._addItemClass(this.anchor,"Anchor");
}else{
if(this.anchor!=t.node){
this._removeItemClass(t.node,"Anchor");
this._addItemClass(t.node,"Selected");
}
}
this.selection[t.node.id]=1;
}else{
this._removeItemClass(t.node,"Selected");
this._removeItemClass(t.node,"Anchor");
}
return t;
};
_2cd.superclass.insertNodes.call(this,data,_2d0,_2d1);
this._normalizedCreator=_2d2;
return this;
},destroy:function(){
_2cd.superclass.destroy.call(this);
this.selection=this.anchor=null;
},onMouseDown:function(e){
if(this.autoSync){
this.sync();
}
if(!this.current){
return;
}
if(!this.singular&&!dnd.getCopyKeyState(e)&&!e.shiftKey&&(this.current.id in this.selection)){
this.simpleSelection=true;
if(_2c9.isLeft(e)){
_2c6.stop(e);
}
return;
}
if(!this.singular&&e.shiftKey){
if(!dnd.getCopyKeyState(e)){
this._removeSelection();
}
var c=this.getAllNodes();
if(c.length){
if(!this.anchor){
this.anchor=c[0];
this._addItemClass(this.anchor,"Anchor");
}
this.selection[this.anchor.id]=1;
if(this.anchor!=this.current){
var i=0,node;
for(;i<c.length;++i){
node=c[i];
if(node==this.anchor||node==this.current){
break;
}
}
for(++i;i<c.length;++i){
node=c[i];
if(node==this.anchor||node==this.current){
break;
}
this._addItemClass(node,"Selected");
this.selection[node.id]=1;
}
this._addItemClass(this.current,"Selected");
this.selection[this.current.id]=1;
}
}
}else{
if(this.singular){
if(this.anchor==this.current){
if(dnd.getCopyKeyState(e)){
this.selectNone();
}
}else{
this.selectNone();
this.anchor=this.current;
this._addItemClass(this.anchor,"Anchor");
this.selection[this.current.id]=1;
}
}else{
if(dnd.getCopyKeyState(e)){
if(this.anchor==this.current){
delete this.selection[this.anchor.id];
this._removeAnchor();
}else{
if(this.current.id in this.selection){
this._removeItemClass(this.current,"Selected");
delete this.selection[this.current.id];
}else{
if(this.anchor){
this._removeItemClass(this.anchor,"Anchor");
this._addItemClass(this.anchor,"Selected");
}
this.anchor=this.current;
this._addItemClass(this.current,"Anchor");
this.selection[this.current.id]=1;
}
}
}else{
if(!(this.current.id in this.selection)){
this.selectNone();
this.anchor=this.current;
this._addItemClass(this.current,"Anchor");
this.selection[this.current.id]=1;
}
}
}
}
_2c6.stop(e);
},onMouseUp:function(){
if(!this.simpleSelection){
return;
}
this.simpleSelection=false;
this.selectNone();
if(this.current){
this.anchor=this.current;
this._addItemClass(this.anchor,"Anchor");
this.selection[this.current.id]=1;
}
},onMouseMove:function(){
this.simpleSelection=false;
},onOverEvent:function(){
this.onmousemoveEvent=on(this.node,_2cb.move,lang.hitch(this,"onMouseMove"));
},onOutEvent:function(){
if(this.onmousemoveEvent){
this.onmousemoveEvent.remove();
delete this.onmousemoveEvent;
}
},_removeSelection:function(){
var e=dnd._empty;
for(var i in this.selection){
if(i in e){
continue;
}
var node=dom.byId(i);
if(node){
this._removeItemClass(node,"Selected");
}
}
this.selection={};
return this;
},_removeAnchor:function(){
if(this.anchor){
this._removeItemClass(this.anchor,"Anchor");
this.anchor=null;
}
return this;
}});
return _2cd;
});
},"davinci/workbench/_ToolbaredContainer":function(){
define(["dojo/_base/declare","dijit/layout/_LayoutWidget","dijit/_Templated"],function(_2d3,_2d4,_2d5){
return _2d3("davinci.workbench._ToolbaredContainer",[_2d4,_2d5],{templateString:"<div><div dojoAttachPoint='titleBarDiv' class='palette_titleBarDiv'></div><div dojoAttachPoint='toolbarDiv' class='toolbaredContainer_toolbarDiv'></div><div dojoAttachPoint='containerNode'></div></div>",gutters:false,_toolbarCreated:{},layout:function(){
var _2d6=[{domNode:this.titleBarDiv,layoutAlign:"top"},{domNode:this.toolbarDiv,layoutAlign:"top"},{domNode:this.containerNode,layoutAlign:"client"}];
dijit.layout.layoutChildren(this.domNode,this._contentBox,_2d6);
this._containerContentBox=dijit.layout.marginBox2contentBox(this.containerNode,_2d6[2]);
var _2d7=dijit.byNode(this.containerNode);
if(_2d7&&_2d7.resize){
_2d7.resize(this._containerContentBox);
}
dojo.marginBox(this.containerNode,_2d6[2]);
},setContent:function(data){
this.mainWidget=data;
var _2d8=data.domNode||data;
dojo.place(_2d8,this.containerNode,"replace");
this.containerNode=_2d8;
if(!this.toolbarCreated(this.declaredClass)){
this._createToolbar(this.declaredClass);
}
this.titleBarDiv.innerHTML="<span class=\"paletteCloseBox\"></span><span class=\"titleBarDivTitle\">"+this.title+"</span>";
var _2d9=dojo.query(".paletteCloseBox",this.titleBarDiv);
if(_2d9.length>0){
var _2da=_2d9[0];
dojo.connect(_2da,"click",this,function(_2db){
davinci.Workbench.collapsePaletteContainer(_2db.currentTarget);
});
}
if(this._started){
this.layout();
}
},removeContent:function(){
var _2dc=dojo.doc.createElement("div");
dojo.place(_2dc,this.containerNode,"replace");
this.containerNode=_2dc;
if(this.mainWidget){
this.mainWidget.destroy();
}
delete this.mainWidget;
},_getViewActions:function(){
},getTopAdditions:function(){
},_createToolbar:function(_2dd){
var _2de=require("davinci/Workbench");
var _2df=this.getToolbarDiv();
var _2e0=this.getTopAdditions();
if(_2e0){
_2df.appendChild(_2e0);
}
if(this.toolbarMenuActionSets){
var _2e1="m"+Date.now();
var _2e2=_2e1+"_menucontainer";
var _2e3=dojo.create("span",{"id":_2e2,"class":"paletteDropdown"},_2df);
var _2e4=_2e1+"_menu";
var _2e5=dojo.create("span",{id:_2e4},_2e3);
_2de.updateMenubar(_2e5,this.toolbarMenuActionSets);
}
var _2e6=this._getViewActions();
if(_2e6&&_2e6.length){
var _2e7=dojo.create("div",{"class":"toolbaredContainer_toolbarDiv"});
var tb=dojo.create("span",{style:{display:"inline-block"}},_2e7);
var _2e8=_2de._createToolBar("toolbarPath",tb,_2e6,this._getViewContext());
dojo.style(_2e8.domNode,{"display":"inline-block","float":"left"});
this.toolbarCreated(_2dd,_2e8);
}
},_getViewContext:function(){
return this;
},getToolbarDiv:function(){
return this.toolbarDiv;
},toolbarCreated:function(_2e9,_2ea){
if(arguments.length>1){
this._toolbarCreated[_2e9]=_2ea;
}
return this._toolbarCreated[_2e9];
},attachToolbar:function(){
var _2eb=this.toolbarCreated(this.declaredClass);
var _2ec=this.getToolbarDiv();
if(_2eb&&_2eb.domNode&&_2ec){
_2ec.innerHTML="";
_2ec.appendChild(_2eb.domNode);
}
}});
});
},"davinci/ve/tools/_Tool":function(){
define(["dojo/_base/declare","davinci/ve/widget","davinci/ve/metadata","davinci/ve/utils/GeomUtils"],function(_2ed,_2ee,_2ef,_2f0){
return _2ed("davinci.ve.tools._Tool",null,{_getTarget:function(){
return this._target;
},_setTarget:function(_2f1,_2f2){
if(!this._targetOverlays){
this._targetOverlays=[];
}
if(this._matchesTargetOverlay(_2f1)){
return;
}
var _2f3=this._context.getContainerNode();
var w;
while(_2f1&&_2f1!=_2f3){
w=_2ee.getEnclosingWidget(_2f1);
if(w&&!w.getContext()){
_2f1=w.domNode.parentNode;
w=null;
}else{
if(w&&davinci.ve.metadata.queryDescriptor(w.type,"enablePointerEvents")){
w=null;
break;
}else{
if(w&&w.getContainerNode()){
if(!davinci.ve.metadata.queryDescriptor(w.type,"isControl")){
w=null;
}
}
break;
}
}
}
if(w){
this._target=w;
this._updateTargetOverlays(_2f2);
this._insertTargetOverlays();
}else{
this._removeTargetOverlays();
this._target=null;
}
},_updateTargetOverlays:function(_2f4){
this._removeTargetOverlays();
if(!this._target){
return;
}
var _2f5=this._target.domNode;
var _2f6=this._getMaxZIndex(_2f5);
if(this._targetOverlays){
var _2f7=this._target.getHelper();
if(_2f7&&_2f7.getTargetOverlays){
var _2f8=_2f7.getTargetOverlays(this._target);
if(_2f8&&_2f8.length>0){
dojo.forEach(_2f8,function(_2f9){
var _2fa=this._getNewTargetOverlay(_2f9,_2f9.x,_2f9.y,_2f9.width,_2f9.height,_2f6);
this._targetOverlays.push(_2fa);
},this);
return;
}
}
var left=_2f5.offsetLeft;
var top=_2f5.offsetTop;
var _2fb=_2f5.offsetWidth;
var _2fc=_2f5.offsetHeight;
if(_2f4){
var diff;
var _2fd=_2f0.getBorderBoxPageCoordsCached(_2f5);
if(_2f4.pageX<_2fd.l){
diff=_2fd.l-_2f4.pageX;
left-=diff;
_2fb+=diff;
}
if(_2f4.pageY<_2fd.t){
diff=_2fd.t-_2f4.pageY;
top-=diff;
_2fc+=diff;
}
if(_2f4.pageX>_2fd.l+_2fd.w){
diff=_2f4.pageX-(_2fd.l+_2fd.w);
_2fb+=diff;
}
if(_2f4.pageY>_2fd.t+_2fd.h){
diff=_2f4.pageY-(_2fd.t+_2fd.h);
_2fc+=diff;
}
}
var _2fe=this._getNewTargetOverlay(_2f5,left,top,_2fb,_2fc,_2f6);
this._targetOverlays.push(_2fe);
}
},_getMaxZIndex:function(_2ff){
var _300=dojo.style(_2ff,"zIndex");
dojo.query("*",_2ff).forEach(function(node){
var _301=dojo.style(node,"zIndex");
var _302=Number(_301);
var _303=Number(_300);
if(!isNaN(_302)){
if(isNaN(_303)){
_300=_301;
}else{
if(_302>_303){
_300=_301;
}
}
}
});
return _300;
},_getNewTargetOverlay:function(_304,x,y,_305,_306,_307){
var _308=this._context.getDojo().create("div",{className:"editFeedback",style:{position:"absolute",opacity:0.1,left:x+"px",top:y+"px",width:_305+"px",height:_306+"px",zIndex:_307}});
return _308;
},_insertTargetOverlays:function(){
if(this._targetOverlays&&this._target){
var _309=this._target.domNode;
var _30a=_309.parentNode;
dojo.forEach(this._targetOverlays,function(_30b){
_30a.insertBefore(_30b,_309.nextSibling);
},this);
}
},_removeTargetOverlays:function(){
if(this._targetOverlays&&this._target){
for(var i=this._targetOverlays.length-1;i>=0;i--){
var _30c=this._targetOverlays[i];
dojo.destroy(_30c);
this._targetOverlays.pop();
}
}
},_matchesTargetOverlay:function(_30d){
return dojo.some(this._targetOverlays,function(_30e){
return _30d==_30e;
},this);
}});
});
},"dijit/_MenuBase":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/lang","dojo/mouse","dojo/on","dojo/window","./a11yclick","./popup","./registry","./_Widget","./_KeyNavContainer","./_TemplatedMixin"],function(_30f,_310,dom,_311,_312,lang,_313,on,_314,_315,pm,_316,_317,_318,_319){
return _310("dijit._MenuBase",[_317,_319,_318],{parentMenu:null,popupDelay:500,autoFocus:false,childSelector:function(node){
var _31a=_316.byNode(node);
return node.parentNode==this.containerNode&&_31a&&_31a.focus;
},postCreate:function(){
var self=this,_31b=typeof this.childSelector=="string"?this.childSelector:lang.hitch(this,"childSelector");
this.own(on(this.containerNode,on.selector(_31b,_313.enter),function(){
self.onItemHover(_316.byNode(this));
}),on(this.containerNode,on.selector(_31b,_313.leave),function(){
self.onItemUnhover(_316.byNode(this));
}),on(this.containerNode,on.selector(_31b,_315),function(evt){
self.onItemClick(_316.byNode(this),evt);
evt.stopPropagation();
evt.preventDefault();
}));
this.inherited(arguments);
},onExecute:function(){
},onCancel:function(){
},_moveToPopup:function(evt){
if(this.focusedChild&&this.focusedChild.popup&&!this.focusedChild.disabled){
this.onItemClick(this.focusedChild,evt);
}else{
var _31c=this._getTopMenu();
if(_31c&&_31c._isMenuBar){
_31c.focusNext();
}
}
},_onPopupHover:function(){
if(this.currentPopup&&this.currentPopup._pendingClose_timer){
var _31d=this.currentPopup.parentMenu;
if(_31d.focusedChild){
_31d.focusedChild._setSelected(false);
}
_31d.focusedChild=this.currentPopup.from_item;
_31d.focusedChild._setSelected(true);
this._stopPendingCloseTimer(this.currentPopup);
}
},onItemHover:function(item){
if(this.isActive){
this.focusChild(item);
if(this.focusedChild.popup&&!this.focusedChild.disabled&&!this.hover_timer){
this.hover_timer=this.defer("_openPopup",this.popupDelay);
}
}
if(this.focusedChild){
this.focusChild(item);
}
this._hoveredChild=item;
item._set("hovering",true);
},_onChildBlur:function(item){
this._stopPopupTimer();
item._setSelected(false);
var _31e=item.popup;
if(_31e){
this._stopPendingCloseTimer(_31e);
_31e._pendingClose_timer=this.defer(function(){
_31e._pendingClose_timer=null;
if(_31e.parentMenu){
_31e.parentMenu.currentPopup=null;
}
pm.close(_31e);
},this.popupDelay);
}
},onItemUnhover:function(item){
if(this.isActive){
this._stopPopupTimer();
}
if(this._hoveredChild==item){
this._hoveredChild=null;
}
item._set("hovering",false);
},_stopPopupTimer:function(){
if(this.hover_timer){
this.hover_timer=this.hover_timer.remove();
}
},_stopPendingCloseTimer:function(_31f){
if(_31f._pendingClose_timer){
_31f._pendingClose_timer=_31f._pendingClose_timer.remove();
}
},_stopFocusTimer:function(){
if(this._focus_timer){
this._focus_timer=this._focus_timer.remove();
}
},_getTopMenu:function(){
for(var top=this;top.parentMenu;top=top.parentMenu){
}
return top;
},onItemClick:function(item,evt){
if(typeof this.isShowingNow=="undefined"){
this._markActive();
}
this.focusChild(item);
if(item.disabled){
return false;
}
if(item.popup){
this._openPopup(evt.type=="keypress");
}else{
this.onExecute();
item._onClick?item._onClick(evt):item.onClick(evt);
}
},_openPopup:function(_320){
this._stopPopupTimer();
var _321=this.focusedChild;
if(!_321){
return;
}
var _322=_321.popup;
if(!_322.isShowingNow){
if(this.currentPopup){
this._stopPendingCloseTimer(this.currentPopup);
pm.close(this.currentPopup);
}
_322.parentMenu=this;
_322.from_item=_321;
var self=this;
pm.open({parent:this,popup:_322,around:_321.domNode,orient:this._orient||["after","before"],onCancel:function(){
self.focusChild(_321);
self._cleanUp();
_321._setSelected(true);
self.focusedChild=_321;
},onExecute:lang.hitch(this,"_cleanUp")});
this.currentPopup=_322;
_322.connect(_322.domNode,"onmouseenter",lang.hitch(self,"_onPopupHover"));
}
if(_320&&_322.focus){
_322._focus_timer=this.defer(lang.hitch(_322,function(){
this._focus_timer=null;
this.focus();
}));
}
},_markActive:function(){
this.isActive=true;
_312.replace(this.domNode,"dijitMenuActive","dijitMenuPassive");
},onOpen:function(){
this.isShowingNow=true;
this._markActive();
},_markInactive:function(){
this.isActive=false;
_312.replace(this.domNode,"dijitMenuPassive","dijitMenuActive");
},onClose:function(){
this._stopFocusTimer();
this._markInactive();
this.isShowingNow=false;
this.parentMenu=null;
},_closeChild:function(){
this._stopPopupTimer();
if(this.currentPopup){
if(_30f.indexOf(this._focusManager.activeStack,this.id)>=0){
_311.set(this.focusedChild.focusNode,"tabIndex",this.tabIndex);
this.focusedChild.focusNode.focus();
}
pm.close(this.currentPopup);
this.currentPopup=null;
}
if(this.focusedChild){
this.focusedChild._setSelected(false);
this.onItemUnhover(this.focusedChild);
this.focusedChild=null;
}
},_onItemFocus:function(item){
if(this._hoveredChild&&this._hoveredChild!=item){
this.onItemUnhover(this._hoveredChild);
}
},_onBlur:function(){
this._cleanUp();
this.inherited(arguments);
},_cleanUp:function(){
this._closeChild();
if(typeof this.isShowingNow=="undefined"){
this._markInactive();
}
}});
});
},"davinci/html/CSSProperty":function(){
define(["dojo/_base/declare","davinci/html/CSSElement"],function(_323,_324){
return _323("davinci.html.CSSProperty",_324,{constructor:function(name,_325,_326){
this.elementType="CSSProperty";
this.name=name||"";
this.value=_325||"";
this.parent=_326;
this.expanded=[];
this.lengthValues=[];
},getValue:function(){
return this.value;
},getText:function(_327){
var s="";
if(this.comment&&!_327.noComments){
s+="\n  "+this.comment.getText(_327);
}
s+=this.name+" : "+this.value;
if(this.isNotImportant){
s+=" !important";
}
s+=";";
if(this.postComment&&!_327.noComments){
s+=this.postComment.getText(_327);
}
return s;
},getCSSRule:function(){
return this.parent;
},addProperty:function(name,_328){
var _329=new CSSProperty(name,_328,this);
this.properties.push(_329);
},getURL:function(){
if(this.url){
var path=new davinci.model.Path(this.getCSSFile().url);
path=path.getParentPath().append(this.url);
return path.toString();
}
}});
});
},"dojo/i18n":function(){
define(["./_base/kernel","require","./has","./_base/array","./_base/config","./_base/lang","./_base/xhr","./json","module"],function(dojo,_32a,has,_32b,_32c,lang,xhr,json,_32d){
has.add("dojo-preload-i18n-Api",1);
1||has.add("dojo-v1x-i18n-Api",1);
var _32e=dojo.i18n={},_32f=/(^.*(^|\/)nls)(\/|$)([^\/]*)\/?([^\/]*)/,_330=function(root,_331,_332,_333){
for(var _334=[_332+_333],_335=_331.split("-"),_336="",i=0;i<_335.length;i++){
_336+=(_336?"-":"")+_335[i];
if(!root||root[_336]){
_334.push(_332+_336+"/"+_333);
}
}
return _334;
},_337={},_338=function(_339,_33a,_33b){
_33b=_33b?_33b.toLowerCase():dojo.locale;
_339=_339.replace(/\./g,"/");
_33a=_33a.replace(/\./g,"/");
return (/root/i.test(_33b))?(_339+"/nls/"+_33a):(_339+"/nls/"+_33b+"/"+_33a);
},_33c=dojo.getL10nName=function(_33d,_33e,_33f){
return _33d=_32d.id+"!"+_338(_33d,_33e,_33f);
},_340=function(_341,_342,_343,_344,_345,load){
_341([_342],function(root){
var _346=lang.clone(root.root),_347=_330(!root._v1x&&root,_345,_343,_344);
_341(_347,function(){
for(var i=1;i<_347.length;i++){
_346=lang.mixin(lang.clone(_346),arguments[i]);
}
var _348=_342+"/"+_345;
_337[_348]=_346;
load();
});
});
},_349=function(id,_34a){
return /^\./.test(id)?_34a(id):id;
},_34b=function(_34c){
var list=_32c.extraLocale||[];
list=lang.isArray(list)?list:[list];
list.push(_34c);
return list;
},load=function(id,_34d,load){
if(has("dojo-preload-i18n-Api")){
var _34e=id.split("*"),_34f=_34e[1]=="preload";
if(_34f){
if(!_337[id]){
_337[id]=1;
_350(_34e[2],json.parse(_34e[3]),1,_34d);
}
load(1);
}
if(_34f||_351(id,_34d,load)){
return;
}
}
var _352=_32f.exec(id),_353=_352[1]+"/",_354=_352[5]||_352[4],_355=_353+_354,_356=(_352[5]&&_352[4]),_357=_356||dojo.locale,_358=_355+"/"+_357,_359=_356?[_357]:_34b(_357),_35a=_359.length,_35b=function(){
if(!--_35a){
load(lang.delegate(_337[_358]));
}
};
_32b.forEach(_359,function(_35c){
var _35d=_355+"/"+_35c;
if(has("dojo-preload-i18n-Api")){
_35e(_35d);
}
if(!_337[_35d]){
_340(_34d,_355,_353,_354,_35c,_35b);
}else{
_35b();
}
});
};
if(has("dojo-unit-tests")){
var _35f=_32e.unitTests=[];
}
if(has("dojo-preload-i18n-Api")||1){
var _360=_32e.normalizeLocale=function(_361){
var _362=_361?_361.toLowerCase():dojo.locale;
return _362=="root"?"ROOT":_362;
},isXd=function(mid,_363){
return (1&&1)?_363.isXdUrl(_32a.toUrl(mid+".js")):true;
},_364=0,_365=[],_350=_32e._preloadLocalizations=function(_366,_367,_368,_369){
_369=_369||_32a;
function _36a(mid,_36b){
if(isXd(mid,_369)||_368){
_369([mid],_36b);
}else{
_375([mid],_36b,_369);
}
};
function _36c(_36d,func){
var _36e=_36d.split("-");
while(_36e.length){
if(func(_36e.join("-"))){
return;
}
_36e.pop();
}
func("ROOT");
};
function _36f(_370){
_370=_360(_370);
_36c(_370,function(loc){
if(_32b.indexOf(_367,loc)>=0){
var mid=_366.replace(/\./g,"/")+"_"+loc;
_364++;
_36a(mid,function(_371){
for(var p in _371){
_337[_32a.toAbsMid(p)+"/"+loc]=_371[p];
}
--_364;
while(!_364&&_365.length){
load.apply(null,_365.shift());
}
});
return true;
}
return false;
});
};
_36f();
_32b.forEach(dojo.config.extraLocale,_36f);
},_351=function(id,_372,load){
if(_364){
_365.push([id,_372,load]);
}
return _364;
},_35e=function(){
};
}
if(1){
var _373={},_374=new Function("__bundle","__checkForLegacyModules","__mid","__amdValue","var define = function(mid, factory){define.called = 1; __amdValue.result = factory || mid;},"+"\t   require = function(){define.called = 1;};"+"try{"+"define.called = 0;"+"eval(__bundle);"+"if(define.called==1)"+"return __amdValue;"+"if((__checkForLegacyModules = __checkForLegacyModules(__mid)))"+"return __checkForLegacyModules;"+"}catch(e){}"+"try{"+"return eval('('+__bundle+')');"+"}catch(e){"+"return e;"+"}"),_375=function(deps,_376,_377){
var _378=[];
_32b.forEach(deps,function(mid){
var url=_377.toUrl(mid+".js");
function load(text){
var _379=_374(text,_35e,mid,_373);
if(_379===_373){
_378.push(_337[url]=_373.result);
}else{
if(_379 instanceof Error){
console.error("failed to evaluate i18n bundle; url="+url,_379);
_379={};
}
_378.push(_337[url]=(/nls\/[^\/]+\/[^\/]+$/.test(url)?_379:{root:_379,_v1x:1}));
}
};
if(_337[url]){
_378.push(_337[url]);
}else{
var _37a=_377.syncLoadNls(mid);
if(_37a){
_378.push(_37a);
}else{
if(!xhr){
try{
_377.getText(url,true,load);
}
catch(e){
_378.push(_337[url]={});
}
}else{
xhr.get({url:url,sync:true,load:load,error:function(){
_378.push(_337[url]={});
}});
}
}
}
});
_376&&_376.apply(null,_378);
};
_35e=function(_37b){
for(var _37c,_37d=_37b.split("/"),_37e=dojo.global[_37d[0]],i=1;_37e&&i<_37d.length-1;_37e=_37e[_37d[i++]]){
}
if(_37e){
_37c=_37e[_37d[i]];
if(!_37c){
_37c=_37e[_37d[i].replace(/-/g,"_")];
}
if(_37c){
_337[_37b]=_37c;
}
}
return _37c;
};
_32e.getLocalization=function(_37f,_380,_381){
var _382,_383=_338(_37f,_380,_381);
load(_383,(!isXd(_383,_32a)?function(deps,_384){
_375(deps,_384,_32a);
}:_32a),function(_385){
_382=_385;
});
return _382;
};
if(has("dojo-unit-tests")){
_35f.push(function(doh){
doh.register("tests.i18n.unit",function(t){
var _386;
_386=_374("{prop:1}",_35e,"nonsense",_373);
t.is({prop:1},_386);
t.is(undefined,_386[1]);
_386=_374("({prop:1})",_35e,"nonsense",_373);
t.is({prop:1},_386);
t.is(undefined,_386[1]);
_386=_374("{'prop-x':1}",_35e,"nonsense",_373);
t.is({"prop-x":1},_386);
t.is(undefined,_386[1]);
_386=_374("({'prop-x':1})",_35e,"nonsense",_373);
t.is({"prop-x":1},_386);
t.is(undefined,_386[1]);
_386=_374("define({'prop-x':1})",_35e,"nonsense",_373);
t.is(_373,_386);
t.is({"prop-x":1},_373.result);
_386=_374("define('some/module', {'prop-x':1})",_35e,"nonsense",_373);
t.is(_373,_386);
t.is({"prop-x":1},_373.result);
_386=_374("this is total nonsense and should throw an error",_35e,"nonsense",_373);
t.is(_386 instanceof Error,true);
});
});
}
}
return lang.mixin(_32e,{dynamic:true,normalize:_349,load:load,cache:_337});
});
},"dojox/html/ellipsis":function(){
define("dojox/html/ellipsis",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","dojo/_base/Color","dojo/colors"],function(d){
if(d.isFF<7){
var _387=1;
if("dojoxFFEllipsisDelay" in d.config){
_387=Number(d.config.dojoxFFEllipsisDelay);
if(isNaN(_387)){
_387=1;
}
}
try{
var _388=(function(){
var sNS="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";
var xml=document.createElementNS(sNS,"window");
var _389=document.createElementNS(sNS,"description");
_389.setAttribute("crop","end");
xml.appendChild(_389);
return function(n){
var x=xml.cloneNode(true);
x.firstChild.setAttribute("value",n.textContent);
n.innerHTML="";
n.appendChild(x);
};
})();
}
catch(e){
}
var _38a=d.create;
var dd=d.doc;
var dp=d.place;
var _38b=_38a("iframe",{className:"dojoxEllipsisIFrame",src:"javascript:'<html><head><script>if(\"loadFirebugConsole\" in window){window.loadFirebugConsole();}</script></head><body></body></html>'",style:{display:"none"}});
var _38c=function(r,cnt){
if(r.collapsed){
return;
}
if(cnt>0){
do{
_38c(r);
cnt--;
}while(cnt);
return;
}
if(r.endContainer.nodeType==3&&r.endOffset>0){
r.setEnd(r.endContainer,r.endOffset-1);
}else{
if(r.endContainer.nodeType==3){
r.setEndBefore(r.endContainer);
_38c(r);
return;
}else{
if(r.endOffset&&r.endContainer.childNodes.length>=r.endOffset){
var _38d=r.endContainer.childNodes[r.endOffset-1];
if(_38d.nodeType==3){
r.setEnd(_38d,_38d.length-1);
}else{
if(_38d.childNodes.length){
r.setEnd(_38d,_38d.childNodes.length);
_38c(r);
return;
}else{
r.setEndBefore(_38d);
_38c(r);
return;
}
}
}else{
r.setEndBefore(r.endContainer);
_38c(r);
return;
}
}
}
};
var _38e=function(n){
var c=_38a("div",{className:"dojoxEllipsisContainer"});
var e=_38a("div",{className:"dojoxEllipsisShown",style:{display:"none"}});
n.parentNode.replaceChild(c,n);
c.appendChild(n);
c.appendChild(e);
var i=_38b.cloneNode(true);
var ns=n.style;
var es=e.style;
var _38f;
var _390=function(){
ns.display="";
es.display="none";
if(n.scrollWidth<=n.offsetWidth){
return;
}
var r=dd.createRange();
r.selectNodeContents(n);
ns.display="none";
es.display="";
var done=false;
do{
var _391=1;
dp(r.cloneContents(),e,"only");
var sw=e.scrollWidth,ow=e.offsetWidth;
done=(sw<=ow);
var pct=(1-((ow*1)/sw));
if(pct>0){
_391=Math.max(Math.round(e.textContent.length*pct)-1,1);
}
_38c(r,_391);
}while(!r.collapsed&&!done);
};
i.onload=function(){
i.contentWindow.onresize=_390;
_390();
};
c.appendChild(i);
};
var hc=d.hasClass;
var doc=d.doc;
var s,fn,opt;
if(doc.querySelectorAll){
s=doc;
fn="querySelectorAll";
opt=".dojoxEllipsis";
}else{
if(doc.getElementsByClassName){
s=doc;
fn="getElementsByClassName";
opt="dojoxEllipsis";
}else{
s=d;
fn="query";
opt=".dojoxEllipsis";
}
}
fx=function(){
d.forEach(s[fn].apply(s,[opt]),function(n){
if(!n||n._djx_ellipsis_done){
return;
}
n._djx_ellipsis_done=true;
if(_388&&n.textContent==n.innerHTML&&!hc(n,"dojoxEllipsisSelectable")){
_388(n);
}else{
_38e(n);
}
});
};
d.addOnLoad(function(){
var t=null;
var c=null;
var _392=function(){
if(c){
d.disconnect(c);
c=null;
}
if(t){
clearTimeout(t);
}
t=setTimeout(function(){
t=null;
fx();
c=d.connect(d.body(),"DOMSubtreeModified",_392);
},_387);
};
_392();
});
}
});
},"dijit/tree/ForestStoreModel":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","./TreeStoreModel"],function(_393,_394,_395,lang,_396){
return _394("dijit.tree.ForestStoreModel",_396,{rootId:"$root$",rootLabel:"ROOT",query:null,constructor:function(_397){
this.root={store:this,root:true,id:_397.rootId,label:_397.rootLabel,children:_397.rootChildren};
},mayHaveChildren:function(item){
return item===this.root||this.inherited(arguments);
},getChildren:function(_398,_399,_39a){
if(_398===this.root){
if(this.root.children){
_399(this.root.children);
}else{
this.store.fetch({query:this.query,onComplete:lang.hitch(this,function(_39b){
this.root.children=_39b;
_399(_39b);
}),onError:_39a});
}
}else{
this.inherited(arguments);
}
},isItem:function(_39c){
return (_39c===this.root)?true:this.inherited(arguments);
},fetchItemByIdentity:function(_39d){
if(_39d.identity==this.root.id){
var _39e=_39d.scope||_395.global;
if(_39d.onItem){
_39d.onItem.call(_39e,this.root);
}
}else{
this.inherited(arguments);
}
},getIdentity:function(item){
return (item===this.root)?this.root.id:this.inherited(arguments);
},getLabel:function(item){
return (item===this.root)?this.root.label:this.inherited(arguments);
},newItem:function(args,_39f,_3a0){
if(_39f===this.root){
this.onNewRootItem(args);
return this.store.newItem(args);
}else{
return this.inherited(arguments);
}
},onNewRootItem:function(){
},pasteItem:function(_3a1,_3a2,_3a3,_3a4,_3a5){
if(_3a2===this.root){
if(!_3a4){
this.onLeaveRoot(_3a1);
}
}
this.inherited(arguments,[_3a1,_3a2===this.root?null:_3a2,_3a3===this.root?null:_3a3,_3a4,_3a5]);
if(_3a3===this.root){
this.onAddToRoot(_3a1);
}
},onAddToRoot:function(item){
},onLeaveRoot:function(item){
},_requeryTop:function(){
var _3a6=this.root.children||[];
this.store.fetch({query:this.query,onComplete:lang.hitch(this,function(_3a7){
this.root.children=_3a7;
if(_3a6.length!=_3a7.length||_393.some(_3a6,function(item,idx){
return _3a7[idx]!=item;
})){
this.onChildrenChange(this.root,_3a7);
}
})});
},onNewItem:function(item,_3a8){
this._requeryTop();
this.inherited(arguments);
},onDeleteItem:function(item){
if(_393.indexOf(this.root.children,item)!=-1){
this._requeryTop();
}
this.inherited(arguments);
},onSetItem:function(item,_3a9,_3aa,_3ab){
this._requeryTop();
this.inherited(arguments);
}});
});
},"dijit/PopupMenuBarItem":function(){
define(["dojo/_base/declare","./PopupMenuItem","./MenuBarItem"],function(_3ac,_3ad,_3ae){
var _3af=_3ae._MenuBarItemMixin;
return _3ac("dijit.PopupMenuBarItem",[_3ad,_3af],{});
});
},"dojox/html/metrics":function(){
define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/sniff","dojo/ready","dojo/_base/unload","dojo/_base/window","dojo/dom-geometry"],function(_3b0,lang,has,_3b1,_3b2,_3b3,_3b4){
var dhm=lang.getObject("dojox.html.metrics",true);
var _3b5=lang.getObject("dojox");
dhm.getFontMeasurements=function(){
var _3b6={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};
if(has("ie")){
_3b3.doc.documentElement.style.fontSize="100%";
}
var div=_3b3.doc.createElement("div");
var ds=div.style;
ds.position="absolute";
ds.left="-100px";
ds.top="0";
ds.width="30px";
ds.height="1000em";
ds.borderWidth="0";
ds.margin="0";
ds.padding="0";
ds.outline="0";
ds.lineHeight="1";
ds.overflow="hidden";
_3b3.body().appendChild(div);
for(var p in _3b6){
ds.fontSize=p;
_3b6[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;
}
_3b3.body().removeChild(div);
div=null;
return _3b6;
};
var _3b7=null;
dhm.getCachedFontMeasurements=function(_3b8){
if(_3b8||!_3b7){
_3b7=dhm.getFontMeasurements();
}
return _3b7;
};
var _3b9=null,_3ba={};
dhm.getTextBox=function(text,_3bb,_3bc){
var m,s;
if(!_3b9){
m=_3b9=_3b3.doc.createElement("div");
var c=_3b3.doc.createElement("div");
c.appendChild(m);
s=c.style;
s.overflow="scroll";
s.position="absolute";
s.left="0px";
s.top="-10000px";
s.width="1px";
s.height="1px";
s.visibility="hidden";
s.borderWidth="0";
s.margin="0";
s.padding="0";
s.outline="0";
_3b3.body().appendChild(c);
}else{
m=_3b9;
}
m.className="";
s=m.style;
s.borderWidth="0";
s.margin="0";
s.padding="0";
s.outline="0";
if(arguments.length>1&&_3bb){
for(var i in _3bb){
if(i in _3ba){
continue;
}
s[i]=_3bb[i];
}
}
if(arguments.length>2&&_3bc){
m.className=_3bc;
}
m.innerHTML=text;
var box=_3b4.position(m);
box.w=m.parentNode.scrollWidth;
return box;
};
var _3bd={w:16,h:16};
dhm.getScrollbar=function(){
return {w:_3bd.w,h:_3bd.h};
};
dhm._fontResizeNode=null;
dhm.initOnFontResize=function(_3be){
var f=dhm._fontResizeNode=_3b3.doc.createElement("iframe");
var fs=f.style;
fs.position="absolute";
fs.width="5em";
fs.height="10em";
fs.top="-10000px";
fs.display="none";
if(has("ie")){
f.onreadystatechange=function(){
if(f.contentWindow.document.readyState=="complete"){
f.onresize=f.contentWindow.parent[_3b5._scopeName].html.metrics._fontresize;
}
};
}else{
f.onload=function(){
f.contentWindow.onresize=f.contentWindow.parent[_3b5._scopeName].html.metrics._fontresize;
};
}
f.setAttribute("src","javascript:'<html><head><script>if(\"loadFirebugConsole\" in window){window.loadFirebugConsole();}</script></head><body></body></html>'");
_3b3.body().appendChild(f);
dhm.initOnFontResize=function(){
};
};
dhm.onFontResize=function(){
};
dhm._fontresize=function(){
dhm.onFontResize();
};
_3b2.addOnUnload(function(){
var f=dhm._fontResizeNode;
if(f){
if(has("ie")&&f.onresize){
f.onresize=null;
}else{
if(f.contentWindow&&f.contentWindow.onresize){
f.contentWindow.onresize=null;
}
}
dhm._fontResizeNode=null;
}
});
_3b1(function(){
try{
var n=_3b3.doc.createElement("div");
n.style.cssText="top:0;left:0;width:100px;height:100px;overflow:scroll;position:absolute;visibility:hidden;";
_3b3.body().appendChild(n);
_3bd.w=n.offsetWidth-n.clientWidth;
_3bd.h=n.offsetHeight-n.clientHeight;
_3b3.body().removeChild(n);
delete n;
}
catch(e){
}
if("fontSizeWatch" in _3b0.config&&!!_3b0.config.fontSizeWatch){
dhm.initOnFontResize();
}
});
return dhm;
});
},"davinci/model/Comment":function(){
define(["dojo/_base/declare","davinci/model/Model"],function(_3bf,_3c0){
return _3bf("davinci.model.Comment",_3c0,{constructor:function(){
this.elementType="Comment";
this.nosemicolon=true;
},addComment:function(type,_3c1,stop,text){
if(this.comments==null){
this.comments=[];
}
this.comments[this.comments.length]={commentType:type,start:_3c1,stop:stop,s:text};
},appendComment:function(text){
var _3c2=this.comments[this.comments.length-1];
_3c2.s+=text;
_3c2.stop+=text.length;
},getText:function(_3c3){
var s="";
for(var i=0;i<this.comments.length;i++){
if(this.comments[i].commentType=="line"){
s+="//"+this.comments[i].s+"\n";
}else{
if(this.comments[i].commentType=="block"){
s+="/*"+this.comments[i].s+"*/\n";
}
}
}
return s;
}});
});
},"url:davinci/ve/input/templates/MultiFieldTableRowSmartInput.html":"<tr>\n\t<td class=\"MultiFieldSmartInput_SmartInput_label\" >\n\t\t{label}\n\t</td>\n\t<td>\n\t\t<div class=\"MultiFieldSmartInput_SmartInput_value\">\n\t\t\t<input type=\"text\" name=\"{textboxId}\"  data-dojo-type=\"{textboxType}\" data-dojo-props=\"trim:true\" value=\"{textboxValue}\" id=\"{textboxId}\">\n\t    </div>\n    </td>\n    <td class=\"MultiFieldSmartInput_SmartInput_checkbox\">\n    \t<div id=\"{checkboxDivId}\">\n    \t\t<input id=\"{checkboxId}\" name=\"{checkboxId}\" data-dojo-type=\"dijit/form/CheckBox\" {checked} />\n\t\t\t<label for=\"{checkboxId}\">html</label>\n    \t</div>\n\t</td>\n</tr>\n\n","davinci/html/HTMLItem":function(){
define(["dojo/_base/declare","davinci/html/HTMLModel"],function(_3c4,_3c5){
return _3c4("davinci.html.HTMLItem",_3c5,{constructor:function(){
this.elementType="HTMLItem";
},getLabel:function(){
return this.getText({indent:0});
},onChange:function(arg){
if(this.parent){
if(arg){
this.parent.onChange(arg);
}
}
},_addWS:function(_3c6,_3c7){
_3c6=_3c6||0;
_3c7=_3c7||0;
var res=[];
for(var i=0;i<_3c6;i++){
res.push("\n");
}
res.push("                                          ".substring(0,_3c7));
return res.join("");
},close:function(){
for(var i=0;i<this.children.length;i++){
this.children[i].close();
}
},getID:function(){
return this.parent.getID()+":"+this.startOffset+":"+this.getLabel();
},getHTMLFile:function(){
var _3c8=this;
while(_3c8&&_3c8.elementType!="HTMLFile"){
_3c8=_3c8.parent;
}
return _3c8;
}});
});
},"davinci/ve/ObjectWidget":function(){
define(["dojo/_base/declare","dojo/dom-attr","./_Widget"],function(_3c9,_3ca,_3cb){
return _3c9("davinci.ve.ObjectWidget",_3cb,{isObjectWidget:true,constructor:function(_3cc,node,_3cd,_3ce,_3cf){
if(typeof _3cd==="string"){
_3ca.set(node,"data-dojo-type",_3cd);
if(_3cf){
_3cf.addAttribute("data-dojo-type",_3cd);
}
}
},postCreate:function(){
var id=this._params.jsId,dj=require("davinci/ve/widget")._dojo(this.domNode),_3d0;
if(id){
_3ca.set(this.domNode,"jsId",id);
var type=this.getObjectType();
if(type){
var c=dj.getObject(type.replace(/\//g,"."));
if(c){
if(c.markupFactory){
_3d0=c.markupFactory(this._params,this.domNode,c);
}else{
if(c.prototype&&c.prototype.markupFactory){
_3d0=c.prototype.markupFactory(this._params,this.domNode,c);
}else{
_3d0=new c(this._params,this.domNode);
}
}
if(_3d0){
_3d0._edit_object_id=id;
dj.setObject(id,_3d0);
}
}
}
}else{
id=this.getObjectId();
if(id){
_3d0=dj.getObject(id);
if(_3d0){
_3d0._edit_object_id=id;
}
}
}
},getObjectType:function(){
var node=this.domNode,type=_3ca.get(node,"data-dojo-type")||_3ca.get(node,"dojoType");
type=type.replace(/\./g,"/");
return type;
},getObjectId:function(){
return _3ca.get(this.domNode,"jsId");
},_getChildren:function(){
return [];
}});
});
},"davinci/model/parser/Tokenizer":function(){
define(["dojo/_base/declare","davinci/js/JSExpression"],function(_3d1,_3d2){
return {stringStream:function(_3d3){
var _3d4="";
var pos=0;
var _3d5=0;
var _3d6="";
function _3d7(){
while(pos==_3d4.length){
_3d6+=_3d4;
_3d4="";
pos=0;
try{
_3d4=_3d3.next();
}
catch(e){
if(e!=StopIteration){
throw e;
}else{
return false;
}
}
}
return true;
};
return {peek:function(){
if(!_3d7()){
return null;
}
return _3d4.charAt(pos);
},next:function(){
if(!_3d7()){
if(_3d6.length>0){
throw "End of stringstream reached without emptying buffer ('"+_3d6+"').";
}else{
throw StopIteration;
}
}
return _3d4.charAt(pos++);
},get:function(){
var temp=_3d6;
_3d6="";
if(pos>0){
temp+=_3d4.slice(0,pos);
_3d4=_3d4.slice(pos);
pos=0;
}
_3d5+=temp.length;
return temp;
},getOffset:function(){
return _3d5;
},push:function(str){
_3d4=_3d4.slice(0,pos)+str+_3d4.slice(pos);
_3d5-=str.length;
},lookAhead:function(str,_3d8,_3d9,_3da){
function _3db(str){
return _3da?str.toLowerCase():str;
};
str=_3db(str);
var _3dc=false;
var _3dd=_3d6,_3de=pos;
if(_3d9){
this.nextWhileMatches(/[\s\u00a0]/);
}
while(true){
var end=pos+str.length,left=_3d4.length-pos;
if(end<=_3d4.length){
_3dc=str==_3db(_3d4.slice(pos,end));
pos=end;
break;
}else{
if(str.slice(0,left)==_3db(_3d4.slice(pos))){
_3d6+=_3d4;
_3d4="";
try{
_3d4=_3d3.next();
}
catch(e){
if(e!=StopIteration){
throw e;
}
break;
}
pos=0;
str=str.slice(left);
}else{
break;
}
}
}
if(!(_3dc&&_3d8)){
_3d4=_3d6.slice(_3dd.length)+_3d4;
pos=_3de;
_3d6=_3dd;
}
return _3dc;
},lookAheadRegex:function(_3df,_3e0){
if(_3df.source.charAt(0)!="^"){
throw new Error("Regexps passed to lookAheadRegex must start with ^");
}
while(_3d4.indexOf("\n",pos)==-1){
try{
_3d4+=_3d3.next();
}
catch(e){
if(e!=StopIteration){
throw e;
break;
}
}
}
var _3e1=_3d4.slice(pos).match(_3df);
if(_3e1&&_3e0){
pos+=_3e1[0].length;
}
return _3e1;
},more:function(){
return this.peek()!==null;
},applies:function(test){
var next=this.peek();
return (next!==null&&test(next));
},nextWhile:function(test){
var next;
while((next=this.peek())!==null&&test(next)){
this.next();
}
},matches:function(re){
var next=this.peek();
return (next!==null&&re.test(next));
},nextWhileMatches:function(re){
var next;
while((next=this.peek())!==null&&re.test(next)){
this.next();
}
},equals:function(ch){
return ch===this.peek();
},endOfLine:function(){
var next=this.peek();
return next==null||next=="\n";
}};
},tokenizer:function(_3e2,_3e3){
function _3e4(ch){
return ch!="\n"&&/^[\s\u00a0]*$/.test(ch);
};
var _3e5={state:_3e3,take:function(type){
if(typeof (type)=="string"){
type={style:type,type:type};
}
type.offset=_3e2.getOffset();
type.content=(type.content||"")+_3e2.get();
if(!/\n$/.test(type.content)){
_3e2.nextWhile(_3e4);
}
type.value=type.content+_3e2.get();
return type;
},next:function(){
if(!_3e2.more()){
throw StopIteration;
}
var type;
if(_3e2.equals("\n")){
_3e2.next();
return this.take("whitespace");
}
if(_3e2.applies(_3e4)){
type="whitespace";
}else{
while(!type){
type=this.state(_3e2,function(s){
_3e5.state=s;
});
}
}
return this.take(type);
}};
return _3e5;
}};
});
},"dijit/form/_ComboBoxMenuMixin":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/i18n","dojo/i18n!./nls/ComboBox"],function(_3e6,_3e7,_3e8,i18n){
return _3e7("dijit.form._ComboBoxMenuMixin",null,{_messages:null,postMixInProperties:function(){
this.inherited(arguments);
this._messages=i18n.getLocalization("dijit.form","ComboBox",this.lang);
},buildRendering:function(){
this.inherited(arguments);
this.previousButton.innerHTML=this._messages["previousMessage"];
this.nextButton.innerHTML=this._messages["nextMessage"];
},_setValueAttr:function(_3e9){
this.value=_3e9;
this.onChange(_3e9);
},onClick:function(node){
if(node==this.previousButton){
this._setSelectedAttr(null);
this.onPage(-1);
}else{
if(node==this.nextButton){
this._setSelectedAttr(null);
this.onPage(1);
}else{
this.onChange(node);
}
}
},onChange:function(){
},onPage:function(){
},onClose:function(){
this._setSelectedAttr(null);
},_createOption:function(item,_3ea){
var _3eb=this._createMenuItem();
var _3ec=_3ea(item);
if(_3ec.html){
_3eb.innerHTML=_3ec.label;
}else{
_3eb.appendChild(_3eb.ownerDocument.createTextNode(_3ec.label));
}
if(_3eb.innerHTML==""){
_3eb.innerHTML="&#160;";
}
this.applyTextDir(_3eb,(_3eb.innerText||_3eb.textContent||""));
return _3eb;
},createOptions:function(_3ed,_3ee,_3ef){
this.items=_3ed;
this.previousButton.style.display=(_3ee.start==0)?"none":"";
_3e8.set(this.previousButton,"id",this.id+"_prev");
_3e6.forEach(_3ed,function(item,i){
var _3f0=this._createOption(item,_3ef);
_3f0.setAttribute("item",i);
_3e8.set(_3f0,"id",this.id+i);
this.nextButton.parentNode.insertBefore(_3f0,this.nextButton);
},this);
var _3f1=false;
if(_3ed.total&&!_3ed.total.then&&_3ed.total!=-1){
if((_3ee.start+_3ee.count)<_3ed.total){
_3f1=true;
}else{
if((_3ee.start+_3ee.count)>_3ed.total&&_3ee.count==_3ed.length){
_3f1=true;
}
}
}else{
if(_3ee.count==_3ed.length){
_3f1=true;
}
}
this.nextButton.style.display=_3f1?"":"none";
_3e8.set(this.nextButton,"id",this.id+"_next");
},clearResultList:function(){
var _3f2=this.containerNode;
while(_3f2.childNodes.length>2){
_3f2.removeChild(_3f2.childNodes[_3f2.childNodes.length-2]);
}
this._setSelectedAttr(null);
},highlightFirstOption:function(){
this.selectFirstNode();
},highlightLastOption:function(){
this.selectLastNode();
},selectFirstNode:function(){
this.inherited(arguments);
if(this.getHighlightedOption()==this.previousButton){
this.selectNextNode();
}
},selectLastNode:function(){
this.inherited(arguments);
if(this.getHighlightedOption()==this.nextButton){
this.selectPreviousNode();
}
},getHighlightedOption:function(){
return this.selected;
}});
});
},"dijit/form/_SearchMixin":function(){
define(["dojo/data/util/filter","dojo/_base/declare","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/query","dojo/sniff","dojo/string","dojo/when","../registry"],function(_3f3,_3f4,_3f5,keys,lang,_3f6,has,_3f7,when,_3f8){
return _3f4("dijit.form._SearchMixin",null,{pageSize:Infinity,store:null,fetchProperties:{},query:{},searchDelay:200,searchAttr:"name",queryExpr:"${0}*",ignoreCase:true,_abortQuery:function(){
if(this.searchTimer){
this.searchTimer=this.searchTimer.remove();
}
if(this._queryDeferHandle){
this._queryDeferHandle=this._queryDeferHandle.remove();
}
if(this._fetchHandle){
if(this._fetchHandle.abort){
this._cancelingQuery=true;
this._fetchHandle.abort();
this._cancelingQuery=false;
}
if(this._fetchHandle.cancel){
this._cancelingQuery=true;
this._fetchHandle.cancel();
this._cancelingQuery=false;
}
this._fetchHandle=null;
}
},_processInput:function(evt){
if(this.disabled||this.readOnly){
return;
}
var key=evt.charOrCode;
if(evt.altKey||((evt.ctrlKey||evt.metaKey)&&(key!="x"&&key!="v"))||key==keys.SHIFT){
return;
}
var _3f9=false;
this._prev_key_backspace=false;
switch(key){
case keys.DELETE:
case keys.BACKSPACE:
this._prev_key_backspace=true;
this._maskValidSubsetError=true;
_3f9=true;
break;
default:
_3f9=typeof key=="string"||key==229;
}
if(_3f9){
if(!this.store){
this.onSearch();
}else{
this.searchTimer=this.defer("_startSearchFromInput",1);
}
}
},onSearch:function(){
},_startSearchFromInput:function(){
this._startSearch(this.focusNode.value.replace(/([\\\*\?])/g,"\\$1"));
},_startSearch:function(text){
this._abortQuery();
var _3fa=this,_3f6=lang.clone(this.query),_3fb={start:0,count:this.pageSize,queryOptions:{ignoreCase:this.ignoreCase,deep:true}},qs=_3f7.substitute(this.queryExpr,[text]),q,_3fc=function(){
var _3fd=_3fa._fetchHandle=_3fa.store.query(_3f6,_3fb);
if(_3fa.disabled||_3fa.readOnly||(q!==_3fa._lastQuery)){
return;
}
when(_3fd,function(res){
_3fa._fetchHandle=null;
if(!_3fa.disabled&&!_3fa.readOnly&&(q===_3fa._lastQuery)){
when(_3fd.total,function(_3fe){
res.total=_3fe;
var _3ff=_3fa.pageSize;
if(isNaN(_3ff)||_3ff>res.total){
_3ff=res.total;
}
res.nextPage=function(_400){
_3fb.direction=_400=_400!==false;
_3fb.count=_3ff;
if(_400){
_3fb.start+=res.length;
if(_3fb.start>=res.total){
_3fb.count=0;
}
}else{
_3fb.start-=_3ff;
if(_3fb.start<0){
_3fb.count=Math.max(_3ff+_3fb.start,0);
_3fb.start=0;
}
}
if(_3fb.count<=0){
res.length=0;
_3fa.onSearch(res,_3f6,_3fb);
}else{
_3fc();
}
};
_3fa.onSearch(res,_3f6,_3fb);
});
}
},function(err){
_3fa._fetchHandle=null;
if(!_3fa._cancelingQuery){
console.error(_3fa.declaredClass+" "+err.toString());
}
});
};
lang.mixin(_3fb,this.fetchProperties);
if(this.store._oldAPI){
q=qs;
}else{
q=_3f3.patternToRegExp(qs,this.ignoreCase);
q.toString=function(){
return qs;
};
}
this._lastQuery=_3f6[this.searchAttr]=q;
this._queryDeferHandle=this.defer(_3fc,this.searchDelay);
},constructor:function(){
this.query={};
this.fetchProperties={};
},postMixInProperties:function(){
if(!this.store){
var list=this.list;
if(list){
this.store=_3f8.byId(list);
}
}
this.inherited(arguments);
}});
});
},"dojox/grid/_RowSelector":function(){
define(["dojo/_base/declare","./_View"],function(_401,_402){
return _401("dojox.grid._RowSelector",_402,{defaultWidth:"2em",noscroll:true,padBorderWidth:2,buildRendering:function(){
this.inherited("buildRendering",arguments);
this.scrollboxNode.style.overflow="hidden";
this.headerNode.style.visibility="hidden";
},getWidth:function(){
return this.viewWidth||this.defaultWidth;
},buildRowContent:function(_403,_404){
var w=this.contentWidth||0;
_404.innerHTML="<table class=\"dojoxGridRowbarTable\" style=\"width:"+w+"px;height:1px;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" role=\"presentation\"><tr><td class=\"dojoxGridRowbarInner\">&nbsp;</td></tr></table>";
},renderHeader:function(){
},updateRow:function(){
},resize:function(){
this.adaptHeight();
},adaptWidth:function(){
if(!("contentWidth" in this)&&this.contentNode&&this.contentNode.offsetWidth>0){
this.contentWidth=this.contentNode.offsetWidth-this.padBorderWidth;
}
},doStyleRowNode:function(_405,_406){
var n=["dojoxGridRowbar dojoxGridNonNormalizedCell"];
if(this.grid.rows.isOver(_405)){
n.push("dojoxGridRowbarOver");
}
if(this.grid.selection.isSelected(_405)){
n.push("dojoxGridRowbarSelected");
}
_406.className=n.join(" ");
},domouseover:function(e){
this.grid.onMouseOverRow(e);
},domouseout:function(e){
if(!this.isIntraRowEvent(e)){
this.grid.onMouseOutRow(e);
}
}});
});
},"davinci/ve/GenericWidget":function(){
define(["dojo/_base/declare","./_Widget"],function(_407,_408){
return _407("davinci.ve.GenericWidget",_408,{isGenericWidget:true,constructor:function(_409,node,type,_40a,_40b){
dojo.attr(node,"dvwidget",type);
if(_40b){
_40b.addAttribute("dvwidget",type);
}
},buildRendering:function(){
this.containerNode=this.domNode;
if(this._params){
for(var name in this._params){
this.domNode.setAttribute(name,this._params[name]);
}
this._params=undefined;
}
},_getChildrenData:function(_40c){
var _40d=[];
var _40e=this.domNode.childNodes;
for(var i=0;i<_40e.length;i++){
var n=_40e[i];
var d;
switch(n.nodeType){
case 1:
var w=require("davinci/ve/widget").byNode(n);
if(w){
d=w.getData(_40c);
}
break;
case 3:
d=n.nodeValue.trim();
if(d&&_40c.serialize){
d=davinci.html.escapeXml(d);
}
break;
case 8:
d="<!--"+n.nodeValue+"-->";
break;
}
if(d){
_40d.push(d);
}
}
if(_40d.length===0){
return undefined;
}
return _40d;
},setProperties:function(_40f){
var node=this.domNode;
for(var name in _40f){
if(name==="style"){
dojo.style(node,_40f[name]);
}else{
if(!_40f[name]){
node.removeAttribute(name);
}else{
node[name]=_40f[name];
}
}
}
this.inherited(arguments);
},_attr:function(name,_410){
if(arguments.length>1){
this.domNode.setAttribute(name,_410);
}else{
return this.domNode.getAttribute(name);
}
},getTagName:function(){
return this.domNode.nodeName.toLowerCase();
}});
});
},"url:dijit/form/templates/DropDownButton.html":"<span class=\"dijit dijitReset dijitInline\"\n\t><span class='dijitReset dijitInline dijitButtonNode'\n\t\tdata-dojo-attach-event=\"ondijitclick:_onClick\" data-dojo-attach-point=\"_buttonNode\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"focusNode,titleNode,_arrowWrapperNode\"\n\t\t\trole=\"button\" aria-haspopup=\"true\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\"\n\t\t\t\tdata-dojo-attach-point=\"iconNode\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode,_popupStateNode\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonInner\"></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonChar\">&#9660;</span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\" tabIndex=\"-1\"\n\t\tdata-dojo-attach-point=\"valueNode\" role=\"presentation\"\n/></span>\n","dojo/dnd/Manager":function(){
define(["../_base/array","../_base/declare","../_base/event","../_base/lang","../_base/window","../dom-class","../Evented","../has","../keys","../on","../topic","../touch","./common","./autoscroll","./Avatar"],function(_411,_412,_413,lang,win,_414,_415,has,keys,on,_416,_417,dnd,_418,_419){
var _41a=_412("dojo.dnd.Manager",[_415],{constructor:function(){
this.avatar=null;
this.source=null;
this.nodes=[];
this.copy=true;
this.target=null;
this.canDropFlag=false;
this.events=[];
},OFFSET_X:has("touch")?0:16,OFFSET_Y:has("touch")?-64:16,overSource:function(_41b){
if(this.avatar){
this.target=(_41b&&_41b.targetState!="Disabled")?_41b:null;
this.canDropFlag=Boolean(this.target);
this.avatar.update();
}
_416.publish("/dnd/source/over",_41b);
},outSource:function(_41c){
if(this.avatar){
if(this.target==_41c){
this.target=null;
this.canDropFlag=false;
this.avatar.update();
_416.publish("/dnd/source/over",null);
}
}else{
_416.publish("/dnd/source/over",null);
}
},startDrag:function(_41d,_41e,copy){
_418.autoScrollStart(win.doc);
this.source=_41d;
this.nodes=_41e;
this.copy=Boolean(copy);
this.avatar=this.makeAvatar();
win.body().appendChild(this.avatar.node);
_416.publish("/dnd/start",_41d,_41e,this.copy);
this.events=[on(win.doc,_417.move,lang.hitch(this,"onMouseMove")),on(win.doc,_417.release,lang.hitch(this,"onMouseUp")),on(win.doc,"keydown",lang.hitch(this,"onKeyDown")),on(win.doc,"keyup",lang.hitch(this,"onKeyUp")),on(win.doc,"dragstart",_413.stop),on(win.body(),"selectstart",_413.stop)];
var c="dojoDnd"+(copy?"Copy":"Move");
_414.add(win.body(),c);
},canDrop:function(flag){
var _41f=Boolean(this.target&&flag);
if(this.canDropFlag!=_41f){
this.canDropFlag=_41f;
this.avatar.update();
}
},stopDrag:function(){
_414.remove(win.body(),["dojoDndCopy","dojoDndMove"]);
_411.forEach(this.events,function(_420){
_420.remove();
});
this.events=[];
this.avatar.destroy();
this.avatar=null;
this.source=this.target=null;
this.nodes=[];
},makeAvatar:function(){
return new _419(this);
},updateAvatar:function(){
this.avatar.update();
},onMouseMove:function(e){
var a=this.avatar;
if(a){
_418.autoScrollNodes(e);
var s=a.node.style;
s.left=(e.pageX+this.OFFSET_X)+"px";
s.top=(e.pageY+this.OFFSET_Y)+"px";
var copy=Boolean(this.source.copyState(dnd.getCopyKeyState(e)));
if(this.copy!=copy){
this._setCopyStatus(copy);
}
}
if(has("touch")){
e.preventDefault();
}
},onMouseUp:function(e){
if(this.avatar){
if(this.target&&this.canDropFlag){
var copy=Boolean(this.source.copyState(dnd.getCopyKeyState(e)));
_416.publish("/dnd/drop/before",this.source,this.nodes,copy,this.target,e);
_416.publish("/dnd/drop",this.source,this.nodes,copy,this.target,e);
}else{
_416.publish("/dnd/cancel");
}
this.stopDrag();
}
},onKeyDown:function(e){
if(this.avatar){
switch(e.keyCode){
case keys.CTRL:
var copy=Boolean(this.source.copyState(true));
if(this.copy!=copy){
this._setCopyStatus(copy);
}
break;
case keys.ESCAPE:
_416.publish("/dnd/cancel");
this.stopDrag();
break;
}
}
},onKeyUp:function(e){
if(this.avatar&&e.keyCode==keys.CTRL){
var copy=Boolean(this.source.copyState(false));
if(this.copy!=copy){
this._setCopyStatus(copy);
}
}
},_setCopyStatus:function(copy){
this.copy=copy;
this.source._markDndStatus(this.copy);
this.updateAvatar();
_414.replace(win.body(),"dojoDnd"+(this.copy?"Copy":"Move"),"dojoDnd"+(this.copy?"Move":"Copy"));
}});
dnd._manager=null;
_41a.manager=dnd.manager=function(){
if(!dnd._manager){
dnd._manager=new _41a();
}
return dnd._manager;
};
return _41a;
});
},"davinci/model/resource/File":function(){
define(["dojo/_base/declare","dojo/_base/xhr","davinci/Runtime","davinci/model/resource/Resource","davinci/model/resource/Marker","davinci/ve/utils/URLRewrite"],function(_421,xhr,_422,_423,_424,_425){
return _421("davinci.model.resource.File",_423,{constructor:function(name,_426){
this.elementType="File";
this.name=name;
this.parent=_426;
this.markers=[];
this.extension=name.substr(name.lastIndexOf(".")+1);
},getExtension:function(){
return this.extension;
},clearMarkers:function(){
this.markers=[];
},addMarker:function(type,line,text){
this.markers.push(new _424(this,type,line,text));
},getMarkers:function(_427){
var _428=[];
if(this.markers){
for(var i=0;i<this.markers.length;i++){
var _429=this.markers[i];
if(!_427){
_428.push(_429);
}else{
if(typeof _427=="string"){
if(_429.type==_427){
_428.push(_429);
}
}else{
dojo.forEach(_427,function(type){
if(type==_429.type){
_428.push(_429);
}
});
}
}
}
}
return _428;
},setContents:function(_42a,_42b){
if(this.isNew&&!_42b){
this.isNew=false;
}
var _42c=_42b?".workingcopy":"";
var path=encodeURI(this.getPath()+_42c);
var _42d=xhr.put({url:path,putData:_42a,handleAs:"text",contentType:"text/html"});
_42d.then(function(res){
this.dirtyResource=_42b;
dojo.publish("/davinci/resource/resourceChanged",["modified",this]);
return this;
}.bind(this),function(err){
console.error("An error occurred: davinci.model.resource.File.prototype.setContents "+err+" : "+path);
return err;
});
return _42d;
},getContentSync:function(){
return _422.serverJSONRequest({url:_425.encodeURI(this.getURL()),handleAs:"text",sync:true});
},getContent:function(){
return xhr.get({url:_425.encodeURI(this.getURL()),handleAs:"text"});
},removeWorkingCopy:function(){
_422.serverJSONRequest({url:"cmd/removeWorkingCopy",handleAs:"text",content:{path:this.getPath()},sync:true});
if(this.isNew){
this.deleteResource(true);
}
}});
});
},"dijit/form/ToggleButton":function(){
define(["dojo/_base/declare","dojo/_base/kernel","./Button","./_ToggleButtonMixin"],function(_42e,_42f,_430,_431){
return _42e("dijit.form.ToggleButton",[_430,_431],{baseClass:"dijitToggleButton",setChecked:function(_432){
_42f.deprecated("setChecked("+_432+") is deprecated. Use set('checked',"+_432+") instead.","","2.0");
this.set("checked",_432);
}});
});
},"davinci/html/CSSRule":function(){
define(["dojo/_base/declare","davinci/html/CSSElement","davinci/html/CSSParser","davinci/html/CSSProperty"],function(_433,_434,_435,_436){
return _433("davinci.html.CSSRule",_434,{constructor:function(){
this.elementType="CSSRule";
this.selectors=[];
this.properties=[];
},getText:function(_437){
var s="";
_437=_437||[];
if(this.comment&&!_437.noComments){
s+=this.comment.getText(_437);
}
s+=this.getSelectorText(_437);
s=s+" {";
for(var i=0;i<this.properties.length;i++){
s=s+"\n    "+this.properties[i].getText(_437);
}
s=s+"\n}\n";
if(this.postComment&&!_437.noComments){
s+=this.postComment.getText(_437);
}
return s;
},setText:function(text){
var _438={xmode:"style",css:true};
var _439=require("davinci/html/CSSParser").parse(text,this);
dojo.mixin(this,this.children[0]);
var _43a=(this.parent)?this.parent.endOffset:0;
this.startOffset=_43a+1;
this.setDirty(true);
},addProperty:function(name,_43b){
var _43c=new _436(name,_43b,this);
this.properties.push(_43c);
this.setDirty(true);
this.onChange();
},insertProperty:function(name,_43d,_43e){
var _43f;
_43f=this.getProperty(name);
if(_43f){
this.removeProperty(name);
}
_43f=new _436(name,_43d,this);
this.properties.splice(_43e,0,_43f);
this.setDirty(true);
this.onChange();
},getSelectorText:function(_440){
var s="";
for(var i=0;i<this.selectors.length;i++){
if(i>0){
s=s+", ";
}
s=s+this.selectors[i].getText(_440);
}
return s;
},matches:function(_441){
_441=this._convertNode(_441);
var _442;
for(var i=0;i<this.selectors.length;i++){
if((_442=this.selectors[i].matches(_441))>=0){
return _442;
}
}
},visit:function(_443){
if(!_443.visit(this)){
for(var i=0;i<this.children.length;i++){
this.children[i].visit(_443);
}
for(var i=0;i<this.selectors.length;i++){
this.selectors[i].visit(_443);
}
}
if(_443.endVisit){
_443.endVisit(this);
}
},hasSelector:function(_444){
for(var i=0;i<this.selectors.length;i++){
if(this.selectors[i].getLabel()==_444){
return true;
}
}
return false;
},matchesSelectors:function(_445){
for(var j=0;j<_445.length;j++){
for(var i=0;i<this.selectors.length;i++){
if(this.selectors[i].matchesSelector(_445[j])){
return true;
}
}
}
return false;
},getCSSRule:function(){
return this;
},getLabel:function(){
return this.getSelectorText({});
},getProperty:function(_446){
for(var i=0;i<this.properties.length;i++){
if(_446==this.properties[i].name){
return this.properties[i];
}
}
},hasProperty:function(_447){
for(var i=0;i<this.properties.length;i++){
if(_447==this.properties[i].name){
return true;
}
}
},getProperties:function(_448){
var _449=[];
for(var i=0;i<this.properties.length;i++){
if(!_448||_448==this.properties[i].name){
_449.push(this.properties[i]);
}
}
return _449;
},setProperty:function(name,_44a){
var _44b=this.getProperty(name);
if(!_44a){
this.removeProperty(name);
}else{
if(_44b){
_44b.value=_44a;
}else{
_44b=new _436();
_44b.name=name;
_44b.value=_44a;
this.properties.push(_44b);
_44b.parent=this;
}
}
this.setDirty(true);
this.onChange();
},removeProperty:function(_44c){
for(var i=0;i<this.properties.length;i++){
if(_44c==this.properties[i].name){
this.properties.splice(i,1);
}
}
this.setDirty(true);
this.onChange();
},removeAllProperties:function(){
this.properties=[];
this.setDirty(true);
this.onChange();
},removeStyleValues:function(_44d){
var _44e=[];
for(var i=0;i<this.properties.length;i++){
var _44f;
for(var j=0;j<_44d.length&&!_44f;j++){
_44f=_44d[j]==this.properties[i].name;
}
if(!_44f){
_44e=this.properties[i];
}
}
this.properties=_44e;
this.setDirty(true);
this.onChange();
}});
});
},"dijit/form/DateTextBox":function(){
define(["dojo/_base/declare","../Calendar","./_DateTimeTextBox"],function(_450,_451,_452){
return _450("dijit.form.DateTextBox",_452,{baseClass:"dijitTextBox dijitComboBox dijitDateTextBox",popupClass:_451,_selector:"date",value:new Date("")});
});
},"davinci/html/html.plugin":function(){
define(["require"],function(_453){
return {id:"davinci.html","davinci.editor":[{id:"HTMLEditor",name:"HTML Editor",extensions:"html",isDefault:false,editorClass:"davinci/html/ui/HTMLEditor",palettePerspective:"davinci.html.htmlEditor",expandPalettes:["left"]},{id:"CSSEditor",name:"CSS Editor",extensions:"css",isDefault:true,editorClass:"davinci/html/ui/CSSEditor",palettePerspective:"davinci.html.htmlEditor",expandPalettes:["left"]},{id:"ImageViewer",name:"Image Viewer",extensions:"jpg,gif,jpeg,png",isDefault:true,editorClass:"davinci/html/ui/ImageViewer",palettePerspective:"davinci.html.htmlEditor",expandPalettes:["left"]}],"davinci.editorActions":{editorContribution:{targetID:"davinci.html.CSSEditor",actions:[{id:"savecombo",className:"maqLabelButton",showLabel:true,label:"Save",toolbarPath:"save",type:"ComboButton",run:function(){
_453(["../Workbench"],function(_454){
_453("../ui/Resource").save();
});
},isEnabled:function(_455){
return _453("../Workbench").getOpenEditor();
},menu:[{iconClass:"saveIcon",run:function(){
_453("../ui/Resource").save();
},isEnabled:function(_456){
return _453("../Workbench").getOpenEditor();
},label:"Save",keyBinding:{accel:true,charOrCode:"s",allowGlobal:true}},{iconClass:"saveAsIcon",run:function(){
_453("../ui/Resource").saveAs("html");
},isEnabled:function(_457){
return _453("../Workbench").getOpenEditor();
},label:"Save As",keyBinding:{accel:true,shift:true,charOrCode:"s",allowGlobal:true}}]}]}},"davinci.preferences":[{name:"HTML",id:"general",category:""}],"davinci.fileType":[{extension:"html",iconClass:"htmlFileIcon",type:"text"},{extension:"css",iconClass:"cssFileIcon",type:"text"},{extension:"jpeg",iconClass:"imageFileIcon",type:"image"},{extension:"jpg",iconClass:"imageFileIcon",type:"image"},{extension:"png",iconClass:"imageFileIcon",type:"image"},{extension:"gif",iconClass:"imageFileIcon",type:"image"}],"davinci.perspective":[{id:"htmlEditor",title:"HTML Editor",views:[{viewID:"davinci.ve.Palette",position:"left",hidden:true},{viewID:"davinci.ui.outline",position:"left",hidden:true},{viewID:"davinci.ve.style",position:"right"},{viewID:"davinci.ui.comment",position:"right",hidden:true},{viewID:"davinci.ve.states",position:"right-bottom",hidden:true},{viewID:"davinci.ui.navigator",position:"left-bottom",selected:true},{viewID:"davinci.review.reviewNavigator",position:"left"}]}]};
});
},"davinci/html/HTMLParser":function(){
define(["dojo/_base/declare","davinci/html/HTMLText","davinci/html/HTMLElement","davinci/html/HTMLAttribute","davinci/html/HTMLComment","davinci/html/PHPBlock","davinci/model/parser/Tokenizer","davinci/html/CSSParser"],function(_458,_459,_45a,_45b,_45c,_45d,_45e,_45f){
var _460=(function(){
var _461={autoSelfClosers:{"br":true,"img":true,"hr":true,"link":true,"input":true,"meta":true,"col":true,"frame":true,"base":true,"area":true},doNotIndent:{"pre":true,"!cdata":true}};
var _462={autoSelfClosers:{},doNotIndent:{"!cdata":true}};
var _463=_461;
var _464=false;
var _465=(function(){
function _466(_467,_468){
var ch=_467.next();
if(ch=="<"){
if(_467.equals("!")){
_467.next();
if(_467.equals("[")){
if(_467.lookAhead("[CDATA[",true)){
_468(_469("xml-cdata","]]>"));
return null;
}else{
return "xml-text";
}
}else{
if(_467.lookAhead("--",true)){
_468(_469("xml-comment","-->"));
return null;
}else{
if(_467.lookAhead("DOCTYPE",true)){
_467.nextWhileMatches(/[\w\._\-]/);
_468(_469("xml-doctype",">"));
return "xml-doctype";
}else{
return "xml-text";
}
}
}
}else{
if(_467.equals("?")){
_467.next();
if(_467.lookAhead("php",true,false,true)){
_468(_46a("php-block","?>"));
return null;
}else{
_467.nextWhileMatches(/[\w\._\-]/);
_468(_469("xml-processing","?>"));
return "xml-processing";
}
}else{
if(_467.equals("/")){
_467.next();
}
_468(_46b);
return "xml-punctuation";
}
}
}else{
if(ch=="&"){
while(!_467.endOfLine()){
if(_467.next()==";"){
break;
}
}
return "xml-entity";
}else{
_467.nextWhileMatches(/[^&<\n]/);
return "xml-text";
}
}
};
function _46b(_46c,_46d){
var ch=_46c.next();
if(ch==">"){
_46d(_466);
return "xml-punctuation";
}else{
if(/[?\/]/.test(ch)&&_46c.equals(">")){
_46c.next();
_46d(_466);
return "xml-punctuation";
}else{
if(ch=="="){
return "xml-punctuation";
}else{
if(/[\'\"]/.test(ch)){
_46d(_46e(ch));
return null;
}else{
_46c.nextWhileMatches(/[^\s\u00a0=<>\"\'\/?]/);
return "xml-name";
}
}
}
}
};
function _46e(_46f){
return function(_470,_471){
while(!_470.endOfLine()){
if(_470.next()==_46f){
_471(_46b);
break;
}
}
return "xml-attribute";
};
};
function _469(_472,_473){
return function(_474,_475){
while(!_474.endOfLine()){
if(_474.lookAhead(_473,true)){
_475(_466);
break;
}
_474.next();
}
return _472;
};
};
function _46a(_476,_477){
return function(_478,_479){
var _47a=false;
while(!_478.endOfLine()){
if(_478.lookAhead(_477,true)){
_47a=true;
_479(_466);
break;
}
_478.next();
}
if(!_47a&&_478.endOfLine()){
_478.next();
}else{
while(_478.lookAheadRegex(/^[\ \t]/,true)){
}
if(_478.endOfLine()){
_478.next();
}
}
return _476;
};
};
return function(_47b,_47c){
return _45e.tokenizer(_47b,_47c||_466);
};
})();
function _47d(_47e){
var _47f=_465(_47e),_480;
var cc=[base];
var _481=0,_482=0;
var _483=null,_484=null;
var _485;
function push(fs){
for(var i=fs.length-1;i>=0;i--){
cc.push(fs[i]);
}
};
function cont(){
push(arguments);
_485=true;
};
function pass(){
push(arguments);
_485=false;
};
function _486(){
_480.style+=" xml-error";
};
function _487(text){
return function(_488,_489){
if(_489==text){
cont();
}else{
_486();
cont(arguments.callee);
}
};
};
function _48a(_48b,_48c){
var _48d=_463.doNotIndent.hasOwnProperty(_48b)||(_484&&_484.noIndent);
_484={prev:_484,name:_48b,indent:_482,startOfLine:_48c,noIndent:_48d};
};
function _48e(){
_484=_484.prev;
};
function _48f(_490){
return function(_491,_492){
var _493=_490;
if(_493&&_493.noIndent){
return _492;
}
if(_464&&/<!\[CDATA\[/.test(_491)){
return 0;
}
if(_493&&/^<\//.test(_491)){
_493=_493.prev;
}
while(_493&&!_493.startOfLine){
_493=_493.prev;
}
if(_493){
return _493.indent+indentUnit;
}else{
return 0;
}
};
};
function base(){
return pass(_494,base);
};
var _495={"xml-text":true,"xml-entity":true,"xml-comment":true,"xml-processing":true,"xml-doctype":true,"php-block":true};
function _494(_496,_497){
if(_497=="<"){
cont(_498,_499,_49a(_481==1));
}else{
if(_497=="</"){
cont(_49b,_487(">"));
}else{
if(_496=="xml-cdata"){
if(!_484||_484.name!="!cdata"){
_48a("!cdata");
}
if(/\]\]>$/.test(_497)){
_48e();
}
cont();
}else{
if(_495.hasOwnProperty(_496)){
cont();
}else{
_486();
cont();
}
}
}
}
};
function _498(_49c,_49d){
if(_49c=="xml-name"){
_483=_49d.toLowerCase();
_480.style="xml-tagname";
cont();
}else{
_483=null;
pass();
}
};
function _49b(_49e,_49f){
if(_49e=="xml-name"){
_480.style="xml-tagname";
if(_484&&_49f.toLowerCase()==_484.name){
_48e();
}else{
_486();
}
}
cont();
};
function _49a(_4a0){
return function(_4a1,_4a2){
if(_4a2=="/>"||(_4a2==">"&&_463.autoSelfClosers.hasOwnProperty(_483))){
cont();
}else{
if(_4a2==">"){
_48a(_483,_4a0);
cont();
}else{
_486();
cont(arguments.callee);
}
}
};
};
function _499(_4a3){
if(_4a3=="xml-name"){
_480.style="xml-attname";
cont(_4a4,_499);
}else{
pass();
}
};
function _4a4(_4a5,_4a6){
if(_4a6=="="){
cont(_4a7);
}else{
if(_4a6==">"||_4a6=="/>"){
pass(_49a);
}else{
pass();
}
}
};
function _4a7(_4a8){
if(_4a8=="xml-attribute"){
cont(_4a7);
}else{
pass();
}
};
return {indentation:function(){
return _482;
},next:function(){
_480=_47f.next();
if(_480.style=="whitespace"&&_481==0){
_482=_480.value.length;
}else{
_481++;
}
if(_480.content=="\n"){
_482=_481=0;
_480.indentation=_48f(_484);
}
if(_480.style=="whitespace"||_480.type=="xml-comment"||_480.type=="php-block"){
return _480;
}
while(true){
_485=false;
cc.pop()(_480.style,_480.content);
if(_485){
return _480;
}
}
},copy:function(){
var _4a9=cc.concat([]),_4aa=_47f.state,_4ab=_484;
var _4ac=this;
return function(_4ad){
cc=_4a9.concat([]);
_481=_482=0;
_484=_4ab;
_47f=_465(_4ad,_4aa);
return _4ac;
};
}};
};
return {make:_47d,electricChars:"/",configure:function(_4ae){
if(_4ae.useHTMLKludges!=null){
_463=_4ae.useHTMLKludges?_461:_462;
}
if(_4ae.alignCDATA){
_464=_4ae.alignCDATA;
}
}};
})();
var _4af=function(text,_4b0){
var _4b1={next:function(){
if(++this.count==1){
return text;
}else{
throw StopIteration;
}
},count:0,text:text};
var _4b2=_45e.stringStream(_4b1);
var _4b3=_460.make(_4b2);
var _4b4;
var _4b5=[];
function _4b6(text){
_4b5.push(text);
};
var _4b7=[];
_4b7.push(_4b0);
var _4b8;
var _4b9,_4ba;
function _4bb(text,_4bc){
_4b8=new _459();
_4b8.wasParsed=true;
_4b8.startOffset=_4bc;
_4b7[_4b7.length-1].addChild(_4b8,undefined,true);
_4b8.value=text;
};
function _4bd(_4be){
if(_4be.content!=_4be.value){
_4bb(_4be.value.substring(_4be.content.length),_4be.offset+_4be.value.length);
}
};
function _4bf(str,_4c0){
var _4c1=str.split("\n");
var _4c2=_4c1[_4c1.length-1].length;
if(_4c0.children.length){
lastElement=_4c0.children[_4c0.children.length-1];
lastElement._fmLine=_4c1.length-1;
lastElement._fmIndent=_4c2;
}else{
_4c0._fmChildLine=_4c1.length-1;
_4c0._fmChildIndent=_4c2;
}
};
function _4c3(){
if(_4b8!=null&&!_4b8.value.match(/\S/)){
var _4c4=_4b7[_4b7.length-1];
_4c4.children.pop();
_4bf(_4b8.value,_4c4);
}
_4b8=null;
};
function _4c5(){
var _4c6=_4b7[_4b7.length-1];
_4b2.nextWhileMatches(/[\s\u00a0]/);
var str=_4b2.get();
if(_4b8!=null){
_4b8.value+=str;
_4c3();
}else{
_4bf(str,_4c6);
}
_45f.parse(_4b2,_4c6);
};
function _4c7(_4c8){
_4b4=_4b3.next();
while(_4c8&&_4b4.style=="whitespace"){
_4b4=_4b3.next();
}
return _4b4;
};
try{
do{
_4b4=_4b3.next();
switch(_4b4.style){
case "xml-punctuation":
_4c3();
if(_4b4.content=="<"){
var _4c9=new _45a();
_4c9.wasParsed=true;
_4c9.startOffset=_4b4.offset;
_4b7[_4b7.length-1].addChild(_4c9,undefined,true);
_4c7(true);
if(_4b4.style=="xml-tagname"){
_4c9.tag=_4b4.content;
}else{
_4b6("expecting tag name");
}
while((_4b4=_4c7(true)).style=="xml-attname"){
var _4ca=new _45b();
_4ca.wasParsed=true;
_4c9.attributes.push(_4ca);
_4ca.name=_4b4.content;
_4ca.startOffset=_4b4.offset;
_4c7(true);
if(_4b4.content=="="){
_4b4=_4b3.next();
if(_4b4.style=="xml-attribute"){
var s=_4b4.content;
_4ca.setValue(s.substring(1,s.length-1));
}else{
_4b6("expecting attribute value");
}
}else{
_4ca.noValue=true;
_4ca.setValue(true);
}
_4ca.endOffset=_4b4.offset-1;
if(_4ca.noValue&&_4b4.style!="xml-attname"){
break;
}
}
if(_4b4.style!="xml-punctuation"){
_4b6("expecting >");
}else{
_4c9.startTagOffset=_4b4.offset;
if(_4b4.content==">"){
_4b7.push(_4c9);
}else{
_4c9.noEndTag=true;
_4c9=_4b7[_4b7.length-1];
}
_4bd(_4b4);
}
if(_4c9.tag=="style"){
_4c5();
}
}else{
if(_4b4.value=="</"){
var _4cb=_4c9;
_4b4=_4b3.next();
if(_4c9.tag=="script"){
_4c9.script=_4c9.getElementText();
}
_4b7.pop();
_4c9=_4b7[_4b7.length-1];
_4b4=_4b3.next();
_4cb.endOffset=_4b4.offset;
_4bd(_4b4);
}
}
_4ba=null;
break;
case "xml-text":
case "whitespace":
case "xml-entity":
if(_4b9){
_4b9.value+=_4b4.value;
}else{
if(_4ba){
_4ba.value+=_4b4.value;
}else{
if(!_4b8){
_4bb(_4b4.value,_4b4.offset);
}else{
_4b8.value+=_4b4.value;
}
}
}
_4ba=null;
break;
case "xml-comment":
_4c3();
var _4cc=new _45c();
_4cc.wasParsed=true;
_4cc.startOffset=_4b4.offset;
_4cc.value=_4b4.content.substring(4,_4b4.content.length-3);
_4cc.endOffset=_4b4.offset+_4b4.content.length;
_4b7[_4b7.length-1].addChild(_4cc,undefined,true);
_4ba=null;
break;
case "php-block":
_4c3();
var _4cd=new _45d();
_4cd.wasParsed=true;
_4cd.startOffset=_4b4.offset;
_4cd.value=_4b4.content;
_4cd.endOffset=_4b4.offset+_4b4.content.length;
_4b7[_4b7.length-1].addChild(_4cd,undefined,true);
_4ba=_4cd;
break;
case "xml-doctype":
if(!_4b9){
_4c3();
var _4cc=new _45c();
_4cc.wasParsed=true;
_4cc.startOffset=_4b4.offset;
_4cc.value=_4b4.value.substring(2);
_4b7[_4b7.length-1].addChild(_4cc,undefined,true);
_4cc.isProcessingInstruction=true;
_4b4=_4b3.next();
}
var _4ce=_4b4.content.length-1;
if(_4b4.content.charAt(_4b4.content.length-1)==">"){
_4cc.endOffset=_4b4.offset+_4b4.content.length;
_4cc.value+=_4b4.content.substring(0,_4ce);
_4bd(_4b4);
_4b9=undefined;
}else{
_4b9=_4cc;
_4cc.value+=_4b4.content;
}
_4ba=null;
break;
}
}while(true);
}
catch(e){
}
return {errors:_4b5,endOffset:(_4b4?_4b4.offset:0)};
};
return {parse:_4af};
});
},"dijit/form/ComboButton":function(){
define(["dojo/_base/declare","dojo/_base/event","dojo/keys","../focus","./DropDownButton","dojo/text!./templates/ComboButton.html"],function(_4cf,_4d0,keys,_4d1,_4d2,_4d3){
return _4cf("dijit.form.ComboButton",_4d2,{templateString:_4d3,_setIdAttr:"",_setTabIndexAttr:["focusNode","titleNode"],_setTitleAttr:"titleNode",optionsTitle:"",baseClass:"dijitComboButton",cssStateNodes:{"buttonNode":"dijitButtonNode","titleNode":"dijitButtonContents","_popupStateNode":"dijitDownArrowButton"},_focusedNode:null,_onButtonKeyPress:function(evt){
if(evt.charOrCode==keys[this.isLeftToRight()?"RIGHT_ARROW":"LEFT_ARROW"]){
_4d1.focus(this._popupStateNode);
_4d0.stop(evt);
}
},_onArrowKeyPress:function(evt){
if(evt.charOrCode==keys[this.isLeftToRight()?"LEFT_ARROW":"RIGHT_ARROW"]){
_4d1.focus(this.titleNode);
_4d0.stop(evt);
}
},focus:function(_4d4){
if(!this.disabled){
_4d1.focus(_4d4=="start"?this.titleNode:this._popupStateNode);
}
}});
});
},"url:dijit/templates/Calendar.html":"<table cellspacing=\"0\" cellpadding=\"0\" class=\"dijitCalendarContainer\" role=\"grid\" aria-labelledby=\"${id}_mddb ${id}_year\">\n\t<thead>\n\t\t<tr class=\"dijitReset dijitCalendarMonthContainer\" valign=\"top\">\n\t\t\t<th class='dijitReset dijitCalendarArrow' data-dojo-attach-point=\"decrementMonth\">\n\t\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitCalendarIncrementControl dijitCalendarDecrease\" role=\"presentation\"/>\n\t\t\t\t<span data-dojo-attach-point=\"decreaseArrowNode\" class=\"dijitA11ySideArrow\">-</span>\n\t\t\t</th>\n\t\t\t<th class='dijitReset' colspan=\"5\">\n\t\t\t\t<div data-dojo-attach-point=\"monthNode\">\n\t\t\t\t</div>\n\t\t\t</th>\n\t\t\t<th class='dijitReset dijitCalendarArrow' data-dojo-attach-point=\"incrementMonth\">\n\t\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitCalendarIncrementControl dijitCalendarIncrease\" role=\"presentation\"/>\n\t\t\t\t<span data-dojo-attach-point=\"increaseArrowNode\" class=\"dijitA11ySideArrow\">+</span>\n\t\t\t</th>\n\t\t</tr>\n\t\t<tr role=\"row\">\n\t\t\t${!dayCellsHtml}\n\t\t</tr>\n\t</thead>\n\t<tbody data-dojo-attach-point=\"dateRowsNode\" data-dojo-attach-event=\"onclick: _onDayClick\" class=\"dijitReset dijitCalendarBodyContainer\">\n\t\t\t${!dateRowsHtml}\n\t</tbody>\n\t<tfoot class=\"dijitReset dijitCalendarYearContainer\">\n\t\t<tr>\n\t\t\t<td class='dijitReset' valign=\"top\" colspan=\"7\" role=\"presentation\">\n\t\t\t\t<div class=\"dijitCalendarYearLabel\">\n\t\t\t\t\t<span data-dojo-attach-point=\"previousYearLabelNode\" class=\"dijitInline dijitCalendarPreviousYear\" role=\"button\"></span>\n\t\t\t\t\t<span data-dojo-attach-point=\"currentYearLabelNode\" class=\"dijitInline dijitCalendarSelectedYear\" role=\"button\" id=\"${id}_year\"></span>\n\t\t\t\t\t<span data-dojo-attach-point=\"nextYearLabelNode\" class=\"dijitInline dijitCalendarNextYear\" role=\"button\"></span>\n\t\t\t\t</div>\n\t\t\t</td>\n\t\t</tr>\n\t</tfoot>\n</table>\n","dijit/form/_AutoCompleterMixin":function(){
define(["dojo/data/util/filter","dojo/_base/declare","dojo/dom-attr","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/query","dojo/regexp","dojo/sniff","dojo/string","./DataList","../registry","./_TextBoxMixin","./_SearchMixin"],function(_4d5,_4d6,_4d7,_4d8,keys,lang,_4d9,_4da,has,_4db,_4dc,_4dd,_4de,_4df){
return _4d6("dijit.form._AutoCompleterMixin",_4df,{item:null,autoComplete:true,highlightMatch:"first",labelAttr:"",labelType:"text",maxHeight:-1,_stopClickEvents:false,_getCaretPos:function(_4e0){
var pos=0;
if(typeof (_4e0.selectionStart)=="number"){
pos=_4e0.selectionStart;
}else{
if(has("ie")){
var tr=_4e0.ownerDocument.selection.createRange().duplicate();
var ntr=_4e0.createTextRange();
tr.move("character",0);
ntr.move("character",0);
try{
ntr.setEndPoint("EndToEnd",tr);
pos=String(ntr.text).replace(/\r/g,"").length;
}
catch(e){
}
}
}
return pos;
},_setCaretPos:function(_4e1,_4e2){
_4e2=parseInt(_4e2);
_4de.selectInputText(_4e1,_4e2,_4e2);
},_setDisabledAttr:function(_4e3){
this.inherited(arguments);
this.domNode.setAttribute("aria-disabled",_4e3?"true":"false");
},_onKey:function(evt){
if(evt.charCode>=32){
return;
}
var key=evt.charCode||evt.keyCode;
if(key==keys.ALT||key==keys.CTRL||key==keys.META||key==keys.SHIFT){
return;
}
var pw=this.dropDown;
var _4e4=null;
this._abortQuery();
this.inherited(arguments);
if(evt.altKey||evt.ctrlKey||evt.metaKey){
return;
}
if(this._opened){
_4e4=pw.getHighlightedOption();
}
switch(key){
case keys.PAGE_DOWN:
case keys.DOWN_ARROW:
case keys.PAGE_UP:
case keys.UP_ARROW:
if(this._opened){
this._announceOption(_4e4);
}
_4d8.stop(evt);
break;
case keys.ENTER:
if(_4e4){
if(_4e4==pw.nextButton){
this._nextSearch(1);
_4d8.stop(evt);
break;
}else{
if(_4e4==pw.previousButton){
this._nextSearch(-1);
_4d8.stop(evt);
break;
}
}
_4d8.stop(evt);
}else{
this._setBlurValue();
this._setCaretPos(this.focusNode,this.focusNode.value.length);
}
case keys.TAB:
var _4e5=this.get("displayedValue");
if(pw&&(_4e5==pw._messages["previousMessage"]||_4e5==pw._messages["nextMessage"])){
break;
}
if(_4e4){
this._selectOption(_4e4);
}
case keys.ESCAPE:
if(this._opened){
this._lastQuery=null;
this.closeDropDown();
}
break;
}
},_autoCompleteText:function(text){
var fn=this.focusNode;
_4de.selectInputText(fn,fn.value.length);
var _4e6=this.ignoreCase?"toLowerCase":"substr";
if(text[_4e6](0).indexOf(this.focusNode.value[_4e6](0))==0){
var cpos=this.autoComplete?this._getCaretPos(fn):fn.value.length;
if((cpos+1)>fn.value.length){
fn.value=text;
_4de.selectInputText(fn,cpos);
}
}else{
fn.value=text;
_4de.selectInputText(fn);
}
},_openResultList:function(_4e7,_4e8,_4e9){
var _4ea=this.dropDown.getHighlightedOption();
this.dropDown.clearResultList();
if(!_4e7.length&&_4e9.start==0){
this.closeDropDown();
return;
}
this._nextSearch=this.dropDown.onPage=lang.hitch(this,function(_4eb){
_4e7.nextPage(_4eb!==-1);
this.focus();
});
this.dropDown.createOptions(_4e7,_4e9,lang.hitch(this,"_getMenuLabelFromItem"));
this._showResultList();
if("direction" in _4e9){
if(_4e9.direction){
this.dropDown.highlightFirstOption();
}else{
if(!_4e9.direction){
this.dropDown.highlightLastOption();
}
}
if(_4ea){
this._announceOption(this.dropDown.getHighlightedOption());
}
}else{
if(this.autoComplete&&!this._prev_key_backspace&&!/^[*]+$/.test(_4e8[this.searchAttr].toString())){
this._announceOption(this.dropDown.containerNode.firstChild.nextSibling);
}
}
},_showResultList:function(){
this.closeDropDown(true);
this.openDropDown();
this.domNode.setAttribute("aria-expanded","true");
},loadDropDown:function(){
this._startSearchAll();
},isLoaded:function(){
return false;
},closeDropDown:function(){
this._abortQuery();
if(this._opened){
this.inherited(arguments);
this.domNode.setAttribute("aria-expanded","false");
this.focusNode.removeAttribute("aria-activedescendant");
}
},_setBlurValue:function(){
var _4ec=this.get("displayedValue");
var pw=this.dropDown;
if(pw&&(_4ec==pw._messages["previousMessage"]||_4ec==pw._messages["nextMessage"])){
this._setValueAttr(this._lastValueReported,true);
}else{
if(typeof this.item=="undefined"){
this.item=null;
this.set("displayedValue",_4ec);
}else{
if(this.value!=this._lastValueReported){
this._handleOnChange(this.value,true);
}
this._refreshState();
}
}
},_setItemAttr:function(item,_4ed,_4ee){
var _4ef="";
if(item){
if(!_4ee){
_4ee=this.store._oldAPI?this.store.getValue(item,this.searchAttr):item[this.searchAttr];
}
_4ef=this._getValueField()!=this.searchAttr?this.store.getIdentity(item):_4ee;
}
this.set("value",_4ef,_4ed,_4ee,item);
},_announceOption:function(node){
if(!node){
return;
}
var _4f0;
if(node==this.dropDown.nextButton||node==this.dropDown.previousButton){
_4f0=node.innerHTML;
this.item=undefined;
this.value="";
}else{
var item=this.dropDown.items[node.getAttribute("item")];
_4f0=(this.store._oldAPI?this.store.getValue(item,this.searchAttr):item[this.searchAttr]).toString();
this.set("item",item,false,_4f0);
}
this.focusNode.value=this.focusNode.value.substring(0,this._lastInput.length);
this.focusNode.setAttribute("aria-activedescendant",_4d7.get(node,"id"));
this._autoCompleteText(_4f0);
},_selectOption:function(_4f1){
this.closeDropDown();
if(_4f1){
this._announceOption(_4f1);
}
this._setCaretPos(this.focusNode,this.focusNode.value.length);
this._handleOnChange(this.value,true);
},_startSearchAll:function(){
this._startSearch("");
},_startSearchFromInput:function(){
this.item=undefined;
this.inherited(arguments);
},_startSearch:function(key){
if(!this.dropDown){
var _4f2=this.id+"_popup",_4f3=lang.isString(this.dropDownClass)?lang.getObject(this.dropDownClass,false):this.dropDownClass;
this.dropDown=new _4f3({onChange:lang.hitch(this,this._selectOption),id:_4f2,dir:this.dir,textDir:this.textDir});
this.focusNode.removeAttribute("aria-activedescendant");
this.textbox.setAttribute("aria-owns",_4f2);
}
this._lastInput=key;
this.inherited(arguments);
},_getValueField:function(){
return this.searchAttr;
},postMixInProperties:function(){
this.inherited(arguments);
if(!this.store){
var _4f4=this.srcNodeRef;
this.store=new _4dc({},_4f4);
if(!("value" in this.params)){
var item=(this.item=this.store.fetchSelectedItem());
if(item){
var _4f5=this._getValueField();
this.value=this.store._oldAPI?this.store.getValue(item,_4f5):item[_4f5];
}
}
}
},postCreate:function(){
var _4f6=_4d9("label[for=\""+this.id+"\"]");
if(_4f6.length){
if(!_4f6[0].id){
_4f6[0].id=this.id+"_label";
}
this.domNode.setAttribute("aria-labelledby",_4f6[0].id);
}
this.inherited(arguments);
this.connect(this,"onSearch","_openResultList");
},_getMenuLabelFromItem:function(item){
var _4f7=this.labelFunc(item,this.store),_4f8=this.labelType;
if(this.highlightMatch!="none"&&this.labelType=="text"&&this._lastInput){
_4f7=this.doHighlight(_4f7,this._lastInput);
_4f8="html";
}
return {html:_4f8=="html",label:_4f7};
},doHighlight:function(_4f9,find){
var _4fa=(this.ignoreCase?"i":"")+(this.highlightMatch=="all"?"g":""),i=this.queryExpr.indexOf("${0}");
find=_4da.escapeString(find);
return this._escapeHtml(_4f9.replace(new RegExp((i==0?"^":"")+"("+find+")"+(i==(this.queryExpr.length-4)?"$":""),_4fa),"\uffff$1\uffff")).replace(/\uFFFF([^\uFFFF]+)\uFFFF/g,"<span class=\"dijitComboBoxHighlightMatch\">$1</span>");
},_escapeHtml:function(str){
str=String(str).replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
return str;
},reset:function(){
this.item=null;
this.inherited(arguments);
},labelFunc:function(item,_4fb){
return (_4fb._oldAPI?_4fb.getValue(item,this.labelAttr||this.searchAttr):item[this.labelAttr||this.searchAttr]).toString();
},_setValueAttr:function(_4fc,_4fd,_4fe,item){
this._set("item",item||null);
if(_4fc==null){
_4fc="";
}
this.inherited(arguments);
},_setTextDirAttr:function(_4ff){
this.inherited(arguments);
if(this.dropDown){
this.dropDown._set("textDir",_4ff);
}
}});
});
},"davinci/ve/DijitWidget":function(){
define(["require","dojo/_base/declare","dojo/_base/window","dojo/_base/lang","dojo/dom-attr","dojo/parser","./_Widget","./metadata"],function(_500,_501,_502,_503,_504,_505,_506,_507){
var _508="__DijitWidgetScratchSpace";
return _501("davinci.ve.DijitWidget",_506,{isDijitWidget:true,constructor:function(_509,node,_50a,_50b,_50c,_50d){
if(typeof _50a==="string"){
var type=_504.get(node,"data-dojo-type")||_504.get(node,"dojoType");
if(!type){
_504.set(node,"data-dojo-type",_50a);
}
if(_50c){
_50c.addAttribute("data-dojo-type",_50a);
}
var doc=node.ownerDocument,win=doc.defaultView,ss=doc[_508];
if(!ss){
ss=doc[_508]=doc.createElement("div");
}
ss.appendChild(node);
var _50e=win.require("dojo/parser").instantiate([node],_509,{noStart:true});
_50a=_50e[0];
if(ss.firstChild){
ss.removeChild(ss.firstChild);
}
this.domNode=_50a.domNode;
_50a.domNode._dvWidget=this;
this.isLayoutContainer=_50a.isLayoutContainer;
}else{
if(!_50d){
this.type=_50a.declaredClass.replace(/\./g,"/");
}else{
this.type=_50d.replace(/\./g,"/");
}
}
var _50f=davinci.ve.metadata.getAllowedChild(this.type);
this.acceptsHTMLChildren=_50f[0]==="ANY"||_50f.toString().toUpperCase().indexOf("HTML")!==-1;
this.dijitWidget=_50a;
this.containerNode=_50a.containerNode;
this.styleNode=_50a.styleNode;
this.id=_50a.id;
},getParent:function(){
if(!this.dijitWidget||!this.dijitWidget.domNode||!this.dijitWidget.domNode.parentNode){
return;
}
var _510=_500("davinci/ve/widget");
var _511=this.dijitWidget;
do{
_511=_510.getEnclosingWidget(_511.domNode.parentNode);
}while(_511&&_511.dijitWidget&&_511.dijitWidget.declaredClass.split(".").pop().charAt(0)=="_");
return _511;
},_getChildren:function(_512){
if(this.acceptsHTMLChildren){
return this.inherited(arguments);
}
var _513=[];
if(davinci.ve.metadata.getAllowedChild(this.type)[0]!=="NONE"){
this.dijitWidget.getChildren().forEach(function(_514){
if(!_514._maqNotDVWidget){
if(_512){
_513.push(_500("davinci/ve/widget").getWidget(_514.domNode));
}else{
var _515=_514.domNode&&_514.domNode._dvWidget;
if(_515){
_513.push(_515);
}
}
}
});
}
return _513;
},_getContainerNode:function(){
return this.containerNode||this.domNode;
},selectChild:function(_516){
if(this.dijitWidget.selectChild){
this.dijitWidget.selectChild(_516.dijitWidget);
}
},_addChildToDom:function(_517,_518){
if(!this.acceptsHTMLChildren){
this.dijitWidget.addChild(_517.dijitWidget,_518);
}else{
this.inherited(arguments);
var dw=_517.dijitWidget;
if(dw&&this.dijitWidget._started&&!dw._started){
_517.startup();
}
}
},_removeChildFromDom:function(_519){
if(this.dijitWidget.removeChild&&_519.dijitWidget){
this.dijitWidget.removeChild(_519.dijitWidget);
}else{
this.inherited(arguments);
}
},_getPropertyValue:function(name){
return this.dijitWidget.get(name);
},startup:function(){
this.dijitWidget.startup();
},isLayout:function(){
var _51a=this.getContext();
var djit=_51a.getDijit();
var _51b=this.dijitWidget.isInstanceOf(djit.layout._LayoutWidget);
return _51b;
},resize:function(){
var _51c=this.getHelper();
if(_51c&&_51c.resize){
_51c.resize(this);
}else{
if(this.dijitWidget.resize){
this.dijitWidget.resize();
}
}
},renderWidget:function(){
if(this.dijitWidget.render){
this.dijitWidget.render();
}else{
if(this.dijitWidget.chart){
var box=dojo.marginBox(this.dijitWidget.domNode);
this.dijitWidget.resize(box);
}
}
if(this.domNode.parentNode._dvWidget&&this.domNode.parentNode._dvWidget.isDijitWidget){
this._refresh(this.domNode.parentNode);
}
},_refresh:function(node){
var _51d=node.parentNode;
if(_51d._dvWidget&&_51d._dvWidget.isDijitWidget){
this._refresh(_51d);
}else{
if(node._dvWidget.resize){
node._dvWidget.resize();
}
}
},_attr:function(name,_51e){
return this.dijitWidget.get.apply(this.dijitWidget,arguments);
}});
});
},"dojox/grid/Selection":function(){
define(["dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/dom-attr"],function(_51f,_520,lang,_521){
return _51f("dojox.grid.Selection",null,{constructor:function(_522){
this.grid=_522;
this.selected=[];
this.setMode(_522.selectionMode);
},mode:"extended",selected:null,updating:0,selectedIndex:-1,rangeStartIndex:-1,setMode:function(mode){
if(this.selected.length){
this.deselectAll();
}
if(mode!="extended"&&mode!="multiple"&&mode!="single"&&mode!="none"){
this.mode="extended";
}else{
this.mode=mode;
}
},onCanSelect:function(_523){
return this.grid.onCanSelect(_523);
},onCanDeselect:function(_524){
return this.grid.onCanDeselect(_524);
},onSelected:function(_525){
},onDeselected:function(_526){
},onChanging:function(){
},onChanged:function(){
},isSelected:function(_527){
if(this.mode=="none"){
return false;
}
return this.selected[_527];
},getFirstSelected:function(){
if(!this.selected.length||this.mode=="none"){
return -1;
}
for(var i=0,l=this.selected.length;i<l;i++){
if(this.selected[i]){
return i;
}
}
return -1;
},getNextSelected:function(_528){
if(this.mode=="none"){
return -1;
}
for(var i=_528+1,l=this.selected.length;i<l;i++){
if(this.selected[i]){
return i;
}
}
return -1;
},getSelected:function(){
var _529=[];
for(var i=0,l=this.selected.length;i<l;i++){
if(this.selected[i]){
_529.push(i);
}
}
return _529;
},getSelectedCount:function(){
var c=0;
for(var i=0;i<this.selected.length;i++){
if(this.selected[i]){
c++;
}
}
return c;
},_beginUpdate:function(){
if(this.updating===0){
this.onChanging();
}
this.updating++;
},_endUpdate:function(){
this.updating--;
if(this.updating===0){
this.onChanged();
}
},select:function(_52a){
if(this.mode=="none"){
return;
}
if(this.mode!="multiple"){
this.deselectAll(_52a);
this.addToSelection(_52a);
}else{
this.toggleSelect(_52a);
}
},addToSelection:function(_52b){
if(this.mode=="none"){
return;
}
if(lang.isArray(_52b)){
_520.forEach(_52b,this.addToSelection,this);
return;
}
_52b=Number(_52b);
if(this.selected[_52b]){
this.selectedIndex=_52b;
}else{
if(this.onCanSelect(_52b)!==false){
this.selectedIndex=_52b;
var _52c=this.grid.getRowNode(_52b);
if(_52c){
_521.set(_52c,"aria-selected","true");
}
this._beginUpdate();
this.selected[_52b]=true;
this.onSelected(_52b);
this._endUpdate();
}
}
},deselect:function(_52d){
if(this.mode=="none"){
return;
}
if(lang.isArray(_52d)){
_520.forEach(_52d,this.deselect,this);
return;
}
_52d=Number(_52d);
if(this.selectedIndex==_52d){
this.selectedIndex=-1;
}
if(this.selected[_52d]){
if(this.onCanDeselect(_52d)===false){
return;
}
var _52e=this.grid.getRowNode(_52d);
if(_52e){
_521.set(_52e,"aria-selected","false");
}
this._beginUpdate();
delete this.selected[_52d];
this.onDeselected(_52d);
this._endUpdate();
}
},setSelected:function(_52f,_530){
this[(_530?"addToSelection":"deselect")](_52f);
},toggleSelect:function(_531){
if(lang.isArray(_531)){
_520.forEach(_531,this.toggleSelect,this);
return;
}
this.setSelected(_531,!this.selected[_531]);
},_range:function(_532,inTo,func){
var s=(_532>=0?_532:inTo),e=inTo;
if(s>e){
e=s;
s=inTo;
}
for(var i=s;i<=e;i++){
func(i);
}
},selectRange:function(_533,inTo){
this._range(_533,inTo,lang.hitch(this,"addToSelection"));
},deselectRange:function(_534,inTo){
this._range(_534,inTo,lang.hitch(this,"deselect"));
},insert:function(_535){
this.selected.splice(_535,0,false);
if(this.selectedIndex>=_535){
this.selectedIndex++;
}
},remove:function(_536){
this.selected.splice(_536,1);
if(this.selectedIndex>=_536){
this.selectedIndex--;
}
},deselectAll:function(_537){
for(var i in this.selected){
if((i!=_537)&&(this.selected[i]===true)){
this.deselect(i);
}
}
},clickSelect:function(_538,_539,_53a){
if(this.mode=="none"){
return;
}
this._beginUpdate();
if(this.mode!="extended"){
this.select(_538);
}else{
if(!_53a||this.rangeStartIndex<0){
this.rangeStartIndex=_538;
}
if(!_539){
this.deselectAll(_538);
}
if(_53a){
this.selectRange(this.rangeStartIndex,_538);
}else{
if(_539){
this.toggleSelect(_538);
}else{
this.addToSelection(_538);
}
}
}
this._endUpdate();
},clickSelectEvent:function(e){
this.clickSelect(e.rowIndex,dojo.isCopyKey(e),e.shiftKey);
},clear:function(){
this._beginUpdate();
this.deselectAll();
this._endUpdate();
}});
});
},"url:dijit/layout/templates/_ScrollingTabControllerButton.html":"<div data-dojo-attach-event=\"onclick:_onClick\" class=\"dijitTabInnerDiv dijitTabContent dijitButtonContents\"  data-dojo-attach-point=\"focusNode\">\n\t<img role=\"presentation\" alt=\"\" src=\"${_blankGif}\" class=\"dijitTabStripIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t<span data-dojo-attach-point=\"containerNode,titleNode\" class=\"dijitButtonText\"></span>\n</div>","dijit/form/MappedTextBox":function(){
define(["dojo/_base/declare","dojo/dom-construct","./ValidationTextBox"],function(_53b,_53c,_53d){
return _53b("dijit.form.MappedTextBox",_53d,{postMixInProperties:function(){
this.inherited(arguments);
this.nameAttrSetting="";
},_setNameAttr:null,serialize:function(val){
return val.toString?val.toString():"";
},toString:function(){
var val=this.filter(this.get("value"));
return val!=null?(typeof val=="string"?val:this.serialize(val,this.constraints)):"";
},validate:function(){
this.valueNode.value=this.toString();
return this.inherited(arguments);
},buildRendering:function(){
this.inherited(arguments);
this.valueNode=_53c.place("<input type='hidden'"+(this.name?" name=\""+this.name.replace(/"/g,"&quot;")+"\"":"")+"/>",this.textbox,"after");
},reset:function(){
this.valueNode.value="";
this.inherited(arguments);
}});
});
},"dijit/form/ComboBoxMixin":function(){
define(["dojo/_base/declare","dojo/_base/Deferred","dojo/_base/kernel","dojo/_base/lang","dojo/store/util/QueryResults","./_AutoCompleterMixin","./_ComboBoxMenu","../_HasDropDown","dojo/text!./templates/DropDownBox.html"],function(_53e,_53f,_540,lang,_541,_542,_543,_544,_545){
return _53e("dijit.form.ComboBoxMixin",[_544,_542],{dropDownClass:_543,hasDownArrow:true,templateString:_545,baseClass:"dijitTextBox dijitComboBox",cssStateNodes:{"_buttonNode":"dijitDownArrowButton"},_setHasDownArrowAttr:function(val){
this._set("hasDownArrow",val);
this._buttonNode.style.display=val?"":"none";
},_showResultList:function(){
this.displayMessage("");
this.inherited(arguments);
},_setStoreAttr:function(_546){
if(!_546.get){
lang.mixin(_546,{_oldAPI:true,get:function(id){
var _547=new _53f();
this.fetchItemByIdentity({identity:id,onItem:function(_548){
_547.resolve(_548);
},onError:function(_549){
_547.reject(_549);
}});
return _547.promise;
},query:function(_54a,_54b){
var _54c=new _53f(function(){
_54d.abort&&_54d.abort();
});
_54c.total=new _53f();
var _54d=this.fetch(lang.mixin({query:_54a,onBegin:function(_54e){
_54c.total.resolve(_54e);
},onComplete:function(_54f){
_54c.resolve(_54f);
},onError:function(_550){
_54c.reject(_550);
}},_54b));
return _541(_54c);
}});
}
this._set("store",_546);
},postMixInProperties:function(){
var _551=this.params.store||this.store;
if(_551){
this._setStoreAttr(_551);
}
this.inherited(arguments);
if(!this.params.store&&!this.store._oldAPI){
var _552=this.declaredClass;
lang.mixin(this.store,{getValue:function(item,attr){
_540.deprecated(_552+".store.getValue(item, attr) is deprecated for builtin store.  Use item.attr directly","","2.0");
return item[attr];
},getLabel:function(item){
_540.deprecated(_552+".store.getLabel(item) is deprecated for builtin store.  Use item.label directly","","2.0");
return item.name;
},fetch:function(args){
_540.deprecated(_552+".store.fetch() is deprecated for builtin store.","Use store.query()","2.0");
var shim=["dojo/data/ObjectStore"];
require(shim,lang.hitch(this,function(_553){
new _553({objectStore:this}).fetch(args);
}));
}});
}
}});
});
},"dijit/form/_TextBoxMixin":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/on","../main"],function(_554,_555,dom,_556,keys,lang,on,_557){
var _558=_555("dijit.form._TextBoxMixin",null,{trim:false,uppercase:false,lowercase:false,propercase:false,maxLength:"",selectOnClick:false,placeHolder:"",_getValueAttr:function(){
return this.parse(this.get("displayedValue"),this.constraints);
},_setValueAttr:function(_559,_55a,_55b){
var _55c;
if(_559!==undefined){
_55c=this.filter(_559);
if(typeof _55b!="string"){
if(_55c!==null&&((typeof _55c!="number")||!isNaN(_55c))){
_55b=this.filter(this.format(_55c,this.constraints));
}else{
_55b="";
}
}
}
if(_55b!=null&&((typeof _55b)!="number"||!isNaN(_55b))&&this.textbox.value!=_55b){
this.textbox.value=_55b;
this._set("displayedValue",this.get("displayedValue"));
}
if(this.textDir=="auto"){
this.applyTextDir(this.focusNode,_55b);
}
this.inherited(arguments,[_55c,_55a]);
},displayedValue:"",_getDisplayedValueAttr:function(){
return this.filter(this.textbox.value);
},_setDisplayedValueAttr:function(_55d){
if(_55d==null){
_55d="";
}else{
if(typeof _55d!="string"){
_55d=String(_55d);
}
}
this.textbox.value=_55d;
this._setValueAttr(this.get("value"),undefined);
this._set("displayedValue",this.get("displayedValue"));
if(this.textDir=="auto"){
this.applyTextDir(this.focusNode,_55d);
}
},format:function(_55e){
return _55e==null?"":(_55e.toString?_55e.toString():_55e);
},parse:function(_55f){
return _55f;
},_refreshState:function(){
},onInput:function(){
},__skipInputEvent:false,_onInput:function(evt){
if(this.textDir=="auto"){
this.applyTextDir(this.focusNode,this.focusNode.value);
}
this._processInput(evt);
},_processInput:function(evt){
this._refreshState();
this._set("displayedValue",this.get("displayedValue"));
},postCreate:function(){
this.textbox.setAttribute("value",this.textbox.value);
this.inherited(arguments);
var _560=function(e){
var _561;
if(e.type=="keydown"){
_561=e.keyCode;
switch(_561){
case keys.SHIFT:
case keys.ALT:
case keys.CTRL:
case keys.META:
case keys.CAPS_LOCK:
case keys.NUM_LOCK:
case keys.SCROLL_LOCK:
return;
}
if(!e.ctrlKey&&!e.metaKey&&!e.altKey){
switch(_561){
case keys.NUMPAD_0:
case keys.NUMPAD_1:
case keys.NUMPAD_2:
case keys.NUMPAD_3:
case keys.NUMPAD_4:
case keys.NUMPAD_5:
case keys.NUMPAD_6:
case keys.NUMPAD_7:
case keys.NUMPAD_8:
case keys.NUMPAD_9:
case keys.NUMPAD_MULTIPLY:
case keys.NUMPAD_PLUS:
case keys.NUMPAD_ENTER:
case keys.NUMPAD_MINUS:
case keys.NUMPAD_PERIOD:
case keys.NUMPAD_DIVIDE:
return;
}
if((_561>=65&&_561<=90)||(_561>=48&&_561<=57)||_561==keys.SPACE){
return;
}
var _562=false;
for(var i in keys){
if(keys[i]===e.keyCode){
_562=true;
break;
}
}
if(!_562){
return;
}
}
}
_561=e.charCode>=32?String.fromCharCode(e.charCode):e.charCode;
if(!_561){
_561=(e.keyCode>=65&&e.keyCode<=90)||(e.keyCode>=48&&e.keyCode<=57)||e.keyCode==keys.SPACE?String.fromCharCode(e.keyCode):e.keyCode;
}
if(!_561){
_561=229;
}
if(e.type=="keypress"){
if(typeof _561!="string"){
return;
}
if((_561>="a"&&_561<="z")||(_561>="A"&&_561<="Z")||(_561>="0"&&_561<="9")||(_561===" ")){
if(e.ctrlKey||e.metaKey||e.altKey){
return;
}
}
}
if(e.type=="input"){
if(this.__skipInputEvent){
this.__skipInputEvent=false;
return;
}
}else{
this.__skipInputEvent=true;
}
var faux={faux:true},attr;
for(attr in e){
if(attr!="layerX"&&attr!="layerY"){
var v=e[attr];
if(typeof v!="function"&&typeof v!="undefined"){
faux[attr]=v;
}
}
}
lang.mixin(faux,{charOrCode:_561,_wasConsumed:false,preventDefault:function(){
faux._wasConsumed=true;
e.preventDefault();
},stopPropagation:function(){
e.stopPropagation();
}});
if(this.onInput(faux)===false){
faux.preventDefault();
faux.stopPropagation();
}
if(faux._wasConsumed){
return;
}
this.defer(function(){
this._onInput(faux);
});
};
this.own(on(this.textbox,"keydown, keypress, paste, cut, input, compositionend",lang.hitch(this,_560)));
},_blankValue:"",filter:function(val){
if(val===null){
return this._blankValue;
}
if(typeof val!="string"){
return val;
}
if(this.trim){
val=lang.trim(val);
}
if(this.uppercase){
val=val.toUpperCase();
}
if(this.lowercase){
val=val.toLowerCase();
}
if(this.propercase){
val=val.replace(/[^\s]+/g,function(word){
return word.substring(0,1).toUpperCase()+word.substring(1);
});
}
return val;
},_setBlurValue:function(){
this._setValueAttr(this.get("value"),true);
},_onBlur:function(e){
if(this.disabled){
return;
}
this._setBlurValue();
this.inherited(arguments);
},_isTextSelected:function(){
return this.textbox.selectionStart!=this.textbox.selectionEnd;
},_onFocus:function(by){
if(this.disabled||this.readOnly){
return;
}
if(this.selectOnClick&&by=="mouse"){
this._selectOnClickHandle=this.connect(this.domNode,"onmouseup",function(){
this.disconnect(this._selectOnClickHandle);
this._selectOnClickHandle=null;
if(!this._isTextSelected()){
_558.selectInputText(this.textbox);
}
});
this.defer(function(){
if(this._selectOnClickHandle){
this.disconnect(this._selectOnClickHandle);
this._selectOnClickHandle=null;
}
},500);
}
this.inherited(arguments);
this._refreshState();
},reset:function(){
this.textbox.value="";
this.inherited(arguments);
},_setTextDirAttr:function(_563){
if(!this._created||this.textDir!=_563){
this._set("textDir",_563);
this.applyTextDir(this.focusNode,this.focusNode.value);
}
}});
_558._setSelectionRange=_557._setSelectionRange=function(_564,_565,stop){
if(_564.setSelectionRange){
_564.setSelectionRange(_565,stop);
}
};
_558.selectInputText=_557.selectInputText=function(_566,_567,stop){
_566=dom.byId(_566);
if(isNaN(_567)){
_567=0;
}
if(isNaN(stop)){
stop=_566.value?_566.value.length:0;
}
try{
_566.focus();
_558._setSelectionRange(_566,_567,stop);
}
catch(e){
}
};
return _558;
});
},"davinci/html/HTMLModel":function(){
define(["dojo/_base/declare","davinci/model/Model"],function(_568,_569){
if(!davinci.html){
davinci.html={};
}
davinci.html._noFormatElements={span:true,b:true,it:true};
davinci.html.escapeXml=function(_56a){
if(!_56a){
return _56a;
}
return _56a.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;");
};
davinci.html.unEscapeXml=function(_56b){
if(!_56b||typeof _56b!=="string"){
return _56b;
}
return _56b.replace(/&quot;/g,"\"").replace(/&gt;/g,">").replace(/&lt;/g,"<").replace(/&amp;/g,"&");
};
return _568("davinci.html.HTMLModel",_569,{});
});
},"dijit/form/SimpleTextarea":function(){
define(["dojo/_base/declare","dojo/dom-class","dojo/sniff","./TextBox"],function(_56c,_56d,has,_56e){
return _56c("dijit.form.SimpleTextarea",_56e,{baseClass:"dijitTextBox dijitTextArea",rows:"3",cols:"20",templateString:"<textarea ${!nameAttrSetting} data-dojo-attach-point='focusNode,containerNode,textbox' autocomplete='off'></textarea>",postMixInProperties:function(){
if(!this.value&&this.srcNodeRef){
this.value=this.srcNodeRef.value;
}
this.inherited(arguments);
},buildRendering:function(){
this.inherited(arguments);
if(has("ie")&&this.cols){
_56d.add(this.textbox,"dijitTextAreaCols");
}
},filter:function(_56f){
if(_56f){
_56f=_56f.replace(/\r/g,"");
}
return this.inherited(arguments);
},_onInput:function(e){
if(this.maxLength){
var _570=parseInt(this.maxLength);
var _571=this.textbox.value.replace(/\r/g,"");
var _572=_571.length-_570;
if(_572>0){
var _573=this.textbox;
if(_573.selectionStart){
var pos=_573.selectionStart;
var cr=0;
if(has("opera")){
cr=(this.textbox.value.substring(0,pos).match(/\r/g)||[]).length;
}
this.textbox.value=_571.substring(0,pos-_572-cr)+_571.substring(pos-cr);
_573.setSelectionRange(pos-_572,pos-_572);
}else{
if(this.ownerDocument.selection){
_573.focus();
var _574=this.ownerDocument.selection.createRange();
_574.moveStart("character",-_572);
_574.text="";
_574.select();
}
}
}
}
this.inherited(arguments);
}});
});
},"davinci/js/JSModel":function(){
define(["dojo/_base/declare","davinci/model/Model"],function(_575,_576){
if(!davinci.js){
davinci.js={};
}
return _575("davinci.js.JSModel",_576,{});
});
},"url:dijit/layout/templates/_TabButton.html":"<div role=\"presentation\" data-dojo-attach-point=\"titleNode,innerDiv,tabContent\" class=\"dijitTabInner dijitTabContent\">\n\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon dijitTabButtonIcon\" data-dojo-attach-point='iconNode'/>\n\t<span data-dojo-attach-point='containerNode,focusNode' class='tabLabel'></span>\n\t<span class=\"dijitInline dijitTabCloseButton dijitTabCloseIcon\" data-dojo-attach-point='closeNode'\n\t\t  role=\"presentation\">\n\t\t<span data-dojo-attach-point='closeText' class='dijitTabCloseText'>[x]</span\n\t\t\t\t></span>\n</div>\n","davinci/review/model/resource/root":function(){
define(["dojo/_base/declare","davinci/model/resource/Resource","davinci/review/model/resource/Folder","davinci/Runtime","dojo/Deferred"],function(_577,_578,_579,_57a,_57b){
var root=_577(_578,{constructor:function(args){
this.elementType="ReviewRoot";
this.name="root";
this.parent=null;
},findFile:function(_57c,_57d){
var _57e=new _57b();
this.getChildren(function(_57f){
var node=null;
dojo.forEach(_57f,function(item){
if(item.timeStamp==_57c){
node=item;
}
});
var _580=null;
if(node!=null){
node.getChildren(function(_581){
dojo.forEach(_581,function(item){
if(this._fileNamesEqual(item.name,_57d)){
_580=item;
}
}.bind(this));
_57e.resolve(_580);
}.bind(this));
}
}.bind(this));
return _57e;
},_fileNamesEqual:function(_582,_583){
if(_582.indexOf("./")!=0){
_582="./"+_582;
}
if(_583.indexOf("./")!=0){
_583="./"+_583;
}
return _582===_583;
},findVersion:function(_584,_585){
var _586=new _57b();
this.getChildren(function(_587){
var _588=null;
dojo.some(_587,function(item){
if(item.designerId==_584&&item.timeStamp==_585){
_588=item;
return true;
}
return false;
});
_586.resolve(_588);
});
return _586;
},getChildren:function(_589,_58a){
if(!this._isLoaded){
if(this._loading){
this._loading.push(_589);
return;
}
this._loading=[];
this._loading.push(_589);
_57a.serverJSONRequest({url:"cmd/listVersions",load:dojo.hitch(this,function(_58b,_58c){
this.children=[];
for(var i=0;i<_58b.length;i++){
var _58d=new _579(dojo.mixin({name:_58b[i].versionTitle,parent:this},_58b[i]));
this.children.push(_58d);
}
this._isLoaded=true;
dojo.forEach(this._loading,function(item){
(item)(this.children);
},this);
delete this._loading;
})});
return;
}
_589(this.children);
},getPath:function(){
return ".review/snapshot";
}});
return dojo.setObject("davinci.review.model.resource.root",new root());
});
},"dijit/PopupMenuItem":function(){
define(["dojo/_base/declare","dojo/dom-style","dojo/query","./registry","./MenuItem","./hccss"],function(_58e,_58f,_590,_591,_592){
return _58e("dijit.PopupMenuItem",_592,{_fillContent:function(){
if(this.srcNodeRef){
var _593=_590("*",this.srcNodeRef);
this.inherited(arguments,[_593[0]]);
this.dropDownContainer=this.srcNodeRef;
}
},startup:function(){
if(this._started){
return;
}
this.inherited(arguments);
if(!this.popup){
var node=_590("[widgetId]",this.dropDownContainer)[0];
this.popup=_591.byNode(node);
}
this.ownerDocumentBody.appendChild(this.popup.domNode);
this.popup.startup();
this.popup.domNode.style.display="none";
if(this.arrowWrapper){
_58f.set(this.arrowWrapper,"visibility","");
}
this.focusNode.setAttribute("aria-haspopup","true");
},destroyDescendants:function(_594){
if(this.popup){
if(!this.popup._destroyed){
this.popup.destroyRecursive(_594);
}
delete this.popup;
}
this.inherited(arguments);
}});
});
},"dijit/_TimePicker":function(){
define(["dojo/_base/array","dojo/date","dojo/date/locale","dojo/date/stamp","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/_base/event","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/query","dojo/mouse","./typematic","./_Widget","./_TemplatedMixin","./form/_FormValueWidget","dojo/text!./templates/TimePicker.html"],function(_595,_596,_597,_598,_599,_59a,_59b,_59c,_59d,keys,lang,has,_59e,_59f,_5a0,_5a1,_5a2,_5a3,_5a4){
var _5a5=_599("dijit._TimePicker",[_5a1,_5a2],{templateString:_5a4,baseClass:"dijitTimePicker",clickableIncrement:"T00:15:00",visibleIncrement:"T01:00:00",visibleRange:"T05:00:00",value:new Date(),_visibleIncrement:2,_clickableIncrement:1,_totalIncrements:10,constraints:{},serialize:_598.toISOString,setValue:function(_5a6){
_59d.deprecated("dijit._TimePicker:setValue() is deprecated.  Use set('value', ...) instead.","","2.0");
this.set("value",_5a6);
},_setValueAttr:function(date){
this._set("value",date);
this._showText();
},_setFilterStringAttr:function(val){
this._set("filterString",val);
this._showText();
},isDisabledDate:function(){
return false;
},_getFilteredNodes:function(_5a7,_5a8,_5a9,_5aa){
var _5ab=[],_5ac=_5aa?_5aa.date:this._refDate,n,i=_5a7,max=this._maxIncrement+Math.abs(i),chk=_5a9?-1:1,dec=_5a9?1:0,inc=1-dec;
do{
i-=dec;
n=this._createOption(i);
if(n){
if((_5a9&&n.date>_5ac)||(!_5a9&&n.date<_5ac)){
break;
}
_5ab[_5a9?"unshift":"push"](n);
_5ac=n.date;
}
i+=inc;
}while(_5ab.length<_5a8&&(i*chk)<max);
return _5ab;
},_showText:function(){
var _5ad=_598.fromISOString;
this.timeMenu.innerHTML="";
this._clickableIncrementDate=_5ad(this.clickableIncrement);
this._visibleIncrementDate=_5ad(this.visibleIncrement);
this._visibleRangeDate=_5ad(this.visibleRange);
var _5ae=function(date){
return date.getHours()*60*60+date.getMinutes()*60+date.getSeconds();
},_5af=_5ae(this._clickableIncrementDate),_5b0=_5ae(this._visibleIncrementDate),_5b1=_5ae(this._visibleRangeDate),time=(this.value||this.currentFocus).getTime();
this._refDate=new Date(time-time%(_5af*1000));
this._refDate.setFullYear(1970,0,1);
this._clickableIncrement=1;
this._totalIncrements=_5b1/_5af;
this._visibleIncrement=_5b0/_5af;
this._maxIncrement=(60*60*24)/_5af;
var _5b2=Math.min(this._totalIncrements,10),_5b3=this._getFilteredNodes(0,(_5b2>>1)+1,false),_5b4=[],_5b5=_5b2-_5b3.length,_5b6=this._getFilteredNodes(0,_5b5,true,_5b3[0]);
if(_5b6.length<_5b5&&_5b3.length>0){
_5b4=this._getFilteredNodes(_5b3[_5b3.length-1].idx+1,_5b5-_5b6.length,false,_5b3[_5b3.length-1]);
}
_595.forEach(_5b6.concat(_5b3,_5b4),function(n){
this.timeMenu.appendChild(n);
},this);
if(!_5b6.length&&!_5b3.length&&!_5b4.length&&this.filterString){
this.filterString="";
this._showText();
}
},constructor:function(){
this.constraints={};
},postMixInProperties:function(){
this.inherited(arguments);
this._setConstraintsAttr(this.constraints);
},_setConstraintsAttr:function(_5b7){
lang.mixin(this,_5b7);
if(!_5b7.locale){
_5b7.locale=this.lang;
}
},postCreate:function(){
this.connect(this.timeMenu,_59f.wheel,"_mouseWheeled");
this.own(_5a0.addMouseListener(this.upArrow,this,"_onArrowUp",33,250),_5a0.addMouseListener(this.downArrow,this,"_onArrowDown",33,250));
this.inherited(arguments);
},_buttonMouse:function(e){
_59a.toggle(e.currentTarget,e.currentTarget==this.upArrow?"dijitUpArrowHover":"dijitDownArrowHover",e.type=="mouseenter"||e.type=="mouseover");
},_createOption:function(_5b8){
var date=new Date(this._refDate);
var _5b9=this._clickableIncrementDate;
date.setTime(date.getTime()+_5b9.getHours()*_5b8*3600000+_5b9.getMinutes()*_5b8*60000+_5b9.getSeconds()*_5b8*1000);
if(this.constraints.selector=="time"){
date.setFullYear(1970,0,1);
}
var _5ba=_597.format(date,this.constraints);
if(this.filterString&&_5ba.toLowerCase().indexOf(this.filterString)!==0){
return null;
}
var div=this.ownerDocument.createElement("div");
div.className=this.baseClass+"Item";
div.date=date;
div.idx=_5b8;
_59b.create("div",{"class":this.baseClass+"ItemInner",innerHTML:_5ba},div);
if(_5b8%this._visibleIncrement<1&&_5b8%this._visibleIncrement>-1){
_59a.add(div,this.baseClass+"Marker");
}else{
if(!(_5b8%this._clickableIncrement)){
_59a.add(div,this.baseClass+"Tick");
}
}
if(this.isDisabledDate(date)){
_59a.add(div,this.baseClass+"ItemDisabled");
}
if(this.value&&!_596.compare(this.value,date,this.constraints.selector)){
div.selected=true;
_59a.add(div,this.baseClass+"ItemSelected");
if(_59a.contains(div,this.baseClass+"Marker")){
_59a.add(div,this.baseClass+"MarkerSelected");
}else{
_59a.add(div,this.baseClass+"TickSelected");
}
this._highlightOption(div,true);
}
return div;
},_onOptionSelected:function(tgt){
var _5bb=tgt.target.date||tgt.target.parentNode.date;
if(!_5bb||this.isDisabledDate(_5bb)){
return;
}
this._highlighted_option=null;
this.set("value",_5bb);
this.onChange(_5bb);
},onChange:function(){
},_highlightOption:function(node,_5bc){
if(!node){
return;
}
if(_5bc){
if(this._highlighted_option){
this._highlightOption(this._highlighted_option,false);
}
this._highlighted_option=node;
}else{
if(this._highlighted_option!==node){
return;
}else{
this._highlighted_option=null;
}
}
_59a.toggle(node,this.baseClass+"ItemHover",_5bc);
if(_59a.contains(node,this.baseClass+"Marker")){
_59a.toggle(node,this.baseClass+"MarkerHover",_5bc);
}else{
_59a.toggle(node,this.baseClass+"TickHover",_5bc);
}
},onmouseover:function(e){
this._keyboardSelected=null;
var tgr=(e.target.parentNode===this.timeMenu)?e.target:e.target.parentNode;
if(!_59a.contains(tgr,this.baseClass+"Item")){
return;
}
this._highlightOption(tgr,true);
},onmouseout:function(e){
this._keyboardSelected=null;
var tgr=(e.target.parentNode===this.timeMenu)?e.target:e.target.parentNode;
this._highlightOption(tgr,false);
},_mouseWheeled:function(e){
this._keyboardSelected=null;
_59c.stop(e);
this[(e.wheelDelta>0?"_onArrowUp":"_onArrowDown")]();
},_onArrowUp:function(_5bd){
if(_5bd===-1){
_59a.remove(this.upArrow,"dijitUpArrowActive");
return;
}else{
if(_5bd===0){
_59a.add(this.upArrow,"dijitUpArrowActive");
}
}
if(!this.timeMenu.childNodes.length){
return;
}
var _5be=this.timeMenu.childNodes[0].idx;
var divs=this._getFilteredNodes(_5be,1,true,this.timeMenu.childNodes[0]);
if(divs.length){
this.timeMenu.removeChild(this.timeMenu.childNodes[this.timeMenu.childNodes.length-1]);
this.timeMenu.insertBefore(divs[0],this.timeMenu.childNodes[0]);
}
},_onArrowDown:function(_5bf){
if(_5bf===-1){
_59a.remove(this.downArrow,"dijitDownArrowActive");
return;
}else{
if(_5bf===0){
_59a.add(this.downArrow,"dijitDownArrowActive");
}
}
if(!this.timeMenu.childNodes.length){
return;
}
var _5c0=this.timeMenu.childNodes[this.timeMenu.childNodes.length-1].idx+1;
var divs=this._getFilteredNodes(_5c0,1,false,this.timeMenu.childNodes[this.timeMenu.childNodes.length-1]);
if(divs.length){
this.timeMenu.removeChild(this.timeMenu.childNodes[0]);
this.timeMenu.appendChild(divs[0]);
}
},handleKey:function(e){
if(e.keyCode==keys.DOWN_ARROW||e.keyCode==keys.UP_ARROW){
_59c.stop(e);
if(this._highlighted_option&&!this._highlighted_option.parentNode){
this._highlighted_option=null;
}
var _5c1=this.timeMenu,tgt=this._highlighted_option||_59e("."+this.baseClass+"ItemSelected",_5c1)[0];
if(!tgt){
tgt=_5c1.childNodes[0];
}else{
if(_5c1.childNodes.length){
if(e.keyCode==keys.DOWN_ARROW&&!tgt.nextSibling){
this._onArrowDown();
}else{
if(e.keyCode==keys.UP_ARROW&&!tgt.previousSibling){
this._onArrowUp();
}
}
if(e.keyCode==keys.DOWN_ARROW){
tgt=tgt.nextSibling;
}else{
tgt=tgt.previousSibling;
}
}
}
this._highlightOption(tgt,true);
this._keyboardSelected=tgt;
return false;
}else{
if(e.keyCode==keys.ENTER||e.keyCode===keys.TAB){
if(!this._keyboardSelected&&e.keyCode===keys.TAB){
return true;
}
if(this._highlighted_option){
this._onOptionSelected({target:this._highlighted_option});
}
return e.keyCode===keys.TAB;
}
}
return undefined;
}});
return _5a5;
});
},"url:davinci/ve/input/templates/MultiFieldSmartInput.html":"<div id=\"iedResizeDiv\"  class=\"iedResizeDiv\"> \n<div dojoType=\"dijit.layout.ContentPane\" class=\"MultiFieldSmartInput_SmartInput_CP\">\n  <table id=\"davinci.ve.input.MultiFieldSmartInput_table\"> \n    <tbody> \n      {tableContent}\n    </tbody> \n  </table> \n</div>   \n  <div id=\"smartInputSim\" class=\"smartInputSim\" style=\"display:none;\"></div>\n  <div id=\"iedResizeHandle\" dojoType=\"dojox.layout.ResizeHandle\" targetId=\"iedResizeDiv\" constrainMin=\"true\" maxWidth=\"200\" maxHeight=\"600\" minWidth=\"240\" minHeight=\"60\"  activeResize=\"true\" intermediateChanges=\"true\"></div>\n</div>\n</td>\n</tr>\n</table>\n<div id=\"davinci.ve.input.SmartInput_div\"  class=\"davinciVeInputSmartInputDiv\"> \n  <div id=\"davinci.ve.input.SmartInput_radio_div\" class=\"smartInputRadioDiv\"> \n   <div class=\"smartInputHelpDiv\"> \n      <span id=\"davinci.ve.input.SmartInput_img_help\"  title=\"Help\" class=\"inlineEditHelp\"> </span>\n      <span class=\"smartInputSpacerSpan\">\n      <button id=\"davinci.ve.input.SmartInput_ok\"  dojoType=\"dijit.form.Button\" type=\"submit\" class=\"inlineEditHelpOk\">{buttonOk}</button> <button id=davinci.ve.input.SmartInput_cancel dojoType=\"dijit.form.Button\" class=\"inlineEditHelpCancel\">{buttonCancel}</button>  \n      </span>   \n    </div> \n    <div id=\"davinci.ve.input.SmartInput_div_help\" style=\"display:none;\" class=\"smartInputHelpTextDiv\"> \n      <div dojoType=\"dijit.layout.ContentPane\" class=\"smartInputHelpTextDivContentPane\" style=\"padding:0;\">{helpText}</div> \n      <div style=\"text-align: left; padding:0; height:2px;\"></div> \n    </div> \n  </div> \n</div> \n\n","dijit/form/RadioButton":function(){
define(["dojo/_base/declare","./CheckBox","./_RadioButtonMixin"],function(_5c2,_5c3,_5c4){
return _5c2("dijit.form.RadioButton",[_5c3,_5c4],{baseClass:"dijitRadio"});
});
},"davinci/ui/OpenThemeDialog":function(){
define(["dojo/_base/declare","dijit/_Templated","dijit/_Widget","dojo/i18n!davinci/ui/nls/ui","dojo/i18n!dijit/nls/common","dojo/text!./templates/OpenThemeDialog.html","davinci/ui/widgets/ThemeSelection"],function(_5c5,_5c6,_5c7,_5c8,_5c9,_5ca){
return _5c5("davinci.ui.OpenThemeDialog",[_5c7,_5c6],{templateString:_5ca,widgetsInTemplate:true,_themeChooser:null,startup:function(){
var _5cb=_5c8;
this.inherited(arguments);
var _5cc=this._themeChooser.get("numberOfThemes");
if(_5cc<1){
alert(_5cb.noUserThemes);
setTimeout(dojo.hitch(this,function(){
this.destroyRecursive();
this.cancel=true;
this.onClose();
},500));
}
},postMixInProperties:function(){
var _5cd=_5c8;
var _5ce=_5c9;
dojo.mixin(this,_5cd);
dojo.mixin(this,_5ce);
this.inherited(arguments);
},_checkValid:function(){
var isOk=true;
var _5cf=this._themeChooser.attr("value");
if(_5cf==null||_5cf==""){
isOk=false;
}
this._okButton.set("disabled",!isOk);
},okButton:function(){
var _5d0=this._themeChooser.attr("value");
davinci.Workbench.openEditor({fileName:_5d0.getFile(),content:_5d0});
},cancelButton:function(){
this.cancel=true;
this.onClose();
}});
});
},"dojox/widget/Toaster":function(){
define(["dojo/_base/declare","dojo/_base/lang","dojo/_base/connect","dojo/_base/fx","dojo/dom-style","dojo/dom-class","dojo/dom-geometry","dijit/registry","dijit/_WidgetBase","dijit/_TemplatedMixin","dijit/BackgroundIframe","dojo/fx","dojo/has","dojo/_base/window","dojo/window"],function(_5d1,lang,_5d2,_5d3,_5d4,_5d5,_5d6,_5d7,_5d8,_5d9,_5da,_5db,has,_5dc,_5dd){
lang.getObject("dojox.widget",true);
var _5de=function(w){
return w.substring(0,1).toUpperCase()+w.substring(1);
};
return _5d1("dojox.widget.Toaster",[_5d8,_5d9],{templateString:"<div class=\"dijitToasterClip\" dojoAttachPoint=\"clipNode\"><div class=\"dijitToasterContainer\" dojoAttachPoint=\"containerNode\" dojoAttachEvent=\"onclick:onSelect\"><div class=\"dijitToasterContent\" dojoAttachPoint=\"contentNode\"></div></div></div>",messageTopic:"",messageTypes:{MESSAGE:"message",WARNING:"warning",ERROR:"error",FATAL:"fatal"},defaultType:"message",positionDirection:"br-up",positionDirectionTypes:["br-up","br-left","bl-up","bl-right","tr-down","tr-left","tl-down","tl-right"],duration:2000,slideDuration:500,separator:"<hr></hr>",postCreate:function(){
this.inherited(arguments);
this.hide();
_5dc.body().appendChild(this.domNode);
if(this.messageTopic){
_5d2.subscribe(this.messageTopic,this,"_handleMessage");
}
},_handleMessage:function(_5df){
if(lang.isString(_5df)){
this.setContent(_5df);
}else{
this.setContent(_5df.message,_5df.type,_5df.duration);
}
},setContent:function(_5e0,_5e1,_5e2){
_5e2=_5e2||this.duration;
if(this.slideAnim){
if(this.slideAnim.status()!="playing"){
this.slideAnim.stop();
}
if(this.slideAnim.status()=="playing"||(this.fadeAnim&&this.fadeAnim.status()=="playing")){
setTimeout(lang.hitch(this,function(){
this.setContent(_5e0,_5e1,_5e2);
}),50);
return;
}
}
for(var type in this.messageTypes){
_5d5.remove(this.containerNode,"dijitToaster"+_5de(this.messageTypes[type]));
}
_5d4.set(this.containerNode,"opacity",1);
this._setContent(_5e0);
_5d5.add(this.containerNode,"dijitToaster"+_5de(_5e1||this.defaultType));
this.show();
var _5e3=_5d6.getMarginBox(this.containerNode);
this._cancelHideTimer();
if(this.isVisible){
this._placeClip();
if(!this._stickyMessage){
this._setHideTimer(_5e2);
}
}else{
var _5e4=this.containerNode.style;
var pd=this.positionDirection;
if(pd.indexOf("-up")>=0){
_5e4.left=0+"px";
_5e4.top=_5e3.h+10+"px";
}else{
if(pd.indexOf("-left")>=0){
_5e4.left=_5e3.w+10+"px";
_5e4.top=0+"px";
}else{
if(pd.indexOf("-right")>=0){
_5e4.left=0-_5e3.w-10+"px";
_5e4.top=0+"px";
}else{
if(pd.indexOf("-down")>=0){
_5e4.left=0+"px";
_5e4.top=0-_5e3.h-10+"px";
}else{
throw new Error(this.id+".positionDirection is invalid: "+pd);
}
}
}
}
this.slideAnim=_5db.slideTo({node:this.containerNode,top:0,left:0,duration:this.slideDuration});
this.connect(this.slideAnim,"onEnd",function(_5e5,anim){
this.fadeAnim=_5d3.fadeOut({node:this.containerNode,duration:1000});
this.connect(this.fadeAnim,"onEnd",function(evt){
this.isVisible=false;
this.hide();
});
this._setHideTimer(_5e2);
this.connect(this,"onSelect",function(evt){
this._cancelHideTimer();
this._stickyMessage=false;
this.fadeAnim.play();
});
this.isVisible=true;
});
this.slideAnim.play();
}
},_setContent:function(_5e6){
if(lang.isFunction(_5e6)){
_5e6(this);
return;
}
if(_5e6&&this.isVisible){
_5e6=this.contentNode.innerHTML+this.separator+_5e6;
}
this.contentNode.innerHTML=_5e6;
},_cancelHideTimer:function(){
if(this._hideTimer){
clearTimeout(this._hideTimer);
this._hideTimer=null;
}
},_setHideTimer:function(_5e7){
this._cancelHideTimer();
if(_5e7>0){
this._cancelHideTimer();
this._hideTimer=setTimeout(lang.hitch(this,function(evt){
if(this.bgIframe&&this.bgIframe.iframe){
this.bgIframe.iframe.style.display="none";
}
this._hideTimer=null;
this._stickyMessage=false;
this.fadeAnim.play();
}),_5e7);
}else{
this._stickyMessage=true;
}
},_placeClip:function(){
var view=_5dd.getBox();
var _5e8=_5d6.getMarginBox(this.containerNode);
var _5e9=this.clipNode.style;
_5e9.height=_5e8.h+"px";
_5e9.width=_5e8.w+"px";
var pd=this.positionDirection;
if(pd.match(/^t/)){
_5e9.top=view.t+"px";
}else{
if(pd.match(/^b/)){
_5e9.top=(view.h-_5e8.h-2+view.t)+"px";
}
}
if(pd.match(/^[tb]r-/)){
_5e9.left=(view.w-_5e8.w-1-view.l)+"px";
}else{
if(pd.match(/^[tb]l-/)){
_5e9.left=0+"px";
}
}
_5e9.clip="rect(0px, "+_5e8.w+"px, "+_5e8.h+"px, 0px)";
if(has("ie")){
if(!this.bgIframe){
this.clipNode.id=_5d7.getUniqueId("dojox_widget_Toaster_clipNode");
this.bgIframe=new _5da(this.clipNode);
}
var _5ea=this.bgIframe.iframe;
if(_5ea){
_5ea.style.display="block";
}
}
},onSelect:function(e){
},show:function(){
_5d4.set(this.domNode,"display","block");
this._placeClip();
if(!this._scrollConnected){
this._scrollConnected=_5d2.connect(_5dd,"onscroll",this,this._placeClip);
}
},hide:function(){
_5d4.set(this.domNode,"display","none");
if(this._scrollConnected){
_5d2.disconnect(this._scrollConnected);
this._scrollConnected=false;
}
_5d4.set(this.containerNode,"opacity",1);
}});
});
},"dojox/data/QueryReadStore":function(){
define(["dojo","dojox","dojo/data/util/sorter","dojo/string"],function(dojo,_5eb){
dojo.declare("dojox.data.QueryReadStore",null,{url:"",requestMethod:"get",_className:"dojox.data.QueryReadStore",_items:[],_lastServerQuery:null,_numRows:-1,lastRequestHash:null,doClientPaging:false,doClientSorting:false,_itemsByIdentity:null,_identifier:null,_features:{"dojo.data.api.Read":true,"dojo.data.api.Identity":true},_labelAttr:"label",constructor:function(_5ec){
dojo.mixin(this,_5ec);
},getValue:function(item,_5ed,_5ee){
this._assertIsItem(item);
if(!dojo.isString(_5ed)){
throw new Error(this._className+".getValue(): Invalid attribute, string expected!");
}
if(!this.hasAttribute(item,_5ed)){
if(_5ee){
return _5ee;
}
}
return item.i[_5ed];
},getValues:function(item,_5ef){
this._assertIsItem(item);
var ret=[];
if(this.hasAttribute(item,_5ef)){
ret.push(item.i[_5ef]);
}
return ret;
},getAttributes:function(item){
this._assertIsItem(item);
var ret=[];
for(var i in item.i){
ret.push(i);
}
return ret;
},hasAttribute:function(item,_5f0){
return this.isItem(item)&&typeof item.i[_5f0]!="undefined";
},containsValue:function(item,_5f1,_5f2){
var _5f3=this.getValues(item,_5f1);
var len=_5f3.length;
for(var i=0;i<len;i++){
if(_5f3[i]==_5f2){
return true;
}
}
return false;
},isItem:function(_5f4){
if(_5f4){
return typeof _5f4.r!="undefined"&&_5f4.r==this;
}
return false;
},isItemLoaded:function(_5f5){
return this.isItem(_5f5);
},loadItem:function(args){
if(this.isItemLoaded(args.item)){
return;
}
},fetch:function(_5f6){
_5f6=_5f6||{};
if(!_5f6.store){
_5f6.store=this;
}
var self=this;
var _5f7=function(_5f8,_5f9){
if(_5f9.onError){
var _5fa=_5f9.scope||dojo.global;
_5f9.onError.call(_5fa,_5f8,_5f9);
}
};
var _5fb=function(_5fc,_5fd,_5fe){
var _5ff=_5fd.abort||null;
var _600=false;
var _601=_5fd.start?_5fd.start:0;
if(self.doClientPaging==false){
_601=0;
}
var _602=_5fd.count?(_601+_5fd.count):_5fc.length;
_5fd.abort=function(){
_600=true;
if(_5ff){
_5ff.call(_5fd);
}
};
var _603=_5fd.scope||dojo.global;
if(!_5fd.store){
_5fd.store=self;
}
if(_5fd.onBegin){
_5fd.onBegin.call(_603,_5fe,_5fd);
}
if(_5fd.sort&&self.doClientSorting){
_5fc.sort(dojo.data.util.sorter.createSortFunction(_5fd.sort,self));
}
if(_5fd.onItem){
for(var i=_601;(i<_5fc.length)&&(i<_602);++i){
var item=_5fc[i];
if(!_600){
_5fd.onItem.call(_603,item,_5fd);
}
}
}
if(_5fd.onComplete&&!_600){
var _604=null;
if(!_5fd.onItem){
_604=_5fc.slice(_601,_602);
}
_5fd.onComplete.call(_603,_604,_5fd);
}
};
this._fetchItems(_5f6,_5fb,_5f7);
return _5f6;
},getFeatures:function(){
return this._features;
},close:function(_605){
},getLabel:function(item){
if(this._labelAttr&&this.isItem(item)){
return this.getValue(item,this._labelAttr);
}
return undefined;
},getLabelAttributes:function(item){
if(this._labelAttr){
return [this._labelAttr];
}
return null;
},_xhrFetchHandler:function(data,_606,_607,_608){
data=this._filterResponse(data);
if(data.label){
this._labelAttr=data.label;
}
var _609=data.numRows||-1;
this._items=[];
dojo.forEach(data.items,function(e){
this._items.push({i:e,r:this});
},this);
var _60a=data.identifier;
this._itemsByIdentity={};
if(_60a){
this._identifier=_60a;
var i;
for(i=0;i<this._items.length;++i){
var item=this._items[i].i;
var _60b=item[_60a];
if(!this._itemsByIdentity[_60b]){
this._itemsByIdentity[_60b]=item;
}else{
throw new Error(this._className+":  The json data as specified by: ["+this.url+"] is malformed.  Items within the list have identifier: ["+_60a+"].  Value collided: ["+_60b+"]");
}
}
}else{
this._identifier=Number;
for(i=0;i<this._items.length;++i){
this._items[i].n=i;
}
}
_609=this._numRows=(_609===-1)?this._items.length:_609;
_607(this._items,_606,_609);
this._numRows=_609;
},_fetchItems:function(_60c,_60d,_60e){
var _60f=_60c.serverQuery||_60c.query||{};
if(!this.doClientPaging){
_60f.start=_60c.start||0;
if(_60c.count){
_60f.count=_60c.count;
}
}
if(!this.doClientSorting&&_60c.sort){
var _610=[];
dojo.forEach(_60c.sort,function(sort){
if(sort&&sort.attribute){
_610.push((sort.descending?"-":"")+sort.attribute);
}
});
_60f.sort=_610.join(",");
}
if(this.doClientPaging&&this._lastServerQuery!==null&&dojo.toJson(_60f)==dojo.toJson(this._lastServerQuery)){
this._numRows=(this._numRows===-1)?this._items.length:this._numRows;
_60d(this._items,_60c,this._numRows);
}else{
var _611=this.requestMethod.toLowerCase()=="post"?dojo.xhrPost:dojo.xhrGet;
var _612=_611({url:this.url,handleAs:"json-comment-optional",content:_60f,failOk:true});
_60c.abort=function(){
_612.cancel();
};
_612.addCallback(dojo.hitch(this,function(data){
this._xhrFetchHandler(data,_60c,_60d,_60e);
}));
_612.addErrback(function(_613){
_60e(_613,_60c);
});
this.lastRequestHash=new Date().getTime()+"-"+String(Math.random()).substring(2);
this._lastServerQuery=dojo.mixin({},_60f);
}
},_filterResponse:function(data){
return data;
},_assertIsItem:function(item){
if(!this.isItem(item)){
throw new Error(this._className+": Invalid item argument.");
}
},_assertIsAttribute:function(_614){
if(typeof _614!=="string"){
throw new Error(this._className+": Invalid attribute argument ('"+_614+"').");
}
},fetchItemByIdentity:function(_615){
if(this._itemsByIdentity){
var item=this._itemsByIdentity[_615.identity];
if(!(item===undefined)){
if(_615.onItem){
var _616=_615.scope?_615.scope:dojo.global;
_615.onItem.call(_616,{i:item,r:this});
}
return;
}
}
var _617=function(_618,_619){
var _61a=_615.scope?_615.scope:dojo.global;
if(_615.onError){
_615.onError.call(_61a,_618);
}
};
var _61b=function(_61c,_61d){
var _61e=_615.scope?_615.scope:dojo.global;
try{
var item=null;
if(_61c&&_61c.length==1){
item=_61c[0];
}
if(_615.onItem){
_615.onItem.call(_61e,item);
}
}
catch(error){
if(_615.onError){
_615.onError.call(_61e,error);
}
}
};
var _61f={serverQuery:{id:_615.identity}};
this._fetchItems(_61f,_61b,_617);
},getIdentity:function(item){
var _620=null;
if(this._identifier===Number){
_620=item.n;
}else{
_620=item.i[this._identifier];
}
return _620;
},getIdentityAttributes:function(item){
return [this._identifier];
}});
return _5eb.data.QueryReadStore;
});
},"url:dijit/templates/TimePicker.html":"<div id=\"widget_${id}\" class=\"dijitMenu\"\n    ><div data-dojo-attach-point=\"upArrow\" class=\"dijitButtonNode dijitUpArrowButton\" data-dojo-attach-event=\"onmouseenter:_buttonMouse,onmouseleave:_buttonMouse\"\n\t\t><div class=\"dijitReset dijitInline dijitArrowButtonInner\" role=\"presentation\">&#160;</div\n\t\t><div class=\"dijitArrowButtonChar\">&#9650;</div></div\n    ><div data-dojo-attach-point=\"timeMenu,focusNode\" data-dojo-attach-event=\"onclick:_onOptionSelected,onmouseover,onmouseout\"></div\n    ><div data-dojo-attach-point=\"downArrow\" class=\"dijitButtonNode dijitDownArrowButton\" data-dojo-attach-event=\"onmouseenter:_buttonMouse,onmouseleave:_buttonMouse\"\n\t\t><div class=\"dijitReset dijitInline dijitArrowButtonInner\" role=\"presentation\">&#160;</div\n\t\t><div class=\"dijitArrowButtonChar\">&#9660;</div></div\n></div>\n","davinci/ve/utils/pseudoClass":function(){
define([],function(){
var _621="maqettaPseudoClass";
return {MAQETTA_PSEUDO_CLASS:_621,replace:function(_622){
return ["hover","link","visited","active","focus","first-letter","first-line","first-child","before","after"].reduce(function(text,_623){
return text.replace(new RegExp(":"+_623,"g"),"."+_621+_623[0].toUpperCase()+_623.slice(1));
},_622);
}};
});
},"davinci/ui/about":function(){
define(["dojo/_base/declare","../Workbench","davinci/version","davinci/repositoryinfo","dojo/date/locale","dojo/date/stamp","dojo/i18n!davinci/ui/nls/ui","dojo/i18n!dijit/nls/common","dijit/form/Button"],function(_624,_625,_626,_627,_628,_629,_62a,_62b){
var _62c=_624("davinci.ui.about",null,{});
_62c.show=function(){
var _62d=_62a;
var _62e="<div class='about_container'>"+"<div class='about_version'>"+dojo.string.substitute(_62d.productVersion,[_626])+"</div>";
var ri=_627,_62f=ri.revision;
var bd=ri.buildtime;
var date=_629.fromISOString(bd);
if(date){
bd=_628.format(date,{formatLength:"medium"});
}
if(bd){
_62e+="<div class='about_date'>"+dojo.string.substitute(_62d.productDate,[bd])+"</div>";
}
if(_62f){
var _630="<a href='https://github.com/maqetta/maqetta/commit/"+_62f+"'>"+_62f.substr(0,15)+"...</a>";
_62e+="<div class='about_build'>"+dojo.string.substitute(_62d.build,[_630])+"</div>";
}
_62e+="</div>";
_625.showMessage(_62d.aboutMaqetta,_62e);
};
return _62c;
});
},"davinci/Workbench":function(){
define(["dojo/_base/lang","require","./Runtime","./model/Path","./workbench/ViewPart","./workbench/EditorContainer","./ui/Dialog","dijit/Toolbar","dijit/ToolbarSeparator","dijit/Menu","dijit/MenuBar","dijit/MenuItem","dijit/MenuSeparator","dijit/PopupMenuBarItem","dijit/form/Button","dijit/form/DropDownButton","dijit/form/ComboButton","dijit/form/ToggleButton","dijit/layout/BorderContainer","dijit/layout/StackController","dijit/layout/StackContainer","dijit/layout/ContentPane","dijit/layout/TabController","dijit/layout/TabContainer","system/resource","dojo/i18n!./nls/webContent","./ve/metadata","dojo/Deferred","dojo/promise/all","dojo/_base/declare","dojo/_base/connect","dojo/_base/xhr","./review/model/resource/root","dojo/i18n!./ve/nls/common","./ve/utils/GeomUtils","dojo/i18n!./ui/nls/common","davinci/review/model/resource/root"],function(lang,_631,_632,Path,_633,_634,_635,_636,_637,Menu,_638,_639,_63a,_63b,_63c,_63d,_63e,_63f,_640,_641,_642,_643,_644,_645,_646,_647,_648,_649,all,_64a,_64b,xhr,_64c,_64d,_64e,_64f,_650){
var _651=71;
var _652=20;
var _653={};
Function.prototype.bind=Function.prototype.bind||function(that){
return dojo.hitch(that,this);
};
var _654=function(_655){
return "editor-"+encodeURIComponent(_655.replace(/[\/| |\t]/g,"_")).replace(/%/g,":");
};
var _656=function(_657){
return _657.replace(/^editor/,"shadow");
};
var _658=function(_659){
return _659.replace(/^shadow/,"editor");
};
var _65a=function(_65b,_65c){
if(_65c.status==401||_65c.status==403){
_65d();
}else{
if(_65b.canceled===true){
var _65e=new RegExp("(^|\\.\\/|"+document.baseURI+"\\/)cmd\\/");
var url=_65b.ioArgs.url;
if(_65e.test(url)){
if(url.indexOf("getBluePageInfo")>=0){
return;
}
}else{
return;
}
_632.handleError(_65c.message);
console.warn("Failed to load url="+url+" message="+_65c.message+" status="+_65c.status);
}
}
};
var _65d=function(){
var _65f="welcome";
var _660=new _635({title:_647.sessionTimedOut});
var _661=dojo.string.substitute(_647.sessionTimedOutMsg,{hrefLoc:_65f});
_660.set("content",_661);
dojo.connect(_660,"onCancel",null,function(){
window.location.href=_65f;
});
setTimeout(function(){
window.location.href=_65f;
},10000);
_660.show();
};
var _662=function(){
davinci.Workbench._expandCollapsePaletteContainers(null,{dontPreserveWidth:true});
var _663=function(_664){
return _664.indexOf(".review")>-1;
};
var _665=function(_666){
return new Path(_666).segment(2);
};
var _667=function(_668){
return new Path(_668).removeFirstSegments(3);
};
var init=function(_669){
dojo.publish("/davinci/ui/initialPerspectiveReady",[]);
if(_669.project){
_67a.setActiveProject(_669.project);
}
if(_669.editors){
_669.version=davinci.version;
var _66a,_66b=_67a.singleProjectMode();
if(_66b){
_66a=new Path(_67a.getProject());
}
_669.editors.forEach(function(_66c){
var _66d=_663(_66c);
if(!_66d&&_66b){
if(!new Path(_66c).startsWith(_66a)){
return;
}
}
var _66e=function(_66f){
var _670=true;
if(_66b){
var path=new Path(_669.activeEditor);
if(!path.startsWith(_66a)){
_670=false;
}
}
var _671=_66c!=_669.activeEditor;
if(_671&&!_670&&!_663(_669.activeEditor)){
_671=false;
_669.activeEditor=_66c;
}
if(_66f){
_67a.openEditor({fileName:_66f,noSelect:_671,isDirty:_66f.isDirty(),startup:false,initializationTime:true});
}
};
if(_66d){
var _672=_665(_66c);
var _673=_667(_66c).toString();
_64c.findFile(_672,_673).then(function(_674){
_66e(_674);
});
}else{
_66e(_646.findResource(_66c));
}
});
}else{
_669.editors=[];
}
};
if(!_67a._state){
_67a._state=_632.getWorkbenchState();
}
var _675=dojo.cookie("davinci_designer");
var _676=dojo.cookie("davinci_version");
dojo.cookie("davinci_designer",null,{expires:-1,path:"/"});
dojo.cookie("davinci_version",null,{expires:-1,path:"/"});
if(_676&&_675){
_650.findVersion(_675,_676).then(function(node){
if(node){
node.getChildren(function(_677){
_677.forEach(function(_678,_679){
var p=_678.getPath();
if(_679==0){
_67a._state.activeEditor=p;
}
if(_67a._state.editors.indexOf(p)<0){
_67a._state.editors.push(p);
}
}.bind(this));
init(_67a._state);
});
}
}.bind(this));
}else{
init(_67a._state);
}
_67a.setupGlobalKeyboardHandler();
};
var _67a={activePerspective:"",actionScope:[],_DEFAULT_PROJECT:"project1",hideEditorTabs:true,_editorTabClosing:{},_shadowTabClosing:{},run:function(){
_632.run();
_67a._initKeys();
_67a._baseTitle=dojo.doc.title;
if(window.maqetta&&maqetta.TopBanner&&maqetta.TopBanner.setup){
maqetta.TopBanner.setup();
}
_632.subscribe("/davinci/resource/resourceChanged",function(type,_67b){
if(type=="deleted"){
var _67c=_654(_67b.getPath());
var _67d=_656(_67c);
var _67e=dijit.byId(_67c);
var _67f=dijit.byId(_67d);
if(_67e&&!_67e._isClosing){
var _680=dijit.byId("editors_container");
var _681=dijit.byId("davinci_file_tabs");
_680.removeChild(_67e);
_67e.destroyRecursive();
_681.removeChild(_67f);
_67f.destroyRecursive();
}
}
});
_632.subscribe("/dojo/io/error",_65a);
_632.subscribe("/davinci/states/state/changed",function(e){
var _682=_632.currentEditor;
if((_682.declaredClass!="davinci.ve.themeEditor.ThemeEditor"&&_682.declaredClass!="davinci.review.editor.ReviewEditor")){
_682.visualEditor.onContentChange.apply(_682.visualEditor,arguments);
}
});
_632.subscribe("/davinci/ui/widgetPropertiesChanges",function(){
var ve=_632.currentEditor.visualEditor;
ve._objectPropertiesChange.apply(ve,arguments);
});
_64b.subscribe("/davinci/states/state/changed",function(args){
var _683=(_632.currentEditor&&_632.currentEditor.declaredClass=="davinci.ve.PageEditor"&&_632.currentEditor.visualEditor&&_632.currentEditor.visualEditor.context);
if(!_683){
return;
}
var _684="_show:",_685,_686,_687;
var _688=_683?_683.getDijit():null;
var _689=_631("davinci/ve/widget");
if(args.newState&&!args.newState.indexOf(_684)){
_685=_688.byId(args.newState.substring(6));
_686=_689.getWidget(_685.domNode);
_687=_686.getHelper();
_687&&_687.popup&&_687.popup(_686);
}
if(args.oldState&&!args.oldState.indexOf(_684)){
_685=_688.byId(args.oldState.substring(6));
_686=_689.getWidget(_685.domNode);
_687=_686.getHelper();
_687&&_687.tearDown&&_687.tearDown(_686);
}
});
_64b.subscribe("/davinci/ui/repositionFocusContainer",function(args){
_67a._repositionFocusContainer();
});
var d=xhr.get({url:"cmd/getInitializationInfo",handleAs:"json"}).then(function(_68a){
_632._initializationInfo=_68a;
var _68b=_68a.userInfo;
_632.isLocalInstall=_68b.userId=="maqettaUser";
_632.userName=_68b.userId;
_632.userEmail=_68b.email;
return _648.init();
}).then(function(){
var _68c=_632.initialPerspective||"davinci.ui.main";
dojo.query(".loading").orphan();
_67a.showPerspective(_68c);
_67a._updateTitle();
_662();
}).otherwise(function(_68d){
dojo.query("#load_screen").addContent(dojo.string.substitute(_647.startupError,[_68d.message]),"only");
});
_67a._lastAutoSave=Date.now();
setInterval(dojo.hitch(this,"_autoSave"),30000);
return d;
},unload:function(){
_67a._autoSave();
},logoff:function(args){
dojo.create("div",{"class":"loading",innerHTML:"<table><tr><td><span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>&nbsp;Logging off...</td></tr></table>"},dojo.body(),"first");
_67a.unload();
return xhr.get({url:"cmd/logoff",handleAs:"text"}).then(function(_68e){
location.href="welcome";
});
},_createToolBar:function(_68f,_690,_691,_692){
var _693=[];
if(!_691){
_691=_632.getExtensions("davinci.actionSets");
}
for(var i=0,len=_691.length;i<len;i++){
var _694=_691[i].actions;
for(var k=0,len2=_694.length;k<len2;k++){
var _695=_694[k],_696=_695[_68f];
if(_696){
if(!_693[_696]){
_693[_696]=[];
}
_693[_696].push(_695);
}
}
}
var _697=new _636({"class":"davinciToolbar"},_690);
var _698={};
var _699=true;
for(var _69a in _693){
if(!_699){
var _69b=new _637();
_697.addChild(_69b);
}else{
_699=false;
}
var _694=_693[_69a];
for(var p=0;p<_694.length;p++){
var _695=_694[p];
_67a._loadActionClass(_695);
var _69c={showLabel:false};
["label","showLabel","iconClass"].forEach(function(prop){
if(_695.hasOwnProperty(prop)){
_69c[prop]=_695[prop];
}
});
if(_695.className){
_69c["class"]=_695.className;
}
var _69d;
var _69e=new _649();
if(_695.menu&&(_695.type=="DropDownButton"||_695.type=="ComboButton")){
var menu=new Menu({style:"display: none;"});
for(var _69f=0;_69f<_695.menu.length;_69f++){
var _6a0=_695.menu[_69f];
_67a._loadActionClass(_6a0);
var _6a1={onClick:dojo.hitch(this,"_runAction",_6a0,_692)};
var _6a2=["label","iconClass"];
_6a2.forEach(function(prop){
if(_6a0[prop]){
_6a1[prop]=_6a0[prop];
}
});
var _6a3=new _639(_6a1);
_6a3._maqAction=_6a0;
menu.addChild(_6a3);
}
_69c.dropDown=menu;
if(_695.type=="DropDownButton"){
_69d=new _63d(_69c);
}else{
_69d=new _63e(_69c);
}
_69d.onClick=dojo.hitch(this,"_runAction",_695,_692);
_69d._maqAction=_695;
_69e.resolve();
}else{
if(_695.toggle||_695.radioGroup){
_69d=new _63f(_69c);
_69d.item=_695;
_69d.set("checked",_695.initialValue);
if(_695.radioGroup){
var _6a4=_698[_695.radioGroup];
if(!_6a4){
_6a4=_698[_695.radioGroup]=[];
}
_6a4.push(_69d);
_69d.onChange=dojo.hitch(this,"_toggleButton",_69d,_692,_6a4);
}else{
_69d.onChange=dojo.hitch(this,"_runAction",_695,_692);
}
_69d._maqAction=_695;
_69e.resolve();
}else{
if(_695.type){
_631([_695.type],function(_6a5){
_69d=new _6a5();
_69d._maqActiond=_695;
_69e.resolve();
});
}else{
_69d=new _63c(_69c);
_69d.onClick=dojo.hitch(this,"_runAction",_695,_692);
_69d._maqAction=_695;
_69e.resolve();
}
}
}
if(_695.icon){
var _6a6=document.createElement("img");
_6a6.src=_695.icon;
_6a6.height=_6a6.width=18;
_69d.domNode.appendChild(_6a6);
}
_69e.then(function(){
_697.addChild(_69d);
if(_695.isEnabled&&!_695.isEnabled()){
_69d.isEnabled=_695.isEnabled;
_69d.set("disabled",true);
}else{
_69d.set("disabled",false);
}
});
}
}
return _697;
},showPerspective:function(_6a7){
_67a.activePerspective=_6a7;
var _6a8=_67a._createMenuTree();
_67a._updateMainMenubar(dojo.byId("davinci_main_menu"),_6a8);
var o=this.getActionSets("davinci.ui.editorMenuBar");
var _6a9=o.clonedActionSets;
if(_6a9.length){
_6a8=_67a._createMenuTree(_6a9);
_67a._updateMainMenubar(dojo.byId("maq_banner_editor_commands"),_6a8);
}
var _6aa=dojo.byId("mainBody");
if(!_6aa.tabs){
_6aa.tabs=[];
}
var _6ab=dijit.byId("mainBody");
if(!_6ab){
_6ab=new _640({gutters:false,region:"center",design:"sidebar"},_6aa);
}
var _6ac=_632.getExtension("davinci.perspective",_6a7);
if(!_6ac){
_632.handleError(dojo.string.substitute(_647.perspectiveNotFound,[_6a7]));
}
_6ac=dojo.clone(_6ac);
var _6ad=_632.getExtensions("davinci.perspectiveExtension",function(_6ae){
return _6ae.targetID===_6a7;
});
dojo.forEach(_6ad,function(_6af){
dojo.forEach(_6af.views,function(view){
_6ac.views.push(view);
});
});
if(!_6aa.editorsStackContainer){
_67a.editorsStackContainer=_6aa.editorsStackContainer=new _642({region:"center",id:"editorsStackContainer",controllerWidget:"dijit.layout.StackController"});
}
_6ab.addChild(_6aa.editorsStackContainer);
if(!_6aa.editorsWelcomePage){
_67a.editorsWelcomePage=_6aa.editorsWelcomePage=new _643({id:"editorsWelcomePage",href:"app/davinci/ve/resources/welcome_to_maqetta.html"});
}
_6aa.editorsStackContainer.addChild(_6aa.editorsWelcomePage);
if(!_6aa.tabs.editors){
_67a.editorTabs=_6aa.tabs.editors=new (_67a.hideEditorTabs?_642:_645)({id:"editors_container",controllerWidget:(_67a.hideEditorTabs?"dijit.layout.StackController":"dijit.layout.TabController")});
_67a.editorTabs.setTitle=function(_6b0,_6b1){
_6b0.attr("title",_6b1);
_6b0.domNode.title="";
if(!_67a.hideEditorTabs){
this.tablist.pane2button[_6b0.id].attr("label",_6b1);
}else{
var _6b2=_6b0.id;
var _6b3=_656(_6b2);
var _6b4=dijit.byId("davinci_file_tabs");
var _6b5=_6b1+(_6b0.isDirty?"<span class=\"dirtyFileAsterisk\"></span>":"");
_6b4.tablist.pane2button[_6b3].attr("label",_6b5);
}
};
dojo.connect(_6aa.tabs.editors,"removeChild",this,_67a._editorTabClosed);
}
_6aa.editorsStackContainer.addChild(_6aa.tabs.editors);
_6aa.editorsStackContainer.selectChild(_6aa.editorsWelcomePage);
dojo.connect(dijit.byId("editors_container"),"selectChild",function(_6b6){
if(!_67a._processingSelectChild){
_67a._processingSelectChild=true;
var _6b7=_6b6.id;
var _6b8=_656(_6b7);
var _6b9=dijit.byId(_6b8);
var _6ba=dijit.byId("davinci_file_tabs");
if(_6b9&&_6ba){
_6ba.selectChild(_6b9);
}
if(_6b6.editor){
_67a._switchEditor(_6b6.editor);
}
_67a._processingSelectChild=false;
}
});
_6ab.startup();
var _6bb=dijit.byId("davinci_app");
if(!_6bb){
_6bb=new _640({design:"headline",gutters:false,liveSplitters:false},"davinci_app");
var _6bc=new _643({region:"top",layoutPriority:1},"davinci_top_bar");
var _6bd=_67a.mainStackContainer=_6aa.editorsStackContainer=new _642({region:"center",id:"mainStackContainer",controllerWidget:"dijit.layout.StackController"});
var _6be=_67a.mainBorderContainer=new _640({design:"headline",gutters:false,id:"mainBorderContainer",liveSplitters:false});
var _6bf=_67a.shadowTabs=new _645({id:"davinci_file_tabs",closable:true,region:"top",layoutPriority:1,style:"display:none"});
_67a.shadowTabs.setTitle=function(tab,_6c0){
tab.attr("title",_6c0);
this.tablist.pane2button[tab.id].attr("label",_6c0);
};
dojo.connect(_6bf,"selectChild",function(_6c1){
var _6c2=_6c1.id;
var _6c3=_658(_6c2);
var _6c4=dijit.byId(_6c3);
var _6c5=dijit.byId("editors_container");
if(_6c5&&_6c4&&_6c4.editor){
_6c5.selectChild(_6c4);
}
});
dojo.connect(_6bf,"removeChild",this,_67a._shadowTabClosed);
var _6c6=new _643({id:"davinci_toolbar_pane",region:"top",layoutPriority:1,content:"<div id=\"davinci_toolbar_container\"></div>",style:"display:none"});
_6bb.addChild(_6bc);
_6bb.addChild(_6bd);
_6bd.addChild(_6be);
_6bd.selectChild(_6be);
_6be.addChild(_6bf);
_6be.addChild(_6c6);
_6be.addChild(_6ab);
_6bb.layout();
_6bb.startup();
_67a._originalOnResize=window.onresize;
window.onresize=_67a.onResize;
dojo.connect(_6ab,"onMouseUp",this,"onResize");
var _6c7=dijit.byId("davinci_file_tabs_tablist_Menu");
if(_6c7){
_6c7.addChild(new dijit.MenuItem({label:_64d.closeAllEditors,onClick:this.closeAllEditors}));
}
}
for(var _6c8 in _6aa.tabs.perspective){
var view=_6aa.tabs.perspective[_6c8];
if(!view){
continue;
}
dojo.forEach(view.getChildren(),function(_6c9){
view.removeChild(_6c9);
if(_6c8!="left"&&_6c8!="right"){
_6c9.destroyRecursive(false);
}
});
view.destroyRecursive(false);
delete _6aa.tabs.perspective[_6c8];
}
this._showViewPromises=dojo.map(_6ac.views,function(view){
return _67a.showView(view.viewID,view.selected,view.hidden);
},this);
davinci.Workbench.focusContainer=dojo.create("div",{"class":"focusContainer",id:"focusContainer"},document.body);
setTimeout(function(){
_6bb.resize();
dojo.publish("/davinci/workbench/ready",[]);
}.bind(this),3000);
},onResize:function(e){
var _6ca=e.explicitOriginalTarget?e.explicitOriginalTarget:e.srcElement;
if(e.type=="resize"||((_6ca.id&&(_6ca.id.indexOf("dijit_layout__Splitter_")>-1)||(_6ca.nextSibling&&_6ca.nextSibling.id&&_6ca.nextSibling.id.indexOf("dijit_layout__Splitter_")>-1)))){
var ed=davinci&&_632.currentEditor;
if(ed&&ed.onResize){
ed.onResize();
}
}
if(_67a._originalOnResize){
_67a._originalOnResize();
}
_67a._repositionFocusContainer();
},updateMenubar:function(node,_6cb){
var _6cc=_67a._createMenuTree(_6cb);
var _6cd=dijit.byId(node.id);
if(!_6cd){
_6cd=new _638({"class":"dijitInline"},node);
}
_67a._addItemsToMenubar(_6cc,_6cd);
},_updateMainMenubar:function(_6ce,_6cf){
for(var i=0;i<_6cf.length;i++){
var _6d0=_6cf[i];
for(var j=0;j<_6d0.menus.length;j++){
var menu=_6d0.menus[j];
var _6d1=_67a._createMenu(menu);
menu.id=menu.id.replace(".","-");
if(window.maqetta&&maqetta.TopBanner&&maqetta.TopBanner.attachMenu){
maqetta.TopBanner.attachMenu(menu,_6d1,_6ce);
}else{
var _6d2=dijit.byId(menu.id+"-dropdown");
if(!_6d2){
var _6d3={label:menu.label,dropDown:_6d1,id:menu.id+"-dropdown"};
if(menu.hasOwnProperty("showLabel")){
_6d3.showLabel=menu.showLabel;
}
if(menu.hasOwnProperty("iconClass")){
_6d3.iconClass=menu.iconClass;
}
if(menu.hasOwnProperty("className")){
_6d3["class"]=menu.className;
}
_6d2=new _63d(_6d3);
_6ce.appendChild(_6d2.domNode);
}
}
}
}
},_addItemsToMenubar:function(_6d4,_6d5){
dojo.forEach(_6d4,function(m){
var _6d6=m.menus,_6d7=_6d6.length;
if(_6d7){
dojo.forEach(_6d6,function(menu){
menu.id=menu.id.replace(/\./g,"-");
var _6d8=_67a._createMenu(menu),_6d9=dijit.byId(menu.id+"-dropdown");
if(!_6d9){
_6d9=new _63b({label:menu.label,popup:_6d8,id:menu.id+"-dropdown"});
}
_6d5.addChild(_6d9);
},this);
}
},this);
},getOpenEditor:function(_6da){
if(_6da!=null){
var tab=dijit.byId(_654(_6da.getPath()));
if(tab){
return tab.editor;
}
return null;
}
var _6db=dijit.byId("editors_container");
if(_6db&&_6db.selectedChildWidget&&_6db.selectedChildWidget.editor){
return _6db.selectedChildWidget.editor;
}
return null;
},closeActiveEditor:function(){
var _6dc=dijit.byId("editors_container");
var _6dd=dijit.byId("davinci_file_tabs");
if(_6dc&&_6dc.selectedChildWidget&&_6dc.selectedChildWidget.editor){
var _6de=selectedChildWidget.id;
var _6df=_656(_6de);
_6dc.closeChild(_6dc.selectedChildWidget);
var _6e0=dijit.byId(_6df);
if(_6e0){
_6dd.closeChild(_6e0);
}
}
},closeAllEditors:function(){
var _6e1=dijit.byId("editors_container");
if(_6e1){
_6e1.getChildren().forEach(function(_6e2){
_6e1.closeChild(_6e2);
});
}
},getAllOpenEditorIds:function(){
},showModal:function(_6e3,_6e4,_6e5,_6e6,_6e7,_6e8){
return _635.showModal(_6e3,_6e4,_6e5,_6e6,_6e7,_6e8);
},showMessage:function(_6e9,_6ea,_6eb,_6ec,_6ed){
return _635.showMessage(_6e9,_6ea,_6eb,_6ec,_6ed);
},showDialog:function(_6ee){
return _635.showDialog(_6ee);
},_createMenuTree:function(_6ef,_6f0){
if(!_6ef){
_6ef=_632.getExtensions("davinci.actionSets",function(_6f1){
var _6f2=_632.getExtensions("davinci.actionSetPartAssociations",function(_6f3){
return _6f3.targetID==_6f1.id;
});
return _6f2.length==0;
});
}
var _6f4=[];
function _6f5(m,id){
for(var j=0,jLen=m.length;j<jLen;j++){
for(var k=0,kLen=m[j].menus.length;k<kLen;k++){
if(id==m[j].menus[k].id){
return m[j].menus[k].menus;
}
}
}
};
function _6f6(item,path,_6f7){
path=path||"additions";
path=path.split("/");
var m=_6f4;
_67a._loadActionClass(item);
var sep=path[path.length-1];
if(path.length>1){
for(var i=0,len=path.length-1;i<len;i++){
var k=_6f5(m,path[i]);
if(k){
m=k;
}
}
}
for(var i=0,len=m.length;i<len;i++){
if(m[i].id==sep){
var _6f8=m[i].menus;
_6f8.push(item);
if(item.separator){
var _6f9=false;
_6f8=item.menus=[];
for(var j=0;j<item.separator.length;j+=2){
var id=item.separator[j];
_6f9=id=="additions";
_6f8.push({id:id,isSeparator:item.separator[j+1],menus:[]});
}
if(!_6f9){
_6f8.push({id:"additions",isSeparator:false,menus:[]});
}
}
return;
}
}
if(_6f7){
_6f4.push({id:sep,isSeparator:false,menus:[item]});
}
};
for(var _6fa=0,len=_6ef.length;_6fa<len;_6fa++){
var _6fb=_6ef[_6fa];
if(_6fb.visible){
if(_6fb.menu){
for(var _6fc=0,_6fd=_6fb.menu.length;_6fc<_6fd;_6fc++){
var menu=_6fb.menu[_6fc];
if(menu.__mainMenu){
for(var j=0;j<menu.separator.length;j+=2){
_6f4.push({id:menu.separator[j],isSeparator:menu.separator[j+1],menus:[]});
}
}else{
_6f6(menu,menu.path,_6f0);
if(menu.populate instanceof Function){
var _6fe=menu.populate();
for(var item in _6fe){
_6f6(_6fe[item],_6fe[item].menubarPath);
}
}
}
}
}
}
}
for(var _6fa=0,len=_6ef.length;_6fa<len;_6fa++){
var _6fb=_6ef[_6fa];
if(_6fb.visible){
for(var _6ff=0,_700=_6fb.actions.length;_6ff<_700;_6ff++){
var _701=_6fb.actions[_6ff];
if(_701.menubarPath){
_6f6(_701,_701.menubarPath,_6f0);
}
}
}
}
return _6f4;
},_loadActionClass:function(item){
if(typeof item.action=="string"){
_631([item.action],function(_702){
item.action=new _702();
item.action.item=item;
});
}
},_createMenu:function(menu,_703){
var _704,_705,_706;
if(menu.menus){
_704=new Menu({parentMenu:menu});
_705=menu.menus;
_706="onOpen";
}else{
_704=new _707({});
_705=menu;
_706="menuOpened";
}
_704.domNode.style.display="none";
_704.actionContext=_703;
this._rebuildMenu(_704,_705);
dojo.connect(_704,_706,this,function(evt){
if(_704._widgetCallback){
_704._widgetCallback(evt);
}
this._rebuildMenu(_704,_705).focus();
});
return _704;
},singleProjectMode:function(){
return true;
},getProject:function(){
return _67a.getActiveProject()||_67a._DEFAULT_PROJECT;
},loadProject:function(_708){
_67a.setActiveProject(_708);
return _67a.updateWorkbenchState().then(function(){
location.href="cmd/configProject?configOnly=true&project="+encodeURIComponent(_708);
});
},location:function(){
return _632.location();
},_rebuildMenu:function(_709,_70a){
dojo.forEach(_709.getChildren(),function(_70b){
_709.removeChild(_70b);
_70b.destroy();
});
_709.focusedChild=null;
var _70c,_70d;
_70a.forEach(function(menu,i){
if(menu.menus.length){
if(menu.isSeparator&&i>0){
_70c=true;
}
menu.menus.forEach(function(item){
if(_70c&&_70d){
_709.addChild(new _63a({}));
_70c=false;
}
_70d=true;
var _70e=item.label;
if(item.action&&item.action.getName){
_70e=item.action.getName();
}
if(item.separator){
var _70f=_67a._createMenu(item);
var _710=new _639({label:_70e,popup:_70f,id:_70f.id+"item"});
_710.actionContext=_709.actionContext;
_709.addChild(_710);
}else{
var _711=true;
if(item.isEnabled){
var _712=_632.getSelection(),_713=_712[0]&&_712[0].resource;
_711=_713?item.isEnabled(_713):false;
}
if(item.action){
if(item.action.shouldShow&&!item.action.shouldShow(_709.actionContext,{menu:_709})){
return;
}
_711=item.action.isEnabled&&item.action.isEnabled(_709.actionContext);
}
var _714={label:_70e,id:item.id,disabled:!_711,onClick:dojo.hitch(this,"_runAction",item,_709.actionContext)};
if(item.iconClass){
_714.iconClass=item.iconClass;
}
_709.addChild(new _639(_714));
}
},this);
}
},this);
return _709;
},_toggleButton:function(_715,_716,_717,arg){
if(!_715.checked){
return;
}
_717.forEach(function(item){
if(item!=_715){
item.set("checked",false);
}
});
_67a._runAction(_715.item,_716,_715.item.id);
},_runAction:function(item,_718,arg){
if(_718&&_632.currentEditor){
_718=_632.currentEditor;
}
if(item.run){
item.run();
}else{
if(item.action){
if(dojo.isString(item.action)){
this._loadActionClass(item);
}
item.action.run(_718);
}else{
if(item.method&&_718&&_718[item.method] instanceof Function){
_718[item.method](arg);
}else{
if(item.commandID){
_632.executeCommand(item.commandID);
}
}
}
}
},showView:function(_719,_71a,_71b){
var d=new _649();
try{
var _71c=dijit.byId("mainBody"),view=_632.getExtension("davinci.view",_719),_71d=dojo.byId("mainBody"),_71e=_67a.activePerspective,_71f=_632.getExtension("davinci.perspective",_71e),_720="left",cp1;
dojo.some(_71f.views,function(view){
if(view.viewID==_719){
_720=view.position;
return true;
}
});
_71d.tabs=_71d.tabs||{};
_71d.tabs.perspective=_71d.tabs.perspective||{};
if(_720=="right"&&!_71d.tabs.perspective.right){
_71c.addChild(_71d.tabs.perspective.right=new _640({"class":"davinciPaletteContainer",style:"width: "+_651+"px;",id:"right_mainBody",minSize:_651,region:"right",gutters:false,splitter:true}));
_71d.tabs.perspective.right.startup();
_653.right_mainBody={expandToSize:340,initialExpandToSize:340};
}
if(_720=="left"&&!_71d.tabs.perspective.left){
_71c.addChild(_71d.tabs.perspective.left=new _640({"class":"davinciPaletteContainer",style:"width: "+_651+"px;",id:"left_mainBody",minSize:_651,region:"left",gutters:false,splitter:true}));
_71d.tabs.perspective.left.startup();
_653["left_mainBody"]={expandToSize:318,initialExpandToSize:318};
}
if(_720==="left"||_720==="right"){
_720+="-top";
}
var _721=_720;
if(!_71d.tabs.perspective[_720]){
_721=_720.split("-");
var _722=_721[0],_723=_71c,_724="davinciPalette ",_725="";
if(_721[1]&&(_722=="left"||_722=="right")){
_723=_71d.tabs.perspective[_722];
_722=_721[1];
if(_721[1]=="top"){
_722="center";
_724+="davinciTopPalette";
}else{
_725="height:30%;";
_724+="davinciBottomPalette";
}
}else{
if(_722=="bottom"){
_725="height:80px;";
_724+="davinciBottomPalette";
}
}
cp1=_71d.tabs.perspective[_720]=new _645({region:_722,id:"palette-tabcontainer-"+_720,tabPosition:_721[0]+"-h",tabStrip:false,"class":_724,style:_725,splitter:_722!="center",controllerWidget:"dijit.layout.TabController"});
_723.addChild(cp1);
dojo.connect(cp1,"selectChild",this,function(tab){
if(tab&&tab.domNode){
var tc=tab.getParent();
if(!this._showViewAddChildInProcess&&!tc._maqDontExpandCollapse){
if(tc._maqLastSelectedChild==tab){
this._expandCollapsePaletteContainer(tab);
}else{
this.expandPaletteContainer(tab.domNode);
}
}
tc._maqLastSelectedChild=tab;
}
}.bind(this));
}else{
cp1=_71d.tabs.perspective[_720];
}
if(dojo.some(cp1.getChildren(),function(_726){
return _726.id==view.id;
})){
return;
}
this.instantiateView(view).then(function(tab){
this._showViewAddChildInProcess=true;
if(!_71b){
cp1.addChild(tab);
}
this._showViewAddChildInProcess=false;
var _727=tab.controlButton;
if(_727&&_727.domNode){
_727.domNode.title=view.title+" "+_64d.palette;
}
if(_71a){
cp1.selectChild(tab);
}
d.resolve(tab);
}.bind(this));
}
catch(ex){
console.error("Error loading view: "+view.id);
console.error(ex);
}
return d;
},instantiateView:function(view){
var d=new _649(),tab=dijit.byId(view.id);
if(tab){
d.resolve(tab);
}else{
_631([view.viewClass],function(_728){
var _729={title:view.title,id:view.id,closable:false,view:view};
if(view.iconClass){
_729.iconClass=view.iconClass;
}
if(!_67a.palettes){
_67a.palettes={};
}
d.resolve((_67a.palettes[view.viewClass]=new (_728||_633)(_729),_67a.palettes[view.viewClass]));
});
}
return d;
},hideView:function(_72a){
for(var _72b in mainBody.tabs.perspective){
if(_72b=="left"||_72b=="right"){
_72b+="-top";
}
if(!mainBody.tabs.perspective[_72b]){
continue;
}
var _72c=mainBody.tabs.perspective[_72b].getChildren();
var _72d=false;
for(var i=0;i<_72c.length&&!_72d;i++){
if(_72c[i].id==_72a){
mainBody.tabs.perspective[_72b].removeChild(_72c[i]);
_72c[i].destroyRecursive(false);
}
}
}
},toggleView:function(_72e){
var _72f=dojo.byId(_72e);
if(_72f){
_67a.hideView(_72e);
}else{
_67a.showView(_72e,true);
}
},openEditor:function(_730,_731){
try{
var _732=_730.fileName,_733;
if(typeof _732=="string"){
_733=_732.substr(_732.lastIndexOf(".")+1);
}else{
_733=_732.getExtension();
_732=_732.getPath();
}
var _734=dijit.byId(_654(_732)),_735=dijit.byId("editors_container");
if(_734){
_735.selectChild(_734);
var _736=_734.editor;
if(_730.startOffset){
_736.select(_730);
}
return;
}
var _737=_730.editorCreateCallback;
var _738=_632.getExtensions("davinci.editor",function(_739){
if(typeof _739.extensions=="string"){
_739.extensions=_739.extensions.split(",");
}
return dojo.some(_739.extensions,function(e){
return e.toLowerCase()==_733.toLowerCase();
});
});
var _73a=_738[0];
if(_738.length>1){
dojo.some(_738,function(_73b){
_73a=_73b;
return _73b.isDefault;
});
}
_67a._createEditor(_73a,_732,_730,_731).then(function(_73c){
if(_737){
_737.call(window,_73c);
}
if(!_730.noSelect){
_632.currentEditor=_73c;
}
},function(_73d){
console.error("Error opening editor for filename: "+_732,_73d);
});
}
catch(ex){
console.error("Exception opening editor for filename: "+_730&&_730.fileName);
console.error(ex);
}
},_createEditor:function(_73e,_73f,_740,_741){
var d=new _649();
var _742=_73f.split("/").pop();
var _743=_740&&_740.fileName&&_740.fileName.extension?"."+_740.fileName.extension:"";
_742+=(_743==".rev"?_743:"");
dojo.query(".loading").orphan();
var _744=dijit.byId("editorsStackContainer"),_745=dijit.byId("editors_container");
if(_744&&_745){
_744.selectChild(_745);
_67a.mainStackContainer.selectChild(_67a.mainBorderContainer);
}
var _746=dijit.byId(_654(_73f)),_747=dijit.byId("editors_container"),_748=dijit.byId("davinci_file_tabs"),_749=false,_74a=null;
if(!_746){
_749=true;
var _74b=_654(_73f);
var _74c=_656(_74b);
_746=new _634({title:_742,id:_74b,"class":"EditorContainer",isDirty:_740.isDirty});
_74a=new _643({title:_742,closable:true,id:_74c});
_74a.onClose=function(tc,tab){
var _74d=tab.id;
var _74e=_658(_74d);
var _74f=dijit.byId(_74e);
var _750=dijit.byId("editors_container");
function _751(){
_74f._skipDirtyCheck=true;
_74f.onClose.apply(_74f,[_750,_74f]);
tc.removeChild(tab);
tab.destroyRecursive();
};
function _752(){
_74f.editor.save();
_751();
};
if(_750&&_74f){
if(_74f.editor.isDirty){
var _753=_74f.editor.getOnUnloadWarningMessage();
if(!_753){
_753=dojo.string.substitute(_647.fileHasUnsavedChanges,[_74f._getTitle()]);
}
_67a.showDialog({title:_74f._getTitle(),content:_753,style:{width:300},okLabel:_64f.save,okCallback:dojo.hitch(this,_752),hideLabel:null,submitOnEnter:true,extendLabels:[_64f.discard],extendCallbacks:[dojo.hitch(this,_751)]});
}else{
_751();
}
}
};
}
if(!_73e){
_73e={editorClass:"davinci/ui/TextEditor",id:"davinci.ui.TextEditor"};
}
if(_749){
_747.addChild(_746);
_748.addChild(_74a);
}
if(!_67a.hideEditorTabs){
var _754=dojo.query(".dijitTabButtonIcon",_746.controlButton.domNode);
dojo.addClass(_754[0],"tabButtonLoadingIcon");
dojo.removeClass(_754[0],"dijitNoIcon");
}
if(!_740.noSelect){
_747.selectChild(_746);
}
if(!_740.initializationTime){
_67a._state.activeEditor=_73f;
}
_746.setEditor(_73e,_73f,true,_740.fileName,_746.domNode,_741).then(function(_755){
if(_740.startLine){
_746.editor.select(_740);
}
if(!_740.noSelect){
if(_67a._state.editors.indexOf(_73f)===-1){
_67a._state.editors.push(_73f);
}
_67a._switchEditor(_746.editor,_740.startup);
}
if(!_67a.hideEditorTabs){
dojo.removeClass(_754[0],"tabButtonLoadingIcon");
dojo.addClass(_754[0],"dijitNoIcon");
}
setTimeout(function(){
_746.resize();
},100);
d.resolve(_746.editor);
},function(_756){
if(!_67a.hideEditorTabs){
dojo.removeClass(_754[0],"tabButtonLoadingIcon");
dojo.addClass(_754[0],"tabButtonErrorIcon");
}
d.reject(_756);
});
return d;
},createPopup:function(args){
var _757=args.partID,_758=args.domNode,_759=args.context,_75a=args.openCallback;
var o=this.getActionSets(_757);
var _75b=o.clonedActionSets;
var _75c=o.actionSets;
if(_75b.length>0){
var _75d=_67a._createMenuTree(_75b,true);
_67a._initActionsKeys(_75c,args);
var _75e=_67a._createMenu(_75d,_759);
if(_75e&&_758){
_75e.bindDomNode(_758);
}
_75e._widgetCallback=_75a;
_75e._partID=_757;
return _75e;
}
},getActionSets:function(_75f){
var _760=[];
_632.getExtension("davinci.actionSetPartAssociations",function(_761){
return _761.parts.some(function(part){
if(part==_75f){
_760.push(_761.targetID);
return true;
}
});
});
var _762;
var _763=[];
if(_760.length){
_762=_632.getExtensions("davinci.actionSets",function(_764){
return _760.some(function(_765){
return _765==_764.id;
});
});
if(_762.length){
_762.forEach(function(_766){
var _767=_648.getLibraryActions(_766.id);
if(_767.length){
_766=lang.mixin({},_766);
_766.actions=_766.actions.concat(_767);
}
_763.push(_766);
});
}
}
return {actionSets:_762,clonedActionSets:_763};
},_initActionsKeys:function(_768,args){
var _769=args.keysDomNode||args.domNode,keys={},_76a;
dojo.forEach(_768,function(_76b){
dojo.forEach(_76b.actions,function(_76c){
if(_76c.keySequence){
keys[_76c.keySequence]=_76c;
_76a=true;
}
});
});
if(_76a){
var _76d=args.context;
dojo.connect(_769,"onkeydown",function(e){
var seq=_67a._keySequence(e),_76e=keys[seq];
if(_76e){
if(_76e.action.shouldShow&&!_76e.action.shouldShow(_76d)){
return;
}
if(_76e.action.isEnabled(_76d)){
_67a._runAction(_76e,_76d);
}
}
});
}
},_initKeys:function(){
var keys={all:[]};
var _76f=_632.getExtensions("davinci.keyBindings");
dojo.forEach(_76f,function(_770){
var _771=_770.contextID||"all";
var _772=keys[_771];
if(!_772){
_772=keys[_771]=[];
}
_772[_770.sequence]=_770.commandID;
});
_67a.keyBindings=keys;
},handleKey:function(e){
if(!_67a.keyBindings){
return;
}
var seq=_67a._keySequence(e);
var cmd;
if(_67a.currentContext&&_67a.keyBindings[_67a.currentContext]){
cmd=_67a.keyBindings[_67a.currentContext][seq];
}
if(!cmd){
cmd=_67a.keyBindings.all[seq];
}
if(cmd){
_632.executeCommand(cmd);
return true;
}
},_keySequence:function(e){
var seq=[];
if(window.event){
if(window.event.ctrlKey){
seq.push("M1");
}
if(window.event.shiftKey){
seq.push("M2");
}
if(window.event.altKey){
seq.push("M3");
}
}else{
if(e.ctrlKey||(e.modifiers==2)||(e.modifiers==3)||(e.modifiers>5)){
seq.push("M1");
}
if(e.shiftKey||(e.modifiers>3)){
seq.push("M2");
}
if(e.modifiers){
if(e.altKey||(e.modifiers%2)){
seq.push("M3");
}
}else{
if(e.altKey){
seq.push("M3");
}
}
}
var _773=String.fromCharCode(e.keyCode);
if(/[A-Z0-9]/.test(_773)){
}else{
var _774={46:"del",114:"f3"};
_773=_774[e.keyCode]||"xxxxxxxxxx";
}
_773=_773.toUpperCase();
if(_773==" "){
_773="' '";
}
seq.push(_773);
return seq.join("+");
},setActionScope:function(_775,_776){
_67a.actionScope[_775]=_776;
},findView:function(_777){
var _778=dijit.byId(_777);
if(_778){
return _778;
}
},_switchEditor:function(_779,_77a){
var _77b=_632.currentEditor;
_632.currentEditor=_779;
_67a._state.activeEditor=_779?_779.fileName:null;
this._removeFocusContainerChildren();
this._showEditorTopPanes();
try{
dojo.publish("/davinci/ui/editorSelected",[{editor:_779,oldEditor:_77b}]);
}
catch(ex){
console.error(ex);
}
_67a._updateTitle(_779);
setTimeout(function(){
if(_779&&_779.visualEditor&&_779.visualEditor.context&&_779.visualEditor.context.isActive()){
_779.visualEditor.context.getTopWidgets().forEach(function(_77c){
if(_77c.resize){
_77c.resize();
}
});
}
this._repositionFocusContainer();
}.bind(this),1000);
all(this._showViewPromises).then(function(){
if(_779&&_779.focus){
_779.focus();
}
this._rearrangePalettes(_779);
this._expandCollapsePaletteContainers(_779);
}.bind(this));
if(!_77a){
_67a.saveState=true;
}
},_rearrangePalettes:function(_77d){
var _77e,_77f,_780;
if(_77d){
var _781=_632.getExtensions("davinci.editor",function(_782){
return _77d?(_782.id===_77d.editorID):false;
});
if(_781&&_781.length>0){
var _783=_781[0];
_77e=_783.palettePerspective;
}
_77f=_77d._rightPaletteExpanded;
_780=_77d._leftPaletteExpanded;
}else{
_77e=_632.initialPerspective||"davinci.ui.main";
}
if(_77e){
var _784=_632.getExtension("davinci.perspective",_77e);
if(!_784){
_632.handleError(dojo.string.substitute(_647.perspectiveNotFound,[_783.palettePerspective]));
}
var _785=_784.views;
dojo.forEach(_785,function(_786){
var _787=_786.viewID;
var _788=_786.position;
if(_788.indexOf("bottom")<0){
_788+="-top";
}
var tab=dijit.byId(_787);
if(tab){
var _789=tab.getParent();
var _78a=mainBody.tabs.perspective[_788];
if(_789!=_78a){
if(_789){
_789.removeChild(tab);
}
if(!_786.hidden){
_78a.addChild(tab);
_789=_78a;
}
}
if(_789){
if(_786.hidden){
_789.removeChild(tab);
}else{
if(_786.selected){
_789._maqDontExpandCollapse=true;
_789.selectChild(tab);
delete _789._maqDontExpandCollapse;
}
}
}
}
});
}
if(_77d){
if(_77d.hasOwnProperty("_rightPaletteExpanded")){
_77d._rightPaletteExpanded=_77f;
}
if(_77d.hasOwnProperty("_leftPaletteExpanded")){
_77d._leftPaletteExpanded=_780;
}
}
},_nearlyCollapsed:function(_78b){
var _78c=dojo.style(_78b,"width");
if(typeof _78c=="string"){
_78c=parseInt(_78c);
}
return _78c<(_651+_652);
},_expandCollapsePaletteContainer:function(tab){
if(!tab||!tab.domNode){
return;
}
var _78d=davinci.Workbench.findPaletteContainerNode(tab.domNode);
if(!_78d.id){
return;
}
var _78e=_78d._maqExpanded;
var _78f;
if(this._nearlyCollapsed(_78d)){
_78e=false;
_78f=(_653[_78d.id].expandToSize>=(_651+_652))?_653[_78d.id].expandToSize:_653[_78d.id].initialExpandToSize;
}
if(_78e){
this.collapsePaletteContainer(_78d);
}else{
this.expandPaletteContainer(_78d,{expandToSize:_78f});
}
},_expandCollapsePaletteContainers:function(_790,_791){
var _792=dijit.byId("left_mainBody");
var _793=dijit.byId("right_mainBody");
if(!_790){
if(_792){
this.collapsePaletteContainer(_792.domNode,_791);
}
if(_793){
this.collapsePaletteContainer(_793.domNode,_791);
}
}else{
var _794=_632.getExtensions("davinci.editor",function(_795){
return _795.id===_790.editorID;
});
if(_794&&_794.length>0){
var _796=_794[0].expandPalettes;
var _797;
if(_792){
if(_790&&_790.hasOwnProperty("_leftPaletteExpanded")){
_797=_790._leftPaletteExpanded;
}else{
_797=(_796&&_796.indexOf("left")>=0);
}
if(_797){
this.expandPaletteContainer(_792.domNode,_791);
}else{
this.collapsePaletteContainer(_792.domNode,_791);
}
}
if(_793){
if(_790&&_790.hasOwnProperty("_rightPaletteExpanded")){
_797=_790._rightPaletteExpanded;
}else{
_797=(_796&&_796.indexOf("right")>=0);
}
if(_797){
this.expandPaletteContainer(_793.domNode,_791);
}else{
this.collapsePaletteContainer(_793.domNode,_791);
}
}
}
}
},_updateTitle:function(_798){
var _799=_67a._baseTitle;
if(_798){
_799=_799+" - ";
if(_798.isDirty){
_799=_799+"*";
}
_799=_799+_798.fileName;
}
dojo.doc.title=_799;
},_editorTabClosed:function(page){
if(!davinci.Workbench._editorTabClosing[page.id]){
davinci.Workbench._editorTabClosing[page.id]=true;
if(page&&page.editor&&page.editor.fileName){
var _79a=page.id;
var _79b=_656(_79a);
var _79c=dijit.byId("davinci_file_tabs");
var _79d=dijit.byId(_79b);
var i=_67a._state.editors.indexOf(page.editor.fileName);
if(i!=-1){
_67a._state.editors.splice(i,1);
}
_67a.saveState=true;
if(!davinci.Workbench._shadowTabClosing[_79b]){
_79c.removeChild(_79d);
_79d.destroyRecursive();
}
}
var _79e=dijit.byId("editors_container").getChildren();
if(!_79e.length){
_67a._switchEditor(null);
this._expandCollapsePaletteContainers(null);
var _79f=dijit.byId("editorsStackContainer");
var _7a0=dijit.byId("editorsWelcomePage");
if(_79f&&_7a0){
_79f.selectChild(_7a0);
}
this._hideEditorTopPanes();
}
delete davinci.Workbench._editorTabClosing[page.id];
}
},_shadowTabClosed:function(page){
if(!davinci.Workbench._shadowTabClosing[page.id]){
davinci.Workbench._shadowTabClosing[page.id]=true;
var _7a1=page.id;
var _7a2=_658(_7a1);
if(!davinci.Workbench._editorTabClosing[_7a2]){
var _7a3=dijit.byId(_7a2);
var _7a4=dijit.byId("editors_container");
if(_7a4&&_7a3){
_7a4.removeChild(_7a3);
_7a3.destroyRecursive();
}
}
delete davinci.Workbench._shadowTabClosing[page.id];
}
},getActiveProject:function(){
if(!_67a._state){
_67a._state=_632.getWorkbenchState();
}
var _7a5=dojo.queryToObject(dojo.doc.location.search.substr((dojo.doc.location.search[0]==="?"?1:0))).project;
if(_7a5){
_67a.loadProject(_7a5);
}
if(_67a._state.hasOwnProperty("project")){
return _67a._state.project;
}
return _67a._DEFAULT_PROJECT;
},setActiveProject:function(_7a6){
if(!_67a._state){
_67a._state={};
}
_67a._state.project=_7a6;
_67a.saveState=true;
},workbenchStateCustomPropGet:function(_7a7){
if(typeof _7a7=="string"){
return _67a._state[_7a7];
}
},workbenchStateCustomPropSet:function(_7a8,_7a9){
if(typeof _7a8=="string"){
if(typeof _7a9=="undefined"){
delete _67a._state[_7a8];
}else{
_67a._state[_7a8]=_7a9;
}
_67a.saveState=true;
}
},clearWorkbenchState:function(){
_67a._state={};
return _67a.updateWorkbenchState();
},updateWorkbenchState:function(){
delete _67a.saveState;
return xhr.put({url:"cmd/setWorkbenchState",putData:JSON.stringify(_67a._state),handleAs:"text"});
},_autoSave:function(){
var _7aa=_67a._lastAutoSave;
var _7ab=false;
function _7ac(_7ad){
if(_7ad.isReadOnly||!_7ad.isDirty){
return;
}
var _7ae=_7ad.lastModifiedTime;
if(_7ae&&_7ae>_7aa){
try{
_7ad.save(true);
}
catch(ex){
console.error("Error while autosaving file:"+ex);
_7ab=true;
}
}
};
if(_67a.editorTabs){
dojo.forEach(_67a.editorTabs.getChildren(),_7ac);
}
if(!_7ab){
_67a._lastAutoSave=Date.now();
}
},setupGlobalKeyboardHandler:function(){
var _7af=_632.getExtensions("davinci.actionSets");
dojo.forEach(_7af,function(_7b0){
if(_7b0.id=="davinci.ui.main"||_7b0.id=="davinci.ui.editorActions"){
dojo.forEach(_7b0.actions,function(_7b1){
if(_7b1.keyBinding){
_632.registerKeyBinding(_7b1.keyBinding,_7b1);
}
});
}
});
},findPaletteContainerNode:function(node){
var _7b2;
var n=node;
while(n&&n.tagName!="BODY"){
if(dojo.hasClass(n,"davinciPaletteContainer")){
_7b2=n;
break;
}
n=n.parentNode;
}
return _7b2;
},collapsePaletteContainer:function(node,_7b3){
var _7b4=davinci.Workbench.findPaletteContainerNode(node);
if(_7b4&&_7b4.id){
var id=_7b4.id;
var _7b5=dojo.style(_7b4,"width");
var _7b6=dijit.byNode(_7b4);
var _7b7=dojo.query("[role=tablist]",_7b4);
if(_7b6&&_7b7.length>0){
var _7b8=_7b7[0];
var _7b9=dojo.marginBox(_7b8);
var _7ba=_7b6.getParent();
if(_7ba&&_7ba.resize&&_7b9&&_7b9.w){
if(!this._nearlyCollapsed(_7b4)&&(!_7b3||!_7b3.dontPreserveWidth)){
_653[id].expandToSize=_7b5;
}
_7b4.style.width=_7b9.w+"px";
_7ba.resize();
_7b6._isCollapsed=true;
}
}
dojo.removeClass(_7b4,"maqPaletteExpanded");
_7b4._maqExpanded=false;
davinci.Workbench._repositionFocusContainer();
var _7bb=_632.currentEditor;
if(_7bb){
if(_7b4.id=="left_mainBody"){
_7bb._leftPaletteExpanded=false;
}else{
if(_7b4.id=="right_mainBody"){
_7bb._rightPaletteExpanded=false;
}
}
}
}
},expandPaletteContainer:function(node,_7bc){
var _7bd=_7bc&&_7bc.expandToSize;
var _7be=davinci.Workbench.findPaletteContainerNode(node);
if(_7be&&_7be.id){
var id=_7be.id;
var _7bf=dijit.byNode(_7be);
if(_7bd){
_653[id].expandToSize=_7bd;
}
if(_7bf&&_653[id].expandToSize){
var _7c0=_7bf.getParent();
if(_7c0&&_7c0.resize){
_7be.style.width=_653[id].expandToSize+"px";
_7c0.resize();
delete _7bf._isCollapsed;
}
}
dojo.addClass(_7be,"maqPaletteExpanded");
_7be._maqExpanded=true;
davinci.Workbench._repositionFocusContainer();
var _7c1=_632.currentEditor;
if(_7c1){
if(_7be.id=="left_mainBody"){
_7c1._leftPaletteExpanded=true;
}else{
if(_7be.id=="right_mainBody"){
_7c1._rightPaletteExpanded=true;
}
}
}
}
},_repositionFocusContainer:function(){
var _7c2=dojo.byId("editors_container");
var _7c3=dojo.byId("focusContainer");
if(_7c2&&_7c3){
var _7c4=_632.currentEditor;
var box;
if(_7c4&&_7c4.getFocusContainerBounds){
box=_7c4.getFocusContainerBounds();
}else{
box=_64e.getBorderBoxPageCoords(_7c2);
}
if(box){
_7c3.style.left=box.l+"px";
_7c3.style.top=box.t+"px";
_7c3.style.width=box.w+"px";
_7c3.style.height=box.h+"px";
if(_7c4&&_7c4.getContext){
var _7c5=_7c4.getContext();
if(_7c5&&_7c5.updateFocusAll){
_7c5.updateFocusAll();
}
}
}
}
},_hideShowEditorTopPanes:function(_7c6){
var _7c7=dijit.byId("davinci_app");
var _7c8=dijit.byId("davinci_file_tabs");
var _7c9=dijit.byId("davinci_toolbar_pane");
_7c8.domNode.style.display=_7c6;
_7c9.domNode.style.display=_7c6;
_7c7.resize();
},_hideEditorTopPanes:function(){
this._hideShowEditorTopPanes("none");
},_showEditorTopPanes:function(){
this._hideShowEditorTopPanes("block");
},_removeFocusContainerChildren:function(){
davinci.Workbench.focusContainer.innerHTML="";
},_XX_last_member:true};
var _707=_64a(Menu,{menuOpened:function(_7ca){
},_openMyself:function(_7cb){
this.menuOpened(_7cb);
var open;
try{
var _7cc=document.getElementById("menuOverlayDiv");
if(!_7cc){
_7cc=dojo.create("div",{id:"menuOverlayDiv",style:"left:0px; top:0px; width:100%; height:100%; position:absolute; z-index:10;"},document.body);
}
if(this.adjustPosition){
var _7cd=this.adjustPosition(_7cb);
open=dijit.popup.open;
dijit.popup.open=function(args){
args.x+=_7cd.x;
args.y+=_7cd.y;
open.call(dijit.popup,args);
};
}
this.onClose=function(){
var _7ce=document.getElementById("menuOverlayDiv");
if(_7ce){
_7ce.parentNode.removeChild(_7ce);
}
}.bind(this);
this.inherited(arguments);
}
finally{
if(open){
dijit.popup.open=open;
}
}
}});
window.setInterval(function(){
if(_67a.saveState){
_67a.updateWorkbenchState();
}
},1000);
dojo.setObject("davinci.Workbench",_67a);
return _67a;
});
},"davinci/ve/themeEditor/metadata/CSSThemeProvider":function(){
define(["dojo/_base/declare","../../utils/pseudoClass"],function(_7cf,_7d0){
return _7cf("davinci.ve.themeEditor.metadata.CSSThemeProvider",null,{module:"davinci.lib",path:"theme/tundra.json",constructor:function(_7d1,_7d2){
this._theme=_7d2;
this.url=encodeURI(_7d1[0].getURL());
this.getWidgets();
},getWidgets:function(){
if(!this._widgets){
var _7d3=undefined;
dojo.xhrGet({url:""+this.url,handleAs:"json",sync:true,load:function(_7d4){
_7d3=_7d4;
}});
this._widgets=_7d3;
this._createDefaults();
}
return this._widgets;
},_createDefaults:function(){
var ret=true;
for(var a in this._widgets){
var _7d5=this._widgets[a];
for(var b in _7d5){
var _7d6=_7d5[b];
for(var c in _7d6.states){
var _7d7=_7d6.states[c];
var _7d8=this.getStyleSelectors(a+"."+b,c);
}
for(var sw in _7d6.subwidgets){
var _7d9=_7d6.subwidgets[sw];
for(var c in _7d9.states){
var _7d7=_7d9.states[c];
var _7d8=this.getStyleSelectors(a+"."+b,c,sw);
}
}
}
}
return;
},getRelativeStyleSelectorsText:function(_7da,_7db,_7dc,_7dd,_7de){
var _7df=this.getStyleSelectors(_7da,_7db,_7dc);
var _7e0=[];
for(s in _7df){
_7dd.forEach(function(_7e1){
var _7e2=false;
for(var p=0;!_7e2&&p<_7df[s].length;p++){
if(_7df[s][p]==_7e1||_7df[s][p]=="$std_10"){
_7e2=true;
}
}
if(_7e2){
var text=""+s;
var _7e3=text.split(" ");
text="";
_7e3.forEach(function(c){
if(c!="."+_7de){
text+=" "+c;
}
}.bind(this));
_7e0.push(text.replace(/^\s*/,"").replace(/\s*$/,""));
return;
}
}.bind(this));
}
return _7e0;
},getStyleSelectors:function(_7e4,_7e5,_7e6){
if(!_7e4){
return;
}
if(!_7e5){
_7e5="Normal";
}
var _7e7;
var p=_7e4.split(/[\.\/]/);
var w=p[0];
var n=p[p.length-1];
if(_7e6&&(w in this._widgets)&&(n in this._widgets[w])){
var sw=(_7e6.id)?_7e6.id:_7e6;
if(!this._widgets[w][n].subwidgets[""+sw].states[""+_7e5]){
return null;
}
_7e7=this._widgets[w][n].subwidgets[""+sw].states[""+_7e5].selectors;
if(!_7e7||_7e7=="$auto"){
_7e7=this._createDefaultSelectors(""+w+sw,_7e5);
this._widgets[w][n].subwidgets[""+sw].states[""+_7e5].selectors=_7e7;
}
}else{
if(this._widgets&&(w in this._widgets)&&(n in this._widgets[w])){
if(this._widgets[w][n].states[""+_7e5]){
_7e7=this._widgets[w][n].states[""+_7e5].selectors;
if(!_7e7||_7e7=="$auto"){
_7e7=this._createDefaultSelectors(""+w+n,_7e5);
this._widgets[w][n].states[""+_7e5].selectors=_7e7;
}
}
}else{
}
}
return _7e7;
},getElementStyleProperties:function(_7e8,_7e9,_7ea){
if(!_7e8){
return;
}
if(!_7e9){
_7e9="Normal";
}
var _7eb;
var p=_7e8.split(/[\.\/]/);
var w=p[0];
var n=p[p.length-1];
if(_7ea&&(w in this._widgets)&&(n in this._widgets[w])){
var sw=(_7ea.id)?_7ea.id:_7ea;
if(!(this._widgets[w][n].subwidgets[""+sw].states[""+_7e9])||!(this._widgets[w][n].subwidgets[""+sw].states[""+_7e9].element)||!(this._widgets[w][n].subwidgets[""+sw].states[""+_7e9].element.style)){
return null;
}
_7eb=this._widgets[w][n].subwidgets[""+sw].states[""+_7e9].element.style;
}else{
if(this._widgets&&(w in this._widgets)&&(n in this._widgets[w])){
if(this._widgets[w][n].states[""+_7e9]&&this._widgets[w][n].states[""+_7e9].element&&this._widgets[w][n].states[""+_7e9].element.style){
_7eb=this._widgets[w][n].states[""+_7e9].element.style;
}
}else{
}
}
return _7eb;
},_createDefaultSelectors:function(_7ec,_7ed){
var _7ee;
if(_7ed=="Normal"){
_7ee="."+this._theme.className+" ."+_7ec;
}else{
_7ee="."+this._theme.className+" ."+_7ec+_7ed;
}
var _7ef={};
_7ef[_7ee]=["$std_10"];
return _7ef;
},_createDefaultQuery:function(_7f0,_7f1){
return "."+_7f0;
},_simulateState:function(q,s,mode,_7f2){
var _7f3=(q instanceof Array)?q:[q];
var _7f4=(s instanceof Array)?s:[s];
for(var i=0;i<_7f4.length;i++){
var _7f5=_7f4[i];
var _7f6=_7f3[i];
var _7f7;
var _7f8;
var _7f9;
if((_7f7=_7f5.indexOf(":"))>-1){
_7f8=_7f5.substring(_7f7+1);
_7f5=_7f5.substring(0,_7f7);
_7f7=_7f8.indexOf("=");
if(_7f7>-1){
_7f9=_7f8.substring(_7f7+1);
_7f8=_7f8.substring(0,_7f7);
}else{
_7f9=_7f8;
}
}
var _7fa=dojo.query(_7f6,_7f2.domNode);
var n=_7fa[0];
if(!n){
n=_7f2.domNode;
}
try{
if(mode=="add"){
if(_7f8){
n.setAttribute(_7f8,_7f9);
}
if(_7f5){
dojo.addClass(n,_7f5);
}
}else{
if(_7f8){
n.removeAttribute(_7f8);
}
if(_7f5){
dojo.removeClass(n,_7f5);
}
}
}
catch(e){
console.error("CSSThemeProvider._simulateState invalid simulate in metadata for "+_7f2.type+" "+q+": "+s);
}
}
},_updateStyle:function(_7fb,_7fc,_7fd,mode){
if(_7fb.id==="all"){
return;
}
var init=false;
if(!_7fd){
_7fd="Normal";
init=true;
}
if(!this._widgets){
return null;
}
if(!_7fc){
_7fc=_7fb.type;
}
var p=_7fc.split(/[\.\/]/);
var w=p[0];
var n=p[p.length-1];
var _7fe=this._widgets[w][n];
if(_7fd==="Normal"&&init==true&&mode==="remove"&&this._widgets[w][n].startState){
_7fd=this._widgets[w][n].startState;
}
if(this._widgets[w][n].states[""+_7fd]){
var q=this._widgets[w][n].states[""+_7fd].query;
if(!q||q=="$auto"){
q=this._createDefaultQuery(w+n,_7fd);
_7fe.states[""+_7fd].query=q;
}
var s=this._widgets[w][n].states[""+_7fd].simulate;
if(!s){
s=" ";
var _7ff=this.getStyleSelectors(_7fc,_7fd);
var _800="";
for(var _801 in _7ff){
_800=_7d0.replace(_801);
_800=_800.replace(/\./g," ");
_800=_800.replace(this._theme.className,"");
s+=" "+_800;
}
if(_7fd!="Normal"){
s=w+_7fd+" "+s;
}
}
if(_7fd!="Normal"){
s+=" "+_7d0.MAQETTA_PSEUDO_CLASS+_7fd;
this._simulateState(q,s,mode,_7fb);
}
}
for(var sub in _7fe.subwidgets){
var _802=_7fe.subwidgets[sub];
if(_7fd==="Normal"&&init==true&&mode==="remove"&&_802.startState){
_7fd=_802.startState;
}
if(_802.states[""+_7fd]){
var q=_802.states[""+_7fd].query;
var s=_802.states[""+_7fd].simulate;
if(!q||q=="$auto"){
q=this._createDefaultQuery(w+sub,_7fd);
_802.states[""+_7fd].query=q;
}
if(!s){
var _7ff=this.getStyleSelectors(_7fc,_7fd,sub);
var _800="";
s=" ";
for(var _801 in _7ff){
_800=_7d0.replace(_801).replace(/\./g," ").replace(this._theme.className,"");
s+=" "+_800;
}
if(_7fd!="Normal"){
s=w+_7fd+" "+s;
}
}
if(_7fd!="Normal"){
this._simulateState(q,s,mode,_7fb);
}
}
}
return;
},setStyleValues:function(node,_803,_804,_805){
this._updateStyle(node,_803,_804,"add");
},removeStyleValues:function(node,_806,_807,_808){
if(_807&&_807!="Normal"){
this._updateStyle(node,_806,_807,"remove");
}
},setWidgetStyleValues:function(node,_809){
var _80a=davinci.ve.widget.getWidget(node);
this._updateStyle(node,null,_809,"add");
},removeWidgetStyleValues:function(node,_80b){
this._updateStyle(node,null,_80b,"remove");
},getDomNode:function(node,_80c,_80d,_80e){
if(!this._widgets){
return null;
}
if(!_80e){
_80e="Normal";
}
var p=_80c.split(/[\.\/]/);
var w=p[0];
var n=p[p.length-1];
var _80f;
try{
if(_80d){
_80f=this._widgets[w][n].subwidgets[""+_80d].states[""+_80e].query;
if(!_80f||_80f=="$auto"){
_80f=this._createDefaultQuery(w+_80d,_80e);
this._widgets[w][n].subwidgets[""+_80d].states[""+_80e].query=_80f;
}
}else{
_80f=this._widgets[w][n].states[""+_80e].query;
if(!_80f||_80f=="$auto"){
_80f=this._createDefaultQuery(w+n,_80e);
this._widgets[w][n].states[""+_80e].query=_80f;
}
}
}
catch(e){
return null;
}
var q;
if(_80f instanceof Array){
q=_80f[0];
}else{
q=_80f;
}
var _810=dojo.query(q,node);
var n=_810[0];
if(!n){
n=node;
}
return n;
},getMetadata:function(_811){
if(!_811){
return undefined;
}
var p=_811.split(/[\.\/]/);
var w=p[0];
var n=p[p.length-1];
var s=this._widgets&&this._widgets[w]&&this._widgets[w][n];
return s;
},getWidgetType:function(_812){
var _813;
_813=_812.type;
var id=_812.id;
if(id.indexOf("all")===0){
_813=_813+".$"+id;
}
return _813;
},isPropertyVaildForWidgetRule:function(rule,_814,_815,_816,_817){
var _818=this.getWidgetType(_815);
var _819=this.getMetadata(_818);
if(_816){
_819=_819.subwidgets[_816];
}
if(_817){
_819=_819.states[_817];
}else{
_819=_819.states["Normal"];
}
var _81a=rule.getSelectorText();
for(var _81b in _819.selectors){
var _81c=_819.selectors[_81b];
if(_81a==_81b){
for(var i=0;i<_81c.length;i++){
var prop=_81c[i];
if(prop=="$std_10"||prop==_814){
return true;
}
}
}
}
return false;
},isPropertyRuleValid:function(rule,_81d,_81e){
var _81f=rule.getSelectorText();
for(var c in _81e.states){
var _820=_81e.states[c];
for(var _821 in _820.selectors){
var _822=_820.selectors[_821];
if(_81f==_821){
for(var i=0;i<_822.length;i++){
var prop=_822[i];
if(prop=="$std_10"||prop==_81d){
return true;
}
}
}
}
}
for(var sw in _81e.subwidgets){
var _823=_81e.subwidgets[sw];
for(var c in _823.states){
var _820=_823.states[c];
for(var _821 in _820.selectors){
var _822=_820.selectors[_821];
if(_81f==_821){
for(var i=0;i<_822.length;i++){
var prop=_822[i];
if(prop=="$std_10"||prop==_81d){
return true;
}
}
}
}
}
}
return false;
function _824(rule,_825){
for(var i=0;i<rule.selectors.length;i++){
var _826=rule.selectors[i].getText();
if(_826==_825){
return true;
}
}
return false;
};
},isPropertyValidForRule:function(rule,_827){
var ret=false;
var _828=rule.getSelectorText();
for(var a in this._widgets){
var _829=this._widgets[a];
for(var b in _829){
var _82a=_829[b];
if(this.isPropertyRuleValid(rule,_827,_82a)){
return true;
}
}
}
return ret;
},getStatesForAllWidgets:function(){
if(!this._widgets){
return null;
}
states=[];
for(var a in this._widgets){
var _82b=this._widgets[a];
for(var b in _82b){
if(b.indexOf("$all")!=0){
var _82c=_82b[b];
for(var c in _82c.states){
states[c]=c;
}
for(var sw in _82c.subwidgets){
var _82d=_82c.subwidgets[sw];
for(var c in _82d.states){
states[c]=c;
}
}
}
}
}
retStates=[];
for(var s in states){
retStates.push(s);
}
return retStates.sort();
},isStateValid:function(_82e,_82f,subW){
if(!this._widgets){
return false;
}
if(_82e.id==="all"&&_82f!="Normal"){
return false;
}
var _830=_82e.type;
var _831=this.getMetadata(_830);
if(_831.states[_82f]&&!subW){
return true;
}
if(!subW){
for(var sw in _831.subwidgets){
var _832=_831.subwidgets[sw];
if(_832.states[_82f]){
return true;
}
}
}else{
var _832=_831.subwidgets[subW];
if(_832&&_832.states[_82f]){
return true;
}
}
return false;
}});
});
},"davinci/de/resource":function(){
define(["davinci/de/widgets/NewDijit","davinci/Workbench","davinci/workbench/Preferences","system/resource","davinci/de/DijitTemplatedGenerator","davinci/library","davinci/ui/Dialog","davinci/ve/actions/ReplaceAction","dojo/promise/all"],function(_833,_834,_835,_836,_837,_838,_839,_83a,all){
var dt={WIDGETS_JSON:{version:"1.0",localPath:true,customWidgetSpec:1,"categories":{"custom":{name:"Custom widget",description:"Custom widget",widgetClass:"dijit"}},widgets:[]},createDijiFromNewDialog:function(){
var _83b=new _833({});
var _83c=_834.getOpenEditor();
var _83d=_83c.fileName;
var _83e=_836.findResource(_83d);
var _83f=_83c.model;
var _840=_834.getOpenEditor();
var _841=_840.getContext();
var _842=_841.getSelection();
if(!dt.validWidget(_842)){
_839.showModal("Invalid Selection.  Please select a single container widget to create a new Widget","Error creating Widget...");
return;
}
_834.showModal(_83b,"Dijit Widget...",{height:60,width:250},function(){
if(!_83b.cancel){
var _843=_83b.attr("value");
dt.createDijit(_843,_83f,_83e,_841,_842).then(function(){
if(_843.replaceSelection){
new _83a().run(_841,_843.group+"."+_843.name);
}
window.location.reload(false);
});
}
return true;
});
},validWidget:function(_844){
if(_844==null||_844.length!=1){
return false;
}
var _845=_844[0];
return (_845.acceptsHTMLChildren);
},_createNameSpace:function(name,_846){
var _847=name.split(".");
var base=_834.getProject();
_846=_846||_836.findResource(base);
if(_847.length>1){
for(var i=0;i<_847.length-1;i++){
var _848=_846.getChildSync(_847[i]);
if(_848!=null){
_846=_848;
}else{
_846=_846.createResource(_847[i],true);
}
}
}
return _846;
},_createFolder:function(name,_849){
var _84a=name.split("/");
var base=_834.getProject();
_849=_849||_836.findResource(base);
if(_84a.length){
for(var i=0;i<_84a.length;i++){
if(_84a[i]=="."){
continue;
}
var _84b=_849.getChildSync(_84a[i]);
if(_84b!=null){
_849=_84b;
}else{
_849=_849.createResource(_84a[i],true);
}
}
}
return _849;
},createDijit:function(_84c,_84d,_84e,_84f,_850){
var _851=_84c.name+"."+_84c.name;
var _852=_84c.name+"/"+_84c.name;
var base=_834.getProject();
var _853=_835.getPreferences("davinci.ui.ProjectPrefs",base);
if(!_853.widgetFolder){
_853.widgetFolder="WebContent/custom";
_835.savePreferences("davinci.ui.ProjectPrefs",base,_853);
}
var _854=dt._createFolder(_853.widgetFolder);
var _855=dt._createNameSpace(_851,_854);
var _856=_855.getChildSync(_84c.name+"_widgets.json");
if(_856==null){
_856=_855.createResource(_84c.name+"_widgets.json");
}
var _857=dojo.clone(dt.WIDGETS_JSON);
_857.name=_84c.name;
_857.longName=_84c.name;
var _858={name:_84c.name,description:_84c.name,type:_852,category:"custom",iconLocal:true,icon:"app/davinci/img/maqetta.png"};
var _859=_850[0]._srcElement;
for(var i=0,atts=_859.attributes,len=atts.length;i<len;i++){
var att=atts[i];
if(!att.noPersist){
if(!_858.properties){
_858.properties={};
}
_858.properties[att.name]=att.value;
}
}
_857.widgets.push(_858);
var _85a=[_856.setContents(JSON.stringify(_857,undefined,"\t"))];
var _85b=new _837({}).buildSource(_84d,_852,_84c.name,false,_84f,_850);
for(var type in _85b){
switch(type){
case "amd":
break;
case "html":
var html=_855.createResource(_84c.name+".html");
_85a.push(html.setContents(_85b.html));
break;
case "js":
var _85c=_855.createResource(_84c.name+".js");
_85a.push(_85c.setContents(_85b.js));
break;
case "metadata":
var _85d=_855.createResource(_84c.name+"_oam.json");
_85a.push(_85d.setContents(_85b.metadata));
_838.addCustomWidgets(base,_856,_855.getPath(),_857);
break;
}
}
return all(_85a);
}};
return dt;
});
},"davinci/ve/themeEditor/metadata/query":function(){
define(["dojo/_base/declare","davinci/ve/utils/URLRewrite"],function(_85e,_85f){
return _85e("davinci.ve.themeEditor.metadata.query",null,{constructor:function(_860,_861){
this.files=_860;
this.cache={};
this.lastLoaded=-1;
this.modules=_861;
this.modulePrefix=null;
this.modulePrefix=".";
if(_861){
for(var i=0;i<_861.length;i++){
this.modulePrefix+="/"+_861[i];
}
}
},getType:function(_862){
var type=null;
if(_862.declaredClass){
type=_862.type;
}else{
type=_862;
if(type.substring(0,5)=="html."){
tagName=type.substring(5);
}
}
return type;
},_loadNextFile:function(){
var _863=this.files[++this.lastLoaded];
var _864=null;
if(_863.getURL){
_864=_85f.encodeURI(_863.getURL());
}else{
_864=this.modulePrefix+_863;
}
var md=null;
dojo.xhrGet({url:_864,handleAs:"json",sync:true,load:function(_865){
md=_865;
}});
return md;
},_fullyLoaded:function(){
return this.files.length<=(this.lastLoaded+1);
},_cacheNext:function(){
var _866=this._loadNextFile();
dojo.mixin(this.cache,_866);
},getMetaData:function(type){
var path=type.split(/[\.\/]/);
var _867=path.length>=0?path[0]:path;
var back=path.length>=0?path[path.length-1]:path;
var _868=this.cache[_867];
if(_868&&_868[back]){
return _868[back];
}
if(!this._fullyLoaded()){
this._cacheNext();
return this.getMetaData(type);
}
return null;
}});
});
},"dojo/dnd/autoscroll":function(){
define(["../_base/lang","../sniff","../_base/window","../dom-geometry","../dom-style","../window"],function(lang,has,win,_869,_86a,_86b){
var _86c={};
lang.setObject("dojo.dnd.autoscroll",_86c);
_86c.getViewport=_86b.getBox;
_86c.V_TRIGGER_AUTOSCROLL=32;
_86c.H_TRIGGER_AUTOSCROLL=32;
_86c.V_AUTOSCROLL_VALUE=16;
_86c.H_AUTOSCROLL_VALUE=16;
var _86d,doc=win.doc,_86e=Infinity,_86f=Infinity;
_86c.autoScrollStart=function(d){
doc=d;
_86d=_86b.getBox(doc);
var html=win.body(doc).parentNode;
_86e=Math.max(html.scrollHeight-_86d.h,0);
_86f=Math.max(html.scrollWidth-_86d.w,0);
};
_86c.autoScroll=function(e){
var v=_86d||_86b.getBox(doc),html=win.body(doc).parentNode,dx=0,dy=0;
if(e.clientX<_86c.H_TRIGGER_AUTOSCROLL){
dx=-_86c.H_AUTOSCROLL_VALUE;
}else{
if(e.clientX>v.w-_86c.H_TRIGGER_AUTOSCROLL){
dx=Math.min(_86c.H_AUTOSCROLL_VALUE,_86f-html.scrollLeft);
}
}
if(e.clientY<_86c.V_TRIGGER_AUTOSCROLL){
dy=-_86c.V_AUTOSCROLL_VALUE;
}else{
if(e.clientY>v.h-_86c.V_TRIGGER_AUTOSCROLL){
dy=Math.min(_86c.V_AUTOSCROLL_VALUE,_86e-html.scrollTop);
}
}
window.scrollBy(dx,dy);
};
_86c._validNodes={"div":1,"p":1,"td":1};
_86c._validOverflow={"auto":1,"scroll":1};
_86c.autoScrollNodes=function(e){
var b,t,w,h,rx,ry,dx=0,dy=0,_870,_871;
for(var n=e.target;n;){
if(n.nodeType==1&&(n.tagName.toLowerCase() in _86c._validNodes)){
var s=_86a.getComputedStyle(n),_872=(s.overflow.toLowerCase() in _86c._validOverflow),_873=(s.overflowX.toLowerCase() in _86c._validOverflow),_874=(s.overflowY.toLowerCase() in _86c._validOverflow);
if(_872||_873||_874){
b=_869.getContentBox(n,s);
t=_869.position(n,true);
}
if(_872||_873){
w=Math.min(_86c.H_TRIGGER_AUTOSCROLL,b.w/2);
rx=e.pageX-t.x;
if(has("webkit")||has("opera")){
rx+=win.body().scrollLeft;
}
dx=0;
if(rx>0&&rx<b.w){
if(rx<w){
dx=-w;
}else{
if(rx>b.w-w){
dx=w;
}
}
_870=n.scrollLeft;
n.scrollLeft=n.scrollLeft+dx;
}
}
if(_872||_874){
h=Math.min(_86c.V_TRIGGER_AUTOSCROLL,b.h/2);
ry=e.pageY-t.y;
if(has("webkit")||has("opera")){
ry+=win.body().scrollTop;
}
dy=0;
if(ry>0&&ry<b.h){
if(ry<h){
dy=-h;
}else{
if(ry>b.h-h){
dy=h;
}
}
_871=n.scrollTop;
n.scrollTop=n.scrollTop+dy;
}
}
if(dx||dy){
return;
}
}
try{
n=n.parentNode;
}
catch(x){
n=null;
}
}
_86c.autoScroll(e);
};
return _86c;
});
},"dijit/form/_RadioButtonMixin":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/_base/event","dojo/_base/lang","dojo/query","../registry"],function(_875,_876,_877,_878,lang,_879,_87a){
return _876("dijit.form._RadioButtonMixin",null,{type:"radio",_getRelatedWidgets:function(){
var ary=[];
_879("input[type=radio]",this.focusNode.form||this.ownerDocument).forEach(lang.hitch(this,function(_87b){
if(_87b.name==this.name&&_87b.form==this.focusNode.form){
var _87c=_87a.getEnclosingWidget(_87b);
if(_87c){
ary.push(_87c);
}
}
}));
return ary;
},_setCheckedAttr:function(_87d){
this.inherited(arguments);
if(!this._created){
return;
}
if(_87d){
_875.forEach(this._getRelatedWidgets(),lang.hitch(this,function(_87e){
if(_87e!=this&&_87e.checked){
_87e.set("checked",false);
}
}));
}
},_getSubmitValue:function(_87f){
return _87f===null?"on":_87f;
},_onClick:function(e){
if(this.checked||this.disabled){
_878.stop(e);
return false;
}
if(this.readOnly){
_878.stop(e);
_875.forEach(this._getRelatedWidgets(),lang.hitch(this,function(_880){
_877.set(this.focusNode||this.domNode,"checked",_880.checked);
}));
return false;
}
return this.inherited(arguments);
}});
});
},"dojo/data/ItemFileWriteStore":function(){
define(["../_base/lang","../_base/declare","../_base/array","../_base/json","../_base/kernel","./ItemFileReadStore","../date/stamp"],function(lang,_881,_882,_883,_884,_885,_886){
return _881("dojo.data.ItemFileWriteStore",_885,{constructor:function(_887){
this._features["dojo.data.api.Write"]=true;
this._features["dojo.data.api.Notification"]=true;
this._pending={_newItems:{},_modifiedItems:{},_deletedItems:{}};
if(!this._datatypeMap["Date"].serialize){
this._datatypeMap["Date"].serialize=function(obj){
return _886.toISOString(obj,{zulu:true});
};
}
if(_887&&(_887.referenceIntegrity===false)){
this.referenceIntegrity=false;
}
this._saveInProgress=false;
},referenceIntegrity:true,_assert:function(_888){
if(!_888){
throw new Error("assertion failed in ItemFileWriteStore");
}
},_getIdentifierAttribute:function(){
return this.getFeatures()["dojo.data.api.Identity"];
},newItem:function(_889,_88a){
this._assert(!this._saveInProgress);
if(!this._loadFinished){
this._forceLoad();
}
if(typeof _889!="object"&&typeof _889!="undefined"){
throw new Error("newItem() was passed something other than an object");
}
var _88b=null;
var _88c=this._getIdentifierAttribute();
if(_88c===Number){
_88b=this._arrayOfAllItems.length;
}else{
_88b=_889[_88c];
if(typeof _88b==="undefined"){
throw new Error("newItem() was not passed an identity for the new item");
}
if(lang.isArray(_88b)){
throw new Error("newItem() was not passed an single-valued identity");
}
}
if(this._itemsByIdentity){
this._assert(typeof this._itemsByIdentity[_88b]==="undefined");
}
this._assert(typeof this._pending._newItems[_88b]==="undefined");
this._assert(typeof this._pending._deletedItems[_88b]==="undefined");
var _88d={};
_88d[this._storeRefPropName]=this;
_88d[this._itemNumPropName]=this._arrayOfAllItems.length;
if(this._itemsByIdentity){
this._itemsByIdentity[_88b]=_88d;
_88d[_88c]=[_88b];
}
this._arrayOfAllItems.push(_88d);
var _88e=null;
if(_88a&&_88a.parent&&_88a.attribute){
_88e={item:_88a.parent,attribute:_88a.attribute,oldValue:undefined};
var _88f=this.getValues(_88a.parent,_88a.attribute);
if(_88f&&_88f.length>0){
var _890=_88f.slice(0,_88f.length);
if(_88f.length===1){
_88e.oldValue=_88f[0];
}else{
_88e.oldValue=_88f.slice(0,_88f.length);
}
_890.push(_88d);
this._setValueOrValues(_88a.parent,_88a.attribute,_890,false);
_88e.newValue=this.getValues(_88a.parent,_88a.attribute);
}else{
this._setValueOrValues(_88a.parent,_88a.attribute,_88d,false);
_88e.newValue=_88d;
}
}else{
_88d[this._rootItemPropName]=true;
this._arrayOfTopLevelItems.push(_88d);
}
this._pending._newItems[_88b]=_88d;
for(var key in _889){
if(key===this._storeRefPropName||key===this._itemNumPropName){
throw new Error("encountered bug in ItemFileWriteStore.newItem");
}
var _891=_889[key];
if(!lang.isArray(_891)){
_891=[_891];
}
_88d[key]=_891;
if(this.referenceIntegrity){
for(var i=0;i<_891.length;i++){
var val=_891[i];
if(this.isItem(val)){
this._addReferenceToMap(val,_88d,key);
}
}
}
}
this.onNew(_88d,_88e);
return _88d;
},_removeArrayElement:function(_892,_893){
var _894=_882.indexOf(_892,_893);
if(_894!=-1){
_892.splice(_894,1);
return true;
}
return false;
},deleteItem:function(item){
this._assert(!this._saveInProgress);
this._assertIsItem(item);
var _895=item[this._itemNumPropName];
var _896=this.getIdentity(item);
if(this.referenceIntegrity){
var _897=this.getAttributes(item);
if(item[this._reverseRefMap]){
item["backup_"+this._reverseRefMap]=lang.clone(item[this._reverseRefMap]);
}
_882.forEach(_897,function(_898){
_882.forEach(this.getValues(item,_898),function(_899){
if(this.isItem(_899)){
if(!item["backupRefs_"+this._reverseRefMap]){
item["backupRefs_"+this._reverseRefMap]=[];
}
item["backupRefs_"+this._reverseRefMap].push({id:this.getIdentity(_899),attr:_898});
this._removeReferenceFromMap(_899,item,_898);
}
},this);
},this);
var _89a=item[this._reverseRefMap];
if(_89a){
for(var _89b in _89a){
var _89c=null;
if(this._itemsByIdentity){
_89c=this._itemsByIdentity[_89b];
}else{
_89c=this._arrayOfAllItems[_89b];
}
if(_89c){
for(var _89d in _89a[_89b]){
var _89e=this.getValues(_89c,_89d)||[];
var _89f=_882.filter(_89e,function(_8a0){
return !(this.isItem(_8a0)&&this.getIdentity(_8a0)==_896);
},this);
this._removeReferenceFromMap(item,_89c,_89d);
if(_89f.length<_89e.length){
this._setValueOrValues(_89c,_89d,_89f,true);
}
}
}
}
}
}
this._arrayOfAllItems[_895]=null;
item[this._storeRefPropName]=null;
if(this._itemsByIdentity){
delete this._itemsByIdentity[_896];
}
this._pending._deletedItems[_896]=item;
if(item[this._rootItemPropName]){
this._removeArrayElement(this._arrayOfTopLevelItems,item);
}
this.onDelete(item);
return true;
},setValue:function(item,_8a1,_8a2){
return this._setValueOrValues(item,_8a1,_8a2,true);
},setValues:function(item,_8a3,_8a4){
return this._setValueOrValues(item,_8a3,_8a4,true);
},unsetAttribute:function(item,_8a5){
return this._setValueOrValues(item,_8a5,[],true);
},_setValueOrValues:function(item,_8a6,_8a7,_8a8){
this._assert(!this._saveInProgress);
this._assertIsItem(item);
this._assert(lang.isString(_8a6));
this._assert(typeof _8a7!=="undefined");
var _8a9=this._getIdentifierAttribute();
if(_8a6==_8a9){
throw new Error("ItemFileWriteStore does not have support for changing the value of an item's identifier.");
}
var _8aa=this._getValueOrValues(item,_8a6);
var _8ab=this.getIdentity(item);
if(!this._pending._modifiedItems[_8ab]){
var _8ac={};
for(var key in item){
if((key===this._storeRefPropName)||(key===this._itemNumPropName)||(key===this._rootItemPropName)){
_8ac[key]=item[key];
}else{
if(key===this._reverseRefMap){
_8ac[key]=lang.clone(item[key]);
}else{
_8ac[key]=item[key].slice(0,item[key].length);
}
}
}
this._pending._modifiedItems[_8ab]=_8ac;
}
var _8ad=false;
if(lang.isArray(_8a7)&&_8a7.length===0){
_8ad=delete item[_8a6];
_8a7=undefined;
if(this.referenceIntegrity&&_8aa){
var _8ae=_8aa;
if(!lang.isArray(_8ae)){
_8ae=[_8ae];
}
for(var i=0;i<_8ae.length;i++){
var _8af=_8ae[i];
if(this.isItem(_8af)){
this._removeReferenceFromMap(_8af,item,_8a6);
}
}
}
}else{
var _8b0;
if(lang.isArray(_8a7)){
_8b0=_8a7.slice(0,_8a7.length);
}else{
_8b0=[_8a7];
}
if(this.referenceIntegrity){
if(_8aa){
var _8ae=_8aa;
if(!lang.isArray(_8ae)){
_8ae=[_8ae];
}
var map={};
_882.forEach(_8ae,function(_8b1){
if(this.isItem(_8b1)){
var id=this.getIdentity(_8b1);
map[id.toString()]=true;
}
},this);
_882.forEach(_8b0,function(_8b2){
if(this.isItem(_8b2)){
var id=this.getIdentity(_8b2);
if(map[id.toString()]){
delete map[id.toString()];
}else{
this._addReferenceToMap(_8b2,item,_8a6);
}
}
},this);
for(var rId in map){
var _8b3;
if(this._itemsByIdentity){
_8b3=this._itemsByIdentity[rId];
}else{
_8b3=this._arrayOfAllItems[rId];
}
this._removeReferenceFromMap(_8b3,item,_8a6);
}
}else{
for(var i=0;i<_8b0.length;i++){
var _8af=_8b0[i];
if(this.isItem(_8af)){
this._addReferenceToMap(_8af,item,_8a6);
}
}
}
}
item[_8a6]=_8b0;
_8ad=true;
}
if(_8a8){
this.onSet(item,_8a6,_8aa,_8a7);
}
return _8ad;
},_addReferenceToMap:function(_8b4,_8b5,_8b6){
var _8b7=this.getIdentity(_8b5);
var _8b8=_8b4[this._reverseRefMap];
if(!_8b8){
_8b8=_8b4[this._reverseRefMap]={};
}
var _8b9=_8b8[_8b7];
if(!_8b9){
_8b9=_8b8[_8b7]={};
}
_8b9[_8b6]=true;
},_removeReferenceFromMap:function(_8ba,_8bb,_8bc){
var _8bd=this.getIdentity(_8bb);
var _8be=_8ba[this._reverseRefMap];
var _8bf;
if(_8be){
for(_8bf in _8be){
if(_8bf==_8bd){
delete _8be[_8bf][_8bc];
if(this._isEmpty(_8be[_8bf])){
delete _8be[_8bf];
}
}
}
if(this._isEmpty(_8be)){
delete _8ba[this._reverseRefMap];
}
}
},_dumpReferenceMap:function(){
var i;
for(i=0;i<this._arrayOfAllItems.length;i++){
var item=this._arrayOfAllItems[i];
if(item&&item[this._reverseRefMap]){
}
}
},_getValueOrValues:function(item,_8c0){
var _8c1=undefined;
if(this.hasAttribute(item,_8c0)){
var _8c2=this.getValues(item,_8c0);
if(_8c2.length==1){
_8c1=_8c2[0];
}else{
_8c1=_8c2;
}
}
return _8c1;
},_flatten:function(_8c3){
if(this.isItem(_8c3)){
return {_reference:this.getIdentity(_8c3)};
}else{
if(typeof _8c3==="object"){
for(var type in this._datatypeMap){
var _8c4=this._datatypeMap[type];
if(lang.isObject(_8c4)&&!lang.isFunction(_8c4)){
if(_8c3 instanceof _8c4.type){
if(!_8c4.serialize){
throw new Error("ItemFileWriteStore:  No serializer defined for type mapping: ["+type+"]");
}
return {_type:type,_value:_8c4.serialize(_8c3)};
}
}else{
if(_8c3 instanceof _8c4){
return {_type:type,_value:_8c3.toString()};
}
}
}
}
return _8c3;
}
},_getNewFileContentString:function(){
var _8c5={};
var _8c6=this._getIdentifierAttribute();
if(_8c6!==Number){
_8c5.identifier=_8c6;
}
if(this._labelAttr){
_8c5.label=this._labelAttr;
}
_8c5.items=[];
for(var i=0;i<this._arrayOfAllItems.length;++i){
var item=this._arrayOfAllItems[i];
if(item!==null){
var _8c7={};
for(var key in item){
if(key!==this._storeRefPropName&&key!==this._itemNumPropName&&key!==this._reverseRefMap&&key!==this._rootItemPropName){
var _8c8=this.getValues(item,key);
if(_8c8.length==1){
_8c7[key]=this._flatten(_8c8[0]);
}else{
var _8c9=[];
for(var j=0;j<_8c8.length;++j){
_8c9.push(this._flatten(_8c8[j]));
_8c7[key]=_8c9;
}
}
}
}
_8c5.items.push(_8c7);
}
}
var _8ca=true;
return _883.toJson(_8c5,_8ca);
},_isEmpty:function(_8cb){
var _8cc=true;
if(lang.isObject(_8cb)){
var i;
for(i in _8cb){
_8cc=false;
break;
}
}else{
if(lang.isArray(_8cb)){
if(_8cb.length>0){
_8cc=false;
}
}
}
return _8cc;
},save:function(_8cd){
this._assert(!this._saveInProgress);
this._saveInProgress=true;
var self=this;
var _8ce=function(){
self._pending={_newItems:{},_modifiedItems:{},_deletedItems:{}};
self._saveInProgress=false;
if(_8cd&&_8cd.onComplete){
var _8cf=_8cd.scope||_884.global;
_8cd.onComplete.call(_8cf);
}
};
var _8d0=function(err){
self._saveInProgress=false;
if(_8cd&&_8cd.onError){
var _8d1=_8cd.scope||_884.global;
_8cd.onError.call(_8d1,err);
}
};
if(this._saveEverything){
var _8d2=this._getNewFileContentString();
this._saveEverything(_8ce,_8d0,_8d2);
}
if(this._saveCustom){
this._saveCustom(_8ce,_8d0);
}
if(!this._saveEverything&&!this._saveCustom){
_8ce();
}
},revert:function(){
this._assert(!this._saveInProgress);
var _8d3;
for(_8d3 in this._pending._modifiedItems){
var _8d4=this._pending._modifiedItems[_8d3];
var _8d5=null;
if(this._itemsByIdentity){
_8d5=this._itemsByIdentity[_8d3];
}else{
_8d5=this._arrayOfAllItems[_8d3];
}
_8d4[this._storeRefPropName]=this;
for(var key in _8d5){
delete _8d5[key];
}
lang.mixin(_8d5,_8d4);
}
var _8d6;
for(_8d3 in this._pending._deletedItems){
_8d6=this._pending._deletedItems[_8d3];
_8d6[this._storeRefPropName]=this;
var _8d7=_8d6[this._itemNumPropName];
if(_8d6["backup_"+this._reverseRefMap]){
_8d6[this._reverseRefMap]=_8d6["backup_"+this._reverseRefMap];
delete _8d6["backup_"+this._reverseRefMap];
}
this._arrayOfAllItems[_8d7]=_8d6;
if(this._itemsByIdentity){
this._itemsByIdentity[_8d3]=_8d6;
}
if(_8d6[this._rootItemPropName]){
this._arrayOfTopLevelItems.push(_8d6);
}
}
for(_8d3 in this._pending._deletedItems){
_8d6=this._pending._deletedItems[_8d3];
if(_8d6["backupRefs_"+this._reverseRefMap]){
_882.forEach(_8d6["backupRefs_"+this._reverseRefMap],function(_8d8){
var _8d9;
if(this._itemsByIdentity){
_8d9=this._itemsByIdentity[_8d8.id];
}else{
_8d9=this._arrayOfAllItems[_8d8.id];
}
this._addReferenceToMap(_8d9,_8d6,_8d8.attr);
},this);
delete _8d6["backupRefs_"+this._reverseRefMap];
}
}
for(_8d3 in this._pending._newItems){
var _8da=this._pending._newItems[_8d3];
_8da[this._storeRefPropName]=null;
this._arrayOfAllItems[_8da[this._itemNumPropName]]=null;
if(_8da[this._rootItemPropName]){
this._removeArrayElement(this._arrayOfTopLevelItems,_8da);
}
if(this._itemsByIdentity){
delete this._itemsByIdentity[_8d3];
}
}
this._pending={_newItems:{},_modifiedItems:{},_deletedItems:{}};
return true;
},isDirty:function(item){
if(item){
var _8db=this.getIdentity(item);
return new Boolean(this._pending._newItems[_8db]||this._pending._modifiedItems[_8db]||this._pending._deletedItems[_8db]).valueOf();
}else{
return !this._isEmpty(this._pending._newItems)||!this._isEmpty(this._pending._modifiedItems)||!this._isEmpty(this._pending._deletedItems);
}
},onSet:function(item,_8dc,_8dd,_8de){
},onNew:function(_8df,_8e0){
},onDelete:function(_8e1){
},close:function(_8e2){
if(this.clearOnClose){
if(!this.isDirty()){
this.inherited(arguments);
}else{
throw new Error("dojo.data.ItemFileWriteStore: There are unsaved changes present in the store.  Please save or revert the changes before invoking close.");
}
}
}});
});
},"url:dijit/templates/TreeNode.html":"<div class=\"dijitTreeNode\" role=\"presentation\"\n\t><div data-dojo-attach-point=\"rowNode\" class=\"dijitTreeRow dijitInline\" role=\"presentation\"\n\t\t><div data-dojo-attach-point=\"indentNode\" class=\"dijitInline\"></div\n\t\t><img src=\"${_blankGif}\" alt=\"\" data-dojo-attach-point=\"expandoNode\" class=\"dijitTreeExpando\" role=\"presentation\"\n\t\t/><span data-dojo-attach-point=\"expandoNodeText\" class=\"dijitExpandoText\" role=\"presentation\"\n\t\t></span\n\t\t><span data-dojo-attach-point=\"contentNode\"\n\t\t\tclass=\"dijitTreeContent\" role=\"presentation\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" data-dojo-attach-point=\"iconNode\" class=\"dijitIcon dijitTreeIcon\" role=\"presentation\"\n\t\t\t/><span data-dojo-attach-point=\"labelNode\" class=\"dijitTreeLabel\" role=\"treeitem\" tabindex=\"-1\" aria-selected=\"false\"></span>\n\t\t</span\n\t></div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitTreeContainer\" role=\"presentation\" style=\"display: none;\"></div>\n</div>\n","davinci/ve/commands/MoveCommand":function(){
define(["dojo/_base/declare","dojo/dom-geometry","davinci/ve/widget","davinci/ve/States","davinci/ve/utils/StyleArray","davinci/ve/utils/GeomUtils"],function(_8e3,_8e4,_8e5,_8e6,_8e7,_8e8){
return _8e3("davinci.ve.commands.MoveCommand",null,{name:"move",constructor:function(_8e9,left,top,_8ea,_8eb,_8ec,_8ed){
this._id=(_8e9?_8e9.id:undefined);
this._context=_8e9.getContext();
this._newBox={l:left,t:top};
this._commandForXYDeltas=_8ea;
this._oldBox=_8eb;
this._applyToStateIndex=(!_8ec||_8ec=="Normal"||_8ec=="undefined")?"undefined":_8ec;
this._disableSnapping=_8ed;
},execute:function(){
if(!this._id){
return;
}
var _8ee=_8e5.byId(this._id);
if(!_8ee||!_8ee.domNode){
return;
}
var _8ef=this._context;
if(!this._oldBox){
var box=_8ee.getMarginBox();
this._oldBox={l:box.l,t:box.t,w:box.w,h:box.h};
}
if(!_8ee.domNode.offsetParent){
return;
}
var _8f0=dojo.position(_8ee.domNode.offsetParent,true);
if(!_8f0){
return;
}
if(this._commandForXYDeltas){
this._newBox.l=this._oldBox.l+this._commandForXYDeltas._deltaX;
this._newBox.t=this._oldBox.t+this._commandForXYDeltas._deltaY;
}else{
if(!this._disableSnapping&&_8ef&&_8ef._snapX){
var w=this._oldBox.w;
if(_8ef._snapX.typeRefObj=="left"){
this._newBox.l=_8ef._snapX.x;
}else{
if(w&&_8ef._snapX.typeRefObj=="right"){
this._newBox.l=_8ef._snapX.x-w;
}else{
if(w&&_8ef._snapX.typeRefObj=="center"){
this._newBox.l=_8ef._snapX.x-w/2;
}
}
}
}
if(!this._disableSnapping&&_8ef&&_8ef._snapY){
var h=this._oldBox.h;
if(_8ef._snapY.typeRefObj=="top"){
this._newBox.t=_8ef._snapY.y;
}else{
if(h&&_8ef._snapY.typeRefObj=="bottom"){
this._newBox.t=_8ef._snapY.y-h;
}else{
if(h&&_8ef._snapY.typeRefObj=="middle"){
this._newBox.t=_8ef._snapY.y-h/2;
}
}
}
}
}
this._deltaX=this._newBox.l-this._oldBox.l;
this._deltaY=this._newBox.t-this._oldBox.t;
var _8f1=_8e8.getBorderBoxPageCoords(_8ee.domNode.offsetParent);
var _8f2=_8e4.getBorderExtents(_8ee.domNode.offsetParent);
var _8f3=this._newBox.l-_8f1.l-_8f2.l;
var _8f4=this._newBox.t-_8f1.t-_8f2.t;
var _8f5=[{left:_8f3+"px"},{top:_8f4+"px"}];
var _8f6=_8ee.getStyleValuesAllStates();
this._oldStyleValuesAllStates=dojo.clone(_8f6);
if(this._oldBox){
var _8f7=this._oldBox.l-_8f1.l-_8f2.l;
var _8f8=this._oldBox.t-_8f1.t-_8f2.t;
this._oldStyleValuesAllStates[this._applyToStateIndex]=_8e7.mergeStyleArrays(this._oldStyleValuesAllStates[this._applyToStateIndex],[{left:_8f7+"px"},{top:_8f8+"px"}]);
}
if(_8f6[this._applyToStateIndex]){
_8f6[this._applyToStateIndex]=_8e7.mergeStyleArrays(_8f6[this._applyToStateIndex],_8f5);
}else{
_8f6[this._applyToStateIndex]=_8f5;
}
_8ee.setStyleValuesAllStates(_8f6);
var _8f9=_8e6.getStatesListCurrent(_8ee.domNode);
var _8fa=_8e7.mergeStyleArrays([],_8f6["undefined"]);
for(var i=0;i<_8f9.length;i++){
if(_8f6[_8f9[i]]){
_8fa=_8e7.mergeStyleArrays(_8fa,_8f6[_8f9[i]]);
}
}
_8ee.setStyleValuesCanvas(_8fa);
_8ee.setStyleValuesModel(_8f6["undefined"]);
_8ee.refresh();
_8e6.resetState(_8ee.domNode);
dojo.publish("/davinci/ui/widgetPropertiesChanged",[[_8ee]]);
},undo:function(){
if(!this._id){
return;
}
var _8fb=_8e5.byId(this._id);
if(!_8fb){
return;
}
var _8fc=this._oldStyleValuesAllStates;
var _8fd=this._applyToStateIndex;
_8fb.setStyleValuesAllStates(_8fc);
var _8fe=_8e7.mergeStyleArrays(_8fc["undefined"],_8fc[_8fd]);
_8fb.setStyleValuesCanvas(_8fe);
_8fb.setStyleValuesModel(this._oldStyleValuesAllStates["undefined"]);
_8fb.refresh();
davinci.ve.states.resetState(_8fb.domNode);
dojo.publish("/davinci/ui/widgetPropertiesChanged",[[_8fb]]);
}});
});
},"dojo/dnd/TimedMoveable":function(){
define(["../_base/declare","./Moveable"],function(_8ff,_900){
var _901=_900.prototype.onMove;
return _8ff("dojo.dnd.TimedMoveable",_900,{timeout:40,constructor:function(node,_902){
if(!_902){
_902={};
}
if(_902.timeout&&typeof _902.timeout=="number"&&_902.timeout>=0){
this.timeout=_902.timeout;
}
},onMoveStop:function(_903){
if(_903._timer){
clearTimeout(_903._timer);
_901.call(this,_903,_903._leftTop);
}
_900.prototype.onMoveStop.apply(this,arguments);
},onMove:function(_904,_905){
_904._leftTop=_905;
if(!_904._timer){
var _906=this;
_904._timer=setTimeout(function(){
_904._timer=null;
_901.call(_906,_904,_904._leftTop);
},this.timeout);
}
}});
});
},"davinci/ve/themeEditor/themeEditor.plugin":function(){
define(["require"],function(_907){
return {id:"davinci.themeEdit","davinci.perspective":{id:"themeEdit",title:"Theme Editor",views:[{viewID:"davinci.ve.Palette",position:"left",hidden:true},{viewID:"davinci.ui.outline",position:"left",hidden:true},{viewID:"davinci.ve.style",position:"right"},{viewID:"davinci.ui.comment",position:"right",hidden:true},{viewID:"davinci.ve.states",position:"right-bottom",selected:true},{viewID:"davinci.ui.navigator",position:"left-bottom",selected:true},{viewID:"davinci.review.reviewNavigator",position:"left"}]},"davinci.editor":{id:"ThemeEditor",name:"Theme Editor",extensions:"theme",defaultContent:"./defaultContent.css",isDefault:true,editorClass:"davinci/ve/themeEditor/ThemeEditor",palettePerspective:"davinci.themeEdit.themeEdit",expandPalettes:["right"]},"davinci.editorActions":{editorContribution:{targetID:"davinci.ve.ThemeEditor",actions:[{id:"undo",action:"davinci/actions/UndoAction",label:"Undo",className:"maqLabelButton",showLabel:true,toolbarPath:"undoredo",keyBinding:{accel:true,charOrCode:"z"}},{id:"redo",action:"davinci/actions/RedoAction",className:"maqLabelButton",showLabel:true,label:"Redo",toolbarPath:"undoredo",keyBinding:{accel:true,shift:true,charOrCode:"z"}},{id:"save",className:"maqLabelButton",showLabel:true,label:"Save",toolbarPath:"save",run:function(){
_907("../../Workbench").getOpenEditor().save();
},isEnabled:function(_908){
return _907("../../Workbench").getOpenEditor();
}}]}}};
});
},"davinci/ve/input/SmartInput":function(){
define(["dojo/_base/declare","dojo/dom-geometry","davinci/ve/commands/ModifyRichTextCommand","dijit/layout/ContentPane","dijit/form/SimpleTextarea","dijit/form/TextBox","dojox/html/entities","dojox/html/ellipsis","dojox/layout/ResizeHandle","dojo/i18n!davinci/ve/nls/ve","dojo/i18n!dijit/nls/common"],function(_909,_90a,_90b,_90c,_90d,_90e,_90f,_910,_911,_912,_913){
return _909("davinci.ve.input.SmartInput",null,{property:null,_X_MOVE_RANGE:10,_Y_MOVE_RANGE:10,_POINTER_TOP_OFFSET:-13,multiLine:"false",displayOnCreate:"true",_connection:[],getHelpText:function(){
if(this.helpText){
return this.helpText;
}
if(this.isHtmlSupported()){
return _912.smartInputHelp1;
}
return _912.smartInputHelp2;
},isHtmlSupported:function(){
if(!this.supportsHTML){
if(this._widget.type.match("^html")=="html"){
this.supportsHTML="true";
}else{
this.supportsHTML="false";
}
}
if(typeof (this.supportsHTML)==="boolean"){
return this.supportsHTML;
}
if(this.supportsHTML==="true"){
return true;
}else{
return false;
}
},parse:function(_914){
return _914;
},parseItems:function(_915){
if(this.trim){
_915=dojo.trim(_915);
}
var _916;
if(_915.match(/[^\\][\r\n]/)){
_916=this.parseItemsInRows(_915);
}else{
_916=this.parseItemsInColumns(_915);
}
return _916;
},parseItemsInRows:function(_917){
var _918=this.splitRows(_917);
var _919=_918.length;
for(var i=0;i<_919;i++){
var item=_918[i];
item=this.parseItem(item);
_918[i]=item;
}
return _918;
},parseItemsInColumns:function(_91a){
var _91b=this.splitColumns(_91a);
var _91c=_91b.length;
for(var i=0;i<_91c;i++){
var item=_91b[i];
item=this.parseItem(item);
_91b[i]=item;
}
return _91b;
},parseGrid:function(_91d){
var rows=this.splitRows(_91d);
var _91e=rows.length;
for(var i=0;i<_91e;i++){
var row=rows[i];
var _91f=this.parseItemsInColumns(row);
rows[i]=_91f;
}
return rows;
},parseItem:function(item){
var _920=/^([-~!>|(*)[+\]]*) ?(.*)$/;
var _921=null;
var text=item;
var _922=item.match(_920);
if(_922){
_921=_922[1];
text=_922[2];
}
var _923=0;
var _924=false;
var _925=false;
var _926=false;
if(_921){
for(var i=0;i<_921.length;i++){
var c=_921[i];
switch(c){
case "-":
case "~":
case "!":
_924=true;
break;
case ">":
_923++;
break;
case "*":
case "+":
_925=true;
break;
default:
}
}
}
var _927={original:item,specialChars:_921,text:text,indent:_923,disabled:_924,selected:_925};
return _927;
},splitRows:function(text){
var _928=[];
var i;
var line="";
var _929=false;
for(i=0;i<text.length;i++){
var c=text.charAt(i);
switch(c){
case "\\":
if(_929){
line+=c;
}
_929=!_929;
break;
case "r":
if(_929){
line+="\r";
_929=false;
}else{
line+=c;
}
break;
case "n":
if(_929){
line+="\n";
_929=false;
}else{
line+=c;
}
break;
case "\r":
case "\n":
if(_929){
line+=c;
_929=false;
}else{
if(this.trim){
line=dojo.trim(line);
}
_928.push(line);
line="";
}
break;
default:
line+=c;
_929=false;
}
}
if(line){
if(this.trim){
line=dojo.trim(line);
}
_928.push(line);
}
return _928;
},splitColumns:function(text){
var _92a=[];
var i;
var line="";
var _92b=false;
for(i=0;i<text.length;i++){
var c=text.charAt(i);
switch(c){
case "\\":
if(_92b){
line+=c;
}
_92b=!_92b;
break;
case "r":
if(_92b){
line+="\r";
_92b=false;
}else{
line+=c;
}
break;
case "n":
if(_92b){
line+="\n";
_92b=false;
}else{
line+=c;
}
break;
case ",":
if(_92b){
line+=c;
_92b=false;
}else{
if(this.trim){
line=dojo.trim(line);
}
_92a.push(line);
line="";
}
break;
default:
line+=c;
_92b=false;
}
}
if(line){
if(this.trim){
line=dojo.trim(line);
}
_92a.push(line);
}
return _92a;
},serializeItems:function(_92c){
var _92d=this.format=="columns"?this.serializeColumns(_92c):this.serializeRows(_92c);
return _92d;
},serializeColumns:function(_92e){
for(var i=0;i<_92e.length;i++){
var item=_92e[i];
item=item.replace(/\\/g,"\\\\");
_92e[i]=item.replace(/,/g,"\\,");
}
var _92f=_92e.join(", ");
return _92f;
},serializeRows:function(_930){
for(var i=0;i<_930.length;i++){
var item=_930[i];
item=item.replace(/\\/g,"\\\\");
_930[i]=item.replace(/\n/g,"\\\n");
}
var _931=_930.join("\n");
return _931;
},inlineEditActive:function(){
if(this._inline&&this._inline.style.display!="none"&&this._inline.eb){
return true;
}else{
return false;
}
},show:function(_932){
this._widget=davinci.ve.widget.byId(_932);
if(!this._inline){
this._createInline();
}
var _933=dojo.hitch(this,function(_934){
this._inline.style.display="block";
this.setFormat(_934);
var _935=[["&","amp"],["\"","quot"],["<","lt"],[">","gt"]];
_934=_90f.decode(_934,_935);
this._inline.eb.set("value",String(_934));
this.updateFormats();
this.help(false);
dijit.selectInputText(this._inline.eb.textbox);
this.updateSimStyle();
this._inline.eb.textbox.focus();
});
var node=this._node(this._widget);
var _936=this.property;
var _937=(_936==="maq_innerText")?"innerHTML":_936;
var _938;
if(_936){
if(node){
_938=dojo.attr(node,_937);
}else{
if(_937==="innerHTML"||_937=="textContent"){
_938=this._widget._srcElement.getElementText(this._context);
_938=_938.replace(/\s+/g," ");
}else{
_938=this._widget.attr(_936);
}
}
}
if(this.serialize){
this.serialize(node||this._widget,_933,_938);
}else{
if(_936){
_933(_938);
}
}
},_createInline:function(){
if(this.multiLine&&this.multiLine!="false"){
this._loading(115,200);
var t=this._getTemplate();
this._inline.set("content",t);
}else{
this._loading(85,200);
var t=this._getTemplate();
this._inline.set("content",t);
}
this._inline.eb=dijit.byId("davinciIleb");
this._connection.push(dojo.connect(this._inline.eb,"onMouseDown",this,"stopEvent"));
this._connection.push(dojo.connect(this._inline.eb,"onKeyDown",this,"stopEvent_Intercept_Enter"));
this._connection.push(dojo.connect(this._inline.eb,"onKeyUp",this,"handleEvent"));
if(this.multiLine=="true"){
this._connection.push(dojo.connect(this._inline.eb,"onBlur",this,"onBlur"));
this._connectSimDiv();
}
var text=this._widget._srcElement.getElementText(this._context);
this._inline.eb.setValue(text);
this._loadingDiv.style.backgroundImage="none";
this._inline._setStyleAttr({display:"block"});
this._connectHelpDiv();
this._connectResizeHandle();
window.setTimeout(function(){
if(this._inline&&this._inline.eb&&this._inline.eb.textbox){
this._inline.eb.textbox.focus();
}
this._connection.push(dojo.connect(this._inline,"onBlur",this,"onOk"));
}.bind(this),500);
this.resize(null);
},_connectHelpDiv:function(){
var help=dojo.byId("davinci.ve.input.SmartInput_img_help");
this._connection.push(dojo.connect(help,"onclick",this,"toggleHelp"));
this._connection.push(dojo.connect(dijit.byId("davinci.ve.input.SmartInput_ok"),"_onSubmit",this,"onOk"));
this._connection.push(dojo.connect(dijit.byId("davinci.ve.input.SmartInput_cancel"),"onClick",this,"onCancel"));
},_findSmartInputContainer:function(_939){
return document.body;
var _93a=_939.parentNode;
while(!dojo.hasClass(_93a,"dijitContentPane")){
_93a=_93a.parentNode;
}
return _93a;
},_loading:function(_93b,_93c){
var _93d=this._widget._edit_context.frameNode;
var doc=_93d.ownerDocument;
var _93e=doc.createElement("div");
var _93f=this._findSmartInputContainer(_93d);
if(!_93f){
return;
}
_93f.appendChild(_93e);
this._loadingDiv=_93e;
dojo.addClass(_93e,"smartInputLoading");
var _940=doc.createElement("div");
_940.id="ieb";
dojo.addClass(_940,"inlineEdit dijitTooltipContainer");
var _941=doc.createElement("div");
_941.id="iebPointer";
this._inline=_940;
_93f.appendChild(_940);
_93f.appendChild(_941);
var m2=new dojo.dnd.Moveable("ieb");
this._connection.push(dojo.connect(m2,"onMoveStart",this,"onMoveStart"));
this._connection.push(dojo.connect(m2,"onMoveStop",this,"onMoveStop"));
var _942=new _90c({},_940);
this._inline=_942;
var _943=dijit.byId("editorsStackContainer").domNode;
var p=_90a.position(_943);
this._loadingDiv.style.position="absolute";
this._loadingDiv.style.left=p.x+"px";
this._loadingDiv.style.top=p.y+"px";
this._loadingDiv.style.width=p.w+"px";
this._loadingDiv.style.height=p.h+"px";
var box=this._widget.getMarginBox();
var _944=dojo.position(_93d);
var _945=dojo.position(_93f);
var _946=(_944.x-_945.x)+_93f.scrollLeft-1;
var _947=(_944.y-_945.y)+_93f.scrollTop-1;
var _948=_93f.clientHeight;
var _949=_93f.clientWidth;
var _94a=26;
var top=_94a;
var _94b=0;
if((box.y+_93b+_94a)<_948){
top=box.y+_94a;
dojo.addClass(_941,"inlineEditConnectorBelow");
}else{
if((box.y-_93b)>0){
top=box.y-_93b;
_94b=_93b+12;
}else{
top=0+_94a;
}
}
var left="0";
if((box.x+_93c+20)<_949){
left=box.x;
}else{
if((box.x+_93c)>_949){
var t=box.x-_93c+box.w;
if(t<0){
t=0;
}
left=t;
}
}
left+=_946;
top+=_947;
this._inline._setStyleAttr({display:"block",top:top+"px",left:left+"px",padding:"1px",overflow:"hidden",backgroundImage:"none"});
this._startTop=top;
this._startLeft=left;
dojo.style(_941,"left",box.x+20+_946+"px");
dojo.style(_941,"top",top+_94b+this._POINTER_TOP_OFFSET+"px");
},handleEvent:function(_94c){
switch(_94c.keyCode){
case 13:
var _94d=this.multiLine;
if(!_94d||_94d=="false"||this._lastKeyCode==13||_94c.ctrlKey){
this.onOk();
}else{
if(_94c.which==dojo.keys.ENTER&&_94c.ctrlKey){
this.onOk();
}
}
break;
case 27:
this.onCancel();
break;
default:
this.updateFormats();
}
this._lastKeyCode=_94c.keyCode;
this.updateSimStyle();
},onOk:function(e){
this.hide();
},onCancel:function(e){
this.hide(true);
},onMoveStart:function(_94e){
dojo.style("iebPointer","display","none");
},onMoveStop:function(_94f){
var left=dojo.style("ieb","left");
var top=dojo.style("ieb","top");
var _950=this._startLeft-left;
var _951=top-this._startTop;
if(_951<this._Y_MOVE_RANGE&&_951>(-this._Y_MOVE_RANGE)){
dojo.style("iebPointer","display","");
dojo.style("iebPointer","top",this._startTop+this._POINTER_TOP_OFFSET+_951+"px");
}else{
dojo.style("iebPointer","display","none");
return;
}
if(_950<this._X_MOVE_RANGE&&_950>(-this._X_MOVE_RANGE)){
dojo.style("iebPointer","display","");
}else{
dojo.style("iebPointer","display","none");
return;
}
},stopEvent:function(e){
e.stopPropagation();
this.updateSimStyle();
},stopEvent_Intercept_Enter:function(e){
this.stopEvent(e);
if(e.keyCode==13&&!this.multiLine){
e.preventDefault();
}
},_node:function(){
var node;
var path=this.path;
var _952=this.selector;
if(path||_952){
node=this._widget.domNode;
if(path){
node=dojo.getObject(path,false,this._widget);
}
if(_952){
node=dojo.query(_952,node)[0];
}
}
return node;
},updateWidget:function(_953){
if(this._widget._destroyed){
return;
}
if(this.parse){
_953=this.parse(_953);
}
var node=this._node(this._widget);
var _954=this._widget.getContext();
var _955=this.property;
var _956=(_955==="maq_innerText")?"innerHTML":_955;
if(this.update){
var _957=this.update(node||this._widget,_953,_955);
if(_957){
this._widget=_957;
}
_954.select(this._widget,null,false);
}else{
if(_955){
if(node){
dojo.attr(node,_956,_953);
}else{
var _958={};
if(_953&&(typeof _953=="string")){
_953=_953.replace(/\n/g,"");
}
var _959=null;
if(_955=="textContent"){
_959=_953;
}else{
_958[_955]=_953;
}
var _95a;
if(_956==="innerHTML"){
_958.richText=_958[_955];
delete _958[_955];
_95a=new _90b(this._widget,_958,null,_954);
}else{
_95a=new davinci.ve.commands.ModifyCommand(this._widget,_958,_959,_954);
}
this._widget._edit_context.getCommandStack().execute(_95a);
this._widget=_95a.newWidget;
this._widget._edit_context._focuses[0]._selectedWidget=this._widget;
}
_954.select(this._widget,null,false);
}
}
},hide:function(_95b){
if(this._inline){
var _95c;
while(connection=this._connection.pop()){
if(connection){
dojo.disconnect(connection);
}
}
var _95d=this._findSmartInputContainer(this._widget._edit_context.frameNode);
if(!_95d){
return;
}
if(this._loadingDiv){
_95d.removeChild(this._loadingDiv);
}
if(this._inline.style.display!="none"&&this._inline.eb){
_95c=this._inline.eb.get("value");
this._value=_95c;
this._format=this.getFormat();
this._inline.style.display="none";
if(this._inline.eb){
this._inline.eb.destroyRecursive();
delete this._inline.eb;
}
this._inline.destroyRecursive();
delete this._inline;
var _95e=_95d.ownerDocument.getElementById("iebPointer");
_95d.removeChild(_95e);
if(_95c!=null&&!_95b){
if(!this.disableEncode&&this._format==="text"){
_95c=_90f.encode(_95c);
}
this.updateWidget(_95c);
}
var _95f=this._widget.getContext();
var _960=_95f.getDocument();
_960.defaultView.focus();
}
}
},getFormat:function(){
var _961=dijit.byId("davinci.ve.input.SmartInput_radio_html");
var _962="text";
if(_961&&_961.checked){
_962="html";
}
return _962;
},containsHtmlMarkUp:function(str){
var n=dojo.create("div",{innerHTML:str});
if(n.children.length>0){
return true;
}else{
return false;
}
},toggleHelp:function(){
var help=dojo.byId("davinci.ve.input.SmartInput_img_help");
if(dojo.hasClass(help,"inlineEditHelpSelected")){
this.help(false);
}else{
this.help(true);
}
dojo.toggleClass(help,"inlineEditHelpSelected");
},setFormat:function(_963){
var _964=dijit.byId("davinci.ve.input.SmartInput_radio_html");
var _965=dijit.byId("davinci.ve.input.SmartInput_radio_text");
var n=dojo.create("div",{innerHTML:_963});
var _966=n.children.length?"html":"text";
if(_966==="html"){
_964.set("checked",true);
_965.set("checked",false);
}else{
_964.set("checked",false);
_965.set("checked",true);
}
this._format=_966;
},help:function(_967){
var _968=dojo.byId("davinci.ve.input.SmartInput_div_help");
var _969=dojo.byId("davinci.ve.input.SmartInput_radio_div");
if(_967){
dojo.style(_968,"display","");
}else{
dojo.style(_968,"display","none");
}
},updateFormats:function(){
var _96a=this._inline.eb.get("value");
var _96b=true;
if(this.containsHtmlMarkUp(_96a)){
_96b=false;
}
var _96c=this._widget.getContext().getDojo();
var _96d=dojo.byId("davinci.ve.input.SmartInput_radio_text_width_div");
var what=_90f.encode(_96a);
_96d.innerHTML="<div class=\"dojoxEllipsis\">"+dojo.replace("Plain text ({0})",[what])+"</div>";
var _96e=dojo.byId("davinci.ve.input.SmartInput_radio_html_width_div");
_96e.innerHTML="<div id=\"davinci.ve.input.SmartInput_radio_html_div\" class=\"dojoxEllipsis\">"+_912.htmlMarkup+"</div>";
var _96f=dijit.byId("davinci.ve.input.SmartInput_radio_html");
var _970=dijit.byId("davinci.ve.input.SmartInput_radio_text");
var _971=dojo.byId("davinci.ve.input.SmartInput_table");
_96f.setDisabled(_96b);
_970.setDisabled(_96b);
if(_96b){
dojo.addClass(_96d,"inlineEditDisabled");
dojo.addClass(_96e,"inlineEditDisabled");
_96f.set("checked",false);
_970.set("checked",true);
}else{
dojo.removeClass(_96d,"inlineEditDisabled");
dojo.removeClass(_96e,"inlineEditDisabled");
}
if(!_96b&&this.isHtmlSupported()){
dojo.style(_970.domNode,"display","");
dojo.style(_96f.domNode,"display","");
dojo.style(_96e,"display","");
dojo.style(_96d,"display","");
dojo.style(_971,"display","");
}else{
dojo.style(_970.domNode,"display","none");
dojo.style(_96f.domNode,"display","none");
dojo.style(_96e,"display","none");
dojo.style(_96d,"display","none");
dojo.style(_971,"display","none");
}
},resize:function(e){
var _972=dojo.byId("iedResizeDiv");
var _973=dijit.byId("davinciIleb");
var _974=_972.clientWidth-5;
var _975=_972.clientHeight-6;
var _976=_972.clientWidth-10;
_974=_972.clientWidth-8;
_975=_972.clientHeight-20;
_976=_972.clientWidth-9;
var _977=dojo.byId("smartInputSim");
dojo.style(_977,"width",_974+10+"px");
this.updateSimStyle();
if(_973){
_973._setStyleAttr({width:_974+"px",height:_975+"px",maxHeight:_975+"px"});
_973._setStyleAttr({width:_972.clientWidth+"px"});
}
var obj=dojo.byId("davinci.ve.input.SmartInput_radio_div");
dojo.style(obj,"width",_976+2+"px");
obj=dojo.byId("davinci.ve.input.SmartInput_radio_text_width_div");
dojo.style(obj,"width",_972.clientWidth-50+"px");
obj=dojo.byId("davinci.ve.input.SmartInput_radio_html_width_div");
dojo.style(obj,"width",_972.clientWidth-50+"px");
},onBlur:function(e){
this.updateSimStyle(e);
},updateSimStyle:function(e){
var _978=dijit.byId("davinciIleb");
var _979=dojo.byId("smartInputSim");
if(_979){
var s=dojo.style(_978.domNode);
dojo.style(_979,"borderColor",s.borderTopColor);
dojo.style(_979,"backgroundColor",s.backgroundColor);
}
},_getTemplate:function(){
var _97a=""+"<div id=\"iedResizeDiv\" class=\"iedResizeDiv\" >"+"<textarea  dojoType=\"dijit.form.SimpleTextarea\" name=\"davinciIleb\" trim=\"true\" id=\"davinciIleb\" class=\"smartInputTextArea\" ></textarea>"+"<div id=\"smartInputSim\" class=\"smartInputSim\" ></div>"+"<div id=\"iedResizeHandle\" dojoType=\"dojox.layout.ResizeHandle\" targetId=\"iedResizeDiv\" constrainMin=\"true\" maxWidth=\"200\" maxHeight=\"600\" minWidth=\"200\" minHeight=\"55\"  activeResize=\"true\" intermediateChanges=\"true\" ></div>"+"</div>";
if(this.multiLine==="true"){
_97a=""+"<div id=\"iedResizeDiv\" class=\"iedResizeDiv\" >"+"<textarea  dojoType=\"dijit.form.SimpleTextarea\" name=\"davinciIleb\" trim=\"true\" id=\"davinciIleb\" class=\"smartInputTextAreaMulti\" ></textarea>"+"<div id=\"smartInputSim\" class=\"smartInputSim\" ></div>"+"<div id=\"iedResizeHandle\" dojoType=\"dojox.layout.ResizeHandle\" targetId=\"iedResizeDiv\" constrainMin=\"true\" maxWidth=\"200\" maxHeight=\"600\" minWidth=\"200\" minHeight=\"80\"  activeResize=\"true\" intermediateChanges=\"true\" ></div>"+"</div>";
}
var _97b=""+_97a+"<div  id=\"davinci.ve.input.SmartInput_div\"  class=\"davinciVeInputSmartInputDiv\" >"+"<div id=\"davinci.ve.input.SmartInput_radio_div\" class=\"smartInputRadioDiv\" >"+"<table id=\"davinci.ve.input.SmartInput_table\"> "+"<tbody>"+"<tr> "+"<td class=\"smartInputTd1\" > "+"<input id=\"davinci.ve.input.SmartInput_radio_text\" showlabel=\"true\" type=\"radio\" dojoType=\"dijit.form.RadioButton\" disabled=\"false\" readOnly=\"false\" intermediateChanges=\"false\" checked=\"true\"> </input> "+"</td> "+"<td class=\"smartInputTd2\" >"+"<div id=\"davinci.ve.input.SmartInput_radio_text_width_div\" class=\"smartInputRadioTextDiv\">"+"</div>"+"</td> "+"</tr>"+"<tr> "+"<td class=\"smartInputTd1\"> <input id=\"davinci.ve.input.SmartInput_radio_html\" showlabel=\"true\" type=\"radio\" dojoType=\"dijit.form.RadioButton\"> </input>  </td> "+"<td class=\"smartInputTd2\">"+"<div id=\"davinci.ve.input.SmartInput_radio_html_width_div\" class=\"smartInputRadioTextDiv\">"+"</div>"+"</td> "+"</tr> "+"</tbody>"+"</table> "+"<div class=\"smartInputHelpDiv\" > "+"<span id=\"davinci.ve.input.SmartInput_img_help\"  title=\"Help\" class=\"inlineEditHelp\" > </span>"+"<span class=\"smartInputSpacerSpan\" >"+"<button id=\"davinci.ve.input.SmartInput_ok\"  dojoType=\"dijit.form.Button\" type=\"submit\" class=\"inlineEditHelpOk\" >"+_913.buttonOk+"</button> <button id=davinci.ve.input.SmartInput_cancel dojoType=\"dijit.form.Button\" class=\"inlineEditHelpCancel\"> "+_913.buttonCancel+"</button>  "+"</span>   "+"</div> "+"<div id=\"davinci.ve.input.SmartInput_div_help\" style=\"display:none;\" class=\"smartInputHelpTextDiv\" > "+"<div dojoType=\"dijit.layout.ContentPane\" class=\"smartInputHelpTextDivContentPane \"style=\"padding:0;\" >"+this.getHelpText()+"</div> "+"<div style=\"text-align: left; padding:0; height:2px;\" ></div> "+"</div> "+"</div>"+"</div> "+"";
return _97b;
},_connectResizeHandle:function(){
var _97c=dijit.byId("iedResizeHandle");
this._connection.push(dojo.connect(_97c,"onResize",this,"resize"));
},_connectSimDiv:function(){
this._connection.push(dojo.connect(this._inline.eb,"onFocus",this,"updateSimStyle"));
this._connection.push(dojo.connect(this._inline.eb,"onMouseOver",this,"updateSimStyle"));
this._connection.push(dojo.connect(this._inline.eb,"onMouseOut",this,"updateSimStyle"));
this._connection.push(dojo.connect(dojo.byId(" davinci.ve.input.SmartInput_div"),"onclick",this,"updateSimStyle"));
}});
});
},"url:dijit/templates/Tree.html":"<div class=\"dijitTree dijitTreeContainer\" role=\"tree\">\n\t<div class=\"dijitInline dijitTreeIndent\" style=\"position: absolute; top: -9999px\" data-dojo-attach-point=\"indentDetector\"></div>\n</div>\n","dijit/form/_ListMouseMixin":function(){
define(["dojo/_base/declare","dojo/mouse","dojo/on","dojo/touch","./_ListBase"],function(_97d,_97e,on,_97f,_980){
return _97d("dijit.form._ListMouseMixin",_980,{postCreate:function(){
this.inherited(arguments);
this.own(on(this.domNode,_97f.press,function(evt){
evt.preventDefault();
}));
this._listConnect(_97f.press,"_onMouseDown");
this._listConnect(_97f.release,"_onMouseUp");
this._listConnect(_97e.enter,"_onMouseOver");
this._listConnect(_97e.leave,"_onMouseOut");
},_onMouseDown:function(evt,_981){
if(this._hoveredNode){
this.onUnhover(this._hoveredNode);
this._hoveredNode=null;
}
this._isDragging=true;
this._setSelectedAttr(_981);
},_onMouseUp:function(evt,_982){
this._isDragging=false;
var _983=this.selected;
var _984=this._hoveredNode;
if(_983&&_982==_983){
this.onClick(_983);
}else{
if(_984&&_982==_984){
this._setSelectedAttr(_984);
this.onClick(_984);
}
}
},_onMouseOut:function(evt,_985){
if(this._hoveredNode){
this.onUnhover(this._hoveredNode);
this._hoveredNode=null;
}
if(this._isDragging){
this._cancelDrag=(new Date()).getTime()+1000;
}
},_onMouseOver:function(evt,_986){
if(this._cancelDrag){
var time=(new Date()).getTime();
if(time>this._cancelDrag){
this._isDragging=false;
}
this._cancelDrag=null;
}
this._hoveredNode=_986;
this.onHover(_986);
if(this._isDragging){
this._setSelectedAttr(_986);
}
}});
});
},"dojo/cookie":function(){
define(["./_base/kernel","./regexp"],function(dojo,_987){
dojo.cookie=function(name,_988,_989){
var c=document.cookie,ret;
if(arguments.length==1){
var _98a=c.match(new RegExp("(?:^|; )"+_987.escapeString(name)+"=([^;]*)"));
ret=_98a?decodeURIComponent(_98a[1]):undefined;
}else{
_989=_989||{};
var exp=_989.expires;
if(typeof exp=="number"){
var d=new Date();
d.setTime(d.getTime()+exp*24*60*60*1000);
exp=_989.expires=d;
}
if(exp&&exp.toUTCString){
_989.expires=exp.toUTCString();
}
_988=encodeURIComponent(_988);
var _98b=name+"="+_988,_98c;
for(_98c in _989){
_98b+="; "+_98c;
var _98d=_989[_98c];
if(_98d!==true){
_98b+="="+_98d;
}
}
document.cookie=_98b;
}
return ret;
};
dojo.cookie.isSupported=function(){
if(!("cookieEnabled" in navigator)){
this("__djCookieTest__","CookiesAllowed");
navigator.cookieEnabled=this("__djCookieTest__")=="CookiesAllowed";
if(navigator.cookieEnabled){
this("__djCookieTest__","",{expires:-1});
}
}
return navigator.cookieEnabled;
};
return dojo.cookie;
});
},"url:dijit/form/templates/DropDownBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\"\n\trole=\"combobox\"\n\t><div class='dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer'\n\t\tdata-dojo-attach-point=\"_buttonNode, _popupStateNode\" role=\"presentation\"\n\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"button presentation\" aria-hidden=\"true\"\n\t\t\t${_buttonInputDisabled}\n\t/></div\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class='dijitReset dijitInputInner' ${!nameAttrSetting} type=\"text\" autocomplete=\"off\"\n\t\t\tdata-dojo-attach-point=\"textbox,focusNode\" role=\"textbox\" aria-haspopup=\"true\"\n\t/></div\n></div>\n","davinci/model/Path":function(){
define(["dojo/_base/declare"],function(_98e){
if(typeof davinci.model==="undefined"){
davinci.model={};
}
if(typeof davinci.model.Path==="undefined"){
davinci.model.Path={};
}
var Path=_98e("davinci.model.Path",null,{constructor:function(path,_98f,_990){
path=path||".";
if(typeof path=="string"){
this.path=path;
this.getSegments();
}else{
this.segments=path;
this.hasLeading=_98f;
this.hasTrailing=_990;
}
},endsWith:function(tail){
var _991=dojo.clone(this.segments);
var _992=(new Path(tail)).getSegments();
while(_992.length>0&&_991.length>0){
if(_992.pop()!=_991.pop()){
return false;
}
}
return true;
},getExtension:function(){
if(!this.extension){
this.extension=this.path.substr(this.path.lastIndexOf(".")+1);
}
return this.extension;
},segment:function(_993){
var segs=this.getSegments();
if(segs.length<_993){
return null;
}
return segs[_993];
},getSegments:function(){
if(!this.segments){
var path=this.path;
this.segments=path.split("/");
if(path.charAt(0)=="/"){
this.hasLeading=true;
}
if(path.charAt(path.length-1)=="/"){
this.hasTrailing=true;
this.segments.pop();
}
this._canonicalize();
}
return this.segments;
},isAbsolute:function(){
return this.hasLeading;
},getParentPath:function(){
if(!this._parentPath){
var _994=dojo.clone(this.segments);
_994.pop();
this._parentPath=new Path(_994,this.hasLeading);
}
return dojo.clone(this._parentPath);
},_clone:function(){
return new Path(dojo.clone(this.segments),this.hasLeading,this.hasTrailing);
},append:function(tail){
tail=tail||"";
if(typeof tail=="string"){
tail=new Path(tail);
}
if(tail.isAbsolute()){
return tail;
}
var _995=this.segments;
var _996=tail.getSegments();
var _997=_995.concat(_996);
var _998=new Path(_997,this.hasLeading,tail.hasTrailing);
if(_996[0]==".."||_996[0]=="."){
_998._canonicalize();
}
return _998;
},toString:function(){
var _999=[];
if(this.hasLeading){
_999.push("/");
}
for(var i=0;i<this.segments.length;i++){
if(i>0){
_999.push("/");
}
_999.push(this.segments[i]);
}
if(this.hasTrailing){
_999.push("/");
}
return _999.join("");
},removeRelative:function(){
var segs=this.getSegments();
if(segs.length>0&&segs[1]=="."){
return this.removeFirstSegments(1);
}
return this;
},relativeTo:function(base,_99a){
if(typeof base=="string"){
base=new Path(base);
}
var _99b=this.segments;
if(this.isAbsolute()){
return this;
}
var _99c=base.getSegments();
var _99d=this.matchingFirstSegments(base);
var _99e=_99c.length;
if(_99a){
_99e=_99e-1;
}
var _99f=_99e-_99d;
var _9a0=_99f+_99b.length-_99d;
if(_9a0==0){
return davinci.model.Path.EMPTY;
}
var _9a1=[];
for(var i=0;i<_99f;i++){
_9a1.push("..");
}
for(var i=_99d;i<_99b.length;i++){
_9a1.push(_99b[i]);
}
return new Path(_9a1,false,this.hasTrailing);
},startsWith:function(_9a2){
var _9a3=this.matchingFirstSegments(_9a2);
return _9a2._length()==_9a3;
},_length:function(_9a4){
return this.segments.length;
},matchingFirstSegments:function(_9a5){
var _9a6=this.segments;
var _9a7=_9a5.getSegments();
var max=Math.min(_9a6.length,_9a7.length);
var _9a8=0;
for(var i=0;i<max;i++){
if(_9a6[i]!=_9a7[i]){
return _9a8;
}
_9a8++;
}
return _9a8;
},removeFirstSegments:function(_9a9){
return new Path(this.segments.slice(_9a9,this.segments.length),this.hasLeading,this.hasTrailing);
},removeMatchingLastSegments:function(_9aa){
var _9ab=this.matchingFirstSegments(_9aa);
return this.removeLastSegments(_9ab);
},removeMatchingFirstSegments:function(_9ac){
var _9ad=this.matchingFirstSegments(_9ac);
return this._clone().removeFirstSegments(_9ad);
},removeLastSegments:function(_9ae){
if(!_9ae){
_9ae=1;
}
return new Path(this.segments.slice(0,this.segments.length-_9ae),this.hasLeading,this.hasTrailing);
},lastSegment:function(){
return this.segments[this.segments.length-1];
},firstSegment:function(_9af){
return this.segments[_9af||0];
},equals:function(_9b0){
if(this.segments.length!=_9b0.segments.length){
return false;
}
for(var i=0;i<this.segments.length;i++){
if(_9b0.segments[i]!=this.segments[i]){
return false;
}
}
return true;
},_canonicalize:function(){
var doIt;
var _9b1=this.segments;
for(var i=0;i<_9b1.length;i++){
if(_9b1[i]=="."||_9b1[i]==".."){
doIt=true;
break;
}
}
if(doIt){
var _9b2=[];
for(var i=0;i<_9b1.length;i++){
if(_9b1[i]==".."){
if(_9b2.length==0){
if(!this.hasLeading){
_9b2.push(_9b1[i]);
}
}else{
if(".."==_9b2[_9b2.length-1]){
_9b2.push("..");
}else{
_9b2.pop();
}
}
}else{
if(_9b1[i]!="."||this.segments.length==1){
_9b2.push(_9b1[i]);
}
}
}
if(_9b2.length==_9b1.length){
return;
}
this.segments=_9b2;
}
}});
davinci.model.Path.EMPTY=new Path("");
return Path;
});
},"davinci/workbench/Preferences":function(){
define(["dojo/_base/declare","dojo/_base/xhr","dojo/_base/lang","dojo/topic","dojo/dom","../Runtime","dijit/_WidgetBase","dijit/_TemplatedMixin","dijit/_WidgetsInTemplateMixin","dijit/registry","davinci/ui/Dialog","dijit/Tree","dijit/tree/ForestStoreModel","dojo/data/ItemFileReadStore","dojo/i18n!./nls/workbench","dojo/i18n!dijit/nls/common","dojo/text!./templates/Preferences.html","dijit/form/Button"],function(_9b3,xhr,lang,_9b4,dom,_9b5,_9b6,_9b7,_9b8,_9b9,_9ba,Tree,_9bb,_9bc,_9bd,_9be,_9bf){
var _9c0=650;
var _9c1=350;
var _9c2=_9b3([_9b6,_9b7,_9b8],{templateString:_9bf,commonStrings:_9be,resize:function(){
this.borderContainer.resize();
}});
var _9c3={_allPrefs:{},savePreferences:function(id,base,_9c4){
xhr.put({url:"cmd/setPreferences?id="+id+"&base="+encodeURIComponent(base),putData:JSON.stringify(_9c4),handleAs:"json",contentType:"text/html"}).then(function(){
if(!_9c3._allPrefs[base]){
_9c3._allPrefs[base]={};
}
_9c3._allPrefs[base][id]=_9c4;
_9b4.publish("/davinci/preferencesChanged",{id:id,preferences:_9c4});
});
},_loadExtensions:function(){
if(!_9c3._extensions){
_9c3._extensions=_9b5.getExtensions("davinci.preferences");
}
},showPreferencePage:function(){
_9c3._loadExtensions();
var _9c5=_9c3.getPrefJson();
if(_9c5.items){
for(var i=_9c5.items.length-1;i>=0;i--){
var item=_9c5.items[i];
if(item.hide){
_9c5.items.splice(i,1);
}
}
}
if(!_9c5||_9c5.length<1){
alert(_9bd.noUserPref);
return;
}
this.dialog=_9ba.showModal(new _9c2({}),_9bd.preferences,{width:_9c0,height:_9c1});
var _9c6=new _9bc({data:_9c5,jsId:"prefTreeDataStore"});
var _9c7=new _9bb({jsId:"fileModel",labelAttr:"name",store:_9c6,rootId:"root"});
var path=["root"];
var _9c8=_9c5.items;
if(_9c8){
do{
var item=_9c8[0];
path.push(item.id);
_9c8=item.children;
}while(_9c8);
}
var _9c9=_9b9.byId("prefTree");
if(!_9c9){
_9c9=new Tree({model:_9c7,id:"prefTree",persist:false,query:"{type:'directory'}",label:"Preferences",labelAttr:"name",showRoot:false,childrenAttrs:"children",openOnClick:true,autoExpand:true});
}
_9c9.onClick=function(node){
_9c3.setPaneContent(node);
};
dom.byId("pref.TreePane").appendChild(_9c9.domNode);
_9c9.startup();
_9c9.onLoadDeferred.then(function(){
_9c9.set("paths",[path]).then(function(){
_9c9.focusNode(_9c9.selectedNode);
_9c3.setPaneContent(_9c9.selectedItem);
});
});
},getPrefJson:function(){
var _9ca=_9c3._extensions;
if(!_9ca){
return [];
}
var _9cb=[];
for(var i=0;i<_9ca.length;i++){
_9ca[i]._index=i;
if(_9ca[i].category){
if(!_9cb[_9ca[i].category]){
_9cb[_9ca[i].category]=[];
}
_9cb[_9ca[i].category].push(_9ca[i]);
}else{
if(!_9cb.root){
_9cb.root=[];
}
_9cb.root.push(_9ca[i]);
}
}
var _9cc=_9cb.root.map(function(node){
return {id:node.id,name:node.name,hide:node.hide,index:node._index,children:_9c3._getPrefJsonChildren(node.id,_9cb)};
});
return {identifier:"id",items:_9cc};
},_getPrefJsonChildren:function(_9cd,_9ce){
var _9cf=_9ce[_9cd];
if(!_9cf){
return [];
}
var _9d0=[];
for(var p=0;p<_9cf.length;p++){
_9d0[p]={id:_9cf[p].id,name:_9cf[p].name,index:_9cf[p]._index};
if(_9ce[_9cf[p].id]){
_9d0[p].children=_9c3._getPrefJsonChildren(_9cf[p].id,_9ce);
}
}
return _9d0;
},setPaneContent:function(node){
var _9d1;
delete _9c3._currentPane;
var _9d2=_9c3._extensions[node.index[0]];
var _9d3=_9c3.getPreferences(_9d2.id,davinci.Workbench.getProject());
if(_9d2.pane){
require([_9d2.pane],function(cls){
var pane=new cls();
_9c3._currentPane=pane;
_9c3._currentPane._extension=_9d2;
_9c3._currentPane.setPreferences(_9d3);
_9b9.byId("pref.RightPane").setContent(pane.domNode);
});
}else{
if(_9d2.pageContent){
_9d1=document.createTextNode(_9d2.pageContent);
}else{
_9d1=document.createTextNode("");
}
}
if(_9d1){
_9b9.byId("pref.RightPane").setContent(_9d1);
}
},_save:function(_9d4){
if(_9c3._currentPane){
var _9d5=_9c3._currentPane.getPreferences();
var id=_9c3._currentPane._extension.id;
var base=davinci.Workbench.getProject();
_9c3.savePreferences(id,base,_9d5);
if(_9c3._currentPane.save){
_9c3._currentPane.save(_9d5);
}
}
for(var i=0;i<_9d4.length;i++){
try{
if(_9d4[i].save){
_9d4[i].save();
}
}
catch(ex){
}
if(_9d4[i].children&&_9d4[i].children.length>0){
_9c3._save(_9d4[i].children);
}
}
},save:function(){
_9c3._save(_9c3._extensions);
_9c3.finish();
},finish:function(){
_9c3._extensions=null;
_9c3._currentPane=null;
this.dialog.destroyRecursive(false);
this.dialog=null;
},getPreferences:function(id,base){
if(!_9c3._allPrefs[base]){
_9c3._allPrefs[base]={};
}
if(!_9c3._allPrefs[base][id]){
var _9d6=_9b5.serverJSONRequest({url:"cmd/getPreferences",handleAs:"json",content:{id:id,base:base},sync:true});
if(!_9d6){
_9d6=_9c3.getDefaultPreferences(id);
}
_9c3._allPrefs[base][id]=_9d6;
}
return _9c3._allPrefs[base][id];
},getDefaultPreferences:function(id){
_9c3._loadExtensions();
for(var i=0;i<_9c3._extensions.length;i++){
if(_9c3._extensions[i].id==id){
if(typeof _9c3._extensions[i].defaultValues==="string"){
var _9d7=_9b5.serverJSONRequest({url:_9c3._extensions[i].defaultValues,handleAs:"json",sync:true});
return _9d7.defaultValues;
}
return _9c3._extensions[i].defaultValues;
}
}
}};
return lang.setObject("davinci.workbench.Preferences",_9c3);
});
},"davinci/model/resource/Marker":function(){
define(["dojo/_base/declare","davinci/model/resource/Resource"],function(_9d8,_9d9){
return _9d8("davinci.model.resource.Marker",_9d9,{constructor:function(_9da,type,line,text){
this.resource=_9da;
this.type=type;
this.line=line;
this.text=text;
}});
});
},"dojox/grid/_ViewManager":function(){
define(["dojo/_base/declare","dojo/_base/sniff","dojo/dom-class"],function(_9db,has,_9dc){
return _9db("dojox.grid._ViewManager",null,{constructor:function(_9dd){
this.grid=_9dd;
},defaultWidth:200,views:[],resize:function(){
this.onEach("resize");
},render:function(){
this.onEach("render");
},addView:function(_9de){
_9de.idx=this.views.length;
this.views.push(_9de);
},destroyViews:function(){
for(var i=0,v;v=this.views[i];i++){
v.destroy();
}
this.views=[];
},getContentNodes:function(){
var _9df=[];
for(var i=0,v;v=this.views[i];i++){
_9df.push(v.contentNode);
}
return _9df;
},forEach:function(_9e0){
for(var i=0,v;v=this.views[i];i++){
_9e0(v,i);
}
},onEach:function(_9e1,_9e2){
_9e2=_9e2||[];
for(var i=0,v;v=this.views[i];i++){
if(_9e1 in v){
v[_9e1].apply(v,_9e2);
}
}
},normalizeHeaderNodeHeight:function(){
var _9e3=[];
for(var i=0,v;(v=this.views[i]);i++){
if(v.headerContentNode.firstChild){
_9e3.push(v.headerContentNode);
}
}
this.normalizeRowNodeHeights(_9e3);
},normalizeRowNodeHeights:function(_9e4){
var h=0;
var _9e5=[];
if(this.grid.rowHeight){
h=this.grid.rowHeight;
}else{
if(_9e4.length<=1){
return;
}
for(var i=0,n;(n=_9e4[i]);i++){
if(!_9dc.contains(n,"dojoxGridNonNormalizedCell")){
_9e5[i]=n.firstChild.offsetHeight;
h=Math.max(h,_9e5[i]);
}
}
h=(h>=0?h:0);
if((has("mozilla")||has("ie")>8)&&h){
h++;
}
}
for(i=0;(n=_9e4[i]);i++){
if(_9e5[i]!=h){
n.firstChild.style.height=h+"px";
}
}
},resetHeaderNodeHeight:function(){
for(var i=0,v,n;(v=this.views[i]);i++){
n=v.headerContentNode.firstChild;
if(n){
n.style.height="";
}
}
},renormalizeRow:function(_9e6){
var _9e7=[];
for(var i=0,v,n;(v=this.views[i])&&(n=v.getRowNode(_9e6));i++){
n.firstChild.style.height="";
_9e7.push(n);
}
this.normalizeRowNodeHeights(_9e7);
},getViewWidth:function(_9e8){
return this.views[_9e8].getWidth()||this.defaultWidth;
},measureHeader:function(){
this.resetHeaderNodeHeight();
this.forEach(function(_9e9){
_9e9.headerContentNode.style.height="";
});
var h=0;
this.forEach(function(_9ea){
h=Math.max(_9ea.headerNode.offsetHeight,h);
});
return h;
},measureContent:function(){
var h=0;
this.forEach(function(_9eb){
h=Math.max(_9eb.domNode.offsetHeight,h);
});
return h;
},findClient:function(_9ec){
var c=this.grid.elasticView||-1;
if(c<0){
for(var i=1,v;(v=this.views[i]);i++){
if(v.viewWidth){
for(i=1;(v=this.views[i]);i++){
if(!v.viewWidth){
c=i;
break;
}
}
break;
}
}
}
if(c<0){
c=Math.floor(this.views.length/2);
}
return c;
},arrange:function(l,w){
var i,v,vw,len=this.views.length,self=this;
var c=(w<=0?len:this.findClient());
var _9ed=function(v,l){
var ds=v.domNode.style;
var hs=v.headerNode.style;
if(!self.grid.isLeftToRight()){
ds.right=l+"px";
if(has("ff")<4){
hs.right=l+v.getScrollbarWidth()+"px";
}else{
hs.right=l+"px";
}
if(!has("webkit")){
hs.width=parseInt(hs.width,10)-v.getScrollbarWidth()+"px";
}
}else{
ds.left=l+"px";
hs.left=l+"px";
}
ds.top=0+"px";
hs.top=0;
};
for(i=0;(v=this.views[i])&&(i<c);i++){
vw=this.getViewWidth(i);
v.setSize(vw,0);
_9ed(v,l);
if(v.headerContentNode&&v.headerContentNode.firstChild){
vw=v.getColumnsWidth()+v.getScrollbarWidth();
}else{
vw=v.domNode.offsetWidth;
}
l+=vw;
}
i++;
var r=w;
for(var j=len-1;(v=this.views[j])&&(i<=j);j--){
vw=this.getViewWidth(j);
v.setSize(vw,0);
vw=v.domNode.offsetWidth;
r-=vw;
_9ed(v,r);
}
if(c<len){
v=this.views[c];
vw=Math.max(1,r-l);
v.setSize(vw+"px",0);
_9ed(v,l);
}
return l;
},renderRow:function(_9ee,_9ef,_9f0){
var _9f1=[];
for(var i=0,v,n,_9f2;(v=this.views[i])&&(n=_9ef[i]);i++){
_9f2=v.renderRow(_9ee);
n.appendChild(_9f2);
_9f1.push(_9f2);
}
if(!_9f0){
this.normalizeRowNodeHeights(_9f1);
}
},rowRemoved:function(_9f3){
this.onEach("rowRemoved",[_9f3]);
},updateRow:function(_9f4,_9f5){
for(var i=0,v;v=this.views[i];i++){
v.updateRow(_9f4);
}
if(!_9f5){
this.renormalizeRow(_9f4);
}
},updateRowStyles:function(_9f6){
this.onEach("updateRowStyles",[_9f6]);
},setScrollTop:function(_9f7){
var top=_9f7;
for(var i=0,v;v=this.views[i];i++){
top=v.setScrollTop(_9f7);
if(has("ie")&&v.headerNode&&v.scrollboxNode){
v.headerNode.scrollLeft=v.scrollboxNode.scrollLeft;
}
}
return top;
},getFirstScrollingView:function(){
for(var i=0,v;(v=this.views[i]);i++){
if(v.hasHScrollbar()||v.hasVScrollbar()){
return v;
}
}
return null;
}});
});
},"dijit/form/NumberTextBox":function(){
define(["dojo/_base/declare","dojo/_base/lang","dojo/number","./RangeBoundTextBox"],function(_9f8,lang,_9f9,_9fa){
var _9fb=_9f8("dijit.form.NumberTextBoxMixin",null,{pattern:_9f9.regexp,value:NaN,editOptions:{pattern:"#.######"},_formatter:_9f9.format,postMixInProperties:function(){
this.inherited(arguments);
this._set("type","text");
},_setConstraintsAttr:function(_9fc){
var _9fd=typeof _9fc.places=="number"?_9fc.places:0;
if(_9fd){
_9fd++;
}
if(typeof _9fc.max!="number"){
_9fc.max=9*Math.pow(10,15-_9fd);
}
if(typeof _9fc.min!="number"){
_9fc.min=-9*Math.pow(10,15-_9fd);
}
this.inherited(arguments,[_9fc]);
if(this.focusNode&&this.focusNode.value&&!isNaN(this.value)){
this.set("value",this.value);
}
},_onFocus:function(){
if(this.disabled){
return;
}
var val=this.get("value");
if(typeof val=="number"&&!isNaN(val)){
var _9fe=this.format(val,this.constraints);
if(_9fe!==undefined){
this.textbox.value=_9fe;
}
}
this.inherited(arguments);
},format:function(_9ff,_a00){
var _a01=String(_9ff);
if(typeof _9ff!="number"){
return _a01;
}
if(isNaN(_9ff)){
return "";
}
if(!("rangeCheck" in this&&this.rangeCheck(_9ff,_a00))&&_a00.exponent!==false&&/\de[-+]?\d/i.test(_a01)){
return _a01;
}
if(this.editOptions&&this.focused){
_a00=lang.mixin({},_a00,this.editOptions);
}
return this._formatter(_9ff,_a00);
},_parser:_9f9.parse,parse:function(_a02,_a03){
var v=this._parser(_a02,lang.mixin({},_a03,(this.editOptions&&this.focused)?this.editOptions:{}));
if(this.editOptions&&this.focused&&isNaN(v)){
v=this._parser(_a02,_a03);
}
return v;
},_getDisplayedValueAttr:function(){
var v=this.inherited(arguments);
return isNaN(v)?this.textbox.value:v;
},filter:function(_a04){
return (_a04==null||_a04==="")?NaN:this.inherited(arguments);
},serialize:function(_a05,_a06){
return (typeof _a05!="number"||isNaN(_a05))?"":this.inherited(arguments);
},_setBlurValue:function(){
var val=lang.hitch(lang.mixin({},this,{focused:true}),"get")("value");
this._setValueAttr(val,true);
},_setValueAttr:function(_a07,_a08,_a09){
if(_a07!==undefined&&_a09===undefined){
_a09=String(_a07);
if(typeof _a07=="number"){
if(isNaN(_a07)){
_a09="";
}else{
if(("rangeCheck" in this&&this.rangeCheck(_a07,this.constraints))||this.constraints.exponent===false||!/\de[-+]?\d/i.test(_a09)){
_a09=undefined;
}
}
}else{
if(!_a07){
_a09="";
_a07=NaN;
}else{
_a07=undefined;
}
}
}
this.inherited(arguments,[_a07,_a08,_a09]);
},_getValueAttr:function(){
var v=this.inherited(arguments);
if(isNaN(v)&&this.textbox.value!==""){
if(this.constraints.exponent!==false&&/\de[-+]?\d/i.test(this.textbox.value)&&(new RegExp("^"+_9f9._realNumberRegexp(lang.mixin({},this.constraints))+"$").test(this.textbox.value))){
var n=Number(this.textbox.value);
return isNaN(n)?undefined:n;
}else{
return undefined;
}
}else{
return v;
}
},isValid:function(_a0a){
if(!this.focused||this._isEmpty(this.textbox.value)){
return this.inherited(arguments);
}else{
var v=this.get("value");
if(!isNaN(v)&&this.rangeCheck(v,this.constraints)){
if(this.constraints.exponent!==false&&/\de[-+]?\d/i.test(this.textbox.value)){
return true;
}else{
return this.inherited(arguments);
}
}else{
return false;
}
}
}});
var _a0b=_9f8("dijit.form.NumberTextBox",[_9fa,_9fb],{baseClass:"dijitTextBox dijitNumberTextBox"});
_a0b.Mixin=_9fb;
return _a0b;
});
},"dojo/promise/all":function(){
define(["../_base/array","../Deferred","../when"],function(_a0c,_a0d,when){
"use strict";
var some=_a0c.some;
return function all(_a0e){
var _a0f,_a0c;
if(_a0e instanceof Array){
_a0c=_a0e;
}else{
if(_a0e&&typeof _a0e==="object"){
_a0f=_a0e;
}
}
var _a10;
var _a11=[];
if(_a0f){
_a0c=[];
for(var key in _a0f){
if(Object.hasOwnProperty.call(_a0f,key)){
_a11.push(key);
_a0c.push(_a0f[key]);
}
}
_a10={};
}else{
if(_a0c){
_a10=[];
}
}
if(!_a0c||!_a0c.length){
return new _a0d().resolve(_a10);
}
var _a12=new _a0d();
_a12.promise.always(function(){
_a10=_a11=null;
});
var _a13=_a0c.length;
some(_a0c,function(_a14,_a15){
if(!_a0f){
_a11.push(_a15);
}
when(_a14,function(_a16){
if(!_a12.isFulfilled()){
_a10[_a11[_a15]]=_a16;
if(--_a13===0){
_a12.resolve(_a10);
}
}
},_a12.reject);
return _a12.isFulfilled();
});
return _a12.promise;
};
});
},"dijit/form/TimeTextBox":function(){
define(["dojo/_base/declare","dojo/keys","dojo/_base/lang","../_TimePicker","./_DateTimeTextBox"],function(_a17,keys,lang,_a18,_a19){
return _a17("dijit.form.TimeTextBox",_a19,{baseClass:"dijitTextBox dijitComboBox dijitTimeTextBox",popupClass:_a18,_selector:"time",value:new Date(""),_onKey:function(evt){
if(this.disabled||this.readOnly){
return;
}
this.inherited(arguments);
switch(evt.keyCode){
case keys.ENTER:
case keys.TAB:
case keys.ESCAPE:
case keys.DOWN_ARROW:
case keys.UP_ARROW:
break;
default:
this.defer(function(){
var val=this.get("displayedValue");
this.filterString=(val&&!this.parse(val,this.constraints))?val.toLowerCase():"";
if(this._opened){
this.closeDropDown();
}
this.openDropDown();
});
}
}});
});
},"davinci/review/model/resource/Empty":function(){
define(["dojo/_base/declare","davinci/model/resource/Resource"],function(_a1a,_a1b){
return _a1a("davinci.review.model.resource.Empty",_a1b,{constructor:function(args){
this.elementType="Folder";
this.name="root";
this.parent=null;
},getChildren:function(){
return this.children;
}});
});
},"url:dijit/form/templates/Button.html":"<span class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><span class=\"dijitReset dijitInline dijitButtonNode\"\n\t\tdata-dojo-attach-event=\"ondijitclick:_onClick\" role=\"presentation\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode,focusNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span class=\"dijitReset dijitToggleButtonIconChar\">&#x25CF;</span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t></span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\"\n\t\ttabIndex=\"-1\" role=\"presentation\" data-dojo-attach-point=\"valueNode\"\n/></span>\n","davinci/ve/widget":function(){
define(["davinci/html/HTMLElement","../Runtime","./metadata","dojo/Deferred","./DijitWidget","./GenericWidget","./HTMLWidget","./ObjectWidget","dojo/window"],function(_a1c,_a1d,_a1e,_a1f,_a20,_a21,_a22,_a23,_a24){
var _a25={};
var _a26=function(_a27,node,_a28){
for(var i=0;i<_a28.children.length;i++){
var _a29=node.childNodes[i];
var _a2a=_a28.children[i];
if((_a29&&_a29.nodeType==1)&&_a2a.elementType=="HTMLElement"){
_a29.id=_a27.getUniqueID(_a2a);
_a26(_a27,_a29,_a2a);
}
}
};
var _a2b=function(node,_a2c){
if(!node){
return undefined;
}
_a2c=_a2c||{};
var data={};
data.properties={};
for(var i=0;i<node.attributes.length;i++){
var a=node.attributes[i];
if(!a.specified||!a.nodeValue){
continue;
}
var n=a.nodeName.toLowerCase();
if(n=="id"||n=="widgetid"||n=="style"){
continue;
}else{
if(n.charAt(0)=="_"){
continue;
}
}
var v=a.nodeValue;
if(v&&n=="class"){
v=v.replace("HtmlWidget","").trim();
if(!v){
continue;
}
}
data.properties[n]=v;
}
if(node.tagName.toLowerCase()=="script"){
data.children=(node.innerHTML||undefined);
}
return data;
};
var _a2d={_dojo:function(node){
var doc=node?(node.ownerDocument||node):dojo.doc;
doc=doc||dojo.doc;
var win=_a24.get(doc);
return win.dojo||dojo;
},_dijit:function(node){
var doc=node?(node.ownerDocument||node):dojo.doc;
var win=_a24.get(doc);
return win.dijit||dijit;
},parseStyleValues:function(text){
var _a2e=[];
if(text){
dojo.forEach(text.split(";"),function(s){
var i=s.indexOf(":");
if(i>0){
var n=s.substring(0,i).trim();
var v=s.substring(i+1).trim();
var o={};
o[n]=v;
_a2e.push(o);
}
});
}
return _a2e;
},retrieveStyleProperty:function(_a2f,_a30,_a31){
var _a32=_a31;
if(_a2f){
dojo.some(_a2f,function(o){
if(o.hasOwnProperty(_a30)){
_a32=o[_a30];
return true;
}
});
}
return _a32;
},setStyleProperty:function(_a33,_a34,_a35){
var _a36=false;
if(_a33){
dojo.some(_a33,function(o){
if(o.hasOwnProperty(_a34)){
o[_a34]=_a35;
_a36=true;
return true;
}
});
}
if(!_a36){
var o={};
o[_a34]=_a35;
_a33.push(o);
}
},getStyleString:function(_a37){
var _a38="";
dojo.forEach(_a37,function(_a39){
for(var p in _a39){
if(_a39[p]){
_a38=_a38+p+":"+_a39[p]+";";
}
}
});
return _a38;
},getEnclosingWidget:function(node){
var _a3a=_a2d.getEnclosingWidgetForRichText(node);
if(_a3a){
return _a3a;
}
var enc=node;
while(enc){
if(enc._dvWidget){
return enc._dvWidget;
}
enc=enc.parentNode||(enc.domNode&&enc.domNode.parentNode);
}
},getEnclosingWidgetForRichText:function(node){
if(!node||!node._dvWidget){
return;
}
if(node._dvWidget.type==="html.stickynote"||node._dvWidget.type==="html.richtext"){
return node._dvWidget;
}else{
if(node.parentNode){
return _a2d.getEnclosingWidgetForRichText(node.parentNode);
}else{
return null;
}
}
},getUniqueObjectId:function(type,node){
if(!type){
return undefined;
}
var base=type.substring((type.lastIndexOf("/")||type.lastIndexOf("."))+1);
var i=1;
var id=base+"_"+i++;
var dj=_a2d._dojo(node);
while(dj.getObject(id)||dj.byId(id)){
id=base+"_"+i++;
}
return id;
},_remove_prefix:function(str){
var _a3b=str;
var _a3c=["dijit/form/","dijit/layout/","dijit/","dojox/mobile/","html.","html/","OpenAjax.","OpenAjax/"];
for(var i=0;i<_a3c.length;i++){
if(str.indexOf(_a3c[i])==0){
_a3b=str.substr(_a3c[i].length);
if(_a3c[i]=="html."){
_a3b="&lt;"+_a3b+"&gt;";
}
break;
}
}
return _a3b;
},_getWidgetNameText:function(type){
var text="<span class='propertiesTitleWidgetName'>";
text+=this._remove_prefix(type);
text+="</span> ";
return text;
},_getWidgetClassText:function(id,_a3d){
var text="<span class='propertiesTitleClassName'>";
if(id){
text+="#"+id;
}
if(_a3d){
text+="."+_a3d.replace(/\s+/g,".");
}
text+="</span> ";
return text;
},getLabelForNode:function(node){
var type=node.getAttribute("data-dojo-type")||node.getAttribute("dojoType");
if(!type){
type=node.tagName.toLowerCase();
}
type=type.replace(/\./g,"/");
var text=this._getWidgetNameText(type);
if(node.id){
text+=this._getWidgetClassText(node.id);
}
return text;
},getLabel:function(_a3e){
var text=this._getWidgetNameText(_a3e.type);
var _a3f,_a40=_a2d.getWidgetHelper(_a3e.type);
if(_a40&&_a40.getWidgetText){
_a3f=_a40.getWidgetText(_a3e);
}
var _a41=_a3e.domNode;
switch(_a3e.type.replace(/\//g,".")){
case "dijit.form.ComboBox":
case "dijit.form.Button":
_a3f=_a3e.attr("label");
break;
case "dijit.layout.ContentPane":
_a3f=_a3e.attr("title");
break;
case "html.label":
_a3f=_a41.innerHTML;
break;
case "html.img":
_a3f=_a41.alt;
if(!_a3f){
_a3f=_a41.title;
}
}
if(_a3f){
text+="<span class='propertiesTitleWidgetText'>"+_a3f+"</span> ";
}
if(_a40&&_a40.getWidgetDescriptor){
text+=" <span class='propertiesTitleWidgetDescriptor'>"+_a40.getWidgetDescriptor(_a3e)+"</span> ";
}
var _a42=_a3e._srcElement;
var id=_a3e.getId();
var _a43=_a42&&_a42.getAttribute("class");
var _a44=_a43&&_a43.trim();
if(id||_a44){
text+=this._getWidgetClassText(id,_a44);
}
if(_a40&&_a40.getWidgetTextExtra){
text+=_a40.getWidgetTextExtra(_a3e);
}
if(_a3e.type=="html.img"){
text+="<span>"+_a41.src.substr(_a41.src.lastIndexOf("/")+1)+"</span>";
}
return text;
},byId:function(id,doc){
var node=dojo.byId(id,doc&&doc.body?doc:undefined);
if(node){
if(node._dvWidget){
return node._dvWidget;
}
var _a45=_a2d.getEnclosingWidget(node);
if(_a45.id==id){
return _a45;
}
}
if(_a1d.currentEditor&&_a1d.currentEditor.currentEditor&&_a1d.currentEditor.currentEditor.context){
var _a46=_a1d.currentEditor.currentEditor.context;
return _a46.widgetHash[id];
}
return undefined;
},byNode:function(node){
if(node._dvWidget){
return node._dvWidget;
}
},createWidget:function(_a47){
if(!_a47||!_a47.type){
return undefined;
}
var data=dojo.mixin({},_a47);
if(data.properties){
data.properties=dojo.mixin({},_a47.properties);
}
var type=data.type,c,_a48,_a49,md=_a1e.query(type);
if(!md){
return undefined;
}
if(data.properties){
if("content" in data.properties&&!data.properties.content){
delete data.properties.content;
}
if(data.properties.theme){
_a48=data.properties.theme.themeName;
}
}
var _a4a=_a1e.queryDescriptor(type,"widgetClass");
var _a4b;
if(_a4a=="object"){
_a49=type;
_a4b=_a23;
md.attributes=md.attributes||{};
md.attributes.dojoType=_a49;
}else{
if(_a4a=="html"){
_a4b=_a22;
}else{
if(_a4a=="dijit"){
_a4b=_a20;
}else{
_a4b=_a21;
}
}
}
if(!_a4b){
return undefined;
}
c=_a4b;
var _a4c=md.content.trim().replace(/\s+/g," ");
var node=_a24.get(dojo.doc).dojo._toDom(_a4c);
if(node.nodeType===11){
var _a4d=0,n=null,_a4e=node.childNodes;
for(var i=0;i<_a4e.length;i++){
if(_a4e[i].nodeType!==8){
_a4d++;
n=_a4e[i];
if(_a4d>1){
break;
}
}
}
if(_a4d>1){
console.error("ERROR: complex widget content not supported");
return;
}
node=n;
}
var _a4f=new _a1c(node.tagName.toLowerCase());
if(node.hasAttributes()){
var _a50=node.attributes;
for(var j=_a50.length-1;j>=0;--j){
_a4f.addAttribute(_a50[j].name,_a50[j].value);
}
}
if(node.innerHTML){
_a4f.addText(node.innerHTML);
}
var _a51=_a1e.queryDescriptor(type,"requiresId"),name=_a1e.queryDescriptor(type,"name"),_a52=_a51&&name.match(/^[A-Za-z]\w*$/)?name:undefined;
node.id=(data.properties&&data.properties.id)||data.context.getUniqueID(_a4f,_a52);
var _a4e=data.children;
if(_a4e){
if(dojo.isString(_a4e)){
node.innerHTML=_a4e;
var _a53=node.nodeName.toLowerCase();
var _a54=_a4f._getAttribute("id");
_a4f.addText(_a4e);
var _a55=_a4f.getText(data.context);
_a4f.children=[];
_a4f.setText(_a55);
if(_a54){
_a4f.addAttribute(_a54.name,_a54.value,_a54.noPersist);
}
_a26(data.context,node,_a4f);
}else{
dojo.forEach(_a4e,function(c){
if(!c){
return;
}
if(dojo.isString(c)){
if(c.length>7&&c.substring(0,4)=="<!--"&&c.substring(c.length-3)=="-->"){
node.appendChild(dojo.doc.createComment(c.substring(4,c.length-3)));
_a4f.addComment(c.substring(4,c.length-3));
}else{
node.appendChild(dojo.doc.createTextNode(c));
_a4f.addText(c);
}
}else{
c.context=data.context;
var _a56=_a2d.createWidget(c);
if(_a56){
node.appendChild(_a56.domNode);
_a4f.addChild(_a56._srcElement);
}
}
});
}
}
var _a57=_a2d.getWidgetHelper(type);
if(_a57&&_a57.preProcessData){
data=_a57.preProcessData(data);
}
var _a58={};
var _a59={};
for(var p in data.properties){
var _a5a=data.properties[p];
if(_a5a!=null){
if(p.substr(0,2).toLowerCase()!="on"&&!(_a4f.tag.toLowerCase()=="a"&&p.toLowerCase()=="href")){
_a58[p]=_a5a;
}else{
_a59[p]=_a5a;
}
}
}
var _a5b=new c(_a58,node,type,md,_a4f,type);
_a5b._srcElement=_a4f;
if(_a5b.chart&&(data.properties&&data.properties.theme)){
_a5b.chart.theme.themeName=_a48;
}
if(data.scripts){
_a5b.scripts=data.scripts;
}
if(data.context){
_a5b._edit_context=data.context;
}
if(data.properties){
_a5b.setProperties(_a58);
_a5b.setProperties(_a59,true);
}
if(data.maqAppStates||data.maqDeltas){
if(data.maqAppStates){
_a5b.domNode._maqAppStates=dojo.clone(data.maqAppStates);
}
if(data.maqDeltas){
_a5b.domNode._maqDeltas=dojo.clone(data.maqDeltas);
}
var obj=davinci.states.serialize(_a5b.domNode);
if(obj.maqAppStates){
_a5b._srcElement.addAttribute(davinci.states.APPSTATES_ATTRIBUTE,obj.maqAppStates);
}
if(obj.maqDeltas){
_a5b._srcElement.addAttribute(davinci.states.DELTAS_ATTRIBUTE,obj.maqDeltas);
}
}
var _a57=_a2d.getWidgetHelper(type);
if(_a57&&_a57.cleanSrcElement){
_a57.cleanSrcElement(_a5b._srcElement);
}
if(_a57&&_a57.postCreateWidget){
_a57.postCreateWidget(_a5b);
}
return _a5b;
},_createSrcElement:function(node){
var _a5c=new _a1c(node.tagName.toLowerCase());
if(node.hasAttributes()){
var _a5d=node.attributes;
for(var j=_a5d.length-1;j>=0;--j){
_a5c.addAttribute(_a5d[j].name,_a5d[j].value);
}
}
return _a5c;
},getWidgetHelper:function(type){
return _a25[type];
},requireWidgetHelper:function(type){
var d=new _a1f();
_a1e.getHelper(type,"helper").then(function(_a5e){
if(_a5e){
d.resolve(_a25[type]=new _a5e());
}else{
d.resolve();
}
});
return d;
},getWidget:function(node){
if(!node||node.nodeType!=1){
return undefined;
}
var _a5f=_a2d.byNode(node);
if(!_a5f){
var ctor;
var data=_a2b(node);
var _a60=node.getAttribute("dvwidget");
if(node.hasAttribute("widgetid")||node.hasAttribute("data-dojo-type")||node.hasAttribute("dojotype")){
var d=_a2d._dijit(node);
var w=d.byNode(node);
var _a61=node.getAttribute("data-dojo-type")||node.getAttribute("dojotype");
if(w){
_a5f=new _a20(data,node,w,null,null,_a61);
}else{
_a5f=new _a23(data,node);
}
}else{
if(_a60){
_a5f=new _a21(data,node,_a60);
}else{
if(node.nodeName=="svg"){
return undefined;
}
_a5f=new _a22(data,node);
}
}
}
return _a5f;
}};
dojo.setObject("davinci.ve.widget",_a2d);
return _a2d;
});
},"davinci/actions/Action":function(){
define(["dojo/_base/declare"],function(_a62){
return _a62("davinci.actions.Action",null,{item:null,run:function(_a63){
},isEnabled:function(_a64){
return true;
},getName:function(){
return this.item.label;
}});
});
},"davinci/ve/commands/StyleCommand":function(){
define(["dojo/_base/declare","davinci/ve/widget","davinci/ve/utils/StyleArray"],function(_a65,_a66,_a67){
return _a65("davinci.ve.commands.StyleCommand",null,{name:"style",constructor:function(_a68,_a69,_a6a){
this._newValues=_a69;
this._id=_a68?_a68.id:undefined;
this._applyToStateIndex=(!_a6a||_a6a=="Normal"||_a6a=="undefined")?"undefined":_a6a;
},add:function(_a6b){
if(!_a6b||_a6b._id!=this._id){
return;
}
if(_a6b._newValues){
dojo.mixin(this._newValues,_a6b._newValues);
}
},execute:function(){
if(!this._id||!this._newValues){
return;
}
var _a6c=require("davinci/ve/widget").byId(this._id);
if(!_a6c||!_a6c.domNode){
return;
}
var _a6d=require("davinci/ve/States");
var _a6e=_a6c.getStyleValuesAllStates();
this._oldStyleValuesAllStates=dojo.clone(_a6e);
if(_a6e[this._applyToStateIndex]){
_a6e[this._applyToStateIndex]=_a67.mergeStyleArrays(_a6e[this._applyToStateIndex],this._newValues);
}else{
_a6e[this._applyToStateIndex]=this._newValues;
}
var _a6f=_a6e[this._applyToStateIndex];
for(var i=_a6f.length-1;i>=0;i--){
var obj=_a6f[i];
var _a70=false;
for(var prop in obj){
var _a71=obj[prop];
if(_a71=="$MAQ_DELETE_PROPERTY$"){
delete obj[prop];
}else{
_a70=true;
}
}
if(!_a70){
_a6f.splice(i,1);
}
}
_a6c.setStyleValuesAllStates(_a6e);
var _a72=_a6d.getStatesListCurrent(_a6c.domNode);
var _a73=_a67.mergeStyleArrays([],_a6e["undefined"]);
for(var i=0;i<_a72.length;i++){
if(_a6e[_a72[i]]){
_a73=_a67.mergeStyleArrays(_a73,_a6e[_a72[i]]);
}
}
_a6c.setStyleValuesCanvas(_a73);
_a6c.setStyleValuesModel(_a6e["undefined"]);
_a6c.refresh();
_a6d.resetState(_a6c.domNode);
dojo.publish("/davinci/ui/widgetPropertiesChanged",[[_a6c]]);
},undo:function(){
if(!this._id||!this._oldStyleValuesAllStates){
return;
}
var _a74=require("davinci/ve/widget").byId(this._id);
if(!_a74){
return;
}
var _a75=require("davinci/ve/States");
var _a76=this._oldStyleValuesAllStates;
var _a77=this._applyToStateIndex;
_a74.setStyleValuesAllStates(_a76);
var _a78=_a67.mergeStyleArrays(_a76["undefined"],_a76[_a77]);
_a74.setStyleValuesCanvas(_a78);
_a74.setStyleValuesModel(this._oldStyleValuesAllStates["undefined"]);
_a74.refresh();
require("davinci/ve/States").resetState(_a74.domNode);
dojo.publish("/davinci/ui/widgetPropertiesChanged",[[_a74]]);
}});
});
},"dojox/main":function(){
define(["dojo/_base/kernel"],function(dojo){
return dojo.dojox;
});
},"url:davinci/ui/templates/ThemeSetsDialog.html":"<div>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<table style=\"width: 90%\">\n\t\t\t<tr>\n\t\t\t\t\t<td style=\"width:40%; vertical-align: top;\">\n\t\t\t\t\t\t\t<table> \n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td style=\" vertical-align: top;\" >\n\t\t\t\t\t\t\t\t\t\t\t\t\t<label>${uiNLS.themeSets}</label><select  id=\"theme_select_themeset_theme_select\" name=\"theme_select_themeset_theme_select\" size=\"10\" style=\"margin-bottom: 5px; width: 190px;\" ></select>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<div id=\"toolbar1\" data-dojo-type=\"dijit.Toolbar\" class=\"toolbaredContainer_toolbarDiv davinciToolbar\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<div data-dojo-type=\"dijit.form.Button\" id=\"theme_select_themeset_add\" data-dojo-props=\"iconClass:'viewActionIcon addThemeSetIcon', showLabel:false \">${uiNLS.addThemeSet}</div>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<span data-dojo-type=\"dijit.ToolbarSeparator\"></span>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<div data-dojo-type=\"dijit.form.Button\" id=\"theme_select_themeset_delete\" data-dojo-props=\"iconClass:'viewActionIcon removeThemeSetIcon', showLabel:false \">${uiNLS.deleteThemeSet}</div>\n\t\t\t\t\t\t\t\t\t\t\t\t\t </div>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t\t<td><div style=\"border-right: 1px solid #ccc; width: 1px; height: 250px; margin-left: 10px; margin-top: 10px;\"></div></td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td></td><td></td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t</td>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t\t<table style=\"width: 100%; margin-left:10px; margin-right:10px;\">\n\t\t\t\t\t\t\t\t\t<tr><td colspan=\"2\">${uiNLS.currentlySelectedThemeSet}</td><tr>\n\t\t\t\t\t\t\t\t\t<tr><td style=\"width: 18%;\">${uiNLS.themeSetName}</td><td style=\"text-align: center;\"><input dojoType=\"dijit.form.TextBox\" id=\"theme_select_themeset_theme_select_textbox\" readonly= \"true\" style=\"width: 175px;\" ></input><input type=\"button\" dojoType=\"dijit.form.Button\" id=\"theme_select_rename_button\" label=\"Rename\" style=\"margin-left: 5px;\"></td></tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t<div style=\"border-top: 1px solid; top: 231px; border-top-color: #ccc; left: 429px; width: 300px; height: 11px; margin-top: 6px; margin-left:10px;\"></div>\n\t\t\t\t\t\t\t<table style=\"margin-left: 15px; width: 100%;\">\n\t\t\t\t\t\t\t\t\t<tr><td style=\"width: 139px;\">${uiNLS.desktopTheme}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_desktop_theme_select\"type=\"text\"  style=\"width: 175px;\"  ></select></td></tr>\n\t\t\t\t\t\t\t\t\t<tr><td>${uiNLS.mobileTheme}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_mobile_theme_select\"type=\"text\"  style=\"width: 175px;\" ></select></td></tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t<table id=\"theme_select_devices_table\" style=\"margin-left:30px; border-collapse: separate; border-spacing: 0 0; width: 100%\">\n\t\t\t\t\t\t\t<tr><td style=\"width: 129px;\">${uiNLS.android}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_android_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>\n\t\t\t\t\t\t\t<tr><td>${uiNLS.blackberry}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_blackberry_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>\n\t\t\t\t\t\t\t<tr><td>${uiNLS.ipad}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_ipad_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>\n\t\t\t\t\t\t\t<tr><td>${uiNLS.iphone}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_iphone_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>\n\t\t\t\t\t\t\t<tr><td>${uiNLS.other}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_other_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>\n\t\t\t\t\t\t\t</table>\n\t\t\n\t\t\t\t\t </td>\n\t\t\t </tr>\n\t\t</table>\n\t</div>\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button dojoType=\"dijit.form.Button\" id=\"theme_select_ok_button\" label=\"${uiNLS.save}\" class=\"maqPrimaryButton\" type=\"submit\"></button>\n\t\t<button dojoType=\"dijit.form.Button\" id=\"theme_select_cancel_button\" label=\"${commonNLS.buttonCancel}\" class=\"maqSecondaryButton\"></button>\n\t</div>\n</div>\n","url:dijit/templates/MenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon dijitMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">\n\t\t<div data-dojo-attach-point=\"arrowWrapper\" style=\"visibility: hidden\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuExpand\"/>\n\t\t\t<span class=\"dijitMenuExpandA11y\">+</span>\n\t\t</div>\n\t</td>\n</tr>\n","url:dijit/form/templates/CheckBox.html":"<div class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><input\n\t \t${!nameAttrSetting} type=\"${type}\" role=\"${type}\" aria-checked=\"false\" ${checkedAttrSetting}\n\t\tclass=\"dijitReset dijitCheckBoxInput\"\n\t\tdata-dojo-attach-point=\"focusNode\"\n\t \tdata-dojo-attach-event=\"onclick:_onClick\"\n/></div>\n","davinci/review/actions/EditVersionAction":function(){
define(["dojo/_base/declare","./_ReviewNavigatorCommon","./PublishAction","../../Runtime","dojox/widget/Toaster","dojo/i18n!./nls/actions"],function(_a79,_a7a,_a7b,_a7c,_a7d,nls){
return _a79("davinci.review.actions.EditVersionAction",[_a7a],{run:function(_a7e){
var _a7f=this._getSelection(_a7e);
if(!_a7f||!_a7f.length){
return;
}
var item=_a7f[0].resource.elementType=="ReviewFile"?_a7f[0].resource.parent:_a7f[0].resource;
var _a80=new _a7b(item);
_a80.run();
},isEnabled:function(_a81){
var _a82=this._getSelection(_a81);
if(_a82&&_a82.length>0){
var item=_a82[0].resource.elementType=="ReviewFile"?_a82[0].resource.parent:_a82[0].resource;
if(item.designerId==_a7c.userName){
return true;
}
}
return false;
}});
});
},"davinci/review/model/resource/File":function(){
define(["dojo/_base/declare","davinci/Runtime","davinci/model/resource/File","davinci/model/Path","dojo/Deferred"],function(_a83,_a84,File,Path,_a85){
return _a83("davinci.review.model.resource.File",File,{constructor:function(name,_a86){
this.elementType="ReviewFile";
this.name=name;
this.parent=_a86;
this.extension="rev";
},getLabel:function(){
var path=new Path(this.name);
var _a87=path.getSegments();
var _a88=_a84.getExtension("davinci.editor",function(_a89){
return _a89.id==="davinci.review.CommentReviewEditor";
});
var _a8a="."+_a88.extensions;
return label=_a87[_a87.length-1]+_a8a;
},getContentSync:function(){
return "";
},getContent:function(){
return new _a85().resolve("");
},removeWorkingCopy:function(){
return;
}});
});
},"davinci/commands/CommandStack":function(){
define(["dojo/_base/declare"],function(_a8b){
return _a8b("davinci.commands.CommandStack",null,{constructor:function(_a8c){
this._context=_a8c;
this._undoStack=[];
this._redoStack=[];
},execute:function(_a8d){
if(!_a8d){
return;
}
var _a8e;
if(this._context&&this._context.declaredClass!="davinci.ve.themeEditor.Context"){
_a8e=dojo.withDoc(this._context.getDocument(),"execute",_a8d,[this._context]);
}else{
_a8e=_a8d.execute();
}
this._undoStack.push(_a8d);
this._redoStack=[];
if(!_a8e){
this.onExecute(_a8d,"execute");
}
},undo:function(){
if(!this.canUndo()){
return;
}
var _a8f=this._undoStack.pop();
if(_a8f._runDelegate){
_a8f._runDelegate.undoDelegate(_a8f);
}else{
if(this._context&&this._context.declaredClass!="davinci.ve.themeEditor.Context"){
dojo.withDoc(this._context.getDocument(),"undo",_a8f);
}else{
_a8f.undo();
}
}
this._redoStack.push(_a8f);
this.onExecute(_a8f,"undo");
},redo:function(){
if(!this.canRedo()){
return;
}
var _a90=this._redoStack.pop();
if(_a90._runDelegate){
_a90._runDelegate.redoDelegate(_a90);
}else{
if(this._context&&this._context.declaredClass!="davinci.ve.themeEditor.Context"){
dojo.withDoc(this._context.getDocument(),"execute",_a90);
}else{
_a90.execute();
}
}
this._undoStack.push(_a90);
this.onExecute(_a90,"redo");
},canUndo:function(){
return this._undoStack.length>0;
},canRedo:function(){
return this._redoStack.length>0;
},getUndoCount:function(){
return this._undoStack.length;
},getRedoCount:function(){
return this._redoStack.length;
},clear:function(){
this._undoStack=[];
this._redoStack=[];
},jump:function(_a91,_a92){
var _a93=this.getUndoCount();
var _a94=this.getRedoCount();
if(_a91==_a93){
return _a91;
}
if(_a91<0||_a91>_a93+_a94){
return -1;
}
var n=_a91-_a93;
if(_a92){
if(n<0){
while(n<0){
this._redoStack.push(this._undoStack.pop());
n++;
}
}else{
while(n>0){
this._undoStack.push(this._redoStack.pop());
n--;
}
}
}else{
if(n<0){
while(n<0){
this.undo();
n++;
}
}else{
while(n>0){
this.redo();
n--;
}
}
}
return _a91;
},onExecute:function(_a95,_a96){
},undoDelegate:function(_a97){
},redoDelegate:function(_a98){
}});
});
},"davinci/ui/ThemeSetsDialog":function(){
define(["dojo/_base/declare","davinci/ui/Dialog","dijit/_Widget","dijit/_Templated","davinci/workbench/Preferences","davinci/Workbench","davinci/library","dojo/text!./templates/ThemeSetsDialog.html","dojo/text!./templates/ThemeSetsRenameDialog.html","dojo/i18n!davinci/ui/nls/ui","dojo/i18n!dijit/nls/common","davinci/Theme","dijit/form/ValidationTextBox","dijit/form/Button","dijit/Toolbar"],function(_a99,_a9a,_a9b,_a9c,_a9d,_a9e,_a9f,_aa0,_aa1,_aa2,_aa3,_aa4){
_a99("davinci.ui.ThemeSetsDialogWidget",[_a9b,_a9c],{templateString:_aa0,widgetsInTemplate:true,uiNLS:_aa2,commonNLS:_aa3});
_a99("davinci.ui.ThemeSetsDialogRenameWidget",[_a9b,_a9c],{templateString:_aa1,widgetsInTemplate:true,uiNLS:_aa2,commonNLS:_aa3});
return dojo.declare("davinci.ui.ThemeSetsDialog",null,{constructor:function(){
this._connections=[];
this._dialog=new _a9a({id:"manageThemeSets",title:_aa2.themeSetsDialog,contentStyle:{width:580}});
dojo.connect(this._dialog,"onCancel",this,"onClose");
this._dojoThemeSets=_aa4.getThemeSets(_a9e.getProject());
if(!this._dojoThemeSets){
this._dojoThemeSets=_aa4.dojoThemeSets;
_aa4.saveThemeSets(_a9e.getProject(),this._dojoThemeSets);
}
if(!this._dojoThemeSets.themeSets[0]){
this._dojoThemeSets.themeSets.push(dojo.clone(_aa4.custom_themeset));
_aa4.saveThemeSets(_a9e.getProject(),this._dojoThemeSets);
}
this._dojoThemeSets=dojo.clone(this._dojoThemeSets);
this._dialog.attr("content",new davinci.ui.ThemeSetsDialogWidget({}));
this._connections.push(dojo.connect(dojo.byId("theme_select_themeset_theme_select"),"onchange",this,"onChange"));
this._connections.push(dojo.connect(dijit.byId("theme_select_themeset_add"),"onClick",this,"addThemeSet"));
this._connections.push(dojo.connect(dijit.byId("theme_select_themeset_delete"),"onClick",this,"deleteThemeSet"));
this._connections.push(dojo.connect(dijit.byId("theme_select_rename_button"),"onClick",this,"renameThemeSet"));
this._connections.push(dojo.connect(dijit.byId("theme_select_desktop_theme_select"),"onChange",this,"onDesktopChange"));
this._connections.push(dojo.connect(dijit.byId("theme_select_mobile_theme_select"),"onChange",this,"onMobileChange"));
this._connections.push(dojo.connect(dijit.byId("theme_select_ok_button"),"_onSubmit",this,"onOk"));
this._connections.push(dojo.connect(dijit.byId("theme_select_cancel_button"),"onClick",this,"onClose"));
this._connections.push(dojo.connect(dijit.byId("theme_select_android_select"),"onChange",this,"onAndroidThemeChange"));
this._connections.push(dojo.connect(dijit.byId("theme_select_blackberry_select"),"onChange",this,"onBlackberryThemeChange"));
this._connections.push(dojo.connect(dijit.byId("theme_select_ipad_select"),"onChange",this,"oniPadThemeChange"));
this._connections.push(dojo.connect(dijit.byId("theme_select_iphone_select"),"onChange",this,"oniPhoneThemeChange"));
this._connections.push(dojo.connect(dijit.byId("theme_select_other_select"),"onChange",this,"onOtherThemeChange"));
this.addThemeSets();
this._selectedThemeSet=this._dojoThemeSets.themeSets[0];
dijit.byId("theme_select_themeset_theme_select_textbox").attr("value",this._selectedThemeSet.name);
this.addThemes(this._selectedThemeSet);
this._dialog.show();
},addThemeSets:function(){
var _aa5=dojo.byId("theme_select_themeset_theme_select");
for(var i=0;i<this._dojoThemeSets.themeSets.length;i++){
var c=dojo.doc.createElement("option");
c.innerHTML=this._dojoThemeSets.themeSets[i].name;
c.value=this._dojoThemeSets.themeSets[i].name;
if(i===0){
c.selected="1";
}
_aa5.appendChild(c);
}
},addThemes:function(_aa6){
this._themeData=_a9f.getThemes(_a9e.getProject(),this.workspaceOnly);
var _aa7=dijit.byId("theme_select_desktop_theme_select");
_aa7.options=[];
var _aa8=dijit.byId("theme_select_android_select");
_aa8.options=[];
var _aa9=dijit.byId("theme_select_blackberry_select");
_aa9.options=[];
var _aaa=dijit.byId("theme_select_ipad_select");
_aaa.options=[];
var _aab=dijit.byId("theme_select_iphone_select");
_aab.options=[];
var _aac=dijit.byId("theme_select_other_select");
_aac.options=[];
var _aad=dijit.byId("theme_select_mobile_theme_select");
_aa7.options=[];
_aad.options=[];
_aad.addOption({value:_aa4.default_theme,label:_aa4.default_theme});
this._themeCount=this._themeData.length;
for(var i=0;i<this._themeData.length;i++){
var opt={value:this._themeData[i].name,label:this._themeData[i].name};
if(this._themeData[i].type==="dojox.mobile"){
_aad.addOption(opt);
_aa8.addOption(opt);
_aa9.addOption(opt);
_aaa.addOption(opt);
_aab.addOption(opt);
_aac.addOption(opt);
}else{
_aa7.addOption(opt);
}
}
_aa7.attr("value",_aa6.desktopTheme);
for(var d=0;d<_aa6.mobileTheme.length;d++){
var _aae=_aa6.mobileTheme[d].device.toLowerCase();
switch(_aae){
case "android":
_aa8.attr("value",_aa6.mobileTheme[d].theme);
break;
case "blackberry":
_aa9.attr("value",_aa6.mobileTheme[d].theme);
break;
case "ipad":
_aaa.attr("value",_aa6.mobileTheme[d].theme);
break;
case "iphone":
_aab.attr("value",_aa6.mobileTheme[d].theme);
break;
case "other":
_aac.attr("value",_aa6.mobileTheme[d].theme);
break;
}
}
if(_aa4.singleMobileTheme(_aa6)){
_aad.attr("value",_aa6.mobileTheme[_aa6.mobileTheme.length-1].theme);
}else{
_aad.attr("value",_aa4.default_theme);
this.onMobileChange(_aa4.default_theme);
}
},addThemeSet:function(e){
var _aaf;
if(this._selectedThemeSet){
_aaf=dojo.clone(this._selectedThemeSet);
}else{
_aaf=dojo.clone(_aa4.default_themeset);
}
var _ab0=_aaf.name;
var _ab1=0;
for(var n=0;n<this._dojoThemeSets.themeSets.length;n++){
if(this._dojoThemeSets.themeSets[n].name==_ab0){
_ab1++;
_ab0=_aaf.name+"_"+_ab1;
n=-1;
}
}
_aaf.name=_ab0;
this._dojoThemeSets.themeSets.push(_aaf);
var _ab2=dojo.byId("theme_select_themeset_theme_select");
var c=dojo.doc.createElement("option");
c.innerHTML=_aaf.name;
c.value=_aaf.name;
_ab2.appendChild(c);
},deleteThemeSet:function(e){
var _ab3=dojo.byId("theme_select_themeset_theme_select");
var node=_ab3[_ab3.selectedIndex];
if(!node){
return;
}
for(var n=0;n<this._dojoThemeSets.themeSets.length;n++){
if(this._dojoThemeSets.themeSets[n].name==node.value){
this._dojoThemeSets.themeSets.splice(n,1);
break;
}
}
this._selectedThemeSet=null;
_ab3.removeChild(node);
dijit.byId("theme_select_themeset_theme_select_textbox").attr("value","");
var _ab4=dijit.byId("theme_select_rename_button");
var _ab5=dijit.byId("theme_select_desktop_theme_select");
var _ab6=dijit.byId("theme_select_mobile_theme_select");
var _ab7=dijit.byId("theme_select_android_select");
var _ab8=dijit.byId("theme_select_blackberry_select");
var _ab9=dijit.byId("theme_select_ipad_select");
var _aba=dijit.byId("theme_select_iphone_select");
var _abb=dijit.byId("theme_select_other_select");
_ab4.set("disabled",true);
_ab5.set("disabled",true);
_ab6.set("disabled",true);
_ab7.set("disabled",true);
_ab8.set("disabled",true);
_ab9.set("disabled",true);
_aba.set("disabled",true);
_abb.set("disabled",true);
},renameThemeSet:function(e){
var _abc=_aa2;
var loc=_aa3;
var _abd=dojo.byId("theme_select_themeset_theme_select");
this._renameDialog=new _a9a({id:"rename",title:_abc.renameThemeSet,contentStyle:{width:300},content:new davinci.ui.ThemeSetsDialogRenameWidget({})});
this._renameDialog._themesetConnections=[];
this._renameDialog._themesetConnections.push(dojo.connect(dijit.byId("theme_set_rename_ok_button"),"onClick",this,"onOkRename"));
this._renameDialog._themesetConnections.push(dojo.connect(dijit.byId("theme_set_rename_cancel_button"),"onClick",this,"onCloseRename"));
this._renameDialog._themesetConnections.push(dojo.connect(this._renameDialog,"onCancel",this,"onCloseRename"));
this._renameDialog.show();
var _abe=dijit.byId("theme_select_themeset_rename_textbox");
_abe.attr("value",this._selectedThemeSet.name);
dijit.selectInputText(_abe);
},onOkRename:function(e){
var _abf=dijit.byId("theme_select_themeset_rename_textbox").attr("value");
if(_abf){
for(var n=0;n<this._dojoThemeSets.themeSets.length;n++){
if(this._dojoThemeSets.themeSets[n].name==_abf){
alert("Theme set name already use");
return;
}
}
var _ac0=dojo.byId("theme_select_themeset_theme_select");
var node=_ac0[_ac0.selectedIndex];
var _ac1=this._selectedThemeSet.name;
node.innerHTML=_abf;
node.value=_abf;
this._selectedThemeSet.name=_abf;
dijit.byId("theme_select_themeset_theme_select_textbox").attr("value",this._selectedThemeSet.name);
}
this.onCloseRename(e);
},onCloseRename:function(e){
while(connection=this._renameDialog._themesetConnections.pop()){
dojo.disconnect(connection);
}
this._renameDialog.destroyDescendants();
this._renameDialog.destroy();
delete this._renameDialog;
},onClick:function(e){
e.target.setAttribute("selected",false);
var _ac2=dojo.byId("theme_select_themeset_theme_select");
_ac2.setAttribute("value",this._selectedThemeSet.name);
},onChange:function(e){
var name=e.target[e.target.selectedIndex].value;
for(var i=0;i<this._dojoThemeSets.themeSets.length;i++){
if(this._dojoThemeSets.themeSets[i].name==name){
this._selectedThemeSet=this._dojoThemeSets.themeSets[i];
this.addThemes(this._dojoThemeSets.themeSets[i]);
dijit.byId("theme_select_themeset_theme_select_textbox").attr("value",this._selectedThemeSet.name);
var _ac3=dijit.byId("theme_select_rename_button");
var _ac4=dijit.byId("theme_select_desktop_theme_select");
var _ac5=dijit.byId("theme_select_mobile_theme_select");
_ac3.set("disabled",false);
_ac4.set("disabled",false);
_ac5.set("disabled",false);
break;
}
}
},onDesktopChange:function(e){
this._selectedThemeSet.desktopTheme=e;
},onMobileChange:function(e){
var _ac6=dijit.byId("theme_select_android_select");
var _ac7=dijit.byId("theme_select_blackberry_select");
var _ac8=dijit.byId("theme_select_ipad_select");
var _ac9=dijit.byId("theme_select_iphone_select");
var _aca=dijit.byId("theme_select_other_select");
function _acb(_acc,_acd,_ace){
switch(_acc){
case "android":
_ac6.attr("value",_acd);
_ac6.set("disabled",_ace);
break;
case "blackberry":
_ac7.attr("value",_acd);
_ac7.set("disabled",_ace);
break;
case "ipad":
_ac8.attr("value",_acd);
_ac8.set("disabled",_ace);
break;
case "iphone":
_ac9.attr("value",_acd);
_ac9.set("disabled",_ace);
break;
case "other":
_aca.attr("value",_acd);
_aca.set("disabled",_ace);
break;
}
};
if((e==="(device-specific)")){
for(var d=0;d<this._selectedThemeSet.mobileTheme.length;d++){
var _acf=this._selectedThemeSet.mobileTheme[d].device.toLowerCase();
_acb(_acf,this._selectedThemeSet.mobileTheme[d].theme,false);
}
}else{
for(var d=0;d<this._selectedThemeSet.mobileTheme.length;d++){
var _acf=this._selectedThemeSet.mobileTheme[d].device.toLowerCase();
this._selectedThemeSet.mobileTheme[d].theme=e;
_acb(_acf,this._selectedThemeSet.mobileTheme[d].theme,true);
}
}
},onDeviceThemeChange:function(_ad0,e){
for(var d=0;d<this._selectedThemeSet.mobileTheme.length;d++){
if(this._selectedThemeSet.mobileTheme[d].device.toLowerCase()===_ad0.toLowerCase()){
this._selectedThemeSet.mobileTheme[d].theme=e;
break;
}
}
},onAndroidThemeChange:function(e){
this.onDeviceThemeChange("android",e);
},onBlackberryThemeChange:function(e){
this.onDeviceThemeChange("blackberry",e);
},oniPadThemeChange:function(e){
this.onDeviceThemeChange("ipad",e);
},oniPhoneThemeChange:function(e){
this.onDeviceThemeChange("iphone",e);
},onOtherThemeChange:function(e){
this.onDeviceThemeChange("other",e);
},onOk:function(e){
_aa4.saveThemeSets(_a9e.getProject(),this._dojoThemeSets);
this.onClose(e);
},onClose:function(e){
while(connection=this._connections.pop()){
dojo.disconnect(connection);
}
this._dialog.destroyDescendants();
this._dialog.destroy();
delete this._dialog;
},onDeleteThemeSet:function(e){
for(var i=0;i<this._dojoThemeSets.themeSets.length;i++){
if(this._dojoThemeSets.themeSets[i].name===this._currentThemeSet.name){
var _ad1=this._dojoThemeSets.themeSets[i-1].name;
var cb=dijit.byId("theme_select");
cb.store.fetchItemByIdentity({identity:this._dojoThemeSets.themeSets[i].name,onItem:function(item){
cb.store.deleteItem(item);
cb.store.save();
}});
this._dojoThemeSets.themeSets.splice(i,1);
this._currentThemeSet=null;
cb.attr("value",_ad1);
break;
}
}
}});
});
},"davinci/ui/widgets/ThemeSelection":function(){
define(["dojo/_base/declare","dijit/_Widget","davinci/library","davinci/Runtime","davinci/Workbench","system/resource","dojo/i18n!davinci/ui/nls/ui","dojo/i18n!dijit/nls/common"],function(_ad2,_ad3,_ad4,_ad5,_ad6,_ad7,_ad8,_ad9){
return _ad2("davinci.ui.widgets.ThemeSelection",[_ad3],{workspaceOnly:true,message:"Theme version does not match workspace version this could produce unexpected results. We suggest recreating the custom theme using the current version of Maqetta and deleting the existing theme.",buildRendering:function(){
var div=dojo.doc.createElement("div");
this._select=dojo.doc.createElement("select");
div.appendChild(this._select);
this._warnDiv=dojo.doc.createElement("div");
div.appendChild(this._warnDiv);
this.domNode=div;
dojo.style(this._select,"width","180px");
dojo.style(this.domNode,"width","100%");
dojo.connect(this._select,"onchange",this,"_onChange");
},postCreate:function(){
this._themeData=_ad4.getThemes(_ad6.getProject(),this.workspaceOnly);
this._themeCount=this._themeData.length;
for(var i=0;i<this._themeData.length;i++){
var op=dojo.doc.createElement("option");
op.value=this._themeData[i].name;
op.text=this._themeData[i].name;
this._select.appendChild(op);
}
if(this._selection){
this._selectValue(this._selection);
}
},_setBaseAttr:function(base){
this._base=base;
},_getBaseAttr:function(){
return this._base;
},_getNumberOfThemesAttr:function(){
return this._themeCount;
},_setValueAttr:function(_ada){
if(!this._hasValue(_ada)){
return;
}
this._selection=_ada;
if(_ada&&_ada.name){
this._selection=_ada.name;
}
this._selectValue(this._selection);
},_hasValue:function(_adb){
for(var i=0;i<this._select.children.length;i++){
if(this._select.children[i].value==_adb){
return true;
}
}
return false;
},_selectValue:function(_adc){
var _add=false;
for(var i=0;i<this._select.children.length;i++){
if(this._select.children[i].selected){
this._select.children[i].selected=false;
}
if(!_add&&this._select.children[i].value==_adc){
this._select.children[i].selected=true;
var _add=true;
}
}
if(!_add&&_adc!=null){
var op=dojo.doc.createElement("option");
op.value=_adc;
op.text=_adc;
op.selected=true;
this._select.appendChild(op);
}
},_getValueAttr:function(){
var name=dojo.attr(this._select,"value");
for(var i=0;i<this._themeData.length;i++){
if(this._themeData[i]["name"]==name){
return this._themeData[i];
}
}
return null;
},_setWorkspaceOnlyAttr:function(_ade){
this.workspaceOnly=_ade;
},onChange:function(){
},_onChange:function(){
var _adf=this._getValueAttr();
if(_adf==null||this._blockChange){
return;
}
this.value=_adf;
this._cookieName="maqetta_"+_adf.name+"_"+_adf.version;
var _ae0=dojo.cookie(this._cookieName);
if(this.dojoVersion&&_adf.version!==this.dojoVersion&&!_ae0){
this._warnDiv.innerHTML="<table>"+"<tr><td></td><td>"+this.message+"</td><td></td></tr>"+"<tr><td></td><td align=\"center\"><button data-dojo-type=\"dijit.form.Button\" type=\"button\" id=\"davinci.ui.widgets.ThemeSelection.ok\">Ok</button><button data-dojo-type=\"dijit.form.Button\" type=\"button\" id=\"davinci.ui.widgets.ThemeSelection.cancel\">Cancel</button></td><td></td></tr>"+"</table>";
var ok=dijit.byId("davinci.ui.widgets.ThemeSelection.ok");
var _ae1=dijit.byId("davinci.ui.widgets.ThemeSelection.cancel");
dojo.connect(ok,"onClick",this,"_warnOk");
dojo.connect(_ae1,"onClick",this,"_warnCancel");
}else{
this.onChange();
}
},_getThemeDataAttr:function(){
return this._themeData;
},_warnOk:function(){
dojo.cookie(this._cookieName,"true");
this._destroy();
this.onChange();
},_warnCancel:function(){
this._destroy();
this.onClose();
},_destroy:function(){
var ok=dijit.byId("davinci.ui.widgets.ThemeSelection.ok");
dojo.disconnect(ok);
ok.destroy();
var _ae2=dijit.byId("davinci.ui.widgets.ThemeSelection.cancel");
dojo.disconnect(_ae2);
_ae2.destroy();
}});
});
},"dijit/Tooltip":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","./main"],function(_ae3,_ae4,fx,dom,_ae5,_ae6,_ae7,lang,_ae8,on,has,_ae9,_aea,_aeb,_aec,_aed,_aee,_aef){
var _af0=_ae4("dijit._MasterTooltip",[_aeb,_aec],{duration:_ae9.defaultDuration,templateString:_aee,postCreate:function(){
this.ownerDocumentBody.appendChild(this.domNode);
this.bgIframe=new _aed(this.domNode);
this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});
this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});
},show:function(_af1,_af2,_af3,rtl,_af4){
if(this.aroundNode&&this.aroundNode===_af2&&this.containerNode.innerHTML==_af1){
return;
}
if(this.fadeOut.status()=="playing"){
this._onDeck=arguments;
return;
}
this.containerNode.innerHTML=_af1;
if(_af4){
this.set("textDir",_af4);
}
this.containerNode.align=rtl?"right":"left";
var pos=_aea.around(this.domNode,_af2,_af3&&_af3.length?_af3:_af5.defaultPosition,!rtl,lang.hitch(this,"orient"));
var _af6=pos.aroundNodePos;
if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){
this.connectorNode.style.top=_af6.y+((_af6.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";
this.connectorNode.style.left="";
}else{
if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){
this.connectorNode.style.left=_af6.x+((_af6.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";
}else{
this.connectorNode.style.left="";
this.connectorNode.style.top="";
}
}
_ae7.set(this.domNode,"opacity",0);
this.fadeIn.play();
this.isShowingNow=true;
this.aroundNode=_af2;
},orient:function(node,_af7,_af8,_af9,_afa){
this.connectorNode.style.top="";
var _afb=_af9.h,_afc=_af9.w;
node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_af7+"-"+_af8];
this.domNode.style.width="auto";
var size=_ae6.position(this.domNode);
if(has("ie")==9){
size.w+=2;
}
var _afd=Math.min((Math.max(_afc,1)),size.w);
_ae6.setMarginBox(this.domNode,{w:_afd});
if(_af8.charAt(0)=="B"&&_af7.charAt(0)=="B"){
var bb=_ae6.position(node);
var _afe=this.connectorNode.offsetHeight;
if(bb.h>_afb){
var _aff=_afb-((_afa.h+_afe)>>1);
this.connectorNode.style.top=_aff+"px";
this.connectorNode.style.bottom="";
}else{
this.connectorNode.style.bottom=Math.min(Math.max(_afa.h/2-_afe/2,0),bb.h-_afe)+"px";
this.connectorNode.style.top="";
}
}else{
this.connectorNode.style.top="";
this.connectorNode.style.bottom="";
}
return Math.max(0,size.w-_afc);
},_onShow:function(){
if(has("ie")){
this.domNode.style.filter="";
}
},hide:function(_b00){
if(this._onDeck&&this._onDeck[1]==_b00){
this._onDeck=null;
}else{
if(this.aroundNode===_b00){
this.fadeIn.stop();
this.isShowingNow=false;
this.aroundNode=null;
this.fadeOut.play();
}else{
}
}
},_onHide:function(){
this.domNode.style.cssText="";
this.containerNode.innerHTML="";
if(this._onDeck){
this.show.apply(this,this._onDeck);
this._onDeck=null;
}
},_setAutoTextDir:function(node){
this.applyTextDir(node,has("ie")?node.outerText:node.textContent);
_ae3.forEach(node.children,function(_b01){
this._setAutoTextDir(_b01);
},this);
},_setTextDirAttr:function(_b02){
this._set("textDir",_b02);
if(_b02=="auto"){
this._setAutoTextDir(this.containerNode);
}else{
this.containerNode.dir=this.textDir;
}
}});
_aef.showTooltip=function(_b03,_b04,_b05,rtl,_b06){
if(_b05){
_b05=_ae3.map(_b05,function(val){
return {after:"after-centered",before:"before-centered"}[val]||val;
});
}
if(!_af5._masterTT){
_aef._masterTT=_af5._masterTT=new _af0();
}
return _af5._masterTT.show(_b03,_b04,_b05,rtl,_b06);
};
_aef.hideTooltip=function(_b07){
return _af5._masterTT&&_af5._masterTT.hide(_b07);
};
var _af5=_ae4("dijit.Tooltip",_aeb,{label:"",showDelay:400,connectId:[],position:[],selector:"",_setConnectIdAttr:function(_b08){
_ae3.forEach(this._connections||[],function(_b09){
_ae3.forEach(_b09,function(_b0a){
_b0a.remove();
});
},this);
this._connectIds=_ae3.filter(lang.isArrayLike(_b08)?_b08:(_b08?[_b08]:[]),function(id){
return dom.byId(id,this.ownerDocument);
},this);
this._connections=_ae3.map(this._connectIds,function(id){
var node=dom.byId(id,this.ownerDocument),_b0b=this.selector,_b0c=_b0b?function(_b0d){
return on.selector(_b0b,_b0d);
}:function(_b0e){
return _b0e;
},self=this;
return [on(node,_b0c(_ae8.enter),function(){
self._onHover(this);
}),on(node,_b0c("focusin"),function(){
self._onHover(this);
}),on(node,_b0c(_ae8.leave),lang.hitch(self,"_onUnHover")),on(node,_b0c("focusout"),lang.hitch(self,"_onUnHover"))];
},this);
this._set("connectId",_b08);
},addTarget:function(node){
var id=node.id||node;
if(_ae3.indexOf(this._connectIds,id)==-1){
this.set("connectId",this._connectIds.concat(id));
}
},removeTarget:function(node){
var id=node.id||node,idx=_ae3.indexOf(this._connectIds,id);
if(idx>=0){
this._connectIds.splice(idx,1);
this.set("connectId",this._connectIds);
}
},buildRendering:function(){
this.inherited(arguments);
_ae5.add(this.domNode,"dijitTooltipData");
},startup:function(){
this.inherited(arguments);
var ids=this.connectId;
_ae3.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);
},getContent:function(node){
return this.label||this.domNode.innerHTML;
},_onHover:function(_b0f){
if(!this._showTimer){
this._showTimer=this.defer(function(){
this.open(_b0f);
},this.showDelay);
}
},_onUnHover:function(){
if(this._showTimer){
this._showTimer.remove();
delete this._showTimer;
}
this.close();
},open:function(_b10){
if(this._showTimer){
this._showTimer.remove();
delete this._showTimer;
}
var _b11=this.getContent(_b10);
if(!_b11){
return;
}
_af5.show(_b11,_b10,this.position,!this.isLeftToRight(),this.textDir);
this._connectNode=_b10;
this.onShow(_b10,this.position);
},close:function(){
if(this._connectNode){
_af5.hide(this._connectNode);
delete this._connectNode;
this.onHide();
}
if(this._showTimer){
this._showTimer.remove();
delete this._showTimer;
}
},onShow:function(){
},onHide:function(){
},destroy:function(){
this.close();
_ae3.forEach(this._connections||[],function(_b12){
_ae3.forEach(_b12,function(_b13){
_b13.remove();
});
},this);
this.inherited(arguments);
}});
_af5._MasterTooltip=_af0;
_af5.show=_aef.showTooltip;
_af5.hide=_aef.hideTooltip;
_af5.defaultPosition=["after-centered","before-centered"];
return _af5;
});
},"url:dijit/templates/MenuSeparator.html":"<tr class=\"dijitMenuSeparator\">\n\t<td class=\"dijitMenuSeparatorIconCell\">\n\t\t<div class=\"dijitMenuSeparatorTop\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n\t<td colspan=\"3\" class=\"dijitMenuSeparatorLabelCell\">\n\t\t<div class=\"dijitMenuSeparatorTop dijitMenuSeparatorLabel\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n</tr>","davinci/review/actions/PublishAction":function(){
define(["dojo/_base/declare","davinci/actions/Action","davinci/review/widgets/PublishWizard","davinci/Runtime","dojox/widget/Toaster","davinci/ui/Dialog","dojo/i18n!./nls/actions"],function(_b14,_b15,_b16,_b17,_b18,_b19,_b1a){
var _b1b=_b14("davinci.review.actions.PublishAction",[_b15],{constructor:function(node,_b1c){
this.node=node;
this.isRestart=_b1c;
if(node&&node.isRestart){
this.isRestart=true;
}
},run:function(){
var _b1d=this.publishWizard=new _b16();
this.dialog=new _b19({contentStyle:{width:650,height:350},title:this.node?_b1a.editReview:_b1a.newReview,onCancel:dojo.hitch(this,this.close),onHide:dojo.hitch(this,this.hide)});
this.dialog.setContent(_b1d);
this.dialog.show();
dojo.connect(_b1d,"onClose",this,this.close);
_b1d.initData(this.node,this.isRestart).then(function(){
_b1d.updateSubmit();
_b1d.reviewerStackContainer.resize();
});
},hide:function(){
this.dialog.destroyRecursive();
},close:function(){
this.dialog.hide();
}});
return _b1b;
});
},"dijit/form/DropDownButton":function(){
define(["dojo/_base/declare","dojo/_base/lang","dojo/query","../registry","../popup","./Button","../_Container","../_HasDropDown","dojo/text!./templates/DropDownButton.html"],function(_b1e,lang,_b1f,_b20,_b21,_b22,_b23,_b24,_b25){
return _b1e("dijit.form.DropDownButton",[_b22,_b23,_b24],{baseClass:"dijitDropDownButton",templateString:_b25,_fillContent:function(){
if(this.srcNodeRef){
var _b26=_b1f("*",this.srcNodeRef);
this.inherited(arguments,[_b26[0]]);
this.dropDownContainer=this.srcNodeRef;
}
},startup:function(){
if(this._started){
return;
}
if(!this.dropDown&&this.dropDownContainer){
var _b27=_b1f("[widgetId]",this.dropDownContainer)[0];
this.dropDown=_b20.byNode(_b27);
delete this.dropDownContainer;
}
if(this.dropDown){
_b21.hide(this.dropDown);
}
this.inherited(arguments);
},isLoaded:function(){
var _b28=this.dropDown;
return (!!_b28&&(!_b28.href||_b28.isLoaded));
},loadDropDown:function(_b29){
var _b2a=this.dropDown;
var _b2b=_b2a.on("load",lang.hitch(this,function(){
_b2b.remove();
_b29();
}));
_b2a.refresh();
},isFocusable:function(){
return this.inherited(arguments)&&!this._mouseDown;
}});
});
},"dojox/grid/cells":function(){
define(["../main","./cells/_base"],function(_b2c){
return _b2c.grid.cells;
});
},"dojo/date":function(){
define(["./has","./_base/lang"],function(has,lang){
var date={};
date.getDaysInMonth=function(_b2d){
var _b2e=_b2d.getMonth();
var days=[31,28,31,30,31,30,31,31,30,31,30,31];
if(_b2e==1&&date.isLeapYear(_b2d)){
return 29;
}
return days[_b2e];
};
date.isLeapYear=function(_b2f){
var year=_b2f.getFullYear();
return !(year%400)||(!(year%4)&&!!(year%100));
};
date.getTimezoneName=function(_b30){
var str=_b30.toString();
var tz="";
var _b31;
var pos=str.indexOf("(");
if(pos>-1){
tz=str.substring(++pos,str.indexOf(")"));
}else{
var pat=/([A-Z\/]+) \d{4}$/;
if((_b31=str.match(pat))){
tz=_b31[1];
}else{
str=_b30.toLocaleString();
pat=/ ([A-Z\/]+)$/;
if((_b31=str.match(pat))){
tz=_b31[1];
}
}
}
return (tz=="AM"||tz=="PM")?"":tz;
};
date.compare=function(_b32,_b33,_b34){
_b32=new Date(+_b32);
_b33=new Date(+(_b33||new Date()));
if(_b34=="date"){
_b32.setHours(0,0,0,0);
_b33.setHours(0,0,0,0);
}else{
if(_b34=="time"){
_b32.setFullYear(0,0,0);
_b33.setFullYear(0,0,0);
}
}
if(_b32>_b33){
return 1;
}
if(_b32<_b33){
return -1;
}
return 0;
};
date.add=function(date,_b35,_b36){
var sum=new Date(+date);
var _b37=false;
var _b38="Date";
switch(_b35){
case "day":
break;
case "weekday":
var days,_b39;
var mod=_b36%5;
if(!mod){
days=(_b36>0)?5:-5;
_b39=(_b36>0)?((_b36-5)/5):((_b36+5)/5);
}else{
days=mod;
_b39=parseInt(_b36/5);
}
var strt=date.getDay();
var adj=0;
if(strt==6&&_b36>0){
adj=1;
}else{
if(strt==0&&_b36<0){
adj=-1;
}
}
var trgt=strt+days;
if(trgt==0||trgt==6){
adj=(_b36>0)?2:-2;
}
_b36=(7*_b39)+days+adj;
break;
case "year":
_b38="FullYear";
_b37=true;
break;
case "week":
_b36*=7;
break;
case "quarter":
_b36*=3;
case "month":
_b37=true;
_b38="Month";
break;
default:
_b38="UTC"+_b35.charAt(0).toUpperCase()+_b35.substring(1)+"s";
}
if(_b38){
sum["set"+_b38](sum["get"+_b38]()+_b36);
}
if(_b37&&(sum.getDate()<date.getDate())){
sum.setDate(0);
}
return sum;
};
date.difference=function(_b3a,_b3b,_b3c){
_b3b=_b3b||new Date();
_b3c=_b3c||"day";
var _b3d=_b3b.getFullYear()-_b3a.getFullYear();
var _b3e=1;
switch(_b3c){
case "quarter":
var m1=_b3a.getMonth();
var m2=_b3b.getMonth();
var q1=Math.floor(m1/3)+1;
var q2=Math.floor(m2/3)+1;
q2+=(_b3d*4);
_b3e=q2-q1;
break;
case "weekday":
var days=Math.round(date.difference(_b3a,_b3b,"day"));
var _b3f=parseInt(date.difference(_b3a,_b3b,"week"));
var mod=days%7;
if(mod==0){
days=_b3f*5;
}else{
var adj=0;
var aDay=_b3a.getDay();
var bDay=_b3b.getDay();
_b3f=parseInt(days/7);
mod=days%7;
var _b40=new Date(_b3a);
_b40.setDate(_b40.getDate()+(_b3f*7));
var _b41=_b40.getDay();
if(days>0){
switch(true){
case aDay==6:
adj=-1;
break;
case aDay==0:
adj=0;
break;
case bDay==6:
adj=-1;
break;
case bDay==0:
adj=-2;
break;
case (_b41+mod)>5:
adj=-2;
}
}else{
if(days<0){
switch(true){
case aDay==6:
adj=0;
break;
case aDay==0:
adj=1;
break;
case bDay==6:
adj=2;
break;
case bDay==0:
adj=1;
break;
case (_b41+mod)<0:
adj=2;
}
}
}
days+=adj;
days-=(_b3f*2);
}
_b3e=days;
break;
case "year":
_b3e=_b3d;
break;
case "month":
_b3e=(_b3b.getMonth()-_b3a.getMonth())+(_b3d*12);
break;
case "week":
_b3e=parseInt(date.difference(_b3a,_b3b,"day")/7);
break;
case "day":
_b3e/=24;
case "hour":
_b3e/=60;
case "minute":
_b3e/=60;
case "second":
_b3e/=1000;
case "millisecond":
_b3e*=_b3b.getTime()-_b3a.getTime();
}
return Math.round(_b3e);
};
1&&lang.mixin(lang.getObject("dojo.date",true),date);
return date;
});
},"davinci/review/review.plugin":function(){
define(["davinci/css!./resources/Comment.css"],function(){
return {id:"davinci.review","davinci.view":[{id:"comment",title:"Comments",viewClass:"davinci/review/view/CommentView",iconClass:"paletteIcon paletteIconComments"},{id:"reviewNavigator",title:"Reviews",viewClass:"davinci/review/view/CommentExplorerView",iconClass:"paletteIcon paletteIconReviews"},{id:"state",title:"States",viewClass:"davinci/ve/views/StatesView",iconClass:"paletteIcon paletteIconStates"}],"davinci.perspective":{id:"review",title:"Review",views:[{viewID:"davinci.ve.Palette",position:"left",hidden:true},{viewID:"davinci.ui.outline",position:"left",hidden:true},{viewID:"davinci.ve.style",position:"right"},{viewID:"davinci.ui.comment",position:"right",selected:true},{viewID:"davinci.ve.states",position:"right-bottom"},{viewID:"davinci.ui.navigator",position:"left-bottom"},{viewID:"davinci.review.reviewNavigator",position:"left",selected:true}]},"davinci.editor":[{id:"CommentReviewEditor",name:"Review Editor",extensions:"rev",isDefault:true,editorClass:"davinci/review/editor/ReviewEditor",editorClassName:"ReviewEditor",palettePerspective:"davinci.review.review",expandPalettes:["right"]}],"davinci.fileType":[{extension:"rev",iconClass:"reviewFileIcon",type:"text"}],"davinci.actionSets":[{id:"editorActionsReview",visible:true,actions:[{id:"newReview",action:"davinci/review/actions/PublishAction",iconClass:"newOpenMenuItem newReviewMenuItem",label:"Review...",menubarPath:"davinci.new/newTheme"}]},{id:"reviewExplorerActions",visible:true,actions:[{id:"davinci.review.view",label:"Open",action:"davinci/review/actions/ViewFileAction",menubarPath:"newfile"},{id:"davinci.review.edit",label:"Edit...",action:"davinci/review/actions/EditVersionAction",menubarPath:"newfile"},{id:"davinci.review.open",label:"Start",action:"davinci/review/actions/OpenVersionAction",menubarPath:"newfile"},{id:"davinci.review.close",label:"Stop...",action:"davinci/review/actions/CloseVersionAction",menubarPath:"newfile"},{id:"davinci.review.delete",label:"Delete...",action:"davinci/review/actions/DeleteVersionAction",menubarPath:"newfile",keyBinding:{charOrCode:[dojo.keys.DELETE,dojo.keys.BACKSPACE]}},{id:"davinci.review.restart",label:"Republish...",action:"davinci/review/actions/RestartVersionAction",menubarPath:"newfile"}]}],"davinci.actionSetPartAssociations":[{targetID:"davinci.review.editorActionsReview",parts:["davinci.ui.editorMenuBar"]},{targetID:"davinci.review.reviewExplorerActions",parts:["davinci.review.reviewNavigator"]}],"davinci.annotationActions":{editorContribution:{actions:[{id:"arrow",label:"Draw arrow",iconClass:"davinciAnnotationIcon davinciAnnotationIconArrow",action:"davinci/review/actions/ArrowAction",toolbarPath:"annotationtools"},{id:"rect",label:"Draw rectangle",iconClass:"davinciAnnotationIcon davinciAnnotationIconRect",action:"davinci/review/actions/RectAction",toolbarPath:"annotationtools"},{id:"ellipse",label:"Draw ellipse",iconClass:"davinciAnnotationIcon davinciAnnotationIconEllipse",action:"davinci/review/actions/EllipseAction",toolbarPath:"annotationtools"},{id:"textAnnotation",label:"Draw text",iconClass:"davinciAnnotationIcon davinciAnnotationIconText",action:"davinci/review/actions/TextAction",toolbarPath:"annotationtools"},{id:"deleteAnnotation",iconClass:"davinciAnnotationIcon davinciAnnotationIconDelete",label:"Delete Annotation",action:"davinci/review/actions/DeleteAnnotationAction",toolbarPath:"annotationtools_delete",keyBinding:{charOrCode:[dojo.keys.DELETE,dojo.keys.BACKSPACE]}}]}},"davinci.editorActions":{editorContribution:{targetID:"davinci.review.CommentReviewEditor",actions:[{id:"ReviewToolBarText",type:"davinci/review/widgets/ReviewToolBarText",toolbarPath:"ReviewToolBarText"}]}}};
});
},"davinci/ui/widgets/TransformTreeMixin":function(){
define("davinci/ui/widgets/TransformTreeMixin",["dijit/Tree"],function(tree){
var _b42=dijit.Tree.prototype.postCreate;
dijit.Tree.prototype.postCreate=function(){
var _b43=dijit.Tree.prototype._onItemChildrenChange;
dijit.Tree.prototype._onItemChildrenChange=function(_b44,_b45){
if(this.transforms){
this.transforms.forEach(function(_b46){
_b45=_b46(_b45);
});
}
_b43.apply(this,[_b44,_b45]);
};
var _b47=this.model.getChildren;
this.model.getChildren=dojo.hitch(this,function(_b48,_b49,_b4a){
var _b4b=_b49;
if(this.transforms){
_b4b=dojo.hitch(this,function(_b4c){
this.transforms.forEach(function(_b4d){
_b4c=_b4d(_b4c);
});
_b49(_b4c);
});
}
_b47.apply(this.model,[_b48,_b4b,_b4a]);
});
_b42.apply(this);
};
});
},"dojox/grid/_Layout":function(){
define(["dojo/_base/kernel","../main","dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/dom-geometry","./cells","./_RowSelector"],function(dojo,_b4e,_b4f,_b50,lang,_b51){
return _b4f("dojox.grid._Layout",null,{constructor:function(_b52){
this.grid=_b52;
},cells:[],structure:null,defaultWidth:"6em",moveColumn:function(_b53,_b54,_b55,_b56,_b57){
var _b58=this.structure[_b53].cells[0];
var _b59=this.structure[_b54].cells[0];
var cell=null;
var _b5a=0;
var _b5b=0;
for(var i=0,c;c=_b58[i];i++){
if(c.index==_b55){
_b5a=i;
break;
}
}
cell=_b58.splice(_b5a,1)[0];
cell.view=this.grid.views.views[_b54];
for(i=0,c=null;c=_b59[i];i++){
if(c.index==_b56){
_b5b=i;
break;
}
}
if(!_b57){
_b5b+=1;
}
_b59.splice(_b5b,0,cell);
var _b5c=this.grid.getCell(this.grid.getSortIndex());
if(_b5c){
_b5c._currentlySorted=this.grid.getSortAsc();
}
this.cells=[];
_b55=0;
var v;
for(i=0;v=this.structure[i];i++){
for(var j=0,cs;cs=v.cells[j];j++){
for(var k=0;c=cs[k];k++){
c.index=_b55;
this.cells.push(c);
if("_currentlySorted" in c){
var si=_b55+1;
si*=c._currentlySorted?1:-1;
this.grid.sortInfo=si;
delete c._currentlySorted;
}
_b55++;
}
}
}
_b50.forEach(this.cells,function(c){
var _b5d=c.markup[2].split(" ");
var _b5e=parseInt(_b5d[1].substring(5));
if(_b5e!=c.index){
_b5d[1]="idx=\""+c.index+"\"";
c.markup[2]=_b5d.join(" ");
}
});
this.grid.setupHeaderMenu();
},setColumnVisibility:function(_b5f,_b60){
var cell=this.cells[_b5f];
if(cell.hidden==_b60){
cell.hidden=!_b60;
var v=cell.view,w=v.viewWidth;
if(w&&w!="auto"){
v._togglingColumn=_b51.getMarginBox(cell.getHeaderNode()).w||0;
}
v.update();
return true;
}else{
return false;
}
},addCellDef:function(_b61,_b62,_b63){
var self=this;
var _b64=function(_b65){
var w=0;
if(_b65.colSpan>1){
w=0;
}else{
w=_b65.width||self._defaultCellProps.width||self.defaultWidth;
if(!isNaN(w)){
w=w+"em";
}
}
return w;
};
var _b66={grid:this.grid,subrow:_b61,layoutIndex:_b62,index:this.cells.length};
if(_b63&&_b63 instanceof _b4e.grid.cells._Base){
var _b67=lang.clone(_b63);
_b66.unitWidth=_b64(_b67._props);
_b67=lang.mixin(_b67,this._defaultCellProps,_b63._props,_b66);
return _b67;
}
var _b68=_b63.type||_b63.cellType||this._defaultCellProps.type||this._defaultCellProps.cellType||_b4e.grid.cells.Cell;
if(lang.isString(_b68)){
_b68=lang.getObject(_b68);
}
_b66.unitWidth=_b64(_b63);
return new _b68(lang.mixin({},this._defaultCellProps,_b63,_b66));
},addRowDef:function(_b69,_b6a){
var _b6b=[];
var _b6c=0,_b6d=0,_b6e=true;
for(var i=0,def,cell;(def=_b6a[i]);i++){
cell=this.addCellDef(_b69,i,def);
_b6b.push(cell);
this.cells.push(cell);
if(_b6e&&cell.relWidth){
_b6c+=cell.relWidth;
}else{
if(cell.width){
var w=cell.width;
if(typeof w=="string"&&w.slice(-1)=="%"){
_b6d+=window.parseInt(w,10);
}else{
if(w=="auto"){
_b6e=false;
}
}
}
}
}
if(_b6c&&_b6e){
_b50.forEach(_b6b,function(cell){
if(cell.relWidth){
cell.width=cell.unitWidth=((cell.relWidth/_b6c)*(100-_b6d))+"%";
}
});
}
return _b6b;
},addRowsDef:function(_b6f){
var _b70=[];
if(lang.isArray(_b6f)){
if(lang.isArray(_b6f[0])){
for(var i=0,row;_b6f&&(row=_b6f[i]);i++){
_b70.push(this.addRowDef(i,row));
}
}else{
_b70.push(this.addRowDef(0,_b6f));
}
}
return _b70;
},addViewDef:function(_b71){
this._defaultCellProps=_b71.defaultCell||{};
if(_b71.width&&_b71.width=="auto"){
delete _b71.width;
}
return lang.mixin({},_b71,{cells:this.addRowsDef(_b71.rows||_b71.cells)});
},setStructure:function(_b72){
this.fieldIndex=0;
this.cells=[];
var s=this.structure=[];
if(this.grid.rowSelector){
var sel={type:_b4e._scopeName+".grid._RowSelector"};
if(lang.isString(this.grid.rowSelector)){
var _b73=this.grid.rowSelector;
if(_b73=="false"){
sel=null;
}else{
if(_b73!="true"){
sel["width"]=_b73;
}
}
}else{
if(!this.grid.rowSelector){
sel=null;
}
}
if(sel){
s.push(this.addViewDef(sel));
}
}
var _b74=function(def){
return ("name" in def||"field" in def||"get" in def);
};
var _b75=function(def){
if(lang.isArray(def)){
if(lang.isArray(def[0])||_b74(def[0])){
return true;
}
}
return false;
};
var _b76=function(def){
return (def!==null&&lang.isObject(def)&&("cells" in def||"rows" in def||("type" in def&&!_b74(def))));
};
if(lang.isArray(_b72)){
var _b77=false;
for(var i=0,st;(st=_b72[i]);i++){
if(_b76(st)){
_b77=true;
break;
}
}
if(!_b77){
s.push(this.addViewDef({cells:_b72}));
}else{
for(i=0;(st=_b72[i]);i++){
if(_b75(st)){
s.push(this.addViewDef({cells:st}));
}else{
if(_b76(st)){
s.push(this.addViewDef(st));
}
}
}
}
}else{
if(_b76(_b72)){
s.push(this.addViewDef(_b72));
}
}
this.cellCount=this.cells.length;
this.grid.setupHeaderMenu();
}});
});
},"dijit/form/RangeBoundTextBox":function(){
define(["dojo/_base/declare","dojo/i18n","./MappedTextBox"],function(_b78,i18n,_b79){
var _b7a=_b78("dijit.form.RangeBoundTextBox",_b79,{rangeMessage:"",rangeCheck:function(_b7b,_b7c){
return ("min" in _b7c?(this.compare(_b7b,_b7c.min)>=0):true)&&("max" in _b7c?(this.compare(_b7b,_b7c.max)<=0):true);
},isInRange:function(){
return this.rangeCheck(this.get("value"),this.constraints);
},_isDefinitelyOutOfRange:function(){
var val=this.get("value");
if(val==null){
return false;
}
var _b7d=false;
if("min" in this.constraints){
var min=this.constraints.min;
_b7d=this.compare(val,((typeof min=="number")&&min>=0&&val!=0)?0:min)<0;
}
if(!_b7d&&("max" in this.constraints)){
var max=this.constraints.max;
_b7d=this.compare(val,((typeof max!="number")||max>0)?max:0)>0;
}
return _b7d;
},_isValidSubset:function(){
return this.inherited(arguments)&&!this._isDefinitelyOutOfRange();
},isValid:function(_b7e){
return this.inherited(arguments)&&((this._isEmpty(this.textbox.value)&&!this.required)||this.isInRange(_b7e));
},getErrorMessage:function(_b7f){
var v=this.get("value");
if(v!=null&&v!==""&&(typeof v!="number"||!isNaN(v))&&!this.isInRange(_b7f)){
return this.rangeMessage;
}
return this.inherited(arguments);
},postMixInProperties:function(){
this.inherited(arguments);
if(!this.rangeMessage){
this.messages=i18n.getLocalization("dijit.form","validate",this.lang);
this.rangeMessage=this.messages.rangeMessage;
}
},applyTextDir:function(){
}});
return _b7a;
});
},"dijit/layout/_ContentPaneResizeMixin":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/query","dojo/sniff","../registry","../Viewport","./utils"],function(_b80,_b81,_b82,_b83,_b84,lang,_b85,has,_b86,_b87,_b88){
return _b81("dijit.layout._ContentPaneResizeMixin",null,{doLayout:true,isLayoutContainer:true,startup:function(){
if(this._started){
return;
}
var _b89=this.getParent();
this._childOfLayoutWidget=_b89&&_b89.isLayoutContainer;
this._needLayout=!this._childOfLayoutWidget;
this.inherited(arguments);
if(this._isShown()){
this._onShow();
}
if(!this._childOfLayoutWidget){
this.own(_b87.on("resize",lang.hitch(this,"resize")));
}
},_checkIfSingleChild:function(){
var _b8a=[],_b8b=false;
_b85("> *",this.containerNode).some(function(node){
var _b8c=_b86.byNode(node);
if(_b8c&&_b8c.resize){
_b8a.push(_b8c);
}else{
if(node.offsetHeight){
_b8b=true;
}
}
});
this._singleChild=_b8a.length==1&&!_b8b?_b8a[0]:null;
_b82.toggle(this.containerNode,this.baseClass+"SingleChild",!!this._singleChild);
},resize:function(_b8d,_b8e){
this._resizeCalled=true;
this._scheduleLayout(_b8d,_b8e);
},_scheduleLayout:function(_b8f,_b90){
if(this._isShown()){
this._layout(_b8f,_b90);
}else{
this._needLayout=true;
this._changeSize=_b8f;
this._resultSize=_b90;
}
},_layout:function(_b91,_b92){
delete this._needLayout;
if(!this._wasShown&&this.open!==false){
this._onShow();
}
if(_b91){
_b83.setMarginBox(this.domNode,_b91);
}
var cn=this.containerNode;
if(cn===this.domNode){
var mb=_b92||{};
lang.mixin(mb,_b91||{});
if(!("h" in mb)||!("w" in mb)){
mb=lang.mixin(_b83.getMarginBox(cn),mb);
}
this._contentBox=_b88.marginBox2contentBox(cn,mb);
}else{
this._contentBox=_b83.getContentBox(cn);
}
this._layoutChildren();
},_layoutChildren:function(){
if(this.doLayout){
this._checkIfSingleChild();
}
if(this._singleChild&&this._singleChild.resize){
var cb=this._contentBox||_b83.getContentBox(this.containerNode);
this._singleChild.resize({w:cb.w,h:cb.h});
}else{
_b80.forEach(this.getChildren(),function(_b93){
if(_b93.resize){
_b93.resize();
}
});
}
},_isShown:function(){
if(this._childOfLayoutWidget){
if(this._resizeCalled&&"open" in this){
return this.open;
}
return this._resizeCalled;
}else{
if("open" in this){
return this.open;
}else{
var node=this.domNode,_b94=this.domNode.parentNode;
return (node.style.display!="none")&&(node.style.visibility!="hidden")&&!_b82.contains(node,"dijitHidden")&&_b94&&_b94.style&&(_b94.style.display!="none");
}
}
},_onShow:function(){
this._wasShown=true;
if(this._needLayout){
this._layout(this._changeSize,this._resultSize);
}
this.inherited(arguments);
}});
});
},"dojo/dnd/Moveable":function(){
define(["../_base/array","../_base/declare","../_base/event","../_base/lang","../dom","../dom-class","../Evented","../on","../topic","../touch","./common","./Mover","../_base/window"],function(_b95,_b96,_b97,lang,dom,_b98,_b99,on,_b9a,_b9b,dnd,_b9c,win){
var _b9d=_b96("dojo.dnd.Moveable",[_b99],{handle:"",delay:0,skip:false,constructor:function(node,_b9e){
this.node=dom.byId(node);
if(!_b9e){
_b9e={};
}
this.handle=_b9e.handle?dom.byId(_b9e.handle):null;
if(!this.handle){
this.handle=this.node;
}
this.delay=_b9e.delay>0?_b9e.delay:0;
this.skip=_b9e.skip;
this.mover=_b9e.mover?_b9e.mover:_b9c;
this.events=[on(this.handle,_b9b.press,lang.hitch(this,"onMouseDown")),on(this.handle,"dragstart",lang.hitch(this,"onSelectStart")),on(this.handle,"selectstart",lang.hitch(this,"onSelectStart"))];
},markupFactory:function(_b9f,node,Ctor){
return new Ctor(node,_b9f);
},destroy:function(){
_b95.forEach(this.events,function(_ba0){
_ba0.remove();
});
this.events=this.node=this.handle=null;
},onMouseDown:function(e){
if(this.skip&&dnd.isFormElement(e)){
return;
}
if(this.delay){
this.events.push(on(this.handle,_b9b.move,lang.hitch(this,"onMouseMove")),on(this.handle,_b9b.release,lang.hitch(this,"onMouseUp")));
this._lastX=e.pageX;
this._lastY=e.pageY;
}else{
this.onDragDetected(e);
}
_b97.stop(e);
},onMouseMove:function(e){
if(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay){
this.onMouseUp(e);
this.onDragDetected(e);
}
_b97.stop(e);
},onMouseUp:function(e){
for(var i=0;i<2;++i){
this.events.pop().remove();
}
_b97.stop(e);
},onSelectStart:function(e){
if(!this.skip||!dnd.isFormElement(e)){
_b97.stop(e);
}
},onDragDetected:function(e){
new this.mover(this.node,e,this);
},onMoveStart:function(_ba1){
_b9a.publish("/dnd/move/start",_ba1);
_b98.add(win.body(),"dojoMove");
_b98.add(this.node,"dojoMoveItem");
},onMoveStop:function(_ba2){
_b9a.publish("/dnd/move/stop",_ba2);
_b98.remove(win.body(),"dojoMove");
_b98.remove(this.node,"dojoMoveItem");
},onFirstMove:function(){
},onMove:function(_ba3,_ba4){
this.onMoving(_ba3,_ba4);
var s=_ba3.node.style;
s.left=_ba4.l+"px";
s.top=_ba4.t+"px";
this.onMoved(_ba3,_ba4);
},onMoving:function(){
},onMoved:function(){
}});
return _b9d;
});
},"dojo/store/util/SimpleQueryEngine":function(){
define(["../../_base/array"],function(_ba5){
return function(_ba6,_ba7){
switch(typeof _ba6){
default:
throw new Error("Can not query with a "+typeof _ba6);
case "object":
case "undefined":
var _ba8=_ba6;
_ba6=function(_ba9){
for(var key in _ba8){
var _baa=_ba8[key];
if(_baa&&_baa.test){
if(!_baa.test(_ba9[key],_ba9)){
return false;
}
}else{
if(_baa!=_ba9[key]){
return false;
}
}
}
return true;
};
break;
case "string":
if(!this[_ba6]){
throw new Error("No filter function "+_ba6+" was found in store");
}
_ba6=this[_ba6];
case "function":
}
function _bab(_bac){
var _bad=_ba5.filter(_bac,_ba6);
var _bae=_ba7&&_ba7.sort;
if(_bae){
_bad.sort(typeof _bae=="function"?_bae:function(a,b){
for(var sort,i=0;sort=_bae[i];i++){
var _baf=a[sort.attribute];
var _bb0=b[sort.attribute];
if(_baf!=_bb0){
return !!sort.descending==(_baf==null||_baf>_bb0)?-1:1;
}
}
return 0;
});
}
if(_ba7&&(_ba7.start||_ba7.count)){
var _bb1=_bad.length;
_bad=_bad.slice(_ba7.start||0,(_ba7.start||0)+(_ba7.count||Infinity));
_bad.total=_bb1;
}
return _bad;
};
_bab.matches=_ba6;
return _bab;
};
});
},"davinci/Runtime":function(){
define(["dojo/i18n!./nls/webContent","./commands/CommandStack","./ui.plugin","./html/html.plugin","./js/js.plugin","./ve/ve.plugin","./ve/themeEditor/themeEditor.plugin","./review/review.plugin","./UserActivityMonitor"],function(_bb2,_bb3,_bb4,_bb5,_bb6,_bb7,_bb8,_bb9,_bba){
var _bbb=[_bb4,_bb5,_bb6,_bb7,_bb8,_bb9];
var _bbc={plugins:[],extensionPoints:[],subscriptions:[],currentSelection:[],commandStack:new _bb3(),getUser:function(){
return this._initializationInfo.userInfo;
},getWorkbenchState:function(){
return this._initializationInfo.workbenchState;
},getSiteConfigData:function(name){
return this._initializationInfo[name];
},getDefaultThemeSet:function(){
return this.getSiteConfigData("defaultThemeSet");
},getUserDisplayName:function(_bbd){
if(!_bbd){
_bbd=this.getUser();
}
var _bbe=_bbd.userDisplayName;
if(!_bbd.userDisplayName){
_bbe=_bbd.email;
}
return _bbe;
},getUserEmail:function(_bbf){
if(!_bbf){
_bbf=this.getUser();
}
return _bbf.email;
},getUserDisplayNamePlusEmail:function(_bc0){
if(!_bc0){
_bc0=this.getUser();
}
var _bc1=this.getUserDisplayName(_bc0);
if(_bc1!=_bc0.email){
_bc1+=" &lt;"+_bc0.email+"&gt;";
}
return _bc1;
},loadPlugins:function(){
_bbb.forEach(function(_bc2){
var _bc3=_bc2.id;
_bbc.plugins[_bc3]=_bc2;
for(var id in _bc2){
var _bc4=_bc2[id];
if(typeof _bc4!="string"){
if(_bc4 instanceof Array){
_bc4.forEach(function(ext){
_bbc._addExtension(id,ext,_bc3);
});
}else{
_bbc._addExtension(id,_bc4,_bc3);
}
}
}
});
},singleUserMode:function(){
return _bbc.isLocalInstall;
},location:function(){
return document.location.href.split("?")[0];
},getUserWorkspaceUrl:function(){
var loc=this.location();
if(loc.slice(-1)=="/"){
loc=loc.slice(0,-1);
}
return loc+"/user/"+_bbc.userName+"/ws/workspace/";
},run:function(){
if(dojo.isMac){
dojo.addClass(document.documentElement,"isMac");
}
var _bc5=document.body.style;
_bbc.supportsCSS3Transitions=_bc5.WebkitTransition!==undefined||_bc5.MozTransition!==undefined||_bc5.OTransition!==undefined||_bc5.transition!==undefined;
_bbc.subscribe("/davinci/ui/selectionChanged",_bbc._selectionChanged);
dojo.connect(dojo.doc.documentElement,"onkeypress",function(e){
if(e.charOrCode==8){
window.davinciBackspaceKeyTime=Date.now();
}
});
_bba.setUpInActivityMonitor(dojo.doc,this);
dojo.connect(dojo.doc.documentElement,"onkeydown",this,"_handleGlobalDocumentKeyEvent");
dojo.addOnUnload(function(e){
var _bc6=null;
var _bc7=(davinci.Workbench&&davinci.Workbench.editorTabs)?davinci.Workbench.editorTabs.getChildren():[];
var _bc8=0;
for(var i=0;i<_bc7.length;i++){
var _bc9=_bc7[i];
if(_bc9.editor){
var _bca=_bc9.editor.getOnUnloadWarningMessage();
if(_bca){
if(!_bc6){
_bc6=_bca;
}
_bc8++;
}
}
}
if(_bc8>1){
_bc6=dojo.string.substitute(_bb2.multipleFilesUnsaved,[_bc6,_bc8]);
}
if(!_bc6){
var _bcb=Date.now()-window.davinciBackspaceKeyTime<100;
if(_bcb){
_bc6=_bb2.careful;
}
}
if(_bc6){
if(e=e||window.event){
e.returnValue=_bc6;
}
return _bc6;
}
});
},subscribe:function(_bcc,func){
_bbc.subscriptions.push(dojo.subscribe(_bcc,this,func));
},destroy:function(){
dojo.forEach(_bbc.subscriptions,dojo.unsubscribe);
},_addExtension:function(id,_bcd,_bce){
if(_bcd.id){
_bcd.id=_bce+"."+_bcd.id;
}
_bbc.extensionPoints[id]=_bbc.extensionPoints[id]||[];
var _bcf=_bbc.extensionPoints[id];
_bcf.push(_bcd);
_bbc.extensionPoints[id]=_bcf;
},getExtensions:function(_bd0,_bd1){
var _bd2=_bbc.extensionPoints[_bd0];
if(_bd1){
var _bd3=[];
var _bd4=_bd1 instanceof Function;
if(_bd2){
return _bd2.filter(function(ext){
return (_bd4&&_bd1(ext))||ext.id==_bd1;
});
}
}
return _bd2;
},getExtension:function(_bd5,_bd6){
return _bbc.getExtensions(_bd5,_bd6)[0];
},handleError:function(_bd7){
var _bd8="welcome";
if(_bbc.singleUserMode()){
_bd8=".";
}
window.document.body.innerHTML=dojo.string.substitute(_bb2.serverConnectError,{redirectUrl:_bd8,error:_bd7});
},executeCommand:function(_bd9){
var cmd=_bbc.getExtension("davinci.commands",_bd9);
if(cmd&&cmd.run){
cmd.run();
}
},_selectionChanged:function(_bda){
_bbc.currentSelection=_bda;
},getSelection:function(){
return _bbc.currentSelection;
},serverJSONRequest:function(_bdb){
var _bdc;
var args={handleAs:"json"};
dojo.mixin(args,_bdb);
dojo.xhrGet(args).then(function(_bdd){
if(_bdd){
_bdc=_bdd;
}
});
return _bdc;
},registerKeyBinding:function(_bde,_bdf){
if(!this._globalKeyBindings){
this._globalKeyBindings=[];
}
this._globalKeyBindings.push({keyBinding:_bde,action:_bdf});
},handleKeyEvent:function(e){
this._handleKeyEvent(e,true);
},_handleGlobalDocumentKeyEvent:function(e){
this._handleKeyEvent(e);
},_handleKeyEvent:function(e,_be0){
if(!this._globalKeyBindings){
return;
}
var _be1=false;
_be1=dojo.some(this._globalKeyBindings,dojo.hitch(this,function(_be2){
if(_bbc.isKeyEqualToEvent(_be2.keyBinding,e)){
davinci.Workbench._runAction(_be2.action);
return true;
}
}));
if(_be1){
dojo.stopEvent(e);
}else{
if(!_be0){
if(this.currentEditor&&this.currentEditor.handleKeyEvent){
this.currentEditor.handleKeyEvent(e,true);
}
}
}
},isKeyEqualToEvent:function(_be3,e){
var _be4=true;
var _be5=((e.ctrlKey&&!dojo.isMac)||(dojo.isMac&&e.metaKey));
var _be6=((e.altKey&&!dojo.isMac)||(dojo.isMac&&e.ctrlKey));
if(!!_be3.accel!==_be5){
_be4=false;
}
if(!!_be3.meta!==_be6){
_be4=false;
}
if(!!_be3.shift!==e.shiftKey){
_be4=false;
}
if(_be4&&_be3.charOrCode&&e.which){
if(dojo.isArray(_be3.charOrCode)){
_be4=dojo.some(_be3.charOrCode,dojo.hitch(this,function(_be7){
return this._comparecharOrCode(_be7,e);
}));
}else{
_be4=this._comparecharOrCode(_be3.charOrCode,e);
}
}
return _be4;
},_comparecharOrCode:function(_be8,e){
var _be9;
if(dojo.isString(_be8)){
_be9=(_be8.toLowerCase()===String.fromCharCode(e.which).toLowerCase());
}else{
_be9=(_be8===e.which);
}
return _be9;
}};
return _bbc;
});
},"davinci/js/JSFile":function(){
define(["dojo/_base/declare","davinci/js/JSElement"],function(_bea,_beb){
return _bea("davinci.js.JSFile",_beb,{constructor:function(_bec){
this.elementType="JSFile";
this.nosemicolon=true;
this._textContent="";
if(_bec){
this.origin=_bec;
}
},getText:function(_bed){
return this._textContent;
},setText:function(text){
this._textContent=text;
},getLabel:function(){
return this.fileName;
},getID:function(){
return this.fileName;
},visit:function(_bee){
var _bef;
_bef=_bee.visit(this);
if(!_bef){
for(var i=0;i<this.children.length;i++){
this.children[i].visit(_bee);
}
}
if(_bee.endVisit){
_bee.endVisit(this);
}
}});
});
},"dojox/grid/_View":function(){
define(["dojo","dijit/registry","../main","dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/_base/connect","dojo/_base/sniff","dojo/query","dojo/_base/window","dojo/text!./resources/View.html","dojo/dnd/Source","dijit/_Widget","dijit/_TemplatedMixin","dojox/html/metrics","./util","dojo/_base/html","./_Builder","dojo/dnd/Avatar","dojo/dnd/Manager"],function(dojo,_bf0,_bf1,_bf2,_bf3,lang,_bf4,has,_bf5,win,_bf6,_bf7,_bf8,_bf9,_bfa,util,html,_bfb,_bfc,_bfd){
var _bfe=function(_bff,_c00){
return _bff.style.cssText==undefined?_bff.getAttribute("style"):_bff.style.cssText;
};
var _c01=_bf2("dojox.grid._View",[_bf8,_bf9],{defaultWidth:"18em",viewWidth:"",templateString:_bf6,classTag:"dojoxGrid",marginBottom:0,rowPad:2,_togglingColumn:-1,_headerBuilderClass:_bfb._HeaderBuilder,_contentBuilderClass:_bfb._ContentBuilder,postMixInProperties:function(){
this.rowNodes={};
},postCreate:function(){
this.connect(this.scrollboxNode,"onscroll","doscroll");
util.funnelEvents(this.contentNode,this,"doContentEvent",["mouseover","mouseout","click","dblclick","contextmenu","mousedown"]);
util.funnelEvents(this.headerNode,this,"doHeaderEvent",["dblclick","mouseover","mouseout","mousemove","mousedown","click","contextmenu"]);
this.content=new this._contentBuilderClass(this);
this.header=new this._headerBuilderClass(this);
if(!this.grid.isLeftToRight()){
this.headerNodeContainer.style.width="";
}
},destroy:function(){
html.destroy(this.headerNode);
delete this.headerNode;
for(var i in this.rowNodes){
this._cleanupRowWidgets(this.rowNodes[i]);
html.destroy(this.rowNodes[i]);
}
this.rowNodes={};
if(this.source){
this.source.destroy();
}
this.inherited(arguments);
},focus:function(){
if(has("ie")||has("webkit")||has("opera")){
this.hiddenFocusNode.focus();
}else{
this.scrollboxNode.focus();
}
},setStructure:function(_c02){
var vs=(this.structure=_c02);
if(vs.width&&!isNaN(vs.width)){
this.viewWidth=vs.width+"em";
}else{
this.viewWidth=vs.width||(vs.noscroll?"auto":this.viewWidth);
}
this._onBeforeRow=vs.onBeforeRow||function(){
};
this._onAfterRow=vs.onAfterRow||function(){
};
this.noscroll=vs.noscroll;
if(this.noscroll){
this.scrollboxNode.style.overflow="hidden";
}
this.simpleStructure=Boolean(vs.cells.length==1);
this.testFlexCells();
this.updateStructure();
},_cleanupRowWidgets:function(_c03){
if(_c03){
_bf3.forEach(_bf5("[widgetId]",_c03).map(_bf0.byNode),function(w){
if(w._destroyOnRemove){
w.destroy();
delete w;
}else{
if(w.domNode&&w.domNode.parentNode){
w.domNode.parentNode.removeChild(w.domNode);
}
}
});
}
},onBeforeRow:function(_c04,_c05){
this._onBeforeRow(_c04,_c05);
if(_c04>=0){
this._cleanupRowWidgets(this.getRowNode(_c04));
}
},onAfterRow:function(_c06,_c07,_c08){
this._onAfterRow(_c06,_c07,_c08);
var g=this.grid;
_bf3.forEach(_bf5(".dojoxGridStubNode",_c08),function(n){
if(n&&n.parentNode){
var lw=n.getAttribute("linkWidget");
var _c09=window.parseInt(html.attr(n,"cellIdx"),10);
var _c0a=g.getCell(_c09);
var w=_bf0.byId(lw);
if(w){
n.parentNode.replaceChild(w.domNode,n);
if(!w._started){
w.startup();
}
dojo.destroy(n);
}else{
n.innerHTML="";
}
}
},this);
},testFlexCells:function(){
this.flexCells=false;
for(var j=0,row;(row=this.structure.cells[j]);j++){
for(var i=0,cell;(cell=row[i]);i++){
cell.view=this;
this.flexCells=this.flexCells||cell.isFlex();
}
}
return this.flexCells;
},updateStructure:function(){
this.header.update();
this.content.update();
},getScrollbarWidth:function(){
var _c0b=this.hasVScrollbar();
var _c0c=html.style(this.scrollboxNode,"overflow");
if(this.noscroll||!_c0c||_c0c=="hidden"){
_c0b=false;
}else{
if(_c0c=="scroll"){
_c0b=true;
}
}
return (_c0b?_bfa.getScrollbar().w:0);
},getColumnsWidth:function(){
var h=this.headerContentNode;
return h&&h.firstChild?(h.firstChild.offsetWidth||html.style(h.firstChild,"width")):0;
},setColumnsWidth:function(_c0d){
this.headerContentNode.firstChild.style.width=_c0d+"px";
if(this.viewWidth){
this.viewWidth=_c0d+"px";
}
},getWidth:function(){
return this.viewWidth||(this.getColumnsWidth()+this.getScrollbarWidth())+"px";
},getContentWidth:function(){
return Math.max(0,html._getContentBox(this.domNode).w-this.getScrollbarWidth())+"px";
},render:function(){
this.scrollboxNode.style.height="";
this.renderHeader();
if(this._togglingColumn>=0){
this.setColumnsWidth(this.getColumnsWidth()-this._togglingColumn);
this._togglingColumn=-1;
}
var _c0e=this.grid.layout.cells;
var _c0f=lang.hitch(this,function(node,_c10){
!this.grid.isLeftToRight()&&(_c10=!_c10);
var inc=_c10?-1:1;
var idx=this.header.getCellNodeIndex(node)+inc;
var cell=_c0e[idx];
while(cell&&cell.getHeaderNode()&&cell.getHeaderNode().style.display=="none"){
idx+=inc;
cell=_c0e[idx];
}
if(cell){
return cell.getHeaderNode();
}
return null;
});
if(this.grid.columnReordering&&this.simpleStructure){
if(this.source){
this.source.destroy();
}
var _c11="dojoxGrid_bottomMarker";
var _c12="dojoxGrid_topMarker";
if(this.bottomMarker){
html.destroy(this.bottomMarker);
}
this.bottomMarker=html.byId(_c11);
if(this.topMarker){
html.destroy(this.topMarker);
}
this.topMarker=html.byId(_c12);
if(!this.bottomMarker){
this.bottomMarker=html.create("div",{"id":_c11,"class":"dojoxGridColPlaceBottom"},win.body());
this._hide(this.bottomMarker);
this.topMarker=html.create("div",{"id":_c12,"class":"dojoxGridColPlaceTop"},win.body());
this._hide(this.topMarker);
}
this.arrowDim=html.contentBox(this.bottomMarker);
var _c13=html.contentBox(this.headerContentNode.firstChild.rows[0]).h;
this.source=new _bf7(this.headerContentNode.firstChild.rows[0],{horizontal:true,accept:["gridColumn_"+this.grid.id],viewIndex:this.index,generateText:false,onMouseDown:lang.hitch(this,function(e){
this.header.decorateEvent(e);
if((this.header.overRightResizeArea(e)||this.header.overLeftResizeArea(e))&&this.header.canResize(e)&&!this.header.moveable){
this.header.beginColumnResize(e);
}else{
if(this.grid.headerMenu){
this.grid.headerMenu.onCancel(true);
}
if(e.button===(has("ie")<9?1:0)){
_bf7.prototype.onMouseDown.call(this.source,e);
}
}
}),onMouseOver:lang.hitch(this,function(e){
var src=this.source;
if(src._getChildByEvent(e)){
_bf7.prototype.onMouseOver.apply(src,arguments);
}
}),_markTargetAnchor:lang.hitch(this,function(_c14){
var src=this.source;
if(src.current==src.targetAnchor&&src.before==_c14){
return;
}
if(src.targetAnchor&&_c0f(src.targetAnchor,src.before)){
src._removeItemClass(_c0f(src.targetAnchor,src.before),src.before?"After":"Before");
}
_bf7.prototype._markTargetAnchor.call(src,_c14);
var _c15=_c14?src.targetAnchor:_c0f(src.targetAnchor,src.before);
var _c16=0;
if(!_c15){
_c15=src.targetAnchor;
_c16=html.contentBox(_c15).w+this.arrowDim.w/2+2;
}
var pos=html.position(_c15,true);
var left=Math.floor(pos.x-this.arrowDim.w/2+_c16);
html.style(this.bottomMarker,"visibility","visible");
html.style(this.topMarker,"visibility","visible");
html.style(this.bottomMarker,{"left":left+"px","top":(_c13+pos.y)+"px"});
html.style(this.topMarker,{"left":left+"px","top":(pos.y-this.arrowDim.h)+"px"});
if(src.targetAnchor&&_c0f(src.targetAnchor,src.before)){
src._addItemClass(_c0f(src.targetAnchor,src.before),src.before?"After":"Before");
}
}),_unmarkTargetAnchor:lang.hitch(this,function(){
var src=this.source;
if(!src.targetAnchor){
return;
}
if(src.targetAnchor&&_c0f(src.targetAnchor,src.before)){
src._removeItemClass(_c0f(src.targetAnchor,src.before),src.before?"After":"Before");
}
this._hide(this.bottomMarker);
this._hide(this.topMarker);
_bf7.prototype._unmarkTargetAnchor.call(src);
}),destroy:lang.hitch(this,function(){
_bf4.disconnect(this._source_conn);
_bf4.unsubscribe(this._source_sub);
_bf7.prototype.destroy.call(this.source);
if(this.bottomMarker){
html.destroy(this.bottomMarker);
delete this.bottomMarker;
}
if(this.topMarker){
html.destroy(this.topMarker);
delete this.topMarker;
}
}),onDndCancel:lang.hitch(this,function(){
_bf7.prototype.onDndCancel.call(this.source);
this._hide(this.bottomMarker);
this._hide(this.topMarker);
})});
this._source_conn=_bf4.connect(this.source,"onDndDrop",this,"_onDndDrop");
this._source_sub=_bf4.subscribe("/dnd/drop/before",this,"_onDndDropBefore");
this.source.startup();
}
},_hide:function(node){
html.style(node,{top:"-10000px","visibility":"hidden"});
},_onDndDropBefore:function(_c17,_c18,copy){
if(_bfd.manager().target!==this.source){
return;
}
this.source._targetNode=this.source.targetAnchor;
this.source._beforeTarget=this.source.before;
var _c19=this.grid.views.views;
var _c1a=_c19[_c17.viewIndex];
var _c1b=_c19[this.index];
if(_c1b!=_c1a){
_c1a.convertColPctToFixed();
_c1b.convertColPctToFixed();
}
},_onDndDrop:function(_c1c,_c1d,copy){
if(_bfd.manager().target!==this.source){
if(_bfd.manager().source===this.source){
this._removingColumn=true;
}
return;
}
this._hide(this.bottomMarker);
this._hide(this.topMarker);
var _c1e=function(n){
return n?html.attr(n,"idx"):null;
};
var w=html.marginBox(_c1d[0]).w;
if(_c1c.viewIndex!==this.index){
var _c1f=this.grid.views.views;
var _c20=_c1f[_c1c.viewIndex];
var _c21=_c1f[this.index];
if(_c20.viewWidth&&_c20.viewWidth!="auto"){
_c20.setColumnsWidth(_c20.getColumnsWidth()-w);
}
if(_c21.viewWidth&&_c21.viewWidth!="auto"){
_c21.setColumnsWidth(_c21.getColumnsWidth());
}
}
var stn=this.source._targetNode;
var stb=this.source._beforeTarget;
!this.grid.isLeftToRight()&&(stb=!stb);
var _c22=this.grid.layout;
var idx=this.index;
delete this.source._targetNode;
delete this.source._beforeTarget;
_c22.moveColumn(_c1c.viewIndex,idx,_c1e(_c1d[0]),_c1e(stn),stb);
},renderHeader:function(){
this.headerContentNode.innerHTML=this.header.generateHtml(this._getHeaderContent);
if(this.flexCells){
this.contentWidth=this.getContentWidth();
this.headerContentNode.firstChild.style.width=this.contentWidth;
}
util.fire(this,"onAfterRow",[-1,this.structure.cells,this.headerContentNode]);
},_getHeaderContent:function(_c23){
var n=_c23.name||_c23.grid.getCellName(_c23);
if(/^\s+$/.test(n)){
n="&nbsp;";
}
var ret=["<div class=\"dojoxGridSortNode"];
if(_c23.index!=_c23.grid.getSortIndex()){
ret.push("\">");
}else{
ret=ret.concat([" ",_c23.grid.sortInfo>0?"dojoxGridSortUp":"dojoxGridSortDown","\"><div class=\"dojoxGridArrowButtonChar\">",_c23.grid.sortInfo>0?"&#9650;":"&#9660;","</div><div class=\"dojoxGridArrowButtonNode\" role=\"presentation\"></div>","<div class=\"dojoxGridColCaption\">"]);
}
ret=ret.concat([n,"</div></div>"]);
return ret.join("");
},resize:function(){
this.adaptHeight();
this.adaptWidth();
},hasHScrollbar:function(_c24){
var _c25=this._hasHScroll||false;
if(this._hasHScroll==undefined||_c24){
if(this.noscroll){
this._hasHScroll=false;
}else{
var _c26=html.style(this.scrollboxNode,"overflow");
if(_c26=="hidden"){
this._hasHScroll=false;
}else{
if(_c26=="scroll"){
this._hasHScroll=true;
}else{
this._hasHScroll=(this.scrollboxNode.offsetWidth-this.getScrollbarWidth()<this.contentNode.offsetWidth);
}
}
}
}
if(_c25!==this._hasHScroll){
this.grid.update();
}
return this._hasHScroll;
},hasVScrollbar:function(_c27){
var _c28=this._hasVScroll||false;
if(this._hasVScroll==undefined||_c27){
if(this.noscroll){
this._hasVScroll=false;
}else{
var _c29=html.style(this.scrollboxNode,"overflow");
if(_c29=="hidden"){
this._hasVScroll=false;
}else{
if(_c29=="scroll"){
this._hasVScroll=true;
}else{
this._hasVScroll=(this.scrollboxNode.scrollHeight>this.scrollboxNode.clientHeight);
}
}
}
}
if(_c28!==this._hasVScroll){
this.grid.update();
}
return this._hasVScroll;
},convertColPctToFixed:function(){
var _c2a=false;
this.grid.initialWidth="";
var _c2b=_bf5("th",this.headerContentNode);
var _c2c=_bf3.map(_c2b,function(c,vIdx){
var w=c.style.width;
html.attr(c,"vIdx",vIdx);
if(w&&w.slice(-1)=="%"){
_c2a=true;
}else{
if(w&&w.slice(-2)=="px"){
return window.parseInt(w,10);
}
}
return html.contentBox(c).w;
});
if(_c2a){
_bf3.forEach(this.grid.layout.cells,function(cell,idx){
if(cell.view==this){
var _c2d=cell.view.getHeaderCellNode(cell.index);
if(_c2d&&html.hasAttr(_c2d,"vIdx")){
var vIdx=window.parseInt(html.attr(_c2d,"vIdx"));
this.setColWidth(idx,_c2c[vIdx]);
html.removeAttr(_c2d,"vIdx");
}
}
},this);
return true;
}
return false;
},adaptHeight:function(_c2e){
if(!this.grid._autoHeight){
var h=(this.domNode.style.height&&parseInt(this.domNode.style.height.replace(/px/,""),10))||this.domNode.clientHeight;
var self=this;
var _c2f=function(){
var v;
for(var i in self.grid.views.views){
v=self.grid.views.views[i];
if(v!==self&&v.hasHScrollbar()){
return true;
}
}
return false;
};
if(_c2e||(this.noscroll&&_c2f())){
h-=_bfa.getScrollbar().h;
}
util.setStyleHeightPx(this.scrollboxNode,h);
}
this.hasVScrollbar(true);
},adaptWidth:function(){
if(this.flexCells){
this.contentWidth=this.getContentWidth();
this.headerContentNode.firstChild.style.width=this.contentWidth;
}
var w=this.scrollboxNode.offsetWidth-this.getScrollbarWidth();
if(!this._removingColumn){
w=Math.max(w,this.getColumnsWidth())+"px";
}else{
w=Math.min(w,this.getColumnsWidth())+"px";
this._removingColumn=false;
}
var cn=this.contentNode;
cn.style.width=w;
this.hasHScrollbar(true);
},setSize:function(w,h){
var ds=this.domNode.style;
var hs=this.headerNode.style;
if(w){
ds.width=w;
hs.width=w;
}
ds.height=(h>=0?h+"px":"");
},renderRow:function(_c30){
var _c31=this.createRowNode(_c30);
this.buildRow(_c30,_c31);
return _c31;
},createRowNode:function(_c32){
var node=document.createElement("div");
node.className=this.classTag+"Row";
if(this instanceof _bf1.grid._RowSelector){
html.attr(node,"role","presentation");
}else{
html.attr(node,"role","row");
if(this.grid.selectionMode!="none"){
node.setAttribute("aria-selected","false");
}
}
node[util.gridViewTag]=this.id;
node[util.rowIndexTag]=_c32;
this.rowNodes[_c32]=node;
return node;
},buildRow:function(_c33,_c34){
this.buildRowContent(_c33,_c34);
this.styleRow(_c33,_c34);
},buildRowContent:function(_c35,_c36){
_c36.innerHTML=this.content.generateHtml(_c35,_c35);
if(this.flexCells&&this.contentWidth){
_c36.firstChild.style.width=this.contentWidth;
}
util.fire(this,"onAfterRow",[_c35,this.structure.cells,_c36]);
},rowRemoved:function(_c37){
if(_c37>=0){
this._cleanupRowWidgets(this.getRowNode(_c37));
}
this.grid.edit.save(this,_c37);
delete this.rowNodes[_c37];
},getRowNode:function(_c38){
return this.rowNodes[_c38];
},getCellNode:function(_c39,_c3a){
var row=this.getRowNode(_c39);
if(row){
return this.content.getCellNode(row,_c3a);
}
},getHeaderCellNode:function(_c3b){
if(this.headerContentNode){
return this.header.getCellNode(this.headerContentNode,_c3b);
}
},styleRow:function(_c3c,_c3d){
_c3d._style=_bfe(_c3d);
this.styleRowNode(_c3c,_c3d);
},styleRowNode:function(_c3e,_c3f){
if(_c3f){
this.doStyleRowNode(_c3e,_c3f);
}
},doStyleRowNode:function(_c40,_c41){
this.grid.styleRowNode(_c40,_c41);
},updateRow:function(_c42){
var _c43=this.getRowNode(_c42);
if(_c43){
_c43.style.height="";
this.buildRow(_c42,_c43);
}
return _c43;
},updateRowStyles:function(_c44){
this.styleRowNode(_c44,this.getRowNode(_c44));
},lastTop:0,firstScroll:0,_nativeScroll:false,doscroll:function(_c45){
if(has("ff")>=13){
this._nativeScroll=true;
}
var _c46=this.grid.isLeftToRight();
if(this.firstScroll<2){
if((!_c46&&this.firstScroll==1)||(_c46&&this.firstScroll===0)){
var s=html.marginBox(this.headerNodeContainer);
if(has("ie")){
this.headerNodeContainer.style.width=s.w+this.getScrollbarWidth()+"px";
}else{
if(has("mozilla")){
this.headerNodeContainer.style.width=s.w-this.getScrollbarWidth()+"px";
this.scrollboxNode.scrollLeft=_c46?this.scrollboxNode.clientWidth-this.scrollboxNode.scrollWidth:this.scrollboxNode.scrollWidth-this.scrollboxNode.clientWidth;
}
}
}
this.firstScroll++;
}
this.headerNode.scrollLeft=this.scrollboxNode.scrollLeft;
var top=this.scrollboxNode.scrollTop;
if(top!==this.lastTop){
this.grid.scrollTo(top);
}
this._nativeScroll=false;
},setScrollTop:function(_c47){
this.lastTop=_c47;
if(!this._nativeScroll){
this.scrollboxNode.scrollTop=_c47;
}
return this.scrollboxNode.scrollTop;
},doContentEvent:function(e){
if(this.content.decorateEvent(e)){
this.grid.onContentEvent(e);
}
},doHeaderEvent:function(e){
if(this.header.decorateEvent(e)){
this.grid.onHeaderEvent(e);
}
},dispatchContentEvent:function(e){
return this.content.dispatchEvent(e);
},dispatchHeaderEvent:function(e){
return this.header.dispatchEvent(e);
},setColWidth:function(_c48,_c49){
this.grid.setCellWidth(_c48,_c49+"px");
},update:function(){
if(!this.domNode){
return;
}
this.content.update();
this.grid.update();
var left=this.scrollboxNode.scrollLeft;
this.scrollboxNode.scrollLeft=left;
this.headerNode.scrollLeft=left;
}});
var _c4a=_bf2("dojox.grid._GridAvatar",_bfc,{construct:function(){
var dd=win.doc;
var a=dd.createElement("table");
a.cellPadding=a.cellSpacing="0";
a.className="dojoxGridDndAvatar";
a.style.position="absolute";
a.style.zIndex=1999;
a.style.margin="0px";
var b=dd.createElement("tbody");
var tr=dd.createElement("tr");
var td=dd.createElement("td");
var img=dd.createElement("td");
tr.className="dojoxGridDndAvatarItem";
img.className="dojoxGridDndAvatarItemImage";
img.style.width="16px";
var _c4b=this.manager.source,node;
if(_c4b.creator){
node=_c4b._normalizedCreator(_c4b.getItem(this.manager.nodes[0].id).data,"avatar").node;
}else{
node=this.manager.nodes[0].cloneNode(true);
var _c4c,_c4d;
if(node.tagName.toLowerCase()=="tr"){
_c4c=dd.createElement("table");
_c4d=dd.createElement("tbody");
_c4d.appendChild(node);
_c4c.appendChild(_c4d);
node=_c4c;
}else{
if(node.tagName.toLowerCase()=="th"){
_c4c=dd.createElement("table");
_c4d=dd.createElement("tbody");
var r=dd.createElement("tr");
_c4c.cellPadding=_c4c.cellSpacing="0";
r.appendChild(node);
_c4d.appendChild(r);
_c4c.appendChild(_c4d);
node=_c4c;
}
}
}
node.id="";
td.appendChild(node);
tr.appendChild(img);
tr.appendChild(td);
html.style(tr,"opacity",0.9);
b.appendChild(tr);
a.appendChild(b);
this.node=a;
var m=_bfd.manager();
this.oldOffsetY=m.OFFSET_Y;
m.OFFSET_Y=1;
},destroy:function(){
_bfd.manager().OFFSET_Y=this.oldOffsetY;
this.inherited(arguments);
}});
var _c4e=_bfd.manager().makeAvatar;
_bfd.manager().makeAvatar=function(){
var src=this.source;
if(src.viewIndex!==undefined&&!html.hasClass(win.body(),"dijit_a11y")){
return new _c4a(this);
}
return _c4e.call(_bfd.manager());
};
return _c01;
});
},"url:davinci/review/widgets/templates/MailFailureDialogContent.html":"<div>\n<div class='mailFailureInfo'>${inviteNotSent}</div>\n<div class='mailFailureExtraInfo'>${mailFailureMsg}</div>\n<div class='mailFailureContent'>${htmlContent}</div>\n</div>\n","dijit/MenuItem":function(){
define(["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/kernel","dojo/sniff","./_Widget","./_TemplatedMixin","./_Contained","./_CssStateMixin","dojo/text!./templates/MenuItem.html"],function(_c4f,dom,_c50,_c51,_c52,has,_c53,_c54,_c55,_c56,_c57){
return _c4f("dijit.MenuItem",[_c53,_c54,_c55,_c56],{templateString:_c57,baseClass:"dijitMenuItem",label:"",_setLabelAttr:function(val){
this.containerNode.innerHTML=val;
this._set("label",val);
if(this.textDir==="auto"){
this.applyTextDir(this.focusNode,this.label);
}
},iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},accelKey:"",disabled:false,_fillContent:function(_c58){
if(_c58&&!("label" in this.params)){
this.set("label",_c58.innerHTML);
}
},buildRendering:function(){
this.inherited(arguments);
var _c59=this.id+"_text";
_c50.set(this.containerNode,"id",_c59);
if(this.accelKeyNode){
_c50.set(this.accelKeyNode,"id",this.id+"_accel");
_c59+=" "+this.id+"_accel";
}
this.domNode.setAttribute("aria-labelledby",_c59);
dom.setSelectable(this.domNode,false);
},onClick:function(){
},focus:function(){
try{
if(has("ie")==8){
this.containerNode.focus();
}
this.focusNode.focus();
}
catch(e){
}
},_onFocus:function(){
this._setSelected(true);
this.getParent()._onItemFocus(this);
this.inherited(arguments);
},_setSelected:function(_c5a){
_c51.toggle(this.domNode,"dijitMenuItemSelected",_c5a);
},setLabel:function(_c5b){
_c52.deprecated("dijit.MenuItem.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");
this.set("label",_c5b);
},setDisabled:function(_c5c){
_c52.deprecated("dijit.Menu.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");
this.set("disabled",_c5c);
},_setDisabledAttr:function(_c5d){
this.focusNode.setAttribute("aria-disabled",_c5d?"true":"false");
this._set("disabled",_c5d);
},_setAccelKeyAttr:function(_c5e){
this.accelKeyNode.style.display=_c5e?"":"none";
this.accelKeyNode.innerHTML=_c5e;
_c50.set(this.containerNode,"colSpan",_c5e?"1":"2");
this._set("accelKey",_c5e);
},_setTextDirAttr:function(_c5f){
if(!this._created||this.textDir!=_c5f){
this._set("textDir",_c5f);
this.applyTextDir(this.focusNode,this.label);
}
}});
});
},"dijit/layout/TabController":function(){
define(["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/i18n","dojo/_base/lang","./StackController","../registry","../Menu","../MenuItem","dojo/text!./templates/_TabButton.html","dojo/i18n!../nls/common"],function(_c60,dom,_c61,_c62,i18n,lang,_c63,_c64,Menu,_c65,_c66){
var _c67=_c60("dijit.layout._TabButton",_c63.StackButton,{baseClass:"dijitTab",cssStateNodes:{closeNode:"dijitTabCloseButton"},templateString:_c66,scrollOnFocus:false,buildRendering:function(){
this.inherited(arguments);
dom.setSelectable(this.containerNode,false);
},startup:function(){
this.inherited(arguments);
var n=this.domNode;
this.defer(function(){
n.className=n.className;
},1);
},_setCloseButtonAttr:function(disp){
this._set("closeButton",disp);
_c62.toggle(this.domNode,"dijitClosable",disp);
this.closeNode.style.display=disp?"":"none";
if(disp){
var _c68=i18n.getLocalization("dijit","common");
if(this.closeNode){
_c61.set(this.closeNode,"title",_c68.itemClose);
}
}
},_setDisabledAttr:function(_c69){
this.inherited(arguments);
if(this.closeNode){
if(_c69){
_c61.remove(this.closeNode,"title");
}else{
var _c6a=i18n.getLocalization("dijit","common");
_c61.set(this.closeNode,"title",_c6a.itemClose);
}
}
},_setLabelAttr:function(_c6b){
this.inherited(arguments);
if(!this.showLabel&&!this.params.title){
this.iconNode.alt=lang.trim(this.containerNode.innerText||this.containerNode.textContent||"");
}
}});
var _c6c=_c60("dijit.layout.TabController",_c63,{baseClass:"dijitTabController",templateString:"<div role='tablist' data-dojo-attach-event='onkeypress:onkeypress'></div>",tabPosition:"top",buttonWidget:_c67,buttonWidgetCloseClass:"dijitTabCloseButton",postCreate:function(){
this.inherited(arguments);
var _c6d=new Menu({id:this.id+"_Menu",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,targetNodeIds:[this.domNode],selector:function(node){
return _c62.contains(node,"dijitClosable")&&!_c62.contains(node,"dijitTabDisabled");
}});
this.own(_c6d);
var _c6e=i18n.getLocalization("dijit","common"),_c6f=this;
_c6d.addChild(new _c65({label:_c6e.itemClose,ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,onClick:function(evt){
var _c70=_c64.byNode(this.getParent().currentTarget);
_c6f.onCloseButtonClick(_c70.page);
}}));
}});
_c6c.TabButton=_c67;
return _c6c;
});
},"dijit/MenuBarItem":function(){
define(["dojo/_base/declare","./MenuItem","dojo/text!./templates/MenuBarItem.html"],function(_c71,_c72,_c73){
var _c74=_c71("dijit._MenuBarItemMixin",null,{templateString:_c73,_setIconClassAttr:null});
var _c75=_c71("dijit.MenuBarItem",[_c72,_c74],{});
_c75._MenuBarItemMixin=_c74;
return _c75;
});
},"dojo/cldr/supplemental":function(){
define(["../_base/lang","../i18n"],function(lang,i18n){
var _c76={};
lang.setObject("dojo.cldr.supplemental",_c76);
_c76.getFirstDayOfWeek=function(_c77){
var _c78={bd:5,mv:5,ae:6,af:6,bh:6,dj:6,dz:6,eg:6,iq:6,ir:6,jo:6,kw:6,ly:6,ma:6,om:6,qa:6,sa:6,sd:6,sy:6,ye:6,ag:0,ar:0,as:0,au:0,br:0,bs:0,bt:0,bw:0,by:0,bz:0,ca:0,cn:0,co:0,dm:0,"do":0,et:0,gt:0,gu:0,hk:0,hn:0,id:0,ie:0,il:0,"in":0,jm:0,jp:0,ke:0,kh:0,kr:0,la:0,mh:0,mm:0,mo:0,mt:0,mx:0,mz:0,ni:0,np:0,nz:0,pa:0,pe:0,ph:0,pk:0,pr:0,py:0,sg:0,sv:0,th:0,tn:0,tt:0,tw:0,um:0,us:0,ve:0,vi:0,ws:0,za:0,zw:0};
var _c79=_c76._region(_c77);
var dow=_c78[_c79];
return (dow===undefined)?1:dow;
};
_c76._region=function(_c7a){
_c7a=i18n.normalizeLocale(_c7a);
var tags=_c7a.split("-");
var _c7b=tags[1];
if(!_c7b){
_c7b={de:"de",en:"us",es:"es",fi:"fi",fr:"fr",he:"il",hu:"hu",it:"it",ja:"jp",ko:"kr",nl:"nl",pt:"br",sv:"se",zh:"cn"}[tags[0]];
}else{
if(_c7b.length==4){
_c7b=tags[2];
}
}
return _c7b;
};
_c76.getWeekend=function(_c7c){
var _c7d={"in":0,af:4,dz:4,ir:4,om:4,sa:4,ye:4,ae:5,bh:5,eg:5,il:5,iq:5,jo:5,kw:5,ly:5,ma:5,qa:5,sd:5,sy:5,tn:5},_c7e={af:5,dz:5,ir:5,om:5,sa:5,ye:5,ae:6,bh:5,eg:6,il:6,iq:6,jo:6,kw:6,ly:6,ma:6,qa:6,sd:6,sy:6,tn:6},_c7f=_c76._region(_c7c),_c80=_c7d[_c7f],end=_c7e[_c7f];
if(_c80===undefined){
_c80=6;
}
if(end===undefined){
end=0;
}
return {start:_c80,end:end};
};
return _c76;
});
},"dijit/MenuBar":function(){
define(["dojo/_base/declare","dojo/_base/event","dojo/keys","./_MenuBase","dojo/text!./templates/MenuBar.html"],function(_c81,_c82,keys,_c83,_c84){
return _c81("dijit.MenuBar",_c83,{templateString:_c84,baseClass:"dijitMenuBar",_isMenuBar:true,postCreate:function(){
this.inherited(arguments);
var l=this.isLeftToRight();
this.connectKeyNavHandlers(l?[keys.LEFT_ARROW]:[keys.RIGHT_ARROW],l?[keys.RIGHT_ARROW]:[keys.LEFT_ARROW]);
this._orient=["below"];
},_moveToPopup:function(evt){
if(this.focusedChild&&this.focusedChild.popup&&!this.focusedChild.disabled){
this.onItemClick(this.focusedChild,evt);
}
},focusChild:function(item){
var _c85=this.focusedChild,_c86=_c85&&_c85.popup&&_c85.popup.isShowingNow;
this.inherited(arguments);
if(_c86&&item.popup&&!item.disabled){
this._openPopup(true);
}
},_onKeyPress:function(evt){
if(evt.ctrlKey||evt.altKey){
return;
}
switch(evt.charOrCode){
case keys.DOWN_ARROW:
this._moveToPopup(evt);
_c82.stop(evt);
}
},onItemClick:function(item,evt){
if(item.popup&&item.popup.isShowingNow&&(evt.type!=="keypress"||evt.keyCode!==keys.DOWN_ARROW)){
item.popup.onCancel();
}else{
this.inherited(arguments);
}
}});
});
},"dijit/ToolbarSeparator":function(){
define(["dojo/_base/declare","dojo/dom","./_Widget","./_TemplatedMixin"],function(_c87,dom,_c88,_c89){
return _c87("dijit.ToolbarSeparator",[_c88,_c89],{templateString:"<div class=\"dijitToolbarSeparator dijitInline\" role=\"presentation\"></div>",buildRendering:function(){
this.inherited(arguments);
dom.setSelectable(this.domNode,false);
},isFocusable:function(){
return false;
}});
});
},"davinci/html/CSSAtRule":function(){
define(["dojo/_base/declare","davinci/html/CSSElement"],function(_c8a,_c8b){
return _c8a("davinci.html.CSSAtRule",_c8b,{constructor:function(){
this.elementType="CSSAtRule";
},getCSSFile:function(){
return this.parent;
},getText:function(_c8c){
s="@";
s=s+this.name+" "+this.value+"\n";
return s;
}});
});
},"dijit/layout/StackController":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/on","../focus","../registry","../_Widget","../_TemplatedMixin","../_Container","../form/ToggleButton","dojo/i18n!../nls/common"],function(_c8d,_c8e,_c8f,_c90,keys,lang,on,_c91,_c92,_c93,_c94,_c95,_c96){
var _c97=_c8e("dijit.layout._StackButton",_c96,{tabIndex:"-1",closeButton:false,_aria_attr:"aria-selected",buildRendering:function(evt){
this.inherited(arguments);
(this.focusNode||this.domNode).setAttribute("role","tab");
}});
var _c98=_c8e("dijit.layout.StackController",[_c93,_c94,_c95],{baseClass:"dijitStackController",templateString:"<span role='tablist' data-dojo-attach-event='onkeypress'></span>",containerId:"",buttonWidget:_c97,buttonWidgetCloseClass:"dijitStackCloseButton",constructor:function(_c99){
this.pane2button={};
},postCreate:function(){
this.inherited(arguments);
this.subscribe(this.containerId+"-startup","onStartup");
this.subscribe(this.containerId+"-addChild","onAddChild");
this.subscribe(this.containerId+"-removeChild","onRemoveChild");
this.subscribe(this.containerId+"-selectChild","onSelectChild");
this.subscribe(this.containerId+"-containerKeyPress","onContainerKeyPress");
this.connect(this.containerNode,"click",function(evt){
var _c9a=_c92.getEnclosingWidget(evt.target);
if(_c9a!=this.containerNode&&!_c9a.disabled&&_c9a.page){
for(var _c9b=evt.target;_c9b!==this.containerNode;_c9b=_c9b.parentNode){
if(_c8f.contains(_c9b,this.buttonWidgetCloseClass)){
this.onCloseButtonClick(_c9a.page);
break;
}else{
if(_c9b==_c9a.domNode){
this.onButtonClick(_c9a.page);
break;
}
}
}
}
});
},onStartup:function(info){
_c8d.forEach(info.children,this.onAddChild,this);
if(info.selected){
this.onSelectChild(info.selected);
}
var _c9c=_c92.byId(this.containerId).containerNode,_c9d=this.pane2button,_c9e={"title":"label","showtitle":"showLabel","iconclass":"iconClass","closable":"closeButton","tooltip":"title","disabled":"disabled"},_c9f=function(attr,_ca0){
return on(_c9c,"attrmodified-"+attr,function(evt){
var _ca1=_c9d[evt.detail&&evt.detail.widget&&evt.detail.widget.id];
if(_ca1){
_ca1.set(_ca0,evt.detail.newValue);
}
});
};
for(var attr in _c9e){
this.own(_c9f(attr,_c9e[attr]));
}
},destroy:function(){
for(var pane in this.pane2button){
this.onRemoveChild(_c92.byId(pane));
}
this.inherited(arguments);
},onAddChild:function(page,_ca2){
var Cls=lang.isString(this.buttonWidget)?lang.getObject(this.buttonWidget):this.buttonWidget;
var _ca3=new Cls({id:this.id+"_"+page.id,name:this.id+"_"+page.id,label:page.title,disabled:page.disabled,ownerDocument:this.ownerDocument,dir:page.dir,lang:page.lang,textDir:page.textDir,showLabel:page.showTitle,iconClass:page.iconClass,closeButton:page.closable,title:page.tooltip,page:page});
this.addChild(_ca3,_ca2);
this.pane2button[page.id]=_ca3;
page.controlButton=_ca3;
if(!this._currentChild){
this.onSelectChild(page);
}
},onRemoveChild:function(page){
if(this._currentChild===page){
this._currentChild=null;
}
var _ca4=this.pane2button[page.id];
if(_ca4){
this.removeChild(_ca4);
delete this.pane2button[page.id];
_ca4.destroy();
}
delete page.controlButton;
},onSelectChild:function(page){
if(!page){
return;
}
if(this._currentChild){
var _ca5=this.pane2button[this._currentChild.id];
_ca5.set("checked",false);
_ca5.focusNode.setAttribute("tabIndex","-1");
}
var _ca6=this.pane2button[page.id];
_ca6.set("checked",true);
this._currentChild=page;
_ca6.focusNode.setAttribute("tabIndex","0");
var _ca7=_c92.byId(this.containerId);
_ca7.containerNode.setAttribute("aria-labelledby",_ca6.id);
},onButtonClick:function(page){
var _ca8=this.pane2button[page.id];
_c91.focus(_ca8.focusNode);
if(this._currentChild&&this._currentChild.id===page.id){
_ca8.set("checked",true);
}
var _ca9=_c92.byId(this.containerId);
_ca9.selectChild(page);
},onCloseButtonClick:function(page){
var _caa=_c92.byId(this.containerId);
_caa.closeChild(page);
if(this._currentChild){
var b=this.pane2button[this._currentChild.id];
if(b){
_c91.focus(b.focusNode||b.domNode);
}
}
},adjacent:function(_cab){
if(!this.isLeftToRight()&&(!this.tabPosition||/top|bottom/.test(this.tabPosition))){
_cab=!_cab;
}
var _cac=this.getChildren();
var idx=_c8d.indexOf(_cac,this.pane2button[this._currentChild.id]),_cad=_cac[idx];
var _cae;
do{
idx=(idx+(_cab?1:_cac.length-1))%_cac.length;
_cae=_cac[idx];
}while(_cae.disabled&&_cae!=_cad);
return _cae;
},onkeypress:function(e){
if(this.disabled||e.altKey){
return;
}
var _caf=null;
if(e.ctrlKey||!e._djpage){
switch(e.charOrCode){
case keys.LEFT_ARROW:
case keys.UP_ARROW:
if(!e._djpage){
_caf=false;
}
break;
case keys.PAGE_UP:
if(e.ctrlKey){
_caf=false;
}
break;
case keys.RIGHT_ARROW:
case keys.DOWN_ARROW:
if(!e._djpage){
_caf=true;
}
break;
case keys.PAGE_DOWN:
if(e.ctrlKey){
_caf=true;
}
break;
case keys.HOME:
var _cb0=this.getChildren();
for(var idx=0;idx<_cb0.length;idx++){
var _cb1=_cb0[idx];
if(!_cb1.disabled){
this.onButtonClick(_cb1.page);
break;
}
}
_c90.stop(e);
break;
case keys.END:
var _cb0=this.getChildren();
for(var idx=_cb0.length-1;idx>=0;idx--){
var _cb1=_cb0[idx];
if(!_cb1.disabled){
this.onButtonClick(_cb1.page);
break;
}
}
_c90.stop(e);
break;
case keys.DELETE:
if(this._currentChild.closable){
this.onCloseButtonClick(this._currentChild);
}
_c90.stop(e);
break;
default:
if(e.ctrlKey){
if(e.charOrCode===keys.TAB){
this.onButtonClick(this.adjacent(!e.shiftKey).page);
_c90.stop(e);
}else{
if(e.charOrCode=="w"){
if(this._currentChild.closable){
this.onCloseButtonClick(this._currentChild);
}
_c90.stop(e);
}
}
}
}
if(_caf!==null){
this.onButtonClick(this.adjacent(_caf).page);
_c90.stop(e);
}
}
},onContainerKeyPress:function(info){
info.e._djpage=info.page;
this.onkeypress(info.e);
}});
_c98.StackButton=_c97;
return _c98;
});
},"dojox/grid/_RowManager":function(){
define(["dojo/_base/declare","dojo/_base/lang","dojo/dom-class"],function(_cb2,lang,_cb3){
var _cb4=function(_cb5,_cb6){
if(_cb5.style.cssText==undefined){
_cb5.setAttribute("style",_cb6);
}else{
_cb5.style.cssText=_cb6;
}
};
return _cb2("dojox.grid._RowManager",null,{constructor:function(_cb7){
this.grid=_cb7;
},linesToEms:2,overRow:-2,prepareStylingRow:function(_cb8,_cb9){
return {index:_cb8,node:_cb9,odd:Boolean(_cb8&1),selected:!!this.grid.selection.isSelected(_cb8),over:this.isOver(_cb8),customStyles:"",customClasses:"dojoxGridRow"};
},styleRowNode:function(_cba,_cbb){
var row=this.prepareStylingRow(_cba,_cbb);
this.grid.onStyleRow(row);
this.applyStyles(row);
},applyStyles:function(_cbc){
var i=_cbc;
i.node.className=i.customClasses;
var h=i.node.style.height;
_cb4(i.node,i.customStyles+";"+(i.node._style||""));
i.node.style.height=h;
},updateStyles:function(_cbd){
this.grid.updateRowStyles(_cbd);
},setOverRow:function(_cbe){
var last=this.overRow;
this.overRow=_cbe;
if((last!=this.overRow)&&(lang.isString(last)||last>=0)){
this.updateStyles(last);
}
this.updateStyles(this.overRow);
},isOver:function(_cbf){
return (this.overRow==_cbf&&!_cb3.contains(this.grid.domNode,"dojoxGridColumnResizing"));
}});
});
},"davinci/ve/commands/ResizeCommand":function(){
define(["dojo/_base/declare","dojo/dom-geometry","davinci/ve/widget","davinci/ve/States","davinci/ve/utils/StyleArray"],function(_cc0,_cc1,_cc2,_cc3,_cc4){
return _cc0("davinci.ve.commands.ResizeCommand",null,{name:"resize",constructor:function(_cc5,_cc6,_cc7,_cc8){
this._id=(_cc5?_cc5.id:undefined);
var _cc9=/^\s*[-+]?[0-9]*\.?[0-9]+\s*$/;
if(_cc9.test(_cc6)){
_cc6=parseFloat(_cc6);
}
if(_cc9.test(_cc7)){
_cc7=parseFloat(_cc7);
}
this._newBox={w:_cc6,h:_cc7};
this._applyToStateIndex=(!_cc8||_cc8=="Normal"||_cc8=="undefined")?"undefined":_cc8;
},execute:function(){
if(!this._id||!this._newBox){
return;
}
var _cca=_cc2.byId(this._id);
if(!_cca||!_cca.domNode){
return;
}
var node=_cca.domNode;
var cs=node.ownerDocument.defaultView.getComputedStyle(node);
var _ccb=_cc1.getContentBox(node,cs);
this._oldBox={w:_ccb.w,h:_ccb.h};
var w=this._newBox.w;
var h=this._newBox.h;
if(this._usesBorderBox(node)){
var pb=_cc1.getPadBorderExtents(node,cs);
if(typeof w=="number"&&w>=0){
w+=pb.w;
}
if(typeof h=="number"&&h>=0){
h+=pb.h;
}
}
var _ccc=[{}];
if(typeof w=="number"){
_ccc[0].width=w+"px";
}else{
if(typeof w=="string"){
_ccc[0].width=w;
}
}
if(typeof h=="number"){
_ccc[0].height=h+"px";
}else{
if(typeof h=="string"){
_ccc[0].height=h;
}
}
var _ccd=_cca.getStyleValuesAllStates();
this._oldStyleValuesAllStates=dojo.clone(_ccd);
if(this._oldBox){
this._oldStyleValuesAllStates[this._applyToStateIndex]=_cc4.mergeStyleArrays(this._oldStyleValuesAllStates[this._applyToStateIndex],[{width:this._oldBox.w+"px"},{height:this._oldBox.h+"px"}]);
}
if(_ccd[this._applyToStateIndex]){
_ccd[this._applyToStateIndex]=_cc4.mergeStyleArrays(_ccd[this._applyToStateIndex],_ccc);
}else{
_ccd[this._applyToStateIndex]=_ccc;
}
_cca.setStyleValuesAllStates(_ccd);
var _cce=_cc3.getStatesListCurrent(_cca.domNode);
var _ccf=_cc4.mergeStyleArrays([],_ccd["undefined"]);
for(var i=0;i<_cce.length;i++){
if(_ccd[_cce[i]]){
_ccf=_cc4.mergeStyleArrays(_ccf,_ccd[_cce[i]]);
}
}
_cca.setStyleValuesCanvas(_ccf);
_cca.setStyleValuesModel(_ccd["undefined"]);
this._resize(_cca);
_cc3.resetState(_cca.domNode);
dojo.publish("/davinci/ui/widgetPropertiesChanged",[[_cca]]);
},setContext:function(_cd0){
this._context=_cd0;
},undo:function(){
if(!this._id){
return;
}
var _cd1=_cc2.byId(this._id);
if(!_cd1){
return;
}
var _cd2=this._oldStyleValuesAllStates;
var _cd3=this._applyToStateIndex;
_cd1.setStyleValuesAllStates(_cd2);
var _cd4=_cc4.mergeStyleArrays(_cd2["undefined"],_cd2[_cd3]);
_cd1.setStyleValuesCanvas(_cd4);
_cd1.setStyleValuesModel(this._oldStyleValuesAllStates["undefined"]);
this._resize(_cd1);
_cc3.resetState(_cd1.domNode);
dojo.publish("/davinci/ui/widgetPropertiesChanged",[[_cd1]]);
},_usesBorderBox:function(node){
var _cd5=node.tagName.toLowerCase();
var type=node.getAttribute("type");
if(type){
type=type.toLowerCase(type);
}
return _cd5=="table"||_cd5=="button"||(_cd5=="input"&&type=="button");
},_resize:function(_cd6){
var _cd7=_cd6.getParent();
if(_cd7&&_cd7.dijitWidget&&_cd7.dijitWidget.isLayoutContainer){
_cd7.resize();
}else{
if(_cd6.resize){
_cd6.resize();
}
}
_cd6.renderWidget();
_cd6._updateSrcStyle();
}});
});
},"davinci/html/CSSImport":function(){
define(["dojo/_base/declare","davinci/html/CSSElement","davinci/model/Path","davinci/html/CSSFile"],function(_cd8,_cd9,Path,_cda){
return _cd8("davinci.html.CSSImport",_cd9,{constructor:function(){
this.elementType="CSSImport";
},getCSSFile:function(){
return this.parent;
},setUrl:function(url){
this.url=url;
},visit:function(_cdb){
if(!_cdb.visit(this)){
for(var i=0;i<this.children.length;i++){
this.children[i].visit(_cdb);
}
if(this.cssFile){
this.cssFile.visit(_cdb);
}
}
if(_cdb.endVisit){
_cdb.endVisit(this);
}
},getText:function(_cdc){
s="@import ";
if(this.isURL){
s+="url(\""+this.url+"\");";
}else{
s+="\""+this.url+"\";";
}
return s;
},close:function(_cdd){
require("davinci/model/Factory").closeModel(this.cssFile);
if(this.connection){
dojo.disconnect(this.connection);
}
delete this.connection;
},load:function(_cde){
var p=this.parent;
while(p&&!(p.url||p.fileName)){
p=p.parent;
}
var path=new Path(p.url||p.fileName);
path=path.getParentPath().append(this.url);
var _cdf=path.toString();
this.cssFile=require("davinci/model/Factory").getModel({url:_cdf,loader:this.parent.loader,includeImports:this.parent.includeImports||_cde});
this.cssFile.relativeURL=this.url;
this.connection=dojo.connect(this.cssFile,"onChange",this.parent,"onChange");
}});
});
},"davinci/ui/Dialog":function(){
define(["dojo/_base/declare","dijit/form/Button","dijit/Dialog","dojo/dom-geometry","dojo/dom-style","dojo/_base/connect","dojo/window","dojo/parser","dojo/i18n!davinci/ve/nls/common","dojox/layout/ResizeHandle",],function(_ce0,_ce1,_ce2,_ce3,_ce4,_ce5,_ce6,_ce7,_ce8,_ce9){
var _cea=_ce0(_ce2,{contentStyle:null,buildRendering:function(){
this.inherited(arguments);
dojo.addClass(this.domNode,"resizableDialog");
if(this.submitOnEnter){
dojo.addClass(this.domNode,"submitOnEnter");
}
},_setContent:function(cont,_ceb){
this.inherited(arguments);
var div=dojo.doc.createElement("div");
this.containerNode.appendChild(div);
new _ce9({targetId:this.id},div);
var _cec=dojo.query(".dijitDialogPaneContentArea",this.containerNode)[0];
if(_cec){
dojo.connect(_cec,"onkeydown",this,"_onKeyDown");
}else{
dojo.connect(this.domNode,"onkeydown",this,"_onKeyDown");
}
},resize:function(_ced){
if(_ced){
var _cee=_ce4.getComputedStyle(this.containerNode);
var _cef=_ce3.getPadExtents(this.containerNode,_cee);
var c={w:_ced.w-_cef.w,h:_ced.h-_cef.h};
c.h-=_ce3.getMarginBox(this.titleBar).h;
var _cf0=dojo.query(".dijitDialogPaneContentArea",this.containerNode)[0];
var _cf1=dojo.query(".dijitDialogPaneActionBar",this.containerNode)[0];
c.h-=_ce3.getMarginBox(_cf1).h;
if(c.w){
dojo.style(_cf0,"width",c.w+"px");
}
if(c.h){
dojo.style(_cf0,"height",c.h+"px");
}
dojo.forEach(this.getChildren(),dojo.hitch(this,function(_cf2){
if(_cf2.resize){
_cf2.resize({w:c.w,h:c.h});
}
}));
}
},show:function(){
var _cf3=this.inherited(arguments);
if(this.contentStyle){
if(typeof (this.contentStyle)=="object"){
var r={};
if(this.contentStyle.width){
r.w=parseInt(this.contentStyle.width);
}
if(this.contentStyle.height){
r.h=parseInt(this.contentStyle.height);
}
var _cf4=_ce6.getBox(this.ownerDocument);
_cf4.w*=this.maxRatio;
_cf4.h*=this.maxRatio;
if(r.h>_cf4.h){
var _cf5=_ce3.position(this.containerNode),w=Math.min(r.w,_cf4.w)-(r.w-_cf5.w),h=Math.min(r.h,_cf4.h)-(r.h-_cf5.h);
r.h=_cf4.h;
}
this.resize(r);
}
this._size();
this._position();
dojo.style(this.containerNode,"width","auto");
dojo.style(this.containerNode,"height","auto");
}
return _cf3;
},_onKeyDown:function(e){
var _cf6=((e.ctrlKey&&!dojo.isMac)||(dojo.isMac&&e.metaKey));
if(e.which==dojo.keys.ENTER&&(_cf6||this.submitOnEnter)){
var _cf7=dojo.query("input[type=submit]",this.containerNode);
if(_cf7.length>0){
var b=dijit.getEnclosingWidget(_cf7[0]);
var evt=document.createEvent("MouseEvents");
evt.initMouseEvent("click",true,true,window,0,0,0,0,0,false,false,false,false,0,null);
b._onClick(evt);
}
}
}});
_cea._timedDestroy=function(_cf8,_cf9){
if(_cf9){
_cf9.forEach(_ce5.disconnect);
}
var hndl=_ce5.connect(_cf8,"onHide",function(){
_ce5.disconnect(hndl);
_cf8.destroyRecursive();
});
_cf8.hide();
};
_cea.showModal=function(_cfa,_cfb,_cfc,_cfd,_cfe,_cff){
var _d00=[];
var _d01={title:_cfb,content:_cfa,contentStyle:_cfc,submitOnEnter:_cfe};
if(_cff){
_d01.onShow=_cff;
}
var _d02=new _cea(_d01);
var _d03=dojo.hitch(this,function(){
var _d04=false;
if(_cfd){
_d04=_cfd();
}
if(_d04){
return;
}
this._timedDestroy(_d02,_d00);
});
_d00.push(_ce5.connect(_d02,"onExecute",_cfa,_d03));
if(_cfa.onExecute){
_d00.push(_ce5.connect(_cfa,"onExecute",_cfa,_d03));
}
_d00.push(_ce5.connect(_cfa,"onClose",dojo.hitch(this,function(){
this._timedDestroy(_d02,_d00);
})));
_d00.push(_ce5.connect(_d02,"onCancel",dojo.hitch(this,function(){
this._timedDestroy(_d02,_d00);
})));
_d02.show();
return _d02;
},_cea.showMessage=function(_d05,_d06,_d07,_d08,_d09){
return this.showDialog({title:_d05,content:_d06,style:_d07,okCallback:_d08,okLabel:null,hideCancel:true});
},_cea.showDialog=function(_d0a){
var _d0b=_d0a.title;
var _d0c=_d0a.content;
var _d0d=_d0a.style;
var _d0e=_d0a.okCallback;
var _d0f=_d0a.okLabel;
var _d10=_d0a.hideCancel;
var _d11=_d0a.submitOnEnter;
var _d12=_d0a.extendLabels;
var _d13=_d0a.extendCallbacks;
var _d14;
var _d15=[];
var _d16=document.createElement("div");
var _d17=document.createElement("div");
dojo.addClass(_d17,"dijitDialogPaneContentArea");
_d16.appendChild(_d17);
var _d18=document.createElement("div");
dojo.addClass(_d18,"dijitDialogPaneActionBar");
var _d19=new _ce1({label:_d0f?_d0f:_ce8.ok,type:"submit","class":"maqPrimaryButton"});
_d18.appendChild(_d19.domNode);
var _d1a=dojo.hitch(this,function(){
this._timedDestroy(_d14,_d15);
});
if(_d12&&_d13&&_d12.length>0&&_d12.length===_d13.length){
for(var i=0;i<_d12.length;i++){
var _d1b=function(i){
if(_d13[i]){
_d13[i]();
}
_d14.onCancel();
}.bind(this,i);
_d18.appendChild(new _ce1({label:_d12[i],onClick:_d1b,"class":"maqSecondaryButton"}).domNode);
}
}
if(!_d10){
function _d1c(){
_d14.onCancel();
};
_d18.appendChild(new _ce1({label:_ce8.cancel,onClick:_d1c,"class":"maqSecondaryButton"}).domNode);
}
_d16.appendChild(_d18);
_d14=new _cea({title:_d0b,content:_d16,contentStyle:_d0d,submitOnEnter:_d11});
if(dojo.isString(_d0c)){
_d17.innerHTML=_d0c;
_ce7.parse(_d17);
}else{
if(_d0c.domNode){
_d17.appendChild(_d0c.domNode);
}else{
_d17.appendChild(_d0c);
}
}
_d15.push(_ce5.connect(_d14,"onExecute",dojo.hitch(this,function(){
if(_d0e){
_d0e();
}
_d1a();
})));
_d15.push(_ce5.connect(_d14,"onCancel",dojo.hitch(this,function(){
_d1a();
})));
_d14.show();
return _d14;
};
return _cea;
});
},"dojox/validate/regexp":function(){
define(["dojo/_base/lang","dojo/regexp","dojox/main"],function(lang,_d1d,_d1e){
var _d1f=lang.getObject("validate.regexp",true,_d1e);
_d1f=_d1e.validate.regexp={ipAddress:function(_d20){
_d20=(typeof _d20=="object")?_d20:{};
if(typeof _d20.allowDottedDecimal!="boolean"){
_d20.allowDottedDecimal=true;
}
if(typeof _d20.allowDottedHex!="boolean"){
_d20.allowDottedHex=true;
}
if(typeof _d20.allowDottedOctal!="boolean"){
_d20.allowDottedOctal=true;
}
if(typeof _d20.allowDecimal!="boolean"){
_d20.allowDecimal=true;
}
if(typeof _d20.allowHex!="boolean"){
_d20.allowHex=true;
}
if(typeof _d20.allowIPv6!="boolean"){
_d20.allowIPv6=true;
}
if(typeof _d20.allowHybrid!="boolean"){
_d20.allowHybrid=true;
}
var _d21="((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])";
var _d22="(0[xX]0*[\\da-fA-F]?[\\da-fA-F]\\.){3}0[xX]0*[\\da-fA-F]?[\\da-fA-F]";
var _d23="(0+[0-3][0-7][0-7]\\.){3}0+[0-3][0-7][0-7]";
var _d24="(0|[1-9]\\d{0,8}|[1-3]\\d{9}|4[01]\\d{8}|42[0-8]\\d{7}|429[0-3]\\d{6}|"+"4294[0-8]\\d{5}|42949[0-5]\\d{4}|429496[0-6]\\d{3}|4294967[01]\\d{2}|42949672[0-8]\\d|429496729[0-5])";
var _d25="0[xX]0*[\\da-fA-F]{1,8}";
var _d26="([\\da-fA-F]{1,4}\\:){7}[\\da-fA-F]{1,4}";
var _d27="([\\da-fA-F]{1,4}\\:){6}"+"((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])";
var a=[];
if(_d20.allowDottedDecimal){
a.push(_d21);
}
if(_d20.allowDottedHex){
a.push(_d22);
}
if(_d20.allowDottedOctal){
a.push(_d23);
}
if(_d20.allowDecimal){
a.push(_d24);
}
if(_d20.allowHex){
a.push(_d25);
}
if(_d20.allowIPv6){
a.push(_d26);
}
if(_d20.allowHybrid){
a.push(_d27);
}
var _d28="";
if(a.length>0){
_d28="("+a.join("|")+")";
}
return _d28;
},host:function(_d29){
_d29=(typeof _d29=="object")?_d29:{};
if(typeof _d29.allowIP!="boolean"){
_d29.allowIP=true;
}
if(typeof _d29.allowLocal!="boolean"){
_d29.allowLocal=false;
}
if(typeof _d29.allowPort!="boolean"){
_d29.allowPort=true;
}
if(typeof _d29.allowNamed!="boolean"){
_d29.allowNamed=false;
}
var _d2a="(?:[\\da-zA-Z](?:[-\\da-zA-Z]{0,61}[\\da-zA-Z])?)";
var _d2b="(?:[a-zA-Z](?:[-\\da-zA-Z]{0,6}[\\da-zA-Z])?)";
var _d2c=_d29.allowPort?"(\\:\\d+)?":"";
var _d2d="((?:"+_d2a+"\\.)+"+_d2b+"\\.?)";
if(_d29.allowIP){
_d2d+="|"+_d1f.ipAddress(_d29);
}
if(_d29.allowLocal){
_d2d+="|localhost";
}
if(_d29.allowNamed){
_d2d+="|^[^-][a-zA-Z0-9_-]*";
}
return "("+_d2d+")"+_d2c;
},url:function(_d2e){
_d2e=(typeof _d2e=="object")?_d2e:{};
if(!("scheme" in _d2e)){
_d2e.scheme=[true,false];
}
var _d2f=_d1d.buildGroupRE(_d2e.scheme,function(q){
if(q){
return "(https?|ftps?)\\://";
}
return "";
});
var _d30="(/(?:[^?#\\s/]+/)*(?:[^?#\\s/]+(?:\\?[^?#\\s/]*)?(?:#[A-Za-z][\\w.:-]*)?)?)?";
return _d2f+_d1f.host(_d2e)+_d30;
},emailAddress:function(_d31){
_d31=(typeof _d31=="object")?_d31:{};
if(typeof _d31.allowCruft!="boolean"){
_d31.allowCruft=false;
}
_d31.allowPort=false;
var _d32="([!#-'*+\\-\\/-9=?A-Z^-~]+[.])*[!#-'*+\\-\\/-9=?A-Z^-~]+";
var _d33=_d32+"@"+_d1f.host(_d31);
if(_d31.allowCruft){
_d33="<?(mailto\\:)?"+_d33+">?";
}
return _d33;
},emailAddressList:function(_d34){
_d34=(typeof _d34=="object")?_d34:{};
if(typeof _d34.listSeparator!="string"){
_d34.listSeparator="\\s;,";
}
var _d35=_d1f.emailAddress(_d34);
var _d36="("+_d35+"\\s*["+_d34.listSeparator+"]\\s*)*"+_d35+"\\s*["+_d34.listSeparator+"]?\\s*";
return _d36;
},numberFormat:function(_d37){
_d37=(typeof _d37=="object")?_d37:{};
if(typeof _d37.format=="undefined"){
_d37.format="###-###-####";
}
var _d38=function(_d39){
return _d1d.escapeString(_d39,"?").replace(/\?/g,"\\d?").replace(/#/g,"\\d");
};
return _d1d.buildGroupRE(_d37.format,_d38);
},ca:{postalCode:function(){
return "([A-Z][0-9][A-Z] [0-9][A-Z][0-9])";
},province:function(){
return "(AB|BC|MB|NB|NL|NS|NT|NU|ON|PE|QC|SK|YT)";
}},us:{state:function(_d3a){
_d3a=(typeof _d3a=="object")?_d3a:{};
if(typeof _d3a.allowTerritories!="boolean"){
_d3a.allowTerritories=true;
}
if(typeof _d3a.allowMilitary!="boolean"){
_d3a.allowMilitary=true;
}
var _d3b="AL|AK|AZ|AR|CA|CO|CT|DE|DC|FL|GA|HI|ID|IL|IN|IA|KS|KY|LA|ME|MD|MA|MI|MN|MS|MO|MT|"+"NE|NV|NH|NJ|NM|NY|NC|ND|OH|OK|OR|PA|RI|SC|SD|TN|TX|UT|VT|VA|WA|WV|WI|WY";
var _d3c="AS|FM|GU|MH|MP|PW|PR|VI";
var _d3d="AA|AE|AP";
if(_d3a.allowTerritories){
_d3b+="|"+_d3c;
}
if(_d3a.allowMilitary){
_d3b+="|"+_d3d;
}
return "("+_d3b+")";
}}};
return _d1f;
});
},"dojo/dnd/Mover":function(){
define(["../_base/array","../_base/declare","../_base/event","../_base/lang","../sniff","../_base/window","../dom","../dom-geometry","../dom-style","../Evented","../on","../touch","./common","./autoscroll"],function(_d3e,_d3f,_d40,lang,has,win,dom,_d41,_d42,_d43,on,_d44,dnd,_d45){
return _d3f("dojo.dnd.Mover",[_d43],{constructor:function(node,e,host){
this.node=dom.byId(node);
this.marginBox={l:e.pageX,t:e.pageY};
this.mouseButton=e.button;
var h=(this.host=host),d=node.ownerDocument;
this.events=[on(d,_d44.move,lang.hitch(this,"onFirstMove")),on(d,_d44.move,lang.hitch(this,"onMouseMove")),on(d,_d44.release,lang.hitch(this,"onMouseUp")),on(d,"dragstart",_d40.stop),on(d.body,"selectstart",_d40.stop)];
_d45.autoScrollStart(d);
if(h&&h.onMoveStart){
h.onMoveStart(this);
}
},onMouseMove:function(e){
_d45.autoScroll(e);
var m=this.marginBox;
this.host.onMove(this,{l:m.l+e.pageX,t:m.t+e.pageY},e);
_d40.stop(e);
},onMouseUp:function(e){
if(has("webkit")&&has("mac")&&this.mouseButton==2?e.button==0:this.mouseButton==e.button){
this.destroy();
}
_d40.stop(e);
},onFirstMove:function(e){
var s=this.node.style,l,t,h=this.host;
switch(s.position){
case "relative":
case "absolute":
l=Math.round(parseFloat(s.left))||0;
t=Math.round(parseFloat(s.top))||0;
break;
default:
s.position="absolute";
var m=_d41.getMarginBox(this.node);
var b=win.doc.body;
var bs=_d42.getComputedStyle(b);
var bm=_d41.getMarginBox(b,bs);
var bc=_d41.getContentBox(b,bs);
l=m.l-(bc.l-bm.l);
t=m.t-(bc.t-bm.t);
break;
}
this.marginBox.l=l-this.marginBox.l;
this.marginBox.t=t-this.marginBox.t;
if(h&&h.onFirstMove){
h.onFirstMove(this,e);
}
this.events.shift().remove();
},destroy:function(){
_d3e.forEach(this.events,function(_d46){
_d46.remove();
});
var h=this.host;
if(h&&h.onMoveStop){
h.onMoveStop(this);
}
this.events=this.node=this.host=null;
}});
});
},"davinci/review/widgets/OpenReviewDialog":function(){
define(["dojo/_base/declare","dijit/_Templated","dijit/_Widget","dijit/Tree","davinci/review/view/CommentExplorerView","davinci/review/model/ReviewTreeModel","davinci/Workbench","dojo/i18n!davinci/ui/nls/ui","dojo/i18n!dijit/nls/common","dojo/text!./templates/OpenReviewDialog.html","dijit/form/Button","dijit/layout/ContentPane"],function(_d47,_d48,_d49,Tree,_d4a,_d4b,_d4c,_d4d,_d4e,_d4f){
return _d47("davinci.ui.widgets.OpenFile",[_d49,_d48],{widgetsInTemplate:true,templateString:_d4f,fileDialogFileName:null,fileDialogParentFolder:null,postMixInProperties:function(){
dojo.mixin(this,_d4d);
dojo.mixin(this,_d4e);
if(!this.finishButtonLabel){
this.finishButtonLabel=_d4d.open;
}
this.inherited(arguments);
},postCreate:function(){
this.inherited(arguments);
var _d50=new _d4b();
this.model=_d50;
var tree=this.tree=new Tree({id:"openReviewDialogTree",persist:false,showRoot:false,model:_d50,labelAttr:"name",childrenAttrs:"children",getIconClass:_d4a.getIconClass,getLabelClass:_d4a.getLabelClass,transforms:_d4a.getSortTransforms()});
this.treeContentPane.set("content",tree);
tree.watch("selectedItems",dojo.hitch(this,this._updateFields));
},startup:function(){
this.tree.startup();
},_updateFields:function(){
this.okButton.set("disabled",true);
this._selectedResource=null;
var _d51=this.tree.get("selectedItems");
if(_d51&&_d51.length==1){
var _d52=_d51[0];
if(_d52.elementType=="ReviewFile"){
this.okButton.set("disabled",false);
this._selectedResource=_d52;
}
}
},_okButton:function(){
if(this._selectedResource){
var item=this._selectedResource;
davinci.Workbench.openEditor({fileName:item,content:item.getText()});
this.cancel=false;
}
},_cancelButton:function(){
this.onClose();
},resize:function(_d53){
this.treeContentPane.resize(_d53);
},onClose:function(){
}});
});
},"dijit/layout/TabContainer":function(){
define(["dojo/_base/lang","dojo/_base/declare","./_TabContainerBase","./TabController","./ScrollingTabController"],function(lang,_d54,_d55,_d56,_d57){
return _d54("dijit.layout.TabContainer",_d55,{useMenu:true,useSlider:true,controllerWidget:"",_makeController:function(_d58){
var cls=this.baseClass+"-tabs"+(this.doLayout?"":" dijitTabNoLayout"),_d56=typeof this.controllerWidget=="string"?lang.getObject(this.controllerWidget):this.controllerWidget;
return new _d56({id:this.id+"_tablist",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,tabPosition:this.tabPosition,doLayout:this.doLayout,containerId:this.id,"class":cls,nested:this.nested,useMenu:this.useMenu,useSlider:this.useSlider,tabStripClass:this.tabStrip?this.baseClass+(this.tabStrip?"":"No")+"Strip":null},_d58);
},postMixInProperties:function(){
this.inherited(arguments);
if(!this.controllerWidget){
this.controllerWidget=(this.tabPosition=="top"||this.tabPosition=="bottom")&&!this.nested?_d57:_d56;
}
}});
});
},"davinci/commands/CompoundCommand":function(){
define(["dojo/_base/declare"],function(_d59){
return _d59("davinci.commands.CompoundCommand",null,{name:"compound",_commands:[],constructor:function(_d5a){
this._commands=[];
if(_d5a){
this._commands=[_d5a];
}
},add:function(_d5b){
if(!_d5b){
return;
}
if(!this._commands){
if(_d5b.name=="compound"){
this._commands=_d5b._commands;
}else{
this._commands=[_d5b];
}
}else{
if(_d5b.name=="compound"){
dojo.forEach(_d5b._commands,function(c){
this.add(c);
},this);
return;
}else{
if(_d5b.name=="modify"){
var id=_d5b._oldId;
for(var i=0;i<this._commands.length;i++){
var c=this._commands[i];
if(c.name=="modify"&&c._oldId==id){
c.add(_d5b);
return;
}
}
}
}
this._commands.push(_d5b);
}
},setContext:function(_d5c){
for(var i=0;i<this._commands.length;i++){
if(this._commands[i].setContext){
this._commands[i].setContext(_d5c);
}
}
},isEmpty:function(){
return (!this._commands||this._commands.length===0);
},execute:function(){
if(!this._commands){
return;
}
for(var i=0;i<this._commands.length;i++){
this._commands[i].execute();
if(this._commands[i]._oldId&&this._commands[i]._newId){
this._oldId=this._commands[i]._oldId;
this._newId=this._commands[i]._newId;
}
}
},undo:function(){
if(!this._commands){
return;
}
for(var i=this._commands.length-1;i>=0;i--){
this._commands[i].undo();
}
}});
});
},"davinci/maqetta/AppStates":function(){
define(["dojo/_base/connect","dojo/dom-style","dojo/dom","dojo/_base/html","dojo/_base/window","dojo/_base/array","dojo/parser","require","dojo/json","dojo/_base/lang"],function(_d5d,_d5e,dom,_d5f,_d60,_d61,_d62,_d63,JSON,lang){
var _d64=function(){
};
_d64.prototype={NORMAL:"Normal",DELTAS_ATTRIBUTE:"data-maq-deltas",DELTAS_ATTRIBUTE_P6:"dvStates",APPSTATES_ATTRIBUTE:"data-maq-appstates",APPSTATES_ATTRIBUTE_P6:"dvStates",reImportant:/^(.*)(!\ *important)(.*)/,isStateContainer:function(node){
return !!(node&&node._maqAppStates);
},getStateContainersForNode:function(node){
var _d65=[];
var n=node;
while(n){
if(n._maqAppStates){
_d65.splice(0,0,n);
}
if(n.tagName=="BODY"){
break;
}
n=n.parentNode;
}
return _d65;
},getAllStateContainers:function(_d66){
var _d67=[];
var that=this;
function _d68(_d69){
if(_d69._maqAppStates){
_d67.push(_d69);
}
var _d6a=that._getChildrenOfNode(_d69);
for(var i=0;i<_d6a.length;i++){
_d68(_d6a[i]);
}
};
_d68(_d66);
return _d67;
},getStatesArray:function(node,_d6b,_d6c,_d6d){
var _d6e=[];
if(node){
var pn=node.parentNode;
while(pn){
if(pn._maqAppStates){
if(pn==_d6d){
_d6e.splice(0,0,{node:pn,oldState:_d6b,newState:_d6c});
}else{
var _d6f=pn._maqAppStates.states?pn._maqAppStates.states.current:undefined;
_d6e.splice(0,0,{node:pn,oldState:_d6f,newState:_d6f});
}
}
if(pn.tagName=="BODY"){
break;
}
pn=pn.parentNode;
}
}
return _d6e;
},findStateContainer:function(node,_d70){
if(node){
var pn=node.parentNode;
while(pn){
if(pn._maqAppStates&&(!_d70||_d70==this.NORMAL||(pn._maqAppStates.states&&pn._maqAppStates.states.indexOf(_d70)>=0))){
return pn;
}
if(pn.tagName=="BODY"){
break;
}
pn=pn.parentNode;
}
}
},getAllStatesForNode:function(node){
var _d71=[this.NORMAL];
if(node){
var pn=node.parentNode;
while(pn){
if(pn._maqAppStates&&pn._maqAppStates.states){
var _d72=pn._maqAppStates.states?pn._maqAppStates.states:[];
for(var i=0;i<_d72.length;i++){
_d71.push(_d72[i]);
}
}
if(pn.tagName=="BODY"){
break;
}
pn=pn.parentNode;
}
}
return _d71;
},getStatesListCurrent:function(node){
var _d73=[];
if(node){
var pn=node.parentNode;
while(pn){
if(pn._maqAppStates){
_d73.splice(0,0,pn._maqAppStates.current);
}
if(pn.tagName=="BODY"){
break;
}
pn=pn.parentNode;
}
}
return _d73;
},getAllCurrentStates:function(_d74){
var _d75=this.getAllStateContainers(_d74);
var _d76=[];
for(var i=0;i<_d75.length;i++){
var node=_d75[i];
var _d77=this.getState(node);
_d76.push({stateContainerNode:node,state:_d77});
}
return _d76;
},getStates:function(node){
var _d78=node&&node._maqAppStates;
var _d79=["Normal"];
if(_d78){
var _d7a=_d78.states?_d78.states:[];
for(var i=0;i<_d7a.length;i++){
var name=_d7a[i];
if(name!="Normal"){
_d79.push(name);
}
}
}
return _d79;
},_getSCNodeFromElemOrEvent:function(_d7b,_d7c){
var node;
if(_d7c&&_d7c.tagName&&_d7c.nodeName){
node=_d7c._maqAppStates?_d7c:this.findStateContainer(_d7c,_d7b);
}else{
if(_d7c&&_d7c.target&&_d7c.currentTarget){
node=_d7c.currentTarget;
if(!node._maqAppStates){
node=this.findStateContainer(node,_d7b);
}
}else{
node=this.getContainer();
}
}
return node;
},_updateSrcState:function(node){
},hasState:function(node,_d7d){
return !!(node&&node._maqAppStates&&node._maqAppStates.states&&node._maqAppStates.states.indexOf(_d7d)>=0);
},getState:function(node){
return node&&node._maqAppStates&&node._maqAppStates.current;
},setState:function(_d7e,_d7f,_d80){
var _d81=_d80?_d80.updateWhenCurrent:false;
var _d82=_d80?_d80.silent:false;
var _d83=_d80?_d80.focus:false;
var node=this._getSCNodeFromElemOrEvent(_d7e,_d7f);
if(!node||!node._maqAppStates||(!_d81&&node._maqAppStates.current==_d7e)){
return;
}
var _d84=node._maqAppStates.current;
if(this.isNormalState(_d7e)){
if(node._maqAppStates.hasOwnProperty("current")){
delete node._maqAppStates.current;
}
_d7e=undefined;
}else{
node._maqAppStates.current=_d7e;
}
if(_d83){
this._setFocus(_d7e,node);
}
if(_d80&&_d80.hasOwnProperty("initial")){
if(_d80.initial){
node._maqAppStates.initial=_d7e;
}else{
if(node._maqAppStates.initial){
delete node._maqAppStates.initial;
}
}
}
if(!_d82){
_d5d.publish("/maqetta/appstates/state/changed",[{node:node,newState:_d7e,oldState:_d84,stateContainerNode:node}]);
}
this._updateSrcState(node,!_d7e);
},getInitial:function(node){
return node&&node._maqAppStates&&node._maqAppStates.initial;
},getFocus:function(_d85){
if(!_d85){
return null;
}
var _d86=this.getAllStateContainers(_d85);
for(var i=0;i<_d86.length;i++){
var _d87=_d86[i]._maqAppStates;
if(_d87&&_d87.hasOwnProperty("focus")){
return {stateContainerNode:_d86[i],state:_d87.focus};
}
}
return null;
},_setFocus:function(_d88,node){
if(!node||!node._maqAppStates){
return;
}
var _d89=(node.ownerDocument&&node.ownerDocument.body);
if(!_d89){
return;
}
var _d8a=this.getFocus(_d89);
if(_d8a&&_d8a.stateContainerNode==node&&_d8a.state==_d88){
return;
}
var _d8b;
var _d8c=this.getAllStateContainers(_d89);
for(var i=0;i<_d8c.length;i++){
_d8b=_d8c[i]._maqAppStates;
if(_d8b){
delete _d8b.focus;
}
}
node._maqAppStates.focus=_d88;
},isNormalState:function(_d8d){
if(arguments.length==0){
_d8d=this.getState();
}
return !_d8d||_d8d==this.NORMAL;
},_styleArrayMixin:function(_d8e,_d8f){
if(_d8f){
for(var j=0;j<_d8f.length;j++){
var _d90=_d8f[j];
for(var _d91 in _d90){
for(var i=_d8e.length-1;i>=0;i--){
var _d92=_d8e[i];
if(_d92.hasOwnProperty(_d91)){
_d8e.splice(i,1);
}
}
}
}
for(var k=0;k<_d8f.length;k++){
_d8e.push(_d8f[k]);
}
}
},getStyle:function(node,_d93,name){
var _d94,_d95=[];
for(var i=0;i<_d93.length;i++){
var _d96=_d93[i];
_d94=node&&node._maqDeltas&&node._maqDeltas[_d96]&&node._maqDeltas[_d96].style;
this._styleArrayMixin(_d95,_d94);
if(arguments.length>2){
if(_d95){
for(var j=_d95.length-1;j>=0;j--){
var item=_d95[j];
for(var prop in item){
if(prop!=name){
_d95.splice(j,1);
break;
}
}
}
}
}
}
return _d95;
},hasStyle:function(node,_d97,name){
if(!node||!name){
return;
}
if(node._maqDeltas&&node._maqDeltas[_d97]&&node._maqDeltas[_d97].style){
var _d98=node._maqDeltas[_d97].style;
for(var i=0;i<_d98[i];i++){
if(_d98[i].hasProperty(name)){
return true;
}
}
}else{
return false;
}
},setStyle:function(node,_d99,_d9a,_d9b){
if(!node||!_d9a){
return;
}
node._maqDeltas=node._maqDeltas||{};
node._maqDeltas[_d99]=node._maqDeltas[_d99]||{};
node._maqDeltas[_d99].style=node._maqDeltas[_d99].style||[];
var _d9c=node._maqDeltas[_d99].style;
if(_d9a){
for(var i=0;i<_d9a.length;i++){
var _d9d=_d9a[i];
for(var _d9e in _d9d){
for(var j=_d9c.length-1;j>=0;j--){
var _d9f=_d9c[j];
for(var _da0 in _d9f){
if(_d9e==_da0){
_d9c.splice(j,1);
break;
}
}
}
}
}
}
var _da1;
if(_d9a){
for(var j=0;j<_d9a.length;j++){
for(var p in _d9a[j]){
var _da2=_d9a[j][p];
if(typeof _da2!="undefined"&&_da2!==null){
if(typeof _da1=="undefined"){
_da1=[];
}
var o={};
o[p]=this._getFormattedValue(p,_da2);
_da1.push(o);
}
}
}
}
if(_d9c&&_da1){
node._maqDeltas[_d99].style=_d9c.concat(_da1);
}else{
if(_d9c){
node._maqDeltas[_d99].style=_d9c;
}else{
if(_da1){
node._maqDeltas[_d99].style=_da1;
}else{
node._maqDeltas[_d99].style=undefined;
}
}
}
if(!_d9b){
_d5d.publish("/davinci/states/state/style/changed",[{node:node,state:_d99,style:_d9a}]);
}
this._updateSrcState(node);
},_convertStyleName:function(name){
if(name.indexOf("-")>=0){
var _da3=name.split("-");
name=_da3[0];
for(var i=1;i<_da3.length;i++){
var n=_da3[i];
name+=(n.charAt(0).toUpperCase()+n.substring(1));
}
}
return name;
},_DYNAMIC_PROPERTIES:{width:1,height:1,top:1,right:1,bottom:1,left:1},_getFormattedValue:function(name,_da4){
if(name in this._DYNAMIC_PROPERTIES){
if(typeof _da4!="string"){
return _da4+"px";
}
var _da5=_d63("dojo/_base/lang").trim(_da4);
if(/^[-+]?[0-9]*\.?[0-9]+$/.test(_da5)){
_da4=_da5+"px";
}
}
return _da4;
},_getStatesListUsingPropName:function(_da6,_da7){
var _da8=[];
if(_da6){
for(var i=0;i<_da6.length;i++){
_da8.push(_da6[i][_da7]);
}
}
return _da8;
},_resetAndCacheNormalStyle:function(node,_da9){
if(!node||!_da9){
return;
}
for(var i=0;i<_da9.length;i++){
var _daa=_da9[i].oldState;
var _dab=this._getStatesListUsingPropName(_da9,"oldState");
var _dac=this.getStyle(node,_dab);
var _dad=this._getStatesListUsingPropName(_da9);
var _dae=this.getStyle(node,_dad);
if(_dac){
for(var j=0;j<_dac.length;j++){
var _daf=_dac[j];
for(var _db0 in _daf){
var _db1=this._convertStyleName(_db0);
node.style[_db1]="";
}
}
}
if(_dae){
for(var k=0;k<_dae.length;k++){
var _db2=_dae[k];
for(var _db3 in _db2){
var _db1=this._convertStyleName(_db3);
var _db4=node.style;
var _db5=this._getFormattedValue(_db3,_db2[_db3])+"";
var _db6=_db5?_db5.match(this.reImportant):null;
if(_db6){
var t=_db6[1]+_db6[3];
t=lang.trim(t);
if(_db4.setProperty){
_db4.setProperty(_db3,t,"important");
}else{
node.style[_db1]=t;
}
}else{
node.style[_db1]=_db5;
}
}
}
}
}
},_update:function(node,_db7){
if(!node||!node._maqDeltas){
return;
}
var _db8=this._getStatesListUsingPropName(_db7,"newState");
var _db9=this.getStyle(node,_db8);
this._resetAndCacheNormalStyle(node,_db7);
if(_db9){
for(var i=0;i<_db9.length;i++){
var _dba=_db9[i];
for(var name in _dba){
var _dbb=this._convertStyleName(name);
var _dbc=_dba[name]+"";
var _dbd=_dbc?_dbc.match(this.reImportant):null;
if(_dbd){
var t=_dbd[1]+_dbd[3];
t=lang.trim(t);
if(_dba.setProperty){
_dba.setProperty(name,t,"important");
}else{
node.style[_dbb]=t;
}
}else{
node.style[_dbb]=_dbc;
}
}
}
}
var _dbe,_dbf;
if(node.id&&node.ownerDocument){
var byId=node.ownerDocument.defaultView.dijit.byId;
if(byId){
_dbe=byId&&byId(node.id);
}
}
if(_dbe&&_dbe.getParent){
_dbf=_dbe.getParent();
}
if(_dbf&&_dbf.resize){
_dbf.resize();
}else{
if(_dbe&&_dbe.resize){
_dbe.resize();
}
}
},isContainer:function(node){
var _dc0=false;
if(node){
var doc=this.getDocument();
if(node===(doc&&doc.body)||node.tagName=="BODY"){
_dc0=true;
}
}
return _dc0;
},getContainer:function(){
return document.body;
},add:function(node,_dc1,_dc2){
if(!node||this.hasState(node,_dc1)){
return;
}
var _dc3=_dc2&&_dc2.index;
node._maqAppStates=node._maqAppStates||{};
node._maqAppStates.states=node._maqAppStates.states||[];
if(typeof _dc3=="number"&&_dc3>=0){
node._maqAppStates.states.splice(_dc3,0,_dc1);
}else{
node._maqAppStates.states.push(_dc1);
}
_d5d.publish("/davinci/states/state/added",[{node:node,state:_dc1}]);
this._updateSrcState(node);
},remove:function(node,_dc4){
if(!node||!node._maqAppStates||!node._maqAppStates.states||!this.hasState(node,_dc4)){
return;
}
var idx=node._maqAppStates.states.indexOf(_dc4);
if(idx<0){
return;
}
var _dc5=this.getState(node);
var body=node.ownerDocument.body;
var _dc6=this.getFocus(body);
node._maqAppStates.states.splice(idx,1);
var _dc7={};
if(_dc6&&_dc6.stateContainerNode==node&&_dc6.state==_dc4){
_dc7.focus=true;
_dc7.updateWhenCurrent=true;
}
if(_dc4==_dc5){
this.setState(undefined,node,_dc7);
}
_d5d.publish("/davinci/states/state/removed",[{node:node,state:_dc4}]);
this._updateSrcState(node);
},rename:function(_dc8,_dc9){
if(!_dc9){
return false;
}
var _dca=_dc9.oldName;
var _dcb=_dc9.newName;
if(!_dc8||!_dc8._maqAppStates||!_dc8._maqAppStates.states||!_dc8._maqAppStates.states.length){
return false;
}
var _dcc=_dc8._maqAppStates.states;
if(_dcc.indexOf(_dca)<0||_dcc.indexOf(_dcb)>=0){
return false;
}
_dcc.splice(_dcc.indexOf(_dca),1,_dcb);
if(_dc8._maqAppStates.focus===_dca){
_dc8._maqAppStates.focus=_dcb;
}
if(_dc8._maqAppStates.current===_dca){
_dc8._maqAppStates.current=_dcb;
}
var _dcd=[_dc8];
var _dce=this.getState(_dc8);
_dcd=_dcd.concat(this._getChildrenOfNode(_dc8));
while(_dcd.length){
var node=_dcd.shift();
if(node._maqDeltas&&node._maqDeltas[_dca]){
node._maqDeltas[_dcb]=node._maqDeltas[_dca];
delete node._maqDeltas[_dca];
}
_dcd=_dcd.concat(this._getChildrenOfNode(node));
var _dcf=this.getStatesArray(node,null,_dcb,_dc8);
this._update(node,_dcf);
this._updateSrcState(node);
}
_d5d.publish("/davinci/states/state/renamed",[{node:node,oldName:_dca,newName:_dcb,stateContainerNode:node}]);
return true;
},_isEmpty:function(_dd0){
for(var name in _dd0){
if(_dd0.hasOwnProperty(name)){
return false;
}
}
return true;
},stringifyWithQuotes:function(o){
str=JSON.stringify(o);
str=str.replace(/(\\)?'/g,function($0,$1){
return $1?$0:"\\'";
});
str=str.replace(/"/g,"'");
return str;
},serialize:function(node){
var that=this;
var _dd1=function(_dd2){
var str=null;
if(node[_dd2]){
var o=_d63("dojo/_base/lang").clone(node[_dd2]);
delete o["undefined"];
if(!that._isEmpty(o)){
str=this.stringifyWithQuotes(o);
}
}
return str;
}.bind(this);
var obj={};
if(!node){
return obj;
}
var _dd3=_dd1("_maqAppStates");
if(typeof _dd3=="string"){
obj.maqAppStates=_dd3;
}
var _dd4=_dd1("_maqDeltas");
if(typeof _dd4=="string"){
obj.maqDeltas=_dd4;
}
return obj;
},deserialize:function(_dd5,_dd6){
if(typeof _dd5=="string"){
_dd5=_dd5.replace(/(\\)?'/g,function($0,$1){
return $1?"'":"\"";
});
_dd5=JSON.parse(_dd5);
this._migrate_m4_m5(_dd5);
_dd5=this._migrate_m6_m7(_dd5,_dd6&&_dd6.isBody);
}
return _dd5;
},_migrate_m4_m5:function(_dd7){
for(var s in _dd7){
var _dd8=_dd7[s];
if(_dd8){
var _dd9=_dd8.style;
if(_dd9&&!_dd9.length){
var _dda=[];
for(var prop in _dd9){
var o={};
o[prop]=_dd9[prop];
_dda.push(o);
}
_dd8.style=_dda;
}
}
}
},_migrate_m6_m7:function(_ddb,_ddc){
if(!_ddb||_ddb.states){
return _ddb;
}
if(_ddc){
var _ddd=[];
for(var s in _ddb){
if(s!="current"){
_ddd.push(s);
}
}
if(_ddd.length>0){
return {states:_ddd};
}else{
return undefined;
}
}else{
delete _ddb.current;
return _ddb;
}
},store:function(node,_dde,_ddf){
if(!node){
return;
}
this.clear(node);
var _de0=(node.tagName=="BODY");
if(_dde){
node._maqAppStates=this.deserialize(_dde,{isBody:_de0});
}
if(_ddf){
node._maqDeltas=this.deserialize(_ddf,{isBody:_de0});
}
_d5d.publish("/davinci/states/stored",[]);
},retrieve:function(node){
if(!node){
return;
}
var _de1=node.getAttribute(this.APPSTATES_ATTRIBUTE);
if(!_de1&&node.tagName==="BODY"){
_de1=node.getAttribute(this.APPSTATES_ATTRIBUTE_P6);
}
var _de2=node.getAttribute(this.DELTAS_ATTRIBUTE);
if(!_de2&&node.tagName!=="BODY"){
_de2=node.getAttribute(this.DELTAS_ATTRIBUTE_P6);
}
return {maqAppStates:_de1,maqDeltas:_de2};
},clear:function(node){
if(!node){
return;
}
if(node._maqAppStates){
delete node._maqAppStates;
}
if(node._maqDeltas){
delete node._maqDeltas;
}
},_parseStyleValues:function(text){
var _de3=[];
if(text){
_d61.forEach(text.split(";"),function(s){
var i=s.indexOf(":");
if(i>0){
var n=s.substring(0,i).trim();
var v=s.substring(i+1).trim();
var o={};
o[n]=v;
_de3.push(o);
}
});
}
return _de3;
},transferElementStyle:function(node,_de4){
if(node){
var _de5=node._maqDeltas;
var _de6=this._parseStyleValues(_de4);
if(!_de5["undefined"]){
_de5["undefined"]={};
}
_de5["undefined"].style=_de6;
}
},getDocument:function(){
return document;
},shouldInitialize:function(){
return !davinci.AppStatesDontInitialize;
},_getChildrenOfNode:function(node){
var _de7=[];
for(var i=0;i<node.childNodes.length;i++){
var n=node.childNodes[i];
if(n.nodeType===1){
_de7.push(n);
}
}
return _de7;
},initialize:function(){
if(!this.subscribed){
_d5d.subscribe("/maqetta/appstates/state/changed",this,function(e){
if(e.editorClass){
return;
}
var _de8=davinci.states._getChildrenOfNode(e.node);
while(_de8.length){
var _de9=_de8.shift();
if(!davinci.states.isContainer(_de9)){
_de8=_de8.concat(davinci.states._getChildrenOfNode(_de9));
}
var _dea=this.getStatesArray(_de9,e.oldState,e.newState,e.stateContainerNode);
davinci.states._update(_de9,_dea);
}
});
this.subscribed=true;
}
}};
if(typeof davinci==="undefined"){
davinci={};
}
var _deb=davinci.states=new _d64();
(function(){
_deb.initialize();
if(_deb.shouldInitialize()){
if(typeof _d63!="undefined"){
_d63(["dojo/_base/lang","dojo/query","dojo/aspect"],function(lang,_dec,_ded){
var _dee=0,_def=false;
var hook=function(_df0){
if(!_def){
_ded.around(_df0,"parse",function(_df1){
var _df2={};
return function(_df3,args){
var root;
if(!args&&_df3&&_df3.rootNode){
args=_df3;
root=args.rootNode;
}else{
root=_df3;
}
root=root?_d5f.byId(root):_d60.body();
_df4(_df2);
var _df5=_df1.apply(this,arguments);
_df6(_df2,root);
return _df5;
};
});
dojo.parser.parse=_df0.parse;
_def=true;
}
};
try{
var _df7=_d63("dojox/mobile/parser");
hook.apply(_df7);
}
catch(e){
}
if(!_df7){
hook.call(null,_d62);
}
var _df4=function(_df8){
var _df9="maqTempClass";
var doc=_deb.getDocument();
if(!doc.body._maqAlreadyPreserved){
var _dfa=davinci.states.retrieve(doc.body);
if(_dfa&&_dfa.maqAppStates){
_df8.body=_dfa.maqAppStates;
}
doc.body._maqAlreadyPreserved=true;
}
_dec("*",doc).forEach(function(node){
var _dfb=node.getAttribute("class");
if(!_dfb){
_dfb="";
}
if(!node._maqAlreadyPreserved&&_dfb.indexOf(_df9)<0){
node._maqAlreadyPreserved=true;
var _dfc=_deb.retrieve(node);
if(node.tagName!="BODY"&&_dfc&&(_dfc.maqAppStates||_dfc.maqDeltas)){
var _dfd=_df9+_dee;
_dfb=_dfb+" "+_dfd;
node.setAttribute("class",_dfb);
_dee++;
_df8[_dfd]={};
if(_dfc.maqAppStates){
_df8[_dfd].maqAppStates=_dfc.maqAppStates;
}
if(_dfc.maqDeltas){
_df8[_dfd].maqDeltas=_dfc.maqDeltas;
}
if(node.style){
_df8[_dfd].style=node.style.cssText;
}else{
console.error("States.js _preserveStates. No value for node.style.");
}
}
}
});
};
var _df6=function(_dfe,_dff){
var doc=_deb.getDocument(),_e00=[],_e01,_e02,_e03,_e04;
for(var id in _dfe){
var node;
if(id=="body"){
node=doc.body;
}else{
node=doc.querySelectorAll("."+id)[0];
}
if(node){
var _e05=(node.tagName=="BODY");
_e01=_e02=_e03=_e04=null;
if(_e05){
_e01=_dfe[id];
}else{
_e01=_dfe[id].maqAppStates;
_e02=_dfe[id].maqDeltas;
}
if(_e01){
_e03=_deb.deserialize(_e01,{isBody:_e05});
}
if(_e02){
_e04=_deb.deserialize(_e02,{isBody:_e05});
}
if(_e03){
if(_e03.initial){
_e03.current=_e03.initial;
}else{
if(_e03.focus){
delete _e03.focus;
}
delete _e03.current;
}
}
_deb.store(node,_e03,_e04);
if(_e02){
davinci.states.transferElementStyle(node,_dfe[id].style);
}
}
}
var _e06=_deb.getAllStateContainers(doc.body);
var _e07=[];
for(var i=0;i<_e06.length;i++){
var _e08=_e06[i];
if(_e08._maqAppStates&&typeof _e08._maqAppStates.current=="string"){
var _e09=_e08._maqAppStates.focus;
_deb.setState(_e08._maqAppStates.current,_e08,{updateWhenCurrent:true,focus:_e09});
}
}
};
});
}
}
})();
if(!davinci.Workbench&&typeof dijit!="undefined"){
_d5d.subscribe("/maqetta/appstates/state/changed",function(args){
var w;
var byId=(args&&args.node&&args.node.ownerDocument&&args.node.ownerDocument.defaultView&&args.node.ownerDocument.defaultView.dijit.byId);
if(byId){
if(args.newState&&!args.newState.indexOf("_show:")){
w=byId(args.newState.substring(6));
w&&w.show&&w.show();
}else{
if(args.oldState&&!args.oldState.indexOf("_show:")){
w=byId(args.oldState.substring(6));
w&&w.hide&&w.hide();
}
}
}
});
}
return _d64;
});
},"url:dijit/templates/Menu.html":"<table class=\"dijit dijitMenu dijitMenuPassive dijitReset dijitMenuTable\" role=\"menu\" tabIndex=\"${tabIndex}\"\n\t   data-dojo-attach-event=\"onkeypress:_onKeyPress\" cellspacing=\"0\">\n\t<tbody class=\"dijitReset\" data-dojo-attach-point=\"containerNode\"></tbody>\n</table>\n","dojo/dnd/Avatar":function(){
define(["../_base/declare","../_base/window","../dom","../dom-attr","../dom-class","../dom-construct","../hccss","../query"],function(_e0a,win,dom,_e0b,_e0c,_e0d,has,_e0e){
return _e0a("dojo.dnd.Avatar",null,{constructor:function(_e0f){
this.manager=_e0f;
this.construct();
},construct:function(){
var a=_e0d.create("table",{"class":"dojoDndAvatar",style:{position:"absolute",zIndex:"1999",margin:"0px"}}),_e10=this.manager.source,node,b=_e0d.create("tbody",null,a),tr=_e0d.create("tr",null,b),td=_e0d.create("td",null,tr),k=Math.min(5,this.manager.nodes.length),i=0;
if(has("highcontrast")){
_e0d.create("span",{id:"a11yIcon",innerHTML:this.manager.copy?"+":"<"},td);
}
_e0d.create("span",{innerHTML:_e10.generateText?this._generateText():""},td);
_e0b.set(tr,{"class":"dojoDndAvatarHeader",style:{opacity:0.9}});
for(;i<k;++i){
if(_e10.creator){
node=_e10._normalizedCreator(_e10.getItem(this.manager.nodes[i].id).data,"avatar").node;
}else{
node=this.manager.nodes[i].cloneNode(true);
if(node.tagName.toLowerCase()=="tr"){
var _e11=_e0d.create("table"),_e12=_e0d.create("tbody",null,_e11);
_e12.appendChild(node);
node=_e11;
}
}
node.id="";
tr=_e0d.create("tr",null,b);
td=_e0d.create("td",null,tr);
td.appendChild(node);
_e0b.set(tr,{"class":"dojoDndAvatarItem",style:{opacity:(9-i)/10}});
}
this.node=a;
},destroy:function(){
_e0d.destroy(this.node);
this.node=false;
},update:function(){
_e0c.toggle(this.node,"dojoDndAvatarCanDrop",this.manager.canDropFlag);
if(has("highcontrast")){
var icon=dom.byId("a11yIcon");
var text="+";
if(this.manager.canDropFlag&&!this.manager.copy){
text="< ";
}else{
if(!this.manager.canDropFlag&&!this.manager.copy){
text="o";
}else{
if(!this.manager.canDropFlag){
text="x";
}
}
}
icon.innerHTML=text;
}
_e0e(("tr.dojoDndAvatarHeader td span"+(has("highcontrast")?" span":"")),this.node).forEach(function(node){
node.innerHTML=this.manager.source.generateText?this._generateText():"";
},this);
},_generateText:function(){
return this.manager.nodes.length.toString();
}});
});
},"url:dijit/layout/templates/TabContainer.html":"<div class=\"dijitTabContainer\">\n\t<div class=\"dijitTabListWrapper\" data-dojo-attach-point=\"tablistNode\"></div>\n\t<div data-dojo-attach-point=\"tablistSpacer\" class=\"dijitTabSpacer ${baseClass}-spacer\"></div>\n\t<div class=\"dijitTabPaneWrapper ${baseClass}-container\" data-dojo-attach-point=\"containerNode\"></div>\n</div>\n","dijit/form/Button":function(){
define(["require","dojo/_base/declare","dojo/dom-class","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/ready","./_FormWidget","./_ButtonMixin","dojo/text!./templates/Button.html"],function(_e13,_e14,_e15,has,_e16,lang,_e17,_e18,_e19,_e1a){
if(has("dijit-legacy-requires")){
_e17(0,function(){
var _e1b=["dijit/form/DropDownButton","dijit/form/ComboButton","dijit/form/ToggleButton"];
_e13(_e1b);
});
}
return _e14("dijit.form.Button",[_e18,_e19],{showLabel:true,iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},baseClass:"dijitButton",templateString:_e1a,_setValueAttr:"valueNode",_onClick:function(e){
var ok=this.inherited(arguments);
if(ok){
if(this.valueNode){
this.valueNode.click();
e.preventDefault();
e.stopPropagation();
}
}
return ok;
},_fillContent:function(_e1c){
if(_e1c&&(!this.params||!("label" in this.params))){
var _e1d=lang.trim(_e1c.innerHTML);
if(_e1d){
this.label=_e1d;
}
}
},_setShowLabelAttr:function(val){
if(this.containerNode){
_e15.toggle(this.containerNode,"dijitDisplayNone",!val);
}
this._set("showLabel",val);
},setLabel:function(_e1e){
_e16.deprecated("dijit.form.Button.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");
this.set("label",_e1e);
},_setLabelAttr:function(_e1f){
this.inherited(arguments);
if(!this.showLabel&&!("title" in this.params)){
this.titleNode.title=lang.trim(this.containerNode.innerText||this.containerNode.textContent||"");
}
}});
});
},"davinci/review/actions/OpenVersionAction":function(){
define(["dojo/_base/declare","./_ReviewNavigatorCommon","davinci/Runtime","dojox/widget/Toaster","dojo/i18n!./nls/actions"],function(_e20,_e21,_e22,_e23,nls){
var _e24=_e20("davinci.review.actions.OpenVersionAction",[_e21],{run:function(_e25){
var _e26=this._getSelection(_e25);
if(!_e26||!_e26.length){
return;
}
var item=_e26[0].resource.elementType=="ReviewFile"?_e26[0].resource.parent:_e26[0].resource;
dojo.xhrGet({url:"cmd/managerVersion",sync:false,handleAs:"text",content:{"type":"open","vTime":item.timeStamp}}).then(function(_e27){
if(_e27=="OK"){
if(typeof hasToaster=="undefined"){
new _e23({position:"br-left",duration:4000,messageTopic:"/davinci/review/resourceChanged"});
hasToaster=true;
}
dojo.publish("/davinci/review/resourceChanged",[{message:nls.openSuccessful,type:"message"},"open",item]);
}
});
},isEnabled:function(_e28){
var _e29=this._getSelection(_e28);
if(!_e29||_e29.length==0){
return false;
}
var item=_e29[0].resource.elementType=="ReviewFile"?_e29[0].resource.parent:_e29[0].resource;
if(item.designerId==_e22.userName){
if(item.closed&&item.closedManual&&!item.isDraft){
return true;
}
}
return false;
}});
return _e24;
});
},"davinci/html/HTMLElement":function(){
define(["dojo/_base/declare","davinci/html/HTMLItem","davinci/html/HTMLText","davinci/html/HTMLComment","davinci/html/HTMLAttribute"],function(_e2a,_e2b,_e2c,_e2d,_e2e){
return _e2a("davinci.html.HTMLElement",_e2b,{constructor:function(tag){
this.elementType="HTMLElement";
this.attributes=[];
this.tag=tag||"";
this._fmChildLine=0;
this._fmChildIndent=0;
},add:function(stmt){
if(!this.statements){
this.statements=[];
}
this.statements.push(stmt);
this.onChange();
},getText:function(_e2f){
_e2f=_e2f||{};
var s="";
var _e30;
_e2f.indent+=2;
s=s+"<"+this.tag;
for(var i=0;i<this.attributes.length;i++){
var _e31=this.attributes[i].getText(_e2f);
if(_e31.length>0){
s=s+" "+_e31;
}
}
if(this.noEndTag){
s=s+"/>";
}else{
s=s+">";
s=s+this._addWS(this._fmChildLine,this._fmChildIndent);
if(this.statements){
for(var i=0;i<this.statements.length;i++){
s=s+this.statements[i].printStatement(_e2f,this.statements[i]);
}
}else{
if(this.script){
s=s+this.script;
}else{
if(this.children.length>0){
var _e32=this.tag=="style";
for(var i=0;i<this.children.length;i++){
s=s+this.children[i].getText(_e2f);
if(_e32){
var _e33=this._fmChildLine,_e34=this._fmChildIndent||0;
if(i+1==this.children.length){
_e33=this._fmLine;
_e34=this._fmIndent;
}
s=s+this._addWS(_e33,_e34);
}
}
}
}
}
if(_e30&&this.children.length>0){
s=s+"\n"+"                                          ".substring(0,_e2f.indent+1);
}
s=s+"</"+this.tag+">";
}
_e2f.indent-=2;
s=s+this._addWS(this._fmLine,this._fmIndent);
return s;
},_formatModel:function(_e35,_e36,_e37){
var _e38=0;
var _e39=1;
if(_e36==undefined){
_e36=this.children.length;
}
function _e3a(_e3b,_e3c,elem){
_e38+=(_e39+_e3b);
if(_e3c){
_e3c._fmChildLine=1;
_e3c._fmChildIndent=_e37.indent;
}else{
elem._fmLine=1;
elem._fmIndent=_e37.indent;
}
};
function _e3d(elem,_e3e){
elem.startOffset=_e38;
elem.wasParsed=true;
_e38+=elem.tag.length+2;
for(var i=0;i<elem.attributes.length;i++){
elem.attributes[i].startOffset=_e38;
var _e3f=elem.attributes[i].getText(_e3e);
if(_e3f.length>0){
_e38+=1+_e3f.length;
}
elem.attributes[i].endOffset=_e38-1;
}
if(elem.noEndTag){
_e38++;
}
elem.startTagOffset=_e38;
var s="";
if(elem.statements){
for(var i=0;i<elem.statements.length;i++){
s=s+elem.statements[i].printStatement(_e3e,elem.statements[i]);
}
}else{
if(elem.script){
s=elem.script;
}
}
if(s){
_e38+=s.length;
}else{
if(elem.children.length>0){
var _e40;
if(!davinci.html._noFormatElements[elem.tag]){
_e3e.indent+=2;
_e3a(_e3e.indent,elem);
_e40=true;
}
var _e41;
for(var i=0;i<elem.children.length;i++){
var _e42=elem.children[i];
switch(_e42.elementType){
case "HTMLElement":
if(_e41&&_e41.elementType!="HTMLText"&&!davinci.html._noFormatElements[_e42.tag]){
_e3a(_e3e.indent,null,_e41);
}
_e3d(_e42,_e3e);
break;
case "HTMLText":
_e42.startOffset=_e38;
_e38+=_e42.value.length;
break;
case "HTMLComment":
_e42.startOffset=_e38;
_e38+=_e42.value.length;
_e38++;
if(_e42.isProcessingInstruction){
_e38+=2;
}
break;
default:
debugger;
}
_e41=_e42;
}
if(_e40){
_e3e.indent-=2;
}
if(_e41&&_e41.elementType!="HTMLText"){
_e3a(_e3e.indent,null,_e41);
}
}
}
_e38+=elem.tag.length+3;
elem.endOffset=_e38-1;
};
var _e43,_e44;
if(!this.children.length||_e36==0){
_e43=this;
_e38=this.startTagOffset+1;
}else{
_e44=this.children[_e36-1];
_e38=_e44.endOffset+1;
}
var _e45=_e38;
if(!davinci.html._noFormatElements[_e35.tag]){
_e3a(_e37.indent,_e43,_e44);
_e35._fmLine=1;
_e35._fmIndent=(_e36<this.children.length)?_e37.indent:_e37.indent-2;
}
_e3d(_e35,_e37);
return (_e38>_e45)?_e38-_e45:0;
},getElementText:function(_e46){
_e46=_e46||{};
var s="";
if(this.children.length>0){
for(var i=0;i<this.children.length;i++){
if(this.children[i].elementType!="HTMLComment"){
s=s+this.children[i].getText(_e46);
}
}
}else{
if(this.script){
return this.script;
}else{
if(this.statements){
for(var i=0;i<this.statements.length;i++){
s=s+this.statements[i].printStatement(_e46,this.statements[i]);
}
}
}
}
return s;
},getChildElements:function(_e47,_e48,_e49){
_e49=_e49||[];
for(var i=0;i<this.children.length;i++){
if(this.children[i].tag==_e47){
_e49.push(this.children[i]);
}
if(_e48&&this.children[i].elementType=="HTMLElement"){
this.children[i].getChildElements(_e47,_e48,_e49);
}
}
return _e49;
},getChildElement:function(_e4a){
for(var i=0;i<this.children.length;i++){
if(this.children[i].tag==_e4a){
return this.children[i];
}
}
},hasAttribute:function(name){
for(var i=0;i<this.attributes.length;i++){
if(this.attributes[i].name==name){
return true;
}
}
return false;
},getAttribute:function(name){
var attr=this._getAttribute(name);
if(attr){
return attr.value;
}
},_getAttribute:function(name){
for(var i=0;i<this.attributes.length;i++){
if(this.attributes[i].name==name){
return this.attributes[i];
}
}
},addText:function(text){
this.addChild(new _e2c(text));
this.onChange();
},addComment:function(text){
this.addChild(new _e2d(text));
this.onChange();
},getLabel:function(){
return "<"+this.tag+">";
},addAttribute:function(name,_e4b,_e4c){
if(name=="textContent"){
this.children=[];
this.addText(_e4b);
return;
}
var _e4d;
var _e4e=(this.attributes.length>0)?this.attributes[this.attributes.length-1].endOffset+1:this.startTagOffset-(this.noEndTag?2:1);
var attr=this._getAttribute(name);
var add;
if(!attr){
attr=new _e2e();
add=true;
_e4d=name.length+_e4b.length+4;
attr.startOffset=_e4e;
attr.endOffset=_e4e+_e4d-1;
}else{
_e4d=_e4b.length-attr.value.length;
}
attr.name=name;
attr.setValue(_e4b);
attr.noPersist=_e4c;
if(this.wasParsed&&!_e4c&&_e4d>0){
this.getHTMLFile().updatePositions(_e4e,_e4d);
}
if(add){
this.attributes.push(attr);
}
this.onChange();
},removeAttribute:function(name){
this.attributes.every(function(attr,idx,arr){
if(attr.name===name){
arr.splice(idx,1);
var file=this.getHTMLFile();
if(!attr.noPersist&&file){
var s=attr.getText();
file.updatePositions(attr.startOffest,0-(s.length+1));
}
return false;
}
return true;
},this);
this.onChange();
},setAttribute:function(name,_e4f){
this.removeAttribute(name);
this.addAttribute(name,_e4f);
},getUniqueID:function(_e50){
var attr=this.getAttribute("id");
if(!attr){
var file=this.getHTMLFile();
if(!file.uniqueIDs){
file.uniqueIDs={};
}
var id;
if(!file.uniqueIDs.hasOwnProperty(this.tag)){
id=file.uniqueIDs[this.tag]=0;
}else{
id=++file.uniqueIDs[this.tag];
}
this.addAttribute("id",this.tag+"_"+id,_e50);
}
},findElement:function(id){
var attr=this.getAttribute("id");
if(id==attr){
return this;
}
for(var i=0;i<this.children.length;i++){
if(this.children[i].elementType=="HTMLElement"){
var _e51=this.children[i].findElement(id);
if(_e51){
return _e51;
}
}
}
},insertBefore:function(_e52,_e53){
var _e54=dojo.indexOf(this.children,_e53);
if(_e54<0){
_e54=undefined;
}
this.addChild(_e52,_e54);
this.onChange();
},addChild:function(_e55,_e56,_e57){
if(!_e57&&this.wasParsed){
if(_e55.elementType=="HTMLElement"){
var _e58=this._getIndent();
var _e59;
if(_e56<this.children.length&&this.children[_e56].elementType=="HTMLElement"){
_e59=this.children[_e56]._getIndent();
}else{
if(this.children.length){
dojo.forEach(this.children,function(_e5a){
if(_e5a.elementType=="HTMLElement"){
_e59=_e5a._getIndent();
}
});
}else{
_e59=_e58+1;
}
}
var _e5b=_e59;
var _e5c={indent:_e5b};
var _e5d=this._formatModel(_e55,_e56,_e5c);
this.getHTMLFile().updatePositions(_e55.startOffset,_e5d);
}else{
if(_e55.elementType=="HTMLText"||_e55.elementType.substring(0,3)=="CSS"){
var s=_e55.getText();
var _e5e=this.children.length?this.children[this.children.length-1].endOffset:this.startTagOffset;
var len=s.length;
if(len>0){
if(_e55.elementType!="HTMLText"){
len+=this._fmChildIndent+1;
}
this.getHTMLFile().updatePositions(_e5e+1,len);
}
_e55.startOffset=_e5e+1;
_e55.endOffset=_e55.startOffset+s.length-1;
}
}
}
_e2b.prototype.addChild.apply(this,arguments);
},removeChild:function(_e5f){
var _e60=dojo.indexOf(this.children,_e5f);
var _e61=1;
if(_e60>=0){
var _e62=1+_e5f.endOffset-_e5f.startOffset;
if(_e5f.elementType=="HTMLElement"){
if(this.children.length==1){
_e62+=this._fmChildLine*_e61+this._fmChildIndent;
this._fmChildIndent-=2;
}else{
if(_e60>0&&this.children[_e60-1].elementType=="HTMLElement"){
var _e63=this.children[_e60-1];
_e62+=_e63._fmLine*_e61+_e63._fmIndent;
}
if(_e60+1==this.children.length&&this.children[_e60-1].elementType=="HTMLElement"){
this.children[_e60-1]._fmChildIndent-=2;
}
}
}
if(_e62>0&&this.wasParsed){
this.getHTMLFile().updatePositions(_e5f.startOffset,0-_e62);
}
}
_e2b.prototype.removeChild.apply(this,arguments);
},_textModify:function(_e64,_e65){
var _e66=_e64.length-_e65.length;
if(_e66!=0&&this.wasParsed){
this.getHTMLFile().updatePositions(this.startOffset,_e66);
}
},setScript:function(_e67){
this._textModify(_e67,this.script);
this.script=_e67;
},_previous:function(){
var inx=dojo.indexOf(this.parent.children,this);
if(inx>0){
return this.parent.children[inx-1];
}
},_getIndent:function(){
var prev=this._previous();
if(prev){
if(prev.elementType==" HTMLText"){
var txt=prev.value.split("\n");
return txt[txt.length-1].length;
}else{
return prev._fmIndent;
}
}else{
return this.parent._fmChildIndent;
}
},visit:function(_e68){
if(!_e68.visit(this)){
for(var i=0;i<this.attributes.length;i++){
this.attributes[i].visit(_e68);
}
for(var i=0;i<this.children.length;i++){
this.children[i].visit(_e68);
}
}
if(_e68.endVisit){
_e68.endVisit(this);
}
},setText:function(text){
this.script="";
var _e69={xmode:"outer"};
var _e6a=this.parent;
var _e6b=require("davinci/html/HTMLParser").parse(text,this);
this.errors=_e6b.errors;
dojo.mixin(this,this.children[0]);
this.parent=_e6a;
this.visit({visit:function(node){
delete node.wasParsed;
},rules:[]});
this.onChange();
}});
});
},"davinci/ve/metadata":function(){
define(["require","dojo/Deferred","dojo/promise/all","dojo/_base/lang","dojo/_base/connect","../library","../model/Path","../repositoryinfo"],function(_e6c,_e6d,all,lang,_e6e,_e6f,Path,info){
var _e70,_e71,_e72={},_e73={},_e74={},l10n=null,_e75=[],_e76={},_e77={id:{datatype:"string",hidden:true},lang:{datatype:"string",hidden:true},dir:{datatype:"string",hidden:true},"class":{datatype:"string",hidden:true},style:{datatype:"string",hidden:true},title:{datatype:"string",hidden:true}};
dojo.subscribe("/davinci/ui/libraryChanged/start",function(){
_e72={};
_e73={};
_e74={};
l10n=null;
_e70.init().then(function(){
dojo.publish("/davinci/ui/libraryChanged");
});
});
function _e78(dest,srcs){
dest=dest||{};
for(var i=1,l=arguments.length;i<l;i++){
var src=arguments[i],name,val;
for(name in src){
if(src.hasOwnProperty(name)){
val=src[name];
if(!(name in dest)||(typeof val!=="object"&&dest[name]!==val)){
dest[name]=val;
}else{
_e78(dest[name],val);
}
}
}
}
return dest;
};
function _e79(pkg,path){
_e72[pkg.name]=pkg;
path=new Path(path);
var _e7a=pkg.overlays;
for(var name in _e7a){
if(_e7a.hasOwnProperty(name)){
if(name==="oam"||name==="maqetta"){
_e78(pkg,_e7a[name]);
}
}
}
delete pkg.overlays;
pkg.__metadataModuleId="maq-metadata-"+pkg.name;
var _e7b=new Path(location.href);
var _e7c=[{name:pkg.__metadataModuleId,location:_e7b.append(path).append(pkg.directories.metadata).toString()}];
if(pkg.name!="dojo"){
pkg.__libraryModuleId=pkg.name;
var _e7d="app/static/lib/"+pkg.name+"/"+pkg.version;
_e7c.push({name:pkg.__libraryModuleId,location:_e7b.append(_e7d).toString()});
}
_e6c=_e6c({packages:_e7c});
var _e7e;
if(lang.exists("scripts.widget_metadata",pkg)){
if(typeof pkg.scripts.widget_metadata=="string"){
var _e7f=path.append(pkg.scripts.widget_metadata);
_e7e=dojo.xhrGet({url:_e7f.toString()+"?"+info.revision,handleAs:"json"}).then(function(data){
if(data){
var _e80=_e7f.getParentPath();
return _e81(pkg.name,data,_e80,_e80);
}
});
}else{
_e7e=_e81(pkg.name,pkg.scripts.widget_metadata,path);
}
}
if(lang.exists("scripts.callbacks",pkg)){
var d=new _e6d();
_e6c([pkg.scripts.callbacks],function(cb){
pkg.$callbacks=cb;
d.resolve();
});
_e75.push(d);
}
return _e7e;
};
function _e81(_e82,_e83,_e84,_e85){
if(!_e82){
console.error("parseLibraryDescriptor: missing 'libName' arg");
}
var pkg=_e72[_e82];
var path=_e84;
_e83.$descriptorFolderPath=path.toString();
_e83.$moduleFolderPath=_e85.toString();
if(!pkg){
_e72[_e82]={$wm:_e83,name:_e83.name,version:_e83.version};
if(_e83.__metadataModuleId){
_e72[_e82].__metadataModuleId=_e83.__metadataModuleId;
}
pkg=_e72[_e82];
}else{
if(pkg.$widgets){
_e83.widgets.forEach(function(item){
pkg.$wm.widgets.push(item);
});
for(var name in _e83.categories){
if(!pkg.$wm.categories.hasOwnProperty(name)){
pkg.$wm.categories[name]=_e83.categories[name];
}
}
}else{
if(pkg.$wm){
for(var z=0;z<_e83.widgets.length;z++){
var _e86=false;
for(var ll=0;!_e86&&ll<pkg.$wm.widgets.length;ll++){
if(pkg.$wm.widgets[ll].type==_e83.widgets[z].type){
_e86=true;
}
}
if(!_e86){
pkg.$wm.widgets.push(_e83.widgets[z]);
}
}
}else{
if(!pkg.$wm){
pkg.$wm=_e83;
}
}
}
}
var wm=pkg.$wm;
function _e87(wm,tag,item){
if(typeof wm.$providedTags[tag]=="undefined"){
wm.$providedTags[tag]=[];
}
wm.$providedTags[tag].push(item);
};
wm.$providedTypes=wm.$providedTypes||{};
wm.$providedTags=wm.$providedTags||{};
wm.widgets.forEach(function(item){
wm.$providedTypes[item.type]=item;
if(typeof item.tags=="string"){
_e87(wm,item.tags,item);
}else{
if(item.tags&&item.tags.length){
for(var _e88=0;_e88<item.tags.length;_e88++){
_e87(wm,item.tags[_e88],item);
}
}
}
if(item.icon&&!item.iconLocal){
item.icon=path.append(item.icon).toString();
}
if(item.iconLarge&&!item.iconLargeLocal){
item.iconLarge=path.append(item.iconLarge).toString();
}
item.widgetClass=wm.categories[item.category].widgetClass;
});
dojo.mixin(wm,{_maqGetString:_e89});
if(wm.extend){
for(var _e8a in wm.extend){
if(wm.extend.hasOwnProperty(_e8a)){
if(_e72[_e8a]&&_e72[_e8a].$wm){
_e8b(_e72[_e8a].$wm,[wm.extend[_e8a]]);
}else{
var ext=_e76[_e8a]||[];
ext.push(wm.extend[_e8a]);
_e76[_e8a]=ext;
}
}
}
}
if(_e76[_e82]){
_e8b(wm,_e76[_e82]);
}
return pkg;
};
function _e8b(wm,_e8c){
function _e8d(val1,val2){
if(typeof val1==="string"){
return val1+","+val2;
}
if(val1 instanceof Array){
return val1.concat(val2);
}
console.error("Unhandled type for \"concat()\"");
};
var _e8e=wm.$providedTypes;
_e8c.forEach(function(ext){
for(var type in ext){
if(ext.hasOwnProperty(type)){
var e=ext[type];
var w=_e8e[type];
if(e.mixin){
lang.mixin(w,e.mixin);
}
if(e.concat){
for(var prop in e.concat){
if(e.concat.hasOwnProperty(prop)){
var val=e.concat[prop];
if(w[prop]){
w[prop]=_e8d(w[prop],val);
}else{
w[prop]=val;
}
}
}
}
}
}
});
};
function _e8f(type){
if(type){
for(var name in _e72){
if(_e72.hasOwnProperty(name)){
var lib=_e72[name];
if(lib.$wm&&lib.$wm.$providedTypes[type]){
return lib;
}
}
}
}
return null;
};
function _e90(type){
var lib=_e8f(type);
if(lib){
return lib.$wm.$providedTypes[type];
}
};
function _e91(tag){
var arr=[];
if(tag){
for(var name in _e72){
if(_e72.hasOwnProperty(name)){
var lib=_e72[name];
if(lib.$wm&&lib.$wm.$providedTags[tag]){
arr=arr.concat(lib.$wm.$providedTags[tag]);
}
}
}
}
return arr;
};
var _e92=false;
function _e89(key){
if(!_e92){
_e92=true;
}
return null;
};
function _e93(type){
if(!type){
return undefined;
}
if(_e73.hasOwnProperty(type)){
return _e73[type];
}
var lib=_e8f(type),wm,_e94;
if(lib){
_e94=lib.$wm.$descriptorFolderPath;
}
if(!_e94){
return null;
}
wm=lib.$wm;
var _e95=null;
var _e96;
if(!wm.localPath){
_e96=[_e94,"/",type.replace(/\./g,"/"),"_oam.json"].join("");
dojo.xhrGet({url:_e96+"?"+info.revision,handleAs:"json",sync:true}).then(function(data){
_e95=data;
});
}else{
var _e97=type.replace(/\./g,"/");
var _e98=_e97.split("/");
_e98.shift();
var _e99=_e98.join("/");
_e96=[wm.$moduleFolderPath,"/",_e99,"_oam.json"].join("");
var _e9a=system.resource.findResource(_e96);
var _e9b=_e9a.getContentSync();
_e95=dojo.fromJson(_e9b);
}
if(!_e95){
console.error("ERROR: Could not load metadata for type: "+type);
return null;
}
_e95.$ownproperty=dojo.mixin({},_e95.property);
_e95.property=dojo.mixin({},_e77,_e95.property);
_e95.$src=_e96;
_e73[type]=_e95;
_e78(_e95,wm.$providedTypes[type].metadata);
return _e95;
};
function _e9c(obj,_e9d){
if(!_e9d){
return obj;
}
dojo.every(_e9d.split("."),function(name){
if(obj[name]===undefined){
obj=undefined;
return false;
}
obj=obj[name];
return true;
});
return obj;
};
function _e9e(name,type){
var _e9f="allowed"+name,prop=_e70.queryDescriptor(type,_e9f);
if(!prop){
prop=name==="Parent"?"ANY":"NONE";
}
return prop.split(/\s*,\s*/);
};
function _ea0(type,_ea1){
var _ea2=_e70.queryDescriptor(type,_ea1);
if(!_ea2){
return null;
}
var lib=_e8f(type);
return _ea3(lib,_ea2);
};
function _ea3(lib,_ea4){
if(!lib||!_ea4){
return null;
}
var _ea5;
if(typeof _ea4==="string"&&_ea4.substr(0,2)==="./"){
_ea5=new Path(lib.__metadataModuleId).append(_ea4).toString();
}else{
_ea5=_ea4;
}
return _ea5;
};
_e70={init:function(){
var _ea6=[];
_e71=_e6c("../Workbench");
_e6f.getUserLibs(_e71.getProject()).forEach(function(lib){
var path=lib.metaRoot;
if(path){
_ea6.push(dojo.xhrGet({url:path+"/package.json"+"?"+info.revision,handleAs:"json"}).then(function(data){
return _e79(data,path);
}));
}
});
return all(_ea6);
},parseMetaData:function(name,_ea7,_ea8,_ea9){
return _e81(name,_ea7,_ea8,_ea9);
},getLibrary:function(name){
return name?_e72[name]:_e72;
},getLibraryActions:function(_eaa,_eab){
var _eac=[];
for(var name in _e72){
if(_e72.hasOwnProperty(name)){
var lib=_e72[name];
var wm=lib.$wm;
if(!wm){
continue;
}
var _ead=lib.$wm["davinci.actionSets"];
if(!_ead){
continue;
}
dojo.forEach(_ead,function(_eae){
if(_eae.id==_eaa){
if(!_eab||(_eae.targetID===_eab)){
var _eaf=dojo.clone(_eae.actions);
dojo.forEach(_eaf,function(_eb0){
if(_eb0.action){
var _eb1=_ea3(lib,_eb0.action);
_eb0.action=_eb1;
}
if(_eb0.menu){
_eb0.menu.forEach(function(item){
if(item.action){
var _eb2=_ea3(lib,item.action);
item.action=_eb2;
}
});
}
_eac.push(_eb0);
});
}
}
});
}
}
return _eac;
},loadThemeMeta:function(_eb3){
var _eb4=_eb3.find({elementType:"HTMLElement",tag:"style"});
var _eb5=[];
var _eb6="claro";
var _eb7;
for(var z=0;z<_eb4.length;z++){
for(var i=0;i<_eb4[z].children.length;i++){
if(_eb4[z].children[i].elementType=="CSSImport"){
_eb5.push(_eb4[z].children[i]);
}
}
}
var _eb8=new Path(_eb3.fileName);
var _eb9=_e6f.getThemes(_e71.getProject());
var _eba={};
for(var i=0;i<_eb9.length;i++){
if(_eb9[i].files){
for(var k=0;k<_eb9[i].files.length;k++){
_eba[_eb9[i].files[k]]=_eb9[i];
}
}
}
for(var i=0;i<_eb5.length;i++){
var url=_eb5[i].url;
for(var _ebb in _eba){
if(_ebb.indexOf(_eb6)>-1){
_eb7=_ebb;
}
if(url.indexOf(_ebb)>-1){
return {themeUrl:url,themeMetaCache:_e6f.getThemeMetadata(_eba[_ebb]),theme:_eba[_ebb]};
}
}
}
var ro=_e70._loadThemeMetaDojoxMobile(_eb3,_eba);
if(ro){
return ro;
}
if(_eb7){
var _ebc=_eb6;
var _ebd;
for(var i=0;i<_eb5.length;i++){
var _ebe=_eb5[i].url.match(/\/([^\/]*)\.css$/);
if(_ebe&&_ebe.length==2){
var _ebf=_ebe[1];
var _ec0=_eb5[i].url.match(new RegExp("themes/"+_ebf+"/"+_ebf+".css$"));
if(_ec0){
_ebd=_ebf;
break;
}
}
}
if(_ebd){
var _ec1=_eb3.getDocumentElement();
var head=_ec1.getChildElement("head");
var _ec2=_ec1.getChildElement("body");
var _ec3=_ec2.getAttribute("class");
if(_ec3){
_ec2.setAttribute("class",_ec3.replace(new RegExp("\\b"+_ebd+"\\b","g"),_ebc));
}
var _ec4=head.getChildElements("style");
dojo.forEach(_ec4,function(_ec5){
dojo.forEach(_ec5.children,function(_ec6){
if(_ec6.elementType=="CSSImport"){
_ec6.url=_ec6.url.replace(new RegExp("/"+_ebd,"g"),"/"+_ebc);
}
});
});
var url=_eb5[i].url.replace(new RegExp("/"+_ebd,"g"),"/"+_ebc);
var _ec7={themeUrl:url,themeMetaCache:_e6f.getThemeMetadata(_eba[_eb7]),theme:_eba[_eb7]};
_ec7.themeMetaCache.usingSubstituteTheme={oldThemeName:_ebd,newThemeName:_ebc};
return _ec7;
}
}
},_loadThemeMetaDojoxMobile:function(_ec8,_ec9){
var _eca=_ec8.find({elementType:"HTMLElement",tag:"script"});
for(var s=0;s<_eca.length;s++){
var text=_eca[s].getElementText();
if(text.length){
var _ecb=text.indexOf("dojoxMobile.themeMap");
if(_ecb>0){
_ecb=text.indexOf("=",_ecb);
var stop=text.indexOf(";",_ecb);
if(stop>_ecb){
var _ecc=dojo.fromJson(text.substring(_ecb+1,stop));
var url=_ecc[0][2][0];
for(var _ecd in _ec9){
if(url.indexOf(_ecd)>-1){
return {themeUrl:url,themeMetaCache:_e6f.getThemeMetadata(_ec9[_ecd]),theme:_ec9[_ecd]};
}
}
}
}
}
}
return;
},getLibraryForType:function(type){
return _e8f(type);
},getLibraryMetadataForType:function(type){
var lib=_e8f(type);
return lib?lib.$wm:null;
},getWidgetDescriptorForType:function(type){
return _e90(type);
},getOamDescriptivePropertyForType:function(type,_ece){
var oam=_e93(type);
if(oam&&oam[_ece]){
var _ecf=oam[_ece];
if(typeof (_ecf)=="string"){
return {type:"text/plain",value:_ecf};
}else{
if(typeof _ecf.value=="string"){
return {type:(_ecf.type?_ecf.type:"text/plain"),value:_ecf.value};
}else{
return null;
}
}
}else{
return null;
}
},getWidgetsWithTag:function(tag){
return _e91(tag);
},getLibraryBase:function(type){
var lib=_e8f(type);
if(lib){
return lib.$wm.$descriptorFolderPath;
}
},invokeCallback:function(_ed0,_ed1,args){
var _ed2=_ed0,fn;
if(typeof _ed0==="string"){
_ed2=_e8f(type);
}
if(_ed2&&_ed2.$callbacks){
fn=_ed2.$callbacks[_ed1];
if(fn){
return fn.apply(_ed2.$callbacks,args);
}
}
},query:function(_ed3,_ed4){
if(!_ed3){
return;
}
var type,_ed5;
if(_ed3.declaredClass){
if(_ed3.metadata){
_ed5=_ed3.metadata;
}
type=_ed3.type;
}else{
type=_ed3;
}
if(!_ed5){
_ed5=_e93(type);
if(!_ed5){
return;
}
if(_ed3.declaredClass){
_ed3.metadata=_ed5;
}
}
return _e9c(_ed5,_ed4);
},queryDescriptorByName:function(name,type,_ed6){
var lib=_e8f(type),item;
if(lib){
var _ed7=lib.$wm.widgets;
for(var i=0;i<_ed7.length;i++){
if(_ed7[i].name==name){
item=_ed7[i];
break;
}
}
}
return this._queryDescriptor(item,_ed6);
},queryDescriptor:function(type,_ed8){
var lib=_e8f(type),item;
if(lib){
item=lib.$wm.$providedTypes[type];
}
return this._queryDescriptor(item,_ed8);
},_queryDescriptor:function(item,_ed9){
if(!item||typeof item!=="object"){
return;
}
var _eda=_e9c(item,_ed9);
if(_ed9==="resizable"){
if(!_eda){
_eda="both";
}
}
return _eda;
},getAllowedParent:function(type){
return _e9e("Parent",type);
},getAllowedChild:function(type){
return _e9e("Child",type);
},getHelper:function(type,_edb){
var d=new _e6d(),idx=type+":"+_edb;
if(idx in _e74){
d.resolve(_e74[idx]);
return d;
}
var _edc=_ea0(type,_edb);
if(!_edc){
d.resolve();
}else{
_e6c([_edc],function(_edd){
d.resolve(_edd);
_e74[idx]=_edd;
});
}
return d;
},getSmartInput:function(type){
var d=new _e6d();
if(type in _ede){
d.resolve(_ede[type]);
}else{
var _edf=_ea0(type,"inlineEdit");
if(!_edf){
d.resolve(null);
}else{
if(typeof _edf==="string"){
_e6c([_edf],function(_ee0){
d.resolve(_ede[type]=new _ee0());
});
}else{
if(Object.prototype.toString.call(_edf.property)==="[object Array]"){
_e6c(["davinci/ve/input/MultiFieldSmartInput"],function(_ee1){
var si=new _ee1();
lang.mixin(si,_edf);
d.resolve(_ede[type]=si);
});
}else{
_e6c(["davinci/ve/input/SmartInput"],function(_ee2){
var si=new _ee2();
lang.mixin(si,_edf);
d.resolve(_ede[type]=si);
});
}
}
}
}
return d;
},getDeferreds:function(){
return _e75;
}};
var _ede={};
_e6e.subscribe("/davinci/ui/libraryChanged/start",function(){
_ede={};
});
return dojo.setObject("davinci.ve.metadata",_e70);
});
},"dijit/layout/_TabContainerBase":function(){
define(["dojo/text!./templates/TabContainer.html","./StackContainer","./utils","../_TemplatedMixin","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style"],function(_ee3,_ee4,_ee5,_ee6,_ee7,_ee8,_ee9,_eea){
return _ee7("dijit.layout._TabContainerBase",[_ee4,_ee6],{tabPosition:"top",baseClass:"dijitTabContainer",tabStrip:false,nested:false,templateString:_ee3,postMixInProperties:function(){
this.baseClass+=this.tabPosition.charAt(0).toUpperCase()+this.tabPosition.substr(1).replace(/-.*/,"");
this.srcNodeRef&&_eea.set(this.srcNodeRef,"visibility","hidden");
this.inherited(arguments);
},buildRendering:function(){
this.inherited(arguments);
this.tablist=this._makeController(this.tablistNode);
if(!this.doLayout){
_ee8.add(this.domNode,"dijitTabContainerNoLayout");
}
if(this.nested){
_ee8.add(this.domNode,"dijitTabContainerNested");
_ee8.add(this.tablist.containerNode,"dijitTabContainerTabListNested");
_ee8.add(this.tablistSpacer,"dijitTabContainerSpacerNested");
_ee8.add(this.containerNode,"dijitTabPaneWrapperNested");
}else{
_ee8.add(this.domNode,"tabStrip-"+(this.tabStrip?"enabled":"disabled"));
}
},_setupChild:function(tab){
_ee8.add(tab.domNode,"dijitTabPane");
this.inherited(arguments);
},startup:function(){
if(this._started){
return;
}
this.tablist.startup();
this.inherited(arguments);
},layout:function(){
if(!this._contentBox||typeof (this._contentBox.l)=="undefined"){
return;
}
var sc=this.selectedChildWidget;
if(this.doLayout){
var _eeb=this.tabPosition.replace(/-h/,"");
this.tablist.layoutAlign=_eeb;
var _eec=[this.tablist,{domNode:this.tablistSpacer,layoutAlign:_eeb},{domNode:this.containerNode,layoutAlign:"client"}];
_ee5.layoutChildren(this.domNode,this._contentBox,_eec);
this._containerContentBox=_ee5.marginBox2contentBox(this.containerNode,_eec[2]);
if(sc&&sc.resize){
sc.resize(this._containerContentBox);
}
}else{
if(this.tablist.resize){
var s=this.tablist.domNode.style;
s.width="0";
var _eed=_ee9.getContentBox(this.domNode).w;
s.width="";
this.tablist.resize({w:_eed});
}
if(sc&&sc.resize){
sc.resize();
}
}
},destroy:function(){
if(this.tablist){
this.tablist.destroy();
}
this.inherited(arguments);
}});
});
},"davinci/ve/commands/_hierarchyCommand":function(){
define(["dojo/_base/declare"],function(_eee){
return _eee("davinci.ve.commands._hierarchyCommand",null,{_isRefreshOnDescendantChange:function(_eef){
var _ef0;
var w=_eef;
while(w&&w.domNode&&w.domNode.tagName!="BODY"){
var _ef1=w.getParent();
if(_ef1&&davinci.ve.metadata.queryDescriptor(_ef1.type,"refreshOnDescendantChange")){
_ef0=_ef1;
}
w=_ef1;
}
return _ef0;
}});
});
},"davinci/ve/ve.plugin":function(){
define(["require"],function(_ef2){
return {id:"davinci.ve","davinci.view":[{id:"Palette",title:"Palette",viewClass:"davinci/ve/palette/HtmlWidgets",iconClass:"paletteIcon paletteIconWidgets"},{id:"states",title:"Scenes",viewClass:"davinci/ve/views/StatesView",iconClass:"paletteIcon paletteIconStates"},{id:"object",title:"Object",viewClass:"davinci/ve/views/ObjectView"},{id:"style",title:"",viewClass:"davinci/ve/views/SwitchingStyleView"}],"davinci.perspective":[{id:"pageDesign",title:"Page Design",views:[{viewID:"davinci.ve.Palette",position:"left",selected:true},{viewID:"davinci.ui.outline",position:"left"},{viewID:"davinci.ve.style",position:"right"},{viewID:"davinci.ui.comment",position:"right",hidden:true},{viewID:"davinci.ve.states",position:"right-bottom",selected:true},{viewID:"davinci.ui.navigator",position:"left-bottom",selected:true},{viewID:"davinci.review.reviewNavigator",position:"left-bottom"}]}],"davinci.editor":[{id:"HTMLPageEditor",name:"HTML Visual Editor",extensions:["html","htm","php"],isDefault:true,editorClass:"davinci/ve/PageEditor",palettePerspective:"davinci.ve.pageDesign",expandPalettes:["left"]}],"davinci.actionSets":[{id:"cutCopyPaste",visible:true,actions:[{label:"Cut",keySequence:"M1+X",iconClass:"editActionIcon editCutIconSmall",action:"davinci/ve/actions/CutAction",menubarPath:"davinci.edit/cut"},{label:"Copy",keySequence:"M1+C",iconClass:"editActionIcon editCopyIconSmall",action:"davinci/ve/actions/CopyAction",menubarPath:"davinci.edit/cut"},{keySequence:"M1+V",iconClass:"editActionIcon editPasteIconSmall",label:"Paste",action:"davinci/ve/actions/PasteAction",menubarPath:"davinci.edit/cut"},{keySequence:"DEL",iconClass:"editActionIcon editDeleteIconSmall",label:"Delete",action:"davinci/ve/actions/DeleteAction",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon selectParentIconSmall",label:"Select parent",action:"davinci/ve/actions/SelectParentAction",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon selectAncestorIconSmall",label:"Select ancestor...",action:"davinci/ve/actions/SelectAncestorAction",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon unselectAllIconSmall",label:"Unselect all",action:"davinci/ve/actions/UnselectAllAction",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon",label:"Surround with &lt;A&gt;",action:"davinci/ve/actions/SurroundAction",surroundWithTagName:"a",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon",label:"Surround with &lt;DIV&gt;",action:"davinci/ve/actions/SurroundAction",surroundWithTagName:"div",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon",label:"Surround with &lt;SPAN&gt;",action:"davinci/ve/actions/SurroundAction",surroundWithTagName:"span",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon moveToFrontIconSmall",label:"Move to front",action:"davinci/ve/actions/MoveToFrontAction",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon moveForwardIconSmall",label:"Move forward",action:"davinci/ve/actions/MoveForwardAction",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon moveBackwardIconSmall",label:"Move backward",action:"davinci/ve/actions/MoveBackwardAction",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon moveToBackIconSmall",label:"Move to back",action:"davinci/ve/actions/MoveToBackAction",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon",label:"Manage States...",action:"davinci/ve/actions/ManageStates",menubarPath:"davinci.edit/cut"}]}],"davinci.viewActions":[{viewContribution:{targetID:"davinci.ve.outline",actions:[{id:"design",iconClass:"designModeIcon editActionIcon",radioGroup:"displayMode",method:"switchDisplayMode",label:"Widgets",toolbarPath:"displayMode"},{id:"source",iconClass:"sourceModeIcon editActionIcon",method:"switchDisplayMode",radioGroup:"displayMode",label:"Source",toolbarPath:"displayMode"}]}},{viewContribution:{targetID:"davinci.ve.states",actions:[{id:"addState",iconClass:"viewActionIcon addStateIcon",action:"davinci/ve/actions/AddState",label:"Add state",toolbarPath:"states1"},{id:"removeState",iconClass:"viewActionIcon removeStateIcon",action:"davinci/ve/actions/RemoveState",label:"Remove state",toolbarPath:"states1"},{id:"modifyState",iconClass:"viewActionIcon modifyStateIcon",action:"davinci/ve/actions/ModifyState",label:"Modify state",toolbarPath:"states1"},{id:"manageStates",className:"manageStatesButton",iconClass:"viewActionIcon manageStatesIcon",action:"davinci/ve/actions/ManageStates",label:"For currently selected widgets, manage widget visibility for different states",toolbarPath:"states1"},{id:"NewWidgetsCurrentState",className:"newWidgetsCurrentStateButton",iconClass:"viewActionIcon newWidgetsCurrentStateIcon",action:"davinci/ve/actions/NewWidgetsCurrentState",label:"Toggle whether new widgets go to Background or current state",toolbarPath:"states2"},{id:"highlightBaseWidgets",className:"highlightBaseWidgetsButton",iconClass:"viewActionIcon highlightBaseWidgetsIcon",action:"davinci/ve/actions/HighlightBaseWidgets",label:"When in custom state, highlight widgets from Background state",toolbarPath:"states2"}]}}],"davinci.actionSetPartAssociations":[{targetID:"davinci.ve.cutCopyPaste",parts:["davinci.ve.visualEditor","davinci.ve.VisualEditorOutline"]}],"davinci.editorActions":{editorContribution:{targetID:"davinci.ve.HTMLPageEditor",actions:[{id:"savecombo",className:"maqLabelButton",showLabel:true,label:"Save",toolbarPath:"save",type:"ComboButton",run:function(){
_ef2(["../Workbench"],function(_ef3){
_ef2("../ui/Resource").save();
});
},isEnabled:function(_ef4){
return _ef2("../Workbench").getOpenEditor();
},menu:[{iconClass:"saveIcon",run:function(){
_ef2("../ui/Resource").save();
},isEnabled:function(_ef5){
return _ef2("../Workbench").getOpenEditor();
},label:"Save",keyBinding:{accel:true,charOrCode:"s",allowGlobal:true}},{iconClass:"saveAsIcon",run:function(){
_ef2("../ui/Resource").saveAs("html");
},isEnabled:function(_ef6){
return _ef2("../Workbench").getOpenEditor();
},label:"Save As",keyBinding:{accel:true,shift:true,charOrCode:"s",allowGlobal:true}},{id:"saveasdijit",iconClass:"saveAsDijitIcon",run:function(){
return _ef2(["davinci/de/resource"],function(r){
r.createDijiFromNewDialog();
});
},isEnabled:function(_ef7){
return _ef2("../Workbench").getOpenEditor();
},label:"Save As Widget"},]},{id:"undo",iconClass:"editActionIcon undoIcon",action:"davinci/actions/UndoAction",label:"Undo",toolbarPath:"undoredo",keyBinding:{accel:true,charOrCode:"z"}},{id:"redo",iconClass:"editActionIcon redoIcon",action:"davinci/actions/RedoAction",label:"Redo",toolbarPath:"undoredo",keyBinding:{accel:true,shift:true,charOrCode:"z"}},{id:"cut",label:"Cut",iconClass:"editActionIcon editCutIcon",action:"davinci/ve/actions/CutAction",toolbarPath:"cutcopypaste",keyBinding:{accel:true,charOrCode:"x"}},{id:"copy",label:"Copy",iconClass:"editActionIcon editCopyIcon",action:"davinci/ve/actions/CopyAction",toolbarPath:"cutcopypaste",keyBinding:{accel:true,charOrCode:"c"}},{label:"Paste",iconClass:"editActionIcon editPasteIcon",action:"davinci/ve/actions/PasteAction",toolbarPath:"cutcopypaste",keyBinding:{accel:true,charOrCode:"v"}},{id:"delete",iconClass:"editActionIcon editDeleteIcon",label:"Delete",action:"davinci/ve/actions/DeleteAction",toolbarPath:"delete",keyBinding:{charOrCode:[dojo.keys.DELETE,dojo.keys.BACKSPACE]}},{id:"openBrowser",iconClass:"openBrowserIcon",className:"davinciFloatRight openBrowser",run:function(){
_ef2(["../Workbench"],function(_ef8){
var _ef9=_ef8.getOpenEditor();
if(_ef9&&_ef9.resourceFile){
_ef9.previewInBrowser();
}else{
console.error("ERROR. Cannot launch browser window. No editor info.");
}
});
},label:"Preview in Browser",toolbarPath:"undoredo",keyBinding:{accel:true,charOrCode:"0",allowGlobal:true}},{id:"documentSettings",iconClass:"documentSettingsIcon",className:"documentSettings davinciFloatRight",label:"Document settings",toolbarPath:"undoredo",type:"DropDownButton",menu:[{id:"theme",iconClass:"selectThemeIcon",className:"davinciFloatRight",action:"davinci/actions/SelectThemeAction",label:"Switch theme"},{id:"chooseDevice",iconClass:"deviceIcon",className:"davinciFloatRight",action:"davinci/ve/actions/ChooseDeviceAction",label:"Choose device"},{id:"rotateDevice",iconClass:"rotateIcon",className:"davinciFloatRight",action:"davinci/ve/actions/RotateDeviceAction",label:"Rotate device"},{iconClass:"editActionIcon",label:"Select parent",action:"davinci/ve/actions/SelectParentAction"},{iconClass:"editActionIcon",label:"Select ancestor...",action:"davinci/ve/actions/SelectAncestorAction"},{iconClass:"editActionIcon",label:"Unselect all",action:"davinci/ve/actions/UnselectAllAction"},{iconClass:"editActionIcon",label:"Move to front",action:"davinci/ve/actions/MoveToFrontAction"},{iconClass:"editActionIcon",label:"Move forward",action:"davinci/ve/actions/MoveForwardAction"},{iconClass:"editActionIcon",label:"Move backward",action:"davinci/ve/actions/MoveBackwardAction"},{iconClass:"editActionIcon",label:"Move to back",action:"davinci/ve/actions/MoveToBackAction"},{iconClass:"editActionIcon",label:"Surround with &lt;A&gt;",action:"davinci/ve/actions/SurroundAction",surroundWithTagName:"a"},{iconClass:"editActionIcon",label:"Surround with &lt;DIV&gt;",action:"davinci/ve/actions/SurroundAction",surroundWithTagName:"div"},{iconClass:"editActionIcon",label:"Surround with &lt;SPAN&gt;",action:"davinci/ve/actions/SurroundAction",surroundWithTagName:"span"},{iconClass:"editActionIcon",label:"Manage States...",action:"davinci/ve/actions/ManageStates",menubarPath:"davinci.edit/cut"}]},{id:"stickynote",iconClass:"stickynoteIcon",action:"davinci/actions/StickyNoteAction",label:"Add note",toolbarPath:"stickynote"},{id:"layout",className:"maqLabelButton davinciFloatRight maqLayoutDropDownButton",showLabel:true,label:"Flow",toolbarPath:"undoredo",type:"DropDownButton",menu:[{label:"Flow",iconClass:"flowLayoutIcon",method:"selectLayoutFlow"},{label:"Absolute",iconClass:"absoluteLayoutIcon",method:"selectLayoutAbsolute"}]},{id:"sourcecombo",className:"maqLabelButton davinciFloatRight maqSourceComboButton",showLabel:true,label:"Source",action:"davinci/ve/actions/ViewSourceAction",toolbarPath:"undoredo",type:"ComboButton",menu:[{keyBinding:{accel:true,charOrCode:"2",allowGlobal:true},iconClass:"editActionIcon sourceModeIcon sourceMenuIcon",action:"davinci/ve/actions/ViewSourceMenuAction",label:"Source only"},{keyBinding:{accel:true,charOrCode:"3",allowGlobal:true},iconClass:"editActionIcon splitVerticalIcon sourceMenuIcon",action:"davinci/ve/actions/ViewSplitVMenuAction",label:"Split Vertically"},{keyBinding:{accel:true,charOrCode:"4",allowGlobal:true},iconClass:"editActionIcon splitHorizontalIcon sourceMenuIcon",action:"davinci/ve/actions/ViewSplitHMenuAction",label:"Split Horizontally"}]},{id:"design",showLabel:true,className:"maqLabelButton davinciFloatRight maqDesignButton",action:"davinci/ve/actions/ViewDesignAction",label:"Design",toolbarPath:"undoredo",keyBinding:{accel:true,charOrCode:"1",allowGlobal:true}},{id:"closeactiveeditor",run:function(){
_ef2(["../Workbench"],function(_efa){
_efa.closeActiveEditor();
});
},keyBinding:{accel:true,shift:true,charOrCode:"w",allowGlobal:true}},{id:"showWidgetsPalette",run:function(){
var tab=dijit.byId("davinci.ve.Palette");
if(tab){
var _efb=tab.getParent();
if(_efb){
_efb.selectChild(tab);
}
}
},keyBinding:{meta:true,charOrCode:"p",allowGlobal:true}}]}},"davinci.preferences":[{name:"Visual Editor",id:"editorPrefs",category:"davinci.html.general",pane:"davinci/ve/prefs/HTMLEditPreferences",defaultValues:{"flowLayout":true,"snap":true,"showPossibleParents":false,"cssOverrideWarn":true,"absoluteWidgetsZindex":900,"widgetPaletteLayout":"icons"}}],"davinci.dnd":[{parts:["davinci.ui.navigator"],dragSource:function(_efc){
if(_efc.elementType=="File"){
return (/gif|jpeg|jpg|png|svg|json/i).test(_efc.getExtension());
}
},dragHandler:"davinci/ve/palette/ImageDragSource"}],"davinci.fileType":[{extension:"theme",iconClass:"themeFileIcon",type:"text"}],"davinci.defaultEditorActions":{editorContribution:{actions:[{id:"save",run:function(){
_ef2("../Workbench").getOpenEditor().save();
},isEnabled:function(_efd){
return true;
},className:"maqLabelButton",showLabel:true,label:"Save",toolbarPath:"save",keyBinding:{accel:true,charOrCode:"s"}},{id:"undo",iconClass:"editActionIcon undoIcon",action:"davinci/actions/UndoAction",label:"Undo",toolbarPath:"undoredo",keyBinding:{accel:true,charOrCode:"z"}},{id:"redo",iconClass:"editActionIcon redoIcon",action:"davinci/actions/RedoAction",label:"Redo",toolbarPath:"undoredo",keyBinding:{accel:true,shift:true,charOrCode:"z"}}]}}};
});
},"davinci/html/CSSSelector":function(){
define(["require","dojo/_base/declare","davinci/html/CSSElement"],function(_efe,_eff,_f00){
var _f01=_eff("davinci.html.CSSSelector",_f00,{constructor:function(){
this.elementType="CSSSelector";
},matchesSelector:function(_f02){
if(_f02.elementType==this.elementType&&this.id==_f02.id&&this.cls==_f02.cls&&this.element==_f02.element&&this.pseudoRule==_f02.pseudoRule){
return true;
}
},getText:function(_f03){
var s="";
if(this.element){
s=s+this.element;
}
if(this.id){
s=s+"#"+this.id;
}
if(this.cls){
s=s+"."+this.cls;
}
if(this.pseudoRule){
s=s+":"+this.pseudoRule;
}
if(this.pseudoElement){
s=s+"::"+this.pseudoElement;
}
if(this.attribute){
s=s+"["+this.attribute.name;
if(this.attribute.type){
s=s+this.attribute.type+"\""+this.attribute.value+"\"";
}
s=s+"]";
}
return s;
},matches:function(_f04,_f05){
var inx=_f05||0;
var node=_f04[inx];
var _f06=0;
var _f07=false;
if(this.id){
if(this.id!=node.id){
return -1;
}
_f06+=100;
_f07=true;
}
if(this.element){
if(this.element=="*"){
_f07=true;
}else{
if(this.element!=node.tagName){
if(this.element.toUpperCase()!=node.tagName){
return -1;
}
}
_f06+=1;
_f07=true;
}
}
if(this.cls&&node.classes){
var _f08=node.classes;
if(this.cls.indexOf(".")>=0){
var _f09=this.cls.split(".");
for(var j=0;j<_f09.length;j++){
var _f0a=false;
for(var i=0;i<_f08.length;i++){
if(_f0a=(_f08[i]==_f09[j])){
break;
}
}
if(!_f0a){
return -1;
}
}
_f06+=(_f09.length*10);
_f07=true;
}else{
var _f0a=false;
for(var i=0;i<_f08.length;i++){
if(_f0a=((_f08[i]==this.cls)&&(!this.pseudoRule))){
break;
}
}
if(!_f0a){
return -1;
}
_f06+=10;
_f07=true;
}
}
if(!_f07){
return -1;
}else{
return _f06;
}
},getCSSRule:function(){
if(this.parent.elementType=="CSSRule"){
return this.parent;
}
return this.parent.parent;
}});
_f01.parseSelectors=function(_f0b){
if(typeof _f0b=="string"){
_f0b=_f0b+"{}";
var _f0c=_efe("davinci/html/CSSFile");
var _f0d=new _f0c();
_f0d.setText(_f0b);
return _f0d.children[0].selectors;
}else{
return _f0b;
}
};
return _f01;
});
},"url:davinci/ve/input/templates/MultiFieldMultiLineTableRowSmartInput.html":"<tr>\n\t<td class=\"MultiFieldSmartInput_SmartInput_label\" >\n\t\t{label}\n\t</td>\n\t<td>\n\t\t<div class=\"MultiFieldSmartInput_SmartInput_value\">\n\t\t\t<input type=\"text\" name=\"{textboxId}\"  data-dojo-type=\"dijit/form/SimpleTextarea\" data-dojo-props=\"trim:true\" class=\"smartInputTextAreaMulti\" value=\"{textboxValue}\" id=\"{textboxId}\">\n\t    </div>\n    </td>\n    <td class=\"MultiFieldSmartInput_SmartInput_checkbox\">\n    \t<div id=\"{checkboxDivId}\">\n    \t\t<input id=\"{checkboxId}\" name=\"{checkboxId}\" data-dojo-type=\"dijit/form/CheckBox\" {checked} />\n\t\t\t<label for=\"{checkboxId}\">html</label>\n    \t</div>\n\t</td>\n</tr>\n\n","url:davinci/review/widgets/templates/OpenReviewDialog.html":"<div class=\"fileDialog\">\n\t<div class=\"dijitDialogPaneContentArea folderContainer\">\n\t\t<div dojoType=\"dijit.layout.ContentPane\" dojoAttachPoint=\"treeContentPane\">\n\t\t</div>\n\t</div>\n\t\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button dojoType=\"dijit.form.Button\" dojoAttachPoint=\"okButton\" dojoAttachEvent=\"onClick:_okButton\" type=\"submit\" class=\"maqPrimaryButton\" disabled=\"disabled\">${finishButtonLabel}</button>\n\t\t<button dojoType=\"dijit.form.Button\" dojoAttachEvent=\"onClick:_cancelButton\" class=\"maqSecondaryButton\">${cancelButtonLabel}</button>\n\t</div>\n</div>\n","dojo/store/Memory":function(){
define(["../_base/declare","./util/QueryResults","./util/SimpleQueryEngine"],function(_f0e,_f0f,_f10){
var base=null;
return _f0e("dojo.store.Memory",base,{constructor:function(_f11){
for(var i in _f11){
this[i]=_f11[i];
}
this.setData(this.data||[]);
},data:null,idProperty:"id",index:null,queryEngine:_f10,get:function(id){
return this.data[this.index[id]];
},getIdentity:function(_f12){
return _f12[this.idProperty];
},put:function(_f13,_f14){
var data=this.data,_f15=this.index,_f16=this.idProperty;
var id=_f13[_f16]=(_f14&&"id" in _f14)?_f14.id:_f16 in _f13?_f13[_f16]:Math.random();
if(id in _f15){
if(_f14&&_f14.overwrite===false){
throw new Error("Object already exists");
}
data[_f15[id]]=_f13;
}else{
_f15[id]=data.push(_f13)-1;
}
return id;
},add:function(_f17,_f18){
(_f18=_f18||{}).overwrite=false;
return this.put(_f17,_f18);
},remove:function(id){
var _f19=this.index;
var data=this.data;
if(id in _f19){
data.splice(_f19[id],1);
this.setData(data);
return true;
}
},query:function(_f1a,_f1b){
return _f0f(this.queryEngine(_f1a,_f1b)(this.data));
},setData:function(data){
if(data.items){
this.idProperty=data.identifier;
data=this.data=data.items;
}else{
this.data=data;
}
this.index={};
for(var i=0,l=data.length;i<l;i++){
this.index[data[i][this.idProperty]]=i;
}
}});
});
},"davinci/de/DijitTemplatedGenerator":function(){
define(["dojo/_base/declare","davinci/model/Path","davinci/ve/metadata","dojo/json"],function(_f1c,Path,_f1d,json){
return _f1c("davinci.de.DijitTemplatedGenerator",null,{constructor:function(args){
dojo.mixin(this,args);
},buildSource:function(_f1e,_f1f,_f20,_f21,_f22,_f23){
this.value={js:"",metadata:"",amd:["dojo/_base/declare","dijit/_Widget","dijit/_Templated"]};
this.metadata={id:_f20,name:_f20,spec:"1.0",version:"1.0",require:[],library:{dojo:{src:"../../dojo/dojo/dojo.js"}}};
this.model=this._srcDocument=_f1e;
var _f24=_f23[0]._srcElement;
var _f25=_f20+"/"+_f20+".html";
if(!_f21){
this.value.amd.push("dojo/text!"+_f25.toString());
this.value.htmlPath=_f25;
}
var _f26=_f24.find({"elementType":"HTMLElement"});
_f26.push(_f24);
this.loadRequires("html.body",true,true,true);
var libs={};
for(var i=0;i<_f26.length;i++){
var n=_f26[i];
var type=n.getAttribute("data-dojo-type")||n.getAttribute("dojoType")||n.getAttribute("dvwidget");
if(type!=null){
this.loadRequires(type,true,true,true);
}
var _f27=_f1d.query(type,"library");
for(var lib in _f27){
libs[lib]=_f27[lib];
}
}
this.metadata.require.push({$library:"dojo",format:"amd",src:_f1f,type:"javascript-module"});
for(var lib in libs){
if(lib!="dojo"){
this.metadata.library[lib]={};
}
}
this.value.html="";
this.value.html+=_f24.getText();
this.value.html+="";
var _f28=3;
this.metadata.content="<div></div>";
this.value.js="define([";
for(var i=0;i<this.value.amd.length;i++){
this.value.js+="'"+this.value.amd[i]+"'";
if(i+1<this.value.amd.length){
this.value.js+=",\n";
}
}
this.value.js+="\n],function(";
for(var i=0;i<_f28;i++){
var _f29=this.value.amd[i].split("/");
var _f2a=_f29[_f29.length-1];
this.value.js+=_f2a;
if(i+1<_f28){
this.value.js+=",";
}
}
if(!_f21){
this.value.js+=",templateString";
}
this.value.js+="){\n\n";
this.value.js+=" return declare([ _Widget, _Templated";
this.value.js+="], {\n";
this.value.js+="       widgetsInTemplate:true,\n";
if(!_f21){
this.value.js+="       templateString:templateString";
}else{
this.value.js+="       templateString:'"+this.escapeHtml(this.value.html)+"'";
delete this.value.html;
}
this.value.js+="   \n});";
this.value.js+="\n});";
this.value.metadata=json.stringify(this.metadata,undefined,"\t");
return this.value;
},escapeHtml:function(text){
var _f2b=text.replace(/"/g,"\\\"");
_f2b=_f2b.replace(/\n/g,"");
return _f2b;
},addMetaData:function(row){
for(var i=0;i<this.metadata.require.length;i++){
var m=this.metadata.require[i];
if(m.$library==row.$library&&m.src==row.src&&m.type==row.type&&m.format==row.format){
return;
}
}
this.metadata.require.push(row);
},loadRequires:function(type,_f2c,_f2d,_f2e){
if(!type){
return false;
}
var _f2f=_f1d.query(type,"require");
if(!_f2f){
return true;
}
_f2f.every(function(r){
this.addMetaData(r);
return;
switch(r.type){
case "javascript":
break;
case "javascript-module":
if(r.format!=="amd"){
console.error("Unknown javascript-module format");
}
if(r.src){
this.value.amd.push(r.src);
}else{
console.error("Inline 'javascript-module' not handled");
}
break;
case "css":
if(r.src){
}else{
console.error("Inline CSS not handled");
}
break;
case "image":
break;
default:
console.error("Unhandled metadata resource type '"+r.type+"' for widget '"+type+"'");
}
return true;
},this);
}});
});
},"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n></div>\n","dojox/grid/_Grid":function(){
define(["dojo/_base/kernel","../main","dojo/_base/declare","./_Events","./_Scroller","./_Layout","./_View","./_ViewManager","./_RowManager","./_FocusManager","./_EditManager","./Selection","./_RowSelector","./util","dijit/_Widget","dijit/_TemplatedMixin","dijit/CheckedMenuItem","dojo/text!./resources/_Grid.html","dojo/string","dojo/_base/array","dojo/_base/lang","dojo/_base/sniff","dojox/html/metrics","dojo/_base/html","dojo/query","dojo/dnd/common","dojo/i18n!dijit/nls/loading"],function(dojo,_f30,_f31,_f32,_f33,_f34,_f35,_f36,_f37,_f38,_f39,_f3a,_f3b,util,_f3c,_f3d,_f3e,_f3f,_f40,_f41,lang,has,_f42,html,_f43){
if(!dojo.isCopyKey){
dojo.isCopyKey=dojo.dnd.getCopyKeyState;
}
var _f44=_f31("dojox.grid._Grid",[_f3c,_f3d,_f32],{templateString:_f3f,classTag:"dojoxGrid",rowCount:5,keepRows:75,rowsPerPage:25,autoWidth:false,initialWidth:"",autoHeight:"",rowHeight:0,autoRender:true,defaultHeight:"15em",height:"",structure:null,elasticView:-1,singleClickEdit:false,selectionMode:"extended",rowSelector:"",columnReordering:false,headerMenu:null,placeholderLabel:"GridColumns",selectable:false,_click:null,loadingMessage:"<span class='dojoxGridLoading'>${loadingState}</span>",errorMessage:"<span class='dojoxGridError'>${errorState}</span>",noDataMessage:"",escapeHTMLInData:true,formatterScope:null,editable:false,summary:"",_setSummaryAttr:"domNode",sortInfo:0,_placeholders:null,_layoutClass:_f34,buildRendering:function(){
this.inherited(arguments);
if(!this.domNode.getAttribute("tabIndex")){
this.domNode.tabIndex="0";
}
this.createScroller();
this.createLayout();
this.createViews();
this.createManagers();
this.createSelection();
this.connect(this.selection,"onSelected","onSelected");
this.connect(this.selection,"onDeselected","onDeselected");
this.connect(this.selection,"onChanged","onSelectionChanged");
_f42.initOnFontResize();
this.connect(_f42,"onFontResize","textSizeChanged");
util.funnelEvents(this.domNode,this,"doKeyEvent",util.keyEvents);
if(this.selectionMode!="none"){
this.domNode.setAttribute("aria-multiselectable",this.selectionMode=="single"?"false":"true");
}
html.addClass(this.domNode,this.classTag);
if(!this.isLeftToRight()){
html.addClass(this.domNode,this.classTag+"Rtl");
}
if(this.rowHeight>0){
html.addClass(this.viewsNode,this.classTag+"FixedRowHeight");
}
},postMixInProperties:function(){
this.inherited(arguments);
var _f45=dojo.i18n.getLocalization("dijit","loading",this.lang);
this.loadingMessage=_f40.substitute(this.loadingMessage,_f45);
this.errorMessage=_f40.substitute(this.errorMessage,_f45);
if(this.srcNodeRef&&this.srcNodeRef.style.height){
this.height=this.srcNodeRef.style.height;
}
this._setAutoHeightAttr(this.autoHeight,true);
this.lastScrollTop=this.scrollTop=0;
},postCreate:function(){
this._placeholders=[];
this._setHeaderMenuAttr(this.headerMenu);
this._setStructureAttr(this.structure);
this._click=[];
this.inherited(arguments);
if(this.domNode&&this.autoWidth&&this.initialWidth){
this.domNode.style.width=this.initialWidth;
}
if(this.domNode&&!this.editable){
html.attr(this.domNode,"aria-readonly","true");
}
},destroy:function(){
this.domNode.onReveal=null;
this.domNode.onSizeChange=null;
delete this._click;
if(this.scroller){
this.scroller.destroy();
delete this.scroller;
}
this.edit.destroy();
delete this.edit;
this.views.destroyViews();
if(this.focus){
this.focus.destroy();
delete this.focus;
}
if(this.headerMenu&&this._placeholders.length){
_f41.forEach(this._placeholders,function(p){
p.unReplace(true);
});
this.headerMenu.unBindDomNode(this.viewsHeaderNode);
}
this.inherited(arguments);
},_setAutoHeightAttr:function(ah,_f46){
if(typeof ah=="string"){
if(!ah||ah=="false"){
ah=false;
}else{
if(ah=="true"){
ah=true;
}else{
ah=window.parseInt(ah,10);
}
}
}
if(typeof ah=="number"){
if(isNaN(ah)){
ah=false;
}
if(ah<0){
ah=true;
}else{
if(ah===0){
ah=false;
}
}
}
this.autoHeight=ah;
if(typeof ah=="boolean"){
this._autoHeight=ah;
}else{
if(typeof ah=="number"){
this._autoHeight=(ah>=this.get("rowCount"));
}else{
this._autoHeight=false;
}
}
if(this._started&&!_f46){
this.render();
}
},_getRowCountAttr:function(){
return this.updating&&this.invalidated&&this.invalidated.rowCount!=undefined?this.invalidated.rowCount:this.rowCount;
},textSizeChanged:function(){
this.render();
},sizeChange:function(){
this.update();
},createManagers:function(){
this.rows=new _f37(this);
this.focus=new _f38(this);
this.edit=new _f39(this);
},createSelection:function(){
this.selection=new _f3a(this);
},createScroller:function(){
this.scroller=new _f33();
this.scroller.grid=this;
this.scroller.renderRow=lang.hitch(this,"renderRow");
this.scroller.removeRow=lang.hitch(this,"rowRemoved");
},createLayout:function(){
this.layout=new this._layoutClass(this);
this.connect(this.layout,"moveColumn","onMoveColumn");
},onMoveColumn:function(){
this.update();
},onResizeColumn:function(_f47){
},createViews:function(){
this.views=new _f36(this);
this.views.createView=lang.hitch(this,"createView");
},createView:function(_f48,idx){
var c=lang.getObject(_f48);
var view=new c({grid:this,index:idx});
this.viewsNode.appendChild(view.domNode);
this.viewsHeaderNode.appendChild(view.headerNode);
this.views.addView(view);
html.attr(this.domNode,"align",this.isLeftToRight()?"left":"right");
return view;
},buildViews:function(){
for(var i=0,vs;(vs=this.layout.structure[i]);i++){
this.createView(vs.type||_f30._scopeName+".grid._View",i).setStructure(vs);
}
this.scroller.setContentNodes(this.views.getContentNodes());
},_setStructureAttr:function(_f49){
var s=_f49;
if(s&&lang.isString(s)){
dojo.deprecated("dojox.grid._Grid.set('structure', 'objVar')","use dojox.grid._Grid.set('structure', objVar) instead","2.0");
s=lang.getObject(s);
}
this.structure=s;
if(!s){
if(this.layout.structure){
s=this.layout.structure;
}else{
return;
}
}
this.views.destroyViews();
this.focus.focusView=null;
if(s!==this.layout.structure){
this.layout.setStructure(s);
}
this._structureChanged();
},setStructure:function(_f4a){
dojo.deprecated("dojox.grid._Grid.setStructure(obj)","use dojox.grid._Grid.set('structure', obj) instead.","2.0");
this._setStructureAttr(_f4a);
},getColumnTogglingItems:function(){
var _f4b,_f4c=[];
_f4b=_f41.map(this.layout.cells,function(cell){
if(!cell.menuItems){
cell.menuItems=[];
}
var self=this;
var item=new _f3e({label:cell.name,checked:!cell.hidden,_gridCell:cell,onChange:function(_f4d){
if(self.layout.setColumnVisibility(this._gridCell.index,_f4d)){
var _f4e=this._gridCell.menuItems;
if(_f4e.length>1){
_f41.forEach(_f4e,function(item){
if(item!==this){
item.setAttribute("checked",_f4d);
}
},this);
}
_f4d=_f41.filter(self.layout.cells,function(c){
if(c.menuItems.length>1){
_f41.forEach(c.menuItems,"item.set('disabled', false);");
}else{
c.menuItems[0].set("disabled",false);
}
return !c.hidden;
});
if(_f4d.length==1){
_f41.forEach(_f4d[0].menuItems,"item.set('disabled', true);");
}
}
},destroy:function(){
var _f4f=_f41.indexOf(this._gridCell.menuItems,this);
this._gridCell.menuItems.splice(_f4f,1);
delete this._gridCell;
_f3e.prototype.destroy.apply(this,arguments);
}});
cell.menuItems.push(item);
if(!cell.hidden){
_f4c.push(item);
}
return item;
},this);
if(_f4c.length==1){
_f4c[0].set("disabled",true);
}
return _f4b;
},_setHeaderMenuAttr:function(menu){
if(this._placeholders&&this._placeholders.length){
_f41.forEach(this._placeholders,function(p){
p.unReplace(true);
});
this._placeholders=[];
}
if(this.headerMenu){
this.headerMenu.unBindDomNode(this.viewsHeaderNode);
}
this.headerMenu=menu;
if(!menu){
return;
}
this.headerMenu.bindDomNode(this.viewsHeaderNode);
if(this.headerMenu.getPlaceholders){
this._placeholders=this.headerMenu.getPlaceholders(this.placeholderLabel);
}
},setHeaderMenu:function(menu){
dojo.deprecated("dojox.grid._Grid.setHeaderMenu(obj)","use dojox.grid._Grid.set('headerMenu', obj) instead.","2.0");
this._setHeaderMenuAttr(menu);
},setupHeaderMenu:function(){
if(this._placeholders&&this._placeholders.length){
_f41.forEach(this._placeholders,function(p){
if(p._replaced){
p.unReplace(true);
}
p.replace(this.getColumnTogglingItems());
},this);
}
},_fetch:function(_f50){
this.setScrollTop(0);
},getItem:function(_f51){
return null;
},showMessage:function(_f52){
if(_f52){
this.messagesNode.innerHTML=_f52;
this.messagesNode.style.display="";
}else{
this.messagesNode.innerHTML="";
this.messagesNode.style.display="none";
}
},_structureChanged:function(){
this.buildViews();
if(this.autoRender&&this._started){
this.render();
}
},hasLayout:function(){
return this.layout.cells.length;
},resize:function(_f53,_f54){
this._pendingChangeSize=_f53;
this._pendingResultSize=_f54;
this.sizeChange();
},_getPadBorder:function(){
this._padBorder=this._padBorder||html._getPadBorderExtents(this.domNode);
return this._padBorder;
},_getHeaderHeight:function(){
var vns=this.viewsHeaderNode.style,t=vns.display=="none"?0:this.views.measureHeader();
vns.height=t+"px";
this.views.normalizeHeaderNodeHeight();
return t;
},_resize:function(_f55,_f56){
_f55=_f55||this._pendingChangeSize;
_f56=_f56||this._pendingResultSize;
delete this._pendingChangeSize;
delete this._pendingResultSize;
if(!this.domNode){
return;
}
var pn=this.domNode.parentNode;
if(!pn||pn.nodeType!=1||!this.hasLayout()||pn.style.visibility=="hidden"||pn.style.display=="none"){
return;
}
var _f57=this._getPadBorder();
var hh=undefined;
var h;
if(this._autoHeight){
this.domNode.style.height="auto";
}else{
if(typeof this.autoHeight=="number"){
h=hh=this._getHeaderHeight();
h+=(this.scroller.averageRowHeight*this.autoHeight);
this.domNode.style.height=h+"px";
}else{
if(this.domNode.clientHeight<=_f57.h){
if(pn==document.body){
this.domNode.style.height=this.defaultHeight;
}else{
if(this.height){
this.domNode.style.height=this.height;
}else{
this.fitTo="parent";
}
}
}
}
}
if(_f56){
_f55=_f56;
}
if(!this._autoHeight&&_f55){
html.marginBox(this.domNode,_f55);
this.height=this.domNode.style.height;
delete this.fitTo;
}else{
if(this.fitTo=="parent"){
h=this._parentContentBoxHeight=(this._parentContentBoxHeight>0?this._parentContentBoxHeight:html._getContentBox(pn).h);
this.domNode.style.height=Math.max(0,h)+"px";
}
}
var _f58=_f41.some(this.views.views,function(v){
return v.flexCells;
});
if(!this._autoHeight&&(h||html._getContentBox(this.domNode).h)===0){
this.viewsHeaderNode.style.display="none";
}else{
this.viewsHeaderNode.style.display="block";
if(!_f58&&hh===undefined){
hh=this._getHeaderHeight();
}
}
if(_f58){
hh=undefined;
}
this.adaptWidth();
this.adaptHeight(hh);
this.postresize();
},adaptWidth:function(){
var _f59=(!this.initialWidth&&this.autoWidth);
var w=_f59?0:this.domNode.clientWidth||(this.domNode.offsetWidth-this._getPadBorder().w),vw=this.views.arrange(1,w);
this.views.onEach("adaptWidth");
if(_f59){
this.domNode.style.width=vw+"px";
}
},adaptHeight:function(_f5a){
var t=_f5a===undefined?this._getHeaderHeight():_f5a;
var h=(this._autoHeight?-1:Math.max(this.domNode.clientHeight-t,0)||0);
this.views.onEach("setSize",[0,h]);
this.views.onEach("adaptHeight");
if(!this._autoHeight){
var _f5b=0,_f5c=0;
var _f5d=_f41.filter(this.views.views,function(v){
var has=v.hasHScrollbar();
if(has){
_f5b++;
}else{
_f5c++;
}
return (!has);
});
if(_f5b>0&&_f5c>0){
_f41.forEach(_f5d,function(v){
v.adaptHeight(true);
});
}
}
if(this.autoHeight===true||h!=-1||(typeof this.autoHeight=="number"&&this.autoHeight>=this.get("rowCount"))){
this.scroller.windowHeight=h;
}else{
this.scroller.windowHeight=Math.max(this.domNode.clientHeight-t,0);
}
},startup:function(){
if(this._started){
return;
}
this.inherited(arguments);
if(this.autoRender){
this.render();
}
},render:function(){
if(!this.domNode){
return;
}
if(!this._started){
return;
}
if(!this.hasLayout()){
this.scroller.init(0,this.keepRows,this.rowsPerPage);
return;
}
this.update=this.defaultUpdate;
this._render();
},_render:function(){
this.scroller.init(this.get("rowCount"),this.keepRows,this.rowsPerPage);
this.prerender();
this.setScrollTop(0);
this.postrender();
},prerender:function(){
this.keepRows=this._autoHeight?0:this.keepRows;
this.scroller.setKeepInfo(this.keepRows);
this.views.render();
this._resize();
},postrender:function(){
this.postresize();
this.focus.initFocusView();
html.setSelectable(this.domNode,this.selectable);
},postresize:function(){
if(this._autoHeight){
var size=Math.max(this.views.measureContent())+"px";
this.viewsNode.style.height=size;
}
},renderRow:function(_f5e,_f5f){
this.views.renderRow(_f5e,_f5f,this._skipRowRenormalize);
},rowRemoved:function(_f60){
this.views.rowRemoved(_f60);
},invalidated:null,updating:false,beginUpdate:function(){
this.invalidated=[];
this.updating=true;
},endUpdate:function(){
this.updating=false;
var i=this.invalidated,r;
if(i.all){
this.update();
}else{
if(i.rowCount!=undefined){
this.updateRowCount(i.rowCount);
}else{
for(r in i){
this.updateRow(Number(r));
}
}
}
this.invalidated=[];
},defaultUpdate:function(){
if(!this.domNode){
return;
}
if(this.updating){
this.invalidated.all=true;
return;
}
this.lastScrollTop=this.scrollTop;
this.prerender();
this.scroller.invalidateNodes();
this.setScrollTop(this.lastScrollTop);
this.postrender();
},update:function(){
this.render();
},updateRow:function(_f61){
_f61=Number(_f61);
if(this.updating){
this.invalidated[_f61]=true;
}else{
this.views.updateRow(_f61);
this.scroller.rowHeightChanged(_f61);
}
},updateRows:function(_f62,_f63){
_f62=Number(_f62);
_f63=Number(_f63);
var i;
if(this.updating){
for(i=0;i<_f63;i++){
this.invalidated[i+_f62]=true;
}
}else{
for(i=0;i<_f63;i++){
this.views.updateRow(i+_f62,this._skipRowRenormalize);
}
this.scroller.rowHeightChanged(_f62);
}
},updateRowCount:function(_f64){
if(this.updating){
this.invalidated.rowCount=_f64;
}else{
this.rowCount=_f64;
this._setAutoHeightAttr(this.autoHeight,true);
if(this.layout.cells.length){
this.scroller.updateRowCount(_f64);
}
this._resize();
if(this.layout.cells.length){
this.setScrollTop(this.scrollTop);
}
}
},updateRowStyles:function(_f65){
this.views.updateRowStyles(_f65);
},getRowNode:function(_f66){
if(this.focus.focusView&&!(this.focus.focusView instanceof _f3b)){
return this.focus.focusView.rowNodes[_f66];
}else{
for(var i=0,_f67;(_f67=this.views.views[i]);i++){
if(!(_f67 instanceof _f3b)){
return _f67.rowNodes[_f66];
}
}
}
return null;
},rowHeightChanged:function(_f68){
this.views.renormalizeRow(_f68);
this.scroller.rowHeightChanged(_f68);
},fastScroll:true,delayScroll:false,scrollRedrawThreshold:(has("ie")?100:50),scrollTo:function(_f69){
if(!this.fastScroll){
this.setScrollTop(_f69);
return;
}
var _f6a=Math.abs(this.lastScrollTop-_f69);
this.lastScrollTop=_f69;
if(_f6a>this.scrollRedrawThreshold||this.delayScroll){
this.delayScroll=true;
this.scrollTop=_f69;
this.views.setScrollTop(_f69);
if(this._pendingScroll){
window.clearTimeout(this._pendingScroll);
}
var _f6b=this;
this._pendingScroll=window.setTimeout(function(){
delete _f6b._pendingScroll;
_f6b.finishScrollJob();
},200);
}else{
this.setScrollTop(_f69);
}
},finishScrollJob:function(){
this.delayScroll=false;
this.setScrollTop(this.scrollTop);
},setScrollTop:function(_f6c){
this.scroller.scroll(this.views.setScrollTop(_f6c));
},scrollToRow:function(_f6d){
this.setScrollTop(this.scroller.findScrollTop(_f6d)+1);
},styleRowNode:function(_f6e,_f6f){
if(_f6f){
this.rows.styleRowNode(_f6e,_f6f);
}
},_mouseOut:function(e){
this.rows.setOverRow(-2);
},getCell:function(_f70){
return this.layout.cells[_f70];
},setCellWidth:function(_f71,_f72){
this.getCell(_f71).unitWidth=_f72;
},getCellName:function(_f73){
return "Cell "+_f73.index;
},canSort:function(_f74){
},sort:function(){
},getSortAsc:function(_f75){
_f75=_f75==undefined?this.sortInfo:_f75;
return Boolean(_f75>0);
},getSortIndex:function(_f76){
_f76=_f76==undefined?this.sortInfo:_f76;
return Math.abs(_f76)-1;
},setSortIndex:function(_f77,_f78){
var si=_f77+1;
if(_f78!=undefined){
si*=(_f78?1:-1);
}else{
if(this.getSortIndex()==_f77){
si=-this.sortInfo;
}
}
this.setSortInfo(si);
},setSortInfo:function(_f79){
if(this.canSort(_f79)){
this.sortInfo=_f79;
this.sort();
this.update();
}
},doKeyEvent:function(e){
e.dispatch="do"+e.type;
this.onKeyEvent(e);
},_dispatch:function(m,e){
if(m in this){
return this[m](e);
}
return false;
},dispatchKeyEvent:function(e){
this._dispatch(e.dispatch,e);
},dispatchContentEvent:function(e){
this.edit.dispatchEvent(e)||e.sourceView.dispatchContentEvent(e)||this._dispatch(e.dispatch,e);
},dispatchHeaderEvent:function(e){
e.sourceView.dispatchHeaderEvent(e)||this._dispatch("doheader"+e.type,e);
},dokeydown:function(e){
this.onKeyDown(e);
},doclick:function(e){
if(e.cellNode){
this.onCellClick(e);
}else{
this.onRowClick(e);
}
},dodblclick:function(e){
if(e.cellNode){
this.onCellDblClick(e);
}else{
this.onRowDblClick(e);
}
},docontextmenu:function(e){
if(e.cellNode){
this.onCellContextMenu(e);
}else{
this.onRowContextMenu(e);
}
},doheaderclick:function(e){
if(e.cellNode){
this.onHeaderCellClick(e);
}else{
this.onHeaderClick(e);
}
},doheaderdblclick:function(e){
if(e.cellNode){
this.onHeaderCellDblClick(e);
}else{
this.onHeaderDblClick(e);
}
},doheadercontextmenu:function(e){
if(e.cellNode){
this.onHeaderCellContextMenu(e);
}else{
this.onHeaderContextMenu(e);
}
},doStartEdit:function(_f7a,_f7b){
this.onStartEdit(_f7a,_f7b);
},doApplyCellEdit:function(_f7c,_f7d,_f7e){
this.onApplyCellEdit(_f7c,_f7d,_f7e);
},doCancelEdit:function(_f7f){
this.onCancelEdit(_f7f);
},doApplyEdit:function(_f80){
this.onApplyEdit(_f80);
},addRow:function(){
this.updateRowCount(this.get("rowCount")+1);
},removeSelectedRows:function(){
if(this.allItemsSelected){
this.updateRowCount(0);
}else{
this.updateRowCount(Math.max(0,this.get("rowCount")-this.selection.getSelected().length));
}
this.selection.clear();
}});
_f44.markupFactory=function(_f81,node,ctor,_f82){
var _f83=function(n){
var w=html.attr(n,"width")||"auto";
if((w!="auto")&&(w.slice(-2)!="em")&&(w.slice(-1)!="%")){
w=parseInt(w,10)+"px";
}
return w;
};
if(!_f81.structure&&node.nodeName.toLowerCase()=="table"){
_f81.structure=_f43("> colgroup",node).map(function(cg){
var sv=html.attr(cg,"span");
var v={noscroll:(html.attr(cg,"noscroll")=="true")?true:false,__span:(!!sv?parseInt(sv,10):1),cells:[]};
if(html.hasAttr(cg,"width")){
v.width=_f83(cg);
}
return v;
});
if(!_f81.structure.length){
_f81.structure.push({__span:Infinity,cells:[]});
}
_f43("thead > tr",node).forEach(function(tr,_f84){
var _f85=0;
var _f86=0;
var _f87;
var _f88=null;
_f43("> th",tr).map(function(th){
if(!_f88){
_f87=0;
_f88=_f81.structure[0];
}else{
if(_f85>=(_f87+_f88.__span)){
_f86++;
_f87+=_f88.__span;
var _f89=_f88;
_f88=_f81.structure[_f86];
}
}
var cell={name:lang.trim(html.attr(th,"name")||th.innerHTML),colSpan:parseInt(html.attr(th,"colspan")||1,10),type:lang.trim(html.attr(th,"cellType")||""),id:lang.trim(html.attr(th,"id")||"")};
_f85+=cell.colSpan;
var _f8a=html.attr(th,"rowspan");
if(_f8a){
cell.rowSpan=_f8a;
}
if(html.hasAttr(th,"width")){
cell.width=_f83(th);
}
if(html.hasAttr(th,"relWidth")){
cell.relWidth=window.parseInt(html.attr(th,"relWidth"),10);
}
if(html.hasAttr(th,"hidden")){
cell.hidden=(html.attr(th,"hidden")=="true"||html.attr(th,"hidden")===true);
}
if(_f82){
_f82(th,cell);
}
cell.type=cell.type?lang.getObject(cell.type):_f30.grid.cells.Cell;
if(cell.type&&cell.type.markupFactory){
cell.type.markupFactory(th,cell);
}
if(!_f88.cells[_f84]){
_f88.cells[_f84]=[];
}
_f88.cells[_f84].push(cell);
});
});
}
return new ctor(_f81,node);
};
return _f44;
});
},"davinci/review/actions/CloseVersionAction":function(){
define(["dojo/_base/declare","./_ReviewNavigatorCommon","davinci/Runtime","dojox/widget/Toaster","dojo/i18n!./nls/actions"],function(_f8b,_f8c,_f8d,_f8e,nls){
var _f8f=_f8b("davinci.review.actions.CloseVersionAction",[_f8c],{run:function(_f90){
var _f91=this._getSelection(_f90);
if(!_f91||!_f91.length){
return;
}
okToClose=confirm(nls.areYouSureClose);
if(!okToClose){
return;
}
var item=_f91[0].resource.elementType=="ReviewFile"?_f91[0].resource.parent:_f91[0].resource;
dojo.xhrGet({url:"cmd/managerVersion",sync:false,handleAs:"text",content:{"type":"close","vTime":item.timeStamp}}).then(function(_f92){
if(_f92=="OK"){
if(typeof hasToaster=="undefined"){
new _f8e({position:"br-left",duration:4000,messageTopic:"/davinci/review/resourceChanged"});
hasToaster=true;
}
dojo.publish("/davinci/review/resourceChanged",[{message:nls.closeSuccessful,type:"message"},"closed",item]);
}
});
},isEnabled:function(_f93){
var _f94=this._getSelection(_f93);
if(!_f94||_f94.length==0){
return false;
}
var item=_f94[0].resource.elementType=="ReviewFile"?_f94[0].resource.parent:_f94[0].resource;
if(item.designerId==_f8d.userName){
if(!item.closed&&!item.isDraft){
return true;
}
}
return false;
}});
return _f8f;
});
},"davinci/html/PHPBlock":function(){
define(["dojo/_base/declare","davinci/html/HTMLItem"],function(_f95,_f96){
return _f95("davinci.html.PHPBlock",_f96,{constructor:function(_f97){
this.elementType="PHPBlock";
this.value=_f97||"";
},getText:function(_f98){
return _f98.excludeIgnoredContent?"":this.value;
}});
});
},"davinci/ve/commands/EventCommand":function(){
define(["dojo/_base/declare","davinci/ve/widget"],function(_f99,_f9a){
return _f99("davinci.ve.commands.EventCommand",null,{name:"EventCommand",constructor:function(_f9b,_f9c){
this._oldId=(_f9b?_f9b.id:undefined);
this._properties=(_f9c||{});
},setContext:function(_f9d){
this._context=_f9d;
},execute:function(){
if(!this._oldId||!this._properties){
return;
}
var _f9e=_f9a.byId(this._oldId);
this._oldProps=_f9e.properties||{};
_f9e.setProperties(this._properties,true);
if(_f9e.isHtmlWidget){
var node=_f9e.domNode;
for(var name in this._properties){
if(!this._properties[name]){
node.removeAttribute(name);
}
}
}
this._newId=this._oldId;
dojo.publish("/davinci/ui/widgetPropertiesChanged",[[_f9e]]);
},undo:function(){
if(!this._newId){
return;
}
var _f9f=_f9a.byId(this._newId);
var _fa0=_f9f.domNode;
var _fa1=_f9f._srcElement;
for(var _fa2 in this._properties){
if(!this._oldProps[_fa2]){
_fa0.removeAttribute(_fa2);
_fa1.removeAttribute(_fa2);
}
}
_f9f.setProperties(this._oldProps);
dojo.publish("/davinci/ui/widgetPropertiesChanged",[[_f9f]]);
}});
});
},"url:davinci/ui/templates/OpenThemeDialog.html":"<div>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t${selectTheme}: <div dojoType=\"davinci.ui.widgets.ThemeSelection\" dojoAttachPoint=\"_themeChooser\" value='claro' dojoAttachEvent='onChange:_checkValid' searchWorkspace='true'></div>\n\t</div>\t\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button dojoType='dijit.form.Button' dojoAttachPoint=\"_okButton\" dojoAttachEvent='onClick:okButton' label='${open}' class=\"maqPrimaryButton\" type=\"submit\"></button>\n\t\t<button dojoType='dijit.form.Button' dojoAttachEvent='onClick:cancelButton' label='${buttonCancel}' class=\"maqSecondaryButton\"></button>\n\t</div>\n</div>","dijit/Toolbar":function(){
define(["require","dojo/_base/declare","dojo/has","dojo/keys","dojo/ready","./_Widget","./_KeyNavContainer","./_TemplatedMixin"],function(_fa3,_fa4,has,keys,_fa5,_fa6,_fa7,_fa8){
if(has("dijit-legacy-requires")){
_fa5(0,function(){
var _fa9=["dijit/ToolbarSeparator"];
_fa3(_fa9);
});
}
return _fa4("dijit.Toolbar",[_fa6,_fa8,_fa7],{templateString:"<div class=\"dijit\" role=\"toolbar\" tabIndex=\"${tabIndex}\" data-dojo-attach-point=\"containerNode\">"+"</div>",baseClass:"dijitToolbar",postCreate:function(){
this.inherited(arguments);
this.connectKeyNavHandlers(this.isLeftToRight()?[keys.LEFT_ARROW]:[keys.RIGHT_ARROW],this.isLeftToRight()?[keys.RIGHT_ARROW]:[keys.LEFT_ARROW]);
}});
});
},"davinci/js/JSExpression":function(){
define(["dojo/_base/declare","davinci/js/JSElement"],function(_faa,_fab){
return _faa("davinci.js.JSExpression",_fab,{constructor:function(){
this.elementType="JSExpression";
},getText:function(){
var s="";
if(this.comment){
s+=this.printNewLine(context)+this.comment.getText(context);
}
if(this.label){
s+=this.printNewLine(context)+this.label.getText(context);
}
return s;
},add:function(e){
}});
});
},"url:dojox/grid/resources/_Grid.html":"<div hidefocus=\"hidefocus\" role=\"grid\" dojoAttachEvent=\"onmouseout:_mouseOut\">\n\t<div class=\"dojoxGridMasterHeader\" dojoAttachPoint=\"viewsHeaderNode\" role=\"presentation\"></div>\n\t<div class=\"dojoxGridMasterView\" dojoAttachPoint=\"viewsNode\" role=\"presentation\"></div>\n\t<div class=\"dojoxGridMasterMessages\" style=\"display: none;\" dojoAttachPoint=\"messagesNode\"></div>\n\t<span dojoAttachPoint=\"lastFocusNode\" tabindex=\"0\"></span>\n</div>\n","davinci/workbench/ViewPart":function(){
define(["dojo/_base/declare","./_ToolbaredContainer","../ve/States","../Runtime"],function(_fac,_fad,_fae,_faf){
return _fac("davinci.workbench.ViewPart",_fad,{constructor:function(_fb0,_fb1){
this.viewExt=_fb0.view;
this.subscriptions=[];
this.publishing={};
},startup:function(){
this.inherited(arguments);
this.domNode.view=this;
if(this.viewExt.startup){
this.viewExt.startup();
}
},subscribe:function(_fb2,func){
this.subscriptions.push(dojo.subscribe(_fb2,this,func));
},publish:function(_fb3,data){
this.publishing[_fb3]=true;
try{
dojo.publish(_fb3,data);
}
catch(e){
console.error(e);
}
delete this.publishing[_fb3];
},destroy:function(){
dojo.forEach(this.subscriptions,dojo.unsubscribe);
delete this.subscriptions;
},_getViewActions:function(){
var _fb4=this.toolbarID||this.viewExt.id;
var _fb5=[];
_faf.getExtensions("davinci.viewActions",function(ext){
if(_fb4==ext.viewContribution.targetID){
_fb5.push(ext.viewContribution);
return true;
}
});
return _fb5;
}});
});
},"davinci/library":function(){
define(["dojo/_base/xhr","dojo/Deferred","./Runtime","./model/Path","./ve/themeEditor/metadata/CSSThemeProvider","./ve/themeEditor/metadata/query","./workbench/Preferences",],function(xhr,_fb6,_fb7,Path,_fb8,_fb9,_fba){
var _fbb={_customWidgets:{}},_fbc={},_fbd={},_fbe={},_fbf={};
dojo.subscribe("/davinci/ui/libraryChanged/start",this,function(){
_fbf={};
_fbe={};
});
dojo.subscribe("/davinci/resource/resourceChanged",this,function(type,_fc0){
var _fc1=require("davinci/Workbench");
var base=_fc1.getProject();
if(type=="deleted"||type=="renamed"){
var _fc2=_fba.getPreferences("davinci.ui.ProjectPrefs",base);
var _fc3=new Path(base).append(_fc2.themeFolder);
var _fc4=new Path(_fc0.getPath());
if(_fc4.startsWith(_fc3)){
delete _fbc[base];
}
}
if(_fc0.elementType=="File"&&_fc0.extension=="theme"){
if(type=="modified"){
_fc0.getContent().then(function(_fc5){
var t=JSON.parse(_fc5);
t.path=[_fc0.getPath()];
t.getFile=function(){
return system.resource.findResource(this.path[0]);
}.bind(t);
for(var i=0;i<_fbc[base].length;i++){
if(_fbc[base][i].name==t.name){
_fbc[base][i]=t;
return;
}
}
_fbc[base].push(t);
}.bind(this));
}
}
});
_fbb={themesChanged:function(base){
_fbc[base]=base?null:[];
},getThemes:function(base,_fc6,_fc7){
if(_fc7){
delete _fbc[base];
}
function _fc8(){
var rlt=[];
if(_fbc[base]){
rlt=_fc6?_fbc[base].filter(function(_fc9){
return !_fc9.getFile().isVirtual();
}):_fbc[base];
}
return rlt;
};
if(_fbc[base]){
return _fc8();
}
var _fca=_fba.getPreferences("davinci.ui.ProjectPrefs",base),_fcb=new Path(base).append(_fca.themeFolder);
var _fcc=_fb7.serverJSONRequest({url:"cmd/getThemes",handleAs:"json",content:{path:"*.theme",ignoreCase:true,workspaceOnly:false,inFolder:_fcb.toString()},sync:true});
_fcc.forEach(function(_fcd){
_fcd.getFile=function(){
return system.resource.findResource(this.path[0]);
}.bind(_fcd);
}.bind(this));
_fbc[base]=_fcc;
return _fc8();
},getThemeMetadata:function(_fce){
if(_fbd[_fce.name]){
return _fbd[_fce.name];
}
var _fcf=new Path(_fce.getFile().getPath()).removeLastSegments();
var _fd0=_fce.files.filter(function(file){
return file.indexOf(".css")>-1;
}).map(_fcf.append,_fcf);
var _fd1=_fce.meta.map(function(_fd2){
var _fd3=_fcf.append(_fd2);
return system.resource.findResource(_fd3.toString());
});
var _fd4=new _fb8(_fd1,_fce);
_fbd[_fce.name]={loader:new _fb9(_fd1),css:_fd0,metadata:_fd4};
return _fbd[_fce.name];
},addCustomWidgets:function(base,_fd5,_fd6,_fd7){
var _fd8=_fba.getPreferences("davinci.ui.ProjectPrefs",base);
if(!_fd8.widgetFolder){
_fd8.widgetFolder="./lib/custom";
_fba.savePreferences("davinci.ui.ProjectPrefs",base,_fd8);
}
var _fd9=_fd5.getParentFolder();
var _fda=_fd9.getPath();
var _fdb=new Path(_fda);
var _fdc=require("davinci/ve/metadata").parseMetaData(_fd7.name,_fd7,_fdb,_fd6);
if(!_fbb._customWidgets[base].hasOwnProperty("name")){
_fbb._customWidgets[base].name="custom";
_fbb._customWidgets[base].metaPath=_fd8.widgetFolder;
_fbb._customWidgets[base].localPath=true;
}
_fbb._customWidgets[base]=_fdc;
dojo.publish("/davinci/ui/addedCustomWidget",[_fdc]);
return _fdc;
},getCustomWidgets:function(base){
if(!_fbb._customWidgets||!_fbb._customWidgets[base]){
if(!_fbb._customWidgets){
_fbb._customWidgets={};
}
if(!_fbb._customWidgets[base]){
_fbb._customWidgets[base]=[];
}
var _fdd=_fba.getPreferences("davinci.ui.ProjectPrefs",base);
if(!_fdd.widgetFolder){
_fdd.widgetFolder="./lib/custom";
_fba.savePreferences("davinci.ui.ProjectPrefs",base,_fdd);
}
var _fde=new Path(base).append(_fdd.widgetFolder);
var _fdf=_fde.getSegments();
var _fe0=system.resource.findResource(_fdf[0]);
for(var i=1;i<_fdf.length;i++){
var _fe1=_fe0.getChildSync(_fdf[i]);
if(_fe1){
_fe0=_fe1;
}else{
_fe0=_fe0.createResource(_fdf[i],true);
}
}
var _fe2;
_fe0.getChildrenSync(function onComplete(_fe3){
_fe2=_fe3;
},true);
this._customWidgetPackages=[];
var _fe4={};
for(var i=0;i<_fe2.length;i++){
var _fe5=_fe2[i];
if(_fe5.elementType=="Folder"){
_fe4[_fe5.name]=_fe5.getPath();
var _fe6="maq-lib-custom-"+_fe5.name;
var url=_fe5.getURL();
require({packages:[{name:_fe6,location:url}]});
this._customWidgetPackages.push({name:_fe5.name,location:url});
}
}
var _fe7=system.resource.findResource("*_widgets.json",false,_fe0);
this._customWidgetDescriptors={};
for(var i=0;i<_fe7.length;i++){
var _fe8=_fe7[i];
var _fe9=_fe8.getParentFolder();
var _fea=_fe0.getURL();
var _feb=_fe9.getURL();
var _fec=_feb.substr(_fea.length+1);
var _fed=null;
try{
_fed=dojo.fromJson(_fe8.getContentSync());
}
catch(e){
}
if(!_fed){
console.warn("No metadata loaded for custom widget: "+_fec);
continue;
}
if(!_fed.customWidgetSpec){
console.warn("Unsupported older custom widget spec version ("+_fed.customWidgetSpec+") for custom widget: "+_fec);
continue;
}
var _fee=_fec.split("/").shift();
_fed.__metadataModuleId="maq-lib-custom-"+_fee;
_fbb.addCustomWidgets(base,_fe8,_fe4[_fee],_fed);
if(!_fbf[base]){
_fbf[base]={};
}
if(!_fbf[base][_fe9.name]){
_fbf[base][_fe9.name]={};
}
_fbf[base][_fe9.name][_fed.version]=_feb;
if(_fed&&_fed.widgets){
for(var j=0;j<_fed.widgets.length;j++){
var _fef=_fed.widgets[j].type;
if(_fef){
this._customWidgetDescriptors[_fef]={name:_fee,location:_feb,descriptor:_fed};
}
}
}
}
}
return {custom:_fbb._customWidgets[base]};
},getCustomWidgetPackages:function(){
return this._customWidgetPackages||[];
},getCustomWidgetDescriptors:function(){
return this._customWidgetDescriptors?this._customWidgetDescriptors:{};
},getInstalledLibs:function(){
if(!_fbb._serverLibs){
_fbb._serverLibs=_fb7.serverJSONRequest({url:"cmd/listLibs",handleAs:"json",content:{},sync:true})[0].userLibs;
}
return _fbb._serverLibs;
},getUserLibs:function(base){
if(_fbe.base){
return _fbe.base;
}
_fbe.base=_fb7.serverJSONRequest({url:"cmd/getUserLibs",handleAs:"json",content:{base:base},sync:true})[0].userLibs;
return _fbe.base;
},getLibRoot:function(id,_ff0,base){
var d=new _fb6();
var _ff1=_fbf;
if(_ff1[base]&&_ff1[base][id]&&_ff1[base][id][_ff0]!==undefined){
return d.resolve(_ff1[base][id][_ff0]||"");
}
if(!_ff1[base]){
_ff1[base]={};
}
if(!_ff1[base][id]){
_ff1[base][id]={};
}
return xhr.get({url:"cmd/getLibRoots",handleAs:"json",content:{libId:id,version:_ff0,base:base}}).then(function(_ff2){
var _ff3=_ff2?_ff2[0].libRoot.root:null;
if(!_ff1[id]){
_ff1[id]={};
}
_ff1[base][id][_ff0]=_ff3;
return d.resolve(_ff3||"");
});
},modifyLib:function(_ff4){
return _fb7.serverJSONRequest({url:"cmd/modifyLib",handleAs:"text",content:{libChanges:JSON.stringify(_ff4)},sync:true});
},addLib:function(id,_ff5){
return _fb7.serverJSONRequest({url:"cmd/getLibRoots",handleAs:"json",content:{libId:id,version:_ff5},sync:true})[0].libRoot.root;
},getLibraryId:function(_ff6,_ff7){
var libs={sketch:"sketch",claro:"claro"};
return libs[_ff6]+(_ff7||"");
},getLibraryName:function(lib){
var _ff8;
var _ff9;
for(var name in lib){
_ff8=name;
_ff9=lib[_ff8];
}
return _ff8;
}};
return _fbb;
});
},"dijit/layout/StackContainer":function(){
define(["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom-class","dojo/has","dojo/_base/lang","dojo/ready","dojo/topic","../registry","../_WidgetBase","./_LayoutWidget","dojo/i18n!../nls/common"],function(_ffa,_ffb,_ffc,_ffd,has,lang,_ffe,_fff,_1000,_1001,_1002){
if(has("dijit-legacy-requires")){
_ffe(0,function(){
var _1003=["dijit/layout/StackController"];
require(_1003);
});
}
var _1004=_ffc("dijit.layout.StackContainer",_1002,{doLayout:true,persist:false,baseClass:"dijitStackContainer",buildRendering:function(){
this.inherited(arguments);
_ffd.add(this.domNode,"dijitLayoutContainer");
this.containerNode.setAttribute("role","tabpanel");
},postCreate:function(){
this.inherited(arguments);
this.connect(this.domNode,"onkeypress",this._onKeyPress);
},startup:function(){
if(this._started){
return;
}
var _1005=this.getChildren();
_ffa.forEach(_1005,this._setupChild,this);
if(this.persist){
this.selectedChildWidget=_1000.byId(_ffb(this.id+"_selectedChild"));
}else{
_ffa.some(_1005,function(child){
if(child.selected){
this.selectedChildWidget=child;
}
return child.selected;
},this);
}
var _1006=this.selectedChildWidget;
if(!_1006&&_1005[0]){
_1006=this.selectedChildWidget=_1005[0];
_1006.selected=true;
}
_fff.publish(this.id+"-startup",{children:_1005,selected:_1006});
this.inherited(arguments);
},resize:function(){
if(!this._hasBeenShown){
this._hasBeenShown=true;
var _1007=this.selectedChildWidget;
if(_1007){
this._showChild(_1007);
}
}
this.inherited(arguments);
},_setupChild:function(child){
this.inherited(arguments);
_ffd.replace(child.domNode,"dijitHidden","dijitVisible");
child.domNode.title="";
},addChild:function(child,_1008){
this.inherited(arguments);
if(this._started){
_fff.publish(this.id+"-addChild",child,_1008);
this.layout();
if(!this.selectedChildWidget){
this.selectChild(child);
}
}
},removeChild:function(page){
this.inherited(arguments);
if(this._started){
_fff.publish(this.id+"-removeChild",page);
}
if(this._descendantsBeingDestroyed){
return;
}
if(this.selectedChildWidget===page){
this.selectedChildWidget=undefined;
if(this._started){
var _1009=this.getChildren();
if(_1009.length){
this.selectChild(_1009[0]);
}
}
}
if(this._started){
this.layout();
}
},selectChild:function(page,_100a){
page=_1000.byId(page);
if(this.selectedChildWidget!=page){
var d=this._transition(page,this.selectedChildWidget,_100a);
this._set("selectedChildWidget",page);
_fff.publish(this.id+"-selectChild",page);
if(this.persist){
_ffb(this.id+"_selectedChild",this.selectedChildWidget.id);
}
}
return d;
},_transition:function(_100b,_100c){
if(_100c){
this._hideChild(_100c);
}
var d=this._showChild(_100b);
if(_100b.resize){
if(this.doLayout){
_100b.resize(this._containerContentBox||this._contentBox);
}else{
_100b.resize();
}
}
return d;
},_adjacent:function(_100d){
var _100e=this.getChildren();
var index=_ffa.indexOf(_100e,this.selectedChildWidget);
index+=_100d?1:_100e.length-1;
return _100e[index%_100e.length];
},forward:function(){
return this.selectChild(this._adjacent(true),true);
},back:function(){
return this.selectChild(this._adjacent(false),true);
},_onKeyPress:function(e){
_fff.publish(this.id+"-containerKeyPress",{e:e,page:this});
},layout:function(){
var child=this.selectedChildWidget;
if(child&&child.resize){
if(this.doLayout){
child.resize(this._containerContentBox||this._contentBox);
}else{
child.resize();
}
}
},_showChild:function(page){
var _100f=this.getChildren();
page.isFirstChild=(page==_100f[0]);
page.isLastChild=(page==_100f[_100f.length-1]);
page._set("selected",true);
_ffd.replace(page.domNode,"dijitVisible","dijitHidden");
return (page._onShow&&page._onShow())||true;
},_hideChild:function(page){
page._set("selected",false);
_ffd.replace(page.domNode,"dijitHidden","dijitVisible");
page.onHide&&page.onHide();
},closeChild:function(page){
var _1010=page.onClose(this,page);
if(_1010){
this.removeChild(page);
page.destroyRecursive();
}
},destroyDescendants:function(_1011){
this._descendantsBeingDestroyed=true;
this.selectedChildWidget=undefined;
_ffa.forEach(this.getChildren(),function(child){
if(!_1011){
this.removeChild(child);
}
child.destroyRecursive(_1011);
},this);
this._descendantsBeingDestroyed=false;
}});
_1004.ChildWidgetProperties={selected:false,disabled:false,closable:false,iconClass:"dijitNoIcon",showTitle:true};
lang.extend(_1001,_1004.ChildWidgetProperties);
return _1004;
});
},"dojo/regexp":function(){
define(["./_base/kernel","./_base/lang"],function(dojo,lang){
var _1012={};
lang.setObject("dojo.regexp",_1012);
_1012.escapeString=function(str,_1013){
return str.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g,function(ch){
if(_1013&&_1013.indexOf(ch)!=-1){
return ch;
}
return "\\"+ch;
});
};
_1012.buildGroupRE=function(arr,re,_1014){
if(!(arr instanceof Array)){
return re(arr);
}
var b=[];
for(var i=0;i<arr.length;i++){
b.push(re(arr[i]));
}
return _1012.group(b.join("|"),_1014);
};
_1012.group=function(_1015,_1016){
return "("+(_1016?"?:":"")+_1015+")";
};
return _1012;
});
},"davinci/UserActivityMonitor":function(){
define(["require","dojo/_base/xhr","dojo/i18n!./nls/webContent"],function(_1017,xhr,_1018){
var _1019={setUpInActivityMonitor:function(doc,_101a){
if(_101a.singleUserMode()){
this._MaxInactiveInterval=-1;
}else{
this._firstPoll=true;
this._MaxInactiveInterval=60*5;
this.keepAlive();
this.addInActivityMonitor(doc);
_101a.subscribe("/dojo/io/load",this.lastServerConnection);
this.userActivity();
}
},addInActivityMonitor:function(doc){
if(this._MaxInactiveInterval===-1){
return [];
}else{
var _101b=[dojo.connect(doc.documentElement,"keydown",this,"userActivity"),dojo.connect(doc.documentElement,"mousedown",this,"userActivity")];
return _101b;
}
},userActivity:function(e){
if(this.countdown){
this.resetIdle();
}
if(this._idleTimer){
window.clearTimeout(this._idleTimer);
}
if(this._MaxInactiveInterval>0){
var t=this._MaxInactiveInterval*1000;
this._idleTimer=window.setTimeout(function(){
this.idle();
}.bind(this),t);
}
},keepAlive:function(){
return xhr.get({url:"cmd/keepalive",handleAs:"json"}).then(function(_101c){
if(_101c.MaxInactiveInterval){
this._MaxInactiveInterval=_101c.MaxInactiveInterval;
if(this._firstPoll){
delete this._firstPoll;
this.userActivity(null);
}
}else{
console.warn("Keep Alive: no MaxInactiveInterval. result="+_101c);
}
}.bind(this),function(error){
console.warn("keepalive error",error);
});
},lastServerConnection:function(_101d,_101e){
if(this._serverPollTimer){
window.clearTimeout(this._serverPollTimer);
}
if(this._MaxInactiveInterval>0){
var t=this._MaxInactiveInterval*1000*0.8;
this._serverPollTimer=window.setTimeout(function(){
this.keepAlive();
}.bind(this),t);
}
},idle:function(){
var _101f=30;
var _1020=this.warnDiv=dojo.create("div",{"class":"idleWarning",innerHTML:dojo.string.substitute(_1018.idleSessionMessage,{seconds:_101f})},dojo.byId("davinci_app"),"first");
this.countdown=window.setInterval(function(){
if(--_101f===0){
window.clearInterval(this.countdown);
delete this.countdown;
_1017("davinci/Workbench").logoff().otherwise(function(_1021){
});
}else{
_1020.innerHTML=dojo.string.substitute(_1018.idleSessionMessage,{seconds:_101f});
}
}.bind(this),1000);
},resetIdle:function(e){
window.clearInterval(this.countdown);
delete this.countdown;
this.warnDiv.parentNode.removeChild(this.warnDiv);
delete this.warnDiv;
this.userActivity();
}};
return _1019;
});
},"dijit/form/ComboBox":function(){
define(["dojo/_base/declare","./ValidationTextBox","./ComboBoxMixin"],function(_1022,_1023,_1024){
return _1022("dijit.form.ComboBox",[_1023,_1024],{});
});
},"dijit/form/_FormMixin":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/window"],function(array,_1025,_1026,lang,on,_1027){
return _1025("dijit.form._FormMixin",null,{state:"",_getDescendantFormWidgets:function(_1028){
var res=[];
array.forEach(_1028||this.getChildren(),function(child){
if("value" in child){
res.push(child);
}else{
res=res.concat(this._getDescendantFormWidgets(child.getChildren()));
}
},this);
return res;
},reset:function(){
array.forEach(this._getDescendantFormWidgets(),function(_1029){
if(_1029.reset){
_1029.reset();
}
});
},validate:function(){
var _102a=false;
return array.every(array.map(this._getDescendantFormWidgets(),function(_102b){
_102b._hasBeenBlurred=true;
var valid=_102b.disabled||!_102b.validate||_102b.validate();
if(!valid&&!_102a){
_1027.scrollIntoView(_102b.containerNode||_102b.domNode);
_102b.focus();
_102a=true;
}
return valid;
}),function(item){
return item;
});
},setValues:function(val){
_1026.deprecated(this.declaredClass+"::setValues() is deprecated. Use set('value', val) instead.","","2.0");
return this.set("value",val);
},_setValueAttr:function(obj){
var map={};
array.forEach(this._getDescendantFormWidgets(),function(_102c){
if(!_102c.name){
return;
}
var entry=map[_102c.name]||(map[_102c.name]=[]);
entry.push(_102c);
});
for(var name in map){
if(!map.hasOwnProperty(name)){
continue;
}
var _102d=map[name],_102e=lang.getObject(name,false,obj);
if(_102e===undefined){
continue;
}
if(!lang.isArray(_102e)){
_102e=[_102e];
}
if(typeof _102d[0].checked=="boolean"){
array.forEach(_102d,function(w){
w.set("value",array.indexOf(_102e,w.value)!=-1);
});
}else{
if(_102d[0].multiple){
_102d[0].set("value",_102e);
}else{
array.forEach(_102d,function(w,i){
w.set("value",_102e[i]);
});
}
}
}
},getValues:function(){
_1026.deprecated(this.declaredClass+"::getValues() is deprecated. Use get('value') instead.","","2.0");
return this.get("value");
},_getValueAttr:function(){
var obj={};
array.forEach(this._getDescendantFormWidgets(),function(_102f){
var name=_102f.name;
if(!name||_102f.disabled){
return;
}
var value=_102f.get("value");
if(typeof _102f.checked=="boolean"){
if(/Radio/.test(_102f.declaredClass)){
if(value!==false){
lang.setObject(name,value,obj);
}else{
value=lang.getObject(name,false,obj);
if(value===undefined){
lang.setObject(name,null,obj);
}
}
}else{
var ary=lang.getObject(name,false,obj);
if(!ary){
ary=[];
lang.setObject(name,ary,obj);
}
if(value!==false){
ary.push(value);
}
}
}else{
var prev=lang.getObject(name,false,obj);
if(typeof prev!="undefined"){
if(lang.isArray(prev)){
prev.push(value);
}else{
lang.setObject(name,[prev,value],obj);
}
}else{
lang.setObject(name,value,obj);
}
}
});
return obj;
},isValid:function(){
return this.state=="";
},onValidStateChange:function(){
},_getState:function(){
var _1030=array.map(this._descendants,function(w){
return w.get("state")||"";
});
return array.indexOf(_1030,"Error")>=0?"Error":array.indexOf(_1030,"Incomplete")>=0?"Incomplete":"";
},disconnectChildren:function(){
},connectChildren:function(_1031){
this._descendants=this._getDescendantFormWidgets();
array.forEach(this._descendants,function(child){
if(!child._started){
child.startup();
}
});
if(!_1031){
this._onChildChange();
}
},_onChildChange:function(attr){
if(!attr||attr=="state"||attr=="disabled"){
this._set("state",this._getState());
}
if(!attr||attr=="value"||attr=="disabled"||attr=="checked"){
if(this._onChangeDelayTimer){
this._onChangeDelayTimer.remove();
}
this._onChangeDelayTimer=this.defer(function(){
delete this._onChangeDelayTimer;
this._set("value",this.get("value"));
},10);
}
},startup:function(){
this.inherited(arguments);
this._descendants=this._getDescendantFormWidgets();
this.value=this.get("value");
this.state=this._getState();
var self=this;
this.own(on(this.containerNode,"attrmodified-state, attrmodified-disabled, attrmodified-value, attrmodified-checked",function(evt){
if(evt.target==self.domNode){
return;
}
self._onChildChange(evt.type.replace("attrmodified-",""));
}));
this.watch("state",function(attr,_1032,_1033){
this.onValidStateChange(_1033=="");
});
},destroy:function(){
this.inherited(arguments);
}});
});
},"dijit/DropDownMenu":function(){
define(["dojo/_base/declare","dojo/_base/event","dojo/keys","dojo/text!./templates/Menu.html","./_OnDijitClickMixin","./_MenuBase"],function(_1034,event,keys,_1035,_1036,_1037){
return _1034("dijit.DropDownMenu",[_1037,_1036],{templateString:_1035,baseClass:"dijitMenu",postCreate:function(){
this.inherited(arguments);
var l=this.isLeftToRight();
this._openSubMenuKey=l?keys.RIGHT_ARROW:keys.LEFT_ARROW;
this._closeSubMenuKey=l?keys.LEFT_ARROW:keys.RIGHT_ARROW;
this.connectKeyNavHandlers([keys.UP_ARROW],[keys.DOWN_ARROW]);
},_onKeyPress:function(evt){
if(evt.ctrlKey||evt.altKey){
return;
}
switch(evt.charOrCode){
case this._openSubMenuKey:
this._moveToPopup(evt);
event.stop(evt);
break;
case this._closeSubMenuKey:
if(this.parentMenu){
if(this.parentMenu._isMenuBar){
this.parentMenu.focusPrev();
}else{
this.onCancel(false);
}
}else{
event.stop(evt);
}
break;
}
}});
});
},"dojo/data/util/simpleFetch":function(){
define(["../../_base/lang","../../_base/kernel","./sorter"],function(lang,_1038,_1039){
var _103a={};
lang.setObject("dojo.data.util.simpleFetch",_103a);
_103a.errorHandler=function(_103b,_103c){
if(_103c.onError){
var scope=_103c.scope||_1038.global;
_103c.onError.call(scope,_103b,_103c);
}
};
_103a.fetchHandler=function(items,_103d){
var _103e=_103d.abort||null,_103f=false,_1040=_103d.start?_103d.start:0,_1041=(_103d.count&&(_103d.count!==Infinity))?(_1040+_103d.count):items.length;
_103d.abort=function(){
_103f=true;
if(_103e){
_103e.call(_103d);
}
};
var scope=_103d.scope||_1038.global;
if(!_103d.store){
_103d.store=this;
}
if(_103d.onBegin){
_103d.onBegin.call(scope,items.length,_103d);
}
if(_103d.sort){
items.sort(_1039.createSortFunction(_103d.sort,this));
}
if(_103d.onItem){
for(var i=_1040;(i<items.length)&&(i<_1041);++i){
var item=items[i];
if(!_103f){
_103d.onItem.call(scope,item,_103d);
}
}
}
if(_103d.onComplete&&!_103f){
var _1042=null;
if(!_103d.onItem){
_1042=items.slice(_1040,_1041);
}
_103d.onComplete.call(scope,_1042,_103d);
}
};
_103a.fetch=function(_1043){
_1043=_1043||{};
if(!_1043.store){
_1043.store=this;
}
this._fetchItems(_1043,lang.hitch(this,"fetchHandler"),lang.hitch(this,"errorHandler"));
return _1043;
};
return _103a;
});
},"dijit/Menu":function(){
define(["require","dojo/_base/array","dojo/_base/declare","dojo/_base/event","dojo/dom","dojo/dom-attr","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/_base/window","dojo/window","./popup","./DropDownMenu","dojo/ready"],function(_1044,array,_1045,event,dom,_1046,_1047,_1048,keys,lang,on,has,win,_1049,pm,_104a,ready){
if(has("dijit-legacy-requires")){
ready(0,function(){
var _104b=["dijit/MenuItem","dijit/PopupMenuItem","dijit/CheckedMenuItem","dijit/MenuSeparator"];
_1044(_104b);
});
}
return _1045("dijit.Menu",_104a,{constructor:function(){
this._bindings=[];
},targetNodeIds:[],selector:"",contextMenuForWindow:false,leftClickToOpen:false,refocus:true,postCreate:function(){
if(this.contextMenuForWindow){
this.bindDomNode(this.ownerDocumentBody);
}else{
array.forEach(this.targetNodeIds,this.bindDomNode,this);
}
this.inherited(arguments);
},_iframeContentWindow:function(_104c){
return _1049.get(this._iframeContentDocument(_104c))||this._iframeContentDocument(_104c)["__parent__"]||(_104c.name&&win.doc.frames[_104c.name])||null;
},_iframeContentDocument:function(_104d){
return _104d.contentDocument||(_104d.contentWindow&&_104d.contentWindow.document)||(_104d.name&&win.doc.frames[_104d.name]&&win.doc.frames[_104d.name].document)||null;
},bindDomNode:function(node){
node=dom.byId(node,this.ownerDocument);
var cn;
if(node.tagName.toLowerCase()=="iframe"){
var _104e=node,_104f=this._iframeContentWindow(_104e);
cn=win.body(_104f.document);
}else{
cn=(node==win.body(this.ownerDocument)?this.ownerDocument.documentElement:node);
}
var _1050={node:node,iframe:_104e};
_1046.set(node,"_dijitMenu"+this.id,this._bindings.push(_1050));
var _1051=lang.hitch(this,function(cn){
var _1052=this.selector,_1053=_1052?function(_1054){
return on.selector(_1052,_1054);
}:function(_1055){
return _1055;
},self=this;
return [on(cn,_1053(this.leftClickToOpen?"click":"contextmenu"),function(evt){
event.stop(evt);
self._scheduleOpen(this,_104e,{x:evt.pageX,y:evt.pageY});
}),on(cn,_1053("keydown"),function(evt){
if(evt.shiftKey&&evt.keyCode==keys.F10){
event.stop(evt);
self._scheduleOpen(this,_104e);
}
})];
});
_1050.connects=cn?_1051(cn):[];
if(_104e){
_1050.onloadHandler=lang.hitch(this,function(){
var _1056=this._iframeContentWindow(_104e);
cn=win.body(_1056.document);
_1050.connects=_1051(cn);
});
if(_104e.addEventListener){
_104e.addEventListener("load",_1050.onloadHandler,false);
}else{
_104e.attachEvent("onload",_1050.onloadHandler);
}
}
},unBindDomNode:function(_1057){
var node;
try{
node=dom.byId(_1057,this.ownerDocument);
}
catch(e){
return;
}
var _1058="_dijitMenu"+this.id;
if(node&&_1046.has(node,_1058)){
var bid=_1046.get(node,_1058)-1,b=this._bindings[bid],h;
while((h=b.connects.pop())){
h.remove();
}
var _1059=b.iframe;
if(_1059){
if(_1059.removeEventListener){
_1059.removeEventListener("load",b.onloadHandler,false);
}else{
_1059.detachEvent("onload",b.onloadHandler);
}
}
_1046.remove(node,_1058);
delete this._bindings[bid];
}
},_scheduleOpen:function(_105a,_105b,_105c){
if(!this._openTimer){
this._openTimer=this.defer(function(){
delete this._openTimer;
this._openMyself({target:_105a,iframe:_105b,coords:_105c});
},1);
}
},_openMyself:function(args){
var _105d=args.target,_105e=args.iframe,_105f=args.coords;
this.currentTarget=_105d;
if(_105f){
if(_105e){
var ifc=_1047.position(_105e,true),_1060=this._iframeContentWindow(_105e),_1061=_1047.docScroll(_1060.document);
var cs=_1048.getComputedStyle(_105e),tp=_1048.toPixelValue,left=(has("ie")&&has("quirks")?0:tp(_105e,cs.paddingLeft))+(has("ie")&&has("quirks")?tp(_105e,cs.borderLeftWidth):0),top=(has("ie")&&has("quirks")?0:tp(_105e,cs.paddingTop))+(has("ie")&&has("quirks")?tp(_105e,cs.borderTopWidth):0);
_105f.x+=ifc.x+left-_1061.x;
_105f.y+=ifc.y+top-_1061.y;
}
}else{
_105f=_1047.position(_105d,true);
_105f.x+=10;
_105f.y+=10;
}
var self=this;
var _1062=this._focusManager.get("prevNode");
var _1063=this._focusManager.get("curNode");
var _1064=!_1063||(dom.isDescendant(_1063,this.domNode))?_1062:_1063;
function _1065(){
if(self.refocus&&_1064){
_1064.focus();
}
pm.close(self);
};
pm.open({popup:this,x:_105f.x,y:_105f.y,onExecute:_1065,onCancel:_1065,orient:this.isLeftToRight()?"L":"R"});
this.focus();
this._onBlur=function(){
this.inherited("_onBlur",arguments);
pm.close(this);
};
},destroy:function(){
array.forEach(this._bindings,function(b){
if(b){
this.unBindDomNode(b.node);
}
},this);
this.inherited(arguments);
}});
});
},"davinci/html/CSSFile":function(){
define(["dojo/_base/declare","dojo/_base/lang","davinci/html/CSSElement","davinci/html/CSSRule","davinci/html/CSSSelector","system/resource"],function(_1066,lang,_1067,_1068,_1069,_106a){
return _1066("davinci.html.CSSFile",_1067,{constructor:function(args){
this.elementType="CSSFile";
lang.mixin(this,args);
if(!this.options){
this.options={xmode:"style",css:true,expandShorthand:false};
}
var txt=null;
if(this.url&&this.loader){
txt=this.loader(this.url);
}else{
if(this.url){
_106a.findResourceAsync(this.url).then(function(file){
file.getContent().then(function(txt){
this.setText(txt);
}.bind(this));
this.setDirty(file.isDirty());
}.bind(this));
}
}
if(txt){
this.setText(txt);
}
},save:function(_106b){
return _106a.findResourceAsync(this.url).then(function(file){
return file.setContents(this.getText(),_106b);
}.bind(this));
},close:function(){
this.visit({visit:function(node){
if(node.elementType=="CSSImport"){
node.close();
}
}});
require(["dojo/_base/connect"],function(_106c){
_106c.publish("davinci/model/closeModel",[this]);
});
},addRule:function(_106d){
var rule=new _1068();
rule.setText(_106d);
this.addChild(rule);
this.setDirty(true);
return rule;
},setText:function(text){
var _106e=this.children;
this.children=[];
var _106f=require("davinci/html/CSSParser").parse(text,this);
if(_106f.errors.length>0){
}
this.errors=_106f.errors;
if(this.errors.length>0&&this.errors[this.errors.length-1].isException){
this.children=_106e;
}
if(this.includeImports){
this.children.forEach(function(child){
if(child.elementType=="CSSImport"){
child.load();
}
});
}
this.onChange();
},getText:function(_1070){
_1070=_1070||{};
_1070.indent=0;
return this.children.map(function(child){
return child.getText(_1070);
}).join("");
},getCSSFile:function(){
return this;
},getID:function(){
return this.fileName;
},getMatchingRules:function(_1071,rules,_1072){
_1071=this._convertNode(_1071);
rules=rules||[];
_1072=_1072||[];
for(var i=0;i<this.children.length;i++){
var child=this.children[i];
if(child.elementType=="CSSRule"){
var level=child.matches(_1071);
if(level){
var added=false;
for(var j=0;j<_1072.length;j++){
if(level>=_1072[j]){
rules.splice(j,0,child);
_1072.splice(j,0,level);
added=true;
break;
}
}
if(!added){
rules.splice(0,0,child);
_1072.splice(0,0,level);
}
}
}else{
if(child.elementType=="CSSImport"&&child.cssFile){
child.cssFile.getMatchingRules(_1071,rules,_1072);
}
}
}
return rules;
},getRule:function(_1073){
var _1074;
if(!_1073){
return [];
}
var _1075=_1069.parseSelectors(_1073);
for(var i=0;i<this.children.length;i++){
var child=this.children[i];
if(child.elementType=="CSSRule"){
if(child.matchesSelectors(_1075)){
_1074=child;
break;
}
}else{
if(child.elementType=="CSSImport"&&child.cssFile){
_1074=child.cssFile.getRule(_1075)||_1074;
}
}
}
return _1074;
},getRules:function(_1076){
var _1077=_1069.parseSelectors(_1076);
var _1078=[];
for(var i=0;i<this.children.length;i++){
var child=this.children[i];
if(child.elementType=="CSSRule"){
if(child.matchesSelectors(_1077)){
_1078.push(child);
}
}else{
if(child.elementType=="CSSImport"&&child.cssFile){
_1078=_1078.concat(child.cssFile.getRules(_1077));
}
}
}
return _1078;
},getStyleValue:function(_1079,_107a){
var rules=[];
var _107b=[];
_107a=this._convertNode(_107a);
this.getMatchingRules(_107a,rules,_107b);
function _107c(_107d){
var level=0;
var _107e,prop;
for(var i=0;i<rules.length;i++){
if((prop=rules[i].getProperty(_107d))){
if(_107b[i]>level){
_107e=prop;
level=_107b[i];
}
}
}
return _107e;
};
if(typeof _1079=="string"){
_1079=[_1079];
}
return _1079.map(function(name){
return _107c(name);
});
}});
});
},"davinci/ve/actions/ContextAction":function(){
define(["dojo/_base/declare","davinci/actions/Action","davinci/Runtime"],function(_107f,_1080,_1081){
return _107f("davinci.ve.actions.ContextAction",[_1080],{_normalizeSelection:function(_1082){
var _1083=_1082.getSelection();
if(_1083.length<2){
return _1083;
}
var _1084=_1082.rootWidget;
var roots=[];
dojo.forEach(_1083,function(w){
var p=w.getParent();
while(p&&p!=_1084){
for(var i=0;i<_1083.length;i++){
if(_1083[i]==p){
_1082.deselect(w);
return;
}
}
p=p.getParent();
}
roots.push(w);
});
return roots;
},_getContext:function(_1085){
if(_1085){
return _1085;
}
var _1086=_1081.currentEditor;
return _1086&&(_1086.getContext&&_1086.getContext()||_1086.context);
},fixupContext:function(_1087){
var obj=this._getContext(_1087);
if(obj.declaredClass=="davinci.ve.Context"){
return obj;
}else{
if(typeof obj.getContext=="function"){
return obj.getContext();
}else{
return null;
}
}
}});
});
},"dijit/form/_CheckBoxMixin":function(){
define(["dojo/_base/declare","dojo/dom-attr","dojo/_base/event"],function(_1088,_1089,event){
return _1088("dijit.form._CheckBoxMixin",null,{type:"checkbox",value:"on",readOnly:false,_aria_attr:"aria-checked",_setReadOnlyAttr:function(value){
this._set("readOnly",value);
_1089.set(this.focusNode,"readOnly",value);
},_setLabelAttr:undefined,_getSubmitValue:function(value){
return !value&&value!==0?"on":value;
},_setValueAttr:function(_108a){
_108a=this._getSubmitValue(_108a);
this._set("value",_108a);
_1089.set(this.focusNode,"value",_108a);
},reset:function(){
this.inherited(arguments);
this._set("value",this.params.value||"on");
_1089.set(this.focusNode,"value",this.value);
},_onClick:function(e){
if(this.readOnly){
event.stop(e);
return false;
}
return this.inherited(arguments);
}});
});
},"dijit/layout/ContentPane":function(){
define(["dojo/_base/kernel","dojo/_base/lang","../_Widget","../_Container","./_ContentPaneResizeMixin","dojo/string","dojo/html","dojo/i18n!../nls/loading","dojo/_base/array","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/_base/xhr","dojo/i18n","dojo/when"],function(_108b,lang,_108c,_108d,_108e,_108f,html,_1090,array,_1091,_1092,dom,_1093,_1094,xhr,i18n,when){
return _1091("dijit.layout.ContentPane",[_108c,_108d,_108e],{href:"",content:"",extractContent:false,parseOnLoad:true,parserScope:_108b._scopeName,preventCache:false,preload:false,refreshOnShow:false,loadingMessage:"<span class='dijitContentPaneLoading'><span class='dijitInline dijitIconLoading'></span>${loadingState}</span>",errorMessage:"<span class='dijitContentPaneError'><span class='dijitInline dijitIconError'></span>${errorState}</span>",isLoaded:false,baseClass:"dijitContentPane",ioArgs:{},onLoadDeferred:null,_setTitleAttr:null,stopParser:true,template:false,create:function(_1095,_1096){
if((!_1095||!_1095.template)&&_1096&&!("href" in _1095)&&!("content" in _1095)){
_1096=dom.byId(_1096);
var df=_1096.ownerDocument.createDocumentFragment();
while(_1096.firstChild){
df.appendChild(_1096.firstChild);
}
_1095=lang.delegate(_1095,{content:df});
}
this.inherited(arguments,[_1095,_1096]);
},postMixInProperties:function(){
this.inherited(arguments);
var _1097=i18n.getLocalization("dijit","loading",this.lang);
this.loadingMessage=_108f.substitute(this.loadingMessage,_1097);
this.errorMessage=_108f.substitute(this.errorMessage,_1097);
},buildRendering:function(){
this.inherited(arguments);
if(!this.containerNode){
this.containerNode=this.domNode;
}
this.domNode.title="";
if(!_1093.get(this.domNode,"role")){
this.domNode.setAttribute("role","group");
}
},startup:function(){
this.inherited(arguments);
if(this._contentSetter){
array.forEach(this._contentSetter.parseResults,function(obj){
if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){
obj.startup();
obj._started=true;
}
},this);
}
},_startChildren:function(){
array.forEach(this.getChildren(),function(obj){
if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){
obj.startup();
obj._started=true;
}
});
if(this._contentSetter){
array.forEach(this._contentSetter.parseResults,function(obj){
if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){
obj.startup();
obj._started=true;
}
},this);
}
},setHref:function(href){
_108b.deprecated("dijit.layout.ContentPane.setHref() is deprecated. Use set('href', ...) instead.","","2.0");
return this.set("href",href);
},_setHrefAttr:function(href){
this.cancel();
this.onLoadDeferred=new _1092(lang.hitch(this,"cancel"));
this.onLoadDeferred.then(lang.hitch(this,"onLoad"));
this._set("href",href);
if(this.preload||(this._created&&this._isShown())){
this._load();
}else{
this._hrefChanged=true;
}
return this.onLoadDeferred;
},setContent:function(data){
_108b.deprecated("dijit.layout.ContentPane.setContent() is deprecated.  Use set('content', ...) instead.","","2.0");
this.set("content",data);
},_setContentAttr:function(data){
this._set("href","");
this.cancel();
this.onLoadDeferred=new _1092(lang.hitch(this,"cancel"));
if(this._created){
this.onLoadDeferred.then(lang.hitch(this,"onLoad"));
}
this._setContent(data||"");
this._isDownloaded=false;
return this.onLoadDeferred;
},_getContentAttr:function(){
return this.containerNode.innerHTML;
},cancel:function(){
if(this._xhrDfd&&(this._xhrDfd.fired==-1)){
this._xhrDfd.cancel();
}
delete this._xhrDfd;
this.onLoadDeferred=null;
},destroy:function(){
this.cancel();
this.inherited(arguments);
},destroyRecursive:function(_1098){
if(this._beingDestroyed){
return;
}
this.inherited(arguments);
},_onShow:function(){
this.inherited(arguments);
if(this.href){
if(!this._xhrDfd&&(!this.isLoaded||this._hrefChanged||this.refreshOnShow)){
return this.refresh();
}
}
},refresh:function(){
this.cancel();
this.onLoadDeferred=new _1092(lang.hitch(this,"cancel"));
this.onLoadDeferred.then(lang.hitch(this,"onLoad"));
this._load();
return this.onLoadDeferred;
},_load:function(){
this._setContent(this.onDownloadStart(),true);
var self=this;
var _1099={preventCache:(this.preventCache||this.refreshOnShow),url:this.href,handleAs:"text"};
if(lang.isObject(this.ioArgs)){
lang.mixin(_1099,this.ioArgs);
}
var hand=(this._xhrDfd=(this.ioMethod||xhr.get)(_1099)),_109a;
hand.then(function(html){
_109a=html;
try{
self._isDownloaded=true;
return self._setContent(html,false);
}
catch(err){
self._onError("Content",err);
}
},function(err){
if(!hand.canceled){
self._onError("Download",err);
}
delete self._xhrDfd;
return err;
}).then(function(){
self.onDownloadEnd();
delete self._xhrDfd;
return _109a;
});
delete this._hrefChanged;
},_onLoadHandler:function(data){
this._set("isLoaded",true);
try{
this.onLoadDeferred.resolve(data);
}
catch(e){
console.error("Error "+this.widgetId+" running custom onLoad code: "+e.message);
}
},_onUnloadHandler:function(){
this._set("isLoaded",false);
try{
this.onUnload();
}
catch(e){
console.error("Error "+this.widgetId+" running custom onUnload code: "+e.message);
}
},destroyDescendants:function(_109b){
if(this.isLoaded){
this._onUnloadHandler();
}
var _109c=this._contentSetter;
array.forEach(this.getChildren(),function(_109d){
if(_109d.destroyRecursive){
_109d.destroyRecursive(_109b);
}else{
if(_109d.destroy){
_109d.destroy(_109b);
}
}
_109d._destroyed=true;
});
if(_109c){
array.forEach(_109c.parseResults,function(_109e){
if(!_109e._destroyed){
if(_109e.destroyRecursive){
_109e.destroyRecursive(_109b);
}else{
if(_109e.destroy){
_109e.destroy(_109b);
}
}
_109e._destroyed=true;
}
});
delete _109c.parseResults;
}
if(!_109b){
_1094.empty(this.containerNode);
}
delete this._singleChild;
},_setContent:function(cont,_109f){
this.destroyDescendants();
var _10a0=this._contentSetter;
if(!(_10a0&&_10a0 instanceof html._ContentSetter)){
_10a0=this._contentSetter=new html._ContentSetter({node:this.containerNode,_onError:lang.hitch(this,this._onError),onContentError:lang.hitch(this,function(e){
var _10a1=this.onContentError(e);
try{
this.containerNode.innerHTML=_10a1;
}
catch(e){
console.error("Fatal "+this.id+" could not change content due to "+e.message,e);
}
})});
}
var _10a2=lang.mixin({cleanContent:this.cleanContent,extractContent:this.extractContent,parseContent:!cont.domNode&&this.parseOnLoad,parserScope:this.parserScope,startup:false,dir:this.dir,lang:this.lang,textDir:this.textDir},this._contentSetterParams||{});
var p=_10a0.set((lang.isObject(cont)&&cont.domNode)?cont.domNode:cont,_10a2);
var self=this;
return when(p&&p.then?p:_10a0.parseDeferred,function(){
delete self._contentSetterParams;
if(!_109f){
if(self._started){
self._startChildren();
self._scheduleLayout();
}
self._onLoadHandler(cont);
}
});
},_onError:function(type,err,_10a3){
this.onLoadDeferred.reject(err);
var _10a4=this["on"+type+"Error"].call(this,err);
if(_10a3){
console.error(_10a3,err);
}else{
if(_10a4){
this._setContent(_10a4,true);
}
}
},onLoad:function(){
},onUnload:function(){
},onDownloadStart:function(){
return this.loadingMessage;
},onContentError:function(){
},onDownloadError:function(){
return this.errorMessage;
},onDownloadEnd:function(){
}});
});
},"url:dijit/form/templates/ValidationTextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\" role=\"presentation\"\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n","davinci/html/HTMLText":function(){
define(["dojo/_base/declare","davinci/html/HTMLItem"],function(_10a5,_10a6){
return _10a5("davinci.html.HTMLText",_10a6,{constructor:function(value){
this.elementType="HTMLText";
this.value=value||"";
},getText:function(_10a7){
return this.value;
},setText:function(value){
if(this.wasParsed||(this.parent&&this.parent.wasParsed)){
var delta=value.length-this.value.length;
if(delta>0){
this.getHTMLFile().updatePositions(this.startOffset+1,delta);
}
}
this.value=value;
},getLabel:function(){
if(this.value.length<15){
return this.value;
}
return this.value.substring(0,15)+"...";
}});
});
},"url:dijit/form/templates/TextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\" id=\"widget_${id}\" role=\"presentation\"\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n","dijit/_KeyNavContainer":function(){
define(["dojo/_base/kernel","./_Container","./_FocusMixin","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/_base/event","dojo/dom-attr","dojo/_base/lang"],function(_10a8,_10a9,_10aa,array,keys,_10ab,event,_10ac,lang){
return _10ab("dijit._KeyNavContainer",[_10aa,_10a9],{tabIndex:"0",connectKeyNavHandlers:function(_10ad,_10ae){
var _10af=(this._keyNavCodes={});
var prev=lang.hitch(this,"focusPrev");
var next=lang.hitch(this,"focusNext");
array.forEach(_10ad,function(code){
_10af[code]=prev;
});
array.forEach(_10ae,function(code){
_10af[code]=next;
});
_10af[keys.HOME]=lang.hitch(this,"focusFirstChild");
_10af[keys.END]=lang.hitch(this,"focusLastChild");
this.connect(this.domNode,"onkeypress","_onContainerKeypress");
this.connect(this.domNode,"onfocus","_onContainerFocus");
},startupKeyNavChildren:function(){
_10a8.deprecated("startupKeyNavChildren() call no longer needed","","2.0");
},startup:function(){
this.inherited(arguments);
array.forEach(this.getChildren(),lang.hitch(this,"_startupChild"));
},addChild:function(_10b0,_10b1){
this.inherited(arguments);
this._startupChild(_10b0);
},focus:function(){
this.focusFirstChild();
},focusFirstChild:function(){
this.focusChild(this._getFirstFocusableChild());
},focusLastChild:function(){
this.focusChild(this._getLastFocusableChild());
},focusNext:function(){
this.focusChild(this._getNextFocusableChild(this.focusedChild,1));
},focusPrev:function(){
this.focusChild(this._getNextFocusableChild(this.focusedChild,-1),true);
},focusChild:function(_10b2,last){
if(!_10b2){
return;
}
if(this.focusedChild&&_10b2!==this.focusedChild){
this._onChildBlur(this.focusedChild);
}
_10b2.set("tabIndex",this.tabIndex);
_10b2.focus(last?"end":"start");
this._set("focusedChild",_10b2);
},_startupChild:function(_10b3){
_10b3.set("tabIndex","-1");
this.connect(_10b3,"_onFocus",function(){
_10b3.set("tabIndex",this.tabIndex);
});
this.connect(_10b3,"_onBlur",function(){
_10b3.set("tabIndex","-1");
});
},_onContainerFocus:function(evt){
if(evt.target!==this.domNode||this.focusedChild){
return;
}
this.focusFirstChild();
_10ac.set(this.domNode,"tabIndex","-1");
},_onBlur:function(evt){
if(this.tabIndex){
_10ac.set(this.domNode,"tabIndex",this.tabIndex);
}
this.focusedChild=null;
this.inherited(arguments);
},_onContainerKeypress:function(evt){
if(evt.ctrlKey||evt.altKey){
return;
}
var func=this._keyNavCodes[evt.charOrCode];
if(func){
func();
event.stop(evt);
}
},_onChildBlur:function(){
},_getFirstFocusableChild:function(){
return this._getNextFocusableChild(null,1);
},_getLastFocusableChild:function(){
return this._getNextFocusableChild(null,-1);
},_getNextFocusableChild:function(child,dir){
if(child){
child=this._getSiblingOfChild(child,dir);
}
var _10b4=this.getChildren();
for(var i=0;i<_10b4.length;i++){
if(!child){
child=_10b4[(dir>0)?0:(_10b4.length-1)];
}
if(child.isFocusable()){
return child;
}
child=this._getSiblingOfChild(child,dir);
}
return null;
}});
});
},"dijit/layout/utils":function(){
define(["dojo/_base/array","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","../main"],function(array,_10b5,_10b6,_10b7,lang,dijit){
var _10b8=lang.getObject("layout",true,dijit);
_10b8.marginBox2contentBox=function(node,mb){
var cs=_10b7.getComputedStyle(node);
var me=_10b6.getMarginExtents(node,cs);
var pb=_10b6.getPadBorderExtents(node,cs);
return {l:_10b7.toPixelValue(node,cs.paddingLeft),t:_10b7.toPixelValue(node,cs.paddingTop),w:mb.w-(me.w+pb.w),h:mb.h-(me.h+pb.h)};
};
function _10b9(word){
return word.substring(0,1).toUpperCase()+word.substring(1);
};
function size(_10ba,dim){
var _10bb=_10ba.resize?_10ba.resize(dim):_10b6.setMarginBox(_10ba.domNode,dim);
if(_10bb){
lang.mixin(_10ba,_10bb);
}else{
lang.mixin(_10ba,_10b6.getMarginBox(_10ba.domNode));
lang.mixin(_10ba,dim);
}
};
_10b8.layoutChildren=function(_10bc,dim,_10bd,_10be,_10bf){
dim=lang.mixin({},dim);
_10b5.add(_10bc,"dijitLayoutContainer");
_10bd=array.filter(_10bd,function(item){
return item.region!="center"&&item.layoutAlign!="client";
}).concat(array.filter(_10bd,function(item){
return item.region=="center"||item.layoutAlign=="client";
}));
array.forEach(_10bd,function(child){
var elm=child.domNode,pos=(child.region||child.layoutAlign);
if(!pos){
throw new Error("No region setting for "+child.id);
}
var _10c0=elm.style;
_10c0.left=dim.l+"px";
_10c0.top=dim.t+"px";
_10c0.position="absolute";
_10b5.add(elm,"dijitAlign"+_10b9(pos));
var _10c1={};
if(_10be&&_10be==child.id){
_10c1[child.region=="top"||child.region=="bottom"?"h":"w"]=_10bf;
}
if(pos=="top"||pos=="bottom"){
_10c1.w=dim.w;
size(child,_10c1);
dim.h-=child.h;
if(pos=="top"){
dim.t+=child.h;
}else{
_10c0.top=dim.t+dim.h+"px";
}
}else{
if(pos=="left"||pos=="right"){
_10c1.h=dim.h;
size(child,_10c1);
dim.w-=child.w;
if(pos=="left"){
dim.l+=child.w;
}else{
_10c0.left=dim.l+dim.w+"px";
}
}else{
if(pos=="client"||pos=="center"){
size(child,dim);
}
}
}
});
};
return {marginBox2contentBox:_10b8.marginBox2contentBox,layoutChildren:_10b8.layoutChildren};
});
},"davinci/html/CSSElement":function(){
define(["dojo/_base/declare","davinci/model/Model"],function(_10c2,Model){
return _10c2("davinci.html.CSSElement",Model,{constructor:function(){
if(typeof pushComment!="undefined"&&pushComment!==null){
this.comment=pushComment;
pushComment=null;
}
this.elementType="CSSElement";
},getLabel:function(){
context={indent:0,noComments:true};
return this.getText(context);
},onChange:function(arg){
if(this.parent){
if(arg){
this.parent.onChange(arg);
}else{
this.parent.onChange(this);
}
}
},close:function(_10c3){
for(var i=0;i<this.children;i++){
this.children[i].close();
}
},getCSSFile:function(){
var rule=this.getCSSRule();
if(rule){
return rule.parent;
}
},getCSSRule:function(){
},_convertNode:function(_10c4){
if(dojo.isArray(_10c4)){
return _10c4;
}
var nodes=[];
while(_10c4&&_10c4.tagName!="HTML"){
nodes.push({tagName:_10c4.tagName,id:_10c4.id,classes:(_10c4.className&&_10c4.className.split(" "))});
_10c4=_10c4.parentNode;
}
return nodes;
},getID:function(){
return this.parent.getID()+":"+this.startOffset+":"+this.getLabel();
}});
});
},"dijit/form/DataList":function(){
define(["dojo/_base/declare","dojo/dom","dojo/_base/lang","dojo/query","dojo/store/Memory","../registry"],function(_10c5,dom,lang,query,_10c6,_10c7){
function _10c8(_10c9){
return {id:_10c9.value,value:_10c9.value,name:lang.trim(_10c9.innerText||_10c9.textContent||"")};
};
return _10c5("dijit.form.DataList",_10c6,{constructor:function(_10ca,_10cb){
this.domNode=dom.byId(_10cb);
lang.mixin(this,_10ca);
if(this.id){
_10c7.add(this);
}
this.domNode.style.display="none";
this.inherited(arguments,[{data:query("option",this.domNode).map(_10c8)}]);
},destroy:function(){
_10c7.remove(this.id);
},fetchSelectedItem:function(){
var _10cc=query("> option[selected]",this.domNode)[0]||query("> option",this.domNode)[0];
return _10cc&&_10c8(_10cc);
}});
});
},"davinci/ve/HTMLWidget":function(){
define(["dojo/_base/declare","./_Widget"],function(_10cd,_10ce){
return _10cd("davinci.ve.HTMLWidget",_10ce,{isHtmlWidget:true,constructor:function(_10cf,node){
this.type="html."+node.tagName.toLowerCase();
this.acceptsHTMLChildren=true;
},buildRendering:function(){
this.containerNode=this.domNode;
if(this._params){
for(var name in this._params){
this.domNode.setAttribute(name,this._params[name]);
}
this._params=undefined;
}
try{
dojo.addClass(this.domNode,"HtmlWidget");
}
catch(e){
}
},_getChildrenData:function(_10d0){
function _10d1(node){
var d=node.nodeValue.trim();
if(d){
d=davinci.html.escapeXml(d);
}
return d;
};
var _10d2=this.domNode;
if(!_10d2.hasChildNodes()){
return null;
}
if(_10d2.childNodes.length===1&&_10d2.firstChild.nodeType===3){
return _10d1(_10d2.firstChild);
}
var data=[];
dojo.forEach(_10d2.childNodes,function(node){
var d;
switch(node.nodeType){
case 1:
var w=require("davinci/ve/widget").byNode(node);
if(w){
d=w.getData(_10d0);
}
break;
case 3:
d=_10d1(node);
break;
case 8:
d="<!--"+node.nodeValue+"-->";
break;
}
if(d){
data.push(d);
}
});
return data;
},setProperties:function(_10d3,_10d4){
var node=this.domNode;
_10d4=_10d4||false;
for(var name in _10d3){
if(name==="style"){
dojo.style(node,_10d3[name]);
}else{
if(!_10d4){
var _10d5=_10d3[name];
if(_10d5||typeof _10d5=="boolean"||typeof _10d5=="number"){
node.setAttribute(name,_10d5);
}else{
node.removeAttribute(name);
}
}
}
}
this.inherited(arguments);
},resize:function(){
this.getChildren().forEach(function(_10d6){
if(_10d6.resize){
_10d6.resize();
}
});
},_attr:function(name,value){
if(arguments.length>1){
this.domNode[name]=value;
}else{
return this.domNode[name];
}
},getTagName:function(){
return this.domNode.nodeName.toLowerCase();
}});
});
},"url:dijit/templates/Dialog.html":"<div class=\"dijitDialog\" role=\"dialog\" aria-labelledby=\"${id}_title\">\n\t<div data-dojo-attach-point=\"titleBar\" class=\"dijitDialogTitleBar\">\n\t\t<span data-dojo-attach-point=\"titleNode\" class=\"dijitDialogTitle\" id=\"${id}_title\"\n\t\t\t\trole=\"heading\" level=\"1\"></span>\n\t\t<span data-dojo-attach-point=\"closeButtonNode\" class=\"dijitDialogCloseIcon\" data-dojo-attach-event=\"ondijitclick: onCancel\" title=\"${buttonCancel}\" role=\"button\" tabIndex=\"-1\">\n\t\t\t<span data-dojo-attach-point=\"closeText\" class=\"closeText\" title=\"${buttonCancel}\">x</span>\n\t\t</span>\n\t</div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitDialogPaneContent\"></div>\n</div>\n","dijit/form/CheckBox":function(){
define(["require","dojo/_base/declare","dojo/dom-attr","dojo/has","dojo/query","dojo/ready","./ToggleButton","./_CheckBoxMixin","dojo/text!./templates/CheckBox.html","dojo/NodeList-dom"],function(_10d7,_10d8,_10d9,has,query,ready,_10da,_10db,_10dc){
if(has("dijit-legacy-requires")){
ready(0,function(){
var _10dd=["dijit/form/RadioButton"];
_10d7(_10dd);
});
}
return _10d8("dijit.form.CheckBox",[_10da,_10db],{templateString:_10dc,baseClass:"dijitCheckBox",_setValueAttr:function(_10de,_10df){
if(typeof _10de=="string"){
this.inherited(arguments);
_10de=true;
}
if(this._created){
this.set("checked",_10de,_10df);
}
},_getValueAttr:function(){
return (this.checked?this.value:false);
},_setIconClassAttr:null,postMixInProperties:function(){
this.inherited(arguments);
this.checkedAttrSetting=this.checked?"checked":"";
},_fillContent:function(){
},_onFocus:function(){
if(this.id){
query("label[for='"+this.id+"']").addClass("dijitFocusedLabel");
}
this.inherited(arguments);
},_onBlur:function(){
if(this.id){
query("label[for='"+this.id+"']").removeClass("dijitFocusedLabel");
}
this.inherited(arguments);
}});
});
},"davinci/model/Model":function(){
define(["dojo/_base/declare"],function(_10e0){
return _10e0("davinci.model.Model",null,{constructor:function(){
this.elementType="";
this.name="";
this.startOffset=0;
this.endOffset=0;
this.parent=null;
this.children=[];
},inherits:function(_10e1){
if(arguments.length>1){
_10e1.apply(this,Array.prototype.slice.call(arguments,1));
}else{
_10e1.call(this);
}
},getText:function(){
},setText:function(text){
},addChild:function(child,index,_10e2){
child.parent=this;
if(index!=undefined){
this.children.splice(index,0,child);
}else{
this.children.push(child);
}
},setStart:function(_10e3){
this.startOffset=_10e3;
},setEnd:function(_10e4){
this.endOffset=_10e4;
},getLabel:function(){
return null;
},getID:function(){
return null;
},mapPositions:function(_10e5){
return {startOffset:_10e5.startOffset,endOffset:_10e5.endOffset};
},findChildAtPosition:function(_10e6){
if(!_10e6.endOffset){
_10e6.endOffset=_10e6.startOffset;
}
if(_10e6.startOffset>=this.startOffset&&_10e6.endOffset<=this.endOffset){
for(var i=0;i<this.children.length;i++){
var child=this.children[i].findChildAtPosition(_10e6);
if(child!=null){
return child;
}
}
return this;
}
return null;
},removeChild:function(child){
for(var i=0;i<this.children.length;i++){
if(this.children[i]==child){
this.children.splice(i,1);
return;
}
}
},find:function(_10e7,_10e8){
var _10e9={visit:function(node){
if(this.found.length>0&&_10e8){
return true;
}
var name=null;
for(name in _10e7){
if(node[name]!=_10e7[name]){
break;
}
}
if(node[name]==_10e7[name]){
this.found.push(node);
}
return false;
},found:[]};
this.visit(_10e9);
if(_10e8){
return (_10e9.found.length>0)?_10e9.found[0]:null;
}
return _10e9.found;
},setDirty:function(_10ea){
this.dirtyResource=_10ea;
},isDirty:function(){
return this.dirtyResource;
},searchUp:function(_10eb){
if(this.elementType==_10eb){
return this;
}
var _10ec=this.parent;
while(_10ec&&_10ec.elementType!=_10eb){
_10ec=_10ec.parent;
}
return _10ec;
},visit:function(_10ed){
if(!_10ed.visit(this)){
for(var i=0;i<this.children.length;i++){
this.children[i].visit(_10ed);
}
}
if(_10ed.endVisit){
_10ed.endVisit(this);
}
},updatePositions:function(model,_10ee,delta){
visitor={visit:function(_10ef){
if(_10ef.endOffset<_10ee){
return true;
}
if(_10ef.startOffset>=_10ee){
_10ef.startOffset+=delta;
_10ef.endOffset+=delta;
}else{
if(_10ef.endOffset>=_10ee){
_10ef.endOffset+=delta;
}
}
}};
model.visit(visitor);
}});
});
},"dijit/tree/_dndSelector":function(){
define(["dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/Deferred","dojo/_base/kernel","dojo/_base/lang","dojo/cookie","dojo/mouse","dojo/on","dojo/touch","./_dndContainer"],function(array,_10f0,_10f1,_10f2,_10f3,lang,_10f4,mouse,on,touch,_10f5){
return _10f1("dijit.tree._dndSelector",_10f5,{constructor:function(){
this.selection={};
this.anchor=null;
if(!this.cookieName&&this.tree.id){
this.cookieName=this.tree.id+"SaveSelectedCookie";
}
this.events.push(on(this.tree.domNode,touch.press,lang.hitch(this,"onMouseDown")),on(this.tree.domNode,touch.release,lang.hitch(this,"onMouseUp")),on(this.tree.domNode,touch.move,lang.hitch(this,"onMouseMove")));
},singular:false,getSelectedTreeNodes:function(){
var nodes=[],sel=this.selection;
for(var i in sel){
nodes.push(sel[i]);
}
return nodes;
},selectNone:function(){
this.setSelection([]);
return this;
},destroy:function(){
this.inherited(arguments);
this.selection=this.anchor=null;
},addTreeNode:function(node,_10f6){
this.setSelection(this.getSelectedTreeNodes().concat([node]));
if(_10f6){
this.anchor=node;
}
return node;
},removeTreeNode:function(node){
this.setSelection(this._setDifference(this.getSelectedTreeNodes(),[node]));
return node;
},isTreeNodeSelected:function(node){
return node.id&&!!this.selection[node.id];
},setSelection:function(_10f7){
var _10f8=this.getSelectedTreeNodes();
array.forEach(this._setDifference(_10f8,_10f7),lang.hitch(this,function(node){
node.setSelected(false);
if(this.anchor==node){
delete this.anchor;
}
delete this.selection[node.id];
}));
array.forEach(this._setDifference(_10f7,_10f8),lang.hitch(this,function(node){
node.setSelected(true);
this.selection[node.id]=node;
}));
this._updateSelectionProperties();
},_setDifference:function(xs,ys){
array.forEach(ys,function(y){
y.__exclude__=true;
});
var ret=array.filter(xs,function(x){
return !x.__exclude__;
});
array.forEach(ys,function(y){
delete y["__exclude__"];
});
return ret;
},_updateSelectionProperties:function(){
var _10f9=this.getSelectedTreeNodes();
var paths=[],nodes=[],_10fa=[];
array.forEach(_10f9,function(node){
var ary=node.getTreePath(),model=this.tree.model;
nodes.push(node);
paths.push(ary);
ary=array.map(ary,function(item){
return model.getIdentity(item);
},this);
_10fa.push(ary.join("/"));
},this);
var items=array.map(nodes,function(node){
return node.item;
});
this.tree._set("paths",paths);
this.tree._set("path",paths[0]||[]);
this.tree._set("selectedNodes",nodes);
this.tree._set("selectedNode",nodes[0]||null);
this.tree._set("selectedItems",items);
this.tree._set("selectedItem",items[0]||null);
if(this.tree.persist&&_10fa.length>0){
_10f4(this.cookieName,_10fa.join(","),{expires:365});
}
},_getSavedPaths:function(){
var tree=this.tree;
if(tree.persist&&tree.dndController.cookieName){
var oreo,paths=[];
oreo=_10f4(tree.dndController.cookieName);
if(oreo){
paths=array.map(oreo.split(","),function(path){
return path.split("/");
});
}
return paths;
}
},onMouseDown:function(e){
if(!this.current||this.tree.isExpandoNode(e.target,this.current)){
return;
}
if(mouse.isLeft(e)){
e.preventDefault();
}else{
if(e.type!="touchstart"){
return;
}
}
var _10fb=this.current,copy=_10f0.isCopyKey(e),id=_10fb.id;
if(!this.singular&&!e.shiftKey&&this.selection[id]){
this._doDeselect=true;
return;
}else{
this._doDeselect=false;
}
this.userSelect(_10fb,copy,e.shiftKey);
},onMouseUp:function(e){
if(!this._doDeselect){
return;
}
this._doDeselect=false;
this.userSelect(this.current,_10f0.isCopyKey(e),e.shiftKey);
},onMouseMove:function(){
this._doDeselect=false;
},_compareNodes:function(n1,n2){
if(n1===n2){
return 0;
}
if("sourceIndex" in document.documentElement){
return n1.sourceIndex-n2.sourceIndex;
}else{
if("compareDocumentPosition" in document.documentElement){
return n1.compareDocumentPosition(n2)&2?1:-1;
}else{
if(document.createRange){
var r1=doc.createRange();
r1.setStartBefore(n1);
var r2=doc.createRange();
r2.setStartBefore(n2);
return r1.compareBoundaryPoints(r1.END_TO_END,r2);
}else{
throw Error("dijit.tree._compareNodes don't know how to compare two different nodes in this browser");
}
}
}
},userSelect:function(node,multi,range){
if(this.singular){
if(this.anchor==node&&multi){
this.selectNone();
}else{
this.setSelection([node]);
this.anchor=node;
}
}else{
if(range&&this.anchor){
var cr=this._compareNodes(this.anchor.rowNode,node.rowNode),begin,end,_10fc=this.anchor;
if(cr<0){
begin=_10fc;
end=node;
}else{
begin=node;
end=_10fc;
}
var nodes=[];
while(begin!=end){
nodes.push(begin);
begin=this.tree._getNextNode(begin);
}
nodes.push(end);
this.setSelection(nodes);
}else{
if(this.selection[node.id]&&multi){
this.removeTreeNode(node);
}else{
if(multi){
this.addTreeNode(node,true);
}else{
this.setSelection([node]);
this.anchor=node;
}
}
}
}
},getItem:function(key){
var _10fd=this.selection[key];
return {data:_10fd,type:["treeNode"]};
},forInSelectedItems:function(f,o){
o=o||_10f3.global;
for(var id in this.selection){
f.call(o,this.getItem(id),id,this);
}
}});
});
},"url:dijit/templates/MenuBar.html":"<div class=\"dijitMenuBar dijitMenuPassive\" data-dojo-attach-point=\"containerNode\"  role=\"menubar\" tabIndex=\"${tabIndex}\" data-dojo-attach-event=\"onkeypress: _onKeyPress\"></div>\n","davinci/ve/commands/ModifyRichTextCommand":function(){
define(["dojo/_base/declare"],function(_10fe){
return _10fe("davinci.ve.commands.ModifyRichTextCommand",null,{name:"modify",constructor:function(_10ff,_1100,_1101,_1102){
this._oldId=_10ff?_10ff.id:undefined;
this._properties=_1100=(_1100||{});
if(_1100.richText){
this._richText=true;
this._newText=_1100.richText;
this._children=_1100.richText;
delete _1100.richText;
}else{
this._children=_1100._children;
}
this._context=_1102||_10ff.getContext();
},setContext:function(_1103){
this._context=_1103;
},add:function(_1104){
if(!_1104||_1104._oldId!=this._oldId){
return;
}
if(_1104._properties){
dojo.mixin(this._properties,_1104._properties);
}
if(_1104._children){
this._children=_1104._children;
}
},execute:function(){
if(!this._oldId||!this._properties){
return;
}
var _1105=require("davinci/ve/widget");
var _1106=_1105.byId(this._oldId);
if(!_1106){
return;
}
this._parentWidget=_1106.getParent();
if(!this._oldText){
this._oldText=_1106._srcElement.getElementText(this._context);
if(this._oldText&&(typeof this._oldText=="string")){
this._oldText=this._oldText.replace(/\n/g,"");
}
}
if(!this._oldData){
this._oldData=_1106.getData();
this._oldData.context=this._context;
this._newData={type:this._oldData.type,properties:dojo.mixin({},this._oldData.properties,this._properties),children:this._newText,maqStates:this._oldData.maqStates,maqDeltas:this._oldData.maqDeltas,context:this._context};
this._oldData={type:this._oldData.type,properties:dojo.mixin({},this._oldData.properties,this._properties),children:this._oldText,maqStates:this._oldData.maqStates,maqDeltas:this._oldData.maqDeltas,context:this._context};
}
var _1107=this._context;
if(_1107){
_1107.detach(_1106);
}
if(this._properties.id){
delete this._newData.properties.isTempID;
}
if(!this._newId_isTempID){
this._newId_isTempID=this._newData.properties.isTempID;
}
if(!this._oldId_isTempID){
this._oldId_isTempID=this._oldData.properties.isTempID;
}
var _1108=null;
var index=this._parentWidget.indexOf(_1106);
this._parentWidget.removeChild(_1106);
_1106.destroyWidget();
if(this._newId){
this._newData.properties.id=this._newId;
}
if(this._newId_isTempID){
this._newData.properties.isTempID=this._newId_isTempID;
}
_1108=_1105.createWidget(this._newData);
if(!_1108){
return;
}
this._parentWidget.addChild(_1108,index);
this._newId=_1108.id;
if(this._context){
this._refresh(_1108);
}
if(_1107){
_1107.widgetAddedOrDeleted();
if(this._oldId!=this._newId){
_1107.widgetChanged(_1107.WIDGET_ID_CHANGED,_1108,this._oldId);
}
_1107.widgetChanged(_1107.WIDGET_MODIFIED,_1108);
}
this.newWidget=_1108;
dojo.publish("/davinci/ui/widget/replaced",[_1108,_1106]);
var _1109=require("davinci/ve/States");
_1109.resetState(_1108.domNode);
},undo:function(){
if(!this._newId||!this._oldData){
return;
}
var _110a=require("davinci/ve/widget");
var _110b=_110a.byId(this._newId);
if(!_110b){
return;
}
var index=dojo.indexOf(this._parentWidget.getChildren(),_110b);
if(index<0){
return;
}
var _110c=this._parentWidget.getContext();
if(_110c){
_110c.detach(_110b);
}
this._parentWidget.removeChild(_110b);
_110b.destroyWidget();
this._oldData.children=this._oldText;
this._oldData.properties.id=this._oldId;
var _110d=_110a.createWidget(this._oldData);
this._parentWidget.addChild(_110d,index);
if(_110c){
this._refresh(_110d);
}
_110c.widgetAddedOrDeleted();
_110c.widgetChanged(_110c.WIDGET_MODIFIED,_110d);
dojo.publish("/davinci/ui/widget/replaced",[_110d,_110b]);
var _110e=require("davinci/ve/States");
_110e.resetState(_110d.domNode);
},_refresh:function(_110f){
var _1110=_110f.getContainerNode();
if(_1110){
this._context.getGlobal()["require"]("dojo/parser").parse(_1110);
}
this._context.attach(_110f);
_110f.startup();
_110f.renderWidget();
if(_1110){
this._context._attachChildren(_1110);
}
}});
});
},"dojo/data/ItemFileReadStore":function(){
define(["../_base/kernel","../_base/lang","../_base/declare","../_base/array","../_base/xhr","../Evented","./util/filter","./util/simpleFetch","../date/stamp"],function(_1111,lang,_1112,array,xhr,_1113,_1114,_1115,_1116){
var _1117=_1112("dojo.data.ItemFileReadStore",[_1113],{constructor:function(_1118){
this._arrayOfAllItems=[];
this._arrayOfTopLevelItems=[];
this._loadFinished=false;
this._jsonFileUrl=_1118.url;
this._ccUrl=_1118.url;
this.url=_1118.url;
this._jsonData=_1118.data;
this.data=null;
this._datatypeMap=_1118.typeMap||{};
if(!this._datatypeMap["Date"]){
this._datatypeMap["Date"]={type:Date,deserialize:function(value){
return _1116.fromISOString(value);
}};
}
this._features={"dojo.data.api.Read":true,"dojo.data.api.Identity":true};
this._itemsByIdentity=null;
this._storeRefPropName="_S";
this._itemNumPropName="_0";
this._rootItemPropName="_RI";
this._reverseRefMap="_RRM";
this._loadInProgress=false;
this._queuedFetches=[];
if(_1118.urlPreventCache!==undefined){
this.urlPreventCache=_1118.urlPreventCache?true:false;
}
if(_1118.hierarchical!==undefined){
this.hierarchical=_1118.hierarchical?true:false;
}
if(_1118.clearOnClose){
this.clearOnClose=true;
}
if("failOk" in _1118){
this.failOk=_1118.failOk?true:false;
}
},url:"",_ccUrl:"",data:null,typeMap:null,clearOnClose:false,urlPreventCache:false,failOk:false,hierarchical:true,_assertIsItem:function(item){
if(!this.isItem(item)){
throw new Error(this.declaredClass+": Invalid item argument.");
}
},_assertIsAttribute:function(_1119){
if(typeof _1119!=="string"){
throw new Error(this.declaredClass+": Invalid attribute argument.");
}
},getValue:function(item,_111a,_111b){
var _111c=this.getValues(item,_111a);
return (_111c.length>0)?_111c[0]:_111b;
},getValues:function(item,_111d){
this._assertIsItem(item);
this._assertIsAttribute(_111d);
return (item[_111d]||[]).slice(0);
},getAttributes:function(item){
this._assertIsItem(item);
var _111e=[];
for(var key in item){
if((key!==this._storeRefPropName)&&(key!==this._itemNumPropName)&&(key!==this._rootItemPropName)&&(key!==this._reverseRefMap)){
_111e.push(key);
}
}
return _111e;
},hasAttribute:function(item,_111f){
this._assertIsItem(item);
this._assertIsAttribute(_111f);
return (_111f in item);
},containsValue:function(item,_1120,value){
var _1121=undefined;
if(typeof value==="string"){
_1121=_1114.patternToRegExp(value,false);
}
return this._containsValue(item,_1120,value,_1121);
},_containsValue:function(item,_1122,value,_1123){
return array.some(this.getValues(item,_1122),function(_1124){
if(_1124!==null&&!lang.isObject(_1124)&&_1123){
if(_1124.toString().match(_1123)){
return true;
}
}else{
if(value===_1124){
return true;
}
}
});
},isItem:function(_1125){
if(_1125&&_1125[this._storeRefPropName]===this){
if(this._arrayOfAllItems[_1125[this._itemNumPropName]]===_1125){
return true;
}
}
return false;
},isItemLoaded:function(_1126){
return this.isItem(_1126);
},loadItem:function(_1127){
this._assertIsItem(_1127.item);
},getFeatures:function(){
return this._features;
},getLabel:function(item){
if(this._labelAttr&&this.isItem(item)){
return this.getValue(item,this._labelAttr);
}
return undefined;
},getLabelAttributes:function(item){
if(this._labelAttr){
return [this._labelAttr];
}
return null;
},filter:function(_1128,_1129,_112a){
var items=[],i,key;
if(_1128.query){
var value,_112b=_1128.queryOptions?_1128.queryOptions.ignoreCase:false;
var _112c={};
for(key in _1128.query){
value=_1128.query[key];
if(typeof value==="string"){
_112c[key]=_1114.patternToRegExp(value,_112b);
}else{
if(value instanceof RegExp){
_112c[key]=value;
}
}
}
for(i=0;i<_1129.length;++i){
var match=true;
var _112d=_1129[i];
if(_112d===null){
match=false;
}else{
for(key in _1128.query){
value=_1128.query[key];
if(!this._containsValue(_112d,key,value,_112c[key])){
match=false;
}
}
}
if(match){
items.push(_112d);
}
}
_112a(items,_1128);
}else{
for(i=0;i<_1129.length;++i){
var item=_1129[i];
if(item!==null){
items.push(item);
}
}
_112a(items,_1128);
}
},_fetchItems:function(_112e,_112f,_1130){
var self=this;
if(this._loadFinished){
this.filter(_112e,this._getItemsArray(_112e.queryOptions),_112f);
}else{
if(this._jsonFileUrl!==this._ccUrl){
_1111.deprecated(this.declaredClass+": ","To change the url, set the url property of the store,"+" not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");
this._ccUrl=this._jsonFileUrl;
this.url=this._jsonFileUrl;
}else{
if(this.url!==this._ccUrl){
this._jsonFileUrl=this.url;
this._ccUrl=this.url;
}
}
if(this.data!=null){
this._jsonData=this.data;
this.data=null;
}
if(this._jsonFileUrl){
if(this._loadInProgress){
this._queuedFetches.push({args:_112e,filter:lang.hitch(self,"filter"),findCallback:lang.hitch(self,_112f)});
}else{
this._loadInProgress=true;
var _1131={url:self._jsonFileUrl,handleAs:"json-comment-optional",preventCache:this.urlPreventCache,failOk:this.failOk};
var _1132=xhr.get(_1131);
_1132.addCallback(function(data){
try{
self._getItemsFromLoadedData(data);
self._loadFinished=true;
self._loadInProgress=false;
self.filter(_112e,self._getItemsArray(_112e.queryOptions),_112f);
self._handleQueuedFetches();
}
catch(e){
self._loadFinished=true;
self._loadInProgress=false;
_1130(e,_112e);
}
});
_1132.addErrback(function(error){
self._loadInProgress=false;
_1130(error,_112e);
});
var _1133=null;
if(_112e.abort){
_1133=_112e.abort;
}
_112e.abort=function(){
var df=_1132;
if(df&&df.fired===-1){
df.cancel();
df=null;
}
if(_1133){
_1133.call(_112e);
}
};
}
}else{
if(this._jsonData){
try{
this._loadFinished=true;
this._getItemsFromLoadedData(this._jsonData);
this._jsonData=null;
self.filter(_112e,this._getItemsArray(_112e.queryOptions),_112f);
}
catch(e){
_1130(e,_112e);
}
}else{
_1130(new Error(this.declaredClass+": No JSON source data was provided as either URL or a nested Javascript object."),_112e);
}
}
}
},_handleQueuedFetches:function(){
if(this._queuedFetches.length>0){
for(var i=0;i<this._queuedFetches.length;i++){
var fData=this._queuedFetches[i],_1134=fData.args,_1135=fData.filter,_1136=fData.findCallback;
if(_1135){
_1135(_1134,this._getItemsArray(_1134.queryOptions),_1136);
}else{
this.fetchItemByIdentity(_1134);
}
}
this._queuedFetches=[];
}
},_getItemsArray:function(_1137){
if(_1137&&_1137.deep){
return this._arrayOfAllItems;
}
return this._arrayOfTopLevelItems;
},close:function(_1138){
if(this.clearOnClose&&this._loadFinished&&!this._loadInProgress){
if(((this._jsonFileUrl==""||this._jsonFileUrl==null)&&(this.url==""||this.url==null))&&this.data==null){
}
this._arrayOfAllItems=[];
this._arrayOfTopLevelItems=[];
this._loadFinished=false;
this._itemsByIdentity=null;
this._loadInProgress=false;
this._queuedFetches=[];
}
},_getItemsFromLoadedData:function(_1139){
var _113a=false,self=this;
function _113b(_113c){
return (_113c!==null)&&(typeof _113c==="object")&&(!lang.isArray(_113c)||_113a)&&(!lang.isFunction(_113c))&&(_113c.constructor==Object||lang.isArray(_113c))&&(typeof _113c._reference==="undefined")&&(typeof _113c._type==="undefined")&&(typeof _113c._value==="undefined")&&self.hierarchical;
};
function _113d(_113e){
self._arrayOfAllItems.push(_113e);
for(var _113f in _113e){
var _1140=_113e[_113f];
if(_1140){
if(lang.isArray(_1140)){
var _1141=_1140;
for(var k=0;k<_1141.length;++k){
var _1142=_1141[k];
if(_113b(_1142)){
_113d(_1142);
}
}
}else{
if(_113b(_1140)){
_113d(_1140);
}
}
}
}
};
this._labelAttr=_1139.label;
var i,item;
this._arrayOfAllItems=[];
this._arrayOfTopLevelItems=_1139.items;
for(i=0;i<this._arrayOfTopLevelItems.length;++i){
item=this._arrayOfTopLevelItems[i];
if(lang.isArray(item)){
_113a=true;
}
_113d(item);
item[this._rootItemPropName]=true;
}
var _1143={},key;
for(i=0;i<this._arrayOfAllItems.length;++i){
item=this._arrayOfAllItems[i];
for(key in item){
if(key!==this._rootItemPropName){
var value=item[key];
if(value!==null){
if(!lang.isArray(value)){
item[key]=[value];
}
}else{
item[key]=[null];
}
}
_1143[key]=key;
}
}
while(_1143[this._storeRefPropName]){
this._storeRefPropName+="_";
}
while(_1143[this._itemNumPropName]){
this._itemNumPropName+="_";
}
while(_1143[this._reverseRefMap]){
this._reverseRefMap+="_";
}
var _1144;
var _1145=_1139.identifier;
if(_1145){
this._itemsByIdentity={};
this._features["dojo.data.api.Identity"]=_1145;
for(i=0;i<this._arrayOfAllItems.length;++i){
item=this._arrayOfAllItems[i];
_1144=item[_1145];
var _1146=_1144[0];
if(!Object.hasOwnProperty.call(this._itemsByIdentity,_1146)){
this._itemsByIdentity[_1146]=item;
}else{
if(this._jsonFileUrl){
throw new Error(this.declaredClass+":  The json data as specified by: ["+this._jsonFileUrl+"] is malformed.  Items within the list have identifier: ["+_1145+"].  Value collided: ["+_1146+"]");
}else{
if(this._jsonData){
throw new Error(this.declaredClass+":  The json data provided by the creation arguments is malformed.  Items within the list have identifier: ["+_1145+"].  Value collided: ["+_1146+"]");
}
}
}
}
}else{
this._features["dojo.data.api.Identity"]=Number;
}
for(i=0;i<this._arrayOfAllItems.length;++i){
item=this._arrayOfAllItems[i];
item[this._storeRefPropName]=this;
item[this._itemNumPropName]=i;
}
for(i=0;i<this._arrayOfAllItems.length;++i){
item=this._arrayOfAllItems[i];
for(key in item){
_1144=item[key];
for(var j=0;j<_1144.length;++j){
value=_1144[j];
if(value!==null&&typeof value=="object"){
if(("_type" in value)&&("_value" in value)){
var type=value._type;
var _1147=this._datatypeMap[type];
if(!_1147){
throw new Error("dojo.data.ItemFileReadStore: in the typeMap constructor arg, no object class was specified for the datatype '"+type+"'");
}else{
if(lang.isFunction(_1147)){
_1144[j]=new _1147(value._value);
}else{
if(lang.isFunction(_1147.deserialize)){
_1144[j]=_1147.deserialize(value._value);
}else{
throw new Error("dojo.data.ItemFileReadStore: Value provided in typeMap was neither a constructor, nor a an object with a deserialize function");
}
}
}
}
if(value._reference){
var _1148=value._reference;
if(!lang.isObject(_1148)){
_1144[j]=this._getItemByIdentity(_1148);
}else{
for(var k=0;k<this._arrayOfAllItems.length;++k){
var _1149=this._arrayOfAllItems[k],found=true;
for(var _114a in _1148){
if(_1149[_114a]!=_1148[_114a]){
found=false;
}
}
if(found){
_1144[j]=_1149;
}
}
}
if(this.referenceIntegrity){
var _114b=_1144[j];
if(this.isItem(_114b)){
this._addReferenceToMap(_114b,item,key);
}
}
}else{
if(this.isItem(value)){
if(this.referenceIntegrity){
this._addReferenceToMap(value,item,key);
}
}
}
}
}
}
}
},_addReferenceToMap:function(_114c,_114d,_114e){
},getIdentity:function(item){
var _114f=this._features["dojo.data.api.Identity"];
if(_114f===Number){
return item[this._itemNumPropName];
}else{
var _1150=item[_114f];
if(_1150){
return _1150[0];
}
}
return null;
},fetchItemByIdentity:function(_1151){
var item,scope;
if(!this._loadFinished){
var self=this;
if(this._jsonFileUrl!==this._ccUrl){
_1111.deprecated(this.declaredClass+": ","To change the url, set the url property of the store,"+" not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");
this._ccUrl=this._jsonFileUrl;
this.url=this._jsonFileUrl;
}else{
if(this.url!==this._ccUrl){
this._jsonFileUrl=this.url;
this._ccUrl=this.url;
}
}
if(this.data!=null&&this._jsonData==null){
this._jsonData=this.data;
this.data=null;
}
if(this._jsonFileUrl){
if(this._loadInProgress){
this._queuedFetches.push({args:_1151});
}else{
this._loadInProgress=true;
var _1152={url:self._jsonFileUrl,handleAs:"json-comment-optional",preventCache:this.urlPreventCache,failOk:this.failOk};
var _1153=xhr.get(_1152);
_1153.addCallback(function(data){
var scope=_1151.scope?_1151.scope:_1111.global;
try{
self._getItemsFromLoadedData(data);
self._loadFinished=true;
self._loadInProgress=false;
item=self._getItemByIdentity(_1151.identity);
if(_1151.onItem){
_1151.onItem.call(scope,item);
}
self._handleQueuedFetches();
}
catch(error){
self._loadInProgress=false;
if(_1151.onError){
_1151.onError.call(scope,error);
}
}
});
_1153.addErrback(function(error){
self._loadInProgress=false;
if(_1151.onError){
var scope=_1151.scope?_1151.scope:_1111.global;
_1151.onError.call(scope,error);
}
});
}
}else{
if(this._jsonData){
self._getItemsFromLoadedData(self._jsonData);
self._jsonData=null;
self._loadFinished=true;
item=self._getItemByIdentity(_1151.identity);
if(_1151.onItem){
scope=_1151.scope?_1151.scope:_1111.global;
_1151.onItem.call(scope,item);
}
}
}
}else{
item=this._getItemByIdentity(_1151.identity);
if(_1151.onItem){
scope=_1151.scope?_1151.scope:_1111.global;
_1151.onItem.call(scope,item);
}
}
},_getItemByIdentity:function(_1154){
var item=null;
if(this._itemsByIdentity){
if(Object.hasOwnProperty.call(this._itemsByIdentity,_1154)){
item=this._itemsByIdentity[_1154];
}
}else{
if(Object.hasOwnProperty.call(this._arrayOfAllItems,_1154)){
item=this._arrayOfAllItems[_1154];
}
}
if(item===undefined){
item=null;
}
return item;
},getIdentityAttributes:function(item){
var _1155=this._features["dojo.data.api.Identity"];
if(_1155===Number){
return null;
}else{
return [_1155];
}
},_forceLoad:function(){
var self=this;
if(this._jsonFileUrl!==this._ccUrl){
_1111.deprecated(this.declaredClass+": ","To change the url, set the url property of the store,"+" not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");
this._ccUrl=this._jsonFileUrl;
this.url=this._jsonFileUrl;
}else{
if(this.url!==this._ccUrl){
this._jsonFileUrl=this.url;
this._ccUrl=this.url;
}
}
if(this.data!=null){
this._jsonData=this.data;
this.data=null;
}
if(this._jsonFileUrl){
var _1156={url:this._jsonFileUrl,handleAs:"json-comment-optional",preventCache:this.urlPreventCache,failOk:this.failOk,sync:true};
var _1157=xhr.get(_1156);
_1157.addCallback(function(data){
try{
if(self._loadInProgress!==true&&!self._loadFinished){
self._getItemsFromLoadedData(data);
self._loadFinished=true;
}else{
if(self._loadInProgress){
throw new Error(this.declaredClass+":  Unable to perform a synchronous load, an async load is in progress.");
}
}
}
catch(e){
throw e;
}
});
_1157.addErrback(function(error){
throw error;
});
}else{
if(this._jsonData){
self._getItemsFromLoadedData(self._jsonData);
self._jsonData=null;
self._loadFinished=true;
}
}
}});
lang.extend(_1117,_1115);
return _1117;
});
},"dojo/dnd/Source":function(){
define(["../_base/array","../_base/connect","../_base/declare","../_base/kernel","../_base/lang","../dom-class","../dom-geometry","../mouse","../ready","../topic","./common","./Selector","./Manager"],function(array,_1158,_1159,_115a,lang,_115b,_115c,mouse,ready,topic,dnd,_115d,_115e){
if(!_115a.isAsync){
ready(0,function(){
var _115f=["dojo/dnd/AutoSource","dojo/dnd/Target"];
require(_115f);
});
}
var _1160=_1159("dojo.dnd.Source",_115d,{isSource:true,horizontal:false,copyOnly:false,selfCopy:false,selfAccept:true,skipForm:false,withHandles:false,autoSync:false,delay:0,accept:["text"],generateText:true,constructor:function(node,_1161){
lang.mixin(this,lang.mixin({},_1161));
var type=this.accept;
if(type.length){
this.accept={};
for(var i=0;i<type.length;++i){
this.accept[type[i]]=1;
}
}
this.isDragging=false;
this.mouseDown=false;
this.targetAnchor=null;
this.targetBox=null;
this.before=true;
this._lastX=0;
this._lastY=0;
this.sourceState="";
if(this.isSource){
_115b.add(this.node,"dojoDndSource");
}
this.targetState="";
if(this.accept){
_115b.add(this.node,"dojoDndTarget");
}
if(this.horizontal){
_115b.add(this.node,"dojoDndHorizontal");
}
this.topics=[topic.subscribe("/dnd/source/over",lang.hitch(this,"onDndSourceOver")),topic.subscribe("/dnd/start",lang.hitch(this,"onDndStart")),topic.subscribe("/dnd/drop",lang.hitch(this,"onDndDrop")),topic.subscribe("/dnd/cancel",lang.hitch(this,"onDndCancel"))];
},checkAcceptance:function(_1162,nodes){
if(this==_1162){
return !this.copyOnly||this.selfAccept;
}
for(var i=0;i<nodes.length;++i){
var type=_1162.getItem(nodes[i].id).type;
var flag=false;
for(var j=0;j<type.length;++j){
if(type[j] in this.accept){
flag=true;
break;
}
}
if(!flag){
return false;
}
}
return true;
},copyState:function(_1163,self){
if(_1163){
return true;
}
if(arguments.length<2){
self=this==_115e.manager().target;
}
if(self){
if(this.copyOnly){
return this.selfCopy;
}
}else{
return this.copyOnly;
}
return false;
},destroy:function(){
_1160.superclass.destroy.call(this);
array.forEach(this.topics,function(t){
t.remove();
});
this.targetAnchor=null;
},onMouseMove:function(e){
if(this.isDragging&&this.targetState=="Disabled"){
return;
}
_1160.superclass.onMouseMove.call(this,e);
var m=_115e.manager();
if(!this.isDragging){
if(this.mouseDown&&this.isSource&&(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay)){
var nodes=this.getSelectedNodes();
if(nodes.length){
m.startDrag(this,nodes,this.copyState(dnd.getCopyKeyState(e),true));
}
}
}
if(this.isDragging){
var _1164=false;
if(this.current){
if(!this.targetBox||this.targetAnchor!=this.current){
this.targetBox=_115c.position(this.current,true);
}
if(this.horizontal){
_1164=(e.pageX-this.targetBox.x<this.targetBox.w/2)==_115c.isBodyLtr(this.current.ownerDocument);
}else{
_1164=(e.pageY-this.targetBox.y)<(this.targetBox.h/2);
}
}
if(this.current!=this.targetAnchor||_1164!=this.before){
this._markTargetAnchor(_1164);
m.canDrop(!this.current||m.source!=this||!(this.current.id in this.selection));
}
}
},onMouseDown:function(e){
if(!this.mouseDown&&this._legalMouseDown(e)&&(!this.skipForm||!dnd.isFormElement(e))){
this.mouseDown=true;
this._lastX=e.pageX;
this._lastY=e.pageY;
_1160.superclass.onMouseDown.call(this,e);
}
},onMouseUp:function(e){
if(this.mouseDown){
this.mouseDown=false;
_1160.superclass.onMouseUp.call(this,e);
}
},onDndSourceOver:function(_1165){
if(this!==_1165){
this.mouseDown=false;
if(this.targetAnchor){
this._unmarkTargetAnchor();
}
}else{
if(this.isDragging){
var m=_115e.manager();
m.canDrop(this.targetState!="Disabled"&&(!this.current||m.source!=this||!(this.current.id in this.selection)));
}
}
},onDndStart:function(_1166,nodes,copy){
if(this.autoSync){
this.sync();
}
if(this.isSource){
this._changeState("Source",this==_1166?(copy?"Copied":"Moved"):"");
}
var _1167=this.accept&&this.checkAcceptance(_1166,nodes);
this._changeState("Target",_1167?"":"Disabled");
if(this==_1166){
_115e.manager().overSource(this);
}
this.isDragging=true;
},onDndDrop:function(_1168,nodes,copy,_1169){
if(this==_1169){
this.onDrop(_1168,nodes,copy);
}
this.onDndCancel();
},onDndCancel:function(){
if(this.targetAnchor){
this._unmarkTargetAnchor();
this.targetAnchor=null;
}
this.before=true;
this.isDragging=false;
this.mouseDown=false;
this._changeState("Source","");
this._changeState("Target","");
},onDrop:function(_116a,nodes,copy){
if(this!=_116a){
this.onDropExternal(_116a,nodes,copy);
}else{
this.onDropInternal(nodes,copy);
}
},onDropExternal:function(_116b,nodes,copy){
var _116c=this._normalizedCreator;
if(this.creator){
this._normalizedCreator=function(node,hint){
return _116c.call(this,_116b.getItem(node.id).data,hint);
};
}else{
if(copy){
this._normalizedCreator=function(node){
var t=_116b.getItem(node.id);
var n=node.cloneNode(true);
n.id=dnd.getUniqueId();
return {node:n,data:t.data,type:t.type};
};
}else{
this._normalizedCreator=function(node){
var t=_116b.getItem(node.id);
_116b.delItem(node.id);
return {node:node,data:t.data,type:t.type};
};
}
}
this.selectNone();
if(!copy&&!this.creator){
_116b.selectNone();
}
this.insertNodes(true,nodes,this.before,this.current);
if(!copy&&this.creator){
_116b.deleteSelectedNodes();
}
this._normalizedCreator=_116c;
},onDropInternal:function(nodes,copy){
var _116d=this._normalizedCreator;
if(this.current&&this.current.id in this.selection){
return;
}
if(copy){
if(this.creator){
this._normalizedCreator=function(node,hint){
return _116d.call(this,this.getItem(node.id).data,hint);
};
}else{
this._normalizedCreator=function(node){
var t=this.getItem(node.id);
var n=node.cloneNode(true);
n.id=dnd.getUniqueId();
return {node:n,data:t.data,type:t.type};
};
}
}else{
if(!this.current){
return;
}
this._normalizedCreator=function(node){
var t=this.getItem(node.id);
return {node:node,data:t.data,type:t.type};
};
}
this._removeSelection();
this.insertNodes(true,nodes,this.before,this.current);
this._normalizedCreator=_116d;
},onDraggingOver:function(){
},onDraggingOut:function(){
},onOverEvent:function(){
_1160.superclass.onOverEvent.call(this);
_115e.manager().overSource(this);
if(this.isDragging&&this.targetState!="Disabled"){
this.onDraggingOver();
}
},onOutEvent:function(){
_1160.superclass.onOutEvent.call(this);
_115e.manager().outSource(this);
if(this.isDragging&&this.targetState!="Disabled"){
this.onDraggingOut();
}
},_markTargetAnchor:function(_116e){
if(this.current==this.targetAnchor&&this.before==_116e){
return;
}
if(this.targetAnchor){
this._removeItemClass(this.targetAnchor,this.before?"Before":"After");
}
this.targetAnchor=this.current;
this.targetBox=null;
this.before=_116e;
if(this.targetAnchor){
this._addItemClass(this.targetAnchor,this.before?"Before":"After");
}
},_unmarkTargetAnchor:function(){
if(!this.targetAnchor){
return;
}
this._removeItemClass(this.targetAnchor,this.before?"Before":"After");
this.targetAnchor=null;
this.targetBox=null;
this.before=true;
},_markDndStatus:function(copy){
this._changeState("Source",copy?"Copied":"Moved");
},_legalMouseDown:function(e){
if(e.type!="touchstart"&&!mouse.isLeft(e)){
return false;
}
if(!this.withHandles){
return true;
}
for(var node=e.target;node&&node!==this.node;node=node.parentNode){
if(_115b.contains(node,"dojoDndHandle")){
return true;
}
if(_115b.contains(node,"dojoDndItem")||_115b.contains(node,"dojoDndIgnore")){
break;
}
}
return false;
}});
return _1160;
});
},"davinci/ve/tools/CreateTool":function(){
define(["dojo/_base/declare","dojo/dom-style","../tools/_Tool","davinci/Workbench","davinci/workbench/Preferences","../metadata","../widget","dojo/Deferred","dojo/promise/all","davinci/ve/States","davinci/commands/CompoundCommand","../commands/AddCommand","../commands/MoveCommand","../commands/ResizeCommand","../commands/StyleCommand"],function(_116f,_1170,_1171,_1172,_1173,_1174,_1175,_1176,all,_1177,_1178,_1179,_117a,_117b,_117c){
var _117d="The selected target is not a valid parent for the given widget.";
return _116f("davinci.ve.tools.CreateTool",_1171,{constructor:function(data){
this._data=data;
if(data&&data.type){
var _117e=_1174.queryDescriptor(data.type,"resizableOnCreate");
var _117f=_117e||_1174.queryDescriptor(data.type,"resizable");
if(_117f!=="none"){
this._resizable=_117f;
}
this._dropCursor=_1174.queryDescriptor(data.type,"dropCursor");
}
this._requireHelpers(data);
},activate:function(_1180){
this._context=_1180;
if(_1180&&_1180.rootNode){
this._oldCursor=_1180.rootNode.style.cursor;
}
_1180.rootNode.style.cursor="crosshair";
},deactivate:function(){
if(this._context&&this._context.rootNode){
this._context.rootNode.style.cursor=this._oldCursor;
}
this._setTarget(null);
delete this._mdPosition;
this._context.dragMoveCleanup();
},_getContentPosition:function(_1181){
if(!_1181){
return undefined;
}
if(_1181.target){
_1181={x:_1181.pageX,y:_1181.pageY};
}
return _1181;
},onMouseDown:function(event){
this._target=_1175.getEnclosingWidget(event.target);
this._mdPosition=this._getContentPosition(event);
this._dragRect=null;
},onMouseMove:function(event){
var _1182=this._context;
var cp=_1182._chooseParent;
if(event.target!=this._lastEventTarget){
cp.setProposedParentWidget(null);
}
this._lastEventTarget=event.target;
if(this._mdPosition){
if(this._resizable){
_1182.deselect();
var p=this._getContentPosition(event);
var l,t,w,h;
var pos_x=true;
var pos_y=true;
if(p.x>=this._mdPosition.x){
l=this._mdPosition.x;
w=p.x-this._mdPosition.x;
}else{
l=p.x;
w=this._mdPosition.x-p.x;
pos_x=false;
}
if(p.y>=this._mdPosition.y){
t=this._mdPosition.y;
h=p.y-this._mdPosition.y;
}else{
t=p.y;
h=this._mdPosition.y-p.y;
pos_y=false;
}
if(event.shiftKey){
if(w>=h){
h=w;
if(!pos_y){
t=this._mdPosition.y-h;
}
}else{
w=h;
if(!pos_x){
l=this._mdPosition.x-w;
}
}
}
if(!this._dragSizeRect){
var body=_1182.getDocument().body;
this._dragSizeRect=dojo.create("div",{style:"border:1px dashed black;z-index:1000001;position:absolute;"},body);
}
var style=this._dragSizeRect.style;
style.left=l+"px";
style.top=t+"px";
style.width=w+"px";
style.height=h+"px";
}
}else{
var _1183=!this.createWithFlowLayout();
this._setTarget(event.target,event);
var _1184=_1182.getPreference("showPossibleParents");
var _1185=(!_1184&&this._spaceKeyDown)||(_1184&&!this._spaceKeyDown);
var _1186={x:event.pageX,y:event.pageY};
var box={l:event.pageX,t:event.pageY,w:0,h:0};
var _1187=_1173.getPreferences("davinci.ve.editorPrefs",_1172.getProject());
var _1188=_1187.snap&&_1183;
var _1189=_1188;
var _118a=!_1183;
if(typeof this._dropCursor=="object"&&this._dropCursor.show===false){
_118a=false;
}
var _118b=this._dropCursor&&this._dropCursor.beforeAfter;
_1182.dragMoveUpdate({data:this._data,position:_1186,absolute:_1183,currentParent:null,eventTarget:event.target,rect:box,doSnapLinesX:_1188,doSnapLinesY:_1189,doFindParentsXY:_1185,doCursor:_118a,beforeAfter:_118b});
}
},onMouseUp:function(event){
var _118c=this._context;
var cp=_118c._chooseParent;
var _118d=!this.createWithFlowLayout();
if(this._dragSizeRect){
var _118e=this._dragSizeRect.parentNode;
_118e.removeChild(this._dragSizeRect);
this._dragSizeRect=null;
}
var _118f=_118c.getActiveDragDiv();
if(_118f){
var elems=dojo.query(".maqCandidateParents",_118f);
if(elems.length==1){
elems[0].innerHTML="";
}
}
this._lastEventTarget=null;
var size,_1190,w,h;
var p=this._getContentPosition(event);
if(this._mdPosition){
var pos_x=true;
var pos_y=true;
this._position=dojo.mixin({},this._mdPosition);
if(p.x<this._mdPosition.x){
this._position.x=p.x;
}
if(this._resizable=="height"){
w=0;
}else{
if(p.x-this._mdPosition.x>=0){
w=p.x-this._mdPosition.x;
}else{
w=this._mdPosition.x-p.x;
pos_x=false;
}
}
if(p.y<this._mdPosition.y){
this._position.y=p.y;
}
if(this._resizable=="width"){
h=0;
}else{
if(p.y-this._mdPosition.y>=0){
h=p.y-this._mdPosition.y;
}else{
h=this._mdPosition.y-p.y;
pos_y=false;
}
}
if(event.shiftKey){
if(w>=h){
h=w;
if(!pos_y){
t=this._mdPosition.y-h;
}
}else{
w=h;
if(!pos_x){
l=this._mdPosition.x-w;
}
}
}
}else{
this._position=p;
}
if(this._resizable&&this._position){
var w,h;
if(w>4||h>4){
size={w:(w>0?w:undefined),h:(h>0?h:undefined)};
}
}
var ppw=cp.getProposedParentWidget();
if(ppw){
_1190=ppw.parent;
if(ppw.refChild){
var _1191=ppw.parent.getChildren();
var idx=_1191.indexOf(ppw.refChild);
if(idx>=0){
if(ppw.refAfter){
idx++;
}
}else{
idx=null;
}
}
}else{
var _1192=this._getTarget()||_1175.getEnclosingWidget(event.target);
var data=this._data;
var _1193=cp.getAllowedTargetWidget(_1192,data,true,{absolute:_118d});
var _1194=dojo.isArray(data)?data[0].type:data.type;
var _1195=_1175.getWidgetHelper(_1194);
if(_1193.length>1&&_1195&&_1195.chooseParent){
_1190=_1195.chooseParent(_1193);
}else{
if(_1193.length>0){
if(_1193.indexOf(_1192)>=0){
_1190=_1192;
}else{
_1190=_1193[0];
}
}
}
}
cp.setProposedParentWidget(null);
var _1196=function(_1197){
this.prototype=Error.prototype;
this.name="InvalidTargetWidgetError";
this.message=_1197?_1197:_117d;
};
try{
var data=this._data instanceof Array?this._data:[this._data];
if(!_1190){
function _1198(type){
var _1199=_1174.queryDescriptor(type,"class");
if(_1199){
return _1199.split(/\s+/).push(type);
}
return [type];
};
var _119a=data.map(function(elem){
return elem.type;
}).join(", "),_119b=data.map(function(elem){
return {allowedParent:_1174.getAllowedParent(elem.type),classList:_1198(elem.type)};
});
var _119c=_117d;
if(_119b.length===1&&_119b[0].allowedParent){
_119c+=["The widget <span style=\"font-family: monospace\">",_119a,"</span> requires ",_119b[0].allowedParent.length>1?"one of the following parent types":"the parent type"," <span style=\"font-family: monospace\">",_119b[0].allowedParent.join(", "),"</span>."].join("");
var _1194=data[0].type;
var _1195=_1175.getWidgetHelper(_1194);
if(_1195&&_1195.isAllowedError){
_119c=_1195.isAllowedError({errorMsg:_119c,type:_1194,allowedParent:_119b[0].allowedParent,absolute:_118d});
}
}
throw new _1196(_119c);
}
for(var i=0;i<data.length;i++){
var type=data[i].type;
var _119d=_1174.getLibraryForType(type),libId=_119d.name,args=[type,_118c];
if(!_118c._widgets.hasOwnProperty(libId)){
_118c._widgets[libId]=0;
}
if(++_118c._widgets[libId]==1){
_1174.invokeCallback(_119d,"onFirstAdd",args);
}
_1174.invokeCallback(_119d,"onAdd",args);
}
this.create({target:_1190,index:idx,directTarget:this._getTarget(),size:size});
}
catch(e){
var _119e,title;
if(e instanceof _1196){
_119e=e.message;
title="Invalid Target";
}else{
_119e="The action was interrupted by an internal error.";
title="Error";
console.error(e);
}
_1172.showMessage(title,_119e);
}
finally{
if(this.exitCreateToolOnMouseUp()){
_118c.setActiveTool(null);
}
this._cleanupActions();
}
},_cleanupActions:function(){
var _119f=this._context;
_119f.dragMoveCleanup();
if(!_119f.inlineEditActive()){
var _11a0=this._context.getDocument();
_11a0.defaultView.focus();
}
},onKeyDown:function(event){
dojo.stopEvent(event);
var _11a1=this._context;
if(event.keyCode==dojo.keys.ESCAPE){
_11a1.setActiveTool(null);
this._cleanupActions();
return;
}
var _11a2=this._context.getPreference("showPossibleParents");
if(event.keyCode==dojo.keys.SPACE){
this._spaceKeyDown=true;
}else{
this._processKeyDown(event.keyCode);
}
var _11a3=(!_11a2&&this._spaceKeyDown)||(_11a2&&!this._spaceKeyDown);
var data=this._data;
var _11a4=dojo.isArray(data)?data[0].type:data.type;
var cp=_11a1._chooseParent;
var _11a5=!this.createWithFlowLayout();
var _11a6=!_11a5;
if(typeof this._dropCursor=="object"&&this._dropCursor.show===false){
_11a6=false;
}
var _11a7=this._dropCursor&&this._dropCursor.beforeAfter;
var _11a8=null;
cp.dragUpdateCandidateParents({widgetType:_11a4,showCandidateParents:_11a3,absolute:_11a5,doCursor:_11a6,beforeAfter:_11a7,currentParent:_11a8});
},_processKeyDown:function(_11a9){
if(_11a9>=49&&_11a9<=57){
var _11aa=this._context;
var cp=_11aa._chooseParent;
var _11ab=cp.getProposedParentsList();
if(_11ab&&_11ab.length>1){
var index=_11ab.length-(_11a9-48);
if(index>=0){
cp.setProposedParentWidget(_11ab[index]);
}
}
}
},onKeyUp:function(event){
if(event.keyCode==dojo.keys.SPACE){
this._spaceKeyDown=false;
}
dojo.stopEvent(event);
var _11ac=this._context.getPreference("showPossibleParents");
var _11ad=(!_11ac&&this._spaceKeyDown)||(_11ac&&!this._spaceKeyDown);
var data=this._data;
var _11ae=dojo.isArray(data)?data[0].type:data.type;
var _11af=this._context;
var cp=_11af._chooseParent;
var _11b0=!this.createWithFlowLayout();
var _11b1=!_11b0;
if(typeof this._dropCursor=="object"&&this._dropCursor.show===false){
_11b1=false;
}
var _11b2=this._dropCursor&&this._dropCursor.beforeAfter;
var _11b3=null;
cp.dragUpdateCandidateParents({widgetType:_11ae,showCandidateParents:_11ad,absolute:_11b0,doCursor:_11b1,beforeAfter:_11b2,currentParent:_11b3});
},_requireHelpers:function(data){
var _11b4=[];
if(!data||!data.type){
if(data instanceof Array){
data.forEach(function(d){
_11b4.concat(this._requireHelpers(d));
},this);
}
return _11b4;
}
_11b4.push(_1175.requireWidgetHelper(data.type));
if(data.children&&!dojo.isString(data.children)){
if(!dojo.every(data.children,function(c){
return _11b4.concat(this._requireHelpers(c));
},this)){
return _11b4;
}
}
return _11b4;
},create:function(args){
if(!args||!this._data){
return;
}
var _11b5=args.target,_11b6,child;
while(_11b5){
_11b6=_11b5.getContainerNode();
if(_11b6){
break;
}
child=_11b5;
_11b5=_11b5.getParent();
}
var index=args.index;
var _11b7;
var _11b8=false;
if(this._data.properties&&this._data.properties.style&&(this._data.properties.style.indexOf("absolute")>0)){
_11b8=true;
}
if(!_11b8&&this.createWithFlowLayout()){
if(child){
index=_11b5.indexOf(child);
}
}else{
if(args.position){
_11b7=args.position;
}else{
if(this._position){
_11b7=this._position;
}
}
}
this._data.context=this._context;
all(this._requireHelpers(this._data)).then(function(){
this._create({parent:_11b5,index:index,position:_11b7,size:args.size});
}.bind(this));
},_create:function(args){
var _11b9=this._context,_11ba=[],_11bb=new _1176();
if(!this._loadType(this._data,_11ba)){
_11bb.reject();
return _11bb;
}
all(_11ba).then(function(){
var w;
if(this.createNewWidget()){
dojo.withDoc(this._context.getDocument(),function(){
w=_1175.createWidget(this._data);
},this);
}else{
w=this._widget;
}
if(!w){
_11bb.reject(new Error("Failed to create widget"));
}
var _11bc=new _1178();
if(this.createNewWidget()){
args.size=this._getInitialSize(w,args);
_11bc.add(new _1179(w,args.parent||this._context.getContainerNode(),args.index));
if(args.position){
var _11bd=_11b9.getPreference("absoluteWidgetsZindex");
_11bc.add(new _117c(w,[{position:"absolute"},{"z-index":_11bd}]));
_11bc.add(new _117a(w,args.position.x,args.position.y));
}
if(args.size){
var width=args.size.w,_11be=args.size.h;
_11bc.add(new _117b(w,width,_11be));
var _11bf=_1175.getWidgetHelper(w.type);
if(_11bf&&_11bf.onCreateResize){
_11bf.onCreateResize(_11bc,w,width,_11be);
}
}
this.checkAddToCurrentState(_11bc,w);
}
var w_id=w.id;
if(this.addToCommandStack){
this.addToCommandStack(_11bc,{widget:w});
}
if(!_11bc.isEmpty()){
this._context.getCommandStack().execute(_11bc);
}
if(w.isLayoutContainer){
w.resize();
}
var w=_1175.byId(w_id);
this._select(w);
this._widget=w;
_11bb.resolve(w);
this.mouseUpProcessingCompleted();
}.bind(this));
return _11bb;
},_loadType:function(data,_11c0){
if(!data||!data.type){
return false;
}
_11c0.push(this._context.loadRequires(data.type,true));
if(data.children&&!dojo.isString(data.children)){
dojo.forEach(data.children,function(c){
this._loadType(c,_11c0);
}.bind(this));
}
return true;
},_getInitialSize:function(w,args){
var _11c1=args.size;
var _11c2=w.getHelper();
if(_11c2&&_11c2.initialSize){
var size=_11c2.initialSize(args);
if(size){
_11c1=size;
}
}
if(!_11c1){
var _11c3=_1174.queryDescriptor(w.type,"initialSize");
if(_11c3){
if(args&&!args.position){
var _11c4=args.parent;
if(_11c4.type=="html.body"){
if(_11c3=="auto"||_11c3.flow=="auto"){
_11c1={w:"100%",h:"auto"};
}else{
_11c1=this._getExplicitFlowSizeFromMetadata(_11c3);
}
}else{
if(this._isTypeContainer(_11c4.type)){
if(_11c3=="auto"||_11c3.flow=="auto"){
var _11c5=_11c4.getData().children;
_11c1={w:"100%",h:(_11c5&&_11c5.length)?"auto":"100%"};
}else{
_11c1=this._getExplicitFlowSizeFromMetadata(_11c3);
}
}else{
_11c1=this._getExplicitFlowSizeFromMetadata(_11c3);
}
}
}else{
if(_11c3=="auto"||_11c3.absolute=="auto"){
_11c1={w:"300px",h:"300px"};
}else{
_11c1=this._getExplicitAbsoluteSizeFromMetadata(_11c3);
}
}
}
}
return _11c1;
},_getExplicitFlowSizeFromMetadata:function(_11c6){
var _11c7=null;
if(_11c6.flow){
_11c7={w:_11c6.flow.width?_11c6.flow.width:"100%",h:_11c6.flow.height?_11c6.flow.height:"auto"};
}else{
_11c7={w:_11c6.width?_11c6.width:"100%",h:_11c6.height?_11c6.height:"auto"};
}
return _11c7;
},_getExplicitAbsoluteSizeFromMetadata:function(_11c8){
var _11c9=null;
if(_11c8.absolute){
_11c9={w:_11c8.absolute.width?_11c8.absolute.width:"300px",h:_11c8.absolute.height?_11c8.absolute.height:"300px",};
}else{
_11c9={w:_11c8.width?_11c8.width:"300px",h:_11c8.height?_11c8.height:"300px"};
}
return _11c9;
},_isTypeContainer:function(type){
return type&&(type=="dijit/layout/ContentPane"||type=="html.div"||type=="html.form"||type=="html.fieldset");
},_select:function(w){
_1174.getSmartInput(w.type).then(function(_11ca){
if(!this._data.fileDragCreate&&_11ca&&_11ca.displayOnCreate){
w.inLineEdit_displayOnCreate=_11ca.displayOnCreate;
this._context.select(w,null,true);
}else{
this._context.select(w);
}
}.bind(this));
},createWithFlowLayout:function(){
var _11cb=_1174.queryDescriptor(this._data.type,"forceAbsolute");
if(_11cb){
return false;
}else{
return this._context.getFlowLayout();
}
},createNewWidget:function(){
return true;
},exitCreateToolOnMouseUp:function(){
return true;
},mouseUpProcessingCompleted:function(){
},checkAddToCurrentState:function(_11cc,_11cd){
var _11ce=_11cd._edit_context;
var _11cf=_1177.getFocus(_11ce.rootNode);
if(_11cf&&_11cf.stateContainerNode){
var _11d0=_1177.getState(_11cf.stateContainerNode);
var _11d1=_1173.getPreferences("davinci.ve.editorPrefs",_1172.getProject());
if(_11d0&&_11d1.newWidgetsCurrentState){
var _11d2=_1170.get(_11cd.domNode,"display");
_11cc.add(new _117c(_11cd,[{display:"none"}]));
_11cc.add(new _117c(_11cd,[{display:_11d2}],_11d0));
}
}
}});
});
},"dojo/html":function(){
define(["./_base/kernel","./_base/lang","./_base/array","./_base/declare","./dom","./dom-construct","./parser"],function(_11d3,lang,_11d4,_11d5,dom,_11d6,_11d7){
var html={};
lang.setObject("dojo.html",html);
var _11d8=0;
html._secureForInnerHtml=function(cont){
return cont.replace(/(?:\s*<!DOCTYPE\s[^>]+>|<title[^>]*>[\s\S]*?<\/title>)/ig,"");
};
html._emptyNode=_11d6.empty;
html._setNodeContent=function(node,cont){
_11d6.empty(node);
if(cont){
if(typeof cont=="string"){
cont=_11d6.toDom(cont,node.ownerDocument);
}
if(!cont.nodeType&&lang.isArrayLike(cont)){
for(var _11d9=cont.length,i=0;i<cont.length;i=_11d9==cont.length?i+1:0){
_11d6.place(cont[i],node,"last");
}
}else{
_11d6.place(cont,node,"last");
}
}
return node;
};
html._ContentSetter=_11d5("dojo.html._ContentSetter",null,{node:"",content:"",id:"",cleanContent:false,extractContent:false,parseContent:false,parserScope:_11d3._scopeName,startup:true,constructor:function(_11da,node){
lang.mixin(this,_11da||{});
node=this.node=dom.byId(this.node||node);
if(!this.id){
this.id=["Setter",(node)?node.id||node.tagName:"",_11d8++].join("_");
}
},set:function(cont,_11db){
if(undefined!==cont){
this.content=cont;
}
if(_11db){
this._mixin(_11db);
}
this.onBegin();
this.setContent();
var ret=this.onEnd();
if(ret&&ret.then){
return ret;
}else{
return this.node;
}
},setContent:function(){
var node=this.node;
if(!node){
throw new Error(this.declaredClass+": setContent given no node");
}
try{
node=html._setNodeContent(node,this.content);
}
catch(e){
var _11dc=this.onContentError(e);
try{
node.innerHTML=_11dc;
}
catch(e){
console.error("Fatal "+this.declaredClass+".setContent could not change content due to "+e.message,e);
}
}
this.node=node;
},empty:function(){
if(this.parseDeferred){
if(!this.parseDeferred.isResolved()){
this.parseDeferred.cancel();
}
delete this.parseDeferred;
}
if(this.parseResults&&this.parseResults.length){
_11d4.forEach(this.parseResults,function(w){
if(w.destroy){
w.destroy();
}
});
delete this.parseResults;
}
_11d6.empty(this.node);
},onBegin:function(){
var cont=this.content;
if(lang.isString(cont)){
if(this.cleanContent){
cont=html._secureForInnerHtml(cont);
}
if(this.extractContent){
var match=cont.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
if(match){
cont=match[1];
}
}
}
this.empty();
this.content=cont;
return this.node;
},onEnd:function(){
if(this.parseContent){
this._parse();
}
return this.node;
},tearDown:function(){
delete this.parseResults;
delete this.parseDeferred;
delete this.node;
delete this.content;
},onContentError:function(err){
return "Error occurred setting content: "+err;
},onExecError:function(err){
return "Error occurred executing scripts: "+err;
},_mixin:function(_11dd){
var empty={},key;
for(key in _11dd){
if(key in empty){
continue;
}
this[key]=_11dd[key];
}
},_parse:function(){
var _11de=this.node;
try{
var _11df={};
_11d4.forEach(["dir","lang","textDir"],function(name){
if(this[name]){
_11df[name]=this[name];
}
},this);
var self=this;
this.parseDeferred=_11d7.parse({rootNode:_11de,noStart:!this.startup,inherited:_11df,scope:this.parserScope}).then(function(_11e0){
return self.parseResults=_11e0;
});
}
catch(e){
this._onError("Content",e,"Error parsing in _ContentSetter#"+this.id);
}
},_onError:function(type,err,_11e1){
var _11e2=this["on"+type+"Error"].call(this,err);
if(_11e1){
console.error(_11e1,err);
}else{
if(_11e2){
html._setNodeContent(this.node,_11e2,true);
}
}
}});
html.set=function(node,cont,_11e3){
if(undefined==cont){
console.warn("dojo.html.set: no cont argument provided, using empty string");
cont="";
}
if(!_11e3){
return html._setNodeContent(node,cont,true);
}else{
var op=new html._ContentSetter(lang.mixin(_11e3,{content:cont,node:node}));
return op.set();
}
};
return html;
});
},"dijit/form/ValidationTextBox":function(){
define(["dojo/_base/declare","dojo/_base/kernel","dojo/i18n","./TextBox","../Tooltip","dojo/text!./templates/ValidationTextBox.html","dojo/i18n!./nls/validate"],function(_11e4,_11e5,i18n,_11e6,_11e7,_11e8){
var _11e9;
return _11e9=_11e4("dijit.form.ValidationTextBox",_11e6,{templateString:_11e8,required:false,promptMessage:"",invalidMessage:"$_unset_$",missingMessage:"$_unset_$",message:"",constraints:{},pattern:".*",regExp:"",regExpGen:function(){
},state:"",tooltipPosition:[],_deprecateRegExp:function(attr,value){
if(value!=_11e9.prototype[attr]){
_11e5.deprecated("ValidationTextBox id="+this.id+", set('"+attr+"', ...) is deprecated.  Use set('pattern', ...) instead.","","2.0");
this.set("pattern",value);
}
},_setRegExpGenAttr:function(_11ea){
this._deprecateRegExp("regExpGen",_11ea);
this.regExpGen=this._getPatternAttr;
},_setRegExpAttr:function(value){
this._deprecateRegExp("regExp",value);
},_setValueAttr:function(){
this.inherited(arguments);
this.validate(this.focused);
},validator:function(value,_11eb){
return (new RegExp("^(?:"+this._getPatternAttr(_11eb)+")"+(this.required?"":"?")+"$")).test(value)&&(!this.required||!this._isEmpty(value))&&(this._isEmpty(value)||this.parse(value,_11eb)!==undefined);
},_isValidSubset:function(){
return this.textbox.value.search(this._partialre)==0;
},isValid:function(){
return this.validator(this.textbox.value,this.constraints);
},_isEmpty:function(value){
return (this.trim?/^\s*$/:/^$/).test(value);
},getErrorMessage:function(){
var _11ec=this.invalidMessage=="$_unset_$"?this.messages.invalidMessage:!this.invalidMessage?this.promptMessage:this.invalidMessage;
var _11ed=this.missingMessage=="$_unset_$"?this.messages.missingMessage:!this.missingMessage?_11ec:this.missingMessage;
return (this.required&&this._isEmpty(this.textbox.value))?_11ed:_11ec;
},getPromptMessage:function(){
return this.promptMessage;
},_maskValidSubsetError:true,validate:function(_11ee){
var _11ef="";
var _11f0=this.disabled||this.isValid(_11ee);
if(_11f0){
this._maskValidSubsetError=true;
}
var _11f1=this._isEmpty(this.textbox.value);
var _11f2=!_11f0&&_11ee&&this._isValidSubset();
this._set("state",_11f0?"":(((((!this._hasBeenBlurred||_11ee)&&_11f1)||_11f2)&&(this._maskValidSubsetError||(_11f2&&!this._hasBeenBlurred&&_11ee)))?"Incomplete":"Error"));
this.focusNode.setAttribute("aria-invalid",_11f0?"false":"true");
if(this.state=="Error"){
this._maskValidSubsetError=_11ee&&_11f2;
_11ef=this.getErrorMessage(_11ee);
}else{
if(this.state=="Incomplete"){
_11ef=this.getPromptMessage(_11ee);
this._maskValidSubsetError=!this._hasBeenBlurred||_11ee;
}else{
if(_11f1){
_11ef=this.getPromptMessage(_11ee);
}
}
}
this.set("message",_11ef);
return _11f0;
},displayMessage:function(_11f3){
if(_11f3&&this.focused){
_11e7.show(_11f3,this.domNode,this.tooltipPosition,!this.isLeftToRight());
}else{
_11e7.hide(this.domNode);
}
},_refreshState:function(){
if(this._created){
this.validate(this.focused);
}
this.inherited(arguments);
},constructor:function(_11f4){
this.constraints={};
this.baseClass+=" dijitValidationTextBox";
},startup:function(){
this.inherited(arguments);
this._refreshState();
},_setConstraintsAttr:function(_11f5){
if(!_11f5.locale&&this.lang){
_11f5.locale=this.lang;
}
this._set("constraints",_11f5);
this._refreshState();
},_setPatternAttr:function(_11f6){
this._set("pattern",_11f6);
},_getPatternAttr:function(_11f7){
var p=this.pattern;
var type=(typeof p).toLowerCase();
if(type=="function"){
p=this.pattern(_11f7||this.constraints);
}
if(p!=this._lastRegExp){
var _11f8="";
this._lastRegExp=p;
if(p!=".*"){
p.replace(/\\.|\[\]|\[.*?[^\\]{1}\]|\{.*?\}|\(\?[=:!]|./g,function(re){
switch(re.charAt(0)){
case "{":
case "+":
case "?":
case "*":
case "^":
case "$":
case "|":
case "(":
_11f8+=re;
break;
case ")":
_11f8+="|$)";
break;
default:
_11f8+="(?:"+re+"|$)";
break;
}
});
}
try{
"".search(_11f8);
}
catch(e){
_11f8=this.pattern;
console.warn("RegExp error in "+this.declaredClass+": "+this.pattern);
}
this._partialre="^(?:"+_11f8+")$";
}
return p;
},postMixInProperties:function(){
this.inherited(arguments);
this.messages=i18n.getLocalization("dijit.form","validate",this.lang);
this._setConstraintsAttr(this.constraints);
},_setDisabledAttr:function(value){
this.inherited(arguments);
this._refreshState();
},_setRequiredAttr:function(value){
this._set("required",value);
this.focusNode.setAttribute("aria-required",value);
this._refreshState();
},_setMessageAttr:function(_11f9){
this._set("message",_11f9);
this.displayMessage(_11f9);
},reset:function(){
this._maskValidSubsetError=true;
this.inherited(arguments);
},_onBlur:function(){
this.displayMessage("");
this.inherited(arguments);
}});
});
},"dijit/layout/BorderContainer":function(){
define(["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/on","dojo/touch","../_WidgetBase","../_Widget","../_TemplatedMixin","./_LayoutWidget","./utils"],function(array,_11fa,_11fb,_11fc,_11fd,_11fe,_11ff,event,keys,lang,on,touch,_1200,_1201,_1202,_1203,_1204){
var _1205=_11fb("dijit.layout._Splitter",[_1201,_1202],{live:true,templateString:"<div class=\"dijitSplitter\" data-dojo-attach-event=\"onkeypress:_onKeyPress,press:_startDrag,onmouseenter:_onMouse,onmouseleave:_onMouse\" tabIndex=\"0\" role=\"separator\"><div class=\"dijitSplitterThumb\"></div></div>",constructor:function(){
this._handlers=[];
},postMixInProperties:function(){
this.inherited(arguments);
this.horizontal=/top|bottom/.test(this.region);
this._factor=/top|left/.test(this.region)?1:-1;
this._cookieName=this.container.id+"_"+this.region;
},buildRendering:function(){
this.inherited(arguments);
_11fc.add(this.domNode,"dijitSplitter"+(this.horizontal?"H":"V"));
if(this.container.persist){
var _1206=_11fa(this._cookieName);
if(_1206){
this.child.domNode.style[this.horizontal?"height":"width"]=_1206;
}
}
},_computeMaxSize:function(){
var dim=this.horizontal?"h":"w",_1207=_11fe.getMarginBox(this.child.domNode)[dim],_1208=array.filter(this.container.getChildren(),function(child){
return child.region=="center";
})[0],_1209=_11fe.getMarginBox(_1208.domNode)[dim];
return Math.min(this.child.maxSize,_1207+_1209);
},_startDrag:function(e){
if(!this.cover){
this.cover=_11fd.place("<div class=dijitSplitterCover></div>",this.child.domNode,"after");
}
_11fc.add(this.cover,"dijitSplitterCoverActive");
if(this.fake){
_11fd.destroy(this.fake);
}
if(!(this._resize=this.live)){
(this.fake=this.domNode.cloneNode(true)).removeAttribute("id");
_11fc.add(this.domNode,"dijitSplitterShadow");
_11fd.place(this.fake,this.domNode,"after");
}
_11fc.add(this.domNode,"dijitSplitterActive dijitSplitter"+(this.horizontal?"H":"V")+"Active");
if(this.fake){
_11fc.remove(this.fake,"dijitSplitterHover dijitSplitter"+(this.horizontal?"H":"V")+"Hover");
}
var _120a=this._factor,_120b=this.horizontal,axis=_120b?"pageY":"pageX",_120c=e[axis],_120d=this.domNode.style,dim=_120b?"h":"w",_120e=_11fe.getMarginBox(this.child.domNode)[dim],max=this._computeMaxSize(),min=this.child.minSize||20,_120f=this.region,_1210=_120f=="top"||_120f=="bottom"?"top":"left",_1211=parseInt(_120d[_1210],10),_1212=this._resize,_1213=lang.hitch(this.container,"_layoutChildren",this.child.id),de=this.ownerDocument;
this._handlers=this._handlers.concat([on(de,touch.move,this._drag=function(e,_1214){
var delta=e[axis]-_120c,_1215=_120a*delta+_120e,_1216=Math.max(Math.min(_1215,max),min);
if(_1212||_1214){
_1213(_1216);
}
_120d[_1210]=delta+_1211+_120a*(_1216-_1215)+"px";
}),on(de,"dragstart",event.stop),on(this.ownerDocumentBody,"selectstart",event.stop),on(de,touch.release,lang.hitch(this,"_stopDrag"))]);
event.stop(e);
},_onMouse:function(e){
var o=(e.type=="mouseover"||e.type=="mouseenter");
_11fc.toggle(this.domNode,"dijitSplitterHover",o);
_11fc.toggle(this.domNode,"dijitSplitter"+(this.horizontal?"H":"V")+"Hover",o);
},_stopDrag:function(e){
try{
if(this.cover){
_11fc.remove(this.cover,"dijitSplitterCoverActive");
}
if(this.fake){
_11fd.destroy(this.fake);
}
_11fc.remove(this.domNode,"dijitSplitterActive dijitSplitter"+(this.horizontal?"H":"V")+"Active dijitSplitterShadow");
this._drag(e);
this._drag(e,true);
}
finally{
this._cleanupHandlers();
delete this._drag;
}
if(this.container.persist){
_11fa(this._cookieName,this.child.domNode.style[this.horizontal?"height":"width"],{expires:365});
}
},_cleanupHandlers:function(){
var h;
while(h=this._handlers.pop()){
h.remove();
}
},_onKeyPress:function(e){
this._resize=true;
var _1217=this.horizontal;
var tick=1;
switch(e.charOrCode){
case _1217?keys.UP_ARROW:keys.LEFT_ARROW:
tick*=-1;
case _1217?keys.DOWN_ARROW:keys.RIGHT_ARROW:
break;
default:
return;
}
var _1218=_11fe.getMarginSize(this.child.domNode)[_1217?"h":"w"]+this._factor*tick;
this.container._layoutChildren(this.child.id,Math.max(Math.min(_1218,this._computeMaxSize()),this.child.minSize));
event.stop(e);
},destroy:function(){
this._cleanupHandlers();
delete this.child;
delete this.container;
delete this.cover;
delete this.fake;
this.inherited(arguments);
}});
var _1219=_11fb("dijit.layout._Gutter",[_1201,_1202],{templateString:"<div class=\"dijitGutter\" role=\"presentation\"></div>",postMixInProperties:function(){
this.inherited(arguments);
this.horizontal=/top|bottom/.test(this.region);
},buildRendering:function(){
this.inherited(arguments);
_11fc.add(this.domNode,"dijitGutter"+(this.horizontal?"H":"V"));
}});
var _121a=_11fb("dijit.layout.BorderContainer",_1203,{design:"headline",gutters:true,liveSplitters:true,persist:false,baseClass:"dijitBorderContainer",_splitterClass:_1205,postMixInProperties:function(){
if(!this.gutters){
this.baseClass+="NoGutter";
}
this.inherited(arguments);
},startup:function(){
if(this._started){
return;
}
array.forEach(this.getChildren(),this._setupChild,this);
this.inherited(arguments);
},_setupChild:function(child){
var _121b=child.region;
if(_121b){
this.inherited(arguments);
_11fc.add(child.domNode,this.baseClass+"Pane");
var ltr=this.isLeftToRight();
if(_121b=="leading"){
_121b=ltr?"left":"right";
}
if(_121b=="trailing"){
_121b=ltr?"right":"left";
}
if(_121b!="center"&&(child.splitter||this.gutters)&&!child._splitterWidget){
var _121c=child.splitter?this._splitterClass:_1219;
if(lang.isString(_121c)){
_121c=lang.getObject(_121c);
}
var _121d=new _121c({id:child.id+"_splitter",container:this,child:child,region:_121b,live:this.liveSplitters});
_121d.isSplitter=true;
child._splitterWidget=_121d;
_11fd.place(_121d.domNode,child.domNode,"after");
_121d.startup();
}
child.region=_121b;
}
},layout:function(){
this._layoutChildren();
},addChild:function(child,_121e){
this.inherited(arguments);
if(this._started){
this.layout();
}
},removeChild:function(child){
var _121f=child.region;
var _1220=child._splitterWidget;
if(_1220){
_1220.destroy();
delete child._splitterWidget;
}
this.inherited(arguments);
if(this._started){
this._layoutChildren();
}
_11fc.remove(child.domNode,this.baseClass+"Pane");
_11ff.set(child.domNode,{top:"auto",bottom:"auto",left:"auto",right:"auto",position:"static"});
_11ff.set(child.domNode,_121f=="top"||_121f=="bottom"?"width":"height","auto");
},getChildren:function(){
return array.filter(this.inherited(arguments),function(_1221){
return !_1221.isSplitter;
});
},getSplitter:function(_1222){
return array.filter(this.getChildren(),function(child){
return child.region==_1222;
})[0]._splitterWidget;
},resize:function(_1223,_1224){
if(!this.cs||!this.pe){
var node=this.domNode;
this.cs=_11ff.getComputedStyle(node);
this.pe=_11fe.getPadExtents(node,this.cs);
this.pe.r=_11ff.toPixelValue(node,this.cs.paddingRight);
this.pe.b=_11ff.toPixelValue(node,this.cs.paddingBottom);
_11ff.set(node,"padding","0px");
}
this.inherited(arguments);
},_layoutChildren:function(_1225,_1226){
if(!this._borderBox||!this._borderBox.h){
return;
}
var _1227=array.map(this.getChildren(),function(child,idx){
return {pane:child,weight:[child.region=="center"?Infinity:0,child.layoutPriority,(this.design=="sidebar"?1:-1)*(/top|bottom/.test(child.region)?1:-1),idx]};
},this);
_1227.sort(function(a,b){
var aw=a.weight,bw=b.weight;
for(var i=0;i<aw.length;i++){
if(aw[i]!=bw[i]){
return aw[i]-bw[i];
}
}
return 0;
});
var _1228=[];
array.forEach(_1227,function(_1229){
var pane=_1229.pane;
_1228.push(pane);
if(pane._splitterWidget){
_1228.push(pane._splitterWidget);
}
});
var dim={l:this.pe.l,t:this.pe.t,w:this._borderBox.w-this.pe.w,h:this._borderBox.h-this.pe.h};
_1204.layoutChildren(this.domNode,dim,_1228,_1225,_1226);
},destroyRecursive:function(){
array.forEach(this.getChildren(),function(child){
var _122a=child._splitterWidget;
if(_122a){
_122a.destroy();
}
delete child._splitterWidget;
});
this.inherited(arguments);
}});
_121a.ChildWidgetProperties={region:"",layoutPriority:0,splitter:false,minSize:0,maxSize:Infinity};
lang.extend(_1200,_121a.ChildWidgetProperties);
_121a._Splitter=_1205;
_121a._Gutter=_1219;
return _121a;
});
},"davinci/html/HTMLFile":function(){
define(["dojo/_base/declare","davinci/html/HTMLItem","davinci/html/HTMLParser","davinci/html/CSSSelector","davinci/html/HTMLElement","davinci/html/CSSImport","davinci/html/CSSFile","davinci/model/Model","davinci/model/Path"],function(_122b,_122c,_122d,_122e,_122f,_1230,_1231,Model,Path){
return _122b("davinci.html.HTMLFile",_122c,{constructor:function(_1232){
this.fileName=_1232;
this.url=_1232;
this.elementType="HTMLFile";
this._loadedCSS={};
this._styleElem=null;
},save:function(_1233){
var _1234;
var file=system.resource.findResource(this.fileName);
if(file){
var text=this.getText();
_1234=file.setContents(text,_1233);
}
return _1234;
},getText:function(_1235){
_1235=_1235||{};
_1235.indent=0;
var s="";
for(var i=0;i<this.children.length;i++){
var child=this.children[i];
s=s+child.getText(_1235);
if(child.elementType=="HTMLComment"){
s=s+this._addWS(child._fmLine,child._fmIndent);
}
}
return s;
},getDocumentElement:function(_1236){
for(var i=0;i<this.children.length;i++){
if(this.children[i].tag=="html"){
return this.children[i];
}
}
},findElement:function(id){
var _1237=this.getDocumentElement();
if(_1237){
return _1237.findElement(id);
}
},getMatchingRules:function(_1238,_1239){
var _123a={visit:function(node){
if(node.elementType=="CSSFile"){
var m=[];
var _123b=node.getMatchingRules(_1238,[],m);
for(var i=0;i<_123b.length;i++){
for(var j=0;j<this.matchLevels.length;j++){
if(m[i]>this.matchLevels[j]){
this.matchLevels.splice(j,0,m[i]);
this.rules.splice(j,0,_123b[i]);
break;
}
}
}
if(this.rules.length==0){
this.rules=_123b;
this.matchLevels=m;
}
return true;
}
return false;
},matchLevels:[],rules:[]};
this.visit(_123a);
if(_1239){
return {"rules":_123a.rules,"matchLevels":_123a.matchLevels};
}else{
return _123a.rules;
}
},getRule:function(_123c){
if(!_123c){
return [];
}
var _123d=_122e.parseSelectors(_123c);
var _123e={visit:function(node){
if(node.elementType=="CSSFile"){
var _123f=node.getRule(_123d);
this.rules=this.rules.concat(_123f||[]);
return true;
}
return false;
},rules:[]};
this.visit(_123e);
return _123e.rules;
},setText:function(text,_1240){
this.visit({visit:function(node){
if(node.elementType=="CSSImport"){
node.close();
}
}});
this.children=[];
this._styleElem=null;
var _1241=_122d.parse(text||"",this);
var _1242="";
if(!_1240&&_1241.errors.length==0){
_1242=this.getText();
this.children=[];
_1241=_122d.parse(_1242,this);
}
this.endOffset=_1241.endOffset;
this.errors=_1241.errors;
var _1243=this;
if(!_1240){
this.visit({visit:function(node){
if(node.elementType=="CSSImport"){
if(!node.cssFile){
node.load(true);
dojo.connect(node.cssFile,"onChange",null,dojo.hitch(_1243,"onChange"));
}
}
}});
}
this.onChange();
},hasStyleSheet:function(url){
var _1244=this.find({elementType:"CSSImport"});
for(var i=0;i<_1244.length;i++){
if(_1244[i].url==url){
return true;
}
}
return false;
},addStyleSheet:function(url,_1245,_1246,_1247,_1248){
var path=new Path(this.url||this.fileName);
path=path.getParentPath().append(url);
var _1249=path.toString();
if(!_1246){
this._loadedCSS[_1249]=require("davinci/model/Factory").getModel({url:_1249,includeImports:true,loader:_1248});
}
if(_1245){
this._loadedCSS[_1249].setText(_1245);
}
this.onChange();
if(!this._styleElem){
var head=this.find({"elementType":"HTMLElement","tag":"head"},true);
var style=head.getChildElement("style");
if(!style){
style=new _122f("style");
head.addChild(style);
}
this._styleElem=style;
}
var css=new _1230();
css.parent=this;
css.url=url;
if(_1247){
this._styleElem.insertBefore(css,_1247);
}else{
this._styleElem.addChild(css);
}
if(!_1246){
css.load(true);
}
},close:function(){
this.visit({visit:function(node){
if(node.elementType=="CSSImport"){
node.close();
}
}});
require("davinci/model/Factory").closeModel(this);
},getLabel:function(){
return "<>";
},getID:function(){
return this.fileName;
},updatePositions:function(_124a,delta){
new Model(this).updatePositions(this,_124a,delta);
this.visit({visit:function(_124b){
if(_124b.endOffset<_124a){
return true;
}
if(_124b.elementType=="HTMLElement"&&_124b.startTagOffset>_124a){
_124b.startTagOffset+=delta;
}
}});
},mapPositions:function(_124c){
var s=this.getText();
var et=_124c.getText();
var start=s.indexOf(et);
var end=start+et.lastIndexOf(">")+1;
return {startOffset:start,endOffset:end};
},reportPositions:function(){
this.visit({visit:function(_124d){
if(_124d.elementType=="HTMLElement"){
}else{
if(_124d.elementType=="HTMLAttribute"){
}
}
}});
},evaluate:function(xpath){
if(xpath.charAt(0)!=="/"){
console.error("invalid XPath string");
return;
}
var elem=this;
xpath.substr(1).split("/").forEach(function(path){
var m=path.match(this._RE_XPATH),tag=m[1],idx=m[2],elems;
elems=elem.children.filter(function(child){
return child.tag===tag;
});
if(!idx&&elems.length>1){
console.error("invalid XPath string; no index specified for multiple elements");
return;
}
elem=idx?elems[idx-1]:elems[0];
},this);
return elem;
},_RE_XPATH:/(\w+)(?:\[(\d+)\])?/});
});
},"dojo/number":function(){
define(["./_base/lang","./i18n","./i18n!./cldr/nls/number","./string","./regexp"],function(lang,i18n,_124e,_124f,_1250){
var _1251={};
lang.setObject("dojo.number",_1251);
_1251.format=function(value,_1252){
_1252=lang.mixin({},_1252||{});
var _1253=i18n.normalizeLocale(_1252.locale),_1254=i18n.getLocalization("dojo.cldr","number",_1253);
_1252.customs=_1254;
var _1255=_1252.pattern||_1254[(_1252.type||"decimal")+"Format"];
if(isNaN(value)||Math.abs(value)==Infinity){
return null;
}
return _1251._applyPattern(value,_1255,_1252);
};
_1251._numberPatternRE=/[#0,]*[#0](?:\.0*#*)?/;
_1251._applyPattern=function(value,_1256,_1257){
_1257=_1257||{};
var group=_1257.customs.group,_1258=_1257.customs.decimal,_1259=_1256.split(";"),_125a=_1259[0];
_1256=_1259[(value<0)?1:0]||("-"+_125a);
if(_1256.indexOf("%")!=-1){
value*=100;
}else{
if(_1256.indexOf("‰")!=-1){
value*=1000;
}else{
if(_1256.indexOf("¤")!=-1){
group=_1257.customs.currencyGroup||group;
_1258=_1257.customs.currencyDecimal||_1258;
_1256=_1256.replace(/\u00a4{1,3}/,function(match){
var prop=["symbol","currency","displayName"][match.length-1];
return _1257[prop]||_1257.currency||"";
});
}else{
if(_1256.indexOf("E")!=-1){
throw new Error("exponential notation not supported");
}
}
}
}
var _125b=_1251._numberPatternRE;
var _125c=_125a.match(_125b);
if(!_125c){
throw new Error("unable to find a number expression in pattern: "+_1256);
}
if(_1257.fractional===false){
_1257.places=0;
}
return _1256.replace(_125b,_1251._formatAbsolute(value,_125c[0],{decimal:_1258,group:group,places:_1257.places,round:_1257.round}));
};
_1251.round=function(value,_125d,_125e){
var _125f=10/(_125e||10);
return (_125f*+value).toFixed(_125d)/_125f;
};
if((0.9).toFixed()==0){
var round=_1251.round;
_1251.round=function(v,p,m){
var d=Math.pow(10,-p||0),a=Math.abs(v);
if(!v||a>=d){
d=0;
}else{
a/=d;
if(a<0.5||a>=0.95){
d=0;
}
}
return round(v,p,m)+(v>0?d:-d);
};
}
_1251._formatAbsolute=function(value,_1260,_1261){
_1261=_1261||{};
if(_1261.places===true){
_1261.places=0;
}
if(_1261.places===Infinity){
_1261.places=6;
}
var _1262=_1260.split("."),comma=typeof _1261.places=="string"&&_1261.places.indexOf(","),_1263=_1261.places;
if(comma){
_1263=_1261.places.substring(comma+1);
}else{
if(!(_1263>=0)){
_1263=(_1262[1]||[]).length;
}
}
if(!(_1261.round<0)){
value=_1251.round(value,_1263,_1261.round);
}
var _1264=String(Math.abs(value)).split("."),_1265=_1264[1]||"";
if(_1262[1]||_1261.places){
if(comma){
_1261.places=_1261.places.substring(0,comma);
}
var pad=_1261.places!==undefined?_1261.places:(_1262[1]&&_1262[1].lastIndexOf("0")+1);
if(pad>_1265.length){
_1264[1]=_124f.pad(_1265,pad,"0",true);
}
if(_1263<_1265.length){
_1264[1]=_1265.substr(0,_1263);
}
}else{
if(_1264[1]){
_1264.pop();
}
}
var _1266=_1262[0].replace(",","");
pad=_1266.indexOf("0");
if(pad!=-1){
pad=_1266.length-pad;
if(pad>_1264[0].length){
_1264[0]=_124f.pad(_1264[0],pad);
}
if(_1266.indexOf("#")==-1){
_1264[0]=_1264[0].substr(_1264[0].length-pad);
}
}
var index=_1262[0].lastIndexOf(","),_1267,_1268;
if(index!=-1){
_1267=_1262[0].length-index-1;
var _1269=_1262[0].substr(0,index);
index=_1269.lastIndexOf(",");
if(index!=-1){
_1268=_1269.length-index-1;
}
}
var _126a=[];
for(var whole=_1264[0];whole;){
var off=whole.length-_1267;
_126a.push((off>0)?whole.substr(off):whole);
whole=(off>0)?whole.slice(0,off):"";
if(_1268){
_1267=_1268;
delete _1268;
}
}
_1264[0]=_126a.reverse().join(_1261.group||",");
return _1264.join(_1261.decimal||".");
};
_1251.regexp=function(_126b){
return _1251._parseInfo(_126b).regexp;
};
_1251._parseInfo=function(_126c){
_126c=_126c||{};
var _126d=i18n.normalizeLocale(_126c.locale),_126e=i18n.getLocalization("dojo.cldr","number",_126d),_126f=_126c.pattern||_126e[(_126c.type||"decimal")+"Format"],group=_126e.group,_1270=_126e.decimal,_1271=1;
if(_126f.indexOf("%")!=-1){
_1271/=100;
}else{
if(_126f.indexOf("‰")!=-1){
_1271/=1000;
}else{
var _1272=_126f.indexOf("¤")!=-1;
if(_1272){
group=_126e.currencyGroup||group;
_1270=_126e.currencyDecimal||_1270;
}
}
}
var _1273=_126f.split(";");
if(_1273.length==1){
_1273.push("-"+_1273[0]);
}
var re=_1250.buildGroupRE(_1273,function(_1274){
_1274="(?:"+_1250.escapeString(_1274,".")+")";
return _1274.replace(_1251._numberPatternRE,function(_1275){
var flags={signed:false,separator:_126c.strict?group:[group,""],fractional:_126c.fractional,decimal:_1270,exponent:false},parts=_1275.split("."),_1276=_126c.places;
if(parts.length==1&&_1271!=1){
parts[1]="###";
}
if(parts.length==1||_1276===0){
flags.fractional=false;
}else{
if(_1276===undefined){
_1276=_126c.pattern?parts[1].lastIndexOf("0")+1:Infinity;
}
if(_1276&&_126c.fractional==undefined){
flags.fractional=true;
}
if(!_126c.places&&(_1276<parts[1].length)){
_1276+=","+parts[1].length;
}
flags.places=_1276;
}
var _1277=parts[0].split(",");
if(_1277.length>1){
flags.groupSize=_1277.pop().length;
if(_1277.length>1){
flags.groupSize2=_1277.pop().length;
}
}
return "("+_1251._realNumberRegexp(flags)+")";
});
},true);
if(_1272){
re=re.replace(/([\s\xa0]*)(\u00a4{1,3})([\s\xa0]*)/g,function(match,_1278,_1279,after){
var prop=["symbol","currency","displayName"][_1279.length-1],_127a=_1250.escapeString(_126c[prop]||_126c.currency||"");
_1278=_1278?"[\\s\\xa0]":"";
after=after?"[\\s\\xa0]":"";
if(!_126c.strict){
if(_1278){
_1278+="*";
}
if(after){
after+="*";
}
return "(?:"+_1278+_127a+after+")?";
}
return _1278+_127a+after;
});
}
return {regexp:re.replace(/[\xa0 ]/g,"[\\s\\xa0]"),group:group,decimal:_1270,factor:_1271};
};
_1251.parse=function(_127b,_127c){
var info=_1251._parseInfo(_127c),_127d=(new RegExp("^"+info.regexp+"$")).exec(_127b);
if(!_127d){
return NaN;
}
var _127e=_127d[1];
if(!_127d[1]){
if(!_127d[2]){
return NaN;
}
_127e=_127d[2];
info.factor*=-1;
}
_127e=_127e.replace(new RegExp("["+info.group+"\\s\\xa0"+"]","g"),"").replace(info.decimal,".");
return _127e*info.factor;
};
_1251._realNumberRegexp=function(flags){
flags=flags||{};
if(!("places" in flags)){
flags.places=Infinity;
}
if(typeof flags.decimal!="string"){
flags.decimal=".";
}
if(!("fractional" in flags)||/^0/.test(flags.places)){
flags.fractional=[true,false];
}
if(!("exponent" in flags)){
flags.exponent=[true,false];
}
if(!("eSigned" in flags)){
flags.eSigned=[true,false];
}
var _127f=_1251._integerRegexp(flags),_1280=_1250.buildGroupRE(flags.fractional,function(q){
var re="";
if(q&&(flags.places!==0)){
re="\\"+flags.decimal;
if(flags.places==Infinity){
re="(?:"+re+"\\d+)?";
}else{
re+="\\d{"+flags.places+"}";
}
}
return re;
},true);
var _1281=_1250.buildGroupRE(flags.exponent,function(q){
if(q){
return "([eE]"+_1251._integerRegexp({signed:flags.eSigned})+")";
}
return "";
});
var _1282=_127f+_1280;
if(_1280){
_1282="(?:(?:"+_1282+")|(?:"+_1280+"))";
}
return _1282+_1281;
};
_1251._integerRegexp=function(flags){
flags=flags||{};
if(!("signed" in flags)){
flags.signed=[true,false];
}
if(!("separator" in flags)){
flags.separator="";
}else{
if(!("groupSize" in flags)){
flags.groupSize=3;
}
}
var _1283=_1250.buildGroupRE(flags.signed,function(q){
return q?"[-+]":"";
},true);
var _1284=_1250.buildGroupRE(flags.separator,function(sep){
if(!sep){
return "(?:\\d+)";
}
sep=_1250.escapeString(sep);
if(sep==" "){
sep="\\s";
}else{
if(sep==" "){
sep="\\s\\xa0";
}
}
var grp=flags.groupSize,grp2=flags.groupSize2;
if(grp2){
var _1285="(?:0|[1-9]\\d{0,"+(grp2-1)+"}(?:["+sep+"]\\d{"+grp2+"})*["+sep+"]\\d{"+grp+"})";
return ((grp-grp2)>0)?"(?:"+_1285+"|(?:0|[1-9]\\d{0,"+(grp-1)+"}))":_1285;
}
return "(?:0|[1-9]\\d{0,"+(grp-1)+"}(?:["+sep+"]\\d{"+grp+"})*)";
},true);
return _1283+_1284;
};
return _1251;
});
},"dojo/data/util/filter":function(){
define(["../../_base/lang"],function(lang){
var _1286={};
lang.setObject("dojo.data.util.filter",_1286);
_1286.patternToRegExp=function(_1287,_1288){
var rxp="^";
var c=null;
for(var i=0;i<_1287.length;i++){
c=_1287.charAt(i);
switch(c){
case "\\":
rxp+=c;
i++;
rxp+=_1287.charAt(i);
break;
case "*":
rxp+=".*";
break;
case "?":
rxp+=".";
break;
case "$":
case "^":
case "/":
case "+":
case ".":
case "|":
case "(":
case ")":
case "{":
case "}":
case "[":
case "]":
rxp+="\\";
default:
rxp+=c;
}
}
rxp+="$";
if(_1288){
return new RegExp(rxp,"mi");
}else{
return new RegExp(rxp,"m");
}
};
return _1286;
});
},"dijit/_WidgetsInTemplateMixin":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/parser"],function(array,_1289,_128a){
return _1289("dijit._WidgetsInTemplateMixin",null,{_earlyTemplatedStartup:false,widgetsInTemplate:true,_beforeFillContent:function(){
if(this.widgetsInTemplate){
var node=this.domNode;
var cw=(this._startupWidgets=_128a.parse(node,{noStart:!this._earlyTemplatedStartup,template:true,inherited:{dir:this.dir,lang:this.lang,textDir:this.textDir},propsThis:this,scope:"dojo"}));
if(!cw.isFulfilled()){
throw new Error(this.declaredClass+": parser returned unfilled promise (probably waiting for module auto-load), "+"unsupported by _WidgetsInTemplateMixin.   Must pre-load all supporting widgets before instantiation.");
}
this._attachTemplateNodes(cw,function(n,p){
return n[p];
});
}
},startup:function(){
array.forEach(this._startupWidgets,function(w){
if(w&&!w._started&&w.startup){
w.startup();
}
});
this.inherited(arguments);
}});
});
},"davinci/ve/utils/ImageUtils":function(){
define([],function(){
return {ImageUpdateFocus:function(_128b,_128c){
if(_128c&&_128b&&_128b.domNode&&_128b.domNode.tagName==="IMG"){
var conn=dojo.connect(_128b.domNode,"onload",function(){
var _128d=_128c.getSelection();
for(var i=0;i<_128d.length;i++){
if(_128d[i]==_128b){
_128c.updateFocus(_128b,i);
break;
}
}
dojo.disconnect(conn);
});
}
}};
});
},"url:dijit/templates/MenuBarItem.html":"<div class=\"dijitReset dijitInline dijitMenuItem dijitMenuItemLabel\" data-dojo-attach-point=\"focusNode\"\n\t \trole=\"menuitem\" tabIndex=\"-1\">\n\t<span data-dojo-attach-point=\"containerNode\"></span>\n</div>\n","dojox/grid/_Builder":function(){
define(["../main","dojo/_base/array","dojo/_base/lang","dojo/_base/window","dojo/_base/event","dojo/_base/sniff","dojo/_base/connect","dojo/dnd/Moveable","dojox/html/metrics","./util","dojo/_base/html"],function(dojox,array,lang,win,event,has,_128e,_128f,_1290,util,html){
var dg=dojox.grid;
var _1291=function(td){
return td.cellIndex>=0?td.cellIndex:array.indexOf(td.parentNode.cells,td);
};
var _1292=function(tr){
return tr.rowIndex>=0?tr.rowIndex:array.indexOf(tr.parentNode.childNodes,tr);
};
var getTr=function(_1293,index){
return _1293&&((_1293.rows||0)[index]||_1293.childNodes[index]);
};
var _1294=function(node){
for(var n=node;n&&n.tagName!="TABLE";n=n.parentNode){
}
return n;
};
var _1295=function(_1296,_1297){
for(var n=_1296;n&&_1297(n);n=n.parentNode){
}
return n;
};
var _1298=function(_1299){
var name=_1299.toUpperCase();
return function(node){
return node.tagName!=name;
};
};
var _129a=util.rowIndexTag;
var _129b=util.gridViewTag;
var _129c=dg._Builder=lang.extend(function(view){
if(view){
this.view=view;
this.grid=view.grid;
}
},{view:null,_table:"<table class=\"dojoxGridRowTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" role=\"presentation\"",getTableArray:function(){
var html=[this._table];
if(this.view.viewWidth){
html.push([" style=\"width:",this.view.viewWidth,";\""].join(""));
}
html.push(">");
return html;
},generateCellMarkup:function(_129d,_129e,_129f,_12a0){
var _12a1=[],html;
if(_12a0){
var _12a2=_129d.index!=_129d.grid.getSortIndex()?"":_129d.grid.sortInfo>0?"aria-sort=\"ascending\"":"aria-sort=\"descending\"";
if(!_129d.id){
_129d.id=this.grid.id+"Hdr"+_129d.index;
}
html=["<th tabIndex=\"-1\" aria-readonly=\"true\" role=\"columnheader\"",_12a2,"id=\"",_129d.id,"\""];
}else{
var _12a3=this.grid.editable&&!_129d.editable?"aria-readonly=\"true\"":"";
html=["<td tabIndex=\"-1\" role=\"gridcell\"",_12a3];
}
if(_129d.colSpan){
html.push(" colspan=\"",_129d.colSpan,"\"");
}
if(_129d.rowSpan){
html.push(" rowspan=\"",_129d.rowSpan,"\"");
}
html.push(" class=\"dojoxGridCell ");
if(_129d.classes){
html.push(_129d.classes," ");
}
if(_129f){
html.push(_129f," ");
}
_12a1.push(html.join(""));
_12a1.push("");
html=["\" idx=\"",_129d.index,"\" style=\""];
if(_129e&&_129e[_129e.length-1]!=";"){
_129e+=";";
}
html.push(_129d.styles,_129e||"",_129d.hidden?"display:none;":"");
if(_129d.unitWidth){
html.push("width:",_129d.unitWidth,";");
}
_12a1.push(html.join(""));
_12a1.push("");
html=["\""];
if(_129d.attrs){
html.push(" ",_129d.attrs);
}
html.push(">");
_12a1.push(html.join(""));
_12a1.push("");
_12a1.push(_12a0?"</th>":"</td>");
return _12a1;
},isCellNode:function(_12a4){
return Boolean(_12a4&&_12a4!=win.doc&&html.attr(_12a4,"idx"));
},getCellNodeIndex:function(_12a5){
return _12a5?Number(html.attr(_12a5,"idx")):-1;
},getCellNode:function(_12a6,_12a7){
for(var i=0,row;((row=getTr(_12a6.firstChild,i))&&row.cells);i++){
for(var j=0,cell;(cell=row.cells[j]);j++){
if(this.getCellNodeIndex(cell)==_12a7){
return cell;
}
}
}
return null;
},findCellTarget:function(_12a8,_12a9){
var n=_12a8;
while(n&&(!this.isCellNode(n)||(n.offsetParent&&_129b in n.offsetParent.parentNode&&n.offsetParent.parentNode[_129b]!=this.view.id))&&(n!=_12a9)){
n=n.parentNode;
}
return n!=_12a9?n:null;
},baseDecorateEvent:function(e){
e.dispatch="do"+e.type;
e.grid=this.grid;
e.sourceView=this.view;
e.cellNode=this.findCellTarget(e.target,e.rowNode);
e.cellIndex=this.getCellNodeIndex(e.cellNode);
e.cell=(e.cellIndex>=0?this.grid.getCell(e.cellIndex):null);
},findTarget:function(_12aa,inTag){
var n=_12aa;
while(n&&(n!=this.domNode)&&(!(inTag in n)||(_129b in n&&n[_129b]!=this.view.id))){
n=n.parentNode;
}
return (n!=this.domNode)?n:null;
},findRowTarget:function(_12ab){
return this.findTarget(_12ab,_129a);
},isIntraNodeEvent:function(e){
try{
return (e.cellNode&&e.relatedTarget&&html.isDescendant(e.relatedTarget,e.cellNode));
}
catch(x){
return false;
}
},isIntraRowEvent:function(e){
try{
var row=e.relatedTarget&&this.findRowTarget(e.relatedTarget);
return !row&&(e.rowIndex==-1)||row&&(e.rowIndex==row.gridRowIndex);
}
catch(x){
return false;
}
},dispatchEvent:function(e){
if(e.dispatch in this){
return this[e.dispatch](e);
}
return false;
},domouseover:function(e){
if(e.cellNode&&(e.cellNode!=this.lastOverCellNode)){
this.lastOverCellNode=e.cellNode;
this.grid.onMouseOver(e);
}
this.grid.onMouseOverRow(e);
},domouseout:function(e){
if(e.cellNode&&(e.cellNode==this.lastOverCellNode)&&!this.isIntraNodeEvent(e,this.lastOverCellNode)){
this.lastOverCellNode=null;
this.grid.onMouseOut(e);
if(!this.isIntraRowEvent(e)){
this.grid.onMouseOutRow(e);
}
}
},domousedown:function(e){
if(e.cellNode){
this.grid.onMouseDown(e);
}
this.grid.onMouseDownRow(e);
}});
var _12ac=dg._ContentBuilder=lang.extend(function(view){
_129c.call(this,view);
},_129c.prototype,{update:function(){
this.prepareHtml();
},prepareHtml:function(){
var _12ad=this.grid.get,cells=this.view.structure.cells;
for(var j=0,row;(row=cells[j]);j++){
for(var i=0,cell;(cell=row[i]);i++){
cell.get=cell.get||(cell.value==undefined)&&_12ad;
cell.markup=this.generateCellMarkup(cell,cell.cellStyles,cell.cellClasses,false);
if(!this.grid.editable&&cell.editable){
this.grid.editable=true;
}
}
}
},generateHtml:function(_12ae,_12af){
var html=this.getTableArray(),v=this.view,cells=v.structure.cells,item=this.grid.getItem(_12af);
util.fire(this.view,"onBeforeRow",[_12af,cells]);
for(var j=0,row;(row=cells[j]);j++){
if(row.hidden||row.header){
continue;
}
html.push(!row.invisible?"<tr>":"<tr class=\"dojoxGridInvisible\">");
for(var i=0,cell,m,cc,cs;(cell=row[i]);i++){
m=cell.markup;
cc=cell.customClasses=[];
cs=cell.customStyles=[];
m[5]=cell.format(_12af,item);
m[1]=cc.join(" ");
m[3]=cs.join(";");
html.push.apply(html,m);
}
html.push("</tr>");
}
html.push("</table>");
return html.join("");
},decorateEvent:function(e){
e.rowNode=this.findRowTarget(e.target);
if(!e.rowNode){
return false;
}
e.rowIndex=e.rowNode[_129a];
this.baseDecorateEvent(e);
e.cell=this.grid.getCell(e.cellIndex);
return true;
}});
var _12b0=dg._HeaderBuilder=lang.extend(function(view){
this.moveable=null;
_129c.call(this,view);
},_129c.prototype,{_skipBogusClicks:false,overResizeWidth:4,minColWidth:1,update:function(){
if(this.tableMap){
this.tableMap.mapRows(this.view.structure.cells);
}else{
this.tableMap=new dg._TableMap(this.view.structure.cells);
}
},generateHtml:function(_12b1,_12b2){
var html=this.getTableArray(),cells=this.view.structure.cells;
util.fire(this.view,"onBeforeRow",[-1,cells]);
for(var j=0,row;(row=cells[j]);j++){
if(row.hidden){
continue;
}
html.push(!row.invisible?"<tr>":"<tr class=\"dojoxGridInvisible\">");
for(var i=0,cell,_12b3;(cell=row[i]);i++){
cell.customClasses=[];
cell.customStyles=[];
if(this.view.simpleStructure){
if(cell.draggable){
if(cell.headerClasses){
if(cell.headerClasses.indexOf("dojoDndItem")==-1){
cell.headerClasses+=" dojoDndItem";
}
}else{
cell.headerClasses="dojoDndItem";
}
}
if(cell.attrs){
if(cell.attrs.indexOf("dndType='gridColumn_")==-1){
cell.attrs+=" dndType='gridColumn_"+this.grid.id+"'";
}
}else{
cell.attrs="dndType='gridColumn_"+this.grid.id+"'";
}
}
_12b3=this.generateCellMarkup(cell,cell.headerStyles,cell.headerClasses,true);
_12b3[5]=(_12b2!=undefined?_12b2:_12b1(cell));
_12b3[3]=cell.customStyles.join(";");
_12b3[1]=cell.customClasses.join(" ");
html.push(_12b3.join(""));
}
html.push("</tr>");
}
html.push("</table>");
return html.join("");
},getCellX:function(e){
var n,x=e.layerX;
if(has("mozilla")||has("ie")>=9){
n=_1295(e.target,_1298("th"));
x-=(n&&n.offsetLeft)||0;
var t=e.sourceView.getScrollbarWidth();
if(!this.grid.isLeftToRight()){
table=_1295(n,_1298("table"));
x-=(table&&table.offsetLeft)||0;
}
}
n=_1295(e.target,function(){
if(!n||n==e.cellNode){
return false;
}
x+=(n.offsetLeft<0?0:n.offsetLeft);
return true;
});
return x;
},decorateEvent:function(e){
this.baseDecorateEvent(e);
e.rowIndex=-1;
e.cellX=this.getCellX(e);
return true;
},prepareResize:function(e,mod){
do{
var i=e.cellIndex;
e.cellNode=(i?e.cellNode.parentNode.cells[i+mod]:null);
e.cellIndex=(e.cellNode?this.getCellNodeIndex(e.cellNode):-1);
}while(e.cellNode&&e.cellNode.style.display=="none");
return Boolean(e.cellNode);
},canResize:function(e){
if(!e.cellNode||e.cellNode.colSpan>1){
return false;
}
var cell=this.grid.getCell(e.cellIndex);
return !cell.noresize&&cell.canResize();
},overLeftResizeArea:function(e){
if(html.hasClass(win.body(),"dojoDndMove")){
return false;
}
if(has("ie")){
var tN=e.target;
if(html.hasClass(tN,"dojoxGridArrowButtonNode")||html.hasClass(tN,"dojoxGridArrowButtonChar")||html.hasClass(tN,"dojoxGridColCaption")){
return false;
}
}
if(this.grid.isLeftToRight()){
return (e.cellIndex>0)&&(e.cellX>0&&e.cellX<this.overResizeWidth)&&this.prepareResize(e,-1);
}
var t=e.cellNode&&(e.cellX>0&&e.cellX<this.overResizeWidth);
return t;
},overRightResizeArea:function(e){
if(html.hasClass(win.body(),"dojoDndMove")){
return false;
}
if(has("ie")){
var tN=e.target;
if(html.hasClass(tN,"dojoxGridArrowButtonNode")||html.hasClass(tN,"dojoxGridArrowButtonChar")||html.hasClass(tN,"dojoxGridColCaption")){
return false;
}
}
if(this.grid.isLeftToRight()){
return e.cellNode&&(e.cellX>=e.cellNode.offsetWidth-this.overResizeWidth);
}
return (e.cellIndex>0)&&(e.cellX>=e.cellNode.offsetWidth-this.overResizeWidth)&&this.prepareResize(e,-1);
},domousemove:function(e){
if(!this.moveable){
var c=(this.overRightResizeArea(e)?"dojoxGridColResize":(this.overLeftResizeArea(e)?"dojoxGridColResize":""));
if(c&&!this.canResize(e)){
c="dojoxGridColNoResize";
}
html.toggleClass(e.sourceView.headerNode,"dojoxGridColNoResize",(c=="dojoxGridColNoResize"));
html.toggleClass(e.sourceView.headerNode,"dojoxGridColResize",(c=="dojoxGridColResize"));
if(c){
event.stop(e);
}
}
},domousedown:function(e){
if(!this.moveable){
if((this.overRightResizeArea(e)||this.overLeftResizeArea(e))&&this.canResize(e)){
this.beginColumnResize(e);
}else{
this.grid.onMouseDown(e);
this.grid.onMouseOverRow(e);
}
}
},doclick:function(e){
if(this._skipBogusClicks){
event.stop(e);
return true;
}
return false;
},colResizeSetup:function(e,_12b4){
var _12b5=html.contentBox(e.sourceView.headerNode);
if(_12b4){
this.lineDiv=document.createElement("div");
var vw=html.position(e.sourceView.headerNode,true);
var _12b6=html.contentBox(e.sourceView.domNode);
var l=e.pageX;
if(!this.grid.isLeftToRight()&&has("ie")<8){
l-=_1290.getScrollbar().w;
}
html.style(this.lineDiv,{top:vw.y+"px",left:l+"px",height:(_12b6.h+_12b5.h)+"px"});
html.addClass(this.lineDiv,"dojoxGridResizeColLine");
this.lineDiv._origLeft=l;
win.body().appendChild(this.lineDiv);
}
var _12b7=[],nodes=this.tableMap.findOverlappingNodes(e.cellNode);
for(var i=0,cell;(cell=nodes[i]);i++){
_12b7.push({node:cell,index:this.getCellNodeIndex(cell),width:cell.offsetWidth});
}
var view=e.sourceView;
var adj=this.grid.isLeftToRight()?1:-1;
var views=e.grid.views.views;
var _12b8=[];
for(var j=view.idx+adj,cView;(cView=views[j]);j=j+adj){
_12b8.push({node:cView.headerNode,left:window.parseInt(cView.headerNode.style.left)});
}
var table=view.headerContentNode.firstChild;
var drag={scrollLeft:e.sourceView.headerNode.scrollLeft,view:view,node:e.cellNode,index:e.cellIndex,w:html.contentBox(e.cellNode).w,vw:_12b5.w,table:table,tw:html.contentBox(table).w,spanners:_12b7,followers:_12b8};
return drag;
},beginColumnResize:function(e){
this.moverDiv=document.createElement("div");
html.style(this.moverDiv,{position:"absolute",left:0});
win.body().appendChild(this.moverDiv);
html.addClass(this.grid.domNode,"dojoxGridColumnResizing");
var m=(this.moveable=new _128f(this.moverDiv));
var drag=this.colResizeSetup(e,true);
m.onMove=lang.hitch(this,"doResizeColumn",drag);
_128e.connect(m,"onMoveStop",lang.hitch(this,function(){
this.endResizeColumn(drag);
if(drag.node.releaseCapture){
drag.node.releaseCapture();
}
this.moveable.destroy();
delete this.moveable;
this.moveable=null;
html.removeClass(this.grid.domNode,"dojoxGridColumnResizing");
}));
if(e.cellNode.setCapture){
e.cellNode.setCapture();
}
m.onMouseDown(e);
},doResizeColumn:function(_12b9,mover,_12ba){
var _12bb=_12ba.l;
var data={deltaX:_12bb,w:_12b9.w+(this.grid.isLeftToRight()?_12bb:-_12bb),vw:_12b9.vw+_12bb,tw:_12b9.tw+_12bb};
this.dragRecord={inDrag:_12b9,mover:mover,leftTop:_12ba};
if(data.w>=this.minColWidth){
if(!mover){
this.doResizeNow(_12b9,data);
}else{
html.style(this.lineDiv,"left",(this.lineDiv._origLeft+data.deltaX)+"px");
}
}
},endResizeColumn:function(_12bc){
if(this.dragRecord){
var _12bd=this.dragRecord.leftTop;
var _12be=this.grid.isLeftToRight()?_12bd.l:-_12bd.l;
_12be+=Math.max(_12bc.w+_12be,this.minColWidth)-(_12bc.w+_12be);
if(has("webkit")&&_12bc.spanners.length){
_12be+=html._getPadBorderExtents(_12bc.spanners[0].node).w;
}
var data={deltaX:_12be,w:_12bc.w+_12be,vw:_12bc.vw+_12be,tw:_12bc.tw+_12be};
this.doResizeNow(_12bc,data);
delete this.dragRecord;
}
html.destroy(this.lineDiv);
html.destroy(this.moverDiv);
html.destroy(this.moverDiv);
delete this.moverDiv;
this._skipBogusClicks=true;
_12bc.view.update();
this._skipBogusClicks=false;
this.grid.onResizeColumn(_12bc.index);
},doResizeNow:function(_12bf,data){
_12bf.view.convertColPctToFixed();
if(_12bf.view.flexCells&&!_12bf.view.testFlexCells()){
var t=_1294(_12bf.node);
if(t){
(t.style.width="");
}
}
var i,s,sw,f,fl;
for(i=0;(s=_12bf.spanners[i]);i++){
sw=s.width+data.deltaX;
if(sw>0){
s.node.style.width=sw+"px";
_12bf.view.setColWidth(s.index,sw);
}
}
if(this.grid.isLeftToRight()||!has("ie")){
for(i=0;(f=_12bf.followers[i]);i++){
fl=f.left+data.deltaX;
f.node.style.left=fl+"px";
}
}
_12bf.node.style.width=data.w+"px";
_12bf.view.setColWidth(_12bf.index,data.w);
_12bf.view.headerNode.style.width=data.vw+"px";
_12bf.view.setColumnsWidth(data.tw);
if(!this.grid.isLeftToRight()){
_12bf.view.headerNode.scrollLeft=_12bf.scrollLeft+data.deltaX;
}
}});
dg._TableMap=lang.extend(function(rows){
this.mapRows(rows);
},{map:null,mapRows:function(_12c0){
var _12c1=_12c0.length;
if(!_12c1){
return;
}
this.map=[];
var row;
for(var k=0;(row=_12c0[k]);k++){
this.map[k]=[];
}
for(var j=0;(row=_12c0[j]);j++){
for(var i=0,x=0,cell,_12c2,_12c3;(cell=row[i]);i++){
while(this.map[j][x]){
x++;
}
this.map[j][x]={c:i,r:j};
_12c3=cell.rowSpan||1;
_12c2=cell.colSpan||1;
for(var y=0;y<_12c3;y++){
for(var s=0;s<_12c2;s++){
this.map[j+y][x+s]=this.map[j][x];
}
}
x+=_12c2;
}
}
},dumpMap:function(){
for(var j=0,row,h="";(row=this.map[j]);j++,h=""){
for(var i=0,cell;(cell=row[i]);i++){
h+=cell.r+","+cell.c+"   ";
}
}
},getMapCoords:function(inRow,inCol){
for(var j=0,row;(row=this.map[j]);j++){
for(var i=0,cell;(cell=row[i]);i++){
if(cell.c==inCol&&cell.r==inRow){
return {j:j,i:i};
}
}
}
return {j:-1,i:-1};
},getNode:function(_12c4,inRow,inCol){
var row=_12c4&&_12c4.rows[inRow];
return row&&row.cells[inCol];
},_findOverlappingNodes:function(_12c5,inRow,inCol){
var nodes=[];
var m=this.getMapCoords(inRow,inCol);
for(var j=0,row;(row=this.map[j]);j++){
if(j==m.j){
continue;
}
var rw=row[m.i];
var n=(rw?this.getNode(_12c5,rw.r,rw.c):null);
if(n){
nodes.push(n);
}
}
return nodes;
},findOverlappingNodes:function(_12c6){
return this._findOverlappingNodes(_1294(_12c6),_1292(_12c6.parentNode),_1291(_12c6));
}});
return {_Builder:_129c,_HeaderBuilder:_12b0,_ContentBuilder:_12ac};
});
},"davinci/workbench/EditorContainer":function(){
define(["require","dojo/_base/declare","dojo/_base/connect","./_ToolbaredContainer","../Runtime","../ve/metadata","../ve/utils/GeomUtils","dojo/Deferred","dojo/i18n!./nls/workbench"],function(_12c7,_12c8,_12c9,_12ca,_12cb,_12cc,_12cd,_12ce,_12cf){
var _12d0={},_12d1={};
return _12c8(_12ca,{constructor:function(args){
},postCreate:function(){
this.subscribe("/davinci/ui/editorSelected",function(event){
if(event.editor==this.editor){
this.updateToolbars();
}
});
this.subscribe("/davinci/ui/widgetSelected",this.updateToolbars);
this.subscribe("/davinci/workbench/ready",this.updateToolbars);
},layout:function(){
this.titleBarDiv.style.display="none";
this.toolbarDiv.style.display="none";
this.inherited(arguments);
},resize:function(){
this.inherited(arguments);
if(this.editor&&this.editor.editor&&this.editor.editor.getTextView){
this.editor.editor.getTextView().resize();
}
},setEditor:function(_12d2,_12d3,_12d4,file,_12d5,_12d6){
var d=new _12ce();
this.editorExtension=_12d2;
_12c7([_12d2.editorClass],function(_12d7){
try{
var _12d8=this.editor=new _12d7(this.containerNode,_12d3);
var _12d9=function(){
if(_12d8.setRootElement){
_12d8.setRootElement(_12d5);
}
this.containerNode=_12d8.domNode||this.containerNode;
if(typeof _12d2.editorClassName=="string"){
dojo.addClass(this.domNode,_12d2.editorClassName);
}
_12d8.editorID=_12d2.id;
_12d8.isDirty=!_12d8.isReadOnly&&this.isDirty;
this._createToolbar(_12d2.editorClass);
if(!_12d4){
_12d4=_12d8.getDefaultContent();
_12d8.isDirty=!_12d8.isReadOnly&&file.isNew;
_12d8.lastModifiedTime=Date.now();
}
if(!_12d4){
_12d4="";
}
_12d8.resourceFile=file;
_12d8.fileName=_12d3;
var _12da="editors_container";
if(davinci.Workbench._state.activeEditor==_12d3){
_12d8.setContent(_12d3,_12d4,_12d6);
this._setupKeyboardHandler(_12d8);
}else{
var _12db=dojo.subscribe(_12da+"-selectChild",this,function(args){
if(_12d8==args.editor){
dojo.unsubscribe(_12db);
_12d8.setContent(_12d3,_12d4);
this._setupKeyboardHandler(_12d8);
}
});
}
_12d8.editorContainer=this;
this.setDirty(_12d8.isDirty);
}.bind(this);
(_12d8.deferreds||new _12ce().resolve()).then(function(){
if(_12d4===true){
return file.getContent().then(function(_12dc){
_12d4=_12dc;
});
}
return new _12ce().resolve();
}).then(function(){
_12d9();
d.resolve(_12d8);
},function(e){
d.reject(e);
});
}
catch(e){
d.reject(e);
}
}.bind(this));
return d;
},setDirty:function(_12dd){
var title=this._getTitle();
this.lastModifiedTime=Date.now();
this.isDirty=_12dd;
var _12de=_12c7("../Workbench");
_12de.editorTabs.setTitle(this,title);
},_getTitle:function(){
var title=this.attr("title");
return title;
},save:function(_12df){
this.editor.save(_12df);
this.setDirty(_12df);
},_close:function(_12e0,_12e1){
dojo.publish("/davinci/ui/EditorClosing",[{editor:_12e0}]);
var _12e2=true;
if(_12e1&&_12e0&&_12e0.isDirty){
var _12e3=_12e0.getOnUnloadWarningMessage();
if(!_12e3){
_12e3=dojo.string.substitute(_12cf.fileHasUnsavedChanges,[this._getTitle()]);
}
_12e2=confirm(_12e3);
}
if(_12e2){
this._isClosing=true;
if(_12e0.removeWorkingCopy){
_12e0.removeWorkingCopy();
}else{
if(_12e0.getFileEditors){
_12e0.getFileEditors().forEach(function(_12e4){
if(_12e4.isReadOnly){
return;
}
_12e4.resourceFile.removeWorkingCopy();
});
}else{
if(_12e0.resourceFile){
_12e0.resourceFile.removeWorkingCopy();
}
}
}
}
return _12e2;
},onClose:function(){
var _12e5=!this._skipDirtyCheck;
return this._close(this.editor,_12e5);
},forceClose:function(_12e6,_12e7){
this._close(_12e6,_12e7);
var _12e8=this.getParent();
if(_12e8){
_12e8.removeChild(this);
this.destroyRecursive();
}
},_getViewActions:function(){
var _12e9=this.editorExtension.id;
var _12ea=[];
var _12eb=_12cb.getExtensions("davinci.editorActions",function(ext){
if(_12e9==ext.editorContribution.targetID){
_12ea.push(ext.editorContribution);
return true;
}
});
if(_12ea.length==0){
var _12eb=_12cb.getExtension("davinci.defaultEditorActions",function(ext){
_12ea.push(ext.editorContribution);
return true;
});
}
var _12ec=_12cc.getLibraryActions("davinci.editorActions",_12e9);
_12ea=dojo.clone(_12ea);
if(_12ea.length>0&&_12ec.length){
dojo.forEach(_12ec,function(_12ed){
var _12ee=_12c7("../Workbench");
if(_12ed.action){
_12ee._loadActionClass(_12ed);
}
if(_12ed.menu){
for(var i=0;i<_12ed.menu.length;i++){
var _12ef=_12ed.menu[0];
if(_12ef.action){
_12ee._loadActionClass(_12ef);
}
}
}
_12ea[0].actions.push(_12ed);
});
}
return _12ea;
},_getViewContext:function(){
return this.editor;
},_setupKeyboardHandler:function(_12f0){
var _12f1=function(o){
if(!this.keyBindings){
this.keyBindings=[];
}
this.keyBindings.push(o);
}.bind(this);
this._getViewActions().forEach(function(_12f2){
_12f2.actions.forEach(function(_12f3){
if(_12f3.keyBinding){
_12f1({keyBinding:_12f3.keyBinding,action:_12f3});
}
if(_12f3.menu){
_12f3.menu.forEach(function(_12f4){
if(_12f4.keyBinding){
_12f1({keyBinding:_12f4.keyBinding,action:_12f4});
}
},this);
}
},this);
},this);
_12c9.connect(_12f0,"handleKeyEvent",this,"_handleKeyDown");
},_handleKeyDown:function(e,_12f5){
var _12f6=this._handleKey(e,_12f5);
if(!_12f6&&!_12f5){
_12cb.handleKeyEvent(e);
}
},_handleKey:function(e,_12f7){
if(!this.keyBindings){
return false;
}
var _12f8=this.keyBindings.some(function(_12f9){
if(_12f7&&!_12f9.keyBinding.allowGlobal){
return;
}
if(_12cb.isKeyEqualToEvent(_12f9.keyBinding,e)){
var _12fa=_12c7("../Workbench");
_12fa._runAction(_12f9.action,this.editor,_12f9.action.id);
return true;
}
},this);
if(_12f8){
dojo.stopEvent(e);
}
return _12f8;
},destroy:function(){
this.inherited(arguments);
if(this.editor){
this.editor.destroy();
}
delete this.editor;
},_updateToolbar:function(_12fb){
function _12fc(_12fd,_12fe){
var _12ff=true;
if(_12fd&&_12fd.action&&_12fd.action[_12fe]){
_12ff=_12fd.action[_12fe]();
}else{
if(_12fd&&_12fd[_12fe]){
_12ff=_12fd[_12fe]();
}
}
return _12ff;
};
function _1300(_1301,_1302){
var _1303=_12fc(_1302,"shouldShow");
if(_1303){
dojo.removeClass(_1301.domNode,"maqHidden");
}else{
dojo.addClass(_1301.domNode,"maqHidden");
}
};
function _1304(_1305,_1306){
var _1307=_12fc(_1306,"isEnabled");
_1305.set("disabled",!_1307);
};
function _1308(_1309,_130a){
_12fc(_130a,"updateStyling");
};
if(_12fb&&this.editor){
var _130b=this.editor.getContext?this.editor.getContext():null;
if(_130b){
var _130c=_12fb.getChildren();
for(var i=0;i<_130c.length;i++){
var child=_130c[i];
_1300(child,child._maqAction);
_1304(child,child._maqAction);
_1308(child,child._maqAction);
var menu=child.dropDown;
if(menu){
var _130d=menu.getChildren();
for(var j=0;j<_130d.length;j++){
var _130e=_130d[j];
_1300(_130e,_130e._maqAction);
_1304(_130e,_130e._maqAction);
_1308(_130e,_130e._maqAction);
}
}
}
}
}
},updateToolbars:function(){
if(this.editor==_12cb.currentEditor){
var _130f=this.getToolbarDiv();
if(_130f){
_130f.innerHTML="";
}
var _1310=this.toolbarCreated(this.editorExtension.editorClass);
if(_130f&&_1310&&_1310.domNode){
_130f.appendChild(_1310.domNode);
}
var _1311=dojo.query("#davinci_toolbar_container .dijitToolbar")[0];
var _1312=_1311?dijit.byNode(_1311):null;
this._updateToolbar(_1312);
}
},_createToolbar:function(_1313){
if(this.toolbarCreated(_1313)||_12d0[_1313]){
return;
}
_12d0[_1313]=true;
this.inherited(arguments);
},getToolbarDiv:function(){
return dojo.byId("davinci_toolbar_container");
},toolbarCreated:function(_1314,_1315){
if(arguments.length>1){
_12d1[_1314]=_1315;
}
return _12d1[_1314];
}});
});
},"davinci/ve/commands/ModifyCommand":function(){
define(["dojo/_base/declare","davinci/ve/commands/_hierarchyCommand","../widget","../utils/ImageUtils","../States"],function(_1316,_1317,_1318,_1319,_131a){
return _1316("davinci.ve.commands.ModifyCommand",[_1317],{name:"modify",constructor:function(_131b,_131c,_131d,_131e,_131f){
this._oldId=(_131b?_131b.id:undefined);
this._properties=_131c=(_131c||{});
this._children=(_131d||typeof _131d=="string")?_131d:_131c._children;
this._context=_131e||_131b.getContext();
this._scripts=_131f;
delete this._properties._children;
},setContext:function(_1320){
this._context=_1320;
},add:function(_1321){
if(!_1321||_1321._oldId!=this._oldId){
return;
}
if(_1321._properties){
dojo.mixin(this._properties,_1321._properties);
}
if(_1321._children){
this._children=_1321._children;
}
},execute:function(){
if(!this._oldId||!this._properties){
return;
}
var _1322=_1318.byId(this._oldId),_1323=this._context;
if(!_1322){
return;
}
this._oldData=_1322.getData();
this._oldData.context=_1323;
this._newData={type:this._oldData.type,properties:dojo.mixin({},this._oldData.properties,this._properties),children:(this._children||typeof this._children=="string")?this._children:this._oldData.children,scripts:dojo.mixin({},this._oldData.scripts,this._scripts),maqAppStates:this._oldData.maqAppStates,maqDeltas:this._oldData.maqDeltas,context:_1323};
for(var prop in this._newData.properties){
var value=this._newData.properties[prop];
if(value==="$MAQ_MODIFYCOMMAND_DELETE_PROPERTY$"){
delete this._newData.properties[prop];
}
}
if(this._doRefreshFromSource(_1322)){
_1322.setProperties(this._newData.properties,true);
setTimeout(function(){
_1323.visualEditor.refresh();
},0);
return;
}
if(_1323){
_1323.detach(_1322);
}
if(!this._oldData.properties.isTempID||this._properties.id){
delete this._newData.properties.isTempID;
}
var _1324=_1322.getParent();
var _1325=null;
var index=_1324.indexOf(_1322);
_1324.removeChild(_1322);
_1322.destroyWidget();
_1325=_1318.createWidget(this._newData);
if(!_1325){
return;
}
if(_1325.domNode.tagName==="IMG"){
_1319.ImageUpdateFocus(_1325,_1323);
}
_1324.addChild(_1325,index);
this._newId=_1325.id;
if(_1323){
_1323.attach(_1325);
_1325.startup();
_1325.renderWidget();
_1323.widgetAddedOrDeleted();
if(this._oldId!=this._newId){
_1323.widgetChanged(_1323.WIDGET_ID_CHANGED,_1325,this._oldId);
}
_1323.widgetChanged(_1323.WIDGET_MODIFIED,_1325);
}
this.newWidget=_1325;
dojo.publish("/davinci/ui/widget/replaced",[_1325,_1322]);
_131a.resetState(_1325.domNode);
var _1326;
var _1327=this._isRefreshParentOnPropChange(_1325);
if(_1327){
if(typeof _1327=="string"){
_1326=_1324;
while(_1326&&_1326.domNode&&_1326.type!=_1327&&_1326.domNode.tagName!="BODY"){
if(!_1326.domNode||_1326.domNode.tagName=="BODY"){
_1326=null;
break;
}
_1326=_1326.getParent();
}
}else{
_1326=_1324;
}
}
var _1328=this._isRefreshOnDescendantChange(_1325);
if(_1328){
_1326=_1328;
}
if(_1326){
var _1329=new davinci.ve.commands.ModifyCommand(_1326,null,null,_1324._edit_context);
_1329.execute();
}
dojo.publish("/davinci/ui/widgetPropertiesChanged",[[_1325]]);
},_doRefreshFromSource:function(_132a){
var props=this._properties,name,p,_132b=false;
for(name in props){
if(props.hasOwnProperty(name)){
p=_132a.metadata.property[name];
if(p&&p.refreshFromSource){
_132b=true;
break;
}
}
}
return _132b;
},_isRefreshParentOnPropChange:function(_132c){
return davinci.ve.metadata.queryDescriptor(_132c.type,"refreshParentOnPropChange");
},undo:function(){
if(!this._newId||!this._oldData){
return;
}
var _132d=_1318.byId(this._newId);
if(!_132d){
return;
}
var _132e=_132d.getParent();
if(!_132e){
return;
}
var index=_132e.indexOf(_132d);
if(index<0){
return;
}
var _132f=_132e.getContext();
if(_132f){
_132f.detach(_132d);
}
_132e.removeChild(_132d);
_132d.destroyWidget();
newWidget=_1318.createWidget(this._oldData);
if(!newWidget){
return;
}
this._oldData=newWidget.getData();
this._oldData.context=this._context;
_132e.addChild(newWidget,index);
if(_132f){
_132f.attach(newWidget);
newWidget.startup();
newWidget.renderWidget();
_132f.widgetAddedOrDeleted();
_132f.widgetChanged(_132f.WIDGET_MODIFIED,newWidget);
}
dojo.publish("/davinci/ui/widget/replaced",[newWidget,_132d]);
_131a.resetState(newWidget.domNode);
var _1330;
var _1331=this._isRefreshParentOnPropChange(_132d);
if(_1331){
if(typeof refreshParent=="string"){
_1330=_132e;
while(_1330&&_1330.domNode&&_1330.type!=refreshParent&&_1330.domNode.tagName!="BODY"){
if(!_1330.domNode||_1330.domNode.tagName=="BODY"){
_1330=null;
break;
}
_1330=_1330.getParent();
}
}else{
_1330=_132e;
}
}
var _1332=this._isRefreshOnDescendantChange(newWidget);
if(_1332){
_1330=_1332;
}
if(_1330){
var _1333=new davinci.ve.commands.ModifyCommand(_1330,null,null,_132e._edit_context);
_1333.execute();
}
dojo.publish("/davinci/ui/widgetPropertiesChanged",[[newWidget]]);
}});
});
},"davinci/review/widgets/PublishWizard":function(){
define(["dojo/_base/declare","dijit/_WidgetBase","dijit/_TemplatedMixin","dijit/_WidgetsInTemplateMixin","dijit/layout/StackContainer","dijit/layout/ContentPane","dijit/form/SimpleTextarea","dijit/form/NumberTextBox","dijit/form/ValidationTextBox","dijit/form/DateTextBox","dijit/form/Button","dijit/form/ComboBox","dojo/data/ItemFileWriteStore","dijit/form/CheckBox","dojox/grid/DataGrid","dojox/data/QueryReadStore","dojox/widget/Toaster","dojox/validate/regexp","dojo/_base/xhr","dojo/string","dojo/fx","dojo/date/stamp","dijit/Tree","dojo/Deferred","dojo/promise/all","system/resource","davinci/Runtime","davinci/Workbench","davinci/model/resource/Folder","davinci/model/resource/File","davinci/review/model/resource/Empty","davinci/review/model/resource/root","dijit/tree/TreeStoreModel","davinci/review/model/store/GeneralReviewReadStore","dojo/i18n!./nls/widgets","dojo/i18n!dijit/nls/common","dojo/text!./templates/PublishWizard.html","dojo/text!./templates/MailFailureDialogContent.html"],function(_1334,_1335,_1336,_1337,_1338,_1339,_133a,_133b,_133c,_133d,_133e,_133f,_1340,_1341,_1342,_1343,_1344,_1345,xhr,_1346,_1347,stamp,Tree,_1348,all,_1349,_134a,_134b,_134c,File,Empty,_134d,_134e,_134f,_1350,_1351,_1352,_1353){
var _1354=_1334(dijit._TreeNode,{postCreate:function(){
this.inherited(arguments);
var _1355=dojo.create("img",{src:"app/dojo/resources/blank.gif","class":"deleteImg"});
dojo.connect(_1355,"onclick",this,dojo.hitch(this,function(){
dojo.publish("/davinci/review/deleteReviewFile",[this.item]);
}));
dojo.place(_1355,this.rowNode,"first");
dojo.style(this.rowNode,{width:"99%"});
dojo.style(this.containerNode,{display:"block"});
}});
var _1356=_1334(Tree,{_createTreeNode:function(args){
return new _1354(args);
}});
return _1334("davinci.review.widgets.PublishWizard",[_1335,_1336],{templateString:_1352,postMixInProperties:function(){
this.inherited(arguments);
dojo.mixin(this,_1350);
dojo.mixin(this,_1351);
},postCreate:function(){
var sc=this.reviewerStackContainer=new _1338({},this.reviewerStackContainer);
var page1=this.page1=new _1339({style:"overflow:hidden;"});
var page2=this.page2=new _1339({style:"overflow:hidden;"});
var page3=this.page3=new _1339({style:"overflow:hidden;"});
this.reviewerStackContainer.addChild(page1);
this.reviewerStackContainer.addChild(page2);
this.reviewerStackContainer.addChild(page3);
this._initPage1();
this._initPage2();
this._initPage3();
this._initButtons();
dojo.place(this.page1Node,page1.domNode);
dojo.place(this.page2Node,page2.domNode);
dojo.place(this.page3Node,page3.domNode);
sc.startup();
this._subs=[dojo.subscribe(sc.id+"-selectChild",dojo.hitch(this,this._onPageSelected)),dojo.subscribe("/davinci/review/publish/valueChanged",dojo.hitch(this,this.updateSubmit)),dojo.subscribe("/davinci/review/deleteReviewFile",dojo.hitch(this,this.delFiles)),dojo.subscribe("/davinci/review/deleteReviewer",dojo.hitch(this,this.delRow))];
},_initPage1:function(){
this.versionTitle=new _133c({onChange:this._onValueChange,required:true},this.versionTitle);
this.receiveEmail=new _1341({checked:true},this.receiveEmail);
this.descriptions=new _133a({style:"width:460px;height:100px;font-family:Verdana, Arial, Helvetica, sans-serif;font-size:100%;"},this.descriptions);
this.desireWidth=new _133b({constraints:{min:0,places:0},value:1024,style:"width:85px"},this.desireWidth);
this.desireHeight=new _133b({constraints:{min:0,places:0},value:768,style:"width:85px"},this.desireHeight);
var _1357=new Date();
this.dueDate=new _133d({onChange:this._onValueChange,type:"text",constraints:{min:new Date(_1357.getFullYear(),_1357.getMonth(),_1357.getDate())}},this.dueDate);
},_initPage2:function(){
var _1358=[];
var _1359=this.fileIndex=1;
this.reviewFiles=_1358;
var _135a=this.sourceTreeModel=new _134e({deferItemLoadingUntilExpand:true,store:new _134f({root:new _134c(_134b.getProject(),null),getLabel:function(item){
var label=item.getName();
if(item.link){
label=label+"  ["+item.link+"]";
}
return label;
}})});
var _135b=function(item){
this.addFiles([item]);
};
var _135c=this.sourceTree=new Tree({id:"reviewWizardSourceTree",persist:false,showRoot:false,model:_135a,labelAttr:"name",getIconClass:dojo.hitch(this,this._getIconClass),isMultiSelect:true,onDblClick:dojo.hitch(this,_135b),transforms:[function(items){
return items.sort(function(a,b){
a=a.name.toLowerCase();
b=b.name.toLowerCase();
return a<b?-1:(a>b?1:0);
});
}]});
this.sourceTreeNode.appendChild(_135c.domNode);
_135c.startup();
var _135d=this.targetTreeModel=new _134e({store:new _134f({root:new Empty(),getLabel:function(item){
var label=item.getName();
if(item.link){
label=label+"  ["+item.link+"]";
}
return label;
}})});
var _135e=this.targetTree=new _1356({id:"reviewWizardTargetTree",showRoot:false,model:_135d,labelAttr:"name",getIconClass:dojo.hitch(this,this._getIconClass),isMultiSelect:true});
this.targetTreeNode.appendChild(_135e.domNode);
_135e.startup();
},_initPage3:function(){
var _135f=function(_1360){
if(!this.photoRepositoryUrl){
this.photoRepositoryUrl=_134a.serverJSONRequest({url:"cmd/getBluePageInfo",handleAs:"text",content:{"type":"photo"},sync:true,});
}
if(this.photoRepositoryUrl===""||this.photoRepositoryUrl=="not-implemented"){
this.photoRepositoryUrl="app/davinci/review/resources/img/profileNoPhoto.gif?";
}
return "<img src=\""+this.photoRepositoryUrl+_1360+"\" width=\"35px\" height=\"35px\" alt=\"User Photo\"></img>";
}.bind(this);
var _1361=function(_1362){
return "<a href=\"javascript:dojo.publish('/davinci/review/deleteReviewer',[])\"><img class=\"delImg\" src=\"app/davinci/review/resources/img/del.gif\"/></a>";
};
var _1363=[{cells:[{name:_1350.user,field:"email",formatter:_135f,width:"70px",styles:"text-align: center;"},{name:_1350.emailAddress,field:"displayName",width:"320px"},{name:_1350.action,field:"action",formatter:_1361,width:"70px",styles:"text-align: center;"}]}];
var _1364={identifier:"email",label:"name",items:[]};
this.userData=_1364.items;
var _1365=new _1340({data:_1364});
this.jsonStore=_1365;
var grid=new _1342({elasticView:"1",store:_1365,structure:_1363,style:"height:100%;width:100%;",canSort:function(index){
if(index==1){
return false;
}
return true;
},canResize:function(){
return false;
},delRow:function(e){
this.removeSelectedRows();
_1365.save();
}});
this.grid=grid;
this.userGrid.appendChild(grid.domNode);
grid.startup();
this.addReviewerButton=new _133e({disabled:true,onClick:dojo.hitch(this,this.addReviewer),label:"<div style='width:75px;height:10px;margin:-6px 0 0 0'>"+_1350.add+"</div>"},this.addReviewerButton);
var _1366=new _1343({url:"cmd/getBluePageInfo",fetch:function(_1367){
var _1368=_1367.query.displayName;
_1368=_1368.substring(0,_1368.length-1);
_1367.serverQuery={searchname:_1368};
return this.inherited("fetch",arguments);
}});
this.addReviewerCombox=new _133f({regExpGen:dojo.hitch(this,this._emailAddress),required:true,store:_1366,searchAttr:"displayName",name:"displayName",autoComplete:false,hasDownArrow:false,highlightMatch:"all",style:"width:220px",onChange:dojo.hitch(this,this._reviewerComboxValueChanged),onKeyUp:dojo.hitch(this,this._updateAddButton),pageSize:10,searchDelay:500,placeHolder:_1350.enterNameOrEmail},this.addReviewerCombox);
},_emailAddress:function(flags){
if(this.addReviewerCombox.item){
return ".*";
}
flags=(typeof flags=="object")?flags:{};
if(typeof flags.allowCruft!="boolean"){
flags.allowCruft=false;
}
flags.allowPort=false;
var _1369="([!#-'*+\\-\\/-9=?A-Z^-~]+[.])*[!#-'*+\\-\\/-9=?A-Z^-~]+";
var _136a=_1369+"@"+_1345.host(flags);
if(flags.allowCruft){
_136a="<?(mailto\\:)?"+_136a+">?";
}
return _136a;
},_initButtons:function(){
this.invite=new _133e({disabled:true,onClick:dojo.hitch(this,function(){
this.publish();
})},this.invite);
this.next=new _133e({onClick:dojo.hitch(this,function(){
this.reviewerStackContainer.forward();
})},this.next);
this.prev=new _133e({onClick:dojo.hitch(this,function(){
this.reviewerStackContainer.back();
})},this.prev);
this.saveDt=new _133e({onClick:dojo.hitch(this,function(){
this.publish(true);
})},this.saveDt);
},_reviewerComboxValueChanged:function(){
if(this.addReviewerCombox.item){
this.addReviewer();
}
},_updateAddButton:function(e){
var valid=this.addReviewerCombox.isValid();
this.addReviewerButton.set("disabled",!valid);
if(e.keyCode==13&&valid){
this.addReviewer();
}
},delRow:function(){
this.grid.delRow();
dojo.publish("/davinci/review/publish/valueChanged");
},addReviewer:function(){
var item=this.addReviewerCombox.item;
var _136b,email,name;
if(item){
_136b=this.addReviewerCombox.value.split(",").join("");
email=item.i.emailaddress;
name=item.i.name;
name=name.split(",").join("");
}else{
name=email=_136b=this.addReviewerCombox.get("value");
}
this.jsonStore.fetchItemByIdentity({identity:email,onItem:function(i){
item=i;
}});
var grid=this.grid;
if(item){
var index=grid.getItemIndex(item);
grid.scrollToRow(index);
var node=grid.getRowNode(index);
dojo.fx.chain([dojo.fadeOut({node:node,duration:300}),dojo.fadeIn({node:node,duration:700}),dojo.fadeOut({node:node,duration:300}),dojo.fadeIn({node:node,duration:700})]).play();
node.removeAttribute("style");
}else{
this.jsonStore.newItem({name:name,email:email,displayName:_136b});
grid.scrollToRow(grid.get("rowCount"));
this.addReviewerCombox.item=null;
this.addReviewerCombox.reset();
this.addReviewerButton.set("disabled",true);
dojo.publish("/davinci/review/publish/valueChanged");
}
},_onValueChange:function(){
dojo.publish("/davinci/review/publish/valueChanged");
},_onPageSelected:function(page){
this.prev.set("disabled",page.isFirstChild);
this.next.set("disabled",page.isLastChild);
dojo.removeClass(this.navPage1,"current");
dojo.removeClass(this.navPage2,"current");
dojo.removeClass(this.navPage3,"current");
if(page==this.page1){
dojo.addClass(this.navPage1,"current");
}
if(page==this.page2){
dojo.addClass(this.navPage2,"current");
}
if(page==this.page3){
dojo.addClass(this.navPage3,"current");
}
},updateSubmit:function(){
var valid=this.versionTitle.isValid()&&this.dueDate.isValid();
var _136c=this.reviewFiles&&this.reviewFiles.length>0;
var _136d=this.userData.length>0;
dojo.removeClass(this.navPage1Icon,valid?"todo":"done");
dojo.addClass(this.navPage1Icon,valid?"done":"todo");
dojo.removeClass(this.navPage2Icon,_136c?"todo":"done");
dojo.addClass(this.navPage2Icon,_136c?"done":"todo");
dojo.removeClass(this.navPage3Icon,_136d?"todo":"done");
dojo.addClass(this.navPage3Icon,_136d?"done":"todo");
this.invite.set("disabled",!(valid&&_136c&&_136d));
var _136e="";
if(!_136d){
_136e=_1350.noReviewersSelected;
}
if(!_136c){
_136e=_1350.noFilesSelected;
}
if(!this.dueDate.isValid()){
_136e=_1350.dueDateIncorrect;
}
if(!this.versionTitle.isValid()){
_136e=_1350.titleRequired;
}
this.reviewMsg.innerHTML=_136e;
},select:function(evt){
var _136f=evt.target;
var _1370=this.reviewerStackContainer;
if(_136f==this.navPage1||_136f==this.navPage1Icon){
_1370.selectChild(this.page1,true);
}else{
if(_136f==this.navPage2||_136f==this.navPage2Icon){
_1370.selectChild(this.page2,true);
}else{
if(_136f==this.navPage3||_136f==this.navPage3Icon){
_1370.selectChild(this.page3,true);
}
}
}
},update:function(){
var _1371=this.targetTreeModel;
_1371.onChildrenChange(_1371.root,_1371.root.children);
},containReviewFile:function(index){
return (this.reviewFiles||[]).some(function(file){
return isNaN(index)?file==index:file.index==index;
});
},getChildrenFiles:function(item){
var _1372=this.reviewFiles||[];
var _1373=this.targetTreeModel;
if(item.elementType=="File"){
if(!this.containReviewFile(item)){
item.index=this.fileIndex++;
_1372.push(item);
var file=new File(item.name,_1373.root);
file.index=item.index;
_1373.root.children.push(file);
}
}else{
if(item.elementType=="Folder"){
item.getChildren(function(_1374){
dojo.forEach(_1374,dojo.hitch(this,function(item){
if(item.elementType=="File"){
this.getChildrenFiles(item);
}
}.bind(this)));
}.bind(this));
}
}
},addSelectFiles:function(){
var _1375=this.sourceTree.get("selectedItems");
this.addFiles(_1375);
},addFiles:function(files){
var _1376=this.sourceTree.get("selectedItems");
if(files){
_1376=files;
}
dojo.forEach(_1376,this.getChildrenFiles,this);
this.update();
dojo.publish("/davinci/review/publish/valueChanged");
},delFiles:function(item){
var _1377=this.reviewFiles,_1378=this.targetTree.get("selectedItems");
if(item){
_1378=[item];
}
dojo.forEach(_1378,dojo.hitch(this,function(item){
if(item.index){
var tmp,i;
for(i=0;i<_1377.length;i++){
if(item.index==_1377[i].index){
tmp=_1377[i];
_1377.splice(i,1);
break;
}
}
if(!tmp){
return;
}
var list=item.parent.children;
for(i=0;i<list.length;i++){
if(item==list[i]){
item.parent.children.splice(i,1);
break;
}
}
this.update(tmp);
}
}));
dojo.publish("/davinci/review/publish/valueChanged");
},_getIconClass:function(item,_1379){
if(item.elementType=="Folder"){
return _1379?"dijitFolderOpened":"dijitFolderClosed";
}
if(item.elementType=="File"){
var icon;
var _137a=item.getExtension();
var _137b=_134a.getExtension("davinci.fileType",function(_137c){
return _137c.extension==_137a;
});
if(_137b){
icon=_137b.iconClass;
}
return icon||"dijitLeaf";
}
return "dijitLeaf";
},initData:function(node,_137d){
var _137e=new _1348();
this.node=node;
this.isRestart=_137d;
if(!node){
xhr.get({url:"cmd/getLatestVersionId"}).then(function(_137f){
this.versionTitle.set("value",dojo.string.substitute(_1350.defaultReviewTitle,[_137f]));
}.bind(this));
}
if(node){
var vName=node.name;
if(_137d){
vName+=" (R)";
}
this.versionTitle.set("value",vName);
if(!this.isRestart){
this.dueDate.set("value",node.dueDate=="infinite"?new Date(""):node.dueDate);
}
this.desireWidth.set("value",node.width===0?"":node.width);
this.desireHeight.set("value",node.height===0?"":node.height);
if(node.description){
this.descriptions.set("value",node.description);
}
this.receiveEmail.set("value",node.receiveEmail);
node.getChildren(function(_1380){
dojo.forEach(_1380,function(item){
var file=_1349.findResource(item.name);
if(file!=null){
this.addFiles([file]);
}
}.bind(this));
for(var i=0;i<node.reviewers.length;i++){
if(node.reviewers[i].email!=node.designerEmail){
var _1381=_134a.getUserDisplayNamePlusEmail({email:node.reviewers[i].email,userId:node.reviewers[i].name});
this.jsonStore.newItem({name:node.reviewers[i].name,email:node.reviewers[i].email,displayName:_1381});
}
}
_137e.resolve();
}.bind(this));
}else{
_137e.resolve();
}
return _137e;
},publish:function(_1382){
var _1383=this.userData.map(function(data){
return data.email;
}).join(",");
var _1384=this.descriptions;
var _1385=_1384.value;
var _1386=this.versionTitle.value;
var _1387=this.dueDate.get("value");
var _1388=_1387?stamp.toISOString(_1387,{zulu:true}):"infinite";
var _1389=this.desireWidth.value||0;
var _138a=this.desireHeight.value||0;
var _138b=dojo.map(this.reviewFiles,function(item){
var path=item.getPath();
if(path.length>2&&path.indexOf("./")==0){
path=path.substring(2);
}
return path;
});
var _138c=this.receiveEmail.get("value")=="on"?"true":"false";
var _138d={isUpdate:this.node&&!this.isRestart,isRestart:this.isRestart,vTime:this.node?this.node.timeStamp:null,emails:_1383,message:_1385,versionTitle:_1386,resources:_138b,desireWidth:_1389,desireHeight:_138a,savingDraft:_1382,dueDate:_1388,receiveEmail:_138c};
if(_134a.currentEditor&&_134a.currentEditor.getContext&&_134a.currentEditor.getContext().getPreference("zazl")){
_138d.zazl=true;
}
var _138e=dojo.objectToQuery(_138d);
xhr.post({url:"cmd/publish"+"?"+_138e,handleAs:"json"}).then(function(_138f){
if(typeof hasToaster=="undefined"){
new _1344({position:"br-left",duration:4000,messageTopic:"/davinci/review/resourceChanged"});
hasToaster=true;
}
if(_138f.length>0){
var _1390=_138f[0];
if(_1390.result=="OK"){
if(_1382){
dojo.publish("/davinci/review/resourceChanged",[{message:_1350.draftSaved,type:"message"},"draft",this.node]);
}else{
if(_1390.emailResult){
if(_1390.emailResult=="OK"){
dojo.publish("/davinci/review/resourceChanged",[{message:_1350.inviteSuccessful,type:"message"},"create",this.node]);
}else{
var _1391=_1346.substitute(_1353,{htmlContent:_1390.emailResult,inviteNotSent:_1350.inviteNotSent,mailFailureMsg:_1350.mailFailureMsg});
dojo.publish("/davinci/review/resourceChanged",[{message:_1350.inviteFailed,type:"warning"},"create",this.node]);
_134b.showMessage(_1350.warning,_1391);
}
}
}
}
}
}.bind(this)).otherwise(function(_1392){
var msg=_1392.responseText;
msg=msg.substring(msg.indexOf("<title>")+7,msg.indexOf("</title>"));
_134a.handleError(_1346.substitute(_1350.errorPublish,[_1392,msg]));
});
this.onClose();
},onClose:function(){
},destroy:function(){
this.inherited(arguments);
this._subs.forEach(dojo.unsubscribe);
delete this._subs;
this.sourceTree.destroyRecursive();
this.targetTree.destroyRecursive();
}});
});
},"davinci/ui.plugin":function(){
define(["require","davinci/css!./ui.css"],function(_1393){
return {id:"davinci.ui","davinci.view":[{id:"navigator",title:"Files",viewClass:"davinci/workbench/Explorer",iconClass:"paletteIcon paletteIconFiles"},{id:"hierarchy",title:"Hierarchy"},{id:"outline",title:"Outline",viewClass:"davinci/workbench/OutlineView",iconClass:"paletteIcon paletteIconOutline"},{id:"comment",title:"Comments",viewClass:"davinci/review/view/CommentView",iconClass:"paletteIcon paletteIconComments"},{id:"scope",title:"Scope"},{id:"properties",title:"Properties",viewClass:"davinci/workbench/PropertyEditor"},{id:"problems",title:"Problems",viewClass:"davinci/workbench/ProblemsView"},{id:"console",title:"Console"},{id:"history",title:"History"},{id:"search",title:"Search"}],"davinci.preferences":[{name:"Project",id:"project",hide:true,category:"",pageContent:"Project Settings here"},{name:"Project Settings",id:"ProjectPrefs",category:"davinci.ui.project",pane:"davinci/ui/ProjectPreferences",defaultValues:{"webContentFolder":"","themeFolder":"themes","widgetFolder":"lib/custom"}}],"davinci.perspective":{id:"main",title:"AJAX IDE",views:[{viewID:"davinci.ui.navigator",position:"left-bottom"},{viewID:"davinci.ui.outline",position:"right"},{viewID:"davinci.ui.properties",position:"right-bottom"}]},"davinci.actionSets":[{id:"editorActions",visible:true,menu:[{__mainMenu:true,separator:["new",false,"open",false]},{label:"Create",path:"new",id:"davinci.new",separator:["newApp",true,"newSketch",true,"newFolder",true,"newTheme",true,"newProject",true,"additions",true]},{label:"Open",path:"open",id:"davinci.open",separator:["openFile",true,"openTheme",true,"openOrion",true,"additions",false]}],actions:[{id:"newHTMLMobile",run:function(){
_1393(["./ui/Resource"],function(r){
r.newHTMLMobile();
});
},iconClass:"newOpenMenuItem newMobileAppMenuItem",label:"Mobile Application...",menubarPath:"davinci.new/newApp"},{id:"newHTMLDesktop",run:function(){
_1393(["./ui/Resource"],function(r){
r.newHTMLDesktop();
});
},iconClass:"newOpenMenuItem newDesktopAppMenuItem",label:"Desktop Application...",menubarPath:"davinci.new/newApp"},{id:"newHTMLSketchHiFi",run:function(){
_1393(["./ui/Resource"],function(r){
r.newHTMLSketchHiFi();
});
},iconClass:"newOpenMenuItem newSketchHiFiMenuItem",label:"Sketch (high-fidelity)...",menubarPath:"davinci.new/newSketch"},{id:"newHTMLSketchLoFi",run:function(){
_1393(["./ui/Resource"],function(r){
r.newHTMLSketchLoFi();
});
},iconClass:"newOpenMenuItem newSketchLoFiMenuItem",label:"Sketch (low-fidelity)...",menubarPath:"davinci.new/newSketch"},{id:"newFolder",run:function(){
_1393(["./ui/Resource"],function(r){
r.newFolder();
});
},iconClass:"newOpenMenuItem newFolderMenuItem",label:"Folder...",menubarPath:"davinci.new/newFolder"},{id:"newCSS",run:function(){
_1393(["./ui/Resource"],function(r){
r.newCSS();
});
},iconClass:"newOpenMenuItem newCSSMenuItem",label:"CSS File...",menubarPath:"davinci.new/newFolder"},{id:"newJS",run:function(){
_1393(["./ui/Resource"],function(r){
r.newJS();
});
},iconClass:"newOpenMenuItem newJSMenuItem",label:"JavaScript File...",menubarPath:"davinci.new/newFolder"},{id:"newTheme",run:function(){
_1393(["davinci/Workbench","davinci/ui/NewTheme"],function(_1394,_1395){
_1394.showModal(new _1395(),"New Theme",{width:300},null,true);
});
},iconClass:"newOpenMenuItem newThemeMenuItem",label:"Theme...",menubarPath:"davinci.new/newTheme"},{id:"newProject",run:function(){
_1393(["./ui/Resource"],function(r){
r.newProject();
});
},iconClass:"newOpenMenuItem newProjectMenuItem",label:"Project...",menubarPath:"davinci.new/newProject"},{id:"openFile",run:function(){
_1393(["./ui/Resource"],function(r){
r.openFile();
});
},iconClass:"newOpenMenuItem openFileMenuItem",label:"File...",toolbarPath:"davinci.toolbar.main/edit",menubarPath:"davinci.open/openFile",keyBinding:{accel:true,charOrCode:"o"}},{id:"openThemeEditor",run:function(){
_1393(["davinci/Workbench","davinci/ui/OpenThemeDialog"],function(_1396,_1397){
_1396.showModal(new _1397(),"Open Theme",{width:200},null,true);
});
},iconClass:"newOpenMenuItem openThemeMenuItem",label:"Theme Editor...",menubarPath:"davinci.open/openTheme"},{id:"openReview",run:function(){
_1393(["./ui/Resource"],function(r){
r.openFile();
});
},run:function(){
_1393(["davinci/Workbench","davinci/review/widgets/OpenReviewDialog"],function(_1398,_1399){
_1398.showModal(new _1399(),"Open Review",{width:350,height:250});
});
},iconClass:"newOpenMenuItem openReviewMenuItem",label:"Review...",menubarPath:"davinci.open/openTheme"},{id:"orionNavigator",run:function(){
window.open("../navigate/table.html#","_blank");
window.focus();
},iconClass:"newOpenMenuItem orionIcon",label:"Orion Navigator",menubarPath:"davinci.open/openOrion"}]},{id:"main",visible:true,menu:[{__mainMenu:true,separator:["usersettings",false,"settings",false,"additions",false,"help",false]},{label:"User settings",path:"usersettings",id:"davinci.usersettings",className:"userSettingsMenu",iconClass:"userSettingsMenuIcon",showLabel:false,separator:["username",true,"logout",true,"additions",false]},{label:"Settings",path:"settings",id:"davinci.settings",className:"appSettingsMenu",iconClass:"appSettingsMenuIcon",showLabel:false,separator:["settings",true,"additions",false]},{label:"Help",path:"help",id:"davinci.help",className:"helpMenu",iconClass:"helpMenuIcon",showLabel:false,separator:["help",true,"about",false,"additions",false]}],actions:[{id:"editPreferences",run:function(){
_1393(["davinci/workbench/Preferences"],function(_139a){
_139a.showPreferencePage();
});
},label:"Preferences...",menubarPath:"davinci.settings/settings"},{id:"editThemeSets",run:function(){
_1393(["davinci/ui/ThemeSetsDialog"],function(_139b){
_139b();
});
},label:"Theme sets...",menubarPath:"davinci.settings/settings"},{id:"showHelp",run:function(){
window.open("app/docs/index.html","MaqettaDocumentation");
},label:"Documentation",menubarPath:"davinci.help/help",keyBinding:{charOrCode:dojo.keys.F1}},{id:"showTutotials",run:function(){
window.open("app/docs/index.html#tutorials/tutorials","MaqettaTutorials");
},label:"Tutorials",menubarPath:"davinci.help/help"},{id:"showVideos",run:function(){
window.open("http://www.youtube.com/user/Maqetta/","MaqettaVideos");
},label:"Videos",menubarPath:"davinci.help/help"},{id:"showCheatSheets",run:function(){
window.open("app/docs/index.html#cheatsheets/cheatsheets","MaqettaCheatSheets");
},label:"Cheat sheets",menubarPath:"davinci.help/help"},{id:"showHowTo",run:function(){
window.open("https://www.ibm.com/search/csass/search/?sn=dw&en=utf&hpp=20&dws=dw&q=maqetta&Search=Search","MaqettaHowTo");
},label:"How-to articles",menubarPath:"davinci.help/help"},{id:"about",run:function(){
_1393(["davinci/ui/about"],function(about){
about.show();
});
},label:"About Maqetta",menubarPath:"davinci.help/about"},{id:"username",action:"davinci/actions/UserNameAction",run:function(){
window.open("../settings/settings.html","_blank");
window.focus();
},label:"{user}",menubarPath:"davinci.usersettings/username"},{id:"logout",action:"davinci/actions/LogoutAction",label:"Logout",menubarPath:"davinci.usersettings/logout"}]},{id:"explorerActions",visible:true,actions:[{id:"davinci.ui.rename",label:"Rename...",iconClass:"renameIcon",run:function(){
_1393(["./ui/Resource"],function(r){
r.renameAction();
});
},isEnabled:function(item){
return _1393("./ui/Resource").canModify(item);
},menubarPath:"addFiles"},{id:"davinci.ui.delete",label:"Delete",iconClass:"deleteIcon",isEnabled:function(item){
return _1393("./ui/Resource").canModify(item);
},run:function(){
_1393(["./ui/Resource"],function(r){
r.deleteAction();
});
},menubarPath:"delete",keyBinding:{charOrCode:[dojo.keys.DELETE,dojo.keys.BACKSPACE]}},{id:"davinci.ui.download",label:"Download",iconClass:"downloadSomeIcon",action:"davinci/actions/DownloadAction",isEnabled:function(item){
return _1393("./ui/Resource").canModify(item);
},menubarPath:"delete"}]}],"davinci.actionSetPartAssociations":[{targetID:"davinci.ui.editorActions",parts:["davinci.ui.editorMenuBar"]},{targetID:"davinci.ui.explorerActions",parts:["davinci.ui.navigator"]}],"davinci.viewActions":[{viewContribution:{targetID:"davinci.ui.problems",actions:[{id:"Copy2",iconClass:"copyIcon",run:function(){
alert("view toolbar");
},label:"Copy",toolbarPath:"davinci.toolbar.main/edit",menubarPath:"davinci.edit/cut"}]}},{viewContribution:{targetID:"workbench.Explorer",actions:[{id:"davinci.ui.newfile",label:"New folder...",iconClass:"newFolderIcon",className:"FilesToolbarNewFolder",run:function(){
_1393(["./ui/Resource"],function(r){
r.newFolder();
});
},toolbarPath:"download"},{id:"davinci.ui.deletefile",label:"Delete file...",iconClass:"FilesToolbarDeleteFileIcon",className:"FilesToolbarDeleteFile",run:function(){
_1393(["./ui/Resource"],function(r){
r.deleteAction();
});
},toolbarPath:"download"},{id:"davinci.ui.renamefile",label:"Rename file...",iconClass:"FilesToolbarRenameFileIcon",className:"FilesToolbarRenameFile",run:function(){
_1393(["./ui/Resource"],function(r){
r.renameAction();
});
},toolbarPath:"download"},{id:"davinci.ui.addFiles",label:"Upload and Extract ZIP file...",iconClass:"uploadZipIcon",className:"FilesToolbarUploadZip",run:function(){
_1393(["./ui/Resource"],function(r){
r.addFilesZip();
});
},isEnabled:function(item){
return !item||_1393("./ui/Resource").canModify(item);
},toolbarPath:"download"},{id:"davinci.ui.addFiles",label:"Upload files...",iconClass:"uploadIcon",className:"FilesToolbarUploadFiles",run:function(){
_1393(["./ui/Resource"],function(r){
r.addFiles();
});
},isEnabled:function(item){
return !item||_1393("./ui/Resource").canModify(item);
},toolbarPath:"download"},{id:"download",iconClass:"downloadSomeIcon",className:"FilesToolbarDownloadSelected",run:function(){
_1393(["./Workbench","./ui/DownloadSelected"],function(_139c,_139d){
_139c.showModal(new _139d(),"Download",{width:440});
});
},label:"Download Selected Files",toolbarPath:"download"},{id:"download",iconClass:"downloadAllIcon",className:"FilesToolbarDownloadAll",run:function(){
_1393(["./Workbench","./ui/Download"],function(_139e,_139f){
_139e.showModal(new _139f(),"Download",{width:440});
});
},label:"Download Entire Project",toolbarPath:"download"}]}}]};
});
},"dojox/grid/_EditManager":function(){
define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/connect","dojo/_base/sniff","./util"],function(lang,array,_13a0,_13a1,has,util){
return _13a0("dojox.grid._EditManager",null,{constructor:function(_13a2){
this.grid=_13a2;
if(has("ie")){
this.connections=[_13a1.connect(document.body,"onfocus",lang.hitch(this,"_boomerangFocus"))];
}else{
this.connections=[_13a1.connect(this.grid,"onBlur",this,"apply")];
}
},info:{},destroy:function(){
array.forEach(this.connections,_13a1.disconnect);
},cellFocus:function(_13a3,_13a4){
if(this.grid.singleClickEdit||this.isEditRow(_13a4)){
this.setEditCell(_13a3,_13a4);
}else{
this.apply();
}
if(this.isEditing()||(_13a3&&_13a3.editable&&_13a3.alwaysEditing)){
this._focusEditor(_13a3,_13a4);
}
},rowClick:function(e){
if(this.isEditing()&&!this.isEditRow(e.rowIndex)){
this.apply();
}
},styleRow:function(inRow){
if(inRow.index==this.info.rowIndex){
inRow.customClasses+=" dojoxGridRowEditing";
}
},dispatchEvent:function(e){
var c=e.cell,ed=(c&&c["editable"])?c:0;
return ed&&ed.dispatchEvent(e.dispatch,e);
},isEditing:function(){
return this.info.rowIndex!==undefined;
},isEditCell:function(_13a5,_13a6){
return (this.info.rowIndex===_13a5)&&(this.info.cell.index==_13a6);
},isEditRow:function(_13a7){
return this.info.rowIndex===_13a7;
},setEditCell:function(_13a8,_13a9){
if(!this.isEditCell(_13a9,_13a8.index)&&this.grid.canEdit&&this.grid.canEdit(_13a8,_13a9)){
this.start(_13a8,_13a9,this.isEditRow(_13a9)||_13a8.editable);
}
},_focusEditor:function(_13aa,_13ab){
util.fire(_13aa,"focus",[_13ab]);
},focusEditor:function(){
if(this.isEditing()){
this._focusEditor(this.info.cell,this.info.rowIndex);
}
},_boomerangWindow:500,_shouldCatchBoomerang:function(){
return this._catchBoomerang>new Date().getTime();
},_boomerangFocus:function(){
if(this._shouldCatchBoomerang()){
this.grid.focus.focusGrid();
this.focusEditor();
this._catchBoomerang=0;
}
},_doCatchBoomerang:function(){
if(has("ie")){
this._catchBoomerang=new Date().getTime()+this._boomerangWindow;
}
},start:function(_13ac,_13ad,_13ae){
if(!this._isValidInput()){
return;
}
this.grid.beginUpdate();
this.editorApply();
if(this.isEditing()&&!this.isEditRow(_13ad)){
this.applyRowEdit();
this.grid.updateRow(_13ad);
}
if(_13ae){
this.info={cell:_13ac,rowIndex:_13ad};
this.grid.doStartEdit(_13ac,_13ad);
this.grid.updateRow(_13ad);
}else{
this.info={};
}
this.grid.endUpdate();
this.grid.focus.focusGrid();
this._focusEditor(_13ac,_13ad);
this._doCatchBoomerang();
},_editorDo:function(_13af){
var c=this.info.cell;
if(c&&c.editable){
c[_13af](this.info.rowIndex);
}
},editorApply:function(){
this._editorDo("apply");
},editorCancel:function(){
this._editorDo("cancel");
},applyCellEdit:function(_13b0,_13b1,_13b2){
if(this.grid.canEdit(_13b1,_13b2)){
this.grid.doApplyCellEdit(_13b0,_13b2,_13b1.field);
}
},applyRowEdit:function(){
this.grid.doApplyEdit(this.info.rowIndex,this.info.cell.field);
},apply:function(){
if(this.isEditing()&&this._isValidInput()){
this.grid.beginUpdate();
this.editorApply();
this.applyRowEdit();
this.info={};
this.grid.endUpdate();
this.grid.focus.focusGrid();
this._doCatchBoomerang();
}
},cancel:function(){
if(this.isEditing()){
this.grid.beginUpdate();
this.editorCancel();
this.info={};
this.grid.endUpdate();
this.grid.focus.focusGrid();
this._doCatchBoomerang();
}
},save:function(_13b3,_13b4){
var c=this.info.cell;
if(this.isEditRow(_13b3)&&(!_13b4||c.view==_13b4)&&c.editable){
c.save(c,this.info.rowIndex);
}
},restore:function(_13b5,_13b6){
var c=this.info.cell;
if(this.isEditRow(_13b6)&&c.view==_13b5&&c.editable){
c.restore(this.info.rowIndex);
}
},_isValidInput:function(){
var w=(this.info.cell||{}).widget;
if(!w||!w.isValid){
return true;
}
w.focused=true;
return w.isValid(true);
}});
});
},"davinci/js/JSElement":function(){
define(["dojo/_base/declare","davinci/js/JSModel"],function(_13b7,_13b8){
var _13b9=null;
var _13ba=null;
return _13b7("davinci.js.JSElement",_13b8,{constructor:function(){
this.elementType="JSElement";
if(_13b9!==null){
this.comment=_13b9;
_13b9=null;
}
if(_13ba!==null){
this.label=_13ba;
_13ba=null;
}
},printNewLine:function(_13bb){
var s="\n";
for(var i=0;i<_13bb.indent;i++){
s=s+" ";
}
return s;
},printStatement:function(_13bc,stmt){
return this.printNewLine(_13bc)+stmt.getText(_13bc)+(stmt.nosemicolon?"":";");
},add:function(e){
this.addChild(e);
},init:function(start,stop,name){
},getLabel:function(){
context={};
context.indent=0;
return this.getText(context);
},getID:function(){
return this.parent.getID()+":"+this.startLine+":"+this.getLabel();
},getSyntaxPositions:function(_13bd){
var _13be=[];
function add(line,col,_13bf,type){
if((typeof _13bd=="undefined")||_13bd==line){
_13be.push({line:line,col:col,length:_13bf,type:type});
}
};
function add2(pos,_13c0,type){
if((typeof _13bd=="undefined")||_13bd==pos[0]){
_13be.push({line:pos[0],col:pos[1],length:_13c0,type:type});
}
};
var _13c1={visit:function(node){
if(node.elementType=="JSFunction"){
add(node.startLine,node.startCol,8,"keyword");
add2(node.leftParenPos,1,"delimiter");
add2(node.rightParenPos,1,"delimiter");
add2(node.leftBracePos,1,"delimiter");
add2(node.rightBracePos,1,"delimiter");
}else{
if(node.elementType=="JSVariableDeclaration"){
add(node.startLine,node.startCol,3,"keyword");
}else{
if(node.elementType=="JSVariableFragment"){
if(node.equalPos){
add2(node.equalPos,1,"operator");
}else{
add(node.startLine,node.startCol,1,"name");
}
}else{
if(node.elementType=="JSNameReference"){
add(node.startLine,node.startCol,node.endCol-node.startCol,"name");
}
}
}
}
},endVisit:function(node){
return true;
}};
this.visit(_13c1);
return _13be;
}});
});
},"dojo/data/util/sorter":function(){
define(["../../_base/lang"],function(lang){
var _13c2={};
lang.setObject("dojo.data.util.sorter",_13c2);
_13c2.basicComparator=function(a,b){
var r=-1;
if(a===null){
a=undefined;
}
if(b===null){
b=undefined;
}
if(a==b){
r=0;
}else{
if(a>b||a==null){
r=1;
}
}
return r;
};
_13c2.createSortFunction=function(_13c3,store){
var _13c4=[];
function _13c5(attr,dir,comp,s){
return function(itemA,itemB){
var a=s.getValue(itemA,attr);
var b=s.getValue(itemB,attr);
return dir*comp(a,b);
};
};
var _13c6;
var map=store.comparatorMap;
var bc=_13c2.basicComparator;
for(var i=0;i<_13c3.length;i++){
_13c6=_13c3[i];
var attr=_13c6.attribute;
if(attr){
var dir=(_13c6.descending)?-1:1;
var comp=bc;
if(map){
if(typeof attr!=="string"&&("toString" in attr)){
attr=attr.toString();
}
comp=map[attr]||bc;
}
_13c4.push(_13c5(attr,dir,comp,store));
}
}
return function(rowA,rowB){
var i=0;
while(i<_13c4.length){
var ret=_13c4[i++](rowA,rowB);
if(ret!==0){
return ret;
}
}
return 0;
};
};
return _13c2;
});
},"dijit/form/_ButtonMixin":function(){
define(["dojo/_base/declare","dojo/dom","dojo/_base/event","../registry"],function(_13c7,dom,event,_13c8){
return _13c7("dijit.form._ButtonMixin",null,{label:"",type:"button",_onClick:function(e){
if(this.disabled){
event.stop(e);
return false;
}
var _13c9=this.onClick(e)===false;
if(!_13c9&&this.type=="submit"&&!(this.valueNode||this.focusNode).form){
for(var node=this.domNode;node.parentNode;node=node.parentNode){
var _13ca=_13c8.byNode(node);
if(_13ca&&typeof _13ca._onSubmit=="function"){
_13ca._onSubmit(e);
_13c9=true;
break;
}
}
}
if(_13c9){
e.preventDefault();
}
return !_13c9;
},postCreate:function(){
this.inherited(arguments);
dom.setSelectable(this.focusNode,false);
},onClick:function(){
return true;
},_setLabelAttr:function(_13cb){
this._set("label",_13cb);
(this.containerNode||this.focusNode).innerHTML=_13cb;
}});
});
},"dojo/colors":function(){
define(["./_base/kernel","./_base/lang","./_base/Color","./_base/array"],function(dojo,lang,Color,_13cc){
var _13cd={};
lang.setObject("dojo.colors",_13cd);
var _13ce=function(m1,m2,h){
if(h<0){
++h;
}
if(h>1){
--h;
}
var h6=6*h;
if(h6<1){
return m1+(m2-m1)*h6;
}
if(2*h<1){
return m2;
}
if(3*h<2){
return m1+(m2-m1)*(2/3-h)*6;
}
return m1;
};
dojo.colorFromRgb=Color.fromRgb=function(color,obj){
var m=color.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);
if(m){
var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;
if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){
var r=c[0];
if(r.charAt(r.length-1)=="%"){
a=_13cc.map(c,function(x){
return parseFloat(x)*2.56;
});
if(l==4){
a[3]=c[3];
}
return Color.fromArray(a,obj);
}
return Color.fromArray(c,obj);
}
if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){
var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;
a=[_13ce(m1,m2,H+1/3)*256,_13ce(m1,m2,H)*256,_13ce(m1,m2,H-1/3)*256,1];
if(l==4){
a[3]=c[3];
}
return Color.fromArray(a,obj);
}
}
return null;
};
var _13cf=function(c,low,high){
c=Number(c);
return isNaN(c)?high:c<low?low:c>high?high:c;
};
Color.prototype.sanitize=function(){
var t=this;
t.r=Math.round(_13cf(t.r,0,255));
t.g=Math.round(_13cf(t.g,0,255));
t.b=Math.round(_13cf(t.b,0,255));
t.a=_13cf(t.a,0,1);
return this;
};
_13cd.makeGrey=Color.makeGrey=function(g,a){
return Color.fromArray([g,g,g,a]);
};
lang.mixin(Color.named,{"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"blanchedalmond":[255,235,205],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"oldlace":[253,245,230],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"whitesmoke":[245,245,245],"yellowgreen":[154,205,50]});
return Color;
});
},"url:davinci/review/widgets/templates/PublishWizard.html":"<div class='publishWizard'>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<div class='steps'>\n\t\t\t<div dojoAttachPoint=\"navPage1\" dojoAttachEvent=\"onclick:select\" class=\"crumbs current sep\">\n\t\t\t\t<div dojoAttachPoint=\"navPage1Icon\" class=\"done\"></div>\n\t\t\t\t1.${generalInfo}\n\t\t\t</div>\n\t\t\t<div dojoAttachPoint=\"navPage2\" dojoAttachEvent=\"onclick:select\" class=\"crumbs sep\">\n\t\t\t\t<div dojoAttachPoint=\"navPage2Icon\" class=\"todo\"></div>\n\t\t\t\t2.${selectRevFiles}\n\t\t\t</div>\n\t\t\t<div dojoAttachPoint=\"navPage3\" dojoAttachEvent=\"onclick:select\" class=\"crumbs\">\n\t\t\t\t<div dojoAttachPoint=\"navPage3Icon\" class=\"todo\"></div>\n\t\t\t\t3.${addReviewers}\n\t\t\t</div>\n\t\t</div>\n\t\t<div dojoAttachPoint=\"reviewerStackContainer\" class='mainSection'>\n\t\t</div>\n\t\t<table cellspacing=\"10\" dojoAttachPoint=\"page1Node\">\n\t\t\t<tr>\n\t\t\t\t<td><label for=\"versionTitle\">${title}:</label></td>\n\t\t\t\t<td><input dojoAttachPoint=\"versionTitle\"></input></td>\n\t\t\t\t<td><input dojoAttachPoint=\"receiveEmail\"></input><label class='emailLabel' for=\"receiveEmail\">${notifyMe}</label></td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td valign=\"top\"><label for=\"descriptions\">${description}:</label></td>\n\t\t\t\t<td colspan=\"2\"><input dojoAttachPoint=\"descriptions\"></input></td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><label>${windowSize}:</label></td>\n\t\t\t\t<td colspan=\"2\"><input dojoAttachPoint=\"desireWidth\"></input><label>*</label><input dojoAttachPoint=\"desireHeight\"/></td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><label for=\"dueDate\">${dueDate}:</label></td>\n\t\t\t\t<td><input dojoAttachPoint=\"dueDate\" /></td>\n\t\t\t\t<td class=\"review-tips\"><label>${leaveBlank}</label></td>\n\t\t\t</tr>\n\t\t</table>\n\t\t\n\t\t<table cellspacing=\"10\" dojoAttachPoint=\"page2Node\">\n\t\t\t<tr>\n\t\t\t\t<td>${availableFiles}:</td>\n\t\t\t\t<td></td>\n\t\t\t\t<td>${selectedFiles}:</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td>\n\t\t\t\t\t<div dojoAttachPoint=\"sourceTreeNode\" class='sourceTree'>\n\t\t\t\t\t\t\n\t\t\t\t\t</div>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<a href=\"javascript:void(0);\" dojoAttachEvent=\"onclick:addSelectFiles\"><img src=\"app/davinci/review/resources/img/forward_nav.gif\"/></a>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<div dojoAttachPoint=\"targetTreeNode\" class='sourceTree'>\n\t\t\t\t\t\n\t\t\t\t\t</div>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t</table>\n\t\t\n\t\t<table cellspacing=\"10\" dojoAttachPoint=\"page3Node\">\n\t\t\t<tr valign=\"top\">\n\t\t\t\t<td align=\"left\" rowspan=2><div class='reviewers'>${reviewers}:</div></td>\n\t\t\t\t<td colspan=2><div dojoAttachPoint=\"userGrid\" class='reviewerList'></div></td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td class='reviewerBox'>\n\t\t\t\t\t<div dojoAttachPoint=\"addReviewerCombox\"></div>\n\t\t\t\t</td>\n\t\t\t\t<td align=\"left\"><button dojoAttachPoint=\"addReviewerButton\"></button></td>\n\t\t\t</tr>\n\t\t</table>\n\t</div>\n\n\t\t<div class='dijitDialogPaneActionBar dialogButtonContainerOverride'>\n\t\t\t<div dojoAttachPoint=\"reviewMsg\" class=\"reviewMsg\"></div>\n\t\t\t<a class='cancelButton' href=\"javascript:void(0);\" dojoAttachEvent=\"onclick:onClose\">${buttonCancel}</a>\n\t\t\t<button class='maqSecondaryButton' dojoAttachPoint=\"saveDt\">${saveAsDraft}</button>\n\t\t\t<button class='maqSecondaryButton' dojoAttachPoint=\"prev\">&lt ${back}</button>\n\t\t\t<button class='maqSecondaryButton' dojoAttachPoint=\"next\">${next} &gt</button>\n\t\t\t<button class='maqPrimaryButton' dojoAttachPoint=\"invite\">${publishReview}</button>\n\t\t</div>\n</div>","dojo/date/locale":function(){
define(["../_base/lang","../_base/array","../date","../cldr/supplemental","../i18n","../regexp","../string","../i18n!../cldr/nls/gregorian","module"],function(lang,array,date,_13d0,i18n,_13d1,_13d2,_13d3,_13d4){
var _13d5={};
lang.setObject(_13d4.id.replace(/\//g,"."),_13d5);
function _13d6(_13d7,_13d8,_13d9,_13da){
return _13da.replace(/([a-z])\1*/ig,function(match){
var s,pad,c=match.charAt(0),l=match.length,_13db=["abbr","wide","narrow"];
switch(c){
case "G":
s=_13d8[(l<4)?"eraAbbr":"eraNames"][_13d7.getFullYear()<0?0:1];
break;
case "y":
s=_13d7.getFullYear();
switch(l){
case 1:
break;
case 2:
if(!_13d9.fullYear){
s=String(s);
s=s.substr(s.length-2);
break;
}
default:
pad=true;
}
break;
case "Q":
case "q":
s=Math.ceil((_13d7.getMonth()+1)/3);
pad=true;
break;
case "M":
case "L":
var m=_13d7.getMonth();
if(l<3){
s=m+1;
pad=true;
}else{
var propM=["months",c=="L"?"standAlone":"format",_13db[l-3]].join("-");
s=_13d8[propM][m];
}
break;
case "w":
var _13dc=0;
s=_13d5._getWeekOfYear(_13d7,_13dc);
pad=true;
break;
case "d":
s=_13d7.getDate();
pad=true;
break;
case "D":
s=_13d5._getDayOfYear(_13d7);
pad=true;
break;
case "e":
case "c":
var d=_13d7.getDay();
if(l<2){
s=(d-_13d0.getFirstDayOfWeek(_13d9.locale)+8)%7;
break;
}
case "E":
d=_13d7.getDay();
if(l<3){
s=d+1;
pad=true;
}else{
var propD=["days",c=="c"?"standAlone":"format",_13db[l-3]].join("-");
s=_13d8[propD][d];
}
break;
case "a":
var _13dd=_13d7.getHours()<12?"am":"pm";
s=_13d9[_13dd]||_13d8["dayPeriods-format-wide-"+_13dd];
break;
case "h":
case "H":
case "K":
case "k":
var h=_13d7.getHours();
switch(c){
case "h":
s=(h%12)||12;
break;
case "H":
s=h;
break;
case "K":
s=(h%12);
break;
case "k":
s=h||24;
break;
}
pad=true;
break;
case "m":
s=_13d7.getMinutes();
pad=true;
break;
case "s":
s=_13d7.getSeconds();
pad=true;
break;
case "S":
s=Math.round(_13d7.getMilliseconds()*Math.pow(10,l-3));
pad=true;
break;
case "v":
case "z":
s=_13d5._getZone(_13d7,true,_13d9);
if(s){
break;
}
l=4;
case "Z":
var _13de=_13d5._getZone(_13d7,false,_13d9);
var tz=[(_13de<=0?"+":"-"),_13d2.pad(Math.floor(Math.abs(_13de)/60),2),_13d2.pad(Math.abs(_13de)%60,2)];
if(l==4){
tz.splice(0,0,"GMT");
tz.splice(3,0,":");
}
s=tz.join("");
break;
default:
throw new Error("dojo.date.locale.format: invalid pattern char: "+_13da);
}
if(pad){
s=_13d2.pad(s,l);
}
return s;
});
};
_13d5._getZone=function(_13df,_13e0,_13e1){
if(_13e0){
return date.getTimezoneName(_13df);
}else{
return _13df.getTimezoneOffset();
}
};
_13d5.format=function(_13e2,_13e3){
_13e3=_13e3||{};
var _13e4=i18n.normalizeLocale(_13e3.locale),_13e5=_13e3.formatLength||"short",_13e6=_13d5._getGregorianBundle(_13e4),str=[],sauce=lang.hitch(this,_13d6,_13e2,_13e6,_13e3);
if(_13e3.selector=="year"){
return _13e7(_13e6["dateFormatItem-yyyy"]||"yyyy",sauce);
}
var _13e8;
if(_13e3.selector!="date"){
_13e8=_13e3.timePattern||_13e6["timeFormat-"+_13e5];
if(_13e8){
str.push(_13e7(_13e8,sauce));
}
}
if(_13e3.selector!="time"){
_13e8=_13e3.datePattern||_13e6["dateFormat-"+_13e5];
if(_13e8){
str.push(_13e7(_13e8,sauce));
}
}
return str.length==1?str[0]:_13e6["dateTimeFormat-"+_13e5].replace(/\'/g,"").replace(/\{(\d+)\}/g,function(match,key){
return str[key];
});
};
_13d5.regexp=function(_13e9){
return _13d5._parseInfo(_13e9).regexp;
};
_13d5._parseInfo=function(_13ea){
_13ea=_13ea||{};
var _13eb=i18n.normalizeLocale(_13ea.locale),_13ec=_13d5._getGregorianBundle(_13eb),_13ed=_13ea.formatLength||"short",_13ee=_13ea.datePattern||_13ec["dateFormat-"+_13ed],_13ef=_13ea.timePattern||_13ec["timeFormat-"+_13ed],_13f0;
if(_13ea.selector=="date"){
_13f0=_13ee;
}else{
if(_13ea.selector=="time"){
_13f0=_13ef;
}else{
_13f0=_13ec["dateTimeFormat-"+_13ed].replace(/\{(\d+)\}/g,function(match,key){
return [_13ef,_13ee][key];
});
}
}
var _13f1=[],re=_13e7(_13f0,lang.hitch(this,_13f2,_13f1,_13ec,_13ea));
return {regexp:re,tokens:_13f1,bundle:_13ec};
};
_13d5.parse=function(value,_13f3){
var _13f4=/[\u200E\u200F\u202A\u202E]/g,info=_13d5._parseInfo(_13f3),_13f5=info.tokens,_13f6=info.bundle,re=new RegExp("^"+info.regexp.replace(_13f4,"")+"$",info.strict?"":"i"),match=re.exec(value&&value.replace(_13f4,""));
if(!match){
return null;
}
var _13f7=["abbr","wide","narrow"],_13f8=[1970,0,1,0,0,0,0],amPm="",valid=array.every(match,function(v,i){
if(!i){
return true;
}
var token=_13f5[i-1],l=token.length,c=token.charAt(0);
switch(c){
case "y":
if(l!=2&&_13f3.strict){
_13f8[0]=v;
}else{
if(v<100){
v=Number(v);
var year=""+new Date().getFullYear(),_13f9=year.substring(0,2)*100,_13fa=Math.min(Number(year.substring(2,4))+20,99);
_13f8[0]=(v<_13fa)?_13f9+v:_13f9-100+v;
}else{
if(_13f3.strict){
return false;
}
_13f8[0]=v;
}
}
break;
case "M":
case "L":
if(l>2){
var _13fb=_13f6["months-"+(c=="L"?"standAlone":"format")+"-"+_13f7[l-3]].concat();
if(!_13f3.strict){
v=v.replace(".","").toLowerCase();
_13fb=array.map(_13fb,function(s){
return s.replace(".","").toLowerCase();
});
}
v=array.indexOf(_13fb,v);
if(v==-1){
return false;
}
}else{
v--;
}
_13f8[1]=v;
break;
case "E":
case "e":
case "c":
var days=_13f6["days-"+(c=="c"?"standAlone":"format")+"-"+_13f7[l-3]].concat();
if(!_13f3.strict){
v=v.toLowerCase();
days=array.map(days,function(d){
return d.toLowerCase();
});
}
v=array.indexOf(days,v);
if(v==-1){
return false;
}
break;
case "D":
_13f8[1]=0;
case "d":
_13f8[2]=v;
break;
case "a":
var am=_13f3.am||_13f6["dayPeriods-format-wide-am"],pm=_13f3.pm||_13f6["dayPeriods-format-wide-pm"];
if(!_13f3.strict){
var _13fc=/\./g;
v=v.replace(_13fc,"").toLowerCase();
am=am.replace(_13fc,"").toLowerCase();
pm=pm.replace(_13fc,"").toLowerCase();
}
if(_13f3.strict&&v!=am&&v!=pm){
return false;
}
amPm=(v==pm)?"p":(v==am)?"a":"";
break;
case "K":
if(v==24){
v=0;
}
case "h":
case "H":
case "k":
if(v>23){
return false;
}
_13f8[3]=v;
break;
case "m":
_13f8[4]=v;
break;
case "s":
_13f8[5]=v;
break;
case "S":
_13f8[6]=v;
}
return true;
});
var hours=+_13f8[3];
if(amPm==="p"&&hours<12){
_13f8[3]=hours+12;
}else{
if(amPm==="a"&&hours==12){
_13f8[3]=0;
}
}
var _13fd=new Date(_13f8[0],_13f8[1],_13f8[2],_13f8[3],_13f8[4],_13f8[5],_13f8[6]);
if(_13f3.strict){
_13fd.setFullYear(_13f8[0]);
}
var _13fe=_13f5.join(""),_13ff=_13fe.indexOf("d")!=-1,_1400=_13fe.indexOf("M")!=-1;
if(!valid||(_1400&&_13fd.getMonth()>_13f8[1])||(_13ff&&_13fd.getDate()>_13f8[2])){
return null;
}
if((_1400&&_13fd.getMonth()<_13f8[1])||(_13ff&&_13fd.getDate()<_13f8[2])){
_13fd=date.add(_13fd,"hour",1);
}
return _13fd;
};
function _13e7(_1401,_1402,_1403,_1404){
var _1405=function(x){
return x;
};
_1402=_1402||_1405;
_1403=_1403||_1405;
_1404=_1404||_1405;
var _1406=_1401.match(/(''|[^'])+/g),_1407=_1401.charAt(0)=="'";
array.forEach(_1406,function(chunk,i){
if(!chunk){
_1406[i]="";
}else{
_1406[i]=(_1407?_1403:_1402)(chunk.replace(/''/g,"'"));
_1407=!_1407;
}
});
return _1404(_1406.join(""));
};
function _13f2(_1408,_1409,_140a,_140b){
_140b=_13d1.escapeString(_140b);
if(!_140a.strict){
_140b=_140b.replace(" a"," ?a");
}
return _140b.replace(/([a-z])\1*/ig,function(match){
var s,c=match.charAt(0),l=match.length,p2="",p3="";
if(_140a.strict){
if(l>1){
p2="0"+"{"+(l-1)+"}";
}
if(l>2){
p3="0"+"{"+(l-2)+"}";
}
}else{
p2="0?";
p3="0{0,2}";
}
switch(c){
case "y":
s="\\d{2,4}";
break;
case "M":
case "L":
s=(l>2)?"\\S+?":"1[0-2]|"+p2+"[1-9]";
break;
case "D":
s="[12][0-9][0-9]|3[0-5][0-9]|36[0-6]|"+p2+"[1-9][0-9]|"+p3+"[1-9]";
break;
case "d":
s="3[01]|[12]\\d|"+p2+"[1-9]";
break;
case "w":
s="[1-4][0-9]|5[0-3]|"+p2+"[1-9]";
break;
case "E":
case "e":
case "c":
s="\\S+";
break;
case "h":
s="1[0-2]|"+p2+"[1-9]";
break;
case "k":
s="1[01]|"+p2+"\\d";
break;
case "H":
s="1\\d|2[0-3]|"+p2+"\\d";
break;
case "K":
s="1\\d|2[0-4]|"+p2+"[1-9]";
break;
case "m":
case "s":
s="[0-5]\\d";
break;
case "S":
s="\\d{"+l+"}";
break;
case "a":
var am=_140a.am||_1409["dayPeriods-format-wide-am"],pm=_140a.pm||_1409["dayPeriods-format-wide-pm"];
s=am+"|"+pm;
if(!_140a.strict){
if(am!=am.toLowerCase()){
s+="|"+am.toLowerCase();
}
if(pm!=pm.toLowerCase()){
s+="|"+pm.toLowerCase();
}
if(s.indexOf(".")!=-1){
s+="|"+s.replace(/\./g,"");
}
}
s=s.replace(/\./g,"\\.");
break;
default:
s=".*";
}
if(_1408){
_1408.push(match);
}
return "("+s+")";
}).replace(/[\xa0 ]/g,"[\\s\\xa0]");
};
var _140c=[];
_13d5.addCustomFormats=function(_140d,_140e){
_140c.push({pkg:_140d,name:_140e});
};
_13d5._getGregorianBundle=function(_140f){
var _1410={};
array.forEach(_140c,function(desc){
var _1411=i18n.getLocalization(desc.pkg,desc.name,_140f);
_1410=lang.mixin(_1410,_1411);
},this);
return _1410;
};
_13d5.addCustomFormats(_13d4.id.replace(/\/date\/locale$/,".cldr"),"gregorian");
_13d5.getNames=function(item,type,_1412,_1413){
var label,_1414=_13d5._getGregorianBundle(_1413),props=[item,_1412,type];
if(_1412=="standAlone"){
var key=props.join("-");
label=_1414[key];
if(label[0]==1){
label=undefined;
}
}
props[1]="format";
return (label||_1414[props.join("-")]).concat();
};
_13d5.isWeekend=function(_1415,_1416){
var _1417=_13d0.getWeekend(_1416),day=(_1415||new Date()).getDay();
if(_1417.end<_1417.start){
_1417.end+=7;
if(day<_1417.start){
day+=7;
}
}
return day>=_1417.start&&day<=_1417.end;
};
_13d5._getDayOfYear=function(_1418){
return date.difference(new Date(_1418.getFullYear(),0,1,_1418.getHours()),_1418)+1;
};
_13d5._getWeekOfYear=function(_1419,_141a){
if(arguments.length==1){
_141a=0;
}
var _141b=new Date(_1419.getFullYear(),0,1).getDay(),adj=(_141b-_141a+7)%7,week=Math.floor((_13d5._getDayOfYear(_1419)+adj-1)/7);
if(_141b==_141a){
week++;
}
return week;
};
return _13d5;
});
},"dijit/tree/_dndContainer":function(){
define(["dojo/aspect","dojo/_base/declare","dojo/dom-class","dojo/_base/event","dojo/_base/lang","dojo/on","dojo/touch"],function(_141c,_141d,_141e,event,lang,on,touch){
return _141d("dijit.tree._dndContainer",null,{constructor:function(tree,_141f){
this.tree=tree;
this.node=tree.domNode;
lang.mixin(this,_141f);
this.current=null;
this.containerState="";
_141e.add(this.node,"dojoDndContainer");
this.events=[on(this.node,touch.enter,lang.hitch(this,"onOverEvent")),on(this.node,touch.leave,lang.hitch(this,"onOutEvent")),_141c.after(this.tree,"_onNodeMouseEnter",lang.hitch(this,"onMouseOver"),true),_141c.after(this.tree,"_onNodeMouseLeave",lang.hitch(this,"onMouseOut"),true),on(this.node,"dragstart",lang.hitch(event,"stop")),on(this.node,"selectstart",lang.hitch(event,"stop"))];
},destroy:function(){
var h;
while(h=this.events.pop()){
h.remove();
}
this.node=this.parent=null;
},onMouseOver:function(_1420){
this.current=_1420;
},onMouseOut:function(){
this.current=null;
},_changeState:function(type,_1421){
var _1422="dojoDnd"+type;
var state=type.toLowerCase()+"State";
_141e.replace(this.node,_1422+_1421,_1422+this[state]);
this[state]=_1421;
},_addItemClass:function(node,type){
_141e.add(node,"dojoDndItem"+type);
},_removeItemClass:function(node,type){
_141e.remove(node,"dojoDndItem"+type);
},onOverEvent:function(){
this._changeState("Container","Over");
},onOutEvent:function(){
this._changeState("Container","");
}});
});
},"url:dojox/grid/resources/View.html":"<div class=\"dojoxGridView\" role=\"presentation\">\n\t<div class=\"dojoxGridHeader\" dojoAttachPoint=\"headerNode\" role=\"presentation\">\n\t\t<div dojoAttachPoint=\"headerNodeContainer\" style=\"width:9000em\" role=\"presentation\">\n\t\t\t<div dojoAttachPoint=\"headerContentNode\" role=\"row\"></div>\n\t\t</div>\n\t</div>\n\t<input type=\"checkbox\" class=\"dojoxGridHiddenFocus\" dojoAttachPoint=\"hiddenFocusNode\" role=\"presentation\" />\n\t<input type=\"checkbox\" class=\"dojoxGridHiddenFocus\" role=\"presentation\" />\n\t<div class=\"dojoxGridScrollbox\" dojoAttachPoint=\"scrollboxNode\" role=\"presentation\">\n\t\t<div class=\"dojoxGridContent\" dojoAttachPoint=\"contentNode\" hidefocus=\"hidefocus\" role=\"presentation\"></div>\n\t</div>\n</div>\n","davinci/Theme":function(){
define(["dojo/_base/declare","dojo/promise/all","./Workbench","./Runtime","./library","./workbench/Preferences","./model/Path","./html/HTMLFile","./model/Factory","system/resource"],function(_1423,all,_1424,_1425,_1426,_1427,Path,_1428,_1429,_142a){
var Theme={TEMP_CLONE_PRE:"clone_",desktop_default:"desktop_default",mobile_default:"custom_default",default_theme:"(device-specific)",none_themeset_name:"(none)",other_device:"other",none_theme:"none",dojoMobileDefault:[{"theme":"android","device":"Android"},{"theme":"blackberry","device":"BlackBerry"},{"theme":"ipad","device":"iPad"},{"theme":"iphone","device":"iPhone"},{"theme":"iphone","device":"other"}],dojoMobileCustom:[{"theme":"custom","device":"Android"},{"theme":"custom","device":"BlackBerry"},{"theme":"custom","device":"iPad"},{"theme":"custom","device":"iPhone"},{"theme":"custom","device":"other"}],isThemeHTML:function(_142b){
return _142b.getName().indexOf("dojo-theme-editor.html")>-1;
},CloneTheme:function(name,_142c,_142d,_142e,_142f,_1430){
var _1431=[];
var _1432=_142f.getFile().parent;
var _1433=new Path(_142e).removeLastSegments(0);
var _1434=_142a.findResource(_1433.toString());
if(_1434.readOnly()){
_1434.createResource();
}
_142a.createResource(_142e,true);
var _1435=_142a.findResource(_142e);
var _1436=_142f.getFile().getName();
var _1437=new Path(_1435.getPath());
var _1438=_1437.lastSegment();
var _1439=_1435.createResource(_1438+".theme");
var _143a=_1435.createResource(_1438+".css");
var _143b=this.getThemeLocation();
var _143c=_142f.getFile().parent.getPath();
function _143d(_143e){
var ret=[];
_143e.forEach(function(_143f){
var file=_142a.findResource(_143c+"/"+_143f);
var _1440=new Path(file.getPath());
var _1441=_1440.relativeTo("./"+_143b,true);
var _1442="..";
for(var i=0;i<_1441.segments.length;i++){
_1442=_1442+"/"+_1441.segments[i];
}
ret.push(_1442);
});
return ret;
};
var _1443=_143d(_142f.themeEditorHtmls);
var meta=_143d(_142f.meta);
var _1444=_143d(_142f.files);
var _1445=" ";
_1444.forEach(function(_1446){
_1445=_1445+"@import url(\""+_1446+"\");";
});
var _1447={className:_142f.className,name:name,version:_142c||_142f.version,specVersion:_142f.specVersion,files:[""+_1438+".css"],meta:meta,themeEditorHtmls:_1443,useBodyFontBackgroundClass:_142f.useBodyFontBackgroundClass};
if(_142f.helper){
if(_142f.helper.declaredClass){
_1447.helper=_142f.helper.declaredClass;
}else{
_1447.helper=_142f.helper;
}
}
if(_142f.base){
_1447.base=_142f.base;
}
if(_142f.type){
_1447.type=_142f.type;
}
if(_142f.conditionalFiles){
_1447.conditionalFiles=_142f.conditionalFiles;
var _1448=_143d(_142f.conditionalFiles);
for(var i=0;i<_1447.conditionalFiles.length;i++){
var _1449=_1435.createResource(_1447.conditionalFiles[i]);
_1431.push(_1449.setContents("@import url(\""+_1448[i]+"\");"));
}
}
var d=_1439.setContents(JSON.stringify(_1447));
d.themeFile=_1439;
_1431.push(d);
_1431.push(_143a.setContents(_1445));
var ret={promise:all(_1431),themeFile:_1439};
return ret;
},getHelper:function(theme){
if(!theme){
return;
}
if(theme.helper&&typeof (theme.helper)!="string"){
return theme.helper;
}
var _144a=theme.helper;
if(_144a){
var _144b=new dojo.Deferred();
require([_144a],function(_144c){
_144c.declaredClass=_144a;
_144a=_144c;
_144b.resolve({helper:_144a});
});
return _144b;
}
},getThemeSet:function(_144d){
var _144e=Theme.getThemeSets(_1424.getProject()),_144f=dojo.clone(this.dojoMobileDefault),_1450;
if(!_144e){
_144e=this.dojoThemeSets;
}
_144e=dojo.clone(_144e);
if(_144d){
var _1451=_144d._getDojoJsElem().getAttribute("data-dojo-config");
if(_1451){
_1451=require.eval("({ "+_1451+" })","data-dojo-config");
if(_1451.themeMap){
_144f=Theme.getDojoxMobileThemesFromThemeMap(_144d,_1451.themeMap);
}
}
var _1452=_144d.getTheme();
for(var s=0,len=_144e.themeSets.length;s<len;s++){
_1450=_144e.themeSets[s];
if(_1450.desktopTheme===_1452.name){
if(this.themeSetEquals(_144f,_1450.mobileTheme)){
return _1450;
}
}
}
}
_1450={name:this.none_themeset_name,desktopTheme:_144d?_1452.name:"claro",mobileTheme:_144f};
_144e.themeSets.push(_1450);
return _1450;
},getBase:function(){
if(_1424.singleProjectMode()){
return _1424.getProject();
}
},getThemeLocation:function(){
var base=this.getBase();
var prefs=_1427.getPreferences("davinci.ui.ProjectPrefs",base);
var _1453=(new Path(base).append(prefs["themeFolder"]));
return _1453;
},getTheme:function(name,_1454){
var _1455=_1426.getThemes(_1424.getProject(),this.workspaceOnly);
for(var i=0;i<_1455.length;i++){
if(_1455[i]&&_1455[i].name===name){
return _1455[i];
}
}
},getThemeByCssFile:function(_1456){
var _1457=_1426.getThemes(_1424.getProject(),this.workspaceOnly);
var _1458=_142a.findResource(_1456.url).getPath();
for(var i=0;i<_1457.length;i++){
var _1459=_1457[i].getFile();
var path=_1459.getParentFolder().getPath();
for(var x=0;x<_1457[i].files.length;x++){
var _145a=path+"/"+_1457[i].files[x];
if(_145a===_1458){
return _1457[i];
}
}
}
return null;
},getDojoxMobileThemeMap:function(_145b,_145c){
var _145d=[];
var other=[".*","iphone",[]];
for(var i=0;i<_145c.length;i++){
if(_145c[i].theme!=this.none_theme&&_145c[i].theme!=this.default_theme){
var theme=this.getTheme(_145c[i].theme);
if(theme){
var _145e;
if(theme.path&&theme.path[0]){
var n=theme.path[0].lastIndexOf("/");
_145e=new Path(theme.path[0].substring(0,n+1)+theme.files[0]);
}else{
_145e=new Path(theme.getFile().parent.getPath()).append(theme.files[0]);
}
var _145f=_145b.getFullResourcePath();
var _1460=_145e.relativeTo(_145f,true).toString();
if(_145c[i].device===this.other_device){
other=[".*",theme.base,[_1460]];
}else{
_145d.push([_145c[i].device,theme.base,[_1460]]);
}
}
}
}
_145d.push(other);
return _145d;
},getDojoxMobileThemesFromThemeMap:function(_1461,_1462){
var _1463=_1426.getThemes(_1424.getProject(),this.workspaceOnly);
var _1464=[];
_1462.forEach(function(item,idx,arr){
for(var i=0;i<_1463.length;i++){
var theme=_1463[i];
var _1465=new Path(theme.getFile().parent.getPath()).append(theme.files[0]);
var _1466=_1461.getFullResourcePath();
var _1467=_1465.relativeTo(_1466,true).toString();
if(_1467==item[2][0]){
var o={};
o.device=item[0];
o.theme=theme.name;
if(o.device===".*"){
o.device="other";
}
_1464.push(o);
break;
}
}
},this);
return _1464;
},themeSetEquals:function(o1,o2){
function _1468(obj){
var count=0;
for(var k in obj){
if(obj.hasOwnProperty(k)){
count++;
}
}
return count;
};
if(typeof (o1)!==typeof (o2)){
return false;
}
if(typeof (o1)==="function"){
return o1.toString()===o2.toString();
}
if(o1 instanceof Object&&o2 instanceof Object){
if(_1468(o1)!==_1468(o2)){
return false;
}
var r=true;
for(var k in o1){
r=this.themeSetEquals(o1[k],o2[k]);
if(!r){
return false;
}
}
return true;
}else{
return o1===o2;
}
},themeMapsEqual:function(o1,o2){
var o1Str=JSON.stringify(o1);
var o2Str=JSON.stringify(o2);
return o1Str===o2Str;
},singleMobileTheme:function(_1469){
var _146a=_1469.mobileTheme[0].theme;
for(var i=1;i<_1469.mobileTheme.length;i++){
if(_1469.mobileTheme[i].theme!=_146a){
return false;
}
}
return true;
},getThemeSets:function(base){
var _146b=_1425.getDefaultThemeSet();
var _146c=null;
if(_146b){
var save=false;
_146c=_1427.getPreferences("maqetta.dojo.themesets",base);
if(!_146c){
_146c=Theme.dojoThemeSets;
_146c.themeSets[0]=_146b;
save=true;
}else{
var found=false;
for(var s=0;s<_146c.themeSets.length;s++){
if(_146c.themeSets[s].name===_146b.name){
found=true;
if(!Theme.themeSetEquals(_146c.themeSets[s],_146b)){
_146c.themeSets[s]=_146b;
save=true;
}
break;
}
}
if(!found){
_146c.themeSets.push(_146b);
save=true;
}
}
if(save){
Theme.saveThemeSets(base,_146c);
}
}
return _146c;
},saveThemeSets:function(base,_146d){
_1427.savePreferences("maqetta.dojo.themesets",base,_146d);
},};
Theme.none_themeset={"name":Theme.none_themeset_name,"desktopTheme":"claro","mobileTheme":dojo.clone(Theme.dojoMobileDefault)};
Theme.default_themeset={"name":Theme.desktop_default,"desktopTheme":"claro","mobileTheme":dojo.clone(Theme.dojoMobileDefault)};
Theme.custom_themeset={"name":Theme.mobile_default,"desktopTheme":"claro","mobileTheme":Theme.dojoMobileCustom};
Theme.dojoThemeSets={"version":"1.7","specVersion":"0.8","helper":"maq-metadata-dojo/dojox/mobile/ThemeHelper","themeSets":[Theme.custom_themeset]};
return Theme;
});
},"davinci/review/model/Resource":function(){
define(["dojo/_base/declare","davinci/review/model/resource/root"],function(_146e,root){
var _146f=null;
return {getRoot:function(){
if(!_146f){
_146f=root;
}
return _146f;
}};
});
},"davinci/ve/utils/StyleArray":function(){
define([],function(){
return {mergeStyleArrays:function(set1,set2){
if(!set1){
set1=[];
}
if(!set2){
set2=[];
}
var _1470=dojo.clone(set1);
for(var i=0;i<set2.length;i++){
for(var name1 in set2[i]){
for(j=_1470.length-1;j>=0;j--){
var _1471=_1470[j];
for(var name2 in _1471){
if(name1==name2){
_1470.splice(j,1);
break;
}
}
}
}
}
var _1472=_1470.concat(set2);
return _1472;
}};
});
},"davinci/repositoryinfo":function(){
define({revision:"@revision@",buildtime:"@buildtime@"});
},"davinci/ui/NewTheme":function(){
define(["dojo/_base/declare","dijit/_TemplatedMixin","dijit/_WidgetBase","dijit/_WidgetsInTemplateMixin","system/resource","../model/Path","../Workbench","../workbench/Preferences","dojo/i18n!./nls/ui","dojo/i18n!dijit/nls/common","dojo/text!./templates/newtheme.html","../Theme","./widgets/ThemeSelection","dijit/form/Button","dijit/form/ValidationTextBox"],function(_1473,_1474,_1475,_1476,_1477,Path,_1478,_1479,uiNLS,_147a,_147b,Theme,_147c,_147d,_147e){
return _1473([_1475,_1474,_1476],{templateString:_147b,_themeSelection:null,_okButton:null,_folder:null,_themeName:null,_folder:null,_version:null,_selector:null,_themeLocation:null,_error1:null,_error2:null,_error3:null,_error4:null,_errorMsg:null,_themeValidator:/^[-]?([_a-z]|[^\0-\237]|\[0-9a-f]{1,6}(\r\n|[ \n\r\t\f])?|\[^\n\r\f0-9a-f])([_a-z0-9-]|[^\0-\237]|\[0-9a-f]{1,6}(\r\n|[ \n\r\t\f])?|\[^\n\r\f0-9a-f])*$/i,postMixInProperties:function(){
var _147f=uiNLS;
var _1480=_147a;
dojo.mixin(this,_147f);
dojo.mixin(this,_1480);
this.inherited(arguments);
},postCreate:function(){
this.inherited(arguments);
dojo.connect(this._themeSelection,"onChange",this,"_baseThemeChanged");
dojo.connect(this._themeSelection,"onChange",this,"_checkValid");
this._selector.validator=dojo.hitch(this,function(value,_1481){
var _1482=this._themeValidator.test(value);
this._okButton.set("disabled",!_1482);
return _1482;
});
},_baseThemeChanged:function(){
this._theme=this._themeSelection.get("value");
},_createTheme:function(){
this._okButton.set("disabled",true);
var _1483=uiNLS;
var _1484=this._themeSelection.get("value");
var _1485=this._selector.get("value");
var _1486=_1485;
var _1487=null;
var base=_1485;
var _1488=this._getThemeLocation();
var r1=_1477.findResource(_1488+"/"+base+".theme");
if(r1){
alert(_1483.themeAlreadyExists);
}else{
this._loading=dojo.create("div",null,dojo.body(),"first");
this._loading.innerHTML=dojo.string.substitute("<table><tr><td><span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>&nbsp;${0}...</td></tr></table>",[_1483.creatingTheme]);
dojo.addClass(this._loading,"loading");
dojo.style(this._loading,"opacity","0.5");
var _1489=this.getBase();
var a=Theme.CloneTheme(_1486,_1487,_1485,_1488,_1484,true);
a.promise.then(function(_148a){
var _148b=a.themeFile;
if(_148b){
_148b.isNew=false;
return _148b.getContent().then(function(_148c){
_1478.openEditor({fileName:_148b,content:_148c});
});
}else{
throw new Error(_1483.errorCreatingTheme+base);
}
}).otherwise(function(_148d){
var _148e="Uh oh! An error has occurred:<br><b>"+_148d.message+"</b>";
if(_148d.fileName){
_148e+="<br>file: "+_148d.fileName+"<br>line: "+_148d.lineNumber;
}
if(_148d.stack){
_148e+="<br><pre>"+_148d.stack+"</pre>";
}
console.error(_148e);
}).otherwise(function(){
if(this._loading){
this._loading.parentNode.removeChild(this._loading);
delete this._loading;
}
}.bind(this));
}
},getBase:function(){
if(_1478.singleProjectMode()){
return _1478.getProject();
}
},_getThemeLocation:function(){
var _148f=this._selector.get("value");
var base=this.getBase();
var prefs=_1479.getPreferences("davinci.ui.ProjectPrefs",base);
var _1490=new Path(base).append(prefs.themeFolder);
return _1490.append(_148f).toString();
},_checkValid:function(){
var isOk=true;
var _1491=this._themeSelection.get("value");
var _1492=this._selector.get("value");
if(_1491==null||_1491==""||_1492==null||_1492==""){
isOk=false;
}
this._okButton.set("disabled",!isOk);
},okButton:function(){
this._createTheme();
},cancelButton:function(){
this.cancel=true;
this.onClose();
},onClose:function(){
}});
});
},"davinci/ve/_Widget":function(){
define("davinci/ve/_Widget",["dojo/_base/declare","./metadata","../html/CSSModel","dojox/html/entities","davinci/ve/utils/StyleArray","davinci/ve/utils/GeomUtils"],function(_1493,_1494,_1495,_1496,_1497,_1498){
var _1499=function(_149a,_149b,func){
if(_149a==_149b){
return true;
}
if(!_149a||!_149b){
return false;
}
if(_149a.length!=_149b.length){
return false;
}
for(var i=0;i<_149a.length;i++){
if(func){
if(!func(_149a[i],_149b[i])){
return false;
}
}else{
if(_149a[i]!=_149b[i]){
return false;
}
}
}
return true;
};
return _1493("davinci.ve._Widget",null,{isWidget:true,acceptsHTMLChildren:false,_skipAttrs:["id","style","class","dir","lang","_children"],constructor:function(_149c,node,type,_149d){
this.domNode=node;
this.id=node.id;
node._dvWidget=this;
this._params=dojo.mixin({},_149c);
this.type=type;
this.metadata=_149d;
},postscript:function(){
var _149e;
if(this.domNode){
var doc=this.domNode.ownerDocument;
if(doc.body._edit_context){
_149e=doc.body._edit_context;
}else{
if(doc.body._dvWidget&&doc.body._dvWidget._edit_context){
_149e=doc.body._dvWidget._edit_context;
}
}
}
if(this.id&&_149e){
_149e.widgetHash[this.id]=this;
}
this.buildRendering();
this.postCreate();
},buildRendering:function(){
},postCreate:function(){
},getObjectType:function(){
},getContext:function(){
return this._edit_context;
},getChildren:function(_149f){
var _14a0=this.getHelper();
if(_14a0&&_14a0.getChildren){
return _14a0.getChildren(this,_149f);
}
return this._getChildren(_149f);
},indexOf:function(child){
var _14a1=this.getHelper();
if(_14a1&&_14a1.indexOf){
return _14a1.indexOf(this,child);
}
return dojo.indexOf(this.getChildren(),child);
},_getChildren:function(_14a2){
var _14a3=this.getContainerNode(),_14a4=[];
if(_14a3){
dojo.forEach(_14a3.children,function(node){
if(_14a2){
_14a4.push(require("davinci/ve/widget").getWidget(node));
}else{
var _14a5=node._dvWidget;
if(_14a5){
_14a4.push(_14a5);
}
}
});
}
return _14a4;
},getContainerNode:function(){
var _14a6=this.getHelper();
if(_14a6&&_14a6.getContainerNode){
return _14a6.getContainerNode(this);
}
if(_1494.getAllowedChild(this.type)[0]!=="NONE"){
return this._getContainerNode();
}
return null;
},_getContainerNode:function(){
return this.domNode;
},getMetadata:function(){
if(!this.metadata){
this.metadata=_1494.query(this);
}
return this.metadata;
},getHelper:function(){
if(!this._edit_helper){
this._edit_helper=require("davinci/ve/widget").getWidgetHelper(this.type);
}
return this._edit_helper;
},attr:function(name,value){
var _14a7=this._attr.apply(this,arguments);
if(arguments.length>1){
value=this._stringValue(name,value);
this._srcElement.addAttribute(name,value);
}else{
return _14a7;
}
},_attr:function(name,value){
},indexOf:function(child){
var _14a8=this.getHelper();
if(_14a8&&_14a8.indexOf){
return _14a8.indexOf(this,child);
}
return dojo.indexOf(this.getChildren(),child);
},getStyleNode:function(){
return this.styleNode||this.domNode;
},addChild:function(child,index){
var _14a9=this.getContainerNode();
if(_14a9){
if(index===undefined||index===null||index===-1){
this._srcElement.addChild(child._srcElement);
}else{
var _14aa=this.getChildren();
if(index<_14aa.length){
this._srcElement.insertBefore(child._srcElement,_14aa[index]._srcElement);
}else{
this._srcElement.addChild(child._srcElement);
}
}
var _14ab=this.getHelper();
if(_14ab&&_14ab.addChild){
_14ab.addChild(this,child,index);
}else{
this._addChildToDom.apply(this,arguments);
}
}
},_addChildToDom:function(child,index){
var node=child.domNode;
var _14ac=this.getContainerNode();
if(index===undefined||index===null||index===-1){
_14ac.appendChild(node);
}else{
var _14ad=this.getChildren();
if(index<_14ad.length){
_14ac.insertBefore(node,_14ad[index].domNode);
}else{
_14ac.appendChild(node);
}
}
},getParent:function(){
return require("davinci/ve/widget").getEnclosingWidget(this.domNode.parentNode)||this.domNode.parentNode;
},getObjectId:function(_14ae){
_14ae=_14ae||this;
var _14af=_14ae._edit_object_id;
if(_14af){
return _14af;
}
if(_14ae.domNode){
return _14ae.domNode.getAttribute("jsId");
}
return undefined;
},addClass:function(_14b0){
var _14b1=this.getClassNames();
_14b1=_14b1?_14b1.split(/\s+/):[];
if(_14b1.indexOf(_14b0)!==-1){
return;
}
_14b1.push(_14b0);
this._srcElement.setAttribute("class",_14b1.join(" "));
dojo.addClass(this.domNode,_14b0);
},getId:function(){
if(!this.id){
if(!this.domNode.id||!this.type){
return undefined;
}
var id=this.domNode.id;
var base=(this.isHtmlWidget?this.getTagName():this.type).replace(/\./g,"_")+"_";
if(id.length>base.length&&id.substring(0,base.length)==base){
return undefined;
}
}
if(this._srcElement&&this._srcElement._getAttribute("id")&&this._srcElement._getAttribute("id").noPersist){
return undefined;
}
return this.id;
},setMarginBox:function(box){
var node=this.getStyleNode();
if(!node){
return;
}
dojo.marginBox(node,box);
this._updateSrcStyle();
},getMarginBox:function(){
var node=this.domNode;
var box=null;
var _14b2=this.getHelper();
if(_14b2&&_14b2.getMarginBoxPageCoords){
box=_14b2.getMarginBoxPageCoords(this);
}else{
box=_1498.getMarginBoxPageCoords(node);
}
box.l-=_1498.getScrollLeft(node);
box.t-=_1498.getScrollTop(node);
box.x=box.l;
box.y=box.t;
return box;
},getStyle:function(_14b3){
var _14b4=this.getStyleValues(_14b3);
if(!_14b4){
return "";
}
return this._styleText(_14b4);
},_sortStyleValues:function(_14b5){
var _14b6=dojo.clone(_14b5);
function _14b7(value){
for(var i=0;i<_14b6.length;i++){
if(_14b6[i]&&_14b6[i].hasOwnProperty(value)){
return i;
}
}
return -1;
};
var _14b8=_1495.shorthand;
var _14b9=0;
for(var i=0;i<_14b8.length;i++){
var index=_14b7(_14b8[i][0]);
if(index>-1){
var _14ba=_14b6[index];
_14b6.splice(index,1);
_14b6.splice(_14b9,0,_14ba);
_14b9++;
}
}
return _14b6;
},_styleText:function(v){
var s="";
if(dojo.isArray(v)){
var _14bb=davinci.ve.states.normalizeArray("style",this.domNode,name,v);
for(var i=0;i<_14bb.length;i++){
for(var name in _14bb[i]){
value=_14bb[i][name];
if(value!==undefined&&value!=""&&value!=null){
s+=name+": "+_14bb[i][name]+"; ";
}
}
}
}else{
for(var name in v){
value=davinci.ve.states.normalize("style",this.domNode,name,v[name]);
if(value!==undefined&&value!=""&&value!=null){
s+=name+": "+v[name]+"; ";
}
}
}
return s.trim();
},getChildrenData:function(_14bc){
_14bc=_14bc||{identify:true};
var _14bd=this.getHelper();
if(_14bd&&_14bd.getChildrenData){
return _14bd.getChildrenData.apply(_14bd,[this,_14bc]);
}
return this._getChildrenData(_14bc);
},_getChildrenData:function(_14be){
return this.getChildren().map(function(w){
return w.getData(_14be);
});
},getClassNames:function(){
return this._srcElement.getAttribute("class")||"";
},_getData:function(_14bf){
var data={type:this.type,properties:{}},_14c0=require("davinci/ve/widget");
if(_14bf.identify){
if(!this._srcElement){
this._srcElement=_14c0._createSrcElement(this.domNode);
}
var _14c1=this._srcElement._getAttribute("id");
if(_14c1&&_14c1.noPersist){
data.properties.isTempID=true;
}
data.properties.id=this.id;
}
if((_14bf.preserveTagName!==false)&&(this.id)){
data.tagName=this._srcElement.tag;
}
var _14c2=_1494.query(this,"property");
if(this.domNode&&this.domNode.parentNode){
var _14c3=_14c0.getEnclosingWidget(this.domNode.parentNode);
var _14c4=_1494.query(_14c3,"childProperties");
if(_14c4){
if(!_14c2){
_14c2=_14c4;
}else{
_14c2=dojo.mixin({},_14c2,_14c4);
}
}
}
if(_14c2){
for(var name in _14c2){
if(this._skipAttrs.indexOf(name.toLowerCase())!==-1){
continue;
}
var _14c5=_14c2[name];
var value=this.getPropertyValue(name);
if(value&&value.length){
if(_14c5.datatype=="array"){
if(!_1499(value,_14c5.defaultValue)){
data.properties[name]=value;
}
}else{
if(value!=_14c5.defaultValue){
data.properties[name]=value;
}
}
}else{
if((_14c5.datatype=="boolean"||_14c5.datatype=="number")&&value!=_14c5.defaultValue){
data.properties[name]=value;
}else{
if(_14c5.datatype&&(_14c5.datatype.indexOf("dijit")==0||_14c5.datatype=="object"&&_14c5.isData)){
data.properties[name]=value;
}
}
}
}
}
data.properties.style=this.getStyle(_14bf);
var _14c6=this.getClassNames(_14bf);
if(_14c6){
data.properties["class"]=_14c6;
}
data.children=this.getChildrenData(_14bf);
return data;
},getData:function(_14c7){
_14c7=_14c7||{identify:true,preserveStates:true};
var data,_14c8=this.getHelper();
if(_14c8&&_14c8.getData){
data=_14c8.getData.apply(_14c8,[this,_14c7]);
}else{
data=this._getData(_14c7);
}
data.maqAppStates=dojo.clone(this.domNode._maqAppStates);
data.maqDeltas=dojo.clone(this.domNode._maqDeltas);
if(!data.properties){
data.properties={};
}
if(this.properties){
for(var name in this.properties){
if(!(name in data.properties)){
data.properties[name]=this.properties[name];
}
}
}
var _14c9=this._srcElement;
var _14ca=_14c9.attributes;
for(var i=0;i<_14ca.length;i++){
var _14cb=_14ca[i];
if(_14cb.name.substr(0,2).toLowerCase()=="on"){
data.properties[_14cb.name]=_14cb.value;
}else{
if(_14c9.tag.toLowerCase()=="a"&&_14cb.name.toLowerCase()=="href"){
data.properties[_14cb.name]=_14cb.value;
}
}
}
return data;
},getPropertyValue:function(name){
if(name==="id"){
return this.getId();
}else{
if(name==="jsId"){
return this.getObjectId();
}
}
var _14cc=this.getHelper();
if(_14cc&&_14cc.getPropertyValue){
return _14cc.getPropertyValue(this,name);
}
return this._getPropertyValue(name);
},_getPropertyValue:function(name){
return this.domNode.getAttribute(name);
},getTagName:function(){
return this.domNode.nodeName.toLowerCase();
},getStyleValues:function(){
function _14cd(_14ce){
for(var j=_14cf.length-1;j>=0;j--){
var item=_14cf[j];
if(item[_14ce]!==undefined){
_14cf.splice(j,1);
}
}
};
var style=this.getStyleNode().style;
var text=this._srcElement.getAttribute("style");
var _14cf=require("davinci/ve/widget").parseStyleValues(text);
var _14d0=this.getParent();
if(style&&_14d0&&_14d0.dijitWidget&&_14d0.dijitWidget.addChild&&!_14d0.acceptsHTMLChildren){
_14cd("position");
_14cd("left");
_14cd("top");
}
return _14cf;
},getStyleValuesAllStates:function(){
var _14d1=this.getStyleValues();
var _14d2={"undefined":_14d1};
var _14d3=this.domNode._maqDeltas;
if(_14d3){
for(var state in _14d3){
if(_14d3[state].style){
if(state=="undefined"){
_14d2[state]=_1497.mergeStyleArrays(_14d1,_14d3[state].style);
}else{
_14d2[state]=_14d3[state].style;
}
}
}
}
return _14d2;
},_updateSrcStyle:function(){
var _14d4=this.getStyle();
if(_14d4.length){
this._srcElement.addAttribute("style",_14d4);
}else{
this._srcElement.removeAttribute("style");
}
},_getStyleString:function(_14d5){
if(!_14d5){
return "";
}
var v=this._sortStyleValues(_14d5);
var text=this._styleText(v);
return text;
},setStyleValuesCanvas:function(_14d6){
if(!_14d6){
return;
}
var text=this._getStyleString(_14d6);
var _14d7=this.getStyleNode();
dojo.attr(_14d7,"style",text);
if(this.dijitWidget){
this.dijitWidget.style=text;
}
},setStyleValuesModel:function(_14d8){
var text=this._getStyleString(_14d8);
if(text.length>0){
this._srcElement.addAttribute("style",text);
}else{
this._srcElement.removeAttribute("style");
}
},setStyleValuesAllStates:function(_14d9){
this.domNode._maqDeltas=undefined;
if(_14d9){
for(var state in _14d9){
var _14da=_14d9[state];
if(state==="undefined"){
state=undefined;
}
davinci.ve.states.setStyle(this.domNode,state,_14da,true);
}
}
},isLayout:function(){
return false;
},resize:function(){
},refresh:function(){
var _14db=this.getParent();
if(_14db.dijitWidget){
_14db.refresh();
}else{
if(this.resize){
this.resize();
}
}
},removeChild:function(child){
this._srcElement.removeChild(child._srcElement);
var _14dc=this.getHelper();
if(_14dc&&_14dc.removeChild){
_14dc.removeChild(this,child);
}else{
this._removeChildFromDom.apply(this,arguments);
}
},_removeChildFromDom:function(child){
var node=child.domNode;
if(node&&node.parentNode){
node.parentNode.removeChild(node);
}
},setProperties:function(_14dd,_14de){
if(!this.properties){
this.properties={};
}
_14de=_14de||false;
if(_14dd.id){
this._srcElement.addAttribute("id",_14dd.id,_14dd.isTempID);
delete _14dd.id;
delete _14dd.isTempID;
}
if(_14dd.isTempID){
delete _14dd.isTempID;
}
for(var name in _14dd){
var _14df=_14dd[name];
if(_14df||typeof _14df=="boolean"||typeof _14df=="number"){
var value=this._stringValue(name,_14df);
if(!_14de){
this.properties[name]=value;
}
this._srcElement.addAttribute(name,value);
}else{
delete this.properties[name];
this._srcElement.removeAttribute(name);
}
}
},startup:function(){
},renderWidget:function(){
},destroyWidget:function(_14e0){
var _14e1=this.getHelper();
if(_14e1&&_14e1.destroy){
_14e1.destroy(this);
return;
}
if(this.dijitWidget){
this.dijitWidget.destroyRecursive();
}else{
dojo.forEach(this.getChildren(),function(each){
each.destroyWidget();
});
}
},selectChild:function(_14e2){
},attach:function(){
var _14e3=this.getHelper();
if(_14e3&&_14e3.create){
_14e3.create(this,this._srcElement);
}
},_stringValue:function(_14e4,value){
var _14e5=this.getMetadata();
var _14e6=_14e5.property&&_14e5.property[_14e4];
if(!_14e6){
return value;
}
if(_14e6.datatype=="object"){
if(value.getObjectId){
value=value.getObjectId();
}else{
var _14e7=value._edit_object_id;
if(_14e7){
return _14e7;
}
if(value.domNode){
return value.domNode.getAttribute("jsId");
}
}
}else{
if(_14e6.datatype=="json"){
var _14e8=this.getContext();
var dj=_14e8&&_14e8.getDojo()||dojo;
var _14e9=this.getHelper();
if(_14e9&&_14e9.checkValue){
value=_14e9.checkValue(value);
}
if(dj.isObject(value)){
value=dj.toJson(value);
}
}else{
if(_14e6.datatype=="string"){
switch(_14e6.format){
case "date":
case "time":
if(isFinite(value)){
value=dojo.date.stamp.toISOString(value,{selector:_14e6.format});
}
break;
default:
value=_1496.encode(value);
}
}
}
}
return value;
}});
});
},"url:davinci/workbench/templates/Preferences.html":"<div style='width:100%; height: 100%'>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<div dojoType='dijit.layout.BorderContainer' dojoAttachPoint=\"borderContainer\" style='width:100%; height: 100%' gutters='false' liveSplitters='true' id='preferencesContainer'>\n\t\t\t<div dojoType='dijit.layout.ContentPane' id='pref.TreePane' splitter='true' region='leading' style='width: 200px;' minSize='100' maxSize='300'></div>\n\t\t\t<div dojoType='dijit.layout.ContentPane' region='center' id='pref.RightPane'></div>\n\t\t</div>\n\t</div>\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<!-- FIXME: we don't have logic to yet implement restoreDefaults() yet. See #627\n\t\t<button dojoType=dijit.form.Button type=\"button\" onclick=\"davinci.workbench.Preferences.restoreDefaults();\"></button>-->\n\t\t<button dojoType=\"dijit.form.Button\" type=\"button\" onclick=\"davinci.workbench.Preferences.save();\" class=\"maqPrimaryButton\" type=\"submit\">${commonStrings.buttonSave}</button>\n\t\t<button dojoType=\"dijit.form.Button\" type=\"button\" onclick=\"davinci.workbench.Preferences.finish();\" class=\"maqSecondaryButton\">${commonStrings.buttonCancel}</button>\n\t</div>\n</div>\n\n\n","dojox/html/entities":function(){
define(["dojo/_base/lang"],function(lang){
var dhe=lang.getObject("dojox.html.entities",true);
var _14ea=function(str,map){
var _14eb,_14ec;
if(map._encCache&&map._encCache.regexp&&map._encCache.mapper&&map.length==map._encCache.length){
_14eb=map._encCache.mapper;
_14ec=map._encCache.regexp;
}else{
_14eb={};
_14ec=["["];
var i;
for(i=0;i<map.length;i++){
_14eb[map[i][0]]="&"+map[i][1]+";";
_14ec.push(map[i][0]);
}
_14ec.push("]");
_14ec=new RegExp(_14ec.join(""),"g");
map._encCache={mapper:_14eb,regexp:_14ec,length:map.length};
}
str=str.replace(_14ec,function(c){
return _14eb[c];
});
return str;
};
var _14ed=function(str,map){
var _14ee,_14ef;
if(map._decCache&&map._decCache.regexp&&map._decCache.mapper&&map.length==map._decCache.length){
_14ee=map._decCache.mapper;
_14ef=map._decCache.regexp;
}else{
_14ee={};
_14ef=["("];
var i;
for(i=0;i<map.length;i++){
var e="&"+map[i][1]+";";
if(i){
_14ef.push("|");
}
_14ee[e]=map[i][0];
_14ef.push(e);
}
_14ef.push(")");
_14ef=new RegExp(_14ef.join(""),"g");
map._decCache={mapper:_14ee,regexp:_14ef,length:map.length};
}
str=str.replace(_14ef,function(c){
return _14ee[c];
});
return str;
};
dhe.html=[["&","amp"],["\"","quot"],["<","lt"],[">","gt"],[" ","nbsp"]];
dhe.latin=[["¡","iexcl"],["¢","cent"],["£","pound"],["€","euro"],["¤","curren"],["¥","yen"],["¦","brvbar"],["§","sect"],["¨","uml"],["©","copy"],["ª","ordf"],["«","laquo"],["¬","not"],["­","shy"],["®","reg"],["¯","macr"],["°","deg"],["±","plusmn"],["²","sup2"],["³","sup3"],["´","acute"],["µ","micro"],["¶","para"],["·","middot"],["¸","cedil"],["¹","sup1"],["º","ordm"],["»","raquo"],["¼","frac14"],["½","frac12"],["¾","frac34"],["¿","iquest"],["À","Agrave"],["Á","Aacute"],["Â","Acirc"],["Ã","Atilde"],["Ä","Auml"],["Å","Aring"],["Æ","AElig"],["Ç","Ccedil"],["È","Egrave"],["É","Eacute"],["Ê","Ecirc"],["Ë","Euml"],["Ì","Igrave"],["Í","Iacute"],["Î","Icirc"],["Ï","Iuml"],["Ð","ETH"],["Ñ","Ntilde"],["Ò","Ograve"],["Ó","Oacute"],["Ô","Ocirc"],["Õ","Otilde"],["Ö","Ouml"],["×","times"],["Ø","Oslash"],["Ù","Ugrave"],["Ú","Uacute"],["Û","Ucirc"],["Ü","Uuml"],["Ý","Yacute"],["Þ","THORN"],["ß","szlig"],["à","agrave"],["á","aacute"],["â","acirc"],["ã","atilde"],["ä","auml"],["å","aring"],["æ","aelig"],["ç","ccedil"],["è","egrave"],["é","eacute"],["ê","ecirc"],["ë","euml"],["ì","igrave"],["í","iacute"],["î","icirc"],["ï","iuml"],["ð","eth"],["ñ","ntilde"],["ò","ograve"],["ó","oacute"],["ô","ocirc"],["õ","otilde"],["ö","ouml"],["÷","divide"],["ø","oslash"],["ù","ugrave"],["ú","uacute"],["û","ucirc"],["ü","uuml"],["ý","yacute"],["þ","thorn"],["ÿ","yuml"],["ƒ","fnof"],["Α","Alpha"],["Β","Beta"],["Γ","Gamma"],["Δ","Delta"],["Ε","Epsilon"],["Ζ","Zeta"],["Η","Eta"],["Θ","Theta"],["Ι","Iota"],["Κ","Kappa"],["Λ","Lambda"],["Μ","Mu"],["Ν","Nu"],["Ξ","Xi"],["Ο","Omicron"],["Π","Pi"],["Ρ","Rho"],["Σ","Sigma"],["Τ","Tau"],["Υ","Upsilon"],["Φ","Phi"],["Χ","Chi"],["Ψ","Psi"],["Ω","Omega"],["α","alpha"],["β","beta"],["γ","gamma"],["δ","delta"],["ε","epsilon"],["ζ","zeta"],["η","eta"],["θ","theta"],["ι","iota"],["κ","kappa"],["λ","lambda"],["μ","mu"],["ν","nu"],["ξ","xi"],["ο","omicron"],["π","pi"],["ρ","rho"],["ς","sigmaf"],["σ","sigma"],["τ","tau"],["υ","upsilon"],["φ","phi"],["χ","chi"],["ψ","psi"],["ω","omega"],["ϑ","thetasym"],["ϒ","upsih"],["ϖ","piv"],["•","bull"],["…","hellip"],["′","prime"],["″","Prime"],["‾","oline"],["⁄","frasl"],["℘","weierp"],["ℑ","image"],["ℜ","real"],["™","trade"],["ℵ","alefsym"],["←","larr"],["↑","uarr"],["→","rarr"],["↓","darr"],["↔","harr"],["↵","crarr"],["⇐","lArr"],["⇑","uArr"],["⇒","rArr"],["⇓","dArr"],["⇔","hArr"],["∀","forall"],["∂","part"],["∃","exist"],["∅","empty"],["∇","nabla"],["∈","isin"],["∉","notin"],["∋","ni"],["∏","prod"],["∑","sum"],["−","minus"],["∗","lowast"],["√","radic"],["∝","prop"],["∞","infin"],["∠","ang"],["∧","and"],["∨","or"],["∩","cap"],["∪","cup"],["∫","int"],["∴","there4"],["∼","sim"],["≅","cong"],["≈","asymp"],["≠","ne"],["≡","equiv"],["≤","le"],["≥","ge"],["⊂","sub"],["⊃","sup"],["⊄","nsub"],["⊆","sube"],["⊇","supe"],["⊕","oplus"],["⊗","otimes"],["⊥","perp"],["⋅","sdot"],["⌈","lceil"],["⌉","rceil"],["⌊","lfloor"],["⌋","rfloor"],["〈","lang"],["〉","rang"],["◊","loz"],["♠","spades"],["♣","clubs"],["♥","hearts"],["♦","diams"],["Œ","Elig"],["œ","oelig"],["Š","Scaron"],["š","scaron"],["Ÿ","Yuml"],["ˆ","circ"],["˜","tilde"],[" ","ensp"],[" ","emsp"],[" ","thinsp"],["‌","zwnj"],["‍","zwj"],["‎","lrm"],["‏","rlm"],["–","ndash"],["—","mdash"],["‘","lsquo"],["’","rsquo"],["‚","sbquo"],["“","ldquo"],["”","rdquo"],["„","bdquo"],["†","dagger"],["‡","Dagger"],["‰","permil"],["‹","lsaquo"],["›","rsaquo"]];
dhe.encode=function(str,m){
if(str){
if(!m){
str=_14ea(str,dhe.html);
str=_14ea(str,dhe.latin);
}else{
str=_14ea(str,m);
}
}
return str;
};
dhe.decode=function(str,m){
if(str){
if(!m){
str=_14ed(str,dhe.html);
str=_14ed(str,dhe.latin);
}else{
str=_14ed(str,m);
}
}
return str;
};
return dhe;
});
},"dojo/store/util/QueryResults":function(){
define(["../../_base/array","../../_base/lang","../../_base/Deferred"],function(array,lang,_14f0){
var _14f1=function(_14f2){
if(!_14f2){
return _14f2;
}
if(_14f2.then){
_14f2=lang.delegate(_14f2);
}
function _14f3(_14f4){
if(!_14f2[_14f4]){
_14f2[_14f4]=function(){
var args=arguments;
return _14f0.when(_14f2,function(_14f5){
Array.prototype.unshift.call(args,_14f5);
return _14f1(array[_14f4].apply(array,args));
});
};
}
};
_14f3("forEach");
_14f3("filter");
_14f3("map");
if(!_14f2.total){
_14f2.total=_14f0.when(_14f2,function(_14f6){
return _14f6.length;
});
}
return _14f2;
};
lang.setObject("dojo.store.util.QueryResults",_14f1);
return _14f1;
});
},"url:davinci/ui/templates/ThemeSetsRenameDialog.html":"<div>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t${uiNLS.themeSetName} <input data-dojo-type=\"dijit.form.ValidationTextBox\" data-dojo-props=\"regExp:'[a-zA-z0-9_]+', required:true, invalidMessage:'Invalid Text.'\" id=\"theme_select_themeset_rename_textbox\" style=\"width: 175px;\"/>\n\t</div>\n\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button type=\"button\" dojoType=\"dijit.form.Button\" id=\"theme_set_rename_ok_button\" label=\"${uiNLS.renameButtonLabel}\" class=\"maqPrimaryButton\" type=\"submit\"></button>\n\t\t<button type=\"button\" dojoType=\"dijit.form.Button\" id=\"theme_set_rename_cancel_button\" label=\"${commonNLS.buttonCancel}\" class=\"maqSecondaryButton\"></button>\n\t</div>\n</div>\n","dijit/form/_ListBase":function(){
define(["dojo/_base/declare","dojo/on","dojo/window"],function(_14f7,on,_14f8){
return _14f7("dijit.form._ListBase",null,{selected:null,_listConnect:function(_14f9,_14fa){
var self=this;
return self.own(on(self.containerNode,on.selector(function(_14fb,_14fc,_14fd){
return _14fb.parentNode==_14fd;
},_14f9),function(evt){
evt.preventDefault();
self[_14fa](evt,this);
}));
},selectFirstNode:function(){
var first=this.containerNode.firstChild;
while(first&&first.style.display=="none"){
first=first.nextSibling;
}
this._setSelectedAttr(first);
},selectLastNode:function(){
var last=this.containerNode.lastChild;
while(last&&last.style.display=="none"){
last=last.previousSibling;
}
this._setSelectedAttr(last);
},selectNextNode:function(){
var _14fe=this.selected;
if(!_14fe){
this.selectFirstNode();
}else{
var next=_14fe.nextSibling;
while(next&&next.style.display=="none"){
next=next.nextSibling;
}
if(!next){
this.selectFirstNode();
}else{
this._setSelectedAttr(next);
}
}
},selectPreviousNode:function(){
var _14ff=this.selected;
if(!_14ff){
this.selectLastNode();
}else{
var prev=_14ff.previousSibling;
while(prev&&prev.style.display=="none"){
prev=prev.previousSibling;
}
if(!prev){
this.selectLastNode();
}else{
this._setSelectedAttr(prev);
}
}
},_setSelectedAttr:function(node){
if(this.selected!=node){
var _1500=this.selected;
if(_1500){
this.onDeselect(_1500);
this.selected=null;
}
if(node){
this.selected=node;
_14f8.scrollIntoView(node);
this.onSelect(node);
}
}else{
if(node){
this.onSelect(node);
}
}
}});
});
},"davinci/model/resource/Folder":function(){
define(["dojo/_base/declare","dojo/_base/xhr","davinci/Runtime","davinci/model/resource/Resource","davinci/model/resource/File"],function(_1501,xhr,_1502,_1503,File){
var _1504=_1501(_1503,{constructor:function(name,_1505){
this.elementType="Folder";
this.name=name;
this.parent=_1505;
},reload:function(){
this._isLoaded=false;
},createResource:function(name,_1506,_1507){
var file;
if(name!=null){
file=_1506?new _1504(name,this):new File(name,this);
}else{
file=this;
_1506=this.elementType=="Folder";
}
var _1508=_1507?"OK":_1502.serverJSONRequest({url:"cmd/createResource",handleAs:"text",content:{path:file.getPath(),isFolder:_1506},sync:true});
if(_1508=="OK"&&name!=null){
this.children.push(file);
delete file.libraryId;
delete file.libVersion;
delete file._readOnly;
dojo.publish("/davinci/resource/resourceChanged",["created",file]);
return file;
}else{
if(_1508=="EXISTS"){
this.children.push(file);
delete file.libraryId;
delete file.libVersion;
delete file._readOnly;
dojo.publish("/davinci/resource/resourceChanged",["created",file]);
return file;
}else{
if(_1508!="OK"){
throw "Folder.createResource failed: name="+name+"response="+_1508;
}else{
delete file.libraryId;
delete file.libVersion;
delete file._readOnly;
return this;
}
}
}
},getChildren:function(_1509,_150a){
if(this._isLoaded){
_1509.call(null,this.children);
}else{
if(this._loading){
this._loading.then(function(){
_1509.call(null,this.children);
}.bind(this),_150a);
}else{
this._loading=xhr.get({url:"cmd/listFiles",content:{path:this.getPath()},sync:false,handleAs:"json"}).then(function(_150b){
this.setChildren(_150b);
this._isLoaded=true;
_1509.call(null,this.children);
delete this._loading;
}.bind(this),_150a);
}
}
},getChildrenSync:function(_150c,sync){
if(!this._isLoaded){
if(this._loadingCallbacks){
this._loadingCallbacks.push(_150c);
return;
}
this._loadingCallbacks=[];
this._loadingCallbacks.push(_150c);
_1502.serverJSONRequest({url:"cmd/listFiles",content:{path:this.getPath()},sync:sync,load:dojo.hitch(this,function(_150d,_150e){
this.setChildrenSync(_150d);
dojo.forEach(this._loadingCallbacks,function(item){
(item)(this.children);
},this);
delete this._loadingCallbacks;
})});
return;
}
_150c(this.children);
},setChildren:function(_150f){
this.children=[];
this._appendFiles(_150f);
},setChildrenSync:function(_1510){
this.children=[];
this._appendFiles(_1510,true);
},_appendFiles:function(_1511,sync){
_1511.forEach(function(item){
var child=sync?this.getChildSync(item.name):this._getChild(item.name);
var _1512=child!=null;
if(item.isDir||item.isLib){
if(!_1512){
child=new _1504(item.name,this);
}
if(item.isLib){
child.isLibrary=true;
}
}else{
if(!_1512){
child=new File(item.name,this);
}
}
child.link=item.link;
child.isNew=item.isNew;
child._readOnly=item.readOnly;
child.setDirty(item.isDirty);
if(item.libraryId){
child.libraryId=item.libraryId;
child.libVersion=item.libVersion;
}
if(!_1512){
this.children.push(child);
}
},this);
this._isLoaded=true;
},getMarkers:function(_1513,_1514){
var _1515=[];
this.visit({visit:function(_1516){
if(_1516.elementType=="File"){
markers=_1516.getMarkers(_1513);
_1515.concat(markers);
}else{
if(!_1514){
return true;
}
}
}},true);
return _1515;
},getChildSync:function(name){
if(!this._isLoaded||(this.children.length<1)){
this._isLoaded=false;
this.getChildrenSync(function(item){
this.children=item;
},true);
}
return this._getChild(name);
},_getChild:function(name){
if(!this.__CASE_SENSITIVE){
name=name.toLowerCase();
}
var _1517;
this.children.some(function(child){
var _1518=child.getName();
if(!this.__CASE_SENSITIVE){
_1518=_1518.toLowerCase();
}
var match=_1518==name;
if(match){
_1517=child;
}
return match;
});
return _1517;
}});
davinci.model.resource.root=new _1504(".",null);
return _1504;
});
},"davinci/ve/utils/URLRewrite":function(){
define([],function(){
var _1519=/^\s*url\s*\(\s*(\'[^\'\"]*\'|\"[^\'\"]*\"|[^\'\"]*)\s*\)\s*$/;
var _151a=/^[\'\"]?([^\'\"]*)[\'\"]?$/;
var _151b=/^(http|ftp)/;
return {isAbsolute:function(url){
if(typeof url!="string"){
return false;
}
var _151c=this.getUrl(url);
if(_151c){
return _151b.test(_151c);
}else{
return false;
}
},containsUrl:function(url){
if(typeof url!="string"){
return false;
}
return _1519.test(url);
},replaceUrl:function(_151d,_151e){
if(typeof _151d!="string"||typeof _151e!="string"){
return null;
}
var _151f=this.getUrl(_151d);
if(_151f){
return "url('"+_151e+"')";
}else{
return null;
}
},stripQuotes:function(s){
var _1520=s.replace(_151a,"$1");
return _1520;
},encodeURI:function(url){
var pass1=encodeURI(url);
return pass1.replace(/#/g,"%23");
},getUrl:function(url){
if(typeof url!="string"){
return null;
}
var _1521=url.match(_1519);
if(_1521&&_1521.length>1){
var match=_1521[1];
return this.stripQuotes(match);
}else{
return null;
}
}};
});
},"dojo/DeferredList":function(){
define(["./_base/kernel","./_base/Deferred","./_base/array"],function(dojo,_1522,_1523){
dojo.DeferredList=function(list,_1524,_1525,_1526,_1527){
var _1528=[];
_1522.call(this);
var self=this;
if(list.length===0&&!_1524){
this.resolve([0,[]]);
}
var _1529=0;
_1523.forEach(list,function(item,i){
item.then(function(_152a){
if(_1524){
self.resolve([i,_152a]);
}else{
_152b(true,_152a);
}
},function(error){
if(_1525){
self.reject(error);
}else{
_152b(false,error);
}
if(_1526){
return null;
}
throw error;
});
function _152b(_152c,_152d){
_1528[i]=[_152c,_152d];
_1529++;
if(_1529===list.length){
self.resolve(_1528);
}
};
});
};
dojo.DeferredList.prototype=new _1522();
dojo.DeferredList.prototype.gatherResults=function(_152e){
var d=new dojo.DeferredList(_152e,false,true,false);
d.addCallback(function(_152f){
var ret=[];
_1523.forEach(_152f,function(_1530){
ret.push(_1530[1]);
});
return ret;
});
return d;
};
return dojo.DeferredList;
});
},"davinci/ve/commands/AddCommand":function(){
define(["dojo/_base/declare","davinci/ve/commands/_hierarchyCommand","davinci/ve/widget","davinci/ve/utils/ImageUtils","davinci/ve/States","davinci/ve/commands/ModifyCommand"],function(_1531,_1532,_1533,_1534,_1535,_1536){
return _1531("davinci.ve.commands.AddCommand",[_1532],{name:"add",constructor:function(_1537,_1538,index){
if(_1537){
if(_1537.domNode){
this._id=_1537.id;
}else{
this._data=_1537;
}
}
this._parentId=_1538.id;
this._index=index;
},execute:function(){
var _1539=_1533.byId(this._parentId);
if(!_1539){
return;
}
var _153a=_1539.getContext();
var _153b=undefined;
if(this._data){
if(this._id&&this._data.properties){
this._data.properties.id=this._id;
}
_153b=_1533.createWidget(this._data);
this._id=_153b.id;
}else{
if(this._id){
_153b=_1533.byId(this._id,_153a);
}
}
if(!_153b){
return;
}
this._data=_153b.getData();
this._data.properties.id=this._id;
this._data.context=_153a;
if(this._index&&typeof this._index!="number"){
if(this._index.domNode){
this._index=_1539.indexOf(this._index);
}else{
var w=_1533.byId(this._index.id,_153a);
this._index=_1539.indexOf(w);
}
}
if(_153b.domNode.tagName==="IMG"){
_1534.ImageUpdateFocus(_153b,_153a);
}
_1539.addChild(_153b,this._index);
if(_153a){
_153a.attach(_153b);
_153b.startup();
_153b.renderWidget();
_153a.widgetAddedOrDeleted();
_153a.widgetChanged(_153a.WIDGET_ADDED,_153b);
}
var _153c=this._isRefreshOnDescendantChange(_153b);
if(_153c){
var _153d=new _1536(_153c,null,null,_1539._edit_context);
_153d.execute();
}
_1535.resetState(_153b.domNode);
},undo:function(){
if(!this._id||!this._parentId){
return;
}
var _153e=_1533.byId(this._id);
if(!_153e){
return;
}
var _153f=_1533.byId(this._parentId);
if(!_153f){
return;
}
var _1540=this._isRefreshOnDescendantChange(_153e);
var _1541=_153e.getContext();
if(_1541){
_1541.detach(_153e);
_1541.deselect(_153e);
}
_153f.removeChild(_153e);
_1541.widgetChanged(_1541.WIDGET_REMOVED,_153e);
_153e.destroyWidget();
if(_1541){
_1541.widgetAddedOrDeleted();
}
if(_1540){
var _1542=new _1536(_1540,null,null,_153f._edit_context);
_1542.execute();
}
_1535.resetState(_153e.domNode);
}});
});
},"dojo/dnd/common":function(){
define(["../_base/connect","../_base/kernel","../_base/lang","../dom"],function(_1543,_1544,lang,dom){
var _1545=lang.getObject("dojo.dnd",true);
_1545.getCopyKeyState=_1543.isCopyKey;
_1545._uniqueId=0;
_1545.getUniqueId=function(){
var id;
do{
id=_1544._scopeName+"Unique"+(++_1545._uniqueId);
}while(dom.byId(id));
return id;
};
_1545._empty={};
_1545.isFormElement=function(e){
var t=e.target;
if(t.nodeType==3){
t=t.parentNode;
}
return " button textarea input select option ".indexOf(" "+t.tagName.toLowerCase()+" ")>=0;
};
return _1545;
});
},"dijit/CalendarLite":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/cldr/supplemental","dojo/date","dojo/date/locale","dojo/date/stamp","dojo/dom","dojo/dom-class","dojo/_base/event","dojo/_base/lang","dojo/sniff","dojo/string","./_WidgetBase","./_TemplatedMixin","dojo/text!./templates/Calendar.html","./hccss"],function(array,_1546,_1547,date,_1548,stamp,dom,_1549,event,lang,has,_154a,_154b,_154c,_154d){
var _154e=_1546("dijit.CalendarLite",[_154b,_154c],{templateString:_154d,dowTemplateString:"<th class=\"dijitReset dijitCalendarDayLabelTemplate\" role=\"columnheader\"><span class=\"dijitCalendarDayLabel\">${d}</span></th>",dateTemplateString:"<td class=\"dijitReset\" role=\"gridcell\" data-dojo-attach-point=\"dateCells\"><span class=\"dijitCalendarDateLabel\" data-dojo-attach-point=\"dateLabels\"></span></td>",weekTemplateString:"<tr class=\"dijitReset dijitCalendarWeekTemplate\" role=\"row\">${d}${d}${d}${d}${d}${d}${d}</tr>",value:new Date(""),datePackage:"",dayWidth:"narrow",tabIndex:"0",currentFocus:new Date(),baseClass:"dijitCalendar",_isValidDate:function(value){
return value&&!isNaN(value)&&typeof value=="object"&&value.toString()!=this.constructor.prototype.value.toString();
},_getValueAttr:function(){
if(this.value&&!isNaN(this.value)){
var value=new this.dateClassObj(this.value);
value.setHours(0,0,0,0);
if(value.getDate()<this.value.getDate()){
value=this.dateModule.add(value,"hour",1);
}
return value;
}else{
return null;
}
},_setValueAttr:function(value,_154f){
if(typeof value=="string"){
value=stamp.fromISOString(value);
}
value=this._patchDate(value);
if(this._isValidDate(value)&&!this.isDisabledDate(value,this.lang)){
this._set("value",value);
this.set("currentFocus",value);
this._markSelectedDates([value]);
if(this._created&&(_154f||typeof _154f=="undefined")){
this.onChange(this.get("value"));
}
}else{
this._set("value",null);
this._markSelectedDates([]);
}
},_patchDate:function(value){
if(value){
value=new this.dateClassObj(value);
value.setHours(1,0,0,0);
}
return value;
},_setText:function(node,text){
while(node.firstChild){
node.removeChild(node.firstChild);
}
node.appendChild(node.ownerDocument.createTextNode(text));
},_populateGrid:function(){
var month=new this.dateClassObj(this.currentFocus);
month.setDate(1);
var _1550=month.getDay(),_1551=this.dateModule.getDaysInMonth(month),_1552=this.dateModule.getDaysInMonth(this.dateModule.add(month,"month",-1)),today=new this.dateClassObj(),_1553=_1547.getFirstDayOfWeek(this.lang);
if(_1553>_1550){
_1553-=7;
}
this._date2cell={};
array.forEach(this.dateCells,function(_1554,idx){
var i=idx+_1553;
var date=new this.dateClassObj(month),_1555,clazz="dijitCalendar",adj=0;
if(i<_1550){
_1555=_1552-_1550+i+1;
adj=-1;
clazz+="Previous";
}else{
if(i>=(_1550+_1551)){
_1555=i-_1550-_1551+1;
adj=1;
clazz+="Next";
}else{
_1555=i-_1550+1;
clazz+="Current";
}
}
if(adj){
date=this.dateModule.add(date,"month",adj);
}
date.setDate(_1555);
if(!this.dateModule.compare(date,today,"date")){
clazz="dijitCalendarCurrentDate "+clazz;
}
if(this.isDisabledDate(date,this.lang)){
clazz="dijitCalendarDisabledDate "+clazz;
_1554.setAttribute("aria-disabled","true");
}else{
clazz="dijitCalendarEnabledDate "+clazz;
_1554.removeAttribute("aria-disabled");
_1554.setAttribute("aria-selected","false");
}
var _1556=this.getClassForDate(date,this.lang);
if(_1556){
clazz=_1556+" "+clazz;
}
_1554.className=clazz+"Month dijitCalendarDateTemplate";
var _1557=date.valueOf();
this._date2cell[_1557]=_1554;
_1554.dijitDateValue=_1557;
this._setText(this.dateLabels[idx],date.getDateLocalized?date.getDateLocalized(this.lang):date.getDate());
},this);
},_populateControls:function(){
var month=new this.dateClassObj(this.currentFocus);
month.setDate(1);
this.monthWidget.set("month",month);
var y=month.getFullYear()-1;
var d=new this.dateClassObj();
array.forEach(["previous","current","next"],function(name){
d.setFullYear(y++);
this._setText(this[name+"YearLabelNode"],this.dateLocaleModule.format(d,{selector:"year",locale:this.lang}));
},this);
},goToToday:function(){
this.set("value",new this.dateClassObj());
},constructor:function(_1558){
this.dateModule=_1558.datePackage?lang.getObject(_1558.datePackage,false):date;
this.dateClassObj=this.dateModule.Date||Date;
this.dateLocaleModule=_1558.datePackage?lang.getObject(_1558.datePackage+".locale",false):_1548;
},_createMonthWidget:function(){
return _154e._MonthWidget({id:this.id+"_mw",lang:this.lang,dateLocaleModule:this.dateLocaleModule},this.monthNode);
},buildRendering:function(){
var d=this.dowTemplateString,_1559=this.dateLocaleModule.getNames("days",this.dayWidth,"standAlone",this.lang),_155a=_1547.getFirstDayOfWeek(this.lang);
this.dayCellsHtml=_154a.substitute([d,d,d,d,d,d,d].join(""),{d:""},function(){
return _1559[_155a++%7];
});
var r=_154a.substitute(this.weekTemplateString,{d:this.dateTemplateString});
this.dateRowsHtml=[r,r,r,r,r,r].join("");
this.dateCells=[];
this.dateLabels=[];
this.inherited(arguments);
dom.setSelectable(this.domNode,false);
var _155b=new this.dateClassObj(this.currentFocus);
this.monthWidget=this._createMonthWidget();
this.set("currentFocus",_155b,false);
},postCreate:function(){
this.inherited(arguments);
this._connectControls();
},_connectControls:function(){
var _155c=lang.hitch(this,function(_155d,part,_155e){
this.connect(this[_155d],"onclick",function(){
this._setCurrentFocusAttr(this.dateModule.add(this.currentFocus,part,_155e));
});
});
_155c("incrementMonth","month",1);
_155c("decrementMonth","month",-1);
_155c("nextYearLabelNode","year",1);
_155c("previousYearLabelNode","year",-1);
},_setCurrentFocusAttr:function(date,_155f){
var _1560=this.currentFocus,_1561=this._getNodeByDate(_1560);
date=this._patchDate(date);
this._set("currentFocus",date);
if(!this._date2cell||this.dateModule.difference(_1560,date,"month")!=0){
this._populateGrid();
this._populateControls();
this._markSelectedDates([this.value]);
}
var _1562=this._getNodeByDate(date);
_1562.setAttribute("tabIndex",this.tabIndex);
if(this.focused||_155f){
_1562.focus();
}
if(_1561&&_1561!=_1562){
if(has("webkit")){
_1561.setAttribute("tabIndex","-1");
}else{
_1561.removeAttribute("tabIndex");
}
}
},focus:function(){
this._setCurrentFocusAttr(this.currentFocus,true);
},_onDayClick:function(evt){
event.stop(evt);
for(var node=evt.target;node&&!node.dijitDateValue;node=node.parentNode){
}
if(node&&!_1549.contains(node,"dijitCalendarDisabledDate")){
this.set("value",node.dijitDateValue);
}
},_getNodeByDate:function(value){
value=this._patchDate(value);
return value&&this._date2cell?this._date2cell[value.valueOf()]:null;
},_markSelectedDates:function(dates){
function mark(_1563,cell){
_1549.toggle(cell,"dijitCalendarSelectedDate",_1563);
cell.setAttribute("aria-selected",_1563?"true":"false");
};
array.forEach(this._selectedCells||[],lang.partial(mark,false));
this._selectedCells=array.filter(array.map(dates,this._getNodeByDate,this),function(n){
return n;
});
array.forEach(this._selectedCells,lang.partial(mark,true));
},onChange:function(){
},isDisabledDate:function(){
},getClassForDate:function(){
}});
_154e._MonthWidget=_1546("dijit.CalendarLite._MonthWidget",_154b,{_setMonthAttr:function(month){
var _1564=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,month),_1565=(has("ie")==6?"":"<div class='dijitSpacer'>"+array.map(_1564,function(s){
return "<div>"+s+"</div>";
}).join("")+"</div>");
this.domNode.innerHTML=_1565+"<div class='dijitCalendarMonthLabel dijitCalendarCurrentMonthLabel'>"+_1564[month.getMonth()]+"</div>";
}});
return _154e;
});
},"dijit/CheckedMenuItem":function(){
define(["dojo/_base/declare","dojo/dom-class","./MenuItem","dojo/text!./templates/CheckedMenuItem.html","./hccss"],function(_1566,_1567,_1568,_1569){
return _1566("dijit.CheckedMenuItem",_1568,{templateString:_1569,checked:false,_setCheckedAttr:function(_156a){
_1567.toggle(this.domNode,"dijitCheckedMenuItemChecked",_156a);
this.domNode.setAttribute("aria-checked",_156a?"true":"false");
this._set("checked",_156a);
},iconClass:"",onChange:function(){
},_onClick:function(evt){
if(!this.disabled){
this.set("checked",!this.checked);
this.onChange(this.checked);
}
this.onClick(evt);
}});
});
},"dojox/grid/_Events":function(){
define(["dojo/keys","dojo/dom-class","dojo/_base/declare","dojo/_base/event","dojo/_base/sniff"],function(keys,_156b,_156c,event,has){
return _156c("dojox.grid._Events",null,{cellOverClass:"dojoxGridCellOver",onKeyEvent:function(e){
this.dispatchKeyEvent(e);
},onContentEvent:function(e){
this.dispatchContentEvent(e);
},onHeaderEvent:function(e){
this.dispatchHeaderEvent(e);
},onStyleRow:function(inRow){
var i=inRow;
i.customClasses+=(i.odd?" dojoxGridRowOdd":"")+(i.selected?" dojoxGridRowSelected":"")+(i.over?" dojoxGridRowOver":"");
this.focus.styleRow(inRow);
this.edit.styleRow(inRow);
},onKeyDown:function(e){
if(e.altKey||e.metaKey){
return;
}
var _156d;
switch(e.keyCode){
case keys.ESCAPE:
this.edit.cancel();
break;
case keys.ENTER:
if(!this.edit.isEditing()){
_156d=this.focus.getHeaderIndex();
if(_156d>=0){
this.setSortIndex(_156d);
break;
}else{
this.selection.clickSelect(this.focus.rowIndex,dojo.isCopyKey(e),e.shiftKey);
}
event.stop(e);
}
if(!e.shiftKey){
var _156e=this.edit.isEditing();
this.edit.apply();
if(!_156e){
this.edit.setEditCell(this.focus.cell,this.focus.rowIndex);
}
}
if(!this.edit.isEditing()){
var _156f=this.focus.focusView||this.views.views[0];
_156f.content.decorateEvent(e);
this.onRowClick(e);
event.stop(e);
}
break;
case keys.SPACE:
if(!this.edit.isEditing()){
_156d=this.focus.getHeaderIndex();
if(_156d>=0){
this.setSortIndex(_156d);
break;
}else{
this.selection.clickSelect(this.focus.rowIndex,dojo.isCopyKey(e),e.shiftKey);
}
event.stop(e);
}
break;
case keys.TAB:
this.focus[e.shiftKey?"previousKey":"nextKey"](e);
break;
case keys.LEFT_ARROW:
case keys.RIGHT_ARROW:
if(!this.edit.isEditing()){
var _1570=e.keyCode;
event.stop(e);
_156d=this.focus.getHeaderIndex();
if(_156d>=0&&(e.shiftKey&&e.ctrlKey)){
this.focus.colSizeAdjust(e,_156d,(_1570==keys.LEFT_ARROW?-1:1)*5);
}else{
var _1571=(_1570==keys.LEFT_ARROW)?1:-1;
if(this.isLeftToRight()){
_1571*=-1;
}
this.focus.move(0,_1571);
}
}
break;
case keys.UP_ARROW:
if(!this.edit.isEditing()&&this.focus.rowIndex!==0){
event.stop(e);
this.focus.move(-1,0);
}
break;
case keys.DOWN_ARROW:
if(!this.edit.isEditing()&&this.focus.rowIndex+1!=this.rowCount){
event.stop(e);
this.focus.move(1,0);
}
break;
case keys.PAGE_UP:
if(!this.edit.isEditing()&&this.focus.rowIndex!==0){
event.stop(e);
if(this.focus.rowIndex!=this.scroller.firstVisibleRow+1){
this.focus.move(this.scroller.firstVisibleRow-this.focus.rowIndex,0);
}else{
this.setScrollTop(this.scroller.findScrollTop(this.focus.rowIndex-1));
this.focus.move(this.scroller.firstVisibleRow-this.scroller.lastVisibleRow+1,0);
}
}
break;
case keys.PAGE_DOWN:
if(!this.edit.isEditing()&&this.focus.rowIndex+1!=this.rowCount){
event.stop(e);
if(this.focus.rowIndex!=this.scroller.lastVisibleRow-1){
this.focus.move(this.scroller.lastVisibleRow-this.focus.rowIndex-1,0);
}else{
this.setScrollTop(this.scroller.findScrollTop(this.focus.rowIndex+1));
this.focus.move(this.scroller.lastVisibleRow-this.scroller.firstVisibleRow-1,0);
}
}
break;
default:
break;
}
},onMouseOver:function(e){
e.rowIndex==-1?this.onHeaderCellMouseOver(e):this.onCellMouseOver(e);
},onMouseOut:function(e){
e.rowIndex==-1?this.onHeaderCellMouseOut(e):this.onCellMouseOut(e);
},onMouseDown:function(e){
e.rowIndex==-1?this.onHeaderCellMouseDown(e):this.onCellMouseDown(e);
},onMouseOverRow:function(e){
if(!this.rows.isOver(e.rowIndex)){
this.rows.setOverRow(e.rowIndex);
e.rowIndex==-1?this.onHeaderMouseOver(e):this.onRowMouseOver(e);
}
},onMouseOutRow:function(e){
if(this.rows.isOver(-1)){
this.onHeaderMouseOut(e);
}else{
if(!this.rows.isOver(-2)){
this.rows.setOverRow(-2);
this.onRowMouseOut(e);
}
}
},onMouseDownRow:function(e){
if(e.rowIndex!=-1){
this.onRowMouseDown(e);
}
},onCellMouseOver:function(e){
if(e.cellNode){
_156b.add(e.cellNode,this.cellOverClass);
}
},onCellMouseOut:function(e){
if(e.cellNode){
_156b.remove(e.cellNode,this.cellOverClass);
}
},onCellMouseDown:function(e){
},onCellClick:function(e){
this._click[0]=this._click[1];
this._click[1]=e;
if(!this.edit.isEditCell(e.rowIndex,e.cellIndex)){
this.focus.setFocusCell(e.cell,e.rowIndex);
}
if(this._click.length>1&&this._click[0]==null){
this._click.shift();
}
this.onRowClick(e);
},onCellDblClick:function(e){
var event;
if(this._click.length>1&&has("ie")){
event=this._click[1];
}else{
if(this._click.length>1&&this._click[0].rowIndex!=this._click[1].rowIndex){
event=this._click[0];
}else{
event=e;
}
}
this.focus.setFocusCell(event.cell,event.rowIndex);
this.onRowClick(event);
this.edit.setEditCell(event.cell,event.rowIndex);
this.onRowDblClick(e);
},onCellContextMenu:function(e){
this.onRowContextMenu(e);
},onCellFocus:function(_1572,_1573){
this.edit.cellFocus(_1572,_1573);
},onRowClick:function(e){
this.edit.rowClick(e);
this.selection.clickSelectEvent(e);
},onRowDblClick:function(e){
},onRowMouseOver:function(e){
},onRowMouseOut:function(e){
},onRowMouseDown:function(e){
},onRowContextMenu:function(e){
event.stop(e);
},onHeaderMouseOver:function(e){
},onHeaderMouseOut:function(e){
},onHeaderCellMouseOver:function(e){
if(e.cellNode){
_156b.add(e.cellNode,this.cellOverClass);
}
},onHeaderCellMouseOut:function(e){
if(e.cellNode){
_156b.remove(e.cellNode,this.cellOverClass);
}
},onHeaderCellMouseDown:function(e){
},onHeaderClick:function(e){
},onHeaderCellClick:function(e){
this.setSortIndex(e.cell.index);
this.onHeaderClick(e);
},onHeaderDblClick:function(e){
},onHeaderCellDblClick:function(e){
this.onHeaderDblClick(e);
},onHeaderCellContextMenu:function(e){
this.onHeaderContextMenu(e);
},onHeaderContextMenu:function(e){
if(!this.headerMenu){
event.stop(e);
}
},onStartEdit:function(_1574,_1575){
},onApplyCellEdit:function(_1576,_1577,_1578){
},onCancelEdit:function(_1579){
},onApplyEdit:function(_157a){
},onCanSelect:function(_157b){
return true;
},onCanDeselect:function(_157c){
return true;
},onSelected:function(_157d){
this.updateRowStyles(_157d);
},onDeselected:function(_157e){
this.updateRowStyles(_157e);
},onSelectionChanged:function(){
}});
});
},"dojox/grid/util":function(){
define(["../main","dojo/_base/lang","dojo/dom"],function(dojox,lang,dom){
var dgu=lang.getObject("grid.util",true,dojox);
dgu.na="...";
dgu.rowIndexTag="gridRowIndex";
dgu.gridViewTag="gridView";
dgu.fire=function(ob,ev,args){
var fn=ob&&ev&&ob[ev];
return fn&&(args?fn.apply(ob,args):ob[ev]());
};
dgu.setStyleHeightPx=function(_157f,_1580){
if(_1580>=0){
var s=_157f.style;
var v=_1580+"px";
if(_157f&&s["height"]!=v){
s["height"]=v;
}
}
};
dgu.mouseEvents=["mouseover","mouseout","mousedown","mouseup","click","dblclick","contextmenu"];
dgu.keyEvents=["keyup","keydown","keypress"];
dgu.funnelEvents=function(_1581,_1582,_1583,_1584){
var evts=(_1584?_1584:dgu.mouseEvents.concat(dgu.keyEvents));
for(var i=0,l=evts.length;i<l;i++){
_1582.connect(_1581,"on"+evts[i],_1583);
}
};
dgu.removeNode=function(_1585){
_1585=dom.byId(_1585);
_1585&&_1585.parentNode&&_1585.parentNode.removeChild(_1585);
return _1585;
};
dgu.arrayCompare=function(inA,inB){
for(var i=0,l=inA.length;i<l;i++){
if(inA[i]!=inB[i]){
return false;
}
}
return (inA.length==inB.length);
};
dgu.arrayInsert=function(_1586,_1587,_1588){
if(_1586.length<=_1587){
_1586[_1587]=_1588;
}else{
_1586.splice(_1587,0,_1588);
}
};
dgu.arrayRemove=function(_1589,_158a){
_1589.splice(_158a,1);
};
dgu.arraySwap=function(_158b,inI,inJ){
var cache=_158b[inI];
_158b[inI]=_158b[inJ];
_158b[inJ]=cache;
};
return dgu;
});
},"dijit/MenuSeparator":function(){
define(["dojo/_base/declare","dojo/dom","./_WidgetBase","./_TemplatedMixin","./_Contained","dojo/text!./templates/MenuSeparator.html"],function(_158c,dom,_158d,_158e,_158f,_1590){
return _158c("dijit.MenuSeparator",[_158d,_158e,_158f],{templateString:_1590,buildRendering:function(){
this.inherited(arguments);
dom.setSelectable(this.domNode,false);
},isFocusable:function(){
return false;
}});
});
},"davinci/html/HTMLAttribute":function(){
define(["dojo/_base/declare","davinci/html/HTMLItem"],function(_1591,_1592){
return _1591("davinci.html.HTMLAttribute",_1592,{constructor:function(){
this.elementType="HTMLAttribute";
this.name="";
this.value="";
},getText:function(_1593){
if(this.noPersist&&!_1593.includeNoPersist){
return "";
}
var s=this.name;
var bool={checked:1,selected:1,disabled:1,readonly:1,multiple:1,ismap:1,autofocus:1,autoplay:1,controls:1,formnovalidate:1,loop:1,muted:1,required:1};
if(bool[this.name.toLowerCase()]){
if(!this.value||this.value==="false"){
s="";
}else{
s+="=\""+this.value+"\"";
}
}else{
if(!this.noValue){
s=s+"=\""+davinci.html.escapeXml(String(this.value))+"\"";
}
}
return s;
},setValue:function(value){
this.value=davinci.html.unEscapeXml(value);
this.onChange();
}});
});
},"dijit/form/_ComboBoxMenu":function(){
define(["dojo/_base/declare","dojo/dom-class","dojo/dom-style","dojo/keys","../_WidgetBase","../_TemplatedMixin","./_ComboBoxMenuMixin","./_ListMouseMixin"],function(_1594,_1595,_1596,keys,_1597,_1598,_1599,_159a){
return _1594("dijit.form._ComboBoxMenu",[_1597,_1598,_159a,_1599],{templateString:"<div class='dijitReset dijitMenu' data-dojo-attach-point='containerNode' style='overflow: auto; overflow-x: hidden;' role='listbox'>"+"<div class='dijitMenuItem dijitMenuPreviousButton' data-dojo-attach-point='previousButton' role='option'></div>"+"<div class='dijitMenuItem dijitMenuNextButton' data-dojo-attach-point='nextButton' role='option'></div>"+"</div>",baseClass:"dijitComboBoxMenu",postCreate:function(){
this.inherited(arguments);
if(!this.isLeftToRight()){
_1595.add(this.previousButton,"dijitMenuItemRtl");
_1595.add(this.nextButton,"dijitMenuItemRtl");
}
},_createMenuItem:function(){
var item=this.ownerDocument.createElement("div");
item.className="dijitReset dijitMenuItem"+(this.isLeftToRight()?"":" dijitMenuItemRtl");
item.setAttribute("role","option");
return item;
},onHover:function(node){
_1595.add(node,"dijitMenuItemHover");
},onUnhover:function(node){
_1595.remove(node,"dijitMenuItemHover");
},onSelect:function(node){
_1595.add(node,"dijitMenuItemSelected");
},onDeselect:function(node){
_1595.remove(node,"dijitMenuItemSelected");
},_page:function(up){
var _159b=0;
var _159c=this.domNode.scrollTop;
var _159d=_1596.get(this.domNode,"height");
if(!this.getHighlightedOption()){
this.selectNextNode();
}
while(_159b<_159d){
var _159e=this.getHighlightedOption();
if(up){
if(!_159e.previousSibling||_159e.previousSibling.style.display=="none"){
break;
}
this.selectPreviousNode();
}else{
if(!_159e.nextSibling||_159e.nextSibling.style.display=="none"){
break;
}
this.selectNextNode();
}
var _159f=this.domNode.scrollTop;
_159b+=(_159f-_159c)*(up?-1:1);
_159c=_159f;
}
},handleKey:function(evt){
switch(evt.keyCode){
case keys.DOWN_ARROW:
this.selectNextNode();
return false;
case keys.PAGE_DOWN:
this._page(false);
return false;
case keys.UP_ARROW:
this.selectPreviousNode();
return false;
case keys.PAGE_UP:
this._page(true);
return false;
default:
return true;
}
}});
});
},"davinci/ve/utils/GeomUtils":function(){
define(["dojo/_base/window","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/_base/sniff"],function(win,_15a0,_15a1,has,sniff){
var _15a2=["TABLE","TBODY","TR","TD","TH"];
return {getMarginBoxPageCoords:function(node){
var _15a3;
win.withDoc(node.ownerDocument,function(){
var _15a4=this.getBorderBoxPageCoords(node);
var _15a5=this.getMarginExtents(node);
_15a3={l:_15a4.l-_15a5.l,t:_15a4.t-_15a5.t,w:_15a4.w+_15a5.l+_15a5.r,h:_15a4.h+_15a5.t+_15a5.b};
}.bind(this));
return _15a3;
},getMarginBoxPageCoordsCached:function(node){
if(!node._maqMarginBoxPageCoords){
node._maqMarginBoxPageCoords=this.getMarginBoxPageCoords(node);
}
return node._maqMarginBoxPageCoords;
},getBorderBoxPageCoords:function(node){
var o;
win.withDoc(node.ownerDocument,function(){
if(_15a2.indexOf(node.tagName)){
var bcr=node.getBoundingClientRect();
var _15a6=this.getScrollLeft(node);
var _15a7=this.getScrollTop(node);
o={l:bcr.left+_15a6,t:bcr.top+_15a7,w:bcr.width,h:bcr.height};
}else{
var l=node.offsetLeft;
var t=node.offsetTop;
var pn=node.parentNode;
var opn=node.offsetParent;
while(pn&&pn.tagName!="BODY"){
if(typeof pn.scrollLeft=="number"&&typeof pn.scrollTop=="number"){
l-=pn.scrollLeft;
t-=pn.scrollTop;
}
if(pn==opn){
var _15a8=_15a0.getBorderExtents(opn);
l+=opn.offsetLeft+_15a8.l;
t+=opn.offsetTop+_15a8.t;
opn=opn.offsetParent;
}
pn=pn.parentNode;
}
o={l:l,t:t,w:node.offsetWidth,h:node.offsetHeight};
}
}.bind(this));
return o;
},getBorderBoxPageCoordsCached:function(node){
if(!node._maqBorderBoxPageCoords){
node._maqBorderBoxPageCoords=this.getBorderBoxPageCoords(node);
}
return node._maqBorderBoxPageCoords;
},getScrollLeft:function(node){
var doc=node&&node.ownerDocument;
if(has("mozilla")){
var win=doc&&doc.defaultView;
return win?win.pageXOffset:0;
}else{
var body=doc&&doc.body;
return body?body.scrollLeft:0;
}
},getScrollTop:function(node){
var doc=node&&node.ownerDocument;
if(has("mozilla")){
var win=doc&&doc.defaultView;
return win?win.pageYOffset:0;
}else{
var body=doc&&doc.body;
return body?body.scrollTop:0;
}
},getMarginExtents:function getMarginExtents(node,_15a9){
var s=_15a9||_15a1.getComputedStyle(node);
var l,t,r,b;
function px(value){
return parseFloat(value)||0;
};
if(s){
l=px(s.marginLeft);
t=px(s.marginTop);
r=px(s.marginRight);
b=px(s.marginBottom);
}else{
l=t=r=b=0;
}
return {l:l,t:t,r:r,b:b,w:l+r,h:t+b};
},clearGeomCache:function(node){
delete node._maqBorderBoxPageCoords;
delete node._maqMarginBoxPageCoords;
}};
});
},"davinci/html/CSSParser":function(){
define(["dojo/_base/declare","davinci/html/CSSSelector","davinci/html/CSSCombinedSelector","davinci/html/CSSRule","davinci/html/CSSProperty","davinci/html/CSSAtRule","davinci/html/CSSImport","davinci/model/parser/Tokenizer","davinci/model/Comment"],function(_15aa,_15ab,_15ac,_15ad,_15ae,_15af,_15b0,_15b1,_15b2){
var _15b3=null;
var _15b4=(function(){
var _15b5=(function(){
function _15b6(_15b7,_15b8){
var ch=_15b7.next();
if(ch=="@"){
_15b7.nextWhileMatches(/[a-zA-Z0-9_-]/);
return "css-at";
}else{
if(ch=="/"&&_15b7.equals("*")){
_15b8(_15b9);
return null;
}else{
if(ch=="<"&&_15b7.equals("!")){
_15b8(_15ba);
return null;
}else{
if(ch=="="){
return "css-compare";
}else{
if(_15b7.equals("=")&&(ch=="~"||ch=="|")){
_15b7.next();
return "css-compare";
}else{
if(ch=="\""||ch=="'"){
_15b8(_15bb(ch));
return null;
}else{
if(ch=="#"){
_15b7.nextWhileMatches(/[\w-]/);
return "css-hash";
}else{
if(ch=="!"){
_15b7.nextWhileMatches(/[ \t]/);
_15b7.nextWhileMatches(/\w/);
return "css-important";
}else{
if(/\d/.test(ch)){
_15b7.nextWhileMatches(/[\w.%]/);
return "css-unit";
}else{
if(/[,.+>*\/]/.test(ch)){
return "css-select-op";
}else{
if(/[;{}:\[\]]/.test(ch)){
return "css-punctuation";
}else{
_15b7.nextWhileMatches(/[\w\\\-_]/);
return "css-identifier";
}
}
}
}
}
}
}
}
}
}
}
};
function _15b9(_15bc,_15bd){
var _15be=false;
while(!_15bc.endOfLine()){
var ch=_15bc.next();
if(_15be&&ch=="/"){
_15bd(_15b6);
break;
}
_15be=(ch=="*");
}
return "css-comment";
};
function _15ba(_15bf,_15c0){
var _15c1=0;
while(!_15bf.endOfLine()){
var ch=_15bf.next();
if(_15c1>=2&&ch==">"){
_15c0(_15b6);
break;
}
_15c1=(ch=="-")?_15c1+1:0;
}
return "css-comment";
};
function _15bb(quote){
return function(_15c2,_15c3){
var _15c4=false;
while(!_15c2.endOfLine()){
var ch=_15c2.next();
if(ch==quote&&!_15c4){
break;
}
_15c4=!_15c4&&ch=="\\";
}
if(!_15c4){
_15c3(_15b6);
}
return "css-string";
};
};
return function(_15c5,_15c6){
return _15b1.tokenizer(_15c5,_15c6||_15b6);
};
})();
function _15c7(_15c8,_15c9,base){
return function(_15ca){
if(!_15c8||/^\}/.test(_15ca)){
return base;
}else{
if(_15c9){
return base+indentUnit*2;
}else{
return base+indentUnit;
}
}
};
};
function _15cb(_15cc,_15cd){
_15cd=_15cd||0;
var _15ce=_15b5(_15cc);
var _15cf=false,_15d0=false,_15d1=false;
var iter={next:function(){
var token=_15ce.next(),style=token.style,_15d2=token.content;
if(style=="css-hash"){
style=token.style=_15d0?"css-colorcode":"css-identifier";
}
if(style=="css-identifier"){
if(_15d0){
token.style="css-value";
}else{
if(!_15cf&&!_15d1){
token.style="css-selector";
}
}
}
if(_15d2=="\n"){
token.indentation=_15c7(_15cf,_15d0,_15cd);
}
if(_15d2=="{"&&_15d1=="@media"){
_15d1=false;
}else{
if(_15d2=="{"){
_15cf=true;
}else{
if(_15d2=="}"){
_15cf=_15d0=_15d1=false;
}else{
if(_15d2==";"){
_15d0=_15d1=false;
}else{
if(_15cf&&style!="css-comment"&&style!="whitespace"){
_15d0=true;
}else{
if(!_15cf&&style=="css-at"){
_15d1=_15d2;
}
}
}
}
}
}
return token;
},copy:function(){
var _15d3=_15cf,_15d4=_15d0,_15d5=_15ce.state;
return function(_15d6){
_15ce=_15b5(_15d6,_15d5);
_15cf=_15d3;
_15d0=_15d4;
return iter;
};
}};
return iter;
};
return {make:_15cb,electricChars:"}"};
})();
_15b4.parse=function(text,_15d7){
var _15d8,_15d9;
if(typeof text=="string"){
var _15da={next:function(){
if(++this.count==1){
return text;
}else{
throw StopIteration;
}
},count:0,text:text};
_15d8=_15b1.stringStream(_15da);
}else{
_15d8=text;
_15d9=true;
}
var _15db=_15b4.make(_15d8);
var token;
var _15dc;
var _15dd;
var _15de=" ";
var _15df=[];
var _15e0=[];
var model,_15e1;
function error(text){
_15df.push(text);
};
function _15e2(){
var start,stop,s;
token=_15db.next();
var _15e3=false;
while(token.style=="css-comment"||token.style=="whitespace"){
if(token.style=="css-comment"||_15e3){
if(!_15b3){
_15b3=new _15b2();
}
s=token.content;
if(token.content.indexOf("/*")===0){
s=s.substring(2);
_15e3=true;
_15b3.addComment("block",start,stop,"");
}
if((s.lastIndexOf("*/")>-1)&&(s.lastIndexOf("*/")==s.length-2)){
s=s.substring(0,s.length-2);
_15e3=false;
}
_15b3.appendComment(s);
}
token=_15db.next();
}
return token;
};
function _15e4(){
_15dc=new _15ab();
_15dc.startOffset=token.offset;
_15dc.parent=model;
if(_15dd){
_15dd.selectors.push(_15dc);
_15dc.parent=_15dd;
}else{
model.selectors.push(_15dc);
}
};
function _15e5(){
var prev=_15dc;
prev.endOffset=token.offset-1;
if(!_15dd){
_15dd=new _15ac();
_15dd.parent=model;
_15dd.selectors.push(prev);
_15dc.startOffset=prev.startOffset;
model.selectors[model.selectors.length-1]=_15dd;
}
_15e4();
_15dd.combiners.push(_15de);
_15de=" ";
};
var _15e6;
try{
do{
_15e2();
switch(token.style){
case "css-selector":
case "css-select-op":
if(_15d9&&token.content=="<"){
_15d8.push("<");
throw StopIteration;
}
model=new _15ad();
_15e0.push(model);
model.startOffset=token.offset;
if(_15d7){
_15d7.addChild(model,undefined,true);
}
_15e1=false;
_15dd=undefined;
_15de=" ";
_15e4();
selectorLoop:
for(;;){
switch(token.style){
case "css-select-op":
switch(token.content){
case ",":
_15dd=undefined;
_15e6=false;
_15e4();
break;
case ".":
if(_15e1){
_15e5();
}
_15e2();
if(_15dc.cls){
_15dc.cls=_15dc.cls+"."+token.content;
}else{
_15dc.cls=token.content;
}
_15e1=token.value.length>token.content.length;
break;
case "*":
if(_15dc.element||_15dc.cls){
_15e5();
}
_15dc.element="*";
break;
case "+":
case ">":
_15de=token.content;
_15e5();
break;
}
break;
case "css-selector":
if(token.type=="css-identifier"){
if(_15dc.element||_15dc.cls||_15e1){
_15e5();
}
_15dc.element=token.content;
}else{
if(token.type=="css-hash"){
if(_15dc.id||_15e1){
_15e5();
}
_15dc.id=token.content.substring(1);
}
}
_15e1=token.value.length>token.content.length;
break;
case "css-punctuation":
if(token.content=="{"){
break selectorLoop;
}else{
if(token.content==":"){
_15e2();
if(token.content==":"){
_15e2();
_15dc.pseudoElement=token.content;
}else{
_15dc.pseudoRule=token.content;
_15e1=true;
}
}else{
if(token.content=="["){
_15e2();
_15dc.attribute={name:token.content};
_15e2();
if(token.content==="="||token.content==="~="||token.content==="|="){
_15dc.attribute.type=token.content;
_15e2();
_15dc.attribute.value=token.content.substring(1,token.content.length-1);
_15e2();
}
}
}
}
break;
}
_15e6=true;
_15e2();
}
if(_15b3){
model.comment=_15b3;
_15b3=null;
}
_15dc.endOffset=token.offset-1;
while(_15e2().content!="}"){
var _15e7=token.offset;
var _15e8=token.content;
var _15e9=false;
if(token.type=="css-hash"){
_15e2();
if(token.type=="css-identifier"){
_15e8+=token.content;
}else{
_15e9=true;
}
}else{
if(token.type!="css-identifier"){
if(token.content!="*"){
error("expecting identifier around "+_15dc.getText()+"{ "+_15ea.name+": "+propery.value);
}else{
_15e2();
_15e8+=token.content;
}
}
}
var _15ea=new _15ae();
_15ea.startOffset=_15e7;
_15ea.parent=model;
if(_15b3){
_15ea.comment=_15b3;
_15b3=null;
}
model.properties.push(_15ea);
model.addChild(_15ea,undefined,true);
_15ea.name=_15e8;
if(!_15e9){
if(_15e2().content!=":"){
error("expecting ':' "+_15dc.getText()+"{ "+_15ea.name+": "+propery.value);
}
}
_15e2();
_15ea.value=token.value;
if(_15ea.value=="url"){
while((_15e2()).content!=")"){
_15ea.value+=token.value;
}
_15ea.value+=token.value;
}
while((_15e2()).content!=";"&&token.content!="}"){
_15ea.value+=token.value;
}
if(_15b3){
_15ea.postComment=_15b3;
_15b3=null;
}
_15ea.endOffset=token.offset-1;
if(token.content=="}"){
break;
}
}
if(_15b3){
_15ea.postComment=_15b3;
_15b3=null;
}
model.endOffset=token.offset;
break;
case "css-at":
var _15eb=token.content.substring(1);
var _15ec=(_15eb=="import")?new _15b0():new _15af();
_15ec.startOffset=token.offset;
if(_15d7){
_15d7.addChild(_15ec,undefined,true);
}
if(_15eb=="import"){
var _15ed=_15ec;
_15e2();
if(token.content=="url"){
_15ed.isURL=true;
_15e2();
_15e2();
}
_15ed.url=token.content.substring(1,token.content.length-1);
if(_15ed.isURL){
_15e2();
}
_15e2();
}else{
if(_15eb.indexOf("keyframes")>=0){
var _15ee="";
var _15ef="";
var _15f0=false;
var _15f1="\t\t";
_15e2();
_15ee=token.content;
if(_15ee=="."){
_15e2();
_15ee+=token.content;
}
_15e2();
_15ec.value=token.content+"\n";
_15e2();
if(token.content.indexOf("from")>=0||token.content.indexOf("to")>=0||token.content.indexOf("%")>=0){
outerLoop:
for(;;){
_15ec.value+="\t"+token.content+" ";
_15e2();
_15ec.value+=token.content+"\n";
while((_15e2()).content!="}"){
if(_15f0){
_15f1="\t\t";
_15f0=false;
}
if(token.content==";"){
_15ef="\n";
_15f0=true;
}else{
if(token.content==":"||token.content==")"){
_15ef=" ";
}
}
_15ec.value+=_15f1+token.content+_15ef;
_15ef="";
_15f1="";
}
_15ec.value+="\t"+token.content+"\n";
_15e2();
if(token.content=="}"){
break outerLoop;
}
}
}else{
error("inside keyframes decl expecting from/to blocks or nn% blocks");
}
_15ec.value+=token.content;
_15ec.name=_15eb+" "+_15ee;
}else{
_15ec.name=_15eb;
_15ec.value="";
while((_15e2()).content!=";"){
_15ec.value+=token.content;
}
}
}
_15ec.endOffset=token.offset;
break;
}
}while(true);
}
catch(e){
if(_15b3&&model){
model.postComment=_15b3;
_15b3=null;
}
}
return {errors:_15df,model:_15e0};
};
return _15b4;
});
},"url:dijit/layout/templates/ScrollingTabController.html":"<div class=\"dijitTabListContainer-${tabPosition}\" style=\"visibility:hidden\">\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerMenuButton\"\n\t\t\tclass=\"tabStripButton-${tabPosition}\"\n\t\t\tid=\"${id}_menuBtn\"\n\t\t\tdata-dojo-props=\"containerId: '${containerId}', iconClass: 'dijitTabStripMenuIcon',\n\t\t\t\t\tdropDownPosition: ['below-alt', 'above-alt']\"\n\t\t\tdata-dojo-attach-point=\"_menuBtn\" showLabel=\"false\" title=\"\">&#9660;</div>\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerButton\"\n\t\t\tclass=\"tabStripButton-${tabPosition}\"\n\t\t\tid=\"${id}_leftBtn\"\n\t\t\tdata-dojo-props=\"iconClass:'dijitTabStripSlideLeftIcon', showLabel:false, title:''\"\n\t\t\tdata-dojo-attach-point=\"_leftBtn\" data-dojo-attach-event=\"onClick: doSlideLeft\">&#9664;</div>\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerButton\"\n\t\t\tclass=\"tabStripButton-${tabPosition}\"\n\t\t\tid=\"${id}_rightBtn\"\n\t\t\tdata-dojo-props=\"iconClass:'dijitTabStripSlideRightIcon', showLabel:false, title:''\"\n\t\t\tdata-dojo-attach-point=\"_rightBtn\" data-dojo-attach-event=\"onClick: doSlideRight\">&#9654;</div>\n\t<div class='dijitTabListWrapper' data-dojo-attach-point='tablistWrapper'>\n\t\t<div role='tablist' data-dojo-attach-event='onkeypress:onkeypress'\n\t\t\t\tdata-dojo-attach-point='containerNode' class='nowrapTabStrip'></div>\n\t</div>\n</div>","url:davinci/de/widgets/templates/NewDijit.html":"<div>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<table>\n\t\t<tr style='display:none;'>\n\t\t<td class=\"NewProjectDialogLabel\">Widget Group:</td><td><input class='templateInput' type='text' dojoAttachPoint=\"_widgetGroup\" vaule='MyWidgets'></input></td><td><div dojoAttachPoint='_error3'></div></td>\n\t\t\n\t\t</tr>\n\t\t\n\t\t<tr>\n\t\t<td class=\"NewProjectDialogLabel\">Widget Name:</td><td><input class='templateInput' type='text' dojoAttachPoint=\"_dijitName\"></input></td><td><div dojoAttachPoint='_error4'></div></td>\n\t\t</tr>\n\t\t<tr style='display:none;'>\n\t\t<td class=\"NewProjectDialogLabel\">Replace Selection with new Widget</td><td><input class='templateInput' type='checkbox' dojoAttachPoint=\"_replaceSelection\"></input></td><td><div dojoAttachPoint='_error5'></div></td>\n\t\t</tr>\n\t\t</table>\n\t</div>\n\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button dojoType='dijit.form.Button' dojoAttachPoint=\"_okButton\" dojoAttachEvent='onClick:okButton' label='OK' type=\"submit\" class=\"maqPrimaryButton\" disabled></button> \n\t\t<button dojoType='dijit.form.Button' dojoAttachEvent='onClick:cancelButton' label='Cancel' class=\"maqSecondaryButton\"></button>\n\t</div>\t\t\n</div>","dojox/grid/cells/_base":function(){
define(["dojo/_base/kernel","dojo/_base/declare","dojo/_base/lang","dojo/_base/event","dojo/_base/connect","dojo/_base/array","dojo/_base/sniff","dojo/dom","dojo/dom-attr","dojo/dom-construct","dijit/_Widget","../util"],function(dojo,_15f2,lang,event,_15f3,array,has,dom,_15f4,_15f5,_15f6,util){
var _15f7=_15f2("dojox.grid._DeferredTextWidget",_15f6,{deferred:null,_destroyOnRemove:true,postCreate:function(){
if(this.deferred){
this.deferred.addBoth(lang.hitch(this,function(text){
if(this.domNode){
this.domNode.innerHTML=text;
}
}));
}
}});
var _15f8=function(_15f9){
try{
util.fire(_15f9,"focus");
util.fire(_15f9,"select");
}
catch(e){
}
};
var _15fa=function(){
setTimeout(lang.hitch.apply(dojo,arguments),0);
};
var _15fb=_15f2("dojox.grid.cells._Base",null,{styles:"",classes:"",editable:false,alwaysEditing:false,formatter:null,defaultValue:"...",value:null,hidden:false,noresize:false,draggable:true,_valueProp:"value",_formatPending:false,constructor:function(_15fc){
this._props=_15fc||{};
lang.mixin(this,_15fc);
if(this.draggable===undefined){
this.draggable=true;
}
},_defaultFormat:function(_15fd,_15fe){
var s=this.grid.formatterScope||this;
var f=this.formatter;
if(f&&s&&typeof f=="string"){
f=this.formatter=s[f];
}
var v=(_15fd!=this.defaultValue&&f)?f.apply(s,_15fe):_15fd;
if(typeof v=="undefined"){
return this.defaultValue;
}
if(v&&v.addBoth){
v=new _15f7({deferred:v},_15f5.create("span",{innerHTML:this.defaultValue}));
}
if(v&&v.declaredClass&&v.startup){
return "<div class='dojoxGridStubNode' linkWidget='"+v.id+"' cellIdx='"+this.index+"'>"+this.defaultValue+"</div>";
}
return v;
},format:function(_15ff,_1600){
var f,i=this.grid.edit.info,d=this.get?this.get(_15ff,_1600):(this.value||this.defaultValue);
d=(d&&d.replace&&this.grid.escapeHTMLInData)?d.replace(/&/g,"&amp;").replace(/</g,"&lt;"):d;
if(this.editable&&(this.alwaysEditing||(i.rowIndex==_15ff&&i.cell==this))){
return this.formatEditing(d,_15ff);
}else{
return this._defaultFormat(d,[d,_15ff,this]);
}
},formatEditing:function(_1601,_1602){
},getNode:function(_1603){
return this.view.getCellNode(_1603,this.index);
},getHeaderNode:function(){
return this.view.getHeaderCellNode(this.index);
},getEditNode:function(_1604){
return (this.getNode(_1604)||0).firstChild||0;
},canResize:function(){
var uw=this.unitWidth;
return uw&&(uw!=="auto");
},isFlex:function(){
var uw=this.unitWidth;
return uw&&lang.isString(uw)&&(uw=="auto"||uw.slice(-1)=="%");
},applyEdit:function(_1605,_1606){
if(this.getNode(_1606)){
this.grid.edit.applyCellEdit(_1605,this,_1606);
}
},cancelEdit:function(_1607){
this.grid.doCancelEdit(_1607);
},_onEditBlur:function(_1608){
if(this.grid.edit.isEditCell(_1608,this.index)){
this.grid.edit.apply();
}
},registerOnBlur:function(_1609,_160a){
if(this.commitOnBlur){
_15f3.connect(_1609,"onblur",function(e){
setTimeout(lang.hitch(this,"_onEditBlur",_160a),250);
});
}
},needFormatNode:function(_160b,_160c){
this._formatPending=true;
_15fa(this,"_formatNode",_160b,_160c);
},cancelFormatNode:function(){
this._formatPending=false;
},_formatNode:function(_160d,_160e){
if(this._formatPending){
this._formatPending=false;
if(!has("ie")){
dom.setSelectable(this.grid.domNode,true);
}
this.formatNode(this.getEditNode(_160e),_160d,_160e);
}
},formatNode:function(_160f,_1610,_1611){
if(has("ie")){
_15fa(this,"focus",_1611,_160f);
}else{
this.focus(_1611,_160f);
}
},dispatchEvent:function(m,e){
if(m in this){
return this[m](e);
}
},getValue:function(_1612){
return this.getEditNode(_1612)[this._valueProp];
},setValue:function(_1613,_1614){
var n=this.getEditNode(_1613);
if(n){
n[this._valueProp]=_1614;
}
},focus:function(_1615,_1616){
_15f8(_1616||this.getEditNode(_1615));
},save:function(_1617){
this.value=this.value||this.getValue(_1617);
},restore:function(_1618){
this.setValue(_1618,this.value);
},_finish:function(_1619){
dom.setSelectable(this.grid.domNode,false);
this.cancelFormatNode();
},apply:function(_161a){
this.applyEdit(this.getValue(_161a),_161a);
this._finish(_161a);
},cancel:function(_161b){
this.cancelEdit(_161b);
this._finish(_161b);
}});
_15fb.markupFactory=function(node,_161c){
var _161d=lang.trim(_15f4.get(node,"formatter")||"");
if(_161d){
_161c.formatter=lang.getObject(_161d)||_161d;
}
var get=lang.trim(_15f4.get(node,"get")||"");
if(get){
_161c.get=lang.getObject(get);
}
var _161e=function(attr,cell,_161f){
var value=lang.trim(_15f4.get(node,attr)||"");
if(value){
cell[_161f||attr]=!(value.toLowerCase()=="false");
}
};
_161e("sortDesc",_161c);
_161e("editable",_161c);
_161e("alwaysEditing",_161c);
_161e("noresize",_161c);
_161e("draggable",_161c);
var value=lang.trim(_15f4.get(node,"loadingText")||_15f4.get(node,"defaultValue")||"");
if(value){
_161c.defaultValue=value;
}
var _1620=function(attr,cell,_1621){
var value=lang.trim(_15f4.get(node,attr)||"")||undefined;
if(value){
cell[_1621||attr]=value;
}
};
_1620("styles",_161c);
_1620("headerStyles",_161c);
_1620("cellStyles",_161c);
_1620("classes",_161c);
_1620("headerClasses",_161c);
_1620("cellClasses",_161c);
};
var Cell=_15f2("dojox.grid.cells.Cell",_15fb,{constructor:function(){
this.keyFilter=this.keyFilter;
},keyFilter:null,formatEditing:function(_1622,_1623){
this.needFormatNode(_1622,_1623);
return "<input class=\"dojoxGridInput\" type=\"text\" value=\""+_1622+"\">";
},formatNode:function(_1624,_1625,_1626){
this.inherited(arguments);
this.registerOnBlur(_1624,_1626);
},doKey:function(e){
if(this.keyFilter){
var key=String.fromCharCode(e.charCode);
if(key.search(this.keyFilter)==-1){
event.stop(e);
}
}
},_finish:function(_1627){
this.inherited(arguments);
var n=this.getEditNode(_1627);
try{
util.fire(n,"blur");
}
catch(e){
}
}});
Cell.markupFactory=function(node,_1628){
_15fb.markupFactory(node,_1628);
var _1629=lang.trim(_15f4.get(node,"keyFilter")||"");
if(_1629){
_1628.keyFilter=new RegExp(_1629);
}
};
var _162a=_15f2("dojox.grid.cells.RowIndex",Cell,{name:"Row",postscript:function(){
this.editable=false;
},get:function(_162b){
return _162b+1;
}});
_162a.markupFactory=function(node,_162c){
Cell.markupFactory(node,_162c);
};
var _162d=_15f2("dojox.grid.cells.Select",Cell,{options:null,values:null,returnIndex:-1,constructor:function(_162e){
this.values=this.values||this.options;
},formatEditing:function(_162f,_1630){
this.needFormatNode(_162f,_1630);
var h=["<select class=\"dojoxGridSelect\">"];
for(var i=0,o,v;((o=this.options[i])!==undefined)&&((v=this.values[i])!==undefined);i++){
v=v.replace?v.replace(/&/g,"&amp;").replace(/</g,"&lt;"):v;
o=o.replace?o.replace(/&/g,"&amp;").replace(/</g,"&lt;"):o;
h.push("<option",(_162f==v?" selected":"")," value=\""+v+"\"",">",o,"</option>");
}
h.push("</select>");
return h.join("");
},_defaultFormat:function(_1631,_1632){
var v=this.inherited(arguments);
if(!this.formatter&&this.values&&this.options){
var i=array.indexOf(this.values,v);
if(i>=0){
v=this.options[i];
}
}
return v;
},getValue:function(_1633){
var n=this.getEditNode(_1633);
if(n){
var i=n.selectedIndex,o=n.options[i];
return this.returnIndex>-1?i:o.value||o.innerHTML;
}
}});
_162d.markupFactory=function(node,cell){
Cell.markupFactory(node,cell);
var _1634=lang.trim(_15f4.get(node,"options")||"");
if(_1634){
var o=_1634.split(",");
if(o[0]!=_1634){
cell.options=o;
}
}
var _1635=lang.trim(_15f4.get(node,"values")||"");
if(_1635){
var v=_1635.split(",");
if(v[0]!=_1635){
cell.values=v;
}
}
};
var _1636=_15f2("dojox.grid.cells.AlwaysEdit",Cell,{alwaysEditing:true,_formatNode:function(_1637,_1638){
this.formatNode(this.getEditNode(_1638),_1637,_1638);
},applyStaticValue:function(_1639){
var e=this.grid.edit;
e.applyCellEdit(this.getValue(_1639),this,_1639);
e.start(this,_1639,true);
}});
_1636.markupFactory=function(node,cell){
Cell.markupFactory(node,cell);
};
var Bool=_15f2("dojox.grid.cells.Bool",_1636,{_valueProp:"checked",formatEditing:function(_163a,_163b){
return "<input class=\"dojoxGridInput\" type=\"checkbox\""+(_163a?" checked=\"checked\"":"")+" style=\"width: auto\" />";
},doclick:function(e){
if(e.target.tagName=="INPUT"){
this.applyStaticValue(e.rowIndex);
}
}});
Bool.markupFactory=function(node,cell){
_1636.markupFactory(node,cell);
};
return _15fb;
});
},"dijit/Dialog":function(){
define(["require","dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/_base/fx","dojo/i18n","dojo/keys","dojo/_base/lang","dojo/on","dojo/ready","dojo/sniff","dojo/window","dojo/dnd/Moveable","dojo/dnd/TimedMoveable","./focus","./_base/manager","./_Widget","./_TemplatedMixin","./_CssStateMixin","./form/_FormMixin","./_DialogMixin","./DialogUnderlay","./layout/ContentPane","dojo/text!./templates/Dialog.html","./main","dojo/i18n!./nls/common"],function(_163c,array,_163d,_163e,_163f,dom,_1640,_1641,_1642,event,fx,i18n,keys,lang,on,ready,has,_1643,_1644,_1645,focus,_1646,_1647,_1648,_1649,_164a,_164b,_164c,_164d,_164e,dijit){
var _164f=_163e("dijit._DialogBase",[_1648,_164a,_164b,_1649],{templateString:_164e,baseClass:"dijitDialog",cssStateNodes:{closeButtonNode:"dijitDialogCloseIcon"},_setTitleAttr:[{node:"titleNode",type:"innerHTML"},{node:"titleBar",type:"attribute"}],open:false,duration:_1646.defaultDuration,refocus:true,autofocus:true,_firstFocusItem:null,_lastFocusItem:null,doLayout:false,draggable:true,_setDraggableAttr:function(val){
this._set("draggable",val);
},"aria-describedby":"",maxRatio:0.9,postMixInProperties:function(){
var _1650=i18n.getLocalization("dijit","common");
lang.mixin(this,_1650);
this.inherited(arguments);
},postCreate:function(){
_1642.set(this.domNode,{display:"none",position:"absolute"});
this.ownerDocumentBody.appendChild(this.domNode);
this.inherited(arguments);
this.connect(this,"onExecute","hide");
this.connect(this,"onCancel","hide");
this._modalconnects=[];
},onLoad:function(){
this._position();
if(this.autofocus&&_1651.isTop(this)){
this._getFocusItems(this.domNode);
focus.focus(this._firstFocusItem);
}
this.inherited(arguments);
},_onBlur:function(by){
this.inherited(arguments);
var _1652=lang.hitch(this,function(){
if(this.open&&!this._destroyed&&_1651.isTop(this)){
this._getFocusItems(this.domNode);
focus.focus(this._firstFocusItem);
}
});
if(by=="mouse"){
on.once(this.ownerDocument,"mouseup",_1652);
}else{
_1652();
}
},_endDrag:function(){
var _1653=_1641.position(this.domNode),_1654=_1643.getBox(this.ownerDocument);
_1653.y=Math.min(Math.max(_1653.y,0),(_1654.h-_1653.h));
_1653.x=Math.min(Math.max(_1653.x,0),(_1654.w-_1653.w));
this._relativePosition=_1653;
this._position();
},_setup:function(){
var node=this.domNode;
if(this.titleBar&&this.draggable){
this._moveable=new ((has("ie")==6)?_1645:_1644)(node,{handle:this.titleBar});
this.connect(this._moveable,"onMoveStop","_endDrag");
}else{
_1640.add(node,"dijitDialogFixed");
}
this.underlayAttrs={dialogId:this.id,"class":array.map(this["class"].split(/\s/),function(s){
return s+"_underlay";
}).join(" "),ownerDocument:this.ownerDocument};
},_size:function(){
this._checkIfSingleChild();
if(this._singleChild){
if(typeof this._singleChildOriginalStyle!="undefined"){
this._singleChild.domNode.style.cssText=this._singleChildOriginalStyle;
delete this._singleChildOriginalStyle;
}
}else{
_1642.set(this.containerNode,{width:"auto",height:"auto"});
}
var bb=_1641.position(this.domNode);
var _1655=_1643.getBox(this.ownerDocument);
_1655.w*=this.maxRatio;
_1655.h*=this.maxRatio;
if(bb.w>=_1655.w||bb.h>=_1655.h){
var _1656=_1641.position(this.containerNode),w=Math.min(bb.w,_1655.w)-(bb.w-_1656.w),h=Math.min(bb.h,_1655.h)-(bb.h-_1656.h);
if(this._singleChild&&this._singleChild.resize){
if(typeof this._singleChildOriginalStyle=="undefined"){
this._singleChildOriginalStyle=this._singleChild.domNode.style.cssText;
}
this._singleChild.resize({w:w,h:h});
}else{
_1642.set(this.containerNode,{width:w+"px",height:h+"px",overflow:"auto",position:"relative"});
}
}else{
if(this._singleChild&&this._singleChild.resize){
this._singleChild.resize();
}
}
},_position:function(){
if(!_1640.contains(this.ownerDocumentBody,"dojoMove")){
var node=this.domNode,_1657=_1643.getBox(this.ownerDocument),p=this._relativePosition,bb=p?null:_1641.position(node),l=Math.floor(_1657.l+(p?p.x:(_1657.w-bb.w)/2)),t=Math.floor(_1657.t+(p?p.y:(_1657.h-bb.h)/2));
_1642.set(node,{left:l+"px",top:t+"px"});
}
},_onKey:function(evt){
if(evt.charOrCode){
var node=evt.target;
if(evt.charOrCode===keys.TAB){
this._getFocusItems(this.domNode);
}
var _1658=(this._firstFocusItem==this._lastFocusItem);
if(node==this._firstFocusItem&&evt.shiftKey&&evt.charOrCode===keys.TAB){
if(!_1658){
focus.focus(this._lastFocusItem);
}
event.stop(evt);
}else{
if(node==this._lastFocusItem&&evt.charOrCode===keys.TAB&&!evt.shiftKey){
if(!_1658){
focus.focus(this._firstFocusItem);
}
event.stop(evt);
}else{
while(node){
if(node==this.domNode||_1640.contains(node,"dijitPopup")){
if(evt.charOrCode==keys.ESCAPE){
this.onCancel();
}else{
return;
}
}
node=node.parentNode;
}
if(evt.charOrCode!==keys.TAB){
event.stop(evt);
}else{
if(!has("opera")){
try{
this._firstFocusItem.focus();
}
catch(e){
}
}
}
}
}
}
},show:function(){
if(this.open){
return;
}
if(!this._started){
this.startup();
}
if(!this._alreadyInitialized){
this._setup();
this._alreadyInitialized=true;
}
if(this._fadeOutDeferred){
this._fadeOutDeferred.cancel();
}
var win=_1643.get(this.ownerDocument);
this._modalconnects.push(on(win,"scroll",lang.hitch(this,"resize")));
this._modalconnects.push(on(this.domNode,_163d._keypress,lang.hitch(this,"_onKey")));
_1642.set(this.domNode,{opacity:0,display:""});
this._set("open",true);
this._onShow();
this._size();
this._position();
var _1659;
this._fadeInDeferred=new _163f(lang.hitch(this,function(){
_1659.stop();
delete this._fadeInDeferred;
}));
_1659=fx.fadeIn({node:this.domNode,duration:this.duration,beforeBegin:lang.hitch(this,function(){
_1651.show(this,this.underlayAttrs);
}),onEnd:lang.hitch(this,function(){
if(this.autofocus&&_1651.isTop(this)){
this._getFocusItems(this.domNode);
focus.focus(this._firstFocusItem);
}
this._fadeInDeferred.resolve(true);
delete this._fadeInDeferred;
})}).play();
return this._fadeInDeferred;
},hide:function(){
if(!this._alreadyInitialized||!this.open){
return;
}
if(this._fadeInDeferred){
this._fadeInDeferred.cancel();
}
var _165a;
this._fadeOutDeferred=new _163f(lang.hitch(this,function(){
_165a.stop();
delete this._fadeOutDeferred;
}));
this._fadeOutDeferred.then(lang.hitch(this,"onHide"));
_165a=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,function(){
this.domNode.style.display="none";
_1651.hide(this);
this._fadeOutDeferred.resolve(true);
delete this._fadeOutDeferred;
})}).play();
if(this._scrollConnected){
this._scrollConnected=false;
}
var h;
while(h=this._modalconnects.pop()){
h.remove();
}
if(this._relativePosition){
delete this._relativePosition;
}
this._set("open",false);
return this._fadeOutDeferred;
},resize:function(){
if(this.domNode.style.display!="none"){
if(_164c._singleton){
_164c._singleton.layout();
}
this._position();
this._size();
}
},destroy:function(){
if(this._fadeInDeferred){
this._fadeInDeferred.cancel();
}
if(this._fadeOutDeferred){
this._fadeOutDeferred.cancel();
}
if(this._moveable){
this._moveable.destroy();
}
var h;
while(h=this._modalconnects.pop()){
h.remove();
}
_1651.hide(this);
this.inherited(arguments);
}});
var _165b=_163e("dijit.Dialog",[_164d,_164f],{});
_165b._DialogBase=_164f;
var _1651=_165b._DialogLevelManager={_beginZIndex:950,show:function(_165c,_165d){
ds[ds.length-1].focus=focus.curNode;
var _165e=_164c._singleton;
if(!_165e||_165e._destroyed){
_165e=dijit._underlay=_164c._singleton=new _164c(_165d);
}else{
_165e.set(_165c.underlayAttrs);
}
var _165f=ds[ds.length-1].dialog?ds[ds.length-1].zIndex+2:_165b._DialogLevelManager._beginZIndex;
if(ds.length==1){
_165e.show();
}
_1642.set(_164c._singleton.domNode,"zIndex",_165f-1);
_1642.set(_165c.domNode,"zIndex",_165f);
ds.push({dialog:_165c,underlayAttrs:_165d,zIndex:_165f});
},hide:function(_1660){
if(ds[ds.length-1].dialog==_1660){
ds.pop();
var pd=ds[ds.length-1];
if(!_164c._singleton._destroyed){
if(ds.length==1){
_164c._singleton.hide();
}else{
_1642.set(_164c._singleton.domNode,"zIndex",pd.zIndex-1);
_164c._singleton.set(pd.underlayAttrs);
}
}
if(_1660.refocus){
var focus=pd.focus;
if(pd.dialog&&(!focus||!dom.isDescendant(focus,pd.dialog.domNode))){
pd.dialog._getFocusItems(pd.dialog.domNode);
focus=pd.dialog._firstFocusItem;
}
if(focus){
try{
focus.focus();
}
catch(e){
}
}
}
}else{
var idx=array.indexOf(array.map(ds,function(elem){
return elem.dialog;
}),_1660);
if(idx!=-1){
ds.splice(idx,1);
}
}
},isTop:function(_1661){
return ds[ds.length-1].dialog==_1661;
}};
var ds=_165b._dialogStack=[{dialog:null,focus:null,underlayAttrs:null}];
if(has("dijit-legacy-requires")){
ready(0,function(){
var _1662=["dijit/TooltipDialog"];
_163c(_1662);
});
}
return _165b;
});
},"dijit/form/_DateTimeTextBox":function(){
define(["dojo/date","dojo/date/locale","dojo/date/stamp","dojo/_base/declare","dojo/_base/lang","./RangeBoundTextBox","../_HasDropDown","dojo/text!./templates/DropDownBox.html"],function(date,_1663,stamp,_1664,lang,_1665,_1666,_1667){
new Date("X");
var _1668=_1664("dijit.form._DateTimeTextBox",[_1665,_1666],{templateString:_1667,hasDownArrow:true,cssStateNodes:{"_buttonNode":"dijitDownArrowButton"},pattern:_1663.regexp,datePackage:"",postMixInProperties:function(){
this.inherited(arguments);
this._set("type","text");
},compare:function(val1,val2){
var _1669=this._isInvalidDate(val1);
var _166a=this._isInvalidDate(val2);
return _1669?(_166a?0:-1):(_166a?1:date.compare(val1,val2,this._selector));
},forceWidth:true,format:function(value,_166b){
if(!value){
return "";
}
return this.dateLocaleModule.format(value,_166b);
},"parse":function(value,_166c){
return this.dateLocaleModule.parse(value,_166c)||(this._isEmpty(value)?null:undefined);
},serialize:function(val,_166d){
if(val.toGregorian){
val=val.toGregorian();
}
return stamp.toISOString(val,_166d);
},dropDownDefaultValue:new Date(),value:new Date(""),_blankValue:null,popupClass:"",_selector:"",constructor:function(_166e){
this.dateModule=_166e.datePackage?lang.getObject(_166e.datePackage,false):date;
this.dateClassObj=this.dateModule.Date||Date;
this.dateLocaleModule=_166e.datePackage?lang.getObject(_166e.datePackage+".locale",false):_1663;
this._set("pattern",this.dateLocaleModule.regexp);
this._invalidDate=this.constructor.prototype.value.toString();
},buildRendering:function(){
this.inherited(arguments);
if(!this.hasDownArrow){
this._buttonNode.style.display="none";
}
if(!this.hasDownArrow){
this._buttonNode=this.domNode;
this.baseClass+=" dijitComboBoxOpenOnClick";
}
},_setConstraintsAttr:function(_166f){
_166f.selector=this._selector;
_166f.fullYear=true;
var _1670=stamp.fromISOString;
if(typeof _166f.min=="string"){
_166f.min=_1670(_166f.min);
}
if(typeof _166f.max=="string"){
_166f.max=_1670(_166f.max);
}
this.inherited(arguments);
},_isInvalidDate:function(value){
return !value||isNaN(value)||typeof value!="object"||value.toString()==this._invalidDate;
},_setValueAttr:function(value,_1671,_1672){
if(value!==undefined){
if(typeof value=="string"){
value=stamp.fromISOString(value);
}
if(this._isInvalidDate(value)){
value=null;
}
if(value instanceof Date&&!(this.dateClassObj instanceof Date)){
value=new this.dateClassObj(value);
}
}
this.inherited(arguments);
if(this.value instanceof Date){
this.filterString="";
}
if(this.dropDown){
this.dropDown.set("value",value,false);
}
},_set:function(attr,value){
if(attr=="value"&&this.value instanceof Date&&this.compare(value,this.value)==0){
return;
}
this.inherited(arguments);
},_setDropDownDefaultValueAttr:function(val){
if(this._isInvalidDate(val)){
val=new this.dateClassObj();
}
this.dropDownDefaultValue=val;
},openDropDown:function(_1673){
if(this.dropDown){
this.dropDown.destroy();
}
var _1674=lang.isString(this.popupClass)?lang.getObject(this.popupClass,false):this.popupClass,_1675=this,value=this.get("value");
this.dropDown=new _1674({onChange:function(value){
_1675.set("value",value,true);
},id:this.id+"_popup",dir:_1675.dir,lang:_1675.lang,value:value,currentFocus:!this._isInvalidDate(value)?value:this.dropDownDefaultValue,constraints:_1675.constraints,filterString:_1675.filterString,datePackage:_1675.params.datePackage,isDisabledDate:function(date){
return !_1675.rangeCheck(date,_1675.constraints);
}});
this.inherited(arguments);
},_getDisplayedValueAttr:function(){
return this.textbox.value;
},_setDisplayedValueAttr:function(value,_1676){
this._setValueAttr(this.parse(value,this.constraints),_1676,value);
}});
return _1668;
});
},"davinci/review/model/store/GeneralReviewReadStore":function(){
define(["dojo/_base/declare"],function(_1677){
return _1677("davinci.review.model.store.GeneralReviewReadStore",null,{constructor:function(args){
dojo.mixin(this,args);
this._features={"dojo.data.api.Read":true,"dojo.data.api.Identity":true};
this._loadedItems=[];
},getFeatures:function(){
return this._features;
},getIdentity:function(item){
return item.getPath();
},fetchItemByIdentity:function(_1678){
var _1679;
if(_1678.identity&&this.isItemLoaded(_1678.identity)){
dojo.some(this._loadedItems,function(item){
if(_1678.identity==this.getIdentity(item)){
_1679=item;
return true;
}
},this);
if(_1679&&_1678.onItem){
var scope=_1678.scope?_1678.scope:dojo.global;
_1678.onItem.call(scope,_1679);
}
}else{
throw new Error("GeneralReviewReadStore: The item cannot be found or it is not loaded!");
}
},getValue:function(item,_167a,_167b){
var ret=this.getValues(item,_167a);
if(ret.length>0){
return ret[0];
}
},getValues:function(item,_167c){
var ret=[];
if(item[_167c]){
if(item[_167c].length>=0){
ret=ret.concat(item[_167c]);
}else{
ret.push(item[_167c]);
}
}
return ret;
},isItem:function(_167d){
if(typeof _167d=="string"){
return dojo.some(this._loadedItems,function(item){
if(_167d==this.getIdentity(item)){
return true;
}
},this);
}else{
if(_167d){
return typeof _167d.r!="undefined"&&_167d.r===this;
}
}
},isItemLoaded:function(_167e){
var _167f=this.isItem(_167e);
if(_167f&&typeof _167e=="object"){
_167f=_167e.isLoaded;
}
return _167f;
},loadItem:function(_1680){
var item=_1680.item;
if(item){
var self=this;
item.getChildren(function(_1681){
var scope=_1680.scope?_1680.scope:dojo.global;
self._loadedItems=self._loadedItems.concat(_1681);
item.children=_1681;
item.isLoaded=true;
dojo.forEach(_1681,function(child){
child.r=self;
});
_1680.onItem&&_1680.onItem.call(scope,item);
},true);
}
},fetch:function(_1682){
if(_1682.onComplete){
var scope=_1682.scope?_1682.scope:dojo.global;
this.root.r=this;
this._loadedItems.push(this.root);
this.loadItem({item:this.root});
_1682.onComplete.call(scope,[this.root]);
}
return _1682;
},close:function(_1683){
this._loadedItems.length=0;
},getLabel:function(item){
throw new Error("GeneralReviewReadStore: getLabel method is abstract!");
},hasAttribute:function(item,_1684){
return this.isItem(item)&&(_1684=="children"?item.elementType=="Folder":typeof item[_1684]);
}});
});
},"system/resource":function(){
define(["require","dojo/_base/declare","dojo/_base/xhr","dojo/Deferred","davinci/model/Path","davinci/Runtime","davinci/model/resource/Folder"],function(_1685,_1686,xhr,_1687,Path,_1688,_1689){
var _168a={root:null,__CASE_SENSITIVE:false,resourceChanged:function(type,_168b){
if(type!=="deleted"&&_168b==system.resource.getRoot()){
_168b.reload();
system.resource.getRoot().getChildrenSync(dojo.hitch(system.resource,function(_168c){
system.resource.onChildrenChange(system.resource.getRoot(),_168c);
}));
return system.resource.getRoot();
}else{
if(type=="created"||type=="deleted"||type=="renamed"||type=="updated"||type=="reload"){
var _168d,_168e;
if(_168b.parent){
_168d=_168b.parent;
_168e=_168b.getPath();
}else{
var p1=new Path(_168b).removeLastSegments();
_168d=system.resource.findResource(p1.toString())||system.resource.getRoot();
_168e=_168b;
}
if(type=="deleted"&&_168b.elementType=="Folder"){
system.resource.onChildrenChange(_168b,[]);
}
if(_168d.elementType=="Folder"&&type=="reload"){
_168d.reload();
}
if(type=="renamed"){
system.resource.onChange(_168b);
}
_168d.getChildrenSync(function(_168f){
system.resource.onChildrenChange(_168d,_168f);
},function(e){
console.error(e);
});
}
}
if(type=="deleted"){
var _1690=dijit.byId("resourceTree");
_1690.attr("selectedItem",null);
}
},createText:function(type,_1691){
return "";
},createResource:function(_1692,_1693,_1694){
var _1695=_1692.split("/");
_1694=_1694||system.resource.getWorkspace();
var _1696=!_1693?_1695.length-1:_1695.length;
for(var i=0;i<_1696;i++){
if(_1695[i]=="."||_1695[i]==""){
continue;
}
var _1697=_1694.getChildSync(_1695[i]);
if(_1697!=null){
_1694=_1697;
}else{
_1694=_1694.createResource(_1695[i],true);
}
}
if(!_1693){
_1694=_1694.createResource(_1695[_1695.length-1]);
}
return _1694;
},listProjects:function(_1698,_1699){
var _169a=system.resource.getRoot();
if(_169a.parent){
_169a=_169a.parent;
}
_169a.getChildren(_1698,_1699);
},createProject:function(_169b){
return xhr.get({url:"cmd/createProject",handleAs:"text",content:{name:_169b.newProjectName,projectToClone:_169b.projectToClone,eclipseSupport:!!_169b.eclipseSupport,projectTemplate:_169b.projectTemplateName}});
},newItem:function(args,_169c){
},pasteItem:function(_169d,_169e,_169f,bCopy){
},onChange:function(item){
},onChildrenChange:function(_16a0,_16a1){
},getLabel:function(item){
var label=item.getName();
if(item.link){
label=label+"  ["+item.link+"]";
}
return label;
},getIdentity:function(item){
return item.getId();
},destroy:function(){
system.resource.subscriptions.forEach(dojo.unsubscribe);
},mayHaveChildren:function(item){
return item.elementType=="Folder";
},getRoot:function(_16a2,_16a3){
if(!system.resource.root){
var _16a4=system.resource.getWorkspace(),_16a5=_1685("davinci/Workbench");
if(_16a5.singleProjectMode()){
var _16a6=_16a5.getProject();
system.resource.root=system.resource.findResource(_16a6,false,_16a4);
}else{
system.resource.root=_16a4;
}
system.resource.root._readOnly=false;
}
if(_16a2){
_16a2(system.resource.root);
}else{
return system.resource.root;
}
},getWorkspace:function(){
if(!this.workspace){
this.workspace=new _1689(".",null);
}
return this.workspace;
},getChildren:function(_16a7,_16a8,_16a9){
_16a7.getChildren(_16a8,_16a9);
},copy:function(_16aa,_16ab,_16ac){
var path=_16aa.getPath?_16aa.getPath():_16aa;
var _16ad=_16ab.getPath?_16ab.getPath():_16ab;
var _16ae=_1688.serverJSONRequest({url:"cmd/copy",handleAs:"text",sync:true,content:{source:path,dest:_16ad,recurse:String(_16ac)}});
system.resource.resourceChanged("reload",_16ab);
},download:function(files,_16af,root,_16b0,_16b1){
var _16b2="";
var _16b3="";
if(_16b0){
_16b2="&libs="+encodeURIComponent(dojo.toJson(_16b0));
}
if(root){
_16b3="&root="+encodeURIComponent(root);
}
if(_16b1){
for(var name in _16b1){
_16b3+="&"+encodeURIComponent(name)+"="+encodeURIComponent(_16b1[name]);
}
}
window.location.href="cmd/download?fileName="+_16af+_16b3+"&resources="+encodeURIComponent(dojo.toJson(files))+_16b2;
},findResourceAsync:function(name,_16b4,_16b5,_16b6){
var _16b7=new _1687();
var _16b8=this.findResource(name,_16b4,_16b5,_16b6);
if(_16b8){
_16b7.resolve(_16b8);
}else{
_16b7.reject();
}
return _16b7;
},findResource:function(name,_16b9,_16ba,_16bb){
_16b9=_16b9||!system.resource.__CASE_SENSITIVE;
var seg1=0,_16bc;
var _16bd=system.resource.getWorkspace();
if(_16ba){
if(typeof _16ba=="string"){
var _16be=_16ba;
_16ba=system.resource.findResource(_16ba,_16b9);
if(!_16ba){
console.error("resource.findResoure: Folder "+_16be+" not found");
return null;
}
}
_16bd=_16ba;
}
if(typeof name=="string"){
_16bc=name.split("/");
if(_16bc[0]=="."){
seg1=1;
}
}else{
if(name.getSegments){
_16bc=name.getSegments();
name=name.toString();
}
}
var _16bf=_16bc.some(function(_16c0){
return _16c0.indexOf("*")!=-1;
});
var _16c1;
function _16c2(){
for(var i=seg1;i<_16bc.length;i++){
var found=null;
if(!_16bd._isLoaded){
_16c1=true;
break;
}
if(_16bc[i]==".."){
found=_16bd=_16bd.parent;
}else{
if(_16bc[i]!="."){
found=_16bd=_16bd.getChildSync(_16bc[i]);
}
}
if(!found){
return;
}
}
return found;
};
var found;
if(!_16bf){
found=_16c2();
}
var _16c3=[];
if(!found&&(_16c1||_16bf)){
var _16c4=_1688.serverJSONRequest({url:"cmd/findResource",content:{path:name,ignoreCase:_16b9,workspaceOnly:_16bb,inFolder:_16ba?_16ba.getPath():null},sync:true});
if(_16c4&&_16c4.length){
_16c3=_16c4.map(function(_16c5){
var _16c6=system.resource.getWorkspace();
for(var j=0;j<_16c5.parents.length;j++){
if(!_16c6._isLoaded){
_16c6.setChildrenSync(_16c5.parents[j].members);
}
if(j+1<_16c5.parents.length){
var name=_16c5.parents[j+1].name;
var _16c7=_16c6.getChildSync(name);
if(!_16c7){
_16c7=new _1689(name,_16c6);
}
_16c6=_16c7;
}
}
_16bd=system.resource.getWorkspace();
seg1=0;
_16bc=_16c5.file.split("/");
if(_16bc[0]=="."){
seg1=1;
}
return _16c2();
});
}
}else{
_16c3=[found];
}
return _16bf?_16c3:_16c3[0];
},alphabeticalSort:function(items){
return items.sort(function(a,b){
a=a.name.toLowerCase();
b=b.name.toLowerCase();
return a<b?-1:(a>b?1:0);
});
}};
var _16c8=[dojo.subscribe("/davinci/resource/resourceChanged",_168a,function(){
return _168a.resourceChanged;
}())];
return dojo.setObject("system.resource",_168a);
});
},"dojox/grid/_Scroller":function(){
define(["dijit/registry","dojo/_base/declare","dojo/_base/lang","./util","dojo/_base/html"],function(_16c9,_16ca,lang,util,html){
var _16cb=function(_16cc){
var i=0,n,p=_16cc.parentNode;
while((n=p.childNodes[i++])){
if(n==_16cc){
return i-1;
}
}
return -1;
};
var _16cd=function(_16ce){
if(!_16ce){
return;
}
dojo.forEach(_16c9.toArray(),function(w){
if(w.domNode&&html.isDescendant(w.domNode,_16ce,true)){
w.destroy();
}
});
};
var _16cf=function(_16d0){
var node=html.byId(_16d0);
return (node&&node.tagName?node.tagName.toLowerCase():"");
};
var _16d1=function(_16d2,inTag){
var _16d3=[];
var i=0,n;
while((n=_16d2.childNodes[i])){
i++;
if(_16cf(n)==inTag){
_16d3.push(n);
}
}
return _16d3;
};
var _16d4=function(_16d5){
return _16d1(_16d5,"div");
};
return _16ca("dojox.grid._Scroller",null,{constructor:function(_16d6){
this.setContentNodes(_16d6);
this.pageHeights=[];
this.pageNodes=[];
this.stack=[];
},rowCount:0,defaultRowHeight:32,keepRows:100,contentNode:null,scrollboxNode:null,defaultPageHeight:0,keepPages:10,pageCount:0,windowHeight:0,firstVisibleRow:0,lastVisibleRow:0,averageRowHeight:0,page:0,pageTop:0,init:function(_16d7,_16d8,_16d9){
switch(arguments.length){
case 3:
this.rowsPerPage=_16d9;
case 2:
this.keepRows=_16d8;
case 1:
this.rowCount=_16d7;
default:
break;
}
this.defaultPageHeight=(this.grid.rowHeight>0?this.grid.rowHeight:this.defaultRowHeight)*this.rowsPerPage;
this.pageCount=this._getPageCount(this.rowCount,this.rowsPerPage);
this.setKeepInfo(this.keepRows);
this.invalidate();
if(this.scrollboxNode){
this.scrollboxNode.scrollTop=0;
this.scroll(0);
this.scrollboxNode.onscroll=lang.hitch(this,"onscroll");
}
},_getPageCount:function(_16da,_16db){
return _16da?(Math.ceil(_16da/_16db)||1):0;
},destroy:function(){
this.invalidateNodes();
delete this.contentNodes;
delete this.contentNode;
delete this.scrollboxNode;
},setKeepInfo:function(_16dc){
this.keepRows=_16dc;
this.keepPages=!this.keepRows?this.keepPages:Math.max(Math.ceil(this.keepRows/this.rowsPerPage),2);
},setContentNodes:function(_16dd){
this.contentNodes=_16dd;
this.colCount=(this.contentNodes?this.contentNodes.length:0);
this.pageNodes=[];
for(var i=0;i<this.colCount;i++){
this.pageNodes[i]=[];
}
},getDefaultNodes:function(){
return this.pageNodes[0]||[];
},invalidate:function(){
this._invalidating=true;
this.invalidateNodes();
this.pageHeights=[];
this.height=(this.pageCount?(this.pageCount-1)*this.defaultPageHeight+this.calcLastPageHeight():0);
this.resize();
this._invalidating=false;
},updateRowCount:function(_16de){
this.invalidateNodes();
this.rowCount=_16de;
var _16df=this.pageCount;
if(_16df===0){
this.height=1;
}
this.pageCount=this._getPageCount(this.rowCount,this.rowsPerPage);
if(this.pageCount<_16df){
for(var i=_16df-1;i>=this.pageCount;i--){
this.height-=this.getPageHeight(i);
delete this.pageHeights[i];
}
}else{
if(this.pageCount>_16df){
this.height+=this.defaultPageHeight*(this.pageCount-_16df-1)+this.calcLastPageHeight();
}
}
this.resize();
},pageExists:function(_16e0){
return Boolean(this.getDefaultPageNode(_16e0));
},measurePage:function(_16e1){
if(this.grid.rowHeight){
return ((_16e1+1)*this.rowsPerPage>this.rowCount?this.rowCount-_16e1*this.rowsPerPage:this.rowsPerPage)*this.grid.rowHeight;
}
var n=this.getDefaultPageNode(_16e1);
return (n&&n.innerHTML)?n.offsetHeight:undefined;
},positionPage:function(_16e2,inPos){
for(var i=0;i<this.colCount;i++){
this.pageNodes[i][_16e2].style.top=inPos+"px";
}
},repositionPages:function(_16e3){
var nodes=this.getDefaultNodes();
var last=0;
for(var i=0;i<this.stack.length;i++){
last=Math.max(this.stack[i],last);
}
var n=nodes[_16e3];
var y=(n?this.getPageNodePosition(n)+this.getPageHeight(_16e3):0);
for(var p=_16e3+1;p<=last;p++){
n=nodes[p];
if(n){
if(this.getPageNodePosition(n)==y){
return;
}
this.positionPage(p,y);
}
y+=this.getPageHeight(p);
}
},installPage:function(_16e4){
for(var i=0;i<this.colCount;i++){
this.contentNodes[i].appendChild(this.pageNodes[i][_16e4]);
}
},preparePage:function(_16e5,_16e6){
var p=(_16e6?this.popPage():null);
for(var i=0;i<this.colCount;i++){
var nodes=this.pageNodes[i];
var new_p=(p===null?this.createPageNode():this.invalidatePageNode(p,nodes));
new_p.pageIndex=_16e5;
nodes[_16e5]=new_p;
}
},renderPage:function(_16e7){
var nodes=[];
var i,j;
for(i=0;i<this.colCount;i++){
nodes[i]=this.pageNodes[i][_16e7];
}
for(i=0,j=_16e7*this.rowsPerPage;(i<this.rowsPerPage)&&(j<this.rowCount);i++,j++){
this.renderRow(j,nodes);
}
},removePage:function(_16e8){
for(var i=0,j=_16e8*this.rowsPerPage;i<this.rowsPerPage;i++,j++){
this.removeRow(j);
}
},destroyPage:function(_16e9){
for(var i=0;i<this.colCount;i++){
var n=this.invalidatePageNode(_16e9,this.pageNodes[i]);
if(n){
html.destroy(n);
}
}
},pacify:function(_16ea){
},pacifying:false,pacifyTicks:200,setPacifying:function(_16eb){
if(this.pacifying!=_16eb){
this.pacifying=_16eb;
this.pacify(this.pacifying);
}
},startPacify:function(){
this.startPacifyTicks=new Date().getTime();
},doPacify:function(){
var _16ec=(new Date().getTime()-this.startPacifyTicks)>this.pacifyTicks;
this.setPacifying(true);
this.startPacify();
return _16ec;
},endPacify:function(){
this.setPacifying(false);
},resize:function(){
if(this.scrollboxNode){
this.windowHeight=this.scrollboxNode.clientHeight;
}
for(var i=0;i<this.colCount;i++){
util.setStyleHeightPx(this.contentNodes[i],Math.max(1,this.height));
}
var _16ed=(!this._invalidating);
if(!_16ed){
var ah=this.grid.get("autoHeight");
if(typeof ah=="number"&&ah<=Math.min(this.rowsPerPage,this.rowCount)){
_16ed=true;
}
}
if(_16ed){
this.needPage(this.page,this.pageTop);
}
var _16ee=(this.page<this.pageCount-1)?this.rowsPerPage:((this.rowCount%this.rowsPerPage)||this.rowsPerPage);
var _16ef=this.getPageHeight(this.page);
this.averageRowHeight=(_16ef>0&&_16ee>0)?(_16ef/_16ee):0;
},calcLastPageHeight:function(){
if(!this.pageCount){
return 0;
}
var _16f0=this.pageCount-1;
var _16f1=((this.rowCount%this.rowsPerPage)||(this.rowsPerPage))*this.defaultRowHeight;
this.pageHeights[_16f0]=_16f1;
return _16f1;
},updateContentHeight:function(inDh){
this.height+=inDh;
this.resize();
},updatePageHeight:function(_16f2,_16f3,_16f4){
if(this.pageExists(_16f2)){
var oh=this.getPageHeight(_16f2);
var h=(this.measurePage(_16f2));
if(h===undefined){
h=oh;
}
this.pageHeights[_16f2]=h;
if(oh!=h){
this.updateContentHeight(h-oh);
var ah=this.grid.get("autoHeight");
if((typeof ah=="number"&&ah>this.rowCount)||(ah===true&&!_16f3)){
if(!_16f4){
this.grid.sizeChange();
}else{
var ns=this.grid.viewsNode.style;
ns.height=parseInt(ns.height)+h-oh+"px";
this.repositionPages(_16f2);
}
}else{
this.repositionPages(_16f2);
}
}
return h;
}
return 0;
},rowHeightChanged:function(_16f5,_16f6){
this.updatePageHeight(Math.floor(_16f5/this.rowsPerPage),false,_16f6);
},invalidateNodes:function(){
while(this.stack.length){
this.destroyPage(this.popPage());
}
},createPageNode:function(){
var p=document.createElement("div");
html.attr(p,"role","presentation");
p.style.position="absolute";
p.style[this.grid.isLeftToRight()?"left":"right"]="0";
return p;
},getPageHeight:function(_16f7){
var ph=this.pageHeights[_16f7];
return (ph!==undefined?ph:this.defaultPageHeight);
},pushPage:function(_16f8){
return this.stack.push(_16f8);
},popPage:function(){
return this.stack.shift();
},findPage:function(inTop){
var i=0,h=0;
for(var ph=0;i<this.pageCount;i++,h+=ph){
ph=this.getPageHeight(i);
if(h+ph>=inTop){
break;
}
}
this.page=i;
this.pageTop=h;
},buildPage:function(_16f9,_16fa,inPos){
this.preparePage(_16f9,_16fa);
this.positionPage(_16f9,inPos);
this.installPage(_16f9);
this.renderPage(_16f9);
this.pushPage(_16f9);
},needPage:function(_16fb,inPos){
var h=this.getPageHeight(_16fb),oh=h;
if(!this.pageExists(_16fb)){
this.buildPage(_16fb,(!this.grid._autoHeight&&this.keepPages&&(this.stack.length>=this.keepPages)),inPos);
h=this.updatePageHeight(_16fb,true);
}else{
this.positionPage(_16fb,inPos);
}
return h;
},onscroll:function(){
this.scroll(this.scrollboxNode.scrollTop);
},scroll:function(inTop){
this.grid.scrollTop=inTop;
if(this.colCount){
this.startPacify();
this.findPage(inTop);
var h=this.height;
var b=this.getScrollBottom(inTop);
for(var p=this.page,y=this.pageTop;(p<this.pageCount)&&((b<0)||(y<b));p++){
y+=this.needPage(p,y);
}
this.firstVisibleRow=this.getFirstVisibleRow(this.page,this.pageTop,inTop);
this.lastVisibleRow=this.getLastVisibleRow(p-1,y,b);
if(h!=this.height){
this.repositionPages(p-1);
}
this.endPacify();
}
},getScrollBottom:function(inTop){
return (this.windowHeight>=0?inTop+this.windowHeight:-1);
},processNodeEvent:function(e,_16fc){
var t=e.target;
while(t&&(t!=_16fc)&&t.parentNode&&(t.parentNode.parentNode!=_16fc)){
t=t.parentNode;
}
if(!t||!t.parentNode||(t.parentNode.parentNode!=_16fc)){
return false;
}
var page=t.parentNode;
e.topRowIndex=page.pageIndex*this.rowsPerPage;
e.rowIndex=e.topRowIndex+_16cb(t);
e.rowTarget=t;
return true;
},processEvent:function(e){
return this.processNodeEvent(e,this.contentNode);
},renderRow:function(_16fd,_16fe){
},removeRow:function(_16ff){
},getDefaultPageNode:function(_1700){
return this.getDefaultNodes()[_1700];
},positionPageNode:function(_1701,inPos){
},getPageNodePosition:function(_1702){
return _1702.offsetTop;
},invalidatePageNode:function(_1703,_1704){
var p=_1704[_1703];
if(p){
delete _1704[_1703];
this.removePage(_1703,p);
_16cd(p);
p.innerHTML="";
}
return p;
},getPageRow:function(_1705){
return _1705*this.rowsPerPage;
},getLastPageRow:function(_1706){
return Math.min(this.rowCount,this.getPageRow(_1706+1))-1;
},getFirstVisibleRow:function(_1707,_1708,_1709){
if(!this.pageExists(_1707)){
return 0;
}
var row=this.getPageRow(_1707);
var nodes=this.getDefaultNodes();
var rows=_16d4(nodes[_1707]);
for(var i=0,l=rows.length;i<l&&_1708<_1709;i++,row++){
_1708+=rows[i].offsetHeight;
}
return (row?row-1:row);
},getLastVisibleRow:function(_170a,_170b,_170c){
if(!this.pageExists(_170a)){
return 0;
}
var nodes=this.getDefaultNodes();
var row=this.getLastPageRow(_170a);
var rows=_16d4(nodes[_170a]);
for(var i=rows.length-1;i>=0&&_170b>_170c;i--,row--){
_170b-=rows[i].offsetHeight;
}
return row+1;
},findTopRow:function(_170d){
var nodes=this.getDefaultNodes();
var rows=_16d4(nodes[this.page]);
for(var i=0,l=rows.length,t=this.pageTop,h;i<l;i++){
h=rows[i].offsetHeight;
t+=h;
if(t>=_170d){
this.offset=h-(t-_170d);
return i+this.page*this.rowsPerPage;
}
}
return -1;
},findScrollTop:function(inRow){
var _170e=Math.floor(inRow/this.rowsPerPage);
var t=0;
var i,l;
for(i=0;i<_170e;i++){
t+=this.getPageHeight(i);
}
this.pageTop=t;
this.page=_170e;
this.needPage(_170e,this.pageTop);
var nodes=this.getDefaultNodes();
var rows=_16d4(nodes[_170e]);
var r=inRow-this.rowsPerPage*_170e;
for(i=0,l=rows.length;i<l&&i<r;i++){
t+=rows[i].offsetHeight;
}
return t;
},dummy:0});
});
},"dijit/Calendar":function(){
define(["dojo/_base/array","dojo/date","dojo/date/locale","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/_base/event","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/sniff","./CalendarLite","./_Widget","./_CssStateMixin","./_TemplatedMixin","./form/DropDownButton"],function(array,date,local,_170f,_1710,_1711,event,_1712,keys,lang,has,_1713,_1714,_1715,_1716,_1717){
var _1718=_170f("dijit.Calendar",[_1713,_1714,_1715],{cssStateNodes:{"decrementMonth":"dijitCalendarArrow","incrementMonth":"dijitCalendarArrow","previousYearLabelNode":"dijitCalendarPreviousYear","nextYearLabelNode":"dijitCalendarNextYear"},setValue:function(value){
_1712.deprecated("dijit.Calendar:setValue() is deprecated.  Use set('value', ...) instead.","","2.0");
this.set("value",value);
},_createMonthWidget:function(){
return new _1718._MonthDropDownButton({id:this.id+"_mddb",tabIndex:-1,onMonthSelect:lang.hitch(this,"_onMonthSelect"),lang:this.lang,dateLocaleModule:this.dateLocaleModule},this.monthNode);
},postCreate:function(){
this.inherited(arguments);
this.connect(this.domNode,"onkeydown","_onKeyDown");
this.connect(this.dateRowsNode,"onmouseover","_onDayMouseOver");
this.connect(this.dateRowsNode,"onmouseout","_onDayMouseOut");
this.connect(this.dateRowsNode,"onmousedown","_onDayMouseDown");
this.connect(this.dateRowsNode,"onmouseup","_onDayMouseUp");
},_onMonthSelect:function(_1719){
var date=new this.dateClassObj(this.currentFocus);
date.setDate(1);
date.setMonth(_1719);
var _171a=this.dateModule.getDaysInMonth(date);
var _171b=this.currentFocus.getDate();
date.setDate(Math.min(_171b,_171a));
this._setCurrentFocusAttr(date);
},_onDayMouseOver:function(evt){
var node=_1711.contains(evt.target,"dijitCalendarDateLabel")?evt.target.parentNode:evt.target;
if(node&&((node.dijitDateValue&&!_1711.contains(node,"dijitCalendarDisabledDate"))||node==this.previousYearLabelNode||node==this.nextYearLabelNode)){
_1711.add(node,"dijitCalendarHoveredDate");
this._currentNode=node;
}
},_onDayMouseOut:function(evt){
if(!this._currentNode){
return;
}
if(evt.relatedTarget&&evt.relatedTarget.parentNode==this._currentNode){
return;
}
var cls="dijitCalendarHoveredDate";
if(_1711.contains(this._currentNode,"dijitCalendarActiveDate")){
cls+=" dijitCalendarActiveDate";
}
_1711.remove(this._currentNode,cls);
this._currentNode=null;
},_onDayMouseDown:function(evt){
var node=evt.target.parentNode;
if(node&&node.dijitDateValue&&!_1711.contains(node,"dijitCalendarDisabledDate")){
_1711.add(node,"dijitCalendarActiveDate");
this._currentNode=node;
}
},_onDayMouseUp:function(evt){
var node=evt.target.parentNode;
if(node&&node.dijitDateValue){
_1711.remove(node,"dijitCalendarActiveDate");
}
},handleKey:function(evt){
var _171c=-1,_171d,_171e=this.currentFocus;
switch(evt.keyCode){
case keys.RIGHT_ARROW:
_171c=1;
case keys.LEFT_ARROW:
_171d="day";
if(!this.isLeftToRight()){
_171c*=-1;
}
break;
case keys.DOWN_ARROW:
_171c=1;
case keys.UP_ARROW:
_171d="week";
break;
case keys.PAGE_DOWN:
_171c=1;
case keys.PAGE_UP:
_171d=evt.ctrlKey||evt.altKey?"year":"month";
break;
case keys.END:
_171e=this.dateModule.add(_171e,"month",1);
_171d="day";
case keys.HOME:
_171e=new this.dateClassObj(_171e);
_171e.setDate(1);
break;
case keys.ENTER:
case keys.SPACE:
this.set("value",this.currentFocus);
break;
default:
return true;
}
if(_171d){
_171e=this.dateModule.add(_171e,_171d,_171c);
}
this._setCurrentFocusAttr(_171e);
return false;
},_onKeyDown:function(evt){
if(!this.handleKey(evt)){
event.stop(evt);
}
},onValueSelected:function(){
},onChange:function(value){
this.onValueSelected(value);
},getClassForDate:function(){
}});
_1718._MonthDropDownButton=_170f("dijit.Calendar._MonthDropDownButton",_1717,{onMonthSelect:function(){
},postCreate:function(){
this.inherited(arguments);
this.dropDown=new _1718._MonthDropDown({id:this.id+"_mdd",onChange:this.onMonthSelect});
},_setMonthAttr:function(month){
var _171f=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,month);
this.dropDown.set("months",_171f);
this.containerNode.innerHTML=(has("ie")==6?"":"<div class='dijitSpacer'>"+this.dropDown.domNode.innerHTML+"</div>")+"<div class='dijitCalendarMonthLabel dijitCalendarCurrentMonthLabel'>"+_171f[month.getMonth()]+"</div>";
}});
_1718._MonthDropDown=_170f("dijit.Calendar._MonthDropDown",[_1714,_1716],{months:[],templateString:"<div class='dijitCalendarMonthMenu dijitMenu' "+"data-dojo-attach-event='onclick:_onClick,onmouseover:_onMenuHover,onmouseout:_onMenuHover'></div>",_setMonthsAttr:function(_1720){
this.domNode.innerHTML=array.map(_1720,function(month,idx){
return month?"<div class='dijitCalendarMonthLabel' month='"+idx+"'>"+month+"</div>":"";
}).join("");
},_onClick:function(evt){
this.onChange(_1710.get(evt.target,"month"));
},onChange:function(){
},_onMenuHover:function(evt){
_1711.toggle(evt.target,"dijitCalendarMonthLabelHover",evt.type=="mouseover");
}});
return _1718;
});
},"dijit/form/_ToggleButtonMixin":function(){
define(["dojo/_base/declare","dojo/dom-attr"],function(_1721,_1722){
return _1721("dijit.form._ToggleButtonMixin",null,{checked:false,_aria_attr:"aria-pressed",_onClick:function(evt){
var _1723=this.checked;
this._set("checked",!_1723);
var ret=this.inherited(arguments);
this.set("checked",ret?this.checked:_1723);
return ret;
},_setCheckedAttr:function(value,_1724){
this._set("checked",value);
var node=this.focusNode||this.domNode;
_1722.set(node,"checked",!!value);
if(value){
node.setAttribute("checked","");
}else{
node.removeAttribute("checked");
}
node.setAttribute(this._aria_attr,String(value));
this._handleOnChange(value,_1724);
},reset:function(){
this._hasBeenBlurred=false;
this.set("checked",this.params.checked||false);
}});
});
},"dojo/dnd/Container":function(){
define(["../_base/array","../_base/declare","../_base/event","../_base/kernel","../_base/lang","../_base/window","../dom","../dom-class","../dom-construct","../Evented","../has","../on","../query","../ready","../touch","./common"],function(array,_1725,event,_1726,lang,win,dom,_1727,_1728,_1729,has,on,query,ready,touch,dnd){
var _172a=_1725("dojo.dnd.Container",_1729,{skipForm:false,allowNested:false,constructor:function(node,_172b){
this.node=dom.byId(node);
if(!_172b){
_172b={};
}
this.creator=_172b.creator||null;
this.skipForm=_172b.skipForm;
this.parent=_172b.dropParent&&dom.byId(_172b.dropParent);
this.map={};
this.current=null;
this.containerState="";
_1727.add(this.node,"dojoDndContainer");
if(!(_172b&&_172b._skipStartup)){
this.startup();
}
this.events=[on(this.node,touch.over,lang.hitch(this,"onMouseOver")),on(this.node,touch.out,lang.hitch(this,"onMouseOut")),on(this.node,"dragstart",lang.hitch(this,"onSelectStart")),on(this.node,"selectstart",lang.hitch(this,"onSelectStart"))];
},creator:function(){
},getItem:function(key){
return this.map[key];
},setItem:function(key,data){
this.map[key]=data;
},delItem:function(key){
delete this.map[key];
},forInItems:function(f,o){
o=o||_1726.global;
var m=this.map,e=dnd._empty;
for(var i in m){
if(i in e){
continue;
}
f.call(o,m[i],i,this);
}
return o;
},clearItems:function(){
this.map={};
},getAllNodes:function(){
return query((this.allowNested?"":"> ")+".dojoDndItem",this.parent);
},sync:function(){
var map={};
this.getAllNodes().forEach(function(node){
if(node.id){
var item=this.getItem(node.id);
if(item){
map[node.id]=item;
return;
}
}else{
node.id=dnd.getUniqueId();
}
var type=node.getAttribute("dndType"),data=node.getAttribute("dndData");
map[node.id]={data:data||node.innerHTML,type:type?type.split(/\s*,\s*/):["text"]};
},this);
this.map=map;
return this;
},insertNodes:function(data,_172c,_172d){
if(!this.parent.firstChild){
_172d=null;
}else{
if(_172c){
if(!_172d){
_172d=this.parent.firstChild;
}
}else{
if(_172d){
_172d=_172d.nextSibling;
}
}
}
var i,t;
if(_172d){
for(i=0;i<data.length;++i){
t=this._normalizedCreator(data[i]);
this.setItem(t.node.id,{data:t.data,type:t.type});
_172d.parentNode.insertBefore(t.node,_172d);
}
}else{
for(i=0;i<data.length;++i){
t=this._normalizedCreator(data[i]);
this.setItem(t.node.id,{data:t.data,type:t.type});
this.parent.appendChild(t.node);
}
}
return this;
},destroy:function(){
array.forEach(this.events,function(_172e){
_172e.remove();
});
this.clearItems();
this.node=this.parent=this.current=null;
},markupFactory:function(_172f,node,Ctor){
_172f._skipStartup=true;
return new Ctor(node,_172f);
},startup:function(){
if(!this.parent){
this.parent=this.node;
if(this.parent.tagName.toLowerCase()=="table"){
var c=this.parent.getElementsByTagName("tbody");
if(c&&c.length){
this.parent=c[0];
}
}
}
this.defaultCreator=dnd._defaultCreator(this.parent);
this.sync();
},onMouseOver:function(e){
var n=e.relatedTarget;
while(n){
if(n==this.node){
break;
}
try{
n=n.parentNode;
}
catch(x){
n=null;
}
}
if(!n){
this._changeState("Container","Over");
this.onOverEvent();
}
n=this._getChildByEvent(e);
if(this.current==n){
return;
}
if(this.current){
this._removeItemClass(this.current,"Over");
}
if(n){
this._addItemClass(n,"Over");
}
this.current=n;
},onMouseOut:function(e){
for(var n=e.relatedTarget;n;){
if(n==this.node){
return;
}
try{
n=n.parentNode;
}
catch(x){
n=null;
}
}
if(this.current){
this._removeItemClass(this.current,"Over");
this.current=null;
}
this._changeState("Container","");
this.onOutEvent();
},onSelectStart:function(e){
if(!this.skipForm||!dnd.isFormElement(e)){
event.stop(e);
}
},onOverEvent:function(){
},onOutEvent:function(){
},_changeState:function(type,_1730){
var _1731="dojoDnd"+type;
var state=type.toLowerCase()+"State";
_1727.replace(this.node,_1731+_1730,_1731+this[state]);
this[state]=_1730;
},_addItemClass:function(node,type){
_1727.add(node,"dojoDndItem"+type);
},_removeItemClass:function(node,type){
_1727.remove(node,"dojoDndItem"+type);
},_getChildByEvent:function(e){
var node=e.target;
if(node){
for(var _1732=node.parentNode;_1732;node=_1732,_1732=node.parentNode){
if((_1732==this.parent||this.allowNested)&&_1727.contains(node,"dojoDndItem")){
return node;
}
}
}
return null;
},_normalizedCreator:function(item,hint){
var t=(this.creator||this.defaultCreator).call(this,item,hint);
if(!lang.isArray(t.type)){
t.type=["text"];
}
if(!t.node.id){
t.node.id=dnd.getUniqueId();
}
_1727.add(t.node,"dojoDndItem");
return t;
}});
dnd._createNode=function(tag){
if(!tag){
return dnd._createSpan;
}
return function(text){
return _1728.create(tag,{innerHTML:text});
};
};
dnd._createTrTd=function(text){
var tr=_1728.create("tr");
_1728.create("td",{innerHTML:text},tr);
return tr;
};
dnd._createSpan=function(text){
return _1728.create("span",{innerHTML:text});
};
dnd._defaultCreatorNodes={ul:"li",ol:"li",div:"div",p:"div"};
dnd._defaultCreator=function(node){
var tag=node.tagName.toLowerCase();
var c=tag=="tbody"||tag=="thead"?dnd._createTrTd:dnd._createNode(dnd._defaultCreatorNodes[tag]);
return function(item,hint){
var isObj=item&&lang.isObject(item),data,type,n;
if(isObj&&item.tagName&&item.nodeType&&item.getAttribute){
data=item.getAttribute("dndData")||item.innerHTML;
type=item.getAttribute("dndType");
type=type?type.split(/\s*,\s*/):["text"];
n=item;
}else{
data=(isObj&&item.data)?item.data:item;
type=(isObj&&item.type)?item.type:["text"];
n=(hint=="avatar"?dnd._createSpan:c)(String(data));
}
if(!n.id){
n.id=dnd.getUniqueId();
}
return {node:n,data:data,type:type};
};
};
return _172a;
});
},"url:davinci/ui/templates/newtheme.html":"<div>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<table>\n\t\t<tr>\n\t\t<td>${themeToClone}:</td><td> <div dojoType=\"davinci.ui.widgets.ThemeSelection\" workspaceOnly=\"false\" dojoAttachPoint = '_themeSelection'></div></td><td><div dojoAttachPoint='_error1'></div></td>\n\t\t</tr>\n\t\t<tr><td colspan='3'><hr></hr></td></tr>\n\t\t<!-- \n\t\t<tr>\n\t\t<td>New Name:</td><td><input style='width:100%' type='select' dojoAttachPoint=\"_themeName\"></input></td><td><div dojoAttachPoint='_error2'></div></td>\n\t\t</tr>\n\t\t<tr>\n\t\t<td>Version:</td><td><input style='width:100%' type='text' dojoAttachPoint=\"_version\"></input></td><td><div dojoAttachPoint='_error3'></div></td>\n\t\t</tr>\n\t\t -->\n\t\t<tr>\n\t\t<td>${newName}:</td><td><input class='templateInput' type='text' \n\t\t\tdojoAttachPoint=\"_selector\"\n\t\t\tdojoType=\"dijit.form.ValidationTextBox\"\n\t\t\trequired=\"true\" \n\t\t\tinvalidMessage='${invalidThemeName}'></input></td><td><div dojoAttachPoint='_error4'></div></td>\n\t\t</tr>\n\t\t</table>\n\t</div>\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button dojoType='dijit.form.Button' dojoAttachPoint=\"_okButton\" dojoAttachEvent='onClick:okButton' label='${create}' class=\"maqPrimaryButton\" type=\"submit\" disabled></button>\n\t\t<button dojoType='dijit.form.Button' dojoAttachEvent='onClick:cancelButton' label='${buttonCancel}' class=\"maqSecondaryButton\"></button>\n\t</div>\t\t\n</div>","davinci/ve/actions/ReplaceAction":function(){
define(["dojo/_base/declare","dojo/dom-style","davinci/ve/actions/ContextAction","davinci/commands/CompoundCommand","davinci/ve/commands/AddCommand","davinci/ve/commands/MoveCommand","davinci/ve/tools/CreateTool","davinci/ve/widget","davinci/ve/utils/GeomUtils"],function(_1733,_1734,_1735,_1736,_1737,_1738,_1739,_173a,_173b){
return _1733("davinci.ve.actions.ReplaceAction",[_1735],{run:function(_173c,_173d){
_173c=this.fixupContext(_173c);
if(_173c){
if(_173c.declaredClass!=="davinci.ve.Context"){
return;
}
var _173e=this._normalizeSelection(_173c);
if(!this.selectionSameParent(_173e)){
return;
}
var _173f=[];
var _1740={"type":_173d,"context":_173c};
if(_173e.length>0){
var _1741=new _1736();
dojo.forEach(_173e,function(w){
var _1742;
var d=w.getData({identify:false});
if(d){
d.context=_173c;
dojo.withDoc(_173c.getDocument(),function(){
_1742=_173a.createWidget(_1740);
},this);
if(_1742){
_1741.add(new _1737(_1742,w.getParent(),undefined));
_1739.prototype.checkAddToCurrentState(_1741,_1742);
_173f.push(_1742);
var _1743=(w&&w.domNode)?_1734.get(w.domNode,"position"):null;
var _1744=(_1743=="absolute");
if(_1744){
var box=_173b.getMarginBoxPageCoords(w.domNode);
box.l+=25;
_1741.add(new _1738(_1742,box.l,box.t,undefined,undefined,undefined,true));
}
}
}
});
_173c.getCommandStack().execute(_1741);
dojo.forEach(_173f,function(w,i){
_173c.select(w,i>0);
},this);
}
}
},isEnabled:function(_1745){
_1745=this.fixupContext(_1745);
var _1746=(_1745&&_1745.getSelection)?_1745.getSelection():[];
if(_1746.length===0){
return false;
}
if(!this.selectionSameParent(_1746)){
return false;
}
return true;
},shouldShow:function(_1747){
_1747=this.fixupContext(_1747);
var _1748=_1747?_1747.editor:null;
return (_1748&&_1748.declaredClass=="davinci.ve.PageEditor");
},selectionSameParent:function(_1749){
if(_1749.length===0){
return false;
}
var _174a=_1749[0].getParent();
for(var i=0;i<_1749.length;i++){
var _174b=_1749[i];
if(_174b.getParent()!=_174a){
return false;
}
}
return true;
}});
});
},"dojox/grid/DataSelection":function(){
define(["dojo/_base/declare","./_SelectionPreserver","./Selection"],function(_174c,_174d,_174e){
return _174c("dojox.grid.DataSelection",_174e,{constructor:function(grid){
if(grid.keepSelection){
this.preserver=new _174d(this);
}
},destroy:function(){
if(this.preserver){
this.preserver.destroy();
}
},getFirstSelected:function(){
var idx=_174e.prototype.getFirstSelected.call(this);
if(idx==-1){
return null;
}
return this.grid.getItem(idx);
},getNextSelected:function(_174f){
var _1750=this.grid.getItemIndex(_174f);
var idx=_174e.prototype.getNextSelected.call(this,_1750);
if(idx==-1){
return null;
}
return this.grid.getItem(idx);
},getSelected:function(){
var _1751=[];
for(var i=0,l=this.selected.length;i<l;i++){
if(this.selected[i]){
_1751.push(this.grid.getItem(i));
}
}
return _1751;
},addToSelection:function(_1752){
if(this.mode=="none"){
return;
}
var idx=null;
if(typeof _1752=="number"||typeof _1752=="string"){
idx=_1752;
}else{
idx=this.grid.getItemIndex(_1752);
}
_174e.prototype.addToSelection.call(this,idx);
},deselect:function(_1753){
if(this.mode=="none"){
return;
}
var idx=null;
if(typeof _1753=="number"||typeof _1753=="string"){
idx=_1753;
}else{
idx=this.grid.getItemIndex(_1753);
}
_174e.prototype.deselect.call(this,idx);
},deselectAll:function(_1754){
var idx=null;
if(_1754||typeof _1754=="number"){
if(typeof _1754=="number"||typeof _1754=="string"){
idx=_1754;
}else{
idx=this.grid.getItemIndex(_1754);
}
_174e.prototype.deselectAll.call(this,idx);
}else{
this.inherited(arguments);
}
}});
});
},"dojo/fx":function(){
define(["./_base/lang","./Evented","./_base/kernel","./_base/array","./_base/connect","./_base/fx","./dom","./dom-style","./dom-geometry","./ready","require"],function(lang,_1755,dojo,_1756,_1757,_1758,dom,_1759,geom,ready,_175a){
if(!dojo.isAsync){
ready(0,function(){
var _175b=["./fx/Toggler"];
_175a(_175b);
});
}
var _175c=dojo.fx={};
var _175d={_fire:function(evt,args){
if(this[evt]){
this[evt].apply(this,args||[]);
}
return this;
}};
var _175e=function(_175f){
this._index=-1;
this._animations=_175f||[];
this._current=this._onAnimateCtx=this._onEndCtx=null;
this.duration=0;
_1756.forEach(this._animations,function(a){
this.duration+=a.duration;
if(a.delay){
this.duration+=a.delay;
}
},this);
};
_175e.prototype=new _1755();
lang.extend(_175e,{_onAnimate:function(){
this._fire("onAnimate",arguments);
},_onEnd:function(){
_1757.disconnect(this._onAnimateCtx);
_1757.disconnect(this._onEndCtx);
this._onAnimateCtx=this._onEndCtx=null;
if(this._index+1==this._animations.length){
this._fire("onEnd");
}else{
this._current=this._animations[++this._index];
this._onAnimateCtx=_1757.connect(this._current,"onAnimate",this,"_onAnimate");
this._onEndCtx=_1757.connect(this._current,"onEnd",this,"_onEnd");
this._current.play(0,true);
}
},play:function(delay,_1760){
if(!this._current){
this._current=this._animations[this._index=0];
}
if(!_1760&&this._current.status()=="playing"){
return this;
}
var _1761=_1757.connect(this._current,"beforeBegin",this,function(){
this._fire("beforeBegin");
}),_1762=_1757.connect(this._current,"onBegin",this,function(arg){
this._fire("onBegin",arguments);
}),_1763=_1757.connect(this._current,"onPlay",this,function(arg){
this._fire("onPlay",arguments);
_1757.disconnect(_1761);
_1757.disconnect(_1762);
_1757.disconnect(_1763);
});
if(this._onAnimateCtx){
_1757.disconnect(this._onAnimateCtx);
}
this._onAnimateCtx=_1757.connect(this._current,"onAnimate",this,"_onAnimate");
if(this._onEndCtx){
_1757.disconnect(this._onEndCtx);
}
this._onEndCtx=_1757.connect(this._current,"onEnd",this,"_onEnd");
this._current.play.apply(this._current,arguments);
return this;
},pause:function(){
if(this._current){
var e=_1757.connect(this._current,"onPause",this,function(arg){
this._fire("onPause",arguments);
_1757.disconnect(e);
});
this._current.pause();
}
return this;
},gotoPercent:function(_1764,_1765){
this.pause();
var _1766=this.duration*_1764;
this._current=null;
_1756.some(this._animations,function(a){
if(a.duration<=_1766){
this._current=a;
return true;
}
_1766-=a.duration;
return false;
});
if(this._current){
this._current.gotoPercent(_1766/this._current.duration,_1765);
}
return this;
},stop:function(_1767){
if(this._current){
if(_1767){
for(;this._index+1<this._animations.length;++this._index){
this._animations[this._index].stop(true);
}
this._current=this._animations[this._index];
}
var e=_1757.connect(this._current,"onStop",this,function(arg){
this._fire("onStop",arguments);
_1757.disconnect(e);
});
this._current.stop();
}
return this;
},status:function(){
return this._current?this._current.status():"stopped";
},destroy:function(){
if(this._onAnimateCtx){
_1757.disconnect(this._onAnimateCtx);
}
if(this._onEndCtx){
_1757.disconnect(this._onEndCtx);
}
}});
lang.extend(_175e,_175d);
_175c.chain=function(_1768){
return new _175e(_1768);
};
var _1769=function(_176a){
this._animations=_176a||[];
this._connects=[];
this._finished=0;
this.duration=0;
_1756.forEach(_176a,function(a){
var _176b=a.duration;
if(a.delay){
_176b+=a.delay;
}
if(this.duration<_176b){
this.duration=_176b;
}
this._connects.push(_1757.connect(a,"onEnd",this,"_onEnd"));
},this);
this._pseudoAnimation=new _1758.Animation({curve:[0,1],duration:this.duration});
var self=this;
_1756.forEach(["beforeBegin","onBegin","onPlay","onAnimate","onPause","onStop","onEnd"],function(evt){
self._connects.push(_1757.connect(self._pseudoAnimation,evt,function(){
self._fire(evt,arguments);
}));
});
};
lang.extend(_1769,{_doAction:function(_176c,args){
_1756.forEach(this._animations,function(a){
a[_176c].apply(a,args);
});
return this;
},_onEnd:function(){
if(++this._finished>this._animations.length){
this._fire("onEnd");
}
},_call:function(_176d,args){
var t=this._pseudoAnimation;
t[_176d].apply(t,args);
},play:function(delay,_176e){
this._finished=0;
this._doAction("play",arguments);
this._call("play",arguments);
return this;
},pause:function(){
this._doAction("pause",arguments);
this._call("pause",arguments);
return this;
},gotoPercent:function(_176f,_1770){
var ms=this.duration*_176f;
_1756.forEach(this._animations,function(a){
a.gotoPercent(a.duration<ms?1:(ms/a.duration),_1770);
});
this._call("gotoPercent",arguments);
return this;
},stop:function(_1771){
this._doAction("stop",arguments);
this._call("stop",arguments);
return this;
},status:function(){
return this._pseudoAnimation.status();
},destroy:function(){
_1756.forEach(this._connects,_1757.disconnect);
}});
lang.extend(_1769,_175d);
_175c.combine=function(_1772){
return new _1769(_1772);
};
_175c.wipeIn=function(args){
var node=args.node=dom.byId(args.node),s=node.style,o;
var anim=_1758.animateProperty(lang.mixin({properties:{height:{start:function(){
o=s.overflow;
s.overflow="hidden";
if(s.visibility=="hidden"||s.display=="none"){
s.height="1px";
s.display="";
s.visibility="";
return 1;
}else{
var _1773=_1759.get(node,"height");
return Math.max(_1773,1);
}
},end:function(){
return node.scrollHeight;
}}}},args));
var fini=function(){
s.height="auto";
s.overflow=o;
};
_1757.connect(anim,"onStop",fini);
_1757.connect(anim,"onEnd",fini);
return anim;
};
_175c.wipeOut=function(args){
var node=args.node=dom.byId(args.node),s=node.style,o;
var anim=_1758.animateProperty(lang.mixin({properties:{height:{end:1}}},args));
_1757.connect(anim,"beforeBegin",function(){
o=s.overflow;
s.overflow="hidden";
s.display="";
});
var fini=function(){
s.overflow=o;
s.height="auto";
s.display="none";
};
_1757.connect(anim,"onStop",fini);
_1757.connect(anim,"onEnd",fini);
return anim;
};
_175c.slideTo=function(args){
var node=args.node=dom.byId(args.node),top=null,left=null;
var init=(function(n){
return function(){
var cs=_1759.getComputedStyle(n);
var pos=cs.position;
top=(pos=="absolute"?n.offsetTop:parseInt(cs.top)||0);
left=(pos=="absolute"?n.offsetLeft:parseInt(cs.left)||0);
if(pos!="absolute"&&pos!="relative"){
var ret=geom.position(n,true);
top=ret.y;
left=ret.x;
n.style.position="absolute";
n.style.top=top+"px";
n.style.left=left+"px";
}
};
})(node);
init();
var anim=_1758.animateProperty(lang.mixin({properties:{top:args.top||0,left:args.left||0}},args));
_1757.connect(anim,"beforeBegin",anim,init);
return anim;
};
return _175c;
});
},"davinci/js/js.plugin":function(){
define(["require"],function(_1774){
return {id:"davinci.js","davinci.editor":{id:"JSEditor",name:"JavaScript Editor",extensions:"js,json",isDefault:true,editorClass:"davinci/js/ui/JavaScriptEditor",palettePerspective:"davinci.html.htmlEditor",expandPalettes:["left"]},"davinci.actionSets":[{id:"jsEdit",visible:true,actions:[{id:"davinci.js.cut",icon:null,label:"cut",commandID:"davinci.js.cut",menubarPath:"davinci.edit/cut"},{id:"davinci.js.add",icon:null,label:"add",commandID:"davinci.js.add",menubarPath:"davinci.edit/add"},{id:"davinci.js.delete",icon:null,label:"delete",commandID:"davinci.js.delete",menubarPath:"davinci.edit/delete"}]}],"davinci.actionSetPartAssociations":[{targetID:"davinci.js.jsEdit",parts:["davinci.ui.outline","davinci.js.JSEditor"]}],"davinci.editorActions":{editorContribution:{targetID:"davinci.js.JSEditor",actions:[{id:"savecombo",className:"maqLabelButton",showLabel:true,label:"Save",toolbarPath:"save",type:"ComboButton",run:function(){
_1774(["../Workbench"],function(_1775){
_1774("../ui/Resource").save();
});
},isEnabled:function(_1776){
return _1774("../Workbench").getOpenEditor();
},menu:[{iconClass:"saveIcon",run:function(){
_1774("../ui/Resource").save();
},isEnabled:function(_1777){
return _1774("../Workbench").getOpenEditor();
},label:"Save",keyBinding:{accel:true,charOrCode:"s",allowGlobal:true}},{iconClass:"saveAsIcon",run:function(){
_1774("../ui/Resource").saveAs("html");
},isEnabled:function(_1778){
return _1774("../Workbench").getOpenEditor();
},label:"Save As",keyBinding:{accel:true,shift:true,charOrCode:"s",allowGlobal:true}}]}]}},"davinci.commands":[{id:"cut",run:function(){
}},{id:"add",run:function(){
}},{id:"delete",run:function(){
}}],"davinci.keyBindings":[{platform:"win",sequence:"M1+C",commandID:"davinci.js.copy",contextID:"davinci.js.JSEditor"}],"davinci.preferences":[],"davinci.fileType":[{extension:"js",iconClass:"jsFileIcon",type:"text"},{extension:"json",iconClass:"jsFileIcon",type:"text"}]};
});
},"dojox/grid/_SelectionPreserver":function(){
define(["dojo/_base/declare","dojo/_base/connect","dojo/_base/lang","dojo/_base/array"],function(_1779,_177a,lang,array){
return _1779("dojox.grid._SelectionPreserver",null,{constructor:function(_177b){
this.selection=_177b;
var grid=this.grid=_177b.grid;
this.reset();
this._connects=[_177a.connect(grid,"_setStore",this,"reset"),_177a.connect(grid,"_addItem",this,"_reSelectById"),_177a.connect(_177b,"onSelected",lang.hitch(this,"_selectById",true)),_177a.connect(_177b,"onDeselected",lang.hitch(this,"_selectById",false)),_177a.connect(_177b,"deselectAll",this,"reset")];
},destroy:function(){
this.reset();
array.forEach(this._connects,_177a.disconnect);
delete this._connects;
},reset:function(){
this._selectedById={};
},_reSelectById:function(item,index){
if(item&&this.grid._hasIdentity){
this.selection.selected[index]=this._selectedById[this.grid.store.getIdentity(item)];
}
},_selectById:function(_177c,_177d){
if(this.selection.mode=="none"||!this.grid._hasIdentity){
return;
}
var item=_177d,g=this.grid;
if(typeof _177d=="number"||typeof _177d=="string"){
var entry=g._by_idx[_177d];
item=entry&&entry.item;
}
if(item){
this._selectedById[g.store.getIdentity(item)]=!!_177c;
}
return item;
}});
});
},"davinci/model/Factory":function(){
define(["../html/CSSFile","../js/JSFile","../html/HTMLFile","system/resource"],function(_177e,_177f,_1780,_1781){
var _1782=[],_1783=[];
var _1784={getModel:function(args){
var url=args.url;
if(!url){
return null;
}
for(var i=0;i<_1783.length;i++){
if(_1783[i].url==url){
_1782[i]++;
this.incrementImports(_1783[i]);
return _1783[i];
}
}
if(/\.html?$/i.test(url)){
return _1784.newHTML(args);
}
if(/\.css$/i.test(url)){
return _1784.newCSS(args);
}
if(/\.js$/i.test(url)){
return _1784.newJS(args);
}
},closeModel:function(model){
var url=model.url;
if(!url){
return null;
}
for(var i=0;i<_1783.length;i++){
if(_1783[i].url==url){
var _1785=_1783[i];
_1782[i]--;
if(_1782[i]===0){
_1783.splice(i,1);
_1782.splice(i,1);
var _1786=_1781.findResource(url);
if(_1786&&_1786.dirtyResource){
_1786.removeWorkingCopy();
_1786.dirtyResource=false;
}
}
}
}
},newHTML:function(args){
var model=new _1780(args.url);
_1783.push(model);
var count=_1783.length-1;
_1782[count]=1;
return model;
},newCSS:function(args){
var model=new _177e(args);
_1783.push(model);
var count=_1783.length-1;
_1782[count]=1;
return model;
},newJS:function(args){
var model=new _177f(args);
_1783.push(model);
var count=_1783.length-1;
_1782[count]=1;
return model;
},getNewFromResource:function(_1787){
var _1788=_1787.extension;
if(!_1788){
return new _1780();
}
switch(_1788){
case "html":
return new _1780();
break;
case "css":
return new _177e();
break;
case "js":
case "json":
return new _177f();
break;
default:
return new _1780();
}
},incrementImports:function(_1789){
var _178a={visit:function(node){
if(node.elementType=="CSSImport"){
var url=node.cssFile.url;
for(var i=0;i<_1783.length;i++){
if(_1783[i].url==url){
_1782[i]++;
}
}
}
return false;
}};
if(_1789){
_1789.visit(_178a);
}
},log:function(){
for(var i=0;i<_1783.length;i++){
}
}};
var _178b=require(["dojo/_base/connect"],function(_178c){
_178c.subscribe("davinci/model/closeModel",_1784,_1784.closeModel);
});
return _1784;
});
},"dijit/_DialogMixin":function(){
define(["dojo/_base/declare","./a11y"],function(_178d,a11y){
return _178d("dijit._DialogMixin",null,{execute:function(){
},onCancel:function(){
},onExecute:function(){
},_onSubmit:function(){
this.onExecute();
this.execute(this.get("value"));
},_getFocusItems:function(){
var elems=a11y._getTabNavigable(this.containerNode);
this._firstFocusItem=elems.lowest||elems.first||this.closeButtonNode||this.domNode;
this._lastFocusItem=elems.last||elems.highest||this._firstFocusItem;
}});
});
},"davinci/version":function(){
define([],"10");
},"davinci/review/actions/_ReviewNavigatorCommon":function(){
define(["dojo/_base/declare","davinci/actions/Action"],function(_178e,_178f){
var _1790=_178e("davinci.review.actions._ReviewNavigatorCommon",[_178f],{_getSelection:function(_1791){
var _1792=null;
if(_1791.getSelection){
_1792=_1791.getSelection();
}else{
var _1793=dijit.byId("davinci.review.reviewNavigator");
_1792=_1793.getSelection();
}
return _1792;
},shouldShow:function(_1794){
return true;
}});
return _1790;
});
},"dojox/layout/ResizeHandle":function(){
define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/connect","dojo/_base/array","dojo/_base/event","dojo/_base/fx","dojo/_base/window","dojo/fx","dojo/window","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dijit/_base/manager","dijit/_Widget","dijit/_TemplatedMixin","dojo/_base/declare"],function(_1795,lang,_1796,_1797,_1798,_1799,_179a,_179b,_179c,_179d,_179e,_179f,_17a0,_17a1,_17a2,_17a3,_17a4){
_1795.experimental("dojox.layout.ResizeHandle");
var _17a5=_17a4("dojox.layout.ResizeHandle",[_17a2,_17a3],{targetId:"",targetContainer:null,resizeAxis:"xy",activeResize:false,activeResizeClass:"dojoxResizeHandleClone",animateSizing:true,animateMethod:"chain",animateDuration:225,minHeight:100,minWidth:100,constrainMax:false,maxHeight:0,maxWidth:0,fixedAspect:false,intermediateChanges:false,startTopic:"/dojo/resize/start",endTopic:"/dojo/resize/stop",templateString:"<div dojoAttachPoint=\"resizeHandle\" class=\"dojoxResizeHandle\"><div></div></div>",postCreate:function(){
this.connect(this.resizeHandle,"onmousedown","_beginSizing");
if(!this.activeResize){
this._resizeHelper=_17a1.byId("dojoxGlobalResizeHelper");
if(!this._resizeHelper){
this._resizeHelper=new _17a6({id:"dojoxGlobalResizeHelper"}).placeAt(_179a.body());
_179e.add(this._resizeHelper.domNode,this.activeResizeClass);
}
}else{
this.animateSizing=false;
}
if(!this.minSize){
this.minSize={w:this.minWidth,h:this.minHeight};
}
if(this.constrainMax){
this.maxSize={w:this.maxWidth,h:this.maxHeight};
}
this._resizeX=this._resizeY=false;
var _17a7=lang.partial(_179e.add,this.resizeHandle);
switch(this.resizeAxis.toLowerCase()){
case "xy":
this._resizeX=this._resizeY=true;
_17a7("dojoxResizeNW");
break;
case "x":
this._resizeX=true;
_17a7("dojoxResizeW");
break;
case "y":
this._resizeY=true;
_17a7("dojoxResizeN");
break;
}
},_beginSizing:function(e){
if(this._isSizing){
return;
}
_1796.publish(this.startTopic,[this]);
this.targetWidget=_17a1.byId(this.targetId);
this.targetDomNode=this.targetWidget?this.targetWidget.domNode:_179d.byId(this.targetId);
if(this.targetContainer){
this.targetDomNode=this.targetContainer;
}
if(!this.targetDomNode){
return;
}
if(!this.activeResize){
var c=_179f.position(this.targetDomNode,true);
this._resizeHelper.resize({l:c.x,t:c.y,w:c.w,h:c.h});
this._resizeHelper.show();
if(!this.isLeftToRight()){
this._resizeHelper.startPosition={l:c.x,t:c.y};
}
}
this._isSizing=true;
this.startPoint={x:e.clientX,y:e.clientY};
var style=_17a0.getComputedStyle(this.targetDomNode),_17a8=_179f.boxModel==="border-model",_17a9=_17a8?{w:0,h:0}:_179f.getPadBorderExtents(this.targetDomNode,style),_17aa=_179f.getMarginExtents(this.targetDomNode,style),mb;
mb=this.startSize={w:_17a0.get(this.targetDomNode,"width",style),h:_17a0.get(this.targetDomNode,"height",style),pbw:_17a9.w,pbh:_17a9.h,mw:_17aa.w,mh:_17aa.h};
if(!this.isLeftToRight()&&dojo.style(this.targetDomNode,"position")=="absolute"){
var p=_179f.position(this.targetDomNode,true);
this.startPosition={l:p.x,t:p.y};
}
this._pconnects=[_1796.connect(_179a.doc,"onmousemove",this,"_updateSizing"),_1796.connect(_179a.doc,"onmouseup",this,"_endSizing")];
_1798.stop(e);
},_updateSizing:function(e){
if(this.activeResize){
this._changeSizing(e);
}else{
var tmp=this._getNewCoords(e,"border",this._resizeHelper.startPosition);
if(tmp===false){
return;
}
this._resizeHelper.resize(tmp);
}
e.preventDefault();
},_getNewCoords:function(e,box,_17ab){
try{
if(!e.clientX||!e.clientY){
return false;
}
}
catch(e){
return false;
}
this._activeResizeLastEvent=e;
var dx=(this.isLeftToRight()?1:-1)*(this.startPoint.x-e.clientX),dy=this.startPoint.y-e.clientY,newW=this.startSize.w-(this._resizeX?dx:0),newH=this.startSize.h-(this._resizeY?dy:0),r=this._checkConstraints(newW,newH);
_17ab=(_17ab||this.startPosition);
if(_17ab&&this._resizeX){
r.l=_17ab.l+dx;
if(r.w!=newW){
r.l+=(newW-r.w);
}
r.t=_17ab.t;
}
switch(box){
case "margin":
r.w+=this.startSize.mw;
r.h+=this.startSize.mh;
case "border":
r.w+=this.startSize.pbw;
r.h+=this.startSize.pbh;
break;
}
return r;
},_checkConstraints:function(newW,newH){
if(this.minSize){
var tm=this.minSize;
if(newW<tm.w){
newW=tm.w;
}
if(newH<tm.h){
newH=tm.h;
}
}
if(this.constrainMax&&this.maxSize){
var ms=this.maxSize;
if(newW>ms.w){
newW=ms.w;
}
if(newH>ms.h){
newH=ms.h;
}
}
if(this.fixedAspect){
var w=this.startSize.w,h=this.startSize.h,delta=w*newH-h*newW;
if(delta<0){
newW=newH*w/h;
}else{
if(delta>0){
newH=newW*h/w;
}
}
}
return {w:newW,h:newH};
},_changeSizing:function(e){
var _17ac=this.targetWidget&&lang.isFunction(this.targetWidget.resize),tmp=this._getNewCoords(e,_17ac&&"margin");
if(tmp===false){
return;
}
if(_17ac){
this.targetWidget.resize(tmp);
}else{
if(this.animateSizing){
var anim=_179b[this.animateMethod]([_1799.animateProperty({node:this.targetDomNode,properties:{width:{start:this.startSize.w,end:tmp.w}},duration:this.animateDuration}),_1799.animateProperty({node:this.targetDomNode,properties:{height:{start:this.startSize.h,end:tmp.h}},duration:this.animateDuration})]);
anim.play();
}else{
_17a0.set(this.targetDomNode,{width:tmp.w+"px",height:tmp.h+"px"});
}
}
if(this.intermediateChanges){
this.onResize(e);
}
},_endSizing:function(e){
_1797.forEach(this._pconnects,_1796.disconnect);
var pub=lang.partial(_1796.publish,this.endTopic,[this]);
if(!this.activeResize){
this._resizeHelper.hide();
this._changeSizing(e);
setTimeout(pub,this.animateDuration+15);
}else{
pub();
}
this._isSizing=false;
this.onResize(e);
},onResize:function(e){
}});
var _17a6=dojo.declare("dojox.layout._ResizeHelper",_17a2,{show:function(){
_17a0.set(this.domNode,"display","");
},hide:function(){
_17a0.set(this.domNode,"display","none");
},resize:function(dim){
_179f.setMarginBox(this.domNode,dim);
}});
return _17a5;
});
},"dijit/Tree":function(){
define(["dojo/_base/array","dojo/_base/connect","dojo/cookie","dojo/_base/declare","dojo/Deferred","dojo/DeferredList","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/errors/create","dojo/fx","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/topic","dojo/touch","dojo/when","./focus","./registry","./_base/manager","./_Widget","./_TemplatedMixin","./_Container","./_Contained","./_CssStateMixin","dojo/text!./templates/TreeNode.html","dojo/text!./templates/Tree.html","./tree/TreeStoreModel","./tree/ForestStoreModel","./tree/_dndSelector"],function(array,_17ad,_17ae,_17af,_17b0,_17b1,dom,_17b2,_17b3,_17b4,event,_17b5,_17b6,_17b7,keys,lang,on,topic,touch,when,focus,_17b8,_17b9,_17ba,_17bb,_17bc,_17bd,_17be,_17bf,_17c0,_17c1,_17c2,_17c3){
_17b0=_17af(_17b0,{addCallback:function(_17c4){
this.then(_17c4);
},addErrback:function(_17c5){
this.then(null,_17c5);
}});
var _17c6=_17af("dijit._TreeNode",[_17ba,_17bb,_17bc,_17bd,_17be],{item:null,isTreeNode:true,label:"",_setLabelAttr:{node:"labelNode",type:"innerText"},isExpandable:null,isExpanded:false,state:"UNCHECKED",templateString:_17bf,baseClass:"dijitTreeNode",cssStateNodes:{rowNode:"dijitTreeRow"},_setTooltipAttr:{node:"rowNode",type:"attribute",attribute:"title"},buildRendering:function(){
this.inherited(arguments);
this._setExpando();
this._updateItemClasses(this.item);
if(this.isExpandable){
this.labelNode.setAttribute("aria-expanded",this.isExpanded);
}
this.setSelected(false);
},_setIndentAttr:function(_17c7){
var _17c8=(Math.max(_17c7,0)*this.tree._nodePixelIndent)+"px";
_17b4.set(this.domNode,"backgroundPosition",_17c8+" 0px");
_17b4.set(this.indentNode,this.isLeftToRight()?"paddingLeft":"paddingRight",_17c8);
array.forEach(this.getChildren(),function(child){
child.set("indent",_17c7+1);
});
this._set("indent",_17c7);
},markProcessing:function(){
this.state="LOADING";
this._setExpando(true);
},unmarkProcessing:function(){
this._setExpando(false);
},_updateItemClasses:function(item){
var tree=this.tree,model=tree.model;
if(tree._v10Compat&&item===model.root){
item=null;
}
this._applyClassAndStyle(item,"icon","Icon");
this._applyClassAndStyle(item,"label","Label");
this._applyClassAndStyle(item,"row","Row");
this.tree._startPaint(true);
},_applyClassAndStyle:function(item,lower,upper){
var _17c9="_"+lower+"Class";
var _17ca=lower+"Node";
var _17cb=this[_17c9];
this[_17c9]=this.tree["get"+upper+"Class"](item,this.isExpanded);
_17b2.replace(this[_17ca],this[_17c9]||"",_17cb||"");
_17b4.set(this[_17ca],this.tree["get"+upper+"Style"](item,this.isExpanded)||{});
},_updateLayout:function(){
var _17cc=this.getParent();
if(!_17cc||!_17cc.rowNode||_17cc.rowNode.style.display=="none"){
_17b2.add(this.domNode,"dijitTreeIsRoot");
}else{
_17b2.toggle(this.domNode,"dijitTreeIsLast",!this.getNextSibling());
}
},_setExpando:function(_17cd){
var _17ce=["dijitTreeExpandoLoading","dijitTreeExpandoOpened","dijitTreeExpandoClosed","dijitTreeExpandoLeaf"],_17cf=["*","-","+","*"],idx=_17cd?0:(this.isExpandable?(this.isExpanded?1:2):3);
_17b2.replace(this.expandoNode,_17ce[idx],_17ce);
this.expandoNodeText.innerHTML=_17cf[idx];
},expand:function(){
if(this._expandDeferred){
return this._expandDeferred;
}
if(this._collapseDeferred){
this._collapseDeferred.cancel();
delete this._collapseDeferred;
}
this.isExpanded=true;
this.labelNode.setAttribute("aria-expanded","true");
if(this.tree.showRoot||this!==this.tree.rootNode){
this.containerNode.setAttribute("role","group");
}
_17b2.add(this.contentNode,"dijitTreeContentExpanded");
this._setExpando();
this._updateItemClasses(this.item);
if(this==this.tree.rootNode&&this.tree.showRoot){
this.tree.domNode.setAttribute("aria-expanded","true");
}
var def,_17d0=_17b6.wipeIn({node:this.containerNode,duration:_17b9.defaultDuration,onEnd:function(){
def.resolve(true);
}});
def=(this._expandDeferred=new _17b0(function(){
_17d0.stop();
}));
_17d0.play();
return def;
},collapse:function(){
if(this._collapseDeferred){
return this._collapseDeferred;
}
if(this._expandDeferred){
this._expandDeferred.cancel();
delete this._expandDeferred;
}
this.isExpanded=false;
this.labelNode.setAttribute("aria-expanded","false");
if(this==this.tree.rootNode&&this.tree.showRoot){
this.tree.domNode.setAttribute("aria-expanded","false");
}
_17b2.remove(this.contentNode,"dijitTreeContentExpanded");
this._setExpando();
this._updateItemClasses(this.item);
var def,_17d1=_17b6.wipeOut({node:this.containerNode,duration:_17b9.defaultDuration,onEnd:function(){
def.resolve(true);
}});
def=(this._collapseDeferred=new _17b0(function(){
_17d1.stop();
}));
_17d1.play();
return def;
},indent:0,setChildItems:function(items){
var tree=this.tree,model=tree.model,defs=[];
var _17d2=this.getChildren();
array.forEach(_17d2,function(child){
_17bc.prototype.removeChild.call(this,child);
},this);
this.defer(function(){
array.forEach(_17d2,function(node){
if(!node._destroyed&&!node.getParent()){
tree.dndController.removeTreeNode(node);
var id=model.getIdentity(node.item),ary=tree._itemNodesMap[id];
if(ary.length==1){
delete tree._itemNodesMap[id];
}else{
var index=array.indexOf(ary,node);
if(index!=-1){
ary.splice(index,1);
}
}
node.destroyRecursive();
}
});
});
this.state="LOADED";
if(items&&items.length>0){
this.isExpandable=true;
array.forEach(items,function(item){
var id=model.getIdentity(item),_17d3=tree._itemNodesMap[id],node;
if(_17d3){
for(var i=0;i<_17d3.length;i++){
if(_17d3[i]&&!_17d3[i].getParent()){
node=_17d3[i];
node.set("indent",this.indent+1);
break;
}
}
}
if(!node){
node=this.tree._createTreeNode({item:item,tree:tree,isExpandable:model.mayHaveChildren(item),label:tree.getLabel(item),tooltip:tree.getTooltip(item),ownerDocument:tree.ownerDocument,dir:tree.dir,lang:tree.lang,textDir:tree.textDir,indent:this.indent+1});
if(_17d3){
_17d3.push(node);
}else{
tree._itemNodesMap[id]=[node];
}
}
this.addChild(node);
if(this.tree.autoExpand||this.tree._state(node)){
defs.push(tree._expandNode(node));
}
},this);
array.forEach(this.getChildren(),function(child){
child._updateLayout();
});
}else{
this.isExpandable=false;
}
if(this._setExpando){
this._setExpando(false);
}
this._updateItemClasses(this.item);
if(this==tree.rootNode){
var fc=this.tree.showRoot?this:this.getChildren()[0];
if(fc){
fc.setFocusable(true);
tree.lastFocused=fc;
}else{
tree.domNode.setAttribute("tabIndex","0");
}
}
var def=new _17b1(defs);
this.tree._startPaint(def);
return def;
},getTreePath:function(){
var node=this;
var path=[];
while(node&&node!==this.tree.rootNode){
path.unshift(node.item);
node=node.getParent();
}
path.unshift(this.tree.rootNode.item);
return path;
},getIdentity:function(){
return this.tree.model.getIdentity(this.item);
},removeChild:function(node){
this.inherited(arguments);
var _17d4=this.getChildren();
if(_17d4.length==0){
this.isExpandable=false;
this.collapse();
}
array.forEach(_17d4,function(child){
child._updateLayout();
});
},makeExpandable:function(){
this.isExpandable=true;
this._setExpando(false);
},setSelected:function(_17d5){
this.labelNode.setAttribute("aria-selected",_17d5?"true":"false");
_17b2.toggle(this.rowNode,"dijitTreeRowSelected",_17d5);
},setFocusable:function(_17d6){
this.labelNode.setAttribute("tabIndex",_17d6?"0":"-1");
},_setTextDirAttr:function(_17d7){
if(_17d7&&((this.textDir!=_17d7)||!this._created)){
this._set("textDir",_17d7);
this.applyTextDir(this.labelNode,this.labelNode.innerText||this.labelNode.textContent||"");
array.forEach(this.getChildren(),function(_17d8){
_17d8.set("textDir",_17d7);
},this);
}
}});
var Tree=_17af("dijit.Tree",[_17ba,_17bb],{store:null,model:null,query:null,label:"",showRoot:true,childrenAttr:["children"],paths:[],path:[],selectedItems:null,selectedItem:null,openOnClick:false,openOnDblClick:false,templateString:_17c0,persist:true,autoExpand:false,dndController:_17c3,dndParams:["onDndDrop","itemCreator","onDndCancel","checkAcceptance","checkItemAcceptance","dragThreshold","betweenThreshold"],onDndDrop:null,itemCreator:null,onDndCancel:null,checkAcceptance:null,checkItemAcceptance:null,dragThreshold:5,betweenThreshold:0,_nodePixelIndent:19,_publish:function(_17d9,_17da){
topic.publish(this.id,lang.mixin({tree:this,event:_17d9},_17da||{}));
},postMixInProperties:function(){
this.tree=this;
if(this.autoExpand){
this.persist=false;
}
this._itemNodesMap={};
if(!this.cookieName&&this.id){
this.cookieName=this.id+"SaveStateCookie";
}
this.expandChildrenDeferred=new _17b0();
this.pendingCommandsDeferred=this.expandChildrenDeferred;
this.inherited(arguments);
},postCreate:function(){
this._initState();
var self=this;
this.own(on(this.domNode,on.selector(".dijitTreeNode",touch.enter),function(evt){
self._onNodeMouseEnter(_17b8.byNode(this),evt);
}),on(this.domNode,on.selector(".dijitTreeNode",touch.leave),function(evt){
self._onNodeMouseLeave(_17b8.byNode(this),evt);
}),on(this.domNode,on.selector(".dijitTreeNode","click"),function(evt){
self._onClick(_17b8.byNode(this),evt);
}),on(this.domNode,on.selector(".dijitTreeNode","dblclick"),function(evt){
self._onDblClick(_17b8.byNode(this),evt);
}),on(this.domNode,on.selector(".dijitTreeNode","keypress"),function(evt){
self._onKeyPress(_17b8.byNode(this),evt);
}),on(this.domNode,on.selector(".dijitTreeNode","keydown"),function(evt){
self._onKeyDown(_17b8.byNode(this),evt);
}),on(this.domNode,on.selector(".dijitTreeRow","focusin"),function(evt){
self._onNodeFocus(_17b8.getEnclosingWidget(this),evt);
}));
if(!this.model){
this._store2model();
}
this.connect(this.model,"onChange","_onItemChange");
this.connect(this.model,"onChildrenChange","_onItemChildrenChange");
this.connect(this.model,"onDelete","_onItemDelete");
this.inherited(arguments);
if(this.dndController){
if(lang.isString(this.dndController)){
this.dndController=lang.getObject(this.dndController);
}
var _17db={};
for(var i=0;i<this.dndParams.length;i++){
if(this[this.dndParams[i]]){
_17db[this.dndParams[i]]=this[this.dndParams[i]];
}
}
this.dndController=new this.dndController(this,_17db);
}
this._load();
if(!this.params.path&&!this.params.paths&&this.persist){
this.set("paths",this.dndController._getSavedPaths());
}
this.onLoadDeferred=this.pendingCommandsDeferred;
this.onLoadDeferred.then(lang.hitch(this,"onLoad"));
},_store2model:function(){
this._v10Compat=true;
_17b7.deprecated("Tree: from version 2.0, should specify a model object rather than a store/query");
var _17dc={id:this.id+"_ForestStoreModel",store:this.store,query:this.query,childrenAttrs:this.childrenAttr};
if(this.params.mayHaveChildren){
_17dc.mayHaveChildren=lang.hitch(this,"mayHaveChildren");
}
if(this.params.getItemChildren){
_17dc.getChildren=lang.hitch(this,function(item,_17dd,_17de){
this.getItemChildren((this._v10Compat&&item===this.model.root)?null:item,_17dd,_17de);
});
}
this.model=new _17c2(_17dc);
this.showRoot=Boolean(this.label);
},onLoad:function(){
},_load:function(){
this.model.getRoot(lang.hitch(this,function(item){
var rn=(this.rootNode=this.tree._createTreeNode({item:item,tree:this,isExpandable:true,label:this.label||this.getLabel(item),textDir:this.textDir,indent:this.showRoot?0:-1}));
if(!this.showRoot){
rn.rowNode.style.display="none";
this.domNode.setAttribute("role","presentation");
this.domNode.removeAttribute("aria-expanded");
this.domNode.removeAttribute("aria-multiselectable");
rn.labelNode.setAttribute("role","presentation");
rn.containerNode.setAttribute("role","tree");
rn.containerNode.setAttribute("aria-expanded","true");
rn.containerNode.setAttribute("aria-multiselectable",!this.dndController.singular);
}else{
this.domNode.setAttribute("aria-multiselectable",!this.dndController.singular);
}
this.domNode.appendChild(rn.domNode);
var _17df=this.model.getIdentity(item);
if(this._itemNodesMap[_17df]){
this._itemNodesMap[_17df].push(rn);
}else{
this._itemNodesMap[_17df]=[rn];
}
rn._updateLayout();
this._expandNode(rn).then(lang.hitch(this,function(){
this.expandChildrenDeferred.resolve(true);
}));
}),lang.hitch(this,function(err){
console.error(this,": error loading root: ",err);
}));
},getNodesByItem:function(item){
if(!item){
return [];
}
var _17e0=lang.isString(item)?item:this.model.getIdentity(item);
return [].concat(this._itemNodesMap[_17e0]);
},_setSelectedItemAttr:function(item){
this.set("selectedItems",[item]);
},_setSelectedItemsAttr:function(items){
var tree=this;
return this.pendingCommandsDeferred=this.pendingCommandsDeferred.then(lang.hitch(this,function(){
var _17e1=array.map(items,function(item){
return (!item||lang.isString(item))?item:tree.model.getIdentity(item);
});
var nodes=[];
array.forEach(_17e1,function(id){
nodes=nodes.concat(tree._itemNodesMap[id]||[]);
});
this.set("selectedNodes",nodes);
}));
},_setPathAttr:function(path){
if(path.length){
return this.set("paths",[path]);
}else{
return this.set("paths",[]);
}
},_setPathsAttr:function(paths){
var tree=this;
return this.pendingCommandsDeferred=this.pendingCommandsDeferred.then(function(){
return new _17b1(array.map(paths,function(path){
var d=new _17b0();
path=array.map(path,function(item){
return lang.isString(item)?item:tree.model.getIdentity(item);
});
if(path.length){
_17e2(path,[tree.rootNode],d);
}else{
d.reject(new Tree.PathError("Empty path"));
}
return d;
}));
}).then(_17e3);
function _17e2(path,nodes,def){
var _17e4=path.shift();
var _17e5=array.filter(nodes,function(node){
return node.getIdentity()==_17e4;
})[0];
if(!!_17e5){
if(path.length){
tree._expandNode(_17e5).then(function(){
_17e2(path,_17e5.getChildren(),def);
});
}else{
def.resolve(_17e5);
}
}else{
def.reject(new Tree.PathError("Could not expand path at "+_17e4));
}
};
function _17e3(_17e6){
tree.set("selectedNodes",array.map(array.filter(_17e6,function(x){
return x[0];
}),function(x){
return x[1];
}));
};
},_setSelectedNodeAttr:function(node){
this.set("selectedNodes",[node]);
},_setSelectedNodesAttr:function(nodes){
this.dndController.setSelection(nodes);
},expandAll:function(){
var _17e7=this;
function _17e8(node){
var def=new dojo.Deferred();
_17e7._expandNode(node).then(function(){
var _17e9=array.filter(node.getChildren()||[],function(node){
return node.isExpandable;
}),defs=array.map(_17e9,_17e8);
new dojo.DeferredList(defs).then(function(){
def.resolve(true);
});
});
return def;
};
return _17e8(this.rootNode);
},collapseAll:function(){
var _17ea=this;
function _17eb(node){
var def=new dojo.Deferred();
def.label="collapseAllDeferred";
var _17ec=array.filter(node.getChildren()||[],function(node){
return node.isExpandable;
}),defs=array.map(_17ec,_17eb);
new dojo.DeferredList(defs).then(function(){
if(!node.isExpanded||(node==_17ea.rootNode&&!_17ea.showRoot)){
def.resolve(true);
}else{
_17ea._collapseNode(node).then(function(){
def.resolve(true);
});
}
});
return def;
};
return _17eb(this.rootNode);
},mayHaveChildren:function(){
},getItemChildren:function(){
},getLabel:function(item){
return this.model.getLabel(item);
},getIconClass:function(item,_17ed){
return (!item||this.model.mayHaveChildren(item))?(_17ed?"dijitFolderOpened":"dijitFolderClosed"):"dijitLeaf";
},getLabelClass:function(){
},getRowClass:function(){
},getIconStyle:function(){
},getLabelStyle:function(){
},getRowStyle:function(){
},getTooltip:function(){
return "";
},_onKeyPress:function(_17ee,e){
if(e.charCode<=32){
return;
}
if(!e.altKey&&!e.ctrlKey&&!e.shiftKey&&!e.metaKey){
var c=String.fromCharCode(e.charCode);
this._onLetterKeyNav({node:_17ee,key:c.toLowerCase()});
event.stop(e);
}
},_onKeyDown:function(_17ef,e){
var key=e.keyCode;
var map=this._keyHandlerMap;
if(!map){
map={};
map[keys.ENTER]=map[keys.SPACE]=map[" "]="_onEnterKey";
map[this.isLeftToRight()?keys.LEFT_ARROW:keys.RIGHT_ARROW]="_onLeftArrow";
map[this.isLeftToRight()?keys.RIGHT_ARROW:keys.LEFT_ARROW]="_onRightArrow";
map[keys.UP_ARROW]="_onUpArrow";
map[keys.DOWN_ARROW]="_onDownArrow";
map[keys.HOME]="_onHomeKey";
map[keys.END]="_onEndKey";
this._keyHandlerMap=map;
}
if(this._keyHandlerMap[key]){
if(this._curSearch){
this._curSearch.timer.remove();
delete this._curSearch;
}
this[this._keyHandlerMap[key]]({node:_17ef,item:_17ef.item,evt:e});
event.stop(e);
}
},_onEnterKey:function(_17f0){
this._publish("execute",{item:_17f0.item,node:_17f0.node});
this.dndController.userSelect(_17f0.node,_17ad.isCopyKey(_17f0.evt),_17f0.evt.shiftKey);
this.onClick(_17f0.item,_17f0.node,_17f0.evt);
},_onDownArrow:function(_17f1){
var node=this._getNextNode(_17f1.node);
if(node&&node.isTreeNode){
this.focusNode(node);
}
},_onUpArrow:function(_17f2){
var node=_17f2.node;
var _17f3=node.getPreviousSibling();
if(_17f3){
node=_17f3;
while(node.isExpandable&&node.isExpanded&&node.hasChildren()){
var _17f4=node.getChildren();
node=_17f4[_17f4.length-1];
}
}else{
var _17f5=node.getParent();
if(!(!this.showRoot&&_17f5===this.rootNode)){
node=_17f5;
}
}
if(node&&node.isTreeNode){
this.focusNode(node);
}
},_onRightArrow:function(_17f6){
var node=_17f6.node;
if(node.isExpandable&&!node.isExpanded){
this._expandNode(node);
}else{
if(node.hasChildren()){
node=node.getChildren()[0];
if(node&&node.isTreeNode){
this.focusNode(node);
}
}
}
},_onLeftArrow:function(_17f7){
var node=_17f7.node;
if(node.isExpandable&&node.isExpanded){
this._collapseNode(node);
}else{
var _17f8=node.getParent();
if(_17f8&&_17f8.isTreeNode&&!(!this.showRoot&&_17f8===this.rootNode)){
this.focusNode(_17f8);
}
}
},_onHomeKey:function(){
var node=this._getRootOrFirstNode();
if(node){
this.focusNode(node);
}
},_onEndKey:function(){
var node=this.rootNode;
while(node.isExpanded){
var c=node.getChildren();
node=c[c.length-1];
}
if(node&&node.isTreeNode){
this.focusNode(node);
}
},multiCharSearchDuration:250,_onLetterKeyNav:function(_17f9){
var cs=this._curSearch;
if(cs){
cs.pattern=cs.pattern+_17f9.key;
cs.timer.remove();
}else{
cs=this._curSearch={pattern:_17f9.key,startNode:_17f9.node};
}
cs.timer=this.defer(function(){
delete this._curSearch;
},this.multiCharSearchDuration);
var node=cs.startNode;
do{
node=this._getNextNode(node);
if(!node){
node=this._getRootOrFirstNode();
}
}while(node!==cs.startNode&&(node.label.toLowerCase().substr(0,cs.pattern.length)!=cs.pattern));
if(node&&node.isTreeNode){
if(node!==cs.startNode){
this.focusNode(node);
}
}
},isExpandoNode:function(node,_17fa){
return dom.isDescendant(node,_17fa.expandoNode)||dom.isDescendant(node,_17fa.expandoNodeText);
},_onClick:function(_17fb,e){
var _17fc=e.target,_17fd=this.isExpandoNode(_17fc,_17fb);
if((this.openOnClick&&_17fb.isExpandable)||_17fd){
if(_17fb.isExpandable){
this._onExpandoClick({node:_17fb});
}
}else{
this._publish("execute",{item:_17fb.item,node:_17fb,evt:e});
this.onClick(_17fb.item,_17fb,e);
this.focusNode(_17fb);
}
event.stop(e);
},_onDblClick:function(_17fe,e){
var _17ff=e.target,_1800=(_17ff==_17fe.expandoNode||_17ff==_17fe.expandoNodeText);
if((this.openOnDblClick&&_17fe.isExpandable)||_1800){
if(_17fe.isExpandable){
this._onExpandoClick({node:_17fe});
}
}else{
this._publish("execute",{item:_17fe.item,node:_17fe,evt:e});
this.onDblClick(_17fe.item,_17fe,e);
this.focusNode(_17fe);
}
event.stop(e);
},_onExpandoClick:function(_1801){
var node=_1801.node;
this.focusNode(node);
if(node.isExpanded){
this._collapseNode(node);
}else{
this._expandNode(node);
}
},onClick:function(){
},onDblClick:function(){
},onOpen:function(){
},onClose:function(){
},_getNextNode:function(node){
if(node.isExpandable&&node.isExpanded&&node.hasChildren()){
return node.getChildren()[0];
}else{
while(node&&node.isTreeNode){
var _1802=node.getNextSibling();
if(_1802){
return _1802;
}
node=node.getParent();
}
return null;
}
},_getRootOrFirstNode:function(){
return this.showRoot?this.rootNode:this.rootNode.getChildren()[0];
},_collapseNode:function(node){
if(node._expandNodeDeferred){
delete node._expandNodeDeferred;
}
if(node.state=="LOADING"){
return;
}
if(node.isExpanded){
var ret=node.collapse();
this.onClose(node.item,node);
this._state(node,false);
this._startPaint(ret);
return ret;
}
},_expandNode:function(node){
var def=new _17b0();
if(node._expandNodeDeferred){
return node._expandNodeDeferred;
}
var model=this.model,item=node.item,_1803=this;
if(!node._loadDeferred){
node.markProcessing();
node._loadDeferred=new _17b0();
model.getChildren(item,function(items){
node.unmarkProcessing();
node.setChildItems(items).then(function(){
node._loadDeferred.resolve(items);
});
},function(err){
console.error(_1803,": error loading "+node.label+" children: ",err);
node._loadDeferred.reject(err);
});
}
node._loadDeferred.then(lang.hitch(this,function(){
node.expand().then(function(){
def.resolve(true);
});
this.onOpen(node.item,node);
this._state(node,true);
}));
this._startPaint(def);
return def;
},focusNode:function(node){
focus.focus(node.labelNode);
},_onNodeFocus:function(node){
if(node&&node!=this.lastFocused){
if(this.lastFocused&&!this.lastFocused._destroyed){
this.lastFocused.setFocusable(false);
}
node.setFocusable(true);
this.lastFocused=node;
}
},_onNodeMouseEnter:function(){
},_onNodeMouseLeave:function(){
},_onItemChange:function(item){
var model=this.model,_1804=model.getIdentity(item),nodes=this._itemNodesMap[_1804];
if(nodes){
var label=this.getLabel(item),_1805=this.getTooltip(item);
array.forEach(nodes,function(node){
node.set({item:item,label:label,tooltip:_1805});
node._updateItemClasses(item);
});
}
},_onItemChildrenChange:function(_1806,_1807){
var model=this.model,_1808=model.getIdentity(_1806),_1809=this._itemNodesMap[_1808];
if(_1809){
array.forEach(_1809,function(_180a){
_180a.setChildItems(_1807);
});
}
},_onItemDelete:function(item){
var model=this.model,_180b=model.getIdentity(item),nodes=this._itemNodesMap[_180b];
if(nodes){
array.forEach(nodes,function(node){
this.dndController.removeTreeNode(node);
var _180c=node.getParent();
if(_180c){
_180c.removeChild(node);
}
node.destroyRecursive();
},this);
delete this._itemNodesMap[_180b];
}
},_initState:function(){
this._openedNodes={};
if(this.persist&&this.cookieName){
var oreo=_17ae(this.cookieName);
if(oreo){
array.forEach(oreo.split(","),function(item){
this._openedNodes[item]=true;
},this);
}
}
},_state:function(node,_180d){
if(!this.persist){
return false;
}
var path=array.map(node.getTreePath(),function(item){
return this.model.getIdentity(item);
},this).join("/");
if(arguments.length===1){
return this._openedNodes[path];
}else{
if(_180d){
this._openedNodes[path]=true;
}else{
delete this._openedNodes[path];
}
if(this.persist&&this.cookieName){
var ary=[];
for(var id in this._openedNodes){
ary.push(id);
}
_17ae(this.cookieName,ary.join(","),{expires:365});
}
}
},destroy:function(){
if(this._curSearch){
this._curSearch.timer.remove();
delete this._curSearch;
}
if(this.rootNode){
this.rootNode.destroyRecursive();
}
if(this.dndController&&!lang.isString(this.dndController)){
this.dndController.destroy();
}
this.rootNode=null;
this.inherited(arguments);
},destroyRecursive:function(){
this.destroy();
},resize:function(_180e){
if(_180e){
_17b3.setMarginBox(this.domNode,_180e);
}
this._nodePixelIndent=_17b3.position(this.tree.indentDetector).w||this._nodePixelIndent;
this.expandChildrenDeferred.then(lang.hitch(this,function(){
this.rootNode.set("indent",this.showRoot?0:-1);
this._adjustWidths();
}));
},_outstandingPaintOperations:0,_startPaint:function(p){
this._outstandingPaintOperations++;
if(this._adjustWidthsTimer){
this._adjustWidthsTimer.remove();
delete this._adjustWidthsTimer;
}
var oc=lang.hitch(this,function(){
this._outstandingPaintOperations--;
if(this._outstandingPaintOperations<=0&&!this._adjustWidthsTimer&&this._started){
this._adjustWidthsTimer=this.defer("_adjustWidths");
}
});
when(p,oc,oc);
},_adjustWidths:function(){
if(this._adjustWidthsTimer){
this._adjustWidthsTimer.remove();
delete this._adjustWidthsTimer;
}
var _180f=0,nodes=[];
function _1810(_1811){
var node=_1811.rowNode;
node.style.width="auto";
_180f=Math.max(_180f,node.clientWidth);
nodes.push(node);
if(_1811.isExpanded){
array.forEach(_1811.getChildren(),_1810);
}
};
_1810(this.rootNode);
_180f=Math.max(_180f,_17b3.getContentBox(this.domNode).w);
array.forEach(nodes,function(node){
node.style.width=_180f+"px";
});
},_createTreeNode:function(args){
return new _17c6(args);
},_setTextDirAttr:function(_1812){
if(_1812&&this.textDir!=_1812){
this._set("textDir",_1812);
this.rootNode.set("textDir",_1812);
}
}});
Tree.PathError=_17b5("TreePathError");
Tree._TreeNode=_17c6;
return Tree;
});
},"davinci/html/HTMLComment":function(){
define(["dojo/_base/declare","davinci/html/HTMLItem"],function(_1813,_1814){
return _1813("davinci.html.HTMLComment",_1814,{constructor:function(value){
this.elementType="HTMLComment";
this.value=value||"";
},getText:function(_1815){
var dash=this.isProcessingInstruction?"":"--";
return "<!"+dash+this.value+dash+">";
}});
});
},"*now":function(r){
r(["dojo/i18n!*preload*maq-metadata-html/html/nls/FieldsetInput*[\"ar\",\"ca\",\"cs\",\"da\",\"de\",\"el\",\"en-gb\",\"en-us\",\"es-es\",\"fi-fi\",\"fr-fr\",\"he-il\",\"hu\",\"it-it\",\"ja-jp\",\"ko-kr\",\"nl-nl\",\"nb\",\"pl\",\"pt-br\",\"pt-pt\",\"ru\",\"sk\",\"sl\",\"sv\",\"th\",\"tr\",\"zh-tw\",\"zh-cn\",\"ROOT\"]"]);
}}});
define("maq-metadata-html/html/FieldsetInput",["dojo/_base/declare","davinci/Runtime","davinci/ve/input/SmartInput","davinci/ve/commands/ModifyCommand","dojo/i18n!./nls/html"],function(_1816,_1817,_1818,_1819,_181a){
return _1816(_1818,{property:"value",displayOnCreate:"true",multiLine:"false",format:"rows",supportsHTML:"false",helpText:"",constructor:function(){
this.helpText=_181a.fieldsetInputHelp;
},serialize:function(_181b,_181c,value){
var data=_181b.getData();
var _181d=data.children;
var _181e="";
for(var i=0;i<_181d.length;i++){
var child=_181d[i];
if(child.type==="html.legend"){
if(typeof child.children==="string"){
var text=child.children;
text=dojox.html.entities.decode(text);
_181e=text;
}
}
}
_181c(_181e);
},update:function(_181f,value){
var data=_181f.getData();
var _1820=data.children;
var _1821=false;
for(var i=0;i<_1820.length;i++){
var child=_1820[i];
if(child.type==="html.legend"){
child.children=value;
_1821=true;
break;
}
}
if(!_1821){
var _1822=this._createLegend(value);
if(typeof _1820==="string"){
_1820=[];
}
_1820.push(_1822);
}
var _1823=new _1819(_181f,null,_1820);
this._getContext().getCommandStack().execute(_1823);
return _1823.newWidget;
},_createLegend:function(text){
return {type:"html.legend",children:text};
},_getEditor:function(){
return _1817.currentEditor;
},_getContext:function(){
var _1824=this._getEditor();
return _1824&&(_1824.getContext&&_1824.getContext()||_1824.context);
}});
});
