/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dojo/i18n":function(){
define("dojo/i18n",["./_base/kernel","require","./has","./_base/array","./_base/config","./_base/lang","./_base/xhr","./json","module"],function(_1,_2,_3,_4,_5,_6,_7,_8,_9){
_3.add("dojo-preload-i18n-Api",1);
1||_3.add("dojo-v1x-i18n-Api",1);
var _a=_1.i18n={},_b=/(^.*(^|\/)nls)(\/|$)([^\/]*)\/?([^\/]*)/,_c=function(_d,_e,_f,_10){
for(var _11=[_f+_10],_12=_e.split("-"),_13="",i=0;i<_12.length;i++){
_13+=(_13?"-":"")+_12[i];
if(!_d||_d[_13]){
_11.push(_f+_13+"/"+_10);
}
}
return _11;
},_14={},_15=function(_16,_17,_18){
_18=_18?_18.toLowerCase():_1.locale;
_16=_16.replace(/\./g,"/");
_17=_17.replace(/\./g,"/");
return (/root/i.test(_18))?(_16+"/nls/"+_17):(_16+"/nls/"+_18+"/"+_17);
},_19=_1.getL10nName=function(_1a,_1b,_1c){
return _1a=_9.id+"!"+_15(_1a,_1b,_1c);
},_1d=function(_1e,_1f,_20,_21,_22,_23){
_1e([_1f],function(_24){
var _25=_6.clone(_24.root),_26=_c(!_24._v1x&&_24,_22,_20,_21);
_1e(_26,function(){
for(var i=1;i<_26.length;i++){
_25=_6.mixin(_6.clone(_25),arguments[i]);
}
var _27=_1f+"/"+_22;
_14[_27]=_25;
_23();
});
});
},_28=function(id,_29){
return /^\./.test(id)?_29(id):id;
},_2a=function(_2b){
var _2c=_5.extraLocale||[];
_2c=_6.isArray(_2c)?_2c:[_2c];
_2c.push(_2b);
return _2c;
},_2d=function(id,_2e,_2f){
if(_3("dojo-preload-i18n-Api")){
var _30=id.split("*"),_31=_30[1]=="preload";
if(_31){
if(!_14[id]){
_14[id]=1;
_32(_30[2],_8.parse(_30[3]),1,_2e);
}
_2f(1);
}
if(_31||_33(id,_2e,_2f)){
return;
}
}
var _34=_b.exec(id),_35=_34[1]+"/",_36=_34[5]||_34[4],_37=_35+_36,_38=(_34[5]&&_34[4]),_39=_38||_1.locale,_3a=_37+"/"+_39,_3b=_38?[_39]:_2a(_39),_3c=_3b.length,_3d=function(){
if(!--_3c){
_2f(_6.delegate(_14[_3a]));
}
};
_4.forEach(_3b,function(_3e){
var _3f=_37+"/"+_3e;
if(_3("dojo-preload-i18n-Api")){
_40(_3f);
}
if(!_14[_3f]){
_1d(_2e,_37,_35,_36,_3e,_3d);
}else{
_3d();
}
});
};
if(_3("dojo-unit-tests")){
var _41=_a.unitTests=[];
}
if(_3("dojo-preload-i18n-Api")||1){
var _42=_a.normalizeLocale=function(_43){
var _44=_43?_43.toLowerCase():_1.locale;
return _44=="root"?"ROOT":_44;
},_45=function(mid,_46){
return (1&&1)?_46.isXdUrl(_2.toUrl(mid+".js")):true;
},_47=0,_48=[],_32=_a._preloadLocalizations=function(_49,_4a,_4b,_4c){
_4c=_4c||_2;
function _4d(mid,_4e){
if(_45(mid,_4c)||_4b){
_4c([mid],_4e);
}else{
_5a([mid],_4e,_4c);
}
};
function _4f(_50,_51){
var _52=_50.split("-");
while(_52.length){
if(_51(_52.join("-"))){
return;
}
_52.pop();
}
_51("ROOT");
};
function _53(_54){
_54=_42(_54);
_4f(_54,function(loc){
if(_4.indexOf(_4a,loc)>=0){
var mid=_49.replace(/\./g,"/")+"_"+loc;
_47++;
_4d(mid,function(_55){
for(var p in _55){
_14[_2.toAbsMid(p)+"/"+loc]=_55[p];
}
--_47;
while(!_47&&_48.length){
_2d.apply(null,_48.shift());
}
});
return true;
}
return false;
});
};
_53();
_4.forEach(_1.config.extraLocale,_53);
},_33=function(id,_56,_57){
if(_47){
_48.push([id,_56,_57]);
}
return _47;
},_40=function(){
};
}
if(1){
var _58={},_59=new Function("__bundle","__checkForLegacyModules","__mid","__amdValue","var define = function(mid, factory){define.called = 1; __amdValue.result = factory || mid;},"+"\t   require = function(){define.called = 1;};"+"try{"+"define.called = 0;"+"eval(__bundle);"+"if(define.called==1)"+"return __amdValue;"+"if((__checkForLegacyModules = __checkForLegacyModules(__mid)))"+"return __checkForLegacyModules;"+"}catch(e){}"+"try{"+"return eval('('+__bundle+')');"+"}catch(e){"+"return e;"+"}"),_5a=function(_5b,_5c,_5d){
var _5e=[];
_4.forEach(_5b,function(mid){
var url=_5d.toUrl(mid+".js");
function _2d(_5f){
var _60=_59(_5f,_40,mid,_58);
if(_60===_58){
_5e.push(_14[url]=_58.result);
}else{
if(_60 instanceof Error){
console.error("failed to evaluate i18n bundle; url="+url,_60);
_60={};
}
_5e.push(_14[url]=(/nls\/[^\/]+\/[^\/]+$/.test(url)?_60:{root:_60,_v1x:1}));
}
};
if(_14[url]){
_5e.push(_14[url]);
}else{
var _61=_5d.syncLoadNls(mid);
if(_61){
_5e.push(_61);
}else{
if(!_7){
try{
_5d.getText(url,true,_2d);
}
catch(e){
_5e.push(_14[url]={});
}
}else{
_7.get({url:url,sync:true,load:_2d,error:function(){
_5e.push(_14[url]={});
}});
}
}
}
});
_5c&&_5c.apply(null,_5e);
};
_40=function(_62){
for(var _63,_64=_62.split("/"),_65=_1.global[_64[0]],i=1;_65&&i<_64.length-1;_65=_65[_64[i++]]){
}
if(_65){
_63=_65[_64[i]];
if(!_63){
_63=_65[_64[i].replace(/-/g,"_")];
}
if(_63){
_14[_62]=_63;
}
}
return _63;
};
_a.getLocalization=function(_66,_67,_68){
var _69,_6a=_15(_66,_67,_68);
_2d(_6a,(!_45(_6a,_2)?function(_6b,_6c){
_5a(_6b,_6c,_2);
}:_2),function(_6d){
_69=_6d;
});
return _69;
};
if(_3("dojo-unit-tests")){
_41.push(function(doh){
doh.register("tests.i18n.unit",function(t){
var _6e;
_6e=_59("{prop:1}",_40,"nonsense",_58);
t.is({prop:1},_6e);
t.is(undefined,_6e[1]);
_6e=_59("({prop:1})",_40,"nonsense",_58);
t.is({prop:1},_6e);
t.is(undefined,_6e[1]);
_6e=_59("{'prop-x':1}",_40,"nonsense",_58);
t.is({"prop-x":1},_6e);
t.is(undefined,_6e[1]);
_6e=_59("({'prop-x':1})",_40,"nonsense",_58);
t.is({"prop-x":1},_6e);
t.is(undefined,_6e[1]);
_6e=_59("define({'prop-x':1})",_40,"nonsense",_58);
t.is(_58,_6e);
t.is({"prop-x":1},_58.result);
_6e=_59("define('some/module', {'prop-x':1})",_40,"nonsense",_58);
t.is(_58,_6e);
t.is({"prop-x":1},_58.result);
_6e=_59("this is total nonsense and should throw an error",_40,"nonsense",_58);
t.is(_6e instanceof Error,true);
});
});
}
}
return _6.mixin(_a,{dynamic:true,normalize:_28,load:_2d,cache:_14});
});
},"dijit/form/DropDownButton":function(){
require({cache:{"url:dijit/form/templates/DropDownButton.html":"<span class=\"dijit dijitReset dijitInline\"\n\t><span class='dijitReset dijitInline dijitButtonNode'\n\t\tdata-dojo-attach-event=\"ondijitclick:_onClick\" data-dojo-attach-point=\"_buttonNode\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"focusNode,titleNode,_arrowWrapperNode\"\n\t\t\trole=\"button\" aria-haspopup=\"true\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\"\n\t\t\t\tdata-dojo-attach-point=\"iconNode\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode,_popupStateNode\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonInner\"></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonChar\">&#9660;</span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\" tabIndex=\"-1\"\n\t\tdata-dojo-attach-point=\"valueNode\" role=\"presentation\"\n/></span>\n"}});
define("dijit/form/DropDownButton",["dojo/_base/declare","dojo/_base/lang","dojo/query","../registry","../popup","./Button","../_Container","../_HasDropDown","dojo/text!./templates/DropDownButton.html"],function(_6f,_70,_71,_72,_73,_74,_75,_76,_77){
return _6f("dijit.form.DropDownButton",[_74,_75,_76],{baseClass:"dijitDropDownButton",templateString:_77,_fillContent:function(){
if(this.srcNodeRef){
var _78=_71("*",this.srcNodeRef);
this.inherited(arguments,[_78[0]]);
this.dropDownContainer=this.srcNodeRef;
}
},startup:function(){
if(this._started){
return;
}
if(!this.dropDown&&this.dropDownContainer){
var _79=_71("[widgetId]",this.dropDownContainer)[0];
this.dropDown=_72.byNode(_79);
delete this.dropDownContainer;
}
if(this.dropDown){
_73.hide(this.dropDown);
}
this.inherited(arguments);
},isLoaded:function(){
var _7a=this.dropDown;
return (!!_7a&&(!_7a.href||_7a.isLoaded));
},loadDropDown:function(_7b){
var _7c=this.dropDown;
var _7d=_7c.on("load",_70.hitch(this,function(){
_7d.remove();
_7b();
}));
_7c.refresh();
},isFocusable:function(){
return this.inherited(arguments)&&!this._mouseDown;
}});
});
},"dijit/layout/ContentPane":function(){
define("dijit/layout/ContentPane",["dojo/_base/kernel","dojo/_base/lang","../_Widget","../_Container","./_ContentPaneResizeMixin","dojo/string","dojo/html","dojo/i18n!../nls/loading","dojo/_base/array","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/_base/xhr","dojo/i18n","dojo/when"],function(_7e,_7f,_80,_81,_82,_83,_84,_85,_86,_87,_88,dom,_89,_8a,xhr,_8b,_8c){
return _87("dijit.layout.ContentPane",[_80,_81,_82],{href:"",content:"",extractContent:false,parseOnLoad:true,parserScope:_7e._scopeName,preventCache:false,preload:false,refreshOnShow:false,loadingMessage:"<span class='dijitContentPaneLoading'><span class='dijitInline dijitIconLoading'></span>${loadingState}</span>",errorMessage:"<span class='dijitContentPaneError'><span class='dijitInline dijitIconError'></span>${errorState}</span>",isLoaded:false,baseClass:"dijitContentPane",ioArgs:{},onLoadDeferred:null,_setTitleAttr:null,stopParser:true,template:false,create:function(_8d,_8e){
if((!_8d||!_8d.template)&&_8e&&!("href" in _8d)&&!("content" in _8d)){
_8e=dom.byId(_8e);
var df=_8e.ownerDocument.createDocumentFragment();
while(_8e.firstChild){
df.appendChild(_8e.firstChild);
}
_8d=_7f.delegate(_8d,{content:df});
}
this.inherited(arguments,[_8d,_8e]);
},postMixInProperties:function(){
this.inherited(arguments);
var _8f=_8b.getLocalization("dijit","loading",this.lang);
this.loadingMessage=_83.substitute(this.loadingMessage,_8f);
this.errorMessage=_83.substitute(this.errorMessage,_8f);
},buildRendering:function(){
this.inherited(arguments);
if(!this.containerNode){
this.containerNode=this.domNode;
}
this.domNode.title="";
if(!_89.get(this.domNode,"role")){
this.domNode.setAttribute("role","group");
}
},startup:function(){
this.inherited(arguments);
if(this._contentSetter){
_86.forEach(this._contentSetter.parseResults,function(obj){
if(!obj._started&&!obj._destroyed&&_7f.isFunction(obj.startup)){
obj.startup();
obj._started=true;
}
},this);
}
},_startChildren:function(){
_86.forEach(this.getChildren(),function(obj){
if(!obj._started&&!obj._destroyed&&_7f.isFunction(obj.startup)){
obj.startup();
obj._started=true;
}
});
if(this._contentSetter){
_86.forEach(this._contentSetter.parseResults,function(obj){
if(!obj._started&&!obj._destroyed&&_7f.isFunction(obj.startup)){
obj.startup();
obj._started=true;
}
},this);
}
},setHref:function(_90){
_7e.deprecated("dijit.layout.ContentPane.setHref() is deprecated. Use set('href', ...) instead.","","2.0");
return this.set("href",_90);
},_setHrefAttr:function(_91){
this.cancel();
this.onLoadDeferred=new _88(_7f.hitch(this,"cancel"));
this.onLoadDeferred.then(_7f.hitch(this,"onLoad"));
this._set("href",_91);
if(this.preload||(this._created&&this._isShown())){
this._load();
}else{
this._hrefChanged=true;
}
return this.onLoadDeferred;
},setContent:function(_92){
_7e.deprecated("dijit.layout.ContentPane.setContent() is deprecated.  Use set('content', ...) instead.","","2.0");
this.set("content",_92);
},_setContentAttr:function(_93){
this._set("href","");
this.cancel();
this.onLoadDeferred=new _88(_7f.hitch(this,"cancel"));
if(this._created){
this.onLoadDeferred.then(_7f.hitch(this,"onLoad"));
}
this._setContent(_93||"");
this._isDownloaded=false;
return this.onLoadDeferred;
},_getContentAttr:function(){
return this.containerNode.innerHTML;
},cancel:function(){
if(this._xhrDfd&&(this._xhrDfd.fired==-1)){
this._xhrDfd.cancel();
}
delete this._xhrDfd;
this.onLoadDeferred=null;
},destroy:function(){
this.cancel();
this.inherited(arguments);
},destroyRecursive:function(_94){
if(this._beingDestroyed){
return;
}
this.inherited(arguments);
},_onShow:function(){
this.inherited(arguments);
if(this.href){
if(!this._xhrDfd&&(!this.isLoaded||this._hrefChanged||this.refreshOnShow)){
return this.refresh();
}
}
},refresh:function(){
this.cancel();
this.onLoadDeferred=new _88(_7f.hitch(this,"cancel"));
this.onLoadDeferred.then(_7f.hitch(this,"onLoad"));
this._load();
return this.onLoadDeferred;
},_load:function(){
this._setContent(this.onDownloadStart(),true);
var _95=this;
var _96={preventCache:(this.preventCache||this.refreshOnShow),url:this.href,handleAs:"text"};
if(_7f.isObject(this.ioArgs)){
_7f.mixin(_96,this.ioArgs);
}
var _97=(this._xhrDfd=(this.ioMethod||xhr.get)(_96)),_98;
_97.then(function(_99){
_98=_99;
try{
_95._isDownloaded=true;
return _95._setContent(_99,false);
}
catch(err){
_95._onError("Content",err);
}
},function(err){
if(!_97.canceled){
_95._onError("Download",err);
}
delete _95._xhrDfd;
return err;
}).then(function(){
_95.onDownloadEnd();
delete _95._xhrDfd;
return _98;
});
delete this._hrefChanged;
},_onLoadHandler:function(_9a){
this._set("isLoaded",true);
try{
this.onLoadDeferred.resolve(_9a);
}
catch(e){
console.error("Error "+this.widgetId+" running custom onLoad code: "+e.message);
}
},_onUnloadHandler:function(){
this._set("isLoaded",false);
try{
this.onUnload();
}
catch(e){
console.error("Error "+this.widgetId+" running custom onUnload code: "+e.message);
}
},destroyDescendants:function(_9b){
if(this.isLoaded){
this._onUnloadHandler();
}
var _9c=this._contentSetter;
_86.forEach(this.getChildren(),function(_9d){
if(_9d.destroyRecursive){
_9d.destroyRecursive(_9b);
}else{
if(_9d.destroy){
_9d.destroy(_9b);
}
}
_9d._destroyed=true;
});
if(_9c){
_86.forEach(_9c.parseResults,function(_9e){
if(!_9e._destroyed){
if(_9e.destroyRecursive){
_9e.destroyRecursive(_9b);
}else{
if(_9e.destroy){
_9e.destroy(_9b);
}
}
_9e._destroyed=true;
}
});
delete _9c.parseResults;
}
if(!_9b){
_8a.empty(this.containerNode);
}
delete this._singleChild;
},_setContent:function(_9f,_a0){
this.destroyDescendants();
var _a1=this._contentSetter;
if(!(_a1&&_a1 instanceof _84._ContentSetter)){
_a1=this._contentSetter=new _84._ContentSetter({node:this.containerNode,_onError:_7f.hitch(this,this._onError),onContentError:_7f.hitch(this,function(e){
var _a2=this.onContentError(e);
try{
this.containerNode.innerHTML=_a2;
}
catch(e){
console.error("Fatal "+this.id+" could not change content due to "+e.message,e);
}
})});
}
var _a3=_7f.mixin({cleanContent:this.cleanContent,extractContent:this.extractContent,parseContent:!_9f.domNode&&this.parseOnLoad,parserScope:this.parserScope,startup:false,dir:this.dir,lang:this.lang,textDir:this.textDir},this._contentSetterParams||{});
var p=_a1.set((_7f.isObject(_9f)&&_9f.domNode)?_9f.domNode:_9f,_a3);
var _a4=this;
return _8c(p&&p.then?p:_a1.parseDeferred,function(){
delete _a4._contentSetterParams;
if(!_a0){
if(_a4._started){
_a4._startChildren();
_a4._scheduleLayout();
}
_a4._onLoadHandler(_9f);
}
});
},_onError:function(_a5,err,_a6){
this.onLoadDeferred.reject(err);
var _a7=this["on"+_a5+"Error"].call(this,err);
if(_a6){
console.error(_a6,err);
}else{
if(_a7){
this._setContent(_a7,true);
}
}
},onLoad:function(){
},onUnload:function(){
},onDownloadStart:function(){
return this.loadingMessage;
},onContentError:function(){
},onDownloadError:function(){
return this.errorMessage;
},onDownloadEnd:function(){
}});
});
},"dojo/dnd/autoscroll":function(){
define("dojo/dnd/autoscroll",["../_base/lang","../sniff","../_base/window","../dom-geometry","../dom-style","../window"],function(_a8,has,win,_a9,_aa,_ab){
var _ac={};
_a8.setObject("dojo.dnd.autoscroll",_ac);
_ac.getViewport=_ab.getBox;
_ac.V_TRIGGER_AUTOSCROLL=32;
_ac.H_TRIGGER_AUTOSCROLL=32;
_ac.V_AUTOSCROLL_VALUE=16;
_ac.H_AUTOSCROLL_VALUE=16;
var _ad,doc=win.doc,_ae=Infinity,_af=Infinity;
_ac.autoScrollStart=function(d){
doc=d;
_ad=_ab.getBox(doc);
var _b0=win.body(doc).parentNode;
_ae=Math.max(_b0.scrollHeight-_ad.h,0);
_af=Math.max(_b0.scrollWidth-_ad.w,0);
};
_ac.autoScroll=function(e){
var v=_ad||_ab.getBox(doc),_b1=win.body(doc).parentNode,dx=0,dy=0;
if(e.clientX<_ac.H_TRIGGER_AUTOSCROLL){
dx=-_ac.H_AUTOSCROLL_VALUE;
}else{
if(e.clientX>v.w-_ac.H_TRIGGER_AUTOSCROLL){
dx=Math.min(_ac.H_AUTOSCROLL_VALUE,_af-_b1.scrollLeft);
}
}
if(e.clientY<_ac.V_TRIGGER_AUTOSCROLL){
dy=-_ac.V_AUTOSCROLL_VALUE;
}else{
if(e.clientY>v.h-_ac.V_TRIGGER_AUTOSCROLL){
dy=Math.min(_ac.V_AUTOSCROLL_VALUE,_ae-_b1.scrollTop);
}
}
window.scrollBy(dx,dy);
};
_ac._validNodes={"div":1,"p":1,"td":1};
_ac._validOverflow={"auto":1,"scroll":1};
_ac.autoScrollNodes=function(e){
var b,t,w,h,rx,ry,dx=0,dy=0,_b2,_b3;
for(var n=e.target;n;){
if(n.nodeType==1&&(n.tagName.toLowerCase() in _ac._validNodes)){
var s=_aa.getComputedStyle(n),_b4=(s.overflow.toLowerCase() in _ac._validOverflow),_b5=(s.overflowX.toLowerCase() in _ac._validOverflow),_b6=(s.overflowY.toLowerCase() in _ac._validOverflow);
if(_b4||_b5||_b6){
b=_a9.getContentBox(n,s);
t=_a9.position(n,true);
}
if(_b4||_b5){
w=Math.min(_ac.H_TRIGGER_AUTOSCROLL,b.w/2);
rx=e.pageX-t.x;
if(has("webkit")||has("opera")){
rx+=win.body().scrollLeft;
}
dx=0;
if(rx>0&&rx<b.w){
if(rx<w){
dx=-w;
}else{
if(rx>b.w-w){
dx=w;
}
}
_b2=n.scrollLeft;
n.scrollLeft=n.scrollLeft+dx;
}
}
if(_b4||_b6){
h=Math.min(_ac.V_TRIGGER_AUTOSCROLL,b.h/2);
ry=e.pageY-t.y;
if(has("webkit")||has("opera")){
ry+=win.body().scrollTop;
}
dy=0;
if(ry>0&&ry<b.h){
if(ry<h){
dy=-h;
}else{
if(ry>b.h-h){
dy=h;
}
}
_b3=n.scrollTop;
n.scrollTop=n.scrollTop+dy;
}
}
if(dx||dy){
return;
}
}
try{
n=n.parentNode;
}
catch(x){
n=null;
}
}
_ac.autoScroll(e);
};
return _ac;
});
},"url:dijit/form/templates/ValidationTextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\" role=\"presentation\"\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n","dijit/form/_TextBoxMixin":function(){
define("dijit/form/_TextBoxMixin",["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/on","../main"],function(_b7,_b8,dom,_b9,_ba,_bb,on,_bc){
var _bd=_b8("dijit.form._TextBoxMixin",null,{trim:false,uppercase:false,lowercase:false,propercase:false,maxLength:"",selectOnClick:false,placeHolder:"",_getValueAttr:function(){
return this.parse(this.get("displayedValue"),this.constraints);
},_setValueAttr:function(_be,_bf,_c0){
var _c1;
if(_be!==undefined){
_c1=this.filter(_be);
if(typeof _c0!="string"){
if(_c1!==null&&((typeof _c1!="number")||!isNaN(_c1))){
_c0=this.filter(this.format(_c1,this.constraints));
}else{
_c0="";
}
}
}
if(_c0!=null&&((typeof _c0)!="number"||!isNaN(_c0))&&this.textbox.value!=_c0){
this.textbox.value=_c0;
this._set("displayedValue",this.get("displayedValue"));
}
if(this.textDir=="auto"){
this.applyTextDir(this.focusNode,_c0);
}
this.inherited(arguments,[_c1,_bf]);
},displayedValue:"",_getDisplayedValueAttr:function(){
return this.filter(this.textbox.value);
},_setDisplayedValueAttr:function(_c2){
if(_c2==null){
_c2="";
}else{
if(typeof _c2!="string"){
_c2=String(_c2);
}
}
this.textbox.value=_c2;
this._setValueAttr(this.get("value"),undefined);
this._set("displayedValue",this.get("displayedValue"));
if(this.textDir=="auto"){
this.applyTextDir(this.focusNode,_c2);
}
},format:function(_c3){
return _c3==null?"":(_c3.toString?_c3.toString():_c3);
},parse:function(_c4){
return _c4;
},_refreshState:function(){
},onInput:function(){
},__skipInputEvent:false,_onInput:function(evt){
if(this.textDir=="auto"){
this.applyTextDir(this.focusNode,this.focusNode.value);
}
this._processInput(evt);
},_processInput:function(evt){
this._refreshState();
this._set("displayedValue",this.get("displayedValue"));
},postCreate:function(){
this.textbox.setAttribute("value",this.textbox.value);
this.inherited(arguments);
var _c5=function(e){
var _c6;
if(e.type=="keydown"){
_c6=e.keyCode;
switch(_c6){
case _ba.SHIFT:
case _ba.ALT:
case _ba.CTRL:
case _ba.META:
case _ba.CAPS_LOCK:
case _ba.NUM_LOCK:
case _ba.SCROLL_LOCK:
return;
}
if(!e.ctrlKey&&!e.metaKey&&!e.altKey){
switch(_c6){
case _ba.NUMPAD_0:
case _ba.NUMPAD_1:
case _ba.NUMPAD_2:
case _ba.NUMPAD_3:
case _ba.NUMPAD_4:
case _ba.NUMPAD_5:
case _ba.NUMPAD_6:
case _ba.NUMPAD_7:
case _ba.NUMPAD_8:
case _ba.NUMPAD_9:
case _ba.NUMPAD_MULTIPLY:
case _ba.NUMPAD_PLUS:
case _ba.NUMPAD_ENTER:
case _ba.NUMPAD_MINUS:
case _ba.NUMPAD_PERIOD:
case _ba.NUMPAD_DIVIDE:
return;
}
if((_c6>=65&&_c6<=90)||(_c6>=48&&_c6<=57)||_c6==_ba.SPACE){
return;
}
var _c7=false;
for(var i in _ba){
if(_ba[i]===e.keyCode){
_c7=true;
break;
}
}
if(!_c7){
return;
}
}
}
_c6=e.charCode>=32?String.fromCharCode(e.charCode):e.charCode;
if(!_c6){
_c6=(e.keyCode>=65&&e.keyCode<=90)||(e.keyCode>=48&&e.keyCode<=57)||e.keyCode==_ba.SPACE?String.fromCharCode(e.keyCode):e.keyCode;
}
if(!_c6){
_c6=229;
}
if(e.type=="keypress"){
if(typeof _c6!="string"){
return;
}
if((_c6>="a"&&_c6<="z")||(_c6>="A"&&_c6<="Z")||(_c6>="0"&&_c6<="9")||(_c6===" ")){
if(e.ctrlKey||e.metaKey||e.altKey){
return;
}
}
}
if(e.type=="input"){
if(this.__skipInputEvent){
this.__skipInputEvent=false;
return;
}
}else{
this.__skipInputEvent=true;
}
var _c8={faux:true},_c9;
for(_c9 in e){
if(_c9!="layerX"&&_c9!="layerY"){
var v=e[_c9];
if(typeof v!="function"&&typeof v!="undefined"){
_c8[_c9]=v;
}
}
}
_bb.mixin(_c8,{charOrCode:_c6,_wasConsumed:false,preventDefault:function(){
_c8._wasConsumed=true;
e.preventDefault();
},stopPropagation:function(){
e.stopPropagation();
}});
if(this.onInput(_c8)===false){
_c8.preventDefault();
_c8.stopPropagation();
}
if(_c8._wasConsumed){
return;
}
this.defer(function(){
this._onInput(_c8);
});
};
this.own(on(this.textbox,"keydown, keypress, paste, cut, input, compositionend",_bb.hitch(this,_c5)));
},_blankValue:"",filter:function(val){
if(val===null){
return this._blankValue;
}
if(typeof val!="string"){
return val;
}
if(this.trim){
val=_bb.trim(val);
}
if(this.uppercase){
val=val.toUpperCase();
}
if(this.lowercase){
val=val.toLowerCase();
}
if(this.propercase){
val=val.replace(/[^\s]+/g,function(_ca){
return _ca.substring(0,1).toUpperCase()+_ca.substring(1);
});
}
return val;
},_setBlurValue:function(){
this._setValueAttr(this.get("value"),true);
},_onBlur:function(e){
if(this.disabled){
return;
}
this._setBlurValue();
this.inherited(arguments);
},_isTextSelected:function(){
return this.textbox.selectionStart!=this.textbox.selectionEnd;
},_onFocus:function(by){
if(this.disabled||this.readOnly){
return;
}
if(this.selectOnClick&&by=="mouse"){
this._selectOnClickHandle=this.connect(this.domNode,"onmouseup",function(){
this.disconnect(this._selectOnClickHandle);
this._selectOnClickHandle=null;
if(!this._isTextSelected()){
_bd.selectInputText(this.textbox);
}
});
this.defer(function(){
if(this._selectOnClickHandle){
this.disconnect(this._selectOnClickHandle);
this._selectOnClickHandle=null;
}
},500);
}
this.inherited(arguments);
this._refreshState();
},reset:function(){
this.textbox.value="";
this.inherited(arguments);
},_setTextDirAttr:function(_cb){
if(!this._created||this.textDir!=_cb){
this._set("textDir",_cb);
this.applyTextDir(this.focusNode,this.focusNode.value);
}
}});
_bd._setSelectionRange=_bc._setSelectionRange=function(_cc,_cd,_ce){
if(_cc.setSelectionRange){
_cc.setSelectionRange(_cd,_ce);
}
};
_bd.selectInputText=_bc.selectInputText=function(_cf,_d0,_d1){
_cf=dom.byId(_cf);
if(isNaN(_d0)){
_d0=0;
}
if(isNaN(_d1)){
_d1=_cf.value?_cf.value.length:0;
}
try{
_cf.focus();
_bd._setSelectionRange(_cf,_d0,_d1);
}
catch(e){
}
};
return _bd;
});
},"dijit/Menu":function(){
define("dijit/Menu",["require","dojo/_base/array","dojo/_base/declare","dojo/_base/event","dojo/dom","dojo/dom-attr","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/_base/window","dojo/window","./popup","./DropDownMenu","dojo/ready"],function(_d2,_d3,_d4,_d5,dom,_d6,_d7,_d8,_d9,_da,on,has,win,_db,pm,_dc,_dd){
if(has("dijit-legacy-requires")){
_dd(0,function(){
var _de=["dijit/MenuItem","dijit/PopupMenuItem","dijit/CheckedMenuItem","dijit/MenuSeparator"];
_d2(_de);
});
}
return _d4("dijit.Menu",_dc,{constructor:function(){
this._bindings=[];
},targetNodeIds:[],selector:"",contextMenuForWindow:false,leftClickToOpen:false,refocus:true,postCreate:function(){
if(this.contextMenuForWindow){
this.bindDomNode(this.ownerDocumentBody);
}else{
_d3.forEach(this.targetNodeIds,this.bindDomNode,this);
}
this.inherited(arguments);
},_iframeContentWindow:function(_df){
return _db.get(this._iframeContentDocument(_df))||this._iframeContentDocument(_df)["__parent__"]||(_df.name&&win.doc.frames[_df.name])||null;
},_iframeContentDocument:function(_e0){
return _e0.contentDocument||(_e0.contentWindow&&_e0.contentWindow.document)||(_e0.name&&win.doc.frames[_e0.name]&&win.doc.frames[_e0.name].document)||null;
},bindDomNode:function(_e1){
_e1=dom.byId(_e1,this.ownerDocument);
var cn;
if(_e1.tagName.toLowerCase()=="iframe"){
var _e2=_e1,_e3=this._iframeContentWindow(_e2);
cn=win.body(_e3.document);
}else{
cn=(_e1==win.body(this.ownerDocument)?this.ownerDocument.documentElement:_e1);
}
var _e4={node:_e1,iframe:_e2};
_d6.set(_e1,"_dijitMenu"+this.id,this._bindings.push(_e4));
var _e5=_da.hitch(this,function(cn){
var _e6=this.selector,_e7=_e6?function(_e8){
return on.selector(_e6,_e8);
}:function(_e9){
return _e9;
},_ea=this;
return [on(cn,_e7(this.leftClickToOpen?"click":"contextmenu"),function(evt){
_d5.stop(evt);
_ea._scheduleOpen(this,_e2,{x:evt.pageX,y:evt.pageY});
}),on(cn,_e7("keydown"),function(evt){
if(evt.shiftKey&&evt.keyCode==_d9.F10){
_d5.stop(evt);
_ea._scheduleOpen(this,_e2);
}
})];
});
_e4.connects=cn?_e5(cn):[];
if(_e2){
_e4.onloadHandler=_da.hitch(this,function(){
var _eb=this._iframeContentWindow(_e2);
cn=win.body(_eb.document);
_e4.connects=_e5(cn);
});
if(_e2.addEventListener){
_e2.addEventListener("load",_e4.onloadHandler,false);
}else{
_e2.attachEvent("onload",_e4.onloadHandler);
}
}
},unBindDomNode:function(_ec){
var _ed;
try{
_ed=dom.byId(_ec,this.ownerDocument);
}
catch(e){
return;
}
var _ee="_dijitMenu"+this.id;
if(_ed&&_d6.has(_ed,_ee)){
var bid=_d6.get(_ed,_ee)-1,b=this._bindings[bid],h;
while((h=b.connects.pop())){
h.remove();
}
var _ef=b.iframe;
if(_ef){
if(_ef.removeEventListener){
_ef.removeEventListener("load",b.onloadHandler,false);
}else{
_ef.detachEvent("onload",b.onloadHandler);
}
}
_d6.remove(_ed,_ee);
delete this._bindings[bid];
}
},_scheduleOpen:function(_f0,_f1,_f2){
if(!this._openTimer){
this._openTimer=this.defer(function(){
delete this._openTimer;
this._openMyself({target:_f0,iframe:_f1,coords:_f2});
},1);
}
},_openMyself:function(_f3){
var _f4=_f3.target,_f5=_f3.iframe,_f6=_f3.coords;
this.currentTarget=_f4;
if(_f6){
if(_f5){
var ifc=_d7.position(_f5,true),_f7=this._iframeContentWindow(_f5),_f8=_d7.docScroll(_f7.document);
var cs=_d8.getComputedStyle(_f5),tp=_d8.toPixelValue,_f9=(has("ie")&&has("quirks")?0:tp(_f5,cs.paddingLeft))+(has("ie")&&has("quirks")?tp(_f5,cs.borderLeftWidth):0),top=(has("ie")&&has("quirks")?0:tp(_f5,cs.paddingTop))+(has("ie")&&has("quirks")?tp(_f5,cs.borderTopWidth):0);
_f6.x+=ifc.x+_f9-_f8.x;
_f6.y+=ifc.y+top-_f8.y;
}
}else{
_f6=_d7.position(_f4,true);
_f6.x+=10;
_f6.y+=10;
}
var _fa=this;
var _fb=this._focusManager.get("prevNode");
var _fc=this._focusManager.get("curNode");
var _fd=!_fc||(dom.isDescendant(_fc,this.domNode))?_fb:_fc;
function _fe(){
if(_fa.refocus&&_fd){
_fd.focus();
}
pm.close(_fa);
};
pm.open({popup:this,x:_f6.x,y:_f6.y,onExecute:_fe,onCancel:_fe,orient:this.isLeftToRight()?"L":"R"});
this.focus();
this._onBlur=function(){
this.inherited("_onBlur",arguments);
pm.close(this);
};
},destroy:function(){
_d3.forEach(this._bindings,function(b){
if(b){
this.unBindDomNode(b.node);
}
},this);
this.inherited(arguments);
}});
});
},"dijit/layout/utils":function(){
define("dijit/layout/utils",["dojo/_base/array","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","../main"],function(_ff,_100,_101,_102,lang,_103){
var _104=lang.getObject("layout",true,_103);
_104.marginBox2contentBox=function(node,mb){
var cs=_102.getComputedStyle(node);
var me=_101.getMarginExtents(node,cs);
var pb=_101.getPadBorderExtents(node,cs);
return {l:_102.toPixelValue(node,cs.paddingLeft),t:_102.toPixelValue(node,cs.paddingTop),w:mb.w-(me.w+pb.w),h:mb.h-(me.h+pb.h)};
};
function _105(word){
return word.substring(0,1).toUpperCase()+word.substring(1);
};
function size(_106,dim){
var _107=_106.resize?_106.resize(dim):_101.setMarginBox(_106.domNode,dim);
if(_107){
lang.mixin(_106,_107);
}else{
lang.mixin(_106,_101.getMarginBox(_106.domNode));
lang.mixin(_106,dim);
}
};
_104.layoutChildren=function(_108,dim,_109,_10a,_10b){
dim=lang.mixin({},dim);
_100.add(_108,"dijitLayoutContainer");
_109=_ff.filter(_109,function(item){
return item.region!="center"&&item.layoutAlign!="client";
}).concat(_ff.filter(_109,function(item){
return item.region=="center"||item.layoutAlign=="client";
}));
_ff.forEach(_109,function(_10c){
var elm=_10c.domNode,pos=(_10c.region||_10c.layoutAlign);
if(!pos){
throw new Error("No region setting for "+_10c.id);
}
var _10d=elm.style;
_10d.left=dim.l+"px";
_10d.top=dim.t+"px";
_10d.position="absolute";
_100.add(elm,"dijitAlign"+_105(pos));
var _10e={};
if(_10a&&_10a==_10c.id){
_10e[_10c.region=="top"||_10c.region=="bottom"?"h":"w"]=_10b;
}
if(pos=="top"||pos=="bottom"){
_10e.w=dim.w;
size(_10c,_10e);
dim.h-=_10c.h;
if(pos=="top"){
dim.t+=_10c.h;
}else{
_10d.top=dim.t+dim.h+"px";
}
}else{
if(pos=="left"||pos=="right"){
_10e.h=dim.h;
size(_10c,_10e);
dim.w-=_10c.w;
if(pos=="left"){
dim.l+=_10c.w;
}else{
_10d.left=dim.l+dim.w+"px";
}
}else{
if(pos=="client"||pos=="center"){
size(_10c,dim);
}
}
}
});
};
return {marginBox2contentBox:_104.marginBox2contentBox,layoutChildren:_104.layoutChildren};
});
},"dijit/_DialogMixin":function(){
define("dijit/_DialogMixin",["dojo/_base/declare","./a11y"],function(_10f,a11y){
return _10f("dijit._DialogMixin",null,{execute:function(){
},onCancel:function(){
},onExecute:function(){
},_onSubmit:function(){
this.onExecute();
this.execute(this.get("value"));
},_getFocusItems:function(){
var _110=a11y._getTabNavigable(this.containerNode);
this._firstFocusItem=_110.lowest||_110.first||this.closeButtonNode||this.domNode;
this._lastFocusItem=_110.last||_110.highest||this._firstFocusItem;
}});
});
},"dijit/_MenuBase":function(){
define("dijit/_MenuBase",["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/lang","dojo/mouse","dojo/on","dojo/window","./a11yclick","./popup","./registry","./_Widget","./_KeyNavContainer","./_TemplatedMixin"],function(_111,_112,dom,_113,_114,lang,_115,on,_116,_117,pm,_118,_119,_11a,_11b){
return _112("dijit._MenuBase",[_119,_11b,_11a],{parentMenu:null,popupDelay:500,autoFocus:false,childSelector:function(node){
var _11c=_118.byNode(node);
return node.parentNode==this.containerNode&&_11c&&_11c.focus;
},postCreate:function(){
var self=this,_11d=typeof this.childSelector=="string"?this.childSelector:lang.hitch(this,"childSelector");
this.own(on(this.containerNode,on.selector(_11d,_115.enter),function(){
self.onItemHover(_118.byNode(this));
}),on(this.containerNode,on.selector(_11d,_115.leave),function(){
self.onItemUnhover(_118.byNode(this));
}),on(this.containerNode,on.selector(_11d,_117),function(evt){
self.onItemClick(_118.byNode(this),evt);
evt.stopPropagation();
evt.preventDefault();
}));
this.inherited(arguments);
},onExecute:function(){
},onCancel:function(){
},_moveToPopup:function(evt){
if(this.focusedChild&&this.focusedChild.popup&&!this.focusedChild.disabled){
this.onItemClick(this.focusedChild,evt);
}else{
var _11e=this._getTopMenu();
if(_11e&&_11e._isMenuBar){
_11e.focusNext();
}
}
},_onPopupHover:function(){
if(this.currentPopup&&this.currentPopup._pendingClose_timer){
var _11f=this.currentPopup.parentMenu;
if(_11f.focusedChild){
_11f.focusedChild._setSelected(false);
}
_11f.focusedChild=this.currentPopup.from_item;
_11f.focusedChild._setSelected(true);
this._stopPendingCloseTimer(this.currentPopup);
}
},onItemHover:function(item){
if(this.isActive){
this.focusChild(item);
if(this.focusedChild.popup&&!this.focusedChild.disabled&&!this.hover_timer){
this.hover_timer=this.defer("_openPopup",this.popupDelay);
}
}
if(this.focusedChild){
this.focusChild(item);
}
this._hoveredChild=item;
item._set("hovering",true);
},_onChildBlur:function(item){
this._stopPopupTimer();
item._setSelected(false);
var _120=item.popup;
if(_120){
this._stopPendingCloseTimer(_120);
_120._pendingClose_timer=this.defer(function(){
_120._pendingClose_timer=null;
if(_120.parentMenu){
_120.parentMenu.currentPopup=null;
}
pm.close(_120);
},this.popupDelay);
}
},onItemUnhover:function(item){
if(this.isActive){
this._stopPopupTimer();
}
if(this._hoveredChild==item){
this._hoveredChild=null;
}
item._set("hovering",false);
},_stopPopupTimer:function(){
if(this.hover_timer){
this.hover_timer=this.hover_timer.remove();
}
},_stopPendingCloseTimer:function(_121){
if(_121._pendingClose_timer){
_121._pendingClose_timer=_121._pendingClose_timer.remove();
}
},_stopFocusTimer:function(){
if(this._focus_timer){
this._focus_timer=this._focus_timer.remove();
}
},_getTopMenu:function(){
for(var top=this;top.parentMenu;top=top.parentMenu){
}
return top;
},onItemClick:function(item,evt){
if(typeof this.isShowingNow=="undefined"){
this._markActive();
}
this.focusChild(item);
if(item.disabled){
return false;
}
if(item.popup){
this._openPopup(evt.type=="keypress");
}else{
this.onExecute();
item._onClick?item._onClick(evt):item.onClick(evt);
}
},_openPopup:function(_122){
this._stopPopupTimer();
var _123=this.focusedChild;
if(!_123){
return;
}
var _124=_123.popup;
if(!_124.isShowingNow){
if(this.currentPopup){
this._stopPendingCloseTimer(this.currentPopup);
pm.close(this.currentPopup);
}
_124.parentMenu=this;
_124.from_item=_123;
var self=this;
pm.open({parent:this,popup:_124,around:_123.domNode,orient:this._orient||["after","before"],onCancel:function(){
self.focusChild(_123);
self._cleanUp();
_123._setSelected(true);
self.focusedChild=_123;
},onExecute:lang.hitch(this,"_cleanUp")});
this.currentPopup=_124;
_124.connect(_124.domNode,"onmouseenter",lang.hitch(self,"_onPopupHover"));
}
if(_122&&_124.focus){
_124._focus_timer=this.defer(lang.hitch(_124,function(){
this._focus_timer=null;
this.focus();
}));
}
},_markActive:function(){
this.isActive=true;
_114.replace(this.domNode,"dijitMenuActive","dijitMenuPassive");
},onOpen:function(){
this.isShowingNow=true;
this._markActive();
},_markInactive:function(){
this.isActive=false;
_114.replace(this.domNode,"dijitMenuPassive","dijitMenuActive");
},onClose:function(){
this._stopFocusTimer();
this._markInactive();
this.isShowingNow=false;
this.parentMenu=null;
},_closeChild:function(){
this._stopPopupTimer();
if(this.currentPopup){
if(_111.indexOf(this._focusManager.activeStack,this.id)>=0){
_113.set(this.focusedChild.focusNode,"tabIndex",this.tabIndex);
this.focusedChild.focusNode.focus();
}
pm.close(this.currentPopup);
this.currentPopup=null;
}
if(this.focusedChild){
this.focusedChild._setSelected(false);
this.onItemUnhover(this.focusedChild);
this.focusedChild=null;
}
},_onItemFocus:function(item){
if(this._hoveredChild&&this._hoveredChild!=item){
this.onItemUnhover(this._hoveredChild);
}
},_onBlur:function(){
this._cleanUp();
this.inherited(arguments);
},_cleanUp:function(){
this._closeChild();
if(typeof this.isShowingNow=="undefined"){
this._markInactive();
}
}});
});
},"url:dijit/form/templates/TextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\" id=\"widget_${id}\" role=\"presentation\"\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n","dojo/dnd/common":function(){
define("dojo/dnd/common",["../_base/connect","../_base/kernel","../_base/lang","../dom"],function(_125,_126,lang,dom){
var _127=lang.getObject("dojo.dnd",true);
_127.getCopyKeyState=_125.isCopyKey;
_127._uniqueId=0;
_127.getUniqueId=function(){
var id;
do{
id=_126._scopeName+"Unique"+(++_127._uniqueId);
}while(dom.byId(id));
return id;
};
_127._empty={};
_127.isFormElement=function(e){
var t=e.target;
if(t.nodeType==3){
t=t.parentNode;
}
return " button textarea input select option ".indexOf(" "+t.tagName.toLowerCase()+" ")>=0;
};
return _127;
});
},"dojox/main":function(){
define("dojox/main",["dojo/_base/kernel"],function(dojo){
return dojo.dojox;
});
},"dojox/form/PasswordValidator":function(){
require({cache:{"url:dojox/form/resources/PasswordValidator.html":"<div dojoAttachPoint=\"containerNode\">\n\t<input type=\"hidden\" name=\"${name}\" value=\"\" dojoAttachPoint=\"focusNode\" />\n</div>"}});
define("dojox/form/PasswordValidator",["dojo/_base/array","dojo/_base/lang","dojo/dom-attr","dojo/i18n","dojo/query","dojo/keys","dijit/form/_FormValueWidget","dijit/form/ValidationTextBox","dojo/text!./resources/PasswordValidator.html","dojo/i18n!./nls/PasswordValidator","dojo/_base/declare"],function(_128,lang,_129,i18n,_12a,keys,_12b,_12c,_12d,_12e,_12f){
var _130=_12f("dojox.form._ChildTextBox",_12c,{containerWidget:null,type:"password",reset:function(){
_12c.prototype._setValueAttr.call(this,"",true);
this._hasBeenBlurred=false;
},postCreate:function(){
this.inherited(arguments);
if(!this.name){
_129.remove(this.focusNode,"name");
}
this.connect(this.focusNode,"onkeypress","_onChildKeyPress");
},_onChildKeyPress:function(e){
if(e&&e.keyCode==keys.ENTER){
this._setBlurValue();
}
}});
var _131=_12f("dojox.form._OldPWBox",_130,{_isPWValid:false,_setValueAttr:function(_132,_133){
if(_132===""){
_132=_131.superclass.attr.call(this,"value");
}
if(_133!==null){
this._isPWValid=this.containerWidget.pwCheck(_132);
}
this.inherited(arguments);
this.containerWidget._childValueAttr(this.containerWidget._inputWidgets[1].get("value"));
},isValid:function(_134){
return this.inherited("isValid",arguments)&&this._isPWValid;
},_update:function(e){
if(this._hasBeenBlurred){
this.validate(true);
}
this._onMouse(e);
},_getValueAttr:function(){
if(this.containerWidget._started&&this.containerWidget.isValid()){
return this.inherited(arguments);
}
return "";
},_setBlurValue:function(){
var _135=_12c.prototype._getValueAttr.call(this);
this._setValueAttr(_135,(this.isValid?this.isValid():true));
}});
var _136=_12f("dojox.form._NewPWBox",_130,{required:true,onChange:function(){
this.containerWidget._inputWidgets[2].validate(false);
this.inherited(arguments);
}});
var _137=_12f("dojox.form._VerifyPWBox",_130,{isValid:function(_138){
return this.inherited("isValid",arguments)&&(this.get("value")==this.containerWidget._inputWidgets[1].get("value"));
}});
return _12f("dojox.form.PasswordValidator",_12b,{required:true,_inputWidgets:null,oldName:"",templateString:_12d,_hasBeenBlurred:false,isValid:function(_139){
return _128.every(this._inputWidgets,function(i){
if(i&&i._setStateClass){
i._setStateClass();
}
return (!i||i.isValid());
});
},validate:function(_13a){
return _128.every(_128.map(this._inputWidgets,function(i){
if(i&&i.validate){
i._hasBeenBlurred=(i._hasBeenBlurred||this._hasBeenBlurred);
return i.validate();
}
return true;
},this),function(item){
return item;
});
},reset:function(){
this._hasBeenBlurred=false;
_128.forEach(this._inputWidgets,function(i){
if(i&&i.reset){
i.reset();
}
},this);
},_createSubWidgets:function(){
var _13b=this._inputWidgets,msg=i18n.getLocalization("dojox.form","PasswordValidator",this.lang);
_128.forEach(_13b,function(i,idx){
if(i){
var p={containerWidget:this},c;
if(idx===0){
p.name=this.oldName;
p.invalidMessage=msg.badPasswordMessage;
c=_131;
}else{
if(idx===1){
p.required=this.required;
c=_136;
}else{
if(idx===2){
p.invalidMessage=msg.nomatchMessage;
c=_137;
}
}
}
_13b[idx]=new c(p,i);
}
},this);
},pwCheck:function(_13c){
return false;
},postCreate:function(){
this.inherited(arguments);
var _13d=this._inputWidgets=[];
_128.forEach(["old","new","verify"],function(i){
_13d.push(_12a("input[pwType="+i+"]",this.containerNode)[0]);
},this);
if(!_13d[1]||!_13d[2]){
throw new Error("Need at least pwType=\"new\" and pwType=\"verify\"");
}
if(this.oldName&&!_13d[0]){
throw new Error("Need to specify pwType=\"old\" if using oldName");
}
this.containerNode=this.domNode;
this._createSubWidgets();
this.connect(this._inputWidgets[1],"_setValueAttr","_childValueAttr");
this.connect(this._inputWidgets[2],"_setValueAttr","_childValueAttr");
},_childValueAttr:function(v){
this.set("value",this.isValid()?v:"");
},_setDisabledAttr:function(_13e){
this.inherited(arguments);
_128.forEach(this._inputWidgets,function(i){
if(i&&i.set){
i.set("disabled",_13e);
}
});
},_setRequiredAttribute:function(_13f){
this.required=_13f;
_129.set(this.focusNode,"required",_13f);
this.focusNode.setAttribute("aria-required",_13f);
this._refreshState();
_128.forEach(this._inputWidgets,function(i){
if(i&&i.set){
i.set("required",_13f);
}
});
},_setValueAttr:function(v){
this.inherited(arguments);
_129.set(this.focusNode,"value",v);
},_getValueAttr:function(){
return this.value||"";
},focus:function(){
var f=false;
_128.forEach(this._inputWidgets,function(i){
if(i&&!i.isValid()&&!f){
i.focus();
f=true;
}
});
if(!f){
this._inputWidgets[1].focus();
}
}});
});
},"dojo/dnd/TimedMoveable":function(){
define("dojo/dnd/TimedMoveable",["../_base/declare","./Moveable"],function(_140,_141){
var _142=_141.prototype.onMove;
return _140("dojo.dnd.TimedMoveable",_141,{timeout:40,constructor:function(node,_143){
if(!_143){
_143={};
}
if(_143.timeout&&typeof _143.timeout=="number"&&_143.timeout>=0){
this.timeout=_143.timeout;
}
},onMoveStop:function(_144){
if(_144._timer){
clearTimeout(_144._timer);
_142.call(this,_144,_144._leftTop);
}
_141.prototype.onMoveStop.apply(this,arguments);
},onMove:function(_145,_146){
_145._leftTop=_146;
if(!_145._timer){
var _147=this;
_145._timer=setTimeout(function(){
_145._timer=null;
_142.call(_147,_145,_145._leftTop);
},this.timeout);
}
}});
});
},"url:dijit/form/templates/Button.html":"<span class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><span class=\"dijitReset dijitInline dijitButtonNode\"\n\t\tdata-dojo-attach-event=\"ondijitclick:_onClick\" role=\"presentation\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode,focusNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span class=\"dijitReset dijitToggleButtonIconChar\">&#x25CF;</span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t></span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\"\n\t\ttabIndex=\"-1\" role=\"presentation\" data-dojo-attach-point=\"valueNode\"\n/></span>\n","dijit/DialogUnderlay":function(){
define("dijit/DialogUnderlay",["dojo/_base/declare","dojo/dom-attr","dojo/window","./_Widget","./_TemplatedMixin","./BackgroundIframe"],function(_148,_149,_14a,_14b,_14c,_14d){
return _148("dijit.DialogUnderlay",[_14b,_14c],{templateString:"<div class='dijitDialogUnderlayWrapper'><div class='dijitDialogUnderlay' data-dojo-attach-point='node'></div></div>",dialogId:"","class":"",_setDialogIdAttr:function(id){
_149.set(this.node,"id",id+"_underlay");
this._set("dialogId",id);
},_setClassAttr:function(_14e){
this.node.className="dijitDialogUnderlay "+_14e;
this._set("class",_14e);
},postCreate:function(){
this.ownerDocumentBody.appendChild(this.domNode);
},layout:function(){
var is=this.node.style,os=this.domNode.style;
os.display="none";
var _14f=_14a.getBox(this.ownerDocument);
os.top=_14f.t+"px";
os.left=_14f.l+"px";
is.width=_14f.w+"px";
is.height=_14f.h+"px";
os.display="block";
},show:function(){
this.domNode.style.display="block";
this.layout();
this.bgIframe=new _14d(this.domNode);
},hide:function(){
this.bgIframe.destroy();
delete this.bgIframe;
this.domNode.style.display="none";
}});
});
},"dojo/dnd/Moveable":function(){
define("dojo/dnd/Moveable",["../_base/array","../_base/declare","../_base/event","../_base/lang","../dom","../dom-class","../Evented","../on","../topic","../touch","./common","./Mover","../_base/window"],function(_150,_151,_152,lang,dom,_153,_154,on,_155,_156,dnd,_157,win){
var _158=_151("dojo.dnd.Moveable",[_154],{handle:"",delay:0,skip:false,constructor:function(node,_159){
this.node=dom.byId(node);
if(!_159){
_159={};
}
this.handle=_159.handle?dom.byId(_159.handle):null;
if(!this.handle){
this.handle=this.node;
}
this.delay=_159.delay>0?_159.delay:0;
this.skip=_159.skip;
this.mover=_159.mover?_159.mover:_157;
this.events=[on(this.handle,_156.press,lang.hitch(this,"onMouseDown")),on(this.handle,"dragstart",lang.hitch(this,"onSelectStart")),on(this.handle,"selectstart",lang.hitch(this,"onSelectStart"))];
},markupFactory:function(_15a,node,Ctor){
return new Ctor(node,_15a);
},destroy:function(){
_150.forEach(this.events,function(_15b){
_15b.remove();
});
this.events=this.node=this.handle=null;
},onMouseDown:function(e){
if(this.skip&&dnd.isFormElement(e)){
return;
}
if(this.delay){
this.events.push(on(this.handle,_156.move,lang.hitch(this,"onMouseMove")),on(this.handle,_156.release,lang.hitch(this,"onMouseUp")));
this._lastX=e.pageX;
this._lastY=e.pageY;
}else{
this.onDragDetected(e);
}
_152.stop(e);
},onMouseMove:function(e){
if(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay){
this.onMouseUp(e);
this.onDragDetected(e);
}
_152.stop(e);
},onMouseUp:function(e){
for(var i=0;i<2;++i){
this.events.pop().remove();
}
_152.stop(e);
},onSelectStart:function(e){
if(!this.skip||!dnd.isFormElement(e)){
_152.stop(e);
}
},onDragDetected:function(e){
new this.mover(this.node,e,this);
},onMoveStart:function(_15c){
_155.publish("/dnd/move/start",_15c);
_153.add(win.body(),"dojoMove");
_153.add(this.node,"dojoMoveItem");
},onMoveStop:function(_15d){
_155.publish("/dnd/move/stop",_15d);
_153.remove(win.body(),"dojoMove");
_153.remove(this.node,"dojoMoveItem");
},onFirstMove:function(){
},onMove:function(_15e,_15f){
this.onMoving(_15e,_15f);
var s=_15e.node.style;
s.left=_15f.l+"px";
s.top=_15f.t+"px";
this.onMoved(_15e,_15f);
},onMoving:function(){
},onMoved:function(){
}});
return _158;
});
},"url:dijit/templates/Menu.html":"<table class=\"dijit dijitMenu dijitMenuPassive dijitReset dijitMenuTable\" role=\"menu\" tabIndex=\"${tabIndex}\"\n\t   data-dojo-attach-event=\"onkeypress:_onKeyPress\" cellspacing=\"0\">\n\t<tbody class=\"dijitReset\" data-dojo-attach-point=\"containerNode\"></tbody>\n</table>\n","dijit/layout/_ContentPaneResizeMixin":function(){
define("dijit/layout/_ContentPaneResizeMixin",["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/query","dojo/sniff","../registry","../Viewport","./utils"],function(_160,_161,_162,_163,_164,lang,_165,has,_166,_167,_168){
return _161("dijit.layout._ContentPaneResizeMixin",null,{doLayout:true,isLayoutContainer:true,startup:function(){
if(this._started){
return;
}
var _169=this.getParent();
this._childOfLayoutWidget=_169&&_169.isLayoutContainer;
this._needLayout=!this._childOfLayoutWidget;
this.inherited(arguments);
if(this._isShown()){
this._onShow();
}
if(!this._childOfLayoutWidget){
this.own(_167.on("resize",lang.hitch(this,"resize")));
}
},_checkIfSingleChild:function(){
var _16a=[],_16b=false;
_165("> *",this.containerNode).some(function(node){
var _16c=_166.byNode(node);
if(_16c&&_16c.resize){
_16a.push(_16c);
}else{
if(node.offsetHeight){
_16b=true;
}
}
});
this._singleChild=_16a.length==1&&!_16b?_16a[0]:null;
_162.toggle(this.containerNode,this.baseClass+"SingleChild",!!this._singleChild);
},resize:function(_16d,_16e){
this._resizeCalled=true;
this._scheduleLayout(_16d,_16e);
},_scheduleLayout:function(_16f,_170){
if(this._isShown()){
this._layout(_16f,_170);
}else{
this._needLayout=true;
this._changeSize=_16f;
this._resultSize=_170;
}
},_layout:function(_171,_172){
delete this._needLayout;
if(!this._wasShown&&this.open!==false){
this._onShow();
}
if(_171){
_163.setMarginBox(this.domNode,_171);
}
var cn=this.containerNode;
if(cn===this.domNode){
var mb=_172||{};
lang.mixin(mb,_171||{});
if(!("h" in mb)||!("w" in mb)){
mb=lang.mixin(_163.getMarginBox(cn),mb);
}
this._contentBox=_168.marginBox2contentBox(cn,mb);
}else{
this._contentBox=_163.getContentBox(cn);
}
this._layoutChildren();
},_layoutChildren:function(){
if(this.doLayout){
this._checkIfSingleChild();
}
if(this._singleChild&&this._singleChild.resize){
var cb=this._contentBox||_163.getContentBox(this.containerNode);
this._singleChild.resize({w:cb.w,h:cb.h});
}else{
_160.forEach(this.getChildren(),function(_173){
if(_173.resize){
_173.resize();
}
});
}
},_isShown:function(){
if(this._childOfLayoutWidget){
if(this._resizeCalled&&"open" in this){
return this.open;
}
return this._resizeCalled;
}else{
if("open" in this){
return this.open;
}else{
var node=this.domNode,_174=this.domNode.parentNode;
return (node.style.display!="none")&&(node.style.visibility!="hidden")&&!_162.contains(node,"dijitHidden")&&_174&&_174.style&&(_174.style.display!="none");
}
}
},_onShow:function(){
this._wasShown=true;
if(this._needLayout){
this._layout(this._changeSize,this._resultSize);
}
this.inherited(arguments);
}});
});
},"davinci/repositoryinfo":function(){
define({revision:"f1554971890cef6693dcc67abd889d64370fcabd",buildtime:"2013-05-02T08:12:13Z"});
},"dijit/form/_ButtonMixin":function(){
define("dijit/form/_ButtonMixin",["dojo/_base/declare","dojo/dom","dojo/_base/event","../registry"],function(_175,dom,_176,_177){
return _175("dijit.form._ButtonMixin",null,{label:"",type:"button",_onClick:function(e){
if(this.disabled){
_176.stop(e);
return false;
}
var _178=this.onClick(e)===false;
if(!_178&&this.type=="submit"&&!(this.valueNode||this.focusNode).form){
for(var node=this.domNode;node.parentNode;node=node.parentNode){
var _179=_177.byNode(node);
if(_179&&typeof _179._onSubmit=="function"){
_179._onSubmit(e);
_178=true;
break;
}
}
}
if(_178){
e.preventDefault();
}
return !_178;
},postCreate:function(){
this.inherited(arguments);
dom.setSelectable(this.focusNode,false);
},onClick:function(){
return true;
},_setLabelAttr:function(_17a){
this._set("label",_17a);
(this.containerNode||this.focusNode).innerHTML=_17a;
}});
});
},"url:dijit/templates/MenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon dijitMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">\n\t\t<div data-dojo-attach-point=\"arrowWrapper\" style=\"visibility: hidden\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuExpand\"/>\n\t\t\t<span class=\"dijitMenuExpandA11y\">+</span>\n\t\t</div>\n\t</td>\n</tr>\n","dijit/form/ValidationTextBox":function(){
require({cache:{"url:dijit/form/templates/ValidationTextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\" role=\"presentation\"\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n"}});
define("dijit/form/ValidationTextBox",["dojo/_base/declare","dojo/_base/kernel","dojo/i18n","./TextBox","../Tooltip","dojo/text!./templates/ValidationTextBox.html","dojo/i18n!./nls/validate"],function(_17b,_17c,i18n,_17d,_17e,_17f){
var _180;
return _180=_17b("dijit.form.ValidationTextBox",_17d,{templateString:_17f,required:false,promptMessage:"",invalidMessage:"$_unset_$",missingMessage:"$_unset_$",message:"",constraints:{},pattern:".*",regExp:"",regExpGen:function(){
},state:"",tooltipPosition:[],_deprecateRegExp:function(attr,_181){
if(_181!=_180.prototype[attr]){
_17c.deprecated("ValidationTextBox id="+this.id+", set('"+attr+"', ...) is deprecated.  Use set('pattern', ...) instead.","","2.0");
this.set("pattern",_181);
}
},_setRegExpGenAttr:function(_182){
this._deprecateRegExp("regExpGen",_182);
this.regExpGen=this._getPatternAttr;
},_setRegExpAttr:function(_183){
this._deprecateRegExp("regExp",_183);
},_setValueAttr:function(){
this.inherited(arguments);
this.validate(this.focused);
},validator:function(_184,_185){
return (new RegExp("^(?:"+this._getPatternAttr(_185)+")"+(this.required?"":"?")+"$")).test(_184)&&(!this.required||!this._isEmpty(_184))&&(this._isEmpty(_184)||this.parse(_184,_185)!==undefined);
},_isValidSubset:function(){
return this.textbox.value.search(this._partialre)==0;
},isValid:function(){
return this.validator(this.textbox.value,this.constraints);
},_isEmpty:function(_186){
return (this.trim?/^\s*$/:/^$/).test(_186);
},getErrorMessage:function(){
var _187=this.invalidMessage=="$_unset_$"?this.messages.invalidMessage:!this.invalidMessage?this.promptMessage:this.invalidMessage;
var _188=this.missingMessage=="$_unset_$"?this.messages.missingMessage:!this.missingMessage?_187:this.missingMessage;
return (this.required&&this._isEmpty(this.textbox.value))?_188:_187;
},getPromptMessage:function(){
return this.promptMessage;
},_maskValidSubsetError:true,validate:function(_189){
var _18a="";
var _18b=this.disabled||this.isValid(_189);
if(_18b){
this._maskValidSubsetError=true;
}
var _18c=this._isEmpty(this.textbox.value);
var _18d=!_18b&&_189&&this._isValidSubset();
this._set("state",_18b?"":(((((!this._hasBeenBlurred||_189)&&_18c)||_18d)&&(this._maskValidSubsetError||(_18d&&!this._hasBeenBlurred&&_189)))?"Incomplete":"Error"));
this.focusNode.setAttribute("aria-invalid",_18b?"false":"true");
if(this.state=="Error"){
this._maskValidSubsetError=_189&&_18d;
_18a=this.getErrorMessage(_189);
}else{
if(this.state=="Incomplete"){
_18a=this.getPromptMessage(_189);
this._maskValidSubsetError=!this._hasBeenBlurred||_189;
}else{
if(_18c){
_18a=this.getPromptMessage(_189);
}
}
}
this.set("message",_18a);
return _18b;
},displayMessage:function(_18e){
if(_18e&&this.focused){
_17e.show(_18e,this.domNode,this.tooltipPosition,!this.isLeftToRight());
}else{
_17e.hide(this.domNode);
}
},_refreshState:function(){
if(this._created){
this.validate(this.focused);
}
this.inherited(arguments);
},constructor:function(_18f){
this.constraints={};
this.baseClass+=" dijitValidationTextBox";
},startup:function(){
this.inherited(arguments);
this._refreshState();
},_setConstraintsAttr:function(_190){
if(!_190.locale&&this.lang){
_190.locale=this.lang;
}
this._set("constraints",_190);
this._refreshState();
},_setPatternAttr:function(_191){
this._set("pattern",_191);
},_getPatternAttr:function(_192){
var p=this.pattern;
var type=(typeof p).toLowerCase();
if(type=="function"){
p=this.pattern(_192||this.constraints);
}
if(p!=this._lastRegExp){
var _193="";
this._lastRegExp=p;
if(p!=".*"){
p.replace(/\\.|\[\]|\[.*?[^\\]{1}\]|\{.*?\}|\(\?[=:!]|./g,function(re){
switch(re.charAt(0)){
case "{":
case "+":
case "?":
case "*":
case "^":
case "$":
case "|":
case "(":
_193+=re;
break;
case ")":
_193+="|$)";
break;
default:
_193+="(?:"+re+"|$)";
break;
}
});
}
try{
"".search(_193);
}
catch(e){
_193=this.pattern;
console.warn("RegExp error in "+this.declaredClass+": "+this.pattern);
}
this._partialre="^(?:"+_193+")$";
}
return p;
},postMixInProperties:function(){
this.inherited(arguments);
this.messages=i18n.getLocalization("dijit.form","validate",this.lang);
this._setConstraintsAttr(this.constraints);
},_setDisabledAttr:function(_194){
this.inherited(arguments);
this._refreshState();
},_setRequiredAttr:function(_195){
this._set("required",_195);
this.focusNode.setAttribute("aria-required",_195);
this._refreshState();
},_setMessageAttr:function(_196){
this._set("message",_196);
this.displayMessage(_196);
},reset:function(){
this._maskValidSubsetError=true;
this.inherited(arguments);
},_onBlur:function(){
this.displayMessage("");
this.inherited(arguments);
}});
});
},"dojo/html":function(){
define("dojo/html",["./_base/kernel","./_base/lang","./_base/array","./_base/declare","./dom","./dom-construct","./parser"],function(_197,lang,_198,_199,dom,_19a,_19b){
var html={};
lang.setObject("dojo.html",html);
var _19c=0;
html._secureForInnerHtml=function(cont){
return cont.replace(/(?:\s*<!DOCTYPE\s[^>]+>|<title[^>]*>[\s\S]*?<\/title>)/ig,"");
};
html._emptyNode=_19a.empty;
html._setNodeContent=function(node,cont){
_19a.empty(node);
if(cont){
if(typeof cont=="string"){
cont=_19a.toDom(cont,node.ownerDocument);
}
if(!cont.nodeType&&lang.isArrayLike(cont)){
for(var _19d=cont.length,i=0;i<cont.length;i=_19d==cont.length?i+1:0){
_19a.place(cont[i],node,"last");
}
}else{
_19a.place(cont,node,"last");
}
}
return node;
};
html._ContentSetter=_199("dojo.html._ContentSetter",null,{node:"",content:"",id:"",cleanContent:false,extractContent:false,parseContent:false,parserScope:_197._scopeName,startup:true,constructor:function(_19e,node){
lang.mixin(this,_19e||{});
node=this.node=dom.byId(this.node||node);
if(!this.id){
this.id=["Setter",(node)?node.id||node.tagName:"",_19c++].join("_");
}
},set:function(cont,_19f){
if(undefined!==cont){
this.content=cont;
}
if(_19f){
this._mixin(_19f);
}
this.onBegin();
this.setContent();
var ret=this.onEnd();
if(ret&&ret.then){
return ret;
}else{
return this.node;
}
},setContent:function(){
var node=this.node;
if(!node){
throw new Error(this.declaredClass+": setContent given no node");
}
try{
node=html._setNodeContent(node,this.content);
}
catch(e){
var _1a0=this.onContentError(e);
try{
node.innerHTML=_1a0;
}
catch(e){
console.error("Fatal "+this.declaredClass+".setContent could not change content due to "+e.message,e);
}
}
this.node=node;
},empty:function(){
if(this.parseDeferred){
if(!this.parseDeferred.isResolved()){
this.parseDeferred.cancel();
}
delete this.parseDeferred;
}
if(this.parseResults&&this.parseResults.length){
_198.forEach(this.parseResults,function(w){
if(w.destroy){
w.destroy();
}
});
delete this.parseResults;
}
_19a.empty(this.node);
},onBegin:function(){
var cont=this.content;
if(lang.isString(cont)){
if(this.cleanContent){
cont=html._secureForInnerHtml(cont);
}
if(this.extractContent){
var _1a1=cont.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
if(_1a1){
cont=_1a1[1];
}
}
}
this.empty();
this.content=cont;
return this.node;
},onEnd:function(){
if(this.parseContent){
this._parse();
}
return this.node;
},tearDown:function(){
delete this.parseResults;
delete this.parseDeferred;
delete this.node;
delete this.content;
},onContentError:function(err){
return "Error occurred setting content: "+err;
},onExecError:function(err){
return "Error occurred executing scripts: "+err;
},_mixin:function(_1a2){
var _1a3={},key;
for(key in _1a2){
if(key in _1a3){
continue;
}
this[key]=_1a2[key];
}
},_parse:function(){
var _1a4=this.node;
try{
var _1a5={};
_198.forEach(["dir","lang","textDir"],function(name){
if(this[name]){
_1a5[name]=this[name];
}
},this);
var self=this;
this.parseDeferred=_19b.parse({rootNode:_1a4,noStart:!this.startup,inherited:_1a5,scope:this.parserScope}).then(function(_1a6){
return self.parseResults=_1a6;
});
}
catch(e){
this._onError("Content",e,"Error parsing in _ContentSetter#"+this.id);
}
},_onError:function(type,err,_1a7){
var _1a8=this["on"+type+"Error"].call(this,err);
if(_1a7){
console.error(_1a7,err);
}else{
if(_1a8){
html._setNodeContent(this.node,_1a8,true);
}
}
}});
html.set=function(node,cont,_1a9){
if(undefined==cont){
console.warn("dojo.html.set: no cont argument provided, using empty string");
cont="";
}
if(!_1a9){
return html._setNodeContent(node,cont,true);
}else{
var op=new html._ContentSetter(lang.mixin(_1a9,{content:cont,node:node}));
return op.set();
}
};
return html;
});
},"dijit/_KeyNavContainer":function(){
define("dijit/_KeyNavContainer",["dojo/_base/kernel","./_Container","./_FocusMixin","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/_base/event","dojo/dom-attr","dojo/_base/lang"],function(_1aa,_1ab,_1ac,_1ad,keys,_1ae,_1af,_1b0,lang){
return _1ae("dijit._KeyNavContainer",[_1ac,_1ab],{tabIndex:"0",connectKeyNavHandlers:function(_1b1,_1b2){
var _1b3=(this._keyNavCodes={});
var prev=lang.hitch(this,"focusPrev");
var next=lang.hitch(this,"focusNext");
_1ad.forEach(_1b1,function(code){
_1b3[code]=prev;
});
_1ad.forEach(_1b2,function(code){
_1b3[code]=next;
});
_1b3[keys.HOME]=lang.hitch(this,"focusFirstChild");
_1b3[keys.END]=lang.hitch(this,"focusLastChild");
this.connect(this.domNode,"onkeypress","_onContainerKeypress");
this.connect(this.domNode,"onfocus","_onContainerFocus");
},startupKeyNavChildren:function(){
_1aa.deprecated("startupKeyNavChildren() call no longer needed","","2.0");
},startup:function(){
this.inherited(arguments);
_1ad.forEach(this.getChildren(),lang.hitch(this,"_startupChild"));
},addChild:function(_1b4,_1b5){
this.inherited(arguments);
this._startupChild(_1b4);
},focus:function(){
this.focusFirstChild();
},focusFirstChild:function(){
this.focusChild(this._getFirstFocusableChild());
},focusLastChild:function(){
this.focusChild(this._getLastFocusableChild());
},focusNext:function(){
this.focusChild(this._getNextFocusableChild(this.focusedChild,1));
},focusPrev:function(){
this.focusChild(this._getNextFocusableChild(this.focusedChild,-1),true);
},focusChild:function(_1b6,last){
if(!_1b6){
return;
}
if(this.focusedChild&&_1b6!==this.focusedChild){
this._onChildBlur(this.focusedChild);
}
_1b6.set("tabIndex",this.tabIndex);
_1b6.focus(last?"end":"start");
this._set("focusedChild",_1b6);
},_startupChild:function(_1b7){
_1b7.set("tabIndex","-1");
this.connect(_1b7,"_onFocus",function(){
_1b7.set("tabIndex",this.tabIndex);
});
this.connect(_1b7,"_onBlur",function(){
_1b7.set("tabIndex","-1");
});
},_onContainerFocus:function(evt){
if(evt.target!==this.domNode||this.focusedChild){
return;
}
this.focusFirstChild();
_1b0.set(this.domNode,"tabIndex","-1");
},_onBlur:function(evt){
if(this.tabIndex){
_1b0.set(this.domNode,"tabIndex",this.tabIndex);
}
this.focusedChild=null;
this.inherited(arguments);
},_onContainerKeypress:function(evt){
if(evt.ctrlKey||evt.altKey){
return;
}
var func=this._keyNavCodes[evt.charOrCode];
if(func){
func();
_1af.stop(evt);
}
},_onChildBlur:function(){
},_getFirstFocusableChild:function(){
return this._getNextFocusableChild(null,1);
},_getLastFocusableChild:function(){
return this._getNextFocusableChild(null,-1);
},_getNextFocusableChild:function(_1b8,dir){
if(_1b8){
_1b8=this._getSiblingOfChild(_1b8,dir);
}
var _1b9=this.getChildren();
for(var i=0;i<_1b9.length;i++){
if(!_1b8){
_1b8=_1b9[(dir>0)?0:(_1b9.length-1)];
}
if(_1b8.isFocusable()){
return _1b8;
}
_1b8=this._getSiblingOfChild(_1b8,dir);
}
return null;
}});
});
},"dojo/dnd/Mover":function(){
define("dojo/dnd/Mover",["../_base/array","../_base/declare","../_base/event","../_base/lang","../sniff","../_base/window","../dom","../dom-geometry","../dom-style","../Evented","../on","../touch","./common","./autoscroll"],function(_1ba,_1bb,_1bc,lang,has,win,dom,_1bd,_1be,_1bf,on,_1c0,dnd,_1c1){
return _1bb("dojo.dnd.Mover",[_1bf],{constructor:function(node,e,host){
this.node=dom.byId(node);
this.marginBox={l:e.pageX,t:e.pageY};
this.mouseButton=e.button;
var h=(this.host=host),d=node.ownerDocument;
this.events=[on(d,_1c0.move,lang.hitch(this,"onFirstMove")),on(d,_1c0.move,lang.hitch(this,"onMouseMove")),on(d,_1c0.release,lang.hitch(this,"onMouseUp")),on(d,"dragstart",_1bc.stop),on(d.body,"selectstart",_1bc.stop)];
_1c1.autoScrollStart(d);
if(h&&h.onMoveStart){
h.onMoveStart(this);
}
},onMouseMove:function(e){
_1c1.autoScroll(e);
var m=this.marginBox;
this.host.onMove(this,{l:m.l+e.pageX,t:m.t+e.pageY},e);
_1bc.stop(e);
},onMouseUp:function(e){
if(has("webkit")&&has("mac")&&this.mouseButton==2?e.button==0:this.mouseButton==e.button){
this.destroy();
}
_1bc.stop(e);
},onFirstMove:function(e){
var s=this.node.style,l,t,h=this.host;
switch(s.position){
case "relative":
case "absolute":
l=Math.round(parseFloat(s.left))||0;
t=Math.round(parseFloat(s.top))||0;
break;
default:
s.position="absolute";
var m=_1bd.getMarginBox(this.node);
var b=win.doc.body;
var bs=_1be.getComputedStyle(b);
var bm=_1bd.getMarginBox(b,bs);
var bc=_1bd.getContentBox(b,bs);
l=m.l-(bc.l-bm.l);
t=m.t-(bc.t-bm.t);
break;
}
this.marginBox.l=l-this.marginBox.l;
this.marginBox.t=t-this.marginBox.t;
if(h&&h.onFirstMove){
h.onFirstMove(this,e);
}
this.events.shift().remove();
},destroy:function(){
_1ba.forEach(this.events,function(_1c2){
_1c2.remove();
});
var h=this.host;
if(h&&h.onMoveStop){
h.onMoveStop(this);
}
this.events=this.node=this.host=null;
}});
});
},"dijit/Tooltip":function(){
require({cache:{"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n></div>\n"}});
define("dijit/Tooltip",["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","./main"],function(_1c3,_1c4,fx,dom,_1c5,_1c6,_1c7,lang,_1c8,on,has,_1c9,_1ca,_1cb,_1cc,_1cd,_1ce,_1cf){
var _1d0=_1c4("dijit._MasterTooltip",[_1cb,_1cc],{duration:_1c9.defaultDuration,templateString:_1ce,postCreate:function(){
this.ownerDocumentBody.appendChild(this.domNode);
this.bgIframe=new _1cd(this.domNode);
this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});
this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});
},show:function(_1d1,_1d2,_1d3,rtl,_1d4){
if(this.aroundNode&&this.aroundNode===_1d2&&this.containerNode.innerHTML==_1d1){
return;
}
if(this.fadeOut.status()=="playing"){
this._onDeck=arguments;
return;
}
this.containerNode.innerHTML=_1d1;
if(_1d4){
this.set("textDir",_1d4);
}
this.containerNode.align=rtl?"right":"left";
var pos=_1ca.around(this.domNode,_1d2,_1d3&&_1d3.length?_1d3:_1d5.defaultPosition,!rtl,lang.hitch(this,"orient"));
var _1d6=pos.aroundNodePos;
if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){
this.connectorNode.style.top=_1d6.y+((_1d6.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";
this.connectorNode.style.left="";
}else{
if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){
this.connectorNode.style.left=_1d6.x+((_1d6.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";
}else{
this.connectorNode.style.left="";
this.connectorNode.style.top="";
}
}
_1c7.set(this.domNode,"opacity",0);
this.fadeIn.play();
this.isShowingNow=true;
this.aroundNode=_1d2;
},orient:function(node,_1d7,_1d8,_1d9,_1da){
this.connectorNode.style.top="";
var _1db=_1d9.h,_1dc=_1d9.w;
node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_1d7+"-"+_1d8];
this.domNode.style.width="auto";
var size=_1c6.position(this.domNode);
if(has("ie")==9){
size.w+=2;
}
var _1dd=Math.min((Math.max(_1dc,1)),size.w);
_1c6.setMarginBox(this.domNode,{w:_1dd});
if(_1d8.charAt(0)=="B"&&_1d7.charAt(0)=="B"){
var bb=_1c6.position(node);
var _1de=this.connectorNode.offsetHeight;
if(bb.h>_1db){
var _1df=_1db-((_1da.h+_1de)>>1);
this.connectorNode.style.top=_1df+"px";
this.connectorNode.style.bottom="";
}else{
this.connectorNode.style.bottom=Math.min(Math.max(_1da.h/2-_1de/2,0),bb.h-_1de)+"px";
this.connectorNode.style.top="";
}
}else{
this.connectorNode.style.top="";
this.connectorNode.style.bottom="";
}
return Math.max(0,size.w-_1dc);
},_onShow:function(){
if(has("ie")){
this.domNode.style.filter="";
}
},hide:function(_1e0){
if(this._onDeck&&this._onDeck[1]==_1e0){
this._onDeck=null;
}else{
if(this.aroundNode===_1e0){
this.fadeIn.stop();
this.isShowingNow=false;
this.aroundNode=null;
this.fadeOut.play();
}else{
}
}
},_onHide:function(){
this.domNode.style.cssText="";
this.containerNode.innerHTML="";
if(this._onDeck){
this.show.apply(this,this._onDeck);
this._onDeck=null;
}
},_setAutoTextDir:function(node){
this.applyTextDir(node,has("ie")?node.outerText:node.textContent);
_1c3.forEach(node.children,function(_1e1){
this._setAutoTextDir(_1e1);
},this);
},_setTextDirAttr:function(_1e2){
this._set("textDir",_1e2);
if(_1e2=="auto"){
this._setAutoTextDir(this.containerNode);
}else{
this.containerNode.dir=this.textDir;
}
}});
_1cf.showTooltip=function(_1e3,_1e4,_1e5,rtl,_1e6){
if(_1e5){
_1e5=_1c3.map(_1e5,function(val){
return {after:"after-centered",before:"before-centered"}[val]||val;
});
}
if(!_1d5._masterTT){
_1cf._masterTT=_1d5._masterTT=new _1d0();
}
return _1d5._masterTT.show(_1e3,_1e4,_1e5,rtl,_1e6);
};
_1cf.hideTooltip=function(_1e7){
return _1d5._masterTT&&_1d5._masterTT.hide(_1e7);
};
var _1d5=_1c4("dijit.Tooltip",_1cb,{label:"",showDelay:400,connectId:[],position:[],selector:"",_setConnectIdAttr:function(_1e8){
_1c3.forEach(this._connections||[],function(_1e9){
_1c3.forEach(_1e9,function(_1ea){
_1ea.remove();
});
},this);
this._connectIds=_1c3.filter(lang.isArrayLike(_1e8)?_1e8:(_1e8?[_1e8]:[]),function(id){
return dom.byId(id,this.ownerDocument);
},this);
this._connections=_1c3.map(this._connectIds,function(id){
var node=dom.byId(id,this.ownerDocument),_1eb=this.selector,_1ec=_1eb?function(_1ed){
return on.selector(_1eb,_1ed);
}:function(_1ee){
return _1ee;
},self=this;
return [on(node,_1ec(_1c8.enter),function(){
self._onHover(this);
}),on(node,_1ec("focusin"),function(){
self._onHover(this);
}),on(node,_1ec(_1c8.leave),lang.hitch(self,"_onUnHover")),on(node,_1ec("focusout"),lang.hitch(self,"_onUnHover"))];
},this);
this._set("connectId",_1e8);
},addTarget:function(node){
var id=node.id||node;
if(_1c3.indexOf(this._connectIds,id)==-1){
this.set("connectId",this._connectIds.concat(id));
}
},removeTarget:function(node){
var id=node.id||node,idx=_1c3.indexOf(this._connectIds,id);
if(idx>=0){
this._connectIds.splice(idx,1);
this.set("connectId",this._connectIds);
}
},buildRendering:function(){
this.inherited(arguments);
_1c5.add(this.domNode,"dijitTooltipData");
},startup:function(){
this.inherited(arguments);
var ids=this.connectId;
_1c3.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);
},getContent:function(node){
return this.label||this.domNode.innerHTML;
},_onHover:function(_1ef){
if(!this._showTimer){
this._showTimer=this.defer(function(){
this.open(_1ef);
},this.showDelay);
}
},_onUnHover:function(){
if(this._showTimer){
this._showTimer.remove();
delete this._showTimer;
}
this.close();
},open:function(_1f0){
if(this._showTimer){
this._showTimer.remove();
delete this._showTimer;
}
var _1f1=this.getContent(_1f0);
if(!_1f1){
return;
}
_1d5.show(_1f1,_1f0,this.position,!this.isLeftToRight(),this.textDir);
this._connectNode=_1f0;
this.onShow(_1f0,this.position);
},close:function(){
if(this._connectNode){
_1d5.hide(this._connectNode);
delete this._connectNode;
this.onHide();
}
if(this._showTimer){
this._showTimer.remove();
delete this._showTimer;
}
},onShow:function(){
},onHide:function(){
},destroy:function(){
this.close();
_1c3.forEach(this._connections||[],function(_1f2){
_1c3.forEach(_1f2,function(_1f3){
_1f3.remove();
});
},this);
this.inherited(arguments);
}});
_1d5._MasterTooltip=_1d0;
_1d5.show=_1cf.showTooltip;
_1d5.hide=_1cf.hideTooltip;
_1d5.defaultPosition=["after-centered","before-centered"];
return _1d5;
});
},"dijit/form/Button":function(){
require({cache:{"url:dijit/form/templates/Button.html":"<span class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><span class=\"dijitReset dijitInline dijitButtonNode\"\n\t\tdata-dojo-attach-event=\"ondijitclick:_onClick\" role=\"presentation\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode,focusNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span class=\"dijitReset dijitToggleButtonIconChar\">&#x25CF;</span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t></span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\"\n\t\ttabIndex=\"-1\" role=\"presentation\" data-dojo-attach-point=\"valueNode\"\n/></span>\n"}});
define("dijit/form/Button",["require","dojo/_base/declare","dojo/dom-class","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/ready","./_FormWidget","./_ButtonMixin","dojo/text!./templates/Button.html"],function(_1f4,_1f5,_1f6,has,_1f7,lang,_1f8,_1f9,_1fa,_1fb){
if(has("dijit-legacy-requires")){
_1f8(0,function(){
var _1fc=["dijit/form/DropDownButton","dijit/form/ComboButton","dijit/form/ToggleButton"];
_1f4(_1fc);
});
}
return _1f5("dijit.form.Button",[_1f9,_1fa],{showLabel:true,iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},baseClass:"dijitButton",templateString:_1fb,_setValueAttr:"valueNode",_onClick:function(e){
var ok=this.inherited(arguments);
if(ok){
if(this.valueNode){
this.valueNode.click();
e.preventDefault();
e.stopPropagation();
}
}
return ok;
},_fillContent:function(_1fd){
if(_1fd&&(!this.params||!("label" in this.params))){
var _1fe=lang.trim(_1fd.innerHTML);
if(_1fe){
this.label=_1fe;
}
}
},_setShowLabelAttr:function(val){
if(this.containerNode){
_1f6.toggle(this.containerNode,"dijitDisplayNone",!val);
}
this._set("showLabel",val);
},setLabel:function(_1ff){
_1f7.deprecated("dijit.form.Button.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");
this.set("label",_1ff);
},_setLabelAttr:function(_200){
this.inherited(arguments);
if(!this.showLabel&&!("title" in this.params)){
this.titleNode.title=lang.trim(this.containerNode.innerText||this.containerNode.textContent||"");
}
}});
});
},"dijit/form/TextBox":function(){
require({cache:{"url:dijit/form/templates/TextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\" id=\"widget_${id}\" role=\"presentation\"\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n"}});
define("dijit/form/TextBox",["dojo/_base/declare","dojo/dom-construct","dojo/dom-style","dojo/_base/kernel","dojo/_base/lang","dojo/sniff","./_FormValueWidget","./_TextBoxMixin","dojo/text!./templates/TextBox.html","../main"],function(_201,_202,_203,_204,lang,has,_205,_206,_207,_208){
var _209=_201("dijit.form.TextBox",[_205,_206],{templateString:_207,_singleNodeTemplate:"<input class=\"dijit dijitReset dijitLeft dijitInputField\" data-dojo-attach-point=\"textbox,focusNode\" autocomplete=\"off\" type=\"${type}\" ${!nameAttrSetting} />",_buttonInputDisabled:has("ie")?"disabled":"",baseClass:"dijitTextBox",postMixInProperties:function(){
var type=this.type.toLowerCase();
if(this.templateString&&this.templateString.toLowerCase()=="input"||((type=="hidden"||type=="file")&&this.templateString==this.constructor.prototype.templateString)){
this.templateString=this._singleNodeTemplate;
}
this.inherited(arguments);
},postCreate:function(){
this.inherited(arguments);
if(has("ie")<9){
this.defer(function(){
try{
var s=_203.getComputedStyle(this.domNode);
if(s){
var ff=s.fontFamily;
if(ff){
var _20a=this.domNode.getElementsByTagName("INPUT");
if(_20a){
for(var i=0;i<_20a.length;i++){
_20a[i].style.fontFamily=ff;
}
}
}
}
}
catch(e){
}
});
}
},_onInput:function(e){
this.inherited(arguments);
if(this.intermediateChanges){
this.defer(function(){
this._handleOnChange(this.get("value"),false);
});
}
},_setPlaceHolderAttr:function(v){
this._set("placeHolder",v);
if(!this._phspan){
this._attachPoints.push("_phspan");
this._phspan=_202.create("span",{onmousedown:function(e){
e.preventDefault();
},className:"dijitPlaceHolder dijitInputField"},this.textbox,"after");
}
this._phspan.innerHTML="";
this._phspan.appendChild(this._phspan.ownerDocument.createTextNode(v));
this._updatePlaceHolder();
},_updatePlaceHolder:function(){
if(this._phspan){
this._phspan.style.display=(this.placeHolder&&!this.focused&&!this.textbox.value)?"":"none";
}
},_setValueAttr:function(_20b,_20c,_20d){
this.inherited(arguments);
this._updatePlaceHolder();
},getDisplayedValue:function(){
_204.deprecated(this.declaredClass+"::getDisplayedValue() is deprecated. Use get('displayedValue') instead.","","2.0");
return this.get("displayedValue");
},setDisplayedValue:function(_20e){
_204.deprecated(this.declaredClass+"::setDisplayedValue() is deprecated. Use set('displayedValue', ...) instead.","","2.0");
this.set("displayedValue",_20e);
},_onBlur:function(e){
if(this.disabled){
return;
}
this.inherited(arguments);
this._updatePlaceHolder();
if(has("mozilla")){
if(this.selectOnClick){
this.textbox.selectionStart=this.textbox.selectionEnd=undefined;
}
}
},_onFocus:function(by){
if(this.disabled||this.readOnly){
return;
}
this.inherited(arguments);
this._updatePlaceHolder();
}});
if(has("ie")){
_209.prototype._isTextSelected=function(){
var _20f=this.ownerDocument.selection.createRange();
var _210=_20f.parentElement();
return _210==this.textbox&&_20f.text.length>0;
};
_208._setSelectionRange=_206._setSelectionRange=function(_211,_212,stop){
if(_211.createTextRange){
var r=_211.createTextRange();
r.collapse(true);
r.moveStart("character",-99999);
r.moveStart("character",_212);
r.moveEnd("character",stop-_212);
r.select();
}
};
}
return _209;
});
},"dijit/form/Form":function(){
define("dijit/form/Form",["dojo/_base/declare","dojo/dom-attr","dojo/_base/event","dojo/_base/kernel","dojo/sniff","../_Widget","../_TemplatedMixin","./_FormMixin","../layout/_ContentPaneResizeMixin"],function(_213,_214,_215,_216,has,_217,_218,_219,_21a){
return _213("dijit.form.Form",[_217,_218,_219,_21a],{name:"",action:"",method:"",encType:"","accept-charset":"",accept:"",target:"",templateString:"<form data-dojo-attach-point='containerNode' data-dojo-attach-event='onreset:_onReset,onsubmit:_onSubmit' ${!nameAttrSetting}></form>",postMixInProperties:function(){
this.nameAttrSetting=this.name?("name='"+this.name+"'"):"";
this.inherited(arguments);
},execute:function(){
},onExecute:function(){
},_setEncTypeAttr:function(_21b){
this.encType=_21b;
_214.set(this.domNode,"encType",_21b);
if(has("ie")){
this.domNode.encoding=_21b;
}
},reset:function(e){
var faux={returnValue:true,preventDefault:function(){
this.returnValue=false;
},stopPropagation:function(){
},currentTarget:e?e.target:this.domNode,target:e?e.target:this.domNode};
if(!(this.onReset(faux)===false)&&faux.returnValue){
this.inherited(arguments,[]);
}
},onReset:function(){
return true;
},_onReset:function(e){
this.reset(e);
_215.stop(e);
return false;
},_onSubmit:function(e){
var fp=this.constructor.prototype;
if(this.execute!=fp.execute||this.onExecute!=fp.onExecute){
_216.deprecated("dijit.form.Form:execute()/onExecute() are deprecated. Use onSubmit() instead.","","2.0");
this.onExecute();
this.execute(this.getValues());
}
if(this.onSubmit(e)===false){
_215.stop(e);
}
},onSubmit:function(){
return this.isValid();
},submit:function(){
if(!(this.onSubmit()===false)){
this.containerNode.submit();
}
}});
});
},"url:dijit/form/templates/DropDownButton.html":"<span class=\"dijit dijitReset dijitInline\"\n\t><span class='dijitReset dijitInline dijitButtonNode'\n\t\tdata-dojo-attach-event=\"ondijitclick:_onClick\" data-dojo-attach-point=\"_buttonNode\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"focusNode,titleNode,_arrowWrapperNode\"\n\t\t\trole=\"button\" aria-haspopup=\"true\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\"\n\t\t\t\tdata-dojo-attach-point=\"iconNode\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode,_popupStateNode\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonInner\"></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonChar\">&#9660;</span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\" tabIndex=\"-1\"\n\t\tdata-dojo-attach-point=\"valueNode\" role=\"presentation\"\n/></span>\n","dijit/_HasDropDown":function(){
define("dijit/_HasDropDown",["dojo/_base/declare","dojo/_base/Deferred","dojo/_base/event","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","dojo/window","./registry","./focus","./popup","./_FocusMixin"],function(_21c,_21d,_21e,dom,_21f,_220,_221,_222,has,keys,lang,on,_223,_224,_225,_226,_227){
return _21c("dijit._HasDropDown",_227,{_buttonNode:null,_arrowWrapperNode:null,_popupStateNode:null,_aroundNode:null,dropDown:null,autoWidth:true,forceWidth:false,maxHeight:0,dropDownPosition:["below","above"],_stopClickEvents:true,_onDropDownMouseDown:function(e){
if(this.disabled||this.readOnly){
return;
}
e.preventDefault();
this._docHandler=this.connect(this.ownerDocument,"mouseup","_onDropDownMouseUp");
this.toggleDropDown();
},_onDropDownMouseUp:function(e){
if(e&&this._docHandler){
this.disconnect(this._docHandler);
}
var _228=this.dropDown,_229=false;
if(e&&this._opened){
var c=_221.position(this._buttonNode,true);
if(!(e.pageX>=c.x&&e.pageX<=c.x+c.w)||!(e.pageY>=c.y&&e.pageY<=c.y+c.h)){
var t=e.target;
while(t&&!_229){
if(_220.contains(t,"dijitPopup")){
_229=true;
}else{
t=t.parentNode;
}
}
if(_229){
t=e.target;
if(_228.onItemClick){
var _22a;
while(t&&!(_22a=_224.byNode(t))){
t=t.parentNode;
}
if(_22a&&_22a.onClick&&_22a.getParent){
_22a.getParent().onItemClick(_22a,e);
}
}
return;
}
}
}
if(this._opened){
if(_228.focus&&_228.autoFocus!==false){
this._focusDropDownTimer=this.defer(function(){
_228.focus();
delete this._focusDropDownTimer;
});
}
}else{
this.defer("focus");
}
if(has("touch")){
this._justGotMouseUp=true;
this.defer(function(){
this._justGotMouseUp=false;
});
}
},_onDropDownClick:function(e){
if(has("touch")&&!this._justGotMouseUp){
this._onDropDownMouseDown(e);
this._onDropDownMouseUp(e);
}
if(this._stopClickEvents){
_21e.stop(e);
}
},buildRendering:function(){
this.inherited(arguments);
this._buttonNode=this._buttonNode||this.focusNode||this.domNode;
this._popupStateNode=this._popupStateNode||this.focusNode||this._buttonNode;
var _22b={"after":this.isLeftToRight()?"Right":"Left","before":this.isLeftToRight()?"Left":"Right","above":"Up","below":"Down","left":"Left","right":"Right"}[this.dropDownPosition[0]]||this.dropDownPosition[0]||"Down";
_220.add(this._arrowWrapperNode||this._buttonNode,"dijit"+_22b+"ArrowButton");
},postCreate:function(){
this.inherited(arguments);
var _22c=this.focusNode||this.domNode;
this.own(on(this._buttonNode,"mousedown",lang.hitch(this,"_onDropDownMouseDown")),on(this._buttonNode,"click",lang.hitch(this,"_onDropDownClick")),on(_22c,"keydown",lang.hitch(this,"_onKey")),on(_22c,"keyup",lang.hitch(this,"_onKeyUp")));
},destroy:function(){
if(this.dropDown){
if(!this.dropDown._destroyed){
this.dropDown.destroyRecursive();
}
delete this.dropDown;
}
this.inherited(arguments);
},_onKey:function(e){
if(this.disabled||this.readOnly){
return;
}
var d=this.dropDown,_22d=e.target;
if(d&&this._opened&&d.handleKey){
if(d.handleKey(e)===false){
_21e.stop(e);
return;
}
}
if(d&&this._opened&&e.keyCode==keys.ESCAPE){
this.closeDropDown();
_21e.stop(e);
}else{
if(!this._opened&&(e.keyCode==keys.DOWN_ARROW||((e.keyCode==keys.ENTER||e.keyCode==keys.SPACE)&&((_22d.tagName||"").toLowerCase()!=="input"||(_22d.type&&_22d.type.toLowerCase()!=="text"))))){
this._toggleOnKeyUp=true;
_21e.stop(e);
}
}
},_onKeyUp:function(){
if(this._toggleOnKeyUp){
delete this._toggleOnKeyUp;
this.toggleDropDown();
var d=this.dropDown;
if(d&&d.focus){
this.defer(lang.hitch(d,"focus"),1);
}
}
},_onBlur:function(){
var _22e=_225.curNode&&this.dropDown&&dom.isDescendant(_225.curNode,this.dropDown.domNode);
this.closeDropDown(_22e);
this.inherited(arguments);
},isLoaded:function(){
return true;
},loadDropDown:function(_22f){
_22f();
},loadAndOpenDropDown:function(){
var d=new _21d(),_230=lang.hitch(this,function(){
this.openDropDown();
d.resolve(this.dropDown);
});
if(!this.isLoaded()){
this.loadDropDown(_230);
}else{
_230();
}
return d;
},toggleDropDown:function(){
if(this.disabled||this.readOnly){
return;
}
if(!this._opened){
this.loadAndOpenDropDown();
}else{
this.closeDropDown();
}
},openDropDown:function(){
var _231=this.dropDown,_232=_231.domNode,_233=this._aroundNode||this.domNode,self=this;
if(!this._preparedNode){
this._preparedNode=true;
if(_232.style.width){
this._explicitDDWidth=true;
}
if(_232.style.height){
this._explicitDDHeight=true;
}
}
if(this.maxHeight||this.forceWidth||this.autoWidth){
var _234={display:"",visibility:"hidden"};
if(!this._explicitDDWidth){
_234.width="";
}
if(!this._explicitDDHeight){
_234.height="";
}
_222.set(_232,_234);
var _235=this.maxHeight;
if(_235==-1){
var _236=_223.getBox(this.ownerDocument),_237=_221.position(_233,false);
_235=Math.floor(Math.max(_237.y,_236.h-(_237.y+_237.h)));
}
_226.moveOffScreen(_231);
if(_231.startup&&!_231._started){
_231.startup();
}
var mb=_221.getMarginSize(_232);
var _238=(_235&&mb.h>_235);
_222.set(_232,{overflowX:"visible",overflowY:_238?"auto":"visible"});
if(_238){
mb.h=_235;
if("w" in mb){
mb.w+=16;
}
}else{
delete mb.h;
}
if(this.forceWidth){
mb.w=_233.offsetWidth;
}else{
if(this.autoWidth){
mb.w=Math.max(mb.w,_233.offsetWidth);
}else{
delete mb.w;
}
}
if(lang.isFunction(_231.resize)){
_231.resize(mb);
}else{
_221.setMarginBox(_232,mb);
}
}
var _239=_226.open({parent:this,popup:_231,around:_233,orient:this.dropDownPosition,onExecute:function(){
self.closeDropDown(true);
},onCancel:function(){
self.closeDropDown(true);
},onClose:function(){
_21f.set(self._popupStateNode,"popupActive",false);
_220.remove(self._popupStateNode,"dijitHasDropDownOpen");
self._set("_opened",false);
}});
_21f.set(this._popupStateNode,"popupActive","true");
_220.add(this._popupStateNode,"dijitHasDropDownOpen");
this._set("_opened",true);
this.domNode.setAttribute("aria-expanded","true");
return _239;
},closeDropDown:function(_23a){
if(this._focusDropDownTimer){
this._focusDropDownTimer.remove();
delete this._focusDropDownTimer;
}
if(this._opened){
this.domNode.setAttribute("aria-expanded","false");
if(_23a){
this.focus();
}
_226.close(this.dropDown);
this._opened=false;
}
}});
});
},"url:dojox/form/resources/PasswordValidator.html":"<div dojoAttachPoint=\"containerNode\">\n\t<input type=\"hidden\" name=\"${name}\" value=\"\" dojoAttachPoint=\"focusNode\" />\n</div>","url:dijit/templates/Dialog.html":"<div class=\"dijitDialog\" role=\"dialog\" aria-labelledby=\"${id}_title\">\n\t<div data-dojo-attach-point=\"titleBar\" class=\"dijitDialogTitleBar\">\n\t\t<span data-dojo-attach-point=\"titleNode\" class=\"dijitDialogTitle\" id=\"${id}_title\"\n\t\t\t\trole=\"heading\" level=\"1\"></span>\n\t\t<span data-dojo-attach-point=\"closeButtonNode\" class=\"dijitDialogCloseIcon\" data-dojo-attach-event=\"ondijitclick: onCancel\" title=\"${buttonCancel}\" role=\"button\" tabIndex=\"-1\">\n\t\t\t<span data-dojo-attach-point=\"closeText\" class=\"closeText\" title=\"${buttonCancel}\">x</span>\n\t\t</span>\n\t</div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitDialogPaneContent\"></div>\n</div>\n","dojox/validate/regexp":function(){
define("dojox/validate/regexp",["dojo/_base/lang","dojo/regexp","dojox/main"],function(lang,_23b,_23c){
var _23d=lang.getObject("validate.regexp",true,_23c);
_23d=_23c.validate.regexp={ipAddress:function(_23e){
_23e=(typeof _23e=="object")?_23e:{};
if(typeof _23e.allowDottedDecimal!="boolean"){
_23e.allowDottedDecimal=true;
}
if(typeof _23e.allowDottedHex!="boolean"){
_23e.allowDottedHex=true;
}
if(typeof _23e.allowDottedOctal!="boolean"){
_23e.allowDottedOctal=true;
}
if(typeof _23e.allowDecimal!="boolean"){
_23e.allowDecimal=true;
}
if(typeof _23e.allowHex!="boolean"){
_23e.allowHex=true;
}
if(typeof _23e.allowIPv6!="boolean"){
_23e.allowIPv6=true;
}
if(typeof _23e.allowHybrid!="boolean"){
_23e.allowHybrid=true;
}
var _23f="((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])";
var _240="(0[xX]0*[\\da-fA-F]?[\\da-fA-F]\\.){3}0[xX]0*[\\da-fA-F]?[\\da-fA-F]";
var _241="(0+[0-3][0-7][0-7]\\.){3}0+[0-3][0-7][0-7]";
var _242="(0|[1-9]\\d{0,8}|[1-3]\\d{9}|4[01]\\d{8}|42[0-8]\\d{7}|429[0-3]\\d{6}|"+"4294[0-8]\\d{5}|42949[0-5]\\d{4}|429496[0-6]\\d{3}|4294967[01]\\d{2}|42949672[0-8]\\d|429496729[0-5])";
var _243="0[xX]0*[\\da-fA-F]{1,8}";
var _244="([\\da-fA-F]{1,4}\\:){7}[\\da-fA-F]{1,4}";
var _245="([\\da-fA-F]{1,4}\\:){6}"+"((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])";
var a=[];
if(_23e.allowDottedDecimal){
a.push(_23f);
}
if(_23e.allowDottedHex){
a.push(_240);
}
if(_23e.allowDottedOctal){
a.push(_241);
}
if(_23e.allowDecimal){
a.push(_242);
}
if(_23e.allowHex){
a.push(_243);
}
if(_23e.allowIPv6){
a.push(_244);
}
if(_23e.allowHybrid){
a.push(_245);
}
var _246="";
if(a.length>0){
_246="("+a.join("|")+")";
}
return _246;
},host:function(_247){
_247=(typeof _247=="object")?_247:{};
if(typeof _247.allowIP!="boolean"){
_247.allowIP=true;
}
if(typeof _247.allowLocal!="boolean"){
_247.allowLocal=false;
}
if(typeof _247.allowPort!="boolean"){
_247.allowPort=true;
}
if(typeof _247.allowNamed!="boolean"){
_247.allowNamed=false;
}
var _248="(?:[\\da-zA-Z](?:[-\\da-zA-Z]{0,61}[\\da-zA-Z])?)";
var _249="(?:[a-zA-Z](?:[-\\da-zA-Z]{0,6}[\\da-zA-Z])?)";
var _24a=_247.allowPort?"(\\:\\d+)?":"";
var _24b="((?:"+_248+"\\.)+"+_249+"\\.?)";
if(_247.allowIP){
_24b+="|"+_23d.ipAddress(_247);
}
if(_247.allowLocal){
_24b+="|localhost";
}
if(_247.allowNamed){
_24b+="|^[^-][a-zA-Z0-9_-]*";
}
return "("+_24b+")"+_24a;
},url:function(_24c){
_24c=(typeof _24c=="object")?_24c:{};
if(!("scheme" in _24c)){
_24c.scheme=[true,false];
}
var _24d=_23b.buildGroupRE(_24c.scheme,function(q){
if(q){
return "(https?|ftps?)\\://";
}
return "";
});
var _24e="(/(?:[^?#\\s/]+/)*(?:[^?#\\s/]+(?:\\?[^?#\\s/]*)?(?:#[A-Za-z][\\w.:-]*)?)?)?";
return _24d+_23d.host(_24c)+_24e;
},emailAddress:function(_24f){
_24f=(typeof _24f=="object")?_24f:{};
if(typeof _24f.allowCruft!="boolean"){
_24f.allowCruft=false;
}
_24f.allowPort=false;
var _250="([!#-'*+\\-\\/-9=?A-Z^-~]+[.])*[!#-'*+\\-\\/-9=?A-Z^-~]+";
var _251=_250+"@"+_23d.host(_24f);
if(_24f.allowCruft){
_251="<?(mailto\\:)?"+_251+">?";
}
return _251;
},emailAddressList:function(_252){
_252=(typeof _252=="object")?_252:{};
if(typeof _252.listSeparator!="string"){
_252.listSeparator="\\s;,";
}
var _253=_23d.emailAddress(_252);
var _254="("+_253+"\\s*["+_252.listSeparator+"]\\s*)*"+_253+"\\s*["+_252.listSeparator+"]?\\s*";
return _254;
},numberFormat:function(_255){
_255=(typeof _255=="object")?_255:{};
if(typeof _255.format=="undefined"){
_255.format="###-###-####";
}
var _256=function(_257){
return _23b.escapeString(_257,"?").replace(/\?/g,"\\d?").replace(/#/g,"\\d");
};
return _23b.buildGroupRE(_255.format,_256);
},ca:{postalCode:function(){
return "([A-Z][0-9][A-Z] [0-9][A-Z][0-9])";
},province:function(){
return "(AB|BC|MB|NB|NL|NS|NT|NU|ON|PE|QC|SK|YT)";
}},us:{state:function(_258){
_258=(typeof _258=="object")?_258:{};
if(typeof _258.allowTerritories!="boolean"){
_258.allowTerritories=true;
}
if(typeof _258.allowMilitary!="boolean"){
_258.allowMilitary=true;
}
var _259="AL|AK|AZ|AR|CA|CO|CT|DE|DC|FL|GA|HI|ID|IL|IN|IA|KS|KY|LA|ME|MD|MA|MI|MN|MS|MO|MT|"+"NE|NV|NH|NJ|NM|NY|NC|ND|OH|OK|OR|PA|RI|SC|SD|TN|TX|UT|VT|VA|WA|WV|WI|WY";
var _25a="AS|FM|GU|MH|MP|PW|PR|VI";
var _25b="AA|AE|AP";
if(_258.allowTerritories){
_259+="|"+_25a;
}
if(_258.allowMilitary){
_259+="|"+_25b;
}
return "("+_259+")";
}}};
return _23d;
});
},"dojo/regexp":function(){
define("dojo/regexp",["./_base/kernel","./_base/lang"],function(dojo,lang){
var _25c={};
lang.setObject("dojo.regexp",_25c);
_25c.escapeString=function(str,_25d){
return str.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g,function(ch){
if(_25d&&_25d.indexOf(ch)!=-1){
return ch;
}
return "\\"+ch;
});
};
_25c.buildGroupRE=function(arr,re,_25e){
if(!(arr instanceof Array)){
return re(arr);
}
var b=[];
for(var i=0;i<arr.length;i++){
b.push(re(arr[i]));
}
return _25c.group(b.join("|"),_25e);
};
_25c.group=function(_25f,_260){
return "("+(_260?"?:":"")+_25f+")";
};
return _25c;
});
},"dijit/form/_FormMixin":function(){
define("dijit/form/_FormMixin",["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/window"],function(_261,_262,_263,lang,on,_264){
return _262("dijit.form._FormMixin",null,{state:"",_getDescendantFormWidgets:function(_265){
var res=[];
_261.forEach(_265||this.getChildren(),function(_266){
if("value" in _266){
res.push(_266);
}else{
res=res.concat(this._getDescendantFormWidgets(_266.getChildren()));
}
},this);
return res;
},reset:function(){
_261.forEach(this._getDescendantFormWidgets(),function(_267){
if(_267.reset){
_267.reset();
}
});
},validate:function(){
var _268=false;
return _261.every(_261.map(this._getDescendantFormWidgets(),function(_269){
_269._hasBeenBlurred=true;
var _26a=_269.disabled||!_269.validate||_269.validate();
if(!_26a&&!_268){
_264.scrollIntoView(_269.containerNode||_269.domNode);
_269.focus();
_268=true;
}
return _26a;
}),function(item){
return item;
});
},setValues:function(val){
_263.deprecated(this.declaredClass+"::setValues() is deprecated. Use set('value', val) instead.","","2.0");
return this.set("value",val);
},_setValueAttr:function(obj){
var map={};
_261.forEach(this._getDescendantFormWidgets(),function(_26b){
if(!_26b.name){
return;
}
var _26c=map[_26b.name]||(map[_26b.name]=[]);
_26c.push(_26b);
});
for(var name in map){
if(!map.hasOwnProperty(name)){
continue;
}
var _26d=map[name],_26e=lang.getObject(name,false,obj);
if(_26e===undefined){
continue;
}
if(!lang.isArray(_26e)){
_26e=[_26e];
}
if(typeof _26d[0].checked=="boolean"){
_261.forEach(_26d,function(w){
w.set("value",_261.indexOf(_26e,w.value)!=-1);
});
}else{
if(_26d[0].multiple){
_26d[0].set("value",_26e);
}else{
_261.forEach(_26d,function(w,i){
w.set("value",_26e[i]);
});
}
}
}
},getValues:function(){
_263.deprecated(this.declaredClass+"::getValues() is deprecated. Use get('value') instead.","","2.0");
return this.get("value");
},_getValueAttr:function(){
var obj={};
_261.forEach(this._getDescendantFormWidgets(),function(_26f){
var name=_26f.name;
if(!name||_26f.disabled){
return;
}
var _270=_26f.get("value");
if(typeof _26f.checked=="boolean"){
if(/Radio/.test(_26f.declaredClass)){
if(_270!==false){
lang.setObject(name,_270,obj);
}else{
_270=lang.getObject(name,false,obj);
if(_270===undefined){
lang.setObject(name,null,obj);
}
}
}else{
var ary=lang.getObject(name,false,obj);
if(!ary){
ary=[];
lang.setObject(name,ary,obj);
}
if(_270!==false){
ary.push(_270);
}
}
}else{
var prev=lang.getObject(name,false,obj);
if(typeof prev!="undefined"){
if(lang.isArray(prev)){
prev.push(_270);
}else{
lang.setObject(name,[prev,_270],obj);
}
}else{
lang.setObject(name,_270,obj);
}
}
});
return obj;
},isValid:function(){
return this.state=="";
},onValidStateChange:function(){
},_getState:function(){
var _271=_261.map(this._descendants,function(w){
return w.get("state")||"";
});
return _261.indexOf(_271,"Error")>=0?"Error":_261.indexOf(_271,"Incomplete")>=0?"Incomplete":"";
},disconnectChildren:function(){
},connectChildren:function(_272){
this._descendants=this._getDescendantFormWidgets();
_261.forEach(this._descendants,function(_273){
if(!_273._started){
_273.startup();
}
});
if(!_272){
this._onChildChange();
}
},_onChildChange:function(attr){
if(!attr||attr=="state"||attr=="disabled"){
this._set("state",this._getState());
}
if(!attr||attr=="value"||attr=="disabled"||attr=="checked"){
if(this._onChangeDelayTimer){
this._onChangeDelayTimer.remove();
}
this._onChangeDelayTimer=this.defer(function(){
delete this._onChangeDelayTimer;
this._set("value",this.get("value"));
},10);
}
},startup:function(){
this.inherited(arguments);
this._descendants=this._getDescendantFormWidgets();
this.value=this.get("value");
this.state=this._getState();
var self=this;
this.own(on(this.containerNode,"attrmodified-state, attrmodified-disabled, attrmodified-value, attrmodified-checked",function(evt){
if(evt.target==self.domNode){
return;
}
self._onChildChange(evt.type.replace("attrmodified-",""));
}));
this.watch("state",function(attr,_274,_275){
this.onValidStateChange(_275=="");
});
},destroy:function(){
this.inherited(arguments);
}});
});
},"davinci/version":function(){
define("davinci/version",[],"10");
},"dijit/DropDownMenu":function(){
require({cache:{"url:dijit/templates/Menu.html":"<table class=\"dijit dijitMenu dijitMenuPassive dijitReset dijitMenuTable\" role=\"menu\" tabIndex=\"${tabIndex}\"\n\t   data-dojo-attach-event=\"onkeypress:_onKeyPress\" cellspacing=\"0\">\n\t<tbody class=\"dijitReset\" data-dojo-attach-point=\"containerNode\"></tbody>\n</table>\n"}});
define("dijit/DropDownMenu",["dojo/_base/declare","dojo/_base/event","dojo/keys","dojo/text!./templates/Menu.html","./_OnDijitClickMixin","./_MenuBase"],function(_276,_277,keys,_278,_279,_27a){
return _276("dijit.DropDownMenu",[_27a,_279],{templateString:_278,baseClass:"dijitMenu",postCreate:function(){
this.inherited(arguments);
var l=this.isLeftToRight();
this._openSubMenuKey=l?keys.RIGHT_ARROW:keys.LEFT_ARROW;
this._closeSubMenuKey=l?keys.LEFT_ARROW:keys.RIGHT_ARROW;
this.connectKeyNavHandlers([keys.UP_ARROW],[keys.DOWN_ARROW]);
},_onKeyPress:function(evt){
if(evt.ctrlKey||evt.altKey){
return;
}
switch(evt.charOrCode){
case this._openSubMenuKey:
this._moveToPopup(evt);
_277.stop(evt);
break;
case this._closeSubMenuKey:
if(this.parentMenu){
if(this.parentMenu._isMenuBar){
this.parentMenu.focusPrev();
}else{
this.onCancel(false);
}
}else{
_277.stop(evt);
}
break;
}
}});
});
},"dijit/MenuItem":function(){
require({cache:{"url:dijit/templates/MenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon dijitMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">\n\t\t<div data-dojo-attach-point=\"arrowWrapper\" style=\"visibility: hidden\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuExpand\"/>\n\t\t\t<span class=\"dijitMenuExpandA11y\">+</span>\n\t\t</div>\n\t</td>\n</tr>\n"}});
define("dijit/MenuItem",["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/kernel","dojo/sniff","./_Widget","./_TemplatedMixin","./_Contained","./_CssStateMixin","dojo/text!./templates/MenuItem.html"],function(_27b,dom,_27c,_27d,_27e,has,_27f,_280,_281,_282,_283){
return _27b("dijit.MenuItem",[_27f,_280,_281,_282],{templateString:_283,baseClass:"dijitMenuItem",label:"",_setLabelAttr:function(val){
this.containerNode.innerHTML=val;
this._set("label",val);
if(this.textDir==="auto"){
this.applyTextDir(this.focusNode,this.label);
}
},iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},accelKey:"",disabled:false,_fillContent:function(_284){
if(_284&&!("label" in this.params)){
this.set("label",_284.innerHTML);
}
},buildRendering:function(){
this.inherited(arguments);
var _285=this.id+"_text";
_27c.set(this.containerNode,"id",_285);
if(this.accelKeyNode){
_27c.set(this.accelKeyNode,"id",this.id+"_accel");
_285+=" "+this.id+"_accel";
}
this.domNode.setAttribute("aria-labelledby",_285);
dom.setSelectable(this.domNode,false);
},onClick:function(){
},focus:function(){
try{
if(has("ie")==8){
this.containerNode.focus();
}
this.focusNode.focus();
}
catch(e){
}
},_onFocus:function(){
this._setSelected(true);
this.getParent()._onItemFocus(this);
this.inherited(arguments);
},_setSelected:function(_286){
_27d.toggle(this.domNode,"dijitMenuItemSelected",_286);
},setLabel:function(_287){
_27e.deprecated("dijit.MenuItem.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");
this.set("label",_287);
},setDisabled:function(_288){
_27e.deprecated("dijit.Menu.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");
this.set("disabled",_288);
},_setDisabledAttr:function(_289){
this.focusNode.setAttribute("aria-disabled",_289?"true":"false");
this._set("disabled",_289);
},_setAccelKeyAttr:function(_28a){
this.accelKeyNode.style.display=_28a?"":"none";
this.accelKeyNode.innerHTML=_28a;
_27c.set(this.containerNode,"colSpan",_28a?"1":"2");
this._set("accelKey",_28a);
},_setTextDirAttr:function(_28b){
if(!this._created||this.textDir!=_28b){
this._set("textDir",_28b);
this.applyTextDir(this.focusNode,this.label);
}
}});
});
},"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n></div>\n","dijit/Dialog":function(){
require({cache:{"url:dijit/templates/Dialog.html":"<div class=\"dijitDialog\" role=\"dialog\" aria-labelledby=\"${id}_title\">\n\t<div data-dojo-attach-point=\"titleBar\" class=\"dijitDialogTitleBar\">\n\t\t<span data-dojo-attach-point=\"titleNode\" class=\"dijitDialogTitle\" id=\"${id}_title\"\n\t\t\t\trole=\"heading\" level=\"1\"></span>\n\t\t<span data-dojo-attach-point=\"closeButtonNode\" class=\"dijitDialogCloseIcon\" data-dojo-attach-event=\"ondijitclick: onCancel\" title=\"${buttonCancel}\" role=\"button\" tabIndex=\"-1\">\n\t\t\t<span data-dojo-attach-point=\"closeText\" class=\"closeText\" title=\"${buttonCancel}\">x</span>\n\t\t</span>\n\t</div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitDialogPaneContent\"></div>\n</div>\n"}});
define("dijit/Dialog",["require","dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/_base/fx","dojo/i18n","dojo/keys","dojo/_base/lang","dojo/on","dojo/ready","dojo/sniff","dojo/window","dojo/dnd/Moveable","dojo/dnd/TimedMoveable","./focus","./_base/manager","./_Widget","./_TemplatedMixin","./_CssStateMixin","./form/_FormMixin","./_DialogMixin","./DialogUnderlay","./layout/ContentPane","dojo/text!./templates/Dialog.html","./main","dojo/i18n!./nls/common"],function(_28c,_28d,_28e,_28f,_290,dom,_291,_292,_293,_294,fx,i18n,keys,lang,on,_295,has,_296,_297,_298,_299,_29a,_29b,_29c,_29d,_29e,_29f,_2a0,_2a1,_2a2,_2a3){
var _2a4=_28f("dijit._DialogBase",[_29c,_29e,_29f,_29d],{templateString:_2a2,baseClass:"dijitDialog",cssStateNodes:{closeButtonNode:"dijitDialogCloseIcon"},_setTitleAttr:[{node:"titleNode",type:"innerHTML"},{node:"titleBar",type:"attribute"}],open:false,duration:_29a.defaultDuration,refocus:true,autofocus:true,_firstFocusItem:null,_lastFocusItem:null,doLayout:false,draggable:true,_setDraggableAttr:function(val){
this._set("draggable",val);
},"aria-describedby":"",maxRatio:0.9,postMixInProperties:function(){
var _2a5=i18n.getLocalization("dijit","common");
lang.mixin(this,_2a5);
this.inherited(arguments);
},postCreate:function(){
_293.set(this.domNode,{display:"none",position:"absolute"});
this.ownerDocumentBody.appendChild(this.domNode);
this.inherited(arguments);
this.connect(this,"onExecute","hide");
this.connect(this,"onCancel","hide");
this._modalconnects=[];
},onLoad:function(){
this._position();
if(this.autofocus&&_2a6.isTop(this)){
this._getFocusItems(this.domNode);
_299.focus(this._firstFocusItem);
}
this.inherited(arguments);
},_onBlur:function(by){
this.inherited(arguments);
var _2a7=lang.hitch(this,function(){
if(this.open&&!this._destroyed&&_2a6.isTop(this)){
this._getFocusItems(this.domNode);
_299.focus(this._firstFocusItem);
}
});
if(by=="mouse"){
on.once(this.ownerDocument,"mouseup",_2a7);
}else{
_2a7();
}
},_endDrag:function(){
var _2a8=_292.position(this.domNode),_2a9=_296.getBox(this.ownerDocument);
_2a8.y=Math.min(Math.max(_2a8.y,0),(_2a9.h-_2a8.h));
_2a8.x=Math.min(Math.max(_2a8.x,0),(_2a9.w-_2a8.w));
this._relativePosition=_2a8;
this._position();
},_setup:function(){
var node=this.domNode;
if(this.titleBar&&this.draggable){
this._moveable=new ((has("ie")==6)?_298:_297)(node,{handle:this.titleBar});
this.connect(this._moveable,"onMoveStop","_endDrag");
}else{
_291.add(node,"dijitDialogFixed");
}
this.underlayAttrs={dialogId:this.id,"class":_28d.map(this["class"].split(/\s/),function(s){
return s+"_underlay";
}).join(" "),ownerDocument:this.ownerDocument};
},_size:function(){
this._checkIfSingleChild();
if(this._singleChild){
if(typeof this._singleChildOriginalStyle!="undefined"){
this._singleChild.domNode.style.cssText=this._singleChildOriginalStyle;
delete this._singleChildOriginalStyle;
}
}else{
_293.set(this.containerNode,{width:"auto",height:"auto"});
}
var bb=_292.position(this.domNode);
var _2aa=_296.getBox(this.ownerDocument);
_2aa.w*=this.maxRatio;
_2aa.h*=this.maxRatio;
if(bb.w>=_2aa.w||bb.h>=_2aa.h){
var _2ab=_292.position(this.containerNode),w=Math.min(bb.w,_2aa.w)-(bb.w-_2ab.w),h=Math.min(bb.h,_2aa.h)-(bb.h-_2ab.h);
if(this._singleChild&&this._singleChild.resize){
if(typeof this._singleChildOriginalStyle=="undefined"){
this._singleChildOriginalStyle=this._singleChild.domNode.style.cssText;
}
this._singleChild.resize({w:w,h:h});
}else{
_293.set(this.containerNode,{width:w+"px",height:h+"px",overflow:"auto",position:"relative"});
}
}else{
if(this._singleChild&&this._singleChild.resize){
this._singleChild.resize();
}
}
},_position:function(){
if(!_291.contains(this.ownerDocumentBody,"dojoMove")){
var node=this.domNode,_2ac=_296.getBox(this.ownerDocument),p=this._relativePosition,bb=p?null:_292.position(node),l=Math.floor(_2ac.l+(p?p.x:(_2ac.w-bb.w)/2)),t=Math.floor(_2ac.t+(p?p.y:(_2ac.h-bb.h)/2));
_293.set(node,{left:l+"px",top:t+"px"});
}
},_onKey:function(evt){
if(evt.charOrCode){
var node=evt.target;
if(evt.charOrCode===keys.TAB){
this._getFocusItems(this.domNode);
}
var _2ad=(this._firstFocusItem==this._lastFocusItem);
if(node==this._firstFocusItem&&evt.shiftKey&&evt.charOrCode===keys.TAB){
if(!_2ad){
_299.focus(this._lastFocusItem);
}
_294.stop(evt);
}else{
if(node==this._lastFocusItem&&evt.charOrCode===keys.TAB&&!evt.shiftKey){
if(!_2ad){
_299.focus(this._firstFocusItem);
}
_294.stop(evt);
}else{
while(node){
if(node==this.domNode||_291.contains(node,"dijitPopup")){
if(evt.charOrCode==keys.ESCAPE){
this.onCancel();
}else{
return;
}
}
node=node.parentNode;
}
if(evt.charOrCode!==keys.TAB){
_294.stop(evt);
}else{
if(!has("opera")){
try{
this._firstFocusItem.focus();
}
catch(e){
}
}
}
}
}
}
},show:function(){
if(this.open){
return;
}
if(!this._started){
this.startup();
}
if(!this._alreadyInitialized){
this._setup();
this._alreadyInitialized=true;
}
if(this._fadeOutDeferred){
this._fadeOutDeferred.cancel();
}
var win=_296.get(this.ownerDocument);
this._modalconnects.push(on(win,"scroll",lang.hitch(this,"resize")));
this._modalconnects.push(on(this.domNode,_28e._keypress,lang.hitch(this,"_onKey")));
_293.set(this.domNode,{opacity:0,display:""});
this._set("open",true);
this._onShow();
this._size();
this._position();
var _2ae;
this._fadeInDeferred=new _290(lang.hitch(this,function(){
_2ae.stop();
delete this._fadeInDeferred;
}));
_2ae=fx.fadeIn({node:this.domNode,duration:this.duration,beforeBegin:lang.hitch(this,function(){
_2a6.show(this,this.underlayAttrs);
}),onEnd:lang.hitch(this,function(){
if(this.autofocus&&_2a6.isTop(this)){
this._getFocusItems(this.domNode);
_299.focus(this._firstFocusItem);
}
this._fadeInDeferred.resolve(true);
delete this._fadeInDeferred;
})}).play();
return this._fadeInDeferred;
},hide:function(){
if(!this._alreadyInitialized||!this.open){
return;
}
if(this._fadeInDeferred){
this._fadeInDeferred.cancel();
}
var _2af;
this._fadeOutDeferred=new _290(lang.hitch(this,function(){
_2af.stop();
delete this._fadeOutDeferred;
}));
this._fadeOutDeferred.then(lang.hitch(this,"onHide"));
_2af=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,function(){
this.domNode.style.display="none";
_2a6.hide(this);
this._fadeOutDeferred.resolve(true);
delete this._fadeOutDeferred;
})}).play();
if(this._scrollConnected){
this._scrollConnected=false;
}
var h;
while(h=this._modalconnects.pop()){
h.remove();
}
if(this._relativePosition){
delete this._relativePosition;
}
this._set("open",false);
return this._fadeOutDeferred;
},resize:function(){
if(this.domNode.style.display!="none"){
if(_2a0._singleton){
_2a0._singleton.layout();
}
this._position();
this._size();
}
},destroy:function(){
if(this._fadeInDeferred){
this._fadeInDeferred.cancel();
}
if(this._fadeOutDeferred){
this._fadeOutDeferred.cancel();
}
if(this._moveable){
this._moveable.destroy();
}
var h;
while(h=this._modalconnects.pop()){
h.remove();
}
_2a6.hide(this);
this.inherited(arguments);
}});
var _2b0=_28f("dijit.Dialog",[_2a1,_2a4],{});
_2b0._DialogBase=_2a4;
var _2a6=_2b0._DialogLevelManager={_beginZIndex:950,show:function(_2b1,_2b2){
ds[ds.length-1].focus=_299.curNode;
var _2b3=_2a0._singleton;
if(!_2b3||_2b3._destroyed){
_2b3=_2a3._underlay=_2a0._singleton=new _2a0(_2b2);
}else{
_2b3.set(_2b1.underlayAttrs);
}
var _2b4=ds[ds.length-1].dialog?ds[ds.length-1].zIndex+2:_2b0._DialogLevelManager._beginZIndex;
if(ds.length==1){
_2b3.show();
}
_293.set(_2a0._singleton.domNode,"zIndex",_2b4-1);
_293.set(_2b1.domNode,"zIndex",_2b4);
ds.push({dialog:_2b1,underlayAttrs:_2b2,zIndex:_2b4});
},hide:function(_2b5){
if(ds[ds.length-1].dialog==_2b5){
ds.pop();
var pd=ds[ds.length-1];
if(!_2a0._singleton._destroyed){
if(ds.length==1){
_2a0._singleton.hide();
}else{
_293.set(_2a0._singleton.domNode,"zIndex",pd.zIndex-1);
_2a0._singleton.set(pd.underlayAttrs);
}
}
if(_2b5.refocus){
var _2b6=pd.focus;
if(pd.dialog&&(!_2b6||!dom.isDescendant(_2b6,pd.dialog.domNode))){
pd.dialog._getFocusItems(pd.dialog.domNode);
_2b6=pd.dialog._firstFocusItem;
}
if(_2b6){
try{
_2b6.focus();
}
catch(e){
}
}
}
}else{
var idx=_28d.indexOf(_28d.map(ds,function(elem){
return elem.dialog;
}),_2b5);
if(idx!=-1){
ds.splice(idx,1);
}
}
},isTop:function(_2b7){
return ds[ds.length-1].dialog==_2b7;
}};
var ds=_2b0._dialogStack=[{dialog:null,focus:null,underlayAttrs:null}];
if(has("dijit-legacy-requires")){
_295(0,function(){
var _2b8=["dijit/TooltipDialog"];
_28c(_2b8);
});
}
return _2b0;
});
},"*now":function(r){
r(["dojo/i18n!*preload*davinci/nls/davinci-common*[\"ar\",\"ca\",\"cs\",\"da\",\"de\",\"el\",\"en-gb\",\"en-us\",\"es-es\",\"fi-fi\",\"fr-fr\",\"he-il\",\"hu\",\"it-it\",\"ja-jp\",\"ko-kr\",\"nl-nl\",\"nb\",\"pl\",\"pt-br\",\"pt-pt\",\"ru\",\"sk\",\"sl\",\"sv\",\"th\",\"tr\",\"zh-tw\",\"zh-cn\",\"ROOT\"]"]);
}}});
define("davinci/davinci-common",["./version","./repositoryinfo","dijit/dijit","dojo/parser","dijit/Dialog","dijit/Menu","dijit/MenuItem","dijit/Tooltip","dijit/form/Button","dijit/form/DropDownButton","dijit/form/Form","dijit/form/TextBox","dijit/form/ValidationTextBox","dojox/form/PasswordValidator","dojox/validate/regexp"],function(){
});
