/**
 * @class davinci.js.VariableFragment
 * @extends davinci.js.JSElement
 * @constructor
 */
define("davinci/js/JSVariableFragment", [
	"dojo/_base/declare",
	"davinci/js/JSElement",
], function(declare, JSExpression) {

return declare("davinci.js.JSVariableFragment", JSElement, {

	constructor: function() {
		this.elementType = "JSVariableFragment";
		this.name = "";
		this.init = null;
	},

	getText: function(context) {
		var s = "";
		if (this.comment) {
			s += this.printNewLine(context) + this.comment.getText(context);
		}
		if (this.label) {
			s += this.printNewLine(context) + this.label.getText(context);
		}
		s += this.name;
		if (this.init != null) {
			s = s + " = " + this.init.getText(context);
		}
		return s;
	},

	visit: function(visitor) {
		var dontVisitChildren;

		dontVisitChildren = visitor.visit(this);
		if (!dontVisitChildren) {
			if (this.init)
				this.init.visit(visitor);
		}
		if (visitor.endVisit) {
			visitor.endVisit(this);
		}
	}

});
});
