/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"davinci/review/actions/CloseVersionAction":function(){
define(["dojo/_base/declare","./_ReviewNavigatorCommon","davinci/Runtime","dojox/widget/Toaster","dojo/i18n!./nls/actions"],function(_1,_2,_3,_4,_5){
var _6=_1("davinci.review.actions.CloseVersionAction",[_2],{run:function(_7){
var _8=this._getSelection(_7);
if(!_8||!_8.length){
return;
}
okToClose=confirm(_5.areYouSureClose);
if(!okToClose){
return;
}
var _9=_8[0].resource.elementType=="ReviewFile"?_8[0].resource.parent:_8[0].resource;
dojo.xhrGet({url:"cmd/managerVersion",sync:false,handleAs:"text",content:{"type":"close","vTime":_9.timeStamp}}).then(function(_a){
if(_a=="OK"){
if(typeof hasToaster=="undefined"){
new _4({position:"br-left",duration:4000,messageTopic:"/davinci/review/resourceChanged"});
hasToaster=true;
}
dojo.publish("/davinci/review/resourceChanged",[{message:_5.closeSuccessful,type:"message"},"closed",_9]);
}
});
},isEnabled:function(_b){
var _c=this._getSelection(_b);
if(!_c||_c.length==0){
return false;
}
var _d=_c[0].resource.elementType=="ReviewFile"?_c[0].resource.parent:_c[0].resource;
if(_d.designerId==_3.userName){
if(!_d.closed&&!_d.isDraft){
return true;
}
}
return false;
}});
return _6;
});
},"davinci/review/Review":function(){
define(["davinci/Runtime","./Color"],function(_e,_f){
return {getColor:function(_10){
var _11;
dojo.some(_e.reviewers,function(_12,n){
if(_12.email==_10){
_11=n;
return true;
}
return false;
});
return _f.colors[_11];
}};
});
},"davinci/review/drawing/shapes/Arrow":function(){
define(["dojo/_base/declare","./_ShapeCommon"],function(_13,_14){
return _13("davinci.review.drawing.shapes.Arrow",_14,{render:function(){
if(!this.shapeNode){
this._createArrowBody();
this._createArrowHead();
this._evtConns.push(dojo.connect(this.shapeNode,"mouseover",this,"onMouseOver"),dojo.connect(this.shapeNode,"mouseout",this,"onMouseOut"),dojo.connect(this.shapeNode,"mousedown",this,"onMouseDown"));
}
this._transformArrowBody();
this._transformArrowhead();
this.inherited(arguments);
},destroy:function(){
this._triangle.right=this._triangle.left=null;
this.inherited(arguments);
},_createArrowBody:function(){
this.shapeNode=dojo.create("div");
dojo.style(this.shapeNode,{"position":"absolute","padding":"0px","margin":"0px","border":"1px solid "+this.color,"height":"0px","MozTransformOrigin":"0 0","WebkitTransformOrigin":"0 0"});
},_createArrowHead:function(){
this._triangle={};
this._triangle.left=dojo.create("div",null,this.shapeNode);
dojo.style(this._triangle.left,{"position":"absolute","top":"-1px","padding":"0px","margin":"0px","border":"1px solid "+this.color,"height":"0px","width":"15px","MozTransformOrigin":"100% 100%","WebkitTransformOrigin":"100% 100%","MozTransform":"rotate(15deg)","WebkitTransform":"rotate(15deg)"});
this._triangle.right=dojo.create("div",null,this.shapeNode);
dojo.style(this._triangle.right,{"position":"absolute","top":"-1px","padding":"0px","margin":"0px","border":"1px solid "+this.color,"height":"0px","width":"15px","MozTransformOrigin":"100% 100%","WebkitTransformOrigin":"100% 100%","MozTransform":"rotate(-15deg)","WebkitTransform":"rotate(-15deg)"});
},_transformArrowBody:function(){
this.angle=90-(180/Math.PI)*Math.atan((this.x1-this.x2)/(this.y1-this.y2));
if(isNaN(this.angle)){
this.angle=0;
}
if(this.y2<=this.y1){
this.angle=this.angle+180;
}
this.length=Math.sqrt(Math.pow(this.x1-this.x2,2)+Math.pow(this.y1-this.y2,2));
dojo.style(this.shapeNode,{"left":this.x1+"px","top":this.y1+"px","width":this.length+"px","MozTransformOrigin":"0 0","WebkitTransformOrigin":"0 0","MozTransform":"rotate("+this.angle+"deg)","WebkitTransform":"rotate("+this.angle+"deg)"});
},_transformArrowhead:function(){
dojo.style(this._triangle.left,{"left":this.length-17+"px"});
dojo.style(this._triangle.right,{"left":this.length-17+"px"});
}});
});
},"davinci/review/drawing/tools/scaffolds/ArrowScaffold":function(){
define(["dojo/_base/declare","./_ScaffoldCommon"],function(_15,_16){
return _15("davinci.review.drawing.tools.scaffolds.ArrowScaffold",_16,{constructor:function(_17){
this.tailHandler=this._createHandler("sw");
this.headHandler=this._createHandler("ne");
this._evtConns=[dojo.connect(this.tailHandler,"mousedown",this,"onHandlerMouseDown"),dojo.connect(this.headHandler,"mousedown",this,"onHandlerMouseDown")];
},createShape:function(x,y,_18){
this.shape=new davinci.review.drawing.shapes.Arrow(this.surface,x,y,x+1,y+1,_18);
this.inherited(arguments);
return this.shape;
},transformShape:function(x,y){
if(this.shape){
this.shape.x2=x;
this.shape.y2=y;
}
this.inherited(arguments);
},wrapShape:function(_19,_1a){
this.inherited(arguments);
dojo.style(this.tailHandler,{"left":_19.x1-3+"px","top":_19.y1-3+"px"});
dojo.style(this.headHandler,{"left":_19.x2-3+"px","top":_19.y2-3+"px"});
if(!_1a){
this.surface.appendChild(this.tailHandler);
this.surface.appendChild(this.headHandler);
}
},destroy:function(){
dojo.destroy(this.tailHandler);
dojo.destroy(this.headHandler);
this.tailHandler=this.headHandler=null;
this.inherited(arguments);
},onHandlerMouseMove:function(evt){
if(this.activeHandler.position=="sw"){
this.shape.x1=evt.pageX;
this.shape.y1=evt.pageY;
}else{
this.shape.x2=evt.pageX;
this.shape.y2=evt.pageY;
}
this.inherited(arguments);
}});
});
},"davinci/review/Color":function(){
define({colors:["firebrick","darkblue","darkgreen","purple","darkorange","darkgoldenrod","brown","darkgrey","darkcyan","deeppink"]});
},"davinci/review/actions/OpenVersionAction":function(){
define(["dojo/_base/declare","./_ReviewNavigatorCommon","davinci/Runtime","dojox/widget/Toaster","dojo/i18n!./nls/actions"],function(_1b,_1c,_1d,_1e,nls){
var _1f=_1b("davinci.review.actions.OpenVersionAction",[_1c],{run:function(_20){
var _21=this._getSelection(_20);
if(!_21||!_21.length){
return;
}
var _22=_21[0].resource.elementType=="ReviewFile"?_21[0].resource.parent:_21[0].resource;
dojo.xhrGet({url:"cmd/managerVersion",sync:false,handleAs:"text",content:{"type":"open","vTime":_22.timeStamp}}).then(function(_23){
if(_23=="OK"){
if(typeof hasToaster=="undefined"){
new _1e({position:"br-left",duration:4000,messageTopic:"/davinci/review/resourceChanged"});
hasToaster=true;
}
dojo.publish("/davinci/review/resourceChanged",[{message:nls.openSuccessful,type:"message"},"open",_22]);
}
});
},isEnabled:function(_24){
var _25=this._getSelection(_24);
if(!_25||_25.length==0){
return false;
}
var _26=_25[0].resource.elementType=="ReviewFile"?_25[0].resource.parent:_25[0].resource;
if(_26.designerId==_1d.userName){
if(_26.closed&&_26.closedManual&&!_26.isDraft){
return true;
}
}
return false;
}});
return _1f;
});
},"davinci/review/drawing/tools/scaffolds/RectangleScaffold":function(){
define(["dojo/_base/declare","./_ScaffoldCommon","davinci/review/drawing/shapes/Rectangle"],function(_27,_28,_29){
return _27("davinci.review.drawing.tools.scaffolds.RectangleScaffold",_28,{constructor:function(_2a){
this.nwh=this._createHandler("nw");
this.neh=this._createHandler("ne");
this.seh=this._createHandler("se");
this.swh=this._createHandler("sw");
this._evtConns=[dojo.connect(this.nwh,"mousedown",this,"onHandlerMouseDown"),dojo.connect(this.neh,"mousedown",this,"onHandlerMouseDown"),dojo.connect(this.seh,"mousedown",this,"onHandlerMouseDown"),dojo.connect(this.swh,"mousedown",this,"onHandlerMouseDown")];
},createShape:function(x,y,_2b){
this.shape=new _29(this.surface,x,y,x+1,y+1,_2b);
this.anchorPoint={x:x,y:y};
this.inherited(arguments);
return this.shape;
},transformShape:function(x,y){
this._transform(x,y);
this.inherited(arguments);
},wrapShape:function(_2c,_2d){
this.inherited(arguments);
dojo.style(this.nwh,{"left":_2c.x1+"px","top":_2c.y1+"px"});
dojo.style(this.neh,{"left":_2c.x2+"px","top":_2c.y1+"px"});
dojo.style(this.seh,{"left":_2c.x2+"px","top":_2c.y2+"px"});
dojo.style(this.swh,{"left":_2c.x1+"px","top":_2c.y2+"px"});
if(!_2d){
this.surface.appendChild(this.nwh);
this.surface.appendChild(this.neh);
this.surface.appendChild(this.seh);
this.surface.appendChild(this.swh);
}
},destroy:function(){
dojo.destroy(this.nwh);
dojo.destroy(this.neh);
dojo.destroy(this.seh);
dojo.destroy(this.swh);
this.inherited(arguments);
},onHandlerMouseMove:function(evt){
this._transform(evt.pageX,evt.pageY);
this.inherited(arguments);
},_transform:function(x,y){
var _2e=this.anchorPoint,_2f=this.shape;
if(_2e.x<x&&_2e.y<y){
this.anchorPoint={x:_2f.x1,y:_2f.y1};
_2f.x2=x;
_2f.y2=y;
}else{
if(_2e.x>x&&_2e.y<y){
this.anchorPoint={x:_2f.x2,y:_2f.y1};
_2f.x1=x;
_2f.y2=y;
}else{
if(_2e.x>x&&_2e.y>y){
this.anchorPoint={x:_2f.x2,y:_2f.y2};
_2f.x1=x;
_2f.y1=y;
}else{
if(_2e.x<x&&_2e.y>y){
this.anchorPoint={x:_2f.x1,y:_2f.y2};
_2f.x2=x;
_2f.y1=y;
}
}
}
}
}});
});
},"davinci/review/drawing/tools/SelectTool":function(){
define(["dojo/_base/declare","./_ToolCommon","./scaffolds/scaffolds","../shapes/shapes"],function(_30,_31,_32,_33){
return _30("davinci.review.drawing.tools.SelectTool",_31,{constructor:function(_34,_35){
_34.selectTool=this;
},hasPermission:function(_36){
var _37=this.surface,_38=this.filterAttributes;
return dojo.every(_38,function(_39){
return _36[_39]&&_37[_39]&&_36[_39]==_37[_39];
});
},selectShape:function(_3a,_3b,_3c){
this.deselectShape();
this.shape=_3a;
if(!_3b){
if(_3a.isInstanceOf(_33.Arrow)){
this.scaffold=new _32.ArrowScaffold(this.surface);
}else{
if(_3a.isInstanceOf(_33.Rectangle)){
this.scaffold=new _32.RectangleScaffold(this.surface);
}else{
if(_3a.isInstanceOf(_33.Ellipse)){
this.scaffold=new _32.EllipseScaffold(this.surface);
}else{
if(_3a.isInstanceOf(_33.Text)){
this.scaffold=new _32.TextScaffold(this.surface);
}else{
new Error("Invalid shape type!");
}
}
}
}
}
this.scaffold.wrapShape(_3a,_3b,_3c);
dojo.publish("/davinci/review/drawing/selectshape",[_3a,this.surface]);
},deselectShape:function(){
if(this.scaffold){
this.scaffold.destroy();
}
var _3d=this.shape;
this.scaffold=this.shape=null;
dojo.publish("/davinci/review/drawing/deselectshape",[_3d,this.surface]);
},removeShape:function(){
if(this.scaffold){
this.scaffold.removeShape();
}
this.deselectShape();
},activate:function(){
this._evtSubs=[dojo.subscribe("/davinci/review/drawing/shapemouseover",this,"_onShapeMouseOver"),dojo.subscribe("/davinci/review/drawing/shapemouseout",this,"_onShapeMouseOut"),dojo.subscribe("/davinci/review/drawing/shapemousedown",this,"_onShapeMouseDown")];
this._evtConns=[dojo.connect(this.surface.domNode,"mousedown",this,"deselectShape")];
},_onShapeMouseOver:function(_3e,evt,_3f){
if(this.surface===_3f&&!this.surface.isDrawing&&!_3e.editable&&this.hasPermission(_3e)){
_3e.style({"cursor":"move"});
}
},_onShapeMouseOut:function(_40,evt,_41){
if(this.surface===_41&&!this.surface.isDrawing&&!_40.editable&&this.hasPermission(_40)){
_40.style({"cursor":""});
}
},_onShapeMouseDown:function(_42,evt,_43){
if(this.surface===_43&&!this.surface.isDrawing&&!_42.editable&&this.hasPermission(_42)){
dojo.stopEvent(evt);
this.selectShape(_42,false,{x:evt.pageX,y:evt.pageY});
}
},deactivate:function(){
this.deselectShape();
this.inherited(arguments);
}});
});
},"davinci/review/drawing/shapes/_ShapeCommon":function(){
define("davinci/review/drawing/shapes/_ShapeCommon",["dojo/_base/declare"],function(_44){
return _44("davinci.review.drawing.shapes._ShapeCommon",null,{constructor:function(_45,x1,y1,x2,y2,_46){
this.surface=_45;
this.x1=x1||0;
this.y1=y1||0;
this.x2=x2||0;
this.y2=y2||0;
this._evtConns=[];
if(_46.a2c&&typeof _46.a2c=="function"){
this.color=_46.a2c(_46.colorAlias);
delete _46.a2c;
}
this.attributeMap=_46;
dojo.mixin(this,_46);
if(!this.color){
this.color="black";
}
},setVisible:function(_47){
if(_47=="visible"){
this.style({"visibility":"visible","opacity":"1.0"});
}else{
if(_47=="partial"){
this.style({"visibility":"visible","opacity":"0.1"});
}else{
if(_47=="hidden"){
this.style({"visibility":"hidden","opacity":"1.0"});
}
}
}
},style:function(_48){
var _49=this.surface&&this.surface.context;
if(!_49||!_49._domIsReady){
return;
}
if(this.shapeNode&&this.shapeNode.ownerDocument&&this.shapeNode.ownerDocument.defaultView){
dojo.style(this.shapeNode,_48);
}else{
console.error("this.shapeNode.ownerDocument.defaultView has no value");
}
},render:function(){
this.surface.appendChild(this.shapeNode);
this.style({"zIndex":"1000255"});
},destroy:function(){
dojo.forEach(this._evtConns,dojo.disconnect);
dojo.destroy(this.shapeNode);
this.shapeNode=null;
this.surface=null;
},onMouseOver:function(evt){
if(!this.surface.isDrawing){
evt.stopPropagation();
}
dojo.publish("/davinci/review/drawing/shapemouseover",[this,evt,this.surface]);
},onMouseOut:function(evt){
if(!this.surface.isDrawing){
evt.stopPropagation();
}
dojo.publish("/davinci/review/drawing/shapemouseout",[this,evt,this.surface]);
},onMouseDown:function(evt){
if(!this.surface.isDrawing){
evt.stopPropagation();
}
dojo.publish("/davinci/review/drawing/shapemousedown",[this,evt,this.surface]);
}});
});
},"davinci/review/drawing/tools/scaffolds/scaffolds":function(){
define(["dojo/_base/declare","./ArrowScaffold","./RectangleScaffold","./EllipseScaffold","./TextScaffold"],function(_4a,_4b,_4c,_4d,_4e){
var _4f={};
_4f.ArrowScaffold=_4b;
_4f.RectangleScaffold=_4c;
_4f.EllipseScaffold=_4d;
_4f.TextScaffold=_4e;
return dojo.setObject("davinci.review.drawing.tools.scaffolds",_4f);
});
},"davinci/review/drawing/tools/scaffolds/TextScaffold":function(){
define(["dojo/_base/declare","./_ScaffoldCommon","davinci/review/drawing/shapes/Text"],function(_50,_51,_52){
return _50("davinci.review.drawing.tools.scaffolds.TextScaffold",_51,{constructor:function(_53){
this.nwh=this._createHandler("nw");
this.neh=this._createHandler("ne");
this.seh=this._createHandler("se");
this.swh=this._createHandler("sw");
this._evtConns=[dojo.connect(this.nwh,"mousedown",this,"onHandlerMouseDown"),dojo.connect(this.neh,"mousedown",this,"onHandlerMouseDown"),dojo.connect(this.seh,"mousedown",this,"onHandlerMouseDown"),dojo.connect(this.swh,"mousedown",this,"onHandlerMouseDown")];
},createShape:function(x,y,_54){
this.shape=new _52(this.surface,x,y,x+1,y+1,_54);
this.anchorPoint={x:x,y:y};
this.inherited(arguments);
return this.shape;
},getEditMode:function(){
this.shape.getEditMode();
},transformShape:function(x,y){
this._transform(x,y);
this.inherited(arguments);
},wrapShape:function(_55,_56){
this.inherited(arguments);
dojo.style(this.nwh,{"left":_55.x1-0.5+"px","top":_55.y1-0.5+"px"});
dojo.style(this.neh,{"left":_55.x2-0.5+"px","top":_55.y1-0.5+"px"});
dojo.style(this.seh,{"left":_55.x2-0.5+"px","top":_55.y2-0.5+"px"});
dojo.style(this.swh,{"left":_55.x1-0.5+"px","top":_55.y2-0.5+"px"});
if(!_56){
this.surface.appendChild(this.nwh);
this.surface.appendChild(this.neh);
this.surface.appendChild(this.seh);
this.surface.appendChild(this.swh);
}
},destroy:function(){
dojo.destroy(this.nwh);
dojo.destroy(this.neh);
dojo.destroy(this.seh);
dojo.destroy(this.swh);
this.inherited(arguments);
},onHandlerMouseMove:function(evt){
this._transform(evt.pageX,evt.pageY);
this.inherited(arguments);
},_transform:function(x,y){
var _57=this.anchorPoint,_58=this.shape;
if(_57.x<x&&_57.y<y){
this.anchorPoint={x:_58.x1,y:_58.y1};
_58.x2=x;
_58.y2=y;
}else{
if(_57.x>x&&_57.y<y){
this.anchorPoint={x:_58.x2,y:_58.y1};
_58.x1=x;
_58.y2=y;
}else{
if(_57.x>x&&_57.y>y){
this.anchorPoint={x:_58.x2,y:_58.y2};
_58.x1=x;
_58.y1=y;
}else{
if(_57.x<x&&_57.y>y){
this.anchorPoint={x:_58.x1,y:_58.y2};
_58.x2=x;
_58.y1=y;
}
}
}
}
}});
});
},"davinci/review/editor/Context":function(){
define(["dojo/_base/declare","dojo/_base/connect","../drawing/Surface","../drawing/tools/CreateTool","../drawing/tools/ExchangeTool","../drawing/tools/HighlightTool","../drawing/tools/SelectTool","../../Runtime","davinci/XPathUtils","davinci/maqetta/AppStates","../../UserActivityMonitor","../Review","../../ve/Context","preview/silhouetteiframe"],function(_59,_5a,_5b,_5c,_5d,_5e,_5f,_60,_61,_62,_63,_64,_65,_66){
var _67=_62.prototype;
return _59("davinci.review.editor.Context",[_65],{setSource:function(){
var _68=this.containerNode;
var _69=this.resourceFile.parent;
if(!_69.width){
_68.style.overflowX="hidden";
}
if(!_69.height){
_68.style.overflowY="hidden";
}
if(!this.frame){
var _6a=this.baseURL;
if(this.getPreference("zazl")){
_6a+="?zazl=true";
}
this.frame=dojo.create("iframe",dojo.mixin(this.iframeattrs,{style:{border:"0",width:_69.width&&_69.height?_69.width+"px":"100%",height:_69.width&&_69.height?_69.height+"px":"100%"},src:_6a,onload:function(_6b){
this._domIsReady=true;
var _6c=_6b&&_6b.target&&_6b.target.contentDocument;
var _6d=_6c&&_6c.defaultView&&_6c.defaultView.window;
var _6e=this.frame.contentDocument.body.getAttribute("data-maq-device");
var _6f=this.frame.contentDocument.body.getAttribute("data-maqetta-device");
if(!_6e&&_6f){
_6e=_6f;
}
var _70=null;
if(_6e&&_6e!="none"&&_6e!="desktop"){
_70="app/preview/images/"+_6e+".svg";
_6d.require&&_6d.require("dojo/ready")(function(){
var _71=_6d.require("dojox/mobile/deviceTheme");
_71.loadDeviceTheme(_66.getMobileTheme(_70));
});
}
_5a.subscribe("/davinci/scene/selectionChanged",this,function(_72,_73){
if(!_60.currentEditor||_60.currentEditor.editorID!="davinci.review.CommentReviewEditor"){
return;
}
if(this._commentView){
this._commentView.updateStatesScenes();
}
});
_6d.require&&_6d.require(["dojo/_base/connect"],function(_74){
_74.subscribe("/maqetta/appstates/state/changed",this,function(_75){
if(!_75||!_60.currentEditor||_60.currentEditor.declaredClass!="davinci.review.editor.ReviewEditor"){
return;
}
var dv=_6d.davinci;
if(dv&&dv.states&&dv.states.setState){
if(this._commentView){
this._commentView.updateStatesScenes();
}
var _76=dojo.clone(_75);
_76.editorClass="davinci.review.editor.ReviewEditor";
_5a.publish("/maqetta/appstates/state/changed",[_76]);
}
});
}.bind(this));
this.rootNode=this.rootWidget=this.frame.contentDocument.body;
var _77=_67.getFocus(this.rootNode);
if(!_77){
var _78=_67.getAllStateContainers(this.rootNode);
if(_78.length>0){
var _79=_67.getInitial(_78[0]);
_67.setState(_79,_78[0],{focus:true,updateWhenCurrent:true});
}
}
this._initDrawing();
_5a.publish("/davinci/review/context/loaded",[this,this.fileName]);
var _7a=[].concat(this._cxtConns,_63.addInActivityMonitor(this.frame.contentDocument));
this._cxtConns=_7a;
this.containerEditor.silhouetteiframe.setSVGFilename(_70);
this._statesLoaded=true;
_5a.publish("/davinci/ui/context/statesLoaded",[this]);
if(this.surface){
this._refreshSurface(this.surface);
}
}.bind(this)}),_68);
}
},getSelection:function(){
return [];
},select:function(){
},_initDrawing:function(){
var doc=this.frame.contentDocument,_7b;
if(!this.surface){
_7b=this.surface=new _5b(doc.body,doc,this);
new _5c(_7b,["commentId"]);
new _5f(_7b,["commentId"]).activate();
new _5d(_7b,["commentId"]);
new _5e(_7b).activate();
}else{
_7b=this.surface;
}
this._cxtConns=[_5a.connect(_7b.highlightTool,"onShapeMouseDown",function(_7c){
_5a.publish("/davinci/review/drawing/annotationSelected",[_7c.commentId]);
}),_5a.connect(this.getContainerNode(),"click",dojo.hitch(this,function(evt){
if(!this.containerEditor.isDirty&&evt.target===this.getContainerNode()){
_5a.publish("/davinci/review/view/canvasFocused",[this]);
}
}))];
this._cxtSubs=[_5a.subscribe(this.fileName+"/davinci/review/drawing/addShape",function(_7d,_7e,_7f){
this.surface.exchangeTool.importShapes(_7d,_7e,dojo.hitch(_64,_64.getColor));
}.bind(this)),_5a.subscribe(this.fileName+"/davinci/review/drawing/enableEditing",this,function(_80,_81,_82){
var _83=_82.pageState;
var _84=_82.pageStateList;
var _85=_82.viewScene;
var _86=_82.viewSceneList;
var _87=this.surface;
_87.activate();
_87.cached=_87.exchangeTool.exportShapesByAttribute();
_87.currentReviewerEmail=_80;
_87.commentId=_81;
_87.filterState=_83;
_87.filterStateList=_84;
_87.filterScene=_85;
_87.filterSceneList=_86;
_87.filterComments=[_81];
this._refreshSurface(_87);
}),_5a.subscribe(this.fileName+"/davinci/review/drawing/getShapesInEditing",this,function(obj,_88){
if(obj._currentPage!=this.fileName){
return;
}
var _89=_88.state;
var _8a=_88.stateList;
var _8b=_88.scene;
var _8c=_88.sceneList;
var _8d=this.surface;
_8d.selectTool.deselectShape();
_8d.setValueByAttribute("commentId",_8d.commentId,"state",_89);
_8d.setValueByAttribute("commentId",_8d.commentId,"stateList",_8a);
_8d.setValueByAttribute("commentId",_8d.commentId,"scene",_8b);
_8d.setValueByAttribute("commentId",_8d.commentId,"sceneList",_8c);
obj.drawingJson=_8d.exchangeTool.exportShapesByAttribute("commentId",[_8d.commentId]);
_8d.deactivate();
_8d.commentId="";
}),_5a.subscribe(this.fileName+"/davinci/review/drawing/cancelEditing",this,function(){
var _8e=this.surface;
_8e.exchangeTool.importShapes(_8e.cached,true,dojo.hitch(_64,_64.getColor));
_8e.deactivate();
this._refreshSurface(_8e);
_8e.commentId="";
}),_5a.subscribe(this.fileName+"/davinci/review/drawing/filter",this,function(_8f,_90){
var _91=this.surface;
var _92=_67.getFocus(this.rootNode);
_91.filterState=_92?_92.state:undefined;
_91.filterStateList=this.getCurrentStates();
_91.filterScene=this.getCurrentScene();
_91.filterSceneList=this.getCurrentScenes();
_91.filterComments=_90;
this._refreshSurface(_91);
}),_5a.subscribe(this.fileName+"/davinci/review/drawing/setShownColorAliases",this,function(_93){
var _94=this.surface;
_94.filterColorAliases=_93;
this._refreshSurface(_94);
}),_5a.subscribe("/davinci/review/view/openComment",this,function(){
if(_60.currentEditor===this.containerEditor){
this.containerEditor.isDirty=true;
if(this.containerEditor.editorContainer){
this.containerEditor.editorContainer.setDirty(true);
}
}
}),_5a.subscribe("/davinci/review/view/closeComment",this,function(){
if(_60.currentEditor===this.containerEditor){
this.containerEditor.isDirty=false;
if(this.containerEditor.editorContainer){
this.containerEditor.editorContainer.setDirty(false);
}
}
}),_5a.subscribe("/davinci/ui/editorSelected",this,function(obj){
if(obj.oldEditor!=null&&this===obj.oldEditor.getContext&&this===obj.oldEditor.getContext()){
try{
this.getDocument();
}
catch(err){
this._destroyDrawing();
}
}
})];
},_refreshSurface:function(_95){
var _96=this;
if(!this._domIsReady){
return;
}
function _97(_98,_99){
if(!_98||!_99){
return false;
}
if(!_96.stateSceneCheck(_98.stateList,_98.sceneList,_99.filterStateList,_99.filterSceneList)){
return true;
}
return false;
};
var _9a=_95.shapes,_9b;
dojo.forEach(_9a,function(_9c){
var _9d="hidden";
if(_60.singleUserMode()||dojo.some(_95.filterColorAliases,function(_9e){
if(_9c.colorAlias==_9e){
return true;
}else{
if(davinci&&davinci.review&&dojo.isArray(_60.reviewers)){
var _9f=_60.reviewers;
var _a0=false;
for(var i=0;i<_9f.length;i++){
if(_9e==_9f[i].email){
_a0=true;
break;
}
}
if(_a0){
if(_9c.colorAlias==_9f[i].email){
return true;
}
}
return false;
}
}
})){
if(_95.filterComments&&_95.filterComments.length>0){
if(dojo.some(_95.filterComments,function(_a1){
return _9c.commentId==_a1;
})){
_9d="visible";
_95.highlightTool&&(_95.highlightTool.shape=_9c);
}else{
_9d="partial";
}
if(_97(_9c,_95)){
_9d="hidden";
}
}else{
if(_97(_9c,_95)){
_9d="hidden";
}else{
_9d="visible";
}
}
}
if(_9c.commentId==_95.commentId){
_9d="visible";
}
_9c.setVisible(_9d);
});
},destroy:function(){
this._destroyDrawing();
},_destroyDrawing:function(){
try{
if(this.surface){
this.surface.destroy();
delete this.surface;
}
}
catch(err){
}
this._cxtConns.forEach(_5a.disconnect);
this._cxtSubs.forEach(_5a.unsubscribe);
},getCurrentStates:function(){
return _67.getAllCurrentStates(this.rootNode).map(function(_a2){
var _a3=_a2.stateContainerNode;
var id=_a3?_a3.id:"";
var _a4=_a3?_61.getXPath(_a3):"";
return {id:id,xpath:_a4,state:_a2.state};
});
},getCurrentScenes:function(){
var _a5=this.sceneManagers;
var _a6={};
for(var _a7 in _a5){
var sm=_a5[_a7];
if(sm.getAllSceneContainers&&sm.getCurrentScene){
_a6[sm.id]=sm.getAllSceneContainers().map(function(sc){
var _a8=sm.getCurrentScene(sc);
var _a9=(_a8&&_a8.id)?_a8.id:"";
var _aa=(_a8&&_a8.id)?_61.getXPath(_a8):"";
return {scId:sc.id,scXpath:_61.getXPath(sc),sceneId:_a9,sceneXpath:_aa};
});
}
}
return _a6;
},getCurrentScene:function(){
var _ab=this.sceneManagers;
for(var _ac in _ab){
var sm=_ab[_ac];
if(sm.getAllSceneContainers&&sm.getCurrentScene){
var _ad=sm.getAllSceneContainers();
for(var j=0;j<_ad.length;j++){
var sc=_ad[j];
var _ae=sm.getCurrentScene(sc);
var _af=(_ae&&_ae.id)?_ae.id:"";
return _af;
}
}
}
return;
},stateSceneCheck:function(_b0,_b1,_b2,_b3){
function _b4(val){
return !val?_67.NORMAL:val;
};
var i,obj,ref;
if(_b0&&_b2){
for(i=0;i<_b2.length;i++){
ref=_b2[i];
var _b5=_b4(ref.state);
obj=_b0[i];
var _b6=_b4(obj.state);
if(obj&&ref){
if(((obj.id&&obj.id===ref.id)||(obj.xpath&&obj.xpath===ref.xpath))&&_b6!==_b5){
return false;
}
}
}
}
if(_b1&&_b3){
for(var _b7 in _b3){
var _b8=_b3[_b7];
var _b9=_b1[_b7];
if(_b8&&_b9){
for(i=0;i<_b8.length;i++){
ref=_b8[i];
obj=_b9[i];
if(obj&&ref){
if(((obj&&obj.scId&&ref&&obj.scId===ref.scId)||(obj&&obj.scXpath&&ref&&obj.scXpath===ref.scXpath))&&((obj&&obj.sceneId&&ref&&obj.sceneId!==ref.sceneId)||(obj&&obj.sceneXpath&&ref&&obj.sceneXpath!==ref.sceneXpath))){
return false;
}
}
}
}
}
}
return true;
}});
});
},"davinci/review/drawing/tools/HighlightTool":function(){
define(["dojo/_base/declare","./_ToolCommon"],function(_ba,_bb){
return _ba("davinci.review.drawing.tools.HighlightTool",_bb,{constructor:function(_bc){
_bc.highlightTool=this;
},activate:function(){
if(this.activated){
return;
}
this._evtSubs=[dojo.subscribe("/davinci/review/drawing/shapemouseover",this,"_onShapeMouseOver"),dojo.subscribe("/davinci/review/drawing/shapemouseout",this,"_onShapeMouseOut"),dojo.subscribe("/davinci/review/drawing/shapemousedown",this,"_onShapeMouseDown")];
this.activated=true;
},_onShapeMouseOver:function(_bd,evt,_be){
if(this.surface!==_be||this.surface.isDrawing){
return;
}
var _bf=this.surface.shapes;
_bd.style({"cursor":"pointer"});
if(!this.shape){
_bd.style({"opacity":"0.5"});
}
},_onShapeMouseOut:function(_c0,evt,_c1){
if(this.surface!==_c1||this.surface.isDrawing){
return;
}
var _c2=this.surface.shapes;
_c0.style({"cursor":""});
if(!this.shape){
_c0.style({"opacity":"1.0"});
}
},_onShapeMouseDown:function(_c3,evt,_c4){
if(this.surface!==_c4||this.surface.isDrawing){
return;
}
if(this.shape===_c3){
_c3.style({"opacity":"0.5"});
this.shape=null;
}else{
_c3.style({"opacity":"1.0"});
this.shape=_c3;
}
this.onShapeMouseDown(_c3);
},onShapeMouseDown:function(_c5){
},deactivate:function(){
if(!this.activated){
return;
}
var _c6=this.surface.shapes;
if(this.shape){
dojo.forEach(_c6,function(_c7){
_c7.style({"opacity":"1.0","cursor":""});
});
}
dojo.forEach(this._evtSubs,dojo.unsubscribe);
this.shape=null;
this.activated=false;
}});
});
},"davinci/review/drawing/tools/ExchangeTool":function(){
define(["dojo/_base/declare","./_ToolCommon"],function(_c8,_c9){
return _c8("davinci.review.drawing.tools.ExchangeTool",_c9,{constructor:function(_ca){
_ca.exchangeTool=this;
},exportShapesByAttribute:function(_cb,_cc){
var _cd=this.surface.getShapesByAttribute(_cb,_cc),_ce,_cf=[],_d0;
dojo.forEach(_cd,function(_d1){
if(_d1.isInstanceOf(davinci.review.drawing.shapes.Arrow)){
_d0="Arrow";
}else{
if(_d1.isInstanceOf(davinci.review.drawing.shapes.Rectangle)){
_d0="Rectangle";
}else{
if(_d1.isInstanceOf(davinci.review.drawing.shapes.Ellipse)){
_d0="Ellipse";
}else{
if(_d1.isInstanceOf(davinci.review.drawing.shapes.Text)){
_d0="Text";
}else{
return;
}
}
}
}
var o={type:_d0,x1:_d1.x1,y1:_d1.y1,x2:_d1.x2,y2:_d1.y2};
for(var _d2 in _d1.attributeMap){
if(_d1.attributeMap.hasOwnProperty(_d2)){
var s=(_d2=="stateList"||_d2=="sceneList")?dojo.toJson(_d1[_d2]):_d1[_d2];
o[_d2]=s;
}
}
if(_d0=="Text"){
o.text=escape(_d1.getText());
}
_ce=dojo.toJson(o);
_cf.push(_ce);
});
return "["+_cf.join(",")+"]";
},importShapes:function(_d3,_d4,a2c){
try{
var _d5=eval(_d3),_d6,_d7;
if(_d4){
this.surface.clear();
}
dojo.forEach(_d5,function(s){
var _d8=s.type;
if(_d8=="Arrow"){
_d6=davinci.review.drawing.shapes.Arrow;
}else{
if(_d8=="Rectangle"){
_d6=davinci.review.drawing.shapes.Rectangle;
}else{
if(_d8=="Ellipse"){
_d6=davinci.review.drawing.shapes.Ellipse;
}else{
if(_d8=="Text"){
_d6=davinci.review.drawing.shapes.Text;
}else{
return;
}
}
}
}
var x1=s.x1,x2=s.x2,y1=s.y1,y2=s.y2,_d9=s.text;
delete s.type;
delete s.x1;
delete s.x2;
delete s.y1;
delete s.y2;
s.a2c=a2c;
if(s.stateList){
s.stateList=dojo.fromJson(s.stateList);
}
if(s.sceneList){
s.sceneList=dojo.fromJson(s.sceneList);
}
_d7=new _d6(this.surface,x1,y1,x2,y2,s);
_d7.filterAttributes=this.filterAttributes;
_d7.render();
if(_d8=="Text"){
_d7.setText(unescape(_d9));
}
this.surface.shapes.push(_d7);
},this);
}
catch(exp){
}
}});
});
},"davinci/review/drawing/tools/scaffolds/_ScaffoldCommon":function(){
define(["dojo/_base/declare"],function(_da){
return _da("davinci.review.drawing.tools.scaffolds._ScaffoldCommon",null,{constructor:function(_db){
this.surface=_db;
},createShape:function(x,y,_dc){
this.shape.render();
},transformShape:function(x,y){
if(this.shape){
this.shape.render();
}
},wrapShape:function(_dd,_de,_df){
this.shape=_dd;
if(!_de){
this._clickPoint=_df;
this._onShapeMouseDown();
}
},moveShape:function(dx,dy){
var _e0=this.shape;
_e0.x1+=dx;
_e0.y1+=dy;
_e0.x2+=dx;
_e0.y2+=dy;
_e0.render();
this.wrapShape(_e0,true);
},removeShape:function(){
this.surface.removeShape(this.shape);
this.destroy();
},onHandlerMouseMove:function(evt){
this.shape.render();
this.wrapShape(this.shape,true);
},destroy:function(){
dojo.forEach(this._evtConns,dojo.disconnect);
dojo.forEach(this._evtSubs,dojo.unsubscribe);
this.activeHandler=this.shape=this.surface=null;
},onHandlerMouseDown:function(evt){
var _e1=this.shape;
this.activeHandler=evt.target;
switch(this.activeHandler.position){
case "nw":
this.anchorPoint={x:_e1.x2,y:_e1.y2};
break;
case "ne":
this.anchorPoint={x:_e1.x1,y:_e1.y2};
break;
case "se":
this.anchorPoint={x:_e1.x1,y:_e1.y1};
break;
case "sw":
this.anchorPoint={x:_e1.x2,y:_e1.y1};
break;
}
dojo.stopEvent(evt);
this._mouseMoveHandler=dojo.connect(this.surface.domNode,"mousemove",this,"onHandlerMouseMove");
this._mouseUpHandler=dojo.connect(this.surface.domNode,"mouseup",this,"_onHandlerMouseUp");
},_onHandlerMouseUp:function(evt){
dojo.disconnect(this._mouseMoveHandler);
dojo.disconnect(this._mouseUpHandler);
},_onShapeMouseDown:function(){
this._mouseMoveHandler=dojo.connect(this.surface.domNode,"mousemove",this,"_onShapeMouseMove");
this._mouseUpHandler=dojo.connect(this.surface.domNode,"mouseup",this,"_onShapeMouseUp");
this._evtConns.push(dojo.connect(this.surface.domNode,"keydown",this,"_onShapeKeyDown"));
},_onShapeMouseMove:function(evt){
var dx=evt.pageX-this._clickPoint.x,dy=evt.pageY-this._clickPoint.y;
this._clickPoint.x=evt.pageX;
this._clickPoint.y=evt.pageY;
this.moveShape(dx,dy);
},_onShapeMouseUp:function(evt){
dojo.disconnect(this._mouseMoveHandler);
dojo.disconnect(this._mouseUpHandler);
},_onShapeKeyDown:function(evt){
if(this.shape.editable){
return;
}
dojo.stopEvent(evt);
switch(evt.keyCode){
case dojo.keys.ESCAPE:
this.destroy();
break;
case dojo.keys.DELETE:
case dojo.keys.BACKSPACE:
this.removeShape();
break;
case dojo.keys.LEFT_ARROW:
this.moveShape(-2,0);
break;
case dojo.keys.UP_ARROW:
this.moveShape(0,-2);
break;
case dojo.keys.RIGHT_ARROW:
this.moveShape(2,0);
break;
case dojo.keys.DOWN_ARROW:
this.moveShape(0,2);
break;
}
},_createHandler:function(_e2){
var _e3=dojo.create("div");
this.handlerRadius=3;
dojo.style(_e3,{"position":"absolute","padding":"0px","margin":"0px","border":"1px solid black","backgroundColor":"white","width":(this.handlerRadius-1)*2+"px","height":(this.handlerRadius-1)*2+"px","MozBorderRadius":this.handlerRadius+"px","WebkitBorderRadius":this.handlerRadius+"px","borderRadius":this.handlerRadius+"px","cursor":_e2+"-resize","zIndex":1000256});
_e3.position=_e2;
return _e3;
}});
});
},"davinci/review/drawing/tools/_ToolCommon":function(){
define(["dojo/_base/declare"],function(_e4){
return _e4("davinci.review.drawing.tools._ToolCommon",null,{constructor:function(_e5,_e6){
this.surface=_e5;
this.filterAttributes=_e6||[];
},setFilterAttributes:function(_e7){
this.filterAttributes=filterAttributes||[];
},activate:function(){
},deactivate:function(){
dojo.forEach(this._evtSubs,dojo.unsubscribe);
dojo.forEach(this._evtConns,dojo.disconnect);
},destroy:function(){
dojo.forEach(this._evtSubs,dojo.unsubscribe);
dojo.forEach(this._evtConns,dojo.disconnect);
this.surface=null;
}});
});
},"davinci/review/drawing/tools/CreateTool":function(){
define(["dojo/_base/declare","./_ToolCommon","./scaffolds/scaffolds"],function(_e8,_e9,_ea){
return _e8("davinci.review.drawing.tools.CreateTool",_e9,{constructor:function(_eb,_ec){
_eb.createTool=this;
},setShape:function(_ed,_ee){
if(this.surface.isDrawing){
return;
}
this.shapeAttributeMap=_ee;
if(this.scaffold){
this.scaffold.destroy();
}
switch(_ed){
case "Arrow":
this.scaffold=new _ea.ArrowScaffold(this.surface);
this.scaffold.type="arrow";
break;
case "Rectangle":
this.scaffold=new _ea.RectangleScaffold(this.surface);
this.scaffold.type="rectangle";
break;
case "Ellipse":
this.scaffold=new _ea.EllipseScaffold(this.surface);
this.scaffold.type="ellipse";
break;
case "Text":
this.scaffold=new _ea.TextScaffold(this.surface);
this.scaffold.type="text";
break;
default:
new Error("Invalid shape type!");
}
},activate:function(){
if(this.surface.isDrawing){
return;
}
this.surface.isDrawing=true;
var _ef=this.surface.docNode=this.surface.domNode;
var _f0=this.surface.htmlNode=_ef.documentElement;
var _f1=this.surface.bodyNode=_ef.body;
var _f2=this.surface.coverDiv=dojo.create("div",{style:"z-index:2000000;cursor:crosshair;position:absolute; left:0px; top:0px; width:"+_f0.offsetWidth+"px; height:"+_f0.offsetHeight+"px;"},_f1);
this._evtConns=[dojo.connect(_f2,"mousedown",this,"_mouseDown"),dojo.connect(_ef,"keydown",this,"_keyDown")];
},_mouseDown:function(evt){
dojo.stopEvent(evt);
this.surface.appendShape(this.scaffold.createShape(evt.pageX,evt.pageY,this.shapeAttributeMap));
if(this.scaffold.type=="text"){
this.scaffold.shape.filterAttributes=this.filterAttributes;
}
this._evtConns.push(dojo.connect(this.surface.coverDiv,"mouseup",this,"_mouseUp"),dojo.connect(this.surface.coverDiv,"mousemove",this,"_mouseMove"));
},_mouseUp:function(evt){
if(this.scaffold.getEditMode){
this.scaffold.getEditMode();
}
this.deactivate();
},_mouseMove:function(evt){
if(!this.surface.isDrawing){
return;
}
this.scaffold.transformShape(evt.pageX,evt.pageY);
},_keyDown:function(evt){
if(evt.keyCode==dojo.keys.ESCAPE){
this.deactivate();
}
},deactivate:function(){
if(!this.surface||!this.surface.isDrawing){
return;
}
this.surface.isDrawing=false;
this.scaffold.destroy();
this.scaffold=null;
this.inherited(arguments);
var _f3=this.surface.coverDiv;
if(_f3){
var _f4=_f3.parentNode;
if(_f4){
_f4.removeChild(_f3);
}
this.surface.coverDiv=null;
}
}});
});
},"davinci/review/actions/EditVersionAction":function(){
define(["dojo/_base/declare","./_ReviewNavigatorCommon","./PublishAction","../../Runtime","dojox/widget/Toaster","dojo/i18n!./nls/actions"],function(_f5,_f6,_f7,_f8,_f9,nls){
return _f5("davinci.review.actions.EditVersionAction",[_f6],{run:function(_fa){
var _fb=this._getSelection(_fa);
if(!_fb||!_fb.length){
return;
}
var _fc=_fb[0].resource.elementType=="ReviewFile"?_fb[0].resource.parent:_fb[0].resource;
var _fd=new _f7(_fc);
_fd.run();
},isEnabled:function(_fe){
var _ff=this._getSelection(_fe);
if(_ff&&_ff.length>0){
var item=_ff[0].resource.elementType=="ReviewFile"?_ff[0].resource.parent:_ff[0].resource;
if(item.designerId==_f8.userName){
return true;
}
}
return false;
}});
});
},"davinci/review/drawing/tools/scaffolds/EllipseScaffold":function(){
define(["dojo/_base/declare","./_ScaffoldCommon","davinci/review/drawing/shapes/Ellipse"],function(_100,_101,_102){
return _100("davinci.review.drawing.tools.scaffolds.EllipseScaffold",_101,{constructor:function(_103){
this.nwh=this._createHandler("nw");
this.neh=this._createHandler("ne");
this.seh=this._createHandler("se");
this.swh=this._createHandler("sw");
this._evtConns=[dojo.connect(this.nwh,"mousedown",this,"onHandlerMouseDown"),dojo.connect(this.neh,"mousedown",this,"onHandlerMouseDown"),dojo.connect(this.seh,"mousedown",this,"onHandlerMouseDown"),dojo.connect(this.swh,"mousedown",this,"onHandlerMouseDown")];
},createShape:function(x,y,_104){
this.shape=new _102(this.surface,x,y,x+1,y+1,_104);
this.anchorPoint={x:x,y:y};
this.inherited(arguments);
return this.shape;
},transformShape:function(x,y){
this._transform(x,y);
this.inherited(arguments);
},wrapShape:function(_105,_106){
this.inherited(arguments);
dojo.style(this.nwh,{"left":_105.x1+"px","top":_105.y1+"px"});
dojo.style(this.neh,{"left":_105.x2+"px","top":_105.y1+"px"});
dojo.style(this.seh,{"left":_105.x2+"px","top":_105.y2+"px"});
dojo.style(this.swh,{"left":_105.x1+"px","top":_105.y2+"px"});
if(!_106){
this.surface.appendChild(this.nwh);
this.surface.appendChild(this.neh);
this.surface.appendChild(this.seh);
this.surface.appendChild(this.swh);
}
},destroy:function(){
dojo.destroy(this.nwh);
dojo.destroy(this.neh);
dojo.destroy(this.seh);
dojo.destroy(this.swh);
this.inherited(arguments);
},onHandlerMouseMove:function(evt){
this._transform(evt.pageX,evt.pageY);
this.inherited(arguments);
},_transform:function(x,y){
var _107=this.anchorPoint,_108=this.shape;
if(_107.x<x&&_107.y<y){
this.anchorPoint={x:_108.x1,y:_108.y1};
_108.x2=x;
_108.y2=y;
}else{
if(_107.x>x&&_107.y<y){
this.anchorPoint={x:_108.x2,y:_108.y1};
_108.x1=x;
_108.y2=y;
}else{
if(_107.x>x&&_107.y>y){
this.anchorPoint={x:_108.x2,y:_108.y2};
_108.x1=x;
_108.y1=y;
}else{
if(_107.x<x&&_107.y>y){
this.anchorPoint={x:_108.x1,y:_108.y2};
_108.x2=x;
_108.y1=y;
}
}
}
}
}});
});
},"davinci/review/drawing/shapes/Text":function(){
define(["dojo/_base/declare","./_ShapeCommon"],function(_109,_10a){
return _109("davinci.review.drawing.shapes.Text",_10a,{render:function(){
if(!this.shapeNode){
this._createEditArea();
this._evtConns.push(dojo.connect(this.shapeNode,"mouseover",this,"onMouseOver"),dojo.connect(this.shapeNode,"mouseout",this,"onMouseOut"),dojo.connect(this.shapeNode,"mousedown",this,"onMouseDown"),dojo.connect(this.shapeNode,"dblclick",this,"_onDoubleClick"),dojo.connect(this.shapeNode,"blur",this,"_onblur"));
}
this._transformTextArea();
this.inherited(arguments);
},setText:function(text){
this.shapeNode.innerHTML=text;
},getText:function(){
return this.shapeNode.innerHTML.replace(/"/g,"'");
},getEditMode:function(){
if(!this.surface.isActivated){
return;
}
this.editable=true;
dojo.attr(this.shapeNode,"contenteditable","true");
dojo.style(this.shapeNode,"cursor","");
this.shapeNode.focus();
},_createEditArea:function(){
this.shapeNode=dojo.create("div");
this.width=Math.abs(this.x1-this.x2);
this.height=Math.abs(this.y1-this.y2);
dojo.style(this.shapeNode,{"position":"absolute","padding":"2px","margin":"0px","border":"1px dotted black","overflow":"hidden","color":this.color,"width":this.width+"px","height":this.height+"px"});
},_transformTextArea:function(){
this.width=Math.abs(this.x1-this.x2);
this.height=Math.abs(this.y1-this.y2);
dojo.style(this.shapeNode,{"left":this.x1+"px","top":this.y1+"px","width":this.width+"px","height":this.height+"px"});
},_onDoubleClick:function(evt){
if(!this.surface.isActivated||!this.isReadOnly()){
return;
}
this.editable=true;
dojo.attr(this.shapeNode,"contenteditable","true");
dojo.style(this.shapeNode,"cursor","");
this.shapeNode.focus();
},_onblur:function(evt){
if(!this.surface.isActivated){
return;
}
this.editable=false;
dojo.attr(this.shapeNode,"contenteditable","false");
dojo.style(this.shapeNode,"cursor","auto");
},isReadOnly:function(){
var _10b=this.surface,_10c=this.filterAttributes;
return dojo.every(_10c,function(attr){
return this[attr]&&_10b[attr]&&this[attr]==_10b[attr];
},this);
}});
});
},"davinci/review/drawing/shapes/Rectangle":function(){
define(["dojo/_base/declare","./_ShapeCommon"],function(_10d,_10e){
return _10d("davinci.review.drawing.shapes.Rectangle",_10e,{render:function(){
if(!this.shapeNode){
this._createRectangle();
this._evtConns.push(dojo.connect(this.shapeNode,"mouseover",this,"onMouseOver"),dojo.connect(this.shapeNode,"mouseout",this,"onMouseOut"),dojo.connect(this.shapeNode,"mousedown",this,"onMouseDown"));
}
this._transformRectangle();
this.inherited(arguments);
},_createRectangle:function(){
this.shapeNode=dojo.create("div");
this.width=Math.abs(this.x1-this.x2);
this.height=Math.abs(this.y1-this.y2);
dojo.style(this.shapeNode,{"position":"absolute","padding":"0px","margin":"0px","border":"2px solid "+this.color,"width":this.width+"px","height":this.height+"px","MozBorderRadius":"10px","WebkitBorderRadius":"10px","borderRadius":"10px"});
dojo.style(dojo.create("div",null,this.shapeNode),{"padding":"0px","margin":"0px","border":"none","width":"100%","height":"100%","backgroundColor":this.color,"opacity":"0.05","MozBorderRadius":"6px","WebkitBorderRadius":"6px","borderRadius":"6px"});
},_transformRectangle:function(){
this.width=Math.abs(this.x1-this.x2);
this.height=Math.abs(this.y1-this.y2);
dojo.style(this.shapeNode,{"left":this.x1+"px","top":this.y1+"px","width":this.width+"px","height":this.height+"px"});
}});
});
},"davinci/review/drawing/shapes/Ellipse":function(){
define(["dojo/_base/declare","./_ShapeCommon"],function(_10f,_110){
return _10f("davinci.review.drawing.shapes.Ellipse",_110,{render:function(){
if(!this.shapeNode){
this._createEllipse();
this._evtConns.push(dojo.connect(this.shapeNode,"mouseover",this,"onMouseOver"),dojo.connect(this.shapeNode,"mouseout",this,"onMouseOut"),dojo.connect(this.shapeNode,"mousedown",this,"onMouseDown"));
}
this._transformEllipse();
this.inherited(arguments);
},destroy:function(){
this._innerEllipse=null;
this.inherited(arguments);
},_createEllipse:function(){
this.shapeNode=dojo.create("div");
var _111=this.width=Math.abs(this.x1-this.x2),_112=this.height=Math.abs(this.y1-this.y2),_113=this.radius=(_111/2+1)+"px "+(_112/2+1)+"px",_114=(_111/2-1)+"px "+(_112/2-1)+"px";
dojo.style(this.shapeNode,{"position":"absolute","padding":"0px","margin":"0px","border":"2px solid "+this.color,"width":_111+"px","height":_112+"px","borderTopLeftRadius":_113,"borderTopRightRadius":_113,"borderBottomLeftRadius":_113,"borderBottomRightRadius":_113,"MozBorderRadiusTopleft":_113,"MozBorderRadiusTopright":_113,"MozBorderRadiusBottomleft":_113,"MozBorderRadiusBottomright":_113,"WebkitBorderTopLeftRadius":_113,"WebkitBorderTopRightRadius":_113,"WebkitBorderBottomLeftRadius":_113,"WebkitBorderBottomRightRadius":_113});
this._innerEllipse=dojo.create("div",null,this.shapeNode);
dojo.style(this._innerEllipse,{"padding":"0px","margin":"0px","border":"none","width":"100%","height":"100%","backgroundColor":this.color,"opacity":"0.05","borderTopLeftRadius":_114,"borderTopRightRadius":_114,"borderBottomLeftRadius":_114,"borderBottomRightRadius":_114,"MozBorderRadiusTopleft":_114,"MozBorderRadiusTopright":_114,"MozBorderRadiusBottomleft":_114,"MozBorderRadiusBottomright":_114,"WebkitBorderTopLeftRadius":_114,"WebkitBorderTopRightRadius":_114,"WebkitBorderBottomLeftRadius":_114,"WebkitBorderBottomRightRadius":_114});
},_transformEllipse:function(){
var _115=this.width=Math.abs(this.x1-this.x2),_116=this.height=Math.abs(this.y1-this.y2),_117=this.radius=(_115/2+1)+"px "+(_116/2+1)+"px",_118=(_115/2-1)+"px "+(_116/2-1)+"px";
dojo.style(this.shapeNode,{"left":this.x1+"px","top":this.y1+"px","width":_115+"px","height":_116+"px","borderTopLeftRadius":_117,"borderTopRightRadius":_117,"borderBottomLeftRadius":_117,"borderBottomRightRadius":_117,"MozBorderRadiusTopleft":_117,"MozBorderRadiusTopright":_117,"MozBorderRadiusBottomleft":_117,"MozBorderRadiusBottomright":_117,"WebkitBorderTopLeftRadius":_117,"WebkitBorderTopRightRadius":_117,"WebkitBorderBottomLeftRadius":_117,"WebkitBorderBottomRightRadius":_117});
dojo.style(this._innerEllipse,{"left":this.x1+"px","top":this.y1+"px","borderTopLeftRadius":_118,"borderTopRightRadius":_118,"borderBottomLeftRadius":_118,"borderBottomRightRadius":_118,"MozBorderRadiusTopleft":_118,"MozBorderRadiusTopright":_118,"MozBorderRadiusBottomleft":_118,"MozBorderRadiusBottomright":_118,"WebkitBorderTopLeftRadius":_118,"WebkitBorderTopRightRadius":_118,"WebkitBorderBottomLeftRadius":_118,"WebkitBorderBottomRightRadius":_118});
}});
});
},"davinci/review/drawing/Surface":function(){
define(["dojo/_base/declare"],function(_119){
return _119("davinci.review.drawing.Surface",null,{constructor:function(_11a,doc,_11b){
doc=doc||dojo.doc;
this.canvas=_11a;
this.context=_11b;
this.domNode=_11a===doc.body?doc:_11a;
this._tools=[];
this.shapes=[];
},activate:function(){
if(this.highlightTool){
this.highlightTool.deactivate();
}
this.isActivated=true;
},deactivate:function(){
if(this.highlightTool){
this.highlightTool.activate();
}
this.isActivated=false;
},setValueByAttribute:function(_11c,_11d,_11e,_11f){
dojo.forEach(this.shapes,function(_120){
if(_120[_11c]&&_120[_11c]==_11d){
_120[_11e]=_11f;
}
});
},getShapesByAttribute:function(_121,_122){
var _123=[];
dojo.forEach(this.shapes,function(_124){
if(!_121||!_122||_124[_121]&&dojo.some(_122,function(_125){
return _124[_121]==_125;
})){
_123.push(_124);
}
});
return _123;
},style:function(_126){
var _127=this.canvas.tagName;
if(_127&&_127.toLowerCase()=="body"){
dojo.style(this.canvas,_126);
}else{
dojo.style(this.domNode,_126);
}
},appendShape:function(_128){
this.shapes.push(_128);
},removeShape:function(_129){
if(this.selectTool){
this.selectTool.deselectShape();
}
for(var i=0;i<this.shapes.length;i++){
if(this.shapes[i]===_129){
_129.destroy();
if(i==this.shapes.length-1){
this.shapes.pop();
}else{
this.shapes[i]=this.shapes.pop();
}
}
}
},clear:function(){
if(this.selectTool){
this.selectTool.deselectShape();
}
dojo.forEach(this.shapes,function(_12a){
_12a.destroy();
});
this.shapes=[];
},appendChild:function(_12b){
return this.canvas.appendChild(_12b);
},removeChild:function(_12c){
return this.canvas.removeChild(_12c);
},destroy:function(){
if(this.selectTool){
this.selectTool.deactivate();
this.selectTool.destroy();
}
if(this.createTool){
this.createTool.deactivate();
this.createTool.destroy();
}
if(this.exchangeTool){
this.exchangeTool.destroy();
}
if(this.highlightTool){
this.highlightTool.deactivate();
this.highlightTool.destroy();
}
dojo.forEach(this.shapes,function(_12d){
_12d.destroy();
});
}});
});
},"davinci/review/drawing/shapes/shapes":function(){
define(["./Arrow","./Rectangle","./Ellipse","./Text"],function(_12e,_12f,_130,Text){
var _131={};
_131.Arrow=_12e;
_131.Rectangle=_12f;
_131.Ellipse=_130;
_131.Text=Text;
return dojo.setObject("davinci.review.drawing.shapes",_131);
});
},"*now":function(r){
r(["dojo/i18n!*preload*davinci/review/editor/nls/ReviewEditor*[\"ar\",\"ca\",\"cs\",\"da\",\"de\",\"el\",\"en-gb\",\"en-us\",\"es-es\",\"fi-fi\",\"fr-fr\",\"he-il\",\"hu\",\"it-it\",\"ja-jp\",\"ko-kr\",\"nl-nl\",\"nb\",\"pl\",\"pt-br\",\"pt-pt\",\"ru\",\"sk\",\"sl\",\"sv\",\"th\",\"tr\",\"zh-tw\",\"zh-cn\",\"ROOT\"]"]);
}}});
define("davinci/review/editor/ReviewEditor",["dojo/_base/declare","davinci/ui/ModelEditor","dijit/layout/BorderContainer","dijit/layout/ContentPane","./Context","davinci/Runtime","davinci/model/Path","preview/silhouetteiframe","dojo/i18n!./nls/review",],function(_132,_133,_134,_135,_136,_137,Path,_138,_139){
return _132("davinci.review.editor.ReviewEditor",_133,{isReadOnly:true,constructor:function(_13a){
this._bc=new _134({},_13a);
this.domNode=this._bc.domNode;
this._designCP=new _135({region:"center"});
this._bc.addChild(this._designCP);
var _13b="<div class=\"silhouette_div_container\">"+"<span class=\"silhouetteiframe_object_container\"></span>"+"</div>";
this._designCP.set("content",_13b);
var _13c=dojo.query(".silhouette_div_container",this._designCP.domNode)[0];
this.silhouetteiframe=new _138({rootNode:_13c,margin:20});
this._bc.startup();
this._bc.resize();
this.isReadOnly=true;
dojo.subscribe("/davinci/review/resourceChanged",this,function(arg1,arg2,arg3){
if(arg2!="open"&&arg2!="closed"||!this.resourceFile){
return;
}
var _13d=this.resourceFile.parent;
if(_13d.timeStamp==arg3.timeStamp){
davinci.review.model.resource.root.findFile(_13d.timeStamp,this.resourceFile.name).then(function(node){
this.resourceFile=node;
}.bind(this));
}
});
},save:function(){
},supports:function(_13e){
return _13e=="states";
},getContext:function(){
return this.context;
},setContent:function(_13f,_140){
this.fileName=_13f;
this.basePath=new Path(_13f);
var _141=new Path(_137.location());
var _142=this.resourceFile.parent.designerId;
var _143=_141.append("user").append(_142).append("ws").append("workspace").append(_13f.replace(/:/g,"%3A")).toString();
var _144=dojo.query(".silhouette_div_container",this._designCP.domNode)[0];
this.context=new _136({containerNode:_144,baseURL:_143,fileName:this.fileName,resourceFile:this.resourceFile,containerEditor:this,iframeattrs:{"class":"silhouetteiframe_iframe"}});
this.title=dojo.doc.title;
this.context.setSource();
},destroy:function(){
if(this.context){
if(this.context._commentView){
this.context._commentView._setPendingEditComment(this,null);
}
if(this.context.destroy){
this.context.destroy();
}
}
this.inherited(arguments);
},onResize:function(){
},getFileNameToDisplay:function(){
var _145=this.fileName;
var _146=_145.split("/");
if(_146.length>3){
_146.splice(0,3);
_145=_146.join("/");
}
return _145+".rev";
},getOnUnloadWarningMessage:function(){
var _147=null;
if(this.isDirty){
_147=dojo.string.substitute(_139.unsavedComment,[this.editorContainer._getTitle()]);
}
return _147;
}});
});
