define([
	"dojo/_base/declare",
	"dojo/dom-construct",
	"dojo/dom-geometry",
	"dojo/dom-style",
	"dijit/_Contained",
	"dijit/_WidgetBase"
], function(declare, domConstruct, domGeometry, domStyle, Contained, WidgetBase, iconUtils){

	// module:
	//		dojox/mobile/CarouselItem

	return declare("dojox.mobile.CarouselItem", [WidgetBase, Contained], {
		// summary:
		//		An item of dojox/mobile/Carousel.
		// description:
		//		CarouselItem represents an item of dojox/mobile/Carousel. In
		//		typical use cases, users do not use this widget alone. Instead,
		//		it is used in conjunction with the Carousel widget.

		// alt: String
		//		An alt text for the carousel item image.
		alt: "",

		// src: String
		//		A path for an image to be displayed as a carousel item.
		src: "",

		// headerText: String
		//		A text that is displayed above the carousel item image.
		headerText: "",

		// footerText: String
		//		A text that is displayed below the carousel item image.
		footerText: "",

		/* internal properties */	
		
		// baseClass: String
		//		The name of the CSS class of this widget.
		baseClass: "mblCarouselItem",

		buildRendering: function(){
			this.inherited(arguments);
			this.domNode.tabIndex = "0";
			this.headerTextNode = domConstruct.create("div", { className: "mblCarouselItemHeaderText" }, this.domNode);
			this.imageNode = domConstruct.create("img", { className: "mblCarouselItemImage" }, this.domNode);
			this.footerTextNode = domConstruct.create("div", { className: "mblCarouselItemFooterText" }, this.domNode);
		},

		startup: function(){
			if(this._started){ return; }
			this.inherited(arguments);
			this.resize();
		},

		resize: function(size){
			var box = domGeometry.getMarginBox(this.domNode);
			if(box.h === 0){ return; }
			var h1 = domGeometry.getMarginBox(this.headerTextNode).h;
			var h2 = domGeometry.getMarginBox(this.footerTextNode).h;
			domGeometry.setMarginBox(this.imageNode, {h:box.h - h1 - h2});
		},

		select: function(){
			// summary:
			//		Highlights the item.
			var img = this.imageNode
			domStyle.set(img, "opacity", 0.4);
			setTimeout(function(){
				domStyle.set(img, "opacity", 1);
			}, 1000);
		},

		_setAltAttr: function(/*String*/alt){
			// tags:
			//		private
			this._set("alt", alt);
			this.imageNode.alt = alt;
		},

		_setSrcAttr: function(/*String*/src){
			// tags:
			//		private
			this._set("src", src);
			this.imageNode.src = src;
		},

		_setHeaderTextAttr: function(/*String*/text){
			this._set("headerText", text);
			this.headerTextNode.innerHTML = this._cv ? this._cv(text) : text;
		},

		_setFooterTextAttr: function(/*String*/text){
			// tags:
			//		private
			this._set("footerText", text);
			this.footerTextNode.innerHTML = this._cv ? this._cv(text) : text;
		}
	});
});
