/*
    Copyright (c) 2004-2010, The Dojo Foundation All Rights Reserved.
    Available via Academic Free License >= 2.1 OR the modified BSD license.
    see: http://dojotoolkit.org/license for details
*/
package org.dojotoolkit.optimizer;

import java.util.List;
import java.util.Map;

/**
 * Implementations of this interface provide access to analysis data generated by calls to the JSOptimizer
 * implementations.
 */
public interface JSAnalysisData {
	/**
	 * @return String array of the modules used to generate the analysis data
	 */
	String[] getModules();
	/**
	 * @return Ordered String array of the dependencies that the modules have
	 */
	String[] getDependencies();
	/**
	 * @return Checksum value that can be used for version information
	 */
	String getChecksum();
	/**
	 * @return Localization array of localizations that the modules have
	 */
	List<Localization> getLocalizations();
	/**
	 * @return String array of text file dependencies
	 */
	List<String> getTextDependencies();
	/**
	 * @return Map array of object detailing modules missing names 
	 */
	List<Map<String, Object>> getModulesMissingNames();
	/**
	 * @return String Key value that can be used to identify what this analyisData is for 
	 */
	String getKey();
	/**
	 * @return String array of the excluded modules
	 */
	String[] getExcludes();
	/**
	 * @return Map of plugin references include any optimized values
	 */
	Map<String, List<Map<String, String>>> getPluginRefs();
	/**
	 * @return Module Shims
	 */
	Map<String, String> getShims();
}
